// Code generated by software.amazon.smithy.rust.codegen.smithy-rs. DO NOT EDIT.

/// <p>The detailed configurations of a specified resource.</p>
#[non_exhaustive]
#[derive(::std::clone::Clone, ::std::cmp::PartialEq, ::std::fmt::Debug)]
pub struct BaseConfigurationItem {
    /// <p>The version number of the resource configuration.</p>
    pub version: ::std::option::Option<::std::string::String>,
    /// <p>The 12-digit Amazon Web Services account ID associated with the resource.</p>
    pub account_id: ::std::option::Option<::std::string::String>,
    /// <p>The time when the recording of configuration changes was initiated for the resource.</p>
    pub configuration_item_capture_time: ::std::option::Option<::aws_smithy_types::DateTime>,
    /// <p>The configuration item status. Valid values include:</p>
    /// <ul>
    /// <li>
    /// <p>OK – The resource configuration has been updated.</p></li>
    /// <li>
    /// <p>ResourceDiscovered – The resource was newly discovered.</p></li>
    /// <li>
    /// <p>ResourceNotRecorded – The resource was discovered, but its configuration was not recorded since the recorder doesn't record resources of this type.</p></li>
    /// <li>
    /// <p>ResourceDeleted – The resource was deleted</p></li>
    /// <li>
    /// <p>ResourceDeletedNotRecorded – The resource was deleted, but its configuration was not recorded since the recorder doesn't record resources of this type.</p></li>
    /// </ul>
    pub configuration_item_status: ::std::option::Option<crate::types::ConfigurationItemStatus>,
    /// <p>An identifier that indicates the ordering of the configuration items of a resource.</p>
    pub configuration_state_id: ::std::option::Option<::std::string::String>,
    /// <p>The Amazon Resource Name (ARN) of the resource.</p>
    pub arn: ::std::option::Option<::std::string::String>,
    /// <p>The type of Amazon Web Services resource.</p>
    pub resource_type: ::std::option::Option<crate::types::ResourceType>,
    /// <p>The ID of the resource (for example., sg-xxxxxx).</p>
    pub resource_id: ::std::option::Option<::std::string::String>,
    /// <p>The custom name of the resource, if available.</p>
    pub resource_name: ::std::option::Option<::std::string::String>,
    /// <p>The region where the resource resides.</p>
    pub aws_region: ::std::option::Option<::std::string::String>,
    /// <p>The Availability Zone associated with the resource.</p>
    pub availability_zone: ::std::option::Option<::std::string::String>,
    /// <p>The time stamp when the resource was created.</p>
    pub resource_creation_time: ::std::option::Option<::aws_smithy_types::DateTime>,
    /// <p>A JSON-encoded string that contains the contents for the resource configuration. This string needs to be deserialized using <code>json.loads()</code> before you can access the contents.</p>
    pub configuration: ::std::option::Option<::std::string::String>,
    /// <p>A string to string map that contains additional contents for the resource configuration.Config returns this field for certain resource types to supplement the information returned for the <code>configuration</code> field.</p>
    /// <p>This string needs to be deserialized using <code>json.loads()</code> before you can access the contents.</p>
    pub supplementary_configuration: ::std::option::Option<::std::collections::HashMap<::std::string::String, ::std::string::String>>,
    /// <p>The recording frequency that Config uses to record configuration changes for the resource.</p><note>
    /// <p>This field only appears in the API response when <code>DAILY</code> recording is enabled for a resource type. If this field is not present, <code>CONTINUOUS</code> recording is enabled for that resource type. For more information on daily recording and continuous recording, see <a href="https://docs.aws.amazon.com/config/latest/developerguide/select-resources.html#select-resources-recording-frequency">Recording Frequency</a> in the <i>Config Developer Guide</i>.</p>
    /// </note>
    pub recording_frequency: ::std::option::Option<crate::types::RecordingFrequency>,
    /// <p>The time when configuration changes for the resource were delivered.</p><note>
    /// <p>This field is optional and is not guaranteed to be present in a configuration item (CI). If you are using daily recording, this field will be populated. However, if you are using continuous recording, this field will be omitted since the delivery time is instantaneous as the CI is available right away. For more information on daily recording and continuous recording, see <a href="https://docs.aws.amazon.com/config/latest/developerguide/select-resources.html#select-resources-recording-frequency">Recording Frequency</a> in the <i>Config Developer Guide</i>.</p>
    /// </note>
    pub configuration_item_delivery_time: ::std::option::Option<::aws_smithy_types::DateTime>,
}
impl BaseConfigurationItem {
    /// <p>The version number of the resource configuration.</p>
    pub fn version(&self) -> ::std::option::Option<&str> {
        self.version.as_deref()
    }
    /// <p>The 12-digit Amazon Web Services account ID associated with the resource.</p>
    pub fn account_id(&self) -> ::std::option::Option<&str> {
        self.account_id.as_deref()
    }
    /// <p>The time when the recording of configuration changes was initiated for the resource.</p>
    pub fn configuration_item_capture_time(&self) -> ::std::option::Option<&::aws_smithy_types::DateTime> {
        self.configuration_item_capture_time.as_ref()
    }
    /// <p>The configuration item status. Valid values include:</p>
    /// <ul>
    /// <li>
    /// <p>OK – The resource configuration has been updated.</p></li>
    /// <li>
    /// <p>ResourceDiscovered – The resource was newly discovered.</p></li>
    /// <li>
    /// <p>ResourceNotRecorded – The resource was discovered, but its configuration was not recorded since the recorder doesn't record resources of this type.</p></li>
    /// <li>
    /// <p>ResourceDeleted – The resource was deleted</p></li>
    /// <li>
    /// <p>ResourceDeletedNotRecorded – The resource was deleted, but its configuration was not recorded since the recorder doesn't record resources of this type.</p></li>
    /// </ul>
    pub fn configuration_item_status(&self) -> ::std::option::Option<&crate::types::ConfigurationItemStatus> {
        self.configuration_item_status.as_ref()
    }
    /// <p>An identifier that indicates the ordering of the configuration items of a resource.</p>
    pub fn configuration_state_id(&self) -> ::std::option::Option<&str> {
        self.configuration_state_id.as_deref()
    }
    /// <p>The Amazon Resource Name (ARN) of the resource.</p>
    pub fn arn(&self) -> ::std::option::Option<&str> {
        self.arn.as_deref()
    }
    /// <p>The type of Amazon Web Services resource.</p>
    pub fn resource_type(&self) -> ::std::option::Option<&crate::types::ResourceType> {
        self.resource_type.as_ref()
    }
    /// <p>The ID of the resource (for example., sg-xxxxxx).</p>
    pub fn resource_id(&self) -> ::std::option::Option<&str> {
        self.resource_id.as_deref()
    }
    /// <p>The custom name of the resource, if available.</p>
    pub fn resource_name(&self) -> ::std::option::Option<&str> {
        self.resource_name.as_deref()
    }
    /// <p>The region where the resource resides.</p>
    pub fn aws_region(&self) -> ::std::option::Option<&str> {
        self.aws_region.as_deref()
    }
    /// <p>The Availability Zone associated with the resource.</p>
    pub fn availability_zone(&self) -> ::std::option::Option<&str> {
        self.availability_zone.as_deref()
    }
    /// <p>The time stamp when the resource was created.</p>
    pub fn resource_creation_time(&self) -> ::std::option::Option<&::aws_smithy_types::DateTime> {
        self.resource_creation_time.as_ref()
    }
    /// <p>A JSON-encoded string that contains the contents for the resource configuration. This string needs to be deserialized using <code>json.loads()</code> before you can access the contents.</p>
    pub fn configuration(&self) -> ::std::option::Option<&str> {
        self.configuration.as_deref()
    }
    /// <p>A string to string map that contains additional contents for the resource configuration.Config returns this field for certain resource types to supplement the information returned for the <code>configuration</code> field.</p>
    /// <p>This string needs to be deserialized using <code>json.loads()</code> before you can access the contents.</p>
    pub fn supplementary_configuration(&self) -> ::std::option::Option<&::std::collections::HashMap<::std::string::String, ::std::string::String>> {
        self.supplementary_configuration.as_ref()
    }
    /// <p>The recording frequency that Config uses to record configuration changes for the resource.</p><note>
    /// <p>This field only appears in the API response when <code>DAILY</code> recording is enabled for a resource type. If this field is not present, <code>CONTINUOUS</code> recording is enabled for that resource type. For more information on daily recording and continuous recording, see <a href="https://docs.aws.amazon.com/config/latest/developerguide/select-resources.html#select-resources-recording-frequency">Recording Frequency</a> in the <i>Config Developer Guide</i>.</p>
    /// </note>
    pub fn recording_frequency(&self) -> ::std::option::Option<&crate::types::RecordingFrequency> {
        self.recording_frequency.as_ref()
    }
    /// <p>The time when configuration changes for the resource were delivered.</p><note>
    /// <p>This field is optional and is not guaranteed to be present in a configuration item (CI). If you are using daily recording, this field will be populated. However, if you are using continuous recording, this field will be omitted since the delivery time is instantaneous as the CI is available right away. For more information on daily recording and continuous recording, see <a href="https://docs.aws.amazon.com/config/latest/developerguide/select-resources.html#select-resources-recording-frequency">Recording Frequency</a> in the <i>Config Developer Guide</i>.</p>
    /// </note>
    pub fn configuration_item_delivery_time(&self) -> ::std::option::Option<&::aws_smithy_types::DateTime> {
        self.configuration_item_delivery_time.as_ref()
    }
}
impl BaseConfigurationItem {
    /// Creates a new builder-style object to manufacture [`BaseConfigurationItem`](crate::types::BaseConfigurationItem).
    pub fn builder() -> crate::types::builders::BaseConfigurationItemBuilder {
        crate::types::builders::BaseConfigurationItemBuilder::default()
    }
}

/// A builder for [`BaseConfigurationItem`](crate::types::BaseConfigurationItem).
#[derive(::std::clone::Clone, ::std::cmp::PartialEq, ::std::default::Default, ::std::fmt::Debug)]
#[non_exhaustive]
pub struct BaseConfigurationItemBuilder {
    pub(crate) version: ::std::option::Option<::std::string::String>,
    pub(crate) account_id: ::std::option::Option<::std::string::String>,
    pub(crate) configuration_item_capture_time: ::std::option::Option<::aws_smithy_types::DateTime>,
    pub(crate) configuration_item_status: ::std::option::Option<crate::types::ConfigurationItemStatus>,
    pub(crate) configuration_state_id: ::std::option::Option<::std::string::String>,
    pub(crate) arn: ::std::option::Option<::std::string::String>,
    pub(crate) resource_type: ::std::option::Option<crate::types::ResourceType>,
    pub(crate) resource_id: ::std::option::Option<::std::string::String>,
    pub(crate) resource_name: ::std::option::Option<::std::string::String>,
    pub(crate) aws_region: ::std::option::Option<::std::string::String>,
    pub(crate) availability_zone: ::std::option::Option<::std::string::String>,
    pub(crate) resource_creation_time: ::std::option::Option<::aws_smithy_types::DateTime>,
    pub(crate) configuration: ::std::option::Option<::std::string::String>,
    pub(crate) supplementary_configuration: ::std::option::Option<::std::collections::HashMap<::std::string::String, ::std::string::String>>,
    pub(crate) recording_frequency: ::std::option::Option<crate::types::RecordingFrequency>,
    pub(crate) configuration_item_delivery_time: ::std::option::Option<::aws_smithy_types::DateTime>,
}
impl BaseConfigurationItemBuilder {
    /// <p>The version number of the resource configuration.</p>
    pub fn version(mut self, input: impl ::std::convert::Into<::std::string::String>) -> Self {
        self.version = ::std::option::Option::Some(input.into());
        self
    }
    /// <p>The version number of the resource configuration.</p>
    pub fn set_version(mut self, input: ::std::option::Option<::std::string::String>) -> Self {
        self.version = input;
        self
    }
    /// <p>The version number of the resource configuration.</p>
    pub fn get_version(&self) -> &::std::option::Option<::std::string::String> {
        &self.version
    }
    /// <p>The 12-digit Amazon Web Services account ID associated with the resource.</p>
    pub fn account_id(mut self, input: impl ::std::convert::Into<::std::string::String>) -> Self {
        self.account_id = ::std::option::Option::Some(input.into());
        self
    }
    /// <p>The 12-digit Amazon Web Services account ID associated with the resource.</p>
    pub fn set_account_id(mut self, input: ::std::option::Option<::std::string::String>) -> Self {
        self.account_id = input;
        self
    }
    /// <p>The 12-digit Amazon Web Services account ID associated with the resource.</p>
    pub fn get_account_id(&self) -> &::std::option::Option<::std::string::String> {
        &self.account_id
    }
    /// <p>The time when the recording of configuration changes was initiated for the resource.</p>
    pub fn configuration_item_capture_time(mut self, input: ::aws_smithy_types::DateTime) -> Self {
        self.configuration_item_capture_time = ::std::option::Option::Some(input);
        self
    }
    /// <p>The time when the recording of configuration changes was initiated for the resource.</p>
    pub fn set_configuration_item_capture_time(mut self, input: ::std::option::Option<::aws_smithy_types::DateTime>) -> Self {
        self.configuration_item_capture_time = input;
        self
    }
    /// <p>The time when the recording of configuration changes was initiated for the resource.</p>
    pub fn get_configuration_item_capture_time(&self) -> &::std::option::Option<::aws_smithy_types::DateTime> {
        &self.configuration_item_capture_time
    }
    /// <p>The configuration item status. Valid values include:</p>
    /// <ul>
    /// <li>
    /// <p>OK – The resource configuration has been updated.</p></li>
    /// <li>
    /// <p>ResourceDiscovered – The resource was newly discovered.</p></li>
    /// <li>
    /// <p>ResourceNotRecorded – The resource was discovered, but its configuration was not recorded since the recorder doesn't record resources of this type.</p></li>
    /// <li>
    /// <p>ResourceDeleted – The resource was deleted</p></li>
    /// <li>
    /// <p>ResourceDeletedNotRecorded – The resource was deleted, but its configuration was not recorded since the recorder doesn't record resources of this type.</p></li>
    /// </ul>
    pub fn configuration_item_status(mut self, input: crate::types::ConfigurationItemStatus) -> Self {
        self.configuration_item_status = ::std::option::Option::Some(input);
        self
    }
    /// <p>The configuration item status. Valid values include:</p>
    /// <ul>
    /// <li>
    /// <p>OK – The resource configuration has been updated.</p></li>
    /// <li>
    /// <p>ResourceDiscovered – The resource was newly discovered.</p></li>
    /// <li>
    /// <p>ResourceNotRecorded – The resource was discovered, but its configuration was not recorded since the recorder doesn't record resources of this type.</p></li>
    /// <li>
    /// <p>ResourceDeleted – The resource was deleted</p></li>
    /// <li>
    /// <p>ResourceDeletedNotRecorded – The resource was deleted, but its configuration was not recorded since the recorder doesn't record resources of this type.</p></li>
    /// </ul>
    pub fn set_configuration_item_status(mut self, input: ::std::option::Option<crate::types::ConfigurationItemStatus>) -> Self {
        self.configuration_item_status = input;
        self
    }
    /// <p>The configuration item status. Valid values include:</p>
    /// <ul>
    /// <li>
    /// <p>OK – The resource configuration has been updated.</p></li>
    /// <li>
    /// <p>ResourceDiscovered – The resource was newly discovered.</p></li>
    /// <li>
    /// <p>ResourceNotRecorded – The resource was discovered, but its configuration was not recorded since the recorder doesn't record resources of this type.</p></li>
    /// <li>
    /// <p>ResourceDeleted – The resource was deleted</p></li>
    /// <li>
    /// <p>ResourceDeletedNotRecorded – The resource was deleted, but its configuration was not recorded since the recorder doesn't record resources of this type.</p></li>
    /// </ul>
    pub fn get_configuration_item_status(&self) -> &::std::option::Option<crate::types::ConfigurationItemStatus> {
        &self.configuration_item_status
    }
    /// <p>An identifier that indicates the ordering of the configuration items of a resource.</p>
    pub fn configuration_state_id(mut self, input: impl ::std::convert::Into<::std::string::String>) -> Self {
        self.configuration_state_id = ::std::option::Option::Some(input.into());
        self
    }
    /// <p>An identifier that indicates the ordering of the configuration items of a resource.</p>
    pub fn set_configuration_state_id(mut self, input: ::std::option::Option<::std::string::String>) -> Self {
        self.configuration_state_id = input;
        self
    }
    /// <p>An identifier that indicates the ordering of the configuration items of a resource.</p>
    pub fn get_configuration_state_id(&self) -> &::std::option::Option<::std::string::String> {
        &self.configuration_state_id
    }
    /// <p>The Amazon Resource Name (ARN) of the resource.</p>
    pub fn arn(mut self, input: impl ::std::convert::Into<::std::string::String>) -> Self {
        self.arn = ::std::option::Option::Some(input.into());
        self
    }
    /// <p>The Amazon Resource Name (ARN) of the resource.</p>
    pub fn set_arn(mut self, input: ::std::option::Option<::std::string::String>) -> Self {
        self.arn = input;
        self
    }
    /// <p>The Amazon Resource Name (ARN) of the resource.</p>
    pub fn get_arn(&self) -> &::std::option::Option<::std::string::String> {
        &self.arn
    }
    /// <p>The type of Amazon Web Services resource.</p>
    pub fn resource_type(mut self, input: crate::types::ResourceType) -> Self {
        self.resource_type = ::std::option::Option::Some(input);
        self
    }
    /// <p>The type of Amazon Web Services resource.</p>
    pub fn set_resource_type(mut self, input: ::std::option::Option<crate::types::ResourceType>) -> Self {
        self.resource_type = input;
        self
    }
    /// <p>The type of Amazon Web Services resource.</p>
    pub fn get_resource_type(&self) -> &::std::option::Option<crate::types::ResourceType> {
        &self.resource_type
    }
    /// <p>The ID of the resource (for example., sg-xxxxxx).</p>
    pub fn resource_id(mut self, input: impl ::std::convert::Into<::std::string::String>) -> Self {
        self.resource_id = ::std::option::Option::Some(input.into());
        self
    }
    /// <p>The ID of the resource (for example., sg-xxxxxx).</p>
    pub fn set_resource_id(mut self, input: ::std::option::Option<::std::string::String>) -> Self {
        self.resource_id = input;
        self
    }
    /// <p>The ID of the resource (for example., sg-xxxxxx).</p>
    pub fn get_resource_id(&self) -> &::std::option::Option<::std::string::String> {
        &self.resource_id
    }
    /// <p>The custom name of the resource, if available.</p>
    pub fn resource_name(mut self, input: impl ::std::convert::Into<::std::string::String>) -> Self {
        self.resource_name = ::std::option::Option::Some(input.into());
        self
    }
    /// <p>The custom name of the resource, if available.</p>
    pub fn set_resource_name(mut self, input: ::std::option::Option<::std::string::String>) -> Self {
        self.resource_name = input;
        self
    }
    /// <p>The custom name of the resource, if available.</p>
    pub fn get_resource_name(&self) -> &::std::option::Option<::std::string::String> {
        &self.resource_name
    }
    /// <p>The region where the resource resides.</p>
    pub fn aws_region(mut self, input: impl ::std::convert::Into<::std::string::String>) -> Self {
        self.aws_region = ::std::option::Option::Some(input.into());
        self
    }
    /// <p>The region where the resource resides.</p>
    pub fn set_aws_region(mut self, input: ::std::option::Option<::std::string::String>) -> Self {
        self.aws_region = input;
        self
    }
    /// <p>The region where the resource resides.</p>
    pub fn get_aws_region(&self) -> &::std::option::Option<::std::string::String> {
        &self.aws_region
    }
    /// <p>The Availability Zone associated with the resource.</p>
    pub fn availability_zone(mut self, input: impl ::std::convert::Into<::std::string::String>) -> Self {
        self.availability_zone = ::std::option::Option::Some(input.into());
        self
    }
    /// <p>The Availability Zone associated with the resource.</p>
    pub fn set_availability_zone(mut self, input: ::std::option::Option<::std::string::String>) -> Self {
        self.availability_zone = input;
        self
    }
    /// <p>The Availability Zone associated with the resource.</p>
    pub fn get_availability_zone(&self) -> &::std::option::Option<::std::string::String> {
        &self.availability_zone
    }
    /// <p>The time stamp when the resource was created.</p>
    pub fn resource_creation_time(mut self, input: ::aws_smithy_types::DateTime) -> Self {
        self.resource_creation_time = ::std::option::Option::Some(input);
        self
    }
    /// <p>The time stamp when the resource was created.</p>
    pub fn set_resource_creation_time(mut self, input: ::std::option::Option<::aws_smithy_types::DateTime>) -> Self {
        self.resource_creation_time = input;
        self
    }
    /// <p>The time stamp when the resource was created.</p>
    pub fn get_resource_creation_time(&self) -> &::std::option::Option<::aws_smithy_types::DateTime> {
        &self.resource_creation_time
    }
    /// <p>A JSON-encoded string that contains the contents for the resource configuration. This string needs to be deserialized using <code>json.loads()</code> before you can access the contents.</p>
    pub fn configuration(mut self, input: impl ::std::convert::Into<::std::string::String>) -> Self {
        self.configuration = ::std::option::Option::Some(input.into());
        self
    }
    /// <p>A JSON-encoded string that contains the contents for the resource configuration. This string needs to be deserialized using <code>json.loads()</code> before you can access the contents.</p>
    pub fn set_configuration(mut self, input: ::std::option::Option<::std::string::String>) -> Self {
        self.configuration = input;
        self
    }
    /// <p>A JSON-encoded string that contains the contents for the resource configuration. This string needs to be deserialized using <code>json.loads()</code> before you can access the contents.</p>
    pub fn get_configuration(&self) -> &::std::option::Option<::std::string::String> {
        &self.configuration
    }
    /// Adds a key-value pair to `supplementary_configuration`.
    ///
    /// To override the contents of this collection use [`set_supplementary_configuration`](Self::set_supplementary_configuration).
    ///
    /// <p>A string to string map that contains additional contents for the resource configuration.Config returns this field for certain resource types to supplement the information returned for the <code>configuration</code> field.</p>
    /// <p>This string needs to be deserialized using <code>json.loads()</code> before you can access the contents.</p>
    pub fn supplementary_configuration(
        mut self,
        k: impl ::std::convert::Into<::std::string::String>,
        v: impl ::std::convert::Into<::std::string::String>,
    ) -> Self {
        let mut hash_map = self.supplementary_configuration.unwrap_or_default();
        hash_map.insert(k.into(), v.into());
        self.supplementary_configuration = ::std::option::Option::Some(hash_map);
        self
    }
    /// <p>A string to string map that contains additional contents for the resource configuration.Config returns this field for certain resource types to supplement the information returned for the <code>configuration</code> field.</p>
    /// <p>This string needs to be deserialized using <code>json.loads()</code> before you can access the contents.</p>
    pub fn set_supplementary_configuration(
        mut self,
        input: ::std::option::Option<::std::collections::HashMap<::std::string::String, ::std::string::String>>,
    ) -> Self {
        self.supplementary_configuration = input;
        self
    }
    /// <p>A string to string map that contains additional contents for the resource configuration.Config returns this field for certain resource types to supplement the information returned for the <code>configuration</code> field.</p>
    /// <p>This string needs to be deserialized using <code>json.loads()</code> before you can access the contents.</p>
    pub fn get_supplementary_configuration(
        &self,
    ) -> &::std::option::Option<::std::collections::HashMap<::std::string::String, ::std::string::String>> {
        &self.supplementary_configuration
    }
    /// <p>The recording frequency that Config uses to record configuration changes for the resource.</p><note>
    /// <p>This field only appears in the API response when <code>DAILY</code> recording is enabled for a resource type. If this field is not present, <code>CONTINUOUS</code> recording is enabled for that resource type. For more information on daily recording and continuous recording, see <a href="https://docs.aws.amazon.com/config/latest/developerguide/select-resources.html#select-resources-recording-frequency">Recording Frequency</a> in the <i>Config Developer Guide</i>.</p>
    /// </note>
    pub fn recording_frequency(mut self, input: crate::types::RecordingFrequency) -> Self {
        self.recording_frequency = ::std::option::Option::Some(input);
        self
    }
    /// <p>The recording frequency that Config uses to record configuration changes for the resource.</p><note>
    /// <p>This field only appears in the API response when <code>DAILY</code> recording is enabled for a resource type. If this field is not present, <code>CONTINUOUS</code> recording is enabled for that resource type. For more information on daily recording and continuous recording, see <a href="https://docs.aws.amazon.com/config/latest/developerguide/select-resources.html#select-resources-recording-frequency">Recording Frequency</a> in the <i>Config Developer Guide</i>.</p>
    /// </note>
    pub fn set_recording_frequency(mut self, input: ::std::option::Option<crate::types::RecordingFrequency>) -> Self {
        self.recording_frequency = input;
        self
    }
    /// <p>The recording frequency that Config uses to record configuration changes for the resource.</p><note>
    /// <p>This field only appears in the API response when <code>DAILY</code> recording is enabled for a resource type. If this field is not present, <code>CONTINUOUS</code> recording is enabled for that resource type. For more information on daily recording and continuous recording, see <a href="https://docs.aws.amazon.com/config/latest/developerguide/select-resources.html#select-resources-recording-frequency">Recording Frequency</a> in the <i>Config Developer Guide</i>.</p>
    /// </note>
    pub fn get_recording_frequency(&self) -> &::std::option::Option<crate::types::RecordingFrequency> {
        &self.recording_frequency
    }
    /// <p>The time when configuration changes for the resource were delivered.</p><note>
    /// <p>This field is optional and is not guaranteed to be present in a configuration item (CI). If you are using daily recording, this field will be populated. However, if you are using continuous recording, this field will be omitted since the delivery time is instantaneous as the CI is available right away. For more information on daily recording and continuous recording, see <a href="https://docs.aws.amazon.com/config/latest/developerguide/select-resources.html#select-resources-recording-frequency">Recording Frequency</a> in the <i>Config Developer Guide</i>.</p>
    /// </note>
    pub fn configuration_item_delivery_time(mut self, input: ::aws_smithy_types::DateTime) -> Self {
        self.configuration_item_delivery_time = ::std::option::Option::Some(input);
        self
    }
    /// <p>The time when configuration changes for the resource were delivered.</p><note>
    /// <p>This field is optional and is not guaranteed to be present in a configuration item (CI). If you are using daily recording, this field will be populated. However, if you are using continuous recording, this field will be omitted since the delivery time is instantaneous as the CI is available right away. For more information on daily recording and continuous recording, see <a href="https://docs.aws.amazon.com/config/latest/developerguide/select-resources.html#select-resources-recording-frequency">Recording Frequency</a> in the <i>Config Developer Guide</i>.</p>
    /// </note>
    pub fn set_configuration_item_delivery_time(mut self, input: ::std::option::Option<::aws_smithy_types::DateTime>) -> Self {
        self.configuration_item_delivery_time = input;
        self
    }
    /// <p>The time when configuration changes for the resource were delivered.</p><note>
    /// <p>This field is optional and is not guaranteed to be present in a configuration item (CI). If you are using daily recording, this field will be populated. However, if you are using continuous recording, this field will be omitted since the delivery time is instantaneous as the CI is available right away. For more information on daily recording and continuous recording, see <a href="https://docs.aws.amazon.com/config/latest/developerguide/select-resources.html#select-resources-recording-frequency">Recording Frequency</a> in the <i>Config Developer Guide</i>.</p>
    /// </note>
    pub fn get_configuration_item_delivery_time(&self) -> &::std::option::Option<::aws_smithy_types::DateTime> {
        &self.configuration_item_delivery_time
    }
    /// Consumes the builder and constructs a [`BaseConfigurationItem`](crate::types::BaseConfigurationItem).
    pub fn build(self) -> crate::types::BaseConfigurationItem {
        crate::types::BaseConfigurationItem {
            version: self.version,
            account_id: self.account_id,
            configuration_item_capture_time: self.configuration_item_capture_time,
            configuration_item_status: self.configuration_item_status,
            configuration_state_id: self.configuration_state_id,
            arn: self.arn,
            resource_type: self.resource_type,
            resource_id: self.resource_id,
            resource_name: self.resource_name,
            aws_region: self.aws_region,
            availability_zone: self.availability_zone,
            resource_creation_time: self.resource_creation_time,
            configuration: self.configuration,
            supplementary_configuration: self.supplementary_configuration,
            recording_frequency: self.recording_frequency,
            configuration_item_delivery_time: self.configuration_item_delivery_time,
        }
    }
}
