// Code generated by software.amazon.smithy.rust.codegen.smithy-rs. DO NOT EDIT.

/// <p>Filters the compliance results based on account ID, region, compliance type, and rule name.</p>
#[non_exhaustive]
#[derive(::std::clone::Clone, ::std::cmp::PartialEq, ::std::fmt::Debug)]
pub struct ConfigRuleComplianceFilters {
    /// <p>The name of the Config rule.</p>
    pub config_rule_name: ::std::option::Option<::std::string::String>,
    /// <p>The rule compliance status.</p>
    /// <p>For the <code>ConfigRuleComplianceFilters</code> data type, Config supports only <code>COMPLIANT</code> and <code>NON_COMPLIANT</code>. Config does not support the <code>NOT_APPLICABLE</code> and the <code>INSUFFICIENT_DATA</code> values.</p>
    pub compliance_type: ::std::option::Option<crate::types::ComplianceType>,
    /// <p>The 12-digit account ID of the source account.</p>
    pub account_id: ::std::option::Option<::std::string::String>,
    /// <p>The source region where the data is aggregated.</p>
    pub aws_region: ::std::option::Option<::std::string::String>,
}
impl ConfigRuleComplianceFilters {
    /// <p>The name of the Config rule.</p>
    pub fn config_rule_name(&self) -> ::std::option::Option<&str> {
        self.config_rule_name.as_deref()
    }
    /// <p>The rule compliance status.</p>
    /// <p>For the <code>ConfigRuleComplianceFilters</code> data type, Config supports only <code>COMPLIANT</code> and <code>NON_COMPLIANT</code>. Config does not support the <code>NOT_APPLICABLE</code> and the <code>INSUFFICIENT_DATA</code> values.</p>
    pub fn compliance_type(&self) -> ::std::option::Option<&crate::types::ComplianceType> {
        self.compliance_type.as_ref()
    }
    /// <p>The 12-digit account ID of the source account.</p>
    pub fn account_id(&self) -> ::std::option::Option<&str> {
        self.account_id.as_deref()
    }
    /// <p>The source region where the data is aggregated.</p>
    pub fn aws_region(&self) -> ::std::option::Option<&str> {
        self.aws_region.as_deref()
    }
}
impl ConfigRuleComplianceFilters {
    /// Creates a new builder-style object to manufacture [`ConfigRuleComplianceFilters`](crate::types::ConfigRuleComplianceFilters).
    pub fn builder() -> crate::types::builders::ConfigRuleComplianceFiltersBuilder {
        crate::types::builders::ConfigRuleComplianceFiltersBuilder::default()
    }
}

/// A builder for [`ConfigRuleComplianceFilters`](crate::types::ConfigRuleComplianceFilters).
#[derive(::std::clone::Clone, ::std::cmp::PartialEq, ::std::default::Default, ::std::fmt::Debug)]
#[non_exhaustive]
pub struct ConfigRuleComplianceFiltersBuilder {
    pub(crate) config_rule_name: ::std::option::Option<::std::string::String>,
    pub(crate) compliance_type: ::std::option::Option<crate::types::ComplianceType>,
    pub(crate) account_id: ::std::option::Option<::std::string::String>,
    pub(crate) aws_region: ::std::option::Option<::std::string::String>,
}
impl ConfigRuleComplianceFiltersBuilder {
    /// <p>The name of the Config rule.</p>
    pub fn config_rule_name(mut self, input: impl ::std::convert::Into<::std::string::String>) -> Self {
        self.config_rule_name = ::std::option::Option::Some(input.into());
        self
    }
    /// <p>The name of the Config rule.</p>
    pub fn set_config_rule_name(mut self, input: ::std::option::Option<::std::string::String>) -> Self {
        self.config_rule_name = input;
        self
    }
    /// <p>The name of the Config rule.</p>
    pub fn get_config_rule_name(&self) -> &::std::option::Option<::std::string::String> {
        &self.config_rule_name
    }
    /// <p>The rule compliance status.</p>
    /// <p>For the <code>ConfigRuleComplianceFilters</code> data type, Config supports only <code>COMPLIANT</code> and <code>NON_COMPLIANT</code>. Config does not support the <code>NOT_APPLICABLE</code> and the <code>INSUFFICIENT_DATA</code> values.</p>
    pub fn compliance_type(mut self, input: crate::types::ComplianceType) -> Self {
        self.compliance_type = ::std::option::Option::Some(input);
        self
    }
    /// <p>The rule compliance status.</p>
    /// <p>For the <code>ConfigRuleComplianceFilters</code> data type, Config supports only <code>COMPLIANT</code> and <code>NON_COMPLIANT</code>. Config does not support the <code>NOT_APPLICABLE</code> and the <code>INSUFFICIENT_DATA</code> values.</p>
    pub fn set_compliance_type(mut self, input: ::std::option::Option<crate::types::ComplianceType>) -> Self {
        self.compliance_type = input;
        self
    }
    /// <p>The rule compliance status.</p>
    /// <p>For the <code>ConfigRuleComplianceFilters</code> data type, Config supports only <code>COMPLIANT</code> and <code>NON_COMPLIANT</code>. Config does not support the <code>NOT_APPLICABLE</code> and the <code>INSUFFICIENT_DATA</code> values.</p>
    pub fn get_compliance_type(&self) -> &::std::option::Option<crate::types::ComplianceType> {
        &self.compliance_type
    }
    /// <p>The 12-digit account ID of the source account.</p>
    pub fn account_id(mut self, input: impl ::std::convert::Into<::std::string::String>) -> Self {
        self.account_id = ::std::option::Option::Some(input.into());
        self
    }
    /// <p>The 12-digit account ID of the source account.</p>
    pub fn set_account_id(mut self, input: ::std::option::Option<::std::string::String>) -> Self {
        self.account_id = input;
        self
    }
    /// <p>The 12-digit account ID of the source account.</p>
    pub fn get_account_id(&self) -> &::std::option::Option<::std::string::String> {
        &self.account_id
    }
    /// <p>The source region where the data is aggregated.</p>
    pub fn aws_region(mut self, input: impl ::std::convert::Into<::std::string::String>) -> Self {
        self.aws_region = ::std::option::Option::Some(input.into());
        self
    }
    /// <p>The source region where the data is aggregated.</p>
    pub fn set_aws_region(mut self, input: ::std::option::Option<::std::string::String>) -> Self {
        self.aws_region = input;
        self
    }
    /// <p>The source region where the data is aggregated.</p>
    pub fn get_aws_region(&self) -> &::std::option::Option<::std::string::String> {
        &self.aws_region
    }
    /// Consumes the builder and constructs a [`ConfigRuleComplianceFilters`](crate::types::ConfigRuleComplianceFilters).
    pub fn build(self) -> crate::types::ConfigRuleComplianceFilters {
        crate::types::ConfigRuleComplianceFilters {
            config_rule_name: self.config_rule_name,
            compliance_type: self.compliance_type,
            account_id: self.account_id,
            aws_region: self.aws_region,
        }
    }
}
