// Code generated by software.amazon.smithy.rust.codegen.smithy-rs. DO NOT EDIT.

/// <p>Filters configuration recorders by recording scope.</p>
#[non_exhaustive]
#[derive(::std::clone::Clone, ::std::cmp::PartialEq, ::std::fmt::Debug)]
pub struct ConfigurationRecorderFilter {
    /// <p>The name of the type of filter. Currently, only <code>recordingScope</code> is supported.</p>
    pub filter_name: ::std::option::Option<crate::types::ConfigurationRecorderFilterName>,
    /// <p>The value of the filter. For <code>recordingScope</code>, valid values include: <code>INTERNAL</code> and <code>PAID</code>.</p>
    /// <p><code>INTERNAL</code> indicates that the <a href="https://docs.aws.amazon.com/config/latest/APIReference/API_ConfigurationItem.html">ConfigurationItems</a> in scope for the configuration recorder are recorded for free.</p>
    /// <p><code>PAID</code> indicates that the <a href="https://docs.aws.amazon.com/config/latest/APIReference/API_ConfigurationItem.html">ConfigurationItems</a> in scope for the configuration recorder impact the costs to your bill.</p>
    pub filter_value: ::std::option::Option<::std::vec::Vec<::std::string::String>>,
}
impl ConfigurationRecorderFilter {
    /// <p>The name of the type of filter. Currently, only <code>recordingScope</code> is supported.</p>
    pub fn filter_name(&self) -> ::std::option::Option<&crate::types::ConfigurationRecorderFilterName> {
        self.filter_name.as_ref()
    }
    /// <p>The value of the filter. For <code>recordingScope</code>, valid values include: <code>INTERNAL</code> and <code>PAID</code>.</p>
    /// <p><code>INTERNAL</code> indicates that the <a href="https://docs.aws.amazon.com/config/latest/APIReference/API_ConfigurationItem.html">ConfigurationItems</a> in scope for the configuration recorder are recorded for free.</p>
    /// <p><code>PAID</code> indicates that the <a href="https://docs.aws.amazon.com/config/latest/APIReference/API_ConfigurationItem.html">ConfigurationItems</a> in scope for the configuration recorder impact the costs to your bill.</p>
    ///
    /// If no value was sent for this field, a default will be set. If you want to determine if no value was sent, use `.filter_value.is_none()`.
    pub fn filter_value(&self) -> &[::std::string::String] {
        self.filter_value.as_deref().unwrap_or_default()
    }
}
impl ConfigurationRecorderFilter {
    /// Creates a new builder-style object to manufacture [`ConfigurationRecorderFilter`](crate::types::ConfigurationRecorderFilter).
    pub fn builder() -> crate::types::builders::ConfigurationRecorderFilterBuilder {
        crate::types::builders::ConfigurationRecorderFilterBuilder::default()
    }
}

/// A builder for [`ConfigurationRecorderFilter`](crate::types::ConfigurationRecorderFilter).
#[derive(::std::clone::Clone, ::std::cmp::PartialEq, ::std::default::Default, ::std::fmt::Debug)]
#[non_exhaustive]
pub struct ConfigurationRecorderFilterBuilder {
    pub(crate) filter_name: ::std::option::Option<crate::types::ConfigurationRecorderFilterName>,
    pub(crate) filter_value: ::std::option::Option<::std::vec::Vec<::std::string::String>>,
}
impl ConfigurationRecorderFilterBuilder {
    /// <p>The name of the type of filter. Currently, only <code>recordingScope</code> is supported.</p>
    pub fn filter_name(mut self, input: crate::types::ConfigurationRecorderFilterName) -> Self {
        self.filter_name = ::std::option::Option::Some(input);
        self
    }
    /// <p>The name of the type of filter. Currently, only <code>recordingScope</code> is supported.</p>
    pub fn set_filter_name(mut self, input: ::std::option::Option<crate::types::ConfigurationRecorderFilterName>) -> Self {
        self.filter_name = input;
        self
    }
    /// <p>The name of the type of filter. Currently, only <code>recordingScope</code> is supported.</p>
    pub fn get_filter_name(&self) -> &::std::option::Option<crate::types::ConfigurationRecorderFilterName> {
        &self.filter_name
    }
    /// Appends an item to `filter_value`.
    ///
    /// To override the contents of this collection use [`set_filter_value`](Self::set_filter_value).
    ///
    /// <p>The value of the filter. For <code>recordingScope</code>, valid values include: <code>INTERNAL</code> and <code>PAID</code>.</p>
    /// <p><code>INTERNAL</code> indicates that the <a href="https://docs.aws.amazon.com/config/latest/APIReference/API_ConfigurationItem.html">ConfigurationItems</a> in scope for the configuration recorder are recorded for free.</p>
    /// <p><code>PAID</code> indicates that the <a href="https://docs.aws.amazon.com/config/latest/APIReference/API_ConfigurationItem.html">ConfigurationItems</a> in scope for the configuration recorder impact the costs to your bill.</p>
    pub fn filter_value(mut self, input: impl ::std::convert::Into<::std::string::String>) -> Self {
        let mut v = self.filter_value.unwrap_or_default();
        v.push(input.into());
        self.filter_value = ::std::option::Option::Some(v);
        self
    }
    /// <p>The value of the filter. For <code>recordingScope</code>, valid values include: <code>INTERNAL</code> and <code>PAID</code>.</p>
    /// <p><code>INTERNAL</code> indicates that the <a href="https://docs.aws.amazon.com/config/latest/APIReference/API_ConfigurationItem.html">ConfigurationItems</a> in scope for the configuration recorder are recorded for free.</p>
    /// <p><code>PAID</code> indicates that the <a href="https://docs.aws.amazon.com/config/latest/APIReference/API_ConfigurationItem.html">ConfigurationItems</a> in scope for the configuration recorder impact the costs to your bill.</p>
    pub fn set_filter_value(mut self, input: ::std::option::Option<::std::vec::Vec<::std::string::String>>) -> Self {
        self.filter_value = input;
        self
    }
    /// <p>The value of the filter. For <code>recordingScope</code>, valid values include: <code>INTERNAL</code> and <code>PAID</code>.</p>
    /// <p><code>INTERNAL</code> indicates that the <a href="https://docs.aws.amazon.com/config/latest/APIReference/API_ConfigurationItem.html">ConfigurationItems</a> in scope for the configuration recorder are recorded for free.</p>
    /// <p><code>PAID</code> indicates that the <a href="https://docs.aws.amazon.com/config/latest/APIReference/API_ConfigurationItem.html">ConfigurationItems</a> in scope for the configuration recorder impact the costs to your bill.</p>
    pub fn get_filter_value(&self) -> &::std::option::Option<::std::vec::Vec<::std::string::String>> {
        &self.filter_value
    }
    /// Consumes the builder and constructs a [`ConfigurationRecorderFilter`](crate::types::ConfigurationRecorderFilter).
    pub fn build(self) -> crate::types::ConfigurationRecorderFilter {
        crate::types::ConfigurationRecorderFilter {
            filter_name: self.filter_name,
            filter_value: self.filter_value,
        }
    }
}
