// Code generated by software.amazon.smithy.rust.codegen.smithy-rs. DO NOT EDIT.

/// <p>The channel through which Config delivers notifications and updated configuration states.</p>
#[non_exhaustive]
#[derive(::std::clone::Clone, ::std::cmp::PartialEq, ::std::fmt::Debug)]
pub struct DeliveryChannel {
    /// <p>The name of the delivery channel. By default, Config assigns the name "default" when creating the delivery channel. To change the delivery channel name, you must use the DeleteDeliveryChannel action to delete your current delivery channel, and then you must use the PutDeliveryChannel command to create a delivery channel that has the desired name.</p>
    pub name: ::std::option::Option<::std::string::String>,
    /// <p>The name of the Amazon S3 bucket to which Config delivers configuration snapshots and configuration history files.</p>
    /// <p>If you specify a bucket that belongs to another Amazon Web Services account, that bucket must have policies that grant access permissions to Config. For more information, see <a href="https://docs.aws.amazon.com/config/latest/developerguide/s3-bucket-policy.html">Permissions for the Amazon S3 Bucket</a> in the <i>Config Developer Guide</i>.</p>
    pub s3_bucket_name: ::std::option::Option<::std::string::String>,
    /// <p>The prefix for the specified Amazon S3 bucket.</p>
    pub s3_key_prefix: ::std::option::Option<::std::string::String>,
    /// <p>The Amazon Resource Name (ARN) of the Key Management Service (KMS ) KMS key (KMS key) used to encrypt objects delivered by Config. Must belong to the same Region as the destination S3 bucket.</p>
    pub s3_kms_key_arn: ::std::option::Option<::std::string::String>,
    /// <p>The Amazon Resource Name (ARN) of the Amazon SNS topic to which Config sends notifications about configuration changes.</p>
    /// <p>If you choose a topic from another account, the topic must have policies that grant access permissions to Config. For more information, see <a href="https://docs.aws.amazon.com/config/latest/developerguide/sns-topic-policy.html">Permissions for the Amazon SNS Topic</a> in the <i>Config Developer Guide</i>.</p>
    pub sns_topic_arn: ::std::option::Option<::std::string::String>,
    /// <p>The options for how often Config delivers configuration snapshots to the Amazon S3 bucket.</p>
    pub config_snapshot_delivery_properties: ::std::option::Option<crate::types::ConfigSnapshotDeliveryProperties>,
}
impl DeliveryChannel {
    /// <p>The name of the delivery channel. By default, Config assigns the name "default" when creating the delivery channel. To change the delivery channel name, you must use the DeleteDeliveryChannel action to delete your current delivery channel, and then you must use the PutDeliveryChannel command to create a delivery channel that has the desired name.</p>
    pub fn name(&self) -> ::std::option::Option<&str> {
        self.name.as_deref()
    }
    /// <p>The name of the Amazon S3 bucket to which Config delivers configuration snapshots and configuration history files.</p>
    /// <p>If you specify a bucket that belongs to another Amazon Web Services account, that bucket must have policies that grant access permissions to Config. For more information, see <a href="https://docs.aws.amazon.com/config/latest/developerguide/s3-bucket-policy.html">Permissions for the Amazon S3 Bucket</a> in the <i>Config Developer Guide</i>.</p>
    pub fn s3_bucket_name(&self) -> ::std::option::Option<&str> {
        self.s3_bucket_name.as_deref()
    }
    /// <p>The prefix for the specified Amazon S3 bucket.</p>
    pub fn s3_key_prefix(&self) -> ::std::option::Option<&str> {
        self.s3_key_prefix.as_deref()
    }
    /// <p>The Amazon Resource Name (ARN) of the Key Management Service (KMS ) KMS key (KMS key) used to encrypt objects delivered by Config. Must belong to the same Region as the destination S3 bucket.</p>
    pub fn s3_kms_key_arn(&self) -> ::std::option::Option<&str> {
        self.s3_kms_key_arn.as_deref()
    }
    /// <p>The Amazon Resource Name (ARN) of the Amazon SNS topic to which Config sends notifications about configuration changes.</p>
    /// <p>If you choose a topic from another account, the topic must have policies that grant access permissions to Config. For more information, see <a href="https://docs.aws.amazon.com/config/latest/developerguide/sns-topic-policy.html">Permissions for the Amazon SNS Topic</a> in the <i>Config Developer Guide</i>.</p>
    pub fn sns_topic_arn(&self) -> ::std::option::Option<&str> {
        self.sns_topic_arn.as_deref()
    }
    /// <p>The options for how often Config delivers configuration snapshots to the Amazon S3 bucket.</p>
    pub fn config_snapshot_delivery_properties(&self) -> ::std::option::Option<&crate::types::ConfigSnapshotDeliveryProperties> {
        self.config_snapshot_delivery_properties.as_ref()
    }
}
impl DeliveryChannel {
    /// Creates a new builder-style object to manufacture [`DeliveryChannel`](crate::types::DeliveryChannel).
    pub fn builder() -> crate::types::builders::DeliveryChannelBuilder {
        crate::types::builders::DeliveryChannelBuilder::default()
    }
}

/// A builder for [`DeliveryChannel`](crate::types::DeliveryChannel).
#[derive(::std::clone::Clone, ::std::cmp::PartialEq, ::std::default::Default, ::std::fmt::Debug)]
#[non_exhaustive]
pub struct DeliveryChannelBuilder {
    pub(crate) name: ::std::option::Option<::std::string::String>,
    pub(crate) s3_bucket_name: ::std::option::Option<::std::string::String>,
    pub(crate) s3_key_prefix: ::std::option::Option<::std::string::String>,
    pub(crate) s3_kms_key_arn: ::std::option::Option<::std::string::String>,
    pub(crate) sns_topic_arn: ::std::option::Option<::std::string::String>,
    pub(crate) config_snapshot_delivery_properties: ::std::option::Option<crate::types::ConfigSnapshotDeliveryProperties>,
}
impl DeliveryChannelBuilder {
    /// <p>The name of the delivery channel. By default, Config assigns the name "default" when creating the delivery channel. To change the delivery channel name, you must use the DeleteDeliveryChannel action to delete your current delivery channel, and then you must use the PutDeliveryChannel command to create a delivery channel that has the desired name.</p>
    pub fn name(mut self, input: impl ::std::convert::Into<::std::string::String>) -> Self {
        self.name = ::std::option::Option::Some(input.into());
        self
    }
    /// <p>The name of the delivery channel. By default, Config assigns the name "default" when creating the delivery channel. To change the delivery channel name, you must use the DeleteDeliveryChannel action to delete your current delivery channel, and then you must use the PutDeliveryChannel command to create a delivery channel that has the desired name.</p>
    pub fn set_name(mut self, input: ::std::option::Option<::std::string::String>) -> Self {
        self.name = input;
        self
    }
    /// <p>The name of the delivery channel. By default, Config assigns the name "default" when creating the delivery channel. To change the delivery channel name, you must use the DeleteDeliveryChannel action to delete your current delivery channel, and then you must use the PutDeliveryChannel command to create a delivery channel that has the desired name.</p>
    pub fn get_name(&self) -> &::std::option::Option<::std::string::String> {
        &self.name
    }
    /// <p>The name of the Amazon S3 bucket to which Config delivers configuration snapshots and configuration history files.</p>
    /// <p>If you specify a bucket that belongs to another Amazon Web Services account, that bucket must have policies that grant access permissions to Config. For more information, see <a href="https://docs.aws.amazon.com/config/latest/developerguide/s3-bucket-policy.html">Permissions for the Amazon S3 Bucket</a> in the <i>Config Developer Guide</i>.</p>
    pub fn s3_bucket_name(mut self, input: impl ::std::convert::Into<::std::string::String>) -> Self {
        self.s3_bucket_name = ::std::option::Option::Some(input.into());
        self
    }
    /// <p>The name of the Amazon S3 bucket to which Config delivers configuration snapshots and configuration history files.</p>
    /// <p>If you specify a bucket that belongs to another Amazon Web Services account, that bucket must have policies that grant access permissions to Config. For more information, see <a href="https://docs.aws.amazon.com/config/latest/developerguide/s3-bucket-policy.html">Permissions for the Amazon S3 Bucket</a> in the <i>Config Developer Guide</i>.</p>
    pub fn set_s3_bucket_name(mut self, input: ::std::option::Option<::std::string::String>) -> Self {
        self.s3_bucket_name = input;
        self
    }
    /// <p>The name of the Amazon S3 bucket to which Config delivers configuration snapshots and configuration history files.</p>
    /// <p>If you specify a bucket that belongs to another Amazon Web Services account, that bucket must have policies that grant access permissions to Config. For more information, see <a href="https://docs.aws.amazon.com/config/latest/developerguide/s3-bucket-policy.html">Permissions for the Amazon S3 Bucket</a> in the <i>Config Developer Guide</i>.</p>
    pub fn get_s3_bucket_name(&self) -> &::std::option::Option<::std::string::String> {
        &self.s3_bucket_name
    }
    /// <p>The prefix for the specified Amazon S3 bucket.</p>
    pub fn s3_key_prefix(mut self, input: impl ::std::convert::Into<::std::string::String>) -> Self {
        self.s3_key_prefix = ::std::option::Option::Some(input.into());
        self
    }
    /// <p>The prefix for the specified Amazon S3 bucket.</p>
    pub fn set_s3_key_prefix(mut self, input: ::std::option::Option<::std::string::String>) -> Self {
        self.s3_key_prefix = input;
        self
    }
    /// <p>The prefix for the specified Amazon S3 bucket.</p>
    pub fn get_s3_key_prefix(&self) -> &::std::option::Option<::std::string::String> {
        &self.s3_key_prefix
    }
    /// <p>The Amazon Resource Name (ARN) of the Key Management Service (KMS ) KMS key (KMS key) used to encrypt objects delivered by Config. Must belong to the same Region as the destination S3 bucket.</p>
    pub fn s3_kms_key_arn(mut self, input: impl ::std::convert::Into<::std::string::String>) -> Self {
        self.s3_kms_key_arn = ::std::option::Option::Some(input.into());
        self
    }
    /// <p>The Amazon Resource Name (ARN) of the Key Management Service (KMS ) KMS key (KMS key) used to encrypt objects delivered by Config. Must belong to the same Region as the destination S3 bucket.</p>
    pub fn set_s3_kms_key_arn(mut self, input: ::std::option::Option<::std::string::String>) -> Self {
        self.s3_kms_key_arn = input;
        self
    }
    /// <p>The Amazon Resource Name (ARN) of the Key Management Service (KMS ) KMS key (KMS key) used to encrypt objects delivered by Config. Must belong to the same Region as the destination S3 bucket.</p>
    pub fn get_s3_kms_key_arn(&self) -> &::std::option::Option<::std::string::String> {
        &self.s3_kms_key_arn
    }
    /// <p>The Amazon Resource Name (ARN) of the Amazon SNS topic to which Config sends notifications about configuration changes.</p>
    /// <p>If you choose a topic from another account, the topic must have policies that grant access permissions to Config. For more information, see <a href="https://docs.aws.amazon.com/config/latest/developerguide/sns-topic-policy.html">Permissions for the Amazon SNS Topic</a> in the <i>Config Developer Guide</i>.</p>
    pub fn sns_topic_arn(mut self, input: impl ::std::convert::Into<::std::string::String>) -> Self {
        self.sns_topic_arn = ::std::option::Option::Some(input.into());
        self
    }
    /// <p>The Amazon Resource Name (ARN) of the Amazon SNS topic to which Config sends notifications about configuration changes.</p>
    /// <p>If you choose a topic from another account, the topic must have policies that grant access permissions to Config. For more information, see <a href="https://docs.aws.amazon.com/config/latest/developerguide/sns-topic-policy.html">Permissions for the Amazon SNS Topic</a> in the <i>Config Developer Guide</i>.</p>
    pub fn set_sns_topic_arn(mut self, input: ::std::option::Option<::std::string::String>) -> Self {
        self.sns_topic_arn = input;
        self
    }
    /// <p>The Amazon Resource Name (ARN) of the Amazon SNS topic to which Config sends notifications about configuration changes.</p>
    /// <p>If you choose a topic from another account, the topic must have policies that grant access permissions to Config. For more information, see <a href="https://docs.aws.amazon.com/config/latest/developerguide/sns-topic-policy.html">Permissions for the Amazon SNS Topic</a> in the <i>Config Developer Guide</i>.</p>
    pub fn get_sns_topic_arn(&self) -> &::std::option::Option<::std::string::String> {
        &self.sns_topic_arn
    }
    /// <p>The options for how often Config delivers configuration snapshots to the Amazon S3 bucket.</p>
    pub fn config_snapshot_delivery_properties(mut self, input: crate::types::ConfigSnapshotDeliveryProperties) -> Self {
        self.config_snapshot_delivery_properties = ::std::option::Option::Some(input);
        self
    }
    /// <p>The options for how often Config delivers configuration snapshots to the Amazon S3 bucket.</p>
    pub fn set_config_snapshot_delivery_properties(mut self, input: ::std::option::Option<crate::types::ConfigSnapshotDeliveryProperties>) -> Self {
        self.config_snapshot_delivery_properties = input;
        self
    }
    /// <p>The options for how often Config delivers configuration snapshots to the Amazon S3 bucket.</p>
    pub fn get_config_snapshot_delivery_properties(&self) -> &::std::option::Option<crate::types::ConfigSnapshotDeliveryProperties> {
        &self.config_snapshot_delivery_properties
    }
    /// Consumes the builder and constructs a [`DeliveryChannel`](crate::types::DeliveryChannel).
    pub fn build(self) -> crate::types::DeliveryChannel {
        crate::types::DeliveryChannel {
            name: self.name,
            s3_bucket_name: self.s3_bucket_name,
            s3_key_prefix: self.s3_key_prefix,
            s3_kms_key_arn: self.s3_kms_key_arn,
            sns_topic_arn: self.sns_topic_arn,
            config_snapshot_delivery_properties: self.config_snapshot_delivery_properties,
        }
    }
}
