// Code generated by software.amazon.smithy.rust.codegen.smithy-rs. DO NOT EDIT.

/// <p>The status of a specified delivery channel.</p>
/// <p>Valid values: <code>Success</code> | <code>Failure</code></p>
#[non_exhaustive]
#[derive(::std::clone::Clone, ::std::cmp::PartialEq, ::std::fmt::Debug)]
pub struct DeliveryChannelStatus {
    /// <p>The name of the delivery channel.</p>
    pub name: ::std::option::Option<::std::string::String>,
    /// <p>A list containing the status of the delivery of the snapshot to the specified Amazon S3 bucket.</p>
    pub config_snapshot_delivery_info: ::std::option::Option<crate::types::ConfigExportDeliveryInfo>,
    /// <p>A list that contains the status of the delivery of the configuration history to the specified Amazon S3 bucket.</p>
    pub config_history_delivery_info: ::std::option::Option<crate::types::ConfigExportDeliveryInfo>,
    /// <p>A list containing the status of the delivery of the configuration stream notification to the specified Amazon SNS topic.</p>
    pub config_stream_delivery_info: ::std::option::Option<crate::types::ConfigStreamDeliveryInfo>,
}
impl DeliveryChannelStatus {
    /// <p>The name of the delivery channel.</p>
    pub fn name(&self) -> ::std::option::Option<&str> {
        self.name.as_deref()
    }
    /// <p>A list containing the status of the delivery of the snapshot to the specified Amazon S3 bucket.</p>
    pub fn config_snapshot_delivery_info(&self) -> ::std::option::Option<&crate::types::ConfigExportDeliveryInfo> {
        self.config_snapshot_delivery_info.as_ref()
    }
    /// <p>A list that contains the status of the delivery of the configuration history to the specified Amazon S3 bucket.</p>
    pub fn config_history_delivery_info(&self) -> ::std::option::Option<&crate::types::ConfigExportDeliveryInfo> {
        self.config_history_delivery_info.as_ref()
    }
    /// <p>A list containing the status of the delivery of the configuration stream notification to the specified Amazon SNS topic.</p>
    pub fn config_stream_delivery_info(&self) -> ::std::option::Option<&crate::types::ConfigStreamDeliveryInfo> {
        self.config_stream_delivery_info.as_ref()
    }
}
impl DeliveryChannelStatus {
    /// Creates a new builder-style object to manufacture [`DeliveryChannelStatus`](crate::types::DeliveryChannelStatus).
    pub fn builder() -> crate::types::builders::DeliveryChannelStatusBuilder {
        crate::types::builders::DeliveryChannelStatusBuilder::default()
    }
}

/// A builder for [`DeliveryChannelStatus`](crate::types::DeliveryChannelStatus).
#[derive(::std::clone::Clone, ::std::cmp::PartialEq, ::std::default::Default, ::std::fmt::Debug)]
#[non_exhaustive]
pub struct DeliveryChannelStatusBuilder {
    pub(crate) name: ::std::option::Option<::std::string::String>,
    pub(crate) config_snapshot_delivery_info: ::std::option::Option<crate::types::ConfigExportDeliveryInfo>,
    pub(crate) config_history_delivery_info: ::std::option::Option<crate::types::ConfigExportDeliveryInfo>,
    pub(crate) config_stream_delivery_info: ::std::option::Option<crate::types::ConfigStreamDeliveryInfo>,
}
impl DeliveryChannelStatusBuilder {
    /// <p>The name of the delivery channel.</p>
    pub fn name(mut self, input: impl ::std::convert::Into<::std::string::String>) -> Self {
        self.name = ::std::option::Option::Some(input.into());
        self
    }
    /// <p>The name of the delivery channel.</p>
    pub fn set_name(mut self, input: ::std::option::Option<::std::string::String>) -> Self {
        self.name = input;
        self
    }
    /// <p>The name of the delivery channel.</p>
    pub fn get_name(&self) -> &::std::option::Option<::std::string::String> {
        &self.name
    }
    /// <p>A list containing the status of the delivery of the snapshot to the specified Amazon S3 bucket.</p>
    pub fn config_snapshot_delivery_info(mut self, input: crate::types::ConfigExportDeliveryInfo) -> Self {
        self.config_snapshot_delivery_info = ::std::option::Option::Some(input);
        self
    }
    /// <p>A list containing the status of the delivery of the snapshot to the specified Amazon S3 bucket.</p>
    pub fn set_config_snapshot_delivery_info(mut self, input: ::std::option::Option<crate::types::ConfigExportDeliveryInfo>) -> Self {
        self.config_snapshot_delivery_info = input;
        self
    }
    /// <p>A list containing the status of the delivery of the snapshot to the specified Amazon S3 bucket.</p>
    pub fn get_config_snapshot_delivery_info(&self) -> &::std::option::Option<crate::types::ConfigExportDeliveryInfo> {
        &self.config_snapshot_delivery_info
    }
    /// <p>A list that contains the status of the delivery of the configuration history to the specified Amazon S3 bucket.</p>
    pub fn config_history_delivery_info(mut self, input: crate::types::ConfigExportDeliveryInfo) -> Self {
        self.config_history_delivery_info = ::std::option::Option::Some(input);
        self
    }
    /// <p>A list that contains the status of the delivery of the configuration history to the specified Amazon S3 bucket.</p>
    pub fn set_config_history_delivery_info(mut self, input: ::std::option::Option<crate::types::ConfigExportDeliveryInfo>) -> Self {
        self.config_history_delivery_info = input;
        self
    }
    /// <p>A list that contains the status of the delivery of the configuration history to the specified Amazon S3 bucket.</p>
    pub fn get_config_history_delivery_info(&self) -> &::std::option::Option<crate::types::ConfigExportDeliveryInfo> {
        &self.config_history_delivery_info
    }
    /// <p>A list containing the status of the delivery of the configuration stream notification to the specified Amazon SNS topic.</p>
    pub fn config_stream_delivery_info(mut self, input: crate::types::ConfigStreamDeliveryInfo) -> Self {
        self.config_stream_delivery_info = ::std::option::Option::Some(input);
        self
    }
    /// <p>A list containing the status of the delivery of the configuration stream notification to the specified Amazon SNS topic.</p>
    pub fn set_config_stream_delivery_info(mut self, input: ::std::option::Option<crate::types::ConfigStreamDeliveryInfo>) -> Self {
        self.config_stream_delivery_info = input;
        self
    }
    /// <p>A list containing the status of the delivery of the configuration stream notification to the specified Amazon SNS topic.</p>
    pub fn get_config_stream_delivery_info(&self) -> &::std::option::Option<crate::types::ConfigStreamDeliveryInfo> {
        &self.config_stream_delivery_info
    }
    /// Consumes the builder and constructs a [`DeliveryChannelStatus`](crate::types::DeliveryChannelStatus).
    pub fn build(self) -> crate::types::DeliveryChannelStatus {
        crate::types::DeliveryChannelStatus {
            name: self.name,
            config_snapshot_delivery_info: self.config_snapshot_delivery_info,
            config_history_delivery_info: self.config_history_delivery_info,
            config_stream_delivery_info: self.config_stream_delivery_info,
        }
    }
}
