// Code generated by software.amazon.smithy.rust.codegen.smithy-rs. DO NOT EDIT.

/// <p>Specifies whether the configuration recorder excludes certain resource types from being recorded. Use the <code>resourceTypes</code> field to enter a comma-separated list of resource types you want to exclude from recording.</p>
/// <p>By default, when Config adds support for a new resource type in the Region where you set up the configuration recorder, including global resource types, Config starts recording resources of that type automatically.</p><note>
/// <p><b>How to use the exclusion recording strategy </b></p>
/// <p>To use this option, you must set the <code>useOnly</code> field of <a href="https://docs.aws.amazon.com/config/latest/APIReference/API_RecordingStrategy.html">RecordingStrategy</a> to <code>EXCLUSION_BY_RESOURCE_TYPES</code>.</p>
/// <p>Config will then record configuration changes for all supported resource types, except the resource types that you specify to exclude from being recorded.</p>
/// <p><b>Global resource types and the exclusion recording strategy </b></p>
/// <p>Unless specifically listed as exclusions, <code>AWS::RDS::GlobalCluster</code> will be recorded automatically in all supported Config Regions were the configuration recorder is enabled.</p>
/// <p>IAM users, groups, roles, and customer managed policies will be recorded in the Region where you set up the configuration recorder if that is a Region where Config was available before February 2022. You cannot be record the global IAM resouce types in Regions supported by Config after February 2022. For a list of those Regions, see <a href="https://docs.aws.amazon.com/config/latest/developerguide/select-resources.html#select-resources-all">Recording Amazon Web Services Resources | Global Resources</a>.</p>
/// </note>
#[non_exhaustive]
#[derive(::std::clone::Clone, ::std::cmp::PartialEq, ::std::fmt::Debug)]
pub struct ExclusionByResourceTypes {
    /// <p>A comma-separated list of resource types to exclude from recording by the configuration recorder.</p>
    pub resource_types: ::std::option::Option<::std::vec::Vec<crate::types::ResourceType>>,
}
impl ExclusionByResourceTypes {
    /// <p>A comma-separated list of resource types to exclude from recording by the configuration recorder.</p>
    ///
    /// If no value was sent for this field, a default will be set. If you want to determine if no value was sent, use `.resource_types.is_none()`.
    pub fn resource_types(&self) -> &[crate::types::ResourceType] {
        self.resource_types.as_deref().unwrap_or_default()
    }
}
impl ExclusionByResourceTypes {
    /// Creates a new builder-style object to manufacture [`ExclusionByResourceTypes`](crate::types::ExclusionByResourceTypes).
    pub fn builder() -> crate::types::builders::ExclusionByResourceTypesBuilder {
        crate::types::builders::ExclusionByResourceTypesBuilder::default()
    }
}

/// A builder for [`ExclusionByResourceTypes`](crate::types::ExclusionByResourceTypes).
#[derive(::std::clone::Clone, ::std::cmp::PartialEq, ::std::default::Default, ::std::fmt::Debug)]
#[non_exhaustive]
pub struct ExclusionByResourceTypesBuilder {
    pub(crate) resource_types: ::std::option::Option<::std::vec::Vec<crate::types::ResourceType>>,
}
impl ExclusionByResourceTypesBuilder {
    /// Appends an item to `resource_types`.
    ///
    /// To override the contents of this collection use [`set_resource_types`](Self::set_resource_types).
    ///
    /// <p>A comma-separated list of resource types to exclude from recording by the configuration recorder.</p>
    pub fn resource_types(mut self, input: crate::types::ResourceType) -> Self {
        let mut v = self.resource_types.unwrap_or_default();
        v.push(input);
        self.resource_types = ::std::option::Option::Some(v);
        self
    }
    /// <p>A comma-separated list of resource types to exclude from recording by the configuration recorder.</p>
    pub fn set_resource_types(mut self, input: ::std::option::Option<::std::vec::Vec<crate::types::ResourceType>>) -> Self {
        self.resource_types = input;
        self
    }
    /// <p>A comma-separated list of resource types to exclude from recording by the configuration recorder.</p>
    pub fn get_resource_types(&self) -> &::std::option::Option<::std::vec::Vec<crate::types::ResourceType>> {
        &self.resource_types
    }
    /// Consumes the builder and constructs a [`ExclusionByResourceTypes`](crate::types::ExclusionByResourceTypes).
    pub fn build(self) -> crate::types::ExclusionByResourceTypes {
        crate::types::ExclusionByResourceTypes {
            resource_types: self.resource_types,
        }
    }
}
