// Code generated by software.amazon.smithy.rust.codegen.smithy-rs. DO NOT EDIT.

/// When writing a match expression against `OrganizationResourceStatus`, it is important to ensure
/// your code is forward-compatible. That is, if a match arm handles a case for a
/// feature that is supported by the service but has not been represented as an enum
/// variant in a current version of SDK, your code should continue to work when you
/// upgrade SDK to a future version in which the enum does include a variant for that
/// feature.
///
/// Here is an example of how you can make a match expression forward-compatible:
///
/// ```text
/// # let organizationresourcestatus = unimplemented!();
/// match organizationresourcestatus {
///     OrganizationResourceStatus::CreateFailed => { /* ... */ },
///     OrganizationResourceStatus::CreateInProgress => { /* ... */ },
///     OrganizationResourceStatus::CreateSuccessful => { /* ... */ },
///     OrganizationResourceStatus::DeleteFailed => { /* ... */ },
///     OrganizationResourceStatus::DeleteInProgress => { /* ... */ },
///     OrganizationResourceStatus::DeleteSuccessful => { /* ... */ },
///     OrganizationResourceStatus::UpdateFailed => { /* ... */ },
///     OrganizationResourceStatus::UpdateInProgress => { /* ... */ },
///     OrganizationResourceStatus::UpdateSuccessful => { /* ... */ },
///     other @ _ if other.as_str() == "NewFeature" => { /* handles a case for `NewFeature` */ },
///     _ => { /* ... */ },
/// }
/// ```
/// The above code demonstrates that when `organizationresourcestatus` represents
/// `NewFeature`, the execution path will lead to the second last match arm,
/// even though the enum does not contain a variant `OrganizationResourceStatus::NewFeature`
/// in the current version of SDK. The reason is that the variable `other`,
/// created by the `@` operator, is bound to
/// `OrganizationResourceStatus::Unknown(UnknownVariantValue("NewFeature".to_owned()))`
/// and calling `as_str` on it yields `"NewFeature"`.
/// This match expression is forward-compatible when executed with a newer
/// version of SDK where the variant `OrganizationResourceStatus::NewFeature` is defined.
/// Specifically, when `organizationresourcestatus` represents `NewFeature`,
/// the execution path will hit the second last match arm as before by virtue of
/// calling `as_str` on `OrganizationResourceStatus::NewFeature` also yielding `"NewFeature"`.
///
/// Explicitly matching on the `Unknown` variant should
/// be avoided for two reasons:
/// - The inner data `UnknownVariantValue` is opaque, and no further information can be extracted.
/// - It might inadvertently shadow other intended match arms.
///
#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(
    ::std::clone::Clone, ::std::cmp::Eq, ::std::cmp::Ord, ::std::cmp::PartialEq, ::std::cmp::PartialOrd, ::std::fmt::Debug, ::std::hash::Hash,
)]
pub enum OrganizationResourceStatus {
    #[allow(missing_docs)] // documentation missing in model
    CreateFailed,
    #[allow(missing_docs)] // documentation missing in model
    CreateInProgress,
    #[allow(missing_docs)] // documentation missing in model
    CreateSuccessful,
    #[allow(missing_docs)] // documentation missing in model
    DeleteFailed,
    #[allow(missing_docs)] // documentation missing in model
    DeleteInProgress,
    #[allow(missing_docs)] // documentation missing in model
    DeleteSuccessful,
    #[allow(missing_docs)] // documentation missing in model
    UpdateFailed,
    #[allow(missing_docs)] // documentation missing in model
    UpdateInProgress,
    #[allow(missing_docs)] // documentation missing in model
    UpdateSuccessful,
    /// `Unknown` contains new variants that have been added since this code was generated.
    #[deprecated(note = "Don't directly match on `Unknown`. See the docs on this enum for the correct way to handle unknown variants.")]
    Unknown(crate::primitives::sealed_enum_unknown::UnknownVariantValue),
}
impl ::std::convert::From<&str> for OrganizationResourceStatus {
    fn from(s: &str) -> Self {
        match s {
            "CREATE_FAILED" => OrganizationResourceStatus::CreateFailed,
            "CREATE_IN_PROGRESS" => OrganizationResourceStatus::CreateInProgress,
            "CREATE_SUCCESSFUL" => OrganizationResourceStatus::CreateSuccessful,
            "DELETE_FAILED" => OrganizationResourceStatus::DeleteFailed,
            "DELETE_IN_PROGRESS" => OrganizationResourceStatus::DeleteInProgress,
            "DELETE_SUCCESSFUL" => OrganizationResourceStatus::DeleteSuccessful,
            "UPDATE_FAILED" => OrganizationResourceStatus::UpdateFailed,
            "UPDATE_IN_PROGRESS" => OrganizationResourceStatus::UpdateInProgress,
            "UPDATE_SUCCESSFUL" => OrganizationResourceStatus::UpdateSuccessful,
            other => OrganizationResourceStatus::Unknown(crate::primitives::sealed_enum_unknown::UnknownVariantValue(other.to_owned())),
        }
    }
}
impl ::std::str::FromStr for OrganizationResourceStatus {
    type Err = ::std::convert::Infallible;

    fn from_str(s: &str) -> ::std::result::Result<Self, <Self as ::std::str::FromStr>::Err> {
        ::std::result::Result::Ok(OrganizationResourceStatus::from(s))
    }
}
impl OrganizationResourceStatus {
    /// Returns the `&str` value of the enum member.
    pub fn as_str(&self) -> &str {
        match self {
            OrganizationResourceStatus::CreateFailed => "CREATE_FAILED",
            OrganizationResourceStatus::CreateInProgress => "CREATE_IN_PROGRESS",
            OrganizationResourceStatus::CreateSuccessful => "CREATE_SUCCESSFUL",
            OrganizationResourceStatus::DeleteFailed => "DELETE_FAILED",
            OrganizationResourceStatus::DeleteInProgress => "DELETE_IN_PROGRESS",
            OrganizationResourceStatus::DeleteSuccessful => "DELETE_SUCCESSFUL",
            OrganizationResourceStatus::UpdateFailed => "UPDATE_FAILED",
            OrganizationResourceStatus::UpdateInProgress => "UPDATE_IN_PROGRESS",
            OrganizationResourceStatus::UpdateSuccessful => "UPDATE_SUCCESSFUL",
            OrganizationResourceStatus::Unknown(value) => value.as_str(),
        }
    }
    /// Returns all the `&str` representations of the enum members.
    pub const fn values() -> &'static [&'static str] {
        &[
            "CREATE_FAILED",
            "CREATE_IN_PROGRESS",
            "CREATE_SUCCESSFUL",
            "DELETE_FAILED",
            "DELETE_IN_PROGRESS",
            "DELETE_SUCCESSFUL",
            "UPDATE_FAILED",
            "UPDATE_IN_PROGRESS",
            "UPDATE_SUCCESSFUL",
        ]
    }
}
impl ::std::convert::AsRef<str> for OrganizationResourceStatus {
    fn as_ref(&self) -> &str {
        self.as_str()
    }
}
impl OrganizationResourceStatus {
    /// Parses the enum value while disallowing unknown variants.
    ///
    /// Unknown variants will result in an error.
    pub fn try_parse(value: &str) -> ::std::result::Result<Self, crate::error::UnknownVariantError> {
        match Self::from(value) {
            #[allow(deprecated)]
            Self::Unknown(_) => ::std::result::Result::Err(crate::error::UnknownVariantError::new(value)),
            known => Ok(known),
        }
    }
}
impl ::std::fmt::Display for OrganizationResourceStatus {
    fn fmt(&self, f: &mut ::std::fmt::Formatter) -> ::std::fmt::Result {
        match self {
            OrganizationResourceStatus::CreateFailed => write!(f, "CREATE_FAILED"),
            OrganizationResourceStatus::CreateInProgress => write!(f, "CREATE_IN_PROGRESS"),
            OrganizationResourceStatus::CreateSuccessful => write!(f, "CREATE_SUCCESSFUL"),
            OrganizationResourceStatus::DeleteFailed => write!(f, "DELETE_FAILED"),
            OrganizationResourceStatus::DeleteInProgress => write!(f, "DELETE_IN_PROGRESS"),
            OrganizationResourceStatus::DeleteSuccessful => write!(f, "DELETE_SUCCESSFUL"),
            OrganizationResourceStatus::UpdateFailed => write!(f, "UPDATE_FAILED"),
            OrganizationResourceStatus::UpdateInProgress => write!(f, "UPDATE_IN_PROGRESS"),
            OrganizationResourceStatus::UpdateSuccessful => write!(f, "UPDATE_SUCCESSFUL"),
            OrganizationResourceStatus::Unknown(value) => write!(f, "{value}"),
        }
    }
}
