// Code generated by software.amazon.smithy.rust.codegen.smithy-rs. DO NOT EDIT.

/// <p>Specifies the default recording frequency that Config uses to record configuration changes. Config supports <i>Continuous recording</i> and <i>Daily recording</i>.</p>
/// <ul>
/// <li>
/// <p>Continuous recording allows you to record configuration changes continuously whenever a change occurs.</p></li>
/// <li>
/// <p>Daily recording allows you to receive a configuration item (CI) representing the most recent state of your resources over the last 24-hour period, only if it’s different from the previous CI recorded.</p></li>
/// </ul><note>
/// <p>Firewall Manager depends on continuous recording to monitor your resources. If you are using Firewall Manager, it is recommended that you set the recording frequency to Continuous.</p>
/// </note>
/// <p>You can also override the recording frequency for specific resource types.</p>
#[non_exhaustive]
#[derive(::std::clone::Clone, ::std::cmp::PartialEq, ::std::fmt::Debug)]
pub struct RecordingMode {
    /// <p>The default recording frequency that Config uses to record configuration changes.</p><important>
    /// <p>Daily recording cannot be specified for the following resource types:</p>
    /// <ul>
    /// <li>
    /// <p><code>AWS::Config::ResourceCompliance</code></p></li>
    /// <li>
    /// <p><code>AWS::Config::ConformancePackCompliance</code></p></li>
    /// <li>
    /// <p><code>AWS::Config::ConfigurationRecorder</code></p></li>
    /// </ul>
    /// <p>For the <b>allSupported</b> (<code>ALL_SUPPORTED_RESOURCE_TYPES</code>) recording strategy, these resource types will be set to Continuous recording.</p>
    /// </important>
    pub recording_frequency: crate::types::RecordingFrequency,
    /// <p>An array of <code>recordingModeOverride</code> objects for you to specify your overrides for the recording mode. The <code>recordingModeOverride</code> object in the <code>recordingModeOverrides</code> array consists of three fields: a <code>description</code>, the new <code>recordingFrequency</code>, and an array of <code>resourceTypes</code> to override.</p>
    pub recording_mode_overrides: ::std::option::Option<::std::vec::Vec<crate::types::RecordingModeOverride>>,
}
impl RecordingMode {
    /// <p>The default recording frequency that Config uses to record configuration changes.</p><important>
    /// <p>Daily recording cannot be specified for the following resource types:</p>
    /// <ul>
    /// <li>
    /// <p><code>AWS::Config::ResourceCompliance</code></p></li>
    /// <li>
    /// <p><code>AWS::Config::ConformancePackCompliance</code></p></li>
    /// <li>
    /// <p><code>AWS::Config::ConfigurationRecorder</code></p></li>
    /// </ul>
    /// <p>For the <b>allSupported</b> (<code>ALL_SUPPORTED_RESOURCE_TYPES</code>) recording strategy, these resource types will be set to Continuous recording.</p>
    /// </important>
    pub fn recording_frequency(&self) -> &crate::types::RecordingFrequency {
        &self.recording_frequency
    }
    /// <p>An array of <code>recordingModeOverride</code> objects for you to specify your overrides for the recording mode. The <code>recordingModeOverride</code> object in the <code>recordingModeOverrides</code> array consists of three fields: a <code>description</code>, the new <code>recordingFrequency</code>, and an array of <code>resourceTypes</code> to override.</p>
    ///
    /// If no value was sent for this field, a default will be set. If you want to determine if no value was sent, use `.recording_mode_overrides.is_none()`.
    pub fn recording_mode_overrides(&self) -> &[crate::types::RecordingModeOverride] {
        self.recording_mode_overrides.as_deref().unwrap_or_default()
    }
}
impl RecordingMode {
    /// Creates a new builder-style object to manufacture [`RecordingMode`](crate::types::RecordingMode).
    pub fn builder() -> crate::types::builders::RecordingModeBuilder {
        crate::types::builders::RecordingModeBuilder::default()
    }
}

/// A builder for [`RecordingMode`](crate::types::RecordingMode).
#[derive(::std::clone::Clone, ::std::cmp::PartialEq, ::std::default::Default, ::std::fmt::Debug)]
#[non_exhaustive]
pub struct RecordingModeBuilder {
    pub(crate) recording_frequency: ::std::option::Option<crate::types::RecordingFrequency>,
    pub(crate) recording_mode_overrides: ::std::option::Option<::std::vec::Vec<crate::types::RecordingModeOverride>>,
}
impl RecordingModeBuilder {
    /// <p>The default recording frequency that Config uses to record configuration changes.</p><important>
    /// <p>Daily recording cannot be specified for the following resource types:</p>
    /// <ul>
    /// <li>
    /// <p><code>AWS::Config::ResourceCompliance</code></p></li>
    /// <li>
    /// <p><code>AWS::Config::ConformancePackCompliance</code></p></li>
    /// <li>
    /// <p><code>AWS::Config::ConfigurationRecorder</code></p></li>
    /// </ul>
    /// <p>For the <b>allSupported</b> (<code>ALL_SUPPORTED_RESOURCE_TYPES</code>) recording strategy, these resource types will be set to Continuous recording.</p>
    /// </important>
    /// This field is required.
    pub fn recording_frequency(mut self, input: crate::types::RecordingFrequency) -> Self {
        self.recording_frequency = ::std::option::Option::Some(input);
        self
    }
    /// <p>The default recording frequency that Config uses to record configuration changes.</p><important>
    /// <p>Daily recording cannot be specified for the following resource types:</p>
    /// <ul>
    /// <li>
    /// <p><code>AWS::Config::ResourceCompliance</code></p></li>
    /// <li>
    /// <p><code>AWS::Config::ConformancePackCompliance</code></p></li>
    /// <li>
    /// <p><code>AWS::Config::ConfigurationRecorder</code></p></li>
    /// </ul>
    /// <p>For the <b>allSupported</b> (<code>ALL_SUPPORTED_RESOURCE_TYPES</code>) recording strategy, these resource types will be set to Continuous recording.</p>
    /// </important>
    pub fn set_recording_frequency(mut self, input: ::std::option::Option<crate::types::RecordingFrequency>) -> Self {
        self.recording_frequency = input;
        self
    }
    /// <p>The default recording frequency that Config uses to record configuration changes.</p><important>
    /// <p>Daily recording cannot be specified for the following resource types:</p>
    /// <ul>
    /// <li>
    /// <p><code>AWS::Config::ResourceCompliance</code></p></li>
    /// <li>
    /// <p><code>AWS::Config::ConformancePackCompliance</code></p></li>
    /// <li>
    /// <p><code>AWS::Config::ConfigurationRecorder</code></p></li>
    /// </ul>
    /// <p>For the <b>allSupported</b> (<code>ALL_SUPPORTED_RESOURCE_TYPES</code>) recording strategy, these resource types will be set to Continuous recording.</p>
    /// </important>
    pub fn get_recording_frequency(&self) -> &::std::option::Option<crate::types::RecordingFrequency> {
        &self.recording_frequency
    }
    /// Appends an item to `recording_mode_overrides`.
    ///
    /// To override the contents of this collection use [`set_recording_mode_overrides`](Self::set_recording_mode_overrides).
    ///
    /// <p>An array of <code>recordingModeOverride</code> objects for you to specify your overrides for the recording mode. The <code>recordingModeOverride</code> object in the <code>recordingModeOverrides</code> array consists of three fields: a <code>description</code>, the new <code>recordingFrequency</code>, and an array of <code>resourceTypes</code> to override.</p>
    pub fn recording_mode_overrides(mut self, input: crate::types::RecordingModeOverride) -> Self {
        let mut v = self.recording_mode_overrides.unwrap_or_default();
        v.push(input);
        self.recording_mode_overrides = ::std::option::Option::Some(v);
        self
    }
    /// <p>An array of <code>recordingModeOverride</code> objects for you to specify your overrides for the recording mode. The <code>recordingModeOverride</code> object in the <code>recordingModeOverrides</code> array consists of three fields: a <code>description</code>, the new <code>recordingFrequency</code>, and an array of <code>resourceTypes</code> to override.</p>
    pub fn set_recording_mode_overrides(mut self, input: ::std::option::Option<::std::vec::Vec<crate::types::RecordingModeOverride>>) -> Self {
        self.recording_mode_overrides = input;
        self
    }
    /// <p>An array of <code>recordingModeOverride</code> objects for you to specify your overrides for the recording mode. The <code>recordingModeOverride</code> object in the <code>recordingModeOverrides</code> array consists of three fields: a <code>description</code>, the new <code>recordingFrequency</code>, and an array of <code>resourceTypes</code> to override.</p>
    pub fn get_recording_mode_overrides(&self) -> &::std::option::Option<::std::vec::Vec<crate::types::RecordingModeOverride>> {
        &self.recording_mode_overrides
    }
    /// Consumes the builder and constructs a [`RecordingMode`](crate::types::RecordingMode).
    /// This method will fail if any of the following fields are not set:
    /// - [`recording_frequency`](crate::types::builders::RecordingModeBuilder::recording_frequency)
    pub fn build(self) -> ::std::result::Result<crate::types::RecordingMode, ::aws_smithy_types::error::operation::BuildError> {
        ::std::result::Result::Ok(crate::types::RecordingMode {
            recording_frequency: self.recording_frequency.ok_or_else(|| {
                ::aws_smithy_types::error::operation::BuildError::missing_field(
                    "recording_frequency",
                    "recording_frequency was not specified but it is required when building RecordingMode",
                )
            })?,
            recording_mode_overrides: self.recording_mode_overrides,
        })
    }
}
