// Code generated by software.amazon.smithy.rust.codegen.smithy-rs. DO NOT EDIT.

/// When writing a match expression against `RecordingStrategyType`, it is important to ensure
/// your code is forward-compatible. That is, if a match arm handles a case for a
/// feature that is supported by the service but has not been represented as an enum
/// variant in a current version of SDK, your code should continue to work when you
/// upgrade SDK to a future version in which the enum does include a variant for that
/// feature.
///
/// Here is an example of how you can make a match expression forward-compatible:
///
/// ```text
/// # let recordingstrategytype = unimplemented!();
/// match recordingstrategytype {
///     RecordingStrategyType::AllSupportedResourceTypes => { /* ... */ },
///     RecordingStrategyType::ExclusionByResourceTypes => { /* ... */ },
///     RecordingStrategyType::InclusionByResourceTypes => { /* ... */ },
///     other @ _ if other.as_str() == "NewFeature" => { /* handles a case for `NewFeature` */ },
///     _ => { /* ... */ },
/// }
/// ```
/// The above code demonstrates that when `recordingstrategytype` represents
/// `NewFeature`, the execution path will lead to the second last match arm,
/// even though the enum does not contain a variant `RecordingStrategyType::NewFeature`
/// in the current version of SDK. The reason is that the variable `other`,
/// created by the `@` operator, is bound to
/// `RecordingStrategyType::Unknown(UnknownVariantValue("NewFeature".to_owned()))`
/// and calling `as_str` on it yields `"NewFeature"`.
/// This match expression is forward-compatible when executed with a newer
/// version of SDK where the variant `RecordingStrategyType::NewFeature` is defined.
/// Specifically, when `recordingstrategytype` represents `NewFeature`,
/// the execution path will hit the second last match arm as before by virtue of
/// calling `as_str` on `RecordingStrategyType::NewFeature` also yielding `"NewFeature"`.
///
/// Explicitly matching on the `Unknown` variant should
/// be avoided for two reasons:
/// - The inner data `UnknownVariantValue` is opaque, and no further information can be extracted.
/// - It might inadvertently shadow other intended match arms.
///
#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(
    ::std::clone::Clone, ::std::cmp::Eq, ::std::cmp::Ord, ::std::cmp::PartialEq, ::std::cmp::PartialOrd, ::std::fmt::Debug, ::std::hash::Hash,
)]
pub enum RecordingStrategyType {
    #[allow(missing_docs)] // documentation missing in model
    AllSupportedResourceTypes,
    #[allow(missing_docs)] // documentation missing in model
    ExclusionByResourceTypes,
    #[allow(missing_docs)] // documentation missing in model
    InclusionByResourceTypes,
    /// `Unknown` contains new variants that have been added since this code was generated.
    #[deprecated(note = "Don't directly match on `Unknown`. See the docs on this enum for the correct way to handle unknown variants.")]
    Unknown(crate::primitives::sealed_enum_unknown::UnknownVariantValue),
}
impl ::std::convert::From<&str> for RecordingStrategyType {
    fn from(s: &str) -> Self {
        match s {
            "ALL_SUPPORTED_RESOURCE_TYPES" => RecordingStrategyType::AllSupportedResourceTypes,
            "EXCLUSION_BY_RESOURCE_TYPES" => RecordingStrategyType::ExclusionByResourceTypes,
            "INCLUSION_BY_RESOURCE_TYPES" => RecordingStrategyType::InclusionByResourceTypes,
            other => RecordingStrategyType::Unknown(crate::primitives::sealed_enum_unknown::UnknownVariantValue(other.to_owned())),
        }
    }
}
impl ::std::str::FromStr for RecordingStrategyType {
    type Err = ::std::convert::Infallible;

    fn from_str(s: &str) -> ::std::result::Result<Self, <Self as ::std::str::FromStr>::Err> {
        ::std::result::Result::Ok(RecordingStrategyType::from(s))
    }
}
impl RecordingStrategyType {
    /// Returns the `&str` value of the enum member.
    pub fn as_str(&self) -> &str {
        match self {
            RecordingStrategyType::AllSupportedResourceTypes => "ALL_SUPPORTED_RESOURCE_TYPES",
            RecordingStrategyType::ExclusionByResourceTypes => "EXCLUSION_BY_RESOURCE_TYPES",
            RecordingStrategyType::InclusionByResourceTypes => "INCLUSION_BY_RESOURCE_TYPES",
            RecordingStrategyType::Unknown(value) => value.as_str(),
        }
    }
    /// Returns all the `&str` representations of the enum members.
    pub const fn values() -> &'static [&'static str] {
        &[
            "ALL_SUPPORTED_RESOURCE_TYPES",
            "EXCLUSION_BY_RESOURCE_TYPES",
            "INCLUSION_BY_RESOURCE_TYPES",
        ]
    }
}
impl ::std::convert::AsRef<str> for RecordingStrategyType {
    fn as_ref(&self) -> &str {
        self.as_str()
    }
}
impl RecordingStrategyType {
    /// Parses the enum value while disallowing unknown variants.
    ///
    /// Unknown variants will result in an error.
    pub fn try_parse(value: &str) -> ::std::result::Result<Self, crate::error::UnknownVariantError> {
        match Self::from(value) {
            #[allow(deprecated)]
            Self::Unknown(_) => ::std::result::Result::Err(crate::error::UnknownVariantError::new(value)),
            known => Ok(known),
        }
    }
}
impl ::std::fmt::Display for RecordingStrategyType {
    fn fmt(&self, f: &mut ::std::fmt::Formatter) -> ::std::fmt::Result {
        match self {
            RecordingStrategyType::AllSupportedResourceTypes => write!(f, "ALL_SUPPORTED_RESOURCE_TYPES"),
            RecordingStrategyType::ExclusionByResourceTypes => write!(f, "EXCLUSION_BY_RESOURCE_TYPES"),
            RecordingStrategyType::InclusionByResourceTypes => write!(f, "INCLUSION_BY_RESOURCE_TYPES"),
            RecordingStrategyType::Unknown(value) => write!(f, "{value}"),
        }
    }
}
