// Code generated by software.amazon.smithy.rust.codegen.smithy-rs. DO NOT EDIT.

/// <p>An object with the name of the retention configuration and the retention period in days. The object stores the configuration for data retention in Config.</p>
#[non_exhaustive]
#[derive(::std::clone::Clone, ::std::cmp::PartialEq, ::std::fmt::Debug)]
pub struct RetentionConfiguration {
    /// <p>The name of the retention configuration object.</p>
    pub name: ::std::string::String,
    /// <p>Number of days Config stores your historical information.</p><note>
    /// <p>Currently, only applicable to the configuration item history.</p>
    /// </note>
    pub retention_period_in_days: i32,
}
impl RetentionConfiguration {
    /// <p>The name of the retention configuration object.</p>
    pub fn name(&self) -> &str {
        use std::ops::Deref;
        self.name.deref()
    }
    /// <p>Number of days Config stores your historical information.</p><note>
    /// <p>Currently, only applicable to the configuration item history.</p>
    /// </note>
    pub fn retention_period_in_days(&self) -> i32 {
        self.retention_period_in_days
    }
}
impl RetentionConfiguration {
    /// Creates a new builder-style object to manufacture [`RetentionConfiguration`](crate::types::RetentionConfiguration).
    pub fn builder() -> crate::types::builders::RetentionConfigurationBuilder {
        crate::types::builders::RetentionConfigurationBuilder::default()
    }
}

/// A builder for [`RetentionConfiguration`](crate::types::RetentionConfiguration).
#[derive(::std::clone::Clone, ::std::cmp::PartialEq, ::std::default::Default, ::std::fmt::Debug)]
#[non_exhaustive]
pub struct RetentionConfigurationBuilder {
    pub(crate) name: ::std::option::Option<::std::string::String>,
    pub(crate) retention_period_in_days: ::std::option::Option<i32>,
}
impl RetentionConfigurationBuilder {
    /// <p>The name of the retention configuration object.</p>
    /// This field is required.
    pub fn name(mut self, input: impl ::std::convert::Into<::std::string::String>) -> Self {
        self.name = ::std::option::Option::Some(input.into());
        self
    }
    /// <p>The name of the retention configuration object.</p>
    pub fn set_name(mut self, input: ::std::option::Option<::std::string::String>) -> Self {
        self.name = input;
        self
    }
    /// <p>The name of the retention configuration object.</p>
    pub fn get_name(&self) -> &::std::option::Option<::std::string::String> {
        &self.name
    }
    /// <p>Number of days Config stores your historical information.</p><note>
    /// <p>Currently, only applicable to the configuration item history.</p>
    /// </note>
    /// This field is required.
    pub fn retention_period_in_days(mut self, input: i32) -> Self {
        self.retention_period_in_days = ::std::option::Option::Some(input);
        self
    }
    /// <p>Number of days Config stores your historical information.</p><note>
    /// <p>Currently, only applicable to the configuration item history.</p>
    /// </note>
    pub fn set_retention_period_in_days(mut self, input: ::std::option::Option<i32>) -> Self {
        self.retention_period_in_days = input;
        self
    }
    /// <p>Number of days Config stores your historical information.</p><note>
    /// <p>Currently, only applicable to the configuration item history.</p>
    /// </note>
    pub fn get_retention_period_in_days(&self) -> &::std::option::Option<i32> {
        &self.retention_period_in_days
    }
    /// Consumes the builder and constructs a [`RetentionConfiguration`](crate::types::RetentionConfiguration).
    /// This method will fail if any of the following fields are not set:
    /// - [`name`](crate::types::builders::RetentionConfigurationBuilder::name)
    /// - [`retention_period_in_days`](crate::types::builders::RetentionConfigurationBuilder::retention_period_in_days)
    pub fn build(self) -> ::std::result::Result<crate::types::RetentionConfiguration, ::aws_smithy_types::error::operation::BuildError> {
        ::std::result::Result::Ok(crate::types::RetentionConfiguration {
            name: self.name.ok_or_else(|| {
                ::aws_smithy_types::error::operation::BuildError::missing_field(
                    "name",
                    "name was not specified but it is required when building RetentionConfiguration",
                )
            })?,
            retention_period_in_days: self.retention_period_in_days.ok_or_else(|| {
                ::aws_smithy_types::error::operation::BuildError::missing_field(
                    "retention_period_in_days",
                    "retention_period_in_days was not specified but it is required when building RetentionConfiguration",
                )
            })?,
        })
    }
}
