// Code generated by software.amazon.smithy.rust.codegen.smithy-rs. DO NOT EDIT.

/// <p>Provides the source and the message types that trigger Config to evaluate your Amazon Web Services resources against a rule. It also provides the frequency with which you want Config to run evaluations for the rule if the trigger type is periodic. You can specify the parameter values for <code>SourceDetail</code> only for custom rules.</p>
#[non_exhaustive]
#[derive(::std::clone::Clone, ::std::cmp::PartialEq, ::std::fmt::Debug)]
pub struct SourceDetail {
    /// <p>The source of the event, such as an Amazon Web Services service, that triggers Config to evaluate your Amazon Web Services resources.</p>
    pub event_source: ::std::option::Option<crate::types::EventSource>,
    /// <p>The type of notification that triggers Config to run an evaluation for a rule. You can specify the following notification types:</p>
    /// <ul>
    /// <li>
    /// <p><code>ConfigurationItemChangeNotification</code> - Triggers an evaluation when Config delivers a configuration item as a result of a resource change.</p></li>
    /// <li>
    /// <p><code>OversizedConfigurationItemChangeNotification</code> - Triggers an evaluation when Config delivers an oversized configuration item. Config may generate this notification type when a resource changes and the notification exceeds the maximum size allowed by Amazon SNS.</p></li>
    /// <li>
    /// <p><code>ScheduledNotification</code> - Triggers a periodic evaluation at the frequency specified for <code>MaximumExecutionFrequency</code>.</p></li>
    /// <li>
    /// <p><code>ConfigurationSnapshotDeliveryCompleted</code> - Triggers a periodic evaluation when Config delivers a configuration snapshot.</p></li>
    /// </ul>
    /// <p>If you want your custom rule to be triggered by configuration changes, specify two SourceDetail objects, one for <code>ConfigurationItemChangeNotification</code> and one for <code>OversizedConfigurationItemChangeNotification</code>.</p>
    pub message_type: ::std::option::Option<crate::types::MessageType>,
    /// <p>The frequency at which you want Config to run evaluations for a custom rule with a periodic trigger. If you specify a value for <code>MaximumExecutionFrequency</code>, then <code>MessageType</code> must use the <code>ScheduledNotification</code> value.</p><note>
    /// <p>By default, rules with a periodic trigger are evaluated every 24 hours. To change the frequency, specify a valid value for the <code>MaximumExecutionFrequency</code> parameter.</p>
    /// <p>Based on the valid value you choose, Config runs evaluations once for each valid value. For example, if you choose <code>Three_Hours</code>, Config runs evaluations once every three hours. In this case, <code>Three_Hours</code> is the frequency of this rule.</p>
    /// </note>
    pub maximum_execution_frequency: ::std::option::Option<crate::types::MaximumExecutionFrequency>,
}
impl SourceDetail {
    /// <p>The source of the event, such as an Amazon Web Services service, that triggers Config to evaluate your Amazon Web Services resources.</p>
    pub fn event_source(&self) -> ::std::option::Option<&crate::types::EventSource> {
        self.event_source.as_ref()
    }
    /// <p>The type of notification that triggers Config to run an evaluation for a rule. You can specify the following notification types:</p>
    /// <ul>
    /// <li>
    /// <p><code>ConfigurationItemChangeNotification</code> - Triggers an evaluation when Config delivers a configuration item as a result of a resource change.</p></li>
    /// <li>
    /// <p><code>OversizedConfigurationItemChangeNotification</code> - Triggers an evaluation when Config delivers an oversized configuration item. Config may generate this notification type when a resource changes and the notification exceeds the maximum size allowed by Amazon SNS.</p></li>
    /// <li>
    /// <p><code>ScheduledNotification</code> - Triggers a periodic evaluation at the frequency specified for <code>MaximumExecutionFrequency</code>.</p></li>
    /// <li>
    /// <p><code>ConfigurationSnapshotDeliveryCompleted</code> - Triggers a periodic evaluation when Config delivers a configuration snapshot.</p></li>
    /// </ul>
    /// <p>If you want your custom rule to be triggered by configuration changes, specify two SourceDetail objects, one for <code>ConfigurationItemChangeNotification</code> and one for <code>OversizedConfigurationItemChangeNotification</code>.</p>
    pub fn message_type(&self) -> ::std::option::Option<&crate::types::MessageType> {
        self.message_type.as_ref()
    }
    /// <p>The frequency at which you want Config to run evaluations for a custom rule with a periodic trigger. If you specify a value for <code>MaximumExecutionFrequency</code>, then <code>MessageType</code> must use the <code>ScheduledNotification</code> value.</p><note>
    /// <p>By default, rules with a periodic trigger are evaluated every 24 hours. To change the frequency, specify a valid value for the <code>MaximumExecutionFrequency</code> parameter.</p>
    /// <p>Based on the valid value you choose, Config runs evaluations once for each valid value. For example, if you choose <code>Three_Hours</code>, Config runs evaluations once every three hours. In this case, <code>Three_Hours</code> is the frequency of this rule.</p>
    /// </note>
    pub fn maximum_execution_frequency(&self) -> ::std::option::Option<&crate::types::MaximumExecutionFrequency> {
        self.maximum_execution_frequency.as_ref()
    }
}
impl SourceDetail {
    /// Creates a new builder-style object to manufacture [`SourceDetail`](crate::types::SourceDetail).
    pub fn builder() -> crate::types::builders::SourceDetailBuilder {
        crate::types::builders::SourceDetailBuilder::default()
    }
}

/// A builder for [`SourceDetail`](crate::types::SourceDetail).
#[derive(::std::clone::Clone, ::std::cmp::PartialEq, ::std::default::Default, ::std::fmt::Debug)]
#[non_exhaustive]
pub struct SourceDetailBuilder {
    pub(crate) event_source: ::std::option::Option<crate::types::EventSource>,
    pub(crate) message_type: ::std::option::Option<crate::types::MessageType>,
    pub(crate) maximum_execution_frequency: ::std::option::Option<crate::types::MaximumExecutionFrequency>,
}
impl SourceDetailBuilder {
    /// <p>The source of the event, such as an Amazon Web Services service, that triggers Config to evaluate your Amazon Web Services resources.</p>
    pub fn event_source(mut self, input: crate::types::EventSource) -> Self {
        self.event_source = ::std::option::Option::Some(input);
        self
    }
    /// <p>The source of the event, such as an Amazon Web Services service, that triggers Config to evaluate your Amazon Web Services resources.</p>
    pub fn set_event_source(mut self, input: ::std::option::Option<crate::types::EventSource>) -> Self {
        self.event_source = input;
        self
    }
    /// <p>The source of the event, such as an Amazon Web Services service, that triggers Config to evaluate your Amazon Web Services resources.</p>
    pub fn get_event_source(&self) -> &::std::option::Option<crate::types::EventSource> {
        &self.event_source
    }
    /// <p>The type of notification that triggers Config to run an evaluation for a rule. You can specify the following notification types:</p>
    /// <ul>
    /// <li>
    /// <p><code>ConfigurationItemChangeNotification</code> - Triggers an evaluation when Config delivers a configuration item as a result of a resource change.</p></li>
    /// <li>
    /// <p><code>OversizedConfigurationItemChangeNotification</code> - Triggers an evaluation when Config delivers an oversized configuration item. Config may generate this notification type when a resource changes and the notification exceeds the maximum size allowed by Amazon SNS.</p></li>
    /// <li>
    /// <p><code>ScheduledNotification</code> - Triggers a periodic evaluation at the frequency specified for <code>MaximumExecutionFrequency</code>.</p></li>
    /// <li>
    /// <p><code>ConfigurationSnapshotDeliveryCompleted</code> - Triggers a periodic evaluation when Config delivers a configuration snapshot.</p></li>
    /// </ul>
    /// <p>If you want your custom rule to be triggered by configuration changes, specify two SourceDetail objects, one for <code>ConfigurationItemChangeNotification</code> and one for <code>OversizedConfigurationItemChangeNotification</code>.</p>
    pub fn message_type(mut self, input: crate::types::MessageType) -> Self {
        self.message_type = ::std::option::Option::Some(input);
        self
    }
    /// <p>The type of notification that triggers Config to run an evaluation for a rule. You can specify the following notification types:</p>
    /// <ul>
    /// <li>
    /// <p><code>ConfigurationItemChangeNotification</code> - Triggers an evaluation when Config delivers a configuration item as a result of a resource change.</p></li>
    /// <li>
    /// <p><code>OversizedConfigurationItemChangeNotification</code> - Triggers an evaluation when Config delivers an oversized configuration item. Config may generate this notification type when a resource changes and the notification exceeds the maximum size allowed by Amazon SNS.</p></li>
    /// <li>
    /// <p><code>ScheduledNotification</code> - Triggers a periodic evaluation at the frequency specified for <code>MaximumExecutionFrequency</code>.</p></li>
    /// <li>
    /// <p><code>ConfigurationSnapshotDeliveryCompleted</code> - Triggers a periodic evaluation when Config delivers a configuration snapshot.</p></li>
    /// </ul>
    /// <p>If you want your custom rule to be triggered by configuration changes, specify two SourceDetail objects, one for <code>ConfigurationItemChangeNotification</code> and one for <code>OversizedConfigurationItemChangeNotification</code>.</p>
    pub fn set_message_type(mut self, input: ::std::option::Option<crate::types::MessageType>) -> Self {
        self.message_type = input;
        self
    }
    /// <p>The type of notification that triggers Config to run an evaluation for a rule. You can specify the following notification types:</p>
    /// <ul>
    /// <li>
    /// <p><code>ConfigurationItemChangeNotification</code> - Triggers an evaluation when Config delivers a configuration item as a result of a resource change.</p></li>
    /// <li>
    /// <p><code>OversizedConfigurationItemChangeNotification</code> - Triggers an evaluation when Config delivers an oversized configuration item. Config may generate this notification type when a resource changes and the notification exceeds the maximum size allowed by Amazon SNS.</p></li>
    /// <li>
    /// <p><code>ScheduledNotification</code> - Triggers a periodic evaluation at the frequency specified for <code>MaximumExecutionFrequency</code>.</p></li>
    /// <li>
    /// <p><code>ConfigurationSnapshotDeliveryCompleted</code> - Triggers a periodic evaluation when Config delivers a configuration snapshot.</p></li>
    /// </ul>
    /// <p>If you want your custom rule to be triggered by configuration changes, specify two SourceDetail objects, one for <code>ConfigurationItemChangeNotification</code> and one for <code>OversizedConfigurationItemChangeNotification</code>.</p>
    pub fn get_message_type(&self) -> &::std::option::Option<crate::types::MessageType> {
        &self.message_type
    }
    /// <p>The frequency at which you want Config to run evaluations for a custom rule with a periodic trigger. If you specify a value for <code>MaximumExecutionFrequency</code>, then <code>MessageType</code> must use the <code>ScheduledNotification</code> value.</p><note>
    /// <p>By default, rules with a periodic trigger are evaluated every 24 hours. To change the frequency, specify a valid value for the <code>MaximumExecutionFrequency</code> parameter.</p>
    /// <p>Based on the valid value you choose, Config runs evaluations once for each valid value. For example, if you choose <code>Three_Hours</code>, Config runs evaluations once every three hours. In this case, <code>Three_Hours</code> is the frequency of this rule.</p>
    /// </note>
    pub fn maximum_execution_frequency(mut self, input: crate::types::MaximumExecutionFrequency) -> Self {
        self.maximum_execution_frequency = ::std::option::Option::Some(input);
        self
    }
    /// <p>The frequency at which you want Config to run evaluations for a custom rule with a periodic trigger. If you specify a value for <code>MaximumExecutionFrequency</code>, then <code>MessageType</code> must use the <code>ScheduledNotification</code> value.</p><note>
    /// <p>By default, rules with a periodic trigger are evaluated every 24 hours. To change the frequency, specify a valid value for the <code>MaximumExecutionFrequency</code> parameter.</p>
    /// <p>Based on the valid value you choose, Config runs evaluations once for each valid value. For example, if you choose <code>Three_Hours</code>, Config runs evaluations once every three hours. In this case, <code>Three_Hours</code> is the frequency of this rule.</p>
    /// </note>
    pub fn set_maximum_execution_frequency(mut self, input: ::std::option::Option<crate::types::MaximumExecutionFrequency>) -> Self {
        self.maximum_execution_frequency = input;
        self
    }
    /// <p>The frequency at which you want Config to run evaluations for a custom rule with a periodic trigger. If you specify a value for <code>MaximumExecutionFrequency</code>, then <code>MessageType</code> must use the <code>ScheduledNotification</code> value.</p><note>
    /// <p>By default, rules with a periodic trigger are evaluated every 24 hours. To change the frequency, specify a valid value for the <code>MaximumExecutionFrequency</code> parameter.</p>
    /// <p>Based on the valid value you choose, Config runs evaluations once for each valid value. For example, if you choose <code>Three_Hours</code>, Config runs evaluations once every three hours. In this case, <code>Three_Hours</code> is the frequency of this rule.</p>
    /// </note>
    pub fn get_maximum_execution_frequency(&self) -> &::std::option::Option<crate::types::MaximumExecutionFrequency> {
        &self.maximum_execution_frequency
    }
    /// Consumes the builder and constructs a [`SourceDetail`](crate::types::SourceDetail).
    pub fn build(self) -> crate::types::SourceDetail {
        crate::types::SourceDetail {
            event_source: self.event_source,
            message_type: self.message_type,
            maximum_execution_frequency: self.maximum_execution_frequency,
        }
    }
}
