// Code generated by software.amazon.smithy.rust.codegen.smithy-rs. DO NOT EDIT.

/// <p>Filters evaluation results based on start and end times.</p>
#[non_exhaustive]
#[derive(::std::clone::Clone, ::std::cmp::PartialEq, ::std::fmt::Debug)]
pub struct TimeWindow {
    /// <p>The start time of an execution.</p>
    pub start_time: ::std::option::Option<::aws_smithy_types::DateTime>,
    /// <p>The end time of an execution. The end time must be after the start date.</p>
    pub end_time: ::std::option::Option<::aws_smithy_types::DateTime>,
}
impl TimeWindow {
    /// <p>The start time of an execution.</p>
    pub fn start_time(&self) -> ::std::option::Option<&::aws_smithy_types::DateTime> {
        self.start_time.as_ref()
    }
    /// <p>The end time of an execution. The end time must be after the start date.</p>
    pub fn end_time(&self) -> ::std::option::Option<&::aws_smithy_types::DateTime> {
        self.end_time.as_ref()
    }
}
impl TimeWindow {
    /// Creates a new builder-style object to manufacture [`TimeWindow`](crate::types::TimeWindow).
    pub fn builder() -> crate::types::builders::TimeWindowBuilder {
        crate::types::builders::TimeWindowBuilder::default()
    }
}

/// A builder for [`TimeWindow`](crate::types::TimeWindow).
#[derive(::std::clone::Clone, ::std::cmp::PartialEq, ::std::default::Default, ::std::fmt::Debug)]
#[non_exhaustive]
pub struct TimeWindowBuilder {
    pub(crate) start_time: ::std::option::Option<::aws_smithy_types::DateTime>,
    pub(crate) end_time: ::std::option::Option<::aws_smithy_types::DateTime>,
}
impl TimeWindowBuilder {
    /// <p>The start time of an execution.</p>
    pub fn start_time(mut self, input: ::aws_smithy_types::DateTime) -> Self {
        self.start_time = ::std::option::Option::Some(input);
        self
    }
    /// <p>The start time of an execution.</p>
    pub fn set_start_time(mut self, input: ::std::option::Option<::aws_smithy_types::DateTime>) -> Self {
        self.start_time = input;
        self
    }
    /// <p>The start time of an execution.</p>
    pub fn get_start_time(&self) -> &::std::option::Option<::aws_smithy_types::DateTime> {
        &self.start_time
    }
    /// <p>The end time of an execution. The end time must be after the start date.</p>
    pub fn end_time(mut self, input: ::aws_smithy_types::DateTime) -> Self {
        self.end_time = ::std::option::Option::Some(input);
        self
    }
    /// <p>The end time of an execution. The end time must be after the start date.</p>
    pub fn set_end_time(mut self, input: ::std::option::Option<::aws_smithy_types::DateTime>) -> Self {
        self.end_time = input;
        self
    }
    /// <p>The end time of an execution. The end time must be after the start date.</p>
    pub fn get_end_time(&self) -> &::std::option::Option<::aws_smithy_types::DateTime> {
        &self.end_time
    }
    /// Consumes the builder and constructs a [`TimeWindow`](crate::types::TimeWindow).
    pub fn build(self) -> crate::types::TimeWindow {
        crate::types::TimeWindow {
            start_time: self.start_time,
            end_time: self.end_time,
        }
    }
}
