// Code generated by software.amazon.smithy.rust.codegen.smithy-rs. DO NOT EDIT.

/// <p>For <code>PutConfigurationAggregator</code> API, you can see this exception for the following reasons:</p>
/// <ul>
/// <li>
/// <p>No permission to call <code>EnableAWSServiceAccess</code> API</p></li>
/// <li>
/// <p>The configuration aggregator cannot be updated because your Amazon Web Services Organization management account or the delegated administrator role changed. Delete this aggregator and create a new one with the current Amazon Web Services Organization.</p></li>
/// <li>
/// <p>The configuration aggregator is associated with a previous Amazon Web Services Organization and Config cannot aggregate data with current Amazon Web Services Organization. Delete this aggregator and create a new one with the current Amazon Web Services Organization.</p></li>
/// <li>
/// <p>You are not a registered delegated administrator for Config with permissions to call <code>ListDelegatedAdministrators</code> API. Ensure that the management account registers delagated administrator for Config service principal name before the delegated administrator creates an aggregator.</p></li>
/// </ul>
/// <p>For all <code>OrganizationConfigRule</code> and <code>OrganizationConformancePack</code> APIs, Config throws an exception if APIs are called from member accounts. All APIs must be called from organization management account.</p>
#[non_exhaustive]
#[derive(::std::clone::Clone, ::std::cmp::PartialEq, ::std::fmt::Debug)]
pub struct OrganizationAccessDeniedException {
    /// <p>Error executing the command</p>
    pub message: ::std::option::Option<::std::string::String>,
    pub(crate) meta: ::aws_smithy_types::error::ErrorMetadata,
}
impl OrganizationAccessDeniedException {
    /// Returns the error message.
    pub fn message(&self) -> ::std::option::Option<&str> {
        self.message.as_deref()
    }
}
impl ::std::fmt::Display for OrganizationAccessDeniedException {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        ::std::write!(f, "OrganizationAccessDeniedException")?;
        if let ::std::option::Option::Some(inner_1) = &self.message {
            {
                ::std::write!(f, ": {inner_1}")?;
            }
        }
        Ok(())
    }
}
impl ::std::error::Error for OrganizationAccessDeniedException {}
impl ::aws_types::request_id::RequestId for crate::types::error::OrganizationAccessDeniedException {
    fn request_id(&self) -> Option<&str> {
        use ::aws_smithy_types::error::metadata::ProvideErrorMetadata;
        self.meta().request_id()
    }
}
impl ::aws_smithy_types::error::metadata::ProvideErrorMetadata for OrganizationAccessDeniedException {
    fn meta(&self) -> &::aws_smithy_types::error::ErrorMetadata {
        &self.meta
    }
}
impl OrganizationAccessDeniedException {
    /// Creates a new builder-style object to manufacture [`OrganizationAccessDeniedException`](crate::types::error::OrganizationAccessDeniedException).
    pub fn builder() -> crate::types::error::builders::OrganizationAccessDeniedExceptionBuilder {
        crate::types::error::builders::OrganizationAccessDeniedExceptionBuilder::default()
    }
}

/// A builder for [`OrganizationAccessDeniedException`](crate::types::error::OrganizationAccessDeniedException).
#[derive(::std::clone::Clone, ::std::cmp::PartialEq, ::std::default::Default, ::std::fmt::Debug)]
#[non_exhaustive]
pub struct OrganizationAccessDeniedExceptionBuilder {
    pub(crate) message: ::std::option::Option<::std::string::String>,
    meta: std::option::Option<::aws_smithy_types::error::ErrorMetadata>,
}
impl OrganizationAccessDeniedExceptionBuilder {
    /// <p>Error executing the command</p>
    pub fn message(mut self, input: impl ::std::convert::Into<::std::string::String>) -> Self {
        self.message = ::std::option::Option::Some(input.into());
        self
    }
    /// <p>Error executing the command</p>
    pub fn set_message(mut self, input: ::std::option::Option<::std::string::String>) -> Self {
        self.message = input;
        self
    }
    /// <p>Error executing the command</p>
    pub fn get_message(&self) -> &::std::option::Option<::std::string::String> {
        &self.message
    }
    /// Sets error metadata
    pub fn meta(mut self, meta: ::aws_smithy_types::error::ErrorMetadata) -> Self {
        self.meta = Some(meta);
        self
    }

    /// Sets error metadata
    pub fn set_meta(&mut self, meta: std::option::Option<::aws_smithy_types::error::ErrorMetadata>) -> &mut Self {
        self.meta = meta;
        self
    }
    /// Consumes the builder and constructs a [`OrganizationAccessDeniedException`](crate::types::error::OrganizationAccessDeniedException).
    pub fn build(self) -> crate::types::error::OrganizationAccessDeniedException {
        crate::types::error::OrganizationAccessDeniedException {
            message: self.message,
            meta: self.meta.unwrap_or_default(),
        }
    }
}
