// Copyright 2025 Don MacAskill. Licensed under MIT or Apache-2.0.

//! Pre-generated 16-lane lookup tables for CRC calculations.
//!
//! This file is auto-generated by `cargo run --bin generate_tables`.
//! Do not edit manually.

#![allow(dead_code)]

pub mod crc16 {
    //! CRC-16 lookup tables

    pub static CRC16_ARC_TABLE: [[u16; 256]; 16] = [
        [
            0x0000, 0xc0c1, 0xc181, 0x0140, 0xc301, 0x03c0, 0x0280, 0xc241, 0xc601, 0x06c0, 0x0780,
            0xc741, 0x0500, 0xc5c1, 0xc481, 0x0440, 0xcc01, 0x0cc0, 0x0d80, 0xcd41, 0x0f00, 0xcfc1,
            0xce81, 0x0e40, 0x0a00, 0xcac1, 0xcb81, 0x0b40, 0xc901, 0x09c0, 0x0880, 0xc841, 0xd801,
            0x18c0, 0x1980, 0xd941, 0x1b00, 0xdbc1, 0xda81, 0x1a40, 0x1e00, 0xdec1, 0xdf81, 0x1f40,
            0xdd01, 0x1dc0, 0x1c80, 0xdc41, 0x1400, 0xd4c1, 0xd581, 0x1540, 0xd701, 0x17c0, 0x1680,
            0xd641, 0xd201, 0x12c0, 0x1380, 0xd341, 0x1100, 0xd1c1, 0xd081, 0x1040, 0xf001, 0x30c0,
            0x3180, 0xf141, 0x3300, 0xf3c1, 0xf281, 0x3240, 0x3600, 0xf6c1, 0xf781, 0x3740, 0xf501,
            0x35c0, 0x3480, 0xf441, 0x3c00, 0xfcc1, 0xfd81, 0x3d40, 0xff01, 0x3fc0, 0x3e80, 0xfe41,
            0xfa01, 0x3ac0, 0x3b80, 0xfb41, 0x3900, 0xf9c1, 0xf881, 0x3840, 0x2800, 0xe8c1, 0xe981,
            0x2940, 0xeb01, 0x2bc0, 0x2a80, 0xea41, 0xee01, 0x2ec0, 0x2f80, 0xef41, 0x2d00, 0xedc1,
            0xec81, 0x2c40, 0xe401, 0x24c0, 0x2580, 0xe541, 0x2700, 0xe7c1, 0xe681, 0x2640, 0x2200,
            0xe2c1, 0xe381, 0x2340, 0xe101, 0x21c0, 0x2080, 0xe041, 0xa001, 0x60c0, 0x6180, 0xa141,
            0x6300, 0xa3c1, 0xa281, 0x6240, 0x6600, 0xa6c1, 0xa781, 0x6740, 0xa501, 0x65c0, 0x6480,
            0xa441, 0x6c00, 0xacc1, 0xad81, 0x6d40, 0xaf01, 0x6fc0, 0x6e80, 0xae41, 0xaa01, 0x6ac0,
            0x6b80, 0xab41, 0x6900, 0xa9c1, 0xa881, 0x6840, 0x7800, 0xb8c1, 0xb981, 0x7940, 0xbb01,
            0x7bc0, 0x7a80, 0xba41, 0xbe01, 0x7ec0, 0x7f80, 0xbf41, 0x7d00, 0xbdc1, 0xbc81, 0x7c40,
            0xb401, 0x74c0, 0x7580, 0xb541, 0x7700, 0xb7c1, 0xb681, 0x7640, 0x7200, 0xb2c1, 0xb381,
            0x7340, 0xb101, 0x71c0, 0x7080, 0xb041, 0x5000, 0x90c1, 0x9181, 0x5140, 0x9301, 0x53c0,
            0x5280, 0x9241, 0x9601, 0x56c0, 0x5780, 0x9741, 0x5500, 0x95c1, 0x9481, 0x5440, 0x9c01,
            0x5cc0, 0x5d80, 0x9d41, 0x5f00, 0x9fc1, 0x9e81, 0x5e40, 0x5a00, 0x9ac1, 0x9b81, 0x5b40,
            0x9901, 0x59c0, 0x5880, 0x9841, 0x8801, 0x48c0, 0x4980, 0x8941, 0x4b00, 0x8bc1, 0x8a81,
            0x4a40, 0x4e00, 0x8ec1, 0x8f81, 0x4f40, 0x8d01, 0x4dc0, 0x4c80, 0x8c41, 0x4400, 0x84c1,
            0x8581, 0x4540, 0x8701, 0x47c0, 0x4680, 0x8641, 0x8201, 0x42c0, 0x4380, 0x8341, 0x4100,
            0x81c1, 0x8081, 0x4040,
        ],
        [
            0x0000, 0x9001, 0x6001, 0xf000, 0xc002, 0x5003, 0xa003, 0x3002, 0xc007, 0x5006, 0xa006,
            0x3007, 0x0005, 0x9004, 0x6004, 0xf005, 0xc00d, 0x500c, 0xa00c, 0x300d, 0x000f, 0x900e,
            0x600e, 0xf00f, 0x000a, 0x900b, 0x600b, 0xf00a, 0xc008, 0x5009, 0xa009, 0x3008, 0xc019,
            0x5018, 0xa018, 0x3019, 0x001b, 0x901a, 0x601a, 0xf01b, 0x001e, 0x901f, 0x601f, 0xf01e,
            0xc01c, 0x501d, 0xa01d, 0x301c, 0x0014, 0x9015, 0x6015, 0xf014, 0xc016, 0x5017, 0xa017,
            0x3016, 0xc013, 0x5012, 0xa012, 0x3013, 0x0011, 0x9010, 0x6010, 0xf011, 0xc031, 0x5030,
            0xa030, 0x3031, 0x0033, 0x9032, 0x6032, 0xf033, 0x0036, 0x9037, 0x6037, 0xf036, 0xc034,
            0x5035, 0xa035, 0x3034, 0x003c, 0x903d, 0x603d, 0xf03c, 0xc03e, 0x503f, 0xa03f, 0x303e,
            0xc03b, 0x503a, 0xa03a, 0x303b, 0x0039, 0x9038, 0x6038, 0xf039, 0x0028, 0x9029, 0x6029,
            0xf028, 0xc02a, 0x502b, 0xa02b, 0x302a, 0xc02f, 0x502e, 0xa02e, 0x302f, 0x002d, 0x902c,
            0x602c, 0xf02d, 0xc025, 0x5024, 0xa024, 0x3025, 0x0027, 0x9026, 0x6026, 0xf027, 0x0022,
            0x9023, 0x6023, 0xf022, 0xc020, 0x5021, 0xa021, 0x3020, 0xc061, 0x5060, 0xa060, 0x3061,
            0x0063, 0x9062, 0x6062, 0xf063, 0x0066, 0x9067, 0x6067, 0xf066, 0xc064, 0x5065, 0xa065,
            0x3064, 0x006c, 0x906d, 0x606d, 0xf06c, 0xc06e, 0x506f, 0xa06f, 0x306e, 0xc06b, 0x506a,
            0xa06a, 0x306b, 0x0069, 0x9068, 0x6068, 0xf069, 0x0078, 0x9079, 0x6079, 0xf078, 0xc07a,
            0x507b, 0xa07b, 0x307a, 0xc07f, 0x507e, 0xa07e, 0x307f, 0x007d, 0x907c, 0x607c, 0xf07d,
            0xc075, 0x5074, 0xa074, 0x3075, 0x0077, 0x9076, 0x6076, 0xf077, 0x0072, 0x9073, 0x6073,
            0xf072, 0xc070, 0x5071, 0xa071, 0x3070, 0x0050, 0x9051, 0x6051, 0xf050, 0xc052, 0x5053,
            0xa053, 0x3052, 0xc057, 0x5056, 0xa056, 0x3057, 0x0055, 0x9054, 0x6054, 0xf055, 0xc05d,
            0x505c, 0xa05c, 0x305d, 0x005f, 0x905e, 0x605e, 0xf05f, 0x005a, 0x905b, 0x605b, 0xf05a,
            0xc058, 0x5059, 0xa059, 0x3058, 0xc049, 0x5048, 0xa048, 0x3049, 0x004b, 0x904a, 0x604a,
            0xf04b, 0x004e, 0x904f, 0x604f, 0xf04e, 0xc04c, 0x504d, 0xa04d, 0x304c, 0x0044, 0x9045,
            0x6045, 0xf044, 0xc046, 0x5047, 0xa047, 0x3046, 0xc043, 0x5042, 0xa042, 0x3043, 0x0041,
            0x9040, 0x6040, 0xf041,
        ],
        [
            0x0000, 0xc051, 0xc0a1, 0x00f0, 0xc141, 0x0110, 0x01e0, 0xc1b1, 0xc281, 0x02d0, 0x0220,
            0xc271, 0x03c0, 0xc391, 0xc361, 0x0330, 0xc501, 0x0550, 0x05a0, 0xc5f1, 0x0440, 0xc411,
            0xc4e1, 0x04b0, 0x0780, 0xc7d1, 0xc721, 0x0770, 0xc6c1, 0x0690, 0x0660, 0xc631, 0xca01,
            0x0a50, 0x0aa0, 0xcaf1, 0x0b40, 0xcb11, 0xcbe1, 0x0bb0, 0x0880, 0xc8d1, 0xc821, 0x0870,
            0xc9c1, 0x0990, 0x0960, 0xc931, 0x0f00, 0xcf51, 0xcfa1, 0x0ff0, 0xce41, 0x0e10, 0x0ee0,
            0xceb1, 0xcd81, 0x0dd0, 0x0d20, 0xcd71, 0x0cc0, 0xcc91, 0xcc61, 0x0c30, 0xd401, 0x1450,
            0x14a0, 0xd4f1, 0x1540, 0xd511, 0xd5e1, 0x15b0, 0x1680, 0xd6d1, 0xd621, 0x1670, 0xd7c1,
            0x1790, 0x1760, 0xd731, 0x1100, 0xd151, 0xd1a1, 0x11f0, 0xd041, 0x1010, 0x10e0, 0xd0b1,
            0xd381, 0x13d0, 0x1320, 0xd371, 0x12c0, 0xd291, 0xd261, 0x1230, 0x1e00, 0xde51, 0xdea1,
            0x1ef0, 0xdf41, 0x1f10, 0x1fe0, 0xdfb1, 0xdc81, 0x1cd0, 0x1c20, 0xdc71, 0x1dc0, 0xdd91,
            0xdd61, 0x1d30, 0xdb01, 0x1b50, 0x1ba0, 0xdbf1, 0x1a40, 0xda11, 0xdae1, 0x1ab0, 0x1980,
            0xd9d1, 0xd921, 0x1970, 0xd8c1, 0x1890, 0x1860, 0xd831, 0xe801, 0x2850, 0x28a0, 0xe8f1,
            0x2940, 0xe911, 0xe9e1, 0x29b0, 0x2a80, 0xead1, 0xea21, 0x2a70, 0xebc1, 0x2b90, 0x2b60,
            0xeb31, 0x2d00, 0xed51, 0xeda1, 0x2df0, 0xec41, 0x2c10, 0x2ce0, 0xecb1, 0xef81, 0x2fd0,
            0x2f20, 0xef71, 0x2ec0, 0xee91, 0xee61, 0x2e30, 0x2200, 0xe251, 0xe2a1, 0x22f0, 0xe341,
            0x2310, 0x23e0, 0xe3b1, 0xe081, 0x20d0, 0x2020, 0xe071, 0x21c0, 0xe191, 0xe161, 0x2130,
            0xe701, 0x2750, 0x27a0, 0xe7f1, 0x2640, 0xe611, 0xe6e1, 0x26b0, 0x2580, 0xe5d1, 0xe521,
            0x2570, 0xe4c1, 0x2490, 0x2460, 0xe431, 0x3c00, 0xfc51, 0xfca1, 0x3cf0, 0xfd41, 0x3d10,
            0x3de0, 0xfdb1, 0xfe81, 0x3ed0, 0x3e20, 0xfe71, 0x3fc0, 0xff91, 0xff61, 0x3f30, 0xf901,
            0x3950, 0x39a0, 0xf9f1, 0x3840, 0xf811, 0xf8e1, 0x38b0, 0x3b80, 0xfbd1, 0xfb21, 0x3b70,
            0xfac1, 0x3a90, 0x3a60, 0xfa31, 0xf601, 0x3650, 0x36a0, 0xf6f1, 0x3740, 0xf711, 0xf7e1,
            0x37b0, 0x3480, 0xf4d1, 0xf421, 0x3470, 0xf5c1, 0x3590, 0x3560, 0xf531, 0x3300, 0xf351,
            0xf3a1, 0x33f0, 0xf241, 0x3210, 0x32e0, 0xf2b1, 0xf181, 0x31d0, 0x3120, 0xf171, 0x30c0,
            0xf091, 0xf061, 0x3030,
        ],
        [
            0x0000, 0xfc01, 0xb801, 0x4400, 0x3001, 0xcc00, 0x8800, 0x7401, 0x6002, 0x9c03, 0xd803,
            0x2402, 0x5003, 0xac02, 0xe802, 0x1403, 0xc004, 0x3c05, 0x7805, 0x8404, 0xf005, 0x0c04,
            0x4804, 0xb405, 0xa006, 0x5c07, 0x1807, 0xe406, 0x9007, 0x6c06, 0x2806, 0xd407, 0xc00b,
            0x3c0a, 0x780a, 0x840b, 0xf00a, 0x0c0b, 0x480b, 0xb40a, 0xa009, 0x5c08, 0x1808, 0xe409,
            0x9008, 0x6c09, 0x2809, 0xd408, 0x000f, 0xfc0e, 0xb80e, 0x440f, 0x300e, 0xcc0f, 0x880f,
            0x740e, 0x600d, 0x9c0c, 0xd80c, 0x240d, 0x500c, 0xac0d, 0xe80d, 0x140c, 0xc015, 0x3c14,
            0x7814, 0x8415, 0xf014, 0x0c15, 0x4815, 0xb414, 0xa017, 0x5c16, 0x1816, 0xe417, 0x9016,
            0x6c17, 0x2817, 0xd416, 0x0011, 0xfc10, 0xb810, 0x4411, 0x3010, 0xcc11, 0x8811, 0x7410,
            0x6013, 0x9c12, 0xd812, 0x2413, 0x5012, 0xac13, 0xe813, 0x1412, 0x001e, 0xfc1f, 0xb81f,
            0x441e, 0x301f, 0xcc1e, 0x881e, 0x741f, 0x601c, 0x9c1d, 0xd81d, 0x241c, 0x501d, 0xac1c,
            0xe81c, 0x141d, 0xc01a, 0x3c1b, 0x781b, 0x841a, 0xf01b, 0x0c1a, 0x481a, 0xb41b, 0xa018,
            0x5c19, 0x1819, 0xe418, 0x9019, 0x6c18, 0x2818, 0xd419, 0xc029, 0x3c28, 0x7828, 0x8429,
            0xf028, 0x0c29, 0x4829, 0xb428, 0xa02b, 0x5c2a, 0x182a, 0xe42b, 0x902a, 0x6c2b, 0x282b,
            0xd42a, 0x002d, 0xfc2c, 0xb82c, 0x442d, 0x302c, 0xcc2d, 0x882d, 0x742c, 0x602f, 0x9c2e,
            0xd82e, 0x242f, 0x502e, 0xac2f, 0xe82f, 0x142e, 0x0022, 0xfc23, 0xb823, 0x4422, 0x3023,
            0xcc22, 0x8822, 0x7423, 0x6020, 0x9c21, 0xd821, 0x2420, 0x5021, 0xac20, 0xe820, 0x1421,
            0xc026, 0x3c27, 0x7827, 0x8426, 0xf027, 0x0c26, 0x4826, 0xb427, 0xa024, 0x5c25, 0x1825,
            0xe424, 0x9025, 0x6c24, 0x2824, 0xd425, 0x003c, 0xfc3d, 0xb83d, 0x443c, 0x303d, 0xcc3c,
            0x883c, 0x743d, 0x603e, 0x9c3f, 0xd83f, 0x243e, 0x503f, 0xac3e, 0xe83e, 0x143f, 0xc038,
            0x3c39, 0x7839, 0x8438, 0xf039, 0x0c38, 0x4838, 0xb439, 0xa03a, 0x5c3b, 0x183b, 0xe43a,
            0x903b, 0x6c3a, 0x283a, 0xd43b, 0xc037, 0x3c36, 0x7836, 0x8437, 0xf036, 0x0c37, 0x4837,
            0xb436, 0xa035, 0x5c34, 0x1834, 0xe435, 0x9034, 0x6c35, 0x2835, 0xd434, 0x0033, 0xfc32,
            0xb832, 0x4433, 0x3032, 0xcc33, 0x8833, 0x7432, 0x6031, 0x9c30, 0xd830, 0x2431, 0x5030,
            0xac31, 0xe831, 0x1430,
        ],
        [
            0x0000, 0xc03d, 0xc079, 0x0044, 0xc0f1, 0x00cc, 0x0088, 0xc0b5, 0xc1e1, 0x01dc, 0x0198,
            0xc1a5, 0x0110, 0xc12d, 0xc169, 0x0154, 0xc3c1, 0x03fc, 0x03b8, 0xc385, 0x0330, 0xc30d,
            0xc349, 0x0374, 0x0220, 0xc21d, 0xc259, 0x0264, 0xc2d1, 0x02ec, 0x02a8, 0xc295, 0xc781,
            0x07bc, 0x07f8, 0xc7c5, 0x0770, 0xc74d, 0xc709, 0x0734, 0x0660, 0xc65d, 0xc619, 0x0624,
            0xc691, 0x06ac, 0x06e8, 0xc6d5, 0x0440, 0xc47d, 0xc439, 0x0404, 0xc4b1, 0x048c, 0x04c8,
            0xc4f5, 0xc5a1, 0x059c, 0x05d8, 0xc5e5, 0x0550, 0xc56d, 0xc529, 0x0514, 0xcf01, 0x0f3c,
            0x0f78, 0xcf45, 0x0ff0, 0xcfcd, 0xcf89, 0x0fb4, 0x0ee0, 0xcedd, 0xce99, 0x0ea4, 0xce11,
            0x0e2c, 0x0e68, 0xce55, 0x0cc0, 0xccfd, 0xccb9, 0x0c84, 0xcc31, 0x0c0c, 0x0c48, 0xcc75,
            0xcd21, 0x0d1c, 0x0d58, 0xcd65, 0x0dd0, 0xcded, 0xcda9, 0x0d94, 0x0880, 0xc8bd, 0xc8f9,
            0x08c4, 0xc871, 0x084c, 0x0808, 0xc835, 0xc961, 0x095c, 0x0918, 0xc925, 0x0990, 0xc9ad,
            0xc9e9, 0x09d4, 0xcb41, 0x0b7c, 0x0b38, 0xcb05, 0x0bb0, 0xcb8d, 0xcbc9, 0x0bf4, 0x0aa0,
            0xca9d, 0xcad9, 0x0ae4, 0xca51, 0x0a6c, 0x0a28, 0xca15, 0xde01, 0x1e3c, 0x1e78, 0xde45,
            0x1ef0, 0xdecd, 0xde89, 0x1eb4, 0x1fe0, 0xdfdd, 0xdf99, 0x1fa4, 0xdf11, 0x1f2c, 0x1f68,
            0xdf55, 0x1dc0, 0xddfd, 0xddb9, 0x1d84, 0xdd31, 0x1d0c, 0x1d48, 0xdd75, 0xdc21, 0x1c1c,
            0x1c58, 0xdc65, 0x1cd0, 0xdced, 0xdca9, 0x1c94, 0x1980, 0xd9bd, 0xd9f9, 0x19c4, 0xd971,
            0x194c, 0x1908, 0xd935, 0xd861, 0x185c, 0x1818, 0xd825, 0x1890, 0xd8ad, 0xd8e9, 0x18d4,
            0xda41, 0x1a7c, 0x1a38, 0xda05, 0x1ab0, 0xda8d, 0xdac9, 0x1af4, 0x1ba0, 0xdb9d, 0xdbd9,
            0x1be4, 0xdb51, 0x1b6c, 0x1b28, 0xdb15, 0x1100, 0xd13d, 0xd179, 0x1144, 0xd1f1, 0x11cc,
            0x1188, 0xd1b5, 0xd0e1, 0x10dc, 0x1098, 0xd0a5, 0x1010, 0xd02d, 0xd069, 0x1054, 0xd2c1,
            0x12fc, 0x12b8, 0xd285, 0x1230, 0xd20d, 0xd249, 0x1274, 0x1320, 0xd31d, 0xd359, 0x1364,
            0xd3d1, 0x13ec, 0x13a8, 0xd395, 0xd681, 0x16bc, 0x16f8, 0xd6c5, 0x1670, 0xd64d, 0xd609,
            0x1634, 0x1760, 0xd75d, 0xd719, 0x1724, 0xd791, 0x17ac, 0x17e8, 0xd7d5, 0x1540, 0xd57d,
            0xd539, 0x1504, 0xd5b1, 0x158c, 0x15c8, 0xd5f5, 0xd4a1, 0x149c, 0x14d8, 0xd4e5, 0x1450,
            0xd46d, 0xd429, 0x1414,
        ],
        [
            0x0000, 0xd101, 0xe201, 0x3300, 0x8401, 0x5500, 0x6600, 0xb701, 0x4801, 0x9900, 0xaa00,
            0x7b01, 0xcc00, 0x1d01, 0x2e01, 0xff00, 0x9002, 0x4103, 0x7203, 0xa302, 0x1403, 0xc502,
            0xf602, 0x2703, 0xd803, 0x0902, 0x3a02, 0xeb03, 0x5c02, 0x8d03, 0xbe03, 0x6f02, 0x6007,
            0xb106, 0x8206, 0x5307, 0xe406, 0x3507, 0x0607, 0xd706, 0x2806, 0xf907, 0xca07, 0x1b06,
            0xac07, 0x7d06, 0x4e06, 0x9f07, 0xf005, 0x2104, 0x1204, 0xc305, 0x7404, 0xa505, 0x9605,
            0x4704, 0xb804, 0x6905, 0x5a05, 0x8b04, 0x3c05, 0xed04, 0xde04, 0x0f05, 0xc00e, 0x110f,
            0x220f, 0xf30e, 0x440f, 0x950e, 0xa60e, 0x770f, 0x880f, 0x590e, 0x6a0e, 0xbb0f, 0x0c0e,
            0xdd0f, 0xee0f, 0x3f0e, 0x500c, 0x810d, 0xb20d, 0x630c, 0xd40d, 0x050c, 0x360c, 0xe70d,
            0x180d, 0xc90c, 0xfa0c, 0x2b0d, 0x9c0c, 0x4d0d, 0x7e0d, 0xaf0c, 0xa009, 0x7108, 0x4208,
            0x9309, 0x2408, 0xf509, 0xc609, 0x1708, 0xe808, 0x3909, 0x0a09, 0xdb08, 0x6c09, 0xbd08,
            0x8e08, 0x5f09, 0x300b, 0xe10a, 0xd20a, 0x030b, 0xb40a, 0x650b, 0x560b, 0x870a, 0x780a,
            0xa90b, 0x9a0b, 0x4b0a, 0xfc0b, 0x2d0a, 0x1e0a, 0xcf0b, 0xc01f, 0x111e, 0x221e, 0xf31f,
            0x441e, 0x951f, 0xa61f, 0x771e, 0x881e, 0x591f, 0x6a1f, 0xbb1e, 0x0c1f, 0xdd1e, 0xee1e,
            0x3f1f, 0x501d, 0x811c, 0xb21c, 0x631d, 0xd41c, 0x051d, 0x361d, 0xe71c, 0x181c, 0xc91d,
            0xfa1d, 0x2b1c, 0x9c1d, 0x4d1c, 0x7e1c, 0xaf1d, 0xa018, 0x7119, 0x4219, 0x9318, 0x2419,
            0xf518, 0xc618, 0x1719, 0xe819, 0x3918, 0x0a18, 0xdb19, 0x6c18, 0xbd19, 0x8e19, 0x5f18,
            0x301a, 0xe11b, 0xd21b, 0x031a, 0xb41b, 0x651a, 0x561a, 0x871b, 0x781b, 0xa91a, 0x9a1a,
            0x4b1b, 0xfc1a, 0x2d1b, 0x1e1b, 0xcf1a, 0x0011, 0xd110, 0xe210, 0x3311, 0x8410, 0x5511,
            0x6611, 0xb710, 0x4810, 0x9911, 0xaa11, 0x7b10, 0xcc11, 0x1d10, 0x2e10, 0xff11, 0x9013,
            0x4112, 0x7212, 0xa313, 0x1412, 0xc513, 0xf613, 0x2712, 0xd812, 0x0913, 0x3a13, 0xeb12,
            0x5c13, 0x8d12, 0xbe12, 0x6f13, 0x6016, 0xb117, 0x8217, 0x5316, 0xe417, 0x3516, 0x0616,
            0xd717, 0x2817, 0xf916, 0xca16, 0x1b17, 0xac16, 0x7d17, 0x4e17, 0x9f16, 0xf014, 0x2115,
            0x1215, 0xc314, 0x7415, 0xa514, 0x9614, 0x4715, 0xb815, 0x6914, 0x5a14, 0x8b15, 0x3c14,
            0xed15, 0xde15, 0x0f14,
        ],
        [
            0x0000, 0xc010, 0xc023, 0x0033, 0xc045, 0x0055, 0x0066, 0xc076, 0xc089, 0x0099, 0x00aa,
            0xc0ba, 0x00cc, 0xc0dc, 0xc0ef, 0x00ff, 0xc111, 0x0101, 0x0132, 0xc122, 0x0154, 0xc144,
            0xc177, 0x0167, 0x0198, 0xc188, 0xc1bb, 0x01ab, 0xc1dd, 0x01cd, 0x01fe, 0xc1ee, 0xc221,
            0x0231, 0x0202, 0xc212, 0x0264, 0xc274, 0xc247, 0x0257, 0x02a8, 0xc2b8, 0xc28b, 0x029b,
            0xc2ed, 0x02fd, 0x02ce, 0xc2de, 0x0330, 0xc320, 0xc313, 0x0303, 0xc375, 0x0365, 0x0356,
            0xc346, 0xc3b9, 0x03a9, 0x039a, 0xc38a, 0x03fc, 0xc3ec, 0xc3df, 0x03cf, 0xc441, 0x0451,
            0x0462, 0xc472, 0x0404, 0xc414, 0xc427, 0x0437, 0x04c8, 0xc4d8, 0xc4eb, 0x04fb, 0xc48d,
            0x049d, 0x04ae, 0xc4be, 0x0550, 0xc540, 0xc573, 0x0563, 0xc515, 0x0505, 0x0536, 0xc526,
            0xc5d9, 0x05c9, 0x05fa, 0xc5ea, 0x059c, 0xc58c, 0xc5bf, 0x05af, 0x0660, 0xc670, 0xc643,
            0x0653, 0xc625, 0x0635, 0x0606, 0xc616, 0xc6e9, 0x06f9, 0x06ca, 0xc6da, 0x06ac, 0xc6bc,
            0xc68f, 0x069f, 0xc771, 0x0761, 0x0752, 0xc742, 0x0734, 0xc724, 0xc717, 0x0707, 0x07f8,
            0xc7e8, 0xc7db, 0x07cb, 0xc7bd, 0x07ad, 0x079e, 0xc78e, 0xc881, 0x0891, 0x08a2, 0xc8b2,
            0x08c4, 0xc8d4, 0xc8e7, 0x08f7, 0x0808, 0xc818, 0xc82b, 0x083b, 0xc84d, 0x085d, 0x086e,
            0xc87e, 0x0990, 0xc980, 0xc9b3, 0x09a3, 0xc9d5, 0x09c5, 0x09f6, 0xc9e6, 0xc919, 0x0909,
            0x093a, 0xc92a, 0x095c, 0xc94c, 0xc97f, 0x096f, 0x0aa0, 0xcab0, 0xca83, 0x0a93, 0xcae5,
            0x0af5, 0x0ac6, 0xcad6, 0xca29, 0x0a39, 0x0a0a, 0xca1a, 0x0a6c, 0xca7c, 0xca4f, 0x0a5f,
            0xcbb1, 0x0ba1, 0x0b92, 0xcb82, 0x0bf4, 0xcbe4, 0xcbd7, 0x0bc7, 0x0b38, 0xcb28, 0xcb1b,
            0x0b0b, 0xcb7d, 0x0b6d, 0x0b5e, 0xcb4e, 0x0cc0, 0xccd0, 0xcce3, 0x0cf3, 0xcc85, 0x0c95,
            0x0ca6, 0xccb6, 0xcc49, 0x0c59, 0x0c6a, 0xcc7a, 0x0c0c, 0xcc1c, 0xcc2f, 0x0c3f, 0xcdd1,
            0x0dc1, 0x0df2, 0xcde2, 0x0d94, 0xcd84, 0xcdb7, 0x0da7, 0x0d58, 0xcd48, 0xcd7b, 0x0d6b,
            0xcd1d, 0x0d0d, 0x0d3e, 0xcd2e, 0xcee1, 0x0ef1, 0x0ec2, 0xced2, 0x0ea4, 0xceb4, 0xce87,
            0x0e97, 0x0e68, 0xce78, 0xce4b, 0x0e5b, 0xce2d, 0x0e3d, 0x0e0e, 0xce1e, 0x0ff0, 0xcfe0,
            0xcfd3, 0x0fc3, 0xcfb5, 0x0fa5, 0x0f96, 0xcf86, 0xcf79, 0x0f69, 0x0f5a, 0xcf4a, 0x0f3c,
            0xcf2c, 0xcf1f, 0x0f0f,
        ],
        [
            0x0000, 0xccc1, 0xd981, 0x1540, 0xf301, 0x3fc0, 0x2a80, 0xe641, 0xa601, 0x6ac0, 0x7f80,
            0xb341, 0x5500, 0x99c1, 0x8c81, 0x4040, 0x0c01, 0xc0c0, 0xd580, 0x1941, 0xff00, 0x33c1,
            0x2681, 0xea40, 0xaa00, 0x66c1, 0x7381, 0xbf40, 0x5901, 0x95c0, 0x8080, 0x4c41, 0x1802,
            0xd4c3, 0xc183, 0x0d42, 0xeb03, 0x27c2, 0x3282, 0xfe43, 0xbe03, 0x72c2, 0x6782, 0xab43,
            0x4d02, 0x81c3, 0x9483, 0x5842, 0x1403, 0xd8c2, 0xcd82, 0x0143, 0xe702, 0x2bc3, 0x3e83,
            0xf242, 0xb202, 0x7ec3, 0x6b83, 0xa742, 0x4103, 0x8dc2, 0x9882, 0x5443, 0x3004, 0xfcc5,
            0xe985, 0x2544, 0xc305, 0x0fc4, 0x1a84, 0xd645, 0x9605, 0x5ac4, 0x4f84, 0x8345, 0x6504,
            0xa9c5, 0xbc85, 0x7044, 0x3c05, 0xf0c4, 0xe584, 0x2945, 0xcf04, 0x03c5, 0x1685, 0xda44,
            0x9a04, 0x56c5, 0x4385, 0x8f44, 0x6905, 0xa5c4, 0xb084, 0x7c45, 0x2806, 0xe4c7, 0xf187,
            0x3d46, 0xdb07, 0x17c6, 0x0286, 0xce47, 0x8e07, 0x42c6, 0x5786, 0x9b47, 0x7d06, 0xb1c7,
            0xa487, 0x6846, 0x2407, 0xe8c6, 0xfd86, 0x3147, 0xd706, 0x1bc7, 0x0e87, 0xc246, 0x8206,
            0x4ec7, 0x5b87, 0x9746, 0x7107, 0xbdc6, 0xa886, 0x6447, 0x6008, 0xacc9, 0xb989, 0x7548,
            0x9309, 0x5fc8, 0x4a88, 0x8649, 0xc609, 0x0ac8, 0x1f88, 0xd349, 0x3508, 0xf9c9, 0xec89,
            0x2048, 0x6c09, 0xa0c8, 0xb588, 0x7949, 0x9f08, 0x53c9, 0x4689, 0x8a48, 0xca08, 0x06c9,
            0x1389, 0xdf48, 0x3909, 0xf5c8, 0xe088, 0x2c49, 0x780a, 0xb4cb, 0xa18b, 0x6d4a, 0x8b0b,
            0x47ca, 0x528a, 0x9e4b, 0xde0b, 0x12ca, 0x078a, 0xcb4b, 0x2d0a, 0xe1cb, 0xf48b, 0x384a,
            0x740b, 0xb8ca, 0xad8a, 0x614b, 0x870a, 0x4bcb, 0x5e8b, 0x924a, 0xd20a, 0x1ecb, 0x0b8b,
            0xc74a, 0x210b, 0xedca, 0xf88a, 0x344b, 0x500c, 0x9ccd, 0x898d, 0x454c, 0xa30d, 0x6fcc,
            0x7a8c, 0xb64d, 0xf60d, 0x3acc, 0x2f8c, 0xe34d, 0x050c, 0xc9cd, 0xdc8d, 0x104c, 0x5c0d,
            0x90cc, 0x858c, 0x494d, 0xaf0c, 0x63cd, 0x768d, 0xba4c, 0xfa0c, 0x36cd, 0x238d, 0xef4c,
            0x090d, 0xc5cc, 0xd08c, 0x1c4d, 0x480e, 0x84cf, 0x918f, 0x5d4e, 0xbb0f, 0x77ce, 0x628e,
            0xae4f, 0xee0f, 0x22ce, 0x378e, 0xfb4f, 0x1d0e, 0xd1cf, 0xc48f, 0x084e, 0x440f, 0x88ce,
            0x9d8e, 0x514f, 0xb70e, 0x7bcf, 0x6e8f, 0xa24e, 0xe20e, 0x2ecf, 0x3b8f, 0xf74e, 0x110f,
            0xddce, 0xc88e, 0x044f,
        ],
        [
            0x0000, 0x900d, 0x6019, 0xf014, 0xc032, 0x503f, 0xa02b, 0x3026, 0xc067, 0x506a, 0xa07e,
            0x3073, 0x0055, 0x9058, 0x604c, 0xf041, 0xc0cd, 0x50c0, 0xa0d4, 0x30d9, 0x00ff, 0x90f2,
            0x60e6, 0xf0eb, 0x00aa, 0x90a7, 0x60b3, 0xf0be, 0xc098, 0x5095, 0xa081, 0x308c, 0xc199,
            0x5194, 0xa180, 0x318d, 0x01ab, 0x91a6, 0x61b2, 0xf1bf, 0x01fe, 0x91f3, 0x61e7, 0xf1ea,
            0xc1cc, 0x51c1, 0xa1d5, 0x31d8, 0x0154, 0x9159, 0x614d, 0xf140, 0xc166, 0x516b, 0xa17f,
            0x3172, 0xc133, 0x513e, 0xa12a, 0x3127, 0x0101, 0x910c, 0x6118, 0xf115, 0xc331, 0x533c,
            0xa328, 0x3325, 0x0303, 0x930e, 0x631a, 0xf317, 0x0356, 0x935b, 0x634f, 0xf342, 0xc364,
            0x5369, 0xa37d, 0x3370, 0x03fc, 0x93f1, 0x63e5, 0xf3e8, 0xc3ce, 0x53c3, 0xa3d7, 0x33da,
            0xc39b, 0x5396, 0xa382, 0x338f, 0x03a9, 0x93a4, 0x63b0, 0xf3bd, 0x02a8, 0x92a5, 0x62b1,
            0xf2bc, 0xc29a, 0x5297, 0xa283, 0x328e, 0xc2cf, 0x52c2, 0xa2d6, 0x32db, 0x02fd, 0x92f0,
            0x62e4, 0xf2e9, 0xc265, 0x5268, 0xa27c, 0x3271, 0x0257, 0x925a, 0x624e, 0xf243, 0x0202,
            0x920f, 0x621b, 0xf216, 0xc230, 0x523d, 0xa229, 0x3224, 0xc661, 0x566c, 0xa678, 0x3675,
            0x0653, 0x965e, 0x664a, 0xf647, 0x0606, 0x960b, 0x661f, 0xf612, 0xc634, 0x5639, 0xa62d,
            0x3620, 0x06ac, 0x96a1, 0x66b5, 0xf6b8, 0xc69e, 0x5693, 0xa687, 0x368a, 0xc6cb, 0x56c6,
            0xa6d2, 0x36df, 0x06f9, 0x96f4, 0x66e0, 0xf6ed, 0x07f8, 0x97f5, 0x67e1, 0xf7ec, 0xc7ca,
            0x57c7, 0xa7d3, 0x37de, 0xc79f, 0x5792, 0xa786, 0x378b, 0x07ad, 0x97a0, 0x67b4, 0xf7b9,
            0xc735, 0x5738, 0xa72c, 0x3721, 0x0707, 0x970a, 0x671e, 0xf713, 0x0752, 0x975f, 0x674b,
            0xf746, 0xc760, 0x576d, 0xa779, 0x3774, 0x0550, 0x955d, 0x6549, 0xf544, 0xc562, 0x556f,
            0xa57b, 0x3576, 0xc537, 0x553a, 0xa52e, 0x3523, 0x0505, 0x9508, 0x651c, 0xf511, 0xc59d,
            0x5590, 0xa584, 0x3589, 0x05af, 0x95a2, 0x65b6, 0xf5bb, 0x05fa, 0x95f7, 0x65e3, 0xf5ee,
            0xc5c8, 0x55c5, 0xa5d1, 0x35dc, 0xc4c9, 0x54c4, 0xa4d0, 0x34dd, 0x04fb, 0x94f6, 0x64e2,
            0xf4ef, 0x04ae, 0x94a3, 0x64b7, 0xf4ba, 0xc49c, 0x5491, 0xa485, 0x3488, 0x0404, 0x9409,
            0x641d, 0xf410, 0xc436, 0x543b, 0xa42f, 0x3422, 0xc463, 0x546e, 0xa47a, 0x3477, 0x0451,
            0x945c, 0x6448, 0xf445,
        ],
        [
            0x0000, 0xc551, 0xcaa1, 0x0ff0, 0xd541, 0x1010, 0x1fe0, 0xdab1, 0xea81, 0x2fd0, 0x2020,
            0xe571, 0x3fc0, 0xfa91, 0xf561, 0x3030, 0x9501, 0x5050, 0x5fa0, 0x9af1, 0x4040, 0x8511,
            0x8ae1, 0x4fb0, 0x7f80, 0xbad1, 0xb521, 0x7070, 0xaac1, 0x6f90, 0x6060, 0xa531, 0x6a01,
            0xaf50, 0xa0a0, 0x65f1, 0xbf40, 0x7a11, 0x75e1, 0xb0b0, 0x8080, 0x45d1, 0x4a21, 0x8f70,
            0x55c1, 0x9090, 0x9f60, 0x5a31, 0xff00, 0x3a51, 0x35a1, 0xf0f0, 0x2a41, 0xef10, 0xe0e0,
            0x25b1, 0x1581, 0xd0d0, 0xdf20, 0x1a71, 0xc0c0, 0x0591, 0x0a61, 0xcf30, 0xd402, 0x1153,
            0x1ea3, 0xdbf2, 0x0143, 0xc412, 0xcbe2, 0x0eb3, 0x3e83, 0xfbd2, 0xf422, 0x3173, 0xebc2,
            0x2e93, 0x2163, 0xe432, 0x4103, 0x8452, 0x8ba2, 0x4ef3, 0x9442, 0x5113, 0x5ee3, 0x9bb2,
            0xab82, 0x6ed3, 0x6123, 0xa472, 0x7ec3, 0xbb92, 0xb462, 0x7133, 0xbe03, 0x7b52, 0x74a2,
            0xb1f3, 0x6b42, 0xae13, 0xa1e3, 0x64b2, 0x5482, 0x91d3, 0x9e23, 0x5b72, 0x81c3, 0x4492,
            0x4b62, 0x8e33, 0x2b02, 0xee53, 0xe1a3, 0x24f2, 0xfe43, 0x3b12, 0x34e2, 0xf1b3, 0xc183,
            0x04d2, 0x0b22, 0xce73, 0x14c2, 0xd193, 0xde63, 0x1b32, 0xe807, 0x2d56, 0x22a6, 0xe7f7,
            0x3d46, 0xf817, 0xf7e7, 0x32b6, 0x0286, 0xc7d7, 0xc827, 0x0d76, 0xd7c7, 0x1296, 0x1d66,
            0xd837, 0x7d06, 0xb857, 0xb7a7, 0x72f6, 0xa847, 0x6d16, 0x62e6, 0xa7b7, 0x9787, 0x52d6,
            0x5d26, 0x9877, 0x42c6, 0x8797, 0x8867, 0x4d36, 0x8206, 0x4757, 0x48a7, 0x8df6, 0x5747,
            0x9216, 0x9de6, 0x58b7, 0x6887, 0xadd6, 0xa226, 0x6777, 0xbdc6, 0x7897, 0x7767, 0xb236,
            0x1707, 0xd256, 0xdda6, 0x18f7, 0xc246, 0x0717, 0x08e7, 0xcdb6, 0xfd86, 0x38d7, 0x3727,
            0xf276, 0x28c7, 0xed96, 0xe266, 0x2737, 0x3c05, 0xf954, 0xf6a4, 0x33f5, 0xe944, 0x2c15,
            0x23e5, 0xe6b4, 0xd684, 0x13d5, 0x1c25, 0xd974, 0x03c5, 0xc694, 0xc964, 0x0c35, 0xa904,
            0x6c55, 0x63a5, 0xa6f4, 0x7c45, 0xb914, 0xb6e4, 0x73b5, 0x4385, 0x86d4, 0x8924, 0x4c75,
            0x96c4, 0x5395, 0x5c65, 0x9934, 0x5604, 0x9355, 0x9ca5, 0x59f4, 0x8345, 0x4614, 0x49e4,
            0x8cb5, 0xbc85, 0x79d4, 0x7624, 0xb375, 0x69c4, 0xac95, 0xa365, 0x6634, 0xc305, 0x0654,
            0x09a4, 0xccf5, 0x1644, 0xd315, 0xdce5, 0x19b4, 0x2984, 0xecd5, 0xe325, 0x2674, 0xfcc5,
            0x3994, 0x3664, 0xf335,
        ],
        [
            0x0000, 0xfc04, 0xb80b, 0x440f, 0x3015, 0xcc11, 0x881e, 0x741a, 0x602a, 0x9c2e, 0xd821,
            0x2425, 0x503f, 0xac3b, 0xe834, 0x1430, 0xc054, 0x3c50, 0x785f, 0x845b, 0xf041, 0x0c45,
            0x484a, 0xb44e, 0xa07e, 0x5c7a, 0x1875, 0xe471, 0x906b, 0x6c6f, 0x2860, 0xd464, 0xc0ab,
            0x3caf, 0x78a0, 0x84a4, 0xf0be, 0x0cba, 0x48b5, 0xb4b1, 0xa081, 0x5c85, 0x188a, 0xe48e,
            0x9094, 0x6c90, 0x289f, 0xd49b, 0x00ff, 0xfcfb, 0xb8f4, 0x44f0, 0x30ea, 0xccee, 0x88e1,
            0x74e5, 0x60d5, 0x9cd1, 0xd8de, 0x24da, 0x50c0, 0xacc4, 0xe8cb, 0x14cf, 0xc155, 0x3d51,
            0x795e, 0x855a, 0xf140, 0x0d44, 0x494b, 0xb54f, 0xa17f, 0x5d7b, 0x1974, 0xe570, 0x916a,
            0x6d6e, 0x2961, 0xd565, 0x0101, 0xfd05, 0xb90a, 0x450e, 0x3114, 0xcd10, 0x891f, 0x751b,
            0x612b, 0x9d2f, 0xd920, 0x2524, 0x513e, 0xad3a, 0xe935, 0x1531, 0x01fe, 0xfdfa, 0xb9f5,
            0x45f1, 0x31eb, 0xcdef, 0x89e0, 0x75e4, 0x61d4, 0x9dd0, 0xd9df, 0x25db, 0x51c1, 0xadc5,
            0xe9ca, 0x15ce, 0xc1aa, 0x3dae, 0x79a1, 0x85a5, 0xf1bf, 0x0dbb, 0x49b4, 0xb5b0, 0xa180,
            0x5d84, 0x198b, 0xe58f, 0x9195, 0x6d91, 0x299e, 0xd59a, 0xc2a9, 0x3ead, 0x7aa2, 0x86a6,
            0xf2bc, 0x0eb8, 0x4ab7, 0xb6b3, 0xa283, 0x5e87, 0x1a88, 0xe68c, 0x9296, 0x6e92, 0x2a9d,
            0xd699, 0x02fd, 0xfef9, 0xbaf6, 0x46f2, 0x32e8, 0xceec, 0x8ae3, 0x76e7, 0x62d7, 0x9ed3,
            0xdadc, 0x26d8, 0x52c2, 0xaec6, 0xeac9, 0x16cd, 0x0202, 0xfe06, 0xba09, 0x460d, 0x3217,
            0xce13, 0x8a1c, 0x7618, 0x6228, 0x9e2c, 0xda23, 0x2627, 0x523d, 0xae39, 0xea36, 0x1632,
            0xc256, 0x3e52, 0x7a5d, 0x8659, 0xf243, 0x0e47, 0x4a48, 0xb64c, 0xa27c, 0x5e78, 0x1a77,
            0xe673, 0x9269, 0x6e6d, 0x2a62, 0xd666, 0x03fc, 0xfff8, 0xbbf7, 0x47f3, 0x33e9, 0xcfed,
            0x8be2, 0x77e6, 0x63d6, 0x9fd2, 0xdbdd, 0x27d9, 0x53c3, 0xafc7, 0xebc8, 0x17cc, 0xc3a8,
            0x3fac, 0x7ba3, 0x87a7, 0xf3bd, 0x0fb9, 0x4bb6, 0xb7b2, 0xa382, 0x5f86, 0x1b89, 0xe78d,
            0x9397, 0x6f93, 0x2b9c, 0xd798, 0xc357, 0x3f53, 0x7b5c, 0x8758, 0xf342, 0x0f46, 0x4b49,
            0xb74d, 0xa37d, 0x5f79, 0x1b76, 0xe772, 0x9368, 0x6f6c, 0x2b63, 0xd767, 0x0303, 0xff07,
            0xbb08, 0x470c, 0x3316, 0xcf12, 0x8b1d, 0x7719, 0x6329, 0x9f2d, 0xdb22, 0x2726, 0x533c,
            0xaf38, 0xeb37, 0x1733,
        ],
        [
            0x0000, 0xc3fd, 0xc7f9, 0x0404, 0xcff1, 0x0c0c, 0x0808, 0xcbf5, 0xdfe1, 0x1c1c, 0x1818,
            0xdbe5, 0x1010, 0xd3ed, 0xd7e9, 0x1414, 0xffc1, 0x3c3c, 0x3838, 0xfbc5, 0x3030, 0xf3cd,
            0xf7c9, 0x3434, 0x2020, 0xe3dd, 0xe7d9, 0x2424, 0xefd1, 0x2c2c, 0x2828, 0xebd5, 0xbf81,
            0x7c7c, 0x7878, 0xbb85, 0x7070, 0xb38d, 0xb789, 0x7474, 0x6060, 0xa39d, 0xa799, 0x6464,
            0xaf91, 0x6c6c, 0x6868, 0xab95, 0x4040, 0x83bd, 0x87b9, 0x4444, 0x8fb1, 0x4c4c, 0x4848,
            0x8bb5, 0x9fa1, 0x5c5c, 0x5858, 0x9ba5, 0x5050, 0x93ad, 0x97a9, 0x5454, 0x3f01, 0xfcfc,
            0xf8f8, 0x3b05, 0xf0f0, 0x330d, 0x3709, 0xf4f4, 0xe0e0, 0x231d, 0x2719, 0xe4e4, 0x2f11,
            0xecec, 0xe8e8, 0x2b15, 0xc0c0, 0x033d, 0x0739, 0xc4c4, 0x0f31, 0xcccc, 0xc8c8, 0x0b35,
            0x1f21, 0xdcdc, 0xd8d8, 0x1b25, 0xd0d0, 0x132d, 0x1729, 0xd4d4, 0x8080, 0x437d, 0x4779,
            0x8484, 0x4f71, 0x8c8c, 0x8888, 0x4b75, 0x5f61, 0x9c9c, 0x9898, 0x5b65, 0x9090, 0x536d,
            0x5769, 0x9494, 0x7f41, 0xbcbc, 0xb8b8, 0x7b45, 0xb0b0, 0x734d, 0x7749, 0xb4b4, 0xa0a0,
            0x635d, 0x6759, 0xa4a4, 0x6f51, 0xacac, 0xa8a8, 0x6b55, 0x7e02, 0xbdff, 0xb9fb, 0x7a06,
            0xb1f3, 0x720e, 0x760a, 0xb5f7, 0xa1e3, 0x621e, 0x661a, 0xa5e7, 0x6e12, 0xadef, 0xa9eb,
            0x6a16, 0x81c3, 0x423e, 0x463a, 0x85c7, 0x4e32, 0x8dcf, 0x89cb, 0x4a36, 0x5e22, 0x9ddf,
            0x99db, 0x5a26, 0x91d3, 0x522e, 0x562a, 0x95d7, 0xc183, 0x027e, 0x067a, 0xc587, 0x0e72,
            0xcd8f, 0xc98b, 0x0a76, 0x1e62, 0xdd9f, 0xd99b, 0x1a66, 0xd193, 0x126e, 0x166a, 0xd597,
            0x3e42, 0xfdbf, 0xf9bb, 0x3a46, 0xf1b3, 0x324e, 0x364a, 0xf5b7, 0xe1a3, 0x225e, 0x265a,
            0xe5a7, 0x2e52, 0xedaf, 0xe9ab, 0x2a56, 0x4103, 0x82fe, 0x86fa, 0x4507, 0x8ef2, 0x4d0f,
            0x490b, 0x8af6, 0x9ee2, 0x5d1f, 0x591b, 0x9ae6, 0x5113, 0x92ee, 0x96ea, 0x5517, 0xbec2,
            0x7d3f, 0x793b, 0xbac6, 0x7133, 0xb2ce, 0xb6ca, 0x7537, 0x6123, 0xa2de, 0xa6da, 0x6527,
            0xaed2, 0x6d2f, 0x692b, 0xaad6, 0xfe82, 0x3d7f, 0x397b, 0xfa86, 0x3173, 0xf28e, 0xf68a,
            0x3577, 0x2163, 0xe29e, 0xe69a, 0x2567, 0xee92, 0x2d6f, 0x296b, 0xea96, 0x0143, 0xc2be,
            0xc6ba, 0x0547, 0xceb2, 0x0d4f, 0x094b, 0xcab6, 0xdea2, 0x1d5f, 0x195b, 0xdaa6, 0x1153,
            0xd2ae, 0xd6aa, 0x1557,
        ],
        [
            0x0000, 0x8102, 0x4207, 0xc305, 0x840e, 0x050c, 0xc609, 0x470b, 0x481f, 0xc91d, 0x0a18,
            0x8b1a, 0xcc11, 0x4d13, 0x8e16, 0x0f14, 0x903e, 0x113c, 0xd239, 0x533b, 0x1430, 0x9532,
            0x5637, 0xd735, 0xd821, 0x5923, 0x9a26, 0x1b24, 0x5c2f, 0xdd2d, 0x1e28, 0x9f2a, 0x607f,
            0xe17d, 0x2278, 0xa37a, 0xe471, 0x6573, 0xa676, 0x2774, 0x2860, 0xa962, 0x6a67, 0xeb65,
            0xac6e, 0x2d6c, 0xee69, 0x6f6b, 0xf041, 0x7143, 0xb246, 0x3344, 0x744f, 0xf54d, 0x3648,
            0xb74a, 0xb85e, 0x395c, 0xfa59, 0x7b5b, 0x3c50, 0xbd52, 0x7e57, 0xff55, 0xc0fe, 0x41fc,
            0x82f9, 0x03fb, 0x44f0, 0xc5f2, 0x06f7, 0x87f5, 0x88e1, 0x09e3, 0xcae6, 0x4be4, 0x0cef,
            0x8ded, 0x4ee8, 0xcfea, 0x50c0, 0xd1c2, 0x12c7, 0x93c5, 0xd4ce, 0x55cc, 0x96c9, 0x17cb,
            0x18df, 0x99dd, 0x5ad8, 0xdbda, 0x9cd1, 0x1dd3, 0xded6, 0x5fd4, 0xa081, 0x2183, 0xe286,
            0x6384, 0x248f, 0xa58d, 0x6688, 0xe78a, 0xe89e, 0x699c, 0xaa99, 0x2b9b, 0x6c90, 0xed92,
            0x2e97, 0xaf95, 0x30bf, 0xb1bd, 0x72b8, 0xf3ba, 0xb4b1, 0x35b3, 0xf6b6, 0x77b4, 0x78a0,
            0xf9a2, 0x3aa7, 0xbba5, 0xfcae, 0x7dac, 0xbea9, 0x3fab, 0xc1ff, 0x40fd, 0x83f8, 0x02fa,
            0x45f1, 0xc4f3, 0x07f6, 0x86f4, 0x89e0, 0x08e2, 0xcbe7, 0x4ae5, 0x0dee, 0x8cec, 0x4fe9,
            0xceeb, 0x51c1, 0xd0c3, 0x13c6, 0x92c4, 0xd5cf, 0x54cd, 0x97c8, 0x16ca, 0x19de, 0x98dc,
            0x5bd9, 0xdadb, 0x9dd0, 0x1cd2, 0xdfd7, 0x5ed5, 0xa180, 0x2082, 0xe387, 0x6285, 0x258e,
            0xa48c, 0x6789, 0xe68b, 0xe99f, 0x689d, 0xab98, 0x2a9a, 0x6d91, 0xec93, 0x2f96, 0xae94,
            0x31be, 0xb0bc, 0x73b9, 0xf2bb, 0xb5b0, 0x34b2, 0xf7b7, 0x76b5, 0x79a1, 0xf8a3, 0x3ba6,
            0xbaa4, 0xfdaf, 0x7cad, 0xbfa8, 0x3eaa, 0x0101, 0x8003, 0x4306, 0xc204, 0x850f, 0x040d,
            0xc708, 0x460a, 0x491e, 0xc81c, 0x0b19, 0x8a1b, 0xcd10, 0x4c12, 0x8f17, 0x0e15, 0x913f,
            0x103d, 0xd338, 0x523a, 0x1531, 0x9433, 0x5736, 0xd634, 0xd920, 0x5822, 0x9b27, 0x1a25,
            0x5d2e, 0xdc2c, 0x1f29, 0x9e2b, 0x617e, 0xe07c, 0x2379, 0xa27b, 0xe570, 0x6472, 0xa777,
            0x2675, 0x2961, 0xa863, 0x6b66, 0xea64, 0xad6f, 0x2c6d, 0xef68, 0x6e6a, 0xf140, 0x7042,
            0xb347, 0x3245, 0x754e, 0xf44c, 0x3749, 0xb64b, 0xb95f, 0x385d, 0xfb58, 0x7a5a, 0x3d51,
            0xbc53, 0x7f56, 0xfe54,
        ],
        [
            0x0000, 0xc100, 0xc203, 0x0303, 0xc405, 0x0505, 0x0606, 0xc706, 0xc809, 0x0909, 0x0a0a,
            0xcb0a, 0x0c0c, 0xcd0c, 0xce0f, 0x0f0f, 0xd011, 0x1111, 0x1212, 0xd312, 0x1414, 0xd514,
            0xd617, 0x1717, 0x1818, 0xd918, 0xda1b, 0x1b1b, 0xdc1d, 0x1d1d, 0x1e1e, 0xdf1e, 0xe021,
            0x2121, 0x2222, 0xe322, 0x2424, 0xe524, 0xe627, 0x2727, 0x2828, 0xe928, 0xea2b, 0x2b2b,
            0xec2d, 0x2d2d, 0x2e2e, 0xef2e, 0x3030, 0xf130, 0xf233, 0x3333, 0xf435, 0x3535, 0x3636,
            0xf736, 0xf839, 0x3939, 0x3a3a, 0xfb3a, 0x3c3c, 0xfd3c, 0xfe3f, 0x3f3f, 0x8041, 0x4141,
            0x4242, 0x8342, 0x4444, 0x8544, 0x8647, 0x4747, 0x4848, 0x8948, 0x8a4b, 0x4b4b, 0x8c4d,
            0x4d4d, 0x4e4e, 0x8f4e, 0x5050, 0x9150, 0x9253, 0x5353, 0x9455, 0x5555, 0x5656, 0x9756,
            0x9859, 0x5959, 0x5a5a, 0x9b5a, 0x5c5c, 0x9d5c, 0x9e5f, 0x5f5f, 0x6060, 0xa160, 0xa263,
            0x6363, 0xa465, 0x6565, 0x6666, 0xa766, 0xa869, 0x6969, 0x6a6a, 0xab6a, 0x6c6c, 0xad6c,
            0xae6f, 0x6f6f, 0xb071, 0x7171, 0x7272, 0xb372, 0x7474, 0xb574, 0xb677, 0x7777, 0x7878,
            0xb978, 0xba7b, 0x7b7b, 0xbc7d, 0x7d7d, 0x7e7e, 0xbf7e, 0x4081, 0x8181, 0x8282, 0x4382,
            0x8484, 0x4584, 0x4687, 0x8787, 0x8888, 0x4988, 0x4a8b, 0x8b8b, 0x4c8d, 0x8d8d, 0x8e8e,
            0x4f8e, 0x9090, 0x5190, 0x5293, 0x9393, 0x5495, 0x9595, 0x9696, 0x5796, 0x5899, 0x9999,
            0x9a9a, 0x5b9a, 0x9c9c, 0x5d9c, 0x5e9f, 0x9f9f, 0xa0a0, 0x61a0, 0x62a3, 0xa3a3, 0x64a5,
            0xa5a5, 0xa6a6, 0x67a6, 0x68a9, 0xa9a9, 0xaaaa, 0x6baa, 0xacac, 0x6dac, 0x6eaf, 0xafaf,
            0x70b1, 0xb1b1, 0xb2b2, 0x73b2, 0xb4b4, 0x75b4, 0x76b7, 0xb7b7, 0xb8b8, 0x79b8, 0x7abb,
            0xbbbb, 0x7cbd, 0xbdbd, 0xbebe, 0x7fbe, 0xc0c0, 0x01c0, 0x02c3, 0xc3c3, 0x04c5, 0xc5c5,
            0xc6c6, 0x07c6, 0x08c9, 0xc9c9, 0xcaca, 0x0bca, 0xcccc, 0x0dcc, 0x0ecf, 0xcfcf, 0x10d1,
            0xd1d1, 0xd2d2, 0x13d2, 0xd4d4, 0x15d4, 0x16d7, 0xd7d7, 0xd8d8, 0x19d8, 0x1adb, 0xdbdb,
            0x1cdd, 0xdddd, 0xdede, 0x1fde, 0x20e1, 0xe1e1, 0xe2e2, 0x23e2, 0xe4e4, 0x25e4, 0x26e7,
            0xe7e7, 0xe8e8, 0x29e8, 0x2aeb, 0xebeb, 0x2ced, 0xeded, 0xeeee, 0x2fee, 0xf0f0, 0x31f0,
            0x32f3, 0xf3f3, 0x34f5, 0xf5f5, 0xf6f6, 0x37f6, 0x38f9, 0xf9f9, 0xfafa, 0x3bfa, 0xfcfc,
            0x3dfc, 0x3eff, 0xffff,
        ],
        [
            0x0000, 0x00c1, 0x0182, 0x0143, 0x0304, 0x03c5, 0x0286, 0x0247, 0x0608, 0x06c9, 0x078a,
            0x074b, 0x050c, 0x05cd, 0x048e, 0x044f, 0x0c10, 0x0cd1, 0x0d92, 0x0d53, 0x0f14, 0x0fd5,
            0x0e96, 0x0e57, 0x0a18, 0x0ad9, 0x0b9a, 0x0b5b, 0x091c, 0x09dd, 0x089e, 0x085f, 0x1820,
            0x18e1, 0x19a2, 0x1963, 0x1b24, 0x1be5, 0x1aa6, 0x1a67, 0x1e28, 0x1ee9, 0x1faa, 0x1f6b,
            0x1d2c, 0x1ded, 0x1cae, 0x1c6f, 0x1430, 0x14f1, 0x15b2, 0x1573, 0x1734, 0x17f5, 0x16b6,
            0x1677, 0x1238, 0x12f9, 0x13ba, 0x137b, 0x113c, 0x11fd, 0x10be, 0x107f, 0x3040, 0x3081,
            0x31c2, 0x3103, 0x3344, 0x3385, 0x32c6, 0x3207, 0x3648, 0x3689, 0x37ca, 0x370b, 0x354c,
            0x358d, 0x34ce, 0x340f, 0x3c50, 0x3c91, 0x3dd2, 0x3d13, 0x3f54, 0x3f95, 0x3ed6, 0x3e17,
            0x3a58, 0x3a99, 0x3bda, 0x3b1b, 0x395c, 0x399d, 0x38de, 0x381f, 0x2860, 0x28a1, 0x29e2,
            0x2923, 0x2b64, 0x2ba5, 0x2ae6, 0x2a27, 0x2e68, 0x2ea9, 0x2fea, 0x2f2b, 0x2d6c, 0x2dad,
            0x2cee, 0x2c2f, 0x2470, 0x24b1, 0x25f2, 0x2533, 0x2774, 0x27b5, 0x26f6, 0x2637, 0x2278,
            0x22b9, 0x23fa, 0x233b, 0x217c, 0x21bd, 0x20fe, 0x203f, 0x6080, 0x6041, 0x6102, 0x61c3,
            0x6384, 0x6345, 0x6206, 0x62c7, 0x6688, 0x6649, 0x670a, 0x67cb, 0x658c, 0x654d, 0x640e,
            0x64cf, 0x6c90, 0x6c51, 0x6d12, 0x6dd3, 0x6f94, 0x6f55, 0x6e16, 0x6ed7, 0x6a98, 0x6a59,
            0x6b1a, 0x6bdb, 0x699c, 0x695d, 0x681e, 0x68df, 0x78a0, 0x7861, 0x7922, 0x79e3, 0x7ba4,
            0x7b65, 0x7a26, 0x7ae7, 0x7ea8, 0x7e69, 0x7f2a, 0x7feb, 0x7dac, 0x7d6d, 0x7c2e, 0x7cef,
            0x74b0, 0x7471, 0x7532, 0x75f3, 0x77b4, 0x7775, 0x7636, 0x76f7, 0x72b8, 0x7279, 0x733a,
            0x73fb, 0x71bc, 0x717d, 0x703e, 0x70ff, 0x50c0, 0x5001, 0x5142, 0x5183, 0x53c4, 0x5305,
            0x5246, 0x5287, 0x56c8, 0x5609, 0x574a, 0x578b, 0x55cc, 0x550d, 0x544e, 0x548f, 0x5cd0,
            0x5c11, 0x5d52, 0x5d93, 0x5fd4, 0x5f15, 0x5e56, 0x5e97, 0x5ad8, 0x5a19, 0x5b5a, 0x5b9b,
            0x59dc, 0x591d, 0x585e, 0x589f, 0x48e0, 0x4821, 0x4962, 0x49a3, 0x4be4, 0x4b25, 0x4a66,
            0x4aa7, 0x4ee8, 0x4e29, 0x4f6a, 0x4fab, 0x4dec, 0x4d2d, 0x4c6e, 0x4caf, 0x44f0, 0x4431,
            0x4572, 0x45b3, 0x47f4, 0x4735, 0x4676, 0x46b7, 0x42f8, 0x4239, 0x437a, 0x43bb, 0x41fc,
            0x413d, 0x407e, 0x40bf,
        ],
        [
            0x0000, 0x90c1, 0x6181, 0xf140, 0xc302, 0x53c3, 0xa283, 0x3242, 0xc607, 0x56c6, 0xa786,
            0x3747, 0x0505, 0x95c4, 0x6484, 0xf445, 0xcc0d, 0x5ccc, 0xad8c, 0x3d4d, 0x0f0f, 0x9fce,
            0x6e8e, 0xfe4f, 0x0a0a, 0x9acb, 0x6b8b, 0xfb4a, 0xc908, 0x59c9, 0xa889, 0x3848, 0xd819,
            0x48d8, 0xb998, 0x2959, 0x1b1b, 0x8bda, 0x7a9a, 0xea5b, 0x1e1e, 0x8edf, 0x7f9f, 0xef5e,
            0xdd1c, 0x4ddd, 0xbc9d, 0x2c5c, 0x1414, 0x84d5, 0x7595, 0xe554, 0xd716, 0x47d7, 0xb697,
            0x2656, 0xd213, 0x42d2, 0xb392, 0x2353, 0x1111, 0x81d0, 0x7090, 0xe051, 0xf031, 0x60f0,
            0x91b0, 0x0171, 0x3333, 0xa3f2, 0x52b2, 0xc273, 0x3636, 0xa6f7, 0x57b7, 0xc776, 0xf534,
            0x65f5, 0x94b5, 0x0474, 0x3c3c, 0xacfd, 0x5dbd, 0xcd7c, 0xff3e, 0x6fff, 0x9ebf, 0x0e7e,
            0xfa3b, 0x6afa, 0x9bba, 0x0b7b, 0x3939, 0xa9f8, 0x58b8, 0xc879, 0x2828, 0xb8e9, 0x49a9,
            0xd968, 0xeb2a, 0x7beb, 0x8aab, 0x1a6a, 0xee2f, 0x7eee, 0x8fae, 0x1f6f, 0x2d2d, 0xbdec,
            0x4cac, 0xdc6d, 0xe425, 0x74e4, 0x85a4, 0x1565, 0x2727, 0xb7e6, 0x46a6, 0xd667, 0x2222,
            0xb2e3, 0x43a3, 0xd362, 0xe120, 0x71e1, 0x80a1, 0x1060, 0xa061, 0x30a0, 0xc1e0, 0x5121,
            0x6363, 0xf3a2, 0x02e2, 0x9223, 0x6666, 0xf6a7, 0x07e7, 0x9726, 0xa564, 0x35a5, 0xc4e5,
            0x5424, 0x6c6c, 0xfcad, 0x0ded, 0x9d2c, 0xaf6e, 0x3faf, 0xceef, 0x5e2e, 0xaa6b, 0x3aaa,
            0xcbea, 0x5b2b, 0x6969, 0xf9a8, 0x08e8, 0x9829, 0x7878, 0xe8b9, 0x19f9, 0x8938, 0xbb7a,
            0x2bbb, 0xdafb, 0x4a3a, 0xbe7f, 0x2ebe, 0xdffe, 0x4f3f, 0x7d7d, 0xedbc, 0x1cfc, 0x8c3d,
            0xb475, 0x24b4, 0xd5f4, 0x4535, 0x7777, 0xe7b6, 0x16f6, 0x8637, 0x7272, 0xe2b3, 0x13f3,
            0x8332, 0xb170, 0x21b1, 0xd0f1, 0x4030, 0x5050, 0xc091, 0x31d1, 0xa110, 0x9352, 0x0393,
            0xf2d3, 0x6212, 0x9657, 0x0696, 0xf7d6, 0x6717, 0x5555, 0xc594, 0x34d4, 0xa415, 0x9c5d,
            0x0c9c, 0xfddc, 0x6d1d, 0x5f5f, 0xcf9e, 0x3ede, 0xae1f, 0x5a5a, 0xca9b, 0x3bdb, 0xab1a,
            0x9958, 0x0999, 0xf8d9, 0x6818, 0x8849, 0x1888, 0xe9c8, 0x7909, 0x4b4b, 0xdb8a, 0x2aca,
            0xba0b, 0x4e4e, 0xde8f, 0x2fcf, 0xbf0e, 0x8d4c, 0x1d8d, 0xeccd, 0x7c0c, 0x4444, 0xd485,
            0x25c5, 0xb504, 0x8746, 0x1787, 0xe6c7, 0x7606, 0x8243, 0x1282, 0xe3c2, 0x7303, 0x4141,
            0xd180, 0x20c0, 0xb001,
        ],
    ];

    pub static CRC16_CDMA2000_TABLE: [[u16; 256]; 16] = [
        [
            0x0000, 0xc867, 0x58a9, 0x90ce, 0xb152, 0x7935, 0xe9fb, 0x219c, 0xaac3, 0x62a4, 0xf26a,
            0x3a0d, 0x1b91, 0xd3f6, 0x4338, 0x8b5f, 0x9de1, 0x5586, 0xc548, 0x0d2f, 0x2cb3, 0xe4d4,
            0x741a, 0xbc7d, 0x3722, 0xff45, 0x6f8b, 0xa7ec, 0x8670, 0x4e17, 0xded9, 0x16be, 0xf3a5,
            0x3bc2, 0xab0c, 0x636b, 0x42f7, 0x8a90, 0x1a5e, 0xd239, 0x5966, 0x9101, 0x01cf, 0xc9a8,
            0xe834, 0x2053, 0xb09d, 0x78fa, 0x6e44, 0xa623, 0x36ed, 0xfe8a, 0xdf16, 0x1771, 0x87bf,
            0x4fd8, 0xc487, 0x0ce0, 0x9c2e, 0x5449, 0x75d5, 0xbdb2, 0x2d7c, 0xe51b, 0x2f2d, 0xe74a,
            0x7784, 0xbfe3, 0x9e7f, 0x5618, 0xc6d6, 0x0eb1, 0x85ee, 0x4d89, 0xdd47, 0x1520, 0x34bc,
            0xfcdb, 0x6c15, 0xa472, 0xb2cc, 0x7aab, 0xea65, 0x2202, 0x039e, 0xcbf9, 0x5b37, 0x9350,
            0x180f, 0xd068, 0x40a6, 0x88c1, 0xa95d, 0x613a, 0xf1f4, 0x3993, 0xdc88, 0x14ef, 0x8421,
            0x4c46, 0x6dda, 0xa5bd, 0x3573, 0xfd14, 0x764b, 0xbe2c, 0x2ee2, 0xe685, 0xc719, 0x0f7e,
            0x9fb0, 0x57d7, 0x4169, 0x890e, 0x19c0, 0xd1a7, 0xf03b, 0x385c, 0xa892, 0x60f5, 0xebaa,
            0x23cd, 0xb303, 0x7b64, 0x5af8, 0x929f, 0x0251, 0xca36, 0x5e5a, 0x963d, 0x06f3, 0xce94,
            0xef08, 0x276f, 0xb7a1, 0x7fc6, 0xf499, 0x3cfe, 0xac30, 0x6457, 0x45cb, 0x8dac, 0x1d62,
            0xd505, 0xc3bb, 0x0bdc, 0x9b12, 0x5375, 0x72e9, 0xba8e, 0x2a40, 0xe227, 0x6978, 0xa11f,
            0x31d1, 0xf9b6, 0xd82a, 0x104d, 0x8083, 0x48e4, 0xadff, 0x6598, 0xf556, 0x3d31, 0x1cad,
            0xd4ca, 0x4404, 0x8c63, 0x073c, 0xcf5b, 0x5f95, 0x97f2, 0xb66e, 0x7e09, 0xeec7, 0x26a0,
            0x301e, 0xf879, 0x68b7, 0xa0d0, 0x814c, 0x492b, 0xd9e5, 0x1182, 0x9add, 0x52ba, 0xc274,
            0x0a13, 0x2b8f, 0xe3e8, 0x7326, 0xbb41, 0x7177, 0xb910, 0x29de, 0xe1b9, 0xc025, 0x0842,
            0x988c, 0x50eb, 0xdbb4, 0x13d3, 0x831d, 0x4b7a, 0x6ae6, 0xa281, 0x324f, 0xfa28, 0xec96,
            0x24f1, 0xb43f, 0x7c58, 0x5dc4, 0x95a3, 0x056d, 0xcd0a, 0x4655, 0x8e32, 0x1efc, 0xd69b,
            0xf707, 0x3f60, 0xafae, 0x67c9, 0x82d2, 0x4ab5, 0xda7b, 0x121c, 0x3380, 0xfbe7, 0x6b29,
            0xa34e, 0x2811, 0xe076, 0x70b8, 0xb8df, 0x9943, 0x5124, 0xc1ea, 0x098d, 0x1f33, 0xd754,
            0x479a, 0x8ffd, 0xae61, 0x6606, 0xf6c8, 0x3eaf, 0xb5f0, 0x7d97, 0xed59, 0x253e, 0x04a2,
            0xccc5, 0x5c0b, 0x946c,
        ],
        [
            0x0000, 0xbcb4, 0xb10f, 0x0dbb, 0xaa79, 0x16cd, 0x1b76, 0xa7c2, 0x9c95, 0x2021, 0x2d9a,
            0x912e, 0x36ec, 0x8a58, 0x87e3, 0x3b57, 0xf14d, 0x4df9, 0x4042, 0xfcf6, 0x5b34, 0xe780,
            0xea3b, 0x568f, 0x6dd8, 0xd16c, 0xdcd7, 0x6063, 0xc7a1, 0x7b15, 0x76ae, 0xca1a, 0x2afd,
            0x9649, 0x9bf2, 0x2746, 0x8084, 0x3c30, 0x318b, 0x8d3f, 0xb668, 0x0adc, 0x0767, 0xbbd3,
            0x1c11, 0xa0a5, 0xad1e, 0x11aa, 0xdbb0, 0x6704, 0x6abf, 0xd60b, 0x71c9, 0xcd7d, 0xc0c6,
            0x7c72, 0x4725, 0xfb91, 0xf62a, 0x4a9e, 0xed5c, 0x51e8, 0x5c53, 0xe0e7, 0x55fa, 0xe94e,
            0xe4f5, 0x5841, 0xff83, 0x4337, 0x4e8c, 0xf238, 0xc96f, 0x75db, 0x7860, 0xc4d4, 0x6316,
            0xdfa2, 0xd219, 0x6ead, 0xa4b7, 0x1803, 0x15b8, 0xa90c, 0x0ece, 0xb27a, 0xbfc1, 0x0375,
            0x3822, 0x8496, 0x892d, 0x3599, 0x925b, 0x2eef, 0x2354, 0x9fe0, 0x7f07, 0xc3b3, 0xce08,
            0x72bc, 0xd57e, 0x69ca, 0x6471, 0xd8c5, 0xe392, 0x5f26, 0x529d, 0xee29, 0x49eb, 0xf55f,
            0xf8e4, 0x4450, 0x8e4a, 0x32fe, 0x3f45, 0x83f1, 0x2433, 0x9887, 0x953c, 0x2988, 0x12df,
            0xae6b, 0xa3d0, 0x1f64, 0xb8a6, 0x0412, 0x09a9, 0xb51d, 0xabf4, 0x1740, 0x1afb, 0xa64f,
            0x018d, 0xbd39, 0xb082, 0x0c36, 0x3761, 0x8bd5, 0x866e, 0x3ada, 0x9d18, 0x21ac, 0x2c17,
            0x90a3, 0x5ab9, 0xe60d, 0xebb6, 0x5702, 0xf0c0, 0x4c74, 0x41cf, 0xfd7b, 0xc62c, 0x7a98,
            0x7723, 0xcb97, 0x6c55, 0xd0e1, 0xdd5a, 0x61ee, 0x8109, 0x3dbd, 0x3006, 0x8cb2, 0x2b70,
            0x97c4, 0x9a7f, 0x26cb, 0x1d9c, 0xa128, 0xac93, 0x1027, 0xb7e5, 0x0b51, 0x06ea, 0xba5e,
            0x7044, 0xccf0, 0xc14b, 0x7dff, 0xda3d, 0x6689, 0x6b32, 0xd786, 0xecd1, 0x5065, 0x5dde,
            0xe16a, 0x46a8, 0xfa1c, 0xf7a7, 0x4b13, 0xfe0e, 0x42ba, 0x4f01, 0xf3b5, 0x5477, 0xe8c3,
            0xe578, 0x59cc, 0x629b, 0xde2f, 0xd394, 0x6f20, 0xc8e2, 0x7456, 0x79ed, 0xc559, 0x0f43,
            0xb3f7, 0xbe4c, 0x02f8, 0xa53a, 0x198e, 0x1435, 0xa881, 0x93d6, 0x2f62, 0x22d9, 0x9e6d,
            0x39af, 0x851b, 0x88a0, 0x3414, 0xd4f3, 0x6847, 0x65fc, 0xd948, 0x7e8a, 0xc23e, 0xcf85,
            0x7331, 0x4866, 0xf4d2, 0xf969, 0x45dd, 0xe21f, 0x5eab, 0x5310, 0xefa4, 0x25be, 0x990a,
            0x94b1, 0x2805, 0x8fc7, 0x3373, 0x3ec8, 0x827c, 0xb92b, 0x059f, 0x0824, 0xb490, 0x1352,
            0xafe6, 0xa25d, 0x1ee9,
        ],
        [
            0x0000, 0x9f8f, 0xf779, 0x68f6, 0x2695, 0xb91a, 0xd1ec, 0x4e63, 0x4d2a, 0xd2a5, 0xba53,
            0x25dc, 0x6bbf, 0xf430, 0x9cc6, 0x0349, 0x9a54, 0x05db, 0x6d2d, 0xf2a2, 0xbcc1, 0x234e,
            0x4bb8, 0xd437, 0xd77e, 0x48f1, 0x2007, 0xbf88, 0xf1eb, 0x6e64, 0x0692, 0x991d, 0xfccf,
            0x6340, 0x0bb6, 0x9439, 0xda5a, 0x45d5, 0x2d23, 0xb2ac, 0xb1e5, 0x2e6a, 0x469c, 0xd913,
            0x9770, 0x08ff, 0x6009, 0xff86, 0x669b, 0xf914, 0x91e2, 0x0e6d, 0x400e, 0xdf81, 0xb777,
            0x28f8, 0x2bb1, 0xb43e, 0xdcc8, 0x4347, 0x0d24, 0x92ab, 0xfa5d, 0x65d2, 0x31f9, 0xae76,
            0xc680, 0x590f, 0x176c, 0x88e3, 0xe015, 0x7f9a, 0x7cd3, 0xe35c, 0x8baa, 0x1425, 0x5a46,
            0xc5c9, 0xad3f, 0x32b0, 0xabad, 0x3422, 0x5cd4, 0xc35b, 0x8d38, 0x12b7, 0x7a41, 0xe5ce,
            0xe687, 0x7908, 0x11fe, 0x8e71, 0xc012, 0x5f9d, 0x376b, 0xa8e4, 0xcd36, 0x52b9, 0x3a4f,
            0xa5c0, 0xeba3, 0x742c, 0x1cda, 0x8355, 0x801c, 0x1f93, 0x7765, 0xe8ea, 0xa689, 0x3906,
            0x51f0, 0xce7f, 0x5762, 0xc8ed, 0xa01b, 0x3f94, 0x71f7, 0xee78, 0x868e, 0x1901, 0x1a48,
            0x85c7, 0xed31, 0x72be, 0x3cdd, 0xa352, 0xcba4, 0x542b, 0x63f2, 0xfc7d, 0x948b, 0x0b04,
            0x4567, 0xdae8, 0xb21e, 0x2d91, 0x2ed8, 0xb157, 0xd9a1, 0x462e, 0x084d, 0x97c2, 0xff34,
            0x60bb, 0xf9a6, 0x6629, 0x0edf, 0x9150, 0xdf33, 0x40bc, 0x284a, 0xb7c5, 0xb48c, 0x2b03,
            0x43f5, 0xdc7a, 0x9219, 0x0d96, 0x6560, 0xfaef, 0x9f3d, 0x00b2, 0x6844, 0xf7cb, 0xb9a8,
            0x2627, 0x4ed1, 0xd15e, 0xd217, 0x4d98, 0x256e, 0xbae1, 0xf482, 0x6b0d, 0x03fb, 0x9c74,
            0x0569, 0x9ae6, 0xf210, 0x6d9f, 0x23fc, 0xbc73, 0xd485, 0x4b0a, 0x4843, 0xd7cc, 0xbf3a,
            0x20b5, 0x6ed6, 0xf159, 0x99af, 0x0620, 0x520b, 0xcd84, 0xa572, 0x3afd, 0x749e, 0xeb11,
            0x83e7, 0x1c68, 0x1f21, 0x80ae, 0xe858, 0x77d7, 0x39b4, 0xa63b, 0xcecd, 0x5142, 0xc85f,
            0x57d0, 0x3f26, 0xa0a9, 0xeeca, 0x7145, 0x19b3, 0x863c, 0x8575, 0x1afa, 0x720c, 0xed83,
            0xa3e0, 0x3c6f, 0x5499, 0xcb16, 0xaec4, 0x314b, 0x59bd, 0xc632, 0x8851, 0x17de, 0x7f28,
            0xe0a7, 0xe3ee, 0x7c61, 0x1497, 0x8b18, 0xc57b, 0x5af4, 0x3202, 0xad8d, 0x3490, 0xab1f,
            0xc3e9, 0x5c66, 0x1205, 0x8d8a, 0xe57c, 0x7af3, 0x79ba, 0xe635, 0x8ec3, 0x114c, 0x5f2f,
            0xc0a0, 0xa856, 0x37d9,
        ],
        [
            0x0000, 0xc7e4, 0x47af, 0x804b, 0x8f5e, 0x48ba, 0xc8f1, 0x0f15, 0xd6db, 0x113f, 0x9174,
            0x5690, 0x5985, 0x9e61, 0x1e2a, 0xd9ce, 0x65d1, 0xa235, 0x227e, 0xe59a, 0xea8f, 0x2d6b,
            0xad20, 0x6ac4, 0xb30a, 0x74ee, 0xf4a5, 0x3341, 0x3c54, 0xfbb0, 0x7bfb, 0xbc1f, 0xcba2,
            0x0c46, 0x8c0d, 0x4be9, 0x44fc, 0x8318, 0x0353, 0xc4b7, 0x1d79, 0xda9d, 0x5ad6, 0x9d32,
            0x9227, 0x55c3, 0xd588, 0x126c, 0xae73, 0x6997, 0xe9dc, 0x2e38, 0x212d, 0xe6c9, 0x6682,
            0xa166, 0x78a8, 0xbf4c, 0x3f07, 0xf8e3, 0xf7f6, 0x3012, 0xb059, 0x77bd, 0x5f23, 0x98c7,
            0x188c, 0xdf68, 0xd07d, 0x1799, 0x97d2, 0x5036, 0x89f8, 0x4e1c, 0xce57, 0x09b3, 0x06a6,
            0xc142, 0x4109, 0x86ed, 0x3af2, 0xfd16, 0x7d5d, 0xbab9, 0xb5ac, 0x7248, 0xf203, 0x35e7,
            0xec29, 0x2bcd, 0xab86, 0x6c62, 0x6377, 0xa493, 0x24d8, 0xe33c, 0x9481, 0x5365, 0xd32e,
            0x14ca, 0x1bdf, 0xdc3b, 0x5c70, 0x9b94, 0x425a, 0x85be, 0x05f5, 0xc211, 0xcd04, 0x0ae0,
            0x8aab, 0x4d4f, 0xf150, 0x36b4, 0xb6ff, 0x711b, 0x7e0e, 0xb9ea, 0x39a1, 0xfe45, 0x278b,
            0xe06f, 0x6024, 0xa7c0, 0xa8d5, 0x6f31, 0xef7a, 0x289e, 0xbe46, 0x79a2, 0xf9e9, 0x3e0d,
            0x3118, 0xf6fc, 0x76b7, 0xb153, 0x689d, 0xaf79, 0x2f32, 0xe8d6, 0xe7c3, 0x2027, 0xa06c,
            0x6788, 0xdb97, 0x1c73, 0x9c38, 0x5bdc, 0x54c9, 0x932d, 0x1366, 0xd482, 0x0d4c, 0xcaa8,
            0x4ae3, 0x8d07, 0x8212, 0x45f6, 0xc5bd, 0x0259, 0x75e4, 0xb200, 0x324b, 0xf5af, 0xfaba,
            0x3d5e, 0xbd15, 0x7af1, 0xa33f, 0x64db, 0xe490, 0x2374, 0x2c61, 0xeb85, 0x6bce, 0xac2a,
            0x1035, 0xd7d1, 0x579a, 0x907e, 0x9f6b, 0x588f, 0xd8c4, 0x1f20, 0xc6ee, 0x010a, 0x8141,
            0x46a5, 0x49b0, 0x8e54, 0x0e1f, 0xc9fb, 0xe165, 0x2681, 0xa6ca, 0x612e, 0x6e3b, 0xa9df,
            0x2994, 0xee70, 0x37be, 0xf05a, 0x7011, 0xb7f5, 0xb8e0, 0x7f04, 0xff4f, 0x38ab, 0x84b4,
            0x4350, 0xc31b, 0x04ff, 0x0bea, 0xcc0e, 0x4c45, 0x8ba1, 0x526f, 0x958b, 0x15c0, 0xd224,
            0xdd31, 0x1ad5, 0x9a9e, 0x5d7a, 0x2ac7, 0xed23, 0x6d68, 0xaa8c, 0xa599, 0x627d, 0xe236,
            0x25d2, 0xfc1c, 0x3bf8, 0xbbb3, 0x7c57, 0x7342, 0xb4a6, 0x34ed, 0xf309, 0x4f16, 0x88f2,
            0x08b9, 0xcf5d, 0xc048, 0x07ac, 0x87e7, 0x4003, 0x99cd, 0x5e29, 0xde62, 0x1986, 0x1693,
            0xd177, 0x513c, 0x96d8,
        ],
        [
            0x0000, 0xb4eb, 0xa1b1, 0x155a, 0x8b05, 0x3fee, 0x2ab4, 0x9e5f, 0xde6d, 0x6a86, 0x7fdc,
            0xcb37, 0x5568, 0xe183, 0xf4d9, 0x4032, 0x74bd, 0xc056, 0xd50c, 0x61e7, 0xffb8, 0x4b53,
            0x5e09, 0xeae2, 0xaad0, 0x1e3b, 0x0b61, 0xbf8a, 0x21d5, 0x953e, 0x8064, 0x348f, 0xe97a,
            0x5d91, 0x48cb, 0xfc20, 0x627f, 0xd694, 0xc3ce, 0x7725, 0x3717, 0x83fc, 0x96a6, 0x224d,
            0xbc12, 0x08f9, 0x1da3, 0xa948, 0x9dc7, 0x292c, 0x3c76, 0x889d, 0x16c2, 0xa229, 0xb773,
            0x0398, 0x43aa, 0xf741, 0xe21b, 0x56f0, 0xc8af, 0x7c44, 0x691e, 0xddf5, 0x1a93, 0xae78,
            0xbb22, 0x0fc9, 0x9196, 0x257d, 0x3027, 0x84cc, 0xc4fe, 0x7015, 0x654f, 0xd1a4, 0x4ffb,
            0xfb10, 0xee4a, 0x5aa1, 0x6e2e, 0xdac5, 0xcf9f, 0x7b74, 0xe52b, 0x51c0, 0x449a, 0xf071,
            0xb043, 0x04a8, 0x11f2, 0xa519, 0x3b46, 0x8fad, 0x9af7, 0x2e1c, 0xf3e9, 0x4702, 0x5258,
            0xe6b3, 0x78ec, 0xcc07, 0xd95d, 0x6db6, 0x2d84, 0x996f, 0x8c35, 0x38de, 0xa681, 0x126a,
            0x0730, 0xb3db, 0x8754, 0x33bf, 0x26e5, 0x920e, 0x0c51, 0xb8ba, 0xade0, 0x190b, 0x5939,
            0xedd2, 0xf888, 0x4c63, 0xd23c, 0x66d7, 0x738d, 0xc766, 0x3526, 0x81cd, 0x9497, 0x207c,
            0xbe23, 0x0ac8, 0x1f92, 0xab79, 0xeb4b, 0x5fa0, 0x4afa, 0xfe11, 0x604e, 0xd4a5, 0xc1ff,
            0x7514, 0x419b, 0xf570, 0xe02a, 0x54c1, 0xca9e, 0x7e75, 0x6b2f, 0xdfc4, 0x9ff6, 0x2b1d,
            0x3e47, 0x8aac, 0x14f3, 0xa018, 0xb542, 0x01a9, 0xdc5c, 0x68b7, 0x7ded, 0xc906, 0x5759,
            0xe3b2, 0xf6e8, 0x4203, 0x0231, 0xb6da, 0xa380, 0x176b, 0x8934, 0x3ddf, 0x2885, 0x9c6e,
            0xa8e1, 0x1c0a, 0x0950, 0xbdbb, 0x23e4, 0x970f, 0x8255, 0x36be, 0x768c, 0xc267, 0xd73d,
            0x63d6, 0xfd89, 0x4962, 0x5c38, 0xe8d3, 0x2fb5, 0x9b5e, 0x8e04, 0x3aef, 0xa4b0, 0x105b,
            0x0501, 0xb1ea, 0xf1d8, 0x4533, 0x5069, 0xe482, 0x7add, 0xce36, 0xdb6c, 0x6f87, 0x5b08,
            0xefe3, 0xfab9, 0x4e52, 0xd00d, 0x64e6, 0x71bc, 0xc557, 0x8565, 0x318e, 0x24d4, 0x903f,
            0x0e60, 0xba8b, 0xafd1, 0x1b3a, 0xc6cf, 0x7224, 0x677e, 0xd395, 0x4dca, 0xf921, 0xec7b,
            0x5890, 0x18a2, 0xac49, 0xb913, 0x0df8, 0x93a7, 0x274c, 0x3216, 0x86fd, 0xb272, 0x0699,
            0x13c3, 0xa728, 0x3977, 0x8d9c, 0x98c6, 0x2c2d, 0x6c1f, 0xd8f4, 0xcdae, 0x7945, 0xe71a,
            0x53f1, 0x46ab, 0xf240,
        ],
        [
            0x0000, 0x6a4c, 0xd498, 0xbed4, 0x6157, 0x0b1b, 0xb5cf, 0xdf83, 0xc2ae, 0xa8e2, 0x1636,
            0x7c7a, 0xa3f9, 0xc9b5, 0x7761, 0x1d2d, 0x4d3b, 0x2777, 0x99a3, 0xf3ef, 0x2c6c, 0x4620,
            0xf8f4, 0x92b8, 0x8f95, 0xe5d9, 0x5b0d, 0x3141, 0xeec2, 0x848e, 0x3a5a, 0x5016, 0x9a76,
            0xf03a, 0x4eee, 0x24a2, 0xfb21, 0x916d, 0x2fb9, 0x45f5, 0x58d8, 0x3294, 0x8c40, 0xe60c,
            0x398f, 0x53c3, 0xed17, 0x875b, 0xd74d, 0xbd01, 0x03d5, 0x6999, 0xb61a, 0xdc56, 0x6282,
            0x08ce, 0x15e3, 0x7faf, 0xc17b, 0xab37, 0x74b4, 0x1ef8, 0xa02c, 0xca60, 0xfc8b, 0x96c7,
            0x2813, 0x425f, 0x9ddc, 0xf790, 0x4944, 0x2308, 0x3e25, 0x5469, 0xeabd, 0x80f1, 0x5f72,
            0x353e, 0x8bea, 0xe1a6, 0xb1b0, 0xdbfc, 0x6528, 0x0f64, 0xd0e7, 0xbaab, 0x047f, 0x6e33,
            0x731e, 0x1952, 0xa786, 0xcdca, 0x1249, 0x7805, 0xc6d1, 0xac9d, 0x66fd, 0x0cb1, 0xb265,
            0xd829, 0x07aa, 0x6de6, 0xd332, 0xb97e, 0xa453, 0xce1f, 0x70cb, 0x1a87, 0xc504, 0xaf48,
            0x119c, 0x7bd0, 0x2bc6, 0x418a, 0xff5e, 0x9512, 0x4a91, 0x20dd, 0x9e09, 0xf445, 0xe968,
            0x8324, 0x3df0, 0x57bc, 0x883f, 0xe273, 0x5ca7, 0x36eb, 0x3171, 0x5b3d, 0xe5e9, 0x8fa5,
            0x5026, 0x3a6a, 0x84be, 0xeef2, 0xf3df, 0x9993, 0x2747, 0x4d0b, 0x9288, 0xf8c4, 0x4610,
            0x2c5c, 0x7c4a, 0x1606, 0xa8d2, 0xc29e, 0x1d1d, 0x7751, 0xc985, 0xa3c9, 0xbee4, 0xd4a8,
            0x6a7c, 0x0030, 0xdfb3, 0xb5ff, 0x0b2b, 0x6167, 0xab07, 0xc14b, 0x7f9f, 0x15d3, 0xca50,
            0xa01c, 0x1ec8, 0x7484, 0x69a9, 0x03e5, 0xbd31, 0xd77d, 0x08fe, 0x62b2, 0xdc66, 0xb62a,
            0xe63c, 0x8c70, 0x32a4, 0x58e8, 0x876b, 0xed27, 0x53f3, 0x39bf, 0x2492, 0x4ede, 0xf00a,
            0x9a46, 0x45c5, 0x2f89, 0x915d, 0xfb11, 0xcdfa, 0xa7b6, 0x1962, 0x732e, 0xacad, 0xc6e1,
            0x7835, 0x1279, 0x0f54, 0x6518, 0xdbcc, 0xb180, 0x6e03, 0x044f, 0xba9b, 0xd0d7, 0x80c1,
            0xea8d, 0x5459, 0x3e15, 0xe196, 0x8bda, 0x350e, 0x5f42, 0x426f, 0x2823, 0x96f7, 0xfcbb,
            0x2338, 0x4974, 0xf7a0, 0x9dec, 0x578c, 0x3dc0, 0x8314, 0xe958, 0x36db, 0x5c97, 0xe243,
            0x880f, 0x9522, 0xff6e, 0x41ba, 0x2bf6, 0xf475, 0x9e39, 0x20ed, 0x4aa1, 0x1ab7, 0x70fb,
            0xce2f, 0xa463, 0x7be0, 0x11ac, 0xaf78, 0xc534, 0xd819, 0xb255, 0x0c81, 0x66cd, 0xb94e,
            0xd302, 0x6dd6, 0x079a,
        ],
        [
            0x0000, 0x62e2, 0xc5c4, 0xa726, 0x43ef, 0x210d, 0x862b, 0xe4c9, 0x87de, 0xe53c, 0x421a,
            0x20f8, 0xc431, 0xa6d3, 0x01f5, 0x6317, 0xc7db, 0xa539, 0x021f, 0x60fd, 0x8434, 0xe6d6,
            0x41f0, 0x2312, 0x4005, 0x22e7, 0x85c1, 0xe723, 0x03ea, 0x6108, 0xc62e, 0xa4cc, 0x47d1,
            0x2533, 0x8215, 0xe0f7, 0x043e, 0x66dc, 0xc1fa, 0xa318, 0xc00f, 0xa2ed, 0x05cb, 0x6729,
            0x83e0, 0xe102, 0x4624, 0x24c6, 0x800a, 0xe2e8, 0x45ce, 0x272c, 0xc3e5, 0xa107, 0x0621,
            0x64c3, 0x07d4, 0x6536, 0xc210, 0xa0f2, 0x443b, 0x26d9, 0x81ff, 0xe31d, 0x8fa2, 0xed40,
            0x4a66, 0x2884, 0xcc4d, 0xaeaf, 0x0989, 0x6b6b, 0x087c, 0x6a9e, 0xcdb8, 0xaf5a, 0x4b93,
            0x2971, 0x8e57, 0xecb5, 0x4879, 0x2a9b, 0x8dbd, 0xef5f, 0x0b96, 0x6974, 0xce52, 0xacb0,
            0xcfa7, 0xad45, 0x0a63, 0x6881, 0x8c48, 0xeeaa, 0x498c, 0x2b6e, 0xc873, 0xaa91, 0x0db7,
            0x6f55, 0x8b9c, 0xe97e, 0x4e58, 0x2cba, 0x4fad, 0x2d4f, 0x8a69, 0xe88b, 0x0c42, 0x6ea0,
            0xc986, 0xab64, 0x0fa8, 0x6d4a, 0xca6c, 0xa88e, 0x4c47, 0x2ea5, 0x8983, 0xeb61, 0x8876,
            0xea94, 0x4db2, 0x2f50, 0xcb99, 0xa97b, 0x0e5d, 0x6cbf, 0xd723, 0xb5c1, 0x12e7, 0x7005,
            0x94cc, 0xf62e, 0x5108, 0x33ea, 0x50fd, 0x321f, 0x9539, 0xf7db, 0x1312, 0x71f0, 0xd6d6,
            0xb434, 0x10f8, 0x721a, 0xd53c, 0xb7de, 0x5317, 0x31f5, 0x96d3, 0xf431, 0x9726, 0xf5c4,
            0x52e2, 0x3000, 0xd4c9, 0xb62b, 0x110d, 0x73ef, 0x90f2, 0xf210, 0x5536, 0x37d4, 0xd31d,
            0xb1ff, 0x16d9, 0x743b, 0x172c, 0x75ce, 0xd2e8, 0xb00a, 0x54c3, 0x3621, 0x9107, 0xf3e5,
            0x5729, 0x35cb, 0x92ed, 0xf00f, 0x14c6, 0x7624, 0xd102, 0xb3e0, 0xd0f7, 0xb215, 0x1533,
            0x77d1, 0x9318, 0xf1fa, 0x56dc, 0x343e, 0x5881, 0x3a63, 0x9d45, 0xffa7, 0x1b6e, 0x798c,
            0xdeaa, 0xbc48, 0xdf5f, 0xbdbd, 0x1a9b, 0x7879, 0x9cb0, 0xfe52, 0x5974, 0x3b96, 0x9f5a,
            0xfdb8, 0x5a9e, 0x387c, 0xdcb5, 0xbe57, 0x1971, 0x7b93, 0x1884, 0x7a66, 0xdd40, 0xbfa2,
            0x5b6b, 0x3989, 0x9eaf, 0xfc4d, 0x1f50, 0x7db2, 0xda94, 0xb876, 0x5cbf, 0x3e5d, 0x997b,
            0xfb99, 0x988e, 0xfa6c, 0x5d4a, 0x3fa8, 0xdb61, 0xb983, 0x1ea5, 0x7c47, 0xd88b, 0xba69,
            0x1d4f, 0x7fad, 0x9b64, 0xf986, 0x5ea0, 0x3c42, 0x5f55, 0x3db7, 0x9a91, 0xf873, 0x1cba,
            0x7e58, 0xd97e, 0xbb9c,
        ],
        [
            0x0000, 0x6621, 0xcc42, 0xaa63, 0x50e3, 0x36c2, 0x9ca1, 0xfa80, 0xa1c6, 0xc7e7, 0x6d84,
            0x0ba5, 0xf125, 0x9704, 0x3d67, 0x5b46, 0x8beb, 0xedca, 0x47a9, 0x2188, 0xdb08, 0xbd29,
            0x174a, 0x716b, 0x2a2d, 0x4c0c, 0xe66f, 0x804e, 0x7ace, 0x1cef, 0xb68c, 0xd0ad, 0xdfb1,
            0xb990, 0x13f3, 0x75d2, 0x8f52, 0xe973, 0x4310, 0x2531, 0x7e77, 0x1856, 0xb235, 0xd414,
            0x2e94, 0x48b5, 0xe2d6, 0x84f7, 0x545a, 0x327b, 0x9818, 0xfe39, 0x04b9, 0x6298, 0xc8fb,
            0xaeda, 0xf59c, 0x93bd, 0x39de, 0x5fff, 0xa57f, 0xc35e, 0x693d, 0x0f1c, 0x7705, 0x1124,
            0xbb47, 0xdd66, 0x27e6, 0x41c7, 0xeba4, 0x8d85, 0xd6c3, 0xb0e2, 0x1a81, 0x7ca0, 0x8620,
            0xe001, 0x4a62, 0x2c43, 0xfcee, 0x9acf, 0x30ac, 0x568d, 0xac0d, 0xca2c, 0x604f, 0x066e,
            0x5d28, 0x3b09, 0x916a, 0xf74b, 0x0dcb, 0x6bea, 0xc189, 0xa7a8, 0xa8b4, 0xce95, 0x64f6,
            0x02d7, 0xf857, 0x9e76, 0x3415, 0x5234, 0x0972, 0x6f53, 0xc530, 0xa311, 0x5991, 0x3fb0,
            0x95d3, 0xf3f2, 0x235f, 0x457e, 0xef1d, 0x893c, 0x73bc, 0x159d, 0xbffe, 0xd9df, 0x8299,
            0xe4b8, 0x4edb, 0x28fa, 0xd27a, 0xb45b, 0x1e38, 0x7819, 0xee0a, 0x882b, 0x2248, 0x4469,
            0xbee9, 0xd8c8, 0x72ab, 0x148a, 0x4fcc, 0x29ed, 0x838e, 0xe5af, 0x1f2f, 0x790e, 0xd36d,
            0xb54c, 0x65e1, 0x03c0, 0xa9a3, 0xcf82, 0x3502, 0x5323, 0xf940, 0x9f61, 0xc427, 0xa206,
            0x0865, 0x6e44, 0x94c4, 0xf2e5, 0x5886, 0x3ea7, 0x31bb, 0x579a, 0xfdf9, 0x9bd8, 0x6158,
            0x0779, 0xad1a, 0xcb3b, 0x907d, 0xf65c, 0x5c3f, 0x3a1e, 0xc09e, 0xa6bf, 0x0cdc, 0x6afd,
            0xba50, 0xdc71, 0x7612, 0x1033, 0xeab3, 0x8c92, 0x26f1, 0x40d0, 0x1b96, 0x7db7, 0xd7d4,
            0xb1f5, 0x4b75, 0x2d54, 0x8737, 0xe116, 0x990f, 0xff2e, 0x554d, 0x336c, 0xc9ec, 0xafcd,
            0x05ae, 0x638f, 0x38c9, 0x5ee8, 0xf48b, 0x92aa, 0x682a, 0x0e0b, 0xa468, 0xc249, 0x12e4,
            0x74c5, 0xdea6, 0xb887, 0x4207, 0x2426, 0x8e45, 0xe864, 0xb322, 0xd503, 0x7f60, 0x1941,
            0xe3c1, 0x85e0, 0x2f83, 0x49a2, 0x46be, 0x209f, 0x8afc, 0xecdd, 0x165d, 0x707c, 0xda1f,
            0xbc3e, 0xe778, 0x8159, 0x2b3a, 0x4d1b, 0xb79b, 0xd1ba, 0x7bd9, 0x1df8, 0xcd55, 0xab74,
            0x0117, 0x6736, 0x9db6, 0xfb97, 0x51f4, 0x37d5, 0x6c93, 0x0ab2, 0xa0d1, 0xc6f0, 0x3c70,
            0x5a51, 0xf032, 0x9613,
        ],
        [
            0x0000, 0x1473, 0x28e6, 0x3c95, 0x51cc, 0x45bf, 0x792a, 0x6d59, 0xa398, 0xb7eb, 0x8b7e,
            0x9f0d, 0xf254, 0xe627, 0xdab2, 0xcec1, 0x8f57, 0x9b24, 0xa7b1, 0xb3c2, 0xde9b, 0xcae8,
            0xf67d, 0xe20e, 0x2ccf, 0x38bc, 0x0429, 0x105a, 0x7d03, 0x6970, 0x55e5, 0x4196, 0xd6c9,
            0xc2ba, 0xfe2f, 0xea5c, 0x8705, 0x9376, 0xafe3, 0xbb90, 0x7551, 0x6122, 0x5db7, 0x49c4,
            0x249d, 0x30ee, 0x0c7b, 0x1808, 0x599e, 0x4ded, 0x7178, 0x650b, 0x0852, 0x1c21, 0x20b4,
            0x34c7, 0xfa06, 0xee75, 0xd2e0, 0xc693, 0xabca, 0xbfb9, 0x832c, 0x975f, 0x65f5, 0x7186,
            0x4d13, 0x5960, 0x3439, 0x204a, 0x1cdf, 0x08ac, 0xc66d, 0xd21e, 0xee8b, 0xfaf8, 0x97a1,
            0x83d2, 0xbf47, 0xab34, 0xeaa2, 0xfed1, 0xc244, 0xd637, 0xbb6e, 0xaf1d, 0x9388, 0x87fb,
            0x493a, 0x5d49, 0x61dc, 0x75af, 0x18f6, 0x0c85, 0x3010, 0x2463, 0xb33c, 0xa74f, 0x9bda,
            0x8fa9, 0xe2f0, 0xf683, 0xca16, 0xde65, 0x10a4, 0x04d7, 0x3842, 0x2c31, 0x4168, 0x551b,
            0x698e, 0x7dfd, 0x3c6b, 0x2818, 0x148d, 0x00fe, 0x6da7, 0x79d4, 0x4541, 0x5132, 0x9ff3,
            0x8b80, 0xb715, 0xa366, 0xce3f, 0xda4c, 0xe6d9, 0xf2aa, 0xcbea, 0xdf99, 0xe30c, 0xf77f,
            0x9a26, 0x8e55, 0xb2c0, 0xa6b3, 0x6872, 0x7c01, 0x4094, 0x54e7, 0x39be, 0x2dcd, 0x1158,
            0x052b, 0x44bd, 0x50ce, 0x6c5b, 0x7828, 0x1571, 0x0102, 0x3d97, 0x29e4, 0xe725, 0xf356,
            0xcfc3, 0xdbb0, 0xb6e9, 0xa29a, 0x9e0f, 0x8a7c, 0x1d23, 0x0950, 0x35c5, 0x21b6, 0x4cef,
            0x589c, 0x6409, 0x707a, 0xbebb, 0xaac8, 0x965d, 0x822e, 0xef77, 0xfb04, 0xc791, 0xd3e2,
            0x9274, 0x8607, 0xba92, 0xaee1, 0xc3b8, 0xd7cb, 0xeb5e, 0xff2d, 0x31ec, 0x259f, 0x190a,
            0x0d79, 0x6020, 0x7453, 0x48c6, 0x5cb5, 0xae1f, 0xba6c, 0x86f9, 0x928a, 0xffd3, 0xeba0,
            0xd735, 0xc346, 0x0d87, 0x19f4, 0x2561, 0x3112, 0x5c4b, 0x4838, 0x74ad, 0x60de, 0x2148,
            0x353b, 0x09ae, 0x1ddd, 0x7084, 0x64f7, 0x5862, 0x4c11, 0x82d0, 0x96a3, 0xaa36, 0xbe45,
            0xd31c, 0xc76f, 0xfbfa, 0xef89, 0x78d6, 0x6ca5, 0x5030, 0x4443, 0x291a, 0x3d69, 0x01fc,
            0x158f, 0xdb4e, 0xcf3d, 0xf3a8, 0xe7db, 0x8a82, 0x9ef1, 0xa264, 0xb617, 0xf781, 0xe3f2,
            0xdf67, 0xcb14, 0xa64d, 0xb23e, 0x8eab, 0x9ad8, 0x5419, 0x406a, 0x7cff, 0x688c, 0x05d5,
            0x11a6, 0x2d33, 0x3940,
        ],
        [
            0x0000, 0x5fb3, 0xbf66, 0xe0d5, 0xb6ab, 0xe918, 0x09cd, 0x567e, 0xa531, 0xfa82, 0x1a57,
            0x45e4, 0x139a, 0x4c29, 0xacfc, 0xf34f, 0x8205, 0xddb6, 0x3d63, 0x62d0, 0x34ae, 0x6b1d,
            0x8bc8, 0xd47b, 0x2734, 0x7887, 0x9852, 0xc7e1, 0x919f, 0xce2c, 0x2ef9, 0x714a, 0xcc6d,
            0x93de, 0x730b, 0x2cb8, 0x7ac6, 0x2575, 0xc5a0, 0x9a13, 0x695c, 0x36ef, 0xd63a, 0x8989,
            0xdff7, 0x8044, 0x6091, 0x3f22, 0x4e68, 0x11db, 0xf10e, 0xaebd, 0xf8c3, 0xa770, 0x47a5,
            0x1816, 0xeb59, 0xb4ea, 0x543f, 0x0b8c, 0x5df2, 0x0241, 0xe294, 0xbd27, 0x50bd, 0x0f0e,
            0xefdb, 0xb068, 0xe616, 0xb9a5, 0x5970, 0x06c3, 0xf58c, 0xaa3f, 0x4aea, 0x1559, 0x4327,
            0x1c94, 0xfc41, 0xa3f2, 0xd2b8, 0x8d0b, 0x6dde, 0x326d, 0x6413, 0x3ba0, 0xdb75, 0x84c6,
            0x7789, 0x283a, 0xc8ef, 0x975c, 0xc122, 0x9e91, 0x7e44, 0x21f7, 0x9cd0, 0xc363, 0x23b6,
            0x7c05, 0x2a7b, 0x75c8, 0x951d, 0xcaae, 0x39e1, 0x6652, 0x8687, 0xd934, 0x8f4a, 0xd0f9,
            0x302c, 0x6f9f, 0x1ed5, 0x4166, 0xa1b3, 0xfe00, 0xa87e, 0xf7cd, 0x1718, 0x48ab, 0xbbe4,
            0xe457, 0x0482, 0x5b31, 0x0d4f, 0x52fc, 0xb229, 0xed9a, 0xa17a, 0xfec9, 0x1e1c, 0x41af,
            0x17d1, 0x4862, 0xa8b7, 0xf704, 0x044b, 0x5bf8, 0xbb2d, 0xe49e, 0xb2e0, 0xed53, 0x0d86,
            0x5235, 0x237f, 0x7ccc, 0x9c19, 0xc3aa, 0x95d4, 0xca67, 0x2ab2, 0x7501, 0x864e, 0xd9fd,
            0x3928, 0x669b, 0x30e5, 0x6f56, 0x8f83, 0xd030, 0x6d17, 0x32a4, 0xd271, 0x8dc2, 0xdbbc,
            0x840f, 0x64da, 0x3b69, 0xc826, 0x9795, 0x7740, 0x28f3, 0x7e8d, 0x213e, 0xc1eb, 0x9e58,
            0xef12, 0xb0a1, 0x5074, 0x0fc7, 0x59b9, 0x060a, 0xe6df, 0xb96c, 0x4a23, 0x1590, 0xf545,
            0xaaf6, 0xfc88, 0xa33b, 0x43ee, 0x1c5d, 0xf1c7, 0xae74, 0x4ea1, 0x1112, 0x476c, 0x18df,
            0xf80a, 0xa7b9, 0x54f6, 0x0b45, 0xeb90, 0xb423, 0xe25d, 0xbdee, 0x5d3b, 0x0288, 0x73c2,
            0x2c71, 0xcca4, 0x9317, 0xc569, 0x9ada, 0x7a0f, 0x25bc, 0xd6f3, 0x8940, 0x6995, 0x3626,
            0x6058, 0x3feb, 0xdf3e, 0x808d, 0x3daa, 0x6219, 0x82cc, 0xdd7f, 0x8b01, 0xd4b2, 0x3467,
            0x6bd4, 0x989b, 0xc728, 0x27fd, 0x784e, 0x2e30, 0x7183, 0x9156, 0xcee5, 0xbfaf, 0xe01c,
            0x00c9, 0x5f7a, 0x0904, 0x56b7, 0xb662, 0xe9d1, 0x1a9e, 0x452d, 0xa5f8, 0xfa4b, 0xac35,
            0xf386, 0x1353, 0x4ce0,
        ],
        [
            0x0000, 0x8a93, 0xdd41, 0x57d2, 0x72e5, 0xf876, 0xafa4, 0x2537, 0xe5ca, 0x6f59, 0x388b,
            0xb218, 0x972f, 0x1dbc, 0x4a6e, 0xc0fd, 0x03f3, 0x8960, 0xdeb2, 0x5421, 0x7116, 0xfb85,
            0xac57, 0x26c4, 0xe639, 0x6caa, 0x3b78, 0xb1eb, 0x94dc, 0x1e4f, 0x499d, 0xc30e, 0x07e6,
            0x8d75, 0xdaa7, 0x5034, 0x7503, 0xff90, 0xa842, 0x22d1, 0xe22c, 0x68bf, 0x3f6d, 0xb5fe,
            0x90c9, 0x1a5a, 0x4d88, 0xc71b, 0x0415, 0x8e86, 0xd954, 0x53c7, 0x76f0, 0xfc63, 0xabb1,
            0x2122, 0xe1df, 0x6b4c, 0x3c9e, 0xb60d, 0x933a, 0x19a9, 0x4e7b, 0xc4e8, 0x0fcc, 0x855f,
            0xd28d, 0x581e, 0x7d29, 0xf7ba, 0xa068, 0x2afb, 0xea06, 0x6095, 0x3747, 0xbdd4, 0x98e3,
            0x1270, 0x45a2, 0xcf31, 0x0c3f, 0x86ac, 0xd17e, 0x5bed, 0x7eda, 0xf449, 0xa39b, 0x2908,
            0xe9f5, 0x6366, 0x34b4, 0xbe27, 0x9b10, 0x1183, 0x4651, 0xccc2, 0x082a, 0x82b9, 0xd56b,
            0x5ff8, 0x7acf, 0xf05c, 0xa78e, 0x2d1d, 0xede0, 0x6773, 0x30a1, 0xba32, 0x9f05, 0x1596,
            0x4244, 0xc8d7, 0x0bd9, 0x814a, 0xd698, 0x5c0b, 0x793c, 0xf3af, 0xa47d, 0x2eee, 0xee13,
            0x6480, 0x3352, 0xb9c1, 0x9cf6, 0x1665, 0x41b7, 0xcb24, 0x1f98, 0x950b, 0xc2d9, 0x484a,
            0x6d7d, 0xe7ee, 0xb03c, 0x3aaf, 0xfa52, 0x70c1, 0x2713, 0xad80, 0x88b7, 0x0224, 0x55f6,
            0xdf65, 0x1c6b, 0x96f8, 0xc12a, 0x4bb9, 0x6e8e, 0xe41d, 0xb3cf, 0x395c, 0xf9a1, 0x7332,
            0x24e0, 0xae73, 0x8b44, 0x01d7, 0x5605, 0xdc96, 0x187e, 0x92ed, 0xc53f, 0x4fac, 0x6a9b,
            0xe008, 0xb7da, 0x3d49, 0xfdb4, 0x7727, 0x20f5, 0xaa66, 0x8f51, 0x05c2, 0x5210, 0xd883,
            0x1b8d, 0x911e, 0xc6cc, 0x4c5f, 0x6968, 0xe3fb, 0xb429, 0x3eba, 0xfe47, 0x74d4, 0x2306,
            0xa995, 0x8ca2, 0x0631, 0x51e3, 0xdb70, 0x1054, 0x9ac7, 0xcd15, 0x4786, 0x62b1, 0xe822,
            0xbff0, 0x3563, 0xf59e, 0x7f0d, 0x28df, 0xa24c, 0x877b, 0x0de8, 0x5a3a, 0xd0a9, 0x13a7,
            0x9934, 0xcee6, 0x4475, 0x6142, 0xebd1, 0xbc03, 0x3690, 0xf66d, 0x7cfe, 0x2b2c, 0xa1bf,
            0x8488, 0x0e1b, 0x59c9, 0xd35a, 0x17b2, 0x9d21, 0xcaf3, 0x4060, 0x6557, 0xefc4, 0xb816,
            0x3285, 0xf278, 0x78eb, 0x2f39, 0xa5aa, 0x809d, 0x0a0e, 0x5ddc, 0xd74f, 0x1441, 0x9ed2,
            0xc900, 0x4393, 0x66a4, 0xec37, 0xbbe5, 0x3176, 0xf18b, 0x7b18, 0x2cca, 0xa659, 0x836e,
            0x09fd, 0x5e2f, 0xd4bc,
        ],
        [
            0x0000, 0x3f30, 0x7e60, 0x4150, 0xfcc0, 0xc3f0, 0x82a0, 0xbd90, 0x31e7, 0x0ed7, 0x4f87,
            0x70b7, 0xcd27, 0xf217, 0xb347, 0x8c77, 0x63ce, 0x5cfe, 0x1dae, 0x229e, 0x9f0e, 0xa03e,
            0xe16e, 0xde5e, 0x5229, 0x6d19, 0x2c49, 0x1379, 0xaee9, 0x91d9, 0xd089, 0xefb9, 0xc79c,
            0xf8ac, 0xb9fc, 0x86cc, 0x3b5c, 0x046c, 0x453c, 0x7a0c, 0xf67b, 0xc94b, 0x881b, 0xb72b,
            0x0abb, 0x358b, 0x74db, 0x4beb, 0xa452, 0x9b62, 0xda32, 0xe502, 0x5892, 0x67a2, 0x26f2,
            0x19c2, 0x95b5, 0xaa85, 0xebd5, 0xd4e5, 0x6975, 0x5645, 0x1715, 0x2825, 0x475f, 0x786f,
            0x393f, 0x060f, 0xbb9f, 0x84af, 0xc5ff, 0xfacf, 0x76b8, 0x4988, 0x08d8, 0x37e8, 0x8a78,
            0xb548, 0xf418, 0xcb28, 0x2491, 0x1ba1, 0x5af1, 0x65c1, 0xd851, 0xe761, 0xa631, 0x9901,
            0x1576, 0x2a46, 0x6b16, 0x5426, 0xe9b6, 0xd686, 0x97d6, 0xa8e6, 0x80c3, 0xbff3, 0xfea3,
            0xc193, 0x7c03, 0x4333, 0x0263, 0x3d53, 0xb124, 0x8e14, 0xcf44, 0xf074, 0x4de4, 0x72d4,
            0x3384, 0x0cb4, 0xe30d, 0xdc3d, 0x9d6d, 0xa25d, 0x1fcd, 0x20fd, 0x61ad, 0x5e9d, 0xd2ea,
            0xedda, 0xac8a, 0x93ba, 0x2e2a, 0x111a, 0x504a, 0x6f7a, 0x8ebe, 0xb18e, 0xf0de, 0xcfee,
            0x727e, 0x4d4e, 0x0c1e, 0x332e, 0xbf59, 0x8069, 0xc139, 0xfe09, 0x4399, 0x7ca9, 0x3df9,
            0x02c9, 0xed70, 0xd240, 0x9310, 0xac20, 0x11b0, 0x2e80, 0x6fd0, 0x50e0, 0xdc97, 0xe3a7,
            0xa2f7, 0x9dc7, 0x2057, 0x1f67, 0x5e37, 0x6107, 0x4922, 0x7612, 0x3742, 0x0872, 0xb5e2,
            0x8ad2, 0xcb82, 0xf4b2, 0x78c5, 0x47f5, 0x06a5, 0x3995, 0x8405, 0xbb35, 0xfa65, 0xc555,
            0x2aec, 0x15dc, 0x548c, 0x6bbc, 0xd62c, 0xe91c, 0xa84c, 0x977c, 0x1b0b, 0x243b, 0x656b,
            0x5a5b, 0xe7cb, 0xd8fb, 0x99ab, 0xa69b, 0xc9e1, 0xf6d1, 0xb781, 0x88b1, 0x3521, 0x0a11,
            0x4b41, 0x7471, 0xf806, 0xc736, 0x8666, 0xb956, 0x04c6, 0x3bf6, 0x7aa6, 0x4596, 0xaa2f,
            0x951f, 0xd44f, 0xeb7f, 0x56ef, 0x69df, 0x288f, 0x17bf, 0x9bc8, 0xa4f8, 0xe5a8, 0xda98,
            0x6708, 0x5838, 0x1968, 0x2658, 0x0e7d, 0x314d, 0x701d, 0x4f2d, 0xf2bd, 0xcd8d, 0x8cdd,
            0xb3ed, 0x3f9a, 0x00aa, 0x41fa, 0x7eca, 0xc35a, 0xfc6a, 0xbd3a, 0x820a, 0x6db3, 0x5283,
            0x13d3, 0x2ce3, 0x9173, 0xae43, 0xef13, 0xd023, 0x5c54, 0x6364, 0x2234, 0x1d04, 0xa094,
            0x9fa4, 0xdef4, 0xe1c4,
        ],
        [
            0x0000, 0xd51b, 0x6251, 0xb74a, 0xc4a2, 0x11b9, 0xa6f3, 0x73e8, 0x4123, 0x9438, 0x2372,
            0xf669, 0x8581, 0x509a, 0xe7d0, 0x32cb, 0x8246, 0x575d, 0xe017, 0x350c, 0x46e4, 0x93ff,
            0x24b5, 0xf1ae, 0xc365, 0x167e, 0xa134, 0x742f, 0x07c7, 0xd2dc, 0x6596, 0xb08d, 0xcceb,
            0x19f0, 0xaeba, 0x7ba1, 0x0849, 0xdd52, 0x6a18, 0xbf03, 0x8dc8, 0x58d3, 0xef99, 0x3a82,
            0x496a, 0x9c71, 0x2b3b, 0xfe20, 0x4ead, 0x9bb6, 0x2cfc, 0xf9e7, 0x8a0f, 0x5f14, 0xe85e,
            0x3d45, 0x0f8e, 0xda95, 0x6ddf, 0xb8c4, 0xcb2c, 0x1e37, 0xa97d, 0x7c66, 0x51b1, 0x84aa,
            0x33e0, 0xe6fb, 0x9513, 0x4008, 0xf742, 0x2259, 0x1092, 0xc589, 0x72c3, 0xa7d8, 0xd430,
            0x012b, 0xb661, 0x637a, 0xd3f7, 0x06ec, 0xb1a6, 0x64bd, 0x1755, 0xc24e, 0x7504, 0xa01f,
            0x92d4, 0x47cf, 0xf085, 0x259e, 0x5676, 0x836d, 0x3427, 0xe13c, 0x9d5a, 0x4841, 0xff0b,
            0x2a10, 0x59f8, 0x8ce3, 0x3ba9, 0xeeb2, 0xdc79, 0x0962, 0xbe28, 0x6b33, 0x18db, 0xcdc0,
            0x7a8a, 0xaf91, 0x1f1c, 0xca07, 0x7d4d, 0xa856, 0xdbbe, 0x0ea5, 0xb9ef, 0x6cf4, 0x5e3f,
            0x8b24, 0x3c6e, 0xe975, 0x9a9d, 0x4f86, 0xf8cc, 0x2dd7, 0xa362, 0x7679, 0xc133, 0x1428,
            0x67c0, 0xb2db, 0x0591, 0xd08a, 0xe241, 0x375a, 0x8010, 0x550b, 0x26e3, 0xf3f8, 0x44b2,
            0x91a9, 0x2124, 0xf43f, 0x4375, 0x966e, 0xe586, 0x309d, 0x87d7, 0x52cc, 0x6007, 0xb51c,
            0x0256, 0xd74d, 0xa4a5, 0x71be, 0xc6f4, 0x13ef, 0x6f89, 0xba92, 0x0dd8, 0xd8c3, 0xab2b,
            0x7e30, 0xc97a, 0x1c61, 0x2eaa, 0xfbb1, 0x4cfb, 0x99e0, 0xea08, 0x3f13, 0x8859, 0x5d42,
            0xedcf, 0x38d4, 0x8f9e, 0x5a85, 0x296d, 0xfc76, 0x4b3c, 0x9e27, 0xacec, 0x79f7, 0xcebd,
            0x1ba6, 0x684e, 0xbd55, 0x0a1f, 0xdf04, 0xf2d3, 0x27c8, 0x9082, 0x4599, 0x3671, 0xe36a,
            0x5420, 0x813b, 0xb3f0, 0x66eb, 0xd1a1, 0x04ba, 0x7752, 0xa249, 0x1503, 0xc018, 0x7095,
            0xa58e, 0x12c4, 0xc7df, 0xb437, 0x612c, 0xd666, 0x037d, 0x31b6, 0xe4ad, 0x53e7, 0x86fc,
            0xf514, 0x200f, 0x9745, 0x425e, 0x3e38, 0xeb23, 0x5c69, 0x8972, 0xfa9a, 0x2f81, 0x98cb,
            0x4dd0, 0x7f1b, 0xaa00, 0x1d4a, 0xc851, 0xbbb9, 0x6ea2, 0xd9e8, 0x0cf3, 0xbc7e, 0x6965,
            0xde2f, 0x0b34, 0x78dc, 0xadc7, 0x1a8d, 0xcf96, 0xfd5d, 0x2846, 0x9f0c, 0x4a17, 0x39ff,
            0xece4, 0x5bae, 0x8eb5,
        ],
        [
            0x0000, 0x8ea3, 0xd521, 0x5b82, 0x6225, 0xec86, 0xb704, 0x39a7, 0xc44a, 0x4ae9, 0x116b,
            0x9fc8, 0xa66f, 0x28cc, 0x734e, 0xfded, 0x40f3, 0xce50, 0x95d2, 0x1b71, 0x22d6, 0xac75,
            0xf7f7, 0x7954, 0x84b9, 0x0a1a, 0x5198, 0xdf3b, 0xe69c, 0x683f, 0x33bd, 0xbd1e, 0x81e6,
            0x0f45, 0x54c7, 0xda64, 0xe3c3, 0x6d60, 0x36e2, 0xb841, 0x45ac, 0xcb0f, 0x908d, 0x1e2e,
            0x2789, 0xa92a, 0xf2a8, 0x7c0b, 0xc115, 0x4fb6, 0x1434, 0x9a97, 0xa330, 0x2d93, 0x7611,
            0xf8b2, 0x055f, 0x8bfc, 0xd07e, 0x5edd, 0x677a, 0xe9d9, 0xb25b, 0x3cf8, 0xcbab, 0x4508,
            0x1e8a, 0x9029, 0xa98e, 0x272d, 0x7caf, 0xf20c, 0x0fe1, 0x8142, 0xdac0, 0x5463, 0x6dc4,
            0xe367, 0xb8e5, 0x3646, 0x8b58, 0x05fb, 0x5e79, 0xd0da, 0xe97d, 0x67de, 0x3c5c, 0xb2ff,
            0x4f12, 0xc1b1, 0x9a33, 0x1490, 0x2d37, 0xa394, 0xf816, 0x76b5, 0x4a4d, 0xc4ee, 0x9f6c,
            0x11cf, 0x2868, 0xa6cb, 0xfd49, 0x73ea, 0x8e07, 0x00a4, 0x5b26, 0xd585, 0xec22, 0x6281,
            0x3903, 0xb7a0, 0x0abe, 0x841d, 0xdf9f, 0x513c, 0x689b, 0xe638, 0xbdba, 0x3319, 0xcef4,
            0x4057, 0x1bd5, 0x9576, 0xacd1, 0x2272, 0x79f0, 0xf753, 0x5f31, 0xd192, 0x8a10, 0x04b3,
            0x3d14, 0xb3b7, 0xe835, 0x6696, 0x9b7b, 0x15d8, 0x4e5a, 0xc0f9, 0xf95e, 0x77fd, 0x2c7f,
            0xa2dc, 0x1fc2, 0x9161, 0xcae3, 0x4440, 0x7de7, 0xf344, 0xa8c6, 0x2665, 0xdb88, 0x552b,
            0x0ea9, 0x800a, 0xb9ad, 0x370e, 0x6c8c, 0xe22f, 0xded7, 0x5074, 0x0bf6, 0x8555, 0xbcf2,
            0x3251, 0x69d3, 0xe770, 0x1a9d, 0x943e, 0xcfbc, 0x411f, 0x78b8, 0xf61b, 0xad99, 0x233a,
            0x9e24, 0x1087, 0x4b05, 0xc5a6, 0xfc01, 0x72a2, 0x2920, 0xa783, 0x5a6e, 0xd4cd, 0x8f4f,
            0x01ec, 0x384b, 0xb6e8, 0xed6a, 0x63c9, 0x949a, 0x1a39, 0x41bb, 0xcf18, 0xf6bf, 0x781c,
            0x239e, 0xad3d, 0x50d0, 0xde73, 0x85f1, 0x0b52, 0x32f5, 0xbc56, 0xe7d4, 0x6977, 0xd469,
            0x5aca, 0x0148, 0x8feb, 0xb64c, 0x38ef, 0x636d, 0xedce, 0x1023, 0x9e80, 0xc502, 0x4ba1,
            0x7206, 0xfca5, 0xa727, 0x2984, 0x157c, 0x9bdf, 0xc05d, 0x4efe, 0x7759, 0xf9fa, 0xa278,
            0x2cdb, 0xd136, 0x5f95, 0x0417, 0x8ab4, 0xb313, 0x3db0, 0x6632, 0xe891, 0x558f, 0xdb2c,
            0x80ae, 0x0e0d, 0x37aa, 0xb909, 0xe28b, 0x6c28, 0x91c5, 0x1f66, 0x44e4, 0xca47, 0xf3e0,
            0x7d43, 0x26c1, 0xa862,
        ],
        [
            0x0000, 0xbe62, 0xb4a3, 0x0ac1, 0xa121, 0x1f43, 0x1582, 0xabe0, 0x8a25, 0x3447, 0x3e86,
            0x80e4, 0x2b04, 0x9566, 0x9fa7, 0x21c5, 0xdc2d, 0x624f, 0x688e, 0xd6ec, 0x7d0c, 0xc36e,
            0xc9af, 0x77cd, 0x5608, 0xe86a, 0xe2ab, 0x5cc9, 0xf729, 0x494b, 0x438a, 0xfde8, 0x703d,
            0xce5f, 0xc49e, 0x7afc, 0xd11c, 0x6f7e, 0x65bf, 0xdbdd, 0xfa18, 0x447a, 0x4ebb, 0xf0d9,
            0x5b39, 0xe55b, 0xef9a, 0x51f8, 0xac10, 0x1272, 0x18b3, 0xa6d1, 0x0d31, 0xb353, 0xb992,
            0x07f0, 0x2635, 0x9857, 0x9296, 0x2cf4, 0x8714, 0x3976, 0x33b7, 0x8dd5, 0xe07a, 0x5e18,
            0x54d9, 0xeabb, 0x415b, 0xff39, 0xf5f8, 0x4b9a, 0x6a5f, 0xd43d, 0xdefc, 0x609e, 0xcb7e,
            0x751c, 0x7fdd, 0xc1bf, 0x3c57, 0x8235, 0x88f4, 0x3696, 0x9d76, 0x2314, 0x29d5, 0x97b7,
            0xb672, 0x0810, 0x02d1, 0xbcb3, 0x1753, 0xa931, 0xa3f0, 0x1d92, 0x9047, 0x2e25, 0x24e4,
            0x9a86, 0x3166, 0x8f04, 0x85c5, 0x3ba7, 0x1a62, 0xa400, 0xaec1, 0x10a3, 0xbb43, 0x0521,
            0x0fe0, 0xb182, 0x4c6a, 0xf208, 0xf8c9, 0x46ab, 0xed4b, 0x5329, 0x59e8, 0xe78a, 0xc64f,
            0x782d, 0x72ec, 0xcc8e, 0x676e, 0xd90c, 0xd3cd, 0x6daf, 0x0893, 0xb6f1, 0xbc30, 0x0252,
            0xa9b2, 0x17d0, 0x1d11, 0xa373, 0x82b6, 0x3cd4, 0x3615, 0x8877, 0x2397, 0x9df5, 0x9734,
            0x2956, 0xd4be, 0x6adc, 0x601d, 0xde7f, 0x759f, 0xcbfd, 0xc13c, 0x7f5e, 0x5e9b, 0xe0f9,
            0xea38, 0x545a, 0xffba, 0x41d8, 0x4b19, 0xf57b, 0x78ae, 0xc6cc, 0xcc0d, 0x726f, 0xd98f,
            0x67ed, 0x6d2c, 0xd34e, 0xf28b, 0x4ce9, 0x4628, 0xf84a, 0x53aa, 0xedc8, 0xe709, 0x596b,
            0xa483, 0x1ae1, 0x1020, 0xae42, 0x05a2, 0xbbc0, 0xb101, 0x0f63, 0x2ea6, 0x90c4, 0x9a05,
            0x2467, 0x8f87, 0x31e5, 0x3b24, 0x8546, 0xe8e9, 0x568b, 0x5c4a, 0xe228, 0x49c8, 0xf7aa,
            0xfd6b, 0x4309, 0x62cc, 0xdcae, 0xd66f, 0x680d, 0xc3ed, 0x7d8f, 0x774e, 0xc92c, 0x34c4,
            0x8aa6, 0x8067, 0x3e05, 0x95e5, 0x2b87, 0x2146, 0x9f24, 0xbee1, 0x0083, 0x0a42, 0xb420,
            0x1fc0, 0xa1a2, 0xab63, 0x1501, 0x98d4, 0x26b6, 0x2c77, 0x9215, 0x39f5, 0x8797, 0x8d56,
            0x3334, 0x12f1, 0xac93, 0xa652, 0x1830, 0xb3d0, 0x0db2, 0x0773, 0xb911, 0x44f9, 0xfa9b,
            0xf05a, 0x4e38, 0xe5d8, 0x5bba, 0x517b, 0xef19, 0xcedc, 0x70be, 0x7a7f, 0xc41d, 0x6ffd,
            0xd19f, 0xdb5e, 0x653c,
        ],
        [
            0x0000, 0x1126, 0x224c, 0x336a, 0x4498, 0x55be, 0x66d4, 0x77f2, 0x8930, 0x9816, 0xab7c,
            0xba5a, 0xcda8, 0xdc8e, 0xefe4, 0xfec2, 0xda07, 0xcb21, 0xf84b, 0xe96d, 0x9e9f, 0x8fb9,
            0xbcd3, 0xadf5, 0x5337, 0x4211, 0x717b, 0x605d, 0x17af, 0x0689, 0x35e3, 0x24c5, 0x7c69,
            0x6d4f, 0x5e25, 0x4f03, 0x38f1, 0x29d7, 0x1abd, 0x0b9b, 0xf559, 0xe47f, 0xd715, 0xc633,
            0xb1c1, 0xa0e7, 0x938d, 0x82ab, 0xa66e, 0xb748, 0x8422, 0x9504, 0xe2f6, 0xf3d0, 0xc0ba,
            0xd19c, 0x2f5e, 0x3e78, 0x0d12, 0x1c34, 0x6bc6, 0x7ae0, 0x498a, 0x58ac, 0xf8d2, 0xe9f4,
            0xda9e, 0xcbb8, 0xbc4a, 0xad6c, 0x9e06, 0x8f20, 0x71e2, 0x60c4, 0x53ae, 0x4288, 0x357a,
            0x245c, 0x1736, 0x0610, 0x22d5, 0x33f3, 0x0099, 0x11bf, 0x664d, 0x776b, 0x4401, 0x5527,
            0xabe5, 0xbac3, 0x89a9, 0x988f, 0xef7d, 0xfe5b, 0xcd31, 0xdc17, 0x84bb, 0x959d, 0xa6f7,
            0xb7d1, 0xc023, 0xd105, 0xe26f, 0xf349, 0x0d8b, 0x1cad, 0x2fc7, 0x3ee1, 0x4913, 0x5835,
            0x6b5f, 0x7a79, 0x5ebc, 0x4f9a, 0x7cf0, 0x6dd6, 0x1a24, 0x0b02, 0x3868, 0x294e, 0xd78c,
            0xc6aa, 0xf5c0, 0xe4e6, 0x9314, 0x8232, 0xb158, 0xa07e, 0x39c3, 0x28e5, 0x1b8f, 0x0aa9,
            0x7d5b, 0x6c7d, 0x5f17, 0x4e31, 0xb0f3, 0xa1d5, 0x92bf, 0x8399, 0xf46b, 0xe54d, 0xd627,
            0xc701, 0xe3c4, 0xf2e2, 0xc188, 0xd0ae, 0xa75c, 0xb67a, 0x8510, 0x9436, 0x6af4, 0x7bd2,
            0x48b8, 0x599e, 0x2e6c, 0x3f4a, 0x0c20, 0x1d06, 0x45aa, 0x548c, 0x67e6, 0x76c0, 0x0132,
            0x1014, 0x237e, 0x3258, 0xcc9a, 0xddbc, 0xeed6, 0xfff0, 0x8802, 0x9924, 0xaa4e, 0xbb68,
            0x9fad, 0x8e8b, 0xbde1, 0xacc7, 0xdb35, 0xca13, 0xf979, 0xe85f, 0x169d, 0x07bb, 0x34d1,
            0x25f7, 0x5205, 0x4323, 0x7049, 0x616f, 0xc111, 0xd037, 0xe35d, 0xf27b, 0x8589, 0x94af,
            0xa7c5, 0xb6e3, 0x4821, 0x5907, 0x6a6d, 0x7b4b, 0x0cb9, 0x1d9f, 0x2ef5, 0x3fd3, 0x1b16,
            0x0a30, 0x395a, 0x287c, 0x5f8e, 0x4ea8, 0x7dc2, 0x6ce4, 0x9226, 0x8300, 0xb06a, 0xa14c,
            0xd6be, 0xc798, 0xf4f2, 0xe5d4, 0xbd78, 0xac5e, 0x9f34, 0x8e12, 0xf9e0, 0xe8c6, 0xdbac,
            0xca8a, 0x3448, 0x256e, 0x1604, 0x0722, 0x70d0, 0x61f6, 0x529c, 0x43ba, 0x677f, 0x7659,
            0x4533, 0x5415, 0x23e7, 0x32c1, 0x01ab, 0x108d, 0xee4f, 0xff69, 0xcc03, 0xdd25, 0xaad7,
            0xbbf1, 0x889b, 0x99bd,
        ],
    ];

    pub static CRC16_CMS_TABLE: [[u16; 256]; 16] = [
        [
            0x0000, 0x8005, 0x800f, 0x000a, 0x801b, 0x001e, 0x0014, 0x8011, 0x8033, 0x0036, 0x003c,
            0x8039, 0x0028, 0x802d, 0x8027, 0x0022, 0x8063, 0x0066, 0x006c, 0x8069, 0x0078, 0x807d,
            0x8077, 0x0072, 0x0050, 0x8055, 0x805f, 0x005a, 0x804b, 0x004e, 0x0044, 0x8041, 0x80c3,
            0x00c6, 0x00cc, 0x80c9, 0x00d8, 0x80dd, 0x80d7, 0x00d2, 0x00f0, 0x80f5, 0x80ff, 0x00fa,
            0x80eb, 0x00ee, 0x00e4, 0x80e1, 0x00a0, 0x80a5, 0x80af, 0x00aa, 0x80bb, 0x00be, 0x00b4,
            0x80b1, 0x8093, 0x0096, 0x009c, 0x8099, 0x0088, 0x808d, 0x8087, 0x0082, 0x8183, 0x0186,
            0x018c, 0x8189, 0x0198, 0x819d, 0x8197, 0x0192, 0x01b0, 0x81b5, 0x81bf, 0x01ba, 0x81ab,
            0x01ae, 0x01a4, 0x81a1, 0x01e0, 0x81e5, 0x81ef, 0x01ea, 0x81fb, 0x01fe, 0x01f4, 0x81f1,
            0x81d3, 0x01d6, 0x01dc, 0x81d9, 0x01c8, 0x81cd, 0x81c7, 0x01c2, 0x0140, 0x8145, 0x814f,
            0x014a, 0x815b, 0x015e, 0x0154, 0x8151, 0x8173, 0x0176, 0x017c, 0x8179, 0x0168, 0x816d,
            0x8167, 0x0162, 0x8123, 0x0126, 0x012c, 0x8129, 0x0138, 0x813d, 0x8137, 0x0132, 0x0110,
            0x8115, 0x811f, 0x011a, 0x810b, 0x010e, 0x0104, 0x8101, 0x8303, 0x0306, 0x030c, 0x8309,
            0x0318, 0x831d, 0x8317, 0x0312, 0x0330, 0x8335, 0x833f, 0x033a, 0x832b, 0x032e, 0x0324,
            0x8321, 0x0360, 0x8365, 0x836f, 0x036a, 0x837b, 0x037e, 0x0374, 0x8371, 0x8353, 0x0356,
            0x035c, 0x8359, 0x0348, 0x834d, 0x8347, 0x0342, 0x03c0, 0x83c5, 0x83cf, 0x03ca, 0x83db,
            0x03de, 0x03d4, 0x83d1, 0x83f3, 0x03f6, 0x03fc, 0x83f9, 0x03e8, 0x83ed, 0x83e7, 0x03e2,
            0x83a3, 0x03a6, 0x03ac, 0x83a9, 0x03b8, 0x83bd, 0x83b7, 0x03b2, 0x0390, 0x8395, 0x839f,
            0x039a, 0x838b, 0x038e, 0x0384, 0x8381, 0x0280, 0x8285, 0x828f, 0x028a, 0x829b, 0x029e,
            0x0294, 0x8291, 0x82b3, 0x02b6, 0x02bc, 0x82b9, 0x02a8, 0x82ad, 0x82a7, 0x02a2, 0x82e3,
            0x02e6, 0x02ec, 0x82e9, 0x02f8, 0x82fd, 0x82f7, 0x02f2, 0x02d0, 0x82d5, 0x82df, 0x02da,
            0x82cb, 0x02ce, 0x02c4, 0x82c1, 0x8243, 0x0246, 0x024c, 0x8249, 0x0258, 0x825d, 0x8257,
            0x0252, 0x0270, 0x8275, 0x827f, 0x027a, 0x826b, 0x026e, 0x0264, 0x8261, 0x0220, 0x8225,
            0x822f, 0x022a, 0x823b, 0x023e, 0x0234, 0x8231, 0x8213, 0x0216, 0x021c, 0x8219, 0x0208,
            0x820d, 0x8207, 0x0202,
        ],
        [
            0x0000, 0x8603, 0x8c03, 0x0a00, 0x9803, 0x1e00, 0x1400, 0x9203, 0xb003, 0x3600, 0x3c00,
            0xba03, 0x2800, 0xae03, 0xa403, 0x2200, 0xe003, 0x6600, 0x6c00, 0xea03, 0x7800, 0xfe03,
            0xf403, 0x7200, 0x5000, 0xd603, 0xdc03, 0x5a00, 0xc803, 0x4e00, 0x4400, 0xc203, 0x4003,
            0xc600, 0xcc00, 0x4a03, 0xd800, 0x5e03, 0x5403, 0xd200, 0xf000, 0x7603, 0x7c03, 0xfa00,
            0x6803, 0xee00, 0xe400, 0x6203, 0xa000, 0x2603, 0x2c03, 0xaa00, 0x3803, 0xbe00, 0xb400,
            0x3203, 0x1003, 0x9600, 0x9c00, 0x1a03, 0x8800, 0x0e03, 0x0403, 0x8200, 0x8006, 0x0605,
            0x0c05, 0x8a06, 0x1805, 0x9e06, 0x9406, 0x1205, 0x3005, 0xb606, 0xbc06, 0x3a05, 0xa806,
            0x2e05, 0x2405, 0xa206, 0x6005, 0xe606, 0xec06, 0x6a05, 0xf806, 0x7e05, 0x7405, 0xf206,
            0xd006, 0x5605, 0x5c05, 0xda06, 0x4805, 0xce06, 0xc406, 0x4205, 0xc005, 0x4606, 0x4c06,
            0xca05, 0x5806, 0xde05, 0xd405, 0x5206, 0x7006, 0xf605, 0xfc05, 0x7a06, 0xe805, 0x6e06,
            0x6406, 0xe205, 0x2006, 0xa605, 0xac05, 0x2a06, 0xb805, 0x3e06, 0x3406, 0xb205, 0x9005,
            0x1606, 0x1c06, 0x9a05, 0x0806, 0x8e05, 0x8405, 0x0206, 0x8009, 0x060a, 0x0c0a, 0x8a09,
            0x180a, 0x9e09, 0x9409, 0x120a, 0x300a, 0xb609, 0xbc09, 0x3a0a, 0xa809, 0x2e0a, 0x240a,
            0xa209, 0x600a, 0xe609, 0xec09, 0x6a0a, 0xf809, 0x7e0a, 0x740a, 0xf209, 0xd009, 0x560a,
            0x5c0a, 0xda09, 0x480a, 0xce09, 0xc409, 0x420a, 0xc00a, 0x4609, 0x4c09, 0xca0a, 0x5809,
            0xde0a, 0xd40a, 0x5209, 0x7009, 0xf60a, 0xfc0a, 0x7a09, 0xe80a, 0x6e09, 0x6409, 0xe20a,
            0x2009, 0xa60a, 0xac0a, 0x2a09, 0xb80a, 0x3e09, 0x3409, 0xb20a, 0x900a, 0x1609, 0x1c09,
            0x9a0a, 0x0809, 0x8e0a, 0x840a, 0x0209, 0x000f, 0x860c, 0x8c0c, 0x0a0f, 0x980c, 0x1e0f,
            0x140f, 0x920c, 0xb00c, 0x360f, 0x3c0f, 0xba0c, 0x280f, 0xae0c, 0xa40c, 0x220f, 0xe00c,
            0x660f, 0x6c0f, 0xea0c, 0x780f, 0xfe0c, 0xf40c, 0x720f, 0x500f, 0xd60c, 0xdc0c, 0x5a0f,
            0xc80c, 0x4e0f, 0x440f, 0xc20c, 0x400c, 0xc60f, 0xcc0f, 0x4a0c, 0xd80f, 0x5e0c, 0x540c,
            0xd20f, 0xf00f, 0x760c, 0x7c0c, 0xfa0f, 0x680c, 0xee0f, 0xe40f, 0x620c, 0xa00f, 0x260c,
            0x2c0c, 0xaa0f, 0x380c, 0xbe0f, 0xb40f, 0x320c, 0x100c, 0x960f, 0x9c0f, 0x1a0c, 0x880f,
            0x0e0c, 0x040c, 0x820f,
        ],
        [
            0x0000, 0x8017, 0x802b, 0x003c, 0x8053, 0x0044, 0x0078, 0x806f, 0x80a3, 0x00b4, 0x0088,
            0x809f, 0x00f0, 0x80e7, 0x80db, 0x00cc, 0x8143, 0x0154, 0x0168, 0x817f, 0x0110, 0x8107,
            0x813b, 0x012c, 0x01e0, 0x81f7, 0x81cb, 0x01dc, 0x81b3, 0x01a4, 0x0198, 0x818f, 0x8283,
            0x0294, 0x02a8, 0x82bf, 0x02d0, 0x82c7, 0x82fb, 0x02ec, 0x0220, 0x8237, 0x820b, 0x021c,
            0x8273, 0x0264, 0x0258, 0x824f, 0x03c0, 0x83d7, 0x83eb, 0x03fc, 0x8393, 0x0384, 0x03b8,
            0x83af, 0x8363, 0x0374, 0x0348, 0x835f, 0x0330, 0x8327, 0x831b, 0x030c, 0x8503, 0x0514,
            0x0528, 0x853f, 0x0550, 0x8547, 0x857b, 0x056c, 0x05a0, 0x85b7, 0x858b, 0x059c, 0x85f3,
            0x05e4, 0x05d8, 0x85cf, 0x0440, 0x8457, 0x846b, 0x047c, 0x8413, 0x0404, 0x0438, 0x842f,
            0x84e3, 0x04f4, 0x04c8, 0x84df, 0x04b0, 0x84a7, 0x849b, 0x048c, 0x0780, 0x8797, 0x87ab,
            0x07bc, 0x87d3, 0x07c4, 0x07f8, 0x87ef, 0x8723, 0x0734, 0x0708, 0x871f, 0x0770, 0x8767,
            0x875b, 0x074c, 0x86c3, 0x06d4, 0x06e8, 0x86ff, 0x0690, 0x8687, 0x86bb, 0x06ac, 0x0660,
            0x8677, 0x864b, 0x065c, 0x8633, 0x0624, 0x0618, 0x860f, 0x8a03, 0x0a14, 0x0a28, 0x8a3f,
            0x0a50, 0x8a47, 0x8a7b, 0x0a6c, 0x0aa0, 0x8ab7, 0x8a8b, 0x0a9c, 0x8af3, 0x0ae4, 0x0ad8,
            0x8acf, 0x0b40, 0x8b57, 0x8b6b, 0x0b7c, 0x8b13, 0x0b04, 0x0b38, 0x8b2f, 0x8be3, 0x0bf4,
            0x0bc8, 0x8bdf, 0x0bb0, 0x8ba7, 0x8b9b, 0x0b8c, 0x0880, 0x8897, 0x88ab, 0x08bc, 0x88d3,
            0x08c4, 0x08f8, 0x88ef, 0x8823, 0x0834, 0x0808, 0x881f, 0x0870, 0x8867, 0x885b, 0x084c,
            0x89c3, 0x09d4, 0x09e8, 0x89ff, 0x0990, 0x8987, 0x89bb, 0x09ac, 0x0960, 0x8977, 0x894b,
            0x095c, 0x8933, 0x0924, 0x0918, 0x890f, 0x0f00, 0x8f17, 0x8f2b, 0x0f3c, 0x8f53, 0x0f44,
            0x0f78, 0x8f6f, 0x8fa3, 0x0fb4, 0x0f88, 0x8f9f, 0x0ff0, 0x8fe7, 0x8fdb, 0x0fcc, 0x8e43,
            0x0e54, 0x0e68, 0x8e7f, 0x0e10, 0x8e07, 0x8e3b, 0x0e2c, 0x0ee0, 0x8ef7, 0x8ecb, 0x0edc,
            0x8eb3, 0x0ea4, 0x0e98, 0x8e8f, 0x8d83, 0x0d94, 0x0da8, 0x8dbf, 0x0dd0, 0x8dc7, 0x8dfb,
            0x0dec, 0x0d20, 0x8d37, 0x8d0b, 0x0d1c, 0x8d73, 0x0d64, 0x0d58, 0x8d4f, 0x0cc0, 0x8cd7,
            0x8ceb, 0x0cfc, 0x8c93, 0x0c84, 0x0cb8, 0x8caf, 0x8c63, 0x0c74, 0x0c48, 0x8c5f, 0x0c30,
            0x8c27, 0x8c1b, 0x0c0c,
        ],
        [
            0x0000, 0x9403, 0xa803, 0x3c00, 0xd003, 0x4400, 0x7800, 0xec03, 0x2003, 0xb400, 0x8800,
            0x1c03, 0xf000, 0x6403, 0x5803, 0xcc00, 0x4006, 0xd405, 0xe805, 0x7c06, 0x9005, 0x0406,
            0x3806, 0xac05, 0x6005, 0xf406, 0xc806, 0x5c05, 0xb006, 0x2405, 0x1805, 0x8c06, 0x800c,
            0x140f, 0x280f, 0xbc0c, 0x500f, 0xc40c, 0xf80c, 0x6c0f, 0xa00f, 0x340c, 0x080c, 0x9c0f,
            0x700c, 0xe40f, 0xd80f, 0x4c0c, 0xc00a, 0x5409, 0x6809, 0xfc0a, 0x1009, 0x840a, 0xb80a,
            0x2c09, 0xe009, 0x740a, 0x480a, 0xdc09, 0x300a, 0xa409, 0x9809, 0x0c0a, 0x801d, 0x141e,
            0x281e, 0xbc1d, 0x501e, 0xc41d, 0xf81d, 0x6c1e, 0xa01e, 0x341d, 0x081d, 0x9c1e, 0x701d,
            0xe41e, 0xd81e, 0x4c1d, 0xc01b, 0x5418, 0x6818, 0xfc1b, 0x1018, 0x841b, 0xb81b, 0x2c18,
            0xe018, 0x741b, 0x481b, 0xdc18, 0x301b, 0xa418, 0x9818, 0x0c1b, 0x0011, 0x9412, 0xa812,
            0x3c11, 0xd012, 0x4411, 0x7811, 0xec12, 0x2012, 0xb411, 0x8811, 0x1c12, 0xf011, 0x6412,
            0x5812, 0xcc11, 0x4017, 0xd414, 0xe814, 0x7c17, 0x9014, 0x0417, 0x3817, 0xac14, 0x6014,
            0xf417, 0xc817, 0x5c14, 0xb017, 0x2414, 0x1814, 0x8c17, 0x803f, 0x143c, 0x283c, 0xbc3f,
            0x503c, 0xc43f, 0xf83f, 0x6c3c, 0xa03c, 0x343f, 0x083f, 0x9c3c, 0x703f, 0xe43c, 0xd83c,
            0x4c3f, 0xc039, 0x543a, 0x683a, 0xfc39, 0x103a, 0x8439, 0xb839, 0x2c3a, 0xe03a, 0x7439,
            0x4839, 0xdc3a, 0x3039, 0xa43a, 0x983a, 0x0c39, 0x0033, 0x9430, 0xa830, 0x3c33, 0xd030,
            0x4433, 0x7833, 0xec30, 0x2030, 0xb433, 0x8833, 0x1c30, 0xf033, 0x6430, 0x5830, 0xcc33,
            0x4035, 0xd436, 0xe836, 0x7c35, 0x9036, 0x0435, 0x3835, 0xac36, 0x6036, 0xf435, 0xc835,
            0x5c36, 0xb035, 0x2436, 0x1836, 0x8c35, 0x0022, 0x9421, 0xa821, 0x3c22, 0xd021, 0x4422,
            0x7822, 0xec21, 0x2021, 0xb422, 0x8822, 0x1c21, 0xf022, 0x6421, 0x5821, 0xcc22, 0x4024,
            0xd427, 0xe827, 0x7c24, 0x9027, 0x0424, 0x3824, 0xac27, 0x6027, 0xf424, 0xc824, 0x5c27,
            0xb024, 0x2427, 0x1827, 0x8c24, 0x802e, 0x142d, 0x282d, 0xbc2e, 0x502d, 0xc42e, 0xf82e,
            0x6c2d, 0xa02d, 0x342e, 0x082e, 0x9c2d, 0x702e, 0xe42d, 0xd82d, 0x4c2e, 0xc028, 0x542b,
            0x682b, 0xfc28, 0x102b, 0x8428, 0xb828, 0x2c2b, 0xe02b, 0x7428, 0x4828, 0xdc2b, 0x3028,
            0xa42b, 0x982b, 0x0c28,
        ],
        [
            0x0000, 0x807b, 0x80f3, 0x0088, 0x81e3, 0x0198, 0x0110, 0x816b, 0x83c3, 0x03b8, 0x0330,
            0x834b, 0x0220, 0x825b, 0x82d3, 0x02a8, 0x8783, 0x07f8, 0x0770, 0x870b, 0x0660, 0x861b,
            0x8693, 0x06e8, 0x0440, 0x843b, 0x84b3, 0x04c8, 0x85a3, 0x05d8, 0x0550, 0x852b, 0x8f03,
            0x0f78, 0x0ff0, 0x8f8b, 0x0ee0, 0x8e9b, 0x8e13, 0x0e68, 0x0cc0, 0x8cbb, 0x8c33, 0x0c48,
            0x8d23, 0x0d58, 0x0dd0, 0x8dab, 0x0880, 0x88fb, 0x8873, 0x0808, 0x8963, 0x0918, 0x0990,
            0x89eb, 0x8b43, 0x0b38, 0x0bb0, 0x8bcb, 0x0aa0, 0x8adb, 0x8a53, 0x0a28, 0x9e03, 0x1e78,
            0x1ef0, 0x9e8b, 0x1fe0, 0x9f9b, 0x9f13, 0x1f68, 0x1dc0, 0x9dbb, 0x9d33, 0x1d48, 0x9c23,
            0x1c58, 0x1cd0, 0x9cab, 0x1980, 0x99fb, 0x9973, 0x1908, 0x9863, 0x1818, 0x1890, 0x98eb,
            0x9a43, 0x1a38, 0x1ab0, 0x9acb, 0x1ba0, 0x9bdb, 0x9b53, 0x1b28, 0x1100, 0x917b, 0x91f3,
            0x1188, 0x90e3, 0x1098, 0x1010, 0x906b, 0x92c3, 0x12b8, 0x1230, 0x924b, 0x1320, 0x935b,
            0x93d3, 0x13a8, 0x9683, 0x16f8, 0x1670, 0x960b, 0x1760, 0x971b, 0x9793, 0x17e8, 0x1540,
            0x953b, 0x95b3, 0x15c8, 0x94a3, 0x14d8, 0x1450, 0x942b, 0xbc03, 0x3c78, 0x3cf0, 0xbc8b,
            0x3de0, 0xbd9b, 0xbd13, 0x3d68, 0x3fc0, 0xbfbb, 0xbf33, 0x3f48, 0xbe23, 0x3e58, 0x3ed0,
            0xbeab, 0x3b80, 0xbbfb, 0xbb73, 0x3b08, 0xba63, 0x3a18, 0x3a90, 0xbaeb, 0xb843, 0x3838,
            0x38b0, 0xb8cb, 0x39a0, 0xb9db, 0xb953, 0x3928, 0x3300, 0xb37b, 0xb3f3, 0x3388, 0xb2e3,
            0x3298, 0x3210, 0xb26b, 0xb0c3, 0x30b8, 0x3030, 0xb04b, 0x3120, 0xb15b, 0xb1d3, 0x31a8,
            0xb483, 0x34f8, 0x3470, 0xb40b, 0x3560, 0xb51b, 0xb593, 0x35e8, 0x3740, 0xb73b, 0xb7b3,
            0x37c8, 0xb6a3, 0x36d8, 0x3650, 0xb62b, 0x2200, 0xa27b, 0xa2f3, 0x2288, 0xa3e3, 0x2398,
            0x2310, 0xa36b, 0xa1c3, 0x21b8, 0x2130, 0xa14b, 0x2020, 0xa05b, 0xa0d3, 0x20a8, 0xa583,
            0x25f8, 0x2570, 0xa50b, 0x2460, 0xa41b, 0xa493, 0x24e8, 0x2640, 0xa63b, 0xa6b3, 0x26c8,
            0xa7a3, 0x27d8, 0x2750, 0xa72b, 0xad03, 0x2d78, 0x2df0, 0xad8b, 0x2ce0, 0xac9b, 0xac13,
            0x2c68, 0x2ec0, 0xaebb, 0xae33, 0x2e48, 0xaf23, 0x2f58, 0x2fd0, 0xafab, 0x2a80, 0xaafb,
            0xaa73, 0x2a08, 0xab63, 0x2b18, 0x2b90, 0xabeb, 0xa943, 0x2938, 0x29b0, 0xa9cb, 0x28a0,
            0xa8db, 0xa853, 0x2828,
        ],
        [
            0x0000, 0xf803, 0x7003, 0x8800, 0xe006, 0x1805, 0x9005, 0x6806, 0x4009, 0xb80a, 0x300a,
            0xc809, 0xa00f, 0x580c, 0xd00c, 0x280f, 0x8012, 0x7811, 0xf011, 0x0812, 0x6014, 0x9817,
            0x1017, 0xe814, 0xc01b, 0x3818, 0xb018, 0x481b, 0x201d, 0xd81e, 0x501e, 0xa81d, 0x8021,
            0x7822, 0xf022, 0x0821, 0x6027, 0x9824, 0x1024, 0xe827, 0xc028, 0x382b, 0xb02b, 0x4828,
            0x202e, 0xd82d, 0x502d, 0xa82e, 0x0033, 0xf830, 0x7030, 0x8833, 0xe035, 0x1836, 0x9036,
            0x6835, 0x403a, 0xb839, 0x3039, 0xc83a, 0xa03c, 0x583f, 0xd03f, 0x283c, 0x8047, 0x7844,
            0xf044, 0x0847, 0x6041, 0x9842, 0x1042, 0xe841, 0xc04e, 0x384d, 0xb04d, 0x484e, 0x2048,
            0xd84b, 0x504b, 0xa848, 0x0055, 0xf856, 0x7056, 0x8855, 0xe053, 0x1850, 0x9050, 0x6853,
            0x405c, 0xb85f, 0x305f, 0xc85c, 0xa05a, 0x5859, 0xd059, 0x285a, 0x0066, 0xf865, 0x7065,
            0x8866, 0xe060, 0x1863, 0x9063, 0x6860, 0x406f, 0xb86c, 0x306c, 0xc86f, 0xa069, 0x586a,
            0xd06a, 0x2869, 0x8074, 0x7877, 0xf077, 0x0874, 0x6072, 0x9871, 0x1071, 0xe872, 0xc07d,
            0x387e, 0xb07e, 0x487d, 0x207b, 0xd878, 0x5078, 0xa87b, 0x808b, 0x7888, 0xf088, 0x088b,
            0x608d, 0x988e, 0x108e, 0xe88d, 0xc082, 0x3881, 0xb081, 0x4882, 0x2084, 0xd887, 0x5087,
            0xa884, 0x0099, 0xf89a, 0x709a, 0x8899, 0xe09f, 0x189c, 0x909c, 0x689f, 0x4090, 0xb893,
            0x3093, 0xc890, 0xa096, 0x5895, 0xd095, 0x2896, 0x00aa, 0xf8a9, 0x70a9, 0x88aa, 0xe0ac,
            0x18af, 0x90af, 0x68ac, 0x40a3, 0xb8a0, 0x30a0, 0xc8a3, 0xa0a5, 0x58a6, 0xd0a6, 0x28a5,
            0x80b8, 0x78bb, 0xf0bb, 0x08b8, 0x60be, 0x98bd, 0x10bd, 0xe8be, 0xc0b1, 0x38b2, 0xb0b2,
            0x48b1, 0x20b7, 0xd8b4, 0x50b4, 0xa8b7, 0x00cc, 0xf8cf, 0x70cf, 0x88cc, 0xe0ca, 0x18c9,
            0x90c9, 0x68ca, 0x40c5, 0xb8c6, 0x30c6, 0xc8c5, 0xa0c3, 0x58c0, 0xd0c0, 0x28c3, 0x80de,
            0x78dd, 0xf0dd, 0x08de, 0x60d8, 0x98db, 0x10db, 0xe8d8, 0xc0d7, 0x38d4, 0xb0d4, 0x48d7,
            0x20d1, 0xd8d2, 0x50d2, 0xa8d1, 0x80ed, 0x78ee, 0xf0ee, 0x08ed, 0x60eb, 0x98e8, 0x10e8,
            0xe8eb, 0xc0e4, 0x38e7, 0xb0e7, 0x48e4, 0x20e2, 0xd8e1, 0x50e1, 0xa8e2, 0x00ff, 0xf8fc,
            0x70fc, 0x88ff, 0xe0f9, 0x18fa, 0x90fa, 0x68f9, 0x40f6, 0xb8f5, 0x30f5, 0xc8f6, 0xa0f0,
            0x58f3, 0xd0f3, 0x28f0,
        ],
        [
            0x0000, 0x8113, 0x8223, 0x0330, 0x8443, 0x0550, 0x0660, 0x8773, 0x8883, 0x0990, 0x0aa0,
            0x8bb3, 0x0cc0, 0x8dd3, 0x8ee3, 0x0ff0, 0x9103, 0x1010, 0x1320, 0x9233, 0x1540, 0x9453,
            0x9763, 0x1670, 0x1980, 0x9893, 0x9ba3, 0x1ab0, 0x9dc3, 0x1cd0, 0x1fe0, 0x9ef3, 0xa203,
            0x2310, 0x2020, 0xa133, 0x2640, 0xa753, 0xa463, 0x2570, 0x2a80, 0xab93, 0xa8a3, 0x29b0,
            0xaec3, 0x2fd0, 0x2ce0, 0xadf3, 0x3300, 0xb213, 0xb123, 0x3030, 0xb743, 0x3650, 0x3560,
            0xb473, 0xbb83, 0x3a90, 0x39a0, 0xb8b3, 0x3fc0, 0xbed3, 0xbde3, 0x3cf0, 0xc403, 0x4510,
            0x4620, 0xc733, 0x4040, 0xc153, 0xc263, 0x4370, 0x4c80, 0xcd93, 0xcea3, 0x4fb0, 0xc8c3,
            0x49d0, 0x4ae0, 0xcbf3, 0x5500, 0xd413, 0xd723, 0x5630, 0xd143, 0x5050, 0x5360, 0xd273,
            0xdd83, 0x5c90, 0x5fa0, 0xdeb3, 0x59c0, 0xd8d3, 0xdbe3, 0x5af0, 0x6600, 0xe713, 0xe423,
            0x6530, 0xe243, 0x6350, 0x6060, 0xe173, 0xee83, 0x6f90, 0x6ca0, 0xedb3, 0x6ac0, 0xebd3,
            0xe8e3, 0x69f0, 0xf703, 0x7610, 0x7520, 0xf433, 0x7340, 0xf253, 0xf163, 0x7070, 0x7f80,
            0xfe93, 0xfda3, 0x7cb0, 0xfbc3, 0x7ad0, 0x79e0, 0xf8f3, 0x0803, 0x8910, 0x8a20, 0x0b33,
            0x8c40, 0x0d53, 0x0e63, 0x8f70, 0x8080, 0x0193, 0x02a3, 0x83b0, 0x04c3, 0x85d0, 0x86e0,
            0x07f3, 0x9900, 0x1813, 0x1b23, 0x9a30, 0x1d43, 0x9c50, 0x9f60, 0x1e73, 0x1183, 0x9090,
            0x93a0, 0x12b3, 0x95c0, 0x14d3, 0x17e3, 0x96f0, 0xaa00, 0x2b13, 0x2823, 0xa930, 0x2e43,
            0xaf50, 0xac60, 0x2d73, 0x2283, 0xa390, 0xa0a0, 0x21b3, 0xa6c0, 0x27d3, 0x24e3, 0xa5f0,
            0x3b03, 0xba10, 0xb920, 0x3833, 0xbf40, 0x3e53, 0x3d63, 0xbc70, 0xb380, 0x3293, 0x31a3,
            0xb0b0, 0x37c3, 0xb6d0, 0xb5e0, 0x34f3, 0xcc00, 0x4d13, 0x4e23, 0xcf30, 0x4843, 0xc950,
            0xca60, 0x4b73, 0x4483, 0xc590, 0xc6a0, 0x47b3, 0xc0c0, 0x41d3, 0x42e3, 0xc3f0, 0x5d03,
            0xdc10, 0xdf20, 0x5e33, 0xd940, 0x5853, 0x5b63, 0xda70, 0xd580, 0x5493, 0x57a3, 0xd6b0,
            0x51c3, 0xd0d0, 0xd3e0, 0x52f3, 0x6e03, 0xef10, 0xec20, 0x6d33, 0xea40, 0x6b53, 0x6863,
            0xe970, 0xe680, 0x6793, 0x64a3, 0xe5b0, 0x62c3, 0xe3d0, 0xe0e0, 0x61f3, 0xff00, 0x7e13,
            0x7d23, 0xfc30, 0x7b43, 0xfa50, 0xf960, 0x7873, 0x7783, 0xf690, 0xf5a0, 0x74b3, 0xf3c0,
            0x72d3, 0x71e3, 0xf0f0,
        ],
        [
            0x0000, 0x1006, 0x200c, 0x300a, 0x4018, 0x501e, 0x6014, 0x7012, 0x8030, 0x9036, 0xa03c,
            0xb03a, 0xc028, 0xd02e, 0xe024, 0xf022, 0x8065, 0x9063, 0xa069, 0xb06f, 0xc07d, 0xd07b,
            0xe071, 0xf077, 0x0055, 0x1053, 0x2059, 0x305f, 0x404d, 0x504b, 0x6041, 0x7047, 0x80cf,
            0x90c9, 0xa0c3, 0xb0c5, 0xc0d7, 0xd0d1, 0xe0db, 0xf0dd, 0x00ff, 0x10f9, 0x20f3, 0x30f5,
            0x40e7, 0x50e1, 0x60eb, 0x70ed, 0x00aa, 0x10ac, 0x20a6, 0x30a0, 0x40b2, 0x50b4, 0x60be,
            0x70b8, 0x809a, 0x909c, 0xa096, 0xb090, 0xc082, 0xd084, 0xe08e, 0xf088, 0x819b, 0x919d,
            0xa197, 0xb191, 0xc183, 0xd185, 0xe18f, 0xf189, 0x01ab, 0x11ad, 0x21a7, 0x31a1, 0x41b3,
            0x51b5, 0x61bf, 0x71b9, 0x01fe, 0x11f8, 0x21f2, 0x31f4, 0x41e6, 0x51e0, 0x61ea, 0x71ec,
            0x81ce, 0x91c8, 0xa1c2, 0xb1c4, 0xc1d6, 0xd1d0, 0xe1da, 0xf1dc, 0x0154, 0x1152, 0x2158,
            0x315e, 0x414c, 0x514a, 0x6140, 0x7146, 0x8164, 0x9162, 0xa168, 0xb16e, 0xc17c, 0xd17a,
            0xe170, 0xf176, 0x8131, 0x9137, 0xa13d, 0xb13b, 0xc129, 0xd12f, 0xe125, 0xf123, 0x0101,
            0x1107, 0x210d, 0x310b, 0x4119, 0x511f, 0x6115, 0x7113, 0x8333, 0x9335, 0xa33f, 0xb339,
            0xc32b, 0xd32d, 0xe327, 0xf321, 0x0303, 0x1305, 0x230f, 0x3309, 0x431b, 0x531d, 0x6317,
            0x7311, 0x0356, 0x1350, 0x235a, 0x335c, 0x434e, 0x5348, 0x6342, 0x7344, 0x8366, 0x9360,
            0xa36a, 0xb36c, 0xc37e, 0xd378, 0xe372, 0xf374, 0x03fc, 0x13fa, 0x23f0, 0x33f6, 0x43e4,
            0x53e2, 0x63e8, 0x73ee, 0x83cc, 0x93ca, 0xa3c0, 0xb3c6, 0xc3d4, 0xd3d2, 0xe3d8, 0xf3de,
            0x8399, 0x939f, 0xa395, 0xb393, 0xc381, 0xd387, 0xe38d, 0xf38b, 0x03a9, 0x13af, 0x23a5,
            0x33a3, 0x43b1, 0x53b7, 0x63bd, 0x73bb, 0x02a8, 0x12ae, 0x22a4, 0x32a2, 0x42b0, 0x52b6,
            0x62bc, 0x72ba, 0x8298, 0x929e, 0xa294, 0xb292, 0xc280, 0xd286, 0xe28c, 0xf28a, 0x82cd,
            0x92cb, 0xa2c1, 0xb2c7, 0xc2d5, 0xd2d3, 0xe2d9, 0xf2df, 0x02fd, 0x12fb, 0x22f1, 0x32f7,
            0x42e5, 0x52e3, 0x62e9, 0x72ef, 0x8267, 0x9261, 0xa26b, 0xb26d, 0xc27f, 0xd279, 0xe273,
            0xf275, 0x0257, 0x1251, 0x225b, 0x325d, 0x424f, 0x5249, 0x6243, 0x7245, 0x0202, 0x1204,
            0x220e, 0x3208, 0x421a, 0x521c, 0x6216, 0x7210, 0x8232, 0x9234, 0xa23e, 0xb238, 0xc22a,
            0xd22c, 0xe226, 0xf220,
        ],
        [
            0x0000, 0x8663, 0x8cc3, 0x0aa0, 0x9983, 0x1fe0, 0x1540, 0x9323, 0xb303, 0x3560, 0x3fc0,
            0xb9a3, 0x2a80, 0xace3, 0xa643, 0x2020, 0xe603, 0x6060, 0x6ac0, 0xeca3, 0x7f80, 0xf9e3,
            0xf343, 0x7520, 0x5500, 0xd363, 0xd9c3, 0x5fa0, 0xcc83, 0x4ae0, 0x4040, 0xc623, 0x4c03,
            0xca60, 0xc0c0, 0x46a3, 0xd580, 0x53e3, 0x5943, 0xdf20, 0xff00, 0x7963, 0x73c3, 0xf5a0,
            0x6683, 0xe0e0, 0xea40, 0x6c23, 0xaa00, 0x2c63, 0x26c3, 0xa0a0, 0x3383, 0xb5e0, 0xbf40,
            0x3923, 0x1903, 0x9f60, 0x95c0, 0x13a3, 0x8080, 0x06e3, 0x0c43, 0x8a20, 0x9806, 0x1e65,
            0x14c5, 0x92a6, 0x0185, 0x87e6, 0x8d46, 0x0b25, 0x2b05, 0xad66, 0xa7c6, 0x21a5, 0xb286,
            0x34e5, 0x3e45, 0xb826, 0x7e05, 0xf866, 0xf2c6, 0x74a5, 0xe786, 0x61e5, 0x6b45, 0xed26,
            0xcd06, 0x4b65, 0x41c5, 0xc7a6, 0x5485, 0xd2e6, 0xd846, 0x5e25, 0xd405, 0x5266, 0x58c6,
            0xdea5, 0x4d86, 0xcbe5, 0xc145, 0x4726, 0x6706, 0xe165, 0xebc5, 0x6da6, 0xfe85, 0x78e6,
            0x7246, 0xf425, 0x3206, 0xb465, 0xbec5, 0x38a6, 0xab85, 0x2de6, 0x2746, 0xa125, 0x8105,
            0x0766, 0x0dc6, 0x8ba5, 0x1886, 0x9ee5, 0x9445, 0x1226, 0xb009, 0x366a, 0x3cca, 0xbaa9,
            0x298a, 0xafe9, 0xa549, 0x232a, 0x030a, 0x8569, 0x8fc9, 0x09aa, 0x9a89, 0x1cea, 0x164a,
            0x9029, 0x560a, 0xd069, 0xdac9, 0x5caa, 0xcf89, 0x49ea, 0x434a, 0xc529, 0xe509, 0x636a,
            0x69ca, 0xefa9, 0x7c8a, 0xfae9, 0xf049, 0x762a, 0xfc0a, 0x7a69, 0x70c9, 0xf6aa, 0x6589,
            0xe3ea, 0xe94a, 0x6f29, 0x4f09, 0xc96a, 0xc3ca, 0x45a9, 0xd68a, 0x50e9, 0x5a49, 0xdc2a,
            0x1a09, 0x9c6a, 0x96ca, 0x10a9, 0x838a, 0x05e9, 0x0f49, 0x892a, 0xa90a, 0x2f69, 0x25c9,
            0xa3aa, 0x3089, 0xb6ea, 0xbc4a, 0x3a29, 0x280f, 0xae6c, 0xa4cc, 0x22af, 0xb18c, 0x37ef,
            0x3d4f, 0xbb2c, 0x9b0c, 0x1d6f, 0x17cf, 0x91ac, 0x028f, 0x84ec, 0x8e4c, 0x082f, 0xce0c,
            0x486f, 0x42cf, 0xc4ac, 0x578f, 0xd1ec, 0xdb4c, 0x5d2f, 0x7d0f, 0xfb6c, 0xf1cc, 0x77af,
            0xe48c, 0x62ef, 0x684f, 0xee2c, 0x640c, 0xe26f, 0xe8cf, 0x6eac, 0xfd8f, 0x7bec, 0x714c,
            0xf72f, 0xd70f, 0x516c, 0x5bcc, 0xddaf, 0x4e8c, 0xc8ef, 0xc24f, 0x442c, 0x820f, 0x046c,
            0x0ecc, 0x88af, 0x1b8c, 0x9def, 0x974f, 0x112c, 0x310c, 0xb76f, 0xbdcf, 0x3bac, 0xa88f,
            0x2eec, 0x244c, 0xa22f,
        ],
        [
            0x0000, 0xe017, 0x402b, 0xa03c, 0x8056, 0x6041, 0xc07d, 0x206a, 0x80a9, 0x60be, 0xc082,
            0x2095, 0x00ff, 0xe0e8, 0x40d4, 0xa0c3, 0x8157, 0x6140, 0xc17c, 0x216b, 0x0101, 0xe116,
            0x412a, 0xa13d, 0x01fe, 0xe1e9, 0x41d5, 0xa1c2, 0x81a8, 0x61bf, 0xc183, 0x2194, 0x82ab,
            0x62bc, 0xc280, 0x2297, 0x02fd, 0xe2ea, 0x42d6, 0xa2c1, 0x0202, 0xe215, 0x4229, 0xa23e,
            0x8254, 0x6243, 0xc27f, 0x2268, 0x03fc, 0xe3eb, 0x43d7, 0xa3c0, 0x83aa, 0x63bd, 0xc381,
            0x2396, 0x8355, 0x6342, 0xc37e, 0x2369, 0x0303, 0xe314, 0x4328, 0xa33f, 0x8553, 0x6544,
            0xc578, 0x256f, 0x0505, 0xe512, 0x452e, 0xa539, 0x05fa, 0xe5ed, 0x45d1, 0xa5c6, 0x85ac,
            0x65bb, 0xc587, 0x2590, 0x0404, 0xe413, 0x442f, 0xa438, 0x8452, 0x6445, 0xc479, 0x246e,
            0x84ad, 0x64ba, 0xc486, 0x2491, 0x04fb, 0xe4ec, 0x44d0, 0xa4c7, 0x07f8, 0xe7ef, 0x47d3,
            0xa7c4, 0x87ae, 0x67b9, 0xc785, 0x2792, 0x8751, 0x6746, 0xc77a, 0x276d, 0x0707, 0xe710,
            0x472c, 0xa73b, 0x86af, 0x66b8, 0xc684, 0x2693, 0x06f9, 0xe6ee, 0x46d2, 0xa6c5, 0x0606,
            0xe611, 0x462d, 0xa63a, 0x8650, 0x6647, 0xc67b, 0x266c, 0x8aa3, 0x6ab4, 0xca88, 0x2a9f,
            0x0af5, 0xeae2, 0x4ade, 0xaac9, 0x0a0a, 0xea1d, 0x4a21, 0xaa36, 0x8a5c, 0x6a4b, 0xca77,
            0x2a60, 0x0bf4, 0xebe3, 0x4bdf, 0xabc8, 0x8ba2, 0x6bb5, 0xcb89, 0x2b9e, 0x8b5d, 0x6b4a,
            0xcb76, 0x2b61, 0x0b0b, 0xeb1c, 0x4b20, 0xab37, 0x0808, 0xe81f, 0x4823, 0xa834, 0x885e,
            0x6849, 0xc875, 0x2862, 0x88a1, 0x68b6, 0xc88a, 0x289d, 0x08f7, 0xe8e0, 0x48dc, 0xa8cb,
            0x895f, 0x6948, 0xc974, 0x2963, 0x0909, 0xe91e, 0x4922, 0xa935, 0x09f6, 0xe9e1, 0x49dd,
            0xa9ca, 0x89a0, 0x69b7, 0xc98b, 0x299c, 0x0ff0, 0xefe7, 0x4fdb, 0xafcc, 0x8fa6, 0x6fb1,
            0xcf8d, 0x2f9a, 0x8f59, 0x6f4e, 0xcf72, 0x2f65, 0x0f0f, 0xef18, 0x4f24, 0xaf33, 0x8ea7,
            0x6eb0, 0xce8c, 0x2e9b, 0x0ef1, 0xeee6, 0x4eda, 0xaecd, 0x0e0e, 0xee19, 0x4e25, 0xae32,
            0x8e58, 0x6e4f, 0xce73, 0x2e64, 0x8d5b, 0x6d4c, 0xcd70, 0x2d67, 0x0d0d, 0xed1a, 0x4d26,
            0xad31, 0x0df2, 0xede5, 0x4dd9, 0xadce, 0x8da4, 0x6db3, 0xcd8f, 0x2d98, 0x0c0c, 0xec1b,
            0x4c27, 0xac30, 0x8c5a, 0x6c4d, 0xcc71, 0x2c66, 0x8ca5, 0x6cb2, 0xcc8e, 0x2c99, 0x0cf3,
            0xece4, 0x4cd8, 0xaccf,
        ],
        [
            0x0000, 0x9543, 0xaa83, 0x3fc0, 0xd503, 0x4040, 0x7f80, 0xeac3, 0x2a03, 0xbf40, 0x8080,
            0x15c3, 0xff00, 0x6a43, 0x5583, 0xc0c0, 0x5406, 0xc145, 0xfe85, 0x6bc6, 0x8105, 0x1446,
            0x2b86, 0xbec5, 0x7e05, 0xeb46, 0xd486, 0x41c5, 0xab06, 0x3e45, 0x0185, 0x94c6, 0xa80c,
            0x3d4f, 0x028f, 0x97cc, 0x7d0f, 0xe84c, 0xd78c, 0x42cf, 0x820f, 0x174c, 0x288c, 0xbdcf,
            0x570c, 0xc24f, 0xfd8f, 0x68cc, 0xfc0a, 0x6949, 0x5689, 0xc3ca, 0x2909, 0xbc4a, 0x838a,
            0x16c9, 0xd609, 0x434a, 0x7c8a, 0xe9c9, 0x030a, 0x9649, 0xa989, 0x3cca, 0xd01d, 0x455e,
            0x7a9e, 0xefdd, 0x051e, 0x905d, 0xaf9d, 0x3ade, 0xfa1e, 0x6f5d, 0x509d, 0xc5de, 0x2f1d,
            0xba5e, 0x859e, 0x10dd, 0x841b, 0x1158, 0x2e98, 0xbbdb, 0x5118, 0xc45b, 0xfb9b, 0x6ed8,
            0xae18, 0x3b5b, 0x049b, 0x91d8, 0x7b1b, 0xee58, 0xd198, 0x44db, 0x7811, 0xed52, 0xd292,
            0x47d1, 0xad12, 0x3851, 0x0791, 0x92d2, 0x5212, 0xc751, 0xf891, 0x6dd2, 0x8711, 0x1252,
            0x2d92, 0xb8d1, 0x2c17, 0xb954, 0x8694, 0x13d7, 0xf914, 0x6c57, 0x5397, 0xc6d4, 0x0614,
            0x9357, 0xac97, 0x39d4, 0xd317, 0x4654, 0x7994, 0xecd7, 0x203f, 0xb57c, 0x8abc, 0x1fff,
            0xf53c, 0x607f, 0x5fbf, 0xcafc, 0x0a3c, 0x9f7f, 0xa0bf, 0x35fc, 0xdf3f, 0x4a7c, 0x75bc,
            0xe0ff, 0x7439, 0xe17a, 0xdeba, 0x4bf9, 0xa13a, 0x3479, 0x0bb9, 0x9efa, 0x5e3a, 0xcb79,
            0xf4b9, 0x61fa, 0x8b39, 0x1e7a, 0x21ba, 0xb4f9, 0x8833, 0x1d70, 0x22b0, 0xb7f3, 0x5d30,
            0xc873, 0xf7b3, 0x62f0, 0xa230, 0x3773, 0x08b3, 0x9df0, 0x7733, 0xe270, 0xddb0, 0x48f3,
            0xdc35, 0x4976, 0x76b6, 0xe3f5, 0x0936, 0x9c75, 0xa3b5, 0x36f6, 0xf636, 0x6375, 0x5cb5,
            0xc9f6, 0x2335, 0xb676, 0x89b6, 0x1cf5, 0xf022, 0x6561, 0x5aa1, 0xcfe2, 0x2521, 0xb062,
            0x8fa2, 0x1ae1, 0xda21, 0x4f62, 0x70a2, 0xe5e1, 0x0f22, 0x9a61, 0xa5a1, 0x30e2, 0xa424,
            0x3167, 0x0ea7, 0x9be4, 0x7127, 0xe464, 0xdba4, 0x4ee7, 0x8e27, 0x1b64, 0x24a4, 0xb1e7,
            0x5b24, 0xce67, 0xf1a7, 0x64e4, 0x582e, 0xcd6d, 0xf2ad, 0x67ee, 0x8d2d, 0x186e, 0x27ae,
            0xb2ed, 0x722d, 0xe76e, 0xd8ae, 0x4ded, 0xa72e, 0x326d, 0x0dad, 0x98ee, 0x0c28, 0x996b,
            0xa6ab, 0x33e8, 0xd92b, 0x4c68, 0x73a8, 0xe6eb, 0x262b, 0xb368, 0x8ca8, 0x19eb, 0xf328,
            0x666b, 0x59ab, 0xcce8,
        ],
        [
            0x0000, 0x407e, 0x80fc, 0xc082, 0x81fd, 0xc183, 0x0101, 0x417f, 0x83ff, 0xc381, 0x0303,
            0x437d, 0x0202, 0x427c, 0x82fe, 0xc280, 0x87fb, 0xc785, 0x0707, 0x4779, 0x0606, 0x4678,
            0x86fa, 0xc684, 0x0404, 0x447a, 0x84f8, 0xc486, 0x85f9, 0xc587, 0x0505, 0x457b, 0x8ff3,
            0xcf8d, 0x0f0f, 0x4f71, 0x0e0e, 0x4e70, 0x8ef2, 0xce8c, 0x0c0c, 0x4c72, 0x8cf0, 0xcc8e,
            0x8df1, 0xcd8f, 0x0d0d, 0x4d73, 0x0808, 0x4876, 0x88f4, 0xc88a, 0x89f5, 0xc98b, 0x0909,
            0x4977, 0x8bf7, 0xcb89, 0x0b0b, 0x4b75, 0x0a0a, 0x4a74, 0x8af6, 0xca88, 0x9fe3, 0xdf9d,
            0x1f1f, 0x5f61, 0x1e1e, 0x5e60, 0x9ee2, 0xde9c, 0x1c1c, 0x5c62, 0x9ce0, 0xdc9e, 0x9de1,
            0xdd9f, 0x1d1d, 0x5d63, 0x1818, 0x5866, 0x98e4, 0xd89a, 0x99e5, 0xd99b, 0x1919, 0x5967,
            0x9be7, 0xdb99, 0x1b1b, 0x5b65, 0x1a1a, 0x5a64, 0x9ae6, 0xda98, 0x1010, 0x506e, 0x90ec,
            0xd092, 0x91ed, 0xd193, 0x1111, 0x516f, 0x93ef, 0xd391, 0x1313, 0x536d, 0x1212, 0x526c,
            0x92ee, 0xd290, 0x97eb, 0xd795, 0x1717, 0x5769, 0x1616, 0x5668, 0x96ea, 0xd694, 0x1414,
            0x546a, 0x94e8, 0xd496, 0x95e9, 0xd597, 0x1515, 0x556b, 0xbfc3, 0xffbd, 0x3f3f, 0x7f41,
            0x3e3e, 0x7e40, 0xbec2, 0xfebc, 0x3c3c, 0x7c42, 0xbcc0, 0xfcbe, 0xbdc1, 0xfdbf, 0x3d3d,
            0x7d43, 0x3838, 0x7846, 0xb8c4, 0xf8ba, 0xb9c5, 0xf9bb, 0x3939, 0x7947, 0xbbc7, 0xfbb9,
            0x3b3b, 0x7b45, 0x3a3a, 0x7a44, 0xbac6, 0xfab8, 0x3030, 0x704e, 0xb0cc, 0xf0b2, 0xb1cd,
            0xf1b3, 0x3131, 0x714f, 0xb3cf, 0xf3b1, 0x3333, 0x734d, 0x3232, 0x724c, 0xb2ce, 0xf2b0,
            0xb7cb, 0xf7b5, 0x3737, 0x7749, 0x3636, 0x7648, 0xb6ca, 0xf6b4, 0x3434, 0x744a, 0xb4c8,
            0xf4b6, 0xb5c9, 0xf5b7, 0x3535, 0x754b, 0x2020, 0x605e, 0xa0dc, 0xe0a2, 0xa1dd, 0xe1a3,
            0x2121, 0x615f, 0xa3df, 0xe3a1, 0x2323, 0x635d, 0x2222, 0x625c, 0xa2de, 0xe2a0, 0xa7db,
            0xe7a5, 0x2727, 0x6759, 0x2626, 0x6658, 0xa6da, 0xe6a4, 0x2424, 0x645a, 0xa4d8, 0xe4a6,
            0xa5d9, 0xe5a7, 0x2525, 0x655b, 0xafd3, 0xefad, 0x2f2f, 0x6f51, 0x2e2e, 0x6e50, 0xaed2,
            0xeeac, 0x2c2c, 0x6c52, 0xacd0, 0xecae, 0xadd1, 0xedaf, 0x2d2d, 0x6d53, 0x2828, 0x6856,
            0xa8d4, 0xe8aa, 0xa9d5, 0xe9ab, 0x2929, 0x6957, 0xabd7, 0xeba9, 0x2b2b, 0x6b55, 0x2a2a,
            0x6a54, 0xaad6, 0xeaa8,
        ],
        [
            0x0000, 0xff83, 0x7f03, 0x8080, 0xfe06, 0x0185, 0x8105, 0x7e86, 0x7c09, 0x838a, 0x030a,
            0xfc89, 0x820f, 0x7d8c, 0xfd0c, 0x028f, 0xf812, 0x0791, 0x8711, 0x7892, 0x0614, 0xf997,
            0x7917, 0x8694, 0x841b, 0x7b98, 0xfb18, 0x049b, 0x7a1d, 0x859e, 0x051e, 0xfa9d, 0x7021,
            0x8fa2, 0x0f22, 0xf0a1, 0x8e27, 0x71a4, 0xf124, 0x0ea7, 0x0c28, 0xf3ab, 0x732b, 0x8ca8,
            0xf22e, 0x0dad, 0x8d2d, 0x72ae, 0x8833, 0x77b0, 0xf730, 0x08b3, 0x7635, 0x89b6, 0x0936,
            0xf6b5, 0xf43a, 0x0bb9, 0x8b39, 0x74ba, 0x0a3c, 0xf5bf, 0x753f, 0x8abc, 0xe042, 0x1fc1,
            0x9f41, 0x60c2, 0x1e44, 0xe1c7, 0x6147, 0x9ec4, 0x9c4b, 0x63c8, 0xe348, 0x1ccb, 0x624d,
            0x9dce, 0x1d4e, 0xe2cd, 0x1850, 0xe7d3, 0x6753, 0x98d0, 0xe656, 0x19d5, 0x9955, 0x66d6,
            0x6459, 0x9bda, 0x1b5a, 0xe4d9, 0x9a5f, 0x65dc, 0xe55c, 0x1adf, 0x9063, 0x6fe0, 0xef60,
            0x10e3, 0x6e65, 0x91e6, 0x1166, 0xeee5, 0xec6a, 0x13e9, 0x9369, 0x6cea, 0x126c, 0xedef,
            0x6d6f, 0x92ec, 0x6871, 0x97f2, 0x1772, 0xe8f1, 0x9677, 0x69f4, 0xe974, 0x16f7, 0x1478,
            0xebfb, 0x6b7b, 0x94f8, 0xea7e, 0x15fd, 0x957d, 0x6afe, 0x4081, 0xbf02, 0x3f82, 0xc001,
            0xbe87, 0x4104, 0xc184, 0x3e07, 0x3c88, 0xc30b, 0x438b, 0xbc08, 0xc28e, 0x3d0d, 0xbd8d,
            0x420e, 0xb893, 0x4710, 0xc790, 0x3813, 0x4695, 0xb916, 0x3996, 0xc615, 0xc49a, 0x3b19,
            0xbb99, 0x441a, 0x3a9c, 0xc51f, 0x459f, 0xba1c, 0x30a0, 0xcf23, 0x4fa3, 0xb020, 0xcea6,
            0x3125, 0xb1a5, 0x4e26, 0x4ca9, 0xb32a, 0x33aa, 0xcc29, 0xb2af, 0x4d2c, 0xcdac, 0x322f,
            0xc8b2, 0x3731, 0xb7b1, 0x4832, 0x36b4, 0xc937, 0x49b7, 0xb634, 0xb4bb, 0x4b38, 0xcbb8,
            0x343b, 0x4abd, 0xb53e, 0x35be, 0xca3d, 0xa0c3, 0x5f40, 0xdfc0, 0x2043, 0x5ec5, 0xa146,
            0x21c6, 0xde45, 0xdcca, 0x2349, 0xa3c9, 0x5c4a, 0x22cc, 0xdd4f, 0x5dcf, 0xa24c, 0x58d1,
            0xa752, 0x27d2, 0xd851, 0xa6d7, 0x5954, 0xd9d4, 0x2657, 0x24d8, 0xdb5b, 0x5bdb, 0xa458,
            0xdade, 0x255d, 0xa5dd, 0x5a5e, 0xd0e2, 0x2f61, 0xafe1, 0x5062, 0x2ee4, 0xd167, 0x51e7,
            0xae64, 0xaceb, 0x5368, 0xd3e8, 0x2c6b, 0x52ed, 0xad6e, 0x2dee, 0xd26d, 0x28f0, 0xd773,
            0x57f3, 0xa870, 0xd6f6, 0x2975, 0xa9f5, 0x5676, 0x54f9, 0xab7a, 0x2bfa, 0xd479, 0xaaff,
            0x557c, 0xd5fc, 0x2a7f,
        ],
        [
            0x0000, 0x8102, 0x8201, 0x0303, 0x8407, 0x0505, 0x0606, 0x8704, 0x880b, 0x0909, 0x0a0a,
            0x8b08, 0x0c0c, 0x8d0e, 0x8e0d, 0x0f0f, 0x9013, 0x1111, 0x1212, 0x9310, 0x1414, 0x9516,
            0x9615, 0x1717, 0x1818, 0x991a, 0x9a19, 0x1b1b, 0x9c1f, 0x1d1d, 0x1e1e, 0x9f1c, 0xa023,
            0x2121, 0x2222, 0xa320, 0x2424, 0xa526, 0xa625, 0x2727, 0x2828, 0xa92a, 0xaa29, 0x2b2b,
            0xac2f, 0x2d2d, 0x2e2e, 0xaf2c, 0x3030, 0xb132, 0xb231, 0x3333, 0xb437, 0x3535, 0x3636,
            0xb734, 0xb83b, 0x3939, 0x3a3a, 0xbb38, 0x3c3c, 0xbd3e, 0xbe3d, 0x3f3f, 0xc043, 0x4141,
            0x4242, 0xc340, 0x4444, 0xc546, 0xc645, 0x4747, 0x4848, 0xc94a, 0xca49, 0x4b4b, 0xcc4f,
            0x4d4d, 0x4e4e, 0xcf4c, 0x5050, 0xd152, 0xd251, 0x5353, 0xd457, 0x5555, 0x5656, 0xd754,
            0xd85b, 0x5959, 0x5a5a, 0xdb58, 0x5c5c, 0xdd5e, 0xde5d, 0x5f5f, 0x6060, 0xe162, 0xe261,
            0x6363, 0xe467, 0x6565, 0x6666, 0xe764, 0xe86b, 0x6969, 0x6a6a, 0xeb68, 0x6c6c, 0xed6e,
            0xee6d, 0x6f6f, 0xf073, 0x7171, 0x7272, 0xf370, 0x7474, 0xf576, 0xf675, 0x7777, 0x7878,
            0xf97a, 0xfa79, 0x7b7b, 0xfc7f, 0x7d7d, 0x7e7e, 0xff7c, 0x0083, 0x8181, 0x8282, 0x0380,
            0x8484, 0x0586, 0x0685, 0x8787, 0x8888, 0x098a, 0x0a89, 0x8b8b, 0x0c8f, 0x8d8d, 0x8e8e,
            0x0f8c, 0x9090, 0x1192, 0x1291, 0x9393, 0x1497, 0x9595, 0x9696, 0x1794, 0x189b, 0x9999,
            0x9a9a, 0x1b98, 0x9c9c, 0x1d9e, 0x1e9d, 0x9f9f, 0xa0a0, 0x21a2, 0x22a1, 0xa3a3, 0x24a7,
            0xa5a5, 0xa6a6, 0x27a4, 0x28ab, 0xa9a9, 0xaaaa, 0x2ba8, 0xacac, 0x2dae, 0x2ead, 0xafaf,
            0x30b3, 0xb1b1, 0xb2b2, 0x33b0, 0xb4b4, 0x35b6, 0x36b5, 0xb7b7, 0xb8b8, 0x39ba, 0x3ab9,
            0xbbbb, 0x3cbf, 0xbdbd, 0xbebe, 0x3fbc, 0xc0c0, 0x41c2, 0x42c1, 0xc3c3, 0x44c7, 0xc5c5,
            0xc6c6, 0x47c4, 0x48cb, 0xc9c9, 0xcaca, 0x4bc8, 0xcccc, 0x4dce, 0x4ecd, 0xcfcf, 0x50d3,
            0xd1d1, 0xd2d2, 0x53d0, 0xd4d4, 0x55d6, 0x56d5, 0xd7d7, 0xd8d8, 0x59da, 0x5ad9, 0xdbdb,
            0x5cdf, 0xdddd, 0xdede, 0x5fdc, 0x60e3, 0xe1e1, 0xe2e2, 0x63e0, 0xe4e4, 0x65e6, 0x66e5,
            0xe7e7, 0xe8e8, 0x69ea, 0x6ae9, 0xebeb, 0x6cef, 0xeded, 0xeeee, 0x6fec, 0xf0f0, 0x71f2,
            0x72f1, 0xf3f3, 0x74f7, 0xf5f5, 0xf6f6, 0x77f4, 0x78fb, 0xf9f9, 0xfafa, 0x7bf8, 0xfcfc,
            0x7dfe, 0x7efd, 0xffff,
        ],
        [
            0x0000, 0x0106, 0x020c, 0x030a, 0x0418, 0x051e, 0x0614, 0x0712, 0x0830, 0x0936, 0x0a3c,
            0x0b3a, 0x0c28, 0x0d2e, 0x0e24, 0x0f22, 0x1060, 0x1166, 0x126c, 0x136a, 0x1478, 0x157e,
            0x1674, 0x1772, 0x1850, 0x1956, 0x1a5c, 0x1b5a, 0x1c48, 0x1d4e, 0x1e44, 0x1f42, 0x20c0,
            0x21c6, 0x22cc, 0x23ca, 0x24d8, 0x25de, 0x26d4, 0x27d2, 0x28f0, 0x29f6, 0x2afc, 0x2bfa,
            0x2ce8, 0x2dee, 0x2ee4, 0x2fe2, 0x30a0, 0x31a6, 0x32ac, 0x33aa, 0x34b8, 0x35be, 0x36b4,
            0x37b2, 0x3890, 0x3996, 0x3a9c, 0x3b9a, 0x3c88, 0x3d8e, 0x3e84, 0x3f82, 0x4180, 0x4086,
            0x438c, 0x428a, 0x4598, 0x449e, 0x4794, 0x4692, 0x49b0, 0x48b6, 0x4bbc, 0x4aba, 0x4da8,
            0x4cae, 0x4fa4, 0x4ea2, 0x51e0, 0x50e6, 0x53ec, 0x52ea, 0x55f8, 0x54fe, 0x57f4, 0x56f2,
            0x59d0, 0x58d6, 0x5bdc, 0x5ada, 0x5dc8, 0x5cce, 0x5fc4, 0x5ec2, 0x6140, 0x6046, 0x634c,
            0x624a, 0x6558, 0x645e, 0x6754, 0x6652, 0x6970, 0x6876, 0x6b7c, 0x6a7a, 0x6d68, 0x6c6e,
            0x6f64, 0x6e62, 0x7120, 0x7026, 0x732c, 0x722a, 0x7538, 0x743e, 0x7734, 0x7632, 0x7910,
            0x7816, 0x7b1c, 0x7a1a, 0x7d08, 0x7c0e, 0x7f04, 0x7e02, 0x8300, 0x8206, 0x810c, 0x800a,
            0x8718, 0x861e, 0x8514, 0x8412, 0x8b30, 0x8a36, 0x893c, 0x883a, 0x8f28, 0x8e2e, 0x8d24,
            0x8c22, 0x9360, 0x9266, 0x916c, 0x906a, 0x9778, 0x967e, 0x9574, 0x9472, 0x9b50, 0x9a56,
            0x995c, 0x985a, 0x9f48, 0x9e4e, 0x9d44, 0x9c42, 0xa3c0, 0xa2c6, 0xa1cc, 0xa0ca, 0xa7d8,
            0xa6de, 0xa5d4, 0xa4d2, 0xabf0, 0xaaf6, 0xa9fc, 0xa8fa, 0xafe8, 0xaeee, 0xade4, 0xace2,
            0xb3a0, 0xb2a6, 0xb1ac, 0xb0aa, 0xb7b8, 0xb6be, 0xb5b4, 0xb4b2, 0xbb90, 0xba96, 0xb99c,
            0xb89a, 0xbf88, 0xbe8e, 0xbd84, 0xbc82, 0xc280, 0xc386, 0xc08c, 0xc18a, 0xc698, 0xc79e,
            0xc494, 0xc592, 0xcab0, 0xcbb6, 0xc8bc, 0xc9ba, 0xcea8, 0xcfae, 0xcca4, 0xcda2, 0xd2e0,
            0xd3e6, 0xd0ec, 0xd1ea, 0xd6f8, 0xd7fe, 0xd4f4, 0xd5f2, 0xdad0, 0xdbd6, 0xd8dc, 0xd9da,
            0xdec8, 0xdfce, 0xdcc4, 0xddc2, 0xe240, 0xe346, 0xe04c, 0xe14a, 0xe658, 0xe75e, 0xe454,
            0xe552, 0xea70, 0xeb76, 0xe87c, 0xe97a, 0xee68, 0xef6e, 0xec64, 0xed62, 0xf220, 0xf326,
            0xf02c, 0xf12a, 0xf638, 0xf73e, 0xf434, 0xf532, 0xfa10, 0xfb16, 0xf81c, 0xf91a, 0xfe08,
            0xff0e, 0xfc04, 0xfd02,
        ],
        [
            0x0000, 0x8605, 0x8c0f, 0x0a0a, 0x981b, 0x1e1e, 0x1414, 0x9211, 0xb033, 0x3636, 0x3c3c,
            0xba39, 0x2828, 0xae2d, 0xa427, 0x2222, 0xe063, 0x6666, 0x6c6c, 0xea69, 0x7878, 0xfe7d,
            0xf477, 0x7272, 0x5050, 0xd655, 0xdc5f, 0x5a5a, 0xc84b, 0x4e4e, 0x4444, 0xc241, 0x40c3,
            0xc6c6, 0xcccc, 0x4ac9, 0xd8d8, 0x5edd, 0x54d7, 0xd2d2, 0xf0f0, 0x76f5, 0x7cff, 0xfafa,
            0x68eb, 0xeeee, 0xe4e4, 0x62e1, 0xa0a0, 0x26a5, 0x2caf, 0xaaaa, 0x38bb, 0xbebe, 0xb4b4,
            0x32b1, 0x1093, 0x9696, 0x9c9c, 0x1a99, 0x8888, 0x0e8d, 0x0487, 0x8282, 0x8186, 0x0783,
            0x0d89, 0x8b8c, 0x199d, 0x9f98, 0x9592, 0x1397, 0x31b5, 0xb7b0, 0xbdba, 0x3bbf, 0xa9ae,
            0x2fab, 0x25a1, 0xa3a4, 0x61e5, 0xe7e0, 0xedea, 0x6bef, 0xf9fe, 0x7ffb, 0x75f1, 0xf3f4,
            0xd1d6, 0x57d3, 0x5dd9, 0xdbdc, 0x49cd, 0xcfc8, 0xc5c2, 0x43c7, 0xc145, 0x4740, 0x4d4a,
            0xcb4f, 0x595e, 0xdf5b, 0xd551, 0x5354, 0x7176, 0xf773, 0xfd79, 0x7b7c, 0xe96d, 0x6f68,
            0x6562, 0xe367, 0x2126, 0xa723, 0xad29, 0x2b2c, 0xb93d, 0x3f38, 0x3532, 0xb337, 0x9115,
            0x1710, 0x1d1a, 0x9b1f, 0x090e, 0x8f0b, 0x8501, 0x0304, 0x8309, 0x050c, 0x0f06, 0x8903,
            0x1b12, 0x9d17, 0x971d, 0x1118, 0x333a, 0xb53f, 0xbf35, 0x3930, 0xab21, 0x2d24, 0x272e,
            0xa12b, 0x636a, 0xe56f, 0xef65, 0x6960, 0xfb71, 0x7d74, 0x777e, 0xf17b, 0xd359, 0x555c,
            0x5f56, 0xd953, 0x4b42, 0xcd47, 0xc74d, 0x4148, 0xc3ca, 0x45cf, 0x4fc5, 0xc9c0, 0x5bd1,
            0xddd4, 0xd7de, 0x51db, 0x73f9, 0xf5fc, 0xfff6, 0x79f3, 0xebe2, 0x6de7, 0x67ed, 0xe1e8,
            0x23a9, 0xa5ac, 0xafa6, 0x29a3, 0xbbb2, 0x3db7, 0x37bd, 0xb1b8, 0x939a, 0x159f, 0x1f95,
            0x9990, 0x0b81, 0x8d84, 0x878e, 0x018b, 0x028f, 0x848a, 0x8e80, 0x0885, 0x9a94, 0x1c91,
            0x169b, 0x909e, 0xb2bc, 0x34b9, 0x3eb3, 0xb8b6, 0x2aa7, 0xaca2, 0xa6a8, 0x20ad, 0xe2ec,
            0x64e9, 0x6ee3, 0xe8e6, 0x7af7, 0xfcf2, 0xf6f8, 0x70fd, 0x52df, 0xd4da, 0xded0, 0x58d5,
            0xcac4, 0x4cc1, 0x46cb, 0xc0ce, 0x424c, 0xc449, 0xce43, 0x4846, 0xda57, 0x5c52, 0x5658,
            0xd05d, 0xf27f, 0x747a, 0x7e70, 0xf875, 0x6a64, 0xec61, 0xe66b, 0x606e, 0xa22f, 0x242a,
            0x2e20, 0xa825, 0x3a34, 0xbc31, 0xb63b, 0x303e, 0x121c, 0x9419, 0x9e13, 0x1816, 0x8a07,
            0x0c02, 0x0608, 0x800d,
        ],
    ];

    pub static CRC16_DDS_110_TABLE: [[u16; 256]; 16] = [
        [
            0x0000, 0x8005, 0x800f, 0x000a, 0x801b, 0x001e, 0x0014, 0x8011, 0x8033, 0x0036, 0x003c,
            0x8039, 0x0028, 0x802d, 0x8027, 0x0022, 0x8063, 0x0066, 0x006c, 0x8069, 0x0078, 0x807d,
            0x8077, 0x0072, 0x0050, 0x8055, 0x805f, 0x005a, 0x804b, 0x004e, 0x0044, 0x8041, 0x80c3,
            0x00c6, 0x00cc, 0x80c9, 0x00d8, 0x80dd, 0x80d7, 0x00d2, 0x00f0, 0x80f5, 0x80ff, 0x00fa,
            0x80eb, 0x00ee, 0x00e4, 0x80e1, 0x00a0, 0x80a5, 0x80af, 0x00aa, 0x80bb, 0x00be, 0x00b4,
            0x80b1, 0x8093, 0x0096, 0x009c, 0x8099, 0x0088, 0x808d, 0x8087, 0x0082, 0x8183, 0x0186,
            0x018c, 0x8189, 0x0198, 0x819d, 0x8197, 0x0192, 0x01b0, 0x81b5, 0x81bf, 0x01ba, 0x81ab,
            0x01ae, 0x01a4, 0x81a1, 0x01e0, 0x81e5, 0x81ef, 0x01ea, 0x81fb, 0x01fe, 0x01f4, 0x81f1,
            0x81d3, 0x01d6, 0x01dc, 0x81d9, 0x01c8, 0x81cd, 0x81c7, 0x01c2, 0x0140, 0x8145, 0x814f,
            0x014a, 0x815b, 0x015e, 0x0154, 0x8151, 0x8173, 0x0176, 0x017c, 0x8179, 0x0168, 0x816d,
            0x8167, 0x0162, 0x8123, 0x0126, 0x012c, 0x8129, 0x0138, 0x813d, 0x8137, 0x0132, 0x0110,
            0x8115, 0x811f, 0x011a, 0x810b, 0x010e, 0x0104, 0x8101, 0x8303, 0x0306, 0x030c, 0x8309,
            0x0318, 0x831d, 0x8317, 0x0312, 0x0330, 0x8335, 0x833f, 0x033a, 0x832b, 0x032e, 0x0324,
            0x8321, 0x0360, 0x8365, 0x836f, 0x036a, 0x837b, 0x037e, 0x0374, 0x8371, 0x8353, 0x0356,
            0x035c, 0x8359, 0x0348, 0x834d, 0x8347, 0x0342, 0x03c0, 0x83c5, 0x83cf, 0x03ca, 0x83db,
            0x03de, 0x03d4, 0x83d1, 0x83f3, 0x03f6, 0x03fc, 0x83f9, 0x03e8, 0x83ed, 0x83e7, 0x03e2,
            0x83a3, 0x03a6, 0x03ac, 0x83a9, 0x03b8, 0x83bd, 0x83b7, 0x03b2, 0x0390, 0x8395, 0x839f,
            0x039a, 0x838b, 0x038e, 0x0384, 0x8381, 0x0280, 0x8285, 0x828f, 0x028a, 0x829b, 0x029e,
            0x0294, 0x8291, 0x82b3, 0x02b6, 0x02bc, 0x82b9, 0x02a8, 0x82ad, 0x82a7, 0x02a2, 0x82e3,
            0x02e6, 0x02ec, 0x82e9, 0x02f8, 0x82fd, 0x82f7, 0x02f2, 0x02d0, 0x82d5, 0x82df, 0x02da,
            0x82cb, 0x02ce, 0x02c4, 0x82c1, 0x8243, 0x0246, 0x024c, 0x8249, 0x0258, 0x825d, 0x8257,
            0x0252, 0x0270, 0x8275, 0x827f, 0x027a, 0x826b, 0x026e, 0x0264, 0x8261, 0x0220, 0x8225,
            0x822f, 0x022a, 0x823b, 0x023e, 0x0234, 0x8231, 0x8213, 0x0216, 0x021c, 0x8219, 0x0208,
            0x820d, 0x8207, 0x0202,
        ],
        [
            0x0000, 0x8603, 0x8c03, 0x0a00, 0x9803, 0x1e00, 0x1400, 0x9203, 0xb003, 0x3600, 0x3c00,
            0xba03, 0x2800, 0xae03, 0xa403, 0x2200, 0xe003, 0x6600, 0x6c00, 0xea03, 0x7800, 0xfe03,
            0xf403, 0x7200, 0x5000, 0xd603, 0xdc03, 0x5a00, 0xc803, 0x4e00, 0x4400, 0xc203, 0x4003,
            0xc600, 0xcc00, 0x4a03, 0xd800, 0x5e03, 0x5403, 0xd200, 0xf000, 0x7603, 0x7c03, 0xfa00,
            0x6803, 0xee00, 0xe400, 0x6203, 0xa000, 0x2603, 0x2c03, 0xaa00, 0x3803, 0xbe00, 0xb400,
            0x3203, 0x1003, 0x9600, 0x9c00, 0x1a03, 0x8800, 0x0e03, 0x0403, 0x8200, 0x8006, 0x0605,
            0x0c05, 0x8a06, 0x1805, 0x9e06, 0x9406, 0x1205, 0x3005, 0xb606, 0xbc06, 0x3a05, 0xa806,
            0x2e05, 0x2405, 0xa206, 0x6005, 0xe606, 0xec06, 0x6a05, 0xf806, 0x7e05, 0x7405, 0xf206,
            0xd006, 0x5605, 0x5c05, 0xda06, 0x4805, 0xce06, 0xc406, 0x4205, 0xc005, 0x4606, 0x4c06,
            0xca05, 0x5806, 0xde05, 0xd405, 0x5206, 0x7006, 0xf605, 0xfc05, 0x7a06, 0xe805, 0x6e06,
            0x6406, 0xe205, 0x2006, 0xa605, 0xac05, 0x2a06, 0xb805, 0x3e06, 0x3406, 0xb205, 0x9005,
            0x1606, 0x1c06, 0x9a05, 0x0806, 0x8e05, 0x8405, 0x0206, 0x8009, 0x060a, 0x0c0a, 0x8a09,
            0x180a, 0x9e09, 0x9409, 0x120a, 0x300a, 0xb609, 0xbc09, 0x3a0a, 0xa809, 0x2e0a, 0x240a,
            0xa209, 0x600a, 0xe609, 0xec09, 0x6a0a, 0xf809, 0x7e0a, 0x740a, 0xf209, 0xd009, 0x560a,
            0x5c0a, 0xda09, 0x480a, 0xce09, 0xc409, 0x420a, 0xc00a, 0x4609, 0x4c09, 0xca0a, 0x5809,
            0xde0a, 0xd40a, 0x5209, 0x7009, 0xf60a, 0xfc0a, 0x7a09, 0xe80a, 0x6e09, 0x6409, 0xe20a,
            0x2009, 0xa60a, 0xac0a, 0x2a09, 0xb80a, 0x3e09, 0x3409, 0xb20a, 0x900a, 0x1609, 0x1c09,
            0x9a0a, 0x0809, 0x8e0a, 0x840a, 0x0209, 0x000f, 0x860c, 0x8c0c, 0x0a0f, 0x980c, 0x1e0f,
            0x140f, 0x920c, 0xb00c, 0x360f, 0x3c0f, 0xba0c, 0x280f, 0xae0c, 0xa40c, 0x220f, 0xe00c,
            0x660f, 0x6c0f, 0xea0c, 0x780f, 0xfe0c, 0xf40c, 0x720f, 0x500f, 0xd60c, 0xdc0c, 0x5a0f,
            0xc80c, 0x4e0f, 0x440f, 0xc20c, 0x400c, 0xc60f, 0xcc0f, 0x4a0c, 0xd80f, 0x5e0c, 0x540c,
            0xd20f, 0xf00f, 0x760c, 0x7c0c, 0xfa0f, 0x680c, 0xee0f, 0xe40f, 0x620c, 0xa00f, 0x260c,
            0x2c0c, 0xaa0f, 0x380c, 0xbe0f, 0xb40f, 0x320c, 0x100c, 0x960f, 0x9c0f, 0x1a0c, 0x880f,
            0x0e0c, 0x040c, 0x820f,
        ],
        [
            0x0000, 0x8017, 0x802b, 0x003c, 0x8053, 0x0044, 0x0078, 0x806f, 0x80a3, 0x00b4, 0x0088,
            0x809f, 0x00f0, 0x80e7, 0x80db, 0x00cc, 0x8143, 0x0154, 0x0168, 0x817f, 0x0110, 0x8107,
            0x813b, 0x012c, 0x01e0, 0x81f7, 0x81cb, 0x01dc, 0x81b3, 0x01a4, 0x0198, 0x818f, 0x8283,
            0x0294, 0x02a8, 0x82bf, 0x02d0, 0x82c7, 0x82fb, 0x02ec, 0x0220, 0x8237, 0x820b, 0x021c,
            0x8273, 0x0264, 0x0258, 0x824f, 0x03c0, 0x83d7, 0x83eb, 0x03fc, 0x8393, 0x0384, 0x03b8,
            0x83af, 0x8363, 0x0374, 0x0348, 0x835f, 0x0330, 0x8327, 0x831b, 0x030c, 0x8503, 0x0514,
            0x0528, 0x853f, 0x0550, 0x8547, 0x857b, 0x056c, 0x05a0, 0x85b7, 0x858b, 0x059c, 0x85f3,
            0x05e4, 0x05d8, 0x85cf, 0x0440, 0x8457, 0x846b, 0x047c, 0x8413, 0x0404, 0x0438, 0x842f,
            0x84e3, 0x04f4, 0x04c8, 0x84df, 0x04b0, 0x84a7, 0x849b, 0x048c, 0x0780, 0x8797, 0x87ab,
            0x07bc, 0x87d3, 0x07c4, 0x07f8, 0x87ef, 0x8723, 0x0734, 0x0708, 0x871f, 0x0770, 0x8767,
            0x875b, 0x074c, 0x86c3, 0x06d4, 0x06e8, 0x86ff, 0x0690, 0x8687, 0x86bb, 0x06ac, 0x0660,
            0x8677, 0x864b, 0x065c, 0x8633, 0x0624, 0x0618, 0x860f, 0x8a03, 0x0a14, 0x0a28, 0x8a3f,
            0x0a50, 0x8a47, 0x8a7b, 0x0a6c, 0x0aa0, 0x8ab7, 0x8a8b, 0x0a9c, 0x8af3, 0x0ae4, 0x0ad8,
            0x8acf, 0x0b40, 0x8b57, 0x8b6b, 0x0b7c, 0x8b13, 0x0b04, 0x0b38, 0x8b2f, 0x8be3, 0x0bf4,
            0x0bc8, 0x8bdf, 0x0bb0, 0x8ba7, 0x8b9b, 0x0b8c, 0x0880, 0x8897, 0x88ab, 0x08bc, 0x88d3,
            0x08c4, 0x08f8, 0x88ef, 0x8823, 0x0834, 0x0808, 0x881f, 0x0870, 0x8867, 0x885b, 0x084c,
            0x89c3, 0x09d4, 0x09e8, 0x89ff, 0x0990, 0x8987, 0x89bb, 0x09ac, 0x0960, 0x8977, 0x894b,
            0x095c, 0x8933, 0x0924, 0x0918, 0x890f, 0x0f00, 0x8f17, 0x8f2b, 0x0f3c, 0x8f53, 0x0f44,
            0x0f78, 0x8f6f, 0x8fa3, 0x0fb4, 0x0f88, 0x8f9f, 0x0ff0, 0x8fe7, 0x8fdb, 0x0fcc, 0x8e43,
            0x0e54, 0x0e68, 0x8e7f, 0x0e10, 0x8e07, 0x8e3b, 0x0e2c, 0x0ee0, 0x8ef7, 0x8ecb, 0x0edc,
            0x8eb3, 0x0ea4, 0x0e98, 0x8e8f, 0x8d83, 0x0d94, 0x0da8, 0x8dbf, 0x0dd0, 0x8dc7, 0x8dfb,
            0x0dec, 0x0d20, 0x8d37, 0x8d0b, 0x0d1c, 0x8d73, 0x0d64, 0x0d58, 0x8d4f, 0x0cc0, 0x8cd7,
            0x8ceb, 0x0cfc, 0x8c93, 0x0c84, 0x0cb8, 0x8caf, 0x8c63, 0x0c74, 0x0c48, 0x8c5f, 0x0c30,
            0x8c27, 0x8c1b, 0x0c0c,
        ],
        [
            0x0000, 0x9403, 0xa803, 0x3c00, 0xd003, 0x4400, 0x7800, 0xec03, 0x2003, 0xb400, 0x8800,
            0x1c03, 0xf000, 0x6403, 0x5803, 0xcc00, 0x4006, 0xd405, 0xe805, 0x7c06, 0x9005, 0x0406,
            0x3806, 0xac05, 0x6005, 0xf406, 0xc806, 0x5c05, 0xb006, 0x2405, 0x1805, 0x8c06, 0x800c,
            0x140f, 0x280f, 0xbc0c, 0x500f, 0xc40c, 0xf80c, 0x6c0f, 0xa00f, 0x340c, 0x080c, 0x9c0f,
            0x700c, 0xe40f, 0xd80f, 0x4c0c, 0xc00a, 0x5409, 0x6809, 0xfc0a, 0x1009, 0x840a, 0xb80a,
            0x2c09, 0xe009, 0x740a, 0x480a, 0xdc09, 0x300a, 0xa409, 0x9809, 0x0c0a, 0x801d, 0x141e,
            0x281e, 0xbc1d, 0x501e, 0xc41d, 0xf81d, 0x6c1e, 0xa01e, 0x341d, 0x081d, 0x9c1e, 0x701d,
            0xe41e, 0xd81e, 0x4c1d, 0xc01b, 0x5418, 0x6818, 0xfc1b, 0x1018, 0x841b, 0xb81b, 0x2c18,
            0xe018, 0x741b, 0x481b, 0xdc18, 0x301b, 0xa418, 0x9818, 0x0c1b, 0x0011, 0x9412, 0xa812,
            0x3c11, 0xd012, 0x4411, 0x7811, 0xec12, 0x2012, 0xb411, 0x8811, 0x1c12, 0xf011, 0x6412,
            0x5812, 0xcc11, 0x4017, 0xd414, 0xe814, 0x7c17, 0x9014, 0x0417, 0x3817, 0xac14, 0x6014,
            0xf417, 0xc817, 0x5c14, 0xb017, 0x2414, 0x1814, 0x8c17, 0x803f, 0x143c, 0x283c, 0xbc3f,
            0x503c, 0xc43f, 0xf83f, 0x6c3c, 0xa03c, 0x343f, 0x083f, 0x9c3c, 0x703f, 0xe43c, 0xd83c,
            0x4c3f, 0xc039, 0x543a, 0x683a, 0xfc39, 0x103a, 0x8439, 0xb839, 0x2c3a, 0xe03a, 0x7439,
            0x4839, 0xdc3a, 0x3039, 0xa43a, 0x983a, 0x0c39, 0x0033, 0x9430, 0xa830, 0x3c33, 0xd030,
            0x4433, 0x7833, 0xec30, 0x2030, 0xb433, 0x8833, 0x1c30, 0xf033, 0x6430, 0x5830, 0xcc33,
            0x4035, 0xd436, 0xe836, 0x7c35, 0x9036, 0x0435, 0x3835, 0xac36, 0x6036, 0xf435, 0xc835,
            0x5c36, 0xb035, 0x2436, 0x1836, 0x8c35, 0x0022, 0x9421, 0xa821, 0x3c22, 0xd021, 0x4422,
            0x7822, 0xec21, 0x2021, 0xb422, 0x8822, 0x1c21, 0xf022, 0x6421, 0x5821, 0xcc22, 0x4024,
            0xd427, 0xe827, 0x7c24, 0x9027, 0x0424, 0x3824, 0xac27, 0x6027, 0xf424, 0xc824, 0x5c27,
            0xb024, 0x2427, 0x1827, 0x8c24, 0x802e, 0x142d, 0x282d, 0xbc2e, 0x502d, 0xc42e, 0xf82e,
            0x6c2d, 0xa02d, 0x342e, 0x082e, 0x9c2d, 0x702e, 0xe42d, 0xd82d, 0x4c2e, 0xc028, 0x542b,
            0x682b, 0xfc28, 0x102b, 0x8428, 0xb828, 0x2c2b, 0xe02b, 0x7428, 0x4828, 0xdc2b, 0x3028,
            0xa42b, 0x982b, 0x0c28,
        ],
        [
            0x0000, 0x807b, 0x80f3, 0x0088, 0x81e3, 0x0198, 0x0110, 0x816b, 0x83c3, 0x03b8, 0x0330,
            0x834b, 0x0220, 0x825b, 0x82d3, 0x02a8, 0x8783, 0x07f8, 0x0770, 0x870b, 0x0660, 0x861b,
            0x8693, 0x06e8, 0x0440, 0x843b, 0x84b3, 0x04c8, 0x85a3, 0x05d8, 0x0550, 0x852b, 0x8f03,
            0x0f78, 0x0ff0, 0x8f8b, 0x0ee0, 0x8e9b, 0x8e13, 0x0e68, 0x0cc0, 0x8cbb, 0x8c33, 0x0c48,
            0x8d23, 0x0d58, 0x0dd0, 0x8dab, 0x0880, 0x88fb, 0x8873, 0x0808, 0x8963, 0x0918, 0x0990,
            0x89eb, 0x8b43, 0x0b38, 0x0bb0, 0x8bcb, 0x0aa0, 0x8adb, 0x8a53, 0x0a28, 0x9e03, 0x1e78,
            0x1ef0, 0x9e8b, 0x1fe0, 0x9f9b, 0x9f13, 0x1f68, 0x1dc0, 0x9dbb, 0x9d33, 0x1d48, 0x9c23,
            0x1c58, 0x1cd0, 0x9cab, 0x1980, 0x99fb, 0x9973, 0x1908, 0x9863, 0x1818, 0x1890, 0x98eb,
            0x9a43, 0x1a38, 0x1ab0, 0x9acb, 0x1ba0, 0x9bdb, 0x9b53, 0x1b28, 0x1100, 0x917b, 0x91f3,
            0x1188, 0x90e3, 0x1098, 0x1010, 0x906b, 0x92c3, 0x12b8, 0x1230, 0x924b, 0x1320, 0x935b,
            0x93d3, 0x13a8, 0x9683, 0x16f8, 0x1670, 0x960b, 0x1760, 0x971b, 0x9793, 0x17e8, 0x1540,
            0x953b, 0x95b3, 0x15c8, 0x94a3, 0x14d8, 0x1450, 0x942b, 0xbc03, 0x3c78, 0x3cf0, 0xbc8b,
            0x3de0, 0xbd9b, 0xbd13, 0x3d68, 0x3fc0, 0xbfbb, 0xbf33, 0x3f48, 0xbe23, 0x3e58, 0x3ed0,
            0xbeab, 0x3b80, 0xbbfb, 0xbb73, 0x3b08, 0xba63, 0x3a18, 0x3a90, 0xbaeb, 0xb843, 0x3838,
            0x38b0, 0xb8cb, 0x39a0, 0xb9db, 0xb953, 0x3928, 0x3300, 0xb37b, 0xb3f3, 0x3388, 0xb2e3,
            0x3298, 0x3210, 0xb26b, 0xb0c3, 0x30b8, 0x3030, 0xb04b, 0x3120, 0xb15b, 0xb1d3, 0x31a8,
            0xb483, 0x34f8, 0x3470, 0xb40b, 0x3560, 0xb51b, 0xb593, 0x35e8, 0x3740, 0xb73b, 0xb7b3,
            0x37c8, 0xb6a3, 0x36d8, 0x3650, 0xb62b, 0x2200, 0xa27b, 0xa2f3, 0x2288, 0xa3e3, 0x2398,
            0x2310, 0xa36b, 0xa1c3, 0x21b8, 0x2130, 0xa14b, 0x2020, 0xa05b, 0xa0d3, 0x20a8, 0xa583,
            0x25f8, 0x2570, 0xa50b, 0x2460, 0xa41b, 0xa493, 0x24e8, 0x2640, 0xa63b, 0xa6b3, 0x26c8,
            0xa7a3, 0x27d8, 0x2750, 0xa72b, 0xad03, 0x2d78, 0x2df0, 0xad8b, 0x2ce0, 0xac9b, 0xac13,
            0x2c68, 0x2ec0, 0xaebb, 0xae33, 0x2e48, 0xaf23, 0x2f58, 0x2fd0, 0xafab, 0x2a80, 0xaafb,
            0xaa73, 0x2a08, 0xab63, 0x2b18, 0x2b90, 0xabeb, 0xa943, 0x2938, 0x29b0, 0xa9cb, 0x28a0,
            0xa8db, 0xa853, 0x2828,
        ],
        [
            0x0000, 0xf803, 0x7003, 0x8800, 0xe006, 0x1805, 0x9005, 0x6806, 0x4009, 0xb80a, 0x300a,
            0xc809, 0xa00f, 0x580c, 0xd00c, 0x280f, 0x8012, 0x7811, 0xf011, 0x0812, 0x6014, 0x9817,
            0x1017, 0xe814, 0xc01b, 0x3818, 0xb018, 0x481b, 0x201d, 0xd81e, 0x501e, 0xa81d, 0x8021,
            0x7822, 0xf022, 0x0821, 0x6027, 0x9824, 0x1024, 0xe827, 0xc028, 0x382b, 0xb02b, 0x4828,
            0x202e, 0xd82d, 0x502d, 0xa82e, 0x0033, 0xf830, 0x7030, 0x8833, 0xe035, 0x1836, 0x9036,
            0x6835, 0x403a, 0xb839, 0x3039, 0xc83a, 0xa03c, 0x583f, 0xd03f, 0x283c, 0x8047, 0x7844,
            0xf044, 0x0847, 0x6041, 0x9842, 0x1042, 0xe841, 0xc04e, 0x384d, 0xb04d, 0x484e, 0x2048,
            0xd84b, 0x504b, 0xa848, 0x0055, 0xf856, 0x7056, 0x8855, 0xe053, 0x1850, 0x9050, 0x6853,
            0x405c, 0xb85f, 0x305f, 0xc85c, 0xa05a, 0x5859, 0xd059, 0x285a, 0x0066, 0xf865, 0x7065,
            0x8866, 0xe060, 0x1863, 0x9063, 0x6860, 0x406f, 0xb86c, 0x306c, 0xc86f, 0xa069, 0x586a,
            0xd06a, 0x2869, 0x8074, 0x7877, 0xf077, 0x0874, 0x6072, 0x9871, 0x1071, 0xe872, 0xc07d,
            0x387e, 0xb07e, 0x487d, 0x207b, 0xd878, 0x5078, 0xa87b, 0x808b, 0x7888, 0xf088, 0x088b,
            0x608d, 0x988e, 0x108e, 0xe88d, 0xc082, 0x3881, 0xb081, 0x4882, 0x2084, 0xd887, 0x5087,
            0xa884, 0x0099, 0xf89a, 0x709a, 0x8899, 0xe09f, 0x189c, 0x909c, 0x689f, 0x4090, 0xb893,
            0x3093, 0xc890, 0xa096, 0x5895, 0xd095, 0x2896, 0x00aa, 0xf8a9, 0x70a9, 0x88aa, 0xe0ac,
            0x18af, 0x90af, 0x68ac, 0x40a3, 0xb8a0, 0x30a0, 0xc8a3, 0xa0a5, 0x58a6, 0xd0a6, 0x28a5,
            0x80b8, 0x78bb, 0xf0bb, 0x08b8, 0x60be, 0x98bd, 0x10bd, 0xe8be, 0xc0b1, 0x38b2, 0xb0b2,
            0x48b1, 0x20b7, 0xd8b4, 0x50b4, 0xa8b7, 0x00cc, 0xf8cf, 0x70cf, 0x88cc, 0xe0ca, 0x18c9,
            0x90c9, 0x68ca, 0x40c5, 0xb8c6, 0x30c6, 0xc8c5, 0xa0c3, 0x58c0, 0xd0c0, 0x28c3, 0x80de,
            0x78dd, 0xf0dd, 0x08de, 0x60d8, 0x98db, 0x10db, 0xe8d8, 0xc0d7, 0x38d4, 0xb0d4, 0x48d7,
            0x20d1, 0xd8d2, 0x50d2, 0xa8d1, 0x80ed, 0x78ee, 0xf0ee, 0x08ed, 0x60eb, 0x98e8, 0x10e8,
            0xe8eb, 0xc0e4, 0x38e7, 0xb0e7, 0x48e4, 0x20e2, 0xd8e1, 0x50e1, 0xa8e2, 0x00ff, 0xf8fc,
            0x70fc, 0x88ff, 0xe0f9, 0x18fa, 0x90fa, 0x68f9, 0x40f6, 0xb8f5, 0x30f5, 0xc8f6, 0xa0f0,
            0x58f3, 0xd0f3, 0x28f0,
        ],
        [
            0x0000, 0x8113, 0x8223, 0x0330, 0x8443, 0x0550, 0x0660, 0x8773, 0x8883, 0x0990, 0x0aa0,
            0x8bb3, 0x0cc0, 0x8dd3, 0x8ee3, 0x0ff0, 0x9103, 0x1010, 0x1320, 0x9233, 0x1540, 0x9453,
            0x9763, 0x1670, 0x1980, 0x9893, 0x9ba3, 0x1ab0, 0x9dc3, 0x1cd0, 0x1fe0, 0x9ef3, 0xa203,
            0x2310, 0x2020, 0xa133, 0x2640, 0xa753, 0xa463, 0x2570, 0x2a80, 0xab93, 0xa8a3, 0x29b0,
            0xaec3, 0x2fd0, 0x2ce0, 0xadf3, 0x3300, 0xb213, 0xb123, 0x3030, 0xb743, 0x3650, 0x3560,
            0xb473, 0xbb83, 0x3a90, 0x39a0, 0xb8b3, 0x3fc0, 0xbed3, 0xbde3, 0x3cf0, 0xc403, 0x4510,
            0x4620, 0xc733, 0x4040, 0xc153, 0xc263, 0x4370, 0x4c80, 0xcd93, 0xcea3, 0x4fb0, 0xc8c3,
            0x49d0, 0x4ae0, 0xcbf3, 0x5500, 0xd413, 0xd723, 0x5630, 0xd143, 0x5050, 0x5360, 0xd273,
            0xdd83, 0x5c90, 0x5fa0, 0xdeb3, 0x59c0, 0xd8d3, 0xdbe3, 0x5af0, 0x6600, 0xe713, 0xe423,
            0x6530, 0xe243, 0x6350, 0x6060, 0xe173, 0xee83, 0x6f90, 0x6ca0, 0xedb3, 0x6ac0, 0xebd3,
            0xe8e3, 0x69f0, 0xf703, 0x7610, 0x7520, 0xf433, 0x7340, 0xf253, 0xf163, 0x7070, 0x7f80,
            0xfe93, 0xfda3, 0x7cb0, 0xfbc3, 0x7ad0, 0x79e0, 0xf8f3, 0x0803, 0x8910, 0x8a20, 0x0b33,
            0x8c40, 0x0d53, 0x0e63, 0x8f70, 0x8080, 0x0193, 0x02a3, 0x83b0, 0x04c3, 0x85d0, 0x86e0,
            0x07f3, 0x9900, 0x1813, 0x1b23, 0x9a30, 0x1d43, 0x9c50, 0x9f60, 0x1e73, 0x1183, 0x9090,
            0x93a0, 0x12b3, 0x95c0, 0x14d3, 0x17e3, 0x96f0, 0xaa00, 0x2b13, 0x2823, 0xa930, 0x2e43,
            0xaf50, 0xac60, 0x2d73, 0x2283, 0xa390, 0xa0a0, 0x21b3, 0xa6c0, 0x27d3, 0x24e3, 0xa5f0,
            0x3b03, 0xba10, 0xb920, 0x3833, 0xbf40, 0x3e53, 0x3d63, 0xbc70, 0xb380, 0x3293, 0x31a3,
            0xb0b0, 0x37c3, 0xb6d0, 0xb5e0, 0x34f3, 0xcc00, 0x4d13, 0x4e23, 0xcf30, 0x4843, 0xc950,
            0xca60, 0x4b73, 0x4483, 0xc590, 0xc6a0, 0x47b3, 0xc0c0, 0x41d3, 0x42e3, 0xc3f0, 0x5d03,
            0xdc10, 0xdf20, 0x5e33, 0xd940, 0x5853, 0x5b63, 0xda70, 0xd580, 0x5493, 0x57a3, 0xd6b0,
            0x51c3, 0xd0d0, 0xd3e0, 0x52f3, 0x6e03, 0xef10, 0xec20, 0x6d33, 0xea40, 0x6b53, 0x6863,
            0xe970, 0xe680, 0x6793, 0x64a3, 0xe5b0, 0x62c3, 0xe3d0, 0xe0e0, 0x61f3, 0xff00, 0x7e13,
            0x7d23, 0xfc30, 0x7b43, 0xfa50, 0xf960, 0x7873, 0x7783, 0xf690, 0xf5a0, 0x74b3, 0xf3c0,
            0x72d3, 0x71e3, 0xf0f0,
        ],
        [
            0x0000, 0x1006, 0x200c, 0x300a, 0x4018, 0x501e, 0x6014, 0x7012, 0x8030, 0x9036, 0xa03c,
            0xb03a, 0xc028, 0xd02e, 0xe024, 0xf022, 0x8065, 0x9063, 0xa069, 0xb06f, 0xc07d, 0xd07b,
            0xe071, 0xf077, 0x0055, 0x1053, 0x2059, 0x305f, 0x404d, 0x504b, 0x6041, 0x7047, 0x80cf,
            0x90c9, 0xa0c3, 0xb0c5, 0xc0d7, 0xd0d1, 0xe0db, 0xf0dd, 0x00ff, 0x10f9, 0x20f3, 0x30f5,
            0x40e7, 0x50e1, 0x60eb, 0x70ed, 0x00aa, 0x10ac, 0x20a6, 0x30a0, 0x40b2, 0x50b4, 0x60be,
            0x70b8, 0x809a, 0x909c, 0xa096, 0xb090, 0xc082, 0xd084, 0xe08e, 0xf088, 0x819b, 0x919d,
            0xa197, 0xb191, 0xc183, 0xd185, 0xe18f, 0xf189, 0x01ab, 0x11ad, 0x21a7, 0x31a1, 0x41b3,
            0x51b5, 0x61bf, 0x71b9, 0x01fe, 0x11f8, 0x21f2, 0x31f4, 0x41e6, 0x51e0, 0x61ea, 0x71ec,
            0x81ce, 0x91c8, 0xa1c2, 0xb1c4, 0xc1d6, 0xd1d0, 0xe1da, 0xf1dc, 0x0154, 0x1152, 0x2158,
            0x315e, 0x414c, 0x514a, 0x6140, 0x7146, 0x8164, 0x9162, 0xa168, 0xb16e, 0xc17c, 0xd17a,
            0xe170, 0xf176, 0x8131, 0x9137, 0xa13d, 0xb13b, 0xc129, 0xd12f, 0xe125, 0xf123, 0x0101,
            0x1107, 0x210d, 0x310b, 0x4119, 0x511f, 0x6115, 0x7113, 0x8333, 0x9335, 0xa33f, 0xb339,
            0xc32b, 0xd32d, 0xe327, 0xf321, 0x0303, 0x1305, 0x230f, 0x3309, 0x431b, 0x531d, 0x6317,
            0x7311, 0x0356, 0x1350, 0x235a, 0x335c, 0x434e, 0x5348, 0x6342, 0x7344, 0x8366, 0x9360,
            0xa36a, 0xb36c, 0xc37e, 0xd378, 0xe372, 0xf374, 0x03fc, 0x13fa, 0x23f0, 0x33f6, 0x43e4,
            0x53e2, 0x63e8, 0x73ee, 0x83cc, 0x93ca, 0xa3c0, 0xb3c6, 0xc3d4, 0xd3d2, 0xe3d8, 0xf3de,
            0x8399, 0x939f, 0xa395, 0xb393, 0xc381, 0xd387, 0xe38d, 0xf38b, 0x03a9, 0x13af, 0x23a5,
            0x33a3, 0x43b1, 0x53b7, 0x63bd, 0x73bb, 0x02a8, 0x12ae, 0x22a4, 0x32a2, 0x42b0, 0x52b6,
            0x62bc, 0x72ba, 0x8298, 0x929e, 0xa294, 0xb292, 0xc280, 0xd286, 0xe28c, 0xf28a, 0x82cd,
            0x92cb, 0xa2c1, 0xb2c7, 0xc2d5, 0xd2d3, 0xe2d9, 0xf2df, 0x02fd, 0x12fb, 0x22f1, 0x32f7,
            0x42e5, 0x52e3, 0x62e9, 0x72ef, 0x8267, 0x9261, 0xa26b, 0xb26d, 0xc27f, 0xd279, 0xe273,
            0xf275, 0x0257, 0x1251, 0x225b, 0x325d, 0x424f, 0x5249, 0x6243, 0x7245, 0x0202, 0x1204,
            0x220e, 0x3208, 0x421a, 0x521c, 0x6216, 0x7210, 0x8232, 0x9234, 0xa23e, 0xb238, 0xc22a,
            0xd22c, 0xe226, 0xf220,
        ],
        [
            0x0000, 0x8663, 0x8cc3, 0x0aa0, 0x9983, 0x1fe0, 0x1540, 0x9323, 0xb303, 0x3560, 0x3fc0,
            0xb9a3, 0x2a80, 0xace3, 0xa643, 0x2020, 0xe603, 0x6060, 0x6ac0, 0xeca3, 0x7f80, 0xf9e3,
            0xf343, 0x7520, 0x5500, 0xd363, 0xd9c3, 0x5fa0, 0xcc83, 0x4ae0, 0x4040, 0xc623, 0x4c03,
            0xca60, 0xc0c0, 0x46a3, 0xd580, 0x53e3, 0x5943, 0xdf20, 0xff00, 0x7963, 0x73c3, 0xf5a0,
            0x6683, 0xe0e0, 0xea40, 0x6c23, 0xaa00, 0x2c63, 0x26c3, 0xa0a0, 0x3383, 0xb5e0, 0xbf40,
            0x3923, 0x1903, 0x9f60, 0x95c0, 0x13a3, 0x8080, 0x06e3, 0x0c43, 0x8a20, 0x9806, 0x1e65,
            0x14c5, 0x92a6, 0x0185, 0x87e6, 0x8d46, 0x0b25, 0x2b05, 0xad66, 0xa7c6, 0x21a5, 0xb286,
            0x34e5, 0x3e45, 0xb826, 0x7e05, 0xf866, 0xf2c6, 0x74a5, 0xe786, 0x61e5, 0x6b45, 0xed26,
            0xcd06, 0x4b65, 0x41c5, 0xc7a6, 0x5485, 0xd2e6, 0xd846, 0x5e25, 0xd405, 0x5266, 0x58c6,
            0xdea5, 0x4d86, 0xcbe5, 0xc145, 0x4726, 0x6706, 0xe165, 0xebc5, 0x6da6, 0xfe85, 0x78e6,
            0x7246, 0xf425, 0x3206, 0xb465, 0xbec5, 0x38a6, 0xab85, 0x2de6, 0x2746, 0xa125, 0x8105,
            0x0766, 0x0dc6, 0x8ba5, 0x1886, 0x9ee5, 0x9445, 0x1226, 0xb009, 0x366a, 0x3cca, 0xbaa9,
            0x298a, 0xafe9, 0xa549, 0x232a, 0x030a, 0x8569, 0x8fc9, 0x09aa, 0x9a89, 0x1cea, 0x164a,
            0x9029, 0x560a, 0xd069, 0xdac9, 0x5caa, 0xcf89, 0x49ea, 0x434a, 0xc529, 0xe509, 0x636a,
            0x69ca, 0xefa9, 0x7c8a, 0xfae9, 0xf049, 0x762a, 0xfc0a, 0x7a69, 0x70c9, 0xf6aa, 0x6589,
            0xe3ea, 0xe94a, 0x6f29, 0x4f09, 0xc96a, 0xc3ca, 0x45a9, 0xd68a, 0x50e9, 0x5a49, 0xdc2a,
            0x1a09, 0x9c6a, 0x96ca, 0x10a9, 0x838a, 0x05e9, 0x0f49, 0x892a, 0xa90a, 0x2f69, 0x25c9,
            0xa3aa, 0x3089, 0xb6ea, 0xbc4a, 0x3a29, 0x280f, 0xae6c, 0xa4cc, 0x22af, 0xb18c, 0x37ef,
            0x3d4f, 0xbb2c, 0x9b0c, 0x1d6f, 0x17cf, 0x91ac, 0x028f, 0x84ec, 0x8e4c, 0x082f, 0xce0c,
            0x486f, 0x42cf, 0xc4ac, 0x578f, 0xd1ec, 0xdb4c, 0x5d2f, 0x7d0f, 0xfb6c, 0xf1cc, 0x77af,
            0xe48c, 0x62ef, 0x684f, 0xee2c, 0x640c, 0xe26f, 0xe8cf, 0x6eac, 0xfd8f, 0x7bec, 0x714c,
            0xf72f, 0xd70f, 0x516c, 0x5bcc, 0xddaf, 0x4e8c, 0xc8ef, 0xc24f, 0x442c, 0x820f, 0x046c,
            0x0ecc, 0x88af, 0x1b8c, 0x9def, 0x974f, 0x112c, 0x310c, 0xb76f, 0xbdcf, 0x3bac, 0xa88f,
            0x2eec, 0x244c, 0xa22f,
        ],
        [
            0x0000, 0xe017, 0x402b, 0xa03c, 0x8056, 0x6041, 0xc07d, 0x206a, 0x80a9, 0x60be, 0xc082,
            0x2095, 0x00ff, 0xe0e8, 0x40d4, 0xa0c3, 0x8157, 0x6140, 0xc17c, 0x216b, 0x0101, 0xe116,
            0x412a, 0xa13d, 0x01fe, 0xe1e9, 0x41d5, 0xa1c2, 0x81a8, 0x61bf, 0xc183, 0x2194, 0x82ab,
            0x62bc, 0xc280, 0x2297, 0x02fd, 0xe2ea, 0x42d6, 0xa2c1, 0x0202, 0xe215, 0x4229, 0xa23e,
            0x8254, 0x6243, 0xc27f, 0x2268, 0x03fc, 0xe3eb, 0x43d7, 0xa3c0, 0x83aa, 0x63bd, 0xc381,
            0x2396, 0x8355, 0x6342, 0xc37e, 0x2369, 0x0303, 0xe314, 0x4328, 0xa33f, 0x8553, 0x6544,
            0xc578, 0x256f, 0x0505, 0xe512, 0x452e, 0xa539, 0x05fa, 0xe5ed, 0x45d1, 0xa5c6, 0x85ac,
            0x65bb, 0xc587, 0x2590, 0x0404, 0xe413, 0x442f, 0xa438, 0x8452, 0x6445, 0xc479, 0x246e,
            0x84ad, 0x64ba, 0xc486, 0x2491, 0x04fb, 0xe4ec, 0x44d0, 0xa4c7, 0x07f8, 0xe7ef, 0x47d3,
            0xa7c4, 0x87ae, 0x67b9, 0xc785, 0x2792, 0x8751, 0x6746, 0xc77a, 0x276d, 0x0707, 0xe710,
            0x472c, 0xa73b, 0x86af, 0x66b8, 0xc684, 0x2693, 0x06f9, 0xe6ee, 0x46d2, 0xa6c5, 0x0606,
            0xe611, 0x462d, 0xa63a, 0x8650, 0x6647, 0xc67b, 0x266c, 0x8aa3, 0x6ab4, 0xca88, 0x2a9f,
            0x0af5, 0xeae2, 0x4ade, 0xaac9, 0x0a0a, 0xea1d, 0x4a21, 0xaa36, 0x8a5c, 0x6a4b, 0xca77,
            0x2a60, 0x0bf4, 0xebe3, 0x4bdf, 0xabc8, 0x8ba2, 0x6bb5, 0xcb89, 0x2b9e, 0x8b5d, 0x6b4a,
            0xcb76, 0x2b61, 0x0b0b, 0xeb1c, 0x4b20, 0xab37, 0x0808, 0xe81f, 0x4823, 0xa834, 0x885e,
            0x6849, 0xc875, 0x2862, 0x88a1, 0x68b6, 0xc88a, 0x289d, 0x08f7, 0xe8e0, 0x48dc, 0xa8cb,
            0x895f, 0x6948, 0xc974, 0x2963, 0x0909, 0xe91e, 0x4922, 0xa935, 0x09f6, 0xe9e1, 0x49dd,
            0xa9ca, 0x89a0, 0x69b7, 0xc98b, 0x299c, 0x0ff0, 0xefe7, 0x4fdb, 0xafcc, 0x8fa6, 0x6fb1,
            0xcf8d, 0x2f9a, 0x8f59, 0x6f4e, 0xcf72, 0x2f65, 0x0f0f, 0xef18, 0x4f24, 0xaf33, 0x8ea7,
            0x6eb0, 0xce8c, 0x2e9b, 0x0ef1, 0xeee6, 0x4eda, 0xaecd, 0x0e0e, 0xee19, 0x4e25, 0xae32,
            0x8e58, 0x6e4f, 0xce73, 0x2e64, 0x8d5b, 0x6d4c, 0xcd70, 0x2d67, 0x0d0d, 0xed1a, 0x4d26,
            0xad31, 0x0df2, 0xede5, 0x4dd9, 0xadce, 0x8da4, 0x6db3, 0xcd8f, 0x2d98, 0x0c0c, 0xec1b,
            0x4c27, 0xac30, 0x8c5a, 0x6c4d, 0xcc71, 0x2c66, 0x8ca5, 0x6cb2, 0xcc8e, 0x2c99, 0x0cf3,
            0xece4, 0x4cd8, 0xaccf,
        ],
        [
            0x0000, 0x9543, 0xaa83, 0x3fc0, 0xd503, 0x4040, 0x7f80, 0xeac3, 0x2a03, 0xbf40, 0x8080,
            0x15c3, 0xff00, 0x6a43, 0x5583, 0xc0c0, 0x5406, 0xc145, 0xfe85, 0x6bc6, 0x8105, 0x1446,
            0x2b86, 0xbec5, 0x7e05, 0xeb46, 0xd486, 0x41c5, 0xab06, 0x3e45, 0x0185, 0x94c6, 0xa80c,
            0x3d4f, 0x028f, 0x97cc, 0x7d0f, 0xe84c, 0xd78c, 0x42cf, 0x820f, 0x174c, 0x288c, 0xbdcf,
            0x570c, 0xc24f, 0xfd8f, 0x68cc, 0xfc0a, 0x6949, 0x5689, 0xc3ca, 0x2909, 0xbc4a, 0x838a,
            0x16c9, 0xd609, 0x434a, 0x7c8a, 0xe9c9, 0x030a, 0x9649, 0xa989, 0x3cca, 0xd01d, 0x455e,
            0x7a9e, 0xefdd, 0x051e, 0x905d, 0xaf9d, 0x3ade, 0xfa1e, 0x6f5d, 0x509d, 0xc5de, 0x2f1d,
            0xba5e, 0x859e, 0x10dd, 0x841b, 0x1158, 0x2e98, 0xbbdb, 0x5118, 0xc45b, 0xfb9b, 0x6ed8,
            0xae18, 0x3b5b, 0x049b, 0x91d8, 0x7b1b, 0xee58, 0xd198, 0x44db, 0x7811, 0xed52, 0xd292,
            0x47d1, 0xad12, 0x3851, 0x0791, 0x92d2, 0x5212, 0xc751, 0xf891, 0x6dd2, 0x8711, 0x1252,
            0x2d92, 0xb8d1, 0x2c17, 0xb954, 0x8694, 0x13d7, 0xf914, 0x6c57, 0x5397, 0xc6d4, 0x0614,
            0x9357, 0xac97, 0x39d4, 0xd317, 0x4654, 0x7994, 0xecd7, 0x203f, 0xb57c, 0x8abc, 0x1fff,
            0xf53c, 0x607f, 0x5fbf, 0xcafc, 0x0a3c, 0x9f7f, 0xa0bf, 0x35fc, 0xdf3f, 0x4a7c, 0x75bc,
            0xe0ff, 0x7439, 0xe17a, 0xdeba, 0x4bf9, 0xa13a, 0x3479, 0x0bb9, 0x9efa, 0x5e3a, 0xcb79,
            0xf4b9, 0x61fa, 0x8b39, 0x1e7a, 0x21ba, 0xb4f9, 0x8833, 0x1d70, 0x22b0, 0xb7f3, 0x5d30,
            0xc873, 0xf7b3, 0x62f0, 0xa230, 0x3773, 0x08b3, 0x9df0, 0x7733, 0xe270, 0xddb0, 0x48f3,
            0xdc35, 0x4976, 0x76b6, 0xe3f5, 0x0936, 0x9c75, 0xa3b5, 0x36f6, 0xf636, 0x6375, 0x5cb5,
            0xc9f6, 0x2335, 0xb676, 0x89b6, 0x1cf5, 0xf022, 0x6561, 0x5aa1, 0xcfe2, 0x2521, 0xb062,
            0x8fa2, 0x1ae1, 0xda21, 0x4f62, 0x70a2, 0xe5e1, 0x0f22, 0x9a61, 0xa5a1, 0x30e2, 0xa424,
            0x3167, 0x0ea7, 0x9be4, 0x7127, 0xe464, 0xdba4, 0x4ee7, 0x8e27, 0x1b64, 0x24a4, 0xb1e7,
            0x5b24, 0xce67, 0xf1a7, 0x64e4, 0x582e, 0xcd6d, 0xf2ad, 0x67ee, 0x8d2d, 0x186e, 0x27ae,
            0xb2ed, 0x722d, 0xe76e, 0xd8ae, 0x4ded, 0xa72e, 0x326d, 0x0dad, 0x98ee, 0x0c28, 0x996b,
            0xa6ab, 0x33e8, 0xd92b, 0x4c68, 0x73a8, 0xe6eb, 0x262b, 0xb368, 0x8ca8, 0x19eb, 0xf328,
            0x666b, 0x59ab, 0xcce8,
        ],
        [
            0x0000, 0x407e, 0x80fc, 0xc082, 0x81fd, 0xc183, 0x0101, 0x417f, 0x83ff, 0xc381, 0x0303,
            0x437d, 0x0202, 0x427c, 0x82fe, 0xc280, 0x87fb, 0xc785, 0x0707, 0x4779, 0x0606, 0x4678,
            0x86fa, 0xc684, 0x0404, 0x447a, 0x84f8, 0xc486, 0x85f9, 0xc587, 0x0505, 0x457b, 0x8ff3,
            0xcf8d, 0x0f0f, 0x4f71, 0x0e0e, 0x4e70, 0x8ef2, 0xce8c, 0x0c0c, 0x4c72, 0x8cf0, 0xcc8e,
            0x8df1, 0xcd8f, 0x0d0d, 0x4d73, 0x0808, 0x4876, 0x88f4, 0xc88a, 0x89f5, 0xc98b, 0x0909,
            0x4977, 0x8bf7, 0xcb89, 0x0b0b, 0x4b75, 0x0a0a, 0x4a74, 0x8af6, 0xca88, 0x9fe3, 0xdf9d,
            0x1f1f, 0x5f61, 0x1e1e, 0x5e60, 0x9ee2, 0xde9c, 0x1c1c, 0x5c62, 0x9ce0, 0xdc9e, 0x9de1,
            0xdd9f, 0x1d1d, 0x5d63, 0x1818, 0x5866, 0x98e4, 0xd89a, 0x99e5, 0xd99b, 0x1919, 0x5967,
            0x9be7, 0xdb99, 0x1b1b, 0x5b65, 0x1a1a, 0x5a64, 0x9ae6, 0xda98, 0x1010, 0x506e, 0x90ec,
            0xd092, 0x91ed, 0xd193, 0x1111, 0x516f, 0x93ef, 0xd391, 0x1313, 0x536d, 0x1212, 0x526c,
            0x92ee, 0xd290, 0x97eb, 0xd795, 0x1717, 0x5769, 0x1616, 0x5668, 0x96ea, 0xd694, 0x1414,
            0x546a, 0x94e8, 0xd496, 0x95e9, 0xd597, 0x1515, 0x556b, 0xbfc3, 0xffbd, 0x3f3f, 0x7f41,
            0x3e3e, 0x7e40, 0xbec2, 0xfebc, 0x3c3c, 0x7c42, 0xbcc0, 0xfcbe, 0xbdc1, 0xfdbf, 0x3d3d,
            0x7d43, 0x3838, 0x7846, 0xb8c4, 0xf8ba, 0xb9c5, 0xf9bb, 0x3939, 0x7947, 0xbbc7, 0xfbb9,
            0x3b3b, 0x7b45, 0x3a3a, 0x7a44, 0xbac6, 0xfab8, 0x3030, 0x704e, 0xb0cc, 0xf0b2, 0xb1cd,
            0xf1b3, 0x3131, 0x714f, 0xb3cf, 0xf3b1, 0x3333, 0x734d, 0x3232, 0x724c, 0xb2ce, 0xf2b0,
            0xb7cb, 0xf7b5, 0x3737, 0x7749, 0x3636, 0x7648, 0xb6ca, 0xf6b4, 0x3434, 0x744a, 0xb4c8,
            0xf4b6, 0xb5c9, 0xf5b7, 0x3535, 0x754b, 0x2020, 0x605e, 0xa0dc, 0xe0a2, 0xa1dd, 0xe1a3,
            0x2121, 0x615f, 0xa3df, 0xe3a1, 0x2323, 0x635d, 0x2222, 0x625c, 0xa2de, 0xe2a0, 0xa7db,
            0xe7a5, 0x2727, 0x6759, 0x2626, 0x6658, 0xa6da, 0xe6a4, 0x2424, 0x645a, 0xa4d8, 0xe4a6,
            0xa5d9, 0xe5a7, 0x2525, 0x655b, 0xafd3, 0xefad, 0x2f2f, 0x6f51, 0x2e2e, 0x6e50, 0xaed2,
            0xeeac, 0x2c2c, 0x6c52, 0xacd0, 0xecae, 0xadd1, 0xedaf, 0x2d2d, 0x6d53, 0x2828, 0x6856,
            0xa8d4, 0xe8aa, 0xa9d5, 0xe9ab, 0x2929, 0x6957, 0xabd7, 0xeba9, 0x2b2b, 0x6b55, 0x2a2a,
            0x6a54, 0xaad6, 0xeaa8,
        ],
        [
            0x0000, 0xff83, 0x7f03, 0x8080, 0xfe06, 0x0185, 0x8105, 0x7e86, 0x7c09, 0x838a, 0x030a,
            0xfc89, 0x820f, 0x7d8c, 0xfd0c, 0x028f, 0xf812, 0x0791, 0x8711, 0x7892, 0x0614, 0xf997,
            0x7917, 0x8694, 0x841b, 0x7b98, 0xfb18, 0x049b, 0x7a1d, 0x859e, 0x051e, 0xfa9d, 0x7021,
            0x8fa2, 0x0f22, 0xf0a1, 0x8e27, 0x71a4, 0xf124, 0x0ea7, 0x0c28, 0xf3ab, 0x732b, 0x8ca8,
            0xf22e, 0x0dad, 0x8d2d, 0x72ae, 0x8833, 0x77b0, 0xf730, 0x08b3, 0x7635, 0x89b6, 0x0936,
            0xf6b5, 0xf43a, 0x0bb9, 0x8b39, 0x74ba, 0x0a3c, 0xf5bf, 0x753f, 0x8abc, 0xe042, 0x1fc1,
            0x9f41, 0x60c2, 0x1e44, 0xe1c7, 0x6147, 0x9ec4, 0x9c4b, 0x63c8, 0xe348, 0x1ccb, 0x624d,
            0x9dce, 0x1d4e, 0xe2cd, 0x1850, 0xe7d3, 0x6753, 0x98d0, 0xe656, 0x19d5, 0x9955, 0x66d6,
            0x6459, 0x9bda, 0x1b5a, 0xe4d9, 0x9a5f, 0x65dc, 0xe55c, 0x1adf, 0x9063, 0x6fe0, 0xef60,
            0x10e3, 0x6e65, 0x91e6, 0x1166, 0xeee5, 0xec6a, 0x13e9, 0x9369, 0x6cea, 0x126c, 0xedef,
            0x6d6f, 0x92ec, 0x6871, 0x97f2, 0x1772, 0xe8f1, 0x9677, 0x69f4, 0xe974, 0x16f7, 0x1478,
            0xebfb, 0x6b7b, 0x94f8, 0xea7e, 0x15fd, 0x957d, 0x6afe, 0x4081, 0xbf02, 0x3f82, 0xc001,
            0xbe87, 0x4104, 0xc184, 0x3e07, 0x3c88, 0xc30b, 0x438b, 0xbc08, 0xc28e, 0x3d0d, 0xbd8d,
            0x420e, 0xb893, 0x4710, 0xc790, 0x3813, 0x4695, 0xb916, 0x3996, 0xc615, 0xc49a, 0x3b19,
            0xbb99, 0x441a, 0x3a9c, 0xc51f, 0x459f, 0xba1c, 0x30a0, 0xcf23, 0x4fa3, 0xb020, 0xcea6,
            0x3125, 0xb1a5, 0x4e26, 0x4ca9, 0xb32a, 0x33aa, 0xcc29, 0xb2af, 0x4d2c, 0xcdac, 0x322f,
            0xc8b2, 0x3731, 0xb7b1, 0x4832, 0x36b4, 0xc937, 0x49b7, 0xb634, 0xb4bb, 0x4b38, 0xcbb8,
            0x343b, 0x4abd, 0xb53e, 0x35be, 0xca3d, 0xa0c3, 0x5f40, 0xdfc0, 0x2043, 0x5ec5, 0xa146,
            0x21c6, 0xde45, 0xdcca, 0x2349, 0xa3c9, 0x5c4a, 0x22cc, 0xdd4f, 0x5dcf, 0xa24c, 0x58d1,
            0xa752, 0x27d2, 0xd851, 0xa6d7, 0x5954, 0xd9d4, 0x2657, 0x24d8, 0xdb5b, 0x5bdb, 0xa458,
            0xdade, 0x255d, 0xa5dd, 0x5a5e, 0xd0e2, 0x2f61, 0xafe1, 0x5062, 0x2ee4, 0xd167, 0x51e7,
            0xae64, 0xaceb, 0x5368, 0xd3e8, 0x2c6b, 0x52ed, 0xad6e, 0x2dee, 0xd26d, 0x28f0, 0xd773,
            0x57f3, 0xa870, 0xd6f6, 0x2975, 0xa9f5, 0x5676, 0x54f9, 0xab7a, 0x2bfa, 0xd479, 0xaaff,
            0x557c, 0xd5fc, 0x2a7f,
        ],
        [
            0x0000, 0x8102, 0x8201, 0x0303, 0x8407, 0x0505, 0x0606, 0x8704, 0x880b, 0x0909, 0x0a0a,
            0x8b08, 0x0c0c, 0x8d0e, 0x8e0d, 0x0f0f, 0x9013, 0x1111, 0x1212, 0x9310, 0x1414, 0x9516,
            0x9615, 0x1717, 0x1818, 0x991a, 0x9a19, 0x1b1b, 0x9c1f, 0x1d1d, 0x1e1e, 0x9f1c, 0xa023,
            0x2121, 0x2222, 0xa320, 0x2424, 0xa526, 0xa625, 0x2727, 0x2828, 0xa92a, 0xaa29, 0x2b2b,
            0xac2f, 0x2d2d, 0x2e2e, 0xaf2c, 0x3030, 0xb132, 0xb231, 0x3333, 0xb437, 0x3535, 0x3636,
            0xb734, 0xb83b, 0x3939, 0x3a3a, 0xbb38, 0x3c3c, 0xbd3e, 0xbe3d, 0x3f3f, 0xc043, 0x4141,
            0x4242, 0xc340, 0x4444, 0xc546, 0xc645, 0x4747, 0x4848, 0xc94a, 0xca49, 0x4b4b, 0xcc4f,
            0x4d4d, 0x4e4e, 0xcf4c, 0x5050, 0xd152, 0xd251, 0x5353, 0xd457, 0x5555, 0x5656, 0xd754,
            0xd85b, 0x5959, 0x5a5a, 0xdb58, 0x5c5c, 0xdd5e, 0xde5d, 0x5f5f, 0x6060, 0xe162, 0xe261,
            0x6363, 0xe467, 0x6565, 0x6666, 0xe764, 0xe86b, 0x6969, 0x6a6a, 0xeb68, 0x6c6c, 0xed6e,
            0xee6d, 0x6f6f, 0xf073, 0x7171, 0x7272, 0xf370, 0x7474, 0xf576, 0xf675, 0x7777, 0x7878,
            0xf97a, 0xfa79, 0x7b7b, 0xfc7f, 0x7d7d, 0x7e7e, 0xff7c, 0x0083, 0x8181, 0x8282, 0x0380,
            0x8484, 0x0586, 0x0685, 0x8787, 0x8888, 0x098a, 0x0a89, 0x8b8b, 0x0c8f, 0x8d8d, 0x8e8e,
            0x0f8c, 0x9090, 0x1192, 0x1291, 0x9393, 0x1497, 0x9595, 0x9696, 0x1794, 0x189b, 0x9999,
            0x9a9a, 0x1b98, 0x9c9c, 0x1d9e, 0x1e9d, 0x9f9f, 0xa0a0, 0x21a2, 0x22a1, 0xa3a3, 0x24a7,
            0xa5a5, 0xa6a6, 0x27a4, 0x28ab, 0xa9a9, 0xaaaa, 0x2ba8, 0xacac, 0x2dae, 0x2ead, 0xafaf,
            0x30b3, 0xb1b1, 0xb2b2, 0x33b0, 0xb4b4, 0x35b6, 0x36b5, 0xb7b7, 0xb8b8, 0x39ba, 0x3ab9,
            0xbbbb, 0x3cbf, 0xbdbd, 0xbebe, 0x3fbc, 0xc0c0, 0x41c2, 0x42c1, 0xc3c3, 0x44c7, 0xc5c5,
            0xc6c6, 0x47c4, 0x48cb, 0xc9c9, 0xcaca, 0x4bc8, 0xcccc, 0x4dce, 0x4ecd, 0xcfcf, 0x50d3,
            0xd1d1, 0xd2d2, 0x53d0, 0xd4d4, 0x55d6, 0x56d5, 0xd7d7, 0xd8d8, 0x59da, 0x5ad9, 0xdbdb,
            0x5cdf, 0xdddd, 0xdede, 0x5fdc, 0x60e3, 0xe1e1, 0xe2e2, 0x63e0, 0xe4e4, 0x65e6, 0x66e5,
            0xe7e7, 0xe8e8, 0x69ea, 0x6ae9, 0xebeb, 0x6cef, 0xeded, 0xeeee, 0x6fec, 0xf0f0, 0x71f2,
            0x72f1, 0xf3f3, 0x74f7, 0xf5f5, 0xf6f6, 0x77f4, 0x78fb, 0xf9f9, 0xfafa, 0x7bf8, 0xfcfc,
            0x7dfe, 0x7efd, 0xffff,
        ],
        [
            0x0000, 0x0106, 0x020c, 0x030a, 0x0418, 0x051e, 0x0614, 0x0712, 0x0830, 0x0936, 0x0a3c,
            0x0b3a, 0x0c28, 0x0d2e, 0x0e24, 0x0f22, 0x1060, 0x1166, 0x126c, 0x136a, 0x1478, 0x157e,
            0x1674, 0x1772, 0x1850, 0x1956, 0x1a5c, 0x1b5a, 0x1c48, 0x1d4e, 0x1e44, 0x1f42, 0x20c0,
            0x21c6, 0x22cc, 0x23ca, 0x24d8, 0x25de, 0x26d4, 0x27d2, 0x28f0, 0x29f6, 0x2afc, 0x2bfa,
            0x2ce8, 0x2dee, 0x2ee4, 0x2fe2, 0x30a0, 0x31a6, 0x32ac, 0x33aa, 0x34b8, 0x35be, 0x36b4,
            0x37b2, 0x3890, 0x3996, 0x3a9c, 0x3b9a, 0x3c88, 0x3d8e, 0x3e84, 0x3f82, 0x4180, 0x4086,
            0x438c, 0x428a, 0x4598, 0x449e, 0x4794, 0x4692, 0x49b0, 0x48b6, 0x4bbc, 0x4aba, 0x4da8,
            0x4cae, 0x4fa4, 0x4ea2, 0x51e0, 0x50e6, 0x53ec, 0x52ea, 0x55f8, 0x54fe, 0x57f4, 0x56f2,
            0x59d0, 0x58d6, 0x5bdc, 0x5ada, 0x5dc8, 0x5cce, 0x5fc4, 0x5ec2, 0x6140, 0x6046, 0x634c,
            0x624a, 0x6558, 0x645e, 0x6754, 0x6652, 0x6970, 0x6876, 0x6b7c, 0x6a7a, 0x6d68, 0x6c6e,
            0x6f64, 0x6e62, 0x7120, 0x7026, 0x732c, 0x722a, 0x7538, 0x743e, 0x7734, 0x7632, 0x7910,
            0x7816, 0x7b1c, 0x7a1a, 0x7d08, 0x7c0e, 0x7f04, 0x7e02, 0x8300, 0x8206, 0x810c, 0x800a,
            0x8718, 0x861e, 0x8514, 0x8412, 0x8b30, 0x8a36, 0x893c, 0x883a, 0x8f28, 0x8e2e, 0x8d24,
            0x8c22, 0x9360, 0x9266, 0x916c, 0x906a, 0x9778, 0x967e, 0x9574, 0x9472, 0x9b50, 0x9a56,
            0x995c, 0x985a, 0x9f48, 0x9e4e, 0x9d44, 0x9c42, 0xa3c0, 0xa2c6, 0xa1cc, 0xa0ca, 0xa7d8,
            0xa6de, 0xa5d4, 0xa4d2, 0xabf0, 0xaaf6, 0xa9fc, 0xa8fa, 0xafe8, 0xaeee, 0xade4, 0xace2,
            0xb3a0, 0xb2a6, 0xb1ac, 0xb0aa, 0xb7b8, 0xb6be, 0xb5b4, 0xb4b2, 0xbb90, 0xba96, 0xb99c,
            0xb89a, 0xbf88, 0xbe8e, 0xbd84, 0xbc82, 0xc280, 0xc386, 0xc08c, 0xc18a, 0xc698, 0xc79e,
            0xc494, 0xc592, 0xcab0, 0xcbb6, 0xc8bc, 0xc9ba, 0xcea8, 0xcfae, 0xcca4, 0xcda2, 0xd2e0,
            0xd3e6, 0xd0ec, 0xd1ea, 0xd6f8, 0xd7fe, 0xd4f4, 0xd5f2, 0xdad0, 0xdbd6, 0xd8dc, 0xd9da,
            0xdec8, 0xdfce, 0xdcc4, 0xddc2, 0xe240, 0xe346, 0xe04c, 0xe14a, 0xe658, 0xe75e, 0xe454,
            0xe552, 0xea70, 0xeb76, 0xe87c, 0xe97a, 0xee68, 0xef6e, 0xec64, 0xed62, 0xf220, 0xf326,
            0xf02c, 0xf12a, 0xf638, 0xf73e, 0xf434, 0xf532, 0xfa10, 0xfb16, 0xf81c, 0xf91a, 0xfe08,
            0xff0e, 0xfc04, 0xfd02,
        ],
        [
            0x0000, 0x8605, 0x8c0f, 0x0a0a, 0x981b, 0x1e1e, 0x1414, 0x9211, 0xb033, 0x3636, 0x3c3c,
            0xba39, 0x2828, 0xae2d, 0xa427, 0x2222, 0xe063, 0x6666, 0x6c6c, 0xea69, 0x7878, 0xfe7d,
            0xf477, 0x7272, 0x5050, 0xd655, 0xdc5f, 0x5a5a, 0xc84b, 0x4e4e, 0x4444, 0xc241, 0x40c3,
            0xc6c6, 0xcccc, 0x4ac9, 0xd8d8, 0x5edd, 0x54d7, 0xd2d2, 0xf0f0, 0x76f5, 0x7cff, 0xfafa,
            0x68eb, 0xeeee, 0xe4e4, 0x62e1, 0xa0a0, 0x26a5, 0x2caf, 0xaaaa, 0x38bb, 0xbebe, 0xb4b4,
            0x32b1, 0x1093, 0x9696, 0x9c9c, 0x1a99, 0x8888, 0x0e8d, 0x0487, 0x8282, 0x8186, 0x0783,
            0x0d89, 0x8b8c, 0x199d, 0x9f98, 0x9592, 0x1397, 0x31b5, 0xb7b0, 0xbdba, 0x3bbf, 0xa9ae,
            0x2fab, 0x25a1, 0xa3a4, 0x61e5, 0xe7e0, 0xedea, 0x6bef, 0xf9fe, 0x7ffb, 0x75f1, 0xf3f4,
            0xd1d6, 0x57d3, 0x5dd9, 0xdbdc, 0x49cd, 0xcfc8, 0xc5c2, 0x43c7, 0xc145, 0x4740, 0x4d4a,
            0xcb4f, 0x595e, 0xdf5b, 0xd551, 0x5354, 0x7176, 0xf773, 0xfd79, 0x7b7c, 0xe96d, 0x6f68,
            0x6562, 0xe367, 0x2126, 0xa723, 0xad29, 0x2b2c, 0xb93d, 0x3f38, 0x3532, 0xb337, 0x9115,
            0x1710, 0x1d1a, 0x9b1f, 0x090e, 0x8f0b, 0x8501, 0x0304, 0x8309, 0x050c, 0x0f06, 0x8903,
            0x1b12, 0x9d17, 0x971d, 0x1118, 0x333a, 0xb53f, 0xbf35, 0x3930, 0xab21, 0x2d24, 0x272e,
            0xa12b, 0x636a, 0xe56f, 0xef65, 0x6960, 0xfb71, 0x7d74, 0x777e, 0xf17b, 0xd359, 0x555c,
            0x5f56, 0xd953, 0x4b42, 0xcd47, 0xc74d, 0x4148, 0xc3ca, 0x45cf, 0x4fc5, 0xc9c0, 0x5bd1,
            0xddd4, 0xd7de, 0x51db, 0x73f9, 0xf5fc, 0xfff6, 0x79f3, 0xebe2, 0x6de7, 0x67ed, 0xe1e8,
            0x23a9, 0xa5ac, 0xafa6, 0x29a3, 0xbbb2, 0x3db7, 0x37bd, 0xb1b8, 0x939a, 0x159f, 0x1f95,
            0x9990, 0x0b81, 0x8d84, 0x878e, 0x018b, 0x028f, 0x848a, 0x8e80, 0x0885, 0x9a94, 0x1c91,
            0x169b, 0x909e, 0xb2bc, 0x34b9, 0x3eb3, 0xb8b6, 0x2aa7, 0xaca2, 0xa6a8, 0x20ad, 0xe2ec,
            0x64e9, 0x6ee3, 0xe8e6, 0x7af7, 0xfcf2, 0xf6f8, 0x70fd, 0x52df, 0xd4da, 0xded0, 0x58d5,
            0xcac4, 0x4cc1, 0x46cb, 0xc0ce, 0x424c, 0xc449, 0xce43, 0x4846, 0xda57, 0x5c52, 0x5658,
            0xd05d, 0xf27f, 0x747a, 0x7e70, 0xf875, 0x6a64, 0xec61, 0xe66b, 0x606e, 0xa22f, 0x242a,
            0x2e20, 0xa825, 0x3a34, 0xbc31, 0xb63b, 0x303e, 0x121c, 0x9419, 0x9e13, 0x1816, 0x8a07,
            0x0c02, 0x0608, 0x800d,
        ],
    ];

    pub static CRC16_DECT_R_TABLE: [[u16; 256]; 16] = [
        [
            0x0000, 0x0589, 0x0b12, 0x0e9b, 0x1624, 0x13ad, 0x1d36, 0x18bf, 0x2c48, 0x29c1, 0x275a,
            0x22d3, 0x3a6c, 0x3fe5, 0x317e, 0x34f7, 0x5890, 0x5d19, 0x5382, 0x560b, 0x4eb4, 0x4b3d,
            0x45a6, 0x402f, 0x74d8, 0x7151, 0x7fca, 0x7a43, 0x62fc, 0x6775, 0x69ee, 0x6c67, 0xb120,
            0xb4a9, 0xba32, 0xbfbb, 0xa704, 0xa28d, 0xac16, 0xa99f, 0x9d68, 0x98e1, 0x967a, 0x93f3,
            0x8b4c, 0x8ec5, 0x805e, 0x85d7, 0xe9b0, 0xec39, 0xe2a2, 0xe72b, 0xff94, 0xfa1d, 0xf486,
            0xf10f, 0xc5f8, 0xc071, 0xceea, 0xcb63, 0xd3dc, 0xd655, 0xd8ce, 0xdd47, 0x67c9, 0x6240,
            0x6cdb, 0x6952, 0x71ed, 0x7464, 0x7aff, 0x7f76, 0x4b81, 0x4e08, 0x4093, 0x451a, 0x5da5,
            0x582c, 0x56b7, 0x533e, 0x3f59, 0x3ad0, 0x344b, 0x31c2, 0x297d, 0x2cf4, 0x226f, 0x27e6,
            0x1311, 0x1698, 0x1803, 0x1d8a, 0x0535, 0x00bc, 0x0e27, 0x0bae, 0xd6e9, 0xd360, 0xddfb,
            0xd872, 0xc0cd, 0xc544, 0xcbdf, 0xce56, 0xfaa1, 0xff28, 0xf1b3, 0xf43a, 0xec85, 0xe90c,
            0xe797, 0xe21e, 0x8e79, 0x8bf0, 0x856b, 0x80e2, 0x985d, 0x9dd4, 0x934f, 0x96c6, 0xa231,
            0xa7b8, 0xa923, 0xacaa, 0xb415, 0xb19c, 0xbf07, 0xba8e, 0xcf92, 0xca1b, 0xc480, 0xc109,
            0xd9b6, 0xdc3f, 0xd2a4, 0xd72d, 0xe3da, 0xe653, 0xe8c8, 0xed41, 0xf5fe, 0xf077, 0xfeec,
            0xfb65, 0x9702, 0x928b, 0x9c10, 0x9999, 0x8126, 0x84af, 0x8a34, 0x8fbd, 0xbb4a, 0xbec3,
            0xb058, 0xb5d1, 0xad6e, 0xa8e7, 0xa67c, 0xa3f5, 0x7eb2, 0x7b3b, 0x75a0, 0x7029, 0x6896,
            0x6d1f, 0x6384, 0x660d, 0x52fa, 0x5773, 0x59e8, 0x5c61, 0x44de, 0x4157, 0x4fcc, 0x4a45,
            0x2622, 0x23ab, 0x2d30, 0x28b9, 0x3006, 0x358f, 0x3b14, 0x3e9d, 0x0a6a, 0x0fe3, 0x0178,
            0x04f1, 0x1c4e, 0x19c7, 0x175c, 0x12d5, 0xa85b, 0xadd2, 0xa349, 0xa6c0, 0xbe7f, 0xbbf6,
            0xb56d, 0xb0e4, 0x8413, 0x819a, 0x8f01, 0x8a88, 0x9237, 0x97be, 0x9925, 0x9cac, 0xf0cb,
            0xf542, 0xfbd9, 0xfe50, 0xe6ef, 0xe366, 0xedfd, 0xe874, 0xdc83, 0xd90a, 0xd791, 0xd218,
            0xcaa7, 0xcf2e, 0xc1b5, 0xc43c, 0x197b, 0x1cf2, 0x1269, 0x17e0, 0x0f5f, 0x0ad6, 0x044d,
            0x01c4, 0x3533, 0x30ba, 0x3e21, 0x3ba8, 0x2317, 0x269e, 0x2805, 0x2d8c, 0x41eb, 0x4462,
            0x4af9, 0x4f70, 0x57cf, 0x5246, 0x5cdd, 0x5954, 0x6da3, 0x682a, 0x66b1, 0x6338, 0x7b87,
            0x7e0e, 0x7095, 0x751c,
        ],
        [
            0x0000, 0x9aad, 0x30d3, 0xaa7e, 0x61a6, 0xfb0b, 0x5175, 0xcbd8, 0xc34c, 0x59e1, 0xf39f,
            0x6932, 0xa2ea, 0x3847, 0x9239, 0x0894, 0x8311, 0x19bc, 0xb3c2, 0x296f, 0xe2b7, 0x781a,
            0xd264, 0x48c9, 0x405d, 0xdaf0, 0x708e, 0xea23, 0x21fb, 0xbb56, 0x1128, 0x8b85, 0x03ab,
            0x9906, 0x3378, 0xa9d5, 0x620d, 0xf8a0, 0x52de, 0xc873, 0xc0e7, 0x5a4a, 0xf034, 0x6a99,
            0xa141, 0x3bec, 0x9192, 0x0b3f, 0x80ba, 0x1a17, 0xb069, 0x2ac4, 0xe11c, 0x7bb1, 0xd1cf,
            0x4b62, 0x43f6, 0xd95b, 0x7325, 0xe988, 0x2250, 0xb8fd, 0x1283, 0x882e, 0x0756, 0x9dfb,
            0x3785, 0xad28, 0x66f0, 0xfc5d, 0x5623, 0xcc8e, 0xc41a, 0x5eb7, 0xf4c9, 0x6e64, 0xa5bc,
            0x3f11, 0x956f, 0x0fc2, 0x8447, 0x1eea, 0xb494, 0x2e39, 0xe5e1, 0x7f4c, 0xd532, 0x4f9f,
            0x470b, 0xdda6, 0x77d8, 0xed75, 0x26ad, 0xbc00, 0x167e, 0x8cd3, 0x04fd, 0x9e50, 0x342e,
            0xae83, 0x655b, 0xfff6, 0x5588, 0xcf25, 0xc7b1, 0x5d1c, 0xf762, 0x6dcf, 0xa617, 0x3cba,
            0x96c4, 0x0c69, 0x87ec, 0x1d41, 0xb73f, 0x2d92, 0xe64a, 0x7ce7, 0xd699, 0x4c34, 0x44a0,
            0xde0d, 0x7473, 0xeede, 0x2506, 0xbfab, 0x15d5, 0x8f78, 0x0eac, 0x9401, 0x3e7f, 0xa4d2,
            0x6f0a, 0xf5a7, 0x5fd9, 0xc574, 0xcde0, 0x574d, 0xfd33, 0x679e, 0xac46, 0x36eb, 0x9c95,
            0x0638, 0x8dbd, 0x1710, 0xbd6e, 0x27c3, 0xec1b, 0x76b6, 0xdcc8, 0x4665, 0x4ef1, 0xd45c,
            0x7e22, 0xe48f, 0x2f57, 0xb5fa, 0x1f84, 0x8529, 0x0d07, 0x97aa, 0x3dd4, 0xa779, 0x6ca1,
            0xf60c, 0x5c72, 0xc6df, 0xce4b, 0x54e6, 0xfe98, 0x6435, 0xafed, 0x3540, 0x9f3e, 0x0593,
            0x8e16, 0x14bb, 0xbec5, 0x2468, 0xefb0, 0x751d, 0xdf63, 0x45ce, 0x4d5a, 0xd7f7, 0x7d89,
            0xe724, 0x2cfc, 0xb651, 0x1c2f, 0x8682, 0x09fa, 0x9357, 0x3929, 0xa384, 0x685c, 0xf2f1,
            0x588f, 0xc222, 0xcab6, 0x501b, 0xfa65, 0x60c8, 0xab10, 0x31bd, 0x9bc3, 0x016e, 0x8aeb,
            0x1046, 0xba38, 0x2095, 0xeb4d, 0x71e0, 0xdb9e, 0x4133, 0x49a7, 0xd30a, 0x7974, 0xe3d9,
            0x2801, 0xb2ac, 0x18d2, 0x827f, 0x0a51, 0x90fc, 0x3a82, 0xa02f, 0x6bf7, 0xf15a, 0x5b24,
            0xc189, 0xc91d, 0x53b0, 0xf9ce, 0x6363, 0xa8bb, 0x3216, 0x9868, 0x02c5, 0x8940, 0x13ed,
            0xb993, 0x233e, 0xe8e6, 0x724b, 0xd835, 0x4298, 0x4a0c, 0xd0a1, 0x7adf, 0xe072, 0x2baa,
            0xb107, 0x1b79, 0x81d4,
        ],
        [
            0x0000, 0x1d58, 0x3ab0, 0x27e8, 0x7560, 0x6838, 0x4fd0, 0x5288, 0xeac0, 0xf798, 0xd070,
            0xcd28, 0x9fa0, 0x82f8, 0xa510, 0xb848, 0xd009, 0xcd51, 0xeab9, 0xf7e1, 0xa569, 0xb831,
            0x9fd9, 0x8281, 0x3ac9, 0x2791, 0x0079, 0x1d21, 0x4fa9, 0x52f1, 0x7519, 0x6841, 0xa59b,
            0xb8c3, 0x9f2b, 0x8273, 0xd0fb, 0xcda3, 0xea4b, 0xf713, 0x4f5b, 0x5203, 0x75eb, 0x68b3,
            0x3a3b, 0x2763, 0x008b, 0x1dd3, 0x7592, 0x68ca, 0x4f22, 0x527a, 0x00f2, 0x1daa, 0x3a42,
            0x271a, 0x9f52, 0x820a, 0xa5e2, 0xb8ba, 0xea32, 0xf76a, 0xd082, 0xcdda, 0x4ebf, 0x53e7,
            0x740f, 0x6957, 0x3bdf, 0x2687, 0x016f, 0x1c37, 0xa47f, 0xb927, 0x9ecf, 0x8397, 0xd11f,
            0xcc47, 0xebaf, 0xf6f7, 0x9eb6, 0x83ee, 0xa406, 0xb95e, 0xebd6, 0xf68e, 0xd166, 0xcc3e,
            0x7476, 0x692e, 0x4ec6, 0x539e, 0x0116, 0x1c4e, 0x3ba6, 0x26fe, 0xeb24, 0xf67c, 0xd194,
            0xcccc, 0x9e44, 0x831c, 0xa4f4, 0xb9ac, 0x01e4, 0x1cbc, 0x3b54, 0x260c, 0x7484, 0x69dc,
            0x4e34, 0x536c, 0x3b2d, 0x2675, 0x019d, 0x1cc5, 0x4e4d, 0x5315, 0x74fd, 0x69a5, 0xd1ed,
            0xccb5, 0xeb5d, 0xf605, 0xa48d, 0xb9d5, 0x9e3d, 0x8365, 0x9d7e, 0x8026, 0xa7ce, 0xba96,
            0xe81e, 0xf546, 0xd2ae, 0xcff6, 0x77be, 0x6ae6, 0x4d0e, 0x5056, 0x02de, 0x1f86, 0x386e,
            0x2536, 0x4d77, 0x502f, 0x77c7, 0x6a9f, 0x3817, 0x254f, 0x02a7, 0x1fff, 0xa7b7, 0xbaef,
            0x9d07, 0x805f, 0xd2d7, 0xcf8f, 0xe867, 0xf53f, 0x38e5, 0x25bd, 0x0255, 0x1f0d, 0x4d85,
            0x50dd, 0x7735, 0x6a6d, 0xd225, 0xcf7d, 0xe895, 0xf5cd, 0xa745, 0xba1d, 0x9df5, 0x80ad,
            0xe8ec, 0xf5b4, 0xd25c, 0xcf04, 0x9d8c, 0x80d4, 0xa73c, 0xba64, 0x022c, 0x1f74, 0x389c,
            0x25c4, 0x774c, 0x6a14, 0x4dfc, 0x50a4, 0xd3c1, 0xce99, 0xe971, 0xf429, 0xa6a1, 0xbbf9,
            0x9c11, 0x8149, 0x3901, 0x2459, 0x03b1, 0x1ee9, 0x4c61, 0x5139, 0x76d1, 0x6b89, 0x03c8,
            0x1e90, 0x3978, 0x2420, 0x76a8, 0x6bf0, 0x4c18, 0x5140, 0xe908, 0xf450, 0xd3b8, 0xcee0,
            0x9c68, 0x8130, 0xa6d8, 0xbb80, 0x765a, 0x6b02, 0x4cea, 0x51b2, 0x033a, 0x1e62, 0x398a,
            0x24d2, 0x9c9a, 0x81c2, 0xa62a, 0xbb72, 0xe9fa, 0xf4a2, 0xd34a, 0xce12, 0xa653, 0xbb0b,
            0x9ce3, 0x81bb, 0xd333, 0xce6b, 0xe983, 0xf4db, 0x4c93, 0x51cb, 0x7623, 0x6b7b, 0x39f3,
            0x24ab, 0x0343, 0x1e1b,
        ],
        [
            0x0000, 0x3f75, 0x7eea, 0x419f, 0xfdd4, 0xc2a1, 0x833e, 0xbc4b, 0xfe21, 0xc154, 0x80cb,
            0xbfbe, 0x03f5, 0x3c80, 0x7d1f, 0x426a, 0xf9cb, 0xc6be, 0x8721, 0xb854, 0x041f, 0x3b6a,
            0x7af5, 0x4580, 0x07ea, 0x389f, 0x7900, 0x4675, 0xfa3e, 0xc54b, 0x84d4, 0xbba1, 0xf61f,
            0xc96a, 0x88f5, 0xb780, 0x0bcb, 0x34be, 0x7521, 0x4a54, 0x083e, 0x374b, 0x76d4, 0x49a1,
            0xf5ea, 0xca9f, 0x8b00, 0xb475, 0x0fd4, 0x30a1, 0x713e, 0x4e4b, 0xf200, 0xcd75, 0x8cea,
            0xb39f, 0xf1f5, 0xce80, 0x8f1f, 0xb06a, 0x0c21, 0x3354, 0x72cb, 0x4dbe, 0xe9b7, 0xd6c2,
            0x975d, 0xa828, 0x1463, 0x2b16, 0x6a89, 0x55fc, 0x1796, 0x28e3, 0x697c, 0x5609, 0xea42,
            0xd537, 0x94a8, 0xabdd, 0x107c, 0x2f09, 0x6e96, 0x51e3, 0xeda8, 0xd2dd, 0x9342, 0xac37,
            0xee5d, 0xd128, 0x90b7, 0xafc2, 0x1389, 0x2cfc, 0x6d63, 0x5216, 0x1fa8, 0x20dd, 0x6142,
            0x5e37, 0xe27c, 0xdd09, 0x9c96, 0xa3e3, 0xe189, 0xdefc, 0x9f63, 0xa016, 0x1c5d, 0x2328,
            0x62b7, 0x5dc2, 0xe663, 0xd916, 0x9889, 0xa7fc, 0x1bb7, 0x24c2, 0x655d, 0x5a28, 0x1842,
            0x2737, 0x66a8, 0x59dd, 0xe596, 0xdae3, 0x9b7c, 0xa409, 0xd6e7, 0xe992, 0xa80d, 0x9778,
            0x2b33, 0x1446, 0x55d9, 0x6aac, 0x28c6, 0x17b3, 0x562c, 0x6959, 0xd512, 0xea67, 0xabf8,
            0x948d, 0x2f2c, 0x1059, 0x51c6, 0x6eb3, 0xd2f8, 0xed8d, 0xac12, 0x9367, 0xd10d, 0xee78,
            0xafe7, 0x9092, 0x2cd9, 0x13ac, 0x5233, 0x6d46, 0x20f8, 0x1f8d, 0x5e12, 0x6167, 0xdd2c,
            0xe259, 0xa3c6, 0x9cb3, 0xded9, 0xe1ac, 0xa033, 0x9f46, 0x230d, 0x1c78, 0x5de7, 0x6292,
            0xd933, 0xe646, 0xa7d9, 0x98ac, 0x24e7, 0x1b92, 0x5a0d, 0x6578, 0x2712, 0x1867, 0x59f8,
            0x668d, 0xdac6, 0xe5b3, 0xa42c, 0x9b59, 0x3f50, 0x0025, 0x41ba, 0x7ecf, 0xc284, 0xfdf1,
            0xbc6e, 0x831b, 0xc171, 0xfe04, 0xbf9b, 0x80ee, 0x3ca5, 0x03d0, 0x424f, 0x7d3a, 0xc69b,
            0xf9ee, 0xb871, 0x8704, 0x3b4f, 0x043a, 0x45a5, 0x7ad0, 0x38ba, 0x07cf, 0x4650, 0x7925,
            0xc56e, 0xfa1b, 0xbb84, 0x84f1, 0xc94f, 0xf63a, 0xb7a5, 0x88d0, 0x349b, 0x0bee, 0x4a71,
            0x7504, 0x376e, 0x081b, 0x4984, 0x76f1, 0xcaba, 0xf5cf, 0xb450, 0x8b25, 0x3084, 0x0ff1,
            0x4e6e, 0x711b, 0xcd50, 0xf225, 0xb3ba, 0x8ccf, 0xcea5, 0xf1d0, 0xb04f, 0x8f3a, 0x3371,
            0x0c04, 0x4d9b, 0x72ee,
        ],
        [
            0x0000, 0xa847, 0x5507, 0xfd40, 0xaa0e, 0x0249, 0xff09, 0x574e, 0x5195, 0xf9d2, 0x0492,
            0xacd5, 0xfb9b, 0x53dc, 0xae9c, 0x06db, 0xa32a, 0x0b6d, 0xf62d, 0x5e6a, 0x0924, 0xa163,
            0x5c23, 0xf464, 0xf2bf, 0x5af8, 0xa7b8, 0x0fff, 0x58b1, 0xf0f6, 0x0db6, 0xa5f1, 0x43dd,
            0xeb9a, 0x16da, 0xbe9d, 0xe9d3, 0x4194, 0xbcd4, 0x1493, 0x1248, 0xba0f, 0x474f, 0xef08,
            0xb846, 0x1001, 0xed41, 0x4506, 0xe0f7, 0x48b0, 0xb5f0, 0x1db7, 0x4af9, 0xe2be, 0x1ffe,
            0xb7b9, 0xb162, 0x1925, 0xe465, 0x4c22, 0x1b6c, 0xb32b, 0x4e6b, 0xe62c, 0x87ba, 0x2ffd,
            0xd2bd, 0x7afa, 0x2db4, 0x85f3, 0x78b3, 0xd0f4, 0xd62f, 0x7e68, 0x8328, 0x2b6f, 0x7c21,
            0xd466, 0x2926, 0x8161, 0x2490, 0x8cd7, 0x7197, 0xd9d0, 0x8e9e, 0x26d9, 0xdb99, 0x73de,
            0x7505, 0xdd42, 0x2002, 0x8845, 0xdf0b, 0x774c, 0x8a0c, 0x224b, 0xc467, 0x6c20, 0x9160,
            0x3927, 0x6e69, 0xc62e, 0x3b6e, 0x9329, 0x95f2, 0x3db5, 0xc0f5, 0x68b2, 0x3ffc, 0x97bb,
            0x6afb, 0xc2bc, 0x674d, 0xcf0a, 0x324a, 0x9a0d, 0xcd43, 0x6504, 0x9844, 0x3003, 0x36d8,
            0x9e9f, 0x63df, 0xcb98, 0x9cd6, 0x3491, 0xc9d1, 0x6196, 0x0afd, 0xa2ba, 0x5ffa, 0xf7bd,
            0xa0f3, 0x08b4, 0xf5f4, 0x5db3, 0x5b68, 0xf32f, 0x0e6f, 0xa628, 0xf166, 0x5921, 0xa461,
            0x0c26, 0xa9d7, 0x0190, 0xfcd0, 0x5497, 0x03d9, 0xab9e, 0x56de, 0xfe99, 0xf842, 0x5005,
            0xad45, 0x0502, 0x524c, 0xfa0b, 0x074b, 0xaf0c, 0x4920, 0xe167, 0x1c27, 0xb460, 0xe32e,
            0x4b69, 0xb629, 0x1e6e, 0x18b5, 0xb0f2, 0x4db2, 0xe5f5, 0xb2bb, 0x1afc, 0xe7bc, 0x4ffb,
            0xea0a, 0x424d, 0xbf0d, 0x174a, 0x4004, 0xe843, 0x1503, 0xbd44, 0xbb9f, 0x13d8, 0xee98,
            0x46df, 0x1191, 0xb9d6, 0x4496, 0xecd1, 0x8d47, 0x2500, 0xd840, 0x7007, 0x2749, 0x8f0e,
            0x724e, 0xda09, 0xdcd2, 0x7495, 0x89d5, 0x2192, 0x76dc, 0xde9b, 0x23db, 0x8b9c, 0x2e6d,
            0x862a, 0x7b6a, 0xd32d, 0x8463, 0x2c24, 0xd164, 0x7923, 0x7ff8, 0xd7bf, 0x2aff, 0x82b8,
            0xd5f6, 0x7db1, 0x80f1, 0x28b6, 0xce9a, 0x66dd, 0x9b9d, 0x33da, 0x6494, 0xccd3, 0x3193,
            0x99d4, 0x9f0f, 0x3748, 0xca08, 0x624f, 0x3501, 0x9d46, 0x6006, 0xc841, 0x6db0, 0xc5f7,
            0x38b7, 0x90f0, 0xc7be, 0x6ff9, 0x92b9, 0x3afe, 0x3c25, 0x9462, 0x6922, 0xc165, 0x962b,
            0x3e6c, 0xc32c, 0x6b6b,
        ],
        [
            0x0000, 0x15fa, 0x2bf4, 0x3e0e, 0x57e8, 0x4212, 0x7c1c, 0x69e6, 0xafd0, 0xba2a, 0x8424,
            0x91de, 0xf838, 0xedc2, 0xd3cc, 0xc636, 0x5a29, 0x4fd3, 0x71dd, 0x6427, 0x0dc1, 0x183b,
            0x2635, 0x33cf, 0xf5f9, 0xe003, 0xde0d, 0xcbf7, 0xa211, 0xb7eb, 0x89e5, 0x9c1f, 0xb452,
            0xa1a8, 0x9fa6, 0x8a5c, 0xe3ba, 0xf640, 0xc84e, 0xddb4, 0x1b82, 0x0e78, 0x3076, 0x258c,
            0x4c6a, 0x5990, 0x679e, 0x7264, 0xee7b, 0xfb81, 0xc58f, 0xd075, 0xb993, 0xac69, 0x9267,
            0x879d, 0x41ab, 0x5451, 0x6a5f, 0x7fa5, 0x1643, 0x03b9, 0x3db7, 0x284d, 0x6d2d, 0x78d7,
            0x46d9, 0x5323, 0x3ac5, 0x2f3f, 0x1131, 0x04cb, 0xc2fd, 0xd707, 0xe909, 0xfcf3, 0x9515,
            0x80ef, 0xbee1, 0xab1b, 0x3704, 0x22fe, 0x1cf0, 0x090a, 0x60ec, 0x7516, 0x4b18, 0x5ee2,
            0x98d4, 0x8d2e, 0xb320, 0xa6da, 0xcf3c, 0xdac6, 0xe4c8, 0xf132, 0xd97f, 0xcc85, 0xf28b,
            0xe771, 0x8e97, 0x9b6d, 0xa563, 0xb099, 0x76af, 0x6355, 0x5d5b, 0x48a1, 0x2147, 0x34bd,
            0x0ab3, 0x1f49, 0x8356, 0x96ac, 0xa8a2, 0xbd58, 0xd4be, 0xc144, 0xff4a, 0xeab0, 0x2c86,
            0x397c, 0x0772, 0x1288, 0x7b6e, 0x6e94, 0x509a, 0x4560, 0xda5a, 0xcfa0, 0xf1ae, 0xe454,
            0x8db2, 0x9848, 0xa646, 0xb3bc, 0x758a, 0x6070, 0x5e7e, 0x4b84, 0x2262, 0x3798, 0x0996,
            0x1c6c, 0x8073, 0x9589, 0xab87, 0xbe7d, 0xd79b, 0xc261, 0xfc6f, 0xe995, 0x2fa3, 0x3a59,
            0x0457, 0x11ad, 0x784b, 0x6db1, 0x53bf, 0x4645, 0x6e08, 0x7bf2, 0x45fc, 0x5006, 0x39e0,
            0x2c1a, 0x1214, 0x07ee, 0xc1d8, 0xd422, 0xea2c, 0xffd6, 0x9630, 0x83ca, 0xbdc4, 0xa83e,
            0x3421, 0x21db, 0x1fd5, 0x0a2f, 0x63c9, 0x7633, 0x483d, 0x5dc7, 0x9bf1, 0x8e0b, 0xb005,
            0xa5ff, 0xcc19, 0xd9e3, 0xe7ed, 0xf217, 0xb777, 0xa28d, 0x9c83, 0x8979, 0xe09f, 0xf565,
            0xcb6b, 0xde91, 0x18a7, 0x0d5d, 0x3353, 0x26a9, 0x4f4f, 0x5ab5, 0x64bb, 0x7141, 0xed5e,
            0xf8a4, 0xc6aa, 0xd350, 0xbab6, 0xaf4c, 0x9142, 0x84b8, 0x428e, 0x5774, 0x697a, 0x7c80,
            0x1566, 0x009c, 0x3e92, 0x2b68, 0x0325, 0x16df, 0x28d1, 0x3d2b, 0x54cd, 0x4137, 0x7f39,
            0x6ac3, 0xacf5, 0xb90f, 0x8701, 0x92fb, 0xfb1d, 0xeee7, 0xd0e9, 0xc513, 0x590c, 0x4cf6,
            0x72f8, 0x6702, 0x0ee4, 0x1b1e, 0x2510, 0x30ea, 0xf6dc, 0xe326, 0xdd28, 0xc8d2, 0xa134,
            0xb4ce, 0x8ac0, 0x9f3a,
        ],
        [
            0x0000, 0xb13d, 0x67f3, 0xd6ce, 0xcfe6, 0x7edb, 0xa815, 0x1928, 0x9a45, 0x2b78, 0xfdb6,
            0x4c8b, 0x55a3, 0xe49e, 0x3250, 0x836d, 0x3103, 0x803e, 0x56f0, 0xe7cd, 0xfee5, 0x4fd8,
            0x9916, 0x282b, 0xab46, 0x1a7b, 0xccb5, 0x7d88, 0x64a0, 0xd59d, 0x0353, 0xb26e, 0x6206,
            0xd33b, 0x05f5, 0xb4c8, 0xade0, 0x1cdd, 0xca13, 0x7b2e, 0xf843, 0x497e, 0x9fb0, 0x2e8d,
            0x37a5, 0x8698, 0x5056, 0xe16b, 0x5305, 0xe238, 0x34f6, 0x85cb, 0x9ce3, 0x2dde, 0xfb10,
            0x4a2d, 0xc940, 0x787d, 0xaeb3, 0x1f8e, 0x06a6, 0xb79b, 0x6155, 0xd068, 0xc40c, 0x7531,
            0xa3ff, 0x12c2, 0x0bea, 0xbad7, 0x6c19, 0xdd24, 0x5e49, 0xef74, 0x39ba, 0x8887, 0x91af,
            0x2092, 0xf65c, 0x4761, 0xf50f, 0x4432, 0x92fc, 0x23c1, 0x3ae9, 0x8bd4, 0x5d1a, 0xec27,
            0x6f4a, 0xde77, 0x08b9, 0xb984, 0xa0ac, 0x1191, 0xc75f, 0x7662, 0xa60a, 0x1737, 0xc1f9,
            0x70c4, 0x69ec, 0xd8d1, 0x0e1f, 0xbf22, 0x3c4f, 0x8d72, 0x5bbc, 0xea81, 0xf3a9, 0x4294,
            0x945a, 0x2567, 0x9709, 0x2634, 0xf0fa, 0x41c7, 0x58ef, 0xe9d2, 0x3f1c, 0x8e21, 0x0d4c,
            0xbc71, 0x6abf, 0xdb82, 0xc2aa, 0x7397, 0xa559, 0x1464, 0x8d91, 0x3cac, 0xea62, 0x5b5f,
            0x4277, 0xf34a, 0x2584, 0x94b9, 0x17d4, 0xa6e9, 0x7027, 0xc11a, 0xd832, 0x690f, 0xbfc1,
            0x0efc, 0xbc92, 0x0daf, 0xdb61, 0x6a5c, 0x7374, 0xc249, 0x1487, 0xa5ba, 0x26d7, 0x97ea,
            0x4124, 0xf019, 0xe931, 0x580c, 0x8ec2, 0x3fff, 0xef97, 0x5eaa, 0x8864, 0x3959, 0x2071,
            0x914c, 0x4782, 0xf6bf, 0x75d2, 0xc4ef, 0x1221, 0xa31c, 0xba34, 0x0b09, 0xddc7, 0x6cfa,
            0xde94, 0x6fa9, 0xb967, 0x085a, 0x1172, 0xa04f, 0x7681, 0xc7bc, 0x44d1, 0xf5ec, 0x2322,
            0x921f, 0x8b37, 0x3a0a, 0xecc4, 0x5df9, 0x499d, 0xf8a0, 0x2e6e, 0x9f53, 0x867b, 0x3746,
            0xe188, 0x50b5, 0xd3d8, 0x62e5, 0xb42b, 0x0516, 0x1c3e, 0xad03, 0x7bcd, 0xcaf0, 0x789e,
            0xc9a3, 0x1f6d, 0xae50, 0xb778, 0x0645, 0xd08b, 0x61b6, 0xe2db, 0x53e6, 0x8528, 0x3415,
            0x2d3d, 0x9c00, 0x4ace, 0xfbf3, 0x2b9b, 0x9aa6, 0x4c68, 0xfd55, 0xe47d, 0x5540, 0x838e,
            0x32b3, 0xb1de, 0x00e3, 0xd62d, 0x6710, 0x7e38, 0xcf05, 0x19cb, 0xa8f6, 0x1a98, 0xaba5,
            0x7d6b, 0xcc56, 0xd57e, 0x6443, 0xb28d, 0x03b0, 0x80dd, 0x31e0, 0xe72e, 0x5613, 0x4f3b,
            0xfe06, 0x28c8, 0x99f5,
        ],
        [
            0x0000, 0x1eab, 0x3d56, 0x23fd, 0x7aac, 0x6407, 0x47fa, 0x5951, 0xf558, 0xebf3, 0xc80e,
            0xd6a5, 0x8ff4, 0x915f, 0xb2a2, 0xac09, 0xef39, 0xf192, 0xd26f, 0xccc4, 0x9595, 0x8b3e,
            0xa8c3, 0xb668, 0x1a61, 0x04ca, 0x2737, 0x399c, 0x60cd, 0x7e66, 0x5d9b, 0x4330, 0xdbfb,
            0xc550, 0xe6ad, 0xf806, 0xa157, 0xbffc, 0x9c01, 0x82aa, 0x2ea3, 0x3008, 0x13f5, 0x0d5e,
            0x540f, 0x4aa4, 0x6959, 0x77f2, 0x34c2, 0x2a69, 0x0994, 0x173f, 0x4e6e, 0x50c5, 0x7338,
            0x6d93, 0xc19a, 0xdf31, 0xfccc, 0xe267, 0xbb36, 0xa59d, 0x8660, 0x98cb, 0xb27f, 0xacd4,
            0x8f29, 0x9182, 0xc8d3, 0xd678, 0xf585, 0xeb2e, 0x4727, 0x598c, 0x7a71, 0x64da, 0x3d8b,
            0x2320, 0x00dd, 0x1e76, 0x5d46, 0x43ed, 0x6010, 0x7ebb, 0x27ea, 0x3941, 0x1abc, 0x0417,
            0xa81e, 0xb6b5, 0x9548, 0x8be3, 0xd2b2, 0xcc19, 0xefe4, 0xf14f, 0x6984, 0x772f, 0x54d2,
            0x4a79, 0x1328, 0x0d83, 0x2e7e, 0x30d5, 0x9cdc, 0x8277, 0xa18a, 0xbf21, 0xe670, 0xf8db,
            0xdb26, 0xc58d, 0x86bd, 0x9816, 0xbbeb, 0xa540, 0xfc11, 0xe2ba, 0xc147, 0xdfec, 0x73e5,
            0x6d4e, 0x4eb3, 0x5018, 0x0949, 0x17e2, 0x341f, 0x2ab4, 0x6177, 0x7fdc, 0x5c21, 0x428a,
            0x1bdb, 0x0570, 0x268d, 0x3826, 0x942f, 0x8a84, 0xa979, 0xb7d2, 0xee83, 0xf028, 0xd3d5,
            0xcd7e, 0x8e4e, 0x90e5, 0xb318, 0xadb3, 0xf4e2, 0xea49, 0xc9b4, 0xd71f, 0x7b16, 0x65bd,
            0x4640, 0x58eb, 0x01ba, 0x1f11, 0x3cec, 0x2247, 0xba8c, 0xa427, 0x87da, 0x9971, 0xc020,
            0xde8b, 0xfd76, 0xe3dd, 0x4fd4, 0x517f, 0x7282, 0x6c29, 0x3578, 0x2bd3, 0x082e, 0x1685,
            0x55b5, 0x4b1e, 0x68e3, 0x7648, 0x2f19, 0x31b2, 0x124f, 0x0ce4, 0xa0ed, 0xbe46, 0x9dbb,
            0x8310, 0xda41, 0xc4ea, 0xe717, 0xf9bc, 0xd308, 0xcda3, 0xee5e, 0xf0f5, 0xa9a4, 0xb70f,
            0x94f2, 0x8a59, 0x2650, 0x38fb, 0x1b06, 0x05ad, 0x5cfc, 0x4257, 0x61aa, 0x7f01, 0x3c31,
            0x229a, 0x0167, 0x1fcc, 0x469d, 0x5836, 0x7bcb, 0x6560, 0xc969, 0xd7c2, 0xf43f, 0xea94,
            0xb3c5, 0xad6e, 0x8e93, 0x9038, 0x08f3, 0x1658, 0x35a5, 0x2b0e, 0x725f, 0x6cf4, 0x4f09,
            0x51a2, 0xfdab, 0xe300, 0xc0fd, 0xde56, 0x8707, 0x99ac, 0xba51, 0xa4fa, 0xe7ca, 0xf961,
            0xda9c, 0xc437, 0x9d66, 0x83cd, 0xa030, 0xbe9b, 0x1292, 0x0c39, 0x2fc4, 0x316f, 0x683e,
            0x7695, 0x5568, 0x4bc3,
        ],
        [
            0x0000, 0xc2ee, 0x8055, 0x42bb, 0x0523, 0xc7cd, 0x8576, 0x4798, 0x0a46, 0xc8a8, 0x8a13,
            0x48fd, 0x0f65, 0xcd8b, 0x8f30, 0x4dde, 0x148c, 0xd662, 0x94d9, 0x5637, 0x11af, 0xd341,
            0x91fa, 0x5314, 0x1eca, 0xdc24, 0x9e9f, 0x5c71, 0x1be9, 0xd907, 0x9bbc, 0x5952, 0x2918,
            0xebf6, 0xa94d, 0x6ba3, 0x2c3b, 0xeed5, 0xac6e, 0x6e80, 0x235e, 0xe1b0, 0xa30b, 0x61e5,
            0x267d, 0xe493, 0xa628, 0x64c6, 0x3d94, 0xff7a, 0xbdc1, 0x7f2f, 0x38b7, 0xfa59, 0xb8e2,
            0x7a0c, 0x37d2, 0xf53c, 0xb787, 0x7569, 0x32f1, 0xf01f, 0xb2a4, 0x704a, 0x5230, 0x90de,
            0xd265, 0x108b, 0x5713, 0x95fd, 0xd746, 0x15a8, 0x5876, 0x9a98, 0xd823, 0x1acd, 0x5d55,
            0x9fbb, 0xdd00, 0x1fee, 0x46bc, 0x8452, 0xc6e9, 0x0407, 0x439f, 0x8171, 0xc3ca, 0x0124,
            0x4cfa, 0x8e14, 0xccaf, 0x0e41, 0x49d9, 0x8b37, 0xc98c, 0x0b62, 0x7b28, 0xb9c6, 0xfb7d,
            0x3993, 0x7e0b, 0xbce5, 0xfe5e, 0x3cb0, 0x716e, 0xb380, 0xf13b, 0x33d5, 0x744d, 0xb6a3,
            0xf418, 0x36f6, 0x6fa4, 0xad4a, 0xeff1, 0x2d1f, 0x6a87, 0xa869, 0xead2, 0x283c, 0x65e2,
            0xa70c, 0xe5b7, 0x2759, 0x60c1, 0xa22f, 0xe094, 0x227a, 0xa460, 0x668e, 0x2435, 0xe6db,
            0xa143, 0x63ad, 0x2116, 0xe3f8, 0xae26, 0x6cc8, 0x2e73, 0xec9d, 0xab05, 0x69eb, 0x2b50,
            0xe9be, 0xb0ec, 0x7202, 0x30b9, 0xf257, 0xb5cf, 0x7721, 0x359a, 0xf774, 0xbaaa, 0x7844,
            0x3aff, 0xf811, 0xbf89, 0x7d67, 0x3fdc, 0xfd32, 0x8d78, 0x4f96, 0x0d2d, 0xcfc3, 0x885b,
            0x4ab5, 0x080e, 0xcae0, 0x873e, 0x45d0, 0x076b, 0xc585, 0x821d, 0x40f3, 0x0248, 0xc0a6,
            0x99f4, 0x5b1a, 0x19a1, 0xdb4f, 0x9cd7, 0x5e39, 0x1c82, 0xde6c, 0x93b2, 0x515c, 0x13e7,
            0xd109, 0x9691, 0x547f, 0x16c4, 0xd42a, 0xf650, 0x34be, 0x7605, 0xb4eb, 0xf373, 0x319d,
            0x7326, 0xb1c8, 0xfc16, 0x3ef8, 0x7c43, 0xbead, 0xf935, 0x3bdb, 0x7960, 0xbb8e, 0xe2dc,
            0x2032, 0x6289, 0xa067, 0xe7ff, 0x2511, 0x67aa, 0xa544, 0xe89a, 0x2a74, 0x68cf, 0xaa21,
            0xedb9, 0x2f57, 0x6dec, 0xaf02, 0xdf48, 0x1da6, 0x5f1d, 0x9df3, 0xda6b, 0x1885, 0x5a3e,
            0x98d0, 0xd50e, 0x17e0, 0x555b, 0x97b5, 0xd02d, 0x12c3, 0x5078, 0x9296, 0xcbc4, 0x092a,
            0x4b91, 0x897f, 0xcee7, 0x0c09, 0x4eb2, 0x8c5c, 0xc182, 0x036c, 0x41d7, 0x8339, 0xc4a1,
            0x064f, 0x44f4, 0x861a,
        ],
        [
            0x0000, 0x4d49, 0x9a92, 0xd7db, 0x30ad, 0x7de4, 0xaa3f, 0xe776, 0x615a, 0x2c13, 0xfbc8,
            0xb681, 0x51f7, 0x1cbe, 0xcb65, 0x862c, 0xc2b4, 0x8ffd, 0x5826, 0x156f, 0xf219, 0xbf50,
            0x688b, 0x25c2, 0xa3ee, 0xeea7, 0x397c, 0x7435, 0x9343, 0xde0a, 0x09d1, 0x4498, 0x80e1,
            0xcda8, 0x1a73, 0x573a, 0xb04c, 0xfd05, 0x2ade, 0x6797, 0xe1bb, 0xacf2, 0x7b29, 0x3660,
            0xd116, 0x9c5f, 0x4b84, 0x06cd, 0x4255, 0x0f1c, 0xd8c7, 0x958e, 0x72f8, 0x3fb1, 0xe86a,
            0xa523, 0x230f, 0x6e46, 0xb99d, 0xf4d4, 0x13a2, 0x5eeb, 0x8930, 0xc479, 0x044b, 0x4902,
            0x9ed9, 0xd390, 0x34e6, 0x79af, 0xae74, 0xe33d, 0x6511, 0x2858, 0xff83, 0xb2ca, 0x55bc,
            0x18f5, 0xcf2e, 0x8267, 0xc6ff, 0x8bb6, 0x5c6d, 0x1124, 0xf652, 0xbb1b, 0x6cc0, 0x2189,
            0xa7a5, 0xeaec, 0x3d37, 0x707e, 0x9708, 0xda41, 0x0d9a, 0x40d3, 0x84aa, 0xc9e3, 0x1e38,
            0x5371, 0xb407, 0xf94e, 0x2e95, 0x63dc, 0xe5f0, 0xa8b9, 0x7f62, 0x322b, 0xd55d, 0x9814,
            0x4fcf, 0x0286, 0x461e, 0x0b57, 0xdc8c, 0x91c5, 0x76b3, 0x3bfa, 0xec21, 0xa168, 0x2744,
            0x6a0d, 0xbdd6, 0xf09f, 0x17e9, 0x5aa0, 0x8d7b, 0xc032, 0x0896, 0x45df, 0x9204, 0xdf4d,
            0x383b, 0x7572, 0xa2a9, 0xefe0, 0x69cc, 0x2485, 0xf35e, 0xbe17, 0x5961, 0x1428, 0xc3f3,
            0x8eba, 0xca22, 0x876b, 0x50b0, 0x1df9, 0xfa8f, 0xb7c6, 0x601d, 0x2d54, 0xab78, 0xe631,
            0x31ea, 0x7ca3, 0x9bd5, 0xd69c, 0x0147, 0x4c0e, 0x8877, 0xc53e, 0x12e5, 0x5fac, 0xb8da,
            0xf593, 0x2248, 0x6f01, 0xe92d, 0xa464, 0x73bf, 0x3ef6, 0xd980, 0x94c9, 0x4312, 0x0e5b,
            0x4ac3, 0x078a, 0xd051, 0x9d18, 0x7a6e, 0x3727, 0xe0fc, 0xadb5, 0x2b99, 0x66d0, 0xb10b,
            0xfc42, 0x1b34, 0x567d, 0x81a6, 0xccef, 0x0cdd, 0x4194, 0x964f, 0xdb06, 0x3c70, 0x7139,
            0xa6e2, 0xebab, 0x6d87, 0x20ce, 0xf715, 0xba5c, 0x5d2a, 0x1063, 0xc7b8, 0x8af1, 0xce69,
            0x8320, 0x54fb, 0x19b2, 0xfec4, 0xb38d, 0x6456, 0x291f, 0xaf33, 0xe27a, 0x35a1, 0x78e8,
            0x9f9e, 0xd2d7, 0x050c, 0x4845, 0x8c3c, 0xc175, 0x16ae, 0x5be7, 0xbc91, 0xf1d8, 0x2603,
            0x6b4a, 0xed66, 0xa02f, 0x77f4, 0x3abd, 0xddcb, 0x9082, 0x4759, 0x0a10, 0x4e88, 0x03c1,
            0xd41a, 0x9953, 0x7e25, 0x336c, 0xe4b7, 0xa9fe, 0x2fd2, 0x629b, 0xb540, 0xf809, 0x1f7f,
            0x5236, 0x85ed, 0xc8a4,
        ],
        [
            0x0000, 0x112c, 0x2258, 0x3374, 0x44b0, 0x559c, 0x66e8, 0x77c4, 0x8960, 0x984c, 0xab38,
            0xba14, 0xcdd0, 0xdcfc, 0xef88, 0xfea4, 0x1749, 0x0665, 0x3511, 0x243d, 0x53f9, 0x42d5,
            0x71a1, 0x608d, 0x9e29, 0x8f05, 0xbc71, 0xad5d, 0xda99, 0xcbb5, 0xf8c1, 0xe9ed, 0x2e92,
            0x3fbe, 0x0cca, 0x1de6, 0x6a22, 0x7b0e, 0x487a, 0x5956, 0xa7f2, 0xb6de, 0x85aa, 0x9486,
            0xe342, 0xf26e, 0xc11a, 0xd036, 0x39db, 0x28f7, 0x1b83, 0x0aaf, 0x7d6b, 0x6c47, 0x5f33,
            0x4e1f, 0xb0bb, 0xa197, 0x92e3, 0x83cf, 0xf40b, 0xe527, 0xd653, 0xc77f, 0x5d24, 0x4c08,
            0x7f7c, 0x6e50, 0x1994, 0x08b8, 0x3bcc, 0x2ae0, 0xd444, 0xc568, 0xf61c, 0xe730, 0x90f4,
            0x81d8, 0xb2ac, 0xa380, 0x4a6d, 0x5b41, 0x6835, 0x7919, 0x0edd, 0x1ff1, 0x2c85, 0x3da9,
            0xc30d, 0xd221, 0xe155, 0xf079, 0x87bd, 0x9691, 0xa5e5, 0xb4c9, 0x73b6, 0x629a, 0x51ee,
            0x40c2, 0x3706, 0x262a, 0x155e, 0x0472, 0xfad6, 0xebfa, 0xd88e, 0xc9a2, 0xbe66, 0xaf4a,
            0x9c3e, 0x8d12, 0x64ff, 0x75d3, 0x46a7, 0x578b, 0x204f, 0x3163, 0x0217, 0x133b, 0xed9f,
            0xfcb3, 0xcfc7, 0xdeeb, 0xa92f, 0xb803, 0x8b77, 0x9a5b, 0xba48, 0xab64, 0x9810, 0x893c,
            0xfef8, 0xefd4, 0xdca0, 0xcd8c, 0x3328, 0x2204, 0x1170, 0x005c, 0x7798, 0x66b4, 0x55c0,
            0x44ec, 0xad01, 0xbc2d, 0x8f59, 0x9e75, 0xe9b1, 0xf89d, 0xcbe9, 0xdac5, 0x2461, 0x354d,
            0x0639, 0x1715, 0x60d1, 0x71fd, 0x4289, 0x53a5, 0x94da, 0x85f6, 0xb682, 0xa7ae, 0xd06a,
            0xc146, 0xf232, 0xe31e, 0x1dba, 0x0c96, 0x3fe2, 0x2ece, 0x590a, 0x4826, 0x7b52, 0x6a7e,
            0x8393, 0x92bf, 0xa1cb, 0xb0e7, 0xc723, 0xd60f, 0xe57b, 0xf457, 0x0af3, 0x1bdf, 0x28ab,
            0x3987, 0x4e43, 0x5f6f, 0x6c1b, 0x7d37, 0xe76c, 0xf640, 0xc534, 0xd418, 0xa3dc, 0xb2f0,
            0x8184, 0x90a8, 0x6e0c, 0x7f20, 0x4c54, 0x5d78, 0x2abc, 0x3b90, 0x08e4, 0x19c8, 0xf025,
            0xe109, 0xd27d, 0xc351, 0xb495, 0xa5b9, 0x96cd, 0x87e1, 0x7945, 0x6869, 0x5b1d, 0x4a31,
            0x3df5, 0x2cd9, 0x1fad, 0x0e81, 0xc9fe, 0xd8d2, 0xeba6, 0xfa8a, 0x8d4e, 0x9c62, 0xaf16,
            0xbe3a, 0x409e, 0x51b2, 0x62c6, 0x73ea, 0x042e, 0x1502, 0x2676, 0x375a, 0xdeb7, 0xcf9b,
            0xfcef, 0xedc3, 0x9a07, 0x8b2b, 0xb85f, 0xa973, 0x57d7, 0x46fb, 0x758f, 0x64a3, 0x1367,
            0x024b, 0x313f, 0x2013,
        ],
        [
            0x0000, 0x7119, 0xe232, 0x932b, 0xc1ed, 0xb0f4, 0x23df, 0x52c6, 0x8653, 0xf74a, 0x6461,
            0x1578, 0x47be, 0x36a7, 0xa58c, 0xd495, 0x092f, 0x7836, 0xeb1d, 0x9a04, 0xc8c2, 0xb9db,
            0x2af0, 0x5be9, 0x8f7c, 0xfe65, 0x6d4e, 0x1c57, 0x4e91, 0x3f88, 0xaca3, 0xddba, 0x125e,
            0x6347, 0xf06c, 0x8175, 0xd3b3, 0xa2aa, 0x3181, 0x4098, 0x940d, 0xe514, 0x763f, 0x0726,
            0x55e0, 0x24f9, 0xb7d2, 0xc6cb, 0x1b71, 0x6a68, 0xf943, 0x885a, 0xda9c, 0xab85, 0x38ae,
            0x49b7, 0x9d22, 0xec3b, 0x7f10, 0x0e09, 0x5ccf, 0x2dd6, 0xbefd, 0xcfe4, 0x24bc, 0x55a5,
            0xc68e, 0xb797, 0xe551, 0x9448, 0x0763, 0x767a, 0xa2ef, 0xd3f6, 0x40dd, 0x31c4, 0x6302,
            0x121b, 0x8130, 0xf029, 0x2d93, 0x5c8a, 0xcfa1, 0xbeb8, 0xec7e, 0x9d67, 0x0e4c, 0x7f55,
            0xabc0, 0xdad9, 0x49f2, 0x38eb, 0x6a2d, 0x1b34, 0x881f, 0xf906, 0x36e2, 0x47fb, 0xd4d0,
            0xa5c9, 0xf70f, 0x8616, 0x153d, 0x6424, 0xb0b1, 0xc1a8, 0x5283, 0x239a, 0x715c, 0x0045,
            0x936e, 0xe277, 0x3fcd, 0x4ed4, 0xddff, 0xace6, 0xfe20, 0x8f39, 0x1c12, 0x6d0b, 0xb99e,
            0xc887, 0x5bac, 0x2ab5, 0x7873, 0x096a, 0x9a41, 0xeb58, 0x4978, 0x3861, 0xab4a, 0xda53,
            0x8895, 0xf98c, 0x6aa7, 0x1bbe, 0xcf2b, 0xbe32, 0x2d19, 0x5c00, 0x0ec6, 0x7fdf, 0xecf4,
            0x9ded, 0x4057, 0x314e, 0xa265, 0xd37c, 0x81ba, 0xf0a3, 0x6388, 0x1291, 0xc604, 0xb71d,
            0x2436, 0x552f, 0x07e9, 0x76f0, 0xe5db, 0x94c2, 0x5b26, 0x2a3f, 0xb914, 0xc80d, 0x9acb,
            0xebd2, 0x78f9, 0x09e0, 0xdd75, 0xac6c, 0x3f47, 0x4e5e, 0x1c98, 0x6d81, 0xfeaa, 0x8fb3,
            0x5209, 0x2310, 0xb03b, 0xc122, 0x93e4, 0xe2fd, 0x71d6, 0x00cf, 0xd45a, 0xa543, 0x3668,
            0x4771, 0x15b7, 0x64ae, 0xf785, 0x869c, 0x6dc4, 0x1cdd, 0x8ff6, 0xfeef, 0xac29, 0xdd30,
            0x4e1b, 0x3f02, 0xeb97, 0x9a8e, 0x09a5, 0x78bc, 0x2a7a, 0x5b63, 0xc848, 0xb951, 0x64eb,
            0x15f2, 0x86d9, 0xf7c0, 0xa506, 0xd41f, 0x4734, 0x362d, 0xe2b8, 0x93a1, 0x008a, 0x7193,
            0x2355, 0x524c, 0xc167, 0xb07e, 0x7f9a, 0x0e83, 0x9da8, 0xecb1, 0xbe77, 0xcf6e, 0x5c45,
            0x2d5c, 0xf9c9, 0x88d0, 0x1bfb, 0x6ae2, 0x3824, 0x493d, 0xda16, 0xab0f, 0x76b5, 0x07ac,
            0x9487, 0xe59e, 0xb758, 0xc641, 0x556a, 0x2473, 0xf0e6, 0x81ff, 0x12d4, 0x63cd, 0x310b,
            0x4012, 0xd339, 0xa220,
        ],
        [
            0x0000, 0x92f0, 0x2069, 0xb299, 0x40d2, 0xd222, 0x60bb, 0xf24b, 0x81a4, 0x1354, 0xa1cd,
            0x333d, 0xc176, 0x5386, 0xe11f, 0x73ef, 0x06c1, 0x9431, 0x26a8, 0xb458, 0x4613, 0xd4e3,
            0x667a, 0xf48a, 0x8765, 0x1595, 0xa70c, 0x35fc, 0xc7b7, 0x5547, 0xe7de, 0x752e, 0x0d82,
            0x9f72, 0x2deb, 0xbf1b, 0x4d50, 0xdfa0, 0x6d39, 0xffc9, 0x8c26, 0x1ed6, 0xac4f, 0x3ebf,
            0xccf4, 0x5e04, 0xec9d, 0x7e6d, 0x0b43, 0x99b3, 0x2b2a, 0xb9da, 0x4b91, 0xd961, 0x6bf8,
            0xf908, 0x8ae7, 0x1817, 0xaa8e, 0x387e, 0xca35, 0x58c5, 0xea5c, 0x78ac, 0x1b04, 0x89f4,
            0x3b6d, 0xa99d, 0x5bd6, 0xc926, 0x7bbf, 0xe94f, 0x9aa0, 0x0850, 0xbac9, 0x2839, 0xda72,
            0x4882, 0xfa1b, 0x68eb, 0x1dc5, 0x8f35, 0x3dac, 0xaf5c, 0x5d17, 0xcfe7, 0x7d7e, 0xef8e,
            0x9c61, 0x0e91, 0xbc08, 0x2ef8, 0xdcb3, 0x4e43, 0xfcda, 0x6e2a, 0x1686, 0x8476, 0x36ef,
            0xa41f, 0x5654, 0xc4a4, 0x763d, 0xe4cd, 0x9722, 0x05d2, 0xb74b, 0x25bb, 0xd7f0, 0x4500,
            0xf799, 0x6569, 0x1047, 0x82b7, 0x302e, 0xa2de, 0x5095, 0xc265, 0x70fc, 0xe20c, 0x91e3,
            0x0313, 0xb18a, 0x237a, 0xd131, 0x43c1, 0xf158, 0x63a8, 0x3608, 0xa4f8, 0x1661, 0x8491,
            0x76da, 0xe42a, 0x56b3, 0xc443, 0xb7ac, 0x255c, 0x97c5, 0x0535, 0xf77e, 0x658e, 0xd717,
            0x45e7, 0x30c9, 0xa239, 0x10a0, 0x8250, 0x701b, 0xe2eb, 0x5072, 0xc282, 0xb16d, 0x239d,
            0x9104, 0x03f4, 0xf1bf, 0x634f, 0xd1d6, 0x4326, 0x3b8a, 0xa97a, 0x1be3, 0x8913, 0x7b58,
            0xe9a8, 0x5b31, 0xc9c1, 0xba2e, 0x28de, 0x9a47, 0x08b7, 0xfafc, 0x680c, 0xda95, 0x4865,
            0x3d4b, 0xafbb, 0x1d22, 0x8fd2, 0x7d99, 0xef69, 0x5df0, 0xcf00, 0xbcef, 0x2e1f, 0x9c86,
            0x0e76, 0xfc3d, 0x6ecd, 0xdc54, 0x4ea4, 0x2d0c, 0xbffc, 0x0d65, 0x9f95, 0x6dde, 0xff2e,
            0x4db7, 0xdf47, 0xaca8, 0x3e58, 0x8cc1, 0x1e31, 0xec7a, 0x7e8a, 0xcc13, 0x5ee3, 0x2bcd,
            0xb93d, 0x0ba4, 0x9954, 0x6b1f, 0xf9ef, 0x4b76, 0xd986, 0xaa69, 0x3899, 0x8a00, 0x18f0,
            0xeabb, 0x784b, 0xcad2, 0x5822, 0x208e, 0xb27e, 0x00e7, 0x9217, 0x605c, 0xf2ac, 0x4035,
            0xd2c5, 0xa12a, 0x33da, 0x8143, 0x13b3, 0xe1f8, 0x7308, 0xc191, 0x5361, 0x264f, 0xb4bf,
            0x0626, 0x94d6, 0x669d, 0xf46d, 0x46f4, 0xd404, 0xa7eb, 0x351b, 0x8782, 0x1572, 0xe739,
            0x75c9, 0xc750, 0x55a0,
        ],
        [
            0x0000, 0x6c10, 0xd820, 0xb430, 0xb5c9, 0xd9d9, 0x6de9, 0x01f9, 0x6e1b, 0x020b, 0xb63b,
            0xda2b, 0xdbd2, 0xb7c2, 0x03f2, 0x6fe2, 0xdc36, 0xb026, 0x0416, 0x6806, 0x69ff, 0x05ef,
            0xb1df, 0xddcf, 0xb22d, 0xde3d, 0x6a0d, 0x061d, 0x07e4, 0x6bf4, 0xdfc4, 0xb3d4, 0xbde5,
            0xd1f5, 0x65c5, 0x09d5, 0x082c, 0x643c, 0xd00c, 0xbc1c, 0xd3fe, 0xbfee, 0x0bde, 0x67ce,
            0x6637, 0x0a27, 0xbe17, 0xd207, 0x61d3, 0x0dc3, 0xb9f3, 0xd5e3, 0xd41a, 0xb80a, 0x0c3a,
            0x602a, 0x0fc8, 0x63d8, 0xd7e8, 0xbbf8, 0xba01, 0xd611, 0x6221, 0x0e31, 0x7e43, 0x1253,
            0xa663, 0xca73, 0xcb8a, 0xa79a, 0x13aa, 0x7fba, 0x1058, 0x7c48, 0xc878, 0xa468, 0xa591,
            0xc981, 0x7db1, 0x11a1, 0xa275, 0xce65, 0x7a55, 0x1645, 0x17bc, 0x7bac, 0xcf9c, 0xa38c,
            0xcc6e, 0xa07e, 0x144e, 0x785e, 0x79a7, 0x15b7, 0xa187, 0xcd97, 0xc3a6, 0xafb6, 0x1b86,
            0x7796, 0x766f, 0x1a7f, 0xae4f, 0xc25f, 0xadbd, 0xc1ad, 0x759d, 0x198d, 0x1874, 0x7464,
            0xc054, 0xac44, 0x1f90, 0x7380, 0xc7b0, 0xaba0, 0xaa59, 0xc649, 0x7279, 0x1e69, 0x718b,
            0x1d9b, 0xa9ab, 0xc5bb, 0xc442, 0xa852, 0x1c62, 0x7072, 0xfc86, 0x9096, 0x24a6, 0x48b6,
            0x494f, 0x255f, 0x916f, 0xfd7f, 0x929d, 0xfe8d, 0x4abd, 0x26ad, 0x2754, 0x4b44, 0xff74,
            0x9364, 0x20b0, 0x4ca0, 0xf890, 0x9480, 0x9579, 0xf969, 0x4d59, 0x2149, 0x4eab, 0x22bb,
            0x968b, 0xfa9b, 0xfb62, 0x9772, 0x2342, 0x4f52, 0x4163, 0x2d73, 0x9943, 0xf553, 0xf4aa,
            0x98ba, 0x2c8a, 0x409a, 0x2f78, 0x4368, 0xf758, 0x9b48, 0x9ab1, 0xf6a1, 0x4291, 0x2e81,
            0x9d55, 0xf145, 0x4575, 0x2965, 0x289c, 0x448c, 0xf0bc, 0x9cac, 0xf34e, 0x9f5e, 0x2b6e,
            0x477e, 0x4687, 0x2a97, 0x9ea7, 0xf2b7, 0x82c5, 0xeed5, 0x5ae5, 0x36f5, 0x370c, 0x5b1c,
            0xef2c, 0x833c, 0xecde, 0x80ce, 0x34fe, 0x58ee, 0x5917, 0x3507, 0x8137, 0xed27, 0x5ef3,
            0x32e3, 0x86d3, 0xeac3, 0xeb3a, 0x872a, 0x331a, 0x5f0a, 0x30e8, 0x5cf8, 0xe8c8, 0x84d8,
            0x8521, 0xe931, 0x5d01, 0x3111, 0x3f20, 0x5330, 0xe700, 0x8b10, 0x8ae9, 0xe6f9, 0x52c9,
            0x3ed9, 0x513b, 0x3d2b, 0x891b, 0xe50b, 0xe4f2, 0x88e2, 0x3cd2, 0x50c2, 0xe316, 0x8f06,
            0x3b36, 0x5726, 0x56df, 0x3acf, 0x8eff, 0xe2ef, 0x8d0d, 0xe11d, 0x552d, 0x393d, 0x38c4,
            0x54d4, 0xe0e4, 0x8cf4,
        ],
        [
            0x0000, 0xfc85, 0xfc83, 0x0006, 0xfc8f, 0x000a, 0x000c, 0xfc89, 0xfc97, 0x0012, 0x0014,
            0xfc91, 0x0018, 0xfc9d, 0xfc9b, 0x001e, 0xfca7, 0x0022, 0x0024, 0xfca1, 0x0028, 0xfcad,
            0xfcab, 0x002e, 0x0030, 0xfcb5, 0xfcb3, 0x0036, 0xfcbf, 0x003a, 0x003c, 0xfcb9, 0xfcc7,
            0x0042, 0x0044, 0xfcc1, 0x0048, 0xfccd, 0xfccb, 0x004e, 0x0050, 0xfcd5, 0xfcd3, 0x0056,
            0xfcdf, 0x005a, 0x005c, 0xfcd9, 0x0060, 0xfce5, 0xfce3, 0x0066, 0xfcef, 0x006a, 0x006c,
            0xfce9, 0xfcf7, 0x0072, 0x0074, 0xfcf1, 0x0078, 0xfcfd, 0xfcfb, 0x007e, 0xfc07, 0x0082,
            0x0084, 0xfc01, 0x0088, 0xfc0d, 0xfc0b, 0x008e, 0x0090, 0xfc15, 0xfc13, 0x0096, 0xfc1f,
            0x009a, 0x009c, 0xfc19, 0x00a0, 0xfc25, 0xfc23, 0x00a6, 0xfc2f, 0x00aa, 0x00ac, 0xfc29,
            0xfc37, 0x00b2, 0x00b4, 0xfc31, 0x00b8, 0xfc3d, 0xfc3b, 0x00be, 0x00c0, 0xfc45, 0xfc43,
            0x00c6, 0xfc4f, 0x00ca, 0x00cc, 0xfc49, 0xfc57, 0x00d2, 0x00d4, 0xfc51, 0x00d8, 0xfc5d,
            0xfc5b, 0x00de, 0xfc67, 0x00e2, 0x00e4, 0xfc61, 0x00e8, 0xfc6d, 0xfc6b, 0x00ee, 0x00f0,
            0xfc75, 0xfc73, 0x00f6, 0xfc7f, 0x00fa, 0x00fc, 0xfc79, 0xfd87, 0x0102, 0x0104, 0xfd81,
            0x0108, 0xfd8d, 0xfd8b, 0x010e, 0x0110, 0xfd95, 0xfd93, 0x0116, 0xfd9f, 0x011a, 0x011c,
            0xfd99, 0x0120, 0xfda5, 0xfda3, 0x0126, 0xfdaf, 0x012a, 0x012c, 0xfda9, 0xfdb7, 0x0132,
            0x0134, 0xfdb1, 0x0138, 0xfdbd, 0xfdbb, 0x013e, 0x0140, 0xfdc5, 0xfdc3, 0x0146, 0xfdcf,
            0x014a, 0x014c, 0xfdc9, 0xfdd7, 0x0152, 0x0154, 0xfdd1, 0x0158, 0xfddd, 0xfddb, 0x015e,
            0xfde7, 0x0162, 0x0164, 0xfde1, 0x0168, 0xfded, 0xfdeb, 0x016e, 0x0170, 0xfdf5, 0xfdf3,
            0x0176, 0xfdff, 0x017a, 0x017c, 0xfdf9, 0x0180, 0xfd05, 0xfd03, 0x0186, 0xfd0f, 0x018a,
            0x018c, 0xfd09, 0xfd17, 0x0192, 0x0194, 0xfd11, 0x0198, 0xfd1d, 0xfd1b, 0x019e, 0xfd27,
            0x01a2, 0x01a4, 0xfd21, 0x01a8, 0xfd2d, 0xfd2b, 0x01ae, 0x01b0, 0xfd35, 0xfd33, 0x01b6,
            0xfd3f, 0x01ba, 0x01bc, 0xfd39, 0xfd47, 0x01c2, 0x01c4, 0xfd41, 0x01c8, 0xfd4d, 0xfd4b,
            0x01ce, 0x01d0, 0xfd55, 0xfd53, 0x01d6, 0xfd5f, 0x01da, 0x01dc, 0xfd59, 0x01e0, 0xfd65,
            0xfd63, 0x01e6, 0xfd6f, 0x01ea, 0x01ec, 0xfd69, 0xfd77, 0x01f2, 0x01f4, 0xfd71, 0x01f8,
            0xfd7d, 0xfd7b, 0x01fe,
        ],
        [
            0x0000, 0xfe87, 0xf887, 0x0600, 0xf487, 0x0a00, 0x0c00, 0xf287, 0xec87, 0x1200, 0x1400,
            0xea87, 0x1800, 0xe687, 0xe087, 0x1e00, 0xdc87, 0x2200, 0x2400, 0xda87, 0x2800, 0xd687,
            0xd087, 0x2e00, 0x3000, 0xce87, 0xc887, 0x3600, 0xc487, 0x3a00, 0x3c00, 0xc287, 0xbc87,
            0x4200, 0x4400, 0xba87, 0x4800, 0xb687, 0xb087, 0x4e00, 0x5000, 0xae87, 0xa887, 0x5600,
            0xa487, 0x5a00, 0x5c00, 0xa287, 0x6000, 0x9e87, 0x9887, 0x6600, 0x9487, 0x6a00, 0x6c00,
            0x9287, 0x8c87, 0x7200, 0x7400, 0x8a87, 0x7800, 0x8687, 0x8087, 0x7e00, 0x7c87, 0x8200,
            0x8400, 0x7a87, 0x8800, 0x7687, 0x7087, 0x8e00, 0x9000, 0x6e87, 0x6887, 0x9600, 0x6487,
            0x9a00, 0x9c00, 0x6287, 0xa000, 0x5e87, 0x5887, 0xa600, 0x5487, 0xaa00, 0xac00, 0x5287,
            0x4c87, 0xb200, 0xb400, 0x4a87, 0xb800, 0x4687, 0x4087, 0xbe00, 0xc000, 0x3e87, 0x3887,
            0xc600, 0x3487, 0xca00, 0xcc00, 0x3287, 0x2c87, 0xd200, 0xd400, 0x2a87, 0xd800, 0x2687,
            0x2087, 0xde00, 0x1c87, 0xe200, 0xe400, 0x1a87, 0xe800, 0x1687, 0x1087, 0xee00, 0xf000,
            0x0e87, 0x0887, 0xf600, 0x0487, 0xfa00, 0xfc00, 0x0287, 0xf90e, 0x0789, 0x0189, 0xff0e,
            0x0d89, 0xf30e, 0xf50e, 0x0b89, 0x1589, 0xeb0e, 0xed0e, 0x1389, 0xe10e, 0x1f89, 0x1989,
            0xe70e, 0x2589, 0xdb0e, 0xdd0e, 0x2389, 0xd10e, 0x2f89, 0x2989, 0xd70e, 0xc90e, 0x3789,
            0x3189, 0xcf0e, 0x3d89, 0xc30e, 0xc50e, 0x3b89, 0x4589, 0xbb0e, 0xbd0e, 0x4389, 0xb10e,
            0x4f89, 0x4989, 0xb70e, 0xa90e, 0x5789, 0x5189, 0xaf0e, 0x5d89, 0xa30e, 0xa50e, 0x5b89,
            0x990e, 0x6789, 0x6189, 0x9f0e, 0x6d89, 0x930e, 0x950e, 0x6b89, 0x7589, 0x8b0e, 0x8d0e,
            0x7389, 0x810e, 0x7f89, 0x7989, 0x870e, 0x8589, 0x7b0e, 0x7d0e, 0x8389, 0x710e, 0x8f89,
            0x8989, 0x770e, 0x690e, 0x9789, 0x9189, 0x6f0e, 0x9d89, 0x630e, 0x650e, 0x9b89, 0x590e,
            0xa789, 0xa189, 0x5f0e, 0xad89, 0x530e, 0x550e, 0xab89, 0xb589, 0x4b0e, 0x4d0e, 0xb389,
            0x410e, 0xbf89, 0xb989, 0x470e, 0x390e, 0xc789, 0xc189, 0x3f0e, 0xcd89, 0x330e, 0x350e,
            0xcb89, 0xd589, 0x2b0e, 0x2d0e, 0xd389, 0x210e, 0xdf89, 0xd989, 0x270e, 0xe589, 0x1b0e,
            0x1d0e, 0xe389, 0x110e, 0xef89, 0xe989, 0x170e, 0x090e, 0xf789, 0xf189, 0x0f0e, 0xfd89,
            0x030e, 0x050e, 0xfb89,
        ],
    ];

    pub static CRC16_DECT_X_TABLE: [[u16; 256]; 16] = [
        [
            0x0000, 0x0589, 0x0b12, 0x0e9b, 0x1624, 0x13ad, 0x1d36, 0x18bf, 0x2c48, 0x29c1, 0x275a,
            0x22d3, 0x3a6c, 0x3fe5, 0x317e, 0x34f7, 0x5890, 0x5d19, 0x5382, 0x560b, 0x4eb4, 0x4b3d,
            0x45a6, 0x402f, 0x74d8, 0x7151, 0x7fca, 0x7a43, 0x62fc, 0x6775, 0x69ee, 0x6c67, 0xb120,
            0xb4a9, 0xba32, 0xbfbb, 0xa704, 0xa28d, 0xac16, 0xa99f, 0x9d68, 0x98e1, 0x967a, 0x93f3,
            0x8b4c, 0x8ec5, 0x805e, 0x85d7, 0xe9b0, 0xec39, 0xe2a2, 0xe72b, 0xff94, 0xfa1d, 0xf486,
            0xf10f, 0xc5f8, 0xc071, 0xceea, 0xcb63, 0xd3dc, 0xd655, 0xd8ce, 0xdd47, 0x67c9, 0x6240,
            0x6cdb, 0x6952, 0x71ed, 0x7464, 0x7aff, 0x7f76, 0x4b81, 0x4e08, 0x4093, 0x451a, 0x5da5,
            0x582c, 0x56b7, 0x533e, 0x3f59, 0x3ad0, 0x344b, 0x31c2, 0x297d, 0x2cf4, 0x226f, 0x27e6,
            0x1311, 0x1698, 0x1803, 0x1d8a, 0x0535, 0x00bc, 0x0e27, 0x0bae, 0xd6e9, 0xd360, 0xddfb,
            0xd872, 0xc0cd, 0xc544, 0xcbdf, 0xce56, 0xfaa1, 0xff28, 0xf1b3, 0xf43a, 0xec85, 0xe90c,
            0xe797, 0xe21e, 0x8e79, 0x8bf0, 0x856b, 0x80e2, 0x985d, 0x9dd4, 0x934f, 0x96c6, 0xa231,
            0xa7b8, 0xa923, 0xacaa, 0xb415, 0xb19c, 0xbf07, 0xba8e, 0xcf92, 0xca1b, 0xc480, 0xc109,
            0xd9b6, 0xdc3f, 0xd2a4, 0xd72d, 0xe3da, 0xe653, 0xe8c8, 0xed41, 0xf5fe, 0xf077, 0xfeec,
            0xfb65, 0x9702, 0x928b, 0x9c10, 0x9999, 0x8126, 0x84af, 0x8a34, 0x8fbd, 0xbb4a, 0xbec3,
            0xb058, 0xb5d1, 0xad6e, 0xa8e7, 0xa67c, 0xa3f5, 0x7eb2, 0x7b3b, 0x75a0, 0x7029, 0x6896,
            0x6d1f, 0x6384, 0x660d, 0x52fa, 0x5773, 0x59e8, 0x5c61, 0x44de, 0x4157, 0x4fcc, 0x4a45,
            0x2622, 0x23ab, 0x2d30, 0x28b9, 0x3006, 0x358f, 0x3b14, 0x3e9d, 0x0a6a, 0x0fe3, 0x0178,
            0x04f1, 0x1c4e, 0x19c7, 0x175c, 0x12d5, 0xa85b, 0xadd2, 0xa349, 0xa6c0, 0xbe7f, 0xbbf6,
            0xb56d, 0xb0e4, 0x8413, 0x819a, 0x8f01, 0x8a88, 0x9237, 0x97be, 0x9925, 0x9cac, 0xf0cb,
            0xf542, 0xfbd9, 0xfe50, 0xe6ef, 0xe366, 0xedfd, 0xe874, 0xdc83, 0xd90a, 0xd791, 0xd218,
            0xcaa7, 0xcf2e, 0xc1b5, 0xc43c, 0x197b, 0x1cf2, 0x1269, 0x17e0, 0x0f5f, 0x0ad6, 0x044d,
            0x01c4, 0x3533, 0x30ba, 0x3e21, 0x3ba8, 0x2317, 0x269e, 0x2805, 0x2d8c, 0x41eb, 0x4462,
            0x4af9, 0x4f70, 0x57cf, 0x5246, 0x5cdd, 0x5954, 0x6da3, 0x682a, 0x66b1, 0x6338, 0x7b87,
            0x7e0e, 0x7095, 0x751c,
        ],
        [
            0x0000, 0x9aad, 0x30d3, 0xaa7e, 0x61a6, 0xfb0b, 0x5175, 0xcbd8, 0xc34c, 0x59e1, 0xf39f,
            0x6932, 0xa2ea, 0x3847, 0x9239, 0x0894, 0x8311, 0x19bc, 0xb3c2, 0x296f, 0xe2b7, 0x781a,
            0xd264, 0x48c9, 0x405d, 0xdaf0, 0x708e, 0xea23, 0x21fb, 0xbb56, 0x1128, 0x8b85, 0x03ab,
            0x9906, 0x3378, 0xa9d5, 0x620d, 0xf8a0, 0x52de, 0xc873, 0xc0e7, 0x5a4a, 0xf034, 0x6a99,
            0xa141, 0x3bec, 0x9192, 0x0b3f, 0x80ba, 0x1a17, 0xb069, 0x2ac4, 0xe11c, 0x7bb1, 0xd1cf,
            0x4b62, 0x43f6, 0xd95b, 0x7325, 0xe988, 0x2250, 0xb8fd, 0x1283, 0x882e, 0x0756, 0x9dfb,
            0x3785, 0xad28, 0x66f0, 0xfc5d, 0x5623, 0xcc8e, 0xc41a, 0x5eb7, 0xf4c9, 0x6e64, 0xa5bc,
            0x3f11, 0x956f, 0x0fc2, 0x8447, 0x1eea, 0xb494, 0x2e39, 0xe5e1, 0x7f4c, 0xd532, 0x4f9f,
            0x470b, 0xdda6, 0x77d8, 0xed75, 0x26ad, 0xbc00, 0x167e, 0x8cd3, 0x04fd, 0x9e50, 0x342e,
            0xae83, 0x655b, 0xfff6, 0x5588, 0xcf25, 0xc7b1, 0x5d1c, 0xf762, 0x6dcf, 0xa617, 0x3cba,
            0x96c4, 0x0c69, 0x87ec, 0x1d41, 0xb73f, 0x2d92, 0xe64a, 0x7ce7, 0xd699, 0x4c34, 0x44a0,
            0xde0d, 0x7473, 0xeede, 0x2506, 0xbfab, 0x15d5, 0x8f78, 0x0eac, 0x9401, 0x3e7f, 0xa4d2,
            0x6f0a, 0xf5a7, 0x5fd9, 0xc574, 0xcde0, 0x574d, 0xfd33, 0x679e, 0xac46, 0x36eb, 0x9c95,
            0x0638, 0x8dbd, 0x1710, 0xbd6e, 0x27c3, 0xec1b, 0x76b6, 0xdcc8, 0x4665, 0x4ef1, 0xd45c,
            0x7e22, 0xe48f, 0x2f57, 0xb5fa, 0x1f84, 0x8529, 0x0d07, 0x97aa, 0x3dd4, 0xa779, 0x6ca1,
            0xf60c, 0x5c72, 0xc6df, 0xce4b, 0x54e6, 0xfe98, 0x6435, 0xafed, 0x3540, 0x9f3e, 0x0593,
            0x8e16, 0x14bb, 0xbec5, 0x2468, 0xefb0, 0x751d, 0xdf63, 0x45ce, 0x4d5a, 0xd7f7, 0x7d89,
            0xe724, 0x2cfc, 0xb651, 0x1c2f, 0x8682, 0x09fa, 0x9357, 0x3929, 0xa384, 0x685c, 0xf2f1,
            0x588f, 0xc222, 0xcab6, 0x501b, 0xfa65, 0x60c8, 0xab10, 0x31bd, 0x9bc3, 0x016e, 0x8aeb,
            0x1046, 0xba38, 0x2095, 0xeb4d, 0x71e0, 0xdb9e, 0x4133, 0x49a7, 0xd30a, 0x7974, 0xe3d9,
            0x2801, 0xb2ac, 0x18d2, 0x827f, 0x0a51, 0x90fc, 0x3a82, 0xa02f, 0x6bf7, 0xf15a, 0x5b24,
            0xc189, 0xc91d, 0x53b0, 0xf9ce, 0x6363, 0xa8bb, 0x3216, 0x9868, 0x02c5, 0x8940, 0x13ed,
            0xb993, 0x233e, 0xe8e6, 0x724b, 0xd835, 0x4298, 0x4a0c, 0xd0a1, 0x7adf, 0xe072, 0x2baa,
            0xb107, 0x1b79, 0x81d4,
        ],
        [
            0x0000, 0x1d58, 0x3ab0, 0x27e8, 0x7560, 0x6838, 0x4fd0, 0x5288, 0xeac0, 0xf798, 0xd070,
            0xcd28, 0x9fa0, 0x82f8, 0xa510, 0xb848, 0xd009, 0xcd51, 0xeab9, 0xf7e1, 0xa569, 0xb831,
            0x9fd9, 0x8281, 0x3ac9, 0x2791, 0x0079, 0x1d21, 0x4fa9, 0x52f1, 0x7519, 0x6841, 0xa59b,
            0xb8c3, 0x9f2b, 0x8273, 0xd0fb, 0xcda3, 0xea4b, 0xf713, 0x4f5b, 0x5203, 0x75eb, 0x68b3,
            0x3a3b, 0x2763, 0x008b, 0x1dd3, 0x7592, 0x68ca, 0x4f22, 0x527a, 0x00f2, 0x1daa, 0x3a42,
            0x271a, 0x9f52, 0x820a, 0xa5e2, 0xb8ba, 0xea32, 0xf76a, 0xd082, 0xcdda, 0x4ebf, 0x53e7,
            0x740f, 0x6957, 0x3bdf, 0x2687, 0x016f, 0x1c37, 0xa47f, 0xb927, 0x9ecf, 0x8397, 0xd11f,
            0xcc47, 0xebaf, 0xf6f7, 0x9eb6, 0x83ee, 0xa406, 0xb95e, 0xebd6, 0xf68e, 0xd166, 0xcc3e,
            0x7476, 0x692e, 0x4ec6, 0x539e, 0x0116, 0x1c4e, 0x3ba6, 0x26fe, 0xeb24, 0xf67c, 0xd194,
            0xcccc, 0x9e44, 0x831c, 0xa4f4, 0xb9ac, 0x01e4, 0x1cbc, 0x3b54, 0x260c, 0x7484, 0x69dc,
            0x4e34, 0x536c, 0x3b2d, 0x2675, 0x019d, 0x1cc5, 0x4e4d, 0x5315, 0x74fd, 0x69a5, 0xd1ed,
            0xccb5, 0xeb5d, 0xf605, 0xa48d, 0xb9d5, 0x9e3d, 0x8365, 0x9d7e, 0x8026, 0xa7ce, 0xba96,
            0xe81e, 0xf546, 0xd2ae, 0xcff6, 0x77be, 0x6ae6, 0x4d0e, 0x5056, 0x02de, 0x1f86, 0x386e,
            0x2536, 0x4d77, 0x502f, 0x77c7, 0x6a9f, 0x3817, 0x254f, 0x02a7, 0x1fff, 0xa7b7, 0xbaef,
            0x9d07, 0x805f, 0xd2d7, 0xcf8f, 0xe867, 0xf53f, 0x38e5, 0x25bd, 0x0255, 0x1f0d, 0x4d85,
            0x50dd, 0x7735, 0x6a6d, 0xd225, 0xcf7d, 0xe895, 0xf5cd, 0xa745, 0xba1d, 0x9df5, 0x80ad,
            0xe8ec, 0xf5b4, 0xd25c, 0xcf04, 0x9d8c, 0x80d4, 0xa73c, 0xba64, 0x022c, 0x1f74, 0x389c,
            0x25c4, 0x774c, 0x6a14, 0x4dfc, 0x50a4, 0xd3c1, 0xce99, 0xe971, 0xf429, 0xa6a1, 0xbbf9,
            0x9c11, 0x8149, 0x3901, 0x2459, 0x03b1, 0x1ee9, 0x4c61, 0x5139, 0x76d1, 0x6b89, 0x03c8,
            0x1e90, 0x3978, 0x2420, 0x76a8, 0x6bf0, 0x4c18, 0x5140, 0xe908, 0xf450, 0xd3b8, 0xcee0,
            0x9c68, 0x8130, 0xa6d8, 0xbb80, 0x765a, 0x6b02, 0x4cea, 0x51b2, 0x033a, 0x1e62, 0x398a,
            0x24d2, 0x9c9a, 0x81c2, 0xa62a, 0xbb72, 0xe9fa, 0xf4a2, 0xd34a, 0xce12, 0xa653, 0xbb0b,
            0x9ce3, 0x81bb, 0xd333, 0xce6b, 0xe983, 0xf4db, 0x4c93, 0x51cb, 0x7623, 0x6b7b, 0x39f3,
            0x24ab, 0x0343, 0x1e1b,
        ],
        [
            0x0000, 0x3f75, 0x7eea, 0x419f, 0xfdd4, 0xc2a1, 0x833e, 0xbc4b, 0xfe21, 0xc154, 0x80cb,
            0xbfbe, 0x03f5, 0x3c80, 0x7d1f, 0x426a, 0xf9cb, 0xc6be, 0x8721, 0xb854, 0x041f, 0x3b6a,
            0x7af5, 0x4580, 0x07ea, 0x389f, 0x7900, 0x4675, 0xfa3e, 0xc54b, 0x84d4, 0xbba1, 0xf61f,
            0xc96a, 0x88f5, 0xb780, 0x0bcb, 0x34be, 0x7521, 0x4a54, 0x083e, 0x374b, 0x76d4, 0x49a1,
            0xf5ea, 0xca9f, 0x8b00, 0xb475, 0x0fd4, 0x30a1, 0x713e, 0x4e4b, 0xf200, 0xcd75, 0x8cea,
            0xb39f, 0xf1f5, 0xce80, 0x8f1f, 0xb06a, 0x0c21, 0x3354, 0x72cb, 0x4dbe, 0xe9b7, 0xd6c2,
            0x975d, 0xa828, 0x1463, 0x2b16, 0x6a89, 0x55fc, 0x1796, 0x28e3, 0x697c, 0x5609, 0xea42,
            0xd537, 0x94a8, 0xabdd, 0x107c, 0x2f09, 0x6e96, 0x51e3, 0xeda8, 0xd2dd, 0x9342, 0xac37,
            0xee5d, 0xd128, 0x90b7, 0xafc2, 0x1389, 0x2cfc, 0x6d63, 0x5216, 0x1fa8, 0x20dd, 0x6142,
            0x5e37, 0xe27c, 0xdd09, 0x9c96, 0xa3e3, 0xe189, 0xdefc, 0x9f63, 0xa016, 0x1c5d, 0x2328,
            0x62b7, 0x5dc2, 0xe663, 0xd916, 0x9889, 0xa7fc, 0x1bb7, 0x24c2, 0x655d, 0x5a28, 0x1842,
            0x2737, 0x66a8, 0x59dd, 0xe596, 0xdae3, 0x9b7c, 0xa409, 0xd6e7, 0xe992, 0xa80d, 0x9778,
            0x2b33, 0x1446, 0x55d9, 0x6aac, 0x28c6, 0x17b3, 0x562c, 0x6959, 0xd512, 0xea67, 0xabf8,
            0x948d, 0x2f2c, 0x1059, 0x51c6, 0x6eb3, 0xd2f8, 0xed8d, 0xac12, 0x9367, 0xd10d, 0xee78,
            0xafe7, 0x9092, 0x2cd9, 0x13ac, 0x5233, 0x6d46, 0x20f8, 0x1f8d, 0x5e12, 0x6167, 0xdd2c,
            0xe259, 0xa3c6, 0x9cb3, 0xded9, 0xe1ac, 0xa033, 0x9f46, 0x230d, 0x1c78, 0x5de7, 0x6292,
            0xd933, 0xe646, 0xa7d9, 0x98ac, 0x24e7, 0x1b92, 0x5a0d, 0x6578, 0x2712, 0x1867, 0x59f8,
            0x668d, 0xdac6, 0xe5b3, 0xa42c, 0x9b59, 0x3f50, 0x0025, 0x41ba, 0x7ecf, 0xc284, 0xfdf1,
            0xbc6e, 0x831b, 0xc171, 0xfe04, 0xbf9b, 0x80ee, 0x3ca5, 0x03d0, 0x424f, 0x7d3a, 0xc69b,
            0xf9ee, 0xb871, 0x8704, 0x3b4f, 0x043a, 0x45a5, 0x7ad0, 0x38ba, 0x07cf, 0x4650, 0x7925,
            0xc56e, 0xfa1b, 0xbb84, 0x84f1, 0xc94f, 0xf63a, 0xb7a5, 0x88d0, 0x349b, 0x0bee, 0x4a71,
            0x7504, 0x376e, 0x081b, 0x4984, 0x76f1, 0xcaba, 0xf5cf, 0xb450, 0x8b25, 0x3084, 0x0ff1,
            0x4e6e, 0x711b, 0xcd50, 0xf225, 0xb3ba, 0x8ccf, 0xcea5, 0xf1d0, 0xb04f, 0x8f3a, 0x3371,
            0x0c04, 0x4d9b, 0x72ee,
        ],
        [
            0x0000, 0xa847, 0x5507, 0xfd40, 0xaa0e, 0x0249, 0xff09, 0x574e, 0x5195, 0xf9d2, 0x0492,
            0xacd5, 0xfb9b, 0x53dc, 0xae9c, 0x06db, 0xa32a, 0x0b6d, 0xf62d, 0x5e6a, 0x0924, 0xa163,
            0x5c23, 0xf464, 0xf2bf, 0x5af8, 0xa7b8, 0x0fff, 0x58b1, 0xf0f6, 0x0db6, 0xa5f1, 0x43dd,
            0xeb9a, 0x16da, 0xbe9d, 0xe9d3, 0x4194, 0xbcd4, 0x1493, 0x1248, 0xba0f, 0x474f, 0xef08,
            0xb846, 0x1001, 0xed41, 0x4506, 0xe0f7, 0x48b0, 0xb5f0, 0x1db7, 0x4af9, 0xe2be, 0x1ffe,
            0xb7b9, 0xb162, 0x1925, 0xe465, 0x4c22, 0x1b6c, 0xb32b, 0x4e6b, 0xe62c, 0x87ba, 0x2ffd,
            0xd2bd, 0x7afa, 0x2db4, 0x85f3, 0x78b3, 0xd0f4, 0xd62f, 0x7e68, 0x8328, 0x2b6f, 0x7c21,
            0xd466, 0x2926, 0x8161, 0x2490, 0x8cd7, 0x7197, 0xd9d0, 0x8e9e, 0x26d9, 0xdb99, 0x73de,
            0x7505, 0xdd42, 0x2002, 0x8845, 0xdf0b, 0x774c, 0x8a0c, 0x224b, 0xc467, 0x6c20, 0x9160,
            0x3927, 0x6e69, 0xc62e, 0x3b6e, 0x9329, 0x95f2, 0x3db5, 0xc0f5, 0x68b2, 0x3ffc, 0x97bb,
            0x6afb, 0xc2bc, 0x674d, 0xcf0a, 0x324a, 0x9a0d, 0xcd43, 0x6504, 0x9844, 0x3003, 0x36d8,
            0x9e9f, 0x63df, 0xcb98, 0x9cd6, 0x3491, 0xc9d1, 0x6196, 0x0afd, 0xa2ba, 0x5ffa, 0xf7bd,
            0xa0f3, 0x08b4, 0xf5f4, 0x5db3, 0x5b68, 0xf32f, 0x0e6f, 0xa628, 0xf166, 0x5921, 0xa461,
            0x0c26, 0xa9d7, 0x0190, 0xfcd0, 0x5497, 0x03d9, 0xab9e, 0x56de, 0xfe99, 0xf842, 0x5005,
            0xad45, 0x0502, 0x524c, 0xfa0b, 0x074b, 0xaf0c, 0x4920, 0xe167, 0x1c27, 0xb460, 0xe32e,
            0x4b69, 0xb629, 0x1e6e, 0x18b5, 0xb0f2, 0x4db2, 0xe5f5, 0xb2bb, 0x1afc, 0xe7bc, 0x4ffb,
            0xea0a, 0x424d, 0xbf0d, 0x174a, 0x4004, 0xe843, 0x1503, 0xbd44, 0xbb9f, 0x13d8, 0xee98,
            0x46df, 0x1191, 0xb9d6, 0x4496, 0xecd1, 0x8d47, 0x2500, 0xd840, 0x7007, 0x2749, 0x8f0e,
            0x724e, 0xda09, 0xdcd2, 0x7495, 0x89d5, 0x2192, 0x76dc, 0xde9b, 0x23db, 0x8b9c, 0x2e6d,
            0x862a, 0x7b6a, 0xd32d, 0x8463, 0x2c24, 0xd164, 0x7923, 0x7ff8, 0xd7bf, 0x2aff, 0x82b8,
            0xd5f6, 0x7db1, 0x80f1, 0x28b6, 0xce9a, 0x66dd, 0x9b9d, 0x33da, 0x6494, 0xccd3, 0x3193,
            0x99d4, 0x9f0f, 0x3748, 0xca08, 0x624f, 0x3501, 0x9d46, 0x6006, 0xc841, 0x6db0, 0xc5f7,
            0x38b7, 0x90f0, 0xc7be, 0x6ff9, 0x92b9, 0x3afe, 0x3c25, 0x9462, 0x6922, 0xc165, 0x962b,
            0x3e6c, 0xc32c, 0x6b6b,
        ],
        [
            0x0000, 0x15fa, 0x2bf4, 0x3e0e, 0x57e8, 0x4212, 0x7c1c, 0x69e6, 0xafd0, 0xba2a, 0x8424,
            0x91de, 0xf838, 0xedc2, 0xd3cc, 0xc636, 0x5a29, 0x4fd3, 0x71dd, 0x6427, 0x0dc1, 0x183b,
            0x2635, 0x33cf, 0xf5f9, 0xe003, 0xde0d, 0xcbf7, 0xa211, 0xb7eb, 0x89e5, 0x9c1f, 0xb452,
            0xa1a8, 0x9fa6, 0x8a5c, 0xe3ba, 0xf640, 0xc84e, 0xddb4, 0x1b82, 0x0e78, 0x3076, 0x258c,
            0x4c6a, 0x5990, 0x679e, 0x7264, 0xee7b, 0xfb81, 0xc58f, 0xd075, 0xb993, 0xac69, 0x9267,
            0x879d, 0x41ab, 0x5451, 0x6a5f, 0x7fa5, 0x1643, 0x03b9, 0x3db7, 0x284d, 0x6d2d, 0x78d7,
            0x46d9, 0x5323, 0x3ac5, 0x2f3f, 0x1131, 0x04cb, 0xc2fd, 0xd707, 0xe909, 0xfcf3, 0x9515,
            0x80ef, 0xbee1, 0xab1b, 0x3704, 0x22fe, 0x1cf0, 0x090a, 0x60ec, 0x7516, 0x4b18, 0x5ee2,
            0x98d4, 0x8d2e, 0xb320, 0xa6da, 0xcf3c, 0xdac6, 0xe4c8, 0xf132, 0xd97f, 0xcc85, 0xf28b,
            0xe771, 0x8e97, 0x9b6d, 0xa563, 0xb099, 0x76af, 0x6355, 0x5d5b, 0x48a1, 0x2147, 0x34bd,
            0x0ab3, 0x1f49, 0x8356, 0x96ac, 0xa8a2, 0xbd58, 0xd4be, 0xc144, 0xff4a, 0xeab0, 0x2c86,
            0x397c, 0x0772, 0x1288, 0x7b6e, 0x6e94, 0x509a, 0x4560, 0xda5a, 0xcfa0, 0xf1ae, 0xe454,
            0x8db2, 0x9848, 0xa646, 0xb3bc, 0x758a, 0x6070, 0x5e7e, 0x4b84, 0x2262, 0x3798, 0x0996,
            0x1c6c, 0x8073, 0x9589, 0xab87, 0xbe7d, 0xd79b, 0xc261, 0xfc6f, 0xe995, 0x2fa3, 0x3a59,
            0x0457, 0x11ad, 0x784b, 0x6db1, 0x53bf, 0x4645, 0x6e08, 0x7bf2, 0x45fc, 0x5006, 0x39e0,
            0x2c1a, 0x1214, 0x07ee, 0xc1d8, 0xd422, 0xea2c, 0xffd6, 0x9630, 0x83ca, 0xbdc4, 0xa83e,
            0x3421, 0x21db, 0x1fd5, 0x0a2f, 0x63c9, 0x7633, 0x483d, 0x5dc7, 0x9bf1, 0x8e0b, 0xb005,
            0xa5ff, 0xcc19, 0xd9e3, 0xe7ed, 0xf217, 0xb777, 0xa28d, 0x9c83, 0x8979, 0xe09f, 0xf565,
            0xcb6b, 0xde91, 0x18a7, 0x0d5d, 0x3353, 0x26a9, 0x4f4f, 0x5ab5, 0x64bb, 0x7141, 0xed5e,
            0xf8a4, 0xc6aa, 0xd350, 0xbab6, 0xaf4c, 0x9142, 0x84b8, 0x428e, 0x5774, 0x697a, 0x7c80,
            0x1566, 0x009c, 0x3e92, 0x2b68, 0x0325, 0x16df, 0x28d1, 0x3d2b, 0x54cd, 0x4137, 0x7f39,
            0x6ac3, 0xacf5, 0xb90f, 0x8701, 0x92fb, 0xfb1d, 0xeee7, 0xd0e9, 0xc513, 0x590c, 0x4cf6,
            0x72f8, 0x6702, 0x0ee4, 0x1b1e, 0x2510, 0x30ea, 0xf6dc, 0xe326, 0xdd28, 0xc8d2, 0xa134,
            0xb4ce, 0x8ac0, 0x9f3a,
        ],
        [
            0x0000, 0xb13d, 0x67f3, 0xd6ce, 0xcfe6, 0x7edb, 0xa815, 0x1928, 0x9a45, 0x2b78, 0xfdb6,
            0x4c8b, 0x55a3, 0xe49e, 0x3250, 0x836d, 0x3103, 0x803e, 0x56f0, 0xe7cd, 0xfee5, 0x4fd8,
            0x9916, 0x282b, 0xab46, 0x1a7b, 0xccb5, 0x7d88, 0x64a0, 0xd59d, 0x0353, 0xb26e, 0x6206,
            0xd33b, 0x05f5, 0xb4c8, 0xade0, 0x1cdd, 0xca13, 0x7b2e, 0xf843, 0x497e, 0x9fb0, 0x2e8d,
            0x37a5, 0x8698, 0x5056, 0xe16b, 0x5305, 0xe238, 0x34f6, 0x85cb, 0x9ce3, 0x2dde, 0xfb10,
            0x4a2d, 0xc940, 0x787d, 0xaeb3, 0x1f8e, 0x06a6, 0xb79b, 0x6155, 0xd068, 0xc40c, 0x7531,
            0xa3ff, 0x12c2, 0x0bea, 0xbad7, 0x6c19, 0xdd24, 0x5e49, 0xef74, 0x39ba, 0x8887, 0x91af,
            0x2092, 0xf65c, 0x4761, 0xf50f, 0x4432, 0x92fc, 0x23c1, 0x3ae9, 0x8bd4, 0x5d1a, 0xec27,
            0x6f4a, 0xde77, 0x08b9, 0xb984, 0xa0ac, 0x1191, 0xc75f, 0x7662, 0xa60a, 0x1737, 0xc1f9,
            0x70c4, 0x69ec, 0xd8d1, 0x0e1f, 0xbf22, 0x3c4f, 0x8d72, 0x5bbc, 0xea81, 0xf3a9, 0x4294,
            0x945a, 0x2567, 0x9709, 0x2634, 0xf0fa, 0x41c7, 0x58ef, 0xe9d2, 0x3f1c, 0x8e21, 0x0d4c,
            0xbc71, 0x6abf, 0xdb82, 0xc2aa, 0x7397, 0xa559, 0x1464, 0x8d91, 0x3cac, 0xea62, 0x5b5f,
            0x4277, 0xf34a, 0x2584, 0x94b9, 0x17d4, 0xa6e9, 0x7027, 0xc11a, 0xd832, 0x690f, 0xbfc1,
            0x0efc, 0xbc92, 0x0daf, 0xdb61, 0x6a5c, 0x7374, 0xc249, 0x1487, 0xa5ba, 0x26d7, 0x97ea,
            0x4124, 0xf019, 0xe931, 0x580c, 0x8ec2, 0x3fff, 0xef97, 0x5eaa, 0x8864, 0x3959, 0x2071,
            0x914c, 0x4782, 0xf6bf, 0x75d2, 0xc4ef, 0x1221, 0xa31c, 0xba34, 0x0b09, 0xddc7, 0x6cfa,
            0xde94, 0x6fa9, 0xb967, 0x085a, 0x1172, 0xa04f, 0x7681, 0xc7bc, 0x44d1, 0xf5ec, 0x2322,
            0x921f, 0x8b37, 0x3a0a, 0xecc4, 0x5df9, 0x499d, 0xf8a0, 0x2e6e, 0x9f53, 0x867b, 0x3746,
            0xe188, 0x50b5, 0xd3d8, 0x62e5, 0xb42b, 0x0516, 0x1c3e, 0xad03, 0x7bcd, 0xcaf0, 0x789e,
            0xc9a3, 0x1f6d, 0xae50, 0xb778, 0x0645, 0xd08b, 0x61b6, 0xe2db, 0x53e6, 0x8528, 0x3415,
            0x2d3d, 0x9c00, 0x4ace, 0xfbf3, 0x2b9b, 0x9aa6, 0x4c68, 0xfd55, 0xe47d, 0x5540, 0x838e,
            0x32b3, 0xb1de, 0x00e3, 0xd62d, 0x6710, 0x7e38, 0xcf05, 0x19cb, 0xa8f6, 0x1a98, 0xaba5,
            0x7d6b, 0xcc56, 0xd57e, 0x6443, 0xb28d, 0x03b0, 0x80dd, 0x31e0, 0xe72e, 0x5613, 0x4f3b,
            0xfe06, 0x28c8, 0x99f5,
        ],
        [
            0x0000, 0x1eab, 0x3d56, 0x23fd, 0x7aac, 0x6407, 0x47fa, 0x5951, 0xf558, 0xebf3, 0xc80e,
            0xd6a5, 0x8ff4, 0x915f, 0xb2a2, 0xac09, 0xef39, 0xf192, 0xd26f, 0xccc4, 0x9595, 0x8b3e,
            0xa8c3, 0xb668, 0x1a61, 0x04ca, 0x2737, 0x399c, 0x60cd, 0x7e66, 0x5d9b, 0x4330, 0xdbfb,
            0xc550, 0xe6ad, 0xf806, 0xa157, 0xbffc, 0x9c01, 0x82aa, 0x2ea3, 0x3008, 0x13f5, 0x0d5e,
            0x540f, 0x4aa4, 0x6959, 0x77f2, 0x34c2, 0x2a69, 0x0994, 0x173f, 0x4e6e, 0x50c5, 0x7338,
            0x6d93, 0xc19a, 0xdf31, 0xfccc, 0xe267, 0xbb36, 0xa59d, 0x8660, 0x98cb, 0xb27f, 0xacd4,
            0x8f29, 0x9182, 0xc8d3, 0xd678, 0xf585, 0xeb2e, 0x4727, 0x598c, 0x7a71, 0x64da, 0x3d8b,
            0x2320, 0x00dd, 0x1e76, 0x5d46, 0x43ed, 0x6010, 0x7ebb, 0x27ea, 0x3941, 0x1abc, 0x0417,
            0xa81e, 0xb6b5, 0x9548, 0x8be3, 0xd2b2, 0xcc19, 0xefe4, 0xf14f, 0x6984, 0x772f, 0x54d2,
            0x4a79, 0x1328, 0x0d83, 0x2e7e, 0x30d5, 0x9cdc, 0x8277, 0xa18a, 0xbf21, 0xe670, 0xf8db,
            0xdb26, 0xc58d, 0x86bd, 0x9816, 0xbbeb, 0xa540, 0xfc11, 0xe2ba, 0xc147, 0xdfec, 0x73e5,
            0x6d4e, 0x4eb3, 0x5018, 0x0949, 0x17e2, 0x341f, 0x2ab4, 0x6177, 0x7fdc, 0x5c21, 0x428a,
            0x1bdb, 0x0570, 0x268d, 0x3826, 0x942f, 0x8a84, 0xa979, 0xb7d2, 0xee83, 0xf028, 0xd3d5,
            0xcd7e, 0x8e4e, 0x90e5, 0xb318, 0xadb3, 0xf4e2, 0xea49, 0xc9b4, 0xd71f, 0x7b16, 0x65bd,
            0x4640, 0x58eb, 0x01ba, 0x1f11, 0x3cec, 0x2247, 0xba8c, 0xa427, 0x87da, 0x9971, 0xc020,
            0xde8b, 0xfd76, 0xe3dd, 0x4fd4, 0x517f, 0x7282, 0x6c29, 0x3578, 0x2bd3, 0x082e, 0x1685,
            0x55b5, 0x4b1e, 0x68e3, 0x7648, 0x2f19, 0x31b2, 0x124f, 0x0ce4, 0xa0ed, 0xbe46, 0x9dbb,
            0x8310, 0xda41, 0xc4ea, 0xe717, 0xf9bc, 0xd308, 0xcda3, 0xee5e, 0xf0f5, 0xa9a4, 0xb70f,
            0x94f2, 0x8a59, 0x2650, 0x38fb, 0x1b06, 0x05ad, 0x5cfc, 0x4257, 0x61aa, 0x7f01, 0x3c31,
            0x229a, 0x0167, 0x1fcc, 0x469d, 0x5836, 0x7bcb, 0x6560, 0xc969, 0xd7c2, 0xf43f, 0xea94,
            0xb3c5, 0xad6e, 0x8e93, 0x9038, 0x08f3, 0x1658, 0x35a5, 0x2b0e, 0x725f, 0x6cf4, 0x4f09,
            0x51a2, 0xfdab, 0xe300, 0xc0fd, 0xde56, 0x8707, 0x99ac, 0xba51, 0xa4fa, 0xe7ca, 0xf961,
            0xda9c, 0xc437, 0x9d66, 0x83cd, 0xa030, 0xbe9b, 0x1292, 0x0c39, 0x2fc4, 0x316f, 0x683e,
            0x7695, 0x5568, 0x4bc3,
        ],
        [
            0x0000, 0xc2ee, 0x8055, 0x42bb, 0x0523, 0xc7cd, 0x8576, 0x4798, 0x0a46, 0xc8a8, 0x8a13,
            0x48fd, 0x0f65, 0xcd8b, 0x8f30, 0x4dde, 0x148c, 0xd662, 0x94d9, 0x5637, 0x11af, 0xd341,
            0x91fa, 0x5314, 0x1eca, 0xdc24, 0x9e9f, 0x5c71, 0x1be9, 0xd907, 0x9bbc, 0x5952, 0x2918,
            0xebf6, 0xa94d, 0x6ba3, 0x2c3b, 0xeed5, 0xac6e, 0x6e80, 0x235e, 0xe1b0, 0xa30b, 0x61e5,
            0x267d, 0xe493, 0xa628, 0x64c6, 0x3d94, 0xff7a, 0xbdc1, 0x7f2f, 0x38b7, 0xfa59, 0xb8e2,
            0x7a0c, 0x37d2, 0xf53c, 0xb787, 0x7569, 0x32f1, 0xf01f, 0xb2a4, 0x704a, 0x5230, 0x90de,
            0xd265, 0x108b, 0x5713, 0x95fd, 0xd746, 0x15a8, 0x5876, 0x9a98, 0xd823, 0x1acd, 0x5d55,
            0x9fbb, 0xdd00, 0x1fee, 0x46bc, 0x8452, 0xc6e9, 0x0407, 0x439f, 0x8171, 0xc3ca, 0x0124,
            0x4cfa, 0x8e14, 0xccaf, 0x0e41, 0x49d9, 0x8b37, 0xc98c, 0x0b62, 0x7b28, 0xb9c6, 0xfb7d,
            0x3993, 0x7e0b, 0xbce5, 0xfe5e, 0x3cb0, 0x716e, 0xb380, 0xf13b, 0x33d5, 0x744d, 0xb6a3,
            0xf418, 0x36f6, 0x6fa4, 0xad4a, 0xeff1, 0x2d1f, 0x6a87, 0xa869, 0xead2, 0x283c, 0x65e2,
            0xa70c, 0xe5b7, 0x2759, 0x60c1, 0xa22f, 0xe094, 0x227a, 0xa460, 0x668e, 0x2435, 0xe6db,
            0xa143, 0x63ad, 0x2116, 0xe3f8, 0xae26, 0x6cc8, 0x2e73, 0xec9d, 0xab05, 0x69eb, 0x2b50,
            0xe9be, 0xb0ec, 0x7202, 0x30b9, 0xf257, 0xb5cf, 0x7721, 0x359a, 0xf774, 0xbaaa, 0x7844,
            0x3aff, 0xf811, 0xbf89, 0x7d67, 0x3fdc, 0xfd32, 0x8d78, 0x4f96, 0x0d2d, 0xcfc3, 0x885b,
            0x4ab5, 0x080e, 0xcae0, 0x873e, 0x45d0, 0x076b, 0xc585, 0x821d, 0x40f3, 0x0248, 0xc0a6,
            0x99f4, 0x5b1a, 0x19a1, 0xdb4f, 0x9cd7, 0x5e39, 0x1c82, 0xde6c, 0x93b2, 0x515c, 0x13e7,
            0xd109, 0x9691, 0x547f, 0x16c4, 0xd42a, 0xf650, 0x34be, 0x7605, 0xb4eb, 0xf373, 0x319d,
            0x7326, 0xb1c8, 0xfc16, 0x3ef8, 0x7c43, 0xbead, 0xf935, 0x3bdb, 0x7960, 0xbb8e, 0xe2dc,
            0x2032, 0x6289, 0xa067, 0xe7ff, 0x2511, 0x67aa, 0xa544, 0xe89a, 0x2a74, 0x68cf, 0xaa21,
            0xedb9, 0x2f57, 0x6dec, 0xaf02, 0xdf48, 0x1da6, 0x5f1d, 0x9df3, 0xda6b, 0x1885, 0x5a3e,
            0x98d0, 0xd50e, 0x17e0, 0x555b, 0x97b5, 0xd02d, 0x12c3, 0x5078, 0x9296, 0xcbc4, 0x092a,
            0x4b91, 0x897f, 0xcee7, 0x0c09, 0x4eb2, 0x8c5c, 0xc182, 0x036c, 0x41d7, 0x8339, 0xc4a1,
            0x064f, 0x44f4, 0x861a,
        ],
        [
            0x0000, 0x4d49, 0x9a92, 0xd7db, 0x30ad, 0x7de4, 0xaa3f, 0xe776, 0x615a, 0x2c13, 0xfbc8,
            0xb681, 0x51f7, 0x1cbe, 0xcb65, 0x862c, 0xc2b4, 0x8ffd, 0x5826, 0x156f, 0xf219, 0xbf50,
            0x688b, 0x25c2, 0xa3ee, 0xeea7, 0x397c, 0x7435, 0x9343, 0xde0a, 0x09d1, 0x4498, 0x80e1,
            0xcda8, 0x1a73, 0x573a, 0xb04c, 0xfd05, 0x2ade, 0x6797, 0xe1bb, 0xacf2, 0x7b29, 0x3660,
            0xd116, 0x9c5f, 0x4b84, 0x06cd, 0x4255, 0x0f1c, 0xd8c7, 0x958e, 0x72f8, 0x3fb1, 0xe86a,
            0xa523, 0x230f, 0x6e46, 0xb99d, 0xf4d4, 0x13a2, 0x5eeb, 0x8930, 0xc479, 0x044b, 0x4902,
            0x9ed9, 0xd390, 0x34e6, 0x79af, 0xae74, 0xe33d, 0x6511, 0x2858, 0xff83, 0xb2ca, 0x55bc,
            0x18f5, 0xcf2e, 0x8267, 0xc6ff, 0x8bb6, 0x5c6d, 0x1124, 0xf652, 0xbb1b, 0x6cc0, 0x2189,
            0xa7a5, 0xeaec, 0x3d37, 0x707e, 0x9708, 0xda41, 0x0d9a, 0x40d3, 0x84aa, 0xc9e3, 0x1e38,
            0x5371, 0xb407, 0xf94e, 0x2e95, 0x63dc, 0xe5f0, 0xa8b9, 0x7f62, 0x322b, 0xd55d, 0x9814,
            0x4fcf, 0x0286, 0x461e, 0x0b57, 0xdc8c, 0x91c5, 0x76b3, 0x3bfa, 0xec21, 0xa168, 0x2744,
            0x6a0d, 0xbdd6, 0xf09f, 0x17e9, 0x5aa0, 0x8d7b, 0xc032, 0x0896, 0x45df, 0x9204, 0xdf4d,
            0x383b, 0x7572, 0xa2a9, 0xefe0, 0x69cc, 0x2485, 0xf35e, 0xbe17, 0x5961, 0x1428, 0xc3f3,
            0x8eba, 0xca22, 0x876b, 0x50b0, 0x1df9, 0xfa8f, 0xb7c6, 0x601d, 0x2d54, 0xab78, 0xe631,
            0x31ea, 0x7ca3, 0x9bd5, 0xd69c, 0x0147, 0x4c0e, 0x8877, 0xc53e, 0x12e5, 0x5fac, 0xb8da,
            0xf593, 0x2248, 0x6f01, 0xe92d, 0xa464, 0x73bf, 0x3ef6, 0xd980, 0x94c9, 0x4312, 0x0e5b,
            0x4ac3, 0x078a, 0xd051, 0x9d18, 0x7a6e, 0x3727, 0xe0fc, 0xadb5, 0x2b99, 0x66d0, 0xb10b,
            0xfc42, 0x1b34, 0x567d, 0x81a6, 0xccef, 0x0cdd, 0x4194, 0x964f, 0xdb06, 0x3c70, 0x7139,
            0xa6e2, 0xebab, 0x6d87, 0x20ce, 0xf715, 0xba5c, 0x5d2a, 0x1063, 0xc7b8, 0x8af1, 0xce69,
            0x8320, 0x54fb, 0x19b2, 0xfec4, 0xb38d, 0x6456, 0x291f, 0xaf33, 0xe27a, 0x35a1, 0x78e8,
            0x9f9e, 0xd2d7, 0x050c, 0x4845, 0x8c3c, 0xc175, 0x16ae, 0x5be7, 0xbc91, 0xf1d8, 0x2603,
            0x6b4a, 0xed66, 0xa02f, 0x77f4, 0x3abd, 0xddcb, 0x9082, 0x4759, 0x0a10, 0x4e88, 0x03c1,
            0xd41a, 0x9953, 0x7e25, 0x336c, 0xe4b7, 0xa9fe, 0x2fd2, 0x629b, 0xb540, 0xf809, 0x1f7f,
            0x5236, 0x85ed, 0xc8a4,
        ],
        [
            0x0000, 0x112c, 0x2258, 0x3374, 0x44b0, 0x559c, 0x66e8, 0x77c4, 0x8960, 0x984c, 0xab38,
            0xba14, 0xcdd0, 0xdcfc, 0xef88, 0xfea4, 0x1749, 0x0665, 0x3511, 0x243d, 0x53f9, 0x42d5,
            0x71a1, 0x608d, 0x9e29, 0x8f05, 0xbc71, 0xad5d, 0xda99, 0xcbb5, 0xf8c1, 0xe9ed, 0x2e92,
            0x3fbe, 0x0cca, 0x1de6, 0x6a22, 0x7b0e, 0x487a, 0x5956, 0xa7f2, 0xb6de, 0x85aa, 0x9486,
            0xe342, 0xf26e, 0xc11a, 0xd036, 0x39db, 0x28f7, 0x1b83, 0x0aaf, 0x7d6b, 0x6c47, 0x5f33,
            0x4e1f, 0xb0bb, 0xa197, 0x92e3, 0x83cf, 0xf40b, 0xe527, 0xd653, 0xc77f, 0x5d24, 0x4c08,
            0x7f7c, 0x6e50, 0x1994, 0x08b8, 0x3bcc, 0x2ae0, 0xd444, 0xc568, 0xf61c, 0xe730, 0x90f4,
            0x81d8, 0xb2ac, 0xa380, 0x4a6d, 0x5b41, 0x6835, 0x7919, 0x0edd, 0x1ff1, 0x2c85, 0x3da9,
            0xc30d, 0xd221, 0xe155, 0xf079, 0x87bd, 0x9691, 0xa5e5, 0xb4c9, 0x73b6, 0x629a, 0x51ee,
            0x40c2, 0x3706, 0x262a, 0x155e, 0x0472, 0xfad6, 0xebfa, 0xd88e, 0xc9a2, 0xbe66, 0xaf4a,
            0x9c3e, 0x8d12, 0x64ff, 0x75d3, 0x46a7, 0x578b, 0x204f, 0x3163, 0x0217, 0x133b, 0xed9f,
            0xfcb3, 0xcfc7, 0xdeeb, 0xa92f, 0xb803, 0x8b77, 0x9a5b, 0xba48, 0xab64, 0x9810, 0x893c,
            0xfef8, 0xefd4, 0xdca0, 0xcd8c, 0x3328, 0x2204, 0x1170, 0x005c, 0x7798, 0x66b4, 0x55c0,
            0x44ec, 0xad01, 0xbc2d, 0x8f59, 0x9e75, 0xe9b1, 0xf89d, 0xcbe9, 0xdac5, 0x2461, 0x354d,
            0x0639, 0x1715, 0x60d1, 0x71fd, 0x4289, 0x53a5, 0x94da, 0x85f6, 0xb682, 0xa7ae, 0xd06a,
            0xc146, 0xf232, 0xe31e, 0x1dba, 0x0c96, 0x3fe2, 0x2ece, 0x590a, 0x4826, 0x7b52, 0x6a7e,
            0x8393, 0x92bf, 0xa1cb, 0xb0e7, 0xc723, 0xd60f, 0xe57b, 0xf457, 0x0af3, 0x1bdf, 0x28ab,
            0x3987, 0x4e43, 0x5f6f, 0x6c1b, 0x7d37, 0xe76c, 0xf640, 0xc534, 0xd418, 0xa3dc, 0xb2f0,
            0x8184, 0x90a8, 0x6e0c, 0x7f20, 0x4c54, 0x5d78, 0x2abc, 0x3b90, 0x08e4, 0x19c8, 0xf025,
            0xe109, 0xd27d, 0xc351, 0xb495, 0xa5b9, 0x96cd, 0x87e1, 0x7945, 0x6869, 0x5b1d, 0x4a31,
            0x3df5, 0x2cd9, 0x1fad, 0x0e81, 0xc9fe, 0xd8d2, 0xeba6, 0xfa8a, 0x8d4e, 0x9c62, 0xaf16,
            0xbe3a, 0x409e, 0x51b2, 0x62c6, 0x73ea, 0x042e, 0x1502, 0x2676, 0x375a, 0xdeb7, 0xcf9b,
            0xfcef, 0xedc3, 0x9a07, 0x8b2b, 0xb85f, 0xa973, 0x57d7, 0x46fb, 0x758f, 0x64a3, 0x1367,
            0x024b, 0x313f, 0x2013,
        ],
        [
            0x0000, 0x7119, 0xe232, 0x932b, 0xc1ed, 0xb0f4, 0x23df, 0x52c6, 0x8653, 0xf74a, 0x6461,
            0x1578, 0x47be, 0x36a7, 0xa58c, 0xd495, 0x092f, 0x7836, 0xeb1d, 0x9a04, 0xc8c2, 0xb9db,
            0x2af0, 0x5be9, 0x8f7c, 0xfe65, 0x6d4e, 0x1c57, 0x4e91, 0x3f88, 0xaca3, 0xddba, 0x125e,
            0x6347, 0xf06c, 0x8175, 0xd3b3, 0xa2aa, 0x3181, 0x4098, 0x940d, 0xe514, 0x763f, 0x0726,
            0x55e0, 0x24f9, 0xb7d2, 0xc6cb, 0x1b71, 0x6a68, 0xf943, 0x885a, 0xda9c, 0xab85, 0x38ae,
            0x49b7, 0x9d22, 0xec3b, 0x7f10, 0x0e09, 0x5ccf, 0x2dd6, 0xbefd, 0xcfe4, 0x24bc, 0x55a5,
            0xc68e, 0xb797, 0xe551, 0x9448, 0x0763, 0x767a, 0xa2ef, 0xd3f6, 0x40dd, 0x31c4, 0x6302,
            0x121b, 0x8130, 0xf029, 0x2d93, 0x5c8a, 0xcfa1, 0xbeb8, 0xec7e, 0x9d67, 0x0e4c, 0x7f55,
            0xabc0, 0xdad9, 0x49f2, 0x38eb, 0x6a2d, 0x1b34, 0x881f, 0xf906, 0x36e2, 0x47fb, 0xd4d0,
            0xa5c9, 0xf70f, 0x8616, 0x153d, 0x6424, 0xb0b1, 0xc1a8, 0x5283, 0x239a, 0x715c, 0x0045,
            0x936e, 0xe277, 0x3fcd, 0x4ed4, 0xddff, 0xace6, 0xfe20, 0x8f39, 0x1c12, 0x6d0b, 0xb99e,
            0xc887, 0x5bac, 0x2ab5, 0x7873, 0x096a, 0x9a41, 0xeb58, 0x4978, 0x3861, 0xab4a, 0xda53,
            0x8895, 0xf98c, 0x6aa7, 0x1bbe, 0xcf2b, 0xbe32, 0x2d19, 0x5c00, 0x0ec6, 0x7fdf, 0xecf4,
            0x9ded, 0x4057, 0x314e, 0xa265, 0xd37c, 0x81ba, 0xf0a3, 0x6388, 0x1291, 0xc604, 0xb71d,
            0x2436, 0x552f, 0x07e9, 0x76f0, 0xe5db, 0x94c2, 0x5b26, 0x2a3f, 0xb914, 0xc80d, 0x9acb,
            0xebd2, 0x78f9, 0x09e0, 0xdd75, 0xac6c, 0x3f47, 0x4e5e, 0x1c98, 0x6d81, 0xfeaa, 0x8fb3,
            0x5209, 0x2310, 0xb03b, 0xc122, 0x93e4, 0xe2fd, 0x71d6, 0x00cf, 0xd45a, 0xa543, 0x3668,
            0x4771, 0x15b7, 0x64ae, 0xf785, 0x869c, 0x6dc4, 0x1cdd, 0x8ff6, 0xfeef, 0xac29, 0xdd30,
            0x4e1b, 0x3f02, 0xeb97, 0x9a8e, 0x09a5, 0x78bc, 0x2a7a, 0x5b63, 0xc848, 0xb951, 0x64eb,
            0x15f2, 0x86d9, 0xf7c0, 0xa506, 0xd41f, 0x4734, 0x362d, 0xe2b8, 0x93a1, 0x008a, 0x7193,
            0x2355, 0x524c, 0xc167, 0xb07e, 0x7f9a, 0x0e83, 0x9da8, 0xecb1, 0xbe77, 0xcf6e, 0x5c45,
            0x2d5c, 0xf9c9, 0x88d0, 0x1bfb, 0x6ae2, 0x3824, 0x493d, 0xda16, 0xab0f, 0x76b5, 0x07ac,
            0x9487, 0xe59e, 0xb758, 0xc641, 0x556a, 0x2473, 0xf0e6, 0x81ff, 0x12d4, 0x63cd, 0x310b,
            0x4012, 0xd339, 0xa220,
        ],
        [
            0x0000, 0x92f0, 0x2069, 0xb299, 0x40d2, 0xd222, 0x60bb, 0xf24b, 0x81a4, 0x1354, 0xa1cd,
            0x333d, 0xc176, 0x5386, 0xe11f, 0x73ef, 0x06c1, 0x9431, 0x26a8, 0xb458, 0x4613, 0xd4e3,
            0x667a, 0xf48a, 0x8765, 0x1595, 0xa70c, 0x35fc, 0xc7b7, 0x5547, 0xe7de, 0x752e, 0x0d82,
            0x9f72, 0x2deb, 0xbf1b, 0x4d50, 0xdfa0, 0x6d39, 0xffc9, 0x8c26, 0x1ed6, 0xac4f, 0x3ebf,
            0xccf4, 0x5e04, 0xec9d, 0x7e6d, 0x0b43, 0x99b3, 0x2b2a, 0xb9da, 0x4b91, 0xd961, 0x6bf8,
            0xf908, 0x8ae7, 0x1817, 0xaa8e, 0x387e, 0xca35, 0x58c5, 0xea5c, 0x78ac, 0x1b04, 0x89f4,
            0x3b6d, 0xa99d, 0x5bd6, 0xc926, 0x7bbf, 0xe94f, 0x9aa0, 0x0850, 0xbac9, 0x2839, 0xda72,
            0x4882, 0xfa1b, 0x68eb, 0x1dc5, 0x8f35, 0x3dac, 0xaf5c, 0x5d17, 0xcfe7, 0x7d7e, 0xef8e,
            0x9c61, 0x0e91, 0xbc08, 0x2ef8, 0xdcb3, 0x4e43, 0xfcda, 0x6e2a, 0x1686, 0x8476, 0x36ef,
            0xa41f, 0x5654, 0xc4a4, 0x763d, 0xe4cd, 0x9722, 0x05d2, 0xb74b, 0x25bb, 0xd7f0, 0x4500,
            0xf799, 0x6569, 0x1047, 0x82b7, 0x302e, 0xa2de, 0x5095, 0xc265, 0x70fc, 0xe20c, 0x91e3,
            0x0313, 0xb18a, 0x237a, 0xd131, 0x43c1, 0xf158, 0x63a8, 0x3608, 0xa4f8, 0x1661, 0x8491,
            0x76da, 0xe42a, 0x56b3, 0xc443, 0xb7ac, 0x255c, 0x97c5, 0x0535, 0xf77e, 0x658e, 0xd717,
            0x45e7, 0x30c9, 0xa239, 0x10a0, 0x8250, 0x701b, 0xe2eb, 0x5072, 0xc282, 0xb16d, 0x239d,
            0x9104, 0x03f4, 0xf1bf, 0x634f, 0xd1d6, 0x4326, 0x3b8a, 0xa97a, 0x1be3, 0x8913, 0x7b58,
            0xe9a8, 0x5b31, 0xc9c1, 0xba2e, 0x28de, 0x9a47, 0x08b7, 0xfafc, 0x680c, 0xda95, 0x4865,
            0x3d4b, 0xafbb, 0x1d22, 0x8fd2, 0x7d99, 0xef69, 0x5df0, 0xcf00, 0xbcef, 0x2e1f, 0x9c86,
            0x0e76, 0xfc3d, 0x6ecd, 0xdc54, 0x4ea4, 0x2d0c, 0xbffc, 0x0d65, 0x9f95, 0x6dde, 0xff2e,
            0x4db7, 0xdf47, 0xaca8, 0x3e58, 0x8cc1, 0x1e31, 0xec7a, 0x7e8a, 0xcc13, 0x5ee3, 0x2bcd,
            0xb93d, 0x0ba4, 0x9954, 0x6b1f, 0xf9ef, 0x4b76, 0xd986, 0xaa69, 0x3899, 0x8a00, 0x18f0,
            0xeabb, 0x784b, 0xcad2, 0x5822, 0x208e, 0xb27e, 0x00e7, 0x9217, 0x605c, 0xf2ac, 0x4035,
            0xd2c5, 0xa12a, 0x33da, 0x8143, 0x13b3, 0xe1f8, 0x7308, 0xc191, 0x5361, 0x264f, 0xb4bf,
            0x0626, 0x94d6, 0x669d, 0xf46d, 0x46f4, 0xd404, 0xa7eb, 0x351b, 0x8782, 0x1572, 0xe739,
            0x75c9, 0xc750, 0x55a0,
        ],
        [
            0x0000, 0x6c10, 0xd820, 0xb430, 0xb5c9, 0xd9d9, 0x6de9, 0x01f9, 0x6e1b, 0x020b, 0xb63b,
            0xda2b, 0xdbd2, 0xb7c2, 0x03f2, 0x6fe2, 0xdc36, 0xb026, 0x0416, 0x6806, 0x69ff, 0x05ef,
            0xb1df, 0xddcf, 0xb22d, 0xde3d, 0x6a0d, 0x061d, 0x07e4, 0x6bf4, 0xdfc4, 0xb3d4, 0xbde5,
            0xd1f5, 0x65c5, 0x09d5, 0x082c, 0x643c, 0xd00c, 0xbc1c, 0xd3fe, 0xbfee, 0x0bde, 0x67ce,
            0x6637, 0x0a27, 0xbe17, 0xd207, 0x61d3, 0x0dc3, 0xb9f3, 0xd5e3, 0xd41a, 0xb80a, 0x0c3a,
            0x602a, 0x0fc8, 0x63d8, 0xd7e8, 0xbbf8, 0xba01, 0xd611, 0x6221, 0x0e31, 0x7e43, 0x1253,
            0xa663, 0xca73, 0xcb8a, 0xa79a, 0x13aa, 0x7fba, 0x1058, 0x7c48, 0xc878, 0xa468, 0xa591,
            0xc981, 0x7db1, 0x11a1, 0xa275, 0xce65, 0x7a55, 0x1645, 0x17bc, 0x7bac, 0xcf9c, 0xa38c,
            0xcc6e, 0xa07e, 0x144e, 0x785e, 0x79a7, 0x15b7, 0xa187, 0xcd97, 0xc3a6, 0xafb6, 0x1b86,
            0x7796, 0x766f, 0x1a7f, 0xae4f, 0xc25f, 0xadbd, 0xc1ad, 0x759d, 0x198d, 0x1874, 0x7464,
            0xc054, 0xac44, 0x1f90, 0x7380, 0xc7b0, 0xaba0, 0xaa59, 0xc649, 0x7279, 0x1e69, 0x718b,
            0x1d9b, 0xa9ab, 0xc5bb, 0xc442, 0xa852, 0x1c62, 0x7072, 0xfc86, 0x9096, 0x24a6, 0x48b6,
            0x494f, 0x255f, 0x916f, 0xfd7f, 0x929d, 0xfe8d, 0x4abd, 0x26ad, 0x2754, 0x4b44, 0xff74,
            0x9364, 0x20b0, 0x4ca0, 0xf890, 0x9480, 0x9579, 0xf969, 0x4d59, 0x2149, 0x4eab, 0x22bb,
            0x968b, 0xfa9b, 0xfb62, 0x9772, 0x2342, 0x4f52, 0x4163, 0x2d73, 0x9943, 0xf553, 0xf4aa,
            0x98ba, 0x2c8a, 0x409a, 0x2f78, 0x4368, 0xf758, 0x9b48, 0x9ab1, 0xf6a1, 0x4291, 0x2e81,
            0x9d55, 0xf145, 0x4575, 0x2965, 0x289c, 0x448c, 0xf0bc, 0x9cac, 0xf34e, 0x9f5e, 0x2b6e,
            0x477e, 0x4687, 0x2a97, 0x9ea7, 0xf2b7, 0x82c5, 0xeed5, 0x5ae5, 0x36f5, 0x370c, 0x5b1c,
            0xef2c, 0x833c, 0xecde, 0x80ce, 0x34fe, 0x58ee, 0x5917, 0x3507, 0x8137, 0xed27, 0x5ef3,
            0x32e3, 0x86d3, 0xeac3, 0xeb3a, 0x872a, 0x331a, 0x5f0a, 0x30e8, 0x5cf8, 0xe8c8, 0x84d8,
            0x8521, 0xe931, 0x5d01, 0x3111, 0x3f20, 0x5330, 0xe700, 0x8b10, 0x8ae9, 0xe6f9, 0x52c9,
            0x3ed9, 0x513b, 0x3d2b, 0x891b, 0xe50b, 0xe4f2, 0x88e2, 0x3cd2, 0x50c2, 0xe316, 0x8f06,
            0x3b36, 0x5726, 0x56df, 0x3acf, 0x8eff, 0xe2ef, 0x8d0d, 0xe11d, 0x552d, 0x393d, 0x38c4,
            0x54d4, 0xe0e4, 0x8cf4,
        ],
        [
            0x0000, 0xfc85, 0xfc83, 0x0006, 0xfc8f, 0x000a, 0x000c, 0xfc89, 0xfc97, 0x0012, 0x0014,
            0xfc91, 0x0018, 0xfc9d, 0xfc9b, 0x001e, 0xfca7, 0x0022, 0x0024, 0xfca1, 0x0028, 0xfcad,
            0xfcab, 0x002e, 0x0030, 0xfcb5, 0xfcb3, 0x0036, 0xfcbf, 0x003a, 0x003c, 0xfcb9, 0xfcc7,
            0x0042, 0x0044, 0xfcc1, 0x0048, 0xfccd, 0xfccb, 0x004e, 0x0050, 0xfcd5, 0xfcd3, 0x0056,
            0xfcdf, 0x005a, 0x005c, 0xfcd9, 0x0060, 0xfce5, 0xfce3, 0x0066, 0xfcef, 0x006a, 0x006c,
            0xfce9, 0xfcf7, 0x0072, 0x0074, 0xfcf1, 0x0078, 0xfcfd, 0xfcfb, 0x007e, 0xfc07, 0x0082,
            0x0084, 0xfc01, 0x0088, 0xfc0d, 0xfc0b, 0x008e, 0x0090, 0xfc15, 0xfc13, 0x0096, 0xfc1f,
            0x009a, 0x009c, 0xfc19, 0x00a0, 0xfc25, 0xfc23, 0x00a6, 0xfc2f, 0x00aa, 0x00ac, 0xfc29,
            0xfc37, 0x00b2, 0x00b4, 0xfc31, 0x00b8, 0xfc3d, 0xfc3b, 0x00be, 0x00c0, 0xfc45, 0xfc43,
            0x00c6, 0xfc4f, 0x00ca, 0x00cc, 0xfc49, 0xfc57, 0x00d2, 0x00d4, 0xfc51, 0x00d8, 0xfc5d,
            0xfc5b, 0x00de, 0xfc67, 0x00e2, 0x00e4, 0xfc61, 0x00e8, 0xfc6d, 0xfc6b, 0x00ee, 0x00f0,
            0xfc75, 0xfc73, 0x00f6, 0xfc7f, 0x00fa, 0x00fc, 0xfc79, 0xfd87, 0x0102, 0x0104, 0xfd81,
            0x0108, 0xfd8d, 0xfd8b, 0x010e, 0x0110, 0xfd95, 0xfd93, 0x0116, 0xfd9f, 0x011a, 0x011c,
            0xfd99, 0x0120, 0xfda5, 0xfda3, 0x0126, 0xfdaf, 0x012a, 0x012c, 0xfda9, 0xfdb7, 0x0132,
            0x0134, 0xfdb1, 0x0138, 0xfdbd, 0xfdbb, 0x013e, 0x0140, 0xfdc5, 0xfdc3, 0x0146, 0xfdcf,
            0x014a, 0x014c, 0xfdc9, 0xfdd7, 0x0152, 0x0154, 0xfdd1, 0x0158, 0xfddd, 0xfddb, 0x015e,
            0xfde7, 0x0162, 0x0164, 0xfde1, 0x0168, 0xfded, 0xfdeb, 0x016e, 0x0170, 0xfdf5, 0xfdf3,
            0x0176, 0xfdff, 0x017a, 0x017c, 0xfdf9, 0x0180, 0xfd05, 0xfd03, 0x0186, 0xfd0f, 0x018a,
            0x018c, 0xfd09, 0xfd17, 0x0192, 0x0194, 0xfd11, 0x0198, 0xfd1d, 0xfd1b, 0x019e, 0xfd27,
            0x01a2, 0x01a4, 0xfd21, 0x01a8, 0xfd2d, 0xfd2b, 0x01ae, 0x01b0, 0xfd35, 0xfd33, 0x01b6,
            0xfd3f, 0x01ba, 0x01bc, 0xfd39, 0xfd47, 0x01c2, 0x01c4, 0xfd41, 0x01c8, 0xfd4d, 0xfd4b,
            0x01ce, 0x01d0, 0xfd55, 0xfd53, 0x01d6, 0xfd5f, 0x01da, 0x01dc, 0xfd59, 0x01e0, 0xfd65,
            0xfd63, 0x01e6, 0xfd6f, 0x01ea, 0x01ec, 0xfd69, 0xfd77, 0x01f2, 0x01f4, 0xfd71, 0x01f8,
            0xfd7d, 0xfd7b, 0x01fe,
        ],
        [
            0x0000, 0xfe87, 0xf887, 0x0600, 0xf487, 0x0a00, 0x0c00, 0xf287, 0xec87, 0x1200, 0x1400,
            0xea87, 0x1800, 0xe687, 0xe087, 0x1e00, 0xdc87, 0x2200, 0x2400, 0xda87, 0x2800, 0xd687,
            0xd087, 0x2e00, 0x3000, 0xce87, 0xc887, 0x3600, 0xc487, 0x3a00, 0x3c00, 0xc287, 0xbc87,
            0x4200, 0x4400, 0xba87, 0x4800, 0xb687, 0xb087, 0x4e00, 0x5000, 0xae87, 0xa887, 0x5600,
            0xa487, 0x5a00, 0x5c00, 0xa287, 0x6000, 0x9e87, 0x9887, 0x6600, 0x9487, 0x6a00, 0x6c00,
            0x9287, 0x8c87, 0x7200, 0x7400, 0x8a87, 0x7800, 0x8687, 0x8087, 0x7e00, 0x7c87, 0x8200,
            0x8400, 0x7a87, 0x8800, 0x7687, 0x7087, 0x8e00, 0x9000, 0x6e87, 0x6887, 0x9600, 0x6487,
            0x9a00, 0x9c00, 0x6287, 0xa000, 0x5e87, 0x5887, 0xa600, 0x5487, 0xaa00, 0xac00, 0x5287,
            0x4c87, 0xb200, 0xb400, 0x4a87, 0xb800, 0x4687, 0x4087, 0xbe00, 0xc000, 0x3e87, 0x3887,
            0xc600, 0x3487, 0xca00, 0xcc00, 0x3287, 0x2c87, 0xd200, 0xd400, 0x2a87, 0xd800, 0x2687,
            0x2087, 0xde00, 0x1c87, 0xe200, 0xe400, 0x1a87, 0xe800, 0x1687, 0x1087, 0xee00, 0xf000,
            0x0e87, 0x0887, 0xf600, 0x0487, 0xfa00, 0xfc00, 0x0287, 0xf90e, 0x0789, 0x0189, 0xff0e,
            0x0d89, 0xf30e, 0xf50e, 0x0b89, 0x1589, 0xeb0e, 0xed0e, 0x1389, 0xe10e, 0x1f89, 0x1989,
            0xe70e, 0x2589, 0xdb0e, 0xdd0e, 0x2389, 0xd10e, 0x2f89, 0x2989, 0xd70e, 0xc90e, 0x3789,
            0x3189, 0xcf0e, 0x3d89, 0xc30e, 0xc50e, 0x3b89, 0x4589, 0xbb0e, 0xbd0e, 0x4389, 0xb10e,
            0x4f89, 0x4989, 0xb70e, 0xa90e, 0x5789, 0x5189, 0xaf0e, 0x5d89, 0xa30e, 0xa50e, 0x5b89,
            0x990e, 0x6789, 0x6189, 0x9f0e, 0x6d89, 0x930e, 0x950e, 0x6b89, 0x7589, 0x8b0e, 0x8d0e,
            0x7389, 0x810e, 0x7f89, 0x7989, 0x870e, 0x8589, 0x7b0e, 0x7d0e, 0x8389, 0x710e, 0x8f89,
            0x8989, 0x770e, 0x690e, 0x9789, 0x9189, 0x6f0e, 0x9d89, 0x630e, 0x650e, 0x9b89, 0x590e,
            0xa789, 0xa189, 0x5f0e, 0xad89, 0x530e, 0x550e, 0xab89, 0xb589, 0x4b0e, 0x4d0e, 0xb389,
            0x410e, 0xbf89, 0xb989, 0x470e, 0x390e, 0xc789, 0xc189, 0x3f0e, 0xcd89, 0x330e, 0x350e,
            0xcb89, 0xd589, 0x2b0e, 0x2d0e, 0xd389, 0x210e, 0xdf89, 0xd989, 0x270e, 0xe589, 0x1b0e,
            0x1d0e, 0xe389, 0x110e, 0xef89, 0xe989, 0x170e, 0x090e, 0xf789, 0xf189, 0x0f0e, 0xfd89,
            0x030e, 0x050e, 0xfb89,
        ],
    ];

    pub static CRC16_DNP_TABLE: [[u16; 256]; 16] = [
        [
            0x0000, 0x365e, 0x6cbc, 0x5ae2, 0xd978, 0xef26, 0xb5c4, 0x839a, 0xff89, 0xc9d7, 0x9335,
            0xa56b, 0x26f1, 0x10af, 0x4a4d, 0x7c13, 0xb26b, 0x8435, 0xded7, 0xe889, 0x6b13, 0x5d4d,
            0x07af, 0x31f1, 0x4de2, 0x7bbc, 0x215e, 0x1700, 0x949a, 0xa2c4, 0xf826, 0xce78, 0x29af,
            0x1ff1, 0x4513, 0x734d, 0xf0d7, 0xc689, 0x9c6b, 0xaa35, 0xd626, 0xe078, 0xba9a, 0x8cc4,
            0x0f5e, 0x3900, 0x63e2, 0x55bc, 0x9bc4, 0xad9a, 0xf778, 0xc126, 0x42bc, 0x74e2, 0x2e00,
            0x185e, 0x644d, 0x5213, 0x08f1, 0x3eaf, 0xbd35, 0x8b6b, 0xd189, 0xe7d7, 0x535e, 0x6500,
            0x3fe2, 0x09bc, 0x8a26, 0xbc78, 0xe69a, 0xd0c4, 0xacd7, 0x9a89, 0xc06b, 0xf635, 0x75af,
            0x43f1, 0x1913, 0x2f4d, 0xe135, 0xd76b, 0x8d89, 0xbbd7, 0x384d, 0x0e13, 0x54f1, 0x62af,
            0x1ebc, 0x28e2, 0x7200, 0x445e, 0xc7c4, 0xf19a, 0xab78, 0x9d26, 0x7af1, 0x4caf, 0x164d,
            0x2013, 0xa389, 0x95d7, 0xcf35, 0xf96b, 0x8578, 0xb326, 0xe9c4, 0xdf9a, 0x5c00, 0x6a5e,
            0x30bc, 0x06e2, 0xc89a, 0xfec4, 0xa426, 0x9278, 0x11e2, 0x27bc, 0x7d5e, 0x4b00, 0x3713,
            0x014d, 0x5baf, 0x6df1, 0xee6b, 0xd835, 0x82d7, 0xb489, 0xa6bc, 0x90e2, 0xca00, 0xfc5e,
            0x7fc4, 0x499a, 0x1378, 0x2526, 0x5935, 0x6f6b, 0x3589, 0x03d7, 0x804d, 0xb613, 0xecf1,
            0xdaaf, 0x14d7, 0x2289, 0x786b, 0x4e35, 0xcdaf, 0xfbf1, 0xa113, 0x974d, 0xeb5e, 0xdd00,
            0x87e2, 0xb1bc, 0x3226, 0x0478, 0x5e9a, 0x68c4, 0x8f13, 0xb94d, 0xe3af, 0xd5f1, 0x566b,
            0x6035, 0x3ad7, 0x0c89, 0x709a, 0x46c4, 0x1c26, 0x2a78, 0xa9e2, 0x9fbc, 0xc55e, 0xf300,
            0x3d78, 0x0b26, 0x51c4, 0x679a, 0xe400, 0xd25e, 0x88bc, 0xbee2, 0xc2f1, 0xf4af, 0xae4d,
            0x9813, 0x1b89, 0x2dd7, 0x7735, 0x416b, 0xf5e2, 0xc3bc, 0x995e, 0xaf00, 0x2c9a, 0x1ac4,
            0x4026, 0x7678, 0x0a6b, 0x3c35, 0x66d7, 0x5089, 0xd313, 0xe54d, 0xbfaf, 0x89f1, 0x4789,
            0x71d7, 0x2b35, 0x1d6b, 0x9ef1, 0xa8af, 0xf24d, 0xc413, 0xb800, 0x8e5e, 0xd4bc, 0xe2e2,
            0x6178, 0x5726, 0x0dc4, 0x3b9a, 0xdc4d, 0xea13, 0xb0f1, 0x86af, 0x0535, 0x336b, 0x6989,
            0x5fd7, 0x23c4, 0x159a, 0x4f78, 0x7926, 0xfabc, 0xcce2, 0x9600, 0xa05e, 0x6e26, 0x5878,
            0x029a, 0x34c4, 0xb75e, 0x8100, 0xdbe2, 0xedbc, 0x91af, 0xa7f1, 0xfd13, 0xcb4d, 0x48d7,
            0x7e89, 0x246b, 0x1235,
        ],
        [
            0x0000, 0xab4e, 0x1be5, 0xb0ab, 0x37ca, 0x9c84, 0x2c2f, 0x8761, 0x6f94, 0xc4da, 0x7471,
            0xdf3f, 0x585e, 0xf310, 0x43bb, 0xe8f5, 0xdf28, 0x7466, 0xc4cd, 0x6f83, 0xe8e2, 0x43ac,
            0xf307, 0x5849, 0xb0bc, 0x1bf2, 0xab59, 0x0017, 0x8776, 0x2c38, 0x9c93, 0x37dd, 0xf329,
            0x5867, 0xe8cc, 0x4382, 0xc4e3, 0x6fad, 0xdf06, 0x7448, 0x9cbd, 0x37f3, 0x8758, 0x2c16,
            0xab77, 0x0039, 0xb092, 0x1bdc, 0x2c01, 0x874f, 0x37e4, 0x9caa, 0x1bcb, 0xb085, 0x002e,
            0xab60, 0x4395, 0xe8db, 0x5870, 0xf33e, 0x745f, 0xdf11, 0x6fba, 0xc4f4, 0xab2b, 0x0065,
            0xb0ce, 0x1b80, 0x9ce1, 0x37af, 0x8704, 0x2c4a, 0xc4bf, 0x6ff1, 0xdf5a, 0x7414, 0xf375,
            0x583b, 0xe890, 0x43de, 0x7403, 0xdf4d, 0x6fe6, 0xc4a8, 0x43c9, 0xe887, 0x582c, 0xf362,
            0x1b97, 0xb0d9, 0x0072, 0xab3c, 0x2c5d, 0x8713, 0x37b8, 0x9cf6, 0x5802, 0xf34c, 0x43e7,
            0xe8a9, 0x6fc8, 0xc486, 0x742d, 0xdf63, 0x3796, 0x9cd8, 0x2c73, 0x873d, 0x005c, 0xab12,
            0x1bb9, 0xb0f7, 0x872a, 0x2c64, 0x9ccf, 0x3781, 0xb0e0, 0x1bae, 0xab05, 0x004b, 0xe8be,
            0x43f0, 0xf35b, 0x5815, 0xdf74, 0x743a, 0xc491, 0x6fdf, 0x1b2f, 0xb061, 0x00ca, 0xab84,
            0x2ce5, 0x87ab, 0x3700, 0x9c4e, 0x74bb, 0xdff5, 0x6f5e, 0xc410, 0x4371, 0xe83f, 0x5894,
            0xf3da, 0xc407, 0x6f49, 0xdfe2, 0x74ac, 0xf3cd, 0x5883, 0xe828, 0x4366, 0xab93, 0x00dd,
            0xb076, 0x1b38, 0x9c59, 0x3717, 0x87bc, 0x2cf2, 0xe806, 0x4348, 0xf3e3, 0x58ad, 0xdfcc,
            0x7482, 0xc429, 0x6f67, 0x8792, 0x2cdc, 0x9c77, 0x3739, 0xb058, 0x1b16, 0xabbd, 0x00f3,
            0x372e, 0x9c60, 0x2ccb, 0x8785, 0x00e4, 0xabaa, 0x1b01, 0xb04f, 0x58ba, 0xf3f4, 0x435f,
            0xe811, 0x6f70, 0xc43e, 0x7495, 0xdfdb, 0xb004, 0x1b4a, 0xabe1, 0x00af, 0x87ce, 0x2c80,
            0x9c2b, 0x3765, 0xdf90, 0x74de, 0xc475, 0x6f3b, 0xe85a, 0x4314, 0xf3bf, 0x58f1, 0x6f2c,
            0xc462, 0x74c9, 0xdf87, 0x58e6, 0xf3a8, 0x4303, 0xe84d, 0x00b8, 0xabf6, 0x1b5d, 0xb013,
            0x3772, 0x9c3c, 0x2c97, 0x87d9, 0x432d, 0xe863, 0x58c8, 0xf386, 0x74e7, 0xdfa9, 0x6f02,
            0xc44c, 0x2cb9, 0x87f7, 0x375c, 0x9c12, 0x1b73, 0xb03d, 0x0096, 0xabd8, 0x9c05, 0x374b,
            0x87e0, 0x2cae, 0xabcf, 0x0081, 0xb02a, 0x1b64, 0xf391, 0x58df, 0xe874, 0x433a, 0xc45b,
            0x6f15, 0xdfbe, 0x74f0,
        ],
        [
            0x0000, 0x19b8, 0x3370, 0x2ac8, 0x66e0, 0x7f58, 0x5590, 0x4c28, 0xcdc0, 0xd478, 0xfeb0,
            0xe708, 0xab20, 0xb298, 0x9850, 0x81e8, 0xd6f9, 0xcf41, 0xe589, 0xfc31, 0xb019, 0xa9a1,
            0x8369, 0x9ad1, 0x1b39, 0x0281, 0x2849, 0x31f1, 0x7dd9, 0x6461, 0x4ea9, 0x5711, 0xe08b,
            0xf933, 0xd3fb, 0xca43, 0x866b, 0x9fd3, 0xb51b, 0xaca3, 0x2d4b, 0x34f3, 0x1e3b, 0x0783,
            0x4bab, 0x5213, 0x78db, 0x6163, 0x3672, 0x2fca, 0x0502, 0x1cba, 0x5092, 0x492a, 0x63e2,
            0x7a5a, 0xfbb2, 0xe20a, 0xc8c2, 0xd17a, 0x9d52, 0x84ea, 0xae22, 0xb79a, 0x8c6f, 0x95d7,
            0xbf1f, 0xa6a7, 0xea8f, 0xf337, 0xd9ff, 0xc047, 0x41af, 0x5817, 0x72df, 0x6b67, 0x274f,
            0x3ef7, 0x143f, 0x0d87, 0x5a96, 0x432e, 0x69e6, 0x705e, 0x3c76, 0x25ce, 0x0f06, 0x16be,
            0x9756, 0x8eee, 0xa426, 0xbd9e, 0xf1b6, 0xe80e, 0xc2c6, 0xdb7e, 0x6ce4, 0x755c, 0x5f94,
            0x462c, 0x0a04, 0x13bc, 0x3974, 0x20cc, 0xa124, 0xb89c, 0x9254, 0x8bec, 0xc7c4, 0xde7c,
            0xf4b4, 0xed0c, 0xba1d, 0xa3a5, 0x896d, 0x90d5, 0xdcfd, 0xc545, 0xef8d, 0xf635, 0x77dd,
            0x6e65, 0x44ad, 0x5d15, 0x113d, 0x0885, 0x224d, 0x3bf5, 0x55a7, 0x4c1f, 0x66d7, 0x7f6f,
            0x3347, 0x2aff, 0x0037, 0x198f, 0x9867, 0x81df, 0xab17, 0xb2af, 0xfe87, 0xe73f, 0xcdf7,
            0xd44f, 0x835e, 0x9ae6, 0xb02e, 0xa996, 0xe5be, 0xfc06, 0xd6ce, 0xcf76, 0x4e9e, 0x5726,
            0x7dee, 0x6456, 0x287e, 0x31c6, 0x1b0e, 0x02b6, 0xb52c, 0xac94, 0x865c, 0x9fe4, 0xd3cc,
            0xca74, 0xe0bc, 0xf904, 0x78ec, 0x6154, 0x4b9c, 0x5224, 0x1e0c, 0x07b4, 0x2d7c, 0x34c4,
            0x63d5, 0x7a6d, 0x50a5, 0x491d, 0x0535, 0x1c8d, 0x3645, 0x2ffd, 0xae15, 0xb7ad, 0x9d65,
            0x84dd, 0xc8f5, 0xd14d, 0xfb85, 0xe23d, 0xd9c8, 0xc070, 0xeab8, 0xf300, 0xbf28, 0xa690,
            0x8c58, 0x95e0, 0x1408, 0x0db0, 0x2778, 0x3ec0, 0x72e8, 0x6b50, 0x4198, 0x5820, 0x0f31,
            0x1689, 0x3c41, 0x25f9, 0x69d1, 0x7069, 0x5aa1, 0x4319, 0xc2f1, 0xdb49, 0xf181, 0xe839,
            0xa411, 0xbda9, 0x9761, 0x8ed9, 0x3943, 0x20fb, 0x0a33, 0x138b, 0x5fa3, 0x461b, 0x6cd3,
            0x756b, 0xf483, 0xed3b, 0xc7f3, 0xde4b, 0x9263, 0x8bdb, 0xa113, 0xb8ab, 0xefba, 0xf602,
            0xdcca, 0xc572, 0x895a, 0x90e2, 0xba2a, 0xa392, 0x227a, 0x3bc2, 0x110a, 0x08b2, 0x449a,
            0x5d22, 0x77ea, 0x6e52,
        ],
        [
            0x0000, 0xc2e8, 0xc8a9, 0x0a41, 0xdc2b, 0x1ec3, 0x1482, 0xd66a, 0xf52f, 0x37c7, 0x3d86,
            0xff6e, 0x2904, 0xebec, 0xe1ad, 0x2345, 0xa727, 0x65cf, 0x6f8e, 0xad66, 0x7b0c, 0xb9e4,
            0xb3a5, 0x714d, 0x5208, 0x90e0, 0x9aa1, 0x5849, 0x8e23, 0x4ccb, 0x468a, 0x8462, 0x0337,
            0xc1df, 0xcb9e, 0x0976, 0xdf1c, 0x1df4, 0x17b5, 0xd55d, 0xf618, 0x34f0, 0x3eb1, 0xfc59,
            0x2a33, 0xe8db, 0xe29a, 0x2072, 0xa410, 0x66f8, 0x6cb9, 0xae51, 0x783b, 0xbad3, 0xb092,
            0x727a, 0x513f, 0x93d7, 0x9996, 0x5b7e, 0x8d14, 0x4ffc, 0x45bd, 0x8755, 0x066e, 0xc486,
            0xcec7, 0x0c2f, 0xda45, 0x18ad, 0x12ec, 0xd004, 0xf341, 0x31a9, 0x3be8, 0xf900, 0x2f6a,
            0xed82, 0xe7c3, 0x252b, 0xa149, 0x63a1, 0x69e0, 0xab08, 0x7d62, 0xbf8a, 0xb5cb, 0x7723,
            0x5466, 0x968e, 0x9ccf, 0x5e27, 0x884d, 0x4aa5, 0x40e4, 0x820c, 0x0559, 0xc7b1, 0xcdf0,
            0x0f18, 0xd972, 0x1b9a, 0x11db, 0xd333, 0xf076, 0x329e, 0x38df, 0xfa37, 0x2c5d, 0xeeb5,
            0xe4f4, 0x261c, 0xa27e, 0x6096, 0x6ad7, 0xa83f, 0x7e55, 0xbcbd, 0xb6fc, 0x7414, 0x5751,
            0x95b9, 0x9ff8, 0x5d10, 0x8b7a, 0x4992, 0x43d3, 0x813b, 0x0cdc, 0xce34, 0xc475, 0x069d,
            0xd0f7, 0x121f, 0x185e, 0xdab6, 0xf9f3, 0x3b1b, 0x315a, 0xf3b2, 0x25d8, 0xe730, 0xed71,
            0x2f99, 0xabfb, 0x6913, 0x6352, 0xa1ba, 0x77d0, 0xb538, 0xbf79, 0x7d91, 0x5ed4, 0x9c3c,
            0x967d, 0x5495, 0x82ff, 0x4017, 0x4a56, 0x88be, 0x0feb, 0xcd03, 0xc742, 0x05aa, 0xd3c0,
            0x1128, 0x1b69, 0xd981, 0xfac4, 0x382c, 0x326d, 0xf085, 0x26ef, 0xe407, 0xee46, 0x2cae,
            0xa8cc, 0x6a24, 0x6065, 0xa28d, 0x74e7, 0xb60f, 0xbc4e, 0x7ea6, 0x5de3, 0x9f0b, 0x954a,
            0x57a2, 0x81c8, 0x4320, 0x4961, 0x8b89, 0x0ab2, 0xc85a, 0xc21b, 0x00f3, 0xd699, 0x1471,
            0x1e30, 0xdcd8, 0xff9d, 0x3d75, 0x3734, 0xf5dc, 0x23b6, 0xe15e, 0xeb1f, 0x29f7, 0xad95,
            0x6f7d, 0x653c, 0xa7d4, 0x71be, 0xb356, 0xb917, 0x7bff, 0x58ba, 0x9a52, 0x9013, 0x52fb,
            0x8491, 0x4679, 0x4c38, 0x8ed0, 0x0985, 0xcb6d, 0xc12c, 0x03c4, 0xd5ae, 0x1746, 0x1d07,
            0xdfef, 0xfcaa, 0x3e42, 0x3403, 0xf6eb, 0x2081, 0xe269, 0xe828, 0x2ac0, 0xaea2, 0x6c4a,
            0x660b, 0xa4e3, 0x7289, 0xb061, 0xba20, 0x78c8, 0x5b8d, 0x9965, 0x9324, 0x51cc, 0x87a6,
            0x454e, 0x4f0f, 0x8de7,
        ],
        [
            0x0000, 0x2306, 0x460c, 0x650a, 0x8c18, 0xaf1e, 0xca14, 0xe912, 0x5549, 0x764f, 0x1345,
            0x3043, 0xd951, 0xfa57, 0x9f5d, 0xbc5b, 0xaa92, 0x8994, 0xec9e, 0xcf98, 0x268a, 0x058c,
            0x6086, 0x4380, 0xffdb, 0xdcdd, 0xb9d7, 0x9ad1, 0x73c3, 0x50c5, 0x35cf, 0x16c9, 0x185d,
            0x3b5b, 0x5e51, 0x7d57, 0x9445, 0xb743, 0xd249, 0xf14f, 0x4d14, 0x6e12, 0x0b18, 0x281e,
            0xc10c, 0xe20a, 0x8700, 0xa406, 0xb2cf, 0x91c9, 0xf4c3, 0xd7c5, 0x3ed7, 0x1dd1, 0x78db,
            0x5bdd, 0xe786, 0xc480, 0xa18a, 0x828c, 0x6b9e, 0x4898, 0x2d92, 0x0e94, 0x30ba, 0x13bc,
            0x76b6, 0x55b0, 0xbca2, 0x9fa4, 0xfaae, 0xd9a8, 0x65f3, 0x46f5, 0x23ff, 0x00f9, 0xe9eb,
            0xcaed, 0xafe7, 0x8ce1, 0x9a28, 0xb92e, 0xdc24, 0xff22, 0x1630, 0x3536, 0x503c, 0x733a,
            0xcf61, 0xec67, 0x896d, 0xaa6b, 0x4379, 0x607f, 0x0575, 0x2673, 0x28e7, 0x0be1, 0x6eeb,
            0x4ded, 0xa4ff, 0x87f9, 0xe2f3, 0xc1f5, 0x7dae, 0x5ea8, 0x3ba2, 0x18a4, 0xf1b6, 0xd2b0,
            0xb7ba, 0x94bc, 0x8275, 0xa173, 0xc479, 0xe77f, 0x0e6d, 0x2d6b, 0x4861, 0x6b67, 0xd73c,
            0xf43a, 0x9130, 0xb236, 0x5b24, 0x7822, 0x1d28, 0x3e2e, 0x6174, 0x4272, 0x2778, 0x047e,
            0xed6c, 0xce6a, 0xab60, 0x8866, 0x343d, 0x173b, 0x7231, 0x5137, 0xb825, 0x9b23, 0xfe29,
            0xdd2f, 0xcbe6, 0xe8e0, 0x8dea, 0xaeec, 0x47fe, 0x64f8, 0x01f2, 0x22f4, 0x9eaf, 0xbda9,
            0xd8a3, 0xfba5, 0x12b7, 0x31b1, 0x54bb, 0x77bd, 0x7929, 0x5a2f, 0x3f25, 0x1c23, 0xf531,
            0xd637, 0xb33d, 0x903b, 0x2c60, 0x0f66, 0x6a6c, 0x496a, 0xa078, 0x837e, 0xe674, 0xc572,
            0xd3bb, 0xf0bd, 0x95b7, 0xb6b1, 0x5fa3, 0x7ca5, 0x19af, 0x3aa9, 0x86f2, 0xa5f4, 0xc0fe,
            0xe3f8, 0x0aea, 0x29ec, 0x4ce6, 0x6fe0, 0x51ce, 0x72c8, 0x17c2, 0x34c4, 0xddd6, 0xfed0,
            0x9bda, 0xb8dc, 0x0487, 0x2781, 0x428b, 0x618d, 0x889f, 0xab99, 0xce93, 0xed95, 0xfb5c,
            0xd85a, 0xbd50, 0x9e56, 0x7744, 0x5442, 0x3148, 0x124e, 0xae15, 0x8d13, 0xe819, 0xcb1f,
            0x220d, 0x010b, 0x6401, 0x4707, 0x4993, 0x6a95, 0x0f9f, 0x2c99, 0xc58b, 0xe68d, 0x8387,
            0xa081, 0x1cda, 0x3fdc, 0x5ad6, 0x79d0, 0x90c2, 0xb3c4, 0xd6ce, 0xf5c8, 0xe301, 0xc007,
            0xa50d, 0x860b, 0x6f19, 0x4c1f, 0x2915, 0x0a13, 0xb648, 0x954e, 0xf044, 0xd342, 0x3a50,
            0x1956, 0x7c5c, 0x5f5a,
        ],
        [
            0x0000, 0xb5e7, 0x26b7, 0x9350, 0x4d6e, 0xf889, 0x6bd9, 0xde3e, 0x9adc, 0x2f3b, 0xbc6b,
            0x098c, 0xd7b2, 0x6255, 0xf105, 0x44e2, 0x78c1, 0xcd26, 0x5e76, 0xeb91, 0x35af, 0x8048,
            0x1318, 0xa6ff, 0xe21d, 0x57fa, 0xc4aa, 0x714d, 0xaf73, 0x1a94, 0x89c4, 0x3c23, 0xf182,
            0x4465, 0xd735, 0x62d2, 0xbcec, 0x090b, 0x9a5b, 0x2fbc, 0x6b5e, 0xdeb9, 0x4de9, 0xf80e,
            0x2630, 0x93d7, 0x0087, 0xb560, 0x8943, 0x3ca4, 0xaff4, 0x1a13, 0xc42d, 0x71ca, 0xe29a,
            0x577d, 0x139f, 0xa678, 0x3528, 0x80cf, 0x5ef1, 0xeb16, 0x7846, 0xcda1, 0xae7d, 0x1b9a,
            0x88ca, 0x3d2d, 0xe313, 0x56f4, 0xc5a4, 0x7043, 0x34a1, 0x8146, 0x1216, 0xa7f1, 0x79cf,
            0xcc28, 0x5f78, 0xea9f, 0xd6bc, 0x635b, 0xf00b, 0x45ec, 0x9bd2, 0x2e35, 0xbd65, 0x0882,
            0x4c60, 0xf987, 0x6ad7, 0xdf30, 0x010e, 0xb4e9, 0x27b9, 0x925e, 0x5fff, 0xea18, 0x7948,
            0xccaf, 0x1291, 0xa776, 0x3426, 0x81c1, 0xc523, 0x70c4, 0xe394, 0x5673, 0x884d, 0x3daa,
            0xaefa, 0x1b1d, 0x273e, 0x92d9, 0x0189, 0xb46e, 0x6a50, 0xdfb7, 0x4ce7, 0xf900, 0xbde2,
            0x0805, 0x9b55, 0x2eb2, 0xf08c, 0x456b, 0xd63b, 0x63dc, 0x1183, 0xa464, 0x3734, 0x82d3,
            0x5ced, 0xe90a, 0x7a5a, 0xcfbd, 0x8b5f, 0x3eb8, 0xade8, 0x180f, 0xc631, 0x73d6, 0xe086,
            0x5561, 0x6942, 0xdca5, 0x4ff5, 0xfa12, 0x242c, 0x91cb, 0x029b, 0xb77c, 0xf39e, 0x4679,
            0xd529, 0x60ce, 0xbef0, 0x0b17, 0x9847, 0x2da0, 0xe001, 0x55e6, 0xc6b6, 0x7351, 0xad6f,
            0x1888, 0x8bd8, 0x3e3f, 0x7add, 0xcf3a, 0x5c6a, 0xe98d, 0x37b3, 0x8254, 0x1104, 0xa4e3,
            0x98c0, 0x2d27, 0xbe77, 0x0b90, 0xd5ae, 0x6049, 0xf319, 0x46fe, 0x021c, 0xb7fb, 0x24ab,
            0x914c, 0x4f72, 0xfa95, 0x69c5, 0xdc22, 0xbffe, 0x0a19, 0x9949, 0x2cae, 0xf290, 0x4777,
            0xd427, 0x61c0, 0x2522, 0x90c5, 0x0395, 0xb672, 0x684c, 0xddab, 0x4efb, 0xfb1c, 0xc73f,
            0x72d8, 0xe188, 0x546f, 0x8a51, 0x3fb6, 0xace6, 0x1901, 0x5de3, 0xe804, 0x7b54, 0xceb3,
            0x108d, 0xa56a, 0x363a, 0x83dd, 0x4e7c, 0xfb9b, 0x68cb, 0xdd2c, 0x0312, 0xb6f5, 0x25a5,
            0x9042, 0xd4a0, 0x6147, 0xf217, 0x47f0, 0x99ce, 0x2c29, 0xbf79, 0x0a9e, 0x36bd, 0x835a,
            0x100a, 0xa5ed, 0x7bd3, 0xce34, 0x5d64, 0xe883, 0xac61, 0x1986, 0x8ad6, 0x3f31, 0xe10f,
            0x54e8, 0xc7b8, 0x725f,
        ],
        [
            0x0000, 0x5f62, 0xbec4, 0xe1a6, 0x30f1, 0x6f93, 0x8e35, 0xd157, 0x61e2, 0x3e80, 0xdf26,
            0x8044, 0x5113, 0x0e71, 0xefd7, 0xb0b5, 0xc3c4, 0x9ca6, 0x7d00, 0x2262, 0xf335, 0xac57,
            0x4df1, 0x1293, 0xa226, 0xfd44, 0x1ce2, 0x4380, 0x92d7, 0xcdb5, 0x2c13, 0x7371, 0xcaf1,
            0x9593, 0x7435, 0x2b57, 0xfa00, 0xa562, 0x44c4, 0x1ba6, 0xab13, 0xf471, 0x15d7, 0x4ab5,
            0x9be2, 0xc480, 0x2526, 0x7a44, 0x0935, 0x5657, 0xb7f1, 0xe893, 0x39c4, 0x66a6, 0x8700,
            0xd862, 0x68d7, 0x37b5, 0xd613, 0x8971, 0x5826, 0x0744, 0xe6e2, 0xb980, 0xd89b, 0x87f9,
            0x665f, 0x393d, 0xe86a, 0xb708, 0x56ae, 0x09cc, 0xb979, 0xe61b, 0x07bd, 0x58df, 0x8988,
            0xd6ea, 0x374c, 0x682e, 0x1b5f, 0x443d, 0xa59b, 0xfaf9, 0x2bae, 0x74cc, 0x956a, 0xca08,
            0x7abd, 0x25df, 0xc479, 0x9b1b, 0x4a4c, 0x152e, 0xf488, 0xabea, 0x126a, 0x4d08, 0xacae,
            0xf3cc, 0x229b, 0x7df9, 0x9c5f, 0xc33d, 0x7388, 0x2cea, 0xcd4c, 0x922e, 0x4379, 0x1c1b,
            0xfdbd, 0xa2df, 0xd1ae, 0x8ecc, 0x6f6a, 0x3008, 0xe15f, 0xbe3d, 0x5f9b, 0x00f9, 0xb04c,
            0xef2e, 0x0e88, 0x51ea, 0x80bd, 0xdfdf, 0x3e79, 0x611b, 0xfc4f, 0xa32d, 0x428b, 0x1de9,
            0xccbe, 0x93dc, 0x727a, 0x2d18, 0x9dad, 0xc2cf, 0x2369, 0x7c0b, 0xad5c, 0xf23e, 0x1398,
            0x4cfa, 0x3f8b, 0x60e9, 0x814f, 0xde2d, 0x0f7a, 0x5018, 0xb1be, 0xeedc, 0x5e69, 0x010b,
            0xe0ad, 0xbfcf, 0x6e98, 0x31fa, 0xd05c, 0x8f3e, 0x36be, 0x69dc, 0x887a, 0xd718, 0x064f,
            0x592d, 0xb88b, 0xe7e9, 0x575c, 0x083e, 0xe998, 0xb6fa, 0x67ad, 0x38cf, 0xd969, 0x860b,
            0xf57a, 0xaa18, 0x4bbe, 0x14dc, 0xc58b, 0x9ae9, 0x7b4f, 0x242d, 0x9498, 0xcbfa, 0x2a5c,
            0x753e, 0xa469, 0xfb0b, 0x1aad, 0x45cf, 0x24d4, 0x7bb6, 0x9a10, 0xc572, 0x1425, 0x4b47,
            0xaae1, 0xf583, 0x4536, 0x1a54, 0xfbf2, 0xa490, 0x75c7, 0x2aa5, 0xcb03, 0x9461, 0xe710,
            0xb872, 0x59d4, 0x06b6, 0xd7e1, 0x8883, 0x6925, 0x3647, 0x86f2, 0xd990, 0x3836, 0x6754,
            0xb603, 0xe961, 0x08c7, 0x57a5, 0xee25, 0xb147, 0x50e1, 0x0f83, 0xded4, 0x81b6, 0x6010,
            0x3f72, 0x8fc7, 0xd0a5, 0x3103, 0x6e61, 0xbf36, 0xe054, 0x01f2, 0x5e90, 0x2de1, 0x7283,
            0x9325, 0xcc47, 0x1d10, 0x4272, 0xa3d4, 0xfcb6, 0x4c03, 0x1361, 0xf2c7, 0xada5, 0x7cf2,
            0x2390, 0xc236, 0x9d54,
        ],
        [
            0x0000, 0x1612, 0x2c24, 0x3a36, 0x5848, 0x4e5a, 0x746c, 0x627e, 0xb090, 0xa682, 0x9cb4,
            0x8aa6, 0xe8d8, 0xfeca, 0xc4fc, 0xd2ee, 0x2c59, 0x3a4b, 0x007d, 0x166f, 0x7411, 0x6203,
            0x5835, 0x4e27, 0x9cc9, 0x8adb, 0xb0ed, 0xa6ff, 0xc481, 0xd293, 0xe8a5, 0xfeb7, 0x58b2,
            0x4ea0, 0x7496, 0x6284, 0x00fa, 0x16e8, 0x2cde, 0x3acc, 0xe822, 0xfe30, 0xc406, 0xd214,
            0xb06a, 0xa678, 0x9c4e, 0x8a5c, 0x74eb, 0x62f9, 0x58cf, 0x4edd, 0x2ca3, 0x3ab1, 0x0087,
            0x1695, 0xc47b, 0xd269, 0xe85f, 0xfe4d, 0x9c33, 0x8a21, 0xb017, 0xa605, 0xb164, 0xa776,
            0x9d40, 0x8b52, 0xe92c, 0xff3e, 0xc508, 0xd31a, 0x01f4, 0x17e6, 0x2dd0, 0x3bc2, 0x59bc,
            0x4fae, 0x7598, 0x638a, 0x9d3d, 0x8b2f, 0xb119, 0xa70b, 0xc575, 0xd367, 0xe951, 0xff43,
            0x2dad, 0x3bbf, 0x0189, 0x179b, 0x75e5, 0x63f7, 0x59c1, 0x4fd3, 0xe9d6, 0xffc4, 0xc5f2,
            0xd3e0, 0xb19e, 0xa78c, 0x9dba, 0x8ba8, 0x5946, 0x4f54, 0x7562, 0x6370, 0x010e, 0x171c,
            0x2d2a, 0x3b38, 0xc58f, 0xd39d, 0xe9ab, 0xffb9, 0x9dc7, 0x8bd5, 0xb1e3, 0xa7f1, 0x751f,
            0x630d, 0x593b, 0x4f29, 0x2d57, 0x3b45, 0x0173, 0x1761, 0x2fb1, 0x39a3, 0x0395, 0x1587,
            0x77f9, 0x61eb, 0x5bdd, 0x4dcf, 0x9f21, 0x8933, 0xb305, 0xa517, 0xc769, 0xd17b, 0xeb4d,
            0xfd5f, 0x03e8, 0x15fa, 0x2fcc, 0x39de, 0x5ba0, 0x4db2, 0x7784, 0x6196, 0xb378, 0xa56a,
            0x9f5c, 0x894e, 0xeb30, 0xfd22, 0xc714, 0xd106, 0x7703, 0x6111, 0x5b27, 0x4d35, 0x2f4b,
            0x3959, 0x036f, 0x157d, 0xc793, 0xd181, 0xebb7, 0xfda5, 0x9fdb, 0x89c9, 0xb3ff, 0xa5ed,
            0x5b5a, 0x4d48, 0x777e, 0x616c, 0x0312, 0x1500, 0x2f36, 0x3924, 0xebca, 0xfdd8, 0xc7ee,
            0xd1fc, 0xb382, 0xa590, 0x9fa6, 0x89b4, 0x9ed5, 0x88c7, 0xb2f1, 0xa4e3, 0xc69d, 0xd08f,
            0xeab9, 0xfcab, 0x2e45, 0x3857, 0x0261, 0x1473, 0x760d, 0x601f, 0x5a29, 0x4c3b, 0xb28c,
            0xa49e, 0x9ea8, 0x88ba, 0xeac4, 0xfcd6, 0xc6e0, 0xd0f2, 0x021c, 0x140e, 0x2e38, 0x382a,
            0x5a54, 0x4c46, 0x7670, 0x6062, 0xc667, 0xd075, 0xea43, 0xfc51, 0x9e2f, 0x883d, 0xb20b,
            0xa419, 0x76f7, 0x60e5, 0x5ad3, 0x4cc1, 0x2ebf, 0x38ad, 0x029b, 0x1489, 0xea3e, 0xfc2c,
            0xc61a, 0xd008, 0xb276, 0xa464, 0x9e52, 0x8840, 0x5aae, 0x4cbc, 0x768a, 0x6098, 0x02e6,
            0x14f4, 0x2ec2, 0x38d0,
        ],
        [
            0x0000, 0xdec1, 0xf0fb, 0x2e3a, 0xac8f, 0x724e, 0x5c74, 0x82b5, 0x1467, 0xcaa6, 0xe49c,
            0x3a5d, 0xb8e8, 0x6629, 0x4813, 0x96d2, 0x28ce, 0xf60f, 0xd835, 0x06f4, 0x8441, 0x5a80,
            0x74ba, 0xaa7b, 0x3ca9, 0xe268, 0xcc52, 0x1293, 0x9026, 0x4ee7, 0x60dd, 0xbe1c, 0x519c,
            0x8f5d, 0xa167, 0x7fa6, 0xfd13, 0x23d2, 0x0de8, 0xd329, 0x45fb, 0x9b3a, 0xb500, 0x6bc1,
            0xe974, 0x37b5, 0x198f, 0xc74e, 0x7952, 0xa793, 0x89a9, 0x5768, 0xd5dd, 0x0b1c, 0x2526,
            0xfbe7, 0x6d35, 0xb3f4, 0x9dce, 0x430f, 0xc1ba, 0x1f7b, 0x3141, 0xef80, 0xa338, 0x7df9,
            0x53c3, 0x8d02, 0x0fb7, 0xd176, 0xff4c, 0x218d, 0xb75f, 0x699e, 0x47a4, 0x9965, 0x1bd0,
            0xc511, 0xeb2b, 0x35ea, 0x8bf6, 0x5537, 0x7b0d, 0xa5cc, 0x2779, 0xf9b8, 0xd782, 0x0943,
            0x9f91, 0x4150, 0x6f6a, 0xb1ab, 0x331e, 0xeddf, 0xc3e5, 0x1d24, 0xf2a4, 0x2c65, 0x025f,
            0xdc9e, 0x5e2b, 0x80ea, 0xaed0, 0x7011, 0xe6c3, 0x3802, 0x1638, 0xc8f9, 0x4a4c, 0x948d,
            0xbab7, 0x6476, 0xda6a, 0x04ab, 0x2a91, 0xf450, 0x76e5, 0xa824, 0x861e, 0x58df, 0xce0d,
            0x10cc, 0x3ef6, 0xe037, 0x6282, 0xbc43, 0x9279, 0x4cb8, 0x0b09, 0xd5c8, 0xfbf2, 0x2533,
            0xa786, 0x7947, 0x577d, 0x89bc, 0x1f6e, 0xc1af, 0xef95, 0x3154, 0xb3e1, 0x6d20, 0x431a,
            0x9ddb, 0x23c7, 0xfd06, 0xd33c, 0x0dfd, 0x8f48, 0x5189, 0x7fb3, 0xa172, 0x37a0, 0xe961,
            0xc75b, 0x199a, 0x9b2f, 0x45ee, 0x6bd4, 0xb515, 0x5a95, 0x8454, 0xaa6e, 0x74af, 0xf61a,
            0x28db, 0x06e1, 0xd820, 0x4ef2, 0x9033, 0xbe09, 0x60c8, 0xe27d, 0x3cbc, 0x1286, 0xcc47,
            0x725b, 0xac9a, 0x82a0, 0x5c61, 0xded4, 0x0015, 0x2e2f, 0xf0ee, 0x663c, 0xb8fd, 0x96c7,
            0x4806, 0xcab3, 0x1472, 0x3a48, 0xe489, 0xa831, 0x76f0, 0x58ca, 0x860b, 0x04be, 0xda7f,
            0xf445, 0x2a84, 0xbc56, 0x6297, 0x4cad, 0x926c, 0x10d9, 0xce18, 0xe022, 0x3ee3, 0x80ff,
            0x5e3e, 0x7004, 0xaec5, 0x2c70, 0xf2b1, 0xdc8b, 0x024a, 0x9498, 0x4a59, 0x6463, 0xbaa2,
            0x3817, 0xe6d6, 0xc8ec, 0x162d, 0xf9ad, 0x276c, 0x0956, 0xd797, 0x5522, 0x8be3, 0xa5d9,
            0x7b18, 0xedca, 0x330b, 0x1d31, 0xc3f0, 0x4145, 0x9f84, 0xb1be, 0x6f7f, 0xd163, 0x0fa2,
            0x2198, 0xff59, 0x7dec, 0xa32d, 0x8d17, 0x53d6, 0xc504, 0x1bc5, 0x35ff, 0xeb3e, 0x698b,
            0xb74a, 0x9970, 0x47b1,
        ],
        [
            0x0000, 0xc362, 0xcbbd, 0x08df, 0xda03, 0x1961, 0x11be, 0xd2dc, 0xf97f, 0x3a1d, 0x32c2,
            0xf1a0, 0x237c, 0xe01e, 0xe8c1, 0x2ba3, 0xbf87, 0x7ce5, 0x743a, 0xb758, 0x6584, 0xa6e6,
            0xae39, 0x6d5b, 0x46f8, 0x859a, 0x8d45, 0x4e27, 0x9cfb, 0x5f99, 0x5746, 0x9424, 0x3277,
            0xf115, 0xf9ca, 0x3aa8, 0xe874, 0x2b16, 0x23c9, 0xe0ab, 0xcb08, 0x086a, 0x00b5, 0xc3d7,
            0x110b, 0xd269, 0xdab6, 0x19d4, 0x8df0, 0x4e92, 0x464d, 0x852f, 0x57f3, 0x9491, 0x9c4e,
            0x5f2c, 0x748f, 0xb7ed, 0xbf32, 0x7c50, 0xae8c, 0x6dee, 0x6531, 0xa653, 0x64ee, 0xa78c,
            0xaf53, 0x6c31, 0xbeed, 0x7d8f, 0x7550, 0xb632, 0x9d91, 0x5ef3, 0x562c, 0x954e, 0x4792,
            0x84f0, 0x8c2f, 0x4f4d, 0xdb69, 0x180b, 0x10d4, 0xd3b6, 0x016a, 0xc208, 0xcad7, 0x09b5,
            0x2216, 0xe174, 0xe9ab, 0x2ac9, 0xf815, 0x3b77, 0x33a8, 0xf0ca, 0x5699, 0x95fb, 0x9d24,
            0x5e46, 0x8c9a, 0x4ff8, 0x4727, 0x8445, 0xafe6, 0x6c84, 0x645b, 0xa739, 0x75e5, 0xb687,
            0xbe58, 0x7d3a, 0xe91e, 0x2a7c, 0x22a3, 0xe1c1, 0x331d, 0xf07f, 0xf8a0, 0x3bc2, 0x1061,
            0xd303, 0xdbdc, 0x18be, 0xca62, 0x0900, 0x01df, 0xc2bd, 0xc9dc, 0x0abe, 0x0261, 0xc103,
            0x13df, 0xd0bd, 0xd862, 0x1b00, 0x30a3, 0xf3c1, 0xfb1e, 0x387c, 0xeaa0, 0x29c2, 0x211d,
            0xe27f, 0x765b, 0xb539, 0xbde6, 0x7e84, 0xac58, 0x6f3a, 0x67e5, 0xa487, 0x8f24, 0x4c46,
            0x4499, 0x87fb, 0x5527, 0x9645, 0x9e9a, 0x5df8, 0xfbab, 0x38c9, 0x3016, 0xf374, 0x21a8,
            0xe2ca, 0xea15, 0x2977, 0x02d4, 0xc1b6, 0xc969, 0x0a0b, 0xd8d7, 0x1bb5, 0x136a, 0xd008,
            0x442c, 0x874e, 0x8f91, 0x4cf3, 0x9e2f, 0x5d4d, 0x5592, 0x96f0, 0xbd53, 0x7e31, 0x76ee,
            0xb58c, 0x6750, 0xa432, 0xaced, 0x6f8f, 0xad32, 0x6e50, 0x668f, 0xa5ed, 0x7731, 0xb453,
            0xbc8c, 0x7fee, 0x544d, 0x972f, 0x9ff0, 0x5c92, 0x8e4e, 0x4d2c, 0x45f3, 0x8691, 0x12b5,
            0xd1d7, 0xd908, 0x1a6a, 0xc8b6, 0x0bd4, 0x030b, 0xc069, 0xebca, 0x28a8, 0x2077, 0xe315,
            0x31c9, 0xf2ab, 0xfa74, 0x3916, 0x9f45, 0x5c27, 0x54f8, 0x979a, 0x4546, 0x8624, 0x8efb,
            0x4d99, 0x663a, 0xa558, 0xad87, 0x6ee5, 0xbc39, 0x7f5b, 0x7784, 0xb4e6, 0x20c2, 0xe3a0,
            0xeb7f, 0x281d, 0xfac1, 0x39a3, 0x317c, 0xf21e, 0xd9bd, 0x1adf, 0x1200, 0xd162, 0x03be,
            0xc0dc, 0xc803, 0x0b61,
        ],
        [
            0x0000, 0x168e, 0x2d1c, 0x3b92, 0x5a38, 0x4cb6, 0x7724, 0x61aa, 0xb470, 0xa2fe, 0x996c,
            0x8fe2, 0xee48, 0xf8c6, 0xc354, 0xd5da, 0x2599, 0x3317, 0x0885, 0x1e0b, 0x7fa1, 0x692f,
            0x52bd, 0x4433, 0x91e9, 0x8767, 0xbcf5, 0xaa7b, 0xcbd1, 0xdd5f, 0xe6cd, 0xf043, 0x4b32,
            0x5dbc, 0x662e, 0x70a0, 0x110a, 0x0784, 0x3c16, 0x2a98, 0xff42, 0xe9cc, 0xd25e, 0xc4d0,
            0xa57a, 0xb3f4, 0x8866, 0x9ee8, 0x6eab, 0x7825, 0x43b7, 0x5539, 0x3493, 0x221d, 0x198f,
            0x0f01, 0xdadb, 0xcc55, 0xf7c7, 0xe149, 0x80e3, 0x966d, 0xadff, 0xbb71, 0x9664, 0x80ea,
            0xbb78, 0xadf6, 0xcc5c, 0xdad2, 0xe140, 0xf7ce, 0x2214, 0x349a, 0x0f08, 0x1986, 0x782c,
            0x6ea2, 0x5530, 0x43be, 0xb3fd, 0xa573, 0x9ee1, 0x886f, 0xe9c5, 0xff4b, 0xc4d9, 0xd257,
            0x078d, 0x1103, 0x2a91, 0x3c1f, 0x5db5, 0x4b3b, 0x70a9, 0x6627, 0xdd56, 0xcbd8, 0xf04a,
            0xe6c4, 0x876e, 0x91e0, 0xaa72, 0xbcfc, 0x6926, 0x7fa8, 0x443a, 0x52b4, 0x331e, 0x2590,
            0x1e02, 0x088c, 0xf8cf, 0xee41, 0xd5d3, 0xc35d, 0xa2f7, 0xb479, 0x8feb, 0x9965, 0x4cbf,
            0x5a31, 0x61a3, 0x772d, 0x1687, 0x0009, 0x3b9b, 0x2d15, 0x61b1, 0x773f, 0x4cad, 0x5a23,
            0x3b89, 0x2d07, 0x1695, 0x001b, 0xd5c1, 0xc34f, 0xf8dd, 0xee53, 0x8ff9, 0x9977, 0xa2e5,
            0xb46b, 0x4428, 0x52a6, 0x6934, 0x7fba, 0x1e10, 0x089e, 0x330c, 0x2582, 0xf058, 0xe6d6,
            0xdd44, 0xcbca, 0xaa60, 0xbcee, 0x877c, 0x91f2, 0x2a83, 0x3c0d, 0x079f, 0x1111, 0x70bb,
            0x6635, 0x5da7, 0x4b29, 0x9ef3, 0x887d, 0xb3ef, 0xa561, 0xc4cb, 0xd245, 0xe9d7, 0xff59,
            0x0f1a, 0x1994, 0x2206, 0x3488, 0x5522, 0x43ac, 0x783e, 0x6eb0, 0xbb6a, 0xade4, 0x9676,
            0x80f8, 0xe152, 0xf7dc, 0xcc4e, 0xdac0, 0xf7d5, 0xe15b, 0xdac9, 0xcc47, 0xaded, 0xbb63,
            0x80f1, 0x967f, 0x43a5, 0x552b, 0x6eb9, 0x7837, 0x199d, 0x0f13, 0x3481, 0x220f, 0xd24c,
            0xc4c2, 0xff50, 0xe9de, 0x8874, 0x9efa, 0xa568, 0xb3e6, 0x663c, 0x70b2, 0x4b20, 0x5dae,
            0x3c04, 0x2a8a, 0x1118, 0x0796, 0xbce7, 0xaa69, 0x91fb, 0x8775, 0xe6df, 0xf051, 0xcbc3,
            0xdd4d, 0x0897, 0x1e19, 0x258b, 0x3305, 0x52af, 0x4421, 0x7fb3, 0x693d, 0x997e, 0x8ff0,
            0xb462, 0xa2ec, 0xc346, 0xd5c8, 0xee5a, 0xf8d4, 0x2d0e, 0x3b80, 0x0012, 0x169c, 0x7736,
            0x61b8, 0x5a2a, 0x4ca4,
        ],
        [
            0x0000, 0xece7, 0x94b7, 0x7850, 0x6417, 0x88f0, 0xf0a0, 0x1c47, 0xc82e, 0x24c9, 0x5c99,
            0xb07e, 0xac39, 0x40de, 0x388e, 0xd469, 0xdd25, 0x31c2, 0x4992, 0xa575, 0xb932, 0x55d5,
            0x2d85, 0xc162, 0x150b, 0xf9ec, 0x81bc, 0x6d5b, 0x711c, 0x9dfb, 0xe5ab, 0x094c, 0xf733,
            0x1bd4, 0x6384, 0x8f63, 0x9324, 0x7fc3, 0x0793, 0xeb74, 0x3f1d, 0xd3fa, 0xabaa, 0x474d,
            0x5b0a, 0xb7ed, 0xcfbd, 0x235a, 0x2a16, 0xc6f1, 0xbea1, 0x5246, 0x4e01, 0xa2e6, 0xdab6,
            0x3651, 0xe238, 0x0edf, 0x768f, 0x9a68, 0x862f, 0x6ac8, 0x1298, 0xfe7f, 0xa31f, 0x4ff8,
            0x37a8, 0xdb4f, 0xc708, 0x2bef, 0x53bf, 0xbf58, 0x6b31, 0x87d6, 0xff86, 0x1361, 0x0f26,
            0xe3c1, 0x9b91, 0x7776, 0x7e3a, 0x92dd, 0xea8d, 0x066a, 0x1a2d, 0xf6ca, 0x8e9a, 0x627d,
            0xb614, 0x5af3, 0x22a3, 0xce44, 0xd203, 0x3ee4, 0x46b4, 0xaa53, 0x542c, 0xb8cb, 0xc09b,
            0x2c7c, 0x303b, 0xdcdc, 0xa48c, 0x486b, 0x9c02, 0x70e5, 0x08b5, 0xe452, 0xf815, 0x14f2,
            0x6ca2, 0x8045, 0x8909, 0x65ee, 0x1dbe, 0xf159, 0xed1e, 0x01f9, 0x79a9, 0x954e, 0x4127,
            0xadc0, 0xd590, 0x3977, 0x2530, 0xc9d7, 0xb187, 0x5d60, 0x0b47, 0xe7a0, 0x9ff0, 0x7317,
            0x6f50, 0x83b7, 0xfbe7, 0x1700, 0xc369, 0x2f8e, 0x57de, 0xbb39, 0xa77e, 0x4b99, 0x33c9,
            0xdf2e, 0xd662, 0x3a85, 0x42d5, 0xae32, 0xb275, 0x5e92, 0x26c2, 0xca25, 0x1e4c, 0xf2ab,
            0x8afb, 0x661c, 0x7a5b, 0x96bc, 0xeeec, 0x020b, 0xfc74, 0x1093, 0x68c3, 0x8424, 0x9863,
            0x7484, 0x0cd4, 0xe033, 0x345a, 0xd8bd, 0xa0ed, 0x4c0a, 0x504d, 0xbcaa, 0xc4fa, 0x281d,
            0x2151, 0xcdb6, 0xb5e6, 0x5901, 0x4546, 0xa9a1, 0xd1f1, 0x3d16, 0xe97f, 0x0598, 0x7dc8,
            0x912f, 0x8d68, 0x618f, 0x19df, 0xf538, 0xa858, 0x44bf, 0x3cef, 0xd008, 0xcc4f, 0x20a8,
            0x58f8, 0xb41f, 0x6076, 0x8c91, 0xf4c1, 0x1826, 0x0461, 0xe886, 0x90d6, 0x7c31, 0x757d,
            0x999a, 0xe1ca, 0x0d2d, 0x116a, 0xfd8d, 0x85dd, 0x693a, 0xbd53, 0x51b4, 0x29e4, 0xc503,
            0xd944, 0x35a3, 0x4df3, 0xa114, 0x5f6b, 0xb38c, 0xcbdc, 0x273b, 0x3b7c, 0xd79b, 0xafcb,
            0x432c, 0x9745, 0x7ba2, 0x03f2, 0xef15, 0xf352, 0x1fb5, 0x67e5, 0x8b02, 0x824e, 0x6ea9,
            0x16f9, 0xfa1e, 0xe659, 0x0abe, 0x72ee, 0x9e09, 0x4a60, 0xa687, 0xded7, 0x3230, 0x2e77,
            0xc290, 0xbac0, 0x5627,
        ],
        [
            0x0000, 0x5f3b, 0xbe76, 0xe14d, 0x3195, 0x6eae, 0x8fe3, 0xd0d8, 0x632a, 0x3c11, 0xdd5c,
            0x8267, 0x52bf, 0x0d84, 0xecc9, 0xb3f2, 0xc654, 0x996f, 0x7822, 0x2719, 0xf7c1, 0xa8fa,
            0x49b7, 0x168c, 0xa57e, 0xfa45, 0x1b08, 0x4433, 0x94eb, 0xcbd0, 0x2a9d, 0x75a6, 0xc1d1,
            0x9eea, 0x7fa7, 0x209c, 0xf044, 0xaf7f, 0x4e32, 0x1109, 0xa2fb, 0xfdc0, 0x1c8d, 0x43b6,
            0x936e, 0xcc55, 0x2d18, 0x7223, 0x0785, 0x58be, 0xb9f3, 0xe6c8, 0x3610, 0x692b, 0x8866,
            0xd75d, 0x64af, 0x3b94, 0xdad9, 0x85e2, 0x553a, 0x0a01, 0xeb4c, 0xb477, 0xcedb, 0x91e0,
            0x70ad, 0x2f96, 0xff4e, 0xa075, 0x4138, 0x1e03, 0xadf1, 0xf2ca, 0x1387, 0x4cbc, 0x9c64,
            0xc35f, 0x2212, 0x7d29, 0x088f, 0x57b4, 0xb6f9, 0xe9c2, 0x391a, 0x6621, 0x876c, 0xd857,
            0x6ba5, 0x349e, 0xd5d3, 0x8ae8, 0x5a30, 0x050b, 0xe446, 0xbb7d, 0x0f0a, 0x5031, 0xb17c,
            0xee47, 0x3e9f, 0x61a4, 0x80e9, 0xdfd2, 0x6c20, 0x331b, 0xd256, 0x8d6d, 0x5db5, 0x028e,
            0xe3c3, 0xbcf8, 0xc95e, 0x9665, 0x7728, 0x2813, 0xf8cb, 0xa7f0, 0x46bd, 0x1986, 0xaa74,
            0xf54f, 0x1402, 0x4b39, 0x9be1, 0xc4da, 0x2597, 0x7aac, 0xd0cf, 0x8ff4, 0x6eb9, 0x3182,
            0xe15a, 0xbe61, 0x5f2c, 0x0017, 0xb3e5, 0xecde, 0x0d93, 0x52a8, 0x8270, 0xdd4b, 0x3c06,
            0x633d, 0x169b, 0x49a0, 0xa8ed, 0xf7d6, 0x270e, 0x7835, 0x9978, 0xc643, 0x75b1, 0x2a8a,
            0xcbc7, 0x94fc, 0x4424, 0x1b1f, 0xfa52, 0xa569, 0x111e, 0x4e25, 0xaf68, 0xf053, 0x208b,
            0x7fb0, 0x9efd, 0xc1c6, 0x7234, 0x2d0f, 0xcc42, 0x9379, 0x43a1, 0x1c9a, 0xfdd7, 0xa2ec,
            0xd74a, 0x8871, 0x693c, 0x3607, 0xe6df, 0xb9e4, 0x58a9, 0x0792, 0xb460, 0xeb5b, 0x0a16,
            0x552d, 0x85f5, 0xdace, 0x3b83, 0x64b8, 0x1e14, 0x412f, 0xa062, 0xff59, 0x2f81, 0x70ba,
            0x91f7, 0xcecc, 0x7d3e, 0x2205, 0xc348, 0x9c73, 0x4cab, 0x1390, 0xf2dd, 0xade6, 0xd840,
            0x877b, 0x6636, 0x390d, 0xe9d5, 0xb6ee, 0x57a3, 0x0898, 0xbb6a, 0xe451, 0x051c, 0x5a27,
            0x8aff, 0xd5c4, 0x3489, 0x6bb2, 0xdfc5, 0x80fe, 0x61b3, 0x3e88, 0xee50, 0xb16b, 0x5026,
            0x0f1d, 0xbcef, 0xe3d4, 0x0299, 0x5da2, 0x8d7a, 0xd241, 0x330c, 0x6c37, 0x1991, 0x46aa,
            0xa7e7, 0xf8dc, 0x2804, 0x773f, 0x9672, 0xc949, 0x7abb, 0x2580, 0xc4cd, 0x9bf6, 0x4b2e,
            0x1415, 0xf558, 0xaa63,
        ],
        [
            0x0000, 0x3ef0, 0x7de0, 0x4310, 0xfbc0, 0xc530, 0x8620, 0xb8d0, 0xbaf9, 0x8409, 0xc719,
            0xf9e9, 0x4139, 0x7fc9, 0x3cd9, 0x0229, 0x388b, 0x067b, 0x456b, 0x7b9b, 0xc34b, 0xfdbb,
            0xbeab, 0x805b, 0x8272, 0xbc82, 0xff92, 0xc162, 0x79b2, 0x4742, 0x0452, 0x3aa2, 0x7116,
            0x4fe6, 0x0cf6, 0x3206, 0x8ad6, 0xb426, 0xf736, 0xc9c6, 0xcbef, 0xf51f, 0xb60f, 0x88ff,
            0x302f, 0x0edf, 0x4dcf, 0x733f, 0x499d, 0x776d, 0x347d, 0x0a8d, 0xb25d, 0x8cad, 0xcfbd,
            0xf14d, 0xf364, 0xcd94, 0x8e84, 0xb074, 0x08a4, 0x3654, 0x7544, 0x4bb4, 0xe22c, 0xdcdc,
            0x9fcc, 0xa13c, 0x19ec, 0x271c, 0x640c, 0x5afc, 0x58d5, 0x6625, 0x2535, 0x1bc5, 0xa315,
            0x9de5, 0xdef5, 0xe005, 0xdaa7, 0xe457, 0xa747, 0x99b7, 0x2167, 0x1f97, 0x5c87, 0x6277,
            0x605e, 0x5eae, 0x1dbe, 0x234e, 0x9b9e, 0xa56e, 0xe67e, 0xd88e, 0x933a, 0xadca, 0xeeda,
            0xd02a, 0x68fa, 0x560a, 0x151a, 0x2bea, 0x29c3, 0x1733, 0x5423, 0x6ad3, 0xd203, 0xecf3,
            0xafe3, 0x9113, 0xabb1, 0x9541, 0xd651, 0xe8a1, 0x5071, 0x6e81, 0x2d91, 0x1361, 0x1148,
            0x2fb8, 0x6ca8, 0x5258, 0xea88, 0xd478, 0x9768, 0xa998, 0x8921, 0xb7d1, 0xf4c1, 0xca31,
            0x72e1, 0x4c11, 0x0f01, 0x31f1, 0x33d8, 0x0d28, 0x4e38, 0x70c8, 0xc818, 0xf6e8, 0xb5f8,
            0x8b08, 0xb1aa, 0x8f5a, 0xcc4a, 0xf2ba, 0x4a6a, 0x749a, 0x378a, 0x097a, 0x0b53, 0x35a3,
            0x76b3, 0x4843, 0xf093, 0xce63, 0x8d73, 0xb383, 0xf837, 0xc6c7, 0x85d7, 0xbb27, 0x03f7,
            0x3d07, 0x7e17, 0x40e7, 0x42ce, 0x7c3e, 0x3f2e, 0x01de, 0xb90e, 0x87fe, 0xc4ee, 0xfa1e,
            0xc0bc, 0xfe4c, 0xbd5c, 0x83ac, 0x3b7c, 0x058c, 0x469c, 0x786c, 0x7a45, 0x44b5, 0x07a5,
            0x3955, 0x8185, 0xbf75, 0xfc65, 0xc295, 0x6b0d, 0x55fd, 0x16ed, 0x281d, 0x90cd, 0xae3d,
            0xed2d, 0xd3dd, 0xd1f4, 0xef04, 0xac14, 0x92e4, 0x2a34, 0x14c4, 0x57d4, 0x6924, 0x5386,
            0x6d76, 0x2e66, 0x1096, 0xa846, 0x96b6, 0xd5a6, 0xeb56, 0xe97f, 0xd78f, 0x949f, 0xaa6f,
            0x12bf, 0x2c4f, 0x6f5f, 0x51af, 0x1a1b, 0x24eb, 0x67fb, 0x590b, 0xe1db, 0xdf2b, 0x9c3b,
            0xa2cb, 0xa0e2, 0x9e12, 0xdd02, 0xe3f2, 0x5b22, 0x65d2, 0x26c2, 0x1832, 0x2290, 0x1c60,
            0x5f70, 0x6180, 0xd950, 0xe7a0, 0xa4b0, 0x9a40, 0x9869, 0xa699, 0xe589, 0xdb79, 0x63a9,
            0x5d59, 0x1e49, 0x20b9,
        ],
        [
            0x0000, 0x6e18, 0xdc30, 0xb228, 0xf519, 0x9b01, 0x2929, 0x4731, 0xa74b, 0xc953, 0x7b7b,
            0x1563, 0x5252, 0x3c4a, 0x8e62, 0xe07a, 0x03ef, 0x6df7, 0xdfdf, 0xb1c7, 0xf6f6, 0x98ee,
            0x2ac6, 0x44de, 0xa4a4, 0xcabc, 0x7894, 0x168c, 0x51bd, 0x3fa5, 0x8d8d, 0xe395, 0x07de,
            0x69c6, 0xdbee, 0xb5f6, 0xf2c7, 0x9cdf, 0x2ef7, 0x40ef, 0xa095, 0xce8d, 0x7ca5, 0x12bd,
            0x558c, 0x3b94, 0x89bc, 0xe7a4, 0x0431, 0x6a29, 0xd801, 0xb619, 0xf128, 0x9f30, 0x2d18,
            0x4300, 0xa37a, 0xcd62, 0x7f4a, 0x1152, 0x5663, 0x387b, 0x8a53, 0xe44b, 0x0fbc, 0x61a4,
            0xd38c, 0xbd94, 0xfaa5, 0x94bd, 0x2695, 0x488d, 0xa8f7, 0xc6ef, 0x74c7, 0x1adf, 0x5dee,
            0x33f6, 0x81de, 0xefc6, 0x0c53, 0x624b, 0xd063, 0xbe7b, 0xf94a, 0x9752, 0x257a, 0x4b62,
            0xab18, 0xc500, 0x7728, 0x1930, 0x5e01, 0x3019, 0x8231, 0xec29, 0x0862, 0x667a, 0xd452,
            0xba4a, 0xfd7b, 0x9363, 0x214b, 0x4f53, 0xaf29, 0xc131, 0x7319, 0x1d01, 0x5a30, 0x3428,
            0x8600, 0xe818, 0x0b8d, 0x6595, 0xd7bd, 0xb9a5, 0xfe94, 0x908c, 0x22a4, 0x4cbc, 0xacc6,
            0xc2de, 0x70f6, 0x1eee, 0x59df, 0x37c7, 0x85ef, 0xebf7, 0x1f78, 0x7160, 0xc348, 0xad50,
            0xea61, 0x8479, 0x3651, 0x5849, 0xb833, 0xd62b, 0x6403, 0x0a1b, 0x4d2a, 0x2332, 0x911a,
            0xff02, 0x1c97, 0x728f, 0xc0a7, 0xaebf, 0xe98e, 0x8796, 0x35be, 0x5ba6, 0xbbdc, 0xd5c4,
            0x67ec, 0x09f4, 0x4ec5, 0x20dd, 0x92f5, 0xfced, 0x18a6, 0x76be, 0xc496, 0xaa8e, 0xedbf,
            0x83a7, 0x318f, 0x5f97, 0xbfed, 0xd1f5, 0x63dd, 0x0dc5, 0x4af4, 0x24ec, 0x96c4, 0xf8dc,
            0x1b49, 0x7551, 0xc779, 0xa961, 0xee50, 0x8048, 0x3260, 0x5c78, 0xbc02, 0xd21a, 0x6032,
            0x0e2a, 0x491b, 0x2703, 0x952b, 0xfb33, 0x10c4, 0x7edc, 0xccf4, 0xa2ec, 0xe5dd, 0x8bc5,
            0x39ed, 0x57f5, 0xb78f, 0xd997, 0x6bbf, 0x05a7, 0x4296, 0x2c8e, 0x9ea6, 0xf0be, 0x132b,
            0x7d33, 0xcf1b, 0xa103, 0xe632, 0x882a, 0x3a02, 0x541a, 0xb460, 0xda78, 0x6850, 0x0648,
            0x4179, 0x2f61, 0x9d49, 0xf351, 0x171a, 0x7902, 0xcb2a, 0xa532, 0xe203, 0x8c1b, 0x3e33,
            0x502b, 0xb051, 0xde49, 0x6c61, 0x0279, 0x4548, 0x2b50, 0x9978, 0xf760, 0x14f5, 0x7aed,
            0xc8c5, 0xa6dd, 0xe1ec, 0x8ff4, 0x3ddc, 0x53c4, 0xb3be, 0xdda6, 0x6f8e, 0x0196, 0x46a7,
            0x28bf, 0x9a97, 0xf48f,
        ],
        [
            0x0000, 0x4d8c, 0x9b18, 0xd694, 0x7b49, 0x36c5, 0xe051, 0xaddd, 0xf692, 0xbb1e, 0x6d8a,
            0x2006, 0x8ddb, 0xc057, 0x16c3, 0x5b4f, 0xa05d, 0xedd1, 0x3b45, 0x76c9, 0xdb14, 0x9698,
            0x400c, 0x0d80, 0x56cf, 0x1b43, 0xcdd7, 0x805b, 0x2d86, 0x600a, 0xb69e, 0xfb12, 0x0dc3,
            0x404f, 0x96db, 0xdb57, 0x768a, 0x3b06, 0xed92, 0xa01e, 0xfb51, 0xb6dd, 0x6049, 0x2dc5,
            0x8018, 0xcd94, 0x1b00, 0x568c, 0xad9e, 0xe012, 0x3686, 0x7b0a, 0xd6d7, 0x9b5b, 0x4dcf,
            0x0043, 0x5b0c, 0x1680, 0xc014, 0x8d98, 0x2045, 0x6dc9, 0xbb5d, 0xf6d1, 0x1b86, 0x560a,
            0x809e, 0xcd12, 0x60cf, 0x2d43, 0xfbd7, 0xb65b, 0xed14, 0xa098, 0x760c, 0x3b80, 0x965d,
            0xdbd1, 0x0d45, 0x40c9, 0xbbdb, 0xf657, 0x20c3, 0x6d4f, 0xc092, 0x8d1e, 0x5b8a, 0x1606,
            0x4d49, 0x00c5, 0xd651, 0x9bdd, 0x3600, 0x7b8c, 0xad18, 0xe094, 0x1645, 0x5bc9, 0x8d5d,
            0xc0d1, 0x6d0c, 0x2080, 0xf614, 0xbb98, 0xe0d7, 0xad5b, 0x7bcf, 0x3643, 0x9b9e, 0xd612,
            0x0086, 0x4d0a, 0xb618, 0xfb94, 0x2d00, 0x608c, 0xcd51, 0x80dd, 0x5649, 0x1bc5, 0x408a,
            0x0d06, 0xdb92, 0x961e, 0x3bc3, 0x764f, 0xa0db, 0xed57, 0x370c, 0x7a80, 0xac14, 0xe198,
            0x4c45, 0x01c9, 0xd75d, 0x9ad1, 0xc19e, 0x8c12, 0x5a86, 0x170a, 0xbad7, 0xf75b, 0x21cf,
            0x6c43, 0x9751, 0xdadd, 0x0c49, 0x41c5, 0xec18, 0xa194, 0x7700, 0x3a8c, 0x61c3, 0x2c4f,
            0xfadb, 0xb757, 0x1a8a, 0x5706, 0x8192, 0xcc1e, 0x3acf, 0x7743, 0xa1d7, 0xec5b, 0x4186,
            0x0c0a, 0xda9e, 0x9712, 0xcc5d, 0x81d1, 0x5745, 0x1ac9, 0xb714, 0xfa98, 0x2c0c, 0x6180,
            0x9a92, 0xd71e, 0x018a, 0x4c06, 0xe1db, 0xac57, 0x7ac3, 0x374f, 0x6c00, 0x218c, 0xf718,
            0xba94, 0x1749, 0x5ac5, 0x8c51, 0xc1dd, 0x2c8a, 0x6106, 0xb792, 0xfa1e, 0x57c3, 0x1a4f,
            0xccdb, 0x8157, 0xda18, 0x9794, 0x4100, 0x0c8c, 0xa151, 0xecdd, 0x3a49, 0x77c5, 0x8cd7,
            0xc15b, 0x17cf, 0x5a43, 0xf79e, 0xba12, 0x6c86, 0x210a, 0x7a45, 0x37c9, 0xe15d, 0xacd1,
            0x010c, 0x4c80, 0x9a14, 0xd798, 0x2149, 0x6cc5, 0xba51, 0xf7dd, 0x5a00, 0x178c, 0xc118,
            0x8c94, 0xd7db, 0x9a57, 0x4cc3, 0x014f, 0xac92, 0xe11e, 0x378a, 0x7a06, 0x8114, 0xcc98,
            0x1a0c, 0x5780, 0xfa5d, 0xb7d1, 0x6145, 0x2cc9, 0x7786, 0x3a0a, 0xec9e, 0xa112, 0x0ccf,
            0x4143, 0x97d7, 0xda5b,
        ],
    ];

    pub static CRC16_EN_13757_TABLE: [[u16; 256]; 16] = [
        [
            0x0000, 0x3d65, 0x7aca, 0x47af, 0xf594, 0xc8f1, 0x8f5e, 0xb23b, 0xd64d, 0xeb28, 0xac87,
            0x91e2, 0x23d9, 0x1ebc, 0x5913, 0x6476, 0x91ff, 0xac9a, 0xeb35, 0xd650, 0x646b, 0x590e,
            0x1ea1, 0x23c4, 0x47b2, 0x7ad7, 0x3d78, 0x001d, 0xb226, 0x8f43, 0xc8ec, 0xf589, 0x1e9b,
            0x23fe, 0x6451, 0x5934, 0xeb0f, 0xd66a, 0x91c5, 0xaca0, 0xc8d6, 0xf5b3, 0xb21c, 0x8f79,
            0x3d42, 0x0027, 0x4788, 0x7aed, 0x8f64, 0xb201, 0xf5ae, 0xc8cb, 0x7af0, 0x4795, 0x003a,
            0x3d5f, 0x5929, 0x644c, 0x23e3, 0x1e86, 0xacbd, 0x91d8, 0xd677, 0xeb12, 0x3d36, 0x0053,
            0x47fc, 0x7a99, 0xc8a2, 0xf5c7, 0xb268, 0x8f0d, 0xeb7b, 0xd61e, 0x91b1, 0xacd4, 0x1eef,
            0x238a, 0x6425, 0x5940, 0xacc9, 0x91ac, 0xd603, 0xeb66, 0x595d, 0x6438, 0x2397, 0x1ef2,
            0x7a84, 0x47e1, 0x004e, 0x3d2b, 0x8f10, 0xb275, 0xf5da, 0xc8bf, 0x23ad, 0x1ec8, 0x5967,
            0x6402, 0xd639, 0xeb5c, 0xacf3, 0x9196, 0xf5e0, 0xc885, 0x8f2a, 0xb24f, 0x0074, 0x3d11,
            0x7abe, 0x47db, 0xb252, 0x8f37, 0xc898, 0xf5fd, 0x47c6, 0x7aa3, 0x3d0c, 0x0069, 0x641f,
            0x597a, 0x1ed5, 0x23b0, 0x918b, 0xacee, 0xeb41, 0xd624, 0x7a6c, 0x4709, 0x00a6, 0x3dc3,
            0x8ff8, 0xb29d, 0xf532, 0xc857, 0xac21, 0x9144, 0xd6eb, 0xeb8e, 0x59b5, 0x64d0, 0x237f,
            0x1e1a, 0xeb93, 0xd6f6, 0x9159, 0xac3c, 0x1e07, 0x2362, 0x64cd, 0x59a8, 0x3dde, 0x00bb,
            0x4714, 0x7a71, 0xc84a, 0xf52f, 0xb280, 0x8fe5, 0x64f7, 0x5992, 0x1e3d, 0x2358, 0x9163,
            0xac06, 0xeba9, 0xd6cc, 0xb2ba, 0x8fdf, 0xc870, 0xf515, 0x472e, 0x7a4b, 0x3de4, 0x0081,
            0xf508, 0xc86d, 0x8fc2, 0xb2a7, 0x009c, 0x3df9, 0x7a56, 0x4733, 0x2345, 0x1e20, 0x598f,
            0x64ea, 0xd6d1, 0xebb4, 0xac1b, 0x917e, 0x475a, 0x7a3f, 0x3d90, 0x00f5, 0xb2ce, 0x8fab,
            0xc804, 0xf561, 0x9117, 0xac72, 0xebdd, 0xd6b8, 0x6483, 0x59e6, 0x1e49, 0x232c, 0xd6a5,
            0xebc0, 0xac6f, 0x910a, 0x2331, 0x1e54, 0x59fb, 0x649e, 0x00e8, 0x3d8d, 0x7a22, 0x4747,
            0xf57c, 0xc819, 0x8fb6, 0xb2d3, 0x59c1, 0x64a4, 0x230b, 0x1e6e, 0xac55, 0x9130, 0xd69f,
            0xebfa, 0x8f8c, 0xb2e9, 0xf546, 0xc823, 0x7a18, 0x477d, 0x00d2, 0x3db7, 0xc83e, 0xf55b,
            0xb2f4, 0x8f91, 0x3daa, 0x00cf, 0x4760, 0x7a05, 0x1e73, 0x2316, 0x64b9, 0x59dc, 0xebe7,
            0xd682, 0x912d, 0xac48,
        ],
        [
            0x0000, 0xf4d8, 0xd4d5, 0x200d, 0x94cf, 0x6017, 0x401a, 0xb4c2, 0x14fb, 0xe023, 0xc02e,
            0x34f6, 0x8034, 0x74ec, 0x54e1, 0xa039, 0x29f6, 0xdd2e, 0xfd23, 0x09fb, 0xbd39, 0x49e1,
            0x69ec, 0x9d34, 0x3d0d, 0xc9d5, 0xe9d8, 0x1d00, 0xa9c2, 0x5d1a, 0x7d17, 0x89cf, 0x53ec,
            0xa734, 0x8739, 0x73e1, 0xc723, 0x33fb, 0x13f6, 0xe72e, 0x4717, 0xb3cf, 0x93c2, 0x671a,
            0xd3d8, 0x2700, 0x070d, 0xf3d5, 0x7a1a, 0x8ec2, 0xaecf, 0x5a17, 0xeed5, 0x1a0d, 0x3a00,
            0xced8, 0x6ee1, 0x9a39, 0xba34, 0x4eec, 0xfa2e, 0x0ef6, 0x2efb, 0xda23, 0xa7d8, 0x5300,
            0x730d, 0x87d5, 0x3317, 0xc7cf, 0xe7c2, 0x131a, 0xb323, 0x47fb, 0x67f6, 0x932e, 0x27ec,
            0xd334, 0xf339, 0x07e1, 0x8e2e, 0x7af6, 0x5afb, 0xae23, 0x1ae1, 0xee39, 0xce34, 0x3aec,
            0x9ad5, 0x6e0d, 0x4e00, 0xbad8, 0x0e1a, 0xfac2, 0xdacf, 0x2e17, 0xf434, 0x00ec, 0x20e1,
            0xd439, 0x60fb, 0x9423, 0xb42e, 0x40f6, 0xe0cf, 0x1417, 0x341a, 0xc0c2, 0x7400, 0x80d8,
            0xa0d5, 0x540d, 0xddc2, 0x291a, 0x0917, 0xfdcf, 0x490d, 0xbdd5, 0x9dd8, 0x6900, 0xc939,
            0x3de1, 0x1dec, 0xe934, 0x5df6, 0xa92e, 0x8923, 0x7dfb, 0x72d5, 0x860d, 0xa600, 0x52d8,
            0xe61a, 0x12c2, 0x32cf, 0xc617, 0x662e, 0x92f6, 0xb2fb, 0x4623, 0xf2e1, 0x0639, 0x2634,
            0xd2ec, 0x5b23, 0xaffb, 0x8ff6, 0x7b2e, 0xcfec, 0x3b34, 0x1b39, 0xefe1, 0x4fd8, 0xbb00,
            0x9b0d, 0x6fd5, 0xdb17, 0x2fcf, 0x0fc2, 0xfb1a, 0x2139, 0xd5e1, 0xf5ec, 0x0134, 0xb5f6,
            0x412e, 0x6123, 0x95fb, 0x35c2, 0xc11a, 0xe117, 0x15cf, 0xa10d, 0x55d5, 0x75d8, 0x8100,
            0x08cf, 0xfc17, 0xdc1a, 0x28c2, 0x9c00, 0x68d8, 0x48d5, 0xbc0d, 0x1c34, 0xe8ec, 0xc8e1,
            0x3c39, 0x88fb, 0x7c23, 0x5c2e, 0xa8f6, 0xd50d, 0x21d5, 0x01d8, 0xf500, 0x41c2, 0xb51a,
            0x9517, 0x61cf, 0xc1f6, 0x352e, 0x1523, 0xe1fb, 0x5539, 0xa1e1, 0x81ec, 0x7534, 0xfcfb,
            0x0823, 0x282e, 0xdcf6, 0x6834, 0x9cec, 0xbce1, 0x4839, 0xe800, 0x1cd8, 0x3cd5, 0xc80d,
            0x7ccf, 0x8817, 0xa81a, 0x5cc2, 0x86e1, 0x7239, 0x5234, 0xa6ec, 0x122e, 0xe6f6, 0xc6fb,
            0x3223, 0x921a, 0x66c2, 0x46cf, 0xb217, 0x06d5, 0xf20d, 0xd200, 0x26d8, 0xaf17, 0x5bcf,
            0x7bc2, 0x8f1a, 0x3bd8, 0xcf00, 0xef0d, 0x1bd5, 0xbbec, 0x4f34, 0x6f39, 0x9be1, 0x2f23,
            0xdbfb, 0xfbf6, 0x0f2e,
        ],
        [
            0x0000, 0xe5aa, 0xf631, 0x139b, 0xd107, 0x34ad, 0x2736, 0xc29c, 0x9f6b, 0x7ac1, 0x695a,
            0x8cf0, 0x4e6c, 0xabc6, 0xb85d, 0x5df7, 0x03b3, 0xe619, 0xf582, 0x1028, 0xd2b4, 0x371e,
            0x2485, 0xc12f, 0x9cd8, 0x7972, 0x6ae9, 0x8f43, 0x4ddf, 0xa875, 0xbbee, 0x5e44, 0x0766,
            0xe2cc, 0xf157, 0x14fd, 0xd661, 0x33cb, 0x2050, 0xc5fa, 0x980d, 0x7da7, 0x6e3c, 0x8b96,
            0x490a, 0xaca0, 0xbf3b, 0x5a91, 0x04d5, 0xe17f, 0xf2e4, 0x174e, 0xd5d2, 0x3078, 0x23e3,
            0xc649, 0x9bbe, 0x7e14, 0x6d8f, 0x8825, 0x4ab9, 0xaf13, 0xbc88, 0x5922, 0x0ecc, 0xeb66,
            0xf8fd, 0x1d57, 0xdfcb, 0x3a61, 0x29fa, 0xcc50, 0x91a7, 0x740d, 0x6796, 0x823c, 0x40a0,
            0xa50a, 0xb691, 0x533b, 0x0d7f, 0xe8d5, 0xfb4e, 0x1ee4, 0xdc78, 0x39d2, 0x2a49, 0xcfe3,
            0x9214, 0x77be, 0x6425, 0x818f, 0x4313, 0xa6b9, 0xb522, 0x5088, 0x09aa, 0xec00, 0xff9b,
            0x1a31, 0xd8ad, 0x3d07, 0x2e9c, 0xcb36, 0x96c1, 0x736b, 0x60f0, 0x855a, 0x47c6, 0xa26c,
            0xb1f7, 0x545d, 0x0a19, 0xefb3, 0xfc28, 0x1982, 0xdb1e, 0x3eb4, 0x2d2f, 0xc885, 0x9572,
            0x70d8, 0x6343, 0x86e9, 0x4475, 0xa1df, 0xb244, 0x57ee, 0x1d98, 0xf832, 0xeba9, 0x0e03,
            0xcc9f, 0x2935, 0x3aae, 0xdf04, 0x82f3, 0x6759, 0x74c2, 0x9168, 0x53f4, 0xb65e, 0xa5c5,
            0x406f, 0x1e2b, 0xfb81, 0xe81a, 0x0db0, 0xcf2c, 0x2a86, 0x391d, 0xdcb7, 0x8140, 0x64ea,
            0x7771, 0x92db, 0x5047, 0xb5ed, 0xa676, 0x43dc, 0x1afe, 0xff54, 0xeccf, 0x0965, 0xcbf9,
            0x2e53, 0x3dc8, 0xd862, 0x8595, 0x603f, 0x73a4, 0x960e, 0x5492, 0xb138, 0xa2a3, 0x4709,
            0x194d, 0xfce7, 0xef7c, 0x0ad6, 0xc84a, 0x2de0, 0x3e7b, 0xdbd1, 0x8626, 0x638c, 0x7017,
            0x95bd, 0x5721, 0xb28b, 0xa110, 0x44ba, 0x1354, 0xf6fe, 0xe565, 0x00cf, 0xc253, 0x27f9,
            0x3462, 0xd1c8, 0x8c3f, 0x6995, 0x7a0e, 0x9fa4, 0x5d38, 0xb892, 0xab09, 0x4ea3, 0x10e7,
            0xf54d, 0xe6d6, 0x037c, 0xc1e0, 0x244a, 0x37d1, 0xd27b, 0x8f8c, 0x6a26, 0x79bd, 0x9c17,
            0x5e8b, 0xbb21, 0xa8ba, 0x4d10, 0x1432, 0xf198, 0xe203, 0x07a9, 0xc535, 0x209f, 0x3304,
            0xd6ae, 0x8b59, 0x6ef3, 0x7d68, 0x98c2, 0x5a5e, 0xbff4, 0xac6f, 0x49c5, 0x1781, 0xf22b,
            0xe1b0, 0x041a, 0xc686, 0x232c, 0x30b7, 0xd51d, 0x88ea, 0x6d40, 0x7edb, 0x9b71, 0x59ed,
            0xbc47, 0xafdc, 0x4a76,
        ],
        [
            0x0000, 0x3b30, 0x7660, 0x4d50, 0xecc0, 0xd7f0, 0x9aa0, 0xa190, 0xe4e5, 0xdfd5, 0x9285,
            0xa9b5, 0x0825, 0x3315, 0x7e45, 0x4575, 0xf4af, 0xcf9f, 0x82cf, 0xb9ff, 0x186f, 0x235f,
            0x6e0f, 0x553f, 0x104a, 0x2b7a, 0x662a, 0x5d1a, 0xfc8a, 0xc7ba, 0x8aea, 0xb1da, 0xd43b,
            0xef0b, 0xa25b, 0x996b, 0x38fb, 0x03cb, 0x4e9b, 0x75ab, 0x30de, 0x0bee, 0x46be, 0x7d8e,
            0xdc1e, 0xe72e, 0xaa7e, 0x914e, 0x2094, 0x1ba4, 0x56f4, 0x6dc4, 0xcc54, 0xf764, 0xba34,
            0x8104, 0xc471, 0xff41, 0xb211, 0x8921, 0x28b1, 0x1381, 0x5ed1, 0x65e1, 0x9513, 0xae23,
            0xe373, 0xd843, 0x79d3, 0x42e3, 0x0fb3, 0x3483, 0x71f6, 0x4ac6, 0x0796, 0x3ca6, 0x9d36,
            0xa606, 0xeb56, 0xd066, 0x61bc, 0x5a8c, 0x17dc, 0x2cec, 0x8d7c, 0xb64c, 0xfb1c, 0xc02c,
            0x8559, 0xbe69, 0xf339, 0xc809, 0x6999, 0x52a9, 0x1ff9, 0x24c9, 0x4128, 0x7a18, 0x3748,
            0x0c78, 0xade8, 0x96d8, 0xdb88, 0xe0b8, 0xa5cd, 0x9efd, 0xd3ad, 0xe89d, 0x490d, 0x723d,
            0x3f6d, 0x045d, 0xb587, 0x8eb7, 0xc3e7, 0xf8d7, 0x5947, 0x6277, 0x2f27, 0x1417, 0x5162,
            0x6a52, 0x2702, 0x1c32, 0xbda2, 0x8692, 0xcbc2, 0xf0f2, 0x1743, 0x2c73, 0x6123, 0x5a13,
            0xfb83, 0xc0b3, 0x8de3, 0xb6d3, 0xf3a6, 0xc896, 0x85c6, 0xbef6, 0x1f66, 0x2456, 0x6906,
            0x5236, 0xe3ec, 0xd8dc, 0x958c, 0xaebc, 0x0f2c, 0x341c, 0x794c, 0x427c, 0x0709, 0x3c39,
            0x7169, 0x4a59, 0xebc9, 0xd0f9, 0x9da9, 0xa699, 0xc378, 0xf848, 0xb518, 0x8e28, 0x2fb8,
            0x1488, 0x59d8, 0x62e8, 0x279d, 0x1cad, 0x51fd, 0x6acd, 0xcb5d, 0xf06d, 0xbd3d, 0x860d,
            0x37d7, 0x0ce7, 0x41b7, 0x7a87, 0xdb17, 0xe027, 0xad77, 0x9647, 0xd332, 0xe802, 0xa552,
            0x9e62, 0x3ff2, 0x04c2, 0x4992, 0x72a2, 0x8250, 0xb960, 0xf430, 0xcf00, 0x6e90, 0x55a0,
            0x18f0, 0x23c0, 0x66b5, 0x5d85, 0x10d5, 0x2be5, 0x8a75, 0xb145, 0xfc15, 0xc725, 0x76ff,
            0x4dcf, 0x009f, 0x3baf, 0x9a3f, 0xa10f, 0xec5f, 0xd76f, 0x921a, 0xa92a, 0xe47a, 0xdf4a,
            0x7eda, 0x45ea, 0x08ba, 0x338a, 0x566b, 0x6d5b, 0x200b, 0x1b3b, 0xbaab, 0x819b, 0xcccb,
            0xf7fb, 0xb28e, 0x89be, 0xc4ee, 0xffde, 0x5e4e, 0x657e, 0x282e, 0x131e, 0xa2c4, 0x99f4,
            0xd4a4, 0xef94, 0x4e04, 0x7534, 0x3864, 0x0354, 0x4621, 0x7d11, 0x3041, 0x0b71, 0xaae1,
            0x91d1, 0xdc81, 0xe7b1,
        ],
        [
            0x0000, 0x2e86, 0x5d0c, 0x738a, 0xba18, 0x949e, 0xe714, 0xc992, 0x4955, 0x67d3, 0x1459,
            0x3adf, 0xf34d, 0xddcb, 0xae41, 0x80c7, 0x92aa, 0xbc2c, 0xcfa6, 0xe120, 0x28b2, 0x0634,
            0x75be, 0x5b38, 0xdbff, 0xf579, 0x86f3, 0xa875, 0x61e7, 0x4f61, 0x3ceb, 0x126d, 0x1831,
            0x36b7, 0x453d, 0x6bbb, 0xa229, 0x8caf, 0xff25, 0xd1a3, 0x5164, 0x7fe2, 0x0c68, 0x22ee,
            0xeb7c, 0xc5fa, 0xb670, 0x98f6, 0x8a9b, 0xa41d, 0xd797, 0xf911, 0x3083, 0x1e05, 0x6d8f,
            0x4309, 0xc3ce, 0xed48, 0x9ec2, 0xb044, 0x79d6, 0x5750, 0x24da, 0x0a5c, 0x3062, 0x1ee4,
            0x6d6e, 0x43e8, 0x8a7a, 0xa4fc, 0xd776, 0xf9f0, 0x7937, 0x57b1, 0x243b, 0x0abd, 0xc32f,
            0xeda9, 0x9e23, 0xb0a5, 0xa2c8, 0x8c4e, 0xffc4, 0xd142, 0x18d0, 0x3656, 0x45dc, 0x6b5a,
            0xeb9d, 0xc51b, 0xb691, 0x9817, 0x5185, 0x7f03, 0x0c89, 0x220f, 0x2853, 0x06d5, 0x755f,
            0x5bd9, 0x924b, 0xbccd, 0xcf47, 0xe1c1, 0x6106, 0x4f80, 0x3c0a, 0x128c, 0xdb1e, 0xf598,
            0x8612, 0xa894, 0xbaf9, 0x947f, 0xe7f5, 0xc973, 0x00e1, 0x2e67, 0x5ded, 0x736b, 0xf3ac,
            0xdd2a, 0xaea0, 0x8026, 0x49b4, 0x6732, 0x14b8, 0x3a3e, 0x60c4, 0x4e42, 0x3dc8, 0x134e,
            0xdadc, 0xf45a, 0x87d0, 0xa956, 0x2991, 0x0717, 0x749d, 0x5a1b, 0x9389, 0xbd0f, 0xce85,
            0xe003, 0xf26e, 0xdce8, 0xaf62, 0x81e4, 0x4876, 0x66f0, 0x157a, 0x3bfc, 0xbb3b, 0x95bd,
            0xe637, 0xc8b1, 0x0123, 0x2fa5, 0x5c2f, 0x72a9, 0x78f5, 0x5673, 0x25f9, 0x0b7f, 0xc2ed,
            0xec6b, 0x9fe1, 0xb167, 0x31a0, 0x1f26, 0x6cac, 0x422a, 0x8bb8, 0xa53e, 0xd6b4, 0xf832,
            0xea5f, 0xc4d9, 0xb753, 0x99d5, 0x5047, 0x7ec1, 0x0d4b, 0x23cd, 0xa30a, 0x8d8c, 0xfe06,
            0xd080, 0x1912, 0x3794, 0x441e, 0x6a98, 0x50a6, 0x7e20, 0x0daa, 0x232c, 0xeabe, 0xc438,
            0xb7b2, 0x9934, 0x19f3, 0x3775, 0x44ff, 0x6a79, 0xa3eb, 0x8d6d, 0xfee7, 0xd061, 0xc20c,
            0xec8a, 0x9f00, 0xb186, 0x7814, 0x5692, 0x2518, 0x0b9e, 0x8b59, 0xa5df, 0xd655, 0xf8d3,
            0x3141, 0x1fc7, 0x6c4d, 0x42cb, 0x4897, 0x6611, 0x159b, 0x3b1d, 0xf28f, 0xdc09, 0xaf83,
            0x8105, 0x01c2, 0x2f44, 0x5cce, 0x7248, 0xbbda, 0x955c, 0xe6d6, 0xc850, 0xda3d, 0xf4bb,
            0x8731, 0xa9b7, 0x6025, 0x4ea3, 0x3d29, 0x13af, 0x9368, 0xbdee, 0xce64, 0xe0e2, 0x2970,
            0x07f6, 0x747c, 0x5afa,
        ],
        [
            0x0000, 0xc188, 0xbe75, 0x7ffd, 0x418f, 0x8007, 0xfffa, 0x3e72, 0x831e, 0x4296, 0x3d6b,
            0xfce3, 0xc291, 0x0319, 0x7ce4, 0xbd6c, 0x3b59, 0xfad1, 0x852c, 0x44a4, 0x7ad6, 0xbb5e,
            0xc4a3, 0x052b, 0xb847, 0x79cf, 0x0632, 0xc7ba, 0xf9c8, 0x3840, 0x47bd, 0x8635, 0x76b2,
            0xb73a, 0xc8c7, 0x094f, 0x373d, 0xf6b5, 0x8948, 0x48c0, 0xf5ac, 0x3424, 0x4bd9, 0x8a51,
            0xb423, 0x75ab, 0x0a56, 0xcbde, 0x4deb, 0x8c63, 0xf39e, 0x3216, 0x0c64, 0xcdec, 0xb211,
            0x7399, 0xcef5, 0x0f7d, 0x7080, 0xb108, 0x8f7a, 0x4ef2, 0x310f, 0xf087, 0xed64, 0x2cec,
            0x5311, 0x9299, 0xaceb, 0x6d63, 0x129e, 0xd316, 0x6e7a, 0xaff2, 0xd00f, 0x1187, 0x2ff5,
            0xee7d, 0x9180, 0x5008, 0xd63d, 0x17b5, 0x6848, 0xa9c0, 0x97b2, 0x563a, 0x29c7, 0xe84f,
            0x5523, 0x94ab, 0xeb56, 0x2ade, 0x14ac, 0xd524, 0xaad9, 0x6b51, 0x9bd6, 0x5a5e, 0x25a3,
            0xe42b, 0xda59, 0x1bd1, 0x642c, 0xa5a4, 0x18c8, 0xd940, 0xa6bd, 0x6735, 0x5947, 0x98cf,
            0xe732, 0x26ba, 0xa08f, 0x6107, 0x1efa, 0xdf72, 0xe100, 0x2088, 0x5f75, 0x9efd, 0x2391,
            0xe219, 0x9de4, 0x5c6c, 0x621e, 0xa396, 0xdc6b, 0x1de3, 0xe7ad, 0x2625, 0x59d8, 0x9850,
            0xa622, 0x67aa, 0x1857, 0xd9df, 0x64b3, 0xa53b, 0xdac6, 0x1b4e, 0x253c, 0xe4b4, 0x9b49,
            0x5ac1, 0xdcf4, 0x1d7c, 0x6281, 0xa309, 0x9d7b, 0x5cf3, 0x230e, 0xe286, 0x5fea, 0x9e62,
            0xe19f, 0x2017, 0x1e65, 0xdfed, 0xa010, 0x6198, 0x911f, 0x5097, 0x2f6a, 0xeee2, 0xd090,
            0x1118, 0x6ee5, 0xaf6d, 0x1201, 0xd389, 0xac74, 0x6dfc, 0x538e, 0x9206, 0xedfb, 0x2c73,
            0xaa46, 0x6bce, 0x1433, 0xd5bb, 0xebc9, 0x2a41, 0x55bc, 0x9434, 0x2958, 0xe8d0, 0x972d,
            0x56a5, 0x68d7, 0xa95f, 0xd6a2, 0x172a, 0x0ac9, 0xcb41, 0xb4bc, 0x7534, 0x4b46, 0x8ace,
            0xf533, 0x34bb, 0x89d7, 0x485f, 0x37a2, 0xf62a, 0xc858, 0x09d0, 0x762d, 0xb7a5, 0x3190,
            0xf018, 0x8fe5, 0x4e6d, 0x701f, 0xb197, 0xce6a, 0x0fe2, 0xb28e, 0x7306, 0x0cfb, 0xcd73,
            0xf301, 0x3289, 0x4d74, 0x8cfc, 0x7c7b, 0xbdf3, 0xc20e, 0x0386, 0x3df4, 0xfc7c, 0x8381,
            0x4209, 0xff65, 0x3eed, 0x4110, 0x8098, 0xbeea, 0x7f62, 0x009f, 0xc117, 0x4722, 0x86aa,
            0xf957, 0x38df, 0x06ad, 0xc725, 0xb8d8, 0x7950, 0xc43c, 0x05b4, 0x7a49, 0xbbc1, 0x85b3,
            0x443b, 0x3bc6, 0xfa4e,
        ],
        [
            0x0000, 0xf23f, 0xd91b, 0x2b24, 0x8f53, 0x7d6c, 0x5648, 0xa477, 0x23c3, 0xd1fc, 0xfad8,
            0x08e7, 0xac90, 0x5eaf, 0x758b, 0x87b4, 0x4786, 0xb5b9, 0x9e9d, 0x6ca2, 0xc8d5, 0x3aea,
            0x11ce, 0xe3f1, 0x6445, 0x967a, 0xbd5e, 0x4f61, 0xeb16, 0x1929, 0x320d, 0xc032, 0x8f0c,
            0x7d33, 0x5617, 0xa428, 0x005f, 0xf260, 0xd944, 0x2b7b, 0xaccf, 0x5ef0, 0x75d4, 0x87eb,
            0x239c, 0xd1a3, 0xfa87, 0x08b8, 0xc88a, 0x3ab5, 0x1191, 0xe3ae, 0x47d9, 0xb5e6, 0x9ec2,
            0x6cfd, 0xeb49, 0x1976, 0x3252, 0xc06d, 0x641a, 0x9625, 0xbd01, 0x4f3e, 0x237d, 0xd142,
            0xfa66, 0x0859, 0xac2e, 0x5e11, 0x7535, 0x870a, 0x00be, 0xf281, 0xd9a5, 0x2b9a, 0x8fed,
            0x7dd2, 0x56f6, 0xa4c9, 0x64fb, 0x96c4, 0xbde0, 0x4fdf, 0xeba8, 0x1997, 0x32b3, 0xc08c,
            0x4738, 0xb507, 0x9e23, 0x6c1c, 0xc86b, 0x3a54, 0x1170, 0xe34f, 0xac71, 0x5e4e, 0x756a,
            0x8755, 0x2322, 0xd11d, 0xfa39, 0x0806, 0x8fb2, 0x7d8d, 0x56a9, 0xa496, 0x00e1, 0xf2de,
            0xd9fa, 0x2bc5, 0xebf7, 0x19c8, 0x32ec, 0xc0d3, 0x64a4, 0x969b, 0xbdbf, 0x4f80, 0xc834,
            0x3a0b, 0x112f, 0xe310, 0x4767, 0xb558, 0x9e7c, 0x6c43, 0x46fa, 0xb4c5, 0x9fe1, 0x6dde,
            0xc9a9, 0x3b96, 0x10b2, 0xe28d, 0x6539, 0x9706, 0xbc22, 0x4e1d, 0xea6a, 0x1855, 0x3371,
            0xc14e, 0x017c, 0xf343, 0xd867, 0x2a58, 0x8e2f, 0x7c10, 0x5734, 0xa50b, 0x22bf, 0xd080,
            0xfba4, 0x099b, 0xadec, 0x5fd3, 0x74f7, 0x86c8, 0xc9f6, 0x3bc9, 0x10ed, 0xe2d2, 0x46a5,
            0xb49a, 0x9fbe, 0x6d81, 0xea35, 0x180a, 0x332e, 0xc111, 0x6566, 0x9759, 0xbc7d, 0x4e42,
            0x8e70, 0x7c4f, 0x576b, 0xa554, 0x0123, 0xf31c, 0xd838, 0x2a07, 0xadb3, 0x5f8c, 0x74a8,
            0x8697, 0x22e0, 0xd0df, 0xfbfb, 0x09c4, 0x6587, 0x97b8, 0xbc9c, 0x4ea3, 0xead4, 0x18eb,
            0x33cf, 0xc1f0, 0x4644, 0xb47b, 0x9f5f, 0x6d60, 0xc917, 0x3b28, 0x100c, 0xe233, 0x2201,
            0xd03e, 0xfb1a, 0x0925, 0xad52, 0x5f6d, 0x7449, 0x8676, 0x01c2, 0xf3fd, 0xd8d9, 0x2ae6,
            0x8e91, 0x7cae, 0x578a, 0xa5b5, 0xea8b, 0x18b4, 0x3390, 0xc1af, 0x65d8, 0x97e7, 0xbcc3,
            0x4efc, 0xc948, 0x3b77, 0x1053, 0xe26c, 0x461b, 0xb424, 0x9f00, 0x6d3f, 0xad0d, 0x5f32,
            0x7416, 0x8629, 0x225e, 0xd061, 0xfb45, 0x097a, 0x8ece, 0x7cf1, 0x57d5, 0xa5ea, 0x019d,
            0xf3a2, 0xd886, 0x2ab9,
        ],
        [
            0x0000, 0x8df4, 0x268d, 0xab79, 0x4d1a, 0xc0ee, 0x6b97, 0xe663, 0x9a34, 0x17c0, 0xbcb9,
            0x314d, 0xd72e, 0x5ada, 0xf1a3, 0x7c57, 0x090d, 0x84f9, 0x2f80, 0xa274, 0x4417, 0xc9e3,
            0x629a, 0xef6e, 0x9339, 0x1ecd, 0xb5b4, 0x3840, 0xde23, 0x53d7, 0xf8ae, 0x755a, 0x121a,
            0x9fee, 0x3497, 0xb963, 0x5f00, 0xd2f4, 0x798d, 0xf479, 0x882e, 0x05da, 0xaea3, 0x2357,
            0xc534, 0x48c0, 0xe3b9, 0x6e4d, 0x1b17, 0x96e3, 0x3d9a, 0xb06e, 0x560d, 0xdbf9, 0x7080,
            0xfd74, 0x8123, 0x0cd7, 0xa7ae, 0x2a5a, 0xcc39, 0x41cd, 0xeab4, 0x6740, 0x2434, 0xa9c0,
            0x02b9, 0x8f4d, 0x692e, 0xe4da, 0x4fa3, 0xc257, 0xbe00, 0x33f4, 0x988d, 0x1579, 0xf31a,
            0x7eee, 0xd597, 0x5863, 0x2d39, 0xa0cd, 0x0bb4, 0x8640, 0x6023, 0xedd7, 0x46ae, 0xcb5a,
            0xb70d, 0x3af9, 0x9180, 0x1c74, 0xfa17, 0x77e3, 0xdc9a, 0x516e, 0x362e, 0xbbda, 0x10a3,
            0x9d57, 0x7b34, 0xf6c0, 0x5db9, 0xd04d, 0xac1a, 0x21ee, 0x8a97, 0x0763, 0xe100, 0x6cf4,
            0xc78d, 0x4a79, 0x3f23, 0xb2d7, 0x19ae, 0x945a, 0x7239, 0xffcd, 0x54b4, 0xd940, 0xa517,
            0x28e3, 0x839a, 0x0e6e, 0xe80d, 0x65f9, 0xce80, 0x4374, 0x4868, 0xc59c, 0x6ee5, 0xe311,
            0x0572, 0x8886, 0x23ff, 0xae0b, 0xd25c, 0x5fa8, 0xf4d1, 0x7925, 0x9f46, 0x12b2, 0xb9cb,
            0x343f, 0x4165, 0xcc91, 0x67e8, 0xea1c, 0x0c7f, 0x818b, 0x2af2, 0xa706, 0xdb51, 0x56a5,
            0xfddc, 0x7028, 0x964b, 0x1bbf, 0xb0c6, 0x3d32, 0x5a72, 0xd786, 0x7cff, 0xf10b, 0x1768,
            0x9a9c, 0x31e5, 0xbc11, 0xc046, 0x4db2, 0xe6cb, 0x6b3f, 0x8d5c, 0x00a8, 0xabd1, 0x2625,
            0x537f, 0xde8b, 0x75f2, 0xf806, 0x1e65, 0x9391, 0x38e8, 0xb51c, 0xc94b, 0x44bf, 0xefc6,
            0x6232, 0x8451, 0x09a5, 0xa2dc, 0x2f28, 0x6c5c, 0xe1a8, 0x4ad1, 0xc725, 0x2146, 0xacb2,
            0x07cb, 0x8a3f, 0xf668, 0x7b9c, 0xd0e5, 0x5d11, 0xbb72, 0x3686, 0x9dff, 0x100b, 0x6551,
            0xe8a5, 0x43dc, 0xce28, 0x284b, 0xa5bf, 0x0ec6, 0x8332, 0xff65, 0x7291, 0xd9e8, 0x541c,
            0xb27f, 0x3f8b, 0x94f2, 0x1906, 0x7e46, 0xf3b2, 0x58cb, 0xd53f, 0x335c, 0xbea8, 0x15d1,
            0x9825, 0xe472, 0x6986, 0xc2ff, 0x4f0b, 0xa968, 0x249c, 0x8fe5, 0x0211, 0x774b, 0xfabf,
            0x51c6, 0xdc32, 0x3a51, 0xb7a5, 0x1cdc, 0x9128, 0xed7f, 0x608b, 0xcbf2, 0x4606, 0xa065,
            0x2d91, 0x86e8, 0x0b1c,
        ],
        [
            0x0000, 0x90d0, 0x1cc5, 0x8c15, 0x398a, 0xa95a, 0x254f, 0xb59f, 0x7314, 0xe3c4, 0x6fd1,
            0xff01, 0x4a9e, 0xda4e, 0x565b, 0xc68b, 0xe628, 0x76f8, 0xfaed, 0x6a3d, 0xdfa2, 0x4f72,
            0xc367, 0x53b7, 0x953c, 0x05ec, 0x89f9, 0x1929, 0xacb6, 0x3c66, 0xb073, 0x20a3, 0xf135,
            0x61e5, 0xedf0, 0x7d20, 0xc8bf, 0x586f, 0xd47a, 0x44aa, 0x8221, 0x12f1, 0x9ee4, 0x0e34,
            0xbbab, 0x2b7b, 0xa76e, 0x37be, 0x171d, 0x87cd, 0x0bd8, 0x9b08, 0x2e97, 0xbe47, 0x3252,
            0xa282, 0x6409, 0xf4d9, 0x78cc, 0xe81c, 0x5d83, 0xcd53, 0x4146, 0xd196, 0xdf0f, 0x4fdf,
            0xc3ca, 0x531a, 0xe685, 0x7655, 0xfa40, 0x6a90, 0xac1b, 0x3ccb, 0xb0de, 0x200e, 0x9591,
            0x0541, 0x8954, 0x1984, 0x3927, 0xa9f7, 0x25e2, 0xb532, 0x00ad, 0x907d, 0x1c68, 0x8cb8,
            0x4a33, 0xdae3, 0x56f6, 0xc626, 0x73b9, 0xe369, 0x6f7c, 0xffac, 0x2e3a, 0xbeea, 0x32ff,
            0xa22f, 0x17b0, 0x8760, 0x0b75, 0x9ba5, 0x5d2e, 0xcdfe, 0x41eb, 0xd13b, 0x64a4, 0xf474,
            0x7861, 0xe8b1, 0xc812, 0x58c2, 0xd4d7, 0x4407, 0xf198, 0x6148, 0xed5d, 0x7d8d, 0xbb06,
            0x2bd6, 0xa7c3, 0x3713, 0x828c, 0x125c, 0x9e49, 0x0e99, 0x837b, 0x13ab, 0x9fbe, 0x0f6e,
            0xbaf1, 0x2a21, 0xa634, 0x36e4, 0xf06f, 0x60bf, 0xecaa, 0x7c7a, 0xc9e5, 0x5935, 0xd520,
            0x45f0, 0x6553, 0xf583, 0x7996, 0xe946, 0x5cd9, 0xcc09, 0x401c, 0xd0cc, 0x1647, 0x8697,
            0x0a82, 0x9a52, 0x2fcd, 0xbf1d, 0x3308, 0xa3d8, 0x724e, 0xe29e, 0x6e8b, 0xfe5b, 0x4bc4,
            0xdb14, 0x5701, 0xc7d1, 0x015a, 0x918a, 0x1d9f, 0x8d4f, 0x38d0, 0xa800, 0x2415, 0xb4c5,
            0x9466, 0x04b6, 0x88a3, 0x1873, 0xadec, 0x3d3c, 0xb129, 0x21f9, 0xe772, 0x77a2, 0xfbb7,
            0x6b67, 0xdef8, 0x4e28, 0xc23d, 0x52ed, 0x5c74, 0xcca4, 0x40b1, 0xd061, 0x65fe, 0xf52e,
            0x793b, 0xe9eb, 0x2f60, 0xbfb0, 0x33a5, 0xa375, 0x16ea, 0x863a, 0x0a2f, 0x9aff, 0xba5c,
            0x2a8c, 0xa699, 0x3649, 0x83d6, 0x1306, 0x9f13, 0x0fc3, 0xc948, 0x5998, 0xd58d, 0x455d,
            0xf0c2, 0x6012, 0xec07, 0x7cd7, 0xad41, 0x3d91, 0xb184, 0x2154, 0x94cb, 0x041b, 0x880e,
            0x18de, 0xde55, 0x4e85, 0xc290, 0x5240, 0xe7df, 0x770f, 0xfb1a, 0x6bca, 0x4b69, 0xdbb9,
            0x57ac, 0xc77c, 0x72e3, 0xe233, 0x6e26, 0xfef6, 0x387d, 0xa8ad, 0x24b8, 0xb468, 0x01f7,
            0x9127, 0x1d32, 0x8de2,
        ],
        [
            0x0000, 0x3b93, 0x7726, 0x4cb5, 0xee4c, 0xd5df, 0x996a, 0xa2f9, 0xe1fd, 0xda6e, 0x96db,
            0xad48, 0x0fb1, 0x3422, 0x7897, 0x4304, 0xfe9f, 0xc50c, 0x89b9, 0xb22a, 0x10d3, 0x2b40,
            0x67f5, 0x5c66, 0x1f62, 0x24f1, 0x6844, 0x53d7, 0xf12e, 0xcabd, 0x8608, 0xbd9b, 0xc05b,
            0xfbc8, 0xb77d, 0x8cee, 0x2e17, 0x1584, 0x5931, 0x62a2, 0x21a6, 0x1a35, 0x5680, 0x6d13,
            0xcfea, 0xf479, 0xb8cc, 0x835f, 0x3ec4, 0x0557, 0x49e2, 0x7271, 0xd088, 0xeb1b, 0xa7ae,
            0x9c3d, 0xdf39, 0xe4aa, 0xa81f, 0x938c, 0x3175, 0x0ae6, 0x4653, 0x7dc0, 0xbdd3, 0x8640,
            0xcaf5, 0xf166, 0x539f, 0x680c, 0x24b9, 0x1f2a, 0x5c2e, 0x67bd, 0x2b08, 0x109b, 0xb262,
            0x89f1, 0xc544, 0xfed7, 0x434c, 0x78df, 0x346a, 0x0ff9, 0xad00, 0x9693, 0xda26, 0xe1b5,
            0xa2b1, 0x9922, 0xd597, 0xee04, 0x4cfd, 0x776e, 0x3bdb, 0x0048, 0x7d88, 0x461b, 0x0aae,
            0x313d, 0x93c4, 0xa857, 0xe4e2, 0xdf71, 0x9c75, 0xa7e6, 0xeb53, 0xd0c0, 0x7239, 0x49aa,
            0x051f, 0x3e8c, 0x8317, 0xb884, 0xf431, 0xcfa2, 0x6d5b, 0x56c8, 0x1a7d, 0x21ee, 0x62ea,
            0x5979, 0x15cc, 0x2e5f, 0x8ca6, 0xb735, 0xfb80, 0xc013, 0x46c3, 0x7d50, 0x31e5, 0x0a76,
            0xa88f, 0x931c, 0xdfa9, 0xe43a, 0xa73e, 0x9cad, 0xd018, 0xeb8b, 0x4972, 0x72e1, 0x3e54,
            0x05c7, 0xb85c, 0x83cf, 0xcf7a, 0xf4e9, 0x5610, 0x6d83, 0x2136, 0x1aa5, 0x59a1, 0x6232,
            0x2e87, 0x1514, 0xb7ed, 0x8c7e, 0xc0cb, 0xfb58, 0x8698, 0xbd0b, 0xf1be, 0xca2d, 0x68d4,
            0x5347, 0x1ff2, 0x2461, 0x6765, 0x5cf6, 0x1043, 0x2bd0, 0x8929, 0xb2ba, 0xfe0f, 0xc59c,
            0x7807, 0x4394, 0x0f21, 0x34b2, 0x964b, 0xadd8, 0xe16d, 0xdafe, 0x99fa, 0xa269, 0xeedc,
            0xd54f, 0x77b6, 0x4c25, 0x0090, 0x3b03, 0xfb10, 0xc083, 0x8c36, 0xb7a5, 0x155c, 0x2ecf,
            0x627a, 0x59e9, 0x1aed, 0x217e, 0x6dcb, 0x5658, 0xf4a1, 0xcf32, 0x8387, 0xb814, 0x058f,
            0x3e1c, 0x72a9, 0x493a, 0xebc3, 0xd050, 0x9ce5, 0xa776, 0xe472, 0xdfe1, 0x9354, 0xa8c7,
            0x0a3e, 0x31ad, 0x7d18, 0x468b, 0x3b4b, 0x00d8, 0x4c6d, 0x77fe, 0xd507, 0xee94, 0xa221,
            0x99b2, 0xdab6, 0xe125, 0xad90, 0x9603, 0x34fa, 0x0f69, 0x43dc, 0x784f, 0xc5d4, 0xfe47,
            0xb2f2, 0x8961, 0x2b98, 0x100b, 0x5cbe, 0x672d, 0x2429, 0x1fba, 0x530f, 0x689c, 0xca65,
            0xf1f6, 0xbd43, 0x86d0,
        ],
        [
            0x0000, 0x8d86, 0x2669, 0xabef, 0x4cd2, 0xc154, 0x6abb, 0xe73d, 0x99a4, 0x1422, 0xbfcd,
            0x324b, 0xd576, 0x58f0, 0xf31f, 0x7e99, 0x0e2d, 0x83ab, 0x2844, 0xa5c2, 0x42ff, 0xcf79,
            0x6496, 0xe910, 0x9789, 0x1a0f, 0xb1e0, 0x3c66, 0xdb5b, 0x56dd, 0xfd32, 0x70b4, 0x1c5a,
            0x91dc, 0x3a33, 0xb7b5, 0x5088, 0xdd0e, 0x76e1, 0xfb67, 0x85fe, 0x0878, 0xa397, 0x2e11,
            0xc92c, 0x44aa, 0xef45, 0x62c3, 0x1277, 0x9ff1, 0x341e, 0xb998, 0x5ea5, 0xd323, 0x78cc,
            0xf54a, 0x8bd3, 0x0655, 0xadba, 0x203c, 0xc701, 0x4a87, 0xe168, 0x6cee, 0x38b4, 0xb532,
            0x1edd, 0x935b, 0x7466, 0xf9e0, 0x520f, 0xdf89, 0xa110, 0x2c96, 0x8779, 0x0aff, 0xedc2,
            0x6044, 0xcbab, 0x462d, 0x3699, 0xbb1f, 0x10f0, 0x9d76, 0x7a4b, 0xf7cd, 0x5c22, 0xd1a4,
            0xaf3d, 0x22bb, 0x8954, 0x04d2, 0xe3ef, 0x6e69, 0xc586, 0x4800, 0x24ee, 0xa968, 0x0287,
            0x8f01, 0x683c, 0xe5ba, 0x4e55, 0xc3d3, 0xbd4a, 0x30cc, 0x9b23, 0x16a5, 0xf198, 0x7c1e,
            0xd7f1, 0x5a77, 0x2ac3, 0xa745, 0x0caa, 0x812c, 0x6611, 0xeb97, 0x4078, 0xcdfe, 0xb367,
            0x3ee1, 0x950e, 0x1888, 0xffb5, 0x7233, 0xd9dc, 0x545a, 0x7168, 0xfcee, 0x5701, 0xda87,
            0x3dba, 0xb03c, 0x1bd3, 0x9655, 0xe8cc, 0x654a, 0xcea5, 0x4323, 0xa41e, 0x2998, 0x8277,
            0x0ff1, 0x7f45, 0xf2c3, 0x592c, 0xd4aa, 0x3397, 0xbe11, 0x15fe, 0x9878, 0xe6e1, 0x6b67,
            0xc088, 0x4d0e, 0xaa33, 0x27b5, 0x8c5a, 0x01dc, 0x6d32, 0xe0b4, 0x4b5b, 0xc6dd, 0x21e0,
            0xac66, 0x0789, 0x8a0f, 0xf496, 0x7910, 0xd2ff, 0x5f79, 0xb844, 0x35c2, 0x9e2d, 0x13ab,
            0x631f, 0xee99, 0x4576, 0xc8f0, 0x2fcd, 0xa24b, 0x09a4, 0x8422, 0xfabb, 0x773d, 0xdcd2,
            0x5154, 0xb669, 0x3bef, 0x9000, 0x1d86, 0x49dc, 0xc45a, 0x6fb5, 0xe233, 0x050e, 0x8888,
            0x2367, 0xaee1, 0xd078, 0x5dfe, 0xf611, 0x7b97, 0x9caa, 0x112c, 0xbac3, 0x3745, 0x47f1,
            0xca77, 0x6198, 0xec1e, 0x0b23, 0x86a5, 0x2d4a, 0xa0cc, 0xde55, 0x53d3, 0xf83c, 0x75ba,
            0x9287, 0x1f01, 0xb4ee, 0x3968, 0x5586, 0xd800, 0x73ef, 0xfe69, 0x1954, 0x94d2, 0x3f3d,
            0xb2bb, 0xcc22, 0x41a4, 0xea4b, 0x67cd, 0x80f0, 0x0d76, 0xa699, 0x2b1f, 0x5bab, 0xd62d,
            0x7dc2, 0xf044, 0x1779, 0x9aff, 0x3110, 0xbc96, 0xc20f, 0x4f89, 0xe466, 0x69e0, 0x8edd,
            0x035b, 0xa8b4, 0x2532,
        ],
        [
            0x0000, 0xe2d0, 0xf8c5, 0x1a15, 0xccef, 0x2e3f, 0x342a, 0xd6fa, 0xa4bb, 0x466b, 0x5c7e,
            0xbeae, 0x6854, 0x8a84, 0x9091, 0x7241, 0x7413, 0x96c3, 0x8cd6, 0x6e06, 0xb8fc, 0x5a2c,
            0x4039, 0xa2e9, 0xd0a8, 0x3278, 0x286d, 0xcabd, 0x1c47, 0xfe97, 0xe482, 0x0652, 0xe826,
            0x0af6, 0x10e3, 0xf233, 0x24c9, 0xc619, 0xdc0c, 0x3edc, 0x4c9d, 0xae4d, 0xb458, 0x5688,
            0x8072, 0x62a2, 0x78b7, 0x9a67, 0x9c35, 0x7ee5, 0x64f0, 0x8620, 0x50da, 0xb20a, 0xa81f,
            0x4acf, 0x388e, 0xda5e, 0xc04b, 0x229b, 0xf461, 0x16b1, 0x0ca4, 0xee74, 0xed29, 0x0ff9,
            0x15ec, 0xf73c, 0x21c6, 0xc316, 0xd903, 0x3bd3, 0x4992, 0xab42, 0xb157, 0x5387, 0x857d,
            0x67ad, 0x7db8, 0x9f68, 0x993a, 0x7bea, 0x61ff, 0x832f, 0x55d5, 0xb705, 0xad10, 0x4fc0,
            0x3d81, 0xdf51, 0xc544, 0x2794, 0xf16e, 0x13be, 0x09ab, 0xeb7b, 0x050f, 0xe7df, 0xfdca,
            0x1f1a, 0xc9e0, 0x2b30, 0x3125, 0xd3f5, 0xa1b4, 0x4364, 0x5971, 0xbba1, 0x6d5b, 0x8f8b,
            0x959e, 0x774e, 0x711c, 0x93cc, 0x89d9, 0x6b09, 0xbdf3, 0x5f23, 0x4536, 0xa7e6, 0xd5a7,
            0x3777, 0x2d62, 0xcfb2, 0x1948, 0xfb98, 0xe18d, 0x035d, 0xe737, 0x05e7, 0x1ff2, 0xfd22,
            0x2bd8, 0xc908, 0xd31d, 0x31cd, 0x438c, 0xa15c, 0xbb49, 0x5999, 0x8f63, 0x6db3, 0x77a6,
            0x9576, 0x9324, 0x71f4, 0x6be1, 0x8931, 0x5fcb, 0xbd1b, 0xa70e, 0x45de, 0x379f, 0xd54f,
            0xcf5a, 0x2d8a, 0xfb70, 0x19a0, 0x03b5, 0xe165, 0x0f11, 0xedc1, 0xf7d4, 0x1504, 0xc3fe,
            0x212e, 0x3b3b, 0xd9eb, 0xabaa, 0x497a, 0x536f, 0xb1bf, 0x6745, 0x8595, 0x9f80, 0x7d50,
            0x7b02, 0x99d2, 0x83c7, 0x6117, 0xb7ed, 0x553d, 0x4f28, 0xadf8, 0xdfb9, 0x3d69, 0x277c,
            0xc5ac, 0x1356, 0xf186, 0xeb93, 0x0943, 0x0a1e, 0xe8ce, 0xf2db, 0x100b, 0xc6f1, 0x2421,
            0x3e34, 0xdce4, 0xaea5, 0x4c75, 0x5660, 0xb4b0, 0x624a, 0x809a, 0x9a8f, 0x785f, 0x7e0d,
            0x9cdd, 0x86c8, 0x6418, 0xb2e2, 0x5032, 0x4a27, 0xa8f7, 0xdab6, 0x3866, 0x2273, 0xc0a3,
            0x1659, 0xf489, 0xee9c, 0x0c4c, 0xe238, 0x00e8, 0x1afd, 0xf82d, 0x2ed7, 0xcc07, 0xd612,
            0x34c2, 0x4683, 0xa453, 0xbe46, 0x5c96, 0x8a6c, 0x68bc, 0x72a9, 0x9079, 0x962b, 0x74fb,
            0x6eee, 0x8c3e, 0x5ac4, 0xb814, 0xa201, 0x40d1, 0x3290, 0xd040, 0xca55, 0x2885, 0xfe7f,
            0x1caf, 0x06ba, 0xe46a,
        ],
        [
            0x0000, 0xf30b, 0xdb73, 0x2878, 0x8b83, 0x7888, 0x50f0, 0xa3fb, 0x2a63, 0xd968, 0xf110,
            0x021b, 0xa1e0, 0x52eb, 0x7a93, 0x8998, 0x54c6, 0xa7cd, 0x8fb5, 0x7cbe, 0xdf45, 0x2c4e,
            0x0436, 0xf73d, 0x7ea5, 0x8dae, 0xa5d6, 0x56dd, 0xf526, 0x062d, 0x2e55, 0xdd5e, 0xa98c,
            0x5a87, 0x72ff, 0x81f4, 0x220f, 0xd104, 0xf97c, 0x0a77, 0x83ef, 0x70e4, 0x589c, 0xab97,
            0x086c, 0xfb67, 0xd31f, 0x2014, 0xfd4a, 0x0e41, 0x2639, 0xd532, 0x76c9, 0x85c2, 0xadba,
            0x5eb1, 0xd729, 0x2422, 0x0c5a, 0xff51, 0x5caa, 0xafa1, 0x87d9, 0x74d2, 0x6e7d, 0x9d76,
            0xb50e, 0x4605, 0xe5fe, 0x16f5, 0x3e8d, 0xcd86, 0x441e, 0xb715, 0x9f6d, 0x6c66, 0xcf9d,
            0x3c96, 0x14ee, 0xe7e5, 0x3abb, 0xc9b0, 0xe1c8, 0x12c3, 0xb138, 0x4233, 0x6a4b, 0x9940,
            0x10d8, 0xe3d3, 0xcbab, 0x38a0, 0x9b5b, 0x6850, 0x4028, 0xb323, 0xc7f1, 0x34fa, 0x1c82,
            0xef89, 0x4c72, 0xbf79, 0x9701, 0x640a, 0xed92, 0x1e99, 0x36e1, 0xc5ea, 0x6611, 0x951a,
            0xbd62, 0x4e69, 0x9337, 0x603c, 0x4844, 0xbb4f, 0x18b4, 0xebbf, 0xc3c7, 0x30cc, 0xb954,
            0x4a5f, 0x6227, 0x912c, 0x32d7, 0xc1dc, 0xe9a4, 0x1aaf, 0xdcfa, 0x2ff1, 0x0789, 0xf482,
            0x5779, 0xa472, 0x8c0a, 0x7f01, 0xf699, 0x0592, 0x2dea, 0xdee1, 0x7d1a, 0x8e11, 0xa669,
            0x5562, 0x883c, 0x7b37, 0x534f, 0xa044, 0x03bf, 0xf0b4, 0xd8cc, 0x2bc7, 0xa25f, 0x5154,
            0x792c, 0x8a27, 0x29dc, 0xdad7, 0xf2af, 0x01a4, 0x7576, 0x867d, 0xae05, 0x5d0e, 0xfef5,
            0x0dfe, 0x2586, 0xd68d, 0x5f15, 0xac1e, 0x8466, 0x776d, 0xd496, 0x279d, 0x0fe5, 0xfcee,
            0x21b0, 0xd2bb, 0xfac3, 0x09c8, 0xaa33, 0x5938, 0x7140, 0x824b, 0x0bd3, 0xf8d8, 0xd0a0,
            0x23ab, 0x8050, 0x735b, 0x5b23, 0xa828, 0xb287, 0x418c, 0x69f4, 0x9aff, 0x3904, 0xca0f,
            0xe277, 0x117c, 0x98e4, 0x6bef, 0x4397, 0xb09c, 0x1367, 0xe06c, 0xc814, 0x3b1f, 0xe641,
            0x154a, 0x3d32, 0xce39, 0x6dc2, 0x9ec9, 0xb6b1, 0x45ba, 0xcc22, 0x3f29, 0x1751, 0xe45a,
            0x47a1, 0xb4aa, 0x9cd2, 0x6fd9, 0x1b0b, 0xe800, 0xc078, 0x3373, 0x9088, 0x6383, 0x4bfb,
            0xb8f0, 0x3168, 0xc263, 0xea1b, 0x1910, 0xbaeb, 0x49e0, 0x6198, 0x9293, 0x4fcd, 0xbcc6,
            0x94be, 0x67b5, 0xc44e, 0x3745, 0x1f3d, 0xec36, 0x65ae, 0x96a5, 0xbedd, 0x4dd6, 0xee2d,
            0x1d26, 0x355e, 0xc655,
        ],
        [
            0x0000, 0x8491, 0x3447, 0xb0d6, 0x688e, 0xec1f, 0x5cc9, 0xd858, 0xd11c, 0x558d, 0xe55b,
            0x61ca, 0xb992, 0x3d03, 0x8dd5, 0x0944, 0x9f5d, 0x1bcc, 0xab1a, 0x2f8b, 0xf7d3, 0x7342,
            0xc394, 0x4705, 0x4e41, 0xcad0, 0x7a06, 0xfe97, 0x26cf, 0xa25e, 0x1288, 0x9619, 0x03df,
            0x874e, 0x3798, 0xb309, 0x6b51, 0xefc0, 0x5f16, 0xdb87, 0xd2c3, 0x5652, 0xe684, 0x6215,
            0xba4d, 0x3edc, 0x8e0a, 0x0a9b, 0x9c82, 0x1813, 0xa8c5, 0x2c54, 0xf40c, 0x709d, 0xc04b,
            0x44da, 0x4d9e, 0xc90f, 0x79d9, 0xfd48, 0x2510, 0xa181, 0x1157, 0x95c6, 0x07be, 0x832f,
            0x33f9, 0xb768, 0x6f30, 0xeba1, 0x5b77, 0xdfe6, 0xd6a2, 0x5233, 0xe2e5, 0x6674, 0xbe2c,
            0x3abd, 0x8a6b, 0x0efa, 0x98e3, 0x1c72, 0xaca4, 0x2835, 0xf06d, 0x74fc, 0xc42a, 0x40bb,
            0x49ff, 0xcd6e, 0x7db8, 0xf929, 0x2171, 0xa5e0, 0x1536, 0x91a7, 0x0461, 0x80f0, 0x3026,
            0xb4b7, 0x6cef, 0xe87e, 0x58a8, 0xdc39, 0xd57d, 0x51ec, 0xe13a, 0x65ab, 0xbdf3, 0x3962,
            0x89b4, 0x0d25, 0x9b3c, 0x1fad, 0xaf7b, 0x2bea, 0xf3b2, 0x7723, 0xc7f5, 0x4364, 0x4a20,
            0xceb1, 0x7e67, 0xfaf6, 0x22ae, 0xa63f, 0x16e9, 0x9278, 0x0f7c, 0x8bed, 0x3b3b, 0xbfaa,
            0x67f2, 0xe363, 0x53b5, 0xd724, 0xde60, 0x5af1, 0xea27, 0x6eb6, 0xb6ee, 0x327f, 0x82a9,
            0x0638, 0x9021, 0x14b0, 0xa466, 0x20f7, 0xf8af, 0x7c3e, 0xcce8, 0x4879, 0x413d, 0xc5ac,
            0x757a, 0xf1eb, 0x29b3, 0xad22, 0x1df4, 0x9965, 0x0ca3, 0x8832, 0x38e4, 0xbc75, 0x642d,
            0xe0bc, 0x506a, 0xd4fb, 0xddbf, 0x592e, 0xe9f8, 0x6d69, 0xb531, 0x31a0, 0x8176, 0x05e7,
            0x93fe, 0x176f, 0xa7b9, 0x2328, 0xfb70, 0x7fe1, 0xcf37, 0x4ba6, 0x42e2, 0xc673, 0x76a5,
            0xf234, 0x2a6c, 0xaefd, 0x1e2b, 0x9aba, 0x08c2, 0x8c53, 0x3c85, 0xb814, 0x604c, 0xe4dd,
            0x540b, 0xd09a, 0xd9de, 0x5d4f, 0xed99, 0x6908, 0xb150, 0x35c1, 0x8517, 0x0186, 0x979f,
            0x130e, 0xa3d8, 0x2749, 0xff11, 0x7b80, 0xcb56, 0x4fc7, 0x4683, 0xc212, 0x72c4, 0xf655,
            0x2e0d, 0xaa9c, 0x1a4a, 0x9edb, 0x0b1d, 0x8f8c, 0x3f5a, 0xbbcb, 0x6393, 0xe702, 0x57d4,
            0xd345, 0xda01, 0x5e90, 0xee46, 0x6ad7, 0xb28f, 0x361e, 0x86c8, 0x0259, 0x9440, 0x10d1,
            0xa007, 0x2496, 0xfcce, 0x785f, 0xc889, 0x4c18, 0x455c, 0xc1cd, 0x711b, 0xf58a, 0x2dd2,
            0xa943, 0x1995, 0x9d04,
        ],
        [
            0x0000, 0x1ef8, 0x3df0, 0x2308, 0x7be0, 0x6518, 0x4610, 0x58e8, 0xf7c0, 0xe938, 0xca30,
            0xd4c8, 0x8c20, 0x92d8, 0xb1d0, 0xaf28, 0xd2e5, 0xcc1d, 0xef15, 0xf1ed, 0xa905, 0xb7fd,
            0x94f5, 0x8a0d, 0x2525, 0x3bdd, 0x18d5, 0x062d, 0x5ec5, 0x403d, 0x6335, 0x7dcd, 0x98af,
            0x8657, 0xa55f, 0xbba7, 0xe34f, 0xfdb7, 0xdebf, 0xc047, 0x6f6f, 0x7197, 0x529f, 0x4c67,
            0x148f, 0x0a77, 0x297f, 0x3787, 0x4a4a, 0x54b2, 0x77ba, 0x6942, 0x31aa, 0x2f52, 0x0c5a,
            0x12a2, 0xbd8a, 0xa372, 0x807a, 0x9e82, 0xc66a, 0xd892, 0xfb9a, 0xe562, 0x0c3b, 0x12c3,
            0x31cb, 0x2f33, 0x77db, 0x6923, 0x4a2b, 0x54d3, 0xfbfb, 0xe503, 0xc60b, 0xd8f3, 0x801b,
            0x9ee3, 0xbdeb, 0xa313, 0xdede, 0xc026, 0xe32e, 0xfdd6, 0xa53e, 0xbbc6, 0x98ce, 0x8636,
            0x291e, 0x37e6, 0x14ee, 0x0a16, 0x52fe, 0x4c06, 0x6f0e, 0x71f6, 0x9494, 0x8a6c, 0xa964,
            0xb79c, 0xef74, 0xf18c, 0xd284, 0xcc7c, 0x6354, 0x7dac, 0x5ea4, 0x405c, 0x18b4, 0x064c,
            0x2544, 0x3bbc, 0x4671, 0x5889, 0x7b81, 0x6579, 0x3d91, 0x2369, 0x0061, 0x1e99, 0xb1b1,
            0xaf49, 0x8c41, 0x92b9, 0xca51, 0xd4a9, 0xf7a1, 0xe959, 0x1876, 0x068e, 0x2586, 0x3b7e,
            0x6396, 0x7d6e, 0x5e66, 0x409e, 0xefb6, 0xf14e, 0xd246, 0xccbe, 0x9456, 0x8aae, 0xa9a6,
            0xb75e, 0xca93, 0xd46b, 0xf763, 0xe99b, 0xb173, 0xaf8b, 0x8c83, 0x927b, 0x3d53, 0x23ab,
            0x00a3, 0x1e5b, 0x46b3, 0x584b, 0x7b43, 0x65bb, 0x80d9, 0x9e21, 0xbd29, 0xa3d1, 0xfb39,
            0xe5c1, 0xc6c9, 0xd831, 0x7719, 0x69e1, 0x4ae9, 0x5411, 0x0cf9, 0x1201, 0x3109, 0x2ff1,
            0x523c, 0x4cc4, 0x6fcc, 0x7134, 0x29dc, 0x3724, 0x142c, 0x0ad4, 0xa5fc, 0xbb04, 0x980c,
            0x86f4, 0xde1c, 0xc0e4, 0xe3ec, 0xfd14, 0x144d, 0x0ab5, 0x29bd, 0x3745, 0x6fad, 0x7155,
            0x525d, 0x4ca5, 0xe38d, 0xfd75, 0xde7d, 0xc085, 0x986d, 0x8695, 0xa59d, 0xbb65, 0xc6a8,
            0xd850, 0xfb58, 0xe5a0, 0xbd48, 0xa3b0, 0x80b8, 0x9e40, 0x3168, 0x2f90, 0x0c98, 0x1260,
            0x4a88, 0x5470, 0x7778, 0x6980, 0x8ce2, 0x921a, 0xb112, 0xafea, 0xf702, 0xe9fa, 0xcaf2,
            0xd40a, 0x7b22, 0x65da, 0x46d2, 0x582a, 0x00c2, 0x1e3a, 0x3d32, 0x23ca, 0x5e07, 0x40ff,
            0x63f7, 0x7d0f, 0x25e7, 0x3b1f, 0x1817, 0x06ef, 0xa9c7, 0xb73f, 0x9437, 0x8acf, 0xd227,
            0xccdf, 0xefd7, 0xf12f,
        ],
        [
            0x0000, 0x30ec, 0x61d8, 0x5134, 0xc3b0, 0xf35c, 0xa268, 0x9284, 0xba05, 0x8ae9, 0xdbdd,
            0xeb31, 0x79b5, 0x4959, 0x186d, 0x2881, 0x496f, 0x7983, 0x28b7, 0x185b, 0x8adf, 0xba33,
            0xeb07, 0xdbeb, 0xf36a, 0xc386, 0x92b2, 0xa25e, 0x30da, 0x0036, 0x5102, 0x61ee, 0x92de,
            0xa232, 0xf306, 0xc3ea, 0x516e, 0x6182, 0x30b6, 0x005a, 0x28db, 0x1837, 0x4903, 0x79ef,
            0xeb6b, 0xdb87, 0x8ab3, 0xba5f, 0xdbb1, 0xeb5d, 0xba69, 0x8a85, 0x1801, 0x28ed, 0x79d9,
            0x4935, 0x61b4, 0x5158, 0x006c, 0x3080, 0xa204, 0x92e8, 0xc3dc, 0xf330, 0x18d9, 0x2835,
            0x7901, 0x49ed, 0xdb69, 0xeb85, 0xbab1, 0x8a5d, 0xa2dc, 0x9230, 0xc304, 0xf3e8, 0x616c,
            0x5180, 0x00b4, 0x3058, 0x51b6, 0x615a, 0x306e, 0x0082, 0x9206, 0xa2ea, 0xf3de, 0xc332,
            0xebb3, 0xdb5f, 0x8a6b, 0xba87, 0x2803, 0x18ef, 0x49db, 0x7937, 0x8a07, 0xbaeb, 0xebdf,
            0xdb33, 0x49b7, 0x795b, 0x286f, 0x1883, 0x3002, 0x00ee, 0x51da, 0x6136, 0xf3b2, 0xc35e,
            0x926a, 0xa286, 0xc368, 0xf384, 0xa2b0, 0x925c, 0x00d8, 0x3034, 0x6100, 0x51ec, 0x796d,
            0x4981, 0x18b5, 0x2859, 0xbadd, 0x8a31, 0xdb05, 0xebe9, 0x31b2, 0x015e, 0x506a, 0x6086,
            0xf202, 0xc2ee, 0x93da, 0xa336, 0x8bb7, 0xbb5b, 0xea6f, 0xda83, 0x4807, 0x78eb, 0x29df,
            0x1933, 0x78dd, 0x4831, 0x1905, 0x29e9, 0xbb6d, 0x8b81, 0xdab5, 0xea59, 0xc2d8, 0xf234,
            0xa300, 0x93ec, 0x0168, 0x3184, 0x60b0, 0x505c, 0xa36c, 0x9380, 0xc2b4, 0xf258, 0x60dc,
            0x5030, 0x0104, 0x31e8, 0x1969, 0x2985, 0x78b1, 0x485d, 0xdad9, 0xea35, 0xbb01, 0x8bed,
            0xea03, 0xdaef, 0x8bdb, 0xbb37, 0x29b3, 0x195f, 0x486b, 0x7887, 0x5006, 0x60ea, 0x31de,
            0x0132, 0x93b6, 0xa35a, 0xf26e, 0xc282, 0x296b, 0x1987, 0x48b3, 0x785f, 0xeadb, 0xda37,
            0x8b03, 0xbbef, 0x936e, 0xa382, 0xf2b6, 0xc25a, 0x50de, 0x6032, 0x3106, 0x01ea, 0x6004,
            0x50e8, 0x01dc, 0x3130, 0xa3b4, 0x9358, 0xc26c, 0xf280, 0xda01, 0xeaed, 0xbbd9, 0x8b35,
            0x19b1, 0x295d, 0x7869, 0x4885, 0xbbb5, 0x8b59, 0xda6d, 0xea81, 0x7805, 0x48e9, 0x19dd,
            0x2931, 0x01b0, 0x315c, 0x6068, 0x5084, 0xc200, 0xf2ec, 0xa3d8, 0x9334, 0xf2da, 0xc236,
            0x9302, 0xa3ee, 0x316a, 0x0186, 0x50b2, 0x605e, 0x48df, 0x7833, 0x2907, 0x19eb, 0x8b6f,
            0xbb83, 0xeab7, 0xda5b,
        ],
    ];

    pub static CRC16_GENIBUS_TABLE: [[u16; 256]; 16] = [
        [
            0x0000, 0x1021, 0x2042, 0x3063, 0x4084, 0x50a5, 0x60c6, 0x70e7, 0x8108, 0x9129, 0xa14a,
            0xb16b, 0xc18c, 0xd1ad, 0xe1ce, 0xf1ef, 0x1231, 0x0210, 0x3273, 0x2252, 0x52b5, 0x4294,
            0x72f7, 0x62d6, 0x9339, 0x8318, 0xb37b, 0xa35a, 0xd3bd, 0xc39c, 0xf3ff, 0xe3de, 0x2462,
            0x3443, 0x0420, 0x1401, 0x64e6, 0x74c7, 0x44a4, 0x5485, 0xa56a, 0xb54b, 0x8528, 0x9509,
            0xe5ee, 0xf5cf, 0xc5ac, 0xd58d, 0x3653, 0x2672, 0x1611, 0x0630, 0x76d7, 0x66f6, 0x5695,
            0x46b4, 0xb75b, 0xa77a, 0x9719, 0x8738, 0xf7df, 0xe7fe, 0xd79d, 0xc7bc, 0x48c4, 0x58e5,
            0x6886, 0x78a7, 0x0840, 0x1861, 0x2802, 0x3823, 0xc9cc, 0xd9ed, 0xe98e, 0xf9af, 0x8948,
            0x9969, 0xa90a, 0xb92b, 0x5af5, 0x4ad4, 0x7ab7, 0x6a96, 0x1a71, 0x0a50, 0x3a33, 0x2a12,
            0xdbfd, 0xcbdc, 0xfbbf, 0xeb9e, 0x9b79, 0x8b58, 0xbb3b, 0xab1a, 0x6ca6, 0x7c87, 0x4ce4,
            0x5cc5, 0x2c22, 0x3c03, 0x0c60, 0x1c41, 0xedae, 0xfd8f, 0xcdec, 0xddcd, 0xad2a, 0xbd0b,
            0x8d68, 0x9d49, 0x7e97, 0x6eb6, 0x5ed5, 0x4ef4, 0x3e13, 0x2e32, 0x1e51, 0x0e70, 0xff9f,
            0xefbe, 0xdfdd, 0xcffc, 0xbf1b, 0xaf3a, 0x9f59, 0x8f78, 0x9188, 0x81a9, 0xb1ca, 0xa1eb,
            0xd10c, 0xc12d, 0xf14e, 0xe16f, 0x1080, 0x00a1, 0x30c2, 0x20e3, 0x5004, 0x4025, 0x7046,
            0x6067, 0x83b9, 0x9398, 0xa3fb, 0xb3da, 0xc33d, 0xd31c, 0xe37f, 0xf35e, 0x02b1, 0x1290,
            0x22f3, 0x32d2, 0x4235, 0x5214, 0x6277, 0x7256, 0xb5ea, 0xa5cb, 0x95a8, 0x8589, 0xf56e,
            0xe54f, 0xd52c, 0xc50d, 0x34e2, 0x24c3, 0x14a0, 0x0481, 0x7466, 0x6447, 0x5424, 0x4405,
            0xa7db, 0xb7fa, 0x8799, 0x97b8, 0xe75f, 0xf77e, 0xc71d, 0xd73c, 0x26d3, 0x36f2, 0x0691,
            0x16b0, 0x6657, 0x7676, 0x4615, 0x5634, 0xd94c, 0xc96d, 0xf90e, 0xe92f, 0x99c8, 0x89e9,
            0xb98a, 0xa9ab, 0x5844, 0x4865, 0x7806, 0x6827, 0x18c0, 0x08e1, 0x3882, 0x28a3, 0xcb7d,
            0xdb5c, 0xeb3f, 0xfb1e, 0x8bf9, 0x9bd8, 0xabbb, 0xbb9a, 0x4a75, 0x5a54, 0x6a37, 0x7a16,
            0x0af1, 0x1ad0, 0x2ab3, 0x3a92, 0xfd2e, 0xed0f, 0xdd6c, 0xcd4d, 0xbdaa, 0xad8b, 0x9de8,
            0x8dc9, 0x7c26, 0x6c07, 0x5c64, 0x4c45, 0x3ca2, 0x2c83, 0x1ce0, 0x0cc1, 0xef1f, 0xff3e,
            0xcf5d, 0xdf7c, 0xaf9b, 0xbfba, 0x8fd9, 0x9ff8, 0x6e17, 0x7e36, 0x4e55, 0x5e74, 0x2e93,
            0x3eb2, 0x0ed1, 0x1ef0,
        ],
        [
            0x0000, 0x3331, 0x6662, 0x5553, 0xccc4, 0xfff5, 0xaaa6, 0x9997, 0x89a9, 0xba98, 0xefcb,
            0xdcfa, 0x456d, 0x765c, 0x230f, 0x103e, 0x0373, 0x3042, 0x6511, 0x5620, 0xcfb7, 0xfc86,
            0xa9d5, 0x9ae4, 0x8ada, 0xb9eb, 0xecb8, 0xdf89, 0x461e, 0x752f, 0x207c, 0x134d, 0x06e6,
            0x35d7, 0x6084, 0x53b5, 0xca22, 0xf913, 0xac40, 0x9f71, 0x8f4f, 0xbc7e, 0xe92d, 0xda1c,
            0x438b, 0x70ba, 0x25e9, 0x16d8, 0x0595, 0x36a4, 0x63f7, 0x50c6, 0xc951, 0xfa60, 0xaf33,
            0x9c02, 0x8c3c, 0xbf0d, 0xea5e, 0xd96f, 0x40f8, 0x73c9, 0x269a, 0x15ab, 0x0dcc, 0x3efd,
            0x6bae, 0x589f, 0xc108, 0xf239, 0xa76a, 0x945b, 0x8465, 0xb754, 0xe207, 0xd136, 0x48a1,
            0x7b90, 0x2ec3, 0x1df2, 0x0ebf, 0x3d8e, 0x68dd, 0x5bec, 0xc27b, 0xf14a, 0xa419, 0x9728,
            0x8716, 0xb427, 0xe174, 0xd245, 0x4bd2, 0x78e3, 0x2db0, 0x1e81, 0x0b2a, 0x381b, 0x6d48,
            0x5e79, 0xc7ee, 0xf4df, 0xa18c, 0x92bd, 0x8283, 0xb1b2, 0xe4e1, 0xd7d0, 0x4e47, 0x7d76,
            0x2825, 0x1b14, 0x0859, 0x3b68, 0x6e3b, 0x5d0a, 0xc49d, 0xf7ac, 0xa2ff, 0x91ce, 0x81f0,
            0xb2c1, 0xe792, 0xd4a3, 0x4d34, 0x7e05, 0x2b56, 0x1867, 0x1b98, 0x28a9, 0x7dfa, 0x4ecb,
            0xd75c, 0xe46d, 0xb13e, 0x820f, 0x9231, 0xa100, 0xf453, 0xc762, 0x5ef5, 0x6dc4, 0x3897,
            0x0ba6, 0x18eb, 0x2bda, 0x7e89, 0x4db8, 0xd42f, 0xe71e, 0xb24d, 0x817c, 0x9142, 0xa273,
            0xf720, 0xc411, 0x5d86, 0x6eb7, 0x3be4, 0x08d5, 0x1d7e, 0x2e4f, 0x7b1c, 0x482d, 0xd1ba,
            0xe28b, 0xb7d8, 0x84e9, 0x94d7, 0xa7e6, 0xf2b5, 0xc184, 0x5813, 0x6b22, 0x3e71, 0x0d40,
            0x1e0d, 0x2d3c, 0x786f, 0x4b5e, 0xd2c9, 0xe1f8, 0xb4ab, 0x879a, 0x97a4, 0xa495, 0xf1c6,
            0xc2f7, 0x5b60, 0x6851, 0x3d02, 0x0e33, 0x1654, 0x2565, 0x7036, 0x4307, 0xda90, 0xe9a1,
            0xbcf2, 0x8fc3, 0x9ffd, 0xaccc, 0xf99f, 0xcaae, 0x5339, 0x6008, 0x355b, 0x066a, 0x1527,
            0x2616, 0x7345, 0x4074, 0xd9e3, 0xead2, 0xbf81, 0x8cb0, 0x9c8e, 0xafbf, 0xfaec, 0xc9dd,
            0x504a, 0x637b, 0x3628, 0x0519, 0x10b2, 0x2383, 0x76d0, 0x45e1, 0xdc76, 0xef47, 0xba14,
            0x8925, 0x991b, 0xaa2a, 0xff79, 0xcc48, 0x55df, 0x66ee, 0x33bd, 0x008c, 0x13c1, 0x20f0,
            0x75a3, 0x4692, 0xdf05, 0xec34, 0xb967, 0x8a56, 0x9a68, 0xa959, 0xfc0a, 0xcf3b, 0x56ac,
            0x659d, 0x30ce, 0x03ff,
        ],
        [
            0x0000, 0x3730, 0x6e60, 0x5950, 0xdcc0, 0xebf0, 0xb2a0, 0x8590, 0xa9a1, 0x9e91, 0xc7c1,
            0xf0f1, 0x7561, 0x4251, 0x1b01, 0x2c31, 0x4363, 0x7453, 0x2d03, 0x1a33, 0x9fa3, 0xa893,
            0xf1c3, 0xc6f3, 0xeac2, 0xddf2, 0x84a2, 0xb392, 0x3602, 0x0132, 0x5862, 0x6f52, 0x86c6,
            0xb1f6, 0xe8a6, 0xdf96, 0x5a06, 0x6d36, 0x3466, 0x0356, 0x2f67, 0x1857, 0x4107, 0x7637,
            0xf3a7, 0xc497, 0x9dc7, 0xaaf7, 0xc5a5, 0xf295, 0xabc5, 0x9cf5, 0x1965, 0x2e55, 0x7705,
            0x4035, 0x6c04, 0x5b34, 0x0264, 0x3554, 0xb0c4, 0x87f4, 0xdea4, 0xe994, 0x1dad, 0x2a9d,
            0x73cd, 0x44fd, 0xc16d, 0xf65d, 0xaf0d, 0x983d, 0xb40c, 0x833c, 0xda6c, 0xed5c, 0x68cc,
            0x5ffc, 0x06ac, 0x319c, 0x5ece, 0x69fe, 0x30ae, 0x079e, 0x820e, 0xb53e, 0xec6e, 0xdb5e,
            0xf76f, 0xc05f, 0x990f, 0xae3f, 0x2baf, 0x1c9f, 0x45cf, 0x72ff, 0x9b6b, 0xac5b, 0xf50b,
            0xc23b, 0x47ab, 0x709b, 0x29cb, 0x1efb, 0x32ca, 0x05fa, 0x5caa, 0x6b9a, 0xee0a, 0xd93a,
            0x806a, 0xb75a, 0xd808, 0xef38, 0xb668, 0x8158, 0x04c8, 0x33f8, 0x6aa8, 0x5d98, 0x71a9,
            0x4699, 0x1fc9, 0x28f9, 0xad69, 0x9a59, 0xc309, 0xf439, 0x3b5a, 0x0c6a, 0x553a, 0x620a,
            0xe79a, 0xd0aa, 0x89fa, 0xbeca, 0x92fb, 0xa5cb, 0xfc9b, 0xcbab, 0x4e3b, 0x790b, 0x205b,
            0x176b, 0x7839, 0x4f09, 0x1659, 0x2169, 0xa4f9, 0x93c9, 0xca99, 0xfda9, 0xd198, 0xe6a8,
            0xbff8, 0x88c8, 0x0d58, 0x3a68, 0x6338, 0x5408, 0xbd9c, 0x8aac, 0xd3fc, 0xe4cc, 0x615c,
            0x566c, 0x0f3c, 0x380c, 0x143d, 0x230d, 0x7a5d, 0x4d6d, 0xc8fd, 0xffcd, 0xa69d, 0x91ad,
            0xfeff, 0xc9cf, 0x909f, 0xa7af, 0x223f, 0x150f, 0x4c5f, 0x7b6f, 0x575e, 0x606e, 0x393e,
            0x0e0e, 0x8b9e, 0xbcae, 0xe5fe, 0xd2ce, 0x26f7, 0x11c7, 0x4897, 0x7fa7, 0xfa37, 0xcd07,
            0x9457, 0xa367, 0x8f56, 0xb866, 0xe136, 0xd606, 0x5396, 0x64a6, 0x3df6, 0x0ac6, 0x6594,
            0x52a4, 0x0bf4, 0x3cc4, 0xb954, 0x8e64, 0xd734, 0xe004, 0xcc35, 0xfb05, 0xa255, 0x9565,
            0x10f5, 0x27c5, 0x7e95, 0x49a5, 0xa031, 0x9701, 0xce51, 0xf961, 0x7cf1, 0x4bc1, 0x1291,
            0x25a1, 0x0990, 0x3ea0, 0x67f0, 0x50c0, 0xd550, 0xe260, 0xbb30, 0x8c00, 0xe352, 0xd462,
            0x8d32, 0xba02, 0x3f92, 0x08a2, 0x51f2, 0x66c2, 0x4af3, 0x7dc3, 0x2493, 0x13a3, 0x9633,
            0xa103, 0xf853, 0xcf63,
        ],
        [
            0x0000, 0x76b4, 0xed68, 0x9bdc, 0xcaf1, 0xbc45, 0x2799, 0x512d, 0x85c3, 0xf377, 0x68ab,
            0x1e1f, 0x4f32, 0x3986, 0xa25a, 0xd4ee, 0x1ba7, 0x6d13, 0xf6cf, 0x807b, 0xd156, 0xa7e2,
            0x3c3e, 0x4a8a, 0x9e64, 0xe8d0, 0x730c, 0x05b8, 0x5495, 0x2221, 0xb9fd, 0xcf49, 0x374e,
            0x41fa, 0xda26, 0xac92, 0xfdbf, 0x8b0b, 0x10d7, 0x6663, 0xb28d, 0xc439, 0x5fe5, 0x2951,
            0x787c, 0x0ec8, 0x9514, 0xe3a0, 0x2ce9, 0x5a5d, 0xc181, 0xb735, 0xe618, 0x90ac, 0x0b70,
            0x7dc4, 0xa92a, 0xdf9e, 0x4442, 0x32f6, 0x63db, 0x156f, 0x8eb3, 0xf807, 0x6e9c, 0x1828,
            0x83f4, 0xf540, 0xa46d, 0xd2d9, 0x4905, 0x3fb1, 0xeb5f, 0x9deb, 0x0637, 0x7083, 0x21ae,
            0x571a, 0xccc6, 0xba72, 0x753b, 0x038f, 0x9853, 0xeee7, 0xbfca, 0xc97e, 0x52a2, 0x2416,
            0xf0f8, 0x864c, 0x1d90, 0x6b24, 0x3a09, 0x4cbd, 0xd761, 0xa1d5, 0x59d2, 0x2f66, 0xb4ba,
            0xc20e, 0x9323, 0xe597, 0x7e4b, 0x08ff, 0xdc11, 0xaaa5, 0x3179, 0x47cd, 0x16e0, 0x6054,
            0xfb88, 0x8d3c, 0x4275, 0x34c1, 0xaf1d, 0xd9a9, 0x8884, 0xfe30, 0x65ec, 0x1358, 0xc7b6,
            0xb102, 0x2ade, 0x5c6a, 0x0d47, 0x7bf3, 0xe02f, 0x969b, 0xdd38, 0xab8c, 0x3050, 0x46e4,
            0x17c9, 0x617d, 0xfaa1, 0x8c15, 0x58fb, 0x2e4f, 0xb593, 0xc327, 0x920a, 0xe4be, 0x7f62,
            0x09d6, 0xc69f, 0xb02b, 0x2bf7, 0x5d43, 0x0c6e, 0x7ada, 0xe106, 0x97b2, 0x435c, 0x35e8,
            0xae34, 0xd880, 0x89ad, 0xff19, 0x64c5, 0x1271, 0xea76, 0x9cc2, 0x071e, 0x71aa, 0x2087,
            0x5633, 0xcdef, 0xbb5b, 0x6fb5, 0x1901, 0x82dd, 0xf469, 0xa544, 0xd3f0, 0x482c, 0x3e98,
            0xf1d1, 0x8765, 0x1cb9, 0x6a0d, 0x3b20, 0x4d94, 0xd648, 0xa0fc, 0x7412, 0x02a6, 0x997a,
            0xefce, 0xbee3, 0xc857, 0x538b, 0x253f, 0xb3a4, 0xc510, 0x5ecc, 0x2878, 0x7955, 0x0fe1,
            0x943d, 0xe289, 0x3667, 0x40d3, 0xdb0f, 0xadbb, 0xfc96, 0x8a22, 0x11fe, 0x674a, 0xa803,
            0xdeb7, 0x456b, 0x33df, 0x62f2, 0x1446, 0x8f9a, 0xf92e, 0x2dc0, 0x5b74, 0xc0a8, 0xb61c,
            0xe731, 0x9185, 0x0a59, 0x7ced, 0x84ea, 0xf25e, 0x6982, 0x1f36, 0x4e1b, 0x38af, 0xa373,
            0xd5c7, 0x0129, 0x779d, 0xec41, 0x9af5, 0xcbd8, 0xbd6c, 0x26b0, 0x5004, 0x9f4d, 0xe9f9,
            0x7225, 0x0491, 0x55bc, 0x2308, 0xb8d4, 0xce60, 0x1a8e, 0x6c3a, 0xf7e6, 0x8152, 0xd07f,
            0xa6cb, 0x3d17, 0x4ba3,
        ],
        [
            0x0000, 0xaa51, 0x4483, 0xeed2, 0x8906, 0x2357, 0xcd85, 0x67d4, 0x022d, 0xa87c, 0x46ae,
            0xecff, 0x8b2b, 0x217a, 0xcfa8, 0x65f9, 0x045a, 0xae0b, 0x40d9, 0xea88, 0x8d5c, 0x270d,
            0xc9df, 0x638e, 0x0677, 0xac26, 0x42f4, 0xe8a5, 0x8f71, 0x2520, 0xcbf2, 0x61a3, 0x08b4,
            0xa2e5, 0x4c37, 0xe666, 0x81b2, 0x2be3, 0xc531, 0x6f60, 0x0a99, 0xa0c8, 0x4e1a, 0xe44b,
            0x839f, 0x29ce, 0xc71c, 0x6d4d, 0x0cee, 0xa6bf, 0x486d, 0xe23c, 0x85e8, 0x2fb9, 0xc16b,
            0x6b3a, 0x0ec3, 0xa492, 0x4a40, 0xe011, 0x87c5, 0x2d94, 0xc346, 0x6917, 0x1168, 0xbb39,
            0x55eb, 0xffba, 0x986e, 0x323f, 0xdced, 0x76bc, 0x1345, 0xb914, 0x57c6, 0xfd97, 0x9a43,
            0x3012, 0xdec0, 0x7491, 0x1532, 0xbf63, 0x51b1, 0xfbe0, 0x9c34, 0x3665, 0xd8b7, 0x72e6,
            0x171f, 0xbd4e, 0x539c, 0xf9cd, 0x9e19, 0x3448, 0xda9a, 0x70cb, 0x19dc, 0xb38d, 0x5d5f,
            0xf70e, 0x90da, 0x3a8b, 0xd459, 0x7e08, 0x1bf1, 0xb1a0, 0x5f72, 0xf523, 0x92f7, 0x38a6,
            0xd674, 0x7c25, 0x1d86, 0xb7d7, 0x5905, 0xf354, 0x9480, 0x3ed1, 0xd003, 0x7a52, 0x1fab,
            0xb5fa, 0x5b28, 0xf179, 0x96ad, 0x3cfc, 0xd22e, 0x787f, 0x22d0, 0x8881, 0x6653, 0xcc02,
            0xabd6, 0x0187, 0xef55, 0x4504, 0x20fd, 0x8aac, 0x647e, 0xce2f, 0xa9fb, 0x03aa, 0xed78,
            0x4729, 0x268a, 0x8cdb, 0x6209, 0xc858, 0xaf8c, 0x05dd, 0xeb0f, 0x415e, 0x24a7, 0x8ef6,
            0x6024, 0xca75, 0xada1, 0x07f0, 0xe922, 0x4373, 0x2a64, 0x8035, 0x6ee7, 0xc4b6, 0xa362,
            0x0933, 0xe7e1, 0x4db0, 0x2849, 0x8218, 0x6cca, 0xc69b, 0xa14f, 0x0b1e, 0xe5cc, 0x4f9d,
            0x2e3e, 0x846f, 0x6abd, 0xc0ec, 0xa738, 0x0d69, 0xe3bb, 0x49ea, 0x2c13, 0x8642, 0x6890,
            0xc2c1, 0xa515, 0x0f44, 0xe196, 0x4bc7, 0x33b8, 0x99e9, 0x773b, 0xdd6a, 0xbabe, 0x10ef,
            0xfe3d, 0x546c, 0x3195, 0x9bc4, 0x7516, 0xdf47, 0xb893, 0x12c2, 0xfc10, 0x5641, 0x37e2,
            0x9db3, 0x7361, 0xd930, 0xbee4, 0x14b5, 0xfa67, 0x5036, 0x35cf, 0x9f9e, 0x714c, 0xdb1d,
            0xbcc9, 0x1698, 0xf84a, 0x521b, 0x3b0c, 0x915d, 0x7f8f, 0xd5de, 0xb20a, 0x185b, 0xf689,
            0x5cd8, 0x3921, 0x9370, 0x7da2, 0xd7f3, 0xb027, 0x1a76, 0xf4a4, 0x5ef5, 0x3f56, 0x9507,
            0x7bd5, 0xd184, 0xb650, 0x1c01, 0xf2d3, 0x5882, 0x3d7b, 0x972a, 0x79f8, 0xd3a9, 0xb47d,
            0x1e2c, 0xf0fe, 0x5aaf,
        ],
        [
            0x0000, 0x45a0, 0x8b40, 0xcee0, 0x06a1, 0x4301, 0x8de1, 0xc841, 0x0d42, 0x48e2, 0x8602,
            0xc3a2, 0x0be3, 0x4e43, 0x80a3, 0xc503, 0x1a84, 0x5f24, 0x91c4, 0xd464, 0x1c25, 0x5985,
            0x9765, 0xd2c5, 0x17c6, 0x5266, 0x9c86, 0xd926, 0x1167, 0x54c7, 0x9a27, 0xdf87, 0x3508,
            0x70a8, 0xbe48, 0xfbe8, 0x33a9, 0x7609, 0xb8e9, 0xfd49, 0x384a, 0x7dea, 0xb30a, 0xf6aa,
            0x3eeb, 0x7b4b, 0xb5ab, 0xf00b, 0x2f8c, 0x6a2c, 0xa4cc, 0xe16c, 0x292d, 0x6c8d, 0xa26d,
            0xe7cd, 0x22ce, 0x676e, 0xa98e, 0xec2e, 0x246f, 0x61cf, 0xaf2f, 0xea8f, 0x6a10, 0x2fb0,
            0xe150, 0xa4f0, 0x6cb1, 0x2911, 0xe7f1, 0xa251, 0x6752, 0x22f2, 0xec12, 0xa9b2, 0x61f3,
            0x2453, 0xeab3, 0xaf13, 0x7094, 0x3534, 0xfbd4, 0xbe74, 0x7635, 0x3395, 0xfd75, 0xb8d5,
            0x7dd6, 0x3876, 0xf696, 0xb336, 0x7b77, 0x3ed7, 0xf037, 0xb597, 0x5f18, 0x1ab8, 0xd458,
            0x91f8, 0x59b9, 0x1c19, 0xd2f9, 0x9759, 0x525a, 0x17fa, 0xd91a, 0x9cba, 0x54fb, 0x115b,
            0xdfbb, 0x9a1b, 0x459c, 0x003c, 0xcedc, 0x8b7c, 0x433d, 0x069d, 0xc87d, 0x8ddd, 0x48de,
            0x0d7e, 0xc39e, 0x863e, 0x4e7f, 0x0bdf, 0xc53f, 0x809f, 0xd420, 0x9180, 0x5f60, 0x1ac0,
            0xd281, 0x9721, 0x59c1, 0x1c61, 0xd962, 0x9cc2, 0x5222, 0x1782, 0xdfc3, 0x9a63, 0x5483,
            0x1123, 0xcea4, 0x8b04, 0x45e4, 0x0044, 0xc805, 0x8da5, 0x4345, 0x06e5, 0xc3e6, 0x8646,
            0x48a6, 0x0d06, 0xc547, 0x80e7, 0x4e07, 0x0ba7, 0xe128, 0xa488, 0x6a68, 0x2fc8, 0xe789,
            0xa229, 0x6cc9, 0x2969, 0xec6a, 0xa9ca, 0x672a, 0x228a, 0xeacb, 0xaf6b, 0x618b, 0x242b,
            0xfbac, 0xbe0c, 0x70ec, 0x354c, 0xfd0d, 0xb8ad, 0x764d, 0x33ed, 0xf6ee, 0xb34e, 0x7dae,
            0x380e, 0xf04f, 0xb5ef, 0x7b0f, 0x3eaf, 0xbe30, 0xfb90, 0x3570, 0x70d0, 0xb891, 0xfd31,
            0x33d1, 0x7671, 0xb372, 0xf6d2, 0x3832, 0x7d92, 0xb5d3, 0xf073, 0x3e93, 0x7b33, 0xa4b4,
            0xe114, 0x2ff4, 0x6a54, 0xa215, 0xe7b5, 0x2955, 0x6cf5, 0xa9f6, 0xec56, 0x22b6, 0x6716,
            0xaf57, 0xeaf7, 0x2417, 0x61b7, 0x8b38, 0xce98, 0x0078, 0x45d8, 0x8d99, 0xc839, 0x06d9,
            0x4379, 0x867a, 0xc3da, 0x0d3a, 0x489a, 0x80db, 0xc57b, 0x0b9b, 0x4e3b, 0x91bc, 0xd41c,
            0x1afc, 0x5f5c, 0x971d, 0xd2bd, 0x1c5d, 0x59fd, 0x9cfe, 0xd95e, 0x17be, 0x521e, 0x9a5f,
            0xdfff, 0x111f, 0x54bf,
        ],
        [
            0x0000, 0xb861, 0x60e3, 0xd882, 0xc1c6, 0x79a7, 0xa125, 0x1944, 0x93ad, 0x2bcc, 0xf34e,
            0x4b2f, 0x526b, 0xea0a, 0x3288, 0x8ae9, 0x377b, 0x8f1a, 0x5798, 0xeff9, 0xf6bd, 0x4edc,
            0x965e, 0x2e3f, 0xa4d6, 0x1cb7, 0xc435, 0x7c54, 0x6510, 0xdd71, 0x05f3, 0xbd92, 0x6ef6,
            0xd697, 0x0e15, 0xb674, 0xaf30, 0x1751, 0xcfd3, 0x77b2, 0xfd5b, 0x453a, 0x9db8, 0x25d9,
            0x3c9d, 0x84fc, 0x5c7e, 0xe41f, 0x598d, 0xe1ec, 0x396e, 0x810f, 0x984b, 0x202a, 0xf8a8,
            0x40c9, 0xca20, 0x7241, 0xaac3, 0x12a2, 0x0be6, 0xb387, 0x6b05, 0xd364, 0xddec, 0x658d,
            0xbd0f, 0x056e, 0x1c2a, 0xa44b, 0x7cc9, 0xc4a8, 0x4e41, 0xf620, 0x2ea2, 0x96c3, 0x8f87,
            0x37e6, 0xef64, 0x5705, 0xea97, 0x52f6, 0x8a74, 0x3215, 0x2b51, 0x9330, 0x4bb2, 0xf3d3,
            0x793a, 0xc15b, 0x19d9, 0xa1b8, 0xb8fc, 0x009d, 0xd81f, 0x607e, 0xb31a, 0x0b7b, 0xd3f9,
            0x6b98, 0x72dc, 0xcabd, 0x123f, 0xaa5e, 0x20b7, 0x98d6, 0x4054, 0xf835, 0xe171, 0x5910,
            0x8192, 0x39f3, 0x8461, 0x3c00, 0xe482, 0x5ce3, 0x45a7, 0xfdc6, 0x2544, 0x9d25, 0x17cc,
            0xafad, 0x772f, 0xcf4e, 0xd60a, 0x6e6b, 0xb6e9, 0x0e88, 0xabf9, 0x1398, 0xcb1a, 0x737b,
            0x6a3f, 0xd25e, 0x0adc, 0xb2bd, 0x3854, 0x8035, 0x58b7, 0xe0d6, 0xf992, 0x41f3, 0x9971,
            0x2110, 0x9c82, 0x24e3, 0xfc61, 0x4400, 0x5d44, 0xe525, 0x3da7, 0x85c6, 0x0f2f, 0xb74e,
            0x6fcc, 0xd7ad, 0xcee9, 0x7688, 0xae0a, 0x166b, 0xc50f, 0x7d6e, 0xa5ec, 0x1d8d, 0x04c9,
            0xbca8, 0x642a, 0xdc4b, 0x56a2, 0xeec3, 0x3641, 0x8e20, 0x9764, 0x2f05, 0xf787, 0x4fe6,
            0xf274, 0x4a15, 0x9297, 0x2af6, 0x33b2, 0x8bd3, 0x5351, 0xeb30, 0x61d9, 0xd9b8, 0x013a,
            0xb95b, 0xa01f, 0x187e, 0xc0fc, 0x789d, 0x7615, 0xce74, 0x16f6, 0xae97, 0xb7d3, 0x0fb2,
            0xd730, 0x6f51, 0xe5b8, 0x5dd9, 0x855b, 0x3d3a, 0x247e, 0x9c1f, 0x449d, 0xfcfc, 0x416e,
            0xf90f, 0x218d, 0x99ec, 0x80a8, 0x38c9, 0xe04b, 0x582a, 0xd2c3, 0x6aa2, 0xb220, 0x0a41,
            0x1305, 0xab64, 0x73e6, 0xcb87, 0x18e3, 0xa082, 0x7800, 0xc061, 0xd925, 0x6144, 0xb9c6,
            0x01a7, 0x8b4e, 0x332f, 0xebad, 0x53cc, 0x4a88, 0xf2e9, 0x2a6b, 0x920a, 0x2f98, 0x97f9,
            0x4f7b, 0xf71a, 0xee5e, 0x563f, 0x8ebd, 0x36dc, 0xbc35, 0x0454, 0xdcd6, 0x64b7, 0x7df3,
            0xc592, 0x1d10, 0xa571,
        ],
        [
            0x0000, 0x47d3, 0x8fa6, 0xc875, 0x0f6d, 0x48be, 0x80cb, 0xc718, 0x1eda, 0x5909, 0x917c,
            0xd6af, 0x11b7, 0x5664, 0x9e11, 0xd9c2, 0x3db4, 0x7a67, 0xb212, 0xf5c1, 0x32d9, 0x750a,
            0xbd7f, 0xfaac, 0x236e, 0x64bd, 0xacc8, 0xeb1b, 0x2c03, 0x6bd0, 0xa3a5, 0xe476, 0x7b68,
            0x3cbb, 0xf4ce, 0xb31d, 0x7405, 0x33d6, 0xfba3, 0xbc70, 0x65b2, 0x2261, 0xea14, 0xadc7,
            0x6adf, 0x2d0c, 0xe579, 0xa2aa, 0x46dc, 0x010f, 0xc97a, 0x8ea9, 0x49b1, 0x0e62, 0xc617,
            0x81c4, 0x5806, 0x1fd5, 0xd7a0, 0x9073, 0x576b, 0x10b8, 0xd8cd, 0x9f1e, 0xf6d0, 0xb103,
            0x7976, 0x3ea5, 0xf9bd, 0xbe6e, 0x761b, 0x31c8, 0xe80a, 0xafd9, 0x67ac, 0x207f, 0xe767,
            0xa0b4, 0x68c1, 0x2f12, 0xcb64, 0x8cb7, 0x44c2, 0x0311, 0xc409, 0x83da, 0x4baf, 0x0c7c,
            0xd5be, 0x926d, 0x5a18, 0x1dcb, 0xdad3, 0x9d00, 0x5575, 0x12a6, 0x8db8, 0xca6b, 0x021e,
            0x45cd, 0x82d5, 0xc506, 0x0d73, 0x4aa0, 0x9362, 0xd4b1, 0x1cc4, 0x5b17, 0x9c0f, 0xdbdc,
            0x13a9, 0x547a, 0xb00c, 0xf7df, 0x3faa, 0x7879, 0xbf61, 0xf8b2, 0x30c7, 0x7714, 0xaed6,
            0xe905, 0x2170, 0x66a3, 0xa1bb, 0xe668, 0x2e1d, 0x69ce, 0xfd81, 0xba52, 0x7227, 0x35f4,
            0xf2ec, 0xb53f, 0x7d4a, 0x3a99, 0xe35b, 0xa488, 0x6cfd, 0x2b2e, 0xec36, 0xabe5, 0x6390,
            0x2443, 0xc035, 0x87e6, 0x4f93, 0x0840, 0xcf58, 0x888b, 0x40fe, 0x072d, 0xdeef, 0x993c,
            0x5149, 0x169a, 0xd182, 0x9651, 0x5e24, 0x19f7, 0x86e9, 0xc13a, 0x094f, 0x4e9c, 0x8984,
            0xce57, 0x0622, 0x41f1, 0x9833, 0xdfe0, 0x1795, 0x5046, 0x975e, 0xd08d, 0x18f8, 0x5f2b,
            0xbb5d, 0xfc8e, 0x34fb, 0x7328, 0xb430, 0xf3e3, 0x3b96, 0x7c45, 0xa587, 0xe254, 0x2a21,
            0x6df2, 0xaaea, 0xed39, 0x254c, 0x629f, 0x0b51, 0x4c82, 0x84f7, 0xc324, 0x043c, 0x43ef,
            0x8b9a, 0xcc49, 0x158b, 0x5258, 0x9a2d, 0xddfe, 0x1ae6, 0x5d35, 0x9540, 0xd293, 0x36e5,
            0x7136, 0xb943, 0xfe90, 0x3988, 0x7e5b, 0xb62e, 0xf1fd, 0x283f, 0x6fec, 0xa799, 0xe04a,
            0x2752, 0x6081, 0xa8f4, 0xef27, 0x7039, 0x37ea, 0xff9f, 0xb84c, 0x7f54, 0x3887, 0xf0f2,
            0xb721, 0x6ee3, 0x2930, 0xe145, 0xa696, 0x618e, 0x265d, 0xee28, 0xa9fb, 0x4d8d, 0x0a5e,
            0xc22b, 0x85f8, 0x42e0, 0x0533, 0xcd46, 0x8a95, 0x5357, 0x1484, 0xdcf1, 0x9b22, 0x5c3a,
            0x1be9, 0xd39c, 0x944f,
        ],
        [
            0x0000, 0xeb23, 0xc667, 0x2d44, 0x9cef, 0x77cc, 0x5a88, 0xb1ab, 0x29ff, 0xc2dc, 0xef98,
            0x04bb, 0xb510, 0x5e33, 0x7377, 0x9854, 0x53fe, 0xb8dd, 0x9599, 0x7eba, 0xcf11, 0x2432,
            0x0976, 0xe255, 0x7a01, 0x9122, 0xbc66, 0x5745, 0xe6ee, 0x0dcd, 0x2089, 0xcbaa, 0xa7fc,
            0x4cdf, 0x619b, 0x8ab8, 0x3b13, 0xd030, 0xfd74, 0x1657, 0x8e03, 0x6520, 0x4864, 0xa347,
            0x12ec, 0xf9cf, 0xd48b, 0x3fa8, 0xf402, 0x1f21, 0x3265, 0xd946, 0x68ed, 0x83ce, 0xae8a,
            0x45a9, 0xddfd, 0x36de, 0x1b9a, 0xf0b9, 0x4112, 0xaa31, 0x8775, 0x6c56, 0x5fd9, 0xb4fa,
            0x99be, 0x729d, 0xc336, 0x2815, 0x0551, 0xee72, 0x7626, 0x9d05, 0xb041, 0x5b62, 0xeac9,
            0x01ea, 0x2cae, 0xc78d, 0x0c27, 0xe704, 0xca40, 0x2163, 0x90c8, 0x7beb, 0x56af, 0xbd8c,
            0x25d8, 0xcefb, 0xe3bf, 0x089c, 0xb937, 0x5214, 0x7f50, 0x9473, 0xf825, 0x1306, 0x3e42,
            0xd561, 0x64ca, 0x8fe9, 0xa2ad, 0x498e, 0xd1da, 0x3af9, 0x17bd, 0xfc9e, 0x4d35, 0xa616,
            0x8b52, 0x6071, 0xabdb, 0x40f8, 0x6dbc, 0x869f, 0x3734, 0xdc17, 0xf153, 0x1a70, 0x8224,
            0x6907, 0x4443, 0xaf60, 0x1ecb, 0xf5e8, 0xd8ac, 0x338f, 0xbfb2, 0x5491, 0x79d5, 0x92f6,
            0x235d, 0xc87e, 0xe53a, 0x0e19, 0x964d, 0x7d6e, 0x502a, 0xbb09, 0x0aa2, 0xe181, 0xccc5,
            0x27e6, 0xec4c, 0x076f, 0x2a2b, 0xc108, 0x70a3, 0x9b80, 0xb6c4, 0x5de7, 0xc5b3, 0x2e90,
            0x03d4, 0xe8f7, 0x595c, 0xb27f, 0x9f3b, 0x7418, 0x184e, 0xf36d, 0xde29, 0x350a, 0x84a1,
            0x6f82, 0x42c6, 0xa9e5, 0x31b1, 0xda92, 0xf7d6, 0x1cf5, 0xad5e, 0x467d, 0x6b39, 0x801a,
            0x4bb0, 0xa093, 0x8dd7, 0x66f4, 0xd75f, 0x3c7c, 0x1138, 0xfa1b, 0x624f, 0x896c, 0xa428,
            0x4f0b, 0xfea0, 0x1583, 0x38c7, 0xd3e4, 0xe06b, 0x0b48, 0x260c, 0xcd2f, 0x7c84, 0x97a7,
            0xbae3, 0x51c0, 0xc994, 0x22b7, 0x0ff3, 0xe4d0, 0x557b, 0xbe58, 0x931c, 0x783f, 0xb395,
            0x58b6, 0x75f2, 0x9ed1, 0x2f7a, 0xc459, 0xe91d, 0x023e, 0x9a6a, 0x7149, 0x5c0d, 0xb72e,
            0x0685, 0xeda6, 0xc0e2, 0x2bc1, 0x4797, 0xacb4, 0x81f0, 0x6ad3, 0xdb78, 0x305b, 0x1d1f,
            0xf63c, 0x6e68, 0x854b, 0xa80f, 0x432c, 0xf287, 0x19a4, 0x34e0, 0xdfc3, 0x1469, 0xff4a,
            0xd20e, 0x392d, 0x8886, 0x63a5, 0x4ee1, 0xa5c2, 0x3d96, 0xd6b5, 0xfbf1, 0x10d2, 0xa179,
            0x4a5a, 0x671e, 0x8c3d,
        ],
        [
            0x0000, 0x6f45, 0xde8a, 0xb1cf, 0xad35, 0xc270, 0x73bf, 0x1cfa, 0x4a4b, 0x250e, 0x94c1,
            0xfb84, 0xe77e, 0x883b, 0x39f4, 0x56b1, 0x9496, 0xfbd3, 0x4a1c, 0x2559, 0x39a3, 0x56e6,
            0xe729, 0x886c, 0xdedd, 0xb198, 0x0057, 0x6f12, 0x73e8, 0x1cad, 0xad62, 0xc227, 0x390d,
            0x5648, 0xe787, 0x88c2, 0x9438, 0xfb7d, 0x4ab2, 0x25f7, 0x7346, 0x1c03, 0xadcc, 0xc289,
            0xde73, 0xb136, 0x00f9, 0x6fbc, 0xad9b, 0xc2de, 0x7311, 0x1c54, 0x00ae, 0x6feb, 0xde24,
            0xb161, 0xe7d0, 0x8895, 0x395a, 0x561f, 0x4ae5, 0x25a0, 0x946f, 0xfb2a, 0x721a, 0x1d5f,
            0xac90, 0xc3d5, 0xdf2f, 0xb06a, 0x01a5, 0x6ee0, 0x3851, 0x5714, 0xe6db, 0x899e, 0x9564,
            0xfa21, 0x4bee, 0x24ab, 0xe68c, 0x89c9, 0x3806, 0x5743, 0x4bb9, 0x24fc, 0x9533, 0xfa76,
            0xacc7, 0xc382, 0x724d, 0x1d08, 0x01f2, 0x6eb7, 0xdf78, 0xb03d, 0x4b17, 0x2452, 0x959d,
            0xfad8, 0xe622, 0x8967, 0x38a8, 0x57ed, 0x015c, 0x6e19, 0xdfd6, 0xb093, 0xac69, 0xc32c,
            0x72e3, 0x1da6, 0xdf81, 0xb0c4, 0x010b, 0x6e4e, 0x72b4, 0x1df1, 0xac3e, 0xc37b, 0x95ca,
            0xfa8f, 0x4b40, 0x2405, 0x38ff, 0x57ba, 0xe675, 0x8930, 0xe434, 0x8b71, 0x3abe, 0x55fb,
            0x4901, 0x2644, 0x978b, 0xf8ce, 0xae7f, 0xc13a, 0x70f5, 0x1fb0, 0x034a, 0x6c0f, 0xddc0,
            0xb285, 0x70a2, 0x1fe7, 0xae28, 0xc16d, 0xdd97, 0xb2d2, 0x031d, 0x6c58, 0x3ae9, 0x55ac,
            0xe463, 0x8b26, 0x97dc, 0xf899, 0x4956, 0x2613, 0xdd39, 0xb27c, 0x03b3, 0x6cf6, 0x700c,
            0x1f49, 0xae86, 0xc1c3, 0x9772, 0xf837, 0x49f8, 0x26bd, 0x3a47, 0x5502, 0xe4cd, 0x8b88,
            0x49af, 0x26ea, 0x9725, 0xf860, 0xe49a, 0x8bdf, 0x3a10, 0x5555, 0x03e4, 0x6ca1, 0xdd6e,
            0xb22b, 0xaed1, 0xc194, 0x705b, 0x1f1e, 0x962e, 0xf96b, 0x48a4, 0x27e1, 0x3b1b, 0x545e,
            0xe591, 0x8ad4, 0xdc65, 0xb320, 0x02ef, 0x6daa, 0x7150, 0x1e15, 0xafda, 0xc09f, 0x02b8,
            0x6dfd, 0xdc32, 0xb377, 0xaf8d, 0xc0c8, 0x7107, 0x1e42, 0x48f3, 0x27b6, 0x9679, 0xf93c,
            0xe5c6, 0x8a83, 0x3b4c, 0x5409, 0xaf23, 0xc066, 0x71a9, 0x1eec, 0x0216, 0x6d53, 0xdc9c,
            0xb3d9, 0xe568, 0x8a2d, 0x3be2, 0x54a7, 0x485d, 0x2718, 0x96d7, 0xf992, 0x3bb5, 0x54f0,
            0xe53f, 0x8a7a, 0x9680, 0xf9c5, 0x480a, 0x274f, 0x71fe, 0x1ebb, 0xaf74, 0xc031, 0xdccb,
            0xb38e, 0x0241, 0x6d04,
        ],
        [
            0x0000, 0xd849, 0xa0b3, 0x78fa, 0x5147, 0x890e, 0xf1f4, 0x29bd, 0xa28e, 0x7ac7, 0x023d,
            0xda74, 0xf3c9, 0x2b80, 0x537a, 0x8b33, 0x553d, 0x8d74, 0xf58e, 0x2dc7, 0x047a, 0xdc33,
            0xa4c9, 0x7c80, 0xf7b3, 0x2ffa, 0x5700, 0x8f49, 0xa6f4, 0x7ebd, 0x0647, 0xde0e, 0xaa7a,
            0x7233, 0x0ac9, 0xd280, 0xfb3d, 0x2374, 0x5b8e, 0x83c7, 0x08f4, 0xd0bd, 0xa847, 0x700e,
            0x59b3, 0x81fa, 0xf900, 0x2149, 0xff47, 0x270e, 0x5ff4, 0x87bd, 0xae00, 0x7649, 0x0eb3,
            0xd6fa, 0x5dc9, 0x8580, 0xfd7a, 0x2533, 0x0c8e, 0xd4c7, 0xac3d, 0x7474, 0x44d5, 0x9c9c,
            0xe466, 0x3c2f, 0x1592, 0xcddb, 0xb521, 0x6d68, 0xe65b, 0x3e12, 0x46e8, 0x9ea1, 0xb71c,
            0x6f55, 0x17af, 0xcfe6, 0x11e8, 0xc9a1, 0xb15b, 0x6912, 0x40af, 0x98e6, 0xe01c, 0x3855,
            0xb366, 0x6b2f, 0x13d5, 0xcb9c, 0xe221, 0x3a68, 0x4292, 0x9adb, 0xeeaf, 0x36e6, 0x4e1c,
            0x9655, 0xbfe8, 0x67a1, 0x1f5b, 0xc712, 0x4c21, 0x9468, 0xec92, 0x34db, 0x1d66, 0xc52f,
            0xbdd5, 0x659c, 0xbb92, 0x63db, 0x1b21, 0xc368, 0xead5, 0x329c, 0x4a66, 0x922f, 0x191c,
            0xc155, 0xb9af, 0x61e6, 0x485b, 0x9012, 0xe8e8, 0x30a1, 0x89aa, 0x51e3, 0x2919, 0xf150,
            0xd8ed, 0x00a4, 0x785e, 0xa017, 0x2b24, 0xf36d, 0x8b97, 0x53de, 0x7a63, 0xa22a, 0xdad0,
            0x0299, 0xdc97, 0x04de, 0x7c24, 0xa46d, 0x8dd0, 0x5599, 0x2d63, 0xf52a, 0x7e19, 0xa650,
            0xdeaa, 0x06e3, 0x2f5e, 0xf717, 0x8fed, 0x57a4, 0x23d0, 0xfb99, 0x8363, 0x5b2a, 0x7297,
            0xaade, 0xd224, 0x0a6d, 0x815e, 0x5917, 0x21ed, 0xf9a4, 0xd019, 0x0850, 0x70aa, 0xa8e3,
            0x76ed, 0xaea4, 0xd65e, 0x0e17, 0x27aa, 0xffe3, 0x8719, 0x5f50, 0xd463, 0x0c2a, 0x74d0,
            0xac99, 0x8524, 0x5d6d, 0x2597, 0xfdde, 0xcd7f, 0x1536, 0x6dcc, 0xb585, 0x9c38, 0x4471,
            0x3c8b, 0xe4c2, 0x6ff1, 0xb7b8, 0xcf42, 0x170b, 0x3eb6, 0xe6ff, 0x9e05, 0x464c, 0x9842,
            0x400b, 0x38f1, 0xe0b8, 0xc905, 0x114c, 0x69b6, 0xb1ff, 0x3acc, 0xe285, 0x9a7f, 0x4236,
            0x6b8b, 0xb3c2, 0xcb38, 0x1371, 0x6705, 0xbf4c, 0xc7b6, 0x1fff, 0x3642, 0xee0b, 0x96f1,
            0x4eb8, 0xc58b, 0x1dc2, 0x6538, 0xbd71, 0x94cc, 0x4c85, 0x347f, 0xec36, 0x3238, 0xea71,
            0x928b, 0x4ac2, 0x637f, 0xbb36, 0xc3cc, 0x1b85, 0x90b6, 0x48ff, 0x3005, 0xe84c, 0xc1f1,
            0x19b8, 0x6142, 0xb90b,
        ],
        [
            0x0000, 0x0375, 0x06ea, 0x059f, 0x0dd4, 0x0ea1, 0x0b3e, 0x084b, 0x1ba8, 0x18dd, 0x1d42,
            0x1e37, 0x167c, 0x1509, 0x1096, 0x13e3, 0x3750, 0x3425, 0x31ba, 0x32cf, 0x3a84, 0x39f1,
            0x3c6e, 0x3f1b, 0x2cf8, 0x2f8d, 0x2a12, 0x2967, 0x212c, 0x2259, 0x27c6, 0x24b3, 0x6ea0,
            0x6dd5, 0x684a, 0x6b3f, 0x6374, 0x6001, 0x659e, 0x66eb, 0x7508, 0x767d, 0x73e2, 0x7097,
            0x78dc, 0x7ba9, 0x7e36, 0x7d43, 0x59f0, 0x5a85, 0x5f1a, 0x5c6f, 0x5424, 0x5751, 0x52ce,
            0x51bb, 0x4258, 0x412d, 0x44b2, 0x47c7, 0x4f8c, 0x4cf9, 0x4966, 0x4a13, 0xdd40, 0xde35,
            0xdbaa, 0xd8df, 0xd094, 0xd3e1, 0xd67e, 0xd50b, 0xc6e8, 0xc59d, 0xc002, 0xc377, 0xcb3c,
            0xc849, 0xcdd6, 0xcea3, 0xea10, 0xe965, 0xecfa, 0xef8f, 0xe7c4, 0xe4b1, 0xe12e, 0xe25b,
            0xf1b8, 0xf2cd, 0xf752, 0xf427, 0xfc6c, 0xff19, 0xfa86, 0xf9f3, 0xb3e0, 0xb095, 0xb50a,
            0xb67f, 0xbe34, 0xbd41, 0xb8de, 0xbbab, 0xa848, 0xab3d, 0xaea2, 0xadd7, 0xa59c, 0xa6e9,
            0xa376, 0xa003, 0x84b0, 0x87c5, 0x825a, 0x812f, 0x8964, 0x8a11, 0x8f8e, 0x8cfb, 0x9f18,
            0x9c6d, 0x99f2, 0x9a87, 0x92cc, 0x91b9, 0x9426, 0x9753, 0xaaa1, 0xa9d4, 0xac4b, 0xaf3e,
            0xa775, 0xa400, 0xa19f, 0xa2ea, 0xb109, 0xb27c, 0xb7e3, 0xb496, 0xbcdd, 0xbfa8, 0xba37,
            0xb942, 0x9df1, 0x9e84, 0x9b1b, 0x986e, 0x9025, 0x9350, 0x96cf, 0x95ba, 0x8659, 0x852c,
            0x80b3, 0x83c6, 0x8b8d, 0x88f8, 0x8d67, 0x8e12, 0xc401, 0xc774, 0xc2eb, 0xc19e, 0xc9d5,
            0xcaa0, 0xcf3f, 0xcc4a, 0xdfa9, 0xdcdc, 0xd943, 0xda36, 0xd27d, 0xd108, 0xd497, 0xd7e2,
            0xf351, 0xf024, 0xf5bb, 0xf6ce, 0xfe85, 0xfdf0, 0xf86f, 0xfb1a, 0xe8f9, 0xeb8c, 0xee13,
            0xed66, 0xe52d, 0xe658, 0xe3c7, 0xe0b2, 0x77e1, 0x7494, 0x710b, 0x727e, 0x7a35, 0x7940,
            0x7cdf, 0x7faa, 0x6c49, 0x6f3c, 0x6aa3, 0x69d6, 0x619d, 0x62e8, 0x6777, 0x6402, 0x40b1,
            0x43c4, 0x465b, 0x452e, 0x4d65, 0x4e10, 0x4b8f, 0x48fa, 0x5b19, 0x586c, 0x5df3, 0x5e86,
            0x56cd, 0x55b8, 0x5027, 0x5352, 0x1941, 0x1a34, 0x1fab, 0x1cde, 0x1495, 0x17e0, 0x127f,
            0x110a, 0x02e9, 0x019c, 0x0403, 0x0776, 0x0f3d, 0x0c48, 0x09d7, 0x0aa2, 0x2e11, 0x2d64,
            0x28fb, 0x2b8e, 0x23c5, 0x20b0, 0x252f, 0x265a, 0x35b9, 0x36cc, 0x3353, 0x3026, 0x386d,
            0x3b18, 0x3e87, 0x3df2,
        ],
        [
            0x0000, 0x4563, 0x8ac6, 0xcfa5, 0x05ad, 0x40ce, 0x8f6b, 0xca08, 0x0b5a, 0x4e39, 0x819c,
            0xc4ff, 0x0ef7, 0x4b94, 0x8431, 0xc152, 0x16b4, 0x53d7, 0x9c72, 0xd911, 0x1319, 0x567a,
            0x99df, 0xdcbc, 0x1dee, 0x588d, 0x9728, 0xd24b, 0x1843, 0x5d20, 0x9285, 0xd7e6, 0x2d68,
            0x680b, 0xa7ae, 0xe2cd, 0x28c5, 0x6da6, 0xa203, 0xe760, 0x2632, 0x6351, 0xacf4, 0xe997,
            0x239f, 0x66fc, 0xa959, 0xec3a, 0x3bdc, 0x7ebf, 0xb11a, 0xf479, 0x3e71, 0x7b12, 0xb4b7,
            0xf1d4, 0x3086, 0x75e5, 0xba40, 0xff23, 0x352b, 0x7048, 0xbfed, 0xfa8e, 0x5ad0, 0x1fb3,
            0xd016, 0x9575, 0x5f7d, 0x1a1e, 0xd5bb, 0x90d8, 0x518a, 0x14e9, 0xdb4c, 0x9e2f, 0x5427,
            0x1144, 0xdee1, 0x9b82, 0x4c64, 0x0907, 0xc6a2, 0x83c1, 0x49c9, 0x0caa, 0xc30f, 0x866c,
            0x473e, 0x025d, 0xcdf8, 0x889b, 0x4293, 0x07f0, 0xc855, 0x8d36, 0x77b8, 0x32db, 0xfd7e,
            0xb81d, 0x7215, 0x3776, 0xf8d3, 0xbdb0, 0x7ce2, 0x3981, 0xf624, 0xb347, 0x794f, 0x3c2c,
            0xf389, 0xb6ea, 0x610c, 0x246f, 0xebca, 0xaea9, 0x64a1, 0x21c2, 0xee67, 0xab04, 0x6a56,
            0x2f35, 0xe090, 0xa5f3, 0x6ffb, 0x2a98, 0xe53d, 0xa05e, 0xb5a0, 0xf0c3, 0x3f66, 0x7a05,
            0xb00d, 0xf56e, 0x3acb, 0x7fa8, 0xbefa, 0xfb99, 0x343c, 0x715f, 0xbb57, 0xfe34, 0x3191,
            0x74f2, 0xa314, 0xe677, 0x29d2, 0x6cb1, 0xa6b9, 0xe3da, 0x2c7f, 0x691c, 0xa84e, 0xed2d,
            0x2288, 0x67eb, 0xade3, 0xe880, 0x2725, 0x6246, 0x98c8, 0xddab, 0x120e, 0x576d, 0x9d65,
            0xd806, 0x17a3, 0x52c0, 0x9392, 0xd6f1, 0x1954, 0x5c37, 0x963f, 0xd35c, 0x1cf9, 0x599a,
            0x8e7c, 0xcb1f, 0x04ba, 0x41d9, 0x8bd1, 0xceb2, 0x0117, 0x4474, 0x8526, 0xc045, 0x0fe0,
            0x4a83, 0x808b, 0xc5e8, 0x0a4d, 0x4f2e, 0xef70, 0xaa13, 0x65b6, 0x20d5, 0xeadd, 0xafbe,
            0x601b, 0x2578, 0xe42a, 0xa149, 0x6eec, 0x2b8f, 0xe187, 0xa4e4, 0x6b41, 0x2e22, 0xf9c4,
            0xbca7, 0x7302, 0x3661, 0xfc69, 0xb90a, 0x76af, 0x33cc, 0xf29e, 0xb7fd, 0x7858, 0x3d3b,
            0xf733, 0xb250, 0x7df5, 0x3896, 0xc218, 0x877b, 0x48de, 0x0dbd, 0xc7b5, 0x82d6, 0x4d73,
            0x0810, 0xc942, 0x8c21, 0x4384, 0x06e7, 0xccef, 0x898c, 0x4629, 0x034a, 0xd4ac, 0x91cf,
            0x5e6a, 0x1b09, 0xd101, 0x9462, 0x5bc7, 0x1ea4, 0xdff6, 0x9a95, 0x5530, 0x1053, 0xda5b,
            0x9f38, 0x509d, 0x15fe,
        ],
        [
            0x0000, 0x7b61, 0xf6c2, 0x8da3, 0xfda5, 0x86c4, 0x0b67, 0x7006, 0xeb6b, 0x900a, 0x1da9,
            0x66c8, 0x16ce, 0x6daf, 0xe00c, 0x9b6d, 0xc6f7, 0xbd96, 0x3035, 0x4b54, 0x3b52, 0x4033,
            0xcd90, 0xb6f1, 0x2d9c, 0x56fd, 0xdb5e, 0xa03f, 0xd039, 0xab58, 0x26fb, 0x5d9a, 0x9dcf,
            0xe6ae, 0x6b0d, 0x106c, 0x606a, 0x1b0b, 0x96a8, 0xedc9, 0x76a4, 0x0dc5, 0x8066, 0xfb07,
            0x8b01, 0xf060, 0x7dc3, 0x06a2, 0x5b38, 0x2059, 0xadfa, 0xd69b, 0xa69d, 0xddfc, 0x505f,
            0x2b3e, 0xb053, 0xcb32, 0x4691, 0x3df0, 0x4df6, 0x3697, 0xbb34, 0xc055, 0x2bbf, 0x50de,
            0xdd7d, 0xa61c, 0xd61a, 0xad7b, 0x20d8, 0x5bb9, 0xc0d4, 0xbbb5, 0x3616, 0x4d77, 0x3d71,
            0x4610, 0xcbb3, 0xb0d2, 0xed48, 0x9629, 0x1b8a, 0x60eb, 0x10ed, 0x6b8c, 0xe62f, 0x9d4e,
            0x0623, 0x7d42, 0xf0e1, 0x8b80, 0xfb86, 0x80e7, 0x0d44, 0x7625, 0xb670, 0xcd11, 0x40b2,
            0x3bd3, 0x4bd5, 0x30b4, 0xbd17, 0xc676, 0x5d1b, 0x267a, 0xabd9, 0xd0b8, 0xa0be, 0xdbdf,
            0x567c, 0x2d1d, 0x7087, 0x0be6, 0x8645, 0xfd24, 0x8d22, 0xf643, 0x7be0, 0x0081, 0x9bec,
            0xe08d, 0x6d2e, 0x164f, 0x6649, 0x1d28, 0x908b, 0xebea, 0x577e, 0x2c1f, 0xa1bc, 0xdadd,
            0xaadb, 0xd1ba, 0x5c19, 0x2778, 0xbc15, 0xc774, 0x4ad7, 0x31b6, 0x41b0, 0x3ad1, 0xb772,
            0xcc13, 0x9189, 0xeae8, 0x674b, 0x1c2a, 0x6c2c, 0x174d, 0x9aee, 0xe18f, 0x7ae2, 0x0183,
            0x8c20, 0xf741, 0x8747, 0xfc26, 0x7185, 0x0ae4, 0xcab1, 0xb1d0, 0x3c73, 0x4712, 0x3714,
            0x4c75, 0xc1d6, 0xbab7, 0x21da, 0x5abb, 0xd718, 0xac79, 0xdc7f, 0xa71e, 0x2abd, 0x51dc,
            0x0c46, 0x7727, 0xfa84, 0x81e5, 0xf1e3, 0x8a82, 0x0721, 0x7c40, 0xe72d, 0x9c4c, 0x11ef,
            0x6a8e, 0x1a88, 0x61e9, 0xec4a, 0x972b, 0x7cc1, 0x07a0, 0x8a03, 0xf162, 0x8164, 0xfa05,
            0x77a6, 0x0cc7, 0x97aa, 0xeccb, 0x6168, 0x1a09, 0x6a0f, 0x116e, 0x9ccd, 0xe7ac, 0xba36,
            0xc157, 0x4cf4, 0x3795, 0x4793, 0x3cf2, 0xb151, 0xca30, 0x515d, 0x2a3c, 0xa79f, 0xdcfe,
            0xacf8, 0xd799, 0x5a3a, 0x215b, 0xe10e, 0x9a6f, 0x17cc, 0x6cad, 0x1cab, 0x67ca, 0xea69,
            0x9108, 0x0a65, 0x7104, 0xfca7, 0x87c6, 0xf7c0, 0x8ca1, 0x0102, 0x7a63, 0x27f9, 0x5c98,
            0xd13b, 0xaa5a, 0xda5c, 0xa13d, 0x2c9e, 0x57ff, 0xcc92, 0xb7f3, 0x3a50, 0x4131, 0x3137,
            0x4a56, 0xc7f5, 0xbc94,
        ],
        [
            0x0000, 0xaefc, 0x4dd9, 0xe325, 0x9bb2, 0x354e, 0xd66b, 0x7897, 0x2745, 0x89b9, 0x6a9c,
            0xc460, 0xbcf7, 0x120b, 0xf12e, 0x5fd2, 0x4e8a, 0xe076, 0x0353, 0xadaf, 0xd538, 0x7bc4,
            0x98e1, 0x361d, 0x69cf, 0xc733, 0x2416, 0x8aea, 0xf27d, 0x5c81, 0xbfa4, 0x1158, 0x9d14,
            0x33e8, 0xd0cd, 0x7e31, 0x06a6, 0xa85a, 0x4b7f, 0xe583, 0xba51, 0x14ad, 0xf788, 0x5974,
            0x21e3, 0x8f1f, 0x6c3a, 0xc2c6, 0xd39e, 0x7d62, 0x9e47, 0x30bb, 0x482c, 0xe6d0, 0x05f5,
            0xab09, 0xf4db, 0x5a27, 0xb902, 0x17fe, 0x6f69, 0xc195, 0x22b0, 0x8c4c, 0x2a09, 0x84f5,
            0x67d0, 0xc92c, 0xb1bb, 0x1f47, 0xfc62, 0x529e, 0x0d4c, 0xa3b0, 0x4095, 0xee69, 0x96fe,
            0x3802, 0xdb27, 0x75db, 0x6483, 0xca7f, 0x295a, 0x87a6, 0xff31, 0x51cd, 0xb2e8, 0x1c14,
            0x43c6, 0xed3a, 0x0e1f, 0xa0e3, 0xd874, 0x7688, 0x95ad, 0x3b51, 0xb71d, 0x19e1, 0xfac4,
            0x5438, 0x2caf, 0x8253, 0x6176, 0xcf8a, 0x9058, 0x3ea4, 0xdd81, 0x737d, 0x0bea, 0xa516,
            0x4633, 0xe8cf, 0xf997, 0x576b, 0xb44e, 0x1ab2, 0x6225, 0xccd9, 0x2ffc, 0x8100, 0xded2,
            0x702e, 0x930b, 0x3df7, 0x4560, 0xeb9c, 0x08b9, 0xa645, 0x5412, 0xfaee, 0x19cb, 0xb737,
            0xcfa0, 0x615c, 0x8279, 0x2c85, 0x7357, 0xddab, 0x3e8e, 0x9072, 0xe8e5, 0x4619, 0xa53c,
            0x0bc0, 0x1a98, 0xb464, 0x5741, 0xf9bd, 0x812a, 0x2fd6, 0xccf3, 0x620f, 0x3ddd, 0x9321,
            0x7004, 0xdef8, 0xa66f, 0x0893, 0xebb6, 0x454a, 0xc906, 0x67fa, 0x84df, 0x2a23, 0x52b4,
            0xfc48, 0x1f6d, 0xb191, 0xee43, 0x40bf, 0xa39a, 0x0d66, 0x75f1, 0xdb0d, 0x3828, 0x96d4,
            0x878c, 0x2970, 0xca55, 0x64a9, 0x1c3e, 0xb2c2, 0x51e7, 0xff1b, 0xa0c9, 0x0e35, 0xed10,
            0x43ec, 0x3b7b, 0x9587, 0x76a2, 0xd85e, 0x7e1b, 0xd0e7, 0x33c2, 0x9d3e, 0xe5a9, 0x4b55,
            0xa870, 0x068c, 0x595e, 0xf7a2, 0x1487, 0xba7b, 0xc2ec, 0x6c10, 0x8f35, 0x21c9, 0x3091,
            0x9e6d, 0x7d48, 0xd3b4, 0xab23, 0x05df, 0xe6fa, 0x4806, 0x17d4, 0xb928, 0x5a0d, 0xf4f1,
            0x8c66, 0x229a, 0xc1bf, 0x6f43, 0xe30f, 0x4df3, 0xaed6, 0x002a, 0x78bd, 0xd641, 0x3564,
            0x9b98, 0xc44a, 0x6ab6, 0x8993, 0x276f, 0x5ff8, 0xf104, 0x1221, 0xbcdd, 0xad85, 0x0379,
            0xe05c, 0x4ea0, 0x3637, 0x98cb, 0x7bee, 0xd512, 0x8ac0, 0x243c, 0xc719, 0x69e5, 0x1172,
            0xbf8e, 0x5cab, 0xf257,
        ],
        [
            0x0000, 0xa824, 0x4069, 0xe84d, 0x80d2, 0x28f6, 0xc0bb, 0x689f, 0x1185, 0xb9a1, 0x51ec,
            0xf9c8, 0x9157, 0x3973, 0xd13e, 0x791a, 0x230a, 0x8b2e, 0x6363, 0xcb47, 0xa3d8, 0x0bfc,
            0xe3b1, 0x4b95, 0x328f, 0x9aab, 0x72e6, 0xdac2, 0xb25d, 0x1a79, 0xf234, 0x5a10, 0x4614,
            0xee30, 0x067d, 0xae59, 0xc6c6, 0x6ee2, 0x86af, 0x2e8b, 0x5791, 0xffb5, 0x17f8, 0xbfdc,
            0xd743, 0x7f67, 0x972a, 0x3f0e, 0x651e, 0xcd3a, 0x2577, 0x8d53, 0xe5cc, 0x4de8, 0xa5a5,
            0x0d81, 0x749b, 0xdcbf, 0x34f2, 0x9cd6, 0xf449, 0x5c6d, 0xb420, 0x1c04, 0x8c28, 0x240c,
            0xcc41, 0x6465, 0x0cfa, 0xa4de, 0x4c93, 0xe4b7, 0x9dad, 0x3589, 0xddc4, 0x75e0, 0x1d7f,
            0xb55b, 0x5d16, 0xf532, 0xaf22, 0x0706, 0xef4b, 0x476f, 0x2ff0, 0x87d4, 0x6f99, 0xc7bd,
            0xbea7, 0x1683, 0xfece, 0x56ea, 0x3e75, 0x9651, 0x7e1c, 0xd638, 0xca3c, 0x6218, 0x8a55,
            0x2271, 0x4aee, 0xe2ca, 0x0a87, 0xa2a3, 0xdbb9, 0x739d, 0x9bd0, 0x33f4, 0x5b6b, 0xf34f,
            0x1b02, 0xb326, 0xe936, 0x4112, 0xa95f, 0x017b, 0x69e4, 0xc1c0, 0x298d, 0x81a9, 0xf8b3,
            0x5097, 0xb8da, 0x10fe, 0x7861, 0xd045, 0x3808, 0x902c, 0x0871, 0xa055, 0x4818, 0xe03c,
            0x88a3, 0x2087, 0xc8ca, 0x60ee, 0x19f4, 0xb1d0, 0x599d, 0xf1b9, 0x9926, 0x3102, 0xd94f,
            0x716b, 0x2b7b, 0x835f, 0x6b12, 0xc336, 0xaba9, 0x038d, 0xebc0, 0x43e4, 0x3afe, 0x92da,
            0x7a97, 0xd2b3, 0xba2c, 0x1208, 0xfa45, 0x5261, 0x4e65, 0xe641, 0x0e0c, 0xa628, 0xceb7,
            0x6693, 0x8ede, 0x26fa, 0x5fe0, 0xf7c4, 0x1f89, 0xb7ad, 0xdf32, 0x7716, 0x9f5b, 0x377f,
            0x6d6f, 0xc54b, 0x2d06, 0x8522, 0xedbd, 0x4599, 0xadd4, 0x05f0, 0x7cea, 0xd4ce, 0x3c83,
            0x94a7, 0xfc38, 0x541c, 0xbc51, 0x1475, 0x8459, 0x2c7d, 0xc430, 0x6c14, 0x048b, 0xacaf,
            0x44e2, 0xecc6, 0x95dc, 0x3df8, 0xd5b5, 0x7d91, 0x150e, 0xbd2a, 0x5567, 0xfd43, 0xa753,
            0x0f77, 0xe73a, 0x4f1e, 0x2781, 0x8fa5, 0x67e8, 0xcfcc, 0xb6d6, 0x1ef2, 0xf6bf, 0x5e9b,
            0x3604, 0x9e20, 0x766d, 0xde49, 0xc24d, 0x6a69, 0x8224, 0x2a00, 0x429f, 0xeabb, 0x02f6,
            0xaad2, 0xd3c8, 0x7bec, 0x93a1, 0x3b85, 0x531a, 0xfb3e, 0x1373, 0xbb57, 0xe147, 0x4963,
            0xa12e, 0x090a, 0x6195, 0xc9b1, 0x21fc, 0x89d8, 0xf0c2, 0x58e6, 0xb0ab, 0x188f, 0x7010,
            0xd834, 0x3079, 0x985d,
        ],
    ];

    pub static CRC16_GSM_TABLE: [[u16; 256]; 16] = [
        [
            0x0000, 0x1021, 0x2042, 0x3063, 0x4084, 0x50a5, 0x60c6, 0x70e7, 0x8108, 0x9129, 0xa14a,
            0xb16b, 0xc18c, 0xd1ad, 0xe1ce, 0xf1ef, 0x1231, 0x0210, 0x3273, 0x2252, 0x52b5, 0x4294,
            0x72f7, 0x62d6, 0x9339, 0x8318, 0xb37b, 0xa35a, 0xd3bd, 0xc39c, 0xf3ff, 0xe3de, 0x2462,
            0x3443, 0x0420, 0x1401, 0x64e6, 0x74c7, 0x44a4, 0x5485, 0xa56a, 0xb54b, 0x8528, 0x9509,
            0xe5ee, 0xf5cf, 0xc5ac, 0xd58d, 0x3653, 0x2672, 0x1611, 0x0630, 0x76d7, 0x66f6, 0x5695,
            0x46b4, 0xb75b, 0xa77a, 0x9719, 0x8738, 0xf7df, 0xe7fe, 0xd79d, 0xc7bc, 0x48c4, 0x58e5,
            0x6886, 0x78a7, 0x0840, 0x1861, 0x2802, 0x3823, 0xc9cc, 0xd9ed, 0xe98e, 0xf9af, 0x8948,
            0x9969, 0xa90a, 0xb92b, 0x5af5, 0x4ad4, 0x7ab7, 0x6a96, 0x1a71, 0x0a50, 0x3a33, 0x2a12,
            0xdbfd, 0xcbdc, 0xfbbf, 0xeb9e, 0x9b79, 0x8b58, 0xbb3b, 0xab1a, 0x6ca6, 0x7c87, 0x4ce4,
            0x5cc5, 0x2c22, 0x3c03, 0x0c60, 0x1c41, 0xedae, 0xfd8f, 0xcdec, 0xddcd, 0xad2a, 0xbd0b,
            0x8d68, 0x9d49, 0x7e97, 0x6eb6, 0x5ed5, 0x4ef4, 0x3e13, 0x2e32, 0x1e51, 0x0e70, 0xff9f,
            0xefbe, 0xdfdd, 0xcffc, 0xbf1b, 0xaf3a, 0x9f59, 0x8f78, 0x9188, 0x81a9, 0xb1ca, 0xa1eb,
            0xd10c, 0xc12d, 0xf14e, 0xe16f, 0x1080, 0x00a1, 0x30c2, 0x20e3, 0x5004, 0x4025, 0x7046,
            0x6067, 0x83b9, 0x9398, 0xa3fb, 0xb3da, 0xc33d, 0xd31c, 0xe37f, 0xf35e, 0x02b1, 0x1290,
            0x22f3, 0x32d2, 0x4235, 0x5214, 0x6277, 0x7256, 0xb5ea, 0xa5cb, 0x95a8, 0x8589, 0xf56e,
            0xe54f, 0xd52c, 0xc50d, 0x34e2, 0x24c3, 0x14a0, 0x0481, 0x7466, 0x6447, 0x5424, 0x4405,
            0xa7db, 0xb7fa, 0x8799, 0x97b8, 0xe75f, 0xf77e, 0xc71d, 0xd73c, 0x26d3, 0x36f2, 0x0691,
            0x16b0, 0x6657, 0x7676, 0x4615, 0x5634, 0xd94c, 0xc96d, 0xf90e, 0xe92f, 0x99c8, 0x89e9,
            0xb98a, 0xa9ab, 0x5844, 0x4865, 0x7806, 0x6827, 0x18c0, 0x08e1, 0x3882, 0x28a3, 0xcb7d,
            0xdb5c, 0xeb3f, 0xfb1e, 0x8bf9, 0x9bd8, 0xabbb, 0xbb9a, 0x4a75, 0x5a54, 0x6a37, 0x7a16,
            0x0af1, 0x1ad0, 0x2ab3, 0x3a92, 0xfd2e, 0xed0f, 0xdd6c, 0xcd4d, 0xbdaa, 0xad8b, 0x9de8,
            0x8dc9, 0x7c26, 0x6c07, 0x5c64, 0x4c45, 0x3ca2, 0x2c83, 0x1ce0, 0x0cc1, 0xef1f, 0xff3e,
            0xcf5d, 0xdf7c, 0xaf9b, 0xbfba, 0x8fd9, 0x9ff8, 0x6e17, 0x7e36, 0x4e55, 0x5e74, 0x2e93,
            0x3eb2, 0x0ed1, 0x1ef0,
        ],
        [
            0x0000, 0x3331, 0x6662, 0x5553, 0xccc4, 0xfff5, 0xaaa6, 0x9997, 0x89a9, 0xba98, 0xefcb,
            0xdcfa, 0x456d, 0x765c, 0x230f, 0x103e, 0x0373, 0x3042, 0x6511, 0x5620, 0xcfb7, 0xfc86,
            0xa9d5, 0x9ae4, 0x8ada, 0xb9eb, 0xecb8, 0xdf89, 0x461e, 0x752f, 0x207c, 0x134d, 0x06e6,
            0x35d7, 0x6084, 0x53b5, 0xca22, 0xf913, 0xac40, 0x9f71, 0x8f4f, 0xbc7e, 0xe92d, 0xda1c,
            0x438b, 0x70ba, 0x25e9, 0x16d8, 0x0595, 0x36a4, 0x63f7, 0x50c6, 0xc951, 0xfa60, 0xaf33,
            0x9c02, 0x8c3c, 0xbf0d, 0xea5e, 0xd96f, 0x40f8, 0x73c9, 0x269a, 0x15ab, 0x0dcc, 0x3efd,
            0x6bae, 0x589f, 0xc108, 0xf239, 0xa76a, 0x945b, 0x8465, 0xb754, 0xe207, 0xd136, 0x48a1,
            0x7b90, 0x2ec3, 0x1df2, 0x0ebf, 0x3d8e, 0x68dd, 0x5bec, 0xc27b, 0xf14a, 0xa419, 0x9728,
            0x8716, 0xb427, 0xe174, 0xd245, 0x4bd2, 0x78e3, 0x2db0, 0x1e81, 0x0b2a, 0x381b, 0x6d48,
            0x5e79, 0xc7ee, 0xf4df, 0xa18c, 0x92bd, 0x8283, 0xb1b2, 0xe4e1, 0xd7d0, 0x4e47, 0x7d76,
            0x2825, 0x1b14, 0x0859, 0x3b68, 0x6e3b, 0x5d0a, 0xc49d, 0xf7ac, 0xa2ff, 0x91ce, 0x81f0,
            0xb2c1, 0xe792, 0xd4a3, 0x4d34, 0x7e05, 0x2b56, 0x1867, 0x1b98, 0x28a9, 0x7dfa, 0x4ecb,
            0xd75c, 0xe46d, 0xb13e, 0x820f, 0x9231, 0xa100, 0xf453, 0xc762, 0x5ef5, 0x6dc4, 0x3897,
            0x0ba6, 0x18eb, 0x2bda, 0x7e89, 0x4db8, 0xd42f, 0xe71e, 0xb24d, 0x817c, 0x9142, 0xa273,
            0xf720, 0xc411, 0x5d86, 0x6eb7, 0x3be4, 0x08d5, 0x1d7e, 0x2e4f, 0x7b1c, 0x482d, 0xd1ba,
            0xe28b, 0xb7d8, 0x84e9, 0x94d7, 0xa7e6, 0xf2b5, 0xc184, 0x5813, 0x6b22, 0x3e71, 0x0d40,
            0x1e0d, 0x2d3c, 0x786f, 0x4b5e, 0xd2c9, 0xe1f8, 0xb4ab, 0x879a, 0x97a4, 0xa495, 0xf1c6,
            0xc2f7, 0x5b60, 0x6851, 0x3d02, 0x0e33, 0x1654, 0x2565, 0x7036, 0x4307, 0xda90, 0xe9a1,
            0xbcf2, 0x8fc3, 0x9ffd, 0xaccc, 0xf99f, 0xcaae, 0x5339, 0x6008, 0x355b, 0x066a, 0x1527,
            0x2616, 0x7345, 0x4074, 0xd9e3, 0xead2, 0xbf81, 0x8cb0, 0x9c8e, 0xafbf, 0xfaec, 0xc9dd,
            0x504a, 0x637b, 0x3628, 0x0519, 0x10b2, 0x2383, 0x76d0, 0x45e1, 0xdc76, 0xef47, 0xba14,
            0x8925, 0x991b, 0xaa2a, 0xff79, 0xcc48, 0x55df, 0x66ee, 0x33bd, 0x008c, 0x13c1, 0x20f0,
            0x75a3, 0x4692, 0xdf05, 0xec34, 0xb967, 0x8a56, 0x9a68, 0xa959, 0xfc0a, 0xcf3b, 0x56ac,
            0x659d, 0x30ce, 0x03ff,
        ],
        [
            0x0000, 0x3730, 0x6e60, 0x5950, 0xdcc0, 0xebf0, 0xb2a0, 0x8590, 0xa9a1, 0x9e91, 0xc7c1,
            0xf0f1, 0x7561, 0x4251, 0x1b01, 0x2c31, 0x4363, 0x7453, 0x2d03, 0x1a33, 0x9fa3, 0xa893,
            0xf1c3, 0xc6f3, 0xeac2, 0xddf2, 0x84a2, 0xb392, 0x3602, 0x0132, 0x5862, 0x6f52, 0x86c6,
            0xb1f6, 0xe8a6, 0xdf96, 0x5a06, 0x6d36, 0x3466, 0x0356, 0x2f67, 0x1857, 0x4107, 0x7637,
            0xf3a7, 0xc497, 0x9dc7, 0xaaf7, 0xc5a5, 0xf295, 0xabc5, 0x9cf5, 0x1965, 0x2e55, 0x7705,
            0x4035, 0x6c04, 0x5b34, 0x0264, 0x3554, 0xb0c4, 0x87f4, 0xdea4, 0xe994, 0x1dad, 0x2a9d,
            0x73cd, 0x44fd, 0xc16d, 0xf65d, 0xaf0d, 0x983d, 0xb40c, 0x833c, 0xda6c, 0xed5c, 0x68cc,
            0x5ffc, 0x06ac, 0x319c, 0x5ece, 0x69fe, 0x30ae, 0x079e, 0x820e, 0xb53e, 0xec6e, 0xdb5e,
            0xf76f, 0xc05f, 0x990f, 0xae3f, 0x2baf, 0x1c9f, 0x45cf, 0x72ff, 0x9b6b, 0xac5b, 0xf50b,
            0xc23b, 0x47ab, 0x709b, 0x29cb, 0x1efb, 0x32ca, 0x05fa, 0x5caa, 0x6b9a, 0xee0a, 0xd93a,
            0x806a, 0xb75a, 0xd808, 0xef38, 0xb668, 0x8158, 0x04c8, 0x33f8, 0x6aa8, 0x5d98, 0x71a9,
            0x4699, 0x1fc9, 0x28f9, 0xad69, 0x9a59, 0xc309, 0xf439, 0x3b5a, 0x0c6a, 0x553a, 0x620a,
            0xe79a, 0xd0aa, 0x89fa, 0xbeca, 0x92fb, 0xa5cb, 0xfc9b, 0xcbab, 0x4e3b, 0x790b, 0x205b,
            0x176b, 0x7839, 0x4f09, 0x1659, 0x2169, 0xa4f9, 0x93c9, 0xca99, 0xfda9, 0xd198, 0xe6a8,
            0xbff8, 0x88c8, 0x0d58, 0x3a68, 0x6338, 0x5408, 0xbd9c, 0x8aac, 0xd3fc, 0xe4cc, 0x615c,
            0x566c, 0x0f3c, 0x380c, 0x143d, 0x230d, 0x7a5d, 0x4d6d, 0xc8fd, 0xffcd, 0xa69d, 0x91ad,
            0xfeff, 0xc9cf, 0x909f, 0xa7af, 0x223f, 0x150f, 0x4c5f, 0x7b6f, 0x575e, 0x606e, 0x393e,
            0x0e0e, 0x8b9e, 0xbcae, 0xe5fe, 0xd2ce, 0x26f7, 0x11c7, 0x4897, 0x7fa7, 0xfa37, 0xcd07,
            0x9457, 0xa367, 0x8f56, 0xb866, 0xe136, 0xd606, 0x5396, 0x64a6, 0x3df6, 0x0ac6, 0x6594,
            0x52a4, 0x0bf4, 0x3cc4, 0xb954, 0x8e64, 0xd734, 0xe004, 0xcc35, 0xfb05, 0xa255, 0x9565,
            0x10f5, 0x27c5, 0x7e95, 0x49a5, 0xa031, 0x9701, 0xce51, 0xf961, 0x7cf1, 0x4bc1, 0x1291,
            0x25a1, 0x0990, 0x3ea0, 0x67f0, 0x50c0, 0xd550, 0xe260, 0xbb30, 0x8c00, 0xe352, 0xd462,
            0x8d32, 0xba02, 0x3f92, 0x08a2, 0x51f2, 0x66c2, 0x4af3, 0x7dc3, 0x2493, 0x13a3, 0x9633,
            0xa103, 0xf853, 0xcf63,
        ],
        [
            0x0000, 0x76b4, 0xed68, 0x9bdc, 0xcaf1, 0xbc45, 0x2799, 0x512d, 0x85c3, 0xf377, 0x68ab,
            0x1e1f, 0x4f32, 0x3986, 0xa25a, 0xd4ee, 0x1ba7, 0x6d13, 0xf6cf, 0x807b, 0xd156, 0xa7e2,
            0x3c3e, 0x4a8a, 0x9e64, 0xe8d0, 0x730c, 0x05b8, 0x5495, 0x2221, 0xb9fd, 0xcf49, 0x374e,
            0x41fa, 0xda26, 0xac92, 0xfdbf, 0x8b0b, 0x10d7, 0x6663, 0xb28d, 0xc439, 0x5fe5, 0x2951,
            0x787c, 0x0ec8, 0x9514, 0xe3a0, 0x2ce9, 0x5a5d, 0xc181, 0xb735, 0xe618, 0x90ac, 0x0b70,
            0x7dc4, 0xa92a, 0xdf9e, 0x4442, 0x32f6, 0x63db, 0x156f, 0x8eb3, 0xf807, 0x6e9c, 0x1828,
            0x83f4, 0xf540, 0xa46d, 0xd2d9, 0x4905, 0x3fb1, 0xeb5f, 0x9deb, 0x0637, 0x7083, 0x21ae,
            0x571a, 0xccc6, 0xba72, 0x753b, 0x038f, 0x9853, 0xeee7, 0xbfca, 0xc97e, 0x52a2, 0x2416,
            0xf0f8, 0x864c, 0x1d90, 0x6b24, 0x3a09, 0x4cbd, 0xd761, 0xa1d5, 0x59d2, 0x2f66, 0xb4ba,
            0xc20e, 0x9323, 0xe597, 0x7e4b, 0x08ff, 0xdc11, 0xaaa5, 0x3179, 0x47cd, 0x16e0, 0x6054,
            0xfb88, 0x8d3c, 0x4275, 0x34c1, 0xaf1d, 0xd9a9, 0x8884, 0xfe30, 0x65ec, 0x1358, 0xc7b6,
            0xb102, 0x2ade, 0x5c6a, 0x0d47, 0x7bf3, 0xe02f, 0x969b, 0xdd38, 0xab8c, 0x3050, 0x46e4,
            0x17c9, 0x617d, 0xfaa1, 0x8c15, 0x58fb, 0x2e4f, 0xb593, 0xc327, 0x920a, 0xe4be, 0x7f62,
            0x09d6, 0xc69f, 0xb02b, 0x2bf7, 0x5d43, 0x0c6e, 0x7ada, 0xe106, 0x97b2, 0x435c, 0x35e8,
            0xae34, 0xd880, 0x89ad, 0xff19, 0x64c5, 0x1271, 0xea76, 0x9cc2, 0x071e, 0x71aa, 0x2087,
            0x5633, 0xcdef, 0xbb5b, 0x6fb5, 0x1901, 0x82dd, 0xf469, 0xa544, 0xd3f0, 0x482c, 0x3e98,
            0xf1d1, 0x8765, 0x1cb9, 0x6a0d, 0x3b20, 0x4d94, 0xd648, 0xa0fc, 0x7412, 0x02a6, 0x997a,
            0xefce, 0xbee3, 0xc857, 0x538b, 0x253f, 0xb3a4, 0xc510, 0x5ecc, 0x2878, 0x7955, 0x0fe1,
            0x943d, 0xe289, 0x3667, 0x40d3, 0xdb0f, 0xadbb, 0xfc96, 0x8a22, 0x11fe, 0x674a, 0xa803,
            0xdeb7, 0x456b, 0x33df, 0x62f2, 0x1446, 0x8f9a, 0xf92e, 0x2dc0, 0x5b74, 0xc0a8, 0xb61c,
            0xe731, 0x9185, 0x0a59, 0x7ced, 0x84ea, 0xf25e, 0x6982, 0x1f36, 0x4e1b, 0x38af, 0xa373,
            0xd5c7, 0x0129, 0x779d, 0xec41, 0x9af5, 0xcbd8, 0xbd6c, 0x26b0, 0x5004, 0x9f4d, 0xe9f9,
            0x7225, 0x0491, 0x55bc, 0x2308, 0xb8d4, 0xce60, 0x1a8e, 0x6c3a, 0xf7e6, 0x8152, 0xd07f,
            0xa6cb, 0x3d17, 0x4ba3,
        ],
        [
            0x0000, 0xaa51, 0x4483, 0xeed2, 0x8906, 0x2357, 0xcd85, 0x67d4, 0x022d, 0xa87c, 0x46ae,
            0xecff, 0x8b2b, 0x217a, 0xcfa8, 0x65f9, 0x045a, 0xae0b, 0x40d9, 0xea88, 0x8d5c, 0x270d,
            0xc9df, 0x638e, 0x0677, 0xac26, 0x42f4, 0xe8a5, 0x8f71, 0x2520, 0xcbf2, 0x61a3, 0x08b4,
            0xa2e5, 0x4c37, 0xe666, 0x81b2, 0x2be3, 0xc531, 0x6f60, 0x0a99, 0xa0c8, 0x4e1a, 0xe44b,
            0x839f, 0x29ce, 0xc71c, 0x6d4d, 0x0cee, 0xa6bf, 0x486d, 0xe23c, 0x85e8, 0x2fb9, 0xc16b,
            0x6b3a, 0x0ec3, 0xa492, 0x4a40, 0xe011, 0x87c5, 0x2d94, 0xc346, 0x6917, 0x1168, 0xbb39,
            0x55eb, 0xffba, 0x986e, 0x323f, 0xdced, 0x76bc, 0x1345, 0xb914, 0x57c6, 0xfd97, 0x9a43,
            0x3012, 0xdec0, 0x7491, 0x1532, 0xbf63, 0x51b1, 0xfbe0, 0x9c34, 0x3665, 0xd8b7, 0x72e6,
            0x171f, 0xbd4e, 0x539c, 0xf9cd, 0x9e19, 0x3448, 0xda9a, 0x70cb, 0x19dc, 0xb38d, 0x5d5f,
            0xf70e, 0x90da, 0x3a8b, 0xd459, 0x7e08, 0x1bf1, 0xb1a0, 0x5f72, 0xf523, 0x92f7, 0x38a6,
            0xd674, 0x7c25, 0x1d86, 0xb7d7, 0x5905, 0xf354, 0x9480, 0x3ed1, 0xd003, 0x7a52, 0x1fab,
            0xb5fa, 0x5b28, 0xf179, 0x96ad, 0x3cfc, 0xd22e, 0x787f, 0x22d0, 0x8881, 0x6653, 0xcc02,
            0xabd6, 0x0187, 0xef55, 0x4504, 0x20fd, 0x8aac, 0x647e, 0xce2f, 0xa9fb, 0x03aa, 0xed78,
            0x4729, 0x268a, 0x8cdb, 0x6209, 0xc858, 0xaf8c, 0x05dd, 0xeb0f, 0x415e, 0x24a7, 0x8ef6,
            0x6024, 0xca75, 0xada1, 0x07f0, 0xe922, 0x4373, 0x2a64, 0x8035, 0x6ee7, 0xc4b6, 0xa362,
            0x0933, 0xe7e1, 0x4db0, 0x2849, 0x8218, 0x6cca, 0xc69b, 0xa14f, 0x0b1e, 0xe5cc, 0x4f9d,
            0x2e3e, 0x846f, 0x6abd, 0xc0ec, 0xa738, 0x0d69, 0xe3bb, 0x49ea, 0x2c13, 0x8642, 0x6890,
            0xc2c1, 0xa515, 0x0f44, 0xe196, 0x4bc7, 0x33b8, 0x99e9, 0x773b, 0xdd6a, 0xbabe, 0x10ef,
            0xfe3d, 0x546c, 0x3195, 0x9bc4, 0x7516, 0xdf47, 0xb893, 0x12c2, 0xfc10, 0x5641, 0x37e2,
            0x9db3, 0x7361, 0xd930, 0xbee4, 0x14b5, 0xfa67, 0x5036, 0x35cf, 0x9f9e, 0x714c, 0xdb1d,
            0xbcc9, 0x1698, 0xf84a, 0x521b, 0x3b0c, 0x915d, 0x7f8f, 0xd5de, 0xb20a, 0x185b, 0xf689,
            0x5cd8, 0x3921, 0x9370, 0x7da2, 0xd7f3, 0xb027, 0x1a76, 0xf4a4, 0x5ef5, 0x3f56, 0x9507,
            0x7bd5, 0xd184, 0xb650, 0x1c01, 0xf2d3, 0x5882, 0x3d7b, 0x972a, 0x79f8, 0xd3a9, 0xb47d,
            0x1e2c, 0xf0fe, 0x5aaf,
        ],
        [
            0x0000, 0x45a0, 0x8b40, 0xcee0, 0x06a1, 0x4301, 0x8de1, 0xc841, 0x0d42, 0x48e2, 0x8602,
            0xc3a2, 0x0be3, 0x4e43, 0x80a3, 0xc503, 0x1a84, 0x5f24, 0x91c4, 0xd464, 0x1c25, 0x5985,
            0x9765, 0xd2c5, 0x17c6, 0x5266, 0x9c86, 0xd926, 0x1167, 0x54c7, 0x9a27, 0xdf87, 0x3508,
            0x70a8, 0xbe48, 0xfbe8, 0x33a9, 0x7609, 0xb8e9, 0xfd49, 0x384a, 0x7dea, 0xb30a, 0xf6aa,
            0x3eeb, 0x7b4b, 0xb5ab, 0xf00b, 0x2f8c, 0x6a2c, 0xa4cc, 0xe16c, 0x292d, 0x6c8d, 0xa26d,
            0xe7cd, 0x22ce, 0x676e, 0xa98e, 0xec2e, 0x246f, 0x61cf, 0xaf2f, 0xea8f, 0x6a10, 0x2fb0,
            0xe150, 0xa4f0, 0x6cb1, 0x2911, 0xe7f1, 0xa251, 0x6752, 0x22f2, 0xec12, 0xa9b2, 0x61f3,
            0x2453, 0xeab3, 0xaf13, 0x7094, 0x3534, 0xfbd4, 0xbe74, 0x7635, 0x3395, 0xfd75, 0xb8d5,
            0x7dd6, 0x3876, 0xf696, 0xb336, 0x7b77, 0x3ed7, 0xf037, 0xb597, 0x5f18, 0x1ab8, 0xd458,
            0x91f8, 0x59b9, 0x1c19, 0xd2f9, 0x9759, 0x525a, 0x17fa, 0xd91a, 0x9cba, 0x54fb, 0x115b,
            0xdfbb, 0x9a1b, 0x459c, 0x003c, 0xcedc, 0x8b7c, 0x433d, 0x069d, 0xc87d, 0x8ddd, 0x48de,
            0x0d7e, 0xc39e, 0x863e, 0x4e7f, 0x0bdf, 0xc53f, 0x809f, 0xd420, 0x9180, 0x5f60, 0x1ac0,
            0xd281, 0x9721, 0x59c1, 0x1c61, 0xd962, 0x9cc2, 0x5222, 0x1782, 0xdfc3, 0x9a63, 0x5483,
            0x1123, 0xcea4, 0x8b04, 0x45e4, 0x0044, 0xc805, 0x8da5, 0x4345, 0x06e5, 0xc3e6, 0x8646,
            0x48a6, 0x0d06, 0xc547, 0x80e7, 0x4e07, 0x0ba7, 0xe128, 0xa488, 0x6a68, 0x2fc8, 0xe789,
            0xa229, 0x6cc9, 0x2969, 0xec6a, 0xa9ca, 0x672a, 0x228a, 0xeacb, 0xaf6b, 0x618b, 0x242b,
            0xfbac, 0xbe0c, 0x70ec, 0x354c, 0xfd0d, 0xb8ad, 0x764d, 0x33ed, 0xf6ee, 0xb34e, 0x7dae,
            0x380e, 0xf04f, 0xb5ef, 0x7b0f, 0x3eaf, 0xbe30, 0xfb90, 0x3570, 0x70d0, 0xb891, 0xfd31,
            0x33d1, 0x7671, 0xb372, 0xf6d2, 0x3832, 0x7d92, 0xb5d3, 0xf073, 0x3e93, 0x7b33, 0xa4b4,
            0xe114, 0x2ff4, 0x6a54, 0xa215, 0xe7b5, 0x2955, 0x6cf5, 0xa9f6, 0xec56, 0x22b6, 0x6716,
            0xaf57, 0xeaf7, 0x2417, 0x61b7, 0x8b38, 0xce98, 0x0078, 0x45d8, 0x8d99, 0xc839, 0x06d9,
            0x4379, 0x867a, 0xc3da, 0x0d3a, 0x489a, 0x80db, 0xc57b, 0x0b9b, 0x4e3b, 0x91bc, 0xd41c,
            0x1afc, 0x5f5c, 0x971d, 0xd2bd, 0x1c5d, 0x59fd, 0x9cfe, 0xd95e, 0x17be, 0x521e, 0x9a5f,
            0xdfff, 0x111f, 0x54bf,
        ],
        [
            0x0000, 0xb861, 0x60e3, 0xd882, 0xc1c6, 0x79a7, 0xa125, 0x1944, 0x93ad, 0x2bcc, 0xf34e,
            0x4b2f, 0x526b, 0xea0a, 0x3288, 0x8ae9, 0x377b, 0x8f1a, 0x5798, 0xeff9, 0xf6bd, 0x4edc,
            0x965e, 0x2e3f, 0xa4d6, 0x1cb7, 0xc435, 0x7c54, 0x6510, 0xdd71, 0x05f3, 0xbd92, 0x6ef6,
            0xd697, 0x0e15, 0xb674, 0xaf30, 0x1751, 0xcfd3, 0x77b2, 0xfd5b, 0x453a, 0x9db8, 0x25d9,
            0x3c9d, 0x84fc, 0x5c7e, 0xe41f, 0x598d, 0xe1ec, 0x396e, 0x810f, 0x984b, 0x202a, 0xf8a8,
            0x40c9, 0xca20, 0x7241, 0xaac3, 0x12a2, 0x0be6, 0xb387, 0x6b05, 0xd364, 0xddec, 0x658d,
            0xbd0f, 0x056e, 0x1c2a, 0xa44b, 0x7cc9, 0xc4a8, 0x4e41, 0xf620, 0x2ea2, 0x96c3, 0x8f87,
            0x37e6, 0xef64, 0x5705, 0xea97, 0x52f6, 0x8a74, 0x3215, 0x2b51, 0x9330, 0x4bb2, 0xf3d3,
            0x793a, 0xc15b, 0x19d9, 0xa1b8, 0xb8fc, 0x009d, 0xd81f, 0x607e, 0xb31a, 0x0b7b, 0xd3f9,
            0x6b98, 0x72dc, 0xcabd, 0x123f, 0xaa5e, 0x20b7, 0x98d6, 0x4054, 0xf835, 0xe171, 0x5910,
            0x8192, 0x39f3, 0x8461, 0x3c00, 0xe482, 0x5ce3, 0x45a7, 0xfdc6, 0x2544, 0x9d25, 0x17cc,
            0xafad, 0x772f, 0xcf4e, 0xd60a, 0x6e6b, 0xb6e9, 0x0e88, 0xabf9, 0x1398, 0xcb1a, 0x737b,
            0x6a3f, 0xd25e, 0x0adc, 0xb2bd, 0x3854, 0x8035, 0x58b7, 0xe0d6, 0xf992, 0x41f3, 0x9971,
            0x2110, 0x9c82, 0x24e3, 0xfc61, 0x4400, 0x5d44, 0xe525, 0x3da7, 0x85c6, 0x0f2f, 0xb74e,
            0x6fcc, 0xd7ad, 0xcee9, 0x7688, 0xae0a, 0x166b, 0xc50f, 0x7d6e, 0xa5ec, 0x1d8d, 0x04c9,
            0xbca8, 0x642a, 0xdc4b, 0x56a2, 0xeec3, 0x3641, 0x8e20, 0x9764, 0x2f05, 0xf787, 0x4fe6,
            0xf274, 0x4a15, 0x9297, 0x2af6, 0x33b2, 0x8bd3, 0x5351, 0xeb30, 0x61d9, 0xd9b8, 0x013a,
            0xb95b, 0xa01f, 0x187e, 0xc0fc, 0x789d, 0x7615, 0xce74, 0x16f6, 0xae97, 0xb7d3, 0x0fb2,
            0xd730, 0x6f51, 0xe5b8, 0x5dd9, 0x855b, 0x3d3a, 0x247e, 0x9c1f, 0x449d, 0xfcfc, 0x416e,
            0xf90f, 0x218d, 0x99ec, 0x80a8, 0x38c9, 0xe04b, 0x582a, 0xd2c3, 0x6aa2, 0xb220, 0x0a41,
            0x1305, 0xab64, 0x73e6, 0xcb87, 0x18e3, 0xa082, 0x7800, 0xc061, 0xd925, 0x6144, 0xb9c6,
            0x01a7, 0x8b4e, 0x332f, 0xebad, 0x53cc, 0x4a88, 0xf2e9, 0x2a6b, 0x920a, 0x2f98, 0x97f9,
            0x4f7b, 0xf71a, 0xee5e, 0x563f, 0x8ebd, 0x36dc, 0xbc35, 0x0454, 0xdcd6, 0x64b7, 0x7df3,
            0xc592, 0x1d10, 0xa571,
        ],
        [
            0x0000, 0x47d3, 0x8fa6, 0xc875, 0x0f6d, 0x48be, 0x80cb, 0xc718, 0x1eda, 0x5909, 0x917c,
            0xd6af, 0x11b7, 0x5664, 0x9e11, 0xd9c2, 0x3db4, 0x7a67, 0xb212, 0xf5c1, 0x32d9, 0x750a,
            0xbd7f, 0xfaac, 0x236e, 0x64bd, 0xacc8, 0xeb1b, 0x2c03, 0x6bd0, 0xa3a5, 0xe476, 0x7b68,
            0x3cbb, 0xf4ce, 0xb31d, 0x7405, 0x33d6, 0xfba3, 0xbc70, 0x65b2, 0x2261, 0xea14, 0xadc7,
            0x6adf, 0x2d0c, 0xe579, 0xa2aa, 0x46dc, 0x010f, 0xc97a, 0x8ea9, 0x49b1, 0x0e62, 0xc617,
            0x81c4, 0x5806, 0x1fd5, 0xd7a0, 0x9073, 0x576b, 0x10b8, 0xd8cd, 0x9f1e, 0xf6d0, 0xb103,
            0x7976, 0x3ea5, 0xf9bd, 0xbe6e, 0x761b, 0x31c8, 0xe80a, 0xafd9, 0x67ac, 0x207f, 0xe767,
            0xa0b4, 0x68c1, 0x2f12, 0xcb64, 0x8cb7, 0x44c2, 0x0311, 0xc409, 0x83da, 0x4baf, 0x0c7c,
            0xd5be, 0x926d, 0x5a18, 0x1dcb, 0xdad3, 0x9d00, 0x5575, 0x12a6, 0x8db8, 0xca6b, 0x021e,
            0x45cd, 0x82d5, 0xc506, 0x0d73, 0x4aa0, 0x9362, 0xd4b1, 0x1cc4, 0x5b17, 0x9c0f, 0xdbdc,
            0x13a9, 0x547a, 0xb00c, 0xf7df, 0x3faa, 0x7879, 0xbf61, 0xf8b2, 0x30c7, 0x7714, 0xaed6,
            0xe905, 0x2170, 0x66a3, 0xa1bb, 0xe668, 0x2e1d, 0x69ce, 0xfd81, 0xba52, 0x7227, 0x35f4,
            0xf2ec, 0xb53f, 0x7d4a, 0x3a99, 0xe35b, 0xa488, 0x6cfd, 0x2b2e, 0xec36, 0xabe5, 0x6390,
            0x2443, 0xc035, 0x87e6, 0x4f93, 0x0840, 0xcf58, 0x888b, 0x40fe, 0x072d, 0xdeef, 0x993c,
            0x5149, 0x169a, 0xd182, 0x9651, 0x5e24, 0x19f7, 0x86e9, 0xc13a, 0x094f, 0x4e9c, 0x8984,
            0xce57, 0x0622, 0x41f1, 0x9833, 0xdfe0, 0x1795, 0x5046, 0x975e, 0xd08d, 0x18f8, 0x5f2b,
            0xbb5d, 0xfc8e, 0x34fb, 0x7328, 0xb430, 0xf3e3, 0x3b96, 0x7c45, 0xa587, 0xe254, 0x2a21,
            0x6df2, 0xaaea, 0xed39, 0x254c, 0x629f, 0x0b51, 0x4c82, 0x84f7, 0xc324, 0x043c, 0x43ef,
            0x8b9a, 0xcc49, 0x158b, 0x5258, 0x9a2d, 0xddfe, 0x1ae6, 0x5d35, 0x9540, 0xd293, 0x36e5,
            0x7136, 0xb943, 0xfe90, 0x3988, 0x7e5b, 0xb62e, 0xf1fd, 0x283f, 0x6fec, 0xa799, 0xe04a,
            0x2752, 0x6081, 0xa8f4, 0xef27, 0x7039, 0x37ea, 0xff9f, 0xb84c, 0x7f54, 0x3887, 0xf0f2,
            0xb721, 0x6ee3, 0x2930, 0xe145, 0xa696, 0x618e, 0x265d, 0xee28, 0xa9fb, 0x4d8d, 0x0a5e,
            0xc22b, 0x85f8, 0x42e0, 0x0533, 0xcd46, 0x8a95, 0x5357, 0x1484, 0xdcf1, 0x9b22, 0x5c3a,
            0x1be9, 0xd39c, 0x944f,
        ],
        [
            0x0000, 0xeb23, 0xc667, 0x2d44, 0x9cef, 0x77cc, 0x5a88, 0xb1ab, 0x29ff, 0xc2dc, 0xef98,
            0x04bb, 0xb510, 0x5e33, 0x7377, 0x9854, 0x53fe, 0xb8dd, 0x9599, 0x7eba, 0xcf11, 0x2432,
            0x0976, 0xe255, 0x7a01, 0x9122, 0xbc66, 0x5745, 0xe6ee, 0x0dcd, 0x2089, 0xcbaa, 0xa7fc,
            0x4cdf, 0x619b, 0x8ab8, 0x3b13, 0xd030, 0xfd74, 0x1657, 0x8e03, 0x6520, 0x4864, 0xa347,
            0x12ec, 0xf9cf, 0xd48b, 0x3fa8, 0xf402, 0x1f21, 0x3265, 0xd946, 0x68ed, 0x83ce, 0xae8a,
            0x45a9, 0xddfd, 0x36de, 0x1b9a, 0xf0b9, 0x4112, 0xaa31, 0x8775, 0x6c56, 0x5fd9, 0xb4fa,
            0x99be, 0x729d, 0xc336, 0x2815, 0x0551, 0xee72, 0x7626, 0x9d05, 0xb041, 0x5b62, 0xeac9,
            0x01ea, 0x2cae, 0xc78d, 0x0c27, 0xe704, 0xca40, 0x2163, 0x90c8, 0x7beb, 0x56af, 0xbd8c,
            0x25d8, 0xcefb, 0xe3bf, 0x089c, 0xb937, 0x5214, 0x7f50, 0x9473, 0xf825, 0x1306, 0x3e42,
            0xd561, 0x64ca, 0x8fe9, 0xa2ad, 0x498e, 0xd1da, 0x3af9, 0x17bd, 0xfc9e, 0x4d35, 0xa616,
            0x8b52, 0x6071, 0xabdb, 0x40f8, 0x6dbc, 0x869f, 0x3734, 0xdc17, 0xf153, 0x1a70, 0x8224,
            0x6907, 0x4443, 0xaf60, 0x1ecb, 0xf5e8, 0xd8ac, 0x338f, 0xbfb2, 0x5491, 0x79d5, 0x92f6,
            0x235d, 0xc87e, 0xe53a, 0x0e19, 0x964d, 0x7d6e, 0x502a, 0xbb09, 0x0aa2, 0xe181, 0xccc5,
            0x27e6, 0xec4c, 0x076f, 0x2a2b, 0xc108, 0x70a3, 0x9b80, 0xb6c4, 0x5de7, 0xc5b3, 0x2e90,
            0x03d4, 0xe8f7, 0x595c, 0xb27f, 0x9f3b, 0x7418, 0x184e, 0xf36d, 0xde29, 0x350a, 0x84a1,
            0x6f82, 0x42c6, 0xa9e5, 0x31b1, 0xda92, 0xf7d6, 0x1cf5, 0xad5e, 0x467d, 0x6b39, 0x801a,
            0x4bb0, 0xa093, 0x8dd7, 0x66f4, 0xd75f, 0x3c7c, 0x1138, 0xfa1b, 0x624f, 0x896c, 0xa428,
            0x4f0b, 0xfea0, 0x1583, 0x38c7, 0xd3e4, 0xe06b, 0x0b48, 0x260c, 0xcd2f, 0x7c84, 0x97a7,
            0xbae3, 0x51c0, 0xc994, 0x22b7, 0x0ff3, 0xe4d0, 0x557b, 0xbe58, 0x931c, 0x783f, 0xb395,
            0x58b6, 0x75f2, 0x9ed1, 0x2f7a, 0xc459, 0xe91d, 0x023e, 0x9a6a, 0x7149, 0x5c0d, 0xb72e,
            0x0685, 0xeda6, 0xc0e2, 0x2bc1, 0x4797, 0xacb4, 0x81f0, 0x6ad3, 0xdb78, 0x305b, 0x1d1f,
            0xf63c, 0x6e68, 0x854b, 0xa80f, 0x432c, 0xf287, 0x19a4, 0x34e0, 0xdfc3, 0x1469, 0xff4a,
            0xd20e, 0x392d, 0x8886, 0x63a5, 0x4ee1, 0xa5c2, 0x3d96, 0xd6b5, 0xfbf1, 0x10d2, 0xa179,
            0x4a5a, 0x671e, 0x8c3d,
        ],
        [
            0x0000, 0x6f45, 0xde8a, 0xb1cf, 0xad35, 0xc270, 0x73bf, 0x1cfa, 0x4a4b, 0x250e, 0x94c1,
            0xfb84, 0xe77e, 0x883b, 0x39f4, 0x56b1, 0x9496, 0xfbd3, 0x4a1c, 0x2559, 0x39a3, 0x56e6,
            0xe729, 0x886c, 0xdedd, 0xb198, 0x0057, 0x6f12, 0x73e8, 0x1cad, 0xad62, 0xc227, 0x390d,
            0x5648, 0xe787, 0x88c2, 0x9438, 0xfb7d, 0x4ab2, 0x25f7, 0x7346, 0x1c03, 0xadcc, 0xc289,
            0xde73, 0xb136, 0x00f9, 0x6fbc, 0xad9b, 0xc2de, 0x7311, 0x1c54, 0x00ae, 0x6feb, 0xde24,
            0xb161, 0xe7d0, 0x8895, 0x395a, 0x561f, 0x4ae5, 0x25a0, 0x946f, 0xfb2a, 0x721a, 0x1d5f,
            0xac90, 0xc3d5, 0xdf2f, 0xb06a, 0x01a5, 0x6ee0, 0x3851, 0x5714, 0xe6db, 0x899e, 0x9564,
            0xfa21, 0x4bee, 0x24ab, 0xe68c, 0x89c9, 0x3806, 0x5743, 0x4bb9, 0x24fc, 0x9533, 0xfa76,
            0xacc7, 0xc382, 0x724d, 0x1d08, 0x01f2, 0x6eb7, 0xdf78, 0xb03d, 0x4b17, 0x2452, 0x959d,
            0xfad8, 0xe622, 0x8967, 0x38a8, 0x57ed, 0x015c, 0x6e19, 0xdfd6, 0xb093, 0xac69, 0xc32c,
            0x72e3, 0x1da6, 0xdf81, 0xb0c4, 0x010b, 0x6e4e, 0x72b4, 0x1df1, 0xac3e, 0xc37b, 0x95ca,
            0xfa8f, 0x4b40, 0x2405, 0x38ff, 0x57ba, 0xe675, 0x8930, 0xe434, 0x8b71, 0x3abe, 0x55fb,
            0x4901, 0x2644, 0x978b, 0xf8ce, 0xae7f, 0xc13a, 0x70f5, 0x1fb0, 0x034a, 0x6c0f, 0xddc0,
            0xb285, 0x70a2, 0x1fe7, 0xae28, 0xc16d, 0xdd97, 0xb2d2, 0x031d, 0x6c58, 0x3ae9, 0x55ac,
            0xe463, 0x8b26, 0x97dc, 0xf899, 0x4956, 0x2613, 0xdd39, 0xb27c, 0x03b3, 0x6cf6, 0x700c,
            0x1f49, 0xae86, 0xc1c3, 0x9772, 0xf837, 0x49f8, 0x26bd, 0x3a47, 0x5502, 0xe4cd, 0x8b88,
            0x49af, 0x26ea, 0x9725, 0xf860, 0xe49a, 0x8bdf, 0x3a10, 0x5555, 0x03e4, 0x6ca1, 0xdd6e,
            0xb22b, 0xaed1, 0xc194, 0x705b, 0x1f1e, 0x962e, 0xf96b, 0x48a4, 0x27e1, 0x3b1b, 0x545e,
            0xe591, 0x8ad4, 0xdc65, 0xb320, 0x02ef, 0x6daa, 0x7150, 0x1e15, 0xafda, 0xc09f, 0x02b8,
            0x6dfd, 0xdc32, 0xb377, 0xaf8d, 0xc0c8, 0x7107, 0x1e42, 0x48f3, 0x27b6, 0x9679, 0xf93c,
            0xe5c6, 0x8a83, 0x3b4c, 0x5409, 0xaf23, 0xc066, 0x71a9, 0x1eec, 0x0216, 0x6d53, 0xdc9c,
            0xb3d9, 0xe568, 0x8a2d, 0x3be2, 0x54a7, 0x485d, 0x2718, 0x96d7, 0xf992, 0x3bb5, 0x54f0,
            0xe53f, 0x8a7a, 0x9680, 0xf9c5, 0x480a, 0x274f, 0x71fe, 0x1ebb, 0xaf74, 0xc031, 0xdccb,
            0xb38e, 0x0241, 0x6d04,
        ],
        [
            0x0000, 0xd849, 0xa0b3, 0x78fa, 0x5147, 0x890e, 0xf1f4, 0x29bd, 0xa28e, 0x7ac7, 0x023d,
            0xda74, 0xf3c9, 0x2b80, 0x537a, 0x8b33, 0x553d, 0x8d74, 0xf58e, 0x2dc7, 0x047a, 0xdc33,
            0xa4c9, 0x7c80, 0xf7b3, 0x2ffa, 0x5700, 0x8f49, 0xa6f4, 0x7ebd, 0x0647, 0xde0e, 0xaa7a,
            0x7233, 0x0ac9, 0xd280, 0xfb3d, 0x2374, 0x5b8e, 0x83c7, 0x08f4, 0xd0bd, 0xa847, 0x700e,
            0x59b3, 0x81fa, 0xf900, 0x2149, 0xff47, 0x270e, 0x5ff4, 0x87bd, 0xae00, 0x7649, 0x0eb3,
            0xd6fa, 0x5dc9, 0x8580, 0xfd7a, 0x2533, 0x0c8e, 0xd4c7, 0xac3d, 0x7474, 0x44d5, 0x9c9c,
            0xe466, 0x3c2f, 0x1592, 0xcddb, 0xb521, 0x6d68, 0xe65b, 0x3e12, 0x46e8, 0x9ea1, 0xb71c,
            0x6f55, 0x17af, 0xcfe6, 0x11e8, 0xc9a1, 0xb15b, 0x6912, 0x40af, 0x98e6, 0xe01c, 0x3855,
            0xb366, 0x6b2f, 0x13d5, 0xcb9c, 0xe221, 0x3a68, 0x4292, 0x9adb, 0xeeaf, 0x36e6, 0x4e1c,
            0x9655, 0xbfe8, 0x67a1, 0x1f5b, 0xc712, 0x4c21, 0x9468, 0xec92, 0x34db, 0x1d66, 0xc52f,
            0xbdd5, 0x659c, 0xbb92, 0x63db, 0x1b21, 0xc368, 0xead5, 0x329c, 0x4a66, 0x922f, 0x191c,
            0xc155, 0xb9af, 0x61e6, 0x485b, 0x9012, 0xe8e8, 0x30a1, 0x89aa, 0x51e3, 0x2919, 0xf150,
            0xd8ed, 0x00a4, 0x785e, 0xa017, 0x2b24, 0xf36d, 0x8b97, 0x53de, 0x7a63, 0xa22a, 0xdad0,
            0x0299, 0xdc97, 0x04de, 0x7c24, 0xa46d, 0x8dd0, 0x5599, 0x2d63, 0xf52a, 0x7e19, 0xa650,
            0xdeaa, 0x06e3, 0x2f5e, 0xf717, 0x8fed, 0x57a4, 0x23d0, 0xfb99, 0x8363, 0x5b2a, 0x7297,
            0xaade, 0xd224, 0x0a6d, 0x815e, 0x5917, 0x21ed, 0xf9a4, 0xd019, 0x0850, 0x70aa, 0xa8e3,
            0x76ed, 0xaea4, 0xd65e, 0x0e17, 0x27aa, 0xffe3, 0x8719, 0x5f50, 0xd463, 0x0c2a, 0x74d0,
            0xac99, 0x8524, 0x5d6d, 0x2597, 0xfdde, 0xcd7f, 0x1536, 0x6dcc, 0xb585, 0x9c38, 0x4471,
            0x3c8b, 0xe4c2, 0x6ff1, 0xb7b8, 0xcf42, 0x170b, 0x3eb6, 0xe6ff, 0x9e05, 0x464c, 0x9842,
            0x400b, 0x38f1, 0xe0b8, 0xc905, 0x114c, 0x69b6, 0xb1ff, 0x3acc, 0xe285, 0x9a7f, 0x4236,
            0x6b8b, 0xb3c2, 0xcb38, 0x1371, 0x6705, 0xbf4c, 0xc7b6, 0x1fff, 0x3642, 0xee0b, 0x96f1,
            0x4eb8, 0xc58b, 0x1dc2, 0x6538, 0xbd71, 0x94cc, 0x4c85, 0x347f, 0xec36, 0x3238, 0xea71,
            0x928b, 0x4ac2, 0x637f, 0xbb36, 0xc3cc, 0x1b85, 0x90b6, 0x48ff, 0x3005, 0xe84c, 0xc1f1,
            0x19b8, 0x6142, 0xb90b,
        ],
        [
            0x0000, 0x0375, 0x06ea, 0x059f, 0x0dd4, 0x0ea1, 0x0b3e, 0x084b, 0x1ba8, 0x18dd, 0x1d42,
            0x1e37, 0x167c, 0x1509, 0x1096, 0x13e3, 0x3750, 0x3425, 0x31ba, 0x32cf, 0x3a84, 0x39f1,
            0x3c6e, 0x3f1b, 0x2cf8, 0x2f8d, 0x2a12, 0x2967, 0x212c, 0x2259, 0x27c6, 0x24b3, 0x6ea0,
            0x6dd5, 0x684a, 0x6b3f, 0x6374, 0x6001, 0x659e, 0x66eb, 0x7508, 0x767d, 0x73e2, 0x7097,
            0x78dc, 0x7ba9, 0x7e36, 0x7d43, 0x59f0, 0x5a85, 0x5f1a, 0x5c6f, 0x5424, 0x5751, 0x52ce,
            0x51bb, 0x4258, 0x412d, 0x44b2, 0x47c7, 0x4f8c, 0x4cf9, 0x4966, 0x4a13, 0xdd40, 0xde35,
            0xdbaa, 0xd8df, 0xd094, 0xd3e1, 0xd67e, 0xd50b, 0xc6e8, 0xc59d, 0xc002, 0xc377, 0xcb3c,
            0xc849, 0xcdd6, 0xcea3, 0xea10, 0xe965, 0xecfa, 0xef8f, 0xe7c4, 0xe4b1, 0xe12e, 0xe25b,
            0xf1b8, 0xf2cd, 0xf752, 0xf427, 0xfc6c, 0xff19, 0xfa86, 0xf9f3, 0xb3e0, 0xb095, 0xb50a,
            0xb67f, 0xbe34, 0xbd41, 0xb8de, 0xbbab, 0xa848, 0xab3d, 0xaea2, 0xadd7, 0xa59c, 0xa6e9,
            0xa376, 0xa003, 0x84b0, 0x87c5, 0x825a, 0x812f, 0x8964, 0x8a11, 0x8f8e, 0x8cfb, 0x9f18,
            0x9c6d, 0x99f2, 0x9a87, 0x92cc, 0x91b9, 0x9426, 0x9753, 0xaaa1, 0xa9d4, 0xac4b, 0xaf3e,
            0xa775, 0xa400, 0xa19f, 0xa2ea, 0xb109, 0xb27c, 0xb7e3, 0xb496, 0xbcdd, 0xbfa8, 0xba37,
            0xb942, 0x9df1, 0x9e84, 0x9b1b, 0x986e, 0x9025, 0x9350, 0x96cf, 0x95ba, 0x8659, 0x852c,
            0x80b3, 0x83c6, 0x8b8d, 0x88f8, 0x8d67, 0x8e12, 0xc401, 0xc774, 0xc2eb, 0xc19e, 0xc9d5,
            0xcaa0, 0xcf3f, 0xcc4a, 0xdfa9, 0xdcdc, 0xd943, 0xda36, 0xd27d, 0xd108, 0xd497, 0xd7e2,
            0xf351, 0xf024, 0xf5bb, 0xf6ce, 0xfe85, 0xfdf0, 0xf86f, 0xfb1a, 0xe8f9, 0xeb8c, 0xee13,
            0xed66, 0xe52d, 0xe658, 0xe3c7, 0xe0b2, 0x77e1, 0x7494, 0x710b, 0x727e, 0x7a35, 0x7940,
            0x7cdf, 0x7faa, 0x6c49, 0x6f3c, 0x6aa3, 0x69d6, 0x619d, 0x62e8, 0x6777, 0x6402, 0x40b1,
            0x43c4, 0x465b, 0x452e, 0x4d65, 0x4e10, 0x4b8f, 0x48fa, 0x5b19, 0x586c, 0x5df3, 0x5e86,
            0x56cd, 0x55b8, 0x5027, 0x5352, 0x1941, 0x1a34, 0x1fab, 0x1cde, 0x1495, 0x17e0, 0x127f,
            0x110a, 0x02e9, 0x019c, 0x0403, 0x0776, 0x0f3d, 0x0c48, 0x09d7, 0x0aa2, 0x2e11, 0x2d64,
            0x28fb, 0x2b8e, 0x23c5, 0x20b0, 0x252f, 0x265a, 0x35b9, 0x36cc, 0x3353, 0x3026, 0x386d,
            0x3b18, 0x3e87, 0x3df2,
        ],
        [
            0x0000, 0x4563, 0x8ac6, 0xcfa5, 0x05ad, 0x40ce, 0x8f6b, 0xca08, 0x0b5a, 0x4e39, 0x819c,
            0xc4ff, 0x0ef7, 0x4b94, 0x8431, 0xc152, 0x16b4, 0x53d7, 0x9c72, 0xd911, 0x1319, 0x567a,
            0x99df, 0xdcbc, 0x1dee, 0x588d, 0x9728, 0xd24b, 0x1843, 0x5d20, 0x9285, 0xd7e6, 0x2d68,
            0x680b, 0xa7ae, 0xe2cd, 0x28c5, 0x6da6, 0xa203, 0xe760, 0x2632, 0x6351, 0xacf4, 0xe997,
            0x239f, 0x66fc, 0xa959, 0xec3a, 0x3bdc, 0x7ebf, 0xb11a, 0xf479, 0x3e71, 0x7b12, 0xb4b7,
            0xf1d4, 0x3086, 0x75e5, 0xba40, 0xff23, 0x352b, 0x7048, 0xbfed, 0xfa8e, 0x5ad0, 0x1fb3,
            0xd016, 0x9575, 0x5f7d, 0x1a1e, 0xd5bb, 0x90d8, 0x518a, 0x14e9, 0xdb4c, 0x9e2f, 0x5427,
            0x1144, 0xdee1, 0x9b82, 0x4c64, 0x0907, 0xc6a2, 0x83c1, 0x49c9, 0x0caa, 0xc30f, 0x866c,
            0x473e, 0x025d, 0xcdf8, 0x889b, 0x4293, 0x07f0, 0xc855, 0x8d36, 0x77b8, 0x32db, 0xfd7e,
            0xb81d, 0x7215, 0x3776, 0xf8d3, 0xbdb0, 0x7ce2, 0x3981, 0xf624, 0xb347, 0x794f, 0x3c2c,
            0xf389, 0xb6ea, 0x610c, 0x246f, 0xebca, 0xaea9, 0x64a1, 0x21c2, 0xee67, 0xab04, 0x6a56,
            0x2f35, 0xe090, 0xa5f3, 0x6ffb, 0x2a98, 0xe53d, 0xa05e, 0xb5a0, 0xf0c3, 0x3f66, 0x7a05,
            0xb00d, 0xf56e, 0x3acb, 0x7fa8, 0xbefa, 0xfb99, 0x343c, 0x715f, 0xbb57, 0xfe34, 0x3191,
            0x74f2, 0xa314, 0xe677, 0x29d2, 0x6cb1, 0xa6b9, 0xe3da, 0x2c7f, 0x691c, 0xa84e, 0xed2d,
            0x2288, 0x67eb, 0xade3, 0xe880, 0x2725, 0x6246, 0x98c8, 0xddab, 0x120e, 0x576d, 0x9d65,
            0xd806, 0x17a3, 0x52c0, 0x9392, 0xd6f1, 0x1954, 0x5c37, 0x963f, 0xd35c, 0x1cf9, 0x599a,
            0x8e7c, 0xcb1f, 0x04ba, 0x41d9, 0x8bd1, 0xceb2, 0x0117, 0x4474, 0x8526, 0xc045, 0x0fe0,
            0x4a83, 0x808b, 0xc5e8, 0x0a4d, 0x4f2e, 0xef70, 0xaa13, 0x65b6, 0x20d5, 0xeadd, 0xafbe,
            0x601b, 0x2578, 0xe42a, 0xa149, 0x6eec, 0x2b8f, 0xe187, 0xa4e4, 0x6b41, 0x2e22, 0xf9c4,
            0xbca7, 0x7302, 0x3661, 0xfc69, 0xb90a, 0x76af, 0x33cc, 0xf29e, 0xb7fd, 0x7858, 0x3d3b,
            0xf733, 0xb250, 0x7df5, 0x3896, 0xc218, 0x877b, 0x48de, 0x0dbd, 0xc7b5, 0x82d6, 0x4d73,
            0x0810, 0xc942, 0x8c21, 0x4384, 0x06e7, 0xccef, 0x898c, 0x4629, 0x034a, 0xd4ac, 0x91cf,
            0x5e6a, 0x1b09, 0xd101, 0x9462, 0x5bc7, 0x1ea4, 0xdff6, 0x9a95, 0x5530, 0x1053, 0xda5b,
            0x9f38, 0x509d, 0x15fe,
        ],
        [
            0x0000, 0x7b61, 0xf6c2, 0x8da3, 0xfda5, 0x86c4, 0x0b67, 0x7006, 0xeb6b, 0x900a, 0x1da9,
            0x66c8, 0x16ce, 0x6daf, 0xe00c, 0x9b6d, 0xc6f7, 0xbd96, 0x3035, 0x4b54, 0x3b52, 0x4033,
            0xcd90, 0xb6f1, 0x2d9c, 0x56fd, 0xdb5e, 0xa03f, 0xd039, 0xab58, 0x26fb, 0x5d9a, 0x9dcf,
            0xe6ae, 0x6b0d, 0x106c, 0x606a, 0x1b0b, 0x96a8, 0xedc9, 0x76a4, 0x0dc5, 0x8066, 0xfb07,
            0x8b01, 0xf060, 0x7dc3, 0x06a2, 0x5b38, 0x2059, 0xadfa, 0xd69b, 0xa69d, 0xddfc, 0x505f,
            0x2b3e, 0xb053, 0xcb32, 0x4691, 0x3df0, 0x4df6, 0x3697, 0xbb34, 0xc055, 0x2bbf, 0x50de,
            0xdd7d, 0xa61c, 0xd61a, 0xad7b, 0x20d8, 0x5bb9, 0xc0d4, 0xbbb5, 0x3616, 0x4d77, 0x3d71,
            0x4610, 0xcbb3, 0xb0d2, 0xed48, 0x9629, 0x1b8a, 0x60eb, 0x10ed, 0x6b8c, 0xe62f, 0x9d4e,
            0x0623, 0x7d42, 0xf0e1, 0x8b80, 0xfb86, 0x80e7, 0x0d44, 0x7625, 0xb670, 0xcd11, 0x40b2,
            0x3bd3, 0x4bd5, 0x30b4, 0xbd17, 0xc676, 0x5d1b, 0x267a, 0xabd9, 0xd0b8, 0xa0be, 0xdbdf,
            0x567c, 0x2d1d, 0x7087, 0x0be6, 0x8645, 0xfd24, 0x8d22, 0xf643, 0x7be0, 0x0081, 0x9bec,
            0xe08d, 0x6d2e, 0x164f, 0x6649, 0x1d28, 0x908b, 0xebea, 0x577e, 0x2c1f, 0xa1bc, 0xdadd,
            0xaadb, 0xd1ba, 0x5c19, 0x2778, 0xbc15, 0xc774, 0x4ad7, 0x31b6, 0x41b0, 0x3ad1, 0xb772,
            0xcc13, 0x9189, 0xeae8, 0x674b, 0x1c2a, 0x6c2c, 0x174d, 0x9aee, 0xe18f, 0x7ae2, 0x0183,
            0x8c20, 0xf741, 0x8747, 0xfc26, 0x7185, 0x0ae4, 0xcab1, 0xb1d0, 0x3c73, 0x4712, 0x3714,
            0x4c75, 0xc1d6, 0xbab7, 0x21da, 0x5abb, 0xd718, 0xac79, 0xdc7f, 0xa71e, 0x2abd, 0x51dc,
            0x0c46, 0x7727, 0xfa84, 0x81e5, 0xf1e3, 0x8a82, 0x0721, 0x7c40, 0xe72d, 0x9c4c, 0x11ef,
            0x6a8e, 0x1a88, 0x61e9, 0xec4a, 0x972b, 0x7cc1, 0x07a0, 0x8a03, 0xf162, 0x8164, 0xfa05,
            0x77a6, 0x0cc7, 0x97aa, 0xeccb, 0x6168, 0x1a09, 0x6a0f, 0x116e, 0x9ccd, 0xe7ac, 0xba36,
            0xc157, 0x4cf4, 0x3795, 0x4793, 0x3cf2, 0xb151, 0xca30, 0x515d, 0x2a3c, 0xa79f, 0xdcfe,
            0xacf8, 0xd799, 0x5a3a, 0x215b, 0xe10e, 0x9a6f, 0x17cc, 0x6cad, 0x1cab, 0x67ca, 0xea69,
            0x9108, 0x0a65, 0x7104, 0xfca7, 0x87c6, 0xf7c0, 0x8ca1, 0x0102, 0x7a63, 0x27f9, 0x5c98,
            0xd13b, 0xaa5a, 0xda5c, 0xa13d, 0x2c9e, 0x57ff, 0xcc92, 0xb7f3, 0x3a50, 0x4131, 0x3137,
            0x4a56, 0xc7f5, 0xbc94,
        ],
        [
            0x0000, 0xaefc, 0x4dd9, 0xe325, 0x9bb2, 0x354e, 0xd66b, 0x7897, 0x2745, 0x89b9, 0x6a9c,
            0xc460, 0xbcf7, 0x120b, 0xf12e, 0x5fd2, 0x4e8a, 0xe076, 0x0353, 0xadaf, 0xd538, 0x7bc4,
            0x98e1, 0x361d, 0x69cf, 0xc733, 0x2416, 0x8aea, 0xf27d, 0x5c81, 0xbfa4, 0x1158, 0x9d14,
            0x33e8, 0xd0cd, 0x7e31, 0x06a6, 0xa85a, 0x4b7f, 0xe583, 0xba51, 0x14ad, 0xf788, 0x5974,
            0x21e3, 0x8f1f, 0x6c3a, 0xc2c6, 0xd39e, 0x7d62, 0x9e47, 0x30bb, 0x482c, 0xe6d0, 0x05f5,
            0xab09, 0xf4db, 0x5a27, 0xb902, 0x17fe, 0x6f69, 0xc195, 0x22b0, 0x8c4c, 0x2a09, 0x84f5,
            0x67d0, 0xc92c, 0xb1bb, 0x1f47, 0xfc62, 0x529e, 0x0d4c, 0xa3b0, 0x4095, 0xee69, 0x96fe,
            0x3802, 0xdb27, 0x75db, 0x6483, 0xca7f, 0x295a, 0x87a6, 0xff31, 0x51cd, 0xb2e8, 0x1c14,
            0x43c6, 0xed3a, 0x0e1f, 0xa0e3, 0xd874, 0x7688, 0x95ad, 0x3b51, 0xb71d, 0x19e1, 0xfac4,
            0x5438, 0x2caf, 0x8253, 0x6176, 0xcf8a, 0x9058, 0x3ea4, 0xdd81, 0x737d, 0x0bea, 0xa516,
            0x4633, 0xe8cf, 0xf997, 0x576b, 0xb44e, 0x1ab2, 0x6225, 0xccd9, 0x2ffc, 0x8100, 0xded2,
            0x702e, 0x930b, 0x3df7, 0x4560, 0xeb9c, 0x08b9, 0xa645, 0x5412, 0xfaee, 0x19cb, 0xb737,
            0xcfa0, 0x615c, 0x8279, 0x2c85, 0x7357, 0xddab, 0x3e8e, 0x9072, 0xe8e5, 0x4619, 0xa53c,
            0x0bc0, 0x1a98, 0xb464, 0x5741, 0xf9bd, 0x812a, 0x2fd6, 0xccf3, 0x620f, 0x3ddd, 0x9321,
            0x7004, 0xdef8, 0xa66f, 0x0893, 0xebb6, 0x454a, 0xc906, 0x67fa, 0x84df, 0x2a23, 0x52b4,
            0xfc48, 0x1f6d, 0xb191, 0xee43, 0x40bf, 0xa39a, 0x0d66, 0x75f1, 0xdb0d, 0x3828, 0x96d4,
            0x878c, 0x2970, 0xca55, 0x64a9, 0x1c3e, 0xb2c2, 0x51e7, 0xff1b, 0xa0c9, 0x0e35, 0xed10,
            0x43ec, 0x3b7b, 0x9587, 0x76a2, 0xd85e, 0x7e1b, 0xd0e7, 0x33c2, 0x9d3e, 0xe5a9, 0x4b55,
            0xa870, 0x068c, 0x595e, 0xf7a2, 0x1487, 0xba7b, 0xc2ec, 0x6c10, 0x8f35, 0x21c9, 0x3091,
            0x9e6d, 0x7d48, 0xd3b4, 0xab23, 0x05df, 0xe6fa, 0x4806, 0x17d4, 0xb928, 0x5a0d, 0xf4f1,
            0x8c66, 0x229a, 0xc1bf, 0x6f43, 0xe30f, 0x4df3, 0xaed6, 0x002a, 0x78bd, 0xd641, 0x3564,
            0x9b98, 0xc44a, 0x6ab6, 0x8993, 0x276f, 0x5ff8, 0xf104, 0x1221, 0xbcdd, 0xad85, 0x0379,
            0xe05c, 0x4ea0, 0x3637, 0x98cb, 0x7bee, 0xd512, 0x8ac0, 0x243c, 0xc719, 0x69e5, 0x1172,
            0xbf8e, 0x5cab, 0xf257,
        ],
        [
            0x0000, 0xa824, 0x4069, 0xe84d, 0x80d2, 0x28f6, 0xc0bb, 0x689f, 0x1185, 0xb9a1, 0x51ec,
            0xf9c8, 0x9157, 0x3973, 0xd13e, 0x791a, 0x230a, 0x8b2e, 0x6363, 0xcb47, 0xa3d8, 0x0bfc,
            0xe3b1, 0x4b95, 0x328f, 0x9aab, 0x72e6, 0xdac2, 0xb25d, 0x1a79, 0xf234, 0x5a10, 0x4614,
            0xee30, 0x067d, 0xae59, 0xc6c6, 0x6ee2, 0x86af, 0x2e8b, 0x5791, 0xffb5, 0x17f8, 0xbfdc,
            0xd743, 0x7f67, 0x972a, 0x3f0e, 0x651e, 0xcd3a, 0x2577, 0x8d53, 0xe5cc, 0x4de8, 0xa5a5,
            0x0d81, 0x749b, 0xdcbf, 0x34f2, 0x9cd6, 0xf449, 0x5c6d, 0xb420, 0x1c04, 0x8c28, 0x240c,
            0xcc41, 0x6465, 0x0cfa, 0xa4de, 0x4c93, 0xe4b7, 0x9dad, 0x3589, 0xddc4, 0x75e0, 0x1d7f,
            0xb55b, 0x5d16, 0xf532, 0xaf22, 0x0706, 0xef4b, 0x476f, 0x2ff0, 0x87d4, 0x6f99, 0xc7bd,
            0xbea7, 0x1683, 0xfece, 0x56ea, 0x3e75, 0x9651, 0x7e1c, 0xd638, 0xca3c, 0x6218, 0x8a55,
            0x2271, 0x4aee, 0xe2ca, 0x0a87, 0xa2a3, 0xdbb9, 0x739d, 0x9bd0, 0x33f4, 0x5b6b, 0xf34f,
            0x1b02, 0xb326, 0xe936, 0x4112, 0xa95f, 0x017b, 0x69e4, 0xc1c0, 0x298d, 0x81a9, 0xf8b3,
            0x5097, 0xb8da, 0x10fe, 0x7861, 0xd045, 0x3808, 0x902c, 0x0871, 0xa055, 0x4818, 0xe03c,
            0x88a3, 0x2087, 0xc8ca, 0x60ee, 0x19f4, 0xb1d0, 0x599d, 0xf1b9, 0x9926, 0x3102, 0xd94f,
            0x716b, 0x2b7b, 0x835f, 0x6b12, 0xc336, 0xaba9, 0x038d, 0xebc0, 0x43e4, 0x3afe, 0x92da,
            0x7a97, 0xd2b3, 0xba2c, 0x1208, 0xfa45, 0x5261, 0x4e65, 0xe641, 0x0e0c, 0xa628, 0xceb7,
            0x6693, 0x8ede, 0x26fa, 0x5fe0, 0xf7c4, 0x1f89, 0xb7ad, 0xdf32, 0x7716, 0x9f5b, 0x377f,
            0x6d6f, 0xc54b, 0x2d06, 0x8522, 0xedbd, 0x4599, 0xadd4, 0x05f0, 0x7cea, 0xd4ce, 0x3c83,
            0x94a7, 0xfc38, 0x541c, 0xbc51, 0x1475, 0x8459, 0x2c7d, 0xc430, 0x6c14, 0x048b, 0xacaf,
            0x44e2, 0xecc6, 0x95dc, 0x3df8, 0xd5b5, 0x7d91, 0x150e, 0xbd2a, 0x5567, 0xfd43, 0xa753,
            0x0f77, 0xe73a, 0x4f1e, 0x2781, 0x8fa5, 0x67e8, 0xcfcc, 0xb6d6, 0x1ef2, 0xf6bf, 0x5e9b,
            0x3604, 0x9e20, 0x766d, 0xde49, 0xc24d, 0x6a69, 0x8224, 0x2a00, 0x429f, 0xeabb, 0x02f6,
            0xaad2, 0xd3c8, 0x7bec, 0x93a1, 0x3b85, 0x531a, 0xfb3e, 0x1373, 0xbb57, 0xe147, 0x4963,
            0xa12e, 0x090a, 0x6195, 0xc9b1, 0x21fc, 0x89d8, 0xf0c2, 0x58e6, 0xb0ab, 0x188f, 0x7010,
            0xd834, 0x3079, 0x985d,
        ],
    ];

    pub static CRC16_IBM_3740_TABLE: [[u16; 256]; 16] = [
        [
            0x0000, 0x1021, 0x2042, 0x3063, 0x4084, 0x50a5, 0x60c6, 0x70e7, 0x8108, 0x9129, 0xa14a,
            0xb16b, 0xc18c, 0xd1ad, 0xe1ce, 0xf1ef, 0x1231, 0x0210, 0x3273, 0x2252, 0x52b5, 0x4294,
            0x72f7, 0x62d6, 0x9339, 0x8318, 0xb37b, 0xa35a, 0xd3bd, 0xc39c, 0xf3ff, 0xe3de, 0x2462,
            0x3443, 0x0420, 0x1401, 0x64e6, 0x74c7, 0x44a4, 0x5485, 0xa56a, 0xb54b, 0x8528, 0x9509,
            0xe5ee, 0xf5cf, 0xc5ac, 0xd58d, 0x3653, 0x2672, 0x1611, 0x0630, 0x76d7, 0x66f6, 0x5695,
            0x46b4, 0xb75b, 0xa77a, 0x9719, 0x8738, 0xf7df, 0xe7fe, 0xd79d, 0xc7bc, 0x48c4, 0x58e5,
            0x6886, 0x78a7, 0x0840, 0x1861, 0x2802, 0x3823, 0xc9cc, 0xd9ed, 0xe98e, 0xf9af, 0x8948,
            0x9969, 0xa90a, 0xb92b, 0x5af5, 0x4ad4, 0x7ab7, 0x6a96, 0x1a71, 0x0a50, 0x3a33, 0x2a12,
            0xdbfd, 0xcbdc, 0xfbbf, 0xeb9e, 0x9b79, 0x8b58, 0xbb3b, 0xab1a, 0x6ca6, 0x7c87, 0x4ce4,
            0x5cc5, 0x2c22, 0x3c03, 0x0c60, 0x1c41, 0xedae, 0xfd8f, 0xcdec, 0xddcd, 0xad2a, 0xbd0b,
            0x8d68, 0x9d49, 0x7e97, 0x6eb6, 0x5ed5, 0x4ef4, 0x3e13, 0x2e32, 0x1e51, 0x0e70, 0xff9f,
            0xefbe, 0xdfdd, 0xcffc, 0xbf1b, 0xaf3a, 0x9f59, 0x8f78, 0x9188, 0x81a9, 0xb1ca, 0xa1eb,
            0xd10c, 0xc12d, 0xf14e, 0xe16f, 0x1080, 0x00a1, 0x30c2, 0x20e3, 0x5004, 0x4025, 0x7046,
            0x6067, 0x83b9, 0x9398, 0xa3fb, 0xb3da, 0xc33d, 0xd31c, 0xe37f, 0xf35e, 0x02b1, 0x1290,
            0x22f3, 0x32d2, 0x4235, 0x5214, 0x6277, 0x7256, 0xb5ea, 0xa5cb, 0x95a8, 0x8589, 0xf56e,
            0xe54f, 0xd52c, 0xc50d, 0x34e2, 0x24c3, 0x14a0, 0x0481, 0x7466, 0x6447, 0x5424, 0x4405,
            0xa7db, 0xb7fa, 0x8799, 0x97b8, 0xe75f, 0xf77e, 0xc71d, 0xd73c, 0x26d3, 0x36f2, 0x0691,
            0x16b0, 0x6657, 0x7676, 0x4615, 0x5634, 0xd94c, 0xc96d, 0xf90e, 0xe92f, 0x99c8, 0x89e9,
            0xb98a, 0xa9ab, 0x5844, 0x4865, 0x7806, 0x6827, 0x18c0, 0x08e1, 0x3882, 0x28a3, 0xcb7d,
            0xdb5c, 0xeb3f, 0xfb1e, 0x8bf9, 0x9bd8, 0xabbb, 0xbb9a, 0x4a75, 0x5a54, 0x6a37, 0x7a16,
            0x0af1, 0x1ad0, 0x2ab3, 0x3a92, 0xfd2e, 0xed0f, 0xdd6c, 0xcd4d, 0xbdaa, 0xad8b, 0x9de8,
            0x8dc9, 0x7c26, 0x6c07, 0x5c64, 0x4c45, 0x3ca2, 0x2c83, 0x1ce0, 0x0cc1, 0xef1f, 0xff3e,
            0xcf5d, 0xdf7c, 0xaf9b, 0xbfba, 0x8fd9, 0x9ff8, 0x6e17, 0x7e36, 0x4e55, 0x5e74, 0x2e93,
            0x3eb2, 0x0ed1, 0x1ef0,
        ],
        [
            0x0000, 0x3331, 0x6662, 0x5553, 0xccc4, 0xfff5, 0xaaa6, 0x9997, 0x89a9, 0xba98, 0xefcb,
            0xdcfa, 0x456d, 0x765c, 0x230f, 0x103e, 0x0373, 0x3042, 0x6511, 0x5620, 0xcfb7, 0xfc86,
            0xa9d5, 0x9ae4, 0x8ada, 0xb9eb, 0xecb8, 0xdf89, 0x461e, 0x752f, 0x207c, 0x134d, 0x06e6,
            0x35d7, 0x6084, 0x53b5, 0xca22, 0xf913, 0xac40, 0x9f71, 0x8f4f, 0xbc7e, 0xe92d, 0xda1c,
            0x438b, 0x70ba, 0x25e9, 0x16d8, 0x0595, 0x36a4, 0x63f7, 0x50c6, 0xc951, 0xfa60, 0xaf33,
            0x9c02, 0x8c3c, 0xbf0d, 0xea5e, 0xd96f, 0x40f8, 0x73c9, 0x269a, 0x15ab, 0x0dcc, 0x3efd,
            0x6bae, 0x589f, 0xc108, 0xf239, 0xa76a, 0x945b, 0x8465, 0xb754, 0xe207, 0xd136, 0x48a1,
            0x7b90, 0x2ec3, 0x1df2, 0x0ebf, 0x3d8e, 0x68dd, 0x5bec, 0xc27b, 0xf14a, 0xa419, 0x9728,
            0x8716, 0xb427, 0xe174, 0xd245, 0x4bd2, 0x78e3, 0x2db0, 0x1e81, 0x0b2a, 0x381b, 0x6d48,
            0x5e79, 0xc7ee, 0xf4df, 0xa18c, 0x92bd, 0x8283, 0xb1b2, 0xe4e1, 0xd7d0, 0x4e47, 0x7d76,
            0x2825, 0x1b14, 0x0859, 0x3b68, 0x6e3b, 0x5d0a, 0xc49d, 0xf7ac, 0xa2ff, 0x91ce, 0x81f0,
            0xb2c1, 0xe792, 0xd4a3, 0x4d34, 0x7e05, 0x2b56, 0x1867, 0x1b98, 0x28a9, 0x7dfa, 0x4ecb,
            0xd75c, 0xe46d, 0xb13e, 0x820f, 0x9231, 0xa100, 0xf453, 0xc762, 0x5ef5, 0x6dc4, 0x3897,
            0x0ba6, 0x18eb, 0x2bda, 0x7e89, 0x4db8, 0xd42f, 0xe71e, 0xb24d, 0x817c, 0x9142, 0xa273,
            0xf720, 0xc411, 0x5d86, 0x6eb7, 0x3be4, 0x08d5, 0x1d7e, 0x2e4f, 0x7b1c, 0x482d, 0xd1ba,
            0xe28b, 0xb7d8, 0x84e9, 0x94d7, 0xa7e6, 0xf2b5, 0xc184, 0x5813, 0x6b22, 0x3e71, 0x0d40,
            0x1e0d, 0x2d3c, 0x786f, 0x4b5e, 0xd2c9, 0xe1f8, 0xb4ab, 0x879a, 0x97a4, 0xa495, 0xf1c6,
            0xc2f7, 0x5b60, 0x6851, 0x3d02, 0x0e33, 0x1654, 0x2565, 0x7036, 0x4307, 0xda90, 0xe9a1,
            0xbcf2, 0x8fc3, 0x9ffd, 0xaccc, 0xf99f, 0xcaae, 0x5339, 0x6008, 0x355b, 0x066a, 0x1527,
            0x2616, 0x7345, 0x4074, 0xd9e3, 0xead2, 0xbf81, 0x8cb0, 0x9c8e, 0xafbf, 0xfaec, 0xc9dd,
            0x504a, 0x637b, 0x3628, 0x0519, 0x10b2, 0x2383, 0x76d0, 0x45e1, 0xdc76, 0xef47, 0xba14,
            0x8925, 0x991b, 0xaa2a, 0xff79, 0xcc48, 0x55df, 0x66ee, 0x33bd, 0x008c, 0x13c1, 0x20f0,
            0x75a3, 0x4692, 0xdf05, 0xec34, 0xb967, 0x8a56, 0x9a68, 0xa959, 0xfc0a, 0xcf3b, 0x56ac,
            0x659d, 0x30ce, 0x03ff,
        ],
        [
            0x0000, 0x3730, 0x6e60, 0x5950, 0xdcc0, 0xebf0, 0xb2a0, 0x8590, 0xa9a1, 0x9e91, 0xc7c1,
            0xf0f1, 0x7561, 0x4251, 0x1b01, 0x2c31, 0x4363, 0x7453, 0x2d03, 0x1a33, 0x9fa3, 0xa893,
            0xf1c3, 0xc6f3, 0xeac2, 0xddf2, 0x84a2, 0xb392, 0x3602, 0x0132, 0x5862, 0x6f52, 0x86c6,
            0xb1f6, 0xe8a6, 0xdf96, 0x5a06, 0x6d36, 0x3466, 0x0356, 0x2f67, 0x1857, 0x4107, 0x7637,
            0xf3a7, 0xc497, 0x9dc7, 0xaaf7, 0xc5a5, 0xf295, 0xabc5, 0x9cf5, 0x1965, 0x2e55, 0x7705,
            0x4035, 0x6c04, 0x5b34, 0x0264, 0x3554, 0xb0c4, 0x87f4, 0xdea4, 0xe994, 0x1dad, 0x2a9d,
            0x73cd, 0x44fd, 0xc16d, 0xf65d, 0xaf0d, 0x983d, 0xb40c, 0x833c, 0xda6c, 0xed5c, 0x68cc,
            0x5ffc, 0x06ac, 0x319c, 0x5ece, 0x69fe, 0x30ae, 0x079e, 0x820e, 0xb53e, 0xec6e, 0xdb5e,
            0xf76f, 0xc05f, 0x990f, 0xae3f, 0x2baf, 0x1c9f, 0x45cf, 0x72ff, 0x9b6b, 0xac5b, 0xf50b,
            0xc23b, 0x47ab, 0x709b, 0x29cb, 0x1efb, 0x32ca, 0x05fa, 0x5caa, 0x6b9a, 0xee0a, 0xd93a,
            0x806a, 0xb75a, 0xd808, 0xef38, 0xb668, 0x8158, 0x04c8, 0x33f8, 0x6aa8, 0x5d98, 0x71a9,
            0x4699, 0x1fc9, 0x28f9, 0xad69, 0x9a59, 0xc309, 0xf439, 0x3b5a, 0x0c6a, 0x553a, 0x620a,
            0xe79a, 0xd0aa, 0x89fa, 0xbeca, 0x92fb, 0xa5cb, 0xfc9b, 0xcbab, 0x4e3b, 0x790b, 0x205b,
            0x176b, 0x7839, 0x4f09, 0x1659, 0x2169, 0xa4f9, 0x93c9, 0xca99, 0xfda9, 0xd198, 0xe6a8,
            0xbff8, 0x88c8, 0x0d58, 0x3a68, 0x6338, 0x5408, 0xbd9c, 0x8aac, 0xd3fc, 0xe4cc, 0x615c,
            0x566c, 0x0f3c, 0x380c, 0x143d, 0x230d, 0x7a5d, 0x4d6d, 0xc8fd, 0xffcd, 0xa69d, 0x91ad,
            0xfeff, 0xc9cf, 0x909f, 0xa7af, 0x223f, 0x150f, 0x4c5f, 0x7b6f, 0x575e, 0x606e, 0x393e,
            0x0e0e, 0x8b9e, 0xbcae, 0xe5fe, 0xd2ce, 0x26f7, 0x11c7, 0x4897, 0x7fa7, 0xfa37, 0xcd07,
            0x9457, 0xa367, 0x8f56, 0xb866, 0xe136, 0xd606, 0x5396, 0x64a6, 0x3df6, 0x0ac6, 0x6594,
            0x52a4, 0x0bf4, 0x3cc4, 0xb954, 0x8e64, 0xd734, 0xe004, 0xcc35, 0xfb05, 0xa255, 0x9565,
            0x10f5, 0x27c5, 0x7e95, 0x49a5, 0xa031, 0x9701, 0xce51, 0xf961, 0x7cf1, 0x4bc1, 0x1291,
            0x25a1, 0x0990, 0x3ea0, 0x67f0, 0x50c0, 0xd550, 0xe260, 0xbb30, 0x8c00, 0xe352, 0xd462,
            0x8d32, 0xba02, 0x3f92, 0x08a2, 0x51f2, 0x66c2, 0x4af3, 0x7dc3, 0x2493, 0x13a3, 0x9633,
            0xa103, 0xf853, 0xcf63,
        ],
        [
            0x0000, 0x76b4, 0xed68, 0x9bdc, 0xcaf1, 0xbc45, 0x2799, 0x512d, 0x85c3, 0xf377, 0x68ab,
            0x1e1f, 0x4f32, 0x3986, 0xa25a, 0xd4ee, 0x1ba7, 0x6d13, 0xf6cf, 0x807b, 0xd156, 0xa7e2,
            0x3c3e, 0x4a8a, 0x9e64, 0xe8d0, 0x730c, 0x05b8, 0x5495, 0x2221, 0xb9fd, 0xcf49, 0x374e,
            0x41fa, 0xda26, 0xac92, 0xfdbf, 0x8b0b, 0x10d7, 0x6663, 0xb28d, 0xc439, 0x5fe5, 0x2951,
            0x787c, 0x0ec8, 0x9514, 0xe3a0, 0x2ce9, 0x5a5d, 0xc181, 0xb735, 0xe618, 0x90ac, 0x0b70,
            0x7dc4, 0xa92a, 0xdf9e, 0x4442, 0x32f6, 0x63db, 0x156f, 0x8eb3, 0xf807, 0x6e9c, 0x1828,
            0x83f4, 0xf540, 0xa46d, 0xd2d9, 0x4905, 0x3fb1, 0xeb5f, 0x9deb, 0x0637, 0x7083, 0x21ae,
            0x571a, 0xccc6, 0xba72, 0x753b, 0x038f, 0x9853, 0xeee7, 0xbfca, 0xc97e, 0x52a2, 0x2416,
            0xf0f8, 0x864c, 0x1d90, 0x6b24, 0x3a09, 0x4cbd, 0xd761, 0xa1d5, 0x59d2, 0x2f66, 0xb4ba,
            0xc20e, 0x9323, 0xe597, 0x7e4b, 0x08ff, 0xdc11, 0xaaa5, 0x3179, 0x47cd, 0x16e0, 0x6054,
            0xfb88, 0x8d3c, 0x4275, 0x34c1, 0xaf1d, 0xd9a9, 0x8884, 0xfe30, 0x65ec, 0x1358, 0xc7b6,
            0xb102, 0x2ade, 0x5c6a, 0x0d47, 0x7bf3, 0xe02f, 0x969b, 0xdd38, 0xab8c, 0x3050, 0x46e4,
            0x17c9, 0x617d, 0xfaa1, 0x8c15, 0x58fb, 0x2e4f, 0xb593, 0xc327, 0x920a, 0xe4be, 0x7f62,
            0x09d6, 0xc69f, 0xb02b, 0x2bf7, 0x5d43, 0x0c6e, 0x7ada, 0xe106, 0x97b2, 0x435c, 0x35e8,
            0xae34, 0xd880, 0x89ad, 0xff19, 0x64c5, 0x1271, 0xea76, 0x9cc2, 0x071e, 0x71aa, 0x2087,
            0x5633, 0xcdef, 0xbb5b, 0x6fb5, 0x1901, 0x82dd, 0xf469, 0xa544, 0xd3f0, 0x482c, 0x3e98,
            0xf1d1, 0x8765, 0x1cb9, 0x6a0d, 0x3b20, 0x4d94, 0xd648, 0xa0fc, 0x7412, 0x02a6, 0x997a,
            0xefce, 0xbee3, 0xc857, 0x538b, 0x253f, 0xb3a4, 0xc510, 0x5ecc, 0x2878, 0x7955, 0x0fe1,
            0x943d, 0xe289, 0x3667, 0x40d3, 0xdb0f, 0xadbb, 0xfc96, 0x8a22, 0x11fe, 0x674a, 0xa803,
            0xdeb7, 0x456b, 0x33df, 0x62f2, 0x1446, 0x8f9a, 0xf92e, 0x2dc0, 0x5b74, 0xc0a8, 0xb61c,
            0xe731, 0x9185, 0x0a59, 0x7ced, 0x84ea, 0xf25e, 0x6982, 0x1f36, 0x4e1b, 0x38af, 0xa373,
            0xd5c7, 0x0129, 0x779d, 0xec41, 0x9af5, 0xcbd8, 0xbd6c, 0x26b0, 0x5004, 0x9f4d, 0xe9f9,
            0x7225, 0x0491, 0x55bc, 0x2308, 0xb8d4, 0xce60, 0x1a8e, 0x6c3a, 0xf7e6, 0x8152, 0xd07f,
            0xa6cb, 0x3d17, 0x4ba3,
        ],
        [
            0x0000, 0xaa51, 0x4483, 0xeed2, 0x8906, 0x2357, 0xcd85, 0x67d4, 0x022d, 0xa87c, 0x46ae,
            0xecff, 0x8b2b, 0x217a, 0xcfa8, 0x65f9, 0x045a, 0xae0b, 0x40d9, 0xea88, 0x8d5c, 0x270d,
            0xc9df, 0x638e, 0x0677, 0xac26, 0x42f4, 0xe8a5, 0x8f71, 0x2520, 0xcbf2, 0x61a3, 0x08b4,
            0xa2e5, 0x4c37, 0xe666, 0x81b2, 0x2be3, 0xc531, 0x6f60, 0x0a99, 0xa0c8, 0x4e1a, 0xe44b,
            0x839f, 0x29ce, 0xc71c, 0x6d4d, 0x0cee, 0xa6bf, 0x486d, 0xe23c, 0x85e8, 0x2fb9, 0xc16b,
            0x6b3a, 0x0ec3, 0xa492, 0x4a40, 0xe011, 0x87c5, 0x2d94, 0xc346, 0x6917, 0x1168, 0xbb39,
            0x55eb, 0xffba, 0x986e, 0x323f, 0xdced, 0x76bc, 0x1345, 0xb914, 0x57c6, 0xfd97, 0x9a43,
            0x3012, 0xdec0, 0x7491, 0x1532, 0xbf63, 0x51b1, 0xfbe0, 0x9c34, 0x3665, 0xd8b7, 0x72e6,
            0x171f, 0xbd4e, 0x539c, 0xf9cd, 0x9e19, 0x3448, 0xda9a, 0x70cb, 0x19dc, 0xb38d, 0x5d5f,
            0xf70e, 0x90da, 0x3a8b, 0xd459, 0x7e08, 0x1bf1, 0xb1a0, 0x5f72, 0xf523, 0x92f7, 0x38a6,
            0xd674, 0x7c25, 0x1d86, 0xb7d7, 0x5905, 0xf354, 0x9480, 0x3ed1, 0xd003, 0x7a52, 0x1fab,
            0xb5fa, 0x5b28, 0xf179, 0x96ad, 0x3cfc, 0xd22e, 0x787f, 0x22d0, 0x8881, 0x6653, 0xcc02,
            0xabd6, 0x0187, 0xef55, 0x4504, 0x20fd, 0x8aac, 0x647e, 0xce2f, 0xa9fb, 0x03aa, 0xed78,
            0x4729, 0x268a, 0x8cdb, 0x6209, 0xc858, 0xaf8c, 0x05dd, 0xeb0f, 0x415e, 0x24a7, 0x8ef6,
            0x6024, 0xca75, 0xada1, 0x07f0, 0xe922, 0x4373, 0x2a64, 0x8035, 0x6ee7, 0xc4b6, 0xa362,
            0x0933, 0xe7e1, 0x4db0, 0x2849, 0x8218, 0x6cca, 0xc69b, 0xa14f, 0x0b1e, 0xe5cc, 0x4f9d,
            0x2e3e, 0x846f, 0x6abd, 0xc0ec, 0xa738, 0x0d69, 0xe3bb, 0x49ea, 0x2c13, 0x8642, 0x6890,
            0xc2c1, 0xa515, 0x0f44, 0xe196, 0x4bc7, 0x33b8, 0x99e9, 0x773b, 0xdd6a, 0xbabe, 0x10ef,
            0xfe3d, 0x546c, 0x3195, 0x9bc4, 0x7516, 0xdf47, 0xb893, 0x12c2, 0xfc10, 0x5641, 0x37e2,
            0x9db3, 0x7361, 0xd930, 0xbee4, 0x14b5, 0xfa67, 0x5036, 0x35cf, 0x9f9e, 0x714c, 0xdb1d,
            0xbcc9, 0x1698, 0xf84a, 0x521b, 0x3b0c, 0x915d, 0x7f8f, 0xd5de, 0xb20a, 0x185b, 0xf689,
            0x5cd8, 0x3921, 0x9370, 0x7da2, 0xd7f3, 0xb027, 0x1a76, 0xf4a4, 0x5ef5, 0x3f56, 0x9507,
            0x7bd5, 0xd184, 0xb650, 0x1c01, 0xf2d3, 0x5882, 0x3d7b, 0x972a, 0x79f8, 0xd3a9, 0xb47d,
            0x1e2c, 0xf0fe, 0x5aaf,
        ],
        [
            0x0000, 0x45a0, 0x8b40, 0xcee0, 0x06a1, 0x4301, 0x8de1, 0xc841, 0x0d42, 0x48e2, 0x8602,
            0xc3a2, 0x0be3, 0x4e43, 0x80a3, 0xc503, 0x1a84, 0x5f24, 0x91c4, 0xd464, 0x1c25, 0x5985,
            0x9765, 0xd2c5, 0x17c6, 0x5266, 0x9c86, 0xd926, 0x1167, 0x54c7, 0x9a27, 0xdf87, 0x3508,
            0x70a8, 0xbe48, 0xfbe8, 0x33a9, 0x7609, 0xb8e9, 0xfd49, 0x384a, 0x7dea, 0xb30a, 0xf6aa,
            0x3eeb, 0x7b4b, 0xb5ab, 0xf00b, 0x2f8c, 0x6a2c, 0xa4cc, 0xe16c, 0x292d, 0x6c8d, 0xa26d,
            0xe7cd, 0x22ce, 0x676e, 0xa98e, 0xec2e, 0x246f, 0x61cf, 0xaf2f, 0xea8f, 0x6a10, 0x2fb0,
            0xe150, 0xa4f0, 0x6cb1, 0x2911, 0xe7f1, 0xa251, 0x6752, 0x22f2, 0xec12, 0xa9b2, 0x61f3,
            0x2453, 0xeab3, 0xaf13, 0x7094, 0x3534, 0xfbd4, 0xbe74, 0x7635, 0x3395, 0xfd75, 0xb8d5,
            0x7dd6, 0x3876, 0xf696, 0xb336, 0x7b77, 0x3ed7, 0xf037, 0xb597, 0x5f18, 0x1ab8, 0xd458,
            0x91f8, 0x59b9, 0x1c19, 0xd2f9, 0x9759, 0x525a, 0x17fa, 0xd91a, 0x9cba, 0x54fb, 0x115b,
            0xdfbb, 0x9a1b, 0x459c, 0x003c, 0xcedc, 0x8b7c, 0x433d, 0x069d, 0xc87d, 0x8ddd, 0x48de,
            0x0d7e, 0xc39e, 0x863e, 0x4e7f, 0x0bdf, 0xc53f, 0x809f, 0xd420, 0x9180, 0x5f60, 0x1ac0,
            0xd281, 0x9721, 0x59c1, 0x1c61, 0xd962, 0x9cc2, 0x5222, 0x1782, 0xdfc3, 0x9a63, 0x5483,
            0x1123, 0xcea4, 0x8b04, 0x45e4, 0x0044, 0xc805, 0x8da5, 0x4345, 0x06e5, 0xc3e6, 0x8646,
            0x48a6, 0x0d06, 0xc547, 0x80e7, 0x4e07, 0x0ba7, 0xe128, 0xa488, 0x6a68, 0x2fc8, 0xe789,
            0xa229, 0x6cc9, 0x2969, 0xec6a, 0xa9ca, 0x672a, 0x228a, 0xeacb, 0xaf6b, 0x618b, 0x242b,
            0xfbac, 0xbe0c, 0x70ec, 0x354c, 0xfd0d, 0xb8ad, 0x764d, 0x33ed, 0xf6ee, 0xb34e, 0x7dae,
            0x380e, 0xf04f, 0xb5ef, 0x7b0f, 0x3eaf, 0xbe30, 0xfb90, 0x3570, 0x70d0, 0xb891, 0xfd31,
            0x33d1, 0x7671, 0xb372, 0xf6d2, 0x3832, 0x7d92, 0xb5d3, 0xf073, 0x3e93, 0x7b33, 0xa4b4,
            0xe114, 0x2ff4, 0x6a54, 0xa215, 0xe7b5, 0x2955, 0x6cf5, 0xa9f6, 0xec56, 0x22b6, 0x6716,
            0xaf57, 0xeaf7, 0x2417, 0x61b7, 0x8b38, 0xce98, 0x0078, 0x45d8, 0x8d99, 0xc839, 0x06d9,
            0x4379, 0x867a, 0xc3da, 0x0d3a, 0x489a, 0x80db, 0xc57b, 0x0b9b, 0x4e3b, 0x91bc, 0xd41c,
            0x1afc, 0x5f5c, 0x971d, 0xd2bd, 0x1c5d, 0x59fd, 0x9cfe, 0xd95e, 0x17be, 0x521e, 0x9a5f,
            0xdfff, 0x111f, 0x54bf,
        ],
        [
            0x0000, 0xb861, 0x60e3, 0xd882, 0xc1c6, 0x79a7, 0xa125, 0x1944, 0x93ad, 0x2bcc, 0xf34e,
            0x4b2f, 0x526b, 0xea0a, 0x3288, 0x8ae9, 0x377b, 0x8f1a, 0x5798, 0xeff9, 0xf6bd, 0x4edc,
            0x965e, 0x2e3f, 0xa4d6, 0x1cb7, 0xc435, 0x7c54, 0x6510, 0xdd71, 0x05f3, 0xbd92, 0x6ef6,
            0xd697, 0x0e15, 0xb674, 0xaf30, 0x1751, 0xcfd3, 0x77b2, 0xfd5b, 0x453a, 0x9db8, 0x25d9,
            0x3c9d, 0x84fc, 0x5c7e, 0xe41f, 0x598d, 0xe1ec, 0x396e, 0x810f, 0x984b, 0x202a, 0xf8a8,
            0x40c9, 0xca20, 0x7241, 0xaac3, 0x12a2, 0x0be6, 0xb387, 0x6b05, 0xd364, 0xddec, 0x658d,
            0xbd0f, 0x056e, 0x1c2a, 0xa44b, 0x7cc9, 0xc4a8, 0x4e41, 0xf620, 0x2ea2, 0x96c3, 0x8f87,
            0x37e6, 0xef64, 0x5705, 0xea97, 0x52f6, 0x8a74, 0x3215, 0x2b51, 0x9330, 0x4bb2, 0xf3d3,
            0x793a, 0xc15b, 0x19d9, 0xa1b8, 0xb8fc, 0x009d, 0xd81f, 0x607e, 0xb31a, 0x0b7b, 0xd3f9,
            0x6b98, 0x72dc, 0xcabd, 0x123f, 0xaa5e, 0x20b7, 0x98d6, 0x4054, 0xf835, 0xe171, 0x5910,
            0x8192, 0x39f3, 0x8461, 0x3c00, 0xe482, 0x5ce3, 0x45a7, 0xfdc6, 0x2544, 0x9d25, 0x17cc,
            0xafad, 0x772f, 0xcf4e, 0xd60a, 0x6e6b, 0xb6e9, 0x0e88, 0xabf9, 0x1398, 0xcb1a, 0x737b,
            0x6a3f, 0xd25e, 0x0adc, 0xb2bd, 0x3854, 0x8035, 0x58b7, 0xe0d6, 0xf992, 0x41f3, 0x9971,
            0x2110, 0x9c82, 0x24e3, 0xfc61, 0x4400, 0x5d44, 0xe525, 0x3da7, 0x85c6, 0x0f2f, 0xb74e,
            0x6fcc, 0xd7ad, 0xcee9, 0x7688, 0xae0a, 0x166b, 0xc50f, 0x7d6e, 0xa5ec, 0x1d8d, 0x04c9,
            0xbca8, 0x642a, 0xdc4b, 0x56a2, 0xeec3, 0x3641, 0x8e20, 0x9764, 0x2f05, 0xf787, 0x4fe6,
            0xf274, 0x4a15, 0x9297, 0x2af6, 0x33b2, 0x8bd3, 0x5351, 0xeb30, 0x61d9, 0xd9b8, 0x013a,
            0xb95b, 0xa01f, 0x187e, 0xc0fc, 0x789d, 0x7615, 0xce74, 0x16f6, 0xae97, 0xb7d3, 0x0fb2,
            0xd730, 0x6f51, 0xe5b8, 0x5dd9, 0x855b, 0x3d3a, 0x247e, 0x9c1f, 0x449d, 0xfcfc, 0x416e,
            0xf90f, 0x218d, 0x99ec, 0x80a8, 0x38c9, 0xe04b, 0x582a, 0xd2c3, 0x6aa2, 0xb220, 0x0a41,
            0x1305, 0xab64, 0x73e6, 0xcb87, 0x18e3, 0xa082, 0x7800, 0xc061, 0xd925, 0x6144, 0xb9c6,
            0x01a7, 0x8b4e, 0x332f, 0xebad, 0x53cc, 0x4a88, 0xf2e9, 0x2a6b, 0x920a, 0x2f98, 0x97f9,
            0x4f7b, 0xf71a, 0xee5e, 0x563f, 0x8ebd, 0x36dc, 0xbc35, 0x0454, 0xdcd6, 0x64b7, 0x7df3,
            0xc592, 0x1d10, 0xa571,
        ],
        [
            0x0000, 0x47d3, 0x8fa6, 0xc875, 0x0f6d, 0x48be, 0x80cb, 0xc718, 0x1eda, 0x5909, 0x917c,
            0xd6af, 0x11b7, 0x5664, 0x9e11, 0xd9c2, 0x3db4, 0x7a67, 0xb212, 0xf5c1, 0x32d9, 0x750a,
            0xbd7f, 0xfaac, 0x236e, 0x64bd, 0xacc8, 0xeb1b, 0x2c03, 0x6bd0, 0xa3a5, 0xe476, 0x7b68,
            0x3cbb, 0xf4ce, 0xb31d, 0x7405, 0x33d6, 0xfba3, 0xbc70, 0x65b2, 0x2261, 0xea14, 0xadc7,
            0x6adf, 0x2d0c, 0xe579, 0xa2aa, 0x46dc, 0x010f, 0xc97a, 0x8ea9, 0x49b1, 0x0e62, 0xc617,
            0x81c4, 0x5806, 0x1fd5, 0xd7a0, 0x9073, 0x576b, 0x10b8, 0xd8cd, 0x9f1e, 0xf6d0, 0xb103,
            0x7976, 0x3ea5, 0xf9bd, 0xbe6e, 0x761b, 0x31c8, 0xe80a, 0xafd9, 0x67ac, 0x207f, 0xe767,
            0xa0b4, 0x68c1, 0x2f12, 0xcb64, 0x8cb7, 0x44c2, 0x0311, 0xc409, 0x83da, 0x4baf, 0x0c7c,
            0xd5be, 0x926d, 0x5a18, 0x1dcb, 0xdad3, 0x9d00, 0x5575, 0x12a6, 0x8db8, 0xca6b, 0x021e,
            0x45cd, 0x82d5, 0xc506, 0x0d73, 0x4aa0, 0x9362, 0xd4b1, 0x1cc4, 0x5b17, 0x9c0f, 0xdbdc,
            0x13a9, 0x547a, 0xb00c, 0xf7df, 0x3faa, 0x7879, 0xbf61, 0xf8b2, 0x30c7, 0x7714, 0xaed6,
            0xe905, 0x2170, 0x66a3, 0xa1bb, 0xe668, 0x2e1d, 0x69ce, 0xfd81, 0xba52, 0x7227, 0x35f4,
            0xf2ec, 0xb53f, 0x7d4a, 0x3a99, 0xe35b, 0xa488, 0x6cfd, 0x2b2e, 0xec36, 0xabe5, 0x6390,
            0x2443, 0xc035, 0x87e6, 0x4f93, 0x0840, 0xcf58, 0x888b, 0x40fe, 0x072d, 0xdeef, 0x993c,
            0x5149, 0x169a, 0xd182, 0x9651, 0x5e24, 0x19f7, 0x86e9, 0xc13a, 0x094f, 0x4e9c, 0x8984,
            0xce57, 0x0622, 0x41f1, 0x9833, 0xdfe0, 0x1795, 0x5046, 0x975e, 0xd08d, 0x18f8, 0x5f2b,
            0xbb5d, 0xfc8e, 0x34fb, 0x7328, 0xb430, 0xf3e3, 0x3b96, 0x7c45, 0xa587, 0xe254, 0x2a21,
            0x6df2, 0xaaea, 0xed39, 0x254c, 0x629f, 0x0b51, 0x4c82, 0x84f7, 0xc324, 0x043c, 0x43ef,
            0x8b9a, 0xcc49, 0x158b, 0x5258, 0x9a2d, 0xddfe, 0x1ae6, 0x5d35, 0x9540, 0xd293, 0x36e5,
            0x7136, 0xb943, 0xfe90, 0x3988, 0x7e5b, 0xb62e, 0xf1fd, 0x283f, 0x6fec, 0xa799, 0xe04a,
            0x2752, 0x6081, 0xa8f4, 0xef27, 0x7039, 0x37ea, 0xff9f, 0xb84c, 0x7f54, 0x3887, 0xf0f2,
            0xb721, 0x6ee3, 0x2930, 0xe145, 0xa696, 0x618e, 0x265d, 0xee28, 0xa9fb, 0x4d8d, 0x0a5e,
            0xc22b, 0x85f8, 0x42e0, 0x0533, 0xcd46, 0x8a95, 0x5357, 0x1484, 0xdcf1, 0x9b22, 0x5c3a,
            0x1be9, 0xd39c, 0x944f,
        ],
        [
            0x0000, 0xeb23, 0xc667, 0x2d44, 0x9cef, 0x77cc, 0x5a88, 0xb1ab, 0x29ff, 0xc2dc, 0xef98,
            0x04bb, 0xb510, 0x5e33, 0x7377, 0x9854, 0x53fe, 0xb8dd, 0x9599, 0x7eba, 0xcf11, 0x2432,
            0x0976, 0xe255, 0x7a01, 0x9122, 0xbc66, 0x5745, 0xe6ee, 0x0dcd, 0x2089, 0xcbaa, 0xa7fc,
            0x4cdf, 0x619b, 0x8ab8, 0x3b13, 0xd030, 0xfd74, 0x1657, 0x8e03, 0x6520, 0x4864, 0xa347,
            0x12ec, 0xf9cf, 0xd48b, 0x3fa8, 0xf402, 0x1f21, 0x3265, 0xd946, 0x68ed, 0x83ce, 0xae8a,
            0x45a9, 0xddfd, 0x36de, 0x1b9a, 0xf0b9, 0x4112, 0xaa31, 0x8775, 0x6c56, 0x5fd9, 0xb4fa,
            0x99be, 0x729d, 0xc336, 0x2815, 0x0551, 0xee72, 0x7626, 0x9d05, 0xb041, 0x5b62, 0xeac9,
            0x01ea, 0x2cae, 0xc78d, 0x0c27, 0xe704, 0xca40, 0x2163, 0x90c8, 0x7beb, 0x56af, 0xbd8c,
            0x25d8, 0xcefb, 0xe3bf, 0x089c, 0xb937, 0x5214, 0x7f50, 0x9473, 0xf825, 0x1306, 0x3e42,
            0xd561, 0x64ca, 0x8fe9, 0xa2ad, 0x498e, 0xd1da, 0x3af9, 0x17bd, 0xfc9e, 0x4d35, 0xa616,
            0x8b52, 0x6071, 0xabdb, 0x40f8, 0x6dbc, 0x869f, 0x3734, 0xdc17, 0xf153, 0x1a70, 0x8224,
            0x6907, 0x4443, 0xaf60, 0x1ecb, 0xf5e8, 0xd8ac, 0x338f, 0xbfb2, 0x5491, 0x79d5, 0x92f6,
            0x235d, 0xc87e, 0xe53a, 0x0e19, 0x964d, 0x7d6e, 0x502a, 0xbb09, 0x0aa2, 0xe181, 0xccc5,
            0x27e6, 0xec4c, 0x076f, 0x2a2b, 0xc108, 0x70a3, 0x9b80, 0xb6c4, 0x5de7, 0xc5b3, 0x2e90,
            0x03d4, 0xe8f7, 0x595c, 0xb27f, 0x9f3b, 0x7418, 0x184e, 0xf36d, 0xde29, 0x350a, 0x84a1,
            0x6f82, 0x42c6, 0xa9e5, 0x31b1, 0xda92, 0xf7d6, 0x1cf5, 0xad5e, 0x467d, 0x6b39, 0x801a,
            0x4bb0, 0xa093, 0x8dd7, 0x66f4, 0xd75f, 0x3c7c, 0x1138, 0xfa1b, 0x624f, 0x896c, 0xa428,
            0x4f0b, 0xfea0, 0x1583, 0x38c7, 0xd3e4, 0xe06b, 0x0b48, 0x260c, 0xcd2f, 0x7c84, 0x97a7,
            0xbae3, 0x51c0, 0xc994, 0x22b7, 0x0ff3, 0xe4d0, 0x557b, 0xbe58, 0x931c, 0x783f, 0xb395,
            0x58b6, 0x75f2, 0x9ed1, 0x2f7a, 0xc459, 0xe91d, 0x023e, 0x9a6a, 0x7149, 0x5c0d, 0xb72e,
            0x0685, 0xeda6, 0xc0e2, 0x2bc1, 0x4797, 0xacb4, 0x81f0, 0x6ad3, 0xdb78, 0x305b, 0x1d1f,
            0xf63c, 0x6e68, 0x854b, 0xa80f, 0x432c, 0xf287, 0x19a4, 0x34e0, 0xdfc3, 0x1469, 0xff4a,
            0xd20e, 0x392d, 0x8886, 0x63a5, 0x4ee1, 0xa5c2, 0x3d96, 0xd6b5, 0xfbf1, 0x10d2, 0xa179,
            0x4a5a, 0x671e, 0x8c3d,
        ],
        [
            0x0000, 0x6f45, 0xde8a, 0xb1cf, 0xad35, 0xc270, 0x73bf, 0x1cfa, 0x4a4b, 0x250e, 0x94c1,
            0xfb84, 0xe77e, 0x883b, 0x39f4, 0x56b1, 0x9496, 0xfbd3, 0x4a1c, 0x2559, 0x39a3, 0x56e6,
            0xe729, 0x886c, 0xdedd, 0xb198, 0x0057, 0x6f12, 0x73e8, 0x1cad, 0xad62, 0xc227, 0x390d,
            0x5648, 0xe787, 0x88c2, 0x9438, 0xfb7d, 0x4ab2, 0x25f7, 0x7346, 0x1c03, 0xadcc, 0xc289,
            0xde73, 0xb136, 0x00f9, 0x6fbc, 0xad9b, 0xc2de, 0x7311, 0x1c54, 0x00ae, 0x6feb, 0xde24,
            0xb161, 0xe7d0, 0x8895, 0x395a, 0x561f, 0x4ae5, 0x25a0, 0x946f, 0xfb2a, 0x721a, 0x1d5f,
            0xac90, 0xc3d5, 0xdf2f, 0xb06a, 0x01a5, 0x6ee0, 0x3851, 0x5714, 0xe6db, 0x899e, 0x9564,
            0xfa21, 0x4bee, 0x24ab, 0xe68c, 0x89c9, 0x3806, 0x5743, 0x4bb9, 0x24fc, 0x9533, 0xfa76,
            0xacc7, 0xc382, 0x724d, 0x1d08, 0x01f2, 0x6eb7, 0xdf78, 0xb03d, 0x4b17, 0x2452, 0x959d,
            0xfad8, 0xe622, 0x8967, 0x38a8, 0x57ed, 0x015c, 0x6e19, 0xdfd6, 0xb093, 0xac69, 0xc32c,
            0x72e3, 0x1da6, 0xdf81, 0xb0c4, 0x010b, 0x6e4e, 0x72b4, 0x1df1, 0xac3e, 0xc37b, 0x95ca,
            0xfa8f, 0x4b40, 0x2405, 0x38ff, 0x57ba, 0xe675, 0x8930, 0xe434, 0x8b71, 0x3abe, 0x55fb,
            0x4901, 0x2644, 0x978b, 0xf8ce, 0xae7f, 0xc13a, 0x70f5, 0x1fb0, 0x034a, 0x6c0f, 0xddc0,
            0xb285, 0x70a2, 0x1fe7, 0xae28, 0xc16d, 0xdd97, 0xb2d2, 0x031d, 0x6c58, 0x3ae9, 0x55ac,
            0xe463, 0x8b26, 0x97dc, 0xf899, 0x4956, 0x2613, 0xdd39, 0xb27c, 0x03b3, 0x6cf6, 0x700c,
            0x1f49, 0xae86, 0xc1c3, 0x9772, 0xf837, 0x49f8, 0x26bd, 0x3a47, 0x5502, 0xe4cd, 0x8b88,
            0x49af, 0x26ea, 0x9725, 0xf860, 0xe49a, 0x8bdf, 0x3a10, 0x5555, 0x03e4, 0x6ca1, 0xdd6e,
            0xb22b, 0xaed1, 0xc194, 0x705b, 0x1f1e, 0x962e, 0xf96b, 0x48a4, 0x27e1, 0x3b1b, 0x545e,
            0xe591, 0x8ad4, 0xdc65, 0xb320, 0x02ef, 0x6daa, 0x7150, 0x1e15, 0xafda, 0xc09f, 0x02b8,
            0x6dfd, 0xdc32, 0xb377, 0xaf8d, 0xc0c8, 0x7107, 0x1e42, 0x48f3, 0x27b6, 0x9679, 0xf93c,
            0xe5c6, 0x8a83, 0x3b4c, 0x5409, 0xaf23, 0xc066, 0x71a9, 0x1eec, 0x0216, 0x6d53, 0xdc9c,
            0xb3d9, 0xe568, 0x8a2d, 0x3be2, 0x54a7, 0x485d, 0x2718, 0x96d7, 0xf992, 0x3bb5, 0x54f0,
            0xe53f, 0x8a7a, 0x9680, 0xf9c5, 0x480a, 0x274f, 0x71fe, 0x1ebb, 0xaf74, 0xc031, 0xdccb,
            0xb38e, 0x0241, 0x6d04,
        ],
        [
            0x0000, 0xd849, 0xa0b3, 0x78fa, 0x5147, 0x890e, 0xf1f4, 0x29bd, 0xa28e, 0x7ac7, 0x023d,
            0xda74, 0xf3c9, 0x2b80, 0x537a, 0x8b33, 0x553d, 0x8d74, 0xf58e, 0x2dc7, 0x047a, 0xdc33,
            0xa4c9, 0x7c80, 0xf7b3, 0x2ffa, 0x5700, 0x8f49, 0xa6f4, 0x7ebd, 0x0647, 0xde0e, 0xaa7a,
            0x7233, 0x0ac9, 0xd280, 0xfb3d, 0x2374, 0x5b8e, 0x83c7, 0x08f4, 0xd0bd, 0xa847, 0x700e,
            0x59b3, 0x81fa, 0xf900, 0x2149, 0xff47, 0x270e, 0x5ff4, 0x87bd, 0xae00, 0x7649, 0x0eb3,
            0xd6fa, 0x5dc9, 0x8580, 0xfd7a, 0x2533, 0x0c8e, 0xd4c7, 0xac3d, 0x7474, 0x44d5, 0x9c9c,
            0xe466, 0x3c2f, 0x1592, 0xcddb, 0xb521, 0x6d68, 0xe65b, 0x3e12, 0x46e8, 0x9ea1, 0xb71c,
            0x6f55, 0x17af, 0xcfe6, 0x11e8, 0xc9a1, 0xb15b, 0x6912, 0x40af, 0x98e6, 0xe01c, 0x3855,
            0xb366, 0x6b2f, 0x13d5, 0xcb9c, 0xe221, 0x3a68, 0x4292, 0x9adb, 0xeeaf, 0x36e6, 0x4e1c,
            0x9655, 0xbfe8, 0x67a1, 0x1f5b, 0xc712, 0x4c21, 0x9468, 0xec92, 0x34db, 0x1d66, 0xc52f,
            0xbdd5, 0x659c, 0xbb92, 0x63db, 0x1b21, 0xc368, 0xead5, 0x329c, 0x4a66, 0x922f, 0x191c,
            0xc155, 0xb9af, 0x61e6, 0x485b, 0x9012, 0xe8e8, 0x30a1, 0x89aa, 0x51e3, 0x2919, 0xf150,
            0xd8ed, 0x00a4, 0x785e, 0xa017, 0x2b24, 0xf36d, 0x8b97, 0x53de, 0x7a63, 0xa22a, 0xdad0,
            0x0299, 0xdc97, 0x04de, 0x7c24, 0xa46d, 0x8dd0, 0x5599, 0x2d63, 0xf52a, 0x7e19, 0xa650,
            0xdeaa, 0x06e3, 0x2f5e, 0xf717, 0x8fed, 0x57a4, 0x23d0, 0xfb99, 0x8363, 0x5b2a, 0x7297,
            0xaade, 0xd224, 0x0a6d, 0x815e, 0x5917, 0x21ed, 0xf9a4, 0xd019, 0x0850, 0x70aa, 0xa8e3,
            0x76ed, 0xaea4, 0xd65e, 0x0e17, 0x27aa, 0xffe3, 0x8719, 0x5f50, 0xd463, 0x0c2a, 0x74d0,
            0xac99, 0x8524, 0x5d6d, 0x2597, 0xfdde, 0xcd7f, 0x1536, 0x6dcc, 0xb585, 0x9c38, 0x4471,
            0x3c8b, 0xe4c2, 0x6ff1, 0xb7b8, 0xcf42, 0x170b, 0x3eb6, 0xe6ff, 0x9e05, 0x464c, 0x9842,
            0x400b, 0x38f1, 0xe0b8, 0xc905, 0x114c, 0x69b6, 0xb1ff, 0x3acc, 0xe285, 0x9a7f, 0x4236,
            0x6b8b, 0xb3c2, 0xcb38, 0x1371, 0x6705, 0xbf4c, 0xc7b6, 0x1fff, 0x3642, 0xee0b, 0x96f1,
            0x4eb8, 0xc58b, 0x1dc2, 0x6538, 0xbd71, 0x94cc, 0x4c85, 0x347f, 0xec36, 0x3238, 0xea71,
            0x928b, 0x4ac2, 0x637f, 0xbb36, 0xc3cc, 0x1b85, 0x90b6, 0x48ff, 0x3005, 0xe84c, 0xc1f1,
            0x19b8, 0x6142, 0xb90b,
        ],
        [
            0x0000, 0x0375, 0x06ea, 0x059f, 0x0dd4, 0x0ea1, 0x0b3e, 0x084b, 0x1ba8, 0x18dd, 0x1d42,
            0x1e37, 0x167c, 0x1509, 0x1096, 0x13e3, 0x3750, 0x3425, 0x31ba, 0x32cf, 0x3a84, 0x39f1,
            0x3c6e, 0x3f1b, 0x2cf8, 0x2f8d, 0x2a12, 0x2967, 0x212c, 0x2259, 0x27c6, 0x24b3, 0x6ea0,
            0x6dd5, 0x684a, 0x6b3f, 0x6374, 0x6001, 0x659e, 0x66eb, 0x7508, 0x767d, 0x73e2, 0x7097,
            0x78dc, 0x7ba9, 0x7e36, 0x7d43, 0x59f0, 0x5a85, 0x5f1a, 0x5c6f, 0x5424, 0x5751, 0x52ce,
            0x51bb, 0x4258, 0x412d, 0x44b2, 0x47c7, 0x4f8c, 0x4cf9, 0x4966, 0x4a13, 0xdd40, 0xde35,
            0xdbaa, 0xd8df, 0xd094, 0xd3e1, 0xd67e, 0xd50b, 0xc6e8, 0xc59d, 0xc002, 0xc377, 0xcb3c,
            0xc849, 0xcdd6, 0xcea3, 0xea10, 0xe965, 0xecfa, 0xef8f, 0xe7c4, 0xe4b1, 0xe12e, 0xe25b,
            0xf1b8, 0xf2cd, 0xf752, 0xf427, 0xfc6c, 0xff19, 0xfa86, 0xf9f3, 0xb3e0, 0xb095, 0xb50a,
            0xb67f, 0xbe34, 0xbd41, 0xb8de, 0xbbab, 0xa848, 0xab3d, 0xaea2, 0xadd7, 0xa59c, 0xa6e9,
            0xa376, 0xa003, 0x84b0, 0x87c5, 0x825a, 0x812f, 0x8964, 0x8a11, 0x8f8e, 0x8cfb, 0x9f18,
            0x9c6d, 0x99f2, 0x9a87, 0x92cc, 0x91b9, 0x9426, 0x9753, 0xaaa1, 0xa9d4, 0xac4b, 0xaf3e,
            0xa775, 0xa400, 0xa19f, 0xa2ea, 0xb109, 0xb27c, 0xb7e3, 0xb496, 0xbcdd, 0xbfa8, 0xba37,
            0xb942, 0x9df1, 0x9e84, 0x9b1b, 0x986e, 0x9025, 0x9350, 0x96cf, 0x95ba, 0x8659, 0x852c,
            0x80b3, 0x83c6, 0x8b8d, 0x88f8, 0x8d67, 0x8e12, 0xc401, 0xc774, 0xc2eb, 0xc19e, 0xc9d5,
            0xcaa0, 0xcf3f, 0xcc4a, 0xdfa9, 0xdcdc, 0xd943, 0xda36, 0xd27d, 0xd108, 0xd497, 0xd7e2,
            0xf351, 0xf024, 0xf5bb, 0xf6ce, 0xfe85, 0xfdf0, 0xf86f, 0xfb1a, 0xe8f9, 0xeb8c, 0xee13,
            0xed66, 0xe52d, 0xe658, 0xe3c7, 0xe0b2, 0x77e1, 0x7494, 0x710b, 0x727e, 0x7a35, 0x7940,
            0x7cdf, 0x7faa, 0x6c49, 0x6f3c, 0x6aa3, 0x69d6, 0x619d, 0x62e8, 0x6777, 0x6402, 0x40b1,
            0x43c4, 0x465b, 0x452e, 0x4d65, 0x4e10, 0x4b8f, 0x48fa, 0x5b19, 0x586c, 0x5df3, 0x5e86,
            0x56cd, 0x55b8, 0x5027, 0x5352, 0x1941, 0x1a34, 0x1fab, 0x1cde, 0x1495, 0x17e0, 0x127f,
            0x110a, 0x02e9, 0x019c, 0x0403, 0x0776, 0x0f3d, 0x0c48, 0x09d7, 0x0aa2, 0x2e11, 0x2d64,
            0x28fb, 0x2b8e, 0x23c5, 0x20b0, 0x252f, 0x265a, 0x35b9, 0x36cc, 0x3353, 0x3026, 0x386d,
            0x3b18, 0x3e87, 0x3df2,
        ],
        [
            0x0000, 0x4563, 0x8ac6, 0xcfa5, 0x05ad, 0x40ce, 0x8f6b, 0xca08, 0x0b5a, 0x4e39, 0x819c,
            0xc4ff, 0x0ef7, 0x4b94, 0x8431, 0xc152, 0x16b4, 0x53d7, 0x9c72, 0xd911, 0x1319, 0x567a,
            0x99df, 0xdcbc, 0x1dee, 0x588d, 0x9728, 0xd24b, 0x1843, 0x5d20, 0x9285, 0xd7e6, 0x2d68,
            0x680b, 0xa7ae, 0xe2cd, 0x28c5, 0x6da6, 0xa203, 0xe760, 0x2632, 0x6351, 0xacf4, 0xe997,
            0x239f, 0x66fc, 0xa959, 0xec3a, 0x3bdc, 0x7ebf, 0xb11a, 0xf479, 0x3e71, 0x7b12, 0xb4b7,
            0xf1d4, 0x3086, 0x75e5, 0xba40, 0xff23, 0x352b, 0x7048, 0xbfed, 0xfa8e, 0x5ad0, 0x1fb3,
            0xd016, 0x9575, 0x5f7d, 0x1a1e, 0xd5bb, 0x90d8, 0x518a, 0x14e9, 0xdb4c, 0x9e2f, 0x5427,
            0x1144, 0xdee1, 0x9b82, 0x4c64, 0x0907, 0xc6a2, 0x83c1, 0x49c9, 0x0caa, 0xc30f, 0x866c,
            0x473e, 0x025d, 0xcdf8, 0x889b, 0x4293, 0x07f0, 0xc855, 0x8d36, 0x77b8, 0x32db, 0xfd7e,
            0xb81d, 0x7215, 0x3776, 0xf8d3, 0xbdb0, 0x7ce2, 0x3981, 0xf624, 0xb347, 0x794f, 0x3c2c,
            0xf389, 0xb6ea, 0x610c, 0x246f, 0xebca, 0xaea9, 0x64a1, 0x21c2, 0xee67, 0xab04, 0x6a56,
            0x2f35, 0xe090, 0xa5f3, 0x6ffb, 0x2a98, 0xe53d, 0xa05e, 0xb5a0, 0xf0c3, 0x3f66, 0x7a05,
            0xb00d, 0xf56e, 0x3acb, 0x7fa8, 0xbefa, 0xfb99, 0x343c, 0x715f, 0xbb57, 0xfe34, 0x3191,
            0x74f2, 0xa314, 0xe677, 0x29d2, 0x6cb1, 0xa6b9, 0xe3da, 0x2c7f, 0x691c, 0xa84e, 0xed2d,
            0x2288, 0x67eb, 0xade3, 0xe880, 0x2725, 0x6246, 0x98c8, 0xddab, 0x120e, 0x576d, 0x9d65,
            0xd806, 0x17a3, 0x52c0, 0x9392, 0xd6f1, 0x1954, 0x5c37, 0x963f, 0xd35c, 0x1cf9, 0x599a,
            0x8e7c, 0xcb1f, 0x04ba, 0x41d9, 0x8bd1, 0xceb2, 0x0117, 0x4474, 0x8526, 0xc045, 0x0fe0,
            0x4a83, 0x808b, 0xc5e8, 0x0a4d, 0x4f2e, 0xef70, 0xaa13, 0x65b6, 0x20d5, 0xeadd, 0xafbe,
            0x601b, 0x2578, 0xe42a, 0xa149, 0x6eec, 0x2b8f, 0xe187, 0xa4e4, 0x6b41, 0x2e22, 0xf9c4,
            0xbca7, 0x7302, 0x3661, 0xfc69, 0xb90a, 0x76af, 0x33cc, 0xf29e, 0xb7fd, 0x7858, 0x3d3b,
            0xf733, 0xb250, 0x7df5, 0x3896, 0xc218, 0x877b, 0x48de, 0x0dbd, 0xc7b5, 0x82d6, 0x4d73,
            0x0810, 0xc942, 0x8c21, 0x4384, 0x06e7, 0xccef, 0x898c, 0x4629, 0x034a, 0xd4ac, 0x91cf,
            0x5e6a, 0x1b09, 0xd101, 0x9462, 0x5bc7, 0x1ea4, 0xdff6, 0x9a95, 0x5530, 0x1053, 0xda5b,
            0x9f38, 0x509d, 0x15fe,
        ],
        [
            0x0000, 0x7b61, 0xf6c2, 0x8da3, 0xfda5, 0x86c4, 0x0b67, 0x7006, 0xeb6b, 0x900a, 0x1da9,
            0x66c8, 0x16ce, 0x6daf, 0xe00c, 0x9b6d, 0xc6f7, 0xbd96, 0x3035, 0x4b54, 0x3b52, 0x4033,
            0xcd90, 0xb6f1, 0x2d9c, 0x56fd, 0xdb5e, 0xa03f, 0xd039, 0xab58, 0x26fb, 0x5d9a, 0x9dcf,
            0xe6ae, 0x6b0d, 0x106c, 0x606a, 0x1b0b, 0x96a8, 0xedc9, 0x76a4, 0x0dc5, 0x8066, 0xfb07,
            0x8b01, 0xf060, 0x7dc3, 0x06a2, 0x5b38, 0x2059, 0xadfa, 0xd69b, 0xa69d, 0xddfc, 0x505f,
            0x2b3e, 0xb053, 0xcb32, 0x4691, 0x3df0, 0x4df6, 0x3697, 0xbb34, 0xc055, 0x2bbf, 0x50de,
            0xdd7d, 0xa61c, 0xd61a, 0xad7b, 0x20d8, 0x5bb9, 0xc0d4, 0xbbb5, 0x3616, 0x4d77, 0x3d71,
            0x4610, 0xcbb3, 0xb0d2, 0xed48, 0x9629, 0x1b8a, 0x60eb, 0x10ed, 0x6b8c, 0xe62f, 0x9d4e,
            0x0623, 0x7d42, 0xf0e1, 0x8b80, 0xfb86, 0x80e7, 0x0d44, 0x7625, 0xb670, 0xcd11, 0x40b2,
            0x3bd3, 0x4bd5, 0x30b4, 0xbd17, 0xc676, 0x5d1b, 0x267a, 0xabd9, 0xd0b8, 0xa0be, 0xdbdf,
            0x567c, 0x2d1d, 0x7087, 0x0be6, 0x8645, 0xfd24, 0x8d22, 0xf643, 0x7be0, 0x0081, 0x9bec,
            0xe08d, 0x6d2e, 0x164f, 0x6649, 0x1d28, 0x908b, 0xebea, 0x577e, 0x2c1f, 0xa1bc, 0xdadd,
            0xaadb, 0xd1ba, 0x5c19, 0x2778, 0xbc15, 0xc774, 0x4ad7, 0x31b6, 0x41b0, 0x3ad1, 0xb772,
            0xcc13, 0x9189, 0xeae8, 0x674b, 0x1c2a, 0x6c2c, 0x174d, 0x9aee, 0xe18f, 0x7ae2, 0x0183,
            0x8c20, 0xf741, 0x8747, 0xfc26, 0x7185, 0x0ae4, 0xcab1, 0xb1d0, 0x3c73, 0x4712, 0x3714,
            0x4c75, 0xc1d6, 0xbab7, 0x21da, 0x5abb, 0xd718, 0xac79, 0xdc7f, 0xa71e, 0x2abd, 0x51dc,
            0x0c46, 0x7727, 0xfa84, 0x81e5, 0xf1e3, 0x8a82, 0x0721, 0x7c40, 0xe72d, 0x9c4c, 0x11ef,
            0x6a8e, 0x1a88, 0x61e9, 0xec4a, 0x972b, 0x7cc1, 0x07a0, 0x8a03, 0xf162, 0x8164, 0xfa05,
            0x77a6, 0x0cc7, 0x97aa, 0xeccb, 0x6168, 0x1a09, 0x6a0f, 0x116e, 0x9ccd, 0xe7ac, 0xba36,
            0xc157, 0x4cf4, 0x3795, 0x4793, 0x3cf2, 0xb151, 0xca30, 0x515d, 0x2a3c, 0xa79f, 0xdcfe,
            0xacf8, 0xd799, 0x5a3a, 0x215b, 0xe10e, 0x9a6f, 0x17cc, 0x6cad, 0x1cab, 0x67ca, 0xea69,
            0x9108, 0x0a65, 0x7104, 0xfca7, 0x87c6, 0xf7c0, 0x8ca1, 0x0102, 0x7a63, 0x27f9, 0x5c98,
            0xd13b, 0xaa5a, 0xda5c, 0xa13d, 0x2c9e, 0x57ff, 0xcc92, 0xb7f3, 0x3a50, 0x4131, 0x3137,
            0x4a56, 0xc7f5, 0xbc94,
        ],
        [
            0x0000, 0xaefc, 0x4dd9, 0xe325, 0x9bb2, 0x354e, 0xd66b, 0x7897, 0x2745, 0x89b9, 0x6a9c,
            0xc460, 0xbcf7, 0x120b, 0xf12e, 0x5fd2, 0x4e8a, 0xe076, 0x0353, 0xadaf, 0xd538, 0x7bc4,
            0x98e1, 0x361d, 0x69cf, 0xc733, 0x2416, 0x8aea, 0xf27d, 0x5c81, 0xbfa4, 0x1158, 0x9d14,
            0x33e8, 0xd0cd, 0x7e31, 0x06a6, 0xa85a, 0x4b7f, 0xe583, 0xba51, 0x14ad, 0xf788, 0x5974,
            0x21e3, 0x8f1f, 0x6c3a, 0xc2c6, 0xd39e, 0x7d62, 0x9e47, 0x30bb, 0x482c, 0xe6d0, 0x05f5,
            0xab09, 0xf4db, 0x5a27, 0xb902, 0x17fe, 0x6f69, 0xc195, 0x22b0, 0x8c4c, 0x2a09, 0x84f5,
            0x67d0, 0xc92c, 0xb1bb, 0x1f47, 0xfc62, 0x529e, 0x0d4c, 0xa3b0, 0x4095, 0xee69, 0x96fe,
            0x3802, 0xdb27, 0x75db, 0x6483, 0xca7f, 0x295a, 0x87a6, 0xff31, 0x51cd, 0xb2e8, 0x1c14,
            0x43c6, 0xed3a, 0x0e1f, 0xa0e3, 0xd874, 0x7688, 0x95ad, 0x3b51, 0xb71d, 0x19e1, 0xfac4,
            0x5438, 0x2caf, 0x8253, 0x6176, 0xcf8a, 0x9058, 0x3ea4, 0xdd81, 0x737d, 0x0bea, 0xa516,
            0x4633, 0xe8cf, 0xf997, 0x576b, 0xb44e, 0x1ab2, 0x6225, 0xccd9, 0x2ffc, 0x8100, 0xded2,
            0x702e, 0x930b, 0x3df7, 0x4560, 0xeb9c, 0x08b9, 0xa645, 0x5412, 0xfaee, 0x19cb, 0xb737,
            0xcfa0, 0x615c, 0x8279, 0x2c85, 0x7357, 0xddab, 0x3e8e, 0x9072, 0xe8e5, 0x4619, 0xa53c,
            0x0bc0, 0x1a98, 0xb464, 0x5741, 0xf9bd, 0x812a, 0x2fd6, 0xccf3, 0x620f, 0x3ddd, 0x9321,
            0x7004, 0xdef8, 0xa66f, 0x0893, 0xebb6, 0x454a, 0xc906, 0x67fa, 0x84df, 0x2a23, 0x52b4,
            0xfc48, 0x1f6d, 0xb191, 0xee43, 0x40bf, 0xa39a, 0x0d66, 0x75f1, 0xdb0d, 0x3828, 0x96d4,
            0x878c, 0x2970, 0xca55, 0x64a9, 0x1c3e, 0xb2c2, 0x51e7, 0xff1b, 0xa0c9, 0x0e35, 0xed10,
            0x43ec, 0x3b7b, 0x9587, 0x76a2, 0xd85e, 0x7e1b, 0xd0e7, 0x33c2, 0x9d3e, 0xe5a9, 0x4b55,
            0xa870, 0x068c, 0x595e, 0xf7a2, 0x1487, 0xba7b, 0xc2ec, 0x6c10, 0x8f35, 0x21c9, 0x3091,
            0x9e6d, 0x7d48, 0xd3b4, 0xab23, 0x05df, 0xe6fa, 0x4806, 0x17d4, 0xb928, 0x5a0d, 0xf4f1,
            0x8c66, 0x229a, 0xc1bf, 0x6f43, 0xe30f, 0x4df3, 0xaed6, 0x002a, 0x78bd, 0xd641, 0x3564,
            0x9b98, 0xc44a, 0x6ab6, 0x8993, 0x276f, 0x5ff8, 0xf104, 0x1221, 0xbcdd, 0xad85, 0x0379,
            0xe05c, 0x4ea0, 0x3637, 0x98cb, 0x7bee, 0xd512, 0x8ac0, 0x243c, 0xc719, 0x69e5, 0x1172,
            0xbf8e, 0x5cab, 0xf257,
        ],
        [
            0x0000, 0xa824, 0x4069, 0xe84d, 0x80d2, 0x28f6, 0xc0bb, 0x689f, 0x1185, 0xb9a1, 0x51ec,
            0xf9c8, 0x9157, 0x3973, 0xd13e, 0x791a, 0x230a, 0x8b2e, 0x6363, 0xcb47, 0xa3d8, 0x0bfc,
            0xe3b1, 0x4b95, 0x328f, 0x9aab, 0x72e6, 0xdac2, 0xb25d, 0x1a79, 0xf234, 0x5a10, 0x4614,
            0xee30, 0x067d, 0xae59, 0xc6c6, 0x6ee2, 0x86af, 0x2e8b, 0x5791, 0xffb5, 0x17f8, 0xbfdc,
            0xd743, 0x7f67, 0x972a, 0x3f0e, 0x651e, 0xcd3a, 0x2577, 0x8d53, 0xe5cc, 0x4de8, 0xa5a5,
            0x0d81, 0x749b, 0xdcbf, 0x34f2, 0x9cd6, 0xf449, 0x5c6d, 0xb420, 0x1c04, 0x8c28, 0x240c,
            0xcc41, 0x6465, 0x0cfa, 0xa4de, 0x4c93, 0xe4b7, 0x9dad, 0x3589, 0xddc4, 0x75e0, 0x1d7f,
            0xb55b, 0x5d16, 0xf532, 0xaf22, 0x0706, 0xef4b, 0x476f, 0x2ff0, 0x87d4, 0x6f99, 0xc7bd,
            0xbea7, 0x1683, 0xfece, 0x56ea, 0x3e75, 0x9651, 0x7e1c, 0xd638, 0xca3c, 0x6218, 0x8a55,
            0x2271, 0x4aee, 0xe2ca, 0x0a87, 0xa2a3, 0xdbb9, 0x739d, 0x9bd0, 0x33f4, 0x5b6b, 0xf34f,
            0x1b02, 0xb326, 0xe936, 0x4112, 0xa95f, 0x017b, 0x69e4, 0xc1c0, 0x298d, 0x81a9, 0xf8b3,
            0x5097, 0xb8da, 0x10fe, 0x7861, 0xd045, 0x3808, 0x902c, 0x0871, 0xa055, 0x4818, 0xe03c,
            0x88a3, 0x2087, 0xc8ca, 0x60ee, 0x19f4, 0xb1d0, 0x599d, 0xf1b9, 0x9926, 0x3102, 0xd94f,
            0x716b, 0x2b7b, 0x835f, 0x6b12, 0xc336, 0xaba9, 0x038d, 0xebc0, 0x43e4, 0x3afe, 0x92da,
            0x7a97, 0xd2b3, 0xba2c, 0x1208, 0xfa45, 0x5261, 0x4e65, 0xe641, 0x0e0c, 0xa628, 0xceb7,
            0x6693, 0x8ede, 0x26fa, 0x5fe0, 0xf7c4, 0x1f89, 0xb7ad, 0xdf32, 0x7716, 0x9f5b, 0x377f,
            0x6d6f, 0xc54b, 0x2d06, 0x8522, 0xedbd, 0x4599, 0xadd4, 0x05f0, 0x7cea, 0xd4ce, 0x3c83,
            0x94a7, 0xfc38, 0x541c, 0xbc51, 0x1475, 0x8459, 0x2c7d, 0xc430, 0x6c14, 0x048b, 0xacaf,
            0x44e2, 0xecc6, 0x95dc, 0x3df8, 0xd5b5, 0x7d91, 0x150e, 0xbd2a, 0x5567, 0xfd43, 0xa753,
            0x0f77, 0xe73a, 0x4f1e, 0x2781, 0x8fa5, 0x67e8, 0xcfcc, 0xb6d6, 0x1ef2, 0xf6bf, 0x5e9b,
            0x3604, 0x9e20, 0x766d, 0xde49, 0xc24d, 0x6a69, 0x8224, 0x2a00, 0x429f, 0xeabb, 0x02f6,
            0xaad2, 0xd3c8, 0x7bec, 0x93a1, 0x3b85, 0x531a, 0xfb3e, 0x1373, 0xbb57, 0xe147, 0x4963,
            0xa12e, 0x090a, 0x6195, 0xc9b1, 0x21fc, 0x89d8, 0xf0c2, 0x58e6, 0xb0ab, 0x188f, 0x7010,
            0xd834, 0x3079, 0x985d,
        ],
    ];

    pub static CRC16_IBM_SDLC_TABLE: [[u16; 256]; 16] = [
        [
            0x0000, 0x1189, 0x2312, 0x329b, 0x4624, 0x57ad, 0x6536, 0x74bf, 0x8c48, 0x9dc1, 0xaf5a,
            0xbed3, 0xca6c, 0xdbe5, 0xe97e, 0xf8f7, 0x1081, 0x0108, 0x3393, 0x221a, 0x56a5, 0x472c,
            0x75b7, 0x643e, 0x9cc9, 0x8d40, 0xbfdb, 0xae52, 0xdaed, 0xcb64, 0xf9ff, 0xe876, 0x2102,
            0x308b, 0x0210, 0x1399, 0x6726, 0x76af, 0x4434, 0x55bd, 0xad4a, 0xbcc3, 0x8e58, 0x9fd1,
            0xeb6e, 0xfae7, 0xc87c, 0xd9f5, 0x3183, 0x200a, 0x1291, 0x0318, 0x77a7, 0x662e, 0x54b5,
            0x453c, 0xbdcb, 0xac42, 0x9ed9, 0x8f50, 0xfbef, 0xea66, 0xd8fd, 0xc974, 0x4204, 0x538d,
            0x6116, 0x709f, 0x0420, 0x15a9, 0x2732, 0x36bb, 0xce4c, 0xdfc5, 0xed5e, 0xfcd7, 0x8868,
            0x99e1, 0xab7a, 0xbaf3, 0x5285, 0x430c, 0x7197, 0x601e, 0x14a1, 0x0528, 0x37b3, 0x263a,
            0xdecd, 0xcf44, 0xfddf, 0xec56, 0x98e9, 0x8960, 0xbbfb, 0xaa72, 0x6306, 0x728f, 0x4014,
            0x519d, 0x2522, 0x34ab, 0x0630, 0x17b9, 0xef4e, 0xfec7, 0xcc5c, 0xddd5, 0xa96a, 0xb8e3,
            0x8a78, 0x9bf1, 0x7387, 0x620e, 0x5095, 0x411c, 0x35a3, 0x242a, 0x16b1, 0x0738, 0xffcf,
            0xee46, 0xdcdd, 0xcd54, 0xb9eb, 0xa862, 0x9af9, 0x8b70, 0x8408, 0x9581, 0xa71a, 0xb693,
            0xc22c, 0xd3a5, 0xe13e, 0xf0b7, 0x0840, 0x19c9, 0x2b52, 0x3adb, 0x4e64, 0x5fed, 0x6d76,
            0x7cff, 0x9489, 0x8500, 0xb79b, 0xa612, 0xd2ad, 0xc324, 0xf1bf, 0xe036, 0x18c1, 0x0948,
            0x3bd3, 0x2a5a, 0x5ee5, 0x4f6c, 0x7df7, 0x6c7e, 0xa50a, 0xb483, 0x8618, 0x9791, 0xe32e,
            0xf2a7, 0xc03c, 0xd1b5, 0x2942, 0x38cb, 0x0a50, 0x1bd9, 0x6f66, 0x7eef, 0x4c74, 0x5dfd,
            0xb58b, 0xa402, 0x9699, 0x8710, 0xf3af, 0xe226, 0xd0bd, 0xc134, 0x39c3, 0x284a, 0x1ad1,
            0x0b58, 0x7fe7, 0x6e6e, 0x5cf5, 0x4d7c, 0xc60c, 0xd785, 0xe51e, 0xf497, 0x8028, 0x91a1,
            0xa33a, 0xb2b3, 0x4a44, 0x5bcd, 0x6956, 0x78df, 0x0c60, 0x1de9, 0x2f72, 0x3efb, 0xd68d,
            0xc704, 0xf59f, 0xe416, 0x90a9, 0x8120, 0xb3bb, 0xa232, 0x5ac5, 0x4b4c, 0x79d7, 0x685e,
            0x1ce1, 0x0d68, 0x3ff3, 0x2e7a, 0xe70e, 0xf687, 0xc41c, 0xd595, 0xa12a, 0xb0a3, 0x8238,
            0x93b1, 0x6b46, 0x7acf, 0x4854, 0x59dd, 0x2d62, 0x3ceb, 0x0e70, 0x1ff9, 0xf78f, 0xe606,
            0xd49d, 0xc514, 0xb1ab, 0xa022, 0x92b9, 0x8330, 0x7bc7, 0x6a4e, 0x58d5, 0x495c, 0x3de3,
            0x2c6a, 0x1ef1, 0x0f78,
        ],
        [
            0x0000, 0x19d8, 0x33b0, 0x2a68, 0x6760, 0x7eb8, 0x54d0, 0x4d08, 0xcec0, 0xd718, 0xfd70,
            0xe4a8, 0xa9a0, 0xb078, 0x9a10, 0x83c8, 0x9591, 0x8c49, 0xa621, 0xbff9, 0xf2f1, 0xeb29,
            0xc141, 0xd899, 0x5b51, 0x4289, 0x68e1, 0x7139, 0x3c31, 0x25e9, 0x0f81, 0x1659, 0x2333,
            0x3aeb, 0x1083, 0x095b, 0x4453, 0x5d8b, 0x77e3, 0x6e3b, 0xedf3, 0xf42b, 0xde43, 0xc79b,
            0x8a93, 0x934b, 0xb923, 0xa0fb, 0xb6a2, 0xaf7a, 0x8512, 0x9cca, 0xd1c2, 0xc81a, 0xe272,
            0xfbaa, 0x7862, 0x61ba, 0x4bd2, 0x520a, 0x1f02, 0x06da, 0x2cb2, 0x356a, 0x4666, 0x5fbe,
            0x75d6, 0x6c0e, 0x2106, 0x38de, 0x12b6, 0x0b6e, 0x88a6, 0x917e, 0xbb16, 0xa2ce, 0xefc6,
            0xf61e, 0xdc76, 0xc5ae, 0xd3f7, 0xca2f, 0xe047, 0xf99f, 0xb497, 0xad4f, 0x8727, 0x9eff,
            0x1d37, 0x04ef, 0x2e87, 0x375f, 0x7a57, 0x638f, 0x49e7, 0x503f, 0x6555, 0x7c8d, 0x56e5,
            0x4f3d, 0x0235, 0x1bed, 0x3185, 0x285d, 0xab95, 0xb24d, 0x9825, 0x81fd, 0xccf5, 0xd52d,
            0xff45, 0xe69d, 0xf0c4, 0xe91c, 0xc374, 0xdaac, 0x97a4, 0x8e7c, 0xa414, 0xbdcc, 0x3e04,
            0x27dc, 0x0db4, 0x146c, 0x5964, 0x40bc, 0x6ad4, 0x730c, 0x8ccc, 0x9514, 0xbf7c, 0xa6a4,
            0xebac, 0xf274, 0xd81c, 0xc1c4, 0x420c, 0x5bd4, 0x71bc, 0x6864, 0x256c, 0x3cb4, 0x16dc,
            0x0f04, 0x195d, 0x0085, 0x2aed, 0x3335, 0x7e3d, 0x67e5, 0x4d8d, 0x5455, 0xd79d, 0xce45,
            0xe42d, 0xfdf5, 0xb0fd, 0xa925, 0x834d, 0x9a95, 0xafff, 0xb627, 0x9c4f, 0x8597, 0xc89f,
            0xd147, 0xfb2f, 0xe2f7, 0x613f, 0x78e7, 0x528f, 0x4b57, 0x065f, 0x1f87, 0x35ef, 0x2c37,
            0x3a6e, 0x23b6, 0x09de, 0x1006, 0x5d0e, 0x44d6, 0x6ebe, 0x7766, 0xf4ae, 0xed76, 0xc71e,
            0xdec6, 0x93ce, 0x8a16, 0xa07e, 0xb9a6, 0xcaaa, 0xd372, 0xf91a, 0xe0c2, 0xadca, 0xb412,
            0x9e7a, 0x87a2, 0x046a, 0x1db2, 0x37da, 0x2e02, 0x630a, 0x7ad2, 0x50ba, 0x4962, 0x5f3b,
            0x46e3, 0x6c8b, 0x7553, 0x385b, 0x2183, 0x0beb, 0x1233, 0x91fb, 0x8823, 0xa24b, 0xbb93,
            0xf69b, 0xef43, 0xc52b, 0xdcf3, 0xe999, 0xf041, 0xda29, 0xc3f1, 0x8ef9, 0x9721, 0xbd49,
            0xa491, 0x2759, 0x3e81, 0x14e9, 0x0d31, 0x4039, 0x59e1, 0x7389, 0x6a51, 0x7c08, 0x65d0,
            0x4fb8, 0x5660, 0x1b68, 0x02b0, 0x28d8, 0x3100, 0xb2c8, 0xab10, 0x8178, 0x98a0, 0xd5a8,
            0xcc70, 0xe618, 0xffc0,
        ],
        [
            0x0000, 0x5adc, 0xb5b8, 0xef64, 0x6361, 0x39bd, 0xd6d9, 0x8c05, 0xc6c2, 0x9c1e, 0x737a,
            0x29a6, 0xa5a3, 0xff7f, 0x101b, 0x4ac7, 0x8595, 0xdf49, 0x302d, 0x6af1, 0xe6f4, 0xbc28,
            0x534c, 0x0990, 0x4357, 0x198b, 0xf6ef, 0xac33, 0x2036, 0x7aea, 0x958e, 0xcf52, 0x033b,
            0x59e7, 0xb683, 0xec5f, 0x605a, 0x3a86, 0xd5e2, 0x8f3e, 0xc5f9, 0x9f25, 0x7041, 0x2a9d,
            0xa698, 0xfc44, 0x1320, 0x49fc, 0x86ae, 0xdc72, 0x3316, 0x69ca, 0xe5cf, 0xbf13, 0x5077,
            0x0aab, 0x406c, 0x1ab0, 0xf5d4, 0xaf08, 0x230d, 0x79d1, 0x96b5, 0xcc69, 0x0676, 0x5caa,
            0xb3ce, 0xe912, 0x6517, 0x3fcb, 0xd0af, 0x8a73, 0xc0b4, 0x9a68, 0x750c, 0x2fd0, 0xa3d5,
            0xf909, 0x166d, 0x4cb1, 0x83e3, 0xd93f, 0x365b, 0x6c87, 0xe082, 0xba5e, 0x553a, 0x0fe6,
            0x4521, 0x1ffd, 0xf099, 0xaa45, 0x2640, 0x7c9c, 0x93f8, 0xc924, 0x054d, 0x5f91, 0xb0f5,
            0xea29, 0x662c, 0x3cf0, 0xd394, 0x8948, 0xc38f, 0x9953, 0x7637, 0x2ceb, 0xa0ee, 0xfa32,
            0x1556, 0x4f8a, 0x80d8, 0xda04, 0x3560, 0x6fbc, 0xe3b9, 0xb965, 0x5601, 0x0cdd, 0x461a,
            0x1cc6, 0xf3a2, 0xa97e, 0x257b, 0x7fa7, 0x90c3, 0xca1f, 0x0cec, 0x5630, 0xb954, 0xe388,
            0x6f8d, 0x3551, 0xda35, 0x80e9, 0xca2e, 0x90f2, 0x7f96, 0x254a, 0xa94f, 0xf393, 0x1cf7,
            0x462b, 0x8979, 0xd3a5, 0x3cc1, 0x661d, 0xea18, 0xb0c4, 0x5fa0, 0x057c, 0x4fbb, 0x1567,
            0xfa03, 0xa0df, 0x2cda, 0x7606, 0x9962, 0xc3be, 0x0fd7, 0x550b, 0xba6f, 0xe0b3, 0x6cb6,
            0x366a, 0xd90e, 0x83d2, 0xc915, 0x93c9, 0x7cad, 0x2671, 0xaa74, 0xf0a8, 0x1fcc, 0x4510,
            0x8a42, 0xd09e, 0x3ffa, 0x6526, 0xe923, 0xb3ff, 0x5c9b, 0x0647, 0x4c80, 0x165c, 0xf938,
            0xa3e4, 0x2fe1, 0x753d, 0x9a59, 0xc085, 0x0a9a, 0x5046, 0xbf22, 0xe5fe, 0x69fb, 0x3327,
            0xdc43, 0x869f, 0xcc58, 0x9684, 0x79e0, 0x233c, 0xaf39, 0xf5e5, 0x1a81, 0x405d, 0x8f0f,
            0xd5d3, 0x3ab7, 0x606b, 0xec6e, 0xb6b2, 0x59d6, 0x030a, 0x49cd, 0x1311, 0xfc75, 0xa6a9,
            0x2aac, 0x7070, 0x9f14, 0xc5c8, 0x09a1, 0x537d, 0xbc19, 0xe6c5, 0x6ac0, 0x301c, 0xdf78,
            0x85a4, 0xcf63, 0x95bf, 0x7adb, 0x2007, 0xac02, 0xf6de, 0x19ba, 0x4366, 0x8c34, 0xd6e8,
            0x398c, 0x6350, 0xef55, 0xb589, 0x5aed, 0x0031, 0x4af6, 0x102a, 0xff4e, 0xa592, 0x2997,
            0x734b, 0x9c2f, 0xc6f3,
        ],
        [
            0x0000, 0x1cbb, 0x3976, 0x25cd, 0x72ec, 0x6e57, 0x4b9a, 0x5721, 0xe5d8, 0xf963, 0xdcae,
            0xc015, 0x9734, 0x8b8f, 0xae42, 0xb2f9, 0xc3a1, 0xdf1a, 0xfad7, 0xe66c, 0xb14d, 0xadf6,
            0x883b, 0x9480, 0x2679, 0x3ac2, 0x1f0f, 0x03b4, 0x5495, 0x482e, 0x6de3, 0x7158, 0x8f53,
            0x93e8, 0xb625, 0xaa9e, 0xfdbf, 0xe104, 0xc4c9, 0xd872, 0x6a8b, 0x7630, 0x53fd, 0x4f46,
            0x1867, 0x04dc, 0x2111, 0x3daa, 0x4cf2, 0x5049, 0x7584, 0x693f, 0x3e1e, 0x22a5, 0x0768,
            0x1bd3, 0xa92a, 0xb591, 0x905c, 0x8ce7, 0xdbc6, 0xc77d, 0xe2b0, 0xfe0b, 0x16b7, 0x0a0c,
            0x2fc1, 0x337a, 0x645b, 0x78e0, 0x5d2d, 0x4196, 0xf36f, 0xefd4, 0xca19, 0xd6a2, 0x8183,
            0x9d38, 0xb8f5, 0xa44e, 0xd516, 0xc9ad, 0xec60, 0xf0db, 0xa7fa, 0xbb41, 0x9e8c, 0x8237,
            0x30ce, 0x2c75, 0x09b8, 0x1503, 0x4222, 0x5e99, 0x7b54, 0x67ef, 0x99e4, 0x855f, 0xa092,
            0xbc29, 0xeb08, 0xf7b3, 0xd27e, 0xcec5, 0x7c3c, 0x6087, 0x454a, 0x59f1, 0x0ed0, 0x126b,
            0x37a6, 0x2b1d, 0x5a45, 0x46fe, 0x6333, 0x7f88, 0x28a9, 0x3412, 0x11df, 0x0d64, 0xbf9d,
            0xa326, 0x86eb, 0x9a50, 0xcd71, 0xd1ca, 0xf407, 0xe8bc, 0x2d6e, 0x31d5, 0x1418, 0x08a3,
            0x5f82, 0x4339, 0x66f4, 0x7a4f, 0xc8b6, 0xd40d, 0xf1c0, 0xed7b, 0xba5a, 0xa6e1, 0x832c,
            0x9f97, 0xeecf, 0xf274, 0xd7b9, 0xcb02, 0x9c23, 0x8098, 0xa555, 0xb9ee, 0x0b17, 0x17ac,
            0x3261, 0x2eda, 0x79fb, 0x6540, 0x408d, 0x5c36, 0xa23d, 0xbe86, 0x9b4b, 0x87f0, 0xd0d1,
            0xcc6a, 0xe9a7, 0xf51c, 0x47e5, 0x5b5e, 0x7e93, 0x6228, 0x3509, 0x29b2, 0x0c7f, 0x10c4,
            0x619c, 0x7d27, 0x58ea, 0x4451, 0x1370, 0x0fcb, 0x2a06, 0x36bd, 0x8444, 0x98ff, 0xbd32,
            0xa189, 0xf6a8, 0xea13, 0xcfde, 0xd365, 0x3bd9, 0x2762, 0x02af, 0x1e14, 0x4935, 0x558e,
            0x7043, 0x6cf8, 0xde01, 0xc2ba, 0xe777, 0xfbcc, 0xaced, 0xb056, 0x959b, 0x8920, 0xf878,
            0xe4c3, 0xc10e, 0xddb5, 0x8a94, 0x962f, 0xb3e2, 0xaf59, 0x1da0, 0x011b, 0x24d6, 0x386d,
            0x6f4c, 0x73f7, 0x563a, 0x4a81, 0xb48a, 0xa831, 0x8dfc, 0x9147, 0xc666, 0xdadd, 0xff10,
            0xe3ab, 0x5152, 0x4de9, 0x6824, 0x749f, 0x23be, 0x3f05, 0x1ac8, 0x0673, 0x772b, 0x6b90,
            0x4e5d, 0x52e6, 0x05c7, 0x197c, 0x3cb1, 0x200a, 0x92f3, 0x8e48, 0xab85, 0xb73e, 0xe01f,
            0xfca4, 0xd969, 0xc5d2,
        ],
        [
            0x0000, 0x0b44, 0x1688, 0x1dcc, 0x2d10, 0x2654, 0x3b98, 0x30dc, 0x5a20, 0x5164, 0x4ca8,
            0x47ec, 0x7730, 0x7c74, 0x61b8, 0x6afc, 0xb440, 0xbf04, 0xa2c8, 0xa98c, 0x9950, 0x9214,
            0x8fd8, 0x849c, 0xee60, 0xe524, 0xf8e8, 0xf3ac, 0xc370, 0xc834, 0xd5f8, 0xdebc, 0x6091,
            0x6bd5, 0x7619, 0x7d5d, 0x4d81, 0x46c5, 0x5b09, 0x504d, 0x3ab1, 0x31f5, 0x2c39, 0x277d,
            0x17a1, 0x1ce5, 0x0129, 0x0a6d, 0xd4d1, 0xdf95, 0xc259, 0xc91d, 0xf9c1, 0xf285, 0xef49,
            0xe40d, 0x8ef1, 0x85b5, 0x9879, 0x933d, 0xa3e1, 0xa8a5, 0xb569, 0xbe2d, 0xc122, 0xca66,
            0xd7aa, 0xdcee, 0xec32, 0xe776, 0xfaba, 0xf1fe, 0x9b02, 0x9046, 0x8d8a, 0x86ce, 0xb612,
            0xbd56, 0xa09a, 0xabde, 0x7562, 0x7e26, 0x63ea, 0x68ae, 0x5872, 0x5336, 0x4efa, 0x45be,
            0x2f42, 0x2406, 0x39ca, 0x328e, 0x0252, 0x0916, 0x14da, 0x1f9e, 0xa1b3, 0xaaf7, 0xb73b,
            0xbc7f, 0x8ca3, 0x87e7, 0x9a2b, 0x916f, 0xfb93, 0xf0d7, 0xed1b, 0xe65f, 0xd683, 0xddc7,
            0xc00b, 0xcb4f, 0x15f3, 0x1eb7, 0x037b, 0x083f, 0x38e3, 0x33a7, 0x2e6b, 0x252f, 0x4fd3,
            0x4497, 0x595b, 0x521f, 0x62c3, 0x6987, 0x744b, 0x7f0f, 0x8a55, 0x8111, 0x9cdd, 0x9799,
            0xa745, 0xac01, 0xb1cd, 0xba89, 0xd075, 0xdb31, 0xc6fd, 0xcdb9, 0xfd65, 0xf621, 0xebed,
            0xe0a9, 0x3e15, 0x3551, 0x289d, 0x23d9, 0x1305, 0x1841, 0x058d, 0x0ec9, 0x6435, 0x6f71,
            0x72bd, 0x79f9, 0x4925, 0x4261, 0x5fad, 0x54e9, 0xeac4, 0xe180, 0xfc4c, 0xf708, 0xc7d4,
            0xcc90, 0xd15c, 0xda18, 0xb0e4, 0xbba0, 0xa66c, 0xad28, 0x9df4, 0x96b0, 0x8b7c, 0x8038,
            0x5e84, 0x55c0, 0x480c, 0x4348, 0x7394, 0x78d0, 0x651c, 0x6e58, 0x04a4, 0x0fe0, 0x122c,
            0x1968, 0x29b4, 0x22f0, 0x3f3c, 0x3478, 0x4b77, 0x4033, 0x5dff, 0x56bb, 0x6667, 0x6d23,
            0x70ef, 0x7bab, 0x1157, 0x1a13, 0x07df, 0x0c9b, 0x3c47, 0x3703, 0x2acf, 0x218b, 0xff37,
            0xf473, 0xe9bf, 0xe2fb, 0xd227, 0xd963, 0xc4af, 0xcfeb, 0xa517, 0xae53, 0xb39f, 0xb8db,
            0x8807, 0x8343, 0x9e8f, 0x95cb, 0x2be6, 0x20a2, 0x3d6e, 0x362a, 0x06f6, 0x0db2, 0x107e,
            0x1b3a, 0x71c6, 0x7a82, 0x674e, 0x6c0a, 0x5cd6, 0x5792, 0x4a5e, 0x411a, 0x9fa6, 0x94e2,
            0x892e, 0x826a, 0xb2b6, 0xb9f2, 0xa43e, 0xaf7a, 0xc586, 0xcec2, 0xd30e, 0xd84a, 0xe896,
            0xe3d2, 0xfe1e, 0xf55a,
        ],
        [
            0x0000, 0x042b, 0x0856, 0x0c7d, 0x10ac, 0x1487, 0x18fa, 0x1cd1, 0x2158, 0x2573, 0x290e,
            0x2d25, 0x31f4, 0x35df, 0x39a2, 0x3d89, 0x42b0, 0x469b, 0x4ae6, 0x4ecd, 0x521c, 0x5637,
            0x5a4a, 0x5e61, 0x63e8, 0x67c3, 0x6bbe, 0x6f95, 0x7344, 0x776f, 0x7b12, 0x7f39, 0x8560,
            0x814b, 0x8d36, 0x891d, 0x95cc, 0x91e7, 0x9d9a, 0x99b1, 0xa438, 0xa013, 0xac6e, 0xa845,
            0xb494, 0xb0bf, 0xbcc2, 0xb8e9, 0xc7d0, 0xc3fb, 0xcf86, 0xcbad, 0xd77c, 0xd357, 0xdf2a,
            0xdb01, 0xe688, 0xe2a3, 0xeede, 0xeaf5, 0xf624, 0xf20f, 0xfe72, 0xfa59, 0x02d1, 0x06fa,
            0x0a87, 0x0eac, 0x127d, 0x1656, 0x1a2b, 0x1e00, 0x2389, 0x27a2, 0x2bdf, 0x2ff4, 0x3325,
            0x370e, 0x3b73, 0x3f58, 0x4061, 0x444a, 0x4837, 0x4c1c, 0x50cd, 0x54e6, 0x589b, 0x5cb0,
            0x6139, 0x6512, 0x696f, 0x6d44, 0x7195, 0x75be, 0x79c3, 0x7de8, 0x87b1, 0x839a, 0x8fe7,
            0x8bcc, 0x971d, 0x9336, 0x9f4b, 0x9b60, 0xa6e9, 0xa2c2, 0xaebf, 0xaa94, 0xb645, 0xb26e,
            0xbe13, 0xba38, 0xc501, 0xc12a, 0xcd57, 0xc97c, 0xd5ad, 0xd186, 0xddfb, 0xd9d0, 0xe459,
            0xe072, 0xec0f, 0xe824, 0xf4f5, 0xf0de, 0xfca3, 0xf888, 0x05a2, 0x0189, 0x0df4, 0x09df,
            0x150e, 0x1125, 0x1d58, 0x1973, 0x24fa, 0x20d1, 0x2cac, 0x2887, 0x3456, 0x307d, 0x3c00,
            0x382b, 0x4712, 0x4339, 0x4f44, 0x4b6f, 0x57be, 0x5395, 0x5fe8, 0x5bc3, 0x664a, 0x6261,
            0x6e1c, 0x6a37, 0x76e6, 0x72cd, 0x7eb0, 0x7a9b, 0x80c2, 0x84e9, 0x8894, 0x8cbf, 0x906e,
            0x9445, 0x9838, 0x9c13, 0xa19a, 0xa5b1, 0xa9cc, 0xade7, 0xb136, 0xb51d, 0xb960, 0xbd4b,
            0xc272, 0xc659, 0xca24, 0xce0f, 0xd2de, 0xd6f5, 0xda88, 0xdea3, 0xe32a, 0xe701, 0xeb7c,
            0xef57, 0xf386, 0xf7ad, 0xfbd0, 0xfffb, 0x0773, 0x0358, 0x0f25, 0x0b0e, 0x17df, 0x13f4,
            0x1f89, 0x1ba2, 0x262b, 0x2200, 0x2e7d, 0x2a56, 0x3687, 0x32ac, 0x3ed1, 0x3afa, 0x45c3,
            0x41e8, 0x4d95, 0x49be, 0x556f, 0x5144, 0x5d39, 0x5912, 0x649b, 0x60b0, 0x6ccd, 0x68e6,
            0x7437, 0x701c, 0x7c61, 0x784a, 0x8213, 0x8638, 0x8a45, 0x8e6e, 0x92bf, 0x9694, 0x9ae9,
            0x9ec2, 0xa34b, 0xa760, 0xab1d, 0xaf36, 0xb3e7, 0xb7cc, 0xbbb1, 0xbf9a, 0xc0a3, 0xc488,
            0xc8f5, 0xccde, 0xd00f, 0xd424, 0xd859, 0xdc72, 0xe1fb, 0xe5d0, 0xe9ad, 0xed86, 0xf157,
            0xf57c, 0xf901, 0xfd2a,
        ],
        [
            0x0000, 0x9fd5, 0x37bb, 0xa86e, 0x6f76, 0xf0a3, 0x58cd, 0xc718, 0xdeec, 0x4139, 0xe957,
            0x7682, 0xb19a, 0x2e4f, 0x8621, 0x19f4, 0xb5c9, 0x2a1c, 0x8272, 0x1da7, 0xdabf, 0x456a,
            0xed04, 0x72d1, 0x6b25, 0xf4f0, 0x5c9e, 0xc34b, 0x0453, 0x9b86, 0x33e8, 0xac3d, 0x6383,
            0xfc56, 0x5438, 0xcbed, 0x0cf5, 0x9320, 0x3b4e, 0xa49b, 0xbd6f, 0x22ba, 0x8ad4, 0x1501,
            0xd219, 0x4dcc, 0xe5a2, 0x7a77, 0xd64a, 0x499f, 0xe1f1, 0x7e24, 0xb93c, 0x26e9, 0x8e87,
            0x1152, 0x08a6, 0x9773, 0x3f1d, 0xa0c8, 0x67d0, 0xf805, 0x506b, 0xcfbe, 0xc706, 0x58d3,
            0xf0bd, 0x6f68, 0xa870, 0x37a5, 0x9fcb, 0x001e, 0x19ea, 0x863f, 0x2e51, 0xb184, 0x769c,
            0xe949, 0x4127, 0xdef2, 0x72cf, 0xed1a, 0x4574, 0xdaa1, 0x1db9, 0x826c, 0x2a02, 0xb5d7,
            0xac23, 0x33f6, 0x9b98, 0x044d, 0xc355, 0x5c80, 0xf4ee, 0x6b3b, 0xa485, 0x3b50, 0x933e,
            0x0ceb, 0xcbf3, 0x5426, 0xfc48, 0x639d, 0x7a69, 0xe5bc, 0x4dd2, 0xd207, 0x151f, 0x8aca,
            0x22a4, 0xbd71, 0x114c, 0x8e99, 0x26f7, 0xb922, 0x7e3a, 0xe1ef, 0x4981, 0xd654, 0xcfa0,
            0x5075, 0xf81b, 0x67ce, 0xa0d6, 0x3f03, 0x976d, 0x08b8, 0x861d, 0x19c8, 0xb1a6, 0x2e73,
            0xe96b, 0x76be, 0xded0, 0x4105, 0x58f1, 0xc724, 0x6f4a, 0xf09f, 0x3787, 0xa852, 0x003c,
            0x9fe9, 0x33d4, 0xac01, 0x046f, 0x9bba, 0x5ca2, 0xc377, 0x6b19, 0xf4cc, 0xed38, 0x72ed,
            0xda83, 0x4556, 0x824e, 0x1d9b, 0xb5f5, 0x2a20, 0xe59e, 0x7a4b, 0xd225, 0x4df0, 0x8ae8,
            0x153d, 0xbd53, 0x2286, 0x3b72, 0xa4a7, 0x0cc9, 0x931c, 0x5404, 0xcbd1, 0x63bf, 0xfc6a,
            0x5057, 0xcf82, 0x67ec, 0xf839, 0x3f21, 0xa0f4, 0x089a, 0x974f, 0x8ebb, 0x116e, 0xb900,
            0x26d5, 0xe1cd, 0x7e18, 0xd676, 0x49a3, 0x411b, 0xdece, 0x76a0, 0xe975, 0x2e6d, 0xb1b8,
            0x19d6, 0x8603, 0x9ff7, 0x0022, 0xa84c, 0x3799, 0xf081, 0x6f54, 0xc73a, 0x58ef, 0xf4d2,
            0x6b07, 0xc369, 0x5cbc, 0x9ba4, 0x0471, 0xac1f, 0x33ca, 0x2a3e, 0xb5eb, 0x1d85, 0x8250,
            0x4548, 0xda9d, 0x72f3, 0xed26, 0x2298, 0xbd4d, 0x1523, 0x8af6, 0x4dee, 0xd23b, 0x7a55,
            0xe580, 0xfc74, 0x63a1, 0xcbcf, 0x541a, 0x9302, 0x0cd7, 0xa4b9, 0x3b6c, 0x9751, 0x0884,
            0xa0ea, 0x3f3f, 0xf827, 0x67f2, 0xcf9c, 0x5049, 0x49bd, 0xd668, 0x7e06, 0xe1d3, 0x26cb,
            0xb91e, 0x1170, 0x8ea5,
        ],
        [
            0x0000, 0x81bf, 0x0b6f, 0x8ad0, 0x16de, 0x9761, 0x1db1, 0x9c0e, 0x2dbc, 0xac03, 0x26d3,
            0xa76c, 0x3b62, 0xbadd, 0x300d, 0xb1b2, 0x5b78, 0xdac7, 0x5017, 0xd1a8, 0x4da6, 0xcc19,
            0x46c9, 0xc776, 0x76c4, 0xf77b, 0x7dab, 0xfc14, 0x601a, 0xe1a5, 0x6b75, 0xeaca, 0xb6f0,
            0x374f, 0xbd9f, 0x3c20, 0xa02e, 0x2191, 0xab41, 0x2afe, 0x9b4c, 0x1af3, 0x9023, 0x119c,
            0x8d92, 0x0c2d, 0x86fd, 0x0742, 0xed88, 0x6c37, 0xe6e7, 0x6758, 0xfb56, 0x7ae9, 0xf039,
            0x7186, 0xc034, 0x418b, 0xcb5b, 0x4ae4, 0xd6ea, 0x5755, 0xdd85, 0x5c3a, 0x65f1, 0xe44e,
            0x6e9e, 0xef21, 0x732f, 0xf290, 0x7840, 0xf9ff, 0x484d, 0xc9f2, 0x4322, 0xc29d, 0x5e93,
            0xdf2c, 0x55fc, 0xd443, 0x3e89, 0xbf36, 0x35e6, 0xb459, 0x2857, 0xa9e8, 0x2338, 0xa287,
            0x1335, 0x928a, 0x185a, 0x99e5, 0x05eb, 0x8454, 0x0e84, 0x8f3b, 0xd301, 0x52be, 0xd86e,
            0x59d1, 0xc5df, 0x4460, 0xceb0, 0x4f0f, 0xfebd, 0x7f02, 0xf5d2, 0x746d, 0xe863, 0x69dc,
            0xe30c, 0x62b3, 0x8879, 0x09c6, 0x8316, 0x02a9, 0x9ea7, 0x1f18, 0x95c8, 0x1477, 0xa5c5,
            0x247a, 0xaeaa, 0x2f15, 0xb31b, 0x32a4, 0xb874, 0x39cb, 0xcbe2, 0x4a5d, 0xc08d, 0x4132,
            0xdd3c, 0x5c83, 0xd653, 0x57ec, 0xe65e, 0x67e1, 0xed31, 0x6c8e, 0xf080, 0x713f, 0xfbef,
            0x7a50, 0x909a, 0x1125, 0x9bf5, 0x1a4a, 0x8644, 0x07fb, 0x8d2b, 0x0c94, 0xbd26, 0x3c99,
            0xb649, 0x37f6, 0xabf8, 0x2a47, 0xa097, 0x2128, 0x7d12, 0xfcad, 0x767d, 0xf7c2, 0x6bcc,
            0xea73, 0x60a3, 0xe11c, 0x50ae, 0xd111, 0x5bc1, 0xda7e, 0x4670, 0xc7cf, 0x4d1f, 0xcca0,
            0x266a, 0xa7d5, 0x2d05, 0xacba, 0x30b4, 0xb10b, 0x3bdb, 0xba64, 0x0bd6, 0x8a69, 0x00b9,
            0x8106, 0x1d08, 0x9cb7, 0x1667, 0x97d8, 0xae13, 0x2fac, 0xa57c, 0x24c3, 0xb8cd, 0x3972,
            0xb3a2, 0x321d, 0x83af, 0x0210, 0x88c0, 0x097f, 0x9571, 0x14ce, 0x9e1e, 0x1fa1, 0xf56b,
            0x74d4, 0xfe04, 0x7fbb, 0xe3b5, 0x620a, 0xe8da, 0x6965, 0xd8d7, 0x5968, 0xd3b8, 0x5207,
            0xce09, 0x4fb6, 0xc566, 0x44d9, 0x18e3, 0x995c, 0x138c, 0x9233, 0x0e3d, 0x8f82, 0x0552,
            0x84ed, 0x355f, 0xb4e0, 0x3e30, 0xbf8f, 0x2381, 0xa23e, 0x28ee, 0xa951, 0x439b, 0xc224,
            0x48f4, 0xc94b, 0x5545, 0xd4fa, 0x5e2a, 0xdf95, 0x6e27, 0xef98, 0x6548, 0xe4f7, 0x78f9,
            0xf946, 0x7396, 0xf229,
        ],
        [
            0x0000, 0x4dfd, 0x9bfa, 0xd607, 0x3fe5, 0x7218, 0xa41f, 0xe9e2, 0x7fca, 0x3237, 0xe430,
            0xa9cd, 0x402f, 0x0dd2, 0xdbd5, 0x9628, 0xff94, 0xb269, 0x646e, 0x2993, 0xc071, 0x8d8c,
            0x5b8b, 0x1676, 0x805e, 0xcda3, 0x1ba4, 0x5659, 0xbfbb, 0xf246, 0x2441, 0x69bc, 0xf739,
            0xbac4, 0x6cc3, 0x213e, 0xc8dc, 0x8521, 0x5326, 0x1edb, 0x88f3, 0xc50e, 0x1309, 0x5ef4,
            0xb716, 0xfaeb, 0x2cec, 0x6111, 0x08ad, 0x4550, 0x9357, 0xdeaa, 0x3748, 0x7ab5, 0xacb2,
            0xe14f, 0x7767, 0x3a9a, 0xec9d, 0xa160, 0x4882, 0x057f, 0xd378, 0x9e85, 0xe663, 0xab9e,
            0x7d99, 0x3064, 0xd986, 0x947b, 0x427c, 0x0f81, 0x99a9, 0xd454, 0x0253, 0x4fae, 0xa64c,
            0xebb1, 0x3db6, 0x704b, 0x19f7, 0x540a, 0x820d, 0xcff0, 0x2612, 0x6bef, 0xbde8, 0xf015,
            0x663d, 0x2bc0, 0xfdc7, 0xb03a, 0x59d8, 0x1425, 0xc222, 0x8fdf, 0x115a, 0x5ca7, 0x8aa0,
            0xc75d, 0x2ebf, 0x6342, 0xb545, 0xf8b8, 0x6e90, 0x236d, 0xf56a, 0xb897, 0x5175, 0x1c88,
            0xca8f, 0x8772, 0xeece, 0xa333, 0x7534, 0x38c9, 0xd12b, 0x9cd6, 0x4ad1, 0x072c, 0x9104,
            0xdcf9, 0x0afe, 0x4703, 0xaee1, 0xe31c, 0x351b, 0x78e6, 0xc4d7, 0x892a, 0x5f2d, 0x12d0,
            0xfb32, 0xb6cf, 0x60c8, 0x2d35, 0xbb1d, 0xf6e0, 0x20e7, 0x6d1a, 0x84f8, 0xc905, 0x1f02,
            0x52ff, 0x3b43, 0x76be, 0xa0b9, 0xed44, 0x04a6, 0x495b, 0x9f5c, 0xd2a1, 0x4489, 0x0974,
            0xdf73, 0x928e, 0x7b6c, 0x3691, 0xe096, 0xad6b, 0x33ee, 0x7e13, 0xa814, 0xe5e9, 0x0c0b,
            0x41f6, 0x97f1, 0xda0c, 0x4c24, 0x01d9, 0xd7de, 0x9a23, 0x73c1, 0x3e3c, 0xe83b, 0xa5c6,
            0xcc7a, 0x8187, 0x5780, 0x1a7d, 0xf39f, 0xbe62, 0x6865, 0x2598, 0xb3b0, 0xfe4d, 0x284a,
            0x65b7, 0x8c55, 0xc1a8, 0x17af, 0x5a52, 0x22b4, 0x6f49, 0xb94e, 0xf4b3, 0x1d51, 0x50ac,
            0x86ab, 0xcb56, 0x5d7e, 0x1083, 0xc684, 0x8b79, 0x629b, 0x2f66, 0xf961, 0xb49c, 0xdd20,
            0x90dd, 0x46da, 0x0b27, 0xe2c5, 0xaf38, 0x793f, 0x34c2, 0xa2ea, 0xef17, 0x3910, 0x74ed,
            0x9d0f, 0xd0f2, 0x06f5, 0x4b08, 0xd58d, 0x9870, 0x4e77, 0x038a, 0xea68, 0xa795, 0x7192,
            0x3c6f, 0xaa47, 0xe7ba, 0x31bd, 0x7c40, 0x95a2, 0xd85f, 0x0e58, 0x43a5, 0x2a19, 0x67e4,
            0xb1e3, 0xfc1e, 0x15fc, 0x5801, 0x8e06, 0xc3fb, 0x55d3, 0x182e, 0xce29, 0x83d4, 0x6a36,
            0x27cb, 0xf1cc, 0xbc31,
        ],
        [
            0x0000, 0x2c27, 0x584e, 0x7469, 0xb09c, 0x9cbb, 0xe8d2, 0xc4f5, 0x6929, 0x450e, 0x3167,
            0x1d40, 0xd9b5, 0xf592, 0x81fb, 0xaddc, 0xd252, 0xfe75, 0x8a1c, 0xa63b, 0x62ce, 0x4ee9,
            0x3a80, 0x16a7, 0xbb7b, 0x975c, 0xe335, 0xcf12, 0x0be7, 0x27c0, 0x53a9, 0x7f8e, 0xacb5,
            0x8092, 0xf4fb, 0xd8dc, 0x1c29, 0x300e, 0x4467, 0x6840, 0xc59c, 0xe9bb, 0x9dd2, 0xb1f5,
            0x7500, 0x5927, 0x2d4e, 0x0169, 0x7ee7, 0x52c0, 0x26a9, 0x0a8e, 0xce7b, 0xe25c, 0x9635,
            0xba12, 0x17ce, 0x3be9, 0x4f80, 0x63a7, 0xa752, 0x8b75, 0xff1c, 0xd33b, 0x517b, 0x7d5c,
            0x0935, 0x2512, 0xe1e7, 0xcdc0, 0xb9a9, 0x958e, 0x3852, 0x1475, 0x601c, 0x4c3b, 0x88ce,
            0xa4e9, 0xd080, 0xfca7, 0x8329, 0xaf0e, 0xdb67, 0xf740, 0x33b5, 0x1f92, 0x6bfb, 0x47dc,
            0xea00, 0xc627, 0xb24e, 0x9e69, 0x5a9c, 0x76bb, 0x02d2, 0x2ef5, 0xfdce, 0xd1e9, 0xa580,
            0x89a7, 0x4d52, 0x6175, 0x151c, 0x393b, 0x94e7, 0xb8c0, 0xcca9, 0xe08e, 0x247b, 0x085c,
            0x7c35, 0x5012, 0x2f9c, 0x03bb, 0x77d2, 0x5bf5, 0x9f00, 0xb327, 0xc74e, 0xeb69, 0x46b5,
            0x6a92, 0x1efb, 0x32dc, 0xf629, 0xda0e, 0xae67, 0x8240, 0xa2f6, 0x8ed1, 0xfab8, 0xd69f,
            0x126a, 0x3e4d, 0x4a24, 0x6603, 0xcbdf, 0xe7f8, 0x9391, 0xbfb6, 0x7b43, 0x5764, 0x230d,
            0x0f2a, 0x70a4, 0x5c83, 0x28ea, 0x04cd, 0xc038, 0xec1f, 0x9876, 0xb451, 0x198d, 0x35aa,
            0x41c3, 0x6de4, 0xa911, 0x8536, 0xf15f, 0xdd78, 0x0e43, 0x2264, 0x560d, 0x7a2a, 0xbedf,
            0x92f8, 0xe691, 0xcab6, 0x676a, 0x4b4d, 0x3f24, 0x1303, 0xd7f6, 0xfbd1, 0x8fb8, 0xa39f,
            0xdc11, 0xf036, 0x845f, 0xa878, 0x6c8d, 0x40aa, 0x34c3, 0x18e4, 0xb538, 0x991f, 0xed76,
            0xc151, 0x05a4, 0x2983, 0x5dea, 0x71cd, 0xf38d, 0xdfaa, 0xabc3, 0x87e4, 0x4311, 0x6f36,
            0x1b5f, 0x3778, 0x9aa4, 0xb683, 0xc2ea, 0xeecd, 0x2a38, 0x061f, 0x7276, 0x5e51, 0x21df,
            0x0df8, 0x7991, 0x55b6, 0x9143, 0xbd64, 0xc90d, 0xe52a, 0x48f6, 0x64d1, 0x10b8, 0x3c9f,
            0xf86a, 0xd44d, 0xa024, 0x8c03, 0x5f38, 0x731f, 0x0776, 0x2b51, 0xefa4, 0xc383, 0xb7ea,
            0x9bcd, 0x3611, 0x1a36, 0x6e5f, 0x4278, 0x868d, 0xaaaa, 0xdec3, 0xf2e4, 0x8d6a, 0xa14d,
            0xd524, 0xf903, 0x3df6, 0x11d1, 0x65b8, 0x499f, 0xe443, 0xc864, 0xbc0d, 0x902a, 0x54df,
            0x78f8, 0x0c91, 0x20b6,
        ],
        [
            0x0000, 0x5591, 0xab22, 0xfeb3, 0x5e55, 0x0bc4, 0xf577, 0xa0e6, 0xbcaa, 0xe93b, 0x1788,
            0x4219, 0xe2ff, 0xb76e, 0x49dd, 0x1c4c, 0x7145, 0x24d4, 0xda67, 0x8ff6, 0x2f10, 0x7a81,
            0x8432, 0xd1a3, 0xcdef, 0x987e, 0x66cd, 0x335c, 0x93ba, 0xc62b, 0x3898, 0x6d09, 0xe28a,
            0xb71b, 0x49a8, 0x1c39, 0xbcdf, 0xe94e, 0x17fd, 0x426c, 0x5e20, 0x0bb1, 0xf502, 0xa093,
            0x0075, 0x55e4, 0xab57, 0xfec6, 0x93cf, 0xc65e, 0x38ed, 0x6d7c, 0xcd9a, 0x980b, 0x66b8,
            0x3329, 0x2f65, 0x7af4, 0x8447, 0xd1d6, 0x7130, 0x24a1, 0xda12, 0x8f83, 0xcd05, 0x9894,
            0x6627, 0x33b6, 0x9350, 0xc6c1, 0x3872, 0x6de3, 0x71af, 0x243e, 0xda8d, 0x8f1c, 0x2ffa,
            0x7a6b, 0x84d8, 0xd149, 0xbc40, 0xe9d1, 0x1762, 0x42f3, 0xe215, 0xb784, 0x4937, 0x1ca6,
            0x00ea, 0x557b, 0xabc8, 0xfe59, 0x5ebf, 0x0b2e, 0xf59d, 0xa00c, 0x2f8f, 0x7a1e, 0x84ad,
            0xd13c, 0x71da, 0x244b, 0xdaf8, 0x8f69, 0x9325, 0xc6b4, 0x3807, 0x6d96, 0xcd70, 0x98e1,
            0x6652, 0x33c3, 0x5eca, 0x0b5b, 0xf5e8, 0xa079, 0x009f, 0x550e, 0xabbd, 0xfe2c, 0xe260,
            0xb7f1, 0x4942, 0x1cd3, 0xbc35, 0xe9a4, 0x1717, 0x4286, 0x921b, 0xc78a, 0x3939, 0x6ca8,
            0xcc4e, 0x99df, 0x676c, 0x32fd, 0x2eb1, 0x7b20, 0x8593, 0xd002, 0x70e4, 0x2575, 0xdbc6,
            0x8e57, 0xe35e, 0xb6cf, 0x487c, 0x1ded, 0xbd0b, 0xe89a, 0x1629, 0x43b8, 0x5ff4, 0x0a65,
            0xf4d6, 0xa147, 0x01a1, 0x5430, 0xaa83, 0xff12, 0x7091, 0x2500, 0xdbb3, 0x8e22, 0x2ec4,
            0x7b55, 0x85e6, 0xd077, 0xcc3b, 0x99aa, 0x6719, 0x3288, 0x926e, 0xc7ff, 0x394c, 0x6cdd,
            0x01d4, 0x5445, 0xaaf6, 0xff67, 0x5f81, 0x0a10, 0xf4a3, 0xa132, 0xbd7e, 0xe8ef, 0x165c,
            0x43cd, 0xe32b, 0xb6ba, 0x4809, 0x1d98, 0x5f1e, 0x0a8f, 0xf43c, 0xa1ad, 0x014b, 0x54da,
            0xaa69, 0xfff8, 0xe3b4, 0xb625, 0x4896, 0x1d07, 0xbde1, 0xe870, 0x16c3, 0x4352, 0x2e5b,
            0x7bca, 0x8579, 0xd0e8, 0x700e, 0x259f, 0xdb2c, 0x8ebd, 0x92f1, 0xc760, 0x39d3, 0x6c42,
            0xcca4, 0x9935, 0x6786, 0x3217, 0xbd94, 0xe805, 0x16b6, 0x4327, 0xe3c1, 0xb650, 0x48e3,
            0x1d72, 0x013e, 0x54af, 0xaa1c, 0xff8d, 0x5f6b, 0x0afa, 0xf449, 0xa1d8, 0xccd1, 0x9940,
            0x67f3, 0x3262, 0x9284, 0xc715, 0x39a6, 0x6c37, 0x707b, 0x25ea, 0xdb59, 0x8ec8, 0x2e2e,
            0x7bbf, 0x850c, 0xd09d,
        ],
        [
            0x0000, 0x8555, 0x02bb, 0x87ee, 0x0576, 0x8023, 0x07cd, 0x8298, 0x0aec, 0x8fb9, 0x0857,
            0x8d02, 0x0f9a, 0x8acf, 0x0d21, 0x8874, 0x15d8, 0x908d, 0x1763, 0x9236, 0x10ae, 0x95fb,
            0x1215, 0x9740, 0x1f34, 0x9a61, 0x1d8f, 0x98da, 0x1a42, 0x9f17, 0x18f9, 0x9dac, 0x2bb0,
            0xaee5, 0x290b, 0xac5e, 0x2ec6, 0xab93, 0x2c7d, 0xa928, 0x215c, 0xa409, 0x23e7, 0xa6b2,
            0x242a, 0xa17f, 0x2691, 0xa3c4, 0x3e68, 0xbb3d, 0x3cd3, 0xb986, 0x3b1e, 0xbe4b, 0x39a5,
            0xbcf0, 0x3484, 0xb1d1, 0x363f, 0xb36a, 0x31f2, 0xb4a7, 0x3349, 0xb61c, 0x5760, 0xd235,
            0x55db, 0xd08e, 0x5216, 0xd743, 0x50ad, 0xd5f8, 0x5d8c, 0xd8d9, 0x5f37, 0xda62, 0x58fa,
            0xddaf, 0x5a41, 0xdf14, 0x42b8, 0xc7ed, 0x4003, 0xc556, 0x47ce, 0xc29b, 0x4575, 0xc020,
            0x4854, 0xcd01, 0x4aef, 0xcfba, 0x4d22, 0xc877, 0x4f99, 0xcacc, 0x7cd0, 0xf985, 0x7e6b,
            0xfb3e, 0x79a6, 0xfcf3, 0x7b1d, 0xfe48, 0x763c, 0xf369, 0x7487, 0xf1d2, 0x734a, 0xf61f,
            0x71f1, 0xf4a4, 0x6908, 0xec5d, 0x6bb3, 0xeee6, 0x6c7e, 0xe92b, 0x6ec5, 0xeb90, 0x63e4,
            0xe6b1, 0x615f, 0xe40a, 0x6692, 0xe3c7, 0x6429, 0xe17c, 0xaec0, 0x2b95, 0xac7b, 0x292e,
            0xabb6, 0x2ee3, 0xa90d, 0x2c58, 0xa42c, 0x2179, 0xa697, 0x23c2, 0xa15a, 0x240f, 0xa3e1,
            0x26b4, 0xbb18, 0x3e4d, 0xb9a3, 0x3cf6, 0xbe6e, 0x3b3b, 0xbcd5, 0x3980, 0xb1f4, 0x34a1,
            0xb34f, 0x361a, 0xb482, 0x31d7, 0xb639, 0x336c, 0x8570, 0x0025, 0x87cb, 0x029e, 0x8006,
            0x0553, 0x82bd, 0x07e8, 0x8f9c, 0x0ac9, 0x8d27, 0x0872, 0x8aea, 0x0fbf, 0x8851, 0x0d04,
            0x90a8, 0x15fd, 0x9213, 0x1746, 0x95de, 0x108b, 0x9765, 0x1230, 0x9a44, 0x1f11, 0x98ff,
            0x1daa, 0x9f32, 0x1a67, 0x9d89, 0x18dc, 0xf9a0, 0x7cf5, 0xfb1b, 0x7e4e, 0xfcd6, 0x7983,
            0xfe6d, 0x7b38, 0xf34c, 0x7619, 0xf1f7, 0x74a2, 0xf63a, 0x736f, 0xf481, 0x71d4, 0xec78,
            0x692d, 0xeec3, 0x6b96, 0xe90e, 0x6c5b, 0xebb5, 0x6ee0, 0xe694, 0x63c1, 0xe42f, 0x617a,
            0xe3e2, 0x66b7, 0xe159, 0x640c, 0xd210, 0x5745, 0xd0ab, 0x55fe, 0xd766, 0x5233, 0xd5dd,
            0x5088, 0xd8fc, 0x5da9, 0xda47, 0x5f12, 0xdd8a, 0x58df, 0xdf31, 0x5a64, 0xc7c8, 0x429d,
            0xc573, 0x4026, 0xc2be, 0x47eb, 0xc005, 0x4550, 0xcd24, 0x4871, 0xcf9f, 0x4aca, 0xc852,
            0x4d07, 0xcae9, 0x4fbc,
        ],
        [
            0x0000, 0x05ad, 0x0b5a, 0x0ef7, 0x16b4, 0x1319, 0x1dee, 0x1843, 0x2d68, 0x28c5, 0x2632,
            0x239f, 0x3bdc, 0x3e71, 0x3086, 0x352b, 0x5ad0, 0x5f7d, 0x518a, 0x5427, 0x4c64, 0x49c9,
            0x473e, 0x4293, 0x77b8, 0x7215, 0x7ce2, 0x794f, 0x610c, 0x64a1, 0x6a56, 0x6ffb, 0xb5a0,
            0xb00d, 0xbefa, 0xbb57, 0xa314, 0xa6b9, 0xa84e, 0xade3, 0x98c8, 0x9d65, 0x9392, 0x963f,
            0x8e7c, 0x8bd1, 0x8526, 0x808b, 0xef70, 0xeadd, 0xe42a, 0xe187, 0xf9c4, 0xfc69, 0xf29e,
            0xf733, 0xc218, 0xc7b5, 0xc942, 0xccef, 0xd4ac, 0xd101, 0xdff6, 0xda5b, 0x6351, 0x66fc,
            0x680b, 0x6da6, 0x75e5, 0x7048, 0x7ebf, 0x7b12, 0x4e39, 0x4b94, 0x4563, 0x40ce, 0x588d,
            0x5d20, 0x53d7, 0x567a, 0x3981, 0x3c2c, 0x32db, 0x3776, 0x2f35, 0x2a98, 0x246f, 0x21c2,
            0x14e9, 0x1144, 0x1fb3, 0x1a1e, 0x025d, 0x07f0, 0x0907, 0x0caa, 0xd6f1, 0xd35c, 0xddab,
            0xd806, 0xc045, 0xc5e8, 0xcb1f, 0xceb2, 0xfb99, 0xfe34, 0xf0c3, 0xf56e, 0xed2d, 0xe880,
            0xe677, 0xe3da, 0x8c21, 0x898c, 0x877b, 0x82d6, 0x9a95, 0x9f38, 0x91cf, 0x9462, 0xa149,
            0xa4e4, 0xaa13, 0xafbe, 0xb7fd, 0xb250, 0xbca7, 0xb90a, 0xc6a2, 0xc30f, 0xcdf8, 0xc855,
            0xd016, 0xd5bb, 0xdb4c, 0xdee1, 0xebca, 0xee67, 0xe090, 0xe53d, 0xfd7e, 0xf8d3, 0xf624,
            0xf389, 0x9c72, 0x99df, 0x9728, 0x9285, 0x8ac6, 0x8f6b, 0x819c, 0x8431, 0xb11a, 0xb4b7,
            0xba40, 0xbfed, 0xa7ae, 0xa203, 0xacf4, 0xa959, 0x7302, 0x76af, 0x7858, 0x7df5, 0x65b6,
            0x601b, 0x6eec, 0x6b41, 0x5e6a, 0x5bc7, 0x5530, 0x509d, 0x48de, 0x4d73, 0x4384, 0x4629,
            0x29d2, 0x2c7f, 0x2288, 0x2725, 0x3f66, 0x3acb, 0x343c, 0x3191, 0x04ba, 0x0117, 0x0fe0,
            0x0a4d, 0x120e, 0x17a3, 0x1954, 0x1cf9, 0xa5f3, 0xa05e, 0xaea9, 0xab04, 0xb347, 0xb6ea,
            0xb81d, 0xbdb0, 0x889b, 0x8d36, 0x83c1, 0x866c, 0x9e2f, 0x9b82, 0x9575, 0x90d8, 0xff23,
            0xfa8e, 0xf479, 0xf1d4, 0xe997, 0xec3a, 0xe2cd, 0xe760, 0xd24b, 0xd7e6, 0xd911, 0xdcbc,
            0xc4ff, 0xc152, 0xcfa5, 0xca08, 0x1053, 0x15fe, 0x1b09, 0x1ea4, 0x06e7, 0x034a, 0x0dbd,
            0x0810, 0x3d3b, 0x3896, 0x3661, 0x33cc, 0x2b8f, 0x2e22, 0x20d5, 0x2578, 0x4a83, 0x4f2e,
            0x41d9, 0x4474, 0x5c37, 0x599a, 0x576d, 0x52c0, 0x67eb, 0x6246, 0x6cb1, 0x691c, 0x715f,
            0x74f2, 0x7a05, 0x7fa8,
        ],
        [
            0x0000, 0x7eea, 0xfdd4, 0x833e, 0xf3b9, 0x8d53, 0x0e6d, 0x7087, 0xef63, 0x9189, 0x12b7,
            0x6c5d, 0x1cda, 0x6230, 0xe10e, 0x9fe4, 0xd6d7, 0xa83d, 0x2b03, 0x55e9, 0x256e, 0x5b84,
            0xd8ba, 0xa650, 0x39b4, 0x475e, 0xc460, 0xba8a, 0xca0d, 0xb4e7, 0x37d9, 0x4933, 0xa5bf,
            0xdb55, 0x586b, 0x2681, 0x5606, 0x28ec, 0xabd2, 0xd538, 0x4adc, 0x3436, 0xb708, 0xc9e2,
            0xb965, 0xc78f, 0x44b1, 0x3a5b, 0x7368, 0x0d82, 0x8ebc, 0xf056, 0x80d1, 0xfe3b, 0x7d05,
            0x03ef, 0x9c0b, 0xe2e1, 0x61df, 0x1f35, 0x6fb2, 0x1158, 0x9266, 0xec8c, 0x436f, 0x3d85,
            0xbebb, 0xc051, 0xb0d6, 0xce3c, 0x4d02, 0x33e8, 0xac0c, 0xd2e6, 0x51d8, 0x2f32, 0x5fb5,
            0x215f, 0xa261, 0xdc8b, 0x95b8, 0xeb52, 0x686c, 0x1686, 0x6601, 0x18eb, 0x9bd5, 0xe53f,
            0x7adb, 0x0431, 0x870f, 0xf9e5, 0x8962, 0xf788, 0x74b6, 0x0a5c, 0xe6d0, 0x983a, 0x1b04,
            0x65ee, 0x1569, 0x6b83, 0xe8bd, 0x9657, 0x09b3, 0x7759, 0xf467, 0x8a8d, 0xfa0a, 0x84e0,
            0x07de, 0x7934, 0x3007, 0x4eed, 0xcdd3, 0xb339, 0xc3be, 0xbd54, 0x3e6a, 0x4080, 0xdf64,
            0xa18e, 0x22b0, 0x5c5a, 0x2cdd, 0x5237, 0xd109, 0xafe3, 0x86de, 0xf834, 0x7b0a, 0x05e0,
            0x7567, 0x0b8d, 0x88b3, 0xf659, 0x69bd, 0x1757, 0x9469, 0xea83, 0x9a04, 0xe4ee, 0x67d0,
            0x193a, 0x5009, 0x2ee3, 0xaddd, 0xd337, 0xa3b0, 0xdd5a, 0x5e64, 0x208e, 0xbf6a, 0xc180,
            0x42be, 0x3c54, 0x4cd3, 0x3239, 0xb107, 0xcfed, 0x2361, 0x5d8b, 0xdeb5, 0xa05f, 0xd0d8,
            0xae32, 0x2d0c, 0x53e6, 0xcc02, 0xb2e8, 0x31d6, 0x4f3c, 0x3fbb, 0x4151, 0xc26f, 0xbc85,
            0xf5b6, 0x8b5c, 0x0862, 0x7688, 0x060f, 0x78e5, 0xfbdb, 0x8531, 0x1ad5, 0x643f, 0xe701,
            0x99eb, 0xe96c, 0x9786, 0x14b8, 0x6a52, 0xc5b1, 0xbb5b, 0x3865, 0x468f, 0x3608, 0x48e2,
            0xcbdc, 0xb536, 0x2ad2, 0x5438, 0xd706, 0xa9ec, 0xd96b, 0xa781, 0x24bf, 0x5a55, 0x1366,
            0x6d8c, 0xeeb2, 0x9058, 0xe0df, 0x9e35, 0x1d0b, 0x63e1, 0xfc05, 0x82ef, 0x01d1, 0x7f3b,
            0x0fbc, 0x7156, 0xf268, 0x8c82, 0x600e, 0x1ee4, 0x9dda, 0xe330, 0x93b7, 0xed5d, 0x6e63,
            0x1089, 0x8f6d, 0xf187, 0x72b9, 0x0c53, 0x7cd4, 0x023e, 0x8100, 0xffea, 0xb6d9, 0xc833,
            0x4b0d, 0x35e7, 0x4560, 0x3b8a, 0xb8b4, 0xc65e, 0x59ba, 0x2750, 0xa46e, 0xda84, 0xaa03,
            0xd4e9, 0x57d7, 0x293d,
        ],
        [
            0x0000, 0x482a, 0x9054, 0xd87e, 0x28b9, 0x6093, 0xb8ed, 0xf0c7, 0x5172, 0x1958, 0xc126,
            0x890c, 0x79cb, 0x31e1, 0xe99f, 0xa1b5, 0xa2e4, 0xeace, 0x32b0, 0x7a9a, 0x8a5d, 0xc277,
            0x1a09, 0x5223, 0xf396, 0xbbbc, 0x63c2, 0x2be8, 0xdb2f, 0x9305, 0x4b7b, 0x0351, 0x4dd9,
            0x05f3, 0xdd8d, 0x95a7, 0x6560, 0x2d4a, 0xf534, 0xbd1e, 0x1cab, 0x5481, 0x8cff, 0xc4d5,
            0x3412, 0x7c38, 0xa446, 0xec6c, 0xef3d, 0xa717, 0x7f69, 0x3743, 0xc784, 0x8fae, 0x57d0,
            0x1ffa, 0xbe4f, 0xf665, 0x2e1b, 0x6631, 0x96f6, 0xdedc, 0x06a2, 0x4e88, 0x9bb2, 0xd398,
            0x0be6, 0x43cc, 0xb30b, 0xfb21, 0x235f, 0x6b75, 0xcac0, 0x82ea, 0x5a94, 0x12be, 0xe279,
            0xaa53, 0x722d, 0x3a07, 0x3956, 0x717c, 0xa902, 0xe128, 0x11ef, 0x59c5, 0x81bb, 0xc991,
            0x6824, 0x200e, 0xf870, 0xb05a, 0x409d, 0x08b7, 0xd0c9, 0x98e3, 0xd66b, 0x9e41, 0x463f,
            0x0e15, 0xfed2, 0xb6f8, 0x6e86, 0x26ac, 0x8719, 0xcf33, 0x174d, 0x5f67, 0xafa0, 0xe78a,
            0x3ff4, 0x77de, 0x748f, 0x3ca5, 0xe4db, 0xacf1, 0x5c36, 0x141c, 0xcc62, 0x8448, 0x25fd,
            0x6dd7, 0xb5a9, 0xfd83, 0x0d44, 0x456e, 0x9d10, 0xd53a, 0x3f75, 0x775f, 0xaf21, 0xe70b,
            0x17cc, 0x5fe6, 0x8798, 0xcfb2, 0x6e07, 0x262d, 0xfe53, 0xb679, 0x46be, 0x0e94, 0xd6ea,
            0x9ec0, 0x9d91, 0xd5bb, 0x0dc5, 0x45ef, 0xb528, 0xfd02, 0x257c, 0x6d56, 0xcce3, 0x84c9,
            0x5cb7, 0x149d, 0xe45a, 0xac70, 0x740e, 0x3c24, 0x72ac, 0x3a86, 0xe2f8, 0xaad2, 0x5a15,
            0x123f, 0xca41, 0x826b, 0x23de, 0x6bf4, 0xb38a, 0xfba0, 0x0b67, 0x434d, 0x9b33, 0xd319,
            0xd048, 0x9862, 0x401c, 0x0836, 0xf8f1, 0xb0db, 0x68a5, 0x208f, 0x813a, 0xc910, 0x116e,
            0x5944, 0xa983, 0xe1a9, 0x39d7, 0x71fd, 0xa4c7, 0xeced, 0x3493, 0x7cb9, 0x8c7e, 0xc454,
            0x1c2a, 0x5400, 0xf5b5, 0xbd9f, 0x65e1, 0x2dcb, 0xdd0c, 0x9526, 0x4d58, 0x0572, 0x0623,
            0x4e09, 0x9677, 0xde5d, 0x2e9a, 0x66b0, 0xbece, 0xf6e4, 0x5751, 0x1f7b, 0xc705, 0x8f2f,
            0x7fe8, 0x37c2, 0xefbc, 0xa796, 0xe91e, 0xa134, 0x794a, 0x3160, 0xc1a7, 0x898d, 0x51f3,
            0x19d9, 0xb86c, 0xf046, 0x2838, 0x6012, 0x90d5, 0xd8ff, 0x0081, 0x48ab, 0x4bfa, 0x03d0,
            0xdbae, 0x9384, 0x6343, 0x2b69, 0xf317, 0xbb3d, 0x1a88, 0x52a2, 0x8adc, 0xc2f6, 0x3231,
            0x7a1b, 0xa265, 0xea4f,
        ],
        [
            0x0000, 0x8e10, 0x1431, 0x9a21, 0x2862, 0xa672, 0x3c53, 0xb243, 0x50c4, 0xded4, 0x44f5,
            0xcae5, 0x78a6, 0xf6b6, 0x6c97, 0xe287, 0xa188, 0x2f98, 0xb5b9, 0x3ba9, 0x89ea, 0x07fa,
            0x9ddb, 0x13cb, 0xf14c, 0x7f5c, 0xe57d, 0x6b6d, 0xd92e, 0x573e, 0xcd1f, 0x430f, 0x4b01,
            0xc511, 0x5f30, 0xd120, 0x6363, 0xed73, 0x7752, 0xf942, 0x1bc5, 0x95d5, 0x0ff4, 0x81e4,
            0x33a7, 0xbdb7, 0x2796, 0xa986, 0xea89, 0x6499, 0xfeb8, 0x70a8, 0xc2eb, 0x4cfb, 0xd6da,
            0x58ca, 0xba4d, 0x345d, 0xae7c, 0x206c, 0x922f, 0x1c3f, 0x861e, 0x080e, 0x9602, 0x1812,
            0x8233, 0x0c23, 0xbe60, 0x3070, 0xaa51, 0x2441, 0xc6c6, 0x48d6, 0xd2f7, 0x5ce7, 0xeea4,
            0x60b4, 0xfa95, 0x7485, 0x378a, 0xb99a, 0x23bb, 0xadab, 0x1fe8, 0x91f8, 0x0bd9, 0x85c9,
            0x674e, 0xe95e, 0x737f, 0xfd6f, 0x4f2c, 0xc13c, 0x5b1d, 0xd50d, 0xdd03, 0x5313, 0xc932,
            0x4722, 0xf561, 0x7b71, 0xe150, 0x6f40, 0x8dc7, 0x03d7, 0x99f6, 0x17e6, 0xa5a5, 0x2bb5,
            0xb194, 0x3f84, 0x7c8b, 0xf29b, 0x68ba, 0xe6aa, 0x54e9, 0xdaf9, 0x40d8, 0xcec8, 0x2c4f,
            0xa25f, 0x387e, 0xb66e, 0x042d, 0x8a3d, 0x101c, 0x9e0c, 0x2415, 0xaa05, 0x3024, 0xbe34,
            0x0c77, 0x8267, 0x1846, 0x9656, 0x74d1, 0xfac1, 0x60e0, 0xeef0, 0x5cb3, 0xd2a3, 0x4882,
            0xc692, 0x859d, 0x0b8d, 0x91ac, 0x1fbc, 0xadff, 0x23ef, 0xb9ce, 0x37de, 0xd559, 0x5b49,
            0xc168, 0x4f78, 0xfd3b, 0x732b, 0xe90a, 0x671a, 0x6f14, 0xe104, 0x7b25, 0xf535, 0x4776,
            0xc966, 0x5347, 0xdd57, 0x3fd0, 0xb1c0, 0x2be1, 0xa5f1, 0x17b2, 0x99a2, 0x0383, 0x8d93,
            0xce9c, 0x408c, 0xdaad, 0x54bd, 0xe6fe, 0x68ee, 0xf2cf, 0x7cdf, 0x9e58, 0x1048, 0x8a69,
            0x0479, 0xb63a, 0x382a, 0xa20b, 0x2c1b, 0xb217, 0x3c07, 0xa626, 0x2836, 0x9a75, 0x1465,
            0x8e44, 0x0054, 0xe2d3, 0x6cc3, 0xf6e2, 0x78f2, 0xcab1, 0x44a1, 0xde80, 0x5090, 0x139f,
            0x9d8f, 0x07ae, 0x89be, 0x3bfd, 0xb5ed, 0x2fcc, 0xa1dc, 0x435b, 0xcd4b, 0x576a, 0xd97a,
            0x6b39, 0xe529, 0x7f08, 0xf118, 0xf916, 0x7706, 0xed27, 0x6337, 0xd174, 0x5f64, 0xc545,
            0x4b55, 0xa9d2, 0x27c2, 0xbde3, 0x33f3, 0x81b0, 0x0fa0, 0x9581, 0x1b91, 0x589e, 0xd68e,
            0x4caf, 0xc2bf, 0x70fc, 0xfeec, 0x64cd, 0xeadd, 0x085a, 0x864a, 0x1c6b, 0x927b, 0x2038,
            0xae28, 0x3409, 0xba19,
        ],
    ];

    pub static CRC16_ISO_IEC_14443_3_A_TABLE: [[u16; 256]; 16] = [
        [
            0x0000, 0x1189, 0x2312, 0x329b, 0x4624, 0x57ad, 0x6536, 0x74bf, 0x8c48, 0x9dc1, 0xaf5a,
            0xbed3, 0xca6c, 0xdbe5, 0xe97e, 0xf8f7, 0x1081, 0x0108, 0x3393, 0x221a, 0x56a5, 0x472c,
            0x75b7, 0x643e, 0x9cc9, 0x8d40, 0xbfdb, 0xae52, 0xdaed, 0xcb64, 0xf9ff, 0xe876, 0x2102,
            0x308b, 0x0210, 0x1399, 0x6726, 0x76af, 0x4434, 0x55bd, 0xad4a, 0xbcc3, 0x8e58, 0x9fd1,
            0xeb6e, 0xfae7, 0xc87c, 0xd9f5, 0x3183, 0x200a, 0x1291, 0x0318, 0x77a7, 0x662e, 0x54b5,
            0x453c, 0xbdcb, 0xac42, 0x9ed9, 0x8f50, 0xfbef, 0xea66, 0xd8fd, 0xc974, 0x4204, 0x538d,
            0x6116, 0x709f, 0x0420, 0x15a9, 0x2732, 0x36bb, 0xce4c, 0xdfc5, 0xed5e, 0xfcd7, 0x8868,
            0x99e1, 0xab7a, 0xbaf3, 0x5285, 0x430c, 0x7197, 0x601e, 0x14a1, 0x0528, 0x37b3, 0x263a,
            0xdecd, 0xcf44, 0xfddf, 0xec56, 0x98e9, 0x8960, 0xbbfb, 0xaa72, 0x6306, 0x728f, 0x4014,
            0x519d, 0x2522, 0x34ab, 0x0630, 0x17b9, 0xef4e, 0xfec7, 0xcc5c, 0xddd5, 0xa96a, 0xb8e3,
            0x8a78, 0x9bf1, 0x7387, 0x620e, 0x5095, 0x411c, 0x35a3, 0x242a, 0x16b1, 0x0738, 0xffcf,
            0xee46, 0xdcdd, 0xcd54, 0xb9eb, 0xa862, 0x9af9, 0x8b70, 0x8408, 0x9581, 0xa71a, 0xb693,
            0xc22c, 0xd3a5, 0xe13e, 0xf0b7, 0x0840, 0x19c9, 0x2b52, 0x3adb, 0x4e64, 0x5fed, 0x6d76,
            0x7cff, 0x9489, 0x8500, 0xb79b, 0xa612, 0xd2ad, 0xc324, 0xf1bf, 0xe036, 0x18c1, 0x0948,
            0x3bd3, 0x2a5a, 0x5ee5, 0x4f6c, 0x7df7, 0x6c7e, 0xa50a, 0xb483, 0x8618, 0x9791, 0xe32e,
            0xf2a7, 0xc03c, 0xd1b5, 0x2942, 0x38cb, 0x0a50, 0x1bd9, 0x6f66, 0x7eef, 0x4c74, 0x5dfd,
            0xb58b, 0xa402, 0x9699, 0x8710, 0xf3af, 0xe226, 0xd0bd, 0xc134, 0x39c3, 0x284a, 0x1ad1,
            0x0b58, 0x7fe7, 0x6e6e, 0x5cf5, 0x4d7c, 0xc60c, 0xd785, 0xe51e, 0xf497, 0x8028, 0x91a1,
            0xa33a, 0xb2b3, 0x4a44, 0x5bcd, 0x6956, 0x78df, 0x0c60, 0x1de9, 0x2f72, 0x3efb, 0xd68d,
            0xc704, 0xf59f, 0xe416, 0x90a9, 0x8120, 0xb3bb, 0xa232, 0x5ac5, 0x4b4c, 0x79d7, 0x685e,
            0x1ce1, 0x0d68, 0x3ff3, 0x2e7a, 0xe70e, 0xf687, 0xc41c, 0xd595, 0xa12a, 0xb0a3, 0x8238,
            0x93b1, 0x6b46, 0x7acf, 0x4854, 0x59dd, 0x2d62, 0x3ceb, 0x0e70, 0x1ff9, 0xf78f, 0xe606,
            0xd49d, 0xc514, 0xb1ab, 0xa022, 0x92b9, 0x8330, 0x7bc7, 0x6a4e, 0x58d5, 0x495c, 0x3de3,
            0x2c6a, 0x1ef1, 0x0f78,
        ],
        [
            0x0000, 0x19d8, 0x33b0, 0x2a68, 0x6760, 0x7eb8, 0x54d0, 0x4d08, 0xcec0, 0xd718, 0xfd70,
            0xe4a8, 0xa9a0, 0xb078, 0x9a10, 0x83c8, 0x9591, 0x8c49, 0xa621, 0xbff9, 0xf2f1, 0xeb29,
            0xc141, 0xd899, 0x5b51, 0x4289, 0x68e1, 0x7139, 0x3c31, 0x25e9, 0x0f81, 0x1659, 0x2333,
            0x3aeb, 0x1083, 0x095b, 0x4453, 0x5d8b, 0x77e3, 0x6e3b, 0xedf3, 0xf42b, 0xde43, 0xc79b,
            0x8a93, 0x934b, 0xb923, 0xa0fb, 0xb6a2, 0xaf7a, 0x8512, 0x9cca, 0xd1c2, 0xc81a, 0xe272,
            0xfbaa, 0x7862, 0x61ba, 0x4bd2, 0x520a, 0x1f02, 0x06da, 0x2cb2, 0x356a, 0x4666, 0x5fbe,
            0x75d6, 0x6c0e, 0x2106, 0x38de, 0x12b6, 0x0b6e, 0x88a6, 0x917e, 0xbb16, 0xa2ce, 0xefc6,
            0xf61e, 0xdc76, 0xc5ae, 0xd3f7, 0xca2f, 0xe047, 0xf99f, 0xb497, 0xad4f, 0x8727, 0x9eff,
            0x1d37, 0x04ef, 0x2e87, 0x375f, 0x7a57, 0x638f, 0x49e7, 0x503f, 0x6555, 0x7c8d, 0x56e5,
            0x4f3d, 0x0235, 0x1bed, 0x3185, 0x285d, 0xab95, 0xb24d, 0x9825, 0x81fd, 0xccf5, 0xd52d,
            0xff45, 0xe69d, 0xf0c4, 0xe91c, 0xc374, 0xdaac, 0x97a4, 0x8e7c, 0xa414, 0xbdcc, 0x3e04,
            0x27dc, 0x0db4, 0x146c, 0x5964, 0x40bc, 0x6ad4, 0x730c, 0x8ccc, 0x9514, 0xbf7c, 0xa6a4,
            0xebac, 0xf274, 0xd81c, 0xc1c4, 0x420c, 0x5bd4, 0x71bc, 0x6864, 0x256c, 0x3cb4, 0x16dc,
            0x0f04, 0x195d, 0x0085, 0x2aed, 0x3335, 0x7e3d, 0x67e5, 0x4d8d, 0x5455, 0xd79d, 0xce45,
            0xe42d, 0xfdf5, 0xb0fd, 0xa925, 0x834d, 0x9a95, 0xafff, 0xb627, 0x9c4f, 0x8597, 0xc89f,
            0xd147, 0xfb2f, 0xe2f7, 0x613f, 0x78e7, 0x528f, 0x4b57, 0x065f, 0x1f87, 0x35ef, 0x2c37,
            0x3a6e, 0x23b6, 0x09de, 0x1006, 0x5d0e, 0x44d6, 0x6ebe, 0x7766, 0xf4ae, 0xed76, 0xc71e,
            0xdec6, 0x93ce, 0x8a16, 0xa07e, 0xb9a6, 0xcaaa, 0xd372, 0xf91a, 0xe0c2, 0xadca, 0xb412,
            0x9e7a, 0x87a2, 0x046a, 0x1db2, 0x37da, 0x2e02, 0x630a, 0x7ad2, 0x50ba, 0x4962, 0x5f3b,
            0x46e3, 0x6c8b, 0x7553, 0x385b, 0x2183, 0x0beb, 0x1233, 0x91fb, 0x8823, 0xa24b, 0xbb93,
            0xf69b, 0xef43, 0xc52b, 0xdcf3, 0xe999, 0xf041, 0xda29, 0xc3f1, 0x8ef9, 0x9721, 0xbd49,
            0xa491, 0x2759, 0x3e81, 0x14e9, 0x0d31, 0x4039, 0x59e1, 0x7389, 0x6a51, 0x7c08, 0x65d0,
            0x4fb8, 0x5660, 0x1b68, 0x02b0, 0x28d8, 0x3100, 0xb2c8, 0xab10, 0x8178, 0x98a0, 0xd5a8,
            0xcc70, 0xe618, 0xffc0,
        ],
        [
            0x0000, 0x5adc, 0xb5b8, 0xef64, 0x6361, 0x39bd, 0xd6d9, 0x8c05, 0xc6c2, 0x9c1e, 0x737a,
            0x29a6, 0xa5a3, 0xff7f, 0x101b, 0x4ac7, 0x8595, 0xdf49, 0x302d, 0x6af1, 0xe6f4, 0xbc28,
            0x534c, 0x0990, 0x4357, 0x198b, 0xf6ef, 0xac33, 0x2036, 0x7aea, 0x958e, 0xcf52, 0x033b,
            0x59e7, 0xb683, 0xec5f, 0x605a, 0x3a86, 0xd5e2, 0x8f3e, 0xc5f9, 0x9f25, 0x7041, 0x2a9d,
            0xa698, 0xfc44, 0x1320, 0x49fc, 0x86ae, 0xdc72, 0x3316, 0x69ca, 0xe5cf, 0xbf13, 0x5077,
            0x0aab, 0x406c, 0x1ab0, 0xf5d4, 0xaf08, 0x230d, 0x79d1, 0x96b5, 0xcc69, 0x0676, 0x5caa,
            0xb3ce, 0xe912, 0x6517, 0x3fcb, 0xd0af, 0x8a73, 0xc0b4, 0x9a68, 0x750c, 0x2fd0, 0xa3d5,
            0xf909, 0x166d, 0x4cb1, 0x83e3, 0xd93f, 0x365b, 0x6c87, 0xe082, 0xba5e, 0x553a, 0x0fe6,
            0x4521, 0x1ffd, 0xf099, 0xaa45, 0x2640, 0x7c9c, 0x93f8, 0xc924, 0x054d, 0x5f91, 0xb0f5,
            0xea29, 0x662c, 0x3cf0, 0xd394, 0x8948, 0xc38f, 0x9953, 0x7637, 0x2ceb, 0xa0ee, 0xfa32,
            0x1556, 0x4f8a, 0x80d8, 0xda04, 0x3560, 0x6fbc, 0xe3b9, 0xb965, 0x5601, 0x0cdd, 0x461a,
            0x1cc6, 0xf3a2, 0xa97e, 0x257b, 0x7fa7, 0x90c3, 0xca1f, 0x0cec, 0x5630, 0xb954, 0xe388,
            0x6f8d, 0x3551, 0xda35, 0x80e9, 0xca2e, 0x90f2, 0x7f96, 0x254a, 0xa94f, 0xf393, 0x1cf7,
            0x462b, 0x8979, 0xd3a5, 0x3cc1, 0x661d, 0xea18, 0xb0c4, 0x5fa0, 0x057c, 0x4fbb, 0x1567,
            0xfa03, 0xa0df, 0x2cda, 0x7606, 0x9962, 0xc3be, 0x0fd7, 0x550b, 0xba6f, 0xe0b3, 0x6cb6,
            0x366a, 0xd90e, 0x83d2, 0xc915, 0x93c9, 0x7cad, 0x2671, 0xaa74, 0xf0a8, 0x1fcc, 0x4510,
            0x8a42, 0xd09e, 0x3ffa, 0x6526, 0xe923, 0xb3ff, 0x5c9b, 0x0647, 0x4c80, 0x165c, 0xf938,
            0xa3e4, 0x2fe1, 0x753d, 0x9a59, 0xc085, 0x0a9a, 0x5046, 0xbf22, 0xe5fe, 0x69fb, 0x3327,
            0xdc43, 0x869f, 0xcc58, 0x9684, 0x79e0, 0x233c, 0xaf39, 0xf5e5, 0x1a81, 0x405d, 0x8f0f,
            0xd5d3, 0x3ab7, 0x606b, 0xec6e, 0xb6b2, 0x59d6, 0x030a, 0x49cd, 0x1311, 0xfc75, 0xa6a9,
            0x2aac, 0x7070, 0x9f14, 0xc5c8, 0x09a1, 0x537d, 0xbc19, 0xe6c5, 0x6ac0, 0x301c, 0xdf78,
            0x85a4, 0xcf63, 0x95bf, 0x7adb, 0x2007, 0xac02, 0xf6de, 0x19ba, 0x4366, 0x8c34, 0xd6e8,
            0x398c, 0x6350, 0xef55, 0xb589, 0x5aed, 0x0031, 0x4af6, 0x102a, 0xff4e, 0xa592, 0x2997,
            0x734b, 0x9c2f, 0xc6f3,
        ],
        [
            0x0000, 0x1cbb, 0x3976, 0x25cd, 0x72ec, 0x6e57, 0x4b9a, 0x5721, 0xe5d8, 0xf963, 0xdcae,
            0xc015, 0x9734, 0x8b8f, 0xae42, 0xb2f9, 0xc3a1, 0xdf1a, 0xfad7, 0xe66c, 0xb14d, 0xadf6,
            0x883b, 0x9480, 0x2679, 0x3ac2, 0x1f0f, 0x03b4, 0x5495, 0x482e, 0x6de3, 0x7158, 0x8f53,
            0x93e8, 0xb625, 0xaa9e, 0xfdbf, 0xe104, 0xc4c9, 0xd872, 0x6a8b, 0x7630, 0x53fd, 0x4f46,
            0x1867, 0x04dc, 0x2111, 0x3daa, 0x4cf2, 0x5049, 0x7584, 0x693f, 0x3e1e, 0x22a5, 0x0768,
            0x1bd3, 0xa92a, 0xb591, 0x905c, 0x8ce7, 0xdbc6, 0xc77d, 0xe2b0, 0xfe0b, 0x16b7, 0x0a0c,
            0x2fc1, 0x337a, 0x645b, 0x78e0, 0x5d2d, 0x4196, 0xf36f, 0xefd4, 0xca19, 0xd6a2, 0x8183,
            0x9d38, 0xb8f5, 0xa44e, 0xd516, 0xc9ad, 0xec60, 0xf0db, 0xa7fa, 0xbb41, 0x9e8c, 0x8237,
            0x30ce, 0x2c75, 0x09b8, 0x1503, 0x4222, 0x5e99, 0x7b54, 0x67ef, 0x99e4, 0x855f, 0xa092,
            0xbc29, 0xeb08, 0xf7b3, 0xd27e, 0xcec5, 0x7c3c, 0x6087, 0x454a, 0x59f1, 0x0ed0, 0x126b,
            0x37a6, 0x2b1d, 0x5a45, 0x46fe, 0x6333, 0x7f88, 0x28a9, 0x3412, 0x11df, 0x0d64, 0xbf9d,
            0xa326, 0x86eb, 0x9a50, 0xcd71, 0xd1ca, 0xf407, 0xe8bc, 0x2d6e, 0x31d5, 0x1418, 0x08a3,
            0x5f82, 0x4339, 0x66f4, 0x7a4f, 0xc8b6, 0xd40d, 0xf1c0, 0xed7b, 0xba5a, 0xa6e1, 0x832c,
            0x9f97, 0xeecf, 0xf274, 0xd7b9, 0xcb02, 0x9c23, 0x8098, 0xa555, 0xb9ee, 0x0b17, 0x17ac,
            0x3261, 0x2eda, 0x79fb, 0x6540, 0x408d, 0x5c36, 0xa23d, 0xbe86, 0x9b4b, 0x87f0, 0xd0d1,
            0xcc6a, 0xe9a7, 0xf51c, 0x47e5, 0x5b5e, 0x7e93, 0x6228, 0x3509, 0x29b2, 0x0c7f, 0x10c4,
            0x619c, 0x7d27, 0x58ea, 0x4451, 0x1370, 0x0fcb, 0x2a06, 0x36bd, 0x8444, 0x98ff, 0xbd32,
            0xa189, 0xf6a8, 0xea13, 0xcfde, 0xd365, 0x3bd9, 0x2762, 0x02af, 0x1e14, 0x4935, 0x558e,
            0x7043, 0x6cf8, 0xde01, 0xc2ba, 0xe777, 0xfbcc, 0xaced, 0xb056, 0x959b, 0x8920, 0xf878,
            0xe4c3, 0xc10e, 0xddb5, 0x8a94, 0x962f, 0xb3e2, 0xaf59, 0x1da0, 0x011b, 0x24d6, 0x386d,
            0x6f4c, 0x73f7, 0x563a, 0x4a81, 0xb48a, 0xa831, 0x8dfc, 0x9147, 0xc666, 0xdadd, 0xff10,
            0xe3ab, 0x5152, 0x4de9, 0x6824, 0x749f, 0x23be, 0x3f05, 0x1ac8, 0x0673, 0x772b, 0x6b90,
            0x4e5d, 0x52e6, 0x05c7, 0x197c, 0x3cb1, 0x200a, 0x92f3, 0x8e48, 0xab85, 0xb73e, 0xe01f,
            0xfca4, 0xd969, 0xc5d2,
        ],
        [
            0x0000, 0x0b44, 0x1688, 0x1dcc, 0x2d10, 0x2654, 0x3b98, 0x30dc, 0x5a20, 0x5164, 0x4ca8,
            0x47ec, 0x7730, 0x7c74, 0x61b8, 0x6afc, 0xb440, 0xbf04, 0xa2c8, 0xa98c, 0x9950, 0x9214,
            0x8fd8, 0x849c, 0xee60, 0xe524, 0xf8e8, 0xf3ac, 0xc370, 0xc834, 0xd5f8, 0xdebc, 0x6091,
            0x6bd5, 0x7619, 0x7d5d, 0x4d81, 0x46c5, 0x5b09, 0x504d, 0x3ab1, 0x31f5, 0x2c39, 0x277d,
            0x17a1, 0x1ce5, 0x0129, 0x0a6d, 0xd4d1, 0xdf95, 0xc259, 0xc91d, 0xf9c1, 0xf285, 0xef49,
            0xe40d, 0x8ef1, 0x85b5, 0x9879, 0x933d, 0xa3e1, 0xa8a5, 0xb569, 0xbe2d, 0xc122, 0xca66,
            0xd7aa, 0xdcee, 0xec32, 0xe776, 0xfaba, 0xf1fe, 0x9b02, 0x9046, 0x8d8a, 0x86ce, 0xb612,
            0xbd56, 0xa09a, 0xabde, 0x7562, 0x7e26, 0x63ea, 0x68ae, 0x5872, 0x5336, 0x4efa, 0x45be,
            0x2f42, 0x2406, 0x39ca, 0x328e, 0x0252, 0x0916, 0x14da, 0x1f9e, 0xa1b3, 0xaaf7, 0xb73b,
            0xbc7f, 0x8ca3, 0x87e7, 0x9a2b, 0x916f, 0xfb93, 0xf0d7, 0xed1b, 0xe65f, 0xd683, 0xddc7,
            0xc00b, 0xcb4f, 0x15f3, 0x1eb7, 0x037b, 0x083f, 0x38e3, 0x33a7, 0x2e6b, 0x252f, 0x4fd3,
            0x4497, 0x595b, 0x521f, 0x62c3, 0x6987, 0x744b, 0x7f0f, 0x8a55, 0x8111, 0x9cdd, 0x9799,
            0xa745, 0xac01, 0xb1cd, 0xba89, 0xd075, 0xdb31, 0xc6fd, 0xcdb9, 0xfd65, 0xf621, 0xebed,
            0xe0a9, 0x3e15, 0x3551, 0x289d, 0x23d9, 0x1305, 0x1841, 0x058d, 0x0ec9, 0x6435, 0x6f71,
            0x72bd, 0x79f9, 0x4925, 0x4261, 0x5fad, 0x54e9, 0xeac4, 0xe180, 0xfc4c, 0xf708, 0xc7d4,
            0xcc90, 0xd15c, 0xda18, 0xb0e4, 0xbba0, 0xa66c, 0xad28, 0x9df4, 0x96b0, 0x8b7c, 0x8038,
            0x5e84, 0x55c0, 0x480c, 0x4348, 0x7394, 0x78d0, 0x651c, 0x6e58, 0x04a4, 0x0fe0, 0x122c,
            0x1968, 0x29b4, 0x22f0, 0x3f3c, 0x3478, 0x4b77, 0x4033, 0x5dff, 0x56bb, 0x6667, 0x6d23,
            0x70ef, 0x7bab, 0x1157, 0x1a13, 0x07df, 0x0c9b, 0x3c47, 0x3703, 0x2acf, 0x218b, 0xff37,
            0xf473, 0xe9bf, 0xe2fb, 0xd227, 0xd963, 0xc4af, 0xcfeb, 0xa517, 0xae53, 0xb39f, 0xb8db,
            0x8807, 0x8343, 0x9e8f, 0x95cb, 0x2be6, 0x20a2, 0x3d6e, 0x362a, 0x06f6, 0x0db2, 0x107e,
            0x1b3a, 0x71c6, 0x7a82, 0x674e, 0x6c0a, 0x5cd6, 0x5792, 0x4a5e, 0x411a, 0x9fa6, 0x94e2,
            0x892e, 0x826a, 0xb2b6, 0xb9f2, 0xa43e, 0xaf7a, 0xc586, 0xcec2, 0xd30e, 0xd84a, 0xe896,
            0xe3d2, 0xfe1e, 0xf55a,
        ],
        [
            0x0000, 0x042b, 0x0856, 0x0c7d, 0x10ac, 0x1487, 0x18fa, 0x1cd1, 0x2158, 0x2573, 0x290e,
            0x2d25, 0x31f4, 0x35df, 0x39a2, 0x3d89, 0x42b0, 0x469b, 0x4ae6, 0x4ecd, 0x521c, 0x5637,
            0x5a4a, 0x5e61, 0x63e8, 0x67c3, 0x6bbe, 0x6f95, 0x7344, 0x776f, 0x7b12, 0x7f39, 0x8560,
            0x814b, 0x8d36, 0x891d, 0x95cc, 0x91e7, 0x9d9a, 0x99b1, 0xa438, 0xa013, 0xac6e, 0xa845,
            0xb494, 0xb0bf, 0xbcc2, 0xb8e9, 0xc7d0, 0xc3fb, 0xcf86, 0xcbad, 0xd77c, 0xd357, 0xdf2a,
            0xdb01, 0xe688, 0xe2a3, 0xeede, 0xeaf5, 0xf624, 0xf20f, 0xfe72, 0xfa59, 0x02d1, 0x06fa,
            0x0a87, 0x0eac, 0x127d, 0x1656, 0x1a2b, 0x1e00, 0x2389, 0x27a2, 0x2bdf, 0x2ff4, 0x3325,
            0x370e, 0x3b73, 0x3f58, 0x4061, 0x444a, 0x4837, 0x4c1c, 0x50cd, 0x54e6, 0x589b, 0x5cb0,
            0x6139, 0x6512, 0x696f, 0x6d44, 0x7195, 0x75be, 0x79c3, 0x7de8, 0x87b1, 0x839a, 0x8fe7,
            0x8bcc, 0x971d, 0x9336, 0x9f4b, 0x9b60, 0xa6e9, 0xa2c2, 0xaebf, 0xaa94, 0xb645, 0xb26e,
            0xbe13, 0xba38, 0xc501, 0xc12a, 0xcd57, 0xc97c, 0xd5ad, 0xd186, 0xddfb, 0xd9d0, 0xe459,
            0xe072, 0xec0f, 0xe824, 0xf4f5, 0xf0de, 0xfca3, 0xf888, 0x05a2, 0x0189, 0x0df4, 0x09df,
            0x150e, 0x1125, 0x1d58, 0x1973, 0x24fa, 0x20d1, 0x2cac, 0x2887, 0x3456, 0x307d, 0x3c00,
            0x382b, 0x4712, 0x4339, 0x4f44, 0x4b6f, 0x57be, 0x5395, 0x5fe8, 0x5bc3, 0x664a, 0x6261,
            0x6e1c, 0x6a37, 0x76e6, 0x72cd, 0x7eb0, 0x7a9b, 0x80c2, 0x84e9, 0x8894, 0x8cbf, 0x906e,
            0x9445, 0x9838, 0x9c13, 0xa19a, 0xa5b1, 0xa9cc, 0xade7, 0xb136, 0xb51d, 0xb960, 0xbd4b,
            0xc272, 0xc659, 0xca24, 0xce0f, 0xd2de, 0xd6f5, 0xda88, 0xdea3, 0xe32a, 0xe701, 0xeb7c,
            0xef57, 0xf386, 0xf7ad, 0xfbd0, 0xfffb, 0x0773, 0x0358, 0x0f25, 0x0b0e, 0x17df, 0x13f4,
            0x1f89, 0x1ba2, 0x262b, 0x2200, 0x2e7d, 0x2a56, 0x3687, 0x32ac, 0x3ed1, 0x3afa, 0x45c3,
            0x41e8, 0x4d95, 0x49be, 0x556f, 0x5144, 0x5d39, 0x5912, 0x649b, 0x60b0, 0x6ccd, 0x68e6,
            0x7437, 0x701c, 0x7c61, 0x784a, 0x8213, 0x8638, 0x8a45, 0x8e6e, 0x92bf, 0x9694, 0x9ae9,
            0x9ec2, 0xa34b, 0xa760, 0xab1d, 0xaf36, 0xb3e7, 0xb7cc, 0xbbb1, 0xbf9a, 0xc0a3, 0xc488,
            0xc8f5, 0xccde, 0xd00f, 0xd424, 0xd859, 0xdc72, 0xe1fb, 0xe5d0, 0xe9ad, 0xed86, 0xf157,
            0xf57c, 0xf901, 0xfd2a,
        ],
        [
            0x0000, 0x9fd5, 0x37bb, 0xa86e, 0x6f76, 0xf0a3, 0x58cd, 0xc718, 0xdeec, 0x4139, 0xe957,
            0x7682, 0xb19a, 0x2e4f, 0x8621, 0x19f4, 0xb5c9, 0x2a1c, 0x8272, 0x1da7, 0xdabf, 0x456a,
            0xed04, 0x72d1, 0x6b25, 0xf4f0, 0x5c9e, 0xc34b, 0x0453, 0x9b86, 0x33e8, 0xac3d, 0x6383,
            0xfc56, 0x5438, 0xcbed, 0x0cf5, 0x9320, 0x3b4e, 0xa49b, 0xbd6f, 0x22ba, 0x8ad4, 0x1501,
            0xd219, 0x4dcc, 0xe5a2, 0x7a77, 0xd64a, 0x499f, 0xe1f1, 0x7e24, 0xb93c, 0x26e9, 0x8e87,
            0x1152, 0x08a6, 0x9773, 0x3f1d, 0xa0c8, 0x67d0, 0xf805, 0x506b, 0xcfbe, 0xc706, 0x58d3,
            0xf0bd, 0x6f68, 0xa870, 0x37a5, 0x9fcb, 0x001e, 0x19ea, 0x863f, 0x2e51, 0xb184, 0x769c,
            0xe949, 0x4127, 0xdef2, 0x72cf, 0xed1a, 0x4574, 0xdaa1, 0x1db9, 0x826c, 0x2a02, 0xb5d7,
            0xac23, 0x33f6, 0x9b98, 0x044d, 0xc355, 0x5c80, 0xf4ee, 0x6b3b, 0xa485, 0x3b50, 0x933e,
            0x0ceb, 0xcbf3, 0x5426, 0xfc48, 0x639d, 0x7a69, 0xe5bc, 0x4dd2, 0xd207, 0x151f, 0x8aca,
            0x22a4, 0xbd71, 0x114c, 0x8e99, 0x26f7, 0xb922, 0x7e3a, 0xe1ef, 0x4981, 0xd654, 0xcfa0,
            0x5075, 0xf81b, 0x67ce, 0xa0d6, 0x3f03, 0x976d, 0x08b8, 0x861d, 0x19c8, 0xb1a6, 0x2e73,
            0xe96b, 0x76be, 0xded0, 0x4105, 0x58f1, 0xc724, 0x6f4a, 0xf09f, 0x3787, 0xa852, 0x003c,
            0x9fe9, 0x33d4, 0xac01, 0x046f, 0x9bba, 0x5ca2, 0xc377, 0x6b19, 0xf4cc, 0xed38, 0x72ed,
            0xda83, 0x4556, 0x824e, 0x1d9b, 0xb5f5, 0x2a20, 0xe59e, 0x7a4b, 0xd225, 0x4df0, 0x8ae8,
            0x153d, 0xbd53, 0x2286, 0x3b72, 0xa4a7, 0x0cc9, 0x931c, 0x5404, 0xcbd1, 0x63bf, 0xfc6a,
            0x5057, 0xcf82, 0x67ec, 0xf839, 0x3f21, 0xa0f4, 0x089a, 0x974f, 0x8ebb, 0x116e, 0xb900,
            0x26d5, 0xe1cd, 0x7e18, 0xd676, 0x49a3, 0x411b, 0xdece, 0x76a0, 0xe975, 0x2e6d, 0xb1b8,
            0x19d6, 0x8603, 0x9ff7, 0x0022, 0xa84c, 0x3799, 0xf081, 0x6f54, 0xc73a, 0x58ef, 0xf4d2,
            0x6b07, 0xc369, 0x5cbc, 0x9ba4, 0x0471, 0xac1f, 0x33ca, 0x2a3e, 0xb5eb, 0x1d85, 0x8250,
            0x4548, 0xda9d, 0x72f3, 0xed26, 0x2298, 0xbd4d, 0x1523, 0x8af6, 0x4dee, 0xd23b, 0x7a55,
            0xe580, 0xfc74, 0x63a1, 0xcbcf, 0x541a, 0x9302, 0x0cd7, 0xa4b9, 0x3b6c, 0x9751, 0x0884,
            0xa0ea, 0x3f3f, 0xf827, 0x67f2, 0xcf9c, 0x5049, 0x49bd, 0xd668, 0x7e06, 0xe1d3, 0x26cb,
            0xb91e, 0x1170, 0x8ea5,
        ],
        [
            0x0000, 0x81bf, 0x0b6f, 0x8ad0, 0x16de, 0x9761, 0x1db1, 0x9c0e, 0x2dbc, 0xac03, 0x26d3,
            0xa76c, 0x3b62, 0xbadd, 0x300d, 0xb1b2, 0x5b78, 0xdac7, 0x5017, 0xd1a8, 0x4da6, 0xcc19,
            0x46c9, 0xc776, 0x76c4, 0xf77b, 0x7dab, 0xfc14, 0x601a, 0xe1a5, 0x6b75, 0xeaca, 0xb6f0,
            0x374f, 0xbd9f, 0x3c20, 0xa02e, 0x2191, 0xab41, 0x2afe, 0x9b4c, 0x1af3, 0x9023, 0x119c,
            0x8d92, 0x0c2d, 0x86fd, 0x0742, 0xed88, 0x6c37, 0xe6e7, 0x6758, 0xfb56, 0x7ae9, 0xf039,
            0x7186, 0xc034, 0x418b, 0xcb5b, 0x4ae4, 0xd6ea, 0x5755, 0xdd85, 0x5c3a, 0x65f1, 0xe44e,
            0x6e9e, 0xef21, 0x732f, 0xf290, 0x7840, 0xf9ff, 0x484d, 0xc9f2, 0x4322, 0xc29d, 0x5e93,
            0xdf2c, 0x55fc, 0xd443, 0x3e89, 0xbf36, 0x35e6, 0xb459, 0x2857, 0xa9e8, 0x2338, 0xa287,
            0x1335, 0x928a, 0x185a, 0x99e5, 0x05eb, 0x8454, 0x0e84, 0x8f3b, 0xd301, 0x52be, 0xd86e,
            0x59d1, 0xc5df, 0x4460, 0xceb0, 0x4f0f, 0xfebd, 0x7f02, 0xf5d2, 0x746d, 0xe863, 0x69dc,
            0xe30c, 0x62b3, 0x8879, 0x09c6, 0x8316, 0x02a9, 0x9ea7, 0x1f18, 0x95c8, 0x1477, 0xa5c5,
            0x247a, 0xaeaa, 0x2f15, 0xb31b, 0x32a4, 0xb874, 0x39cb, 0xcbe2, 0x4a5d, 0xc08d, 0x4132,
            0xdd3c, 0x5c83, 0xd653, 0x57ec, 0xe65e, 0x67e1, 0xed31, 0x6c8e, 0xf080, 0x713f, 0xfbef,
            0x7a50, 0x909a, 0x1125, 0x9bf5, 0x1a4a, 0x8644, 0x07fb, 0x8d2b, 0x0c94, 0xbd26, 0x3c99,
            0xb649, 0x37f6, 0xabf8, 0x2a47, 0xa097, 0x2128, 0x7d12, 0xfcad, 0x767d, 0xf7c2, 0x6bcc,
            0xea73, 0x60a3, 0xe11c, 0x50ae, 0xd111, 0x5bc1, 0xda7e, 0x4670, 0xc7cf, 0x4d1f, 0xcca0,
            0x266a, 0xa7d5, 0x2d05, 0xacba, 0x30b4, 0xb10b, 0x3bdb, 0xba64, 0x0bd6, 0x8a69, 0x00b9,
            0x8106, 0x1d08, 0x9cb7, 0x1667, 0x97d8, 0xae13, 0x2fac, 0xa57c, 0x24c3, 0xb8cd, 0x3972,
            0xb3a2, 0x321d, 0x83af, 0x0210, 0x88c0, 0x097f, 0x9571, 0x14ce, 0x9e1e, 0x1fa1, 0xf56b,
            0x74d4, 0xfe04, 0x7fbb, 0xe3b5, 0x620a, 0xe8da, 0x6965, 0xd8d7, 0x5968, 0xd3b8, 0x5207,
            0xce09, 0x4fb6, 0xc566, 0x44d9, 0x18e3, 0x995c, 0x138c, 0x9233, 0x0e3d, 0x8f82, 0x0552,
            0x84ed, 0x355f, 0xb4e0, 0x3e30, 0xbf8f, 0x2381, 0xa23e, 0x28ee, 0xa951, 0x439b, 0xc224,
            0x48f4, 0xc94b, 0x5545, 0xd4fa, 0x5e2a, 0xdf95, 0x6e27, 0xef98, 0x6548, 0xe4f7, 0x78f9,
            0xf946, 0x7396, 0xf229,
        ],
        [
            0x0000, 0x4dfd, 0x9bfa, 0xd607, 0x3fe5, 0x7218, 0xa41f, 0xe9e2, 0x7fca, 0x3237, 0xe430,
            0xa9cd, 0x402f, 0x0dd2, 0xdbd5, 0x9628, 0xff94, 0xb269, 0x646e, 0x2993, 0xc071, 0x8d8c,
            0x5b8b, 0x1676, 0x805e, 0xcda3, 0x1ba4, 0x5659, 0xbfbb, 0xf246, 0x2441, 0x69bc, 0xf739,
            0xbac4, 0x6cc3, 0x213e, 0xc8dc, 0x8521, 0x5326, 0x1edb, 0x88f3, 0xc50e, 0x1309, 0x5ef4,
            0xb716, 0xfaeb, 0x2cec, 0x6111, 0x08ad, 0x4550, 0x9357, 0xdeaa, 0x3748, 0x7ab5, 0xacb2,
            0xe14f, 0x7767, 0x3a9a, 0xec9d, 0xa160, 0x4882, 0x057f, 0xd378, 0x9e85, 0xe663, 0xab9e,
            0x7d99, 0x3064, 0xd986, 0x947b, 0x427c, 0x0f81, 0x99a9, 0xd454, 0x0253, 0x4fae, 0xa64c,
            0xebb1, 0x3db6, 0x704b, 0x19f7, 0x540a, 0x820d, 0xcff0, 0x2612, 0x6bef, 0xbde8, 0xf015,
            0x663d, 0x2bc0, 0xfdc7, 0xb03a, 0x59d8, 0x1425, 0xc222, 0x8fdf, 0x115a, 0x5ca7, 0x8aa0,
            0xc75d, 0x2ebf, 0x6342, 0xb545, 0xf8b8, 0x6e90, 0x236d, 0xf56a, 0xb897, 0x5175, 0x1c88,
            0xca8f, 0x8772, 0xeece, 0xa333, 0x7534, 0x38c9, 0xd12b, 0x9cd6, 0x4ad1, 0x072c, 0x9104,
            0xdcf9, 0x0afe, 0x4703, 0xaee1, 0xe31c, 0x351b, 0x78e6, 0xc4d7, 0x892a, 0x5f2d, 0x12d0,
            0xfb32, 0xb6cf, 0x60c8, 0x2d35, 0xbb1d, 0xf6e0, 0x20e7, 0x6d1a, 0x84f8, 0xc905, 0x1f02,
            0x52ff, 0x3b43, 0x76be, 0xa0b9, 0xed44, 0x04a6, 0x495b, 0x9f5c, 0xd2a1, 0x4489, 0x0974,
            0xdf73, 0x928e, 0x7b6c, 0x3691, 0xe096, 0xad6b, 0x33ee, 0x7e13, 0xa814, 0xe5e9, 0x0c0b,
            0x41f6, 0x97f1, 0xda0c, 0x4c24, 0x01d9, 0xd7de, 0x9a23, 0x73c1, 0x3e3c, 0xe83b, 0xa5c6,
            0xcc7a, 0x8187, 0x5780, 0x1a7d, 0xf39f, 0xbe62, 0x6865, 0x2598, 0xb3b0, 0xfe4d, 0x284a,
            0x65b7, 0x8c55, 0xc1a8, 0x17af, 0x5a52, 0x22b4, 0x6f49, 0xb94e, 0xf4b3, 0x1d51, 0x50ac,
            0x86ab, 0xcb56, 0x5d7e, 0x1083, 0xc684, 0x8b79, 0x629b, 0x2f66, 0xf961, 0xb49c, 0xdd20,
            0x90dd, 0x46da, 0x0b27, 0xe2c5, 0xaf38, 0x793f, 0x34c2, 0xa2ea, 0xef17, 0x3910, 0x74ed,
            0x9d0f, 0xd0f2, 0x06f5, 0x4b08, 0xd58d, 0x9870, 0x4e77, 0x038a, 0xea68, 0xa795, 0x7192,
            0x3c6f, 0xaa47, 0xe7ba, 0x31bd, 0x7c40, 0x95a2, 0xd85f, 0x0e58, 0x43a5, 0x2a19, 0x67e4,
            0xb1e3, 0xfc1e, 0x15fc, 0x5801, 0x8e06, 0xc3fb, 0x55d3, 0x182e, 0xce29, 0x83d4, 0x6a36,
            0x27cb, 0xf1cc, 0xbc31,
        ],
        [
            0x0000, 0x2c27, 0x584e, 0x7469, 0xb09c, 0x9cbb, 0xe8d2, 0xc4f5, 0x6929, 0x450e, 0x3167,
            0x1d40, 0xd9b5, 0xf592, 0x81fb, 0xaddc, 0xd252, 0xfe75, 0x8a1c, 0xa63b, 0x62ce, 0x4ee9,
            0x3a80, 0x16a7, 0xbb7b, 0x975c, 0xe335, 0xcf12, 0x0be7, 0x27c0, 0x53a9, 0x7f8e, 0xacb5,
            0x8092, 0xf4fb, 0xd8dc, 0x1c29, 0x300e, 0x4467, 0x6840, 0xc59c, 0xe9bb, 0x9dd2, 0xb1f5,
            0x7500, 0x5927, 0x2d4e, 0x0169, 0x7ee7, 0x52c0, 0x26a9, 0x0a8e, 0xce7b, 0xe25c, 0x9635,
            0xba12, 0x17ce, 0x3be9, 0x4f80, 0x63a7, 0xa752, 0x8b75, 0xff1c, 0xd33b, 0x517b, 0x7d5c,
            0x0935, 0x2512, 0xe1e7, 0xcdc0, 0xb9a9, 0x958e, 0x3852, 0x1475, 0x601c, 0x4c3b, 0x88ce,
            0xa4e9, 0xd080, 0xfca7, 0x8329, 0xaf0e, 0xdb67, 0xf740, 0x33b5, 0x1f92, 0x6bfb, 0x47dc,
            0xea00, 0xc627, 0xb24e, 0x9e69, 0x5a9c, 0x76bb, 0x02d2, 0x2ef5, 0xfdce, 0xd1e9, 0xa580,
            0x89a7, 0x4d52, 0x6175, 0x151c, 0x393b, 0x94e7, 0xb8c0, 0xcca9, 0xe08e, 0x247b, 0x085c,
            0x7c35, 0x5012, 0x2f9c, 0x03bb, 0x77d2, 0x5bf5, 0x9f00, 0xb327, 0xc74e, 0xeb69, 0x46b5,
            0x6a92, 0x1efb, 0x32dc, 0xf629, 0xda0e, 0xae67, 0x8240, 0xa2f6, 0x8ed1, 0xfab8, 0xd69f,
            0x126a, 0x3e4d, 0x4a24, 0x6603, 0xcbdf, 0xe7f8, 0x9391, 0xbfb6, 0x7b43, 0x5764, 0x230d,
            0x0f2a, 0x70a4, 0x5c83, 0x28ea, 0x04cd, 0xc038, 0xec1f, 0x9876, 0xb451, 0x198d, 0x35aa,
            0x41c3, 0x6de4, 0xa911, 0x8536, 0xf15f, 0xdd78, 0x0e43, 0x2264, 0x560d, 0x7a2a, 0xbedf,
            0x92f8, 0xe691, 0xcab6, 0x676a, 0x4b4d, 0x3f24, 0x1303, 0xd7f6, 0xfbd1, 0x8fb8, 0xa39f,
            0xdc11, 0xf036, 0x845f, 0xa878, 0x6c8d, 0x40aa, 0x34c3, 0x18e4, 0xb538, 0x991f, 0xed76,
            0xc151, 0x05a4, 0x2983, 0x5dea, 0x71cd, 0xf38d, 0xdfaa, 0xabc3, 0x87e4, 0x4311, 0x6f36,
            0x1b5f, 0x3778, 0x9aa4, 0xb683, 0xc2ea, 0xeecd, 0x2a38, 0x061f, 0x7276, 0x5e51, 0x21df,
            0x0df8, 0x7991, 0x55b6, 0x9143, 0xbd64, 0xc90d, 0xe52a, 0x48f6, 0x64d1, 0x10b8, 0x3c9f,
            0xf86a, 0xd44d, 0xa024, 0x8c03, 0x5f38, 0x731f, 0x0776, 0x2b51, 0xefa4, 0xc383, 0xb7ea,
            0x9bcd, 0x3611, 0x1a36, 0x6e5f, 0x4278, 0x868d, 0xaaaa, 0xdec3, 0xf2e4, 0x8d6a, 0xa14d,
            0xd524, 0xf903, 0x3df6, 0x11d1, 0x65b8, 0x499f, 0xe443, 0xc864, 0xbc0d, 0x902a, 0x54df,
            0x78f8, 0x0c91, 0x20b6,
        ],
        [
            0x0000, 0x5591, 0xab22, 0xfeb3, 0x5e55, 0x0bc4, 0xf577, 0xa0e6, 0xbcaa, 0xe93b, 0x1788,
            0x4219, 0xe2ff, 0xb76e, 0x49dd, 0x1c4c, 0x7145, 0x24d4, 0xda67, 0x8ff6, 0x2f10, 0x7a81,
            0x8432, 0xd1a3, 0xcdef, 0x987e, 0x66cd, 0x335c, 0x93ba, 0xc62b, 0x3898, 0x6d09, 0xe28a,
            0xb71b, 0x49a8, 0x1c39, 0xbcdf, 0xe94e, 0x17fd, 0x426c, 0x5e20, 0x0bb1, 0xf502, 0xa093,
            0x0075, 0x55e4, 0xab57, 0xfec6, 0x93cf, 0xc65e, 0x38ed, 0x6d7c, 0xcd9a, 0x980b, 0x66b8,
            0x3329, 0x2f65, 0x7af4, 0x8447, 0xd1d6, 0x7130, 0x24a1, 0xda12, 0x8f83, 0xcd05, 0x9894,
            0x6627, 0x33b6, 0x9350, 0xc6c1, 0x3872, 0x6de3, 0x71af, 0x243e, 0xda8d, 0x8f1c, 0x2ffa,
            0x7a6b, 0x84d8, 0xd149, 0xbc40, 0xe9d1, 0x1762, 0x42f3, 0xe215, 0xb784, 0x4937, 0x1ca6,
            0x00ea, 0x557b, 0xabc8, 0xfe59, 0x5ebf, 0x0b2e, 0xf59d, 0xa00c, 0x2f8f, 0x7a1e, 0x84ad,
            0xd13c, 0x71da, 0x244b, 0xdaf8, 0x8f69, 0x9325, 0xc6b4, 0x3807, 0x6d96, 0xcd70, 0x98e1,
            0x6652, 0x33c3, 0x5eca, 0x0b5b, 0xf5e8, 0xa079, 0x009f, 0x550e, 0xabbd, 0xfe2c, 0xe260,
            0xb7f1, 0x4942, 0x1cd3, 0xbc35, 0xe9a4, 0x1717, 0x4286, 0x921b, 0xc78a, 0x3939, 0x6ca8,
            0xcc4e, 0x99df, 0x676c, 0x32fd, 0x2eb1, 0x7b20, 0x8593, 0xd002, 0x70e4, 0x2575, 0xdbc6,
            0x8e57, 0xe35e, 0xb6cf, 0x487c, 0x1ded, 0xbd0b, 0xe89a, 0x1629, 0x43b8, 0x5ff4, 0x0a65,
            0xf4d6, 0xa147, 0x01a1, 0x5430, 0xaa83, 0xff12, 0x7091, 0x2500, 0xdbb3, 0x8e22, 0x2ec4,
            0x7b55, 0x85e6, 0xd077, 0xcc3b, 0x99aa, 0x6719, 0x3288, 0x926e, 0xc7ff, 0x394c, 0x6cdd,
            0x01d4, 0x5445, 0xaaf6, 0xff67, 0x5f81, 0x0a10, 0xf4a3, 0xa132, 0xbd7e, 0xe8ef, 0x165c,
            0x43cd, 0xe32b, 0xb6ba, 0x4809, 0x1d98, 0x5f1e, 0x0a8f, 0xf43c, 0xa1ad, 0x014b, 0x54da,
            0xaa69, 0xfff8, 0xe3b4, 0xb625, 0x4896, 0x1d07, 0xbde1, 0xe870, 0x16c3, 0x4352, 0x2e5b,
            0x7bca, 0x8579, 0xd0e8, 0x700e, 0x259f, 0xdb2c, 0x8ebd, 0x92f1, 0xc760, 0x39d3, 0x6c42,
            0xcca4, 0x9935, 0x6786, 0x3217, 0xbd94, 0xe805, 0x16b6, 0x4327, 0xe3c1, 0xb650, 0x48e3,
            0x1d72, 0x013e, 0x54af, 0xaa1c, 0xff8d, 0x5f6b, 0x0afa, 0xf449, 0xa1d8, 0xccd1, 0x9940,
            0x67f3, 0x3262, 0x9284, 0xc715, 0x39a6, 0x6c37, 0x707b, 0x25ea, 0xdb59, 0x8ec8, 0x2e2e,
            0x7bbf, 0x850c, 0xd09d,
        ],
        [
            0x0000, 0x8555, 0x02bb, 0x87ee, 0x0576, 0x8023, 0x07cd, 0x8298, 0x0aec, 0x8fb9, 0x0857,
            0x8d02, 0x0f9a, 0x8acf, 0x0d21, 0x8874, 0x15d8, 0x908d, 0x1763, 0x9236, 0x10ae, 0x95fb,
            0x1215, 0x9740, 0x1f34, 0x9a61, 0x1d8f, 0x98da, 0x1a42, 0x9f17, 0x18f9, 0x9dac, 0x2bb0,
            0xaee5, 0x290b, 0xac5e, 0x2ec6, 0xab93, 0x2c7d, 0xa928, 0x215c, 0xa409, 0x23e7, 0xa6b2,
            0x242a, 0xa17f, 0x2691, 0xa3c4, 0x3e68, 0xbb3d, 0x3cd3, 0xb986, 0x3b1e, 0xbe4b, 0x39a5,
            0xbcf0, 0x3484, 0xb1d1, 0x363f, 0xb36a, 0x31f2, 0xb4a7, 0x3349, 0xb61c, 0x5760, 0xd235,
            0x55db, 0xd08e, 0x5216, 0xd743, 0x50ad, 0xd5f8, 0x5d8c, 0xd8d9, 0x5f37, 0xda62, 0x58fa,
            0xddaf, 0x5a41, 0xdf14, 0x42b8, 0xc7ed, 0x4003, 0xc556, 0x47ce, 0xc29b, 0x4575, 0xc020,
            0x4854, 0xcd01, 0x4aef, 0xcfba, 0x4d22, 0xc877, 0x4f99, 0xcacc, 0x7cd0, 0xf985, 0x7e6b,
            0xfb3e, 0x79a6, 0xfcf3, 0x7b1d, 0xfe48, 0x763c, 0xf369, 0x7487, 0xf1d2, 0x734a, 0xf61f,
            0x71f1, 0xf4a4, 0x6908, 0xec5d, 0x6bb3, 0xeee6, 0x6c7e, 0xe92b, 0x6ec5, 0xeb90, 0x63e4,
            0xe6b1, 0x615f, 0xe40a, 0x6692, 0xe3c7, 0x6429, 0xe17c, 0xaec0, 0x2b95, 0xac7b, 0x292e,
            0xabb6, 0x2ee3, 0xa90d, 0x2c58, 0xa42c, 0x2179, 0xa697, 0x23c2, 0xa15a, 0x240f, 0xa3e1,
            0x26b4, 0xbb18, 0x3e4d, 0xb9a3, 0x3cf6, 0xbe6e, 0x3b3b, 0xbcd5, 0x3980, 0xb1f4, 0x34a1,
            0xb34f, 0x361a, 0xb482, 0x31d7, 0xb639, 0x336c, 0x8570, 0x0025, 0x87cb, 0x029e, 0x8006,
            0x0553, 0x82bd, 0x07e8, 0x8f9c, 0x0ac9, 0x8d27, 0x0872, 0x8aea, 0x0fbf, 0x8851, 0x0d04,
            0x90a8, 0x15fd, 0x9213, 0x1746, 0x95de, 0x108b, 0x9765, 0x1230, 0x9a44, 0x1f11, 0x98ff,
            0x1daa, 0x9f32, 0x1a67, 0x9d89, 0x18dc, 0xf9a0, 0x7cf5, 0xfb1b, 0x7e4e, 0xfcd6, 0x7983,
            0xfe6d, 0x7b38, 0xf34c, 0x7619, 0xf1f7, 0x74a2, 0xf63a, 0x736f, 0xf481, 0x71d4, 0xec78,
            0x692d, 0xeec3, 0x6b96, 0xe90e, 0x6c5b, 0xebb5, 0x6ee0, 0xe694, 0x63c1, 0xe42f, 0x617a,
            0xe3e2, 0x66b7, 0xe159, 0x640c, 0xd210, 0x5745, 0xd0ab, 0x55fe, 0xd766, 0x5233, 0xd5dd,
            0x5088, 0xd8fc, 0x5da9, 0xda47, 0x5f12, 0xdd8a, 0x58df, 0xdf31, 0x5a64, 0xc7c8, 0x429d,
            0xc573, 0x4026, 0xc2be, 0x47eb, 0xc005, 0x4550, 0xcd24, 0x4871, 0xcf9f, 0x4aca, 0xc852,
            0x4d07, 0xcae9, 0x4fbc,
        ],
        [
            0x0000, 0x05ad, 0x0b5a, 0x0ef7, 0x16b4, 0x1319, 0x1dee, 0x1843, 0x2d68, 0x28c5, 0x2632,
            0x239f, 0x3bdc, 0x3e71, 0x3086, 0x352b, 0x5ad0, 0x5f7d, 0x518a, 0x5427, 0x4c64, 0x49c9,
            0x473e, 0x4293, 0x77b8, 0x7215, 0x7ce2, 0x794f, 0x610c, 0x64a1, 0x6a56, 0x6ffb, 0xb5a0,
            0xb00d, 0xbefa, 0xbb57, 0xa314, 0xa6b9, 0xa84e, 0xade3, 0x98c8, 0x9d65, 0x9392, 0x963f,
            0x8e7c, 0x8bd1, 0x8526, 0x808b, 0xef70, 0xeadd, 0xe42a, 0xe187, 0xf9c4, 0xfc69, 0xf29e,
            0xf733, 0xc218, 0xc7b5, 0xc942, 0xccef, 0xd4ac, 0xd101, 0xdff6, 0xda5b, 0x6351, 0x66fc,
            0x680b, 0x6da6, 0x75e5, 0x7048, 0x7ebf, 0x7b12, 0x4e39, 0x4b94, 0x4563, 0x40ce, 0x588d,
            0x5d20, 0x53d7, 0x567a, 0x3981, 0x3c2c, 0x32db, 0x3776, 0x2f35, 0x2a98, 0x246f, 0x21c2,
            0x14e9, 0x1144, 0x1fb3, 0x1a1e, 0x025d, 0x07f0, 0x0907, 0x0caa, 0xd6f1, 0xd35c, 0xddab,
            0xd806, 0xc045, 0xc5e8, 0xcb1f, 0xceb2, 0xfb99, 0xfe34, 0xf0c3, 0xf56e, 0xed2d, 0xe880,
            0xe677, 0xe3da, 0x8c21, 0x898c, 0x877b, 0x82d6, 0x9a95, 0x9f38, 0x91cf, 0x9462, 0xa149,
            0xa4e4, 0xaa13, 0xafbe, 0xb7fd, 0xb250, 0xbca7, 0xb90a, 0xc6a2, 0xc30f, 0xcdf8, 0xc855,
            0xd016, 0xd5bb, 0xdb4c, 0xdee1, 0xebca, 0xee67, 0xe090, 0xe53d, 0xfd7e, 0xf8d3, 0xf624,
            0xf389, 0x9c72, 0x99df, 0x9728, 0x9285, 0x8ac6, 0x8f6b, 0x819c, 0x8431, 0xb11a, 0xb4b7,
            0xba40, 0xbfed, 0xa7ae, 0xa203, 0xacf4, 0xa959, 0x7302, 0x76af, 0x7858, 0x7df5, 0x65b6,
            0x601b, 0x6eec, 0x6b41, 0x5e6a, 0x5bc7, 0x5530, 0x509d, 0x48de, 0x4d73, 0x4384, 0x4629,
            0x29d2, 0x2c7f, 0x2288, 0x2725, 0x3f66, 0x3acb, 0x343c, 0x3191, 0x04ba, 0x0117, 0x0fe0,
            0x0a4d, 0x120e, 0x17a3, 0x1954, 0x1cf9, 0xa5f3, 0xa05e, 0xaea9, 0xab04, 0xb347, 0xb6ea,
            0xb81d, 0xbdb0, 0x889b, 0x8d36, 0x83c1, 0x866c, 0x9e2f, 0x9b82, 0x9575, 0x90d8, 0xff23,
            0xfa8e, 0xf479, 0xf1d4, 0xe997, 0xec3a, 0xe2cd, 0xe760, 0xd24b, 0xd7e6, 0xd911, 0xdcbc,
            0xc4ff, 0xc152, 0xcfa5, 0xca08, 0x1053, 0x15fe, 0x1b09, 0x1ea4, 0x06e7, 0x034a, 0x0dbd,
            0x0810, 0x3d3b, 0x3896, 0x3661, 0x33cc, 0x2b8f, 0x2e22, 0x20d5, 0x2578, 0x4a83, 0x4f2e,
            0x41d9, 0x4474, 0x5c37, 0x599a, 0x576d, 0x52c0, 0x67eb, 0x6246, 0x6cb1, 0x691c, 0x715f,
            0x74f2, 0x7a05, 0x7fa8,
        ],
        [
            0x0000, 0x7eea, 0xfdd4, 0x833e, 0xf3b9, 0x8d53, 0x0e6d, 0x7087, 0xef63, 0x9189, 0x12b7,
            0x6c5d, 0x1cda, 0x6230, 0xe10e, 0x9fe4, 0xd6d7, 0xa83d, 0x2b03, 0x55e9, 0x256e, 0x5b84,
            0xd8ba, 0xa650, 0x39b4, 0x475e, 0xc460, 0xba8a, 0xca0d, 0xb4e7, 0x37d9, 0x4933, 0xa5bf,
            0xdb55, 0x586b, 0x2681, 0x5606, 0x28ec, 0xabd2, 0xd538, 0x4adc, 0x3436, 0xb708, 0xc9e2,
            0xb965, 0xc78f, 0x44b1, 0x3a5b, 0x7368, 0x0d82, 0x8ebc, 0xf056, 0x80d1, 0xfe3b, 0x7d05,
            0x03ef, 0x9c0b, 0xe2e1, 0x61df, 0x1f35, 0x6fb2, 0x1158, 0x9266, 0xec8c, 0x436f, 0x3d85,
            0xbebb, 0xc051, 0xb0d6, 0xce3c, 0x4d02, 0x33e8, 0xac0c, 0xd2e6, 0x51d8, 0x2f32, 0x5fb5,
            0x215f, 0xa261, 0xdc8b, 0x95b8, 0xeb52, 0x686c, 0x1686, 0x6601, 0x18eb, 0x9bd5, 0xe53f,
            0x7adb, 0x0431, 0x870f, 0xf9e5, 0x8962, 0xf788, 0x74b6, 0x0a5c, 0xe6d0, 0x983a, 0x1b04,
            0x65ee, 0x1569, 0x6b83, 0xe8bd, 0x9657, 0x09b3, 0x7759, 0xf467, 0x8a8d, 0xfa0a, 0x84e0,
            0x07de, 0x7934, 0x3007, 0x4eed, 0xcdd3, 0xb339, 0xc3be, 0xbd54, 0x3e6a, 0x4080, 0xdf64,
            0xa18e, 0x22b0, 0x5c5a, 0x2cdd, 0x5237, 0xd109, 0xafe3, 0x86de, 0xf834, 0x7b0a, 0x05e0,
            0x7567, 0x0b8d, 0x88b3, 0xf659, 0x69bd, 0x1757, 0x9469, 0xea83, 0x9a04, 0xe4ee, 0x67d0,
            0x193a, 0x5009, 0x2ee3, 0xaddd, 0xd337, 0xa3b0, 0xdd5a, 0x5e64, 0x208e, 0xbf6a, 0xc180,
            0x42be, 0x3c54, 0x4cd3, 0x3239, 0xb107, 0xcfed, 0x2361, 0x5d8b, 0xdeb5, 0xa05f, 0xd0d8,
            0xae32, 0x2d0c, 0x53e6, 0xcc02, 0xb2e8, 0x31d6, 0x4f3c, 0x3fbb, 0x4151, 0xc26f, 0xbc85,
            0xf5b6, 0x8b5c, 0x0862, 0x7688, 0x060f, 0x78e5, 0xfbdb, 0x8531, 0x1ad5, 0x643f, 0xe701,
            0x99eb, 0xe96c, 0x9786, 0x14b8, 0x6a52, 0xc5b1, 0xbb5b, 0x3865, 0x468f, 0x3608, 0x48e2,
            0xcbdc, 0xb536, 0x2ad2, 0x5438, 0xd706, 0xa9ec, 0xd96b, 0xa781, 0x24bf, 0x5a55, 0x1366,
            0x6d8c, 0xeeb2, 0x9058, 0xe0df, 0x9e35, 0x1d0b, 0x63e1, 0xfc05, 0x82ef, 0x01d1, 0x7f3b,
            0x0fbc, 0x7156, 0xf268, 0x8c82, 0x600e, 0x1ee4, 0x9dda, 0xe330, 0x93b7, 0xed5d, 0x6e63,
            0x1089, 0x8f6d, 0xf187, 0x72b9, 0x0c53, 0x7cd4, 0x023e, 0x8100, 0xffea, 0xb6d9, 0xc833,
            0x4b0d, 0x35e7, 0x4560, 0x3b8a, 0xb8b4, 0xc65e, 0x59ba, 0x2750, 0xa46e, 0xda84, 0xaa03,
            0xd4e9, 0x57d7, 0x293d,
        ],
        [
            0x0000, 0x482a, 0x9054, 0xd87e, 0x28b9, 0x6093, 0xb8ed, 0xf0c7, 0x5172, 0x1958, 0xc126,
            0x890c, 0x79cb, 0x31e1, 0xe99f, 0xa1b5, 0xa2e4, 0xeace, 0x32b0, 0x7a9a, 0x8a5d, 0xc277,
            0x1a09, 0x5223, 0xf396, 0xbbbc, 0x63c2, 0x2be8, 0xdb2f, 0x9305, 0x4b7b, 0x0351, 0x4dd9,
            0x05f3, 0xdd8d, 0x95a7, 0x6560, 0x2d4a, 0xf534, 0xbd1e, 0x1cab, 0x5481, 0x8cff, 0xc4d5,
            0x3412, 0x7c38, 0xa446, 0xec6c, 0xef3d, 0xa717, 0x7f69, 0x3743, 0xc784, 0x8fae, 0x57d0,
            0x1ffa, 0xbe4f, 0xf665, 0x2e1b, 0x6631, 0x96f6, 0xdedc, 0x06a2, 0x4e88, 0x9bb2, 0xd398,
            0x0be6, 0x43cc, 0xb30b, 0xfb21, 0x235f, 0x6b75, 0xcac0, 0x82ea, 0x5a94, 0x12be, 0xe279,
            0xaa53, 0x722d, 0x3a07, 0x3956, 0x717c, 0xa902, 0xe128, 0x11ef, 0x59c5, 0x81bb, 0xc991,
            0x6824, 0x200e, 0xf870, 0xb05a, 0x409d, 0x08b7, 0xd0c9, 0x98e3, 0xd66b, 0x9e41, 0x463f,
            0x0e15, 0xfed2, 0xb6f8, 0x6e86, 0x26ac, 0x8719, 0xcf33, 0x174d, 0x5f67, 0xafa0, 0xe78a,
            0x3ff4, 0x77de, 0x748f, 0x3ca5, 0xe4db, 0xacf1, 0x5c36, 0x141c, 0xcc62, 0x8448, 0x25fd,
            0x6dd7, 0xb5a9, 0xfd83, 0x0d44, 0x456e, 0x9d10, 0xd53a, 0x3f75, 0x775f, 0xaf21, 0xe70b,
            0x17cc, 0x5fe6, 0x8798, 0xcfb2, 0x6e07, 0x262d, 0xfe53, 0xb679, 0x46be, 0x0e94, 0xd6ea,
            0x9ec0, 0x9d91, 0xd5bb, 0x0dc5, 0x45ef, 0xb528, 0xfd02, 0x257c, 0x6d56, 0xcce3, 0x84c9,
            0x5cb7, 0x149d, 0xe45a, 0xac70, 0x740e, 0x3c24, 0x72ac, 0x3a86, 0xe2f8, 0xaad2, 0x5a15,
            0x123f, 0xca41, 0x826b, 0x23de, 0x6bf4, 0xb38a, 0xfba0, 0x0b67, 0x434d, 0x9b33, 0xd319,
            0xd048, 0x9862, 0x401c, 0x0836, 0xf8f1, 0xb0db, 0x68a5, 0x208f, 0x813a, 0xc910, 0x116e,
            0x5944, 0xa983, 0xe1a9, 0x39d7, 0x71fd, 0xa4c7, 0xeced, 0x3493, 0x7cb9, 0x8c7e, 0xc454,
            0x1c2a, 0x5400, 0xf5b5, 0xbd9f, 0x65e1, 0x2dcb, 0xdd0c, 0x9526, 0x4d58, 0x0572, 0x0623,
            0x4e09, 0x9677, 0xde5d, 0x2e9a, 0x66b0, 0xbece, 0xf6e4, 0x5751, 0x1f7b, 0xc705, 0x8f2f,
            0x7fe8, 0x37c2, 0xefbc, 0xa796, 0xe91e, 0xa134, 0x794a, 0x3160, 0xc1a7, 0x898d, 0x51f3,
            0x19d9, 0xb86c, 0xf046, 0x2838, 0x6012, 0x90d5, 0xd8ff, 0x0081, 0x48ab, 0x4bfa, 0x03d0,
            0xdbae, 0x9384, 0x6343, 0x2b69, 0xf317, 0xbb3d, 0x1a88, 0x52a2, 0x8adc, 0xc2f6, 0x3231,
            0x7a1b, 0xa265, 0xea4f,
        ],
        [
            0x0000, 0x8e10, 0x1431, 0x9a21, 0x2862, 0xa672, 0x3c53, 0xb243, 0x50c4, 0xded4, 0x44f5,
            0xcae5, 0x78a6, 0xf6b6, 0x6c97, 0xe287, 0xa188, 0x2f98, 0xb5b9, 0x3ba9, 0x89ea, 0x07fa,
            0x9ddb, 0x13cb, 0xf14c, 0x7f5c, 0xe57d, 0x6b6d, 0xd92e, 0x573e, 0xcd1f, 0x430f, 0x4b01,
            0xc511, 0x5f30, 0xd120, 0x6363, 0xed73, 0x7752, 0xf942, 0x1bc5, 0x95d5, 0x0ff4, 0x81e4,
            0x33a7, 0xbdb7, 0x2796, 0xa986, 0xea89, 0x6499, 0xfeb8, 0x70a8, 0xc2eb, 0x4cfb, 0xd6da,
            0x58ca, 0xba4d, 0x345d, 0xae7c, 0x206c, 0x922f, 0x1c3f, 0x861e, 0x080e, 0x9602, 0x1812,
            0x8233, 0x0c23, 0xbe60, 0x3070, 0xaa51, 0x2441, 0xc6c6, 0x48d6, 0xd2f7, 0x5ce7, 0xeea4,
            0x60b4, 0xfa95, 0x7485, 0x378a, 0xb99a, 0x23bb, 0xadab, 0x1fe8, 0x91f8, 0x0bd9, 0x85c9,
            0x674e, 0xe95e, 0x737f, 0xfd6f, 0x4f2c, 0xc13c, 0x5b1d, 0xd50d, 0xdd03, 0x5313, 0xc932,
            0x4722, 0xf561, 0x7b71, 0xe150, 0x6f40, 0x8dc7, 0x03d7, 0x99f6, 0x17e6, 0xa5a5, 0x2bb5,
            0xb194, 0x3f84, 0x7c8b, 0xf29b, 0x68ba, 0xe6aa, 0x54e9, 0xdaf9, 0x40d8, 0xcec8, 0x2c4f,
            0xa25f, 0x387e, 0xb66e, 0x042d, 0x8a3d, 0x101c, 0x9e0c, 0x2415, 0xaa05, 0x3024, 0xbe34,
            0x0c77, 0x8267, 0x1846, 0x9656, 0x74d1, 0xfac1, 0x60e0, 0xeef0, 0x5cb3, 0xd2a3, 0x4882,
            0xc692, 0x859d, 0x0b8d, 0x91ac, 0x1fbc, 0xadff, 0x23ef, 0xb9ce, 0x37de, 0xd559, 0x5b49,
            0xc168, 0x4f78, 0xfd3b, 0x732b, 0xe90a, 0x671a, 0x6f14, 0xe104, 0x7b25, 0xf535, 0x4776,
            0xc966, 0x5347, 0xdd57, 0x3fd0, 0xb1c0, 0x2be1, 0xa5f1, 0x17b2, 0x99a2, 0x0383, 0x8d93,
            0xce9c, 0x408c, 0xdaad, 0x54bd, 0xe6fe, 0x68ee, 0xf2cf, 0x7cdf, 0x9e58, 0x1048, 0x8a69,
            0x0479, 0xb63a, 0x382a, 0xa20b, 0x2c1b, 0xb217, 0x3c07, 0xa626, 0x2836, 0x9a75, 0x1465,
            0x8e44, 0x0054, 0xe2d3, 0x6cc3, 0xf6e2, 0x78f2, 0xcab1, 0x44a1, 0xde80, 0x5090, 0x139f,
            0x9d8f, 0x07ae, 0x89be, 0x3bfd, 0xb5ed, 0x2fcc, 0xa1dc, 0x435b, 0xcd4b, 0x576a, 0xd97a,
            0x6b39, 0xe529, 0x7f08, 0xf118, 0xf916, 0x7706, 0xed27, 0x6337, 0xd174, 0x5f64, 0xc545,
            0x4b55, 0xa9d2, 0x27c2, 0xbde3, 0x33f3, 0x81b0, 0x0fa0, 0x9581, 0x1b91, 0x589e, 0xd68e,
            0x4caf, 0xc2bf, 0x70fc, 0xfeec, 0x64cd, 0xeadd, 0x085a, 0x864a, 0x1c6b, 0x927b, 0x2038,
            0xae28, 0x3409, 0xba19,
        ],
    ];

    pub static CRC16_KERMIT_TABLE: [[u16; 256]; 16] = [
        [
            0x0000, 0x1189, 0x2312, 0x329b, 0x4624, 0x57ad, 0x6536, 0x74bf, 0x8c48, 0x9dc1, 0xaf5a,
            0xbed3, 0xca6c, 0xdbe5, 0xe97e, 0xf8f7, 0x1081, 0x0108, 0x3393, 0x221a, 0x56a5, 0x472c,
            0x75b7, 0x643e, 0x9cc9, 0x8d40, 0xbfdb, 0xae52, 0xdaed, 0xcb64, 0xf9ff, 0xe876, 0x2102,
            0x308b, 0x0210, 0x1399, 0x6726, 0x76af, 0x4434, 0x55bd, 0xad4a, 0xbcc3, 0x8e58, 0x9fd1,
            0xeb6e, 0xfae7, 0xc87c, 0xd9f5, 0x3183, 0x200a, 0x1291, 0x0318, 0x77a7, 0x662e, 0x54b5,
            0x453c, 0xbdcb, 0xac42, 0x9ed9, 0x8f50, 0xfbef, 0xea66, 0xd8fd, 0xc974, 0x4204, 0x538d,
            0x6116, 0x709f, 0x0420, 0x15a9, 0x2732, 0x36bb, 0xce4c, 0xdfc5, 0xed5e, 0xfcd7, 0x8868,
            0x99e1, 0xab7a, 0xbaf3, 0x5285, 0x430c, 0x7197, 0x601e, 0x14a1, 0x0528, 0x37b3, 0x263a,
            0xdecd, 0xcf44, 0xfddf, 0xec56, 0x98e9, 0x8960, 0xbbfb, 0xaa72, 0x6306, 0x728f, 0x4014,
            0x519d, 0x2522, 0x34ab, 0x0630, 0x17b9, 0xef4e, 0xfec7, 0xcc5c, 0xddd5, 0xa96a, 0xb8e3,
            0x8a78, 0x9bf1, 0x7387, 0x620e, 0x5095, 0x411c, 0x35a3, 0x242a, 0x16b1, 0x0738, 0xffcf,
            0xee46, 0xdcdd, 0xcd54, 0xb9eb, 0xa862, 0x9af9, 0x8b70, 0x8408, 0x9581, 0xa71a, 0xb693,
            0xc22c, 0xd3a5, 0xe13e, 0xf0b7, 0x0840, 0x19c9, 0x2b52, 0x3adb, 0x4e64, 0x5fed, 0x6d76,
            0x7cff, 0x9489, 0x8500, 0xb79b, 0xa612, 0xd2ad, 0xc324, 0xf1bf, 0xe036, 0x18c1, 0x0948,
            0x3bd3, 0x2a5a, 0x5ee5, 0x4f6c, 0x7df7, 0x6c7e, 0xa50a, 0xb483, 0x8618, 0x9791, 0xe32e,
            0xf2a7, 0xc03c, 0xd1b5, 0x2942, 0x38cb, 0x0a50, 0x1bd9, 0x6f66, 0x7eef, 0x4c74, 0x5dfd,
            0xb58b, 0xa402, 0x9699, 0x8710, 0xf3af, 0xe226, 0xd0bd, 0xc134, 0x39c3, 0x284a, 0x1ad1,
            0x0b58, 0x7fe7, 0x6e6e, 0x5cf5, 0x4d7c, 0xc60c, 0xd785, 0xe51e, 0xf497, 0x8028, 0x91a1,
            0xa33a, 0xb2b3, 0x4a44, 0x5bcd, 0x6956, 0x78df, 0x0c60, 0x1de9, 0x2f72, 0x3efb, 0xd68d,
            0xc704, 0xf59f, 0xe416, 0x90a9, 0x8120, 0xb3bb, 0xa232, 0x5ac5, 0x4b4c, 0x79d7, 0x685e,
            0x1ce1, 0x0d68, 0x3ff3, 0x2e7a, 0xe70e, 0xf687, 0xc41c, 0xd595, 0xa12a, 0xb0a3, 0x8238,
            0x93b1, 0x6b46, 0x7acf, 0x4854, 0x59dd, 0x2d62, 0x3ceb, 0x0e70, 0x1ff9, 0xf78f, 0xe606,
            0xd49d, 0xc514, 0xb1ab, 0xa022, 0x92b9, 0x8330, 0x7bc7, 0x6a4e, 0x58d5, 0x495c, 0x3de3,
            0x2c6a, 0x1ef1, 0x0f78,
        ],
        [
            0x0000, 0x19d8, 0x33b0, 0x2a68, 0x6760, 0x7eb8, 0x54d0, 0x4d08, 0xcec0, 0xd718, 0xfd70,
            0xe4a8, 0xa9a0, 0xb078, 0x9a10, 0x83c8, 0x9591, 0x8c49, 0xa621, 0xbff9, 0xf2f1, 0xeb29,
            0xc141, 0xd899, 0x5b51, 0x4289, 0x68e1, 0x7139, 0x3c31, 0x25e9, 0x0f81, 0x1659, 0x2333,
            0x3aeb, 0x1083, 0x095b, 0x4453, 0x5d8b, 0x77e3, 0x6e3b, 0xedf3, 0xf42b, 0xde43, 0xc79b,
            0x8a93, 0x934b, 0xb923, 0xa0fb, 0xb6a2, 0xaf7a, 0x8512, 0x9cca, 0xd1c2, 0xc81a, 0xe272,
            0xfbaa, 0x7862, 0x61ba, 0x4bd2, 0x520a, 0x1f02, 0x06da, 0x2cb2, 0x356a, 0x4666, 0x5fbe,
            0x75d6, 0x6c0e, 0x2106, 0x38de, 0x12b6, 0x0b6e, 0x88a6, 0x917e, 0xbb16, 0xa2ce, 0xefc6,
            0xf61e, 0xdc76, 0xc5ae, 0xd3f7, 0xca2f, 0xe047, 0xf99f, 0xb497, 0xad4f, 0x8727, 0x9eff,
            0x1d37, 0x04ef, 0x2e87, 0x375f, 0x7a57, 0x638f, 0x49e7, 0x503f, 0x6555, 0x7c8d, 0x56e5,
            0x4f3d, 0x0235, 0x1bed, 0x3185, 0x285d, 0xab95, 0xb24d, 0x9825, 0x81fd, 0xccf5, 0xd52d,
            0xff45, 0xe69d, 0xf0c4, 0xe91c, 0xc374, 0xdaac, 0x97a4, 0x8e7c, 0xa414, 0xbdcc, 0x3e04,
            0x27dc, 0x0db4, 0x146c, 0x5964, 0x40bc, 0x6ad4, 0x730c, 0x8ccc, 0x9514, 0xbf7c, 0xa6a4,
            0xebac, 0xf274, 0xd81c, 0xc1c4, 0x420c, 0x5bd4, 0x71bc, 0x6864, 0x256c, 0x3cb4, 0x16dc,
            0x0f04, 0x195d, 0x0085, 0x2aed, 0x3335, 0x7e3d, 0x67e5, 0x4d8d, 0x5455, 0xd79d, 0xce45,
            0xe42d, 0xfdf5, 0xb0fd, 0xa925, 0x834d, 0x9a95, 0xafff, 0xb627, 0x9c4f, 0x8597, 0xc89f,
            0xd147, 0xfb2f, 0xe2f7, 0x613f, 0x78e7, 0x528f, 0x4b57, 0x065f, 0x1f87, 0x35ef, 0x2c37,
            0x3a6e, 0x23b6, 0x09de, 0x1006, 0x5d0e, 0x44d6, 0x6ebe, 0x7766, 0xf4ae, 0xed76, 0xc71e,
            0xdec6, 0x93ce, 0x8a16, 0xa07e, 0xb9a6, 0xcaaa, 0xd372, 0xf91a, 0xe0c2, 0xadca, 0xb412,
            0x9e7a, 0x87a2, 0x046a, 0x1db2, 0x37da, 0x2e02, 0x630a, 0x7ad2, 0x50ba, 0x4962, 0x5f3b,
            0x46e3, 0x6c8b, 0x7553, 0x385b, 0x2183, 0x0beb, 0x1233, 0x91fb, 0x8823, 0xa24b, 0xbb93,
            0xf69b, 0xef43, 0xc52b, 0xdcf3, 0xe999, 0xf041, 0xda29, 0xc3f1, 0x8ef9, 0x9721, 0xbd49,
            0xa491, 0x2759, 0x3e81, 0x14e9, 0x0d31, 0x4039, 0x59e1, 0x7389, 0x6a51, 0x7c08, 0x65d0,
            0x4fb8, 0x5660, 0x1b68, 0x02b0, 0x28d8, 0x3100, 0xb2c8, 0xab10, 0x8178, 0x98a0, 0xd5a8,
            0xcc70, 0xe618, 0xffc0,
        ],
        [
            0x0000, 0x5adc, 0xb5b8, 0xef64, 0x6361, 0x39bd, 0xd6d9, 0x8c05, 0xc6c2, 0x9c1e, 0x737a,
            0x29a6, 0xa5a3, 0xff7f, 0x101b, 0x4ac7, 0x8595, 0xdf49, 0x302d, 0x6af1, 0xe6f4, 0xbc28,
            0x534c, 0x0990, 0x4357, 0x198b, 0xf6ef, 0xac33, 0x2036, 0x7aea, 0x958e, 0xcf52, 0x033b,
            0x59e7, 0xb683, 0xec5f, 0x605a, 0x3a86, 0xd5e2, 0x8f3e, 0xc5f9, 0x9f25, 0x7041, 0x2a9d,
            0xa698, 0xfc44, 0x1320, 0x49fc, 0x86ae, 0xdc72, 0x3316, 0x69ca, 0xe5cf, 0xbf13, 0x5077,
            0x0aab, 0x406c, 0x1ab0, 0xf5d4, 0xaf08, 0x230d, 0x79d1, 0x96b5, 0xcc69, 0x0676, 0x5caa,
            0xb3ce, 0xe912, 0x6517, 0x3fcb, 0xd0af, 0x8a73, 0xc0b4, 0x9a68, 0x750c, 0x2fd0, 0xa3d5,
            0xf909, 0x166d, 0x4cb1, 0x83e3, 0xd93f, 0x365b, 0x6c87, 0xe082, 0xba5e, 0x553a, 0x0fe6,
            0x4521, 0x1ffd, 0xf099, 0xaa45, 0x2640, 0x7c9c, 0x93f8, 0xc924, 0x054d, 0x5f91, 0xb0f5,
            0xea29, 0x662c, 0x3cf0, 0xd394, 0x8948, 0xc38f, 0x9953, 0x7637, 0x2ceb, 0xa0ee, 0xfa32,
            0x1556, 0x4f8a, 0x80d8, 0xda04, 0x3560, 0x6fbc, 0xe3b9, 0xb965, 0x5601, 0x0cdd, 0x461a,
            0x1cc6, 0xf3a2, 0xa97e, 0x257b, 0x7fa7, 0x90c3, 0xca1f, 0x0cec, 0x5630, 0xb954, 0xe388,
            0x6f8d, 0x3551, 0xda35, 0x80e9, 0xca2e, 0x90f2, 0x7f96, 0x254a, 0xa94f, 0xf393, 0x1cf7,
            0x462b, 0x8979, 0xd3a5, 0x3cc1, 0x661d, 0xea18, 0xb0c4, 0x5fa0, 0x057c, 0x4fbb, 0x1567,
            0xfa03, 0xa0df, 0x2cda, 0x7606, 0x9962, 0xc3be, 0x0fd7, 0x550b, 0xba6f, 0xe0b3, 0x6cb6,
            0x366a, 0xd90e, 0x83d2, 0xc915, 0x93c9, 0x7cad, 0x2671, 0xaa74, 0xf0a8, 0x1fcc, 0x4510,
            0x8a42, 0xd09e, 0x3ffa, 0x6526, 0xe923, 0xb3ff, 0x5c9b, 0x0647, 0x4c80, 0x165c, 0xf938,
            0xa3e4, 0x2fe1, 0x753d, 0x9a59, 0xc085, 0x0a9a, 0x5046, 0xbf22, 0xe5fe, 0x69fb, 0x3327,
            0xdc43, 0x869f, 0xcc58, 0x9684, 0x79e0, 0x233c, 0xaf39, 0xf5e5, 0x1a81, 0x405d, 0x8f0f,
            0xd5d3, 0x3ab7, 0x606b, 0xec6e, 0xb6b2, 0x59d6, 0x030a, 0x49cd, 0x1311, 0xfc75, 0xa6a9,
            0x2aac, 0x7070, 0x9f14, 0xc5c8, 0x09a1, 0x537d, 0xbc19, 0xe6c5, 0x6ac0, 0x301c, 0xdf78,
            0x85a4, 0xcf63, 0x95bf, 0x7adb, 0x2007, 0xac02, 0xf6de, 0x19ba, 0x4366, 0x8c34, 0xd6e8,
            0x398c, 0x6350, 0xef55, 0xb589, 0x5aed, 0x0031, 0x4af6, 0x102a, 0xff4e, 0xa592, 0x2997,
            0x734b, 0x9c2f, 0xc6f3,
        ],
        [
            0x0000, 0x1cbb, 0x3976, 0x25cd, 0x72ec, 0x6e57, 0x4b9a, 0x5721, 0xe5d8, 0xf963, 0xdcae,
            0xc015, 0x9734, 0x8b8f, 0xae42, 0xb2f9, 0xc3a1, 0xdf1a, 0xfad7, 0xe66c, 0xb14d, 0xadf6,
            0x883b, 0x9480, 0x2679, 0x3ac2, 0x1f0f, 0x03b4, 0x5495, 0x482e, 0x6de3, 0x7158, 0x8f53,
            0x93e8, 0xb625, 0xaa9e, 0xfdbf, 0xe104, 0xc4c9, 0xd872, 0x6a8b, 0x7630, 0x53fd, 0x4f46,
            0x1867, 0x04dc, 0x2111, 0x3daa, 0x4cf2, 0x5049, 0x7584, 0x693f, 0x3e1e, 0x22a5, 0x0768,
            0x1bd3, 0xa92a, 0xb591, 0x905c, 0x8ce7, 0xdbc6, 0xc77d, 0xe2b0, 0xfe0b, 0x16b7, 0x0a0c,
            0x2fc1, 0x337a, 0x645b, 0x78e0, 0x5d2d, 0x4196, 0xf36f, 0xefd4, 0xca19, 0xd6a2, 0x8183,
            0x9d38, 0xb8f5, 0xa44e, 0xd516, 0xc9ad, 0xec60, 0xf0db, 0xa7fa, 0xbb41, 0x9e8c, 0x8237,
            0x30ce, 0x2c75, 0x09b8, 0x1503, 0x4222, 0x5e99, 0x7b54, 0x67ef, 0x99e4, 0x855f, 0xa092,
            0xbc29, 0xeb08, 0xf7b3, 0xd27e, 0xcec5, 0x7c3c, 0x6087, 0x454a, 0x59f1, 0x0ed0, 0x126b,
            0x37a6, 0x2b1d, 0x5a45, 0x46fe, 0x6333, 0x7f88, 0x28a9, 0x3412, 0x11df, 0x0d64, 0xbf9d,
            0xa326, 0x86eb, 0x9a50, 0xcd71, 0xd1ca, 0xf407, 0xe8bc, 0x2d6e, 0x31d5, 0x1418, 0x08a3,
            0x5f82, 0x4339, 0x66f4, 0x7a4f, 0xc8b6, 0xd40d, 0xf1c0, 0xed7b, 0xba5a, 0xa6e1, 0x832c,
            0x9f97, 0xeecf, 0xf274, 0xd7b9, 0xcb02, 0x9c23, 0x8098, 0xa555, 0xb9ee, 0x0b17, 0x17ac,
            0x3261, 0x2eda, 0x79fb, 0x6540, 0x408d, 0x5c36, 0xa23d, 0xbe86, 0x9b4b, 0x87f0, 0xd0d1,
            0xcc6a, 0xe9a7, 0xf51c, 0x47e5, 0x5b5e, 0x7e93, 0x6228, 0x3509, 0x29b2, 0x0c7f, 0x10c4,
            0x619c, 0x7d27, 0x58ea, 0x4451, 0x1370, 0x0fcb, 0x2a06, 0x36bd, 0x8444, 0x98ff, 0xbd32,
            0xa189, 0xf6a8, 0xea13, 0xcfde, 0xd365, 0x3bd9, 0x2762, 0x02af, 0x1e14, 0x4935, 0x558e,
            0x7043, 0x6cf8, 0xde01, 0xc2ba, 0xe777, 0xfbcc, 0xaced, 0xb056, 0x959b, 0x8920, 0xf878,
            0xe4c3, 0xc10e, 0xddb5, 0x8a94, 0x962f, 0xb3e2, 0xaf59, 0x1da0, 0x011b, 0x24d6, 0x386d,
            0x6f4c, 0x73f7, 0x563a, 0x4a81, 0xb48a, 0xa831, 0x8dfc, 0x9147, 0xc666, 0xdadd, 0xff10,
            0xe3ab, 0x5152, 0x4de9, 0x6824, 0x749f, 0x23be, 0x3f05, 0x1ac8, 0x0673, 0x772b, 0x6b90,
            0x4e5d, 0x52e6, 0x05c7, 0x197c, 0x3cb1, 0x200a, 0x92f3, 0x8e48, 0xab85, 0xb73e, 0xe01f,
            0xfca4, 0xd969, 0xc5d2,
        ],
        [
            0x0000, 0x0b44, 0x1688, 0x1dcc, 0x2d10, 0x2654, 0x3b98, 0x30dc, 0x5a20, 0x5164, 0x4ca8,
            0x47ec, 0x7730, 0x7c74, 0x61b8, 0x6afc, 0xb440, 0xbf04, 0xa2c8, 0xa98c, 0x9950, 0x9214,
            0x8fd8, 0x849c, 0xee60, 0xe524, 0xf8e8, 0xf3ac, 0xc370, 0xc834, 0xd5f8, 0xdebc, 0x6091,
            0x6bd5, 0x7619, 0x7d5d, 0x4d81, 0x46c5, 0x5b09, 0x504d, 0x3ab1, 0x31f5, 0x2c39, 0x277d,
            0x17a1, 0x1ce5, 0x0129, 0x0a6d, 0xd4d1, 0xdf95, 0xc259, 0xc91d, 0xf9c1, 0xf285, 0xef49,
            0xe40d, 0x8ef1, 0x85b5, 0x9879, 0x933d, 0xa3e1, 0xa8a5, 0xb569, 0xbe2d, 0xc122, 0xca66,
            0xd7aa, 0xdcee, 0xec32, 0xe776, 0xfaba, 0xf1fe, 0x9b02, 0x9046, 0x8d8a, 0x86ce, 0xb612,
            0xbd56, 0xa09a, 0xabde, 0x7562, 0x7e26, 0x63ea, 0x68ae, 0x5872, 0x5336, 0x4efa, 0x45be,
            0x2f42, 0x2406, 0x39ca, 0x328e, 0x0252, 0x0916, 0x14da, 0x1f9e, 0xa1b3, 0xaaf7, 0xb73b,
            0xbc7f, 0x8ca3, 0x87e7, 0x9a2b, 0x916f, 0xfb93, 0xf0d7, 0xed1b, 0xe65f, 0xd683, 0xddc7,
            0xc00b, 0xcb4f, 0x15f3, 0x1eb7, 0x037b, 0x083f, 0x38e3, 0x33a7, 0x2e6b, 0x252f, 0x4fd3,
            0x4497, 0x595b, 0x521f, 0x62c3, 0x6987, 0x744b, 0x7f0f, 0x8a55, 0x8111, 0x9cdd, 0x9799,
            0xa745, 0xac01, 0xb1cd, 0xba89, 0xd075, 0xdb31, 0xc6fd, 0xcdb9, 0xfd65, 0xf621, 0xebed,
            0xe0a9, 0x3e15, 0x3551, 0x289d, 0x23d9, 0x1305, 0x1841, 0x058d, 0x0ec9, 0x6435, 0x6f71,
            0x72bd, 0x79f9, 0x4925, 0x4261, 0x5fad, 0x54e9, 0xeac4, 0xe180, 0xfc4c, 0xf708, 0xc7d4,
            0xcc90, 0xd15c, 0xda18, 0xb0e4, 0xbba0, 0xa66c, 0xad28, 0x9df4, 0x96b0, 0x8b7c, 0x8038,
            0x5e84, 0x55c0, 0x480c, 0x4348, 0x7394, 0x78d0, 0x651c, 0x6e58, 0x04a4, 0x0fe0, 0x122c,
            0x1968, 0x29b4, 0x22f0, 0x3f3c, 0x3478, 0x4b77, 0x4033, 0x5dff, 0x56bb, 0x6667, 0x6d23,
            0x70ef, 0x7bab, 0x1157, 0x1a13, 0x07df, 0x0c9b, 0x3c47, 0x3703, 0x2acf, 0x218b, 0xff37,
            0xf473, 0xe9bf, 0xe2fb, 0xd227, 0xd963, 0xc4af, 0xcfeb, 0xa517, 0xae53, 0xb39f, 0xb8db,
            0x8807, 0x8343, 0x9e8f, 0x95cb, 0x2be6, 0x20a2, 0x3d6e, 0x362a, 0x06f6, 0x0db2, 0x107e,
            0x1b3a, 0x71c6, 0x7a82, 0x674e, 0x6c0a, 0x5cd6, 0x5792, 0x4a5e, 0x411a, 0x9fa6, 0x94e2,
            0x892e, 0x826a, 0xb2b6, 0xb9f2, 0xa43e, 0xaf7a, 0xc586, 0xcec2, 0xd30e, 0xd84a, 0xe896,
            0xe3d2, 0xfe1e, 0xf55a,
        ],
        [
            0x0000, 0x042b, 0x0856, 0x0c7d, 0x10ac, 0x1487, 0x18fa, 0x1cd1, 0x2158, 0x2573, 0x290e,
            0x2d25, 0x31f4, 0x35df, 0x39a2, 0x3d89, 0x42b0, 0x469b, 0x4ae6, 0x4ecd, 0x521c, 0x5637,
            0x5a4a, 0x5e61, 0x63e8, 0x67c3, 0x6bbe, 0x6f95, 0x7344, 0x776f, 0x7b12, 0x7f39, 0x8560,
            0x814b, 0x8d36, 0x891d, 0x95cc, 0x91e7, 0x9d9a, 0x99b1, 0xa438, 0xa013, 0xac6e, 0xa845,
            0xb494, 0xb0bf, 0xbcc2, 0xb8e9, 0xc7d0, 0xc3fb, 0xcf86, 0xcbad, 0xd77c, 0xd357, 0xdf2a,
            0xdb01, 0xe688, 0xe2a3, 0xeede, 0xeaf5, 0xf624, 0xf20f, 0xfe72, 0xfa59, 0x02d1, 0x06fa,
            0x0a87, 0x0eac, 0x127d, 0x1656, 0x1a2b, 0x1e00, 0x2389, 0x27a2, 0x2bdf, 0x2ff4, 0x3325,
            0x370e, 0x3b73, 0x3f58, 0x4061, 0x444a, 0x4837, 0x4c1c, 0x50cd, 0x54e6, 0x589b, 0x5cb0,
            0x6139, 0x6512, 0x696f, 0x6d44, 0x7195, 0x75be, 0x79c3, 0x7de8, 0x87b1, 0x839a, 0x8fe7,
            0x8bcc, 0x971d, 0x9336, 0x9f4b, 0x9b60, 0xa6e9, 0xa2c2, 0xaebf, 0xaa94, 0xb645, 0xb26e,
            0xbe13, 0xba38, 0xc501, 0xc12a, 0xcd57, 0xc97c, 0xd5ad, 0xd186, 0xddfb, 0xd9d0, 0xe459,
            0xe072, 0xec0f, 0xe824, 0xf4f5, 0xf0de, 0xfca3, 0xf888, 0x05a2, 0x0189, 0x0df4, 0x09df,
            0x150e, 0x1125, 0x1d58, 0x1973, 0x24fa, 0x20d1, 0x2cac, 0x2887, 0x3456, 0x307d, 0x3c00,
            0x382b, 0x4712, 0x4339, 0x4f44, 0x4b6f, 0x57be, 0x5395, 0x5fe8, 0x5bc3, 0x664a, 0x6261,
            0x6e1c, 0x6a37, 0x76e6, 0x72cd, 0x7eb0, 0x7a9b, 0x80c2, 0x84e9, 0x8894, 0x8cbf, 0x906e,
            0x9445, 0x9838, 0x9c13, 0xa19a, 0xa5b1, 0xa9cc, 0xade7, 0xb136, 0xb51d, 0xb960, 0xbd4b,
            0xc272, 0xc659, 0xca24, 0xce0f, 0xd2de, 0xd6f5, 0xda88, 0xdea3, 0xe32a, 0xe701, 0xeb7c,
            0xef57, 0xf386, 0xf7ad, 0xfbd0, 0xfffb, 0x0773, 0x0358, 0x0f25, 0x0b0e, 0x17df, 0x13f4,
            0x1f89, 0x1ba2, 0x262b, 0x2200, 0x2e7d, 0x2a56, 0x3687, 0x32ac, 0x3ed1, 0x3afa, 0x45c3,
            0x41e8, 0x4d95, 0x49be, 0x556f, 0x5144, 0x5d39, 0x5912, 0x649b, 0x60b0, 0x6ccd, 0x68e6,
            0x7437, 0x701c, 0x7c61, 0x784a, 0x8213, 0x8638, 0x8a45, 0x8e6e, 0x92bf, 0x9694, 0x9ae9,
            0x9ec2, 0xa34b, 0xa760, 0xab1d, 0xaf36, 0xb3e7, 0xb7cc, 0xbbb1, 0xbf9a, 0xc0a3, 0xc488,
            0xc8f5, 0xccde, 0xd00f, 0xd424, 0xd859, 0xdc72, 0xe1fb, 0xe5d0, 0xe9ad, 0xed86, 0xf157,
            0xf57c, 0xf901, 0xfd2a,
        ],
        [
            0x0000, 0x9fd5, 0x37bb, 0xa86e, 0x6f76, 0xf0a3, 0x58cd, 0xc718, 0xdeec, 0x4139, 0xe957,
            0x7682, 0xb19a, 0x2e4f, 0x8621, 0x19f4, 0xb5c9, 0x2a1c, 0x8272, 0x1da7, 0xdabf, 0x456a,
            0xed04, 0x72d1, 0x6b25, 0xf4f0, 0x5c9e, 0xc34b, 0x0453, 0x9b86, 0x33e8, 0xac3d, 0x6383,
            0xfc56, 0x5438, 0xcbed, 0x0cf5, 0x9320, 0x3b4e, 0xa49b, 0xbd6f, 0x22ba, 0x8ad4, 0x1501,
            0xd219, 0x4dcc, 0xe5a2, 0x7a77, 0xd64a, 0x499f, 0xe1f1, 0x7e24, 0xb93c, 0x26e9, 0x8e87,
            0x1152, 0x08a6, 0x9773, 0x3f1d, 0xa0c8, 0x67d0, 0xf805, 0x506b, 0xcfbe, 0xc706, 0x58d3,
            0xf0bd, 0x6f68, 0xa870, 0x37a5, 0x9fcb, 0x001e, 0x19ea, 0x863f, 0x2e51, 0xb184, 0x769c,
            0xe949, 0x4127, 0xdef2, 0x72cf, 0xed1a, 0x4574, 0xdaa1, 0x1db9, 0x826c, 0x2a02, 0xb5d7,
            0xac23, 0x33f6, 0x9b98, 0x044d, 0xc355, 0x5c80, 0xf4ee, 0x6b3b, 0xa485, 0x3b50, 0x933e,
            0x0ceb, 0xcbf3, 0x5426, 0xfc48, 0x639d, 0x7a69, 0xe5bc, 0x4dd2, 0xd207, 0x151f, 0x8aca,
            0x22a4, 0xbd71, 0x114c, 0x8e99, 0x26f7, 0xb922, 0x7e3a, 0xe1ef, 0x4981, 0xd654, 0xcfa0,
            0x5075, 0xf81b, 0x67ce, 0xa0d6, 0x3f03, 0x976d, 0x08b8, 0x861d, 0x19c8, 0xb1a6, 0x2e73,
            0xe96b, 0x76be, 0xded0, 0x4105, 0x58f1, 0xc724, 0x6f4a, 0xf09f, 0x3787, 0xa852, 0x003c,
            0x9fe9, 0x33d4, 0xac01, 0x046f, 0x9bba, 0x5ca2, 0xc377, 0x6b19, 0xf4cc, 0xed38, 0x72ed,
            0xda83, 0x4556, 0x824e, 0x1d9b, 0xb5f5, 0x2a20, 0xe59e, 0x7a4b, 0xd225, 0x4df0, 0x8ae8,
            0x153d, 0xbd53, 0x2286, 0x3b72, 0xa4a7, 0x0cc9, 0x931c, 0x5404, 0xcbd1, 0x63bf, 0xfc6a,
            0x5057, 0xcf82, 0x67ec, 0xf839, 0x3f21, 0xa0f4, 0x089a, 0x974f, 0x8ebb, 0x116e, 0xb900,
            0x26d5, 0xe1cd, 0x7e18, 0xd676, 0x49a3, 0x411b, 0xdece, 0x76a0, 0xe975, 0x2e6d, 0xb1b8,
            0x19d6, 0x8603, 0x9ff7, 0x0022, 0xa84c, 0x3799, 0xf081, 0x6f54, 0xc73a, 0x58ef, 0xf4d2,
            0x6b07, 0xc369, 0x5cbc, 0x9ba4, 0x0471, 0xac1f, 0x33ca, 0x2a3e, 0xb5eb, 0x1d85, 0x8250,
            0x4548, 0xda9d, 0x72f3, 0xed26, 0x2298, 0xbd4d, 0x1523, 0x8af6, 0x4dee, 0xd23b, 0x7a55,
            0xe580, 0xfc74, 0x63a1, 0xcbcf, 0x541a, 0x9302, 0x0cd7, 0xa4b9, 0x3b6c, 0x9751, 0x0884,
            0xa0ea, 0x3f3f, 0xf827, 0x67f2, 0xcf9c, 0x5049, 0x49bd, 0xd668, 0x7e06, 0xe1d3, 0x26cb,
            0xb91e, 0x1170, 0x8ea5,
        ],
        [
            0x0000, 0x81bf, 0x0b6f, 0x8ad0, 0x16de, 0x9761, 0x1db1, 0x9c0e, 0x2dbc, 0xac03, 0x26d3,
            0xa76c, 0x3b62, 0xbadd, 0x300d, 0xb1b2, 0x5b78, 0xdac7, 0x5017, 0xd1a8, 0x4da6, 0xcc19,
            0x46c9, 0xc776, 0x76c4, 0xf77b, 0x7dab, 0xfc14, 0x601a, 0xe1a5, 0x6b75, 0xeaca, 0xb6f0,
            0x374f, 0xbd9f, 0x3c20, 0xa02e, 0x2191, 0xab41, 0x2afe, 0x9b4c, 0x1af3, 0x9023, 0x119c,
            0x8d92, 0x0c2d, 0x86fd, 0x0742, 0xed88, 0x6c37, 0xe6e7, 0x6758, 0xfb56, 0x7ae9, 0xf039,
            0x7186, 0xc034, 0x418b, 0xcb5b, 0x4ae4, 0xd6ea, 0x5755, 0xdd85, 0x5c3a, 0x65f1, 0xe44e,
            0x6e9e, 0xef21, 0x732f, 0xf290, 0x7840, 0xf9ff, 0x484d, 0xc9f2, 0x4322, 0xc29d, 0x5e93,
            0xdf2c, 0x55fc, 0xd443, 0x3e89, 0xbf36, 0x35e6, 0xb459, 0x2857, 0xa9e8, 0x2338, 0xa287,
            0x1335, 0x928a, 0x185a, 0x99e5, 0x05eb, 0x8454, 0x0e84, 0x8f3b, 0xd301, 0x52be, 0xd86e,
            0x59d1, 0xc5df, 0x4460, 0xceb0, 0x4f0f, 0xfebd, 0x7f02, 0xf5d2, 0x746d, 0xe863, 0x69dc,
            0xe30c, 0x62b3, 0x8879, 0x09c6, 0x8316, 0x02a9, 0x9ea7, 0x1f18, 0x95c8, 0x1477, 0xa5c5,
            0x247a, 0xaeaa, 0x2f15, 0xb31b, 0x32a4, 0xb874, 0x39cb, 0xcbe2, 0x4a5d, 0xc08d, 0x4132,
            0xdd3c, 0x5c83, 0xd653, 0x57ec, 0xe65e, 0x67e1, 0xed31, 0x6c8e, 0xf080, 0x713f, 0xfbef,
            0x7a50, 0x909a, 0x1125, 0x9bf5, 0x1a4a, 0x8644, 0x07fb, 0x8d2b, 0x0c94, 0xbd26, 0x3c99,
            0xb649, 0x37f6, 0xabf8, 0x2a47, 0xa097, 0x2128, 0x7d12, 0xfcad, 0x767d, 0xf7c2, 0x6bcc,
            0xea73, 0x60a3, 0xe11c, 0x50ae, 0xd111, 0x5bc1, 0xda7e, 0x4670, 0xc7cf, 0x4d1f, 0xcca0,
            0x266a, 0xa7d5, 0x2d05, 0xacba, 0x30b4, 0xb10b, 0x3bdb, 0xba64, 0x0bd6, 0x8a69, 0x00b9,
            0x8106, 0x1d08, 0x9cb7, 0x1667, 0x97d8, 0xae13, 0x2fac, 0xa57c, 0x24c3, 0xb8cd, 0x3972,
            0xb3a2, 0x321d, 0x83af, 0x0210, 0x88c0, 0x097f, 0x9571, 0x14ce, 0x9e1e, 0x1fa1, 0xf56b,
            0x74d4, 0xfe04, 0x7fbb, 0xe3b5, 0x620a, 0xe8da, 0x6965, 0xd8d7, 0x5968, 0xd3b8, 0x5207,
            0xce09, 0x4fb6, 0xc566, 0x44d9, 0x18e3, 0x995c, 0x138c, 0x9233, 0x0e3d, 0x8f82, 0x0552,
            0x84ed, 0x355f, 0xb4e0, 0x3e30, 0xbf8f, 0x2381, 0xa23e, 0x28ee, 0xa951, 0x439b, 0xc224,
            0x48f4, 0xc94b, 0x5545, 0xd4fa, 0x5e2a, 0xdf95, 0x6e27, 0xef98, 0x6548, 0xe4f7, 0x78f9,
            0xf946, 0x7396, 0xf229,
        ],
        [
            0x0000, 0x4dfd, 0x9bfa, 0xd607, 0x3fe5, 0x7218, 0xa41f, 0xe9e2, 0x7fca, 0x3237, 0xe430,
            0xa9cd, 0x402f, 0x0dd2, 0xdbd5, 0x9628, 0xff94, 0xb269, 0x646e, 0x2993, 0xc071, 0x8d8c,
            0x5b8b, 0x1676, 0x805e, 0xcda3, 0x1ba4, 0x5659, 0xbfbb, 0xf246, 0x2441, 0x69bc, 0xf739,
            0xbac4, 0x6cc3, 0x213e, 0xc8dc, 0x8521, 0x5326, 0x1edb, 0x88f3, 0xc50e, 0x1309, 0x5ef4,
            0xb716, 0xfaeb, 0x2cec, 0x6111, 0x08ad, 0x4550, 0x9357, 0xdeaa, 0x3748, 0x7ab5, 0xacb2,
            0xe14f, 0x7767, 0x3a9a, 0xec9d, 0xa160, 0x4882, 0x057f, 0xd378, 0x9e85, 0xe663, 0xab9e,
            0x7d99, 0x3064, 0xd986, 0x947b, 0x427c, 0x0f81, 0x99a9, 0xd454, 0x0253, 0x4fae, 0xa64c,
            0xebb1, 0x3db6, 0x704b, 0x19f7, 0x540a, 0x820d, 0xcff0, 0x2612, 0x6bef, 0xbde8, 0xf015,
            0x663d, 0x2bc0, 0xfdc7, 0xb03a, 0x59d8, 0x1425, 0xc222, 0x8fdf, 0x115a, 0x5ca7, 0x8aa0,
            0xc75d, 0x2ebf, 0x6342, 0xb545, 0xf8b8, 0x6e90, 0x236d, 0xf56a, 0xb897, 0x5175, 0x1c88,
            0xca8f, 0x8772, 0xeece, 0xa333, 0x7534, 0x38c9, 0xd12b, 0x9cd6, 0x4ad1, 0x072c, 0x9104,
            0xdcf9, 0x0afe, 0x4703, 0xaee1, 0xe31c, 0x351b, 0x78e6, 0xc4d7, 0x892a, 0x5f2d, 0x12d0,
            0xfb32, 0xb6cf, 0x60c8, 0x2d35, 0xbb1d, 0xf6e0, 0x20e7, 0x6d1a, 0x84f8, 0xc905, 0x1f02,
            0x52ff, 0x3b43, 0x76be, 0xa0b9, 0xed44, 0x04a6, 0x495b, 0x9f5c, 0xd2a1, 0x4489, 0x0974,
            0xdf73, 0x928e, 0x7b6c, 0x3691, 0xe096, 0xad6b, 0x33ee, 0x7e13, 0xa814, 0xe5e9, 0x0c0b,
            0x41f6, 0x97f1, 0xda0c, 0x4c24, 0x01d9, 0xd7de, 0x9a23, 0x73c1, 0x3e3c, 0xe83b, 0xa5c6,
            0xcc7a, 0x8187, 0x5780, 0x1a7d, 0xf39f, 0xbe62, 0x6865, 0x2598, 0xb3b0, 0xfe4d, 0x284a,
            0x65b7, 0x8c55, 0xc1a8, 0x17af, 0x5a52, 0x22b4, 0x6f49, 0xb94e, 0xf4b3, 0x1d51, 0x50ac,
            0x86ab, 0xcb56, 0x5d7e, 0x1083, 0xc684, 0x8b79, 0x629b, 0x2f66, 0xf961, 0xb49c, 0xdd20,
            0x90dd, 0x46da, 0x0b27, 0xe2c5, 0xaf38, 0x793f, 0x34c2, 0xa2ea, 0xef17, 0x3910, 0x74ed,
            0x9d0f, 0xd0f2, 0x06f5, 0x4b08, 0xd58d, 0x9870, 0x4e77, 0x038a, 0xea68, 0xa795, 0x7192,
            0x3c6f, 0xaa47, 0xe7ba, 0x31bd, 0x7c40, 0x95a2, 0xd85f, 0x0e58, 0x43a5, 0x2a19, 0x67e4,
            0xb1e3, 0xfc1e, 0x15fc, 0x5801, 0x8e06, 0xc3fb, 0x55d3, 0x182e, 0xce29, 0x83d4, 0x6a36,
            0x27cb, 0xf1cc, 0xbc31,
        ],
        [
            0x0000, 0x2c27, 0x584e, 0x7469, 0xb09c, 0x9cbb, 0xe8d2, 0xc4f5, 0x6929, 0x450e, 0x3167,
            0x1d40, 0xd9b5, 0xf592, 0x81fb, 0xaddc, 0xd252, 0xfe75, 0x8a1c, 0xa63b, 0x62ce, 0x4ee9,
            0x3a80, 0x16a7, 0xbb7b, 0x975c, 0xe335, 0xcf12, 0x0be7, 0x27c0, 0x53a9, 0x7f8e, 0xacb5,
            0x8092, 0xf4fb, 0xd8dc, 0x1c29, 0x300e, 0x4467, 0x6840, 0xc59c, 0xe9bb, 0x9dd2, 0xb1f5,
            0x7500, 0x5927, 0x2d4e, 0x0169, 0x7ee7, 0x52c0, 0x26a9, 0x0a8e, 0xce7b, 0xe25c, 0x9635,
            0xba12, 0x17ce, 0x3be9, 0x4f80, 0x63a7, 0xa752, 0x8b75, 0xff1c, 0xd33b, 0x517b, 0x7d5c,
            0x0935, 0x2512, 0xe1e7, 0xcdc0, 0xb9a9, 0x958e, 0x3852, 0x1475, 0x601c, 0x4c3b, 0x88ce,
            0xa4e9, 0xd080, 0xfca7, 0x8329, 0xaf0e, 0xdb67, 0xf740, 0x33b5, 0x1f92, 0x6bfb, 0x47dc,
            0xea00, 0xc627, 0xb24e, 0x9e69, 0x5a9c, 0x76bb, 0x02d2, 0x2ef5, 0xfdce, 0xd1e9, 0xa580,
            0x89a7, 0x4d52, 0x6175, 0x151c, 0x393b, 0x94e7, 0xb8c0, 0xcca9, 0xe08e, 0x247b, 0x085c,
            0x7c35, 0x5012, 0x2f9c, 0x03bb, 0x77d2, 0x5bf5, 0x9f00, 0xb327, 0xc74e, 0xeb69, 0x46b5,
            0x6a92, 0x1efb, 0x32dc, 0xf629, 0xda0e, 0xae67, 0x8240, 0xa2f6, 0x8ed1, 0xfab8, 0xd69f,
            0x126a, 0x3e4d, 0x4a24, 0x6603, 0xcbdf, 0xe7f8, 0x9391, 0xbfb6, 0x7b43, 0x5764, 0x230d,
            0x0f2a, 0x70a4, 0x5c83, 0x28ea, 0x04cd, 0xc038, 0xec1f, 0x9876, 0xb451, 0x198d, 0x35aa,
            0x41c3, 0x6de4, 0xa911, 0x8536, 0xf15f, 0xdd78, 0x0e43, 0x2264, 0x560d, 0x7a2a, 0xbedf,
            0x92f8, 0xe691, 0xcab6, 0x676a, 0x4b4d, 0x3f24, 0x1303, 0xd7f6, 0xfbd1, 0x8fb8, 0xa39f,
            0xdc11, 0xf036, 0x845f, 0xa878, 0x6c8d, 0x40aa, 0x34c3, 0x18e4, 0xb538, 0x991f, 0xed76,
            0xc151, 0x05a4, 0x2983, 0x5dea, 0x71cd, 0xf38d, 0xdfaa, 0xabc3, 0x87e4, 0x4311, 0x6f36,
            0x1b5f, 0x3778, 0x9aa4, 0xb683, 0xc2ea, 0xeecd, 0x2a38, 0x061f, 0x7276, 0x5e51, 0x21df,
            0x0df8, 0x7991, 0x55b6, 0x9143, 0xbd64, 0xc90d, 0xe52a, 0x48f6, 0x64d1, 0x10b8, 0x3c9f,
            0xf86a, 0xd44d, 0xa024, 0x8c03, 0x5f38, 0x731f, 0x0776, 0x2b51, 0xefa4, 0xc383, 0xb7ea,
            0x9bcd, 0x3611, 0x1a36, 0x6e5f, 0x4278, 0x868d, 0xaaaa, 0xdec3, 0xf2e4, 0x8d6a, 0xa14d,
            0xd524, 0xf903, 0x3df6, 0x11d1, 0x65b8, 0x499f, 0xe443, 0xc864, 0xbc0d, 0x902a, 0x54df,
            0x78f8, 0x0c91, 0x20b6,
        ],
        [
            0x0000, 0x5591, 0xab22, 0xfeb3, 0x5e55, 0x0bc4, 0xf577, 0xa0e6, 0xbcaa, 0xe93b, 0x1788,
            0x4219, 0xe2ff, 0xb76e, 0x49dd, 0x1c4c, 0x7145, 0x24d4, 0xda67, 0x8ff6, 0x2f10, 0x7a81,
            0x8432, 0xd1a3, 0xcdef, 0x987e, 0x66cd, 0x335c, 0x93ba, 0xc62b, 0x3898, 0x6d09, 0xe28a,
            0xb71b, 0x49a8, 0x1c39, 0xbcdf, 0xe94e, 0x17fd, 0x426c, 0x5e20, 0x0bb1, 0xf502, 0xa093,
            0x0075, 0x55e4, 0xab57, 0xfec6, 0x93cf, 0xc65e, 0x38ed, 0x6d7c, 0xcd9a, 0x980b, 0x66b8,
            0x3329, 0x2f65, 0x7af4, 0x8447, 0xd1d6, 0x7130, 0x24a1, 0xda12, 0x8f83, 0xcd05, 0x9894,
            0x6627, 0x33b6, 0x9350, 0xc6c1, 0x3872, 0x6de3, 0x71af, 0x243e, 0xda8d, 0x8f1c, 0x2ffa,
            0x7a6b, 0x84d8, 0xd149, 0xbc40, 0xe9d1, 0x1762, 0x42f3, 0xe215, 0xb784, 0x4937, 0x1ca6,
            0x00ea, 0x557b, 0xabc8, 0xfe59, 0x5ebf, 0x0b2e, 0xf59d, 0xa00c, 0x2f8f, 0x7a1e, 0x84ad,
            0xd13c, 0x71da, 0x244b, 0xdaf8, 0x8f69, 0x9325, 0xc6b4, 0x3807, 0x6d96, 0xcd70, 0x98e1,
            0x6652, 0x33c3, 0x5eca, 0x0b5b, 0xf5e8, 0xa079, 0x009f, 0x550e, 0xabbd, 0xfe2c, 0xe260,
            0xb7f1, 0x4942, 0x1cd3, 0xbc35, 0xe9a4, 0x1717, 0x4286, 0x921b, 0xc78a, 0x3939, 0x6ca8,
            0xcc4e, 0x99df, 0x676c, 0x32fd, 0x2eb1, 0x7b20, 0x8593, 0xd002, 0x70e4, 0x2575, 0xdbc6,
            0x8e57, 0xe35e, 0xb6cf, 0x487c, 0x1ded, 0xbd0b, 0xe89a, 0x1629, 0x43b8, 0x5ff4, 0x0a65,
            0xf4d6, 0xa147, 0x01a1, 0x5430, 0xaa83, 0xff12, 0x7091, 0x2500, 0xdbb3, 0x8e22, 0x2ec4,
            0x7b55, 0x85e6, 0xd077, 0xcc3b, 0x99aa, 0x6719, 0x3288, 0x926e, 0xc7ff, 0x394c, 0x6cdd,
            0x01d4, 0x5445, 0xaaf6, 0xff67, 0x5f81, 0x0a10, 0xf4a3, 0xa132, 0xbd7e, 0xe8ef, 0x165c,
            0x43cd, 0xe32b, 0xb6ba, 0x4809, 0x1d98, 0x5f1e, 0x0a8f, 0xf43c, 0xa1ad, 0x014b, 0x54da,
            0xaa69, 0xfff8, 0xe3b4, 0xb625, 0x4896, 0x1d07, 0xbde1, 0xe870, 0x16c3, 0x4352, 0x2e5b,
            0x7bca, 0x8579, 0xd0e8, 0x700e, 0x259f, 0xdb2c, 0x8ebd, 0x92f1, 0xc760, 0x39d3, 0x6c42,
            0xcca4, 0x9935, 0x6786, 0x3217, 0xbd94, 0xe805, 0x16b6, 0x4327, 0xe3c1, 0xb650, 0x48e3,
            0x1d72, 0x013e, 0x54af, 0xaa1c, 0xff8d, 0x5f6b, 0x0afa, 0xf449, 0xa1d8, 0xccd1, 0x9940,
            0x67f3, 0x3262, 0x9284, 0xc715, 0x39a6, 0x6c37, 0x707b, 0x25ea, 0xdb59, 0x8ec8, 0x2e2e,
            0x7bbf, 0x850c, 0xd09d,
        ],
        [
            0x0000, 0x8555, 0x02bb, 0x87ee, 0x0576, 0x8023, 0x07cd, 0x8298, 0x0aec, 0x8fb9, 0x0857,
            0x8d02, 0x0f9a, 0x8acf, 0x0d21, 0x8874, 0x15d8, 0x908d, 0x1763, 0x9236, 0x10ae, 0x95fb,
            0x1215, 0x9740, 0x1f34, 0x9a61, 0x1d8f, 0x98da, 0x1a42, 0x9f17, 0x18f9, 0x9dac, 0x2bb0,
            0xaee5, 0x290b, 0xac5e, 0x2ec6, 0xab93, 0x2c7d, 0xa928, 0x215c, 0xa409, 0x23e7, 0xa6b2,
            0x242a, 0xa17f, 0x2691, 0xa3c4, 0x3e68, 0xbb3d, 0x3cd3, 0xb986, 0x3b1e, 0xbe4b, 0x39a5,
            0xbcf0, 0x3484, 0xb1d1, 0x363f, 0xb36a, 0x31f2, 0xb4a7, 0x3349, 0xb61c, 0x5760, 0xd235,
            0x55db, 0xd08e, 0x5216, 0xd743, 0x50ad, 0xd5f8, 0x5d8c, 0xd8d9, 0x5f37, 0xda62, 0x58fa,
            0xddaf, 0x5a41, 0xdf14, 0x42b8, 0xc7ed, 0x4003, 0xc556, 0x47ce, 0xc29b, 0x4575, 0xc020,
            0x4854, 0xcd01, 0x4aef, 0xcfba, 0x4d22, 0xc877, 0x4f99, 0xcacc, 0x7cd0, 0xf985, 0x7e6b,
            0xfb3e, 0x79a6, 0xfcf3, 0x7b1d, 0xfe48, 0x763c, 0xf369, 0x7487, 0xf1d2, 0x734a, 0xf61f,
            0x71f1, 0xf4a4, 0x6908, 0xec5d, 0x6bb3, 0xeee6, 0x6c7e, 0xe92b, 0x6ec5, 0xeb90, 0x63e4,
            0xe6b1, 0x615f, 0xe40a, 0x6692, 0xe3c7, 0x6429, 0xe17c, 0xaec0, 0x2b95, 0xac7b, 0x292e,
            0xabb6, 0x2ee3, 0xa90d, 0x2c58, 0xa42c, 0x2179, 0xa697, 0x23c2, 0xa15a, 0x240f, 0xa3e1,
            0x26b4, 0xbb18, 0x3e4d, 0xb9a3, 0x3cf6, 0xbe6e, 0x3b3b, 0xbcd5, 0x3980, 0xb1f4, 0x34a1,
            0xb34f, 0x361a, 0xb482, 0x31d7, 0xb639, 0x336c, 0x8570, 0x0025, 0x87cb, 0x029e, 0x8006,
            0x0553, 0x82bd, 0x07e8, 0x8f9c, 0x0ac9, 0x8d27, 0x0872, 0x8aea, 0x0fbf, 0x8851, 0x0d04,
            0x90a8, 0x15fd, 0x9213, 0x1746, 0x95de, 0x108b, 0x9765, 0x1230, 0x9a44, 0x1f11, 0x98ff,
            0x1daa, 0x9f32, 0x1a67, 0x9d89, 0x18dc, 0xf9a0, 0x7cf5, 0xfb1b, 0x7e4e, 0xfcd6, 0x7983,
            0xfe6d, 0x7b38, 0xf34c, 0x7619, 0xf1f7, 0x74a2, 0xf63a, 0x736f, 0xf481, 0x71d4, 0xec78,
            0x692d, 0xeec3, 0x6b96, 0xe90e, 0x6c5b, 0xebb5, 0x6ee0, 0xe694, 0x63c1, 0xe42f, 0x617a,
            0xe3e2, 0x66b7, 0xe159, 0x640c, 0xd210, 0x5745, 0xd0ab, 0x55fe, 0xd766, 0x5233, 0xd5dd,
            0x5088, 0xd8fc, 0x5da9, 0xda47, 0x5f12, 0xdd8a, 0x58df, 0xdf31, 0x5a64, 0xc7c8, 0x429d,
            0xc573, 0x4026, 0xc2be, 0x47eb, 0xc005, 0x4550, 0xcd24, 0x4871, 0xcf9f, 0x4aca, 0xc852,
            0x4d07, 0xcae9, 0x4fbc,
        ],
        [
            0x0000, 0x05ad, 0x0b5a, 0x0ef7, 0x16b4, 0x1319, 0x1dee, 0x1843, 0x2d68, 0x28c5, 0x2632,
            0x239f, 0x3bdc, 0x3e71, 0x3086, 0x352b, 0x5ad0, 0x5f7d, 0x518a, 0x5427, 0x4c64, 0x49c9,
            0x473e, 0x4293, 0x77b8, 0x7215, 0x7ce2, 0x794f, 0x610c, 0x64a1, 0x6a56, 0x6ffb, 0xb5a0,
            0xb00d, 0xbefa, 0xbb57, 0xa314, 0xa6b9, 0xa84e, 0xade3, 0x98c8, 0x9d65, 0x9392, 0x963f,
            0x8e7c, 0x8bd1, 0x8526, 0x808b, 0xef70, 0xeadd, 0xe42a, 0xe187, 0xf9c4, 0xfc69, 0xf29e,
            0xf733, 0xc218, 0xc7b5, 0xc942, 0xccef, 0xd4ac, 0xd101, 0xdff6, 0xda5b, 0x6351, 0x66fc,
            0x680b, 0x6da6, 0x75e5, 0x7048, 0x7ebf, 0x7b12, 0x4e39, 0x4b94, 0x4563, 0x40ce, 0x588d,
            0x5d20, 0x53d7, 0x567a, 0x3981, 0x3c2c, 0x32db, 0x3776, 0x2f35, 0x2a98, 0x246f, 0x21c2,
            0x14e9, 0x1144, 0x1fb3, 0x1a1e, 0x025d, 0x07f0, 0x0907, 0x0caa, 0xd6f1, 0xd35c, 0xddab,
            0xd806, 0xc045, 0xc5e8, 0xcb1f, 0xceb2, 0xfb99, 0xfe34, 0xf0c3, 0xf56e, 0xed2d, 0xe880,
            0xe677, 0xe3da, 0x8c21, 0x898c, 0x877b, 0x82d6, 0x9a95, 0x9f38, 0x91cf, 0x9462, 0xa149,
            0xa4e4, 0xaa13, 0xafbe, 0xb7fd, 0xb250, 0xbca7, 0xb90a, 0xc6a2, 0xc30f, 0xcdf8, 0xc855,
            0xd016, 0xd5bb, 0xdb4c, 0xdee1, 0xebca, 0xee67, 0xe090, 0xe53d, 0xfd7e, 0xf8d3, 0xf624,
            0xf389, 0x9c72, 0x99df, 0x9728, 0x9285, 0x8ac6, 0x8f6b, 0x819c, 0x8431, 0xb11a, 0xb4b7,
            0xba40, 0xbfed, 0xa7ae, 0xa203, 0xacf4, 0xa959, 0x7302, 0x76af, 0x7858, 0x7df5, 0x65b6,
            0x601b, 0x6eec, 0x6b41, 0x5e6a, 0x5bc7, 0x5530, 0x509d, 0x48de, 0x4d73, 0x4384, 0x4629,
            0x29d2, 0x2c7f, 0x2288, 0x2725, 0x3f66, 0x3acb, 0x343c, 0x3191, 0x04ba, 0x0117, 0x0fe0,
            0x0a4d, 0x120e, 0x17a3, 0x1954, 0x1cf9, 0xa5f3, 0xa05e, 0xaea9, 0xab04, 0xb347, 0xb6ea,
            0xb81d, 0xbdb0, 0x889b, 0x8d36, 0x83c1, 0x866c, 0x9e2f, 0x9b82, 0x9575, 0x90d8, 0xff23,
            0xfa8e, 0xf479, 0xf1d4, 0xe997, 0xec3a, 0xe2cd, 0xe760, 0xd24b, 0xd7e6, 0xd911, 0xdcbc,
            0xc4ff, 0xc152, 0xcfa5, 0xca08, 0x1053, 0x15fe, 0x1b09, 0x1ea4, 0x06e7, 0x034a, 0x0dbd,
            0x0810, 0x3d3b, 0x3896, 0x3661, 0x33cc, 0x2b8f, 0x2e22, 0x20d5, 0x2578, 0x4a83, 0x4f2e,
            0x41d9, 0x4474, 0x5c37, 0x599a, 0x576d, 0x52c0, 0x67eb, 0x6246, 0x6cb1, 0x691c, 0x715f,
            0x74f2, 0x7a05, 0x7fa8,
        ],
        [
            0x0000, 0x7eea, 0xfdd4, 0x833e, 0xf3b9, 0x8d53, 0x0e6d, 0x7087, 0xef63, 0x9189, 0x12b7,
            0x6c5d, 0x1cda, 0x6230, 0xe10e, 0x9fe4, 0xd6d7, 0xa83d, 0x2b03, 0x55e9, 0x256e, 0x5b84,
            0xd8ba, 0xa650, 0x39b4, 0x475e, 0xc460, 0xba8a, 0xca0d, 0xb4e7, 0x37d9, 0x4933, 0xa5bf,
            0xdb55, 0x586b, 0x2681, 0x5606, 0x28ec, 0xabd2, 0xd538, 0x4adc, 0x3436, 0xb708, 0xc9e2,
            0xb965, 0xc78f, 0x44b1, 0x3a5b, 0x7368, 0x0d82, 0x8ebc, 0xf056, 0x80d1, 0xfe3b, 0x7d05,
            0x03ef, 0x9c0b, 0xe2e1, 0x61df, 0x1f35, 0x6fb2, 0x1158, 0x9266, 0xec8c, 0x436f, 0x3d85,
            0xbebb, 0xc051, 0xb0d6, 0xce3c, 0x4d02, 0x33e8, 0xac0c, 0xd2e6, 0x51d8, 0x2f32, 0x5fb5,
            0x215f, 0xa261, 0xdc8b, 0x95b8, 0xeb52, 0x686c, 0x1686, 0x6601, 0x18eb, 0x9bd5, 0xe53f,
            0x7adb, 0x0431, 0x870f, 0xf9e5, 0x8962, 0xf788, 0x74b6, 0x0a5c, 0xe6d0, 0x983a, 0x1b04,
            0x65ee, 0x1569, 0x6b83, 0xe8bd, 0x9657, 0x09b3, 0x7759, 0xf467, 0x8a8d, 0xfa0a, 0x84e0,
            0x07de, 0x7934, 0x3007, 0x4eed, 0xcdd3, 0xb339, 0xc3be, 0xbd54, 0x3e6a, 0x4080, 0xdf64,
            0xa18e, 0x22b0, 0x5c5a, 0x2cdd, 0x5237, 0xd109, 0xafe3, 0x86de, 0xf834, 0x7b0a, 0x05e0,
            0x7567, 0x0b8d, 0x88b3, 0xf659, 0x69bd, 0x1757, 0x9469, 0xea83, 0x9a04, 0xe4ee, 0x67d0,
            0x193a, 0x5009, 0x2ee3, 0xaddd, 0xd337, 0xa3b0, 0xdd5a, 0x5e64, 0x208e, 0xbf6a, 0xc180,
            0x42be, 0x3c54, 0x4cd3, 0x3239, 0xb107, 0xcfed, 0x2361, 0x5d8b, 0xdeb5, 0xa05f, 0xd0d8,
            0xae32, 0x2d0c, 0x53e6, 0xcc02, 0xb2e8, 0x31d6, 0x4f3c, 0x3fbb, 0x4151, 0xc26f, 0xbc85,
            0xf5b6, 0x8b5c, 0x0862, 0x7688, 0x060f, 0x78e5, 0xfbdb, 0x8531, 0x1ad5, 0x643f, 0xe701,
            0x99eb, 0xe96c, 0x9786, 0x14b8, 0x6a52, 0xc5b1, 0xbb5b, 0x3865, 0x468f, 0x3608, 0x48e2,
            0xcbdc, 0xb536, 0x2ad2, 0x5438, 0xd706, 0xa9ec, 0xd96b, 0xa781, 0x24bf, 0x5a55, 0x1366,
            0x6d8c, 0xeeb2, 0x9058, 0xe0df, 0x9e35, 0x1d0b, 0x63e1, 0xfc05, 0x82ef, 0x01d1, 0x7f3b,
            0x0fbc, 0x7156, 0xf268, 0x8c82, 0x600e, 0x1ee4, 0x9dda, 0xe330, 0x93b7, 0xed5d, 0x6e63,
            0x1089, 0x8f6d, 0xf187, 0x72b9, 0x0c53, 0x7cd4, 0x023e, 0x8100, 0xffea, 0xb6d9, 0xc833,
            0x4b0d, 0x35e7, 0x4560, 0x3b8a, 0xb8b4, 0xc65e, 0x59ba, 0x2750, 0xa46e, 0xda84, 0xaa03,
            0xd4e9, 0x57d7, 0x293d,
        ],
        [
            0x0000, 0x482a, 0x9054, 0xd87e, 0x28b9, 0x6093, 0xb8ed, 0xf0c7, 0x5172, 0x1958, 0xc126,
            0x890c, 0x79cb, 0x31e1, 0xe99f, 0xa1b5, 0xa2e4, 0xeace, 0x32b0, 0x7a9a, 0x8a5d, 0xc277,
            0x1a09, 0x5223, 0xf396, 0xbbbc, 0x63c2, 0x2be8, 0xdb2f, 0x9305, 0x4b7b, 0x0351, 0x4dd9,
            0x05f3, 0xdd8d, 0x95a7, 0x6560, 0x2d4a, 0xf534, 0xbd1e, 0x1cab, 0x5481, 0x8cff, 0xc4d5,
            0x3412, 0x7c38, 0xa446, 0xec6c, 0xef3d, 0xa717, 0x7f69, 0x3743, 0xc784, 0x8fae, 0x57d0,
            0x1ffa, 0xbe4f, 0xf665, 0x2e1b, 0x6631, 0x96f6, 0xdedc, 0x06a2, 0x4e88, 0x9bb2, 0xd398,
            0x0be6, 0x43cc, 0xb30b, 0xfb21, 0x235f, 0x6b75, 0xcac0, 0x82ea, 0x5a94, 0x12be, 0xe279,
            0xaa53, 0x722d, 0x3a07, 0x3956, 0x717c, 0xa902, 0xe128, 0x11ef, 0x59c5, 0x81bb, 0xc991,
            0x6824, 0x200e, 0xf870, 0xb05a, 0x409d, 0x08b7, 0xd0c9, 0x98e3, 0xd66b, 0x9e41, 0x463f,
            0x0e15, 0xfed2, 0xb6f8, 0x6e86, 0x26ac, 0x8719, 0xcf33, 0x174d, 0x5f67, 0xafa0, 0xe78a,
            0x3ff4, 0x77de, 0x748f, 0x3ca5, 0xe4db, 0xacf1, 0x5c36, 0x141c, 0xcc62, 0x8448, 0x25fd,
            0x6dd7, 0xb5a9, 0xfd83, 0x0d44, 0x456e, 0x9d10, 0xd53a, 0x3f75, 0x775f, 0xaf21, 0xe70b,
            0x17cc, 0x5fe6, 0x8798, 0xcfb2, 0x6e07, 0x262d, 0xfe53, 0xb679, 0x46be, 0x0e94, 0xd6ea,
            0x9ec0, 0x9d91, 0xd5bb, 0x0dc5, 0x45ef, 0xb528, 0xfd02, 0x257c, 0x6d56, 0xcce3, 0x84c9,
            0x5cb7, 0x149d, 0xe45a, 0xac70, 0x740e, 0x3c24, 0x72ac, 0x3a86, 0xe2f8, 0xaad2, 0x5a15,
            0x123f, 0xca41, 0x826b, 0x23de, 0x6bf4, 0xb38a, 0xfba0, 0x0b67, 0x434d, 0x9b33, 0xd319,
            0xd048, 0x9862, 0x401c, 0x0836, 0xf8f1, 0xb0db, 0x68a5, 0x208f, 0x813a, 0xc910, 0x116e,
            0x5944, 0xa983, 0xe1a9, 0x39d7, 0x71fd, 0xa4c7, 0xeced, 0x3493, 0x7cb9, 0x8c7e, 0xc454,
            0x1c2a, 0x5400, 0xf5b5, 0xbd9f, 0x65e1, 0x2dcb, 0xdd0c, 0x9526, 0x4d58, 0x0572, 0x0623,
            0x4e09, 0x9677, 0xde5d, 0x2e9a, 0x66b0, 0xbece, 0xf6e4, 0x5751, 0x1f7b, 0xc705, 0x8f2f,
            0x7fe8, 0x37c2, 0xefbc, 0xa796, 0xe91e, 0xa134, 0x794a, 0x3160, 0xc1a7, 0x898d, 0x51f3,
            0x19d9, 0xb86c, 0xf046, 0x2838, 0x6012, 0x90d5, 0xd8ff, 0x0081, 0x48ab, 0x4bfa, 0x03d0,
            0xdbae, 0x9384, 0x6343, 0x2b69, 0xf317, 0xbb3d, 0x1a88, 0x52a2, 0x8adc, 0xc2f6, 0x3231,
            0x7a1b, 0xa265, 0xea4f,
        ],
        [
            0x0000, 0x8e10, 0x1431, 0x9a21, 0x2862, 0xa672, 0x3c53, 0xb243, 0x50c4, 0xded4, 0x44f5,
            0xcae5, 0x78a6, 0xf6b6, 0x6c97, 0xe287, 0xa188, 0x2f98, 0xb5b9, 0x3ba9, 0x89ea, 0x07fa,
            0x9ddb, 0x13cb, 0xf14c, 0x7f5c, 0xe57d, 0x6b6d, 0xd92e, 0x573e, 0xcd1f, 0x430f, 0x4b01,
            0xc511, 0x5f30, 0xd120, 0x6363, 0xed73, 0x7752, 0xf942, 0x1bc5, 0x95d5, 0x0ff4, 0x81e4,
            0x33a7, 0xbdb7, 0x2796, 0xa986, 0xea89, 0x6499, 0xfeb8, 0x70a8, 0xc2eb, 0x4cfb, 0xd6da,
            0x58ca, 0xba4d, 0x345d, 0xae7c, 0x206c, 0x922f, 0x1c3f, 0x861e, 0x080e, 0x9602, 0x1812,
            0x8233, 0x0c23, 0xbe60, 0x3070, 0xaa51, 0x2441, 0xc6c6, 0x48d6, 0xd2f7, 0x5ce7, 0xeea4,
            0x60b4, 0xfa95, 0x7485, 0x378a, 0xb99a, 0x23bb, 0xadab, 0x1fe8, 0x91f8, 0x0bd9, 0x85c9,
            0x674e, 0xe95e, 0x737f, 0xfd6f, 0x4f2c, 0xc13c, 0x5b1d, 0xd50d, 0xdd03, 0x5313, 0xc932,
            0x4722, 0xf561, 0x7b71, 0xe150, 0x6f40, 0x8dc7, 0x03d7, 0x99f6, 0x17e6, 0xa5a5, 0x2bb5,
            0xb194, 0x3f84, 0x7c8b, 0xf29b, 0x68ba, 0xe6aa, 0x54e9, 0xdaf9, 0x40d8, 0xcec8, 0x2c4f,
            0xa25f, 0x387e, 0xb66e, 0x042d, 0x8a3d, 0x101c, 0x9e0c, 0x2415, 0xaa05, 0x3024, 0xbe34,
            0x0c77, 0x8267, 0x1846, 0x9656, 0x74d1, 0xfac1, 0x60e0, 0xeef0, 0x5cb3, 0xd2a3, 0x4882,
            0xc692, 0x859d, 0x0b8d, 0x91ac, 0x1fbc, 0xadff, 0x23ef, 0xb9ce, 0x37de, 0xd559, 0x5b49,
            0xc168, 0x4f78, 0xfd3b, 0x732b, 0xe90a, 0x671a, 0x6f14, 0xe104, 0x7b25, 0xf535, 0x4776,
            0xc966, 0x5347, 0xdd57, 0x3fd0, 0xb1c0, 0x2be1, 0xa5f1, 0x17b2, 0x99a2, 0x0383, 0x8d93,
            0xce9c, 0x408c, 0xdaad, 0x54bd, 0xe6fe, 0x68ee, 0xf2cf, 0x7cdf, 0x9e58, 0x1048, 0x8a69,
            0x0479, 0xb63a, 0x382a, 0xa20b, 0x2c1b, 0xb217, 0x3c07, 0xa626, 0x2836, 0x9a75, 0x1465,
            0x8e44, 0x0054, 0xe2d3, 0x6cc3, 0xf6e2, 0x78f2, 0xcab1, 0x44a1, 0xde80, 0x5090, 0x139f,
            0x9d8f, 0x07ae, 0x89be, 0x3bfd, 0xb5ed, 0x2fcc, 0xa1dc, 0x435b, 0xcd4b, 0x576a, 0xd97a,
            0x6b39, 0xe529, 0x7f08, 0xf118, 0xf916, 0x7706, 0xed27, 0x6337, 0xd174, 0x5f64, 0xc545,
            0x4b55, 0xa9d2, 0x27c2, 0xbde3, 0x33f3, 0x81b0, 0x0fa0, 0x9581, 0x1b91, 0x589e, 0xd68e,
            0x4caf, 0xc2bf, 0x70fc, 0xfeec, 0x64cd, 0xeadd, 0x085a, 0x864a, 0x1c6b, 0x927b, 0x2038,
            0xae28, 0x3409, 0xba19,
        ],
    ];

    pub static CRC16_LJ1200_TABLE: [[u16; 256]; 16] = [
        [
            0x0000, 0x6f63, 0xdec6, 0xb1a5, 0xd2ef, 0xbd8c, 0x0c29, 0x634a, 0xcabd, 0xa5de, 0x147b,
            0x7b18, 0x1852, 0x7731, 0xc694, 0xa9f7, 0xfa19, 0x957a, 0x24df, 0x4bbc, 0x28f6, 0x4795,
            0xf630, 0x9953, 0x30a4, 0x5fc7, 0xee62, 0x8101, 0xe24b, 0x8d28, 0x3c8d, 0x53ee, 0x9b51,
            0xf432, 0x4597, 0x2af4, 0x49be, 0x26dd, 0x9778, 0xf81b, 0x51ec, 0x3e8f, 0x8f2a, 0xe049,
            0x8303, 0xec60, 0x5dc5, 0x32a6, 0x6148, 0x0e2b, 0xbf8e, 0xd0ed, 0xb3a7, 0xdcc4, 0x6d61,
            0x0202, 0xabf5, 0xc496, 0x7533, 0x1a50, 0x791a, 0x1679, 0xa7dc, 0xc8bf, 0x59c1, 0x36a2,
            0x8707, 0xe864, 0x8b2e, 0xe44d, 0x55e8, 0x3a8b, 0x937c, 0xfc1f, 0x4dba, 0x22d9, 0x4193,
            0x2ef0, 0x9f55, 0xf036, 0xa3d8, 0xccbb, 0x7d1e, 0x127d, 0x7137, 0x1e54, 0xaff1, 0xc092,
            0x6965, 0x0606, 0xb7a3, 0xd8c0, 0xbb8a, 0xd4e9, 0x654c, 0x0a2f, 0xc290, 0xadf3, 0x1c56,
            0x7335, 0x107f, 0x7f1c, 0xceb9, 0xa1da, 0x082d, 0x674e, 0xd6eb, 0xb988, 0xdac2, 0xb5a1,
            0x0404, 0x6b67, 0x3889, 0x57ea, 0xe64f, 0x892c, 0xea66, 0x8505, 0x34a0, 0x5bc3, 0xf234,
            0x9d57, 0x2cf2, 0x4391, 0x20db, 0x4fb8, 0xfe1d, 0x917e, 0xb382, 0xdce1, 0x6d44, 0x0227,
            0x616d, 0x0e0e, 0xbfab, 0xd0c8, 0x793f, 0x165c, 0xa7f9, 0xc89a, 0xabd0, 0xc4b3, 0x7516,
            0x1a75, 0x499b, 0x26f8, 0x975d, 0xf83e, 0x9b74, 0xf417, 0x45b2, 0x2ad1, 0x8326, 0xec45,
            0x5de0, 0x3283, 0x51c9, 0x3eaa, 0x8f0f, 0xe06c, 0x28d3, 0x47b0, 0xf615, 0x9976, 0xfa3c,
            0x955f, 0x24fa, 0x4b99, 0xe26e, 0x8d0d, 0x3ca8, 0x53cb, 0x3081, 0x5fe2, 0xee47, 0x8124,
            0xd2ca, 0xbda9, 0x0c0c, 0x636f, 0x0025, 0x6f46, 0xdee3, 0xb180, 0x1877, 0x7714, 0xc6b1,
            0xa9d2, 0xca98, 0xa5fb, 0x145e, 0x7b3d, 0xea43, 0x8520, 0x3485, 0x5be6, 0x38ac, 0x57cf,
            0xe66a, 0x8909, 0x20fe, 0x4f9d, 0xfe38, 0x915b, 0xf211, 0x9d72, 0x2cd7, 0x43b4, 0x105a,
            0x7f39, 0xce9c, 0xa1ff, 0xc2b5, 0xadd6, 0x1c73, 0x7310, 0xdae7, 0xb584, 0x0421, 0x6b42,
            0x0808, 0x676b, 0xd6ce, 0xb9ad, 0x7112, 0x1e71, 0xafd4, 0xc0b7, 0xa3fd, 0xcc9e, 0x7d3b,
            0x1258, 0xbbaf, 0xd4cc, 0x6569, 0x0a0a, 0x6940, 0x0623, 0xb786, 0xd8e5, 0x8b0b, 0xe468,
            0x55cd, 0x3aae, 0x59e4, 0x3687, 0x8722, 0xe841, 0x41b6, 0x2ed5, 0x9f70, 0xf013, 0x9359,
            0xfc3a, 0x4d9f, 0x22fc,
        ],
        [
            0x0000, 0x0867, 0x10ce, 0x18a9, 0x219c, 0x29fb, 0x3152, 0x3935, 0x4338, 0x4b5f, 0x53f6,
            0x5b91, 0x62a4, 0x6ac3, 0x726a, 0x7a0d, 0x8670, 0x8e17, 0x96be, 0x9ed9, 0xa7ec, 0xaf8b,
            0xb722, 0xbf45, 0xc548, 0xcd2f, 0xd586, 0xdde1, 0xe4d4, 0xecb3, 0xf41a, 0xfc7d, 0x6383,
            0x6be4, 0x734d, 0x7b2a, 0x421f, 0x4a78, 0x52d1, 0x5ab6, 0x20bb, 0x28dc, 0x3075, 0x3812,
            0x0127, 0x0940, 0x11e9, 0x198e, 0xe5f3, 0xed94, 0xf53d, 0xfd5a, 0xc46f, 0xcc08, 0xd4a1,
            0xdcc6, 0xa6cb, 0xaeac, 0xb605, 0xbe62, 0x8757, 0x8f30, 0x9799, 0x9ffe, 0xc706, 0xcf61,
            0xd7c8, 0xdfaf, 0xe69a, 0xeefd, 0xf654, 0xfe33, 0x843e, 0x8c59, 0x94f0, 0x9c97, 0xa5a2,
            0xadc5, 0xb56c, 0xbd0b, 0x4176, 0x4911, 0x51b8, 0x59df, 0x60ea, 0x688d, 0x7024, 0x7843,
            0x024e, 0x0a29, 0x1280, 0x1ae7, 0x23d2, 0x2bb5, 0x331c, 0x3b7b, 0xa485, 0xace2, 0xb44b,
            0xbc2c, 0x8519, 0x8d7e, 0x95d7, 0x9db0, 0xe7bd, 0xefda, 0xf773, 0xff14, 0xc621, 0xce46,
            0xd6ef, 0xde88, 0x22f5, 0x2a92, 0x323b, 0x3a5c, 0x0369, 0x0b0e, 0x13a7, 0x1bc0, 0x61cd,
            0x69aa, 0x7103, 0x7964, 0x4051, 0x4836, 0x509f, 0x58f8, 0xe16f, 0xe908, 0xf1a1, 0xf9c6,
            0xc0f3, 0xc894, 0xd03d, 0xd85a, 0xa257, 0xaa30, 0xb299, 0xbafe, 0x83cb, 0x8bac, 0x9305,
            0x9b62, 0x671f, 0x6f78, 0x77d1, 0x7fb6, 0x4683, 0x4ee4, 0x564d, 0x5e2a, 0x2427, 0x2c40,
            0x34e9, 0x3c8e, 0x05bb, 0x0ddc, 0x1575, 0x1d12, 0x82ec, 0x8a8b, 0x9222, 0x9a45, 0xa370,
            0xab17, 0xb3be, 0xbbd9, 0xc1d4, 0xc9b3, 0xd11a, 0xd97d, 0xe048, 0xe82f, 0xf086, 0xf8e1,
            0x049c, 0x0cfb, 0x1452, 0x1c35, 0x2500, 0x2d67, 0x35ce, 0x3da9, 0x47a4, 0x4fc3, 0x576a,
            0x5f0d, 0x6638, 0x6e5f, 0x76f6, 0x7e91, 0x2669, 0x2e0e, 0x36a7, 0x3ec0, 0x07f5, 0x0f92,
            0x173b, 0x1f5c, 0x6551, 0x6d36, 0x759f, 0x7df8, 0x44cd, 0x4caa, 0x5403, 0x5c64, 0xa019,
            0xa87e, 0xb0d7, 0xb8b0, 0x8185, 0x89e2, 0x914b, 0x992c, 0xe321, 0xeb46, 0xf3ef, 0xfb88,
            0xc2bd, 0xcada, 0xd273, 0xda14, 0x45ea, 0x4d8d, 0x5524, 0x5d43, 0x6476, 0x6c11, 0x74b8,
            0x7cdf, 0x06d2, 0x0eb5, 0x161c, 0x1e7b, 0x274e, 0x2f29, 0x3780, 0x3fe7, 0xc39a, 0xcbfd,
            0xd354, 0xdb33, 0xe206, 0xea61, 0xf2c8, 0xfaaf, 0x80a2, 0x88c5, 0x906c, 0x980b, 0xa13e,
            0xa959, 0xb1f0, 0xb997,
        ],
        [
            0x0000, 0xadbd, 0x3419, 0x99a4, 0x6832, 0xc58f, 0x5c2b, 0xf196, 0xd064, 0x7dd9, 0xe47d,
            0x49c0, 0xb856, 0x15eb, 0x8c4f, 0x21f2, 0xcfab, 0x6216, 0xfbb2, 0x560f, 0xa799, 0x0a24,
            0x9380, 0x3e3d, 0x1fcf, 0xb272, 0x2bd6, 0x866b, 0x77fd, 0xda40, 0x43e4, 0xee59, 0xf035,
            0x5d88, 0xc42c, 0x6991, 0x9807, 0x35ba, 0xac1e, 0x01a3, 0x2051, 0x8dec, 0x1448, 0xb9f5,
            0x4863, 0xe5de, 0x7c7a, 0xd1c7, 0x3f9e, 0x9223, 0x0b87, 0xa63a, 0x57ac, 0xfa11, 0x63b5,
            0xce08, 0xeffa, 0x4247, 0xdbe3, 0x765e, 0x87c8, 0x2a75, 0xb3d1, 0x1e6c, 0x8f09, 0x22b4,
            0xbb10, 0x16ad, 0xe73b, 0x4a86, 0xd322, 0x7e9f, 0x5f6d, 0xf2d0, 0x6b74, 0xc6c9, 0x375f,
            0x9ae2, 0x0346, 0xaefb, 0x40a2, 0xed1f, 0x74bb, 0xd906, 0x2890, 0x852d, 0x1c89, 0xb134,
            0x90c6, 0x3d7b, 0xa4df, 0x0962, 0xf8f4, 0x5549, 0xcced, 0x6150, 0x7f3c, 0xd281, 0x4b25,
            0xe698, 0x170e, 0xbab3, 0x2317, 0x8eaa, 0xaf58, 0x02e5, 0x9b41, 0x36fc, 0xc76a, 0x6ad7,
            0xf373, 0x5ece, 0xb097, 0x1d2a, 0x848e, 0x2933, 0xd8a5, 0x7518, 0xecbc, 0x4101, 0x60f3,
            0xcd4e, 0x54ea, 0xf957, 0x08c1, 0xa57c, 0x3cd8, 0x9165, 0x7171, 0xdccc, 0x4568, 0xe8d5,
            0x1943, 0xb4fe, 0x2d5a, 0x80e7, 0xa115, 0x0ca8, 0x950c, 0x38b1, 0xc927, 0x649a, 0xfd3e,
            0x5083, 0xbeda, 0x1367, 0x8ac3, 0x277e, 0xd6e8, 0x7b55, 0xe2f1, 0x4f4c, 0x6ebe, 0xc303,
            0x5aa7, 0xf71a, 0x068c, 0xab31, 0x3295, 0x9f28, 0x8144, 0x2cf9, 0xb55d, 0x18e0, 0xe976,
            0x44cb, 0xdd6f, 0x70d2, 0x5120, 0xfc9d, 0x6539, 0xc884, 0x3912, 0x94af, 0x0d0b, 0xa0b6,
            0x4eef, 0xe352, 0x7af6, 0xd74b, 0x26dd, 0x8b60, 0x12c4, 0xbf79, 0x9e8b, 0x3336, 0xaa92,
            0x072f, 0xf6b9, 0x5b04, 0xc2a0, 0x6f1d, 0xfe78, 0x53c5, 0xca61, 0x67dc, 0x964a, 0x3bf7,
            0xa253, 0x0fee, 0x2e1c, 0x83a1, 0x1a05, 0xb7b8, 0x462e, 0xeb93, 0x7237, 0xdf8a, 0x31d3,
            0x9c6e, 0x05ca, 0xa877, 0x59e1, 0xf45c, 0x6df8, 0xc045, 0xe1b7, 0x4c0a, 0xd5ae, 0x7813,
            0x8985, 0x2438, 0xbd9c, 0x1021, 0x0e4d, 0xa3f0, 0x3a54, 0x97e9, 0x667f, 0xcbc2, 0x5266,
            0xffdb, 0xde29, 0x7394, 0xea30, 0x478d, 0xb61b, 0x1ba6, 0x8202, 0x2fbf, 0xc1e6, 0x6c5b,
            0xf5ff, 0x5842, 0xa9d4, 0x0469, 0x9dcd, 0x3070, 0x1182, 0xbc3f, 0x259b, 0x8826, 0x79b0,
            0xd40d, 0x4da9, 0xe014,
        ],
        [
            0x0000, 0xe2e2, 0xaaa7, 0x4845, 0x3a2d, 0xd8cf, 0x908a, 0x7268, 0x745a, 0x96b8, 0xdefd,
            0x3c1f, 0x4e77, 0xac95, 0xe4d0, 0x0632, 0xe8b4, 0x0a56, 0x4213, 0xa0f1, 0xd299, 0x307b,
            0x783e, 0x9adc, 0x9cee, 0x7e0c, 0x3649, 0xd4ab, 0xa6c3, 0x4421, 0x0c64, 0xee86, 0xbe0b,
            0x5ce9, 0x14ac, 0xf64e, 0x8426, 0x66c4, 0x2e81, 0xcc63, 0xca51, 0x28b3, 0x60f6, 0x8214,
            0xf07c, 0x129e, 0x5adb, 0xb839, 0x56bf, 0xb45d, 0xfc18, 0x1efa, 0x6c92, 0x8e70, 0xc635,
            0x24d7, 0x22e5, 0xc007, 0x8842, 0x6aa0, 0x18c8, 0xfa2a, 0xb26f, 0x508d, 0x1375, 0xf197,
            0xb9d2, 0x5b30, 0x2958, 0xcbba, 0x83ff, 0x611d, 0x672f, 0x85cd, 0xcd88, 0x2f6a, 0x5d02,
            0xbfe0, 0xf7a5, 0x1547, 0xfbc1, 0x1923, 0x5166, 0xb384, 0xc1ec, 0x230e, 0x6b4b, 0x89a9,
            0x8f9b, 0x6d79, 0x253c, 0xc7de, 0xb5b6, 0x5754, 0x1f11, 0xfdf3, 0xad7e, 0x4f9c, 0x07d9,
            0xe53b, 0x9753, 0x75b1, 0x3df4, 0xdf16, 0xd924, 0x3bc6, 0x7383, 0x9161, 0xe309, 0x01eb,
            0x49ae, 0xab4c, 0x45ca, 0xa728, 0xef6d, 0x0d8f, 0x7fe7, 0x9d05, 0xd540, 0x37a2, 0x3190,
            0xd372, 0x9b37, 0x79d5, 0x0bbd, 0xe95f, 0xa11a, 0x43f8, 0x26ea, 0xc408, 0x8c4d, 0x6eaf,
            0x1cc7, 0xfe25, 0xb660, 0x5482, 0x52b0, 0xb052, 0xf817, 0x1af5, 0x689d, 0x8a7f, 0xc23a,
            0x20d8, 0xce5e, 0x2cbc, 0x64f9, 0x861b, 0xf473, 0x1691, 0x5ed4, 0xbc36, 0xba04, 0x58e6,
            0x10a3, 0xf241, 0x8029, 0x62cb, 0x2a8e, 0xc86c, 0x98e1, 0x7a03, 0x3246, 0xd0a4, 0xa2cc,
            0x402e, 0x086b, 0xea89, 0xecbb, 0x0e59, 0x461c, 0xa4fe, 0xd696, 0x3474, 0x7c31, 0x9ed3,
            0x7055, 0x92b7, 0xdaf2, 0x3810, 0x4a78, 0xa89a, 0xe0df, 0x023d, 0x040f, 0xe6ed, 0xaea8,
            0x4c4a, 0x3e22, 0xdcc0, 0x9485, 0x7667, 0x359f, 0xd77d, 0x9f38, 0x7dda, 0x0fb2, 0xed50,
            0xa515, 0x47f7, 0x41c5, 0xa327, 0xeb62, 0x0980, 0x7be8, 0x990a, 0xd14f, 0x33ad, 0xdd2b,
            0x3fc9, 0x778c, 0x956e, 0xe706, 0x05e4, 0x4da1, 0xaf43, 0xa971, 0x4b93, 0x03d6, 0xe134,
            0x935c, 0x71be, 0x39fb, 0xdb19, 0x8b94, 0x6976, 0x2133, 0xc3d1, 0xb1b9, 0x535b, 0x1b1e,
            0xf9fc, 0xffce, 0x1d2c, 0x5569, 0xb78b, 0xc5e3, 0x2701, 0x6f44, 0x8da6, 0x6320, 0x81c2,
            0xc987, 0x2b65, 0x590d, 0xbbef, 0xf3aa, 0x1148, 0x177a, 0xf598, 0xbddd, 0x5f3f, 0x2d57,
            0xcfb5, 0x87f0, 0x6512,
        ],
        [
            0x0000, 0x4dd4, 0x9ba8, 0xd67c, 0x5833, 0x15e7, 0xc39b, 0x8e4f, 0xb066, 0xfdb2, 0x2bce,
            0x661a, 0xe855, 0xa581, 0x73fd, 0x3e29, 0x0faf, 0x427b, 0x9407, 0xd9d3, 0x579c, 0x1a48,
            0xcc34, 0x81e0, 0xbfc9, 0xf21d, 0x2461, 0x69b5, 0xe7fa, 0xaa2e, 0x7c52, 0x3186, 0x1f5e,
            0x528a, 0x84f6, 0xc922, 0x476d, 0x0ab9, 0xdcc5, 0x9111, 0xaf38, 0xe2ec, 0x3490, 0x7944,
            0xf70b, 0xbadf, 0x6ca3, 0x2177, 0x10f1, 0x5d25, 0x8b59, 0xc68d, 0x48c2, 0x0516, 0xd36a,
            0x9ebe, 0xa097, 0xed43, 0x3b3f, 0x76eb, 0xf8a4, 0xb570, 0x630c, 0x2ed8, 0x3ebc, 0x7368,
            0xa514, 0xe8c0, 0x668f, 0x2b5b, 0xfd27, 0xb0f3, 0x8eda, 0xc30e, 0x1572, 0x58a6, 0xd6e9,
            0x9b3d, 0x4d41, 0x0095, 0x3113, 0x7cc7, 0xaabb, 0xe76f, 0x6920, 0x24f4, 0xf288, 0xbf5c,
            0x8175, 0xcca1, 0x1add, 0x5709, 0xd946, 0x9492, 0x42ee, 0x0f3a, 0x21e2, 0x6c36, 0xba4a,
            0xf79e, 0x79d1, 0x3405, 0xe279, 0xafad, 0x9184, 0xdc50, 0x0a2c, 0x47f8, 0xc9b7, 0x8463,
            0x521f, 0x1fcb, 0x2e4d, 0x6399, 0xb5e5, 0xf831, 0x767e, 0x3baa, 0xedd6, 0xa002, 0x9e2b,
            0xd3ff, 0x0583, 0x4857, 0xc618, 0x8bcc, 0x5db0, 0x1064, 0x7d78, 0x30ac, 0xe6d0, 0xab04,
            0x254b, 0x689f, 0xbee3, 0xf337, 0xcd1e, 0x80ca, 0x56b6, 0x1b62, 0x952d, 0xd8f9, 0x0e85,
            0x4351, 0x72d7, 0x3f03, 0xe97f, 0xa4ab, 0x2ae4, 0x6730, 0xb14c, 0xfc98, 0xc2b1, 0x8f65,
            0x5919, 0x14cd, 0x9a82, 0xd756, 0x012a, 0x4cfe, 0x6226, 0x2ff2, 0xf98e, 0xb45a, 0x3a15,
            0x77c1, 0xa1bd, 0xec69, 0xd240, 0x9f94, 0x49e8, 0x043c, 0x8a73, 0xc7a7, 0x11db, 0x5c0f,
            0x6d89, 0x205d, 0xf621, 0xbbf5, 0x35ba, 0x786e, 0xae12, 0xe3c6, 0xddef, 0x903b, 0x4647,
            0x0b93, 0x85dc, 0xc808, 0x1e74, 0x53a0, 0x43c4, 0x0e10, 0xd86c, 0x95b8, 0x1bf7, 0x5623,
            0x805f, 0xcd8b, 0xf3a2, 0xbe76, 0x680a, 0x25de, 0xab91, 0xe645, 0x3039, 0x7ded, 0x4c6b,
            0x01bf, 0xd7c3, 0x9a17, 0x1458, 0x598c, 0x8ff0, 0xc224, 0xfc0d, 0xb1d9, 0x67a5, 0x2a71,
            0xa43e, 0xe9ea, 0x3f96, 0x7242, 0x5c9a, 0x114e, 0xc732, 0x8ae6, 0x04a9, 0x497d, 0x9f01,
            0xd2d5, 0xecfc, 0xa128, 0x7754, 0x3a80, 0xb4cf, 0xf91b, 0x2f67, 0x62b3, 0x5335, 0x1ee1,
            0xc89d, 0x8549, 0x0b06, 0x46d2, 0x90ae, 0xdd7a, 0xe353, 0xae87, 0x78fb, 0x352f, 0xbb60,
            0xf6b4, 0x20c8, 0x6d1c,
        ],
        [
            0x0000, 0xfaf0, 0x9a83, 0x6073, 0x5a65, 0xa095, 0xc0e6, 0x3a16, 0xb4ca, 0x4e3a, 0x2e49,
            0xd4b9, 0xeeaf, 0x145f, 0x742c, 0x8edc, 0x06f7, 0xfc07, 0x9c74, 0x6684, 0x5c92, 0xa662,
            0xc611, 0x3ce1, 0xb23d, 0x48cd, 0x28be, 0xd24e, 0xe858, 0x12a8, 0x72db, 0x882b, 0x0dee,
            0xf71e, 0x976d, 0x6d9d, 0x578b, 0xad7b, 0xcd08, 0x37f8, 0xb924, 0x43d4, 0x23a7, 0xd957,
            0xe341, 0x19b1, 0x79c2, 0x8332, 0x0b19, 0xf1e9, 0x919a, 0x6b6a, 0x517c, 0xab8c, 0xcbff,
            0x310f, 0xbfd3, 0x4523, 0x2550, 0xdfa0, 0xe5b6, 0x1f46, 0x7f35, 0x85c5, 0x1bdc, 0xe12c,
            0x815f, 0x7baf, 0x41b9, 0xbb49, 0xdb3a, 0x21ca, 0xaf16, 0x55e6, 0x3595, 0xcf65, 0xf573,
            0x0f83, 0x6ff0, 0x9500, 0x1d2b, 0xe7db, 0x87a8, 0x7d58, 0x474e, 0xbdbe, 0xddcd, 0x273d,
            0xa9e1, 0x5311, 0x3362, 0xc992, 0xf384, 0x0974, 0x6907, 0x93f7, 0x1632, 0xecc2, 0x8cb1,
            0x7641, 0x4c57, 0xb6a7, 0xd6d4, 0x2c24, 0xa2f8, 0x5808, 0x387b, 0xc28b, 0xf89d, 0x026d,
            0x621e, 0x98ee, 0x10c5, 0xea35, 0x8a46, 0x70b6, 0x4aa0, 0xb050, 0xd023, 0x2ad3, 0xa40f,
            0x5eff, 0x3e8c, 0xc47c, 0xfe6a, 0x049a, 0x64e9, 0x9e19, 0x37b8, 0xcd48, 0xad3b, 0x57cb,
            0x6ddd, 0x972d, 0xf75e, 0x0dae, 0x8372, 0x7982, 0x19f1, 0xe301, 0xd917, 0x23e7, 0x4394,
            0xb964, 0x314f, 0xcbbf, 0xabcc, 0x513c, 0x6b2a, 0x91da, 0xf1a9, 0x0b59, 0x8585, 0x7f75,
            0x1f06, 0xe5f6, 0xdfe0, 0x2510, 0x4563, 0xbf93, 0x3a56, 0xc0a6, 0xa0d5, 0x5a25, 0x6033,
            0x9ac3, 0xfab0, 0x0040, 0x8e9c, 0x746c, 0x141f, 0xeeef, 0xd4f9, 0x2e09, 0x4e7a, 0xb48a,
            0x3ca1, 0xc651, 0xa622, 0x5cd2, 0x66c4, 0x9c34, 0xfc47, 0x06b7, 0x886b, 0x729b, 0x12e8,
            0xe818, 0xd20e, 0x28fe, 0x488d, 0xb27d, 0x2c64, 0xd694, 0xb6e7, 0x4c17, 0x7601, 0x8cf1,
            0xec82, 0x1672, 0x98ae, 0x625e, 0x022d, 0xf8dd, 0xc2cb, 0x383b, 0x5848, 0xa2b8, 0x2a93,
            0xd063, 0xb010, 0x4ae0, 0x70f6, 0x8a06, 0xea75, 0x1085, 0x9e59, 0x64a9, 0x04da, 0xfe2a,
            0xc43c, 0x3ecc, 0x5ebf, 0xa44f, 0x218a, 0xdb7a, 0xbb09, 0x41f9, 0x7bef, 0x811f, 0xe16c,
            0x1b9c, 0x9540, 0x6fb0, 0x0fc3, 0xf533, 0xcf25, 0x35d5, 0x55a6, 0xaf56, 0x277d, 0xdd8d,
            0xbdfe, 0x470e, 0x7d18, 0x87e8, 0xe79b, 0x1d6b, 0x93b7, 0x6947, 0x0934, 0xf3c4, 0xc9d2,
            0x3322, 0x5351, 0xa9a1,
        ],
        [
            0x0000, 0x6f70, 0xdee0, 0xb190, 0xd2a3, 0xbdd3, 0x0c43, 0x6333, 0xca25, 0xa555, 0x14c5,
            0x7bb5, 0x1886, 0x77f6, 0xc666, 0xa916, 0xfb29, 0x9459, 0x25c9, 0x4ab9, 0x298a, 0x46fa,
            0xf76a, 0x981a, 0x310c, 0x5e7c, 0xefec, 0x809c, 0xe3af, 0x8cdf, 0x3d4f, 0x523f, 0x9931,
            0xf641, 0x47d1, 0x28a1, 0x4b92, 0x24e2, 0x9572, 0xfa02, 0x5314, 0x3c64, 0x8df4, 0xe284,
            0x81b7, 0xeec7, 0x5f57, 0x3027, 0x6218, 0x0d68, 0xbcf8, 0xd388, 0xb0bb, 0xdfcb, 0x6e5b,
            0x012b, 0xa83d, 0xc74d, 0x76dd, 0x19ad, 0x7a9e, 0x15ee, 0xa47e, 0xcb0e, 0x5d01, 0x3271,
            0x83e1, 0xec91, 0x8fa2, 0xe0d2, 0x5142, 0x3e32, 0x9724, 0xf854, 0x49c4, 0x26b4, 0x4587,
            0x2af7, 0x9b67, 0xf417, 0xa628, 0xc958, 0x78c8, 0x17b8, 0x748b, 0x1bfb, 0xaa6b, 0xc51b,
            0x6c0d, 0x037d, 0xb2ed, 0xdd9d, 0xbeae, 0xd1de, 0x604e, 0x0f3e, 0xc430, 0xab40, 0x1ad0,
            0x75a0, 0x1693, 0x79e3, 0xc873, 0xa703, 0x0e15, 0x6165, 0xd0f5, 0xbf85, 0xdcb6, 0xb3c6,
            0x0256, 0x6d26, 0x3f19, 0x5069, 0xe1f9, 0x8e89, 0xedba, 0x82ca, 0x335a, 0x5c2a, 0xf53c,
            0x9a4c, 0x2bdc, 0x44ac, 0x279f, 0x48ef, 0xf97f, 0x960f, 0xba02, 0xd572, 0x64e2, 0x0b92,
            0x68a1, 0x07d1, 0xb641, 0xd931, 0x7027, 0x1f57, 0xaec7, 0xc1b7, 0xa284, 0xcdf4, 0x7c64,
            0x1314, 0x412b, 0x2e5b, 0x9fcb, 0xf0bb, 0x9388, 0xfcf8, 0x4d68, 0x2218, 0x8b0e, 0xe47e,
            0x55ee, 0x3a9e, 0x59ad, 0x36dd, 0x874d, 0xe83d, 0x2333, 0x4c43, 0xfdd3, 0x92a3, 0xf190,
            0x9ee0, 0x2f70, 0x4000, 0xe916, 0x8666, 0x37f6, 0x5886, 0x3bb5, 0x54c5, 0xe555, 0x8a25,
            0xd81a, 0xb76a, 0x06fa, 0x698a, 0x0ab9, 0x65c9, 0xd459, 0xbb29, 0x123f, 0x7d4f, 0xccdf,
            0xa3af, 0xc09c, 0xafec, 0x1e7c, 0x710c, 0xe703, 0x8873, 0x39e3, 0x5693, 0x35a0, 0x5ad0,
            0xeb40, 0x8430, 0x2d26, 0x4256, 0xf3c6, 0x9cb6, 0xff85, 0x90f5, 0x2165, 0x4e15, 0x1c2a,
            0x735a, 0xc2ca, 0xadba, 0xce89, 0xa1f9, 0x1069, 0x7f19, 0xd60f, 0xb97f, 0x08ef, 0x679f,
            0x04ac, 0x6bdc, 0xda4c, 0xb53c, 0x7e32, 0x1142, 0xa0d2, 0xcfa2, 0xac91, 0xc3e1, 0x7271,
            0x1d01, 0xb417, 0xdb67, 0x6af7, 0x0587, 0x66b4, 0x09c4, 0xb854, 0xd724, 0x851b, 0xea6b,
            0x5bfb, 0x348b, 0x57b8, 0x38c8, 0x8958, 0xe628, 0x4f3e, 0x204e, 0x91de, 0xfeae, 0x9d9d,
            0xf2ed, 0x437d, 0x2c0d,
        ],
        [
            0x0000, 0x1b67, 0x36ce, 0x2da9, 0x6d9c, 0x76fb, 0x5b52, 0x4035, 0xdb38, 0xc05f, 0xedf6,
            0xf691, 0xb6a4, 0xadc3, 0x806a, 0x9b0d, 0xd913, 0xc274, 0xefdd, 0xf4ba, 0xb48f, 0xafe8,
            0x8241, 0x9926, 0x022b, 0x194c, 0x34e5, 0x2f82, 0x6fb7, 0x74d0, 0x5979, 0x421e, 0xdd45,
            0xc622, 0xeb8b, 0xf0ec, 0xb0d9, 0xabbe, 0x8617, 0x9d70, 0x067d, 0x1d1a, 0x30b3, 0x2bd4,
            0x6be1, 0x7086, 0x5d2f, 0x4648, 0x0456, 0x1f31, 0x3298, 0x29ff, 0x69ca, 0x72ad, 0x5f04,
            0x4463, 0xdf6e, 0xc409, 0xe9a0, 0xf2c7, 0xb2f2, 0xa995, 0x843c, 0x9f5b, 0xd5e9, 0xce8e,
            0xe327, 0xf840, 0xb875, 0xa312, 0x8ebb, 0x95dc, 0x0ed1, 0x15b6, 0x381f, 0x2378, 0x634d,
            0x782a, 0x5583, 0x4ee4, 0x0cfa, 0x179d, 0x3a34, 0x2153, 0x6166, 0x7a01, 0x57a8, 0x4ccf,
            0xd7c2, 0xcca5, 0xe10c, 0xfa6b, 0xba5e, 0xa139, 0x8c90, 0x97f7, 0x08ac, 0x13cb, 0x3e62,
            0x2505, 0x6530, 0x7e57, 0x53fe, 0x4899, 0xd394, 0xc8f3, 0xe55a, 0xfe3d, 0xbe08, 0xa56f,
            0x88c6, 0x93a1, 0xd1bf, 0xcad8, 0xe771, 0xfc16, 0xbc23, 0xa744, 0x8aed, 0x918a, 0x0a87,
            0x11e0, 0x3c49, 0x272e, 0x671b, 0x7c7c, 0x51d5, 0x4ab2, 0xc4b1, 0xdfd6, 0xf27f, 0xe918,
            0xa92d, 0xb24a, 0x9fe3, 0x8484, 0x1f89, 0x04ee, 0x2947, 0x3220, 0x7215, 0x6972, 0x44db,
            0x5fbc, 0x1da2, 0x06c5, 0x2b6c, 0x300b, 0x703e, 0x6b59, 0x46f0, 0x5d97, 0xc69a, 0xddfd,
            0xf054, 0xeb33, 0xab06, 0xb061, 0x9dc8, 0x86af, 0x19f4, 0x0293, 0x2f3a, 0x345d, 0x7468,
            0x6f0f, 0x42a6, 0x59c1, 0xc2cc, 0xd9ab, 0xf402, 0xef65, 0xaf50, 0xb437, 0x999e, 0x82f9,
            0xc0e7, 0xdb80, 0xf629, 0xed4e, 0xad7b, 0xb61c, 0x9bb5, 0x80d2, 0x1bdf, 0x00b8, 0x2d11,
            0x3676, 0x7643, 0x6d24, 0x408d, 0x5bea, 0x1158, 0x0a3f, 0x2796, 0x3cf1, 0x7cc4, 0x67a3,
            0x4a0a, 0x516d, 0xca60, 0xd107, 0xfcae, 0xe7c9, 0xa7fc, 0xbc9b, 0x9132, 0x8a55, 0xc84b,
            0xd32c, 0xfe85, 0xe5e2, 0xa5d7, 0xbeb0, 0x9319, 0x887e, 0x1373, 0x0814, 0x25bd, 0x3eda,
            0x7eef, 0x6588, 0x4821, 0x5346, 0xcc1d, 0xd77a, 0xfad3, 0xe1b4, 0xa181, 0xbae6, 0x974f,
            0x8c28, 0x1725, 0x0c42, 0x21eb, 0x3a8c, 0x7ab9, 0x61de, 0x4c77, 0x5710, 0x150e, 0x0e69,
            0x23c0, 0x38a7, 0x7892, 0x63f5, 0x4e5c, 0x553b, 0xce36, 0xd551, 0xf8f8, 0xe39f, 0xa3aa,
            0xb8cd, 0x9564, 0x8e03,
        ],
        [
            0x0000, 0xe601, 0xa361, 0x4560, 0x29a1, 0xcfa0, 0x8ac0, 0x6cc1, 0x5342, 0xb543, 0xf023,
            0x1622, 0x7ae3, 0x9ce2, 0xd982, 0x3f83, 0xa684, 0x4085, 0x05e5, 0xe3e4, 0x8f25, 0x6924,
            0x2c44, 0xca45, 0xf5c6, 0x13c7, 0x56a7, 0xb0a6, 0xdc67, 0x3a66, 0x7f06, 0x9907, 0x226b,
            0xc46a, 0x810a, 0x670b, 0x0bca, 0xedcb, 0xa8ab, 0x4eaa, 0x7129, 0x9728, 0xd248, 0x3449,
            0x5888, 0xbe89, 0xfbe9, 0x1de8, 0x84ef, 0x62ee, 0x278e, 0xc18f, 0xad4e, 0x4b4f, 0x0e2f,
            0xe82e, 0xd7ad, 0x31ac, 0x74cc, 0x92cd, 0xfe0c, 0x180d, 0x5d6d, 0xbb6c, 0x44d6, 0xa2d7,
            0xe7b7, 0x01b6, 0x6d77, 0x8b76, 0xce16, 0x2817, 0x1794, 0xf195, 0xb4f5, 0x52f4, 0x3e35,
            0xd834, 0x9d54, 0x7b55, 0xe252, 0x0453, 0x4133, 0xa732, 0xcbf3, 0x2df2, 0x6892, 0x8e93,
            0xb110, 0x5711, 0x1271, 0xf470, 0x98b1, 0x7eb0, 0x3bd0, 0xddd1, 0x66bd, 0x80bc, 0xc5dc,
            0x23dd, 0x4f1c, 0xa91d, 0xec7d, 0x0a7c, 0x35ff, 0xd3fe, 0x969e, 0x709f, 0x1c5e, 0xfa5f,
            0xbf3f, 0x593e, 0xc039, 0x2638, 0x6358, 0x8559, 0xe998, 0x0f99, 0x4af9, 0xacf8, 0x937b,
            0x757a, 0x301a, 0xd61b, 0xbada, 0x5cdb, 0x19bb, 0xffba, 0x89ac, 0x6fad, 0x2acd, 0xcccc,
            0xa00d, 0x460c, 0x036c, 0xe56d, 0xdaee, 0x3cef, 0x798f, 0x9f8e, 0xf34f, 0x154e, 0x502e,
            0xb62f, 0x2f28, 0xc929, 0x8c49, 0x6a48, 0x0689, 0xe088, 0xa5e8, 0x43e9, 0x7c6a, 0x9a6b,
            0xdf0b, 0x390a, 0x55cb, 0xb3ca, 0xf6aa, 0x10ab, 0xabc7, 0x4dc6, 0x08a6, 0xeea7, 0x8266,
            0x6467, 0x2107, 0xc706, 0xf885, 0x1e84, 0x5be4, 0xbde5, 0xd124, 0x3725, 0x7245, 0x9444,
            0x0d43, 0xeb42, 0xae22, 0x4823, 0x24e2, 0xc2e3, 0x8783, 0x6182, 0x5e01, 0xb800, 0xfd60,
            0x1b61, 0x77a0, 0x91a1, 0xd4c1, 0x32c0, 0xcd7a, 0x2b7b, 0x6e1b, 0x881a, 0xe4db, 0x02da,
            0x47ba, 0xa1bb, 0x9e38, 0x7839, 0x3d59, 0xdb58, 0xb799, 0x5198, 0x14f8, 0xf2f9, 0x6bfe,
            0x8dff, 0xc89f, 0x2e9e, 0x425f, 0xa45e, 0xe13e, 0x073f, 0x38bc, 0xdebd, 0x9bdd, 0x7ddc,
            0x111d, 0xf71c, 0xb27c, 0x547d, 0xef11, 0x0910, 0x4c70, 0xaa71, 0xc6b0, 0x20b1, 0x65d1,
            0x83d0, 0xbc53, 0x5a52, 0x1f32, 0xf933, 0x95f2, 0x73f3, 0x3693, 0xd092, 0x4995, 0xaf94,
            0xeaf4, 0x0cf5, 0x6034, 0x8635, 0xc355, 0x2554, 0x1ad7, 0xfcd6, 0xb9b6, 0x5fb7, 0x3376,
            0xd577, 0x9017, 0x7616,
        ],
        [
            0x0000, 0x7c3b, 0xf876, 0x844d, 0x9f8f, 0xe3b4, 0x67f9, 0x1bc2, 0x507d, 0x2c46, 0xa80b,
            0xd430, 0xcff2, 0xb3c9, 0x3784, 0x4bbf, 0xa0fa, 0xdcc1, 0x588c, 0x24b7, 0x3f75, 0x434e,
            0xc703, 0xbb38, 0xf087, 0x8cbc, 0x08f1, 0x74ca, 0x6f08, 0x1333, 0x977e, 0xeb45, 0x2e97,
            0x52ac, 0xd6e1, 0xaada, 0xb118, 0xcd23, 0x496e, 0x3555, 0x7eea, 0x02d1, 0x869c, 0xfaa7,
            0xe165, 0x9d5e, 0x1913, 0x6528, 0x8e6d, 0xf256, 0x761b, 0x0a20, 0x11e2, 0x6dd9, 0xe994,
            0x95af, 0xde10, 0xa22b, 0x2666, 0x5a5d, 0x419f, 0x3da4, 0xb9e9, 0xc5d2, 0x5d2e, 0x2115,
            0xa558, 0xd963, 0xc2a1, 0xbe9a, 0x3ad7, 0x46ec, 0x0d53, 0x7168, 0xf525, 0x891e, 0x92dc,
            0xeee7, 0x6aaa, 0x1691, 0xfdd4, 0x81ef, 0x05a2, 0x7999, 0x625b, 0x1e60, 0x9a2d, 0xe616,
            0xada9, 0xd192, 0x55df, 0x29e4, 0x3226, 0x4e1d, 0xca50, 0xb66b, 0x73b9, 0x0f82, 0x8bcf,
            0xf7f4, 0xec36, 0x900d, 0x1440, 0x687b, 0x23c4, 0x5fff, 0xdbb2, 0xa789, 0xbc4b, 0xc070,
            0x443d, 0x3806, 0xd343, 0xaf78, 0x2b35, 0x570e, 0x4ccc, 0x30f7, 0xb4ba, 0xc881, 0x833e,
            0xff05, 0x7b48, 0x0773, 0x1cb1, 0x608a, 0xe4c7, 0x98fc, 0xba5c, 0xc667, 0x422a, 0x3e11,
            0x25d3, 0x59e8, 0xdda5, 0xa19e, 0xea21, 0x961a, 0x1257, 0x6e6c, 0x75ae, 0x0995, 0x8dd8,
            0xf1e3, 0x1aa6, 0x669d, 0xe2d0, 0x9eeb, 0x8529, 0xf912, 0x7d5f, 0x0164, 0x4adb, 0x36e0,
            0xb2ad, 0xce96, 0xd554, 0xa96f, 0x2d22, 0x5119, 0x94cb, 0xe8f0, 0x6cbd, 0x1086, 0x0b44,
            0x777f, 0xf332, 0x8f09, 0xc4b6, 0xb88d, 0x3cc0, 0x40fb, 0x5b39, 0x2702, 0xa34f, 0xdf74,
            0x3431, 0x480a, 0xcc47, 0xb07c, 0xabbe, 0xd785, 0x53c8, 0x2ff3, 0x644c, 0x1877, 0x9c3a,
            0xe001, 0xfbc3, 0x87f8, 0x03b5, 0x7f8e, 0xe772, 0x9b49, 0x1f04, 0x633f, 0x78fd, 0x04c6,
            0x808b, 0xfcb0, 0xb70f, 0xcb34, 0x4f79, 0x3342, 0x2880, 0x54bb, 0xd0f6, 0xaccd, 0x4788,
            0x3bb3, 0xbffe, 0xc3c5, 0xd807, 0xa43c, 0x2071, 0x5c4a, 0x17f5, 0x6bce, 0xef83, 0x93b8,
            0x887a, 0xf441, 0x700c, 0x0c37, 0xc9e5, 0xb5de, 0x3193, 0x4da8, 0x566a, 0x2a51, 0xae1c,
            0xd227, 0x9998, 0xe5a3, 0x61ee, 0x1dd5, 0x0617, 0x7a2c, 0xfe61, 0x825a, 0x691f, 0x1524,
            0x9169, 0xed52, 0xf690, 0x8aab, 0x0ee6, 0x72dd, 0x3962, 0x4559, 0xc114, 0xbd2f, 0xa6ed,
            0xdad6, 0x5e9b, 0x22a0,
        ],
        [
            0x0000, 0x1bdb, 0x37b6, 0x2c6d, 0x6f6c, 0x74b7, 0x58da, 0x4301, 0xded8, 0xc503, 0xe96e,
            0xf2b5, 0xb1b4, 0xaa6f, 0x8602, 0x9dd9, 0xd2d3, 0xc908, 0xe565, 0xfebe, 0xbdbf, 0xa664,
            0x8a09, 0x91d2, 0x0c0b, 0x17d0, 0x3bbd, 0x2066, 0x6367, 0x78bc, 0x54d1, 0x4f0a, 0xcac5,
            0xd11e, 0xfd73, 0xe6a8, 0xa5a9, 0xbe72, 0x921f, 0x89c4, 0x141d, 0x0fc6, 0x23ab, 0x3870,
            0x7b71, 0x60aa, 0x4cc7, 0x571c, 0x1816, 0x03cd, 0x2fa0, 0x347b, 0x777a, 0x6ca1, 0x40cc,
            0x5b17, 0xc6ce, 0xdd15, 0xf178, 0xeaa3, 0xa9a2, 0xb279, 0x9e14, 0x85cf, 0xfae9, 0xe132,
            0xcd5f, 0xd684, 0x9585, 0x8e5e, 0xa233, 0xb9e8, 0x2431, 0x3fea, 0x1387, 0x085c, 0x4b5d,
            0x5086, 0x7ceb, 0x6730, 0x283a, 0x33e1, 0x1f8c, 0x0457, 0x4756, 0x5c8d, 0x70e0, 0x6b3b,
            0xf6e2, 0xed39, 0xc154, 0xda8f, 0x998e, 0x8255, 0xae38, 0xb5e3, 0x302c, 0x2bf7, 0x079a,
            0x1c41, 0x5f40, 0x449b, 0x68f6, 0x732d, 0xeef4, 0xf52f, 0xd942, 0xc299, 0x8198, 0x9a43,
            0xb62e, 0xadf5, 0xe2ff, 0xf924, 0xd549, 0xce92, 0x8d93, 0x9648, 0xba25, 0xa1fe, 0x3c27,
            0x27fc, 0x0b91, 0x104a, 0x534b, 0x4890, 0x64fd, 0x7f26, 0x9ab1, 0x816a, 0xad07, 0xb6dc,
            0xf5dd, 0xee06, 0xc26b, 0xd9b0, 0x4469, 0x5fb2, 0x73df, 0x6804, 0x2b05, 0x30de, 0x1cb3,
            0x0768, 0x4862, 0x53b9, 0x7fd4, 0x640f, 0x270e, 0x3cd5, 0x10b8, 0x0b63, 0x96ba, 0x8d61,
            0xa10c, 0xbad7, 0xf9d6, 0xe20d, 0xce60, 0xd5bb, 0x5074, 0x4baf, 0x67c2, 0x7c19, 0x3f18,
            0x24c3, 0x08ae, 0x1375, 0x8eac, 0x9577, 0xb91a, 0xa2c1, 0xe1c0, 0xfa1b, 0xd676, 0xcdad,
            0x82a7, 0x997c, 0xb511, 0xaeca, 0xedcb, 0xf610, 0xda7d, 0xc1a6, 0x5c7f, 0x47a4, 0x6bc9,
            0x7012, 0x3313, 0x28c8, 0x04a5, 0x1f7e, 0x6058, 0x7b83, 0x57ee, 0x4c35, 0x0f34, 0x14ef,
            0x3882, 0x2359, 0xbe80, 0xa55b, 0x8936, 0x92ed, 0xd1ec, 0xca37, 0xe65a, 0xfd81, 0xb28b,
            0xa950, 0x853d, 0x9ee6, 0xdde7, 0xc63c, 0xea51, 0xf18a, 0x6c53, 0x7788, 0x5be5, 0x403e,
            0x033f, 0x18e4, 0x3489, 0x2f52, 0xaa9d, 0xb146, 0x9d2b, 0x86f0, 0xc5f1, 0xde2a, 0xf247,
            0xe99c, 0x7445, 0x6f9e, 0x43f3, 0x5828, 0x1b29, 0x00f2, 0x2c9f, 0x3744, 0x784e, 0x6395,
            0x4ff8, 0x5423, 0x1722, 0x0cf9, 0x2094, 0x3b4f, 0xa696, 0xbd4d, 0x9120, 0x8afb, 0xc9fa,
            0xd221, 0xfe4c, 0xe597,
        ],
        [
            0x0000, 0x5a01, 0xb402, 0xee03, 0x0767, 0x5d66, 0xb365, 0xe964, 0x0ece, 0x54cf, 0xbacc,
            0xe0cd, 0x09a9, 0x53a8, 0xbdab, 0xe7aa, 0x1d9c, 0x479d, 0xa99e, 0xf39f, 0x1afb, 0x40fa,
            0xaef9, 0xf4f8, 0x1352, 0x4953, 0xa750, 0xfd51, 0x1435, 0x4e34, 0xa037, 0xfa36, 0x3b38,
            0x6139, 0x8f3a, 0xd53b, 0x3c5f, 0x665e, 0x885d, 0xd25c, 0x35f6, 0x6ff7, 0x81f4, 0xdbf5,
            0x3291, 0x6890, 0x8693, 0xdc92, 0x26a4, 0x7ca5, 0x92a6, 0xc8a7, 0x21c3, 0x7bc2, 0x95c1,
            0xcfc0, 0x286a, 0x726b, 0x9c68, 0xc669, 0x2f0d, 0x750c, 0x9b0f, 0xc10e, 0x7670, 0x2c71,
            0xc272, 0x9873, 0x7117, 0x2b16, 0xc515, 0x9f14, 0x78be, 0x22bf, 0xccbc, 0x96bd, 0x7fd9,
            0x25d8, 0xcbdb, 0x91da, 0x6bec, 0x31ed, 0xdfee, 0x85ef, 0x6c8b, 0x368a, 0xd889, 0x8288,
            0x6522, 0x3f23, 0xd120, 0x8b21, 0x6245, 0x3844, 0xd647, 0x8c46, 0x4d48, 0x1749, 0xf94a,
            0xa34b, 0x4a2f, 0x102e, 0xfe2d, 0xa42c, 0x4386, 0x1987, 0xf784, 0xad85, 0x44e1, 0x1ee0,
            0xf0e3, 0xaae2, 0x50d4, 0x0ad5, 0xe4d6, 0xbed7, 0x57b3, 0x0db2, 0xe3b1, 0xb9b0, 0x5e1a,
            0x041b, 0xea18, 0xb019, 0x597d, 0x037c, 0xed7f, 0xb77e, 0xece0, 0xb6e1, 0x58e2, 0x02e3,
            0xeb87, 0xb186, 0x5f85, 0x0584, 0xe22e, 0xb82f, 0x562c, 0x0c2d, 0xe549, 0xbf48, 0x514b,
            0x0b4a, 0xf17c, 0xab7d, 0x457e, 0x1f7f, 0xf61b, 0xac1a, 0x4219, 0x1818, 0xffb2, 0xa5b3,
            0x4bb0, 0x11b1, 0xf8d5, 0xa2d4, 0x4cd7, 0x16d6, 0xd7d8, 0x8dd9, 0x63da, 0x39db, 0xd0bf,
            0x8abe, 0x64bd, 0x3ebc, 0xd916, 0x8317, 0x6d14, 0x3715, 0xde71, 0x8470, 0x6a73, 0x3072,
            0xca44, 0x9045, 0x7e46, 0x2447, 0xcd23, 0x9722, 0x7921, 0x2320, 0xc48a, 0x9e8b, 0x7088,
            0x2a89, 0xc3ed, 0x99ec, 0x77ef, 0x2dee, 0x9a90, 0xc091, 0x2e92, 0x7493, 0x9df7, 0xc7f6,
            0x29f5, 0x73f4, 0x945e, 0xce5f, 0x205c, 0x7a5d, 0x9339, 0xc938, 0x273b, 0x7d3a, 0x870c,
            0xdd0d, 0x330e, 0x690f, 0x806b, 0xda6a, 0x3469, 0x6e68, 0x89c2, 0xd3c3, 0x3dc0, 0x67c1,
            0x8ea5, 0xd4a4, 0x3aa7, 0x60a6, 0xa1a8, 0xfba9, 0x15aa, 0x4fab, 0xa6cf, 0xfcce, 0x12cd,
            0x48cc, 0xaf66, 0xf567, 0x1b64, 0x4165, 0xa801, 0xf200, 0x1c03, 0x4602, 0xbc34, 0xe635,
            0x0836, 0x5237, 0xbb53, 0xe152, 0x0f51, 0x5550, 0xb2fa, 0xe8fb, 0x06f8, 0x5cf9, 0xb59d,
            0xef9c, 0x019f, 0x5b9e,
        ],
        [
            0x0000, 0xb6a3, 0x0225, 0xb486, 0x044a, 0xb2e9, 0x066f, 0xb0cc, 0x0894, 0xbe37, 0x0ab1,
            0xbc12, 0x0cde, 0xba7d, 0x0efb, 0xb858, 0x1128, 0xa78b, 0x130d, 0xa5ae, 0x1562, 0xa3c1,
            0x1747, 0xa1e4, 0x19bc, 0xaf1f, 0x1b99, 0xad3a, 0x1df6, 0xab55, 0x1fd3, 0xa970, 0x2250,
            0x94f3, 0x2075, 0x96d6, 0x261a, 0x90b9, 0x243f, 0x929c, 0x2ac4, 0x9c67, 0x28e1, 0x9e42,
            0x2e8e, 0x982d, 0x2cab, 0x9a08, 0x3378, 0x85db, 0x315d, 0x87fe, 0x3732, 0x8191, 0x3517,
            0x83b4, 0x3bec, 0x8d4f, 0x39c9, 0x8f6a, 0x3fa6, 0x8905, 0x3d83, 0x8b20, 0x44a0, 0xf203,
            0x4685, 0xf026, 0x40ea, 0xf649, 0x42cf, 0xf46c, 0x4c34, 0xfa97, 0x4e11, 0xf8b2, 0x487e,
            0xfedd, 0x4a5b, 0xfcf8, 0x5588, 0xe32b, 0x57ad, 0xe10e, 0x51c2, 0xe761, 0x53e7, 0xe544,
            0x5d1c, 0xebbf, 0x5f39, 0xe99a, 0x5956, 0xeff5, 0x5b73, 0xedd0, 0x66f0, 0xd053, 0x64d5,
            0xd276, 0x62ba, 0xd419, 0x609f, 0xd63c, 0x6e64, 0xd8c7, 0x6c41, 0xdae2, 0x6a2e, 0xdc8d,
            0x680b, 0xdea8, 0x77d8, 0xc17b, 0x75fd, 0xc35e, 0x7392, 0xc531, 0x71b7, 0xc714, 0x7f4c,
            0xc9ef, 0x7d69, 0xcbca, 0x7b06, 0xcda5, 0x7923, 0xcf80, 0x8940, 0x3fe3, 0x8b65, 0x3dc6,
            0x8d0a, 0x3ba9, 0x8f2f, 0x398c, 0x81d4, 0x3777, 0x83f1, 0x3552, 0x859e, 0x333d, 0x87bb,
            0x3118, 0x9868, 0x2ecb, 0x9a4d, 0x2cee, 0x9c22, 0x2a81, 0x9e07, 0x28a4, 0x90fc, 0x265f,
            0x92d9, 0x247a, 0x94b6, 0x2215, 0x9693, 0x2030, 0xab10, 0x1db3, 0xa935, 0x1f96, 0xaf5a,
            0x19f9, 0xad7f, 0x1bdc, 0xa384, 0x1527, 0xa1a1, 0x1702, 0xa7ce, 0x116d, 0xa5eb, 0x1348,
            0xba38, 0x0c9b, 0xb81d, 0x0ebe, 0xbe72, 0x08d1, 0xbc57, 0x0af4, 0xb2ac, 0x040f, 0xb089,
            0x062a, 0xb6e6, 0x0045, 0xb4c3, 0x0260, 0xcde0, 0x7b43, 0xcfc5, 0x7966, 0xc9aa, 0x7f09,
            0xcb8f, 0x7d2c, 0xc574, 0x73d7, 0xc751, 0x71f2, 0xc13e, 0x779d, 0xc31b, 0x75b8, 0xdcc8,
            0x6a6b, 0xdeed, 0x684e, 0xd882, 0x6e21, 0xdaa7, 0x6c04, 0xd45c, 0x62ff, 0xd679, 0x60da,
            0xd016, 0x66b5, 0xd233, 0x6490, 0xefb0, 0x5913, 0xed95, 0x5b36, 0xebfa, 0x5d59, 0xe9df,
            0x5f7c, 0xe724, 0x5187, 0xe501, 0x53a2, 0xe36e, 0x55cd, 0xe14b, 0x57e8, 0xfe98, 0x483b,
            0xfcbd, 0x4a1e, 0xfad2, 0x4c71, 0xf8f7, 0x4e54, 0xf60c, 0x40af, 0xf429, 0x428a, 0xf246,
            0x44e5, 0xf063, 0x46c0,
        ],
        [
            0x0000, 0x7de3, 0xfbc6, 0x8625, 0x98ef, 0xe50c, 0x6329, 0x1eca, 0x5ebd, 0x235e, 0xa57b,
            0xd898, 0xc652, 0xbbb1, 0x3d94, 0x4077, 0xbd7a, 0xc099, 0x46bc, 0x3b5f, 0x2595, 0x5876,
            0xde53, 0xa3b0, 0xe3c7, 0x9e24, 0x1801, 0x65e2, 0x7b28, 0x06cb, 0x80ee, 0xfd0d, 0x1597,
            0x6874, 0xee51, 0x93b2, 0x8d78, 0xf09b, 0x76be, 0x0b5d, 0x4b2a, 0x36c9, 0xb0ec, 0xcd0f,
            0xd3c5, 0xae26, 0x2803, 0x55e0, 0xa8ed, 0xd50e, 0x532b, 0x2ec8, 0x3002, 0x4de1, 0xcbc4,
            0xb627, 0xf650, 0x8bb3, 0x0d96, 0x7075, 0x6ebf, 0x135c, 0x9579, 0xe89a, 0x2b2e, 0x56cd,
            0xd0e8, 0xad0b, 0xb3c1, 0xce22, 0x4807, 0x35e4, 0x7593, 0x0870, 0x8e55, 0xf3b6, 0xed7c,
            0x909f, 0x16ba, 0x6b59, 0x9654, 0xebb7, 0x6d92, 0x1071, 0x0ebb, 0x7358, 0xf57d, 0x889e,
            0xc8e9, 0xb50a, 0x332f, 0x4ecc, 0x5006, 0x2de5, 0xabc0, 0xd623, 0x3eb9, 0x435a, 0xc57f,
            0xb89c, 0xa656, 0xdbb5, 0x5d90, 0x2073, 0x6004, 0x1de7, 0x9bc2, 0xe621, 0xf8eb, 0x8508,
            0x032d, 0x7ece, 0x83c3, 0xfe20, 0x7805, 0x05e6, 0x1b2c, 0x66cf, 0xe0ea, 0x9d09, 0xdd7e,
            0xa09d, 0x26b8, 0x5b5b, 0x4591, 0x3872, 0xbe57, 0xc3b4, 0x565c, 0x2bbf, 0xad9a, 0xd079,
            0xceb3, 0xb350, 0x3575, 0x4896, 0x08e1, 0x7502, 0xf327, 0x8ec4, 0x900e, 0xeded, 0x6bc8,
            0x162b, 0xeb26, 0x96c5, 0x10e0, 0x6d03, 0x73c9, 0x0e2a, 0x880f, 0xf5ec, 0xb59b, 0xc878,
            0x4e5d, 0x33be, 0x2d74, 0x5097, 0xd6b2, 0xab51, 0x43cb, 0x3e28, 0xb80d, 0xc5ee, 0xdb24,
            0xa6c7, 0x20e2, 0x5d01, 0x1d76, 0x6095, 0xe6b0, 0x9b53, 0x8599, 0xf87a, 0x7e5f, 0x03bc,
            0xfeb1, 0x8352, 0x0577, 0x7894, 0x665e, 0x1bbd, 0x9d98, 0xe07b, 0xa00c, 0xddef, 0x5bca,
            0x2629, 0x38e3, 0x4500, 0xc325, 0xbec6, 0x7d72, 0x0091, 0x86b4, 0xfb57, 0xe59d, 0x987e,
            0x1e5b, 0x63b8, 0x23cf, 0x5e2c, 0xd809, 0xa5ea, 0xbb20, 0xc6c3, 0x40e6, 0x3d05, 0xc008,
            0xbdeb, 0x3bce, 0x462d, 0x58e7, 0x2504, 0xa321, 0xdec2, 0x9eb5, 0xe356, 0x6573, 0x1890,
            0x065a, 0x7bb9, 0xfd9c, 0x807f, 0x68e5, 0x1506, 0x9323, 0xeec0, 0xf00a, 0x8de9, 0x0bcc,
            0x762f, 0x3658, 0x4bbb, 0xcd9e, 0xb07d, 0xaeb7, 0xd354, 0x5571, 0x2892, 0xd59f, 0xa87c,
            0x2e59, 0x53ba, 0x4d70, 0x3093, 0xb6b6, 0xcb55, 0x8b22, 0xf6c1, 0x70e4, 0x0d07, 0x13cd,
            0x6e2e, 0xe80b, 0x95e8,
        ],
        [
            0x0000, 0xacb8, 0x3613, 0x9aab, 0x6c26, 0xc09e, 0x5a35, 0xf68d, 0xd84c, 0x74f4, 0xee5f,
            0x42e7, 0xb46a, 0x18d2, 0x8279, 0x2ec1, 0xdffb, 0x7343, 0xe9e8, 0x4550, 0xb3dd, 0x1f65,
            0x85ce, 0x2976, 0x07b7, 0xab0f, 0x31a4, 0x9d1c, 0x6b91, 0xc729, 0x5d82, 0xf13a, 0xd095,
            0x7c2d, 0xe686, 0x4a3e, 0xbcb3, 0x100b, 0x8aa0, 0x2618, 0x08d9, 0xa461, 0x3eca, 0x9272,
            0x64ff, 0xc847, 0x52ec, 0xfe54, 0x0f6e, 0xa3d6, 0x397d, 0x95c5, 0x6348, 0xcff0, 0x555b,
            0xf9e3, 0xd722, 0x7b9a, 0xe131, 0x4d89, 0xbb04, 0x17bc, 0x8d17, 0x21af, 0xce49, 0x62f1,
            0xf85a, 0x54e2, 0xa26f, 0x0ed7, 0x947c, 0x38c4, 0x1605, 0xbabd, 0x2016, 0x8cae, 0x7a23,
            0xd69b, 0x4c30, 0xe088, 0x11b2, 0xbd0a, 0x27a1, 0x8b19, 0x7d94, 0xd12c, 0x4b87, 0xe73f,
            0xc9fe, 0x6546, 0xffed, 0x5355, 0xa5d8, 0x0960, 0x93cb, 0x3f73, 0x1edc, 0xb264, 0x28cf,
            0x8477, 0x72fa, 0xde42, 0x44e9, 0xe851, 0xc690, 0x6a28, 0xf083, 0x5c3b, 0xaab6, 0x060e,
            0x9ca5, 0x301d, 0xc127, 0x6d9f, 0xf734, 0x5b8c, 0xad01, 0x01b9, 0x9b12, 0x37aa, 0x196b,
            0xb5d3, 0x2f78, 0x83c0, 0x754d, 0xd9f5, 0x435e, 0xefe6, 0xf3f1, 0x5f49, 0xc5e2, 0x695a,
            0x9fd7, 0x336f, 0xa9c4, 0x057c, 0x2bbd, 0x8705, 0x1dae, 0xb116, 0x479b, 0xeb23, 0x7188,
            0xdd30, 0x2c0a, 0x80b2, 0x1a19, 0xb6a1, 0x402c, 0xec94, 0x763f, 0xda87, 0xf446, 0x58fe,
            0xc255, 0x6eed, 0x9860, 0x34d8, 0xae73, 0x02cb, 0x2364, 0x8fdc, 0x1577, 0xb9cf, 0x4f42,
            0xe3fa, 0x7951, 0xd5e9, 0xfb28, 0x5790, 0xcd3b, 0x6183, 0x970e, 0x3bb6, 0xa11d, 0x0da5,
            0xfc9f, 0x5027, 0xca8c, 0x6634, 0x90b9, 0x3c01, 0xa6aa, 0x0a12, 0x24d3, 0x886b, 0x12c0,
            0xbe78, 0x48f5, 0xe44d, 0x7ee6, 0xd25e, 0x3db8, 0x9100, 0x0bab, 0xa713, 0x519e, 0xfd26,
            0x678d, 0xcb35, 0xe5f4, 0x494c, 0xd3e7, 0x7f5f, 0x89d2, 0x256a, 0xbfc1, 0x1379, 0xe243,
            0x4efb, 0xd450, 0x78e8, 0x8e65, 0x22dd, 0xb876, 0x14ce, 0x3a0f, 0x96b7, 0x0c1c, 0xa0a4,
            0x5629, 0xfa91, 0x603a, 0xcc82, 0xed2d, 0x4195, 0xdb3e, 0x7786, 0x810b, 0x2db3, 0xb718,
            0x1ba0, 0x3561, 0x99d9, 0x0372, 0xafca, 0x5947, 0xf5ff, 0x6f54, 0xc3ec, 0x32d6, 0x9e6e,
            0x04c5, 0xa87d, 0x5ef0, 0xf248, 0x68e3, 0xc45b, 0xea9a, 0x4622, 0xdc89, 0x7031, 0x86bc,
            0x2a04, 0xb0af, 0x1c17,
        ],
        [
            0x0000, 0x8881, 0x7e61, 0xf6e0, 0xfcc2, 0x7443, 0x82a3, 0x0a22, 0x96e7, 0x1e66, 0xe886,
            0x6007, 0x6a25, 0xe2a4, 0x1444, 0x9cc5, 0x42ad, 0xca2c, 0x3ccc, 0xb44d, 0xbe6f, 0x36ee,
            0xc00e, 0x488f, 0xd44a, 0x5ccb, 0xaa2b, 0x22aa, 0x2888, 0xa009, 0x56e9, 0xde68, 0x855a,
            0x0ddb, 0xfb3b, 0x73ba, 0x7998, 0xf119, 0x07f9, 0x8f78, 0x13bd, 0x9b3c, 0x6ddc, 0xe55d,
            0xef7f, 0x67fe, 0x911e, 0x199f, 0xc7f7, 0x4f76, 0xb996, 0x3117, 0x3b35, 0xb3b4, 0x4554,
            0xcdd5, 0x5110, 0xd991, 0x2f71, 0xa7f0, 0xadd2, 0x2553, 0xd3b3, 0x5b32, 0x65d7, 0xed56,
            0x1bb6, 0x9337, 0x9915, 0x1194, 0xe774, 0x6ff5, 0xf330, 0x7bb1, 0x8d51, 0x05d0, 0x0ff2,
            0x8773, 0x7193, 0xf912, 0x277a, 0xaffb, 0x591b, 0xd19a, 0xdbb8, 0x5339, 0xa5d9, 0x2d58,
            0xb19d, 0x391c, 0xcffc, 0x477d, 0x4d5f, 0xc5de, 0x333e, 0xbbbf, 0xe08d, 0x680c, 0x9eec,
            0x166d, 0x1c4f, 0x94ce, 0x622e, 0xeaaf, 0x766a, 0xfeeb, 0x080b, 0x808a, 0x8aa8, 0x0229,
            0xf4c9, 0x7c48, 0xa220, 0x2aa1, 0xdc41, 0x54c0, 0x5ee2, 0xd663, 0x2083, 0xa802, 0x34c7,
            0xbc46, 0x4aa6, 0xc227, 0xc805, 0x4084, 0xb664, 0x3ee5, 0xcbae, 0x432f, 0xb5cf, 0x3d4e,
            0x376c, 0xbfed, 0x490d, 0xc18c, 0x5d49, 0xd5c8, 0x2328, 0xaba9, 0xa18b, 0x290a, 0xdfea,
            0x576b, 0x8903, 0x0182, 0xf762, 0x7fe3, 0x75c1, 0xfd40, 0x0ba0, 0x8321, 0x1fe4, 0x9765,
            0x6185, 0xe904, 0xe326, 0x6ba7, 0x9d47, 0x15c6, 0x4ef4, 0xc675, 0x3095, 0xb814, 0xb236,
            0x3ab7, 0xcc57, 0x44d6, 0xd813, 0x5092, 0xa672, 0x2ef3, 0x24d1, 0xac50, 0x5ab0, 0xd231,
            0x0c59, 0x84d8, 0x7238, 0xfab9, 0xf09b, 0x781a, 0x8efa, 0x067b, 0x9abe, 0x123f, 0xe4df,
            0x6c5e, 0x667c, 0xeefd, 0x181d, 0x909c, 0xae79, 0x26f8, 0xd018, 0x5899, 0x52bb, 0xda3a,
            0x2cda, 0xa45b, 0x389e, 0xb01f, 0x46ff, 0xce7e, 0xc45c, 0x4cdd, 0xba3d, 0x32bc, 0xecd4,
            0x6455, 0x92b5, 0x1a34, 0x1016, 0x9897, 0x6e77, 0xe6f6, 0x7a33, 0xf2b2, 0x0452, 0x8cd3,
            0x86f1, 0x0e70, 0xf890, 0x7011, 0x2b23, 0xa3a2, 0x5542, 0xddc3, 0xd7e1, 0x5f60, 0xa980,
            0x2101, 0xbdc4, 0x3545, 0xc3a5, 0x4b24, 0x4106, 0xc987, 0x3f67, 0xb7e6, 0x698e, 0xe10f,
            0x17ef, 0x9f6e, 0x954c, 0x1dcd, 0xeb2d, 0x63ac, 0xff69, 0x77e8, 0x8108, 0x0989, 0x03ab,
            0x8b2a, 0x7dca, 0xf54b,
        ],
    ];

    pub static CRC16_M17_TABLE: [[u16; 256]; 16] = [
        [
            0x0000, 0x5935, 0xb26a, 0xeb5f, 0x3de1, 0x64d4, 0x8f8b, 0xd6be, 0x7bc2, 0x22f7, 0xc9a8,
            0x909d, 0x4623, 0x1f16, 0xf449, 0xad7c, 0xf784, 0xaeb1, 0x45ee, 0x1cdb, 0xca65, 0x9350,
            0x780f, 0x213a, 0x8c46, 0xd573, 0x3e2c, 0x6719, 0xb1a7, 0xe892, 0x03cd, 0x5af8, 0xb63d,
            0xef08, 0x0457, 0x5d62, 0x8bdc, 0xd2e9, 0x39b6, 0x6083, 0xcdff, 0x94ca, 0x7f95, 0x26a0,
            0xf01e, 0xa92b, 0x4274, 0x1b41, 0x41b9, 0x188c, 0xf3d3, 0xaae6, 0x7c58, 0x256d, 0xce32,
            0x9707, 0x3a7b, 0x634e, 0x8811, 0xd124, 0x079a, 0x5eaf, 0xb5f0, 0xecc5, 0x354f, 0x6c7a,
            0x8725, 0xde10, 0x08ae, 0x519b, 0xbac4, 0xe3f1, 0x4e8d, 0x17b8, 0xfce7, 0xa5d2, 0x736c,
            0x2a59, 0xc106, 0x9833, 0xc2cb, 0x9bfe, 0x70a1, 0x2994, 0xff2a, 0xa61f, 0x4d40, 0x1475,
            0xb909, 0xe03c, 0x0b63, 0x5256, 0x84e8, 0xdddd, 0x3682, 0x6fb7, 0x8372, 0xda47, 0x3118,
            0x682d, 0xbe93, 0xe7a6, 0x0cf9, 0x55cc, 0xf8b0, 0xa185, 0x4ada, 0x13ef, 0xc551, 0x9c64,
            0x773b, 0x2e0e, 0x74f6, 0x2dc3, 0xc69c, 0x9fa9, 0x4917, 0x1022, 0xfb7d, 0xa248, 0x0f34,
            0x5601, 0xbd5e, 0xe46b, 0x32d5, 0x6be0, 0x80bf, 0xd98a, 0x6a9e, 0x33ab, 0xd8f4, 0x81c1,
            0x577f, 0x0e4a, 0xe515, 0xbc20, 0x115c, 0x4869, 0xa336, 0xfa03, 0x2cbd, 0x7588, 0x9ed7,
            0xc7e2, 0x9d1a, 0xc42f, 0x2f70, 0x7645, 0xa0fb, 0xf9ce, 0x1291, 0x4ba4, 0xe6d8, 0xbfed,
            0x54b2, 0x0d87, 0xdb39, 0x820c, 0x6953, 0x3066, 0xdca3, 0x8596, 0x6ec9, 0x37fc, 0xe142,
            0xb877, 0x5328, 0x0a1d, 0xa761, 0xfe54, 0x150b, 0x4c3e, 0x9a80, 0xc3b5, 0x28ea, 0x71df,
            0x2b27, 0x7212, 0x994d, 0xc078, 0x16c6, 0x4ff3, 0xa4ac, 0xfd99, 0x50e5, 0x09d0, 0xe28f,
            0xbbba, 0x6d04, 0x3431, 0xdf6e, 0x865b, 0x5fd1, 0x06e4, 0xedbb, 0xb48e, 0x6230, 0x3b05,
            0xd05a, 0x896f, 0x2413, 0x7d26, 0x9679, 0xcf4c, 0x19f2, 0x40c7, 0xab98, 0xf2ad, 0xa855,
            0xf160, 0x1a3f, 0x430a, 0x95b4, 0xcc81, 0x27de, 0x7eeb, 0xd397, 0x8aa2, 0x61fd, 0x38c8,
            0xee76, 0xb743, 0x5c1c, 0x0529, 0xe9ec, 0xb0d9, 0x5b86, 0x02b3, 0xd40d, 0x8d38, 0x6667,
            0x3f52, 0x922e, 0xcb1b, 0x2044, 0x7971, 0xafcf, 0xf6fa, 0x1da5, 0x4490, 0x1e68, 0x475d,
            0xac02, 0xf537, 0x2389, 0x7abc, 0x91e3, 0xc8d6, 0x65aa, 0x3c9f, 0xd7c0, 0x8ef5, 0x584b,
            0x017e, 0xea21, 0xb314,
        ],
        [
            0x0000, 0xd53c, 0xf34d, 0x2671, 0xbfaf, 0x6a93, 0x4ce2, 0x99de, 0x266b, 0xf357, 0xd526,
            0x001a, 0x99c4, 0x4cf8, 0x6a89, 0xbfb5, 0x4cd6, 0x99ea, 0xbf9b, 0x6aa7, 0xf379, 0x2645,
            0x0034, 0xd508, 0x6abd, 0xbf81, 0x99f0, 0x4ccc, 0xd512, 0x002e, 0x265f, 0xf363, 0x99ac,
            0x4c90, 0x6ae1, 0xbfdd, 0x2603, 0xf33f, 0xd54e, 0x0072, 0xbfc7, 0x6afb, 0x4c8a, 0x99b6,
            0x0068, 0xd554, 0xf325, 0x2619, 0xd57a, 0x0046, 0x2637, 0xf30b, 0x6ad5, 0xbfe9, 0x9998,
            0x4ca4, 0xf311, 0x262d, 0x005c, 0xd560, 0x4cbe, 0x9982, 0xbff3, 0x6acf, 0x6a6d, 0xbf51,
            0x9920, 0x4c1c, 0xd5c2, 0x00fe, 0x268f, 0xf3b3, 0x4c06, 0x993a, 0xbf4b, 0x6a77, 0xf3a9,
            0x2695, 0x00e4, 0xd5d8, 0x26bb, 0xf387, 0xd5f6, 0x00ca, 0x9914, 0x4c28, 0x6a59, 0xbf65,
            0x00d0, 0xd5ec, 0xf39d, 0x26a1, 0xbf7f, 0x6a43, 0x4c32, 0x990e, 0xf3c1, 0x26fd, 0x008c,
            0xd5b0, 0x4c6e, 0x9952, 0xbf23, 0x6a1f, 0xd5aa, 0x0096, 0x26e7, 0xf3db, 0x6a05, 0xbf39,
            0x9948, 0x4c74, 0xbf17, 0x6a2b, 0x4c5a, 0x9966, 0x00b8, 0xd584, 0xf3f5, 0x26c9, 0x997c,
            0x4c40, 0x6a31, 0xbf0d, 0x26d3, 0xf3ef, 0xd59e, 0x00a2, 0xd4da, 0x01e6, 0x2797, 0xf2ab,
            0x6b75, 0xbe49, 0x9838, 0x4d04, 0xf2b1, 0x278d, 0x01fc, 0xd4c0, 0x4d1e, 0x9822, 0xbe53,
            0x6b6f, 0x980c, 0x4d30, 0x6b41, 0xbe7d, 0x27a3, 0xf29f, 0xd4ee, 0x01d2, 0xbe67, 0x6b5b,
            0x4d2a, 0x9816, 0x01c8, 0xd4f4, 0xf285, 0x27b9, 0x4d76, 0x984a, 0xbe3b, 0x6b07, 0xf2d9,
            0x27e5, 0x0194, 0xd4a8, 0x6b1d, 0xbe21, 0x9850, 0x4d6c, 0xd4b2, 0x018e, 0x27ff, 0xf2c3,
            0x01a0, 0xd49c, 0xf2ed, 0x27d1, 0xbe0f, 0x6b33, 0x4d42, 0x987e, 0x27cb, 0xf2f7, 0xd486,
            0x01ba, 0x9864, 0x4d58, 0x6b29, 0xbe15, 0xbeb7, 0x6b8b, 0x4dfa, 0x98c6, 0x0118, 0xd424,
            0xf255, 0x2769, 0x98dc, 0x4de0, 0x6b91, 0xbead, 0x2773, 0xf24f, 0xd43e, 0x0102, 0xf261,
            0x275d, 0x012c, 0xd410, 0x4dce, 0x98f2, 0xbe83, 0x6bbf, 0xd40a, 0x0136, 0x2747, 0xf27b,
            0x6ba5, 0xbe99, 0x98e8, 0x4dd4, 0x271b, 0xf227, 0xd456, 0x016a, 0x98b4, 0x4d88, 0x6bf9,
            0xbec5, 0x0170, 0xd44c, 0xf23d, 0x2701, 0xbedf, 0x6be3, 0x4d92, 0x98ae, 0x6bcd, 0xbef1,
            0x9880, 0x4dbc, 0xd462, 0x015e, 0x272f, 0xf213, 0x4da6, 0x989a, 0xbeeb, 0x6bd7, 0xf209,
            0x2735, 0x0144, 0xd478,
        ],
        [
            0x0000, 0xf081, 0xb837, 0x48b6, 0x295b, 0xd9da, 0x916c, 0x61ed, 0x52b6, 0xa237, 0xea81,
            0x1a00, 0x7bed, 0x8b6c, 0xc3da, 0x335b, 0xa56c, 0x55ed, 0x1d5b, 0xedda, 0x8c37, 0x7cb6,
            0x3400, 0xc481, 0xf7da, 0x075b, 0x4fed, 0xbf6c, 0xde81, 0x2e00, 0x66b6, 0x9637, 0x13ed,
            0xe36c, 0xabda, 0x5b5b, 0x3ab6, 0xca37, 0x8281, 0x7200, 0x415b, 0xb1da, 0xf96c, 0x09ed,
            0x6800, 0x9881, 0xd037, 0x20b6, 0xb681, 0x4600, 0x0eb6, 0xfe37, 0x9fda, 0x6f5b, 0x27ed,
            0xd76c, 0xe437, 0x14b6, 0x5c00, 0xac81, 0xcd6c, 0x3ded, 0x755b, 0x85da, 0x27da, 0xd75b,
            0x9fed, 0x6f6c, 0x0e81, 0xfe00, 0xb6b6, 0x4637, 0x756c, 0x85ed, 0xcd5b, 0x3dda, 0x5c37,
            0xacb6, 0xe400, 0x1481, 0x82b6, 0x7237, 0x3a81, 0xca00, 0xabed, 0x5b6c, 0x13da, 0xe35b,
            0xd000, 0x2081, 0x6837, 0x98b6, 0xf95b, 0x09da, 0x416c, 0xb1ed, 0x3437, 0xc4b6, 0x8c00,
            0x7c81, 0x1d6c, 0xeded, 0xa55b, 0x55da, 0x6681, 0x9600, 0xdeb6, 0x2e37, 0x4fda, 0xbf5b,
            0xf7ed, 0x076c, 0x915b, 0x61da, 0x296c, 0xd9ed, 0xb800, 0x4881, 0x0037, 0xf0b6, 0xc3ed,
            0x336c, 0x7bda, 0x8b5b, 0xeab6, 0x1a37, 0x5281, 0xa200, 0x4fb4, 0xbf35, 0xf783, 0x0702,
            0x66ef, 0x966e, 0xded8, 0x2e59, 0x1d02, 0xed83, 0xa535, 0x55b4, 0x3459, 0xc4d8, 0x8c6e,
            0x7cef, 0xead8, 0x1a59, 0x52ef, 0xa26e, 0xc383, 0x3302, 0x7bb4, 0x8b35, 0xb86e, 0x48ef,
            0x0059, 0xf0d8, 0x9135, 0x61b4, 0x2902, 0xd983, 0x5c59, 0xacd8, 0xe46e, 0x14ef, 0x7502,
            0x8583, 0xcd35, 0x3db4, 0x0eef, 0xfe6e, 0xb6d8, 0x4659, 0x27b4, 0xd735, 0x9f83, 0x6f02,
            0xf935, 0x09b4, 0x4102, 0xb183, 0xd06e, 0x20ef, 0x6859, 0x98d8, 0xab83, 0x5b02, 0x13b4,
            0xe335, 0x82d8, 0x7259, 0x3aef, 0xca6e, 0x686e, 0x98ef, 0xd059, 0x20d8, 0x4135, 0xb1b4,
            0xf902, 0x0983, 0x3ad8, 0xca59, 0x82ef, 0x726e, 0x1383, 0xe302, 0xabb4, 0x5b35, 0xcd02,
            0x3d83, 0x7535, 0x85b4, 0xe459, 0x14d8, 0x5c6e, 0xacef, 0x9fb4, 0x6f35, 0x2783, 0xd702,
            0xb6ef, 0x466e, 0x0ed8, 0xfe59, 0x7b83, 0x8b02, 0xc3b4, 0x3335, 0x52d8, 0xa259, 0xeaef,
            0x1a6e, 0x2935, 0xd9b4, 0x9102, 0x6183, 0x006e, 0xf0ef, 0xb859, 0x48d8, 0xdeef, 0x2e6e,
            0x66d8, 0x9659, 0xf7b4, 0x0735, 0x4f83, 0xbf02, 0x8c59, 0x7cd8, 0x346e, 0xc4ef, 0xa502,
            0x5583, 0x1d35, 0xedb4,
        ],
        [
            0x0000, 0x9f68, 0x67e5, 0xf88d, 0xcfca, 0x50a2, 0xa82f, 0x3747, 0xc6a1, 0x59c9, 0xa144,
            0x3e2c, 0x096b, 0x9603, 0x6e8e, 0xf1e6, 0xd477, 0x4b1f, 0xb392, 0x2cfa, 0x1bbd, 0x84d5,
            0x7c58, 0xe330, 0x12d6, 0x8dbe, 0x7533, 0xea5b, 0xdd1c, 0x4274, 0xbaf9, 0x2591, 0xf1db,
            0x6eb3, 0x963e, 0x0956, 0x3e11, 0xa179, 0x59f4, 0xc69c, 0x377a, 0xa812, 0x509f, 0xcff7,
            0xf8b0, 0x67d8, 0x9f55, 0x003d, 0x25ac, 0xbac4, 0x4249, 0xdd21, 0xea66, 0x750e, 0x8d83,
            0x12eb, 0xe30d, 0x7c65, 0x84e8, 0x1b80, 0x2cc7, 0xb3af, 0x4b22, 0xd44a, 0xba83, 0x25eb,
            0xdd66, 0x420e, 0x7549, 0xea21, 0x12ac, 0x8dc4, 0x7c22, 0xe34a, 0x1bc7, 0x84af, 0xb3e8,
            0x2c80, 0xd40d, 0x4b65, 0x6ef4, 0xf19c, 0x0911, 0x9679, 0xa13e, 0x3e56, 0xc6db, 0x59b3,
            0xa855, 0x373d, 0xcfb0, 0x50d8, 0x679f, 0xf8f7, 0x007a, 0x9f12, 0x4b58, 0xd430, 0x2cbd,
            0xb3d5, 0x8492, 0x1bfa, 0xe377, 0x7c1f, 0x8df9, 0x1291, 0xea1c, 0x7574, 0x4233, 0xdd5b,
            0x25d6, 0xbabe, 0x9f2f, 0x0047, 0xf8ca, 0x67a2, 0x50e5, 0xcf8d, 0x3700, 0xa868, 0x598e,
            0xc6e6, 0x3e6b, 0xa103, 0x9644, 0x092c, 0xf1a1, 0x6ec9, 0x2c33, 0xb35b, 0x4bd6, 0xd4be,
            0xe3f9, 0x7c91, 0x841c, 0x1b74, 0xea92, 0x75fa, 0x8d77, 0x121f, 0x2558, 0xba30, 0x42bd,
            0xddd5, 0xf844, 0x672c, 0x9fa1, 0x00c9, 0x378e, 0xa8e6, 0x506b, 0xcf03, 0x3ee5, 0xa18d,
            0x5900, 0xc668, 0xf12f, 0x6e47, 0x96ca, 0x09a2, 0xdde8, 0x4280, 0xba0d, 0x2565, 0x1222,
            0x8d4a, 0x75c7, 0xeaaf, 0x1b49, 0x8421, 0x7cac, 0xe3c4, 0xd483, 0x4beb, 0xb366, 0x2c0e,
            0x099f, 0x96f7, 0x6e7a, 0xf112, 0xc655, 0x593d, 0xa1b0, 0x3ed8, 0xcf3e, 0x5056, 0xa8db,
            0x37b3, 0x00f4, 0x9f9c, 0x6711, 0xf879, 0x96b0, 0x09d8, 0xf155, 0x6e3d, 0x597a, 0xc612,
            0x3e9f, 0xa1f7, 0x5011, 0xcf79, 0x37f4, 0xa89c, 0x9fdb, 0x00b3, 0xf83e, 0x6756, 0x42c7,
            0xddaf, 0x2522, 0xba4a, 0x8d0d, 0x1265, 0xeae8, 0x7580, 0x8466, 0x1b0e, 0xe383, 0x7ceb,
            0x4bac, 0xd4c4, 0x2c49, 0xb321, 0x676b, 0xf803, 0x008e, 0x9fe6, 0xa8a1, 0x37c9, 0xcf44,
            0x502c, 0xa1ca, 0x3ea2, 0xc62f, 0x5947, 0x6e00, 0xf168, 0x09e5, 0x968d, 0xb31c, 0x2c74,
            0xd4f9, 0x4b91, 0x7cd6, 0xe3be, 0x1b33, 0x845b, 0x75bd, 0xead5, 0x1258, 0x8d30, 0xba77,
            0x251f, 0xdd92, 0x42fa,
        ],
        [
            0x0000, 0x5866, 0xb0cc, 0xe8aa, 0x38ad, 0x60cb, 0x8861, 0xd007, 0x715a, 0x293c, 0xc196,
            0x99f0, 0x49f7, 0x1191, 0xf93b, 0xa15d, 0xe2b4, 0xbad2, 0x5278, 0x0a1e, 0xda19, 0x827f,
            0x6ad5, 0x32b3, 0x93ee, 0xcb88, 0x2322, 0x7b44, 0xab43, 0xf325, 0x1b8f, 0x43e9, 0x9c5d,
            0xc43b, 0x2c91, 0x74f7, 0xa4f0, 0xfc96, 0x143c, 0x4c5a, 0xed07, 0xb561, 0x5dcb, 0x05ad,
            0xd5aa, 0x8dcc, 0x6566, 0x3d00, 0x7ee9, 0x268f, 0xce25, 0x9643, 0x4644, 0x1e22, 0xf688,
            0xaeee, 0x0fb3, 0x57d5, 0xbf7f, 0xe719, 0x371e, 0x6f78, 0x87d2, 0xdfb4, 0x618f, 0x39e9,
            0xd143, 0x8925, 0x5922, 0x0144, 0xe9ee, 0xb188, 0x10d5, 0x48b3, 0xa019, 0xf87f, 0x2878,
            0x701e, 0x98b4, 0xc0d2, 0x833b, 0xdb5d, 0x33f7, 0x6b91, 0xbb96, 0xe3f0, 0x0b5a, 0x533c,
            0xf261, 0xaa07, 0x42ad, 0x1acb, 0xcacc, 0x92aa, 0x7a00, 0x2266, 0xfdd2, 0xa5b4, 0x4d1e,
            0x1578, 0xc57f, 0x9d19, 0x75b3, 0x2dd5, 0x8c88, 0xd4ee, 0x3c44, 0x6422, 0xb425, 0xec43,
            0x04e9, 0x5c8f, 0x1f66, 0x4700, 0xafaa, 0xf7cc, 0x27cb, 0x7fad, 0x9707, 0xcf61, 0x6e3c,
            0x365a, 0xdef0, 0x8696, 0x5691, 0x0ef7, 0xe65d, 0xbe3b, 0xc31e, 0x9b78, 0x73d2, 0x2bb4,
            0xfbb3, 0xa3d5, 0x4b7f, 0x1319, 0xb244, 0xea22, 0x0288, 0x5aee, 0x8ae9, 0xd28f, 0x3a25,
            0x6243, 0x21aa, 0x79cc, 0x9166, 0xc900, 0x1907, 0x4161, 0xa9cb, 0xf1ad, 0x50f0, 0x0896,
            0xe03c, 0xb85a, 0x685d, 0x303b, 0xd891, 0x80f7, 0x5f43, 0x0725, 0xef8f, 0xb7e9, 0x67ee,
            0x3f88, 0xd722, 0x8f44, 0x2e19, 0x767f, 0x9ed5, 0xc6b3, 0x16b4, 0x4ed2, 0xa678, 0xfe1e,
            0xbdf7, 0xe591, 0x0d3b, 0x555d, 0x855a, 0xdd3c, 0x3596, 0x6df0, 0xccad, 0x94cb, 0x7c61,
            0x2407, 0xf400, 0xac66, 0x44cc, 0x1caa, 0xa291, 0xfaf7, 0x125d, 0x4a3b, 0x9a3c, 0xc25a,
            0x2af0, 0x7296, 0xd3cb, 0x8bad, 0x6307, 0x3b61, 0xeb66, 0xb300, 0x5baa, 0x03cc, 0x4025,
            0x1843, 0xf0e9, 0xa88f, 0x7888, 0x20ee, 0xc844, 0x9022, 0x317f, 0x6919, 0x81b3, 0xd9d5,
            0x09d2, 0x51b4, 0xb91e, 0xe178, 0x3ecc, 0x66aa, 0x8e00, 0xd666, 0x0661, 0x5e07, 0xb6ad,
            0xeecb, 0x4f96, 0x17f0, 0xff5a, 0xa73c, 0x773b, 0x2f5d, 0xc7f7, 0x9f91, 0xdc78, 0x841e,
            0x6cb4, 0x34d2, 0xe4d5, 0xbcb3, 0x5419, 0x0c7f, 0xad22, 0xf544, 0x1dee, 0x4588, 0x958f,
            0xcde9, 0x2543, 0x7d25,
        ],
        [
            0x0000, 0xdf09, 0xe727, 0x382e, 0x977b, 0x4872, 0x705c, 0xaf55, 0x77c3, 0xa8ca, 0x90e4,
            0x4fed, 0xe0b8, 0x3fb1, 0x079f, 0xd896, 0xef86, 0x308f, 0x08a1, 0xd7a8, 0x78fd, 0xa7f4,
            0x9fda, 0x40d3, 0x9845, 0x474c, 0x7f62, 0xa06b, 0x0f3e, 0xd037, 0xe819, 0x3710, 0x8639,
            0x5930, 0x611e, 0xbe17, 0x1142, 0xce4b, 0xf665, 0x296c, 0xf1fa, 0x2ef3, 0x16dd, 0xc9d4,
            0x6681, 0xb988, 0x81a6, 0x5eaf, 0x69bf, 0xb6b6, 0x8e98, 0x5191, 0xfec4, 0x21cd, 0x19e3,
            0xc6ea, 0x1e7c, 0xc175, 0xf95b, 0x2652, 0x8907, 0x560e, 0x6e20, 0xb129, 0x5547, 0x8a4e,
            0xb260, 0x6d69, 0xc23c, 0x1d35, 0x251b, 0xfa12, 0x2284, 0xfd8d, 0xc5a3, 0x1aaa, 0xb5ff,
            0x6af6, 0x52d8, 0x8dd1, 0xbac1, 0x65c8, 0x5de6, 0x82ef, 0x2dba, 0xf2b3, 0xca9d, 0x1594,
            0xcd02, 0x120b, 0x2a25, 0xf52c, 0x5a79, 0x8570, 0xbd5e, 0x6257, 0xd37e, 0x0c77, 0x3459,
            0xeb50, 0x4405, 0x9b0c, 0xa322, 0x7c2b, 0xa4bd, 0x7bb4, 0x439a, 0x9c93, 0x33c6, 0xeccf,
            0xd4e1, 0x0be8, 0x3cf8, 0xe3f1, 0xdbdf, 0x04d6, 0xab83, 0x748a, 0x4ca4, 0x93ad, 0x4b3b,
            0x9432, 0xac1c, 0x7315, 0xdc40, 0x0349, 0x3b67, 0xe46e, 0xaa8e, 0x7587, 0x4da9, 0x92a0,
            0x3df5, 0xe2fc, 0xdad2, 0x05db, 0xdd4d, 0x0244, 0x3a6a, 0xe563, 0x4a36, 0x953f, 0xad11,
            0x7218, 0x4508, 0x9a01, 0xa22f, 0x7d26, 0xd273, 0x0d7a, 0x3554, 0xea5d, 0x32cb, 0xedc2,
            0xd5ec, 0x0ae5, 0xa5b0, 0x7ab9, 0x4297, 0x9d9e, 0x2cb7, 0xf3be, 0xcb90, 0x1499, 0xbbcc,
            0x64c5, 0x5ceb, 0x83e2, 0x5b74, 0x847d, 0xbc53, 0x635a, 0xcc0f, 0x1306, 0x2b28, 0xf421,
            0xc331, 0x1c38, 0x2416, 0xfb1f, 0x544a, 0x8b43, 0xb36d, 0x6c64, 0xb4f2, 0x6bfb, 0x53d5,
            0x8cdc, 0x2389, 0xfc80, 0xc4ae, 0x1ba7, 0xffc9, 0x20c0, 0x18ee, 0xc7e7, 0x68b2, 0xb7bb,
            0x8f95, 0x509c, 0x880a, 0x5703, 0x6f2d, 0xb024, 0x1f71, 0xc078, 0xf856, 0x275f, 0x104f,
            0xcf46, 0xf768, 0x2861, 0x8734, 0x583d, 0x6013, 0xbf1a, 0x678c, 0xb885, 0x80ab, 0x5fa2,
            0xf0f7, 0x2ffe, 0x17d0, 0xc8d9, 0x79f0, 0xa6f9, 0x9ed7, 0x41de, 0xee8b, 0x3182, 0x09ac,
            0xd6a5, 0x0e33, 0xd13a, 0xe914, 0x361d, 0x9948, 0x4641, 0x7e6f, 0xa166, 0x9676, 0x497f,
            0x7151, 0xae58, 0x010d, 0xde04, 0xe62a, 0x3923, 0xe1b5, 0x3ebc, 0x0692, 0xd99b, 0x76ce,
            0xa9c7, 0x91e9, 0x4ee0,
        ],
        [
            0x0000, 0x0c29, 0x1852, 0x147b, 0x30a4, 0x3c8d, 0x28f6, 0x24df, 0x6148, 0x6d61, 0x791a,
            0x7533, 0x51ec, 0x5dc5, 0x49be, 0x4597, 0xc290, 0xceb9, 0xdac2, 0xd6eb, 0xf234, 0xfe1d,
            0xea66, 0xe64f, 0xa3d8, 0xaff1, 0xbb8a, 0xb7a3, 0x937c, 0x9f55, 0x8b2e, 0x8707, 0xdc15,
            0xd03c, 0xc447, 0xc86e, 0xecb1, 0xe098, 0xf4e3, 0xf8ca, 0xbd5d, 0xb174, 0xa50f, 0xa926,
            0x8df9, 0x81d0, 0x95ab, 0x9982, 0x1e85, 0x12ac, 0x06d7, 0x0afe, 0x2e21, 0x2208, 0x3673,
            0x3a5a, 0x7fcd, 0x73e4, 0x679f, 0x6bb6, 0x4f69, 0x4340, 0x573b, 0x5b12, 0xe11f, 0xed36,
            0xf94d, 0xf564, 0xd1bb, 0xdd92, 0xc9e9, 0xc5c0, 0x8057, 0x8c7e, 0x9805, 0x942c, 0xb0f3,
            0xbcda, 0xa8a1, 0xa488, 0x238f, 0x2fa6, 0x3bdd, 0x37f4, 0x132b, 0x1f02, 0x0b79, 0x0750,
            0x42c7, 0x4eee, 0x5a95, 0x56bc, 0x7263, 0x7e4a, 0x6a31, 0x6618, 0x3d0a, 0x3123, 0x2558,
            0x2971, 0x0dae, 0x0187, 0x15fc, 0x19d5, 0x5c42, 0x506b, 0x4410, 0x4839, 0x6ce6, 0x60cf,
            0x74b4, 0x789d, 0xff9a, 0xf3b3, 0xe7c8, 0xebe1, 0xcf3e, 0xc317, 0xd76c, 0xdb45, 0x9ed2,
            0x92fb, 0x8680, 0x8aa9, 0xae76, 0xa25f, 0xb624, 0xba0d, 0x9b0b, 0x9722, 0x8359, 0x8f70,
            0xabaf, 0xa786, 0xb3fd, 0xbfd4, 0xfa43, 0xf66a, 0xe211, 0xee38, 0xcae7, 0xc6ce, 0xd2b5,
            0xde9c, 0x599b, 0x55b2, 0x41c9, 0x4de0, 0x693f, 0x6516, 0x716d, 0x7d44, 0x38d3, 0x34fa,
            0x2081, 0x2ca8, 0x0877, 0x045e, 0x1025, 0x1c0c, 0x471e, 0x4b37, 0x5f4c, 0x5365, 0x77ba,
            0x7b93, 0x6fe8, 0x63c1, 0x2656, 0x2a7f, 0x3e04, 0x322d, 0x16f2, 0x1adb, 0x0ea0, 0x0289,
            0x858e, 0x89a7, 0x9ddc, 0x91f5, 0xb52a, 0xb903, 0xad78, 0xa151, 0xe4c6, 0xe8ef, 0xfc94,
            0xf0bd, 0xd462, 0xd84b, 0xcc30, 0xc019, 0x7a14, 0x763d, 0x6246, 0x6e6f, 0x4ab0, 0x4699,
            0x52e2, 0x5ecb, 0x1b5c, 0x1775, 0x030e, 0x0f27, 0x2bf8, 0x27d1, 0x33aa, 0x3f83, 0xb884,
            0xb4ad, 0xa0d6, 0xacff, 0x8820, 0x8409, 0x9072, 0x9c5b, 0xd9cc, 0xd5e5, 0xc19e, 0xcdb7,
            0xe968, 0xe541, 0xf13a, 0xfd13, 0xa601, 0xaa28, 0xbe53, 0xb27a, 0x96a5, 0x9a8c, 0x8ef7,
            0x82de, 0xc749, 0xcb60, 0xdf1b, 0xd332, 0xf7ed, 0xfbc4, 0xefbf, 0xe396, 0x6491, 0x68b8,
            0x7cc3, 0x70ea, 0x5435, 0x581c, 0x4c67, 0x404e, 0x05d9, 0x09f0, 0x1d8b, 0x11a2, 0x357d,
            0x3954, 0x2d2f, 0x2106,
        ],
        [
            0x0000, 0x6f23, 0xde46, 0xb165, 0xe5b9, 0x8a9a, 0x3bff, 0x54dc, 0x9247, 0xfd64, 0x4c01,
            0x2322, 0x77fe, 0x18dd, 0xa9b8, 0xc69b, 0x7dbb, 0x1298, 0xa3fd, 0xccde, 0x9802, 0xf721,
            0x4644, 0x2967, 0xeffc, 0x80df, 0x31ba, 0x5e99, 0x0a45, 0x6566, 0xd403, 0xbb20, 0xfb76,
            0x9455, 0x2530, 0x4a13, 0x1ecf, 0x71ec, 0xc089, 0xafaa, 0x6931, 0x0612, 0xb777, 0xd854,
            0x8c88, 0xe3ab, 0x52ce, 0x3ded, 0x86cd, 0xe9ee, 0x588b, 0x37a8, 0x6374, 0x0c57, 0xbd32,
            0xd211, 0x148a, 0x7ba9, 0xcacc, 0xa5ef, 0xf133, 0x9e10, 0x2f75, 0x4056, 0xafd9, 0xc0fa,
            0x719f, 0x1ebc, 0x4a60, 0x2543, 0x9426, 0xfb05, 0x3d9e, 0x52bd, 0xe3d8, 0x8cfb, 0xd827,
            0xb704, 0x0661, 0x6942, 0xd262, 0xbd41, 0x0c24, 0x6307, 0x37db, 0x58f8, 0xe99d, 0x86be,
            0x4025, 0x2f06, 0x9e63, 0xf140, 0xa59c, 0xcabf, 0x7bda, 0x14f9, 0x54af, 0x3b8c, 0x8ae9,
            0xe5ca, 0xb116, 0xde35, 0x6f50, 0x0073, 0xc6e8, 0xa9cb, 0x18ae, 0x778d, 0x2351, 0x4c72,
            0xfd17, 0x9234, 0x2914, 0x4637, 0xf752, 0x9871, 0xccad, 0xa38e, 0x12eb, 0x7dc8, 0xbb53,
            0xd470, 0x6515, 0x0a36, 0x5eea, 0x31c9, 0x80ac, 0xef8f, 0x0687, 0x69a4, 0xd8c1, 0xb7e2,
            0xe33e, 0x8c1d, 0x3d78, 0x525b, 0x94c0, 0xfbe3, 0x4a86, 0x25a5, 0x7179, 0x1e5a, 0xaf3f,
            0xc01c, 0x7b3c, 0x141f, 0xa57a, 0xca59, 0x9e85, 0xf1a6, 0x40c3, 0x2fe0, 0xe97b, 0x8658,
            0x373d, 0x581e, 0x0cc2, 0x63e1, 0xd284, 0xbda7, 0xfdf1, 0x92d2, 0x23b7, 0x4c94, 0x1848,
            0x776b, 0xc60e, 0xa92d, 0x6fb6, 0x0095, 0xb1f0, 0xded3, 0x8a0f, 0xe52c, 0x5449, 0x3b6a,
            0x804a, 0xef69, 0x5e0c, 0x312f, 0x65f3, 0x0ad0, 0xbbb5, 0xd496, 0x120d, 0x7d2e, 0xcc4b,
            0xa368, 0xf7b4, 0x9897, 0x29f2, 0x46d1, 0xa95e, 0xc67d, 0x7718, 0x183b, 0x4ce7, 0x23c4,
            0x92a1, 0xfd82, 0x3b19, 0x543a, 0xe55f, 0x8a7c, 0xdea0, 0xb183, 0x00e6, 0x6fc5, 0xd4e5,
            0xbbc6, 0x0aa3, 0x6580, 0x315c, 0x5e7f, 0xef1a, 0x8039, 0x46a2, 0x2981, 0x98e4, 0xf7c7,
            0xa31b, 0xcc38, 0x7d5d, 0x127e, 0x5228, 0x3d0b, 0x8c6e, 0xe34d, 0xb791, 0xd8b2, 0x69d7,
            0x06f4, 0xc06f, 0xaf4c, 0x1e29, 0x710a, 0x25d6, 0x4af5, 0xfb90, 0x94b3, 0x2f93, 0x40b0,
            0xf1d5, 0x9ef6, 0xca2a, 0xa509, 0x146c, 0x7b4f, 0xbdd4, 0xd2f7, 0x6392, 0x0cb1, 0x586d,
            0x374e, 0x862b, 0xe908,
        ],
        [
            0x0000, 0x0d0e, 0x1a1c, 0x1712, 0x3438, 0x3936, 0x2e24, 0x232a, 0x6870, 0x657e, 0x726c,
            0x7f62, 0x5c48, 0x5146, 0x4654, 0x4b5a, 0xd0e0, 0xddee, 0xcafc, 0xc7f2, 0xe4d8, 0xe9d6,
            0xfec4, 0xf3ca, 0xb890, 0xb59e, 0xa28c, 0xaf82, 0x8ca8, 0x81a6, 0x96b4, 0x9bba, 0xf8f5,
            0xf5fb, 0xe2e9, 0xefe7, 0xcccd, 0xc1c3, 0xd6d1, 0xdbdf, 0x9085, 0x9d8b, 0x8a99, 0x8797,
            0xa4bd, 0xa9b3, 0xbea1, 0xb3af, 0x2815, 0x251b, 0x3209, 0x3f07, 0x1c2d, 0x1123, 0x0631,
            0x0b3f, 0x4065, 0x4d6b, 0x5a79, 0x5777, 0x745d, 0x7953, 0x6e41, 0x634f, 0xa8df, 0xa5d1,
            0xb2c3, 0xbfcd, 0x9ce7, 0x91e9, 0x86fb, 0x8bf5, 0xc0af, 0xcda1, 0xdab3, 0xd7bd, 0xf497,
            0xf999, 0xee8b, 0xe385, 0x783f, 0x7531, 0x6223, 0x6f2d, 0x4c07, 0x4109, 0x561b, 0x5b15,
            0x104f, 0x1d41, 0x0a53, 0x075d, 0x2477, 0x2979, 0x3e6b, 0x3365, 0x502a, 0x5d24, 0x4a36,
            0x4738, 0x6412, 0x691c, 0x7e0e, 0x7300, 0x385a, 0x3554, 0x2246, 0x2f48, 0x0c62, 0x016c,
            0x167e, 0x1b70, 0x80ca, 0x8dc4, 0x9ad6, 0x97d8, 0xb4f2, 0xb9fc, 0xaeee, 0xa3e0, 0xe8ba,
            0xe5b4, 0xf2a6, 0xffa8, 0xdc82, 0xd18c, 0xc69e, 0xcb90, 0x088b, 0x0585, 0x1297, 0x1f99,
            0x3cb3, 0x31bd, 0x26af, 0x2ba1, 0x60fb, 0x6df5, 0x7ae7, 0x77e9, 0x54c3, 0x59cd, 0x4edf,
            0x43d1, 0xd86b, 0xd565, 0xc277, 0xcf79, 0xec53, 0xe15d, 0xf64f, 0xfb41, 0xb01b, 0xbd15,
            0xaa07, 0xa709, 0x8423, 0x892d, 0x9e3f, 0x9331, 0xf07e, 0xfd70, 0xea62, 0xe76c, 0xc446,
            0xc948, 0xde5a, 0xd354, 0x980e, 0x9500, 0x8212, 0x8f1c, 0xac36, 0xa138, 0xb62a, 0xbb24,
            0x209e, 0x2d90, 0x3a82, 0x378c, 0x14a6, 0x19a8, 0x0eba, 0x03b4, 0x48ee, 0x45e0, 0x52f2,
            0x5ffc, 0x7cd6, 0x71d8, 0x66ca, 0x6bc4, 0xa054, 0xad5a, 0xba48, 0xb746, 0x946c, 0x9962,
            0x8e70, 0x837e, 0xc824, 0xc52a, 0xd238, 0xdf36, 0xfc1c, 0xf112, 0xe600, 0xeb0e, 0x70b4,
            0x7dba, 0x6aa8, 0x67a6, 0x448c, 0x4982, 0x5e90, 0x539e, 0x18c4, 0x15ca, 0x02d8, 0x0fd6,
            0x2cfc, 0x21f2, 0x36e0, 0x3bee, 0x58a1, 0x55af, 0x42bd, 0x4fb3, 0x6c99, 0x6197, 0x7685,
            0x7b8b, 0x30d1, 0x3ddf, 0x2acd, 0x27c3, 0x04e9, 0x09e7, 0x1ef5, 0x13fb, 0x8841, 0x854f,
            0x925d, 0x9f53, 0xbc79, 0xb177, 0xa665, 0xab6b, 0xe031, 0xed3f, 0xfa2d, 0xf723, 0xd409,
            0xd907, 0xce15, 0xc31b,
        ],
        [
            0x0000, 0x1116, 0x222c, 0x333a, 0x4458, 0x554e, 0x6674, 0x7762, 0x88b0, 0x99a6, 0xaa9c,
            0xbb8a, 0xcce8, 0xddfe, 0xeec4, 0xffd2, 0x4855, 0x5943, 0x6a79, 0x7b6f, 0x0c0d, 0x1d1b,
            0x2e21, 0x3f37, 0xc0e5, 0xd1f3, 0xe2c9, 0xf3df, 0x84bd, 0x95ab, 0xa691, 0xb787, 0x90aa,
            0x81bc, 0xb286, 0xa390, 0xd4f2, 0xc5e4, 0xf6de, 0xe7c8, 0x181a, 0x090c, 0x3a36, 0x2b20,
            0x5c42, 0x4d54, 0x7e6e, 0x6f78, 0xd8ff, 0xc9e9, 0xfad3, 0xebc5, 0x9ca7, 0x8db1, 0xbe8b,
            0xaf9d, 0x504f, 0x4159, 0x7263, 0x6375, 0x1417, 0x0501, 0x363b, 0x272d, 0x7861, 0x6977,
            0x5a4d, 0x4b5b, 0x3c39, 0x2d2f, 0x1e15, 0x0f03, 0xf0d1, 0xe1c7, 0xd2fd, 0xc3eb, 0xb489,
            0xa59f, 0x96a5, 0x87b3, 0x3034, 0x2122, 0x1218, 0x030e, 0x746c, 0x657a, 0x5640, 0x4756,
            0xb884, 0xa992, 0x9aa8, 0x8bbe, 0xfcdc, 0xedca, 0xdef0, 0xcfe6, 0xe8cb, 0xf9dd, 0xcae7,
            0xdbf1, 0xac93, 0xbd85, 0x8ebf, 0x9fa9, 0x607b, 0x716d, 0x4257, 0x5341, 0x2423, 0x3535,
            0x060f, 0x1719, 0xa09e, 0xb188, 0x82b2, 0x93a4, 0xe4c6, 0xf5d0, 0xc6ea, 0xd7fc, 0x282e,
            0x3938, 0x0a02, 0x1b14, 0x6c76, 0x7d60, 0x4e5a, 0x5f4c, 0xf0c2, 0xe1d4, 0xd2ee, 0xc3f8,
            0xb49a, 0xa58c, 0x96b6, 0x87a0, 0x7872, 0x6964, 0x5a5e, 0x4b48, 0x3c2a, 0x2d3c, 0x1e06,
            0x0f10, 0xb897, 0xa981, 0x9abb, 0x8bad, 0xfccf, 0xedd9, 0xdee3, 0xcff5, 0x3027, 0x2131,
            0x120b, 0x031d, 0x747f, 0x6569, 0x5653, 0x4745, 0x6068, 0x717e, 0x4244, 0x5352, 0x2430,
            0x3526, 0x061c, 0x170a, 0xe8d8, 0xf9ce, 0xcaf4, 0xdbe2, 0xac80, 0xbd96, 0x8eac, 0x9fba,
            0x283d, 0x392b, 0x0a11, 0x1b07, 0x6c65, 0x7d73, 0x4e49, 0x5f5f, 0xa08d, 0xb19b, 0x82a1,
            0x93b7, 0xe4d5, 0xf5c3, 0xc6f9, 0xd7ef, 0x88a3, 0x99b5, 0xaa8f, 0xbb99, 0xccfb, 0xdded,
            0xeed7, 0xffc1, 0x0013, 0x1105, 0x223f, 0x3329, 0x444b, 0x555d, 0x6667, 0x7771, 0xc0f6,
            0xd1e0, 0xe2da, 0xf3cc, 0x84ae, 0x95b8, 0xa682, 0xb794, 0x4846, 0x5950, 0x6a6a, 0x7b7c,
            0x0c1e, 0x1d08, 0x2e32, 0x3f24, 0x1809, 0x091f, 0x3a25, 0x2b33, 0x5c51, 0x4d47, 0x7e7d,
            0x6f6b, 0x90b9, 0x81af, 0xb295, 0xa383, 0xd4e1, 0xc5f7, 0xf6cd, 0xe7db, 0x505c, 0x414a,
            0x7270, 0x6366, 0x1404, 0x0512, 0x3628, 0x273e, 0xd8ec, 0xc9fa, 0xfac0, 0xebd6, 0x9cb4,
            0x8da2, 0xbe98, 0xaf8e,
        ],
        [
            0x0000, 0xb8b1, 0x2857, 0x90e6, 0x50ae, 0xe81f, 0x78f9, 0xc048, 0xa15c, 0x19ed, 0x890b,
            0x31ba, 0xf1f2, 0x4943, 0xd9a5, 0x6114, 0x1b8d, 0xa33c, 0x33da, 0x8b6b, 0x4b23, 0xf392,
            0x6374, 0xdbc5, 0xbad1, 0x0260, 0x9286, 0x2a37, 0xea7f, 0x52ce, 0xc228, 0x7a99, 0x371a,
            0x8fab, 0x1f4d, 0xa7fc, 0x67b4, 0xdf05, 0x4fe3, 0xf752, 0x9646, 0x2ef7, 0xbe11, 0x06a0,
            0xc6e8, 0x7e59, 0xeebf, 0x560e, 0x2c97, 0x9426, 0x04c0, 0xbc71, 0x7c39, 0xc488, 0x546e,
            0xecdf, 0x8dcb, 0x357a, 0xa59c, 0x1d2d, 0xdd65, 0x65d4, 0xf532, 0x4d83, 0x6e34, 0xd685,
            0x4663, 0xfed2, 0x3e9a, 0x862b, 0x16cd, 0xae7c, 0xcf68, 0x77d9, 0xe73f, 0x5f8e, 0x9fc6,
            0x2777, 0xb791, 0x0f20, 0x75b9, 0xcd08, 0x5dee, 0xe55f, 0x2517, 0x9da6, 0x0d40, 0xb5f1,
            0xd4e5, 0x6c54, 0xfcb2, 0x4403, 0x844b, 0x3cfa, 0xac1c, 0x14ad, 0x592e, 0xe19f, 0x7179,
            0xc9c8, 0x0980, 0xb131, 0x21d7, 0x9966, 0xf872, 0x40c3, 0xd025, 0x6894, 0xa8dc, 0x106d,
            0x808b, 0x383a, 0x42a3, 0xfa12, 0x6af4, 0xd245, 0x120d, 0xaabc, 0x3a5a, 0x82eb, 0xe3ff,
            0x5b4e, 0xcba8, 0x7319, 0xb351, 0x0be0, 0x9b06, 0x23b7, 0xdc68, 0x64d9, 0xf43f, 0x4c8e,
            0x8cc6, 0x3477, 0xa491, 0x1c20, 0x7d34, 0xc585, 0x5563, 0xedd2, 0x2d9a, 0x952b, 0x05cd,
            0xbd7c, 0xc7e5, 0x7f54, 0xefb2, 0x5703, 0x974b, 0x2ffa, 0xbf1c, 0x07ad, 0x66b9, 0xde08,
            0x4eee, 0xf65f, 0x3617, 0x8ea6, 0x1e40, 0xa6f1, 0xeb72, 0x53c3, 0xc325, 0x7b94, 0xbbdc,
            0x036d, 0x938b, 0x2b3a, 0x4a2e, 0xf29f, 0x6279, 0xdac8, 0x1a80, 0xa231, 0x32d7, 0x8a66,
            0xf0ff, 0x484e, 0xd8a8, 0x6019, 0xa051, 0x18e0, 0x8806, 0x30b7, 0x51a3, 0xe912, 0x79f4,
            0xc145, 0x010d, 0xb9bc, 0x295a, 0x91eb, 0xb25c, 0x0aed, 0x9a0b, 0x22ba, 0xe2f2, 0x5a43,
            0xcaa5, 0x7214, 0x1300, 0xabb1, 0x3b57, 0x83e6, 0x43ae, 0xfb1f, 0x6bf9, 0xd348, 0xa9d1,
            0x1160, 0x8186, 0x3937, 0xf97f, 0x41ce, 0xd128, 0x6999, 0x088d, 0xb03c, 0x20da, 0x986b,
            0x5823, 0xe092, 0x7074, 0xc8c5, 0x8546, 0x3df7, 0xad11, 0x15a0, 0xd5e8, 0x6d59, 0xfdbf,
            0x450e, 0x241a, 0x9cab, 0x0c4d, 0xb4fc, 0x74b4, 0xcc05, 0x5ce3, 0xe452, 0x9ecb, 0x267a,
            0xb69c, 0x0e2d, 0xce65, 0x76d4, 0xe632, 0x5e83, 0x3f97, 0x8726, 0x17c0, 0xaf71, 0x6f39,
            0xd788, 0x476e, 0xffdf,
        ],
        [
            0x0000, 0xe1e5, 0x9aff, 0x7b1a, 0x6ccb, 0x8d2e, 0xf634, 0x17d1, 0xd996, 0x3873, 0x4369,
            0xa28c, 0xb55d, 0x54b8, 0x2fa2, 0xce47, 0xea19, 0x0bfc, 0x70e6, 0x9103, 0x86d2, 0x6737,
            0x1c2d, 0xfdc8, 0x338f, 0xd26a, 0xa970, 0x4895, 0x5f44, 0xbea1, 0xc5bb, 0x245e, 0x8d07,
            0x6ce2, 0x17f8, 0xf61d, 0xe1cc, 0x0029, 0x7b33, 0x9ad6, 0x5491, 0xb574, 0xce6e, 0x2f8b,
            0x385a, 0xd9bf, 0xa2a5, 0x4340, 0x671e, 0x86fb, 0xfde1, 0x1c04, 0x0bd5, 0xea30, 0x912a,
            0x70cf, 0xbe88, 0x5f6d, 0x2477, 0xc592, 0xd243, 0x33a6, 0x48bc, 0xa959, 0x433b, 0xa2de,
            0xd9c4, 0x3821, 0x2ff0, 0xce15, 0xb50f, 0x54ea, 0x9aad, 0x7b48, 0x0052, 0xe1b7, 0xf666,
            0x1783, 0x6c99, 0x8d7c, 0xa922, 0x48c7, 0x33dd, 0xd238, 0xc5e9, 0x240c, 0x5f16, 0xbef3,
            0x70b4, 0x9151, 0xea4b, 0x0bae, 0x1c7f, 0xfd9a, 0x8680, 0x6765, 0xce3c, 0x2fd9, 0x54c3,
            0xb526, 0xa2f7, 0x4312, 0x3808, 0xd9ed, 0x17aa, 0xf64f, 0x8d55, 0x6cb0, 0x7b61, 0x9a84,
            0xe19e, 0x007b, 0x2425, 0xc5c0, 0xbeda, 0x5f3f, 0x48ee, 0xa90b, 0xd211, 0x33f4, 0xfdb3,
            0x1c56, 0x674c, 0x86a9, 0x9178, 0x709d, 0x0b87, 0xea62, 0x8676, 0x6793, 0x1c89, 0xfd6c,
            0xeabd, 0x0b58, 0x7042, 0x91a7, 0x5fe0, 0xbe05, 0xc51f, 0x24fa, 0x332b, 0xd2ce, 0xa9d4,
            0x4831, 0x6c6f, 0x8d8a, 0xf690, 0x1775, 0x00a4, 0xe141, 0x9a5b, 0x7bbe, 0xb5f9, 0x541c,
            0x2f06, 0xcee3, 0xd932, 0x38d7, 0x43cd, 0xa228, 0x0b71, 0xea94, 0x918e, 0x706b, 0x67ba,
            0x865f, 0xfd45, 0x1ca0, 0xd2e7, 0x3302, 0x4818, 0xa9fd, 0xbe2c, 0x5fc9, 0x24d3, 0xc536,
            0xe168, 0x008d, 0x7b97, 0x9a72, 0x8da3, 0x6c46, 0x175c, 0xf6b9, 0x38fe, 0xd91b, 0xa201,
            0x43e4, 0x5435, 0xb5d0, 0xceca, 0x2f2f, 0xc54d, 0x24a8, 0x5fb2, 0xbe57, 0xa986, 0x4863,
            0x3379, 0xd29c, 0x1cdb, 0xfd3e, 0x8624, 0x67c1, 0x7010, 0x91f5, 0xeaef, 0x0b0a, 0x2f54,
            0xceb1, 0xb5ab, 0x544e, 0x439f, 0xa27a, 0xd960, 0x3885, 0xf6c2, 0x1727, 0x6c3d, 0x8dd8,
            0x9a09, 0x7bec, 0x00f6, 0xe113, 0x484a, 0xa9af, 0xd2b5, 0x3350, 0x2481, 0xc564, 0xbe7e,
            0x5f9b, 0x91dc, 0x7039, 0x0b23, 0xeac6, 0xfd17, 0x1cf2, 0x67e8, 0x860d, 0xa253, 0x43b6,
            0x38ac, 0xd949, 0xce98, 0x2f7d, 0x5467, 0xb582, 0x7bc5, 0x9a20, 0xe13a, 0x00df, 0x170e,
            0xf6eb, 0x8df1, 0x6c14,
        ],
        [
            0x0000, 0x55d9, 0xabb2, 0xfe6b, 0x0e51, 0x5b88, 0xa5e3, 0xf03a, 0x1ca2, 0x497b, 0xb710,
            0xe2c9, 0x12f3, 0x472a, 0xb941, 0xec98, 0x3944, 0x6c9d, 0x92f6, 0xc72f, 0x3715, 0x62cc,
            0x9ca7, 0xc97e, 0x25e6, 0x703f, 0x8e54, 0xdb8d, 0x2bb7, 0x7e6e, 0x8005, 0xd5dc, 0x7288,
            0x2751, 0xd93a, 0x8ce3, 0x7cd9, 0x2900, 0xd76b, 0x82b2, 0x6e2a, 0x3bf3, 0xc598, 0x9041,
            0x607b, 0x35a2, 0xcbc9, 0x9e10, 0x4bcc, 0x1e15, 0xe07e, 0xb5a7, 0x459d, 0x1044, 0xee2f,
            0xbbf6, 0x576e, 0x02b7, 0xfcdc, 0xa905, 0x593f, 0x0ce6, 0xf28d, 0xa754, 0xe510, 0xb0c9,
            0x4ea2, 0x1b7b, 0xeb41, 0xbe98, 0x40f3, 0x152a, 0xf9b2, 0xac6b, 0x5200, 0x07d9, 0xf7e3,
            0xa23a, 0x5c51, 0x0988, 0xdc54, 0x898d, 0x77e6, 0x223f, 0xd205, 0x87dc, 0x79b7, 0x2c6e,
            0xc0f6, 0x952f, 0x6b44, 0x3e9d, 0xcea7, 0x9b7e, 0x6515, 0x30cc, 0x9798, 0xc241, 0x3c2a,
            0x69f3, 0x99c9, 0xcc10, 0x327b, 0x67a2, 0x8b3a, 0xdee3, 0x2088, 0x7551, 0x856b, 0xd0b2,
            0x2ed9, 0x7b00, 0xaedc, 0xfb05, 0x056e, 0x50b7, 0xa08d, 0xf554, 0x0b3f, 0x5ee6, 0xb27e,
            0xe7a7, 0x19cc, 0x4c15, 0xbc2f, 0xe9f6, 0x179d, 0x4244, 0x9315, 0xc6cc, 0x38a7, 0x6d7e,
            0x9d44, 0xc89d, 0x36f6, 0x632f, 0x8fb7, 0xda6e, 0x2405, 0x71dc, 0x81e6, 0xd43f, 0x2a54,
            0x7f8d, 0xaa51, 0xff88, 0x01e3, 0x543a, 0xa400, 0xf1d9, 0x0fb2, 0x5a6b, 0xb6f3, 0xe32a,
            0x1d41, 0x4898, 0xb8a2, 0xed7b, 0x1310, 0x46c9, 0xe19d, 0xb444, 0x4a2f, 0x1ff6, 0xefcc,
            0xba15, 0x447e, 0x11a7, 0xfd3f, 0xa8e6, 0x568d, 0x0354, 0xf36e, 0xa6b7, 0x58dc, 0x0d05,
            0xd8d9, 0x8d00, 0x736b, 0x26b2, 0xd688, 0x8351, 0x7d3a, 0x28e3, 0xc47b, 0x91a2, 0x6fc9,
            0x3a10, 0xca2a, 0x9ff3, 0x6198, 0x3441, 0x7605, 0x23dc, 0xddb7, 0x886e, 0x7854, 0x2d8d,
            0xd3e6, 0x863f, 0x6aa7, 0x3f7e, 0xc115, 0x94cc, 0x64f6, 0x312f, 0xcf44, 0x9a9d, 0x4f41,
            0x1a98, 0xe4f3, 0xb12a, 0x4110, 0x14c9, 0xeaa2, 0xbf7b, 0x53e3, 0x063a, 0xf851, 0xad88,
            0x5db2, 0x086b, 0xf600, 0xa3d9, 0x048d, 0x5154, 0xaf3f, 0xfae6, 0x0adc, 0x5f05, 0xa16e,
            0xf4b7, 0x182f, 0x4df6, 0xb39d, 0xe644, 0x167e, 0x43a7, 0xbdcc, 0xe815, 0x3dc9, 0x6810,
            0x967b, 0xc3a2, 0x3398, 0x6641, 0x982a, 0xcdf3, 0x216b, 0x74b2, 0x8ad9, 0xdf00, 0x2f3a,
            0x7ae3, 0x8488, 0xd151,
        ],
        [
            0x0000, 0x7f1f, 0xfe3e, 0x8121, 0xa549, 0xda56, 0x5b77, 0x2468, 0x13a7, 0x6cb8, 0xed99,
            0x9286, 0xb6ee, 0xc9f1, 0x48d0, 0x37cf, 0x274e, 0x5851, 0xd970, 0xa66f, 0x8207, 0xfd18,
            0x7c39, 0x0326, 0x34e9, 0x4bf6, 0xcad7, 0xb5c8, 0x91a0, 0xeebf, 0x6f9e, 0x1081, 0x4e9c,
            0x3183, 0xb0a2, 0xcfbd, 0xebd5, 0x94ca, 0x15eb, 0x6af4, 0x5d3b, 0x2224, 0xa305, 0xdc1a,
            0xf872, 0x876d, 0x064c, 0x7953, 0x69d2, 0x16cd, 0x97ec, 0xe8f3, 0xcc9b, 0xb384, 0x32a5,
            0x4dba, 0x7a75, 0x056a, 0x844b, 0xfb54, 0xdf3c, 0xa023, 0x2102, 0x5e1d, 0x9d38, 0xe227,
            0x6306, 0x1c19, 0x3871, 0x476e, 0xc64f, 0xb950, 0x8e9f, 0xf180, 0x70a1, 0x0fbe, 0x2bd6,
            0x54c9, 0xd5e8, 0xaaf7, 0xba76, 0xc569, 0x4448, 0x3b57, 0x1f3f, 0x6020, 0xe101, 0x9e1e,
            0xa9d1, 0xd6ce, 0x57ef, 0x28f0, 0x0c98, 0x7387, 0xf2a6, 0x8db9, 0xd3a4, 0xacbb, 0x2d9a,
            0x5285, 0x76ed, 0x09f2, 0x88d3, 0xf7cc, 0xc003, 0xbf1c, 0x3e3d, 0x4122, 0x654a, 0x1a55,
            0x9b74, 0xe46b, 0xf4ea, 0x8bf5, 0x0ad4, 0x75cb, 0x51a3, 0x2ebc, 0xaf9d, 0xd082, 0xe74d,
            0x9852, 0x1973, 0x666c, 0x4204, 0x3d1b, 0xbc3a, 0xc325, 0x6345, 0x1c5a, 0x9d7b, 0xe264,
            0xc60c, 0xb913, 0x3832, 0x472d, 0x70e2, 0x0ffd, 0x8edc, 0xf1c3, 0xd5ab, 0xaab4, 0x2b95,
            0x548a, 0x440b, 0x3b14, 0xba35, 0xc52a, 0xe142, 0x9e5d, 0x1f7c, 0x6063, 0x57ac, 0x28b3,
            0xa992, 0xd68d, 0xf2e5, 0x8dfa, 0x0cdb, 0x73c4, 0x2dd9, 0x52c6, 0xd3e7, 0xacf8, 0x8890,
            0xf78f, 0x76ae, 0x09b1, 0x3e7e, 0x4161, 0xc040, 0xbf5f, 0x9b37, 0xe428, 0x6509, 0x1a16,
            0x0a97, 0x7588, 0xf4a9, 0x8bb6, 0xafde, 0xd0c1, 0x51e0, 0x2eff, 0x1930, 0x662f, 0xe70e,
            0x9811, 0xbc79, 0xc366, 0x4247, 0x3d58, 0xfe7d, 0x8162, 0x0043, 0x7f5c, 0x5b34, 0x242b,
            0xa50a, 0xda15, 0xedda, 0x92c5, 0x13e4, 0x6cfb, 0x4893, 0x378c, 0xb6ad, 0xc9b2, 0xd933,
            0xa62c, 0x270d, 0x5812, 0x7c7a, 0x0365, 0x8244, 0xfd5b, 0xca94, 0xb58b, 0x34aa, 0x4bb5,
            0x6fdd, 0x10c2, 0x91e3, 0xeefc, 0xb0e1, 0xcffe, 0x4edf, 0x31c0, 0x15a8, 0x6ab7, 0xeb96,
            0x9489, 0xa346, 0xdc59, 0x5d78, 0x2267, 0x060f, 0x7910, 0xf831, 0x872e, 0x97af, 0xe8b0,
            0x6991, 0x168e, 0x32e6, 0x4df9, 0xccd8, 0xb3c7, 0x8408, 0xfb17, 0x7a36, 0x0529, 0x2141,
            0x5e5e, 0xdf7f, 0xa060,
        ],
        [
            0x0000, 0xc68a, 0xd421, 0x12ab, 0xf177, 0x37fd, 0x2556, 0xe3dc, 0xbbdb, 0x7d51, 0x6ffa,
            0xa970, 0x4aac, 0x8c26, 0x9e8d, 0x5807, 0x2e83, 0xe809, 0xfaa2, 0x3c28, 0xdff4, 0x197e,
            0x0bd5, 0xcd5f, 0x9558, 0x53d2, 0x4179, 0x87f3, 0x642f, 0xa2a5, 0xb00e, 0x7684, 0x5d06,
            0x9b8c, 0x8927, 0x4fad, 0xac71, 0x6afb, 0x7850, 0xbeda, 0xe6dd, 0x2057, 0x32fc, 0xf476,
            0x17aa, 0xd120, 0xc38b, 0x0501, 0x7385, 0xb50f, 0xa7a4, 0x612e, 0x82f2, 0x4478, 0x56d3,
            0x9059, 0xc85e, 0x0ed4, 0x1c7f, 0xdaf5, 0x3929, 0xffa3, 0xed08, 0x2b82, 0xba0c, 0x7c86,
            0x6e2d, 0xa8a7, 0x4b7b, 0x8df1, 0x9f5a, 0x59d0, 0x01d7, 0xc75d, 0xd5f6, 0x137c, 0xf0a0,
            0x362a, 0x2481, 0xe20b, 0x948f, 0x5205, 0x40ae, 0x8624, 0x65f8, 0xa372, 0xb1d9, 0x7753,
            0x2f54, 0xe9de, 0xfb75, 0x3dff, 0xde23, 0x18a9, 0x0a02, 0xcc88, 0xe70a, 0x2180, 0x332b,
            0xf5a1, 0x167d, 0xd0f7, 0xc25c, 0x04d6, 0x5cd1, 0x9a5b, 0x88f0, 0x4e7a, 0xada6, 0x6b2c,
            0x7987, 0xbf0d, 0xc989, 0x0f03, 0x1da8, 0xdb22, 0x38fe, 0xfe74, 0xecdf, 0x2a55, 0x7252,
            0xb4d8, 0xa673, 0x60f9, 0x8325, 0x45af, 0x5704, 0x918e, 0x2d2d, 0xeba7, 0xf90c, 0x3f86,
            0xdc5a, 0x1ad0, 0x087b, 0xcef1, 0x96f6, 0x507c, 0x42d7, 0x845d, 0x6781, 0xa10b, 0xb3a0,
            0x752a, 0x03ae, 0xc524, 0xd78f, 0x1105, 0xf2d9, 0x3453, 0x26f8, 0xe072, 0xb875, 0x7eff,
            0x6c54, 0xaade, 0x4902, 0x8f88, 0x9d23, 0x5ba9, 0x702b, 0xb6a1, 0xa40a, 0x6280, 0x815c,
            0x47d6, 0x557d, 0x93f7, 0xcbf0, 0x0d7a, 0x1fd1, 0xd95b, 0x3a87, 0xfc0d, 0xeea6, 0x282c,
            0x5ea8, 0x9822, 0x8a89, 0x4c03, 0xafdf, 0x6955, 0x7bfe, 0xbd74, 0xe573, 0x23f9, 0x3152,
            0xf7d8, 0x1404, 0xd28e, 0xc025, 0x06af, 0x9721, 0x51ab, 0x4300, 0x858a, 0x6656, 0xa0dc,
            0xb277, 0x74fd, 0x2cfa, 0xea70, 0xf8db, 0x3e51, 0xdd8d, 0x1b07, 0x09ac, 0xcf26, 0xb9a2,
            0x7f28, 0x6d83, 0xab09, 0x48d5, 0x8e5f, 0x9cf4, 0x5a7e, 0x0279, 0xc4f3, 0xd658, 0x10d2,
            0xf30e, 0x3584, 0x272f, 0xe1a5, 0xca27, 0x0cad, 0x1e06, 0xd88c, 0x3b50, 0xfdda, 0xef71,
            0x29fb, 0x71fc, 0xb776, 0xa5dd, 0x6357, 0x808b, 0x4601, 0x54aa, 0x9220, 0xe4a4, 0x222e,
            0x3085, 0xf60f, 0x15d3, 0xd359, 0xc1f2, 0x0778, 0x5f7f, 0x99f5, 0x8b5e, 0x4dd4, 0xae08,
            0x6882, 0x7a29, 0xbca3,
        ],
        [
            0x0000, 0x5a5a, 0xb4b4, 0xeeee, 0x305d, 0x6a07, 0x84e9, 0xdeb3, 0x60ba, 0x3ae0, 0xd40e,
            0x8e54, 0x50e7, 0x0abd, 0xe453, 0xbe09, 0xc174, 0x9b2e, 0x75c0, 0x2f9a, 0xf129, 0xab73,
            0x459d, 0x1fc7, 0xa1ce, 0xfb94, 0x157a, 0x4f20, 0x9193, 0xcbc9, 0x2527, 0x7f7d, 0xdbdd,
            0x8187, 0x6f69, 0x3533, 0xeb80, 0xb1da, 0x5f34, 0x056e, 0xbb67, 0xe13d, 0x0fd3, 0x5589,
            0x8b3a, 0xd160, 0x3f8e, 0x65d4, 0x1aa9, 0x40f3, 0xae1d, 0xf447, 0x2af4, 0x70ae, 0x9e40,
            0xc41a, 0x7a13, 0x2049, 0xcea7, 0x94fd, 0x4a4e, 0x1014, 0xfefa, 0xa4a0, 0xee8f, 0xb4d5,
            0x5a3b, 0x0061, 0xded2, 0x8488, 0x6a66, 0x303c, 0x8e35, 0xd46f, 0x3a81, 0x60db, 0xbe68,
            0xe432, 0x0adc, 0x5086, 0x2ffb, 0x75a1, 0x9b4f, 0xc115, 0x1fa6, 0x45fc, 0xab12, 0xf148,
            0x4f41, 0x151b, 0xfbf5, 0xa1af, 0x7f1c, 0x2546, 0xcba8, 0x91f2, 0x3552, 0x6f08, 0x81e6,
            0xdbbc, 0x050f, 0x5f55, 0xb1bb, 0xebe1, 0x55e8, 0x0fb2, 0xe15c, 0xbb06, 0x65b5, 0x3fef,
            0xd101, 0x8b5b, 0xf426, 0xae7c, 0x4092, 0x1ac8, 0xc47b, 0x9e21, 0x70cf, 0x2a95, 0x949c,
            0xcec6, 0x2028, 0x7a72, 0xa4c1, 0xfe9b, 0x1075, 0x4a2f, 0x842b, 0xde71, 0x309f, 0x6ac5,
            0xb476, 0xee2c, 0x00c2, 0x5a98, 0xe491, 0xbecb, 0x5025, 0x0a7f, 0xd4cc, 0x8e96, 0x6078,
            0x3a22, 0x455f, 0x1f05, 0xf1eb, 0xabb1, 0x7502, 0x2f58, 0xc1b6, 0x9bec, 0x25e5, 0x7fbf,
            0x9151, 0xcb0b, 0x15b8, 0x4fe2, 0xa10c, 0xfb56, 0x5ff6, 0x05ac, 0xeb42, 0xb118, 0x6fab,
            0x35f1, 0xdb1f, 0x8145, 0x3f4c, 0x6516, 0x8bf8, 0xd1a2, 0x0f11, 0x554b, 0xbba5, 0xe1ff,
            0x9e82, 0xc4d8, 0x2a36, 0x706c, 0xaedf, 0xf485, 0x1a6b, 0x4031, 0xfe38, 0xa462, 0x4a8c,
            0x10d6, 0xce65, 0x943f, 0x7ad1, 0x208b, 0x6aa4, 0x30fe, 0xde10, 0x844a, 0x5af9, 0x00a3,
            0xee4d, 0xb417, 0x0a1e, 0x5044, 0xbeaa, 0xe4f0, 0x3a43, 0x6019, 0x8ef7, 0xd4ad, 0xabd0,
            0xf18a, 0x1f64, 0x453e, 0x9b8d, 0xc1d7, 0x2f39, 0x7563, 0xcb6a, 0x9130, 0x7fde, 0x2584,
            0xfb37, 0xa16d, 0x4f83, 0x15d9, 0xb179, 0xeb23, 0x05cd, 0x5f97, 0x8124, 0xdb7e, 0x3590,
            0x6fca, 0xd1c3, 0x8b99, 0x6577, 0x3f2d, 0xe19e, 0xbbc4, 0x552a, 0x0f70, 0x700d, 0x2a57,
            0xc4b9, 0x9ee3, 0x4050, 0x1a0a, 0xf4e4, 0xaebe, 0x10b7, 0x4aed, 0xa403, 0xfe59, 0x20ea,
            0x7ab0, 0x945e, 0xce04,
        ],
    ];

    pub static CRC16_MAXIM_DOW_TABLE: [[u16; 256]; 16] = [
        [
            0x0000, 0xc0c1, 0xc181, 0x0140, 0xc301, 0x03c0, 0x0280, 0xc241, 0xc601, 0x06c0, 0x0780,
            0xc741, 0x0500, 0xc5c1, 0xc481, 0x0440, 0xcc01, 0x0cc0, 0x0d80, 0xcd41, 0x0f00, 0xcfc1,
            0xce81, 0x0e40, 0x0a00, 0xcac1, 0xcb81, 0x0b40, 0xc901, 0x09c0, 0x0880, 0xc841, 0xd801,
            0x18c0, 0x1980, 0xd941, 0x1b00, 0xdbc1, 0xda81, 0x1a40, 0x1e00, 0xdec1, 0xdf81, 0x1f40,
            0xdd01, 0x1dc0, 0x1c80, 0xdc41, 0x1400, 0xd4c1, 0xd581, 0x1540, 0xd701, 0x17c0, 0x1680,
            0xd641, 0xd201, 0x12c0, 0x1380, 0xd341, 0x1100, 0xd1c1, 0xd081, 0x1040, 0xf001, 0x30c0,
            0x3180, 0xf141, 0x3300, 0xf3c1, 0xf281, 0x3240, 0x3600, 0xf6c1, 0xf781, 0x3740, 0xf501,
            0x35c0, 0x3480, 0xf441, 0x3c00, 0xfcc1, 0xfd81, 0x3d40, 0xff01, 0x3fc0, 0x3e80, 0xfe41,
            0xfa01, 0x3ac0, 0x3b80, 0xfb41, 0x3900, 0xf9c1, 0xf881, 0x3840, 0x2800, 0xe8c1, 0xe981,
            0x2940, 0xeb01, 0x2bc0, 0x2a80, 0xea41, 0xee01, 0x2ec0, 0x2f80, 0xef41, 0x2d00, 0xedc1,
            0xec81, 0x2c40, 0xe401, 0x24c0, 0x2580, 0xe541, 0x2700, 0xe7c1, 0xe681, 0x2640, 0x2200,
            0xe2c1, 0xe381, 0x2340, 0xe101, 0x21c0, 0x2080, 0xe041, 0xa001, 0x60c0, 0x6180, 0xa141,
            0x6300, 0xa3c1, 0xa281, 0x6240, 0x6600, 0xa6c1, 0xa781, 0x6740, 0xa501, 0x65c0, 0x6480,
            0xa441, 0x6c00, 0xacc1, 0xad81, 0x6d40, 0xaf01, 0x6fc0, 0x6e80, 0xae41, 0xaa01, 0x6ac0,
            0x6b80, 0xab41, 0x6900, 0xa9c1, 0xa881, 0x6840, 0x7800, 0xb8c1, 0xb981, 0x7940, 0xbb01,
            0x7bc0, 0x7a80, 0xba41, 0xbe01, 0x7ec0, 0x7f80, 0xbf41, 0x7d00, 0xbdc1, 0xbc81, 0x7c40,
            0xb401, 0x74c0, 0x7580, 0xb541, 0x7700, 0xb7c1, 0xb681, 0x7640, 0x7200, 0xb2c1, 0xb381,
            0x7340, 0xb101, 0x71c0, 0x7080, 0xb041, 0x5000, 0x90c1, 0x9181, 0x5140, 0x9301, 0x53c0,
            0x5280, 0x9241, 0x9601, 0x56c0, 0x5780, 0x9741, 0x5500, 0x95c1, 0x9481, 0x5440, 0x9c01,
            0x5cc0, 0x5d80, 0x9d41, 0x5f00, 0x9fc1, 0x9e81, 0x5e40, 0x5a00, 0x9ac1, 0x9b81, 0x5b40,
            0x9901, 0x59c0, 0x5880, 0x9841, 0x8801, 0x48c0, 0x4980, 0x8941, 0x4b00, 0x8bc1, 0x8a81,
            0x4a40, 0x4e00, 0x8ec1, 0x8f81, 0x4f40, 0x8d01, 0x4dc0, 0x4c80, 0x8c41, 0x4400, 0x84c1,
            0x8581, 0x4540, 0x8701, 0x47c0, 0x4680, 0x8641, 0x8201, 0x42c0, 0x4380, 0x8341, 0x4100,
            0x81c1, 0x8081, 0x4040,
        ],
        [
            0x0000, 0x9001, 0x6001, 0xf000, 0xc002, 0x5003, 0xa003, 0x3002, 0xc007, 0x5006, 0xa006,
            0x3007, 0x0005, 0x9004, 0x6004, 0xf005, 0xc00d, 0x500c, 0xa00c, 0x300d, 0x000f, 0x900e,
            0x600e, 0xf00f, 0x000a, 0x900b, 0x600b, 0xf00a, 0xc008, 0x5009, 0xa009, 0x3008, 0xc019,
            0x5018, 0xa018, 0x3019, 0x001b, 0x901a, 0x601a, 0xf01b, 0x001e, 0x901f, 0x601f, 0xf01e,
            0xc01c, 0x501d, 0xa01d, 0x301c, 0x0014, 0x9015, 0x6015, 0xf014, 0xc016, 0x5017, 0xa017,
            0x3016, 0xc013, 0x5012, 0xa012, 0x3013, 0x0011, 0x9010, 0x6010, 0xf011, 0xc031, 0x5030,
            0xa030, 0x3031, 0x0033, 0x9032, 0x6032, 0xf033, 0x0036, 0x9037, 0x6037, 0xf036, 0xc034,
            0x5035, 0xa035, 0x3034, 0x003c, 0x903d, 0x603d, 0xf03c, 0xc03e, 0x503f, 0xa03f, 0x303e,
            0xc03b, 0x503a, 0xa03a, 0x303b, 0x0039, 0x9038, 0x6038, 0xf039, 0x0028, 0x9029, 0x6029,
            0xf028, 0xc02a, 0x502b, 0xa02b, 0x302a, 0xc02f, 0x502e, 0xa02e, 0x302f, 0x002d, 0x902c,
            0x602c, 0xf02d, 0xc025, 0x5024, 0xa024, 0x3025, 0x0027, 0x9026, 0x6026, 0xf027, 0x0022,
            0x9023, 0x6023, 0xf022, 0xc020, 0x5021, 0xa021, 0x3020, 0xc061, 0x5060, 0xa060, 0x3061,
            0x0063, 0x9062, 0x6062, 0xf063, 0x0066, 0x9067, 0x6067, 0xf066, 0xc064, 0x5065, 0xa065,
            0x3064, 0x006c, 0x906d, 0x606d, 0xf06c, 0xc06e, 0x506f, 0xa06f, 0x306e, 0xc06b, 0x506a,
            0xa06a, 0x306b, 0x0069, 0x9068, 0x6068, 0xf069, 0x0078, 0x9079, 0x6079, 0xf078, 0xc07a,
            0x507b, 0xa07b, 0x307a, 0xc07f, 0x507e, 0xa07e, 0x307f, 0x007d, 0x907c, 0x607c, 0xf07d,
            0xc075, 0x5074, 0xa074, 0x3075, 0x0077, 0x9076, 0x6076, 0xf077, 0x0072, 0x9073, 0x6073,
            0xf072, 0xc070, 0x5071, 0xa071, 0x3070, 0x0050, 0x9051, 0x6051, 0xf050, 0xc052, 0x5053,
            0xa053, 0x3052, 0xc057, 0x5056, 0xa056, 0x3057, 0x0055, 0x9054, 0x6054, 0xf055, 0xc05d,
            0x505c, 0xa05c, 0x305d, 0x005f, 0x905e, 0x605e, 0xf05f, 0x005a, 0x905b, 0x605b, 0xf05a,
            0xc058, 0x5059, 0xa059, 0x3058, 0xc049, 0x5048, 0xa048, 0x3049, 0x004b, 0x904a, 0x604a,
            0xf04b, 0x004e, 0x904f, 0x604f, 0xf04e, 0xc04c, 0x504d, 0xa04d, 0x304c, 0x0044, 0x9045,
            0x6045, 0xf044, 0xc046, 0x5047, 0xa047, 0x3046, 0xc043, 0x5042, 0xa042, 0x3043, 0x0041,
            0x9040, 0x6040, 0xf041,
        ],
        [
            0x0000, 0xc051, 0xc0a1, 0x00f0, 0xc141, 0x0110, 0x01e0, 0xc1b1, 0xc281, 0x02d0, 0x0220,
            0xc271, 0x03c0, 0xc391, 0xc361, 0x0330, 0xc501, 0x0550, 0x05a0, 0xc5f1, 0x0440, 0xc411,
            0xc4e1, 0x04b0, 0x0780, 0xc7d1, 0xc721, 0x0770, 0xc6c1, 0x0690, 0x0660, 0xc631, 0xca01,
            0x0a50, 0x0aa0, 0xcaf1, 0x0b40, 0xcb11, 0xcbe1, 0x0bb0, 0x0880, 0xc8d1, 0xc821, 0x0870,
            0xc9c1, 0x0990, 0x0960, 0xc931, 0x0f00, 0xcf51, 0xcfa1, 0x0ff0, 0xce41, 0x0e10, 0x0ee0,
            0xceb1, 0xcd81, 0x0dd0, 0x0d20, 0xcd71, 0x0cc0, 0xcc91, 0xcc61, 0x0c30, 0xd401, 0x1450,
            0x14a0, 0xd4f1, 0x1540, 0xd511, 0xd5e1, 0x15b0, 0x1680, 0xd6d1, 0xd621, 0x1670, 0xd7c1,
            0x1790, 0x1760, 0xd731, 0x1100, 0xd151, 0xd1a1, 0x11f0, 0xd041, 0x1010, 0x10e0, 0xd0b1,
            0xd381, 0x13d0, 0x1320, 0xd371, 0x12c0, 0xd291, 0xd261, 0x1230, 0x1e00, 0xde51, 0xdea1,
            0x1ef0, 0xdf41, 0x1f10, 0x1fe0, 0xdfb1, 0xdc81, 0x1cd0, 0x1c20, 0xdc71, 0x1dc0, 0xdd91,
            0xdd61, 0x1d30, 0xdb01, 0x1b50, 0x1ba0, 0xdbf1, 0x1a40, 0xda11, 0xdae1, 0x1ab0, 0x1980,
            0xd9d1, 0xd921, 0x1970, 0xd8c1, 0x1890, 0x1860, 0xd831, 0xe801, 0x2850, 0x28a0, 0xe8f1,
            0x2940, 0xe911, 0xe9e1, 0x29b0, 0x2a80, 0xead1, 0xea21, 0x2a70, 0xebc1, 0x2b90, 0x2b60,
            0xeb31, 0x2d00, 0xed51, 0xeda1, 0x2df0, 0xec41, 0x2c10, 0x2ce0, 0xecb1, 0xef81, 0x2fd0,
            0x2f20, 0xef71, 0x2ec0, 0xee91, 0xee61, 0x2e30, 0x2200, 0xe251, 0xe2a1, 0x22f0, 0xe341,
            0x2310, 0x23e0, 0xe3b1, 0xe081, 0x20d0, 0x2020, 0xe071, 0x21c0, 0xe191, 0xe161, 0x2130,
            0xe701, 0x2750, 0x27a0, 0xe7f1, 0x2640, 0xe611, 0xe6e1, 0x26b0, 0x2580, 0xe5d1, 0xe521,
            0x2570, 0xe4c1, 0x2490, 0x2460, 0xe431, 0x3c00, 0xfc51, 0xfca1, 0x3cf0, 0xfd41, 0x3d10,
            0x3de0, 0xfdb1, 0xfe81, 0x3ed0, 0x3e20, 0xfe71, 0x3fc0, 0xff91, 0xff61, 0x3f30, 0xf901,
            0x3950, 0x39a0, 0xf9f1, 0x3840, 0xf811, 0xf8e1, 0x38b0, 0x3b80, 0xfbd1, 0xfb21, 0x3b70,
            0xfac1, 0x3a90, 0x3a60, 0xfa31, 0xf601, 0x3650, 0x36a0, 0xf6f1, 0x3740, 0xf711, 0xf7e1,
            0x37b0, 0x3480, 0xf4d1, 0xf421, 0x3470, 0xf5c1, 0x3590, 0x3560, 0xf531, 0x3300, 0xf351,
            0xf3a1, 0x33f0, 0xf241, 0x3210, 0x32e0, 0xf2b1, 0xf181, 0x31d0, 0x3120, 0xf171, 0x30c0,
            0xf091, 0xf061, 0x3030,
        ],
        [
            0x0000, 0xfc01, 0xb801, 0x4400, 0x3001, 0xcc00, 0x8800, 0x7401, 0x6002, 0x9c03, 0xd803,
            0x2402, 0x5003, 0xac02, 0xe802, 0x1403, 0xc004, 0x3c05, 0x7805, 0x8404, 0xf005, 0x0c04,
            0x4804, 0xb405, 0xa006, 0x5c07, 0x1807, 0xe406, 0x9007, 0x6c06, 0x2806, 0xd407, 0xc00b,
            0x3c0a, 0x780a, 0x840b, 0xf00a, 0x0c0b, 0x480b, 0xb40a, 0xa009, 0x5c08, 0x1808, 0xe409,
            0x9008, 0x6c09, 0x2809, 0xd408, 0x000f, 0xfc0e, 0xb80e, 0x440f, 0x300e, 0xcc0f, 0x880f,
            0x740e, 0x600d, 0x9c0c, 0xd80c, 0x240d, 0x500c, 0xac0d, 0xe80d, 0x140c, 0xc015, 0x3c14,
            0x7814, 0x8415, 0xf014, 0x0c15, 0x4815, 0xb414, 0xa017, 0x5c16, 0x1816, 0xe417, 0x9016,
            0x6c17, 0x2817, 0xd416, 0x0011, 0xfc10, 0xb810, 0x4411, 0x3010, 0xcc11, 0x8811, 0x7410,
            0x6013, 0x9c12, 0xd812, 0x2413, 0x5012, 0xac13, 0xe813, 0x1412, 0x001e, 0xfc1f, 0xb81f,
            0x441e, 0x301f, 0xcc1e, 0x881e, 0x741f, 0x601c, 0x9c1d, 0xd81d, 0x241c, 0x501d, 0xac1c,
            0xe81c, 0x141d, 0xc01a, 0x3c1b, 0x781b, 0x841a, 0xf01b, 0x0c1a, 0x481a, 0xb41b, 0xa018,
            0x5c19, 0x1819, 0xe418, 0x9019, 0x6c18, 0x2818, 0xd419, 0xc029, 0x3c28, 0x7828, 0x8429,
            0xf028, 0x0c29, 0x4829, 0xb428, 0xa02b, 0x5c2a, 0x182a, 0xe42b, 0x902a, 0x6c2b, 0x282b,
            0xd42a, 0x002d, 0xfc2c, 0xb82c, 0x442d, 0x302c, 0xcc2d, 0x882d, 0x742c, 0x602f, 0x9c2e,
            0xd82e, 0x242f, 0x502e, 0xac2f, 0xe82f, 0x142e, 0x0022, 0xfc23, 0xb823, 0x4422, 0x3023,
            0xcc22, 0x8822, 0x7423, 0x6020, 0x9c21, 0xd821, 0x2420, 0x5021, 0xac20, 0xe820, 0x1421,
            0xc026, 0x3c27, 0x7827, 0x8426, 0xf027, 0x0c26, 0x4826, 0xb427, 0xa024, 0x5c25, 0x1825,
            0xe424, 0x9025, 0x6c24, 0x2824, 0xd425, 0x003c, 0xfc3d, 0xb83d, 0x443c, 0x303d, 0xcc3c,
            0x883c, 0x743d, 0x603e, 0x9c3f, 0xd83f, 0x243e, 0x503f, 0xac3e, 0xe83e, 0x143f, 0xc038,
            0x3c39, 0x7839, 0x8438, 0xf039, 0x0c38, 0x4838, 0xb439, 0xa03a, 0x5c3b, 0x183b, 0xe43a,
            0x903b, 0x6c3a, 0x283a, 0xd43b, 0xc037, 0x3c36, 0x7836, 0x8437, 0xf036, 0x0c37, 0x4837,
            0xb436, 0xa035, 0x5c34, 0x1834, 0xe435, 0x9034, 0x6c35, 0x2835, 0xd434, 0x0033, 0xfc32,
            0xb832, 0x4433, 0x3032, 0xcc33, 0x8833, 0x7432, 0x6031, 0x9c30, 0xd830, 0x2431, 0x5030,
            0xac31, 0xe831, 0x1430,
        ],
        [
            0x0000, 0xc03d, 0xc079, 0x0044, 0xc0f1, 0x00cc, 0x0088, 0xc0b5, 0xc1e1, 0x01dc, 0x0198,
            0xc1a5, 0x0110, 0xc12d, 0xc169, 0x0154, 0xc3c1, 0x03fc, 0x03b8, 0xc385, 0x0330, 0xc30d,
            0xc349, 0x0374, 0x0220, 0xc21d, 0xc259, 0x0264, 0xc2d1, 0x02ec, 0x02a8, 0xc295, 0xc781,
            0x07bc, 0x07f8, 0xc7c5, 0x0770, 0xc74d, 0xc709, 0x0734, 0x0660, 0xc65d, 0xc619, 0x0624,
            0xc691, 0x06ac, 0x06e8, 0xc6d5, 0x0440, 0xc47d, 0xc439, 0x0404, 0xc4b1, 0x048c, 0x04c8,
            0xc4f5, 0xc5a1, 0x059c, 0x05d8, 0xc5e5, 0x0550, 0xc56d, 0xc529, 0x0514, 0xcf01, 0x0f3c,
            0x0f78, 0xcf45, 0x0ff0, 0xcfcd, 0xcf89, 0x0fb4, 0x0ee0, 0xcedd, 0xce99, 0x0ea4, 0xce11,
            0x0e2c, 0x0e68, 0xce55, 0x0cc0, 0xccfd, 0xccb9, 0x0c84, 0xcc31, 0x0c0c, 0x0c48, 0xcc75,
            0xcd21, 0x0d1c, 0x0d58, 0xcd65, 0x0dd0, 0xcded, 0xcda9, 0x0d94, 0x0880, 0xc8bd, 0xc8f9,
            0x08c4, 0xc871, 0x084c, 0x0808, 0xc835, 0xc961, 0x095c, 0x0918, 0xc925, 0x0990, 0xc9ad,
            0xc9e9, 0x09d4, 0xcb41, 0x0b7c, 0x0b38, 0xcb05, 0x0bb0, 0xcb8d, 0xcbc9, 0x0bf4, 0x0aa0,
            0xca9d, 0xcad9, 0x0ae4, 0xca51, 0x0a6c, 0x0a28, 0xca15, 0xde01, 0x1e3c, 0x1e78, 0xde45,
            0x1ef0, 0xdecd, 0xde89, 0x1eb4, 0x1fe0, 0xdfdd, 0xdf99, 0x1fa4, 0xdf11, 0x1f2c, 0x1f68,
            0xdf55, 0x1dc0, 0xddfd, 0xddb9, 0x1d84, 0xdd31, 0x1d0c, 0x1d48, 0xdd75, 0xdc21, 0x1c1c,
            0x1c58, 0xdc65, 0x1cd0, 0xdced, 0xdca9, 0x1c94, 0x1980, 0xd9bd, 0xd9f9, 0x19c4, 0xd971,
            0x194c, 0x1908, 0xd935, 0xd861, 0x185c, 0x1818, 0xd825, 0x1890, 0xd8ad, 0xd8e9, 0x18d4,
            0xda41, 0x1a7c, 0x1a38, 0xda05, 0x1ab0, 0xda8d, 0xdac9, 0x1af4, 0x1ba0, 0xdb9d, 0xdbd9,
            0x1be4, 0xdb51, 0x1b6c, 0x1b28, 0xdb15, 0x1100, 0xd13d, 0xd179, 0x1144, 0xd1f1, 0x11cc,
            0x1188, 0xd1b5, 0xd0e1, 0x10dc, 0x1098, 0xd0a5, 0x1010, 0xd02d, 0xd069, 0x1054, 0xd2c1,
            0x12fc, 0x12b8, 0xd285, 0x1230, 0xd20d, 0xd249, 0x1274, 0x1320, 0xd31d, 0xd359, 0x1364,
            0xd3d1, 0x13ec, 0x13a8, 0xd395, 0xd681, 0x16bc, 0x16f8, 0xd6c5, 0x1670, 0xd64d, 0xd609,
            0x1634, 0x1760, 0xd75d, 0xd719, 0x1724, 0xd791, 0x17ac, 0x17e8, 0xd7d5, 0x1540, 0xd57d,
            0xd539, 0x1504, 0xd5b1, 0x158c, 0x15c8, 0xd5f5, 0xd4a1, 0x149c, 0x14d8, 0xd4e5, 0x1450,
            0xd46d, 0xd429, 0x1414,
        ],
        [
            0x0000, 0xd101, 0xe201, 0x3300, 0x8401, 0x5500, 0x6600, 0xb701, 0x4801, 0x9900, 0xaa00,
            0x7b01, 0xcc00, 0x1d01, 0x2e01, 0xff00, 0x9002, 0x4103, 0x7203, 0xa302, 0x1403, 0xc502,
            0xf602, 0x2703, 0xd803, 0x0902, 0x3a02, 0xeb03, 0x5c02, 0x8d03, 0xbe03, 0x6f02, 0x6007,
            0xb106, 0x8206, 0x5307, 0xe406, 0x3507, 0x0607, 0xd706, 0x2806, 0xf907, 0xca07, 0x1b06,
            0xac07, 0x7d06, 0x4e06, 0x9f07, 0xf005, 0x2104, 0x1204, 0xc305, 0x7404, 0xa505, 0x9605,
            0x4704, 0xb804, 0x6905, 0x5a05, 0x8b04, 0x3c05, 0xed04, 0xde04, 0x0f05, 0xc00e, 0x110f,
            0x220f, 0xf30e, 0x440f, 0x950e, 0xa60e, 0x770f, 0x880f, 0x590e, 0x6a0e, 0xbb0f, 0x0c0e,
            0xdd0f, 0xee0f, 0x3f0e, 0x500c, 0x810d, 0xb20d, 0x630c, 0xd40d, 0x050c, 0x360c, 0xe70d,
            0x180d, 0xc90c, 0xfa0c, 0x2b0d, 0x9c0c, 0x4d0d, 0x7e0d, 0xaf0c, 0xa009, 0x7108, 0x4208,
            0x9309, 0x2408, 0xf509, 0xc609, 0x1708, 0xe808, 0x3909, 0x0a09, 0xdb08, 0x6c09, 0xbd08,
            0x8e08, 0x5f09, 0x300b, 0xe10a, 0xd20a, 0x030b, 0xb40a, 0x650b, 0x560b, 0x870a, 0x780a,
            0xa90b, 0x9a0b, 0x4b0a, 0xfc0b, 0x2d0a, 0x1e0a, 0xcf0b, 0xc01f, 0x111e, 0x221e, 0xf31f,
            0x441e, 0x951f, 0xa61f, 0x771e, 0x881e, 0x591f, 0x6a1f, 0xbb1e, 0x0c1f, 0xdd1e, 0xee1e,
            0x3f1f, 0x501d, 0x811c, 0xb21c, 0x631d, 0xd41c, 0x051d, 0x361d, 0xe71c, 0x181c, 0xc91d,
            0xfa1d, 0x2b1c, 0x9c1d, 0x4d1c, 0x7e1c, 0xaf1d, 0xa018, 0x7119, 0x4219, 0x9318, 0x2419,
            0xf518, 0xc618, 0x1719, 0xe819, 0x3918, 0x0a18, 0xdb19, 0x6c18, 0xbd19, 0x8e19, 0x5f18,
            0x301a, 0xe11b, 0xd21b, 0x031a, 0xb41b, 0x651a, 0x561a, 0x871b, 0x781b, 0xa91a, 0x9a1a,
            0x4b1b, 0xfc1a, 0x2d1b, 0x1e1b, 0xcf1a, 0x0011, 0xd110, 0xe210, 0x3311, 0x8410, 0x5511,
            0x6611, 0xb710, 0x4810, 0x9911, 0xaa11, 0x7b10, 0xcc11, 0x1d10, 0x2e10, 0xff11, 0x9013,
            0x4112, 0x7212, 0xa313, 0x1412, 0xc513, 0xf613, 0x2712, 0xd812, 0x0913, 0x3a13, 0xeb12,
            0x5c13, 0x8d12, 0xbe12, 0x6f13, 0x6016, 0xb117, 0x8217, 0x5316, 0xe417, 0x3516, 0x0616,
            0xd717, 0x2817, 0xf916, 0xca16, 0x1b17, 0xac16, 0x7d17, 0x4e17, 0x9f16, 0xf014, 0x2115,
            0x1215, 0xc314, 0x7415, 0xa514, 0x9614, 0x4715, 0xb815, 0x6914, 0x5a14, 0x8b15, 0x3c14,
            0xed15, 0xde15, 0x0f14,
        ],
        [
            0x0000, 0xc010, 0xc023, 0x0033, 0xc045, 0x0055, 0x0066, 0xc076, 0xc089, 0x0099, 0x00aa,
            0xc0ba, 0x00cc, 0xc0dc, 0xc0ef, 0x00ff, 0xc111, 0x0101, 0x0132, 0xc122, 0x0154, 0xc144,
            0xc177, 0x0167, 0x0198, 0xc188, 0xc1bb, 0x01ab, 0xc1dd, 0x01cd, 0x01fe, 0xc1ee, 0xc221,
            0x0231, 0x0202, 0xc212, 0x0264, 0xc274, 0xc247, 0x0257, 0x02a8, 0xc2b8, 0xc28b, 0x029b,
            0xc2ed, 0x02fd, 0x02ce, 0xc2de, 0x0330, 0xc320, 0xc313, 0x0303, 0xc375, 0x0365, 0x0356,
            0xc346, 0xc3b9, 0x03a9, 0x039a, 0xc38a, 0x03fc, 0xc3ec, 0xc3df, 0x03cf, 0xc441, 0x0451,
            0x0462, 0xc472, 0x0404, 0xc414, 0xc427, 0x0437, 0x04c8, 0xc4d8, 0xc4eb, 0x04fb, 0xc48d,
            0x049d, 0x04ae, 0xc4be, 0x0550, 0xc540, 0xc573, 0x0563, 0xc515, 0x0505, 0x0536, 0xc526,
            0xc5d9, 0x05c9, 0x05fa, 0xc5ea, 0x059c, 0xc58c, 0xc5bf, 0x05af, 0x0660, 0xc670, 0xc643,
            0x0653, 0xc625, 0x0635, 0x0606, 0xc616, 0xc6e9, 0x06f9, 0x06ca, 0xc6da, 0x06ac, 0xc6bc,
            0xc68f, 0x069f, 0xc771, 0x0761, 0x0752, 0xc742, 0x0734, 0xc724, 0xc717, 0x0707, 0x07f8,
            0xc7e8, 0xc7db, 0x07cb, 0xc7bd, 0x07ad, 0x079e, 0xc78e, 0xc881, 0x0891, 0x08a2, 0xc8b2,
            0x08c4, 0xc8d4, 0xc8e7, 0x08f7, 0x0808, 0xc818, 0xc82b, 0x083b, 0xc84d, 0x085d, 0x086e,
            0xc87e, 0x0990, 0xc980, 0xc9b3, 0x09a3, 0xc9d5, 0x09c5, 0x09f6, 0xc9e6, 0xc919, 0x0909,
            0x093a, 0xc92a, 0x095c, 0xc94c, 0xc97f, 0x096f, 0x0aa0, 0xcab0, 0xca83, 0x0a93, 0xcae5,
            0x0af5, 0x0ac6, 0xcad6, 0xca29, 0x0a39, 0x0a0a, 0xca1a, 0x0a6c, 0xca7c, 0xca4f, 0x0a5f,
            0xcbb1, 0x0ba1, 0x0b92, 0xcb82, 0x0bf4, 0xcbe4, 0xcbd7, 0x0bc7, 0x0b38, 0xcb28, 0xcb1b,
            0x0b0b, 0xcb7d, 0x0b6d, 0x0b5e, 0xcb4e, 0x0cc0, 0xccd0, 0xcce3, 0x0cf3, 0xcc85, 0x0c95,
            0x0ca6, 0xccb6, 0xcc49, 0x0c59, 0x0c6a, 0xcc7a, 0x0c0c, 0xcc1c, 0xcc2f, 0x0c3f, 0xcdd1,
            0x0dc1, 0x0df2, 0xcde2, 0x0d94, 0xcd84, 0xcdb7, 0x0da7, 0x0d58, 0xcd48, 0xcd7b, 0x0d6b,
            0xcd1d, 0x0d0d, 0x0d3e, 0xcd2e, 0xcee1, 0x0ef1, 0x0ec2, 0xced2, 0x0ea4, 0xceb4, 0xce87,
            0x0e97, 0x0e68, 0xce78, 0xce4b, 0x0e5b, 0xce2d, 0x0e3d, 0x0e0e, 0xce1e, 0x0ff0, 0xcfe0,
            0xcfd3, 0x0fc3, 0xcfb5, 0x0fa5, 0x0f96, 0xcf86, 0xcf79, 0x0f69, 0x0f5a, 0xcf4a, 0x0f3c,
            0xcf2c, 0xcf1f, 0x0f0f,
        ],
        [
            0x0000, 0xccc1, 0xd981, 0x1540, 0xf301, 0x3fc0, 0x2a80, 0xe641, 0xa601, 0x6ac0, 0x7f80,
            0xb341, 0x5500, 0x99c1, 0x8c81, 0x4040, 0x0c01, 0xc0c0, 0xd580, 0x1941, 0xff00, 0x33c1,
            0x2681, 0xea40, 0xaa00, 0x66c1, 0x7381, 0xbf40, 0x5901, 0x95c0, 0x8080, 0x4c41, 0x1802,
            0xd4c3, 0xc183, 0x0d42, 0xeb03, 0x27c2, 0x3282, 0xfe43, 0xbe03, 0x72c2, 0x6782, 0xab43,
            0x4d02, 0x81c3, 0x9483, 0x5842, 0x1403, 0xd8c2, 0xcd82, 0x0143, 0xe702, 0x2bc3, 0x3e83,
            0xf242, 0xb202, 0x7ec3, 0x6b83, 0xa742, 0x4103, 0x8dc2, 0x9882, 0x5443, 0x3004, 0xfcc5,
            0xe985, 0x2544, 0xc305, 0x0fc4, 0x1a84, 0xd645, 0x9605, 0x5ac4, 0x4f84, 0x8345, 0x6504,
            0xa9c5, 0xbc85, 0x7044, 0x3c05, 0xf0c4, 0xe584, 0x2945, 0xcf04, 0x03c5, 0x1685, 0xda44,
            0x9a04, 0x56c5, 0x4385, 0x8f44, 0x6905, 0xa5c4, 0xb084, 0x7c45, 0x2806, 0xe4c7, 0xf187,
            0x3d46, 0xdb07, 0x17c6, 0x0286, 0xce47, 0x8e07, 0x42c6, 0x5786, 0x9b47, 0x7d06, 0xb1c7,
            0xa487, 0x6846, 0x2407, 0xe8c6, 0xfd86, 0x3147, 0xd706, 0x1bc7, 0x0e87, 0xc246, 0x8206,
            0x4ec7, 0x5b87, 0x9746, 0x7107, 0xbdc6, 0xa886, 0x6447, 0x6008, 0xacc9, 0xb989, 0x7548,
            0x9309, 0x5fc8, 0x4a88, 0x8649, 0xc609, 0x0ac8, 0x1f88, 0xd349, 0x3508, 0xf9c9, 0xec89,
            0x2048, 0x6c09, 0xa0c8, 0xb588, 0x7949, 0x9f08, 0x53c9, 0x4689, 0x8a48, 0xca08, 0x06c9,
            0x1389, 0xdf48, 0x3909, 0xf5c8, 0xe088, 0x2c49, 0x780a, 0xb4cb, 0xa18b, 0x6d4a, 0x8b0b,
            0x47ca, 0x528a, 0x9e4b, 0xde0b, 0x12ca, 0x078a, 0xcb4b, 0x2d0a, 0xe1cb, 0xf48b, 0x384a,
            0x740b, 0xb8ca, 0xad8a, 0x614b, 0x870a, 0x4bcb, 0x5e8b, 0x924a, 0xd20a, 0x1ecb, 0x0b8b,
            0xc74a, 0x210b, 0xedca, 0xf88a, 0x344b, 0x500c, 0x9ccd, 0x898d, 0x454c, 0xa30d, 0x6fcc,
            0x7a8c, 0xb64d, 0xf60d, 0x3acc, 0x2f8c, 0xe34d, 0x050c, 0xc9cd, 0xdc8d, 0x104c, 0x5c0d,
            0x90cc, 0x858c, 0x494d, 0xaf0c, 0x63cd, 0x768d, 0xba4c, 0xfa0c, 0x36cd, 0x238d, 0xef4c,
            0x090d, 0xc5cc, 0xd08c, 0x1c4d, 0x480e, 0x84cf, 0x918f, 0x5d4e, 0xbb0f, 0x77ce, 0x628e,
            0xae4f, 0xee0f, 0x22ce, 0x378e, 0xfb4f, 0x1d0e, 0xd1cf, 0xc48f, 0x084e, 0x440f, 0x88ce,
            0x9d8e, 0x514f, 0xb70e, 0x7bcf, 0x6e8f, 0xa24e, 0xe20e, 0x2ecf, 0x3b8f, 0xf74e, 0x110f,
            0xddce, 0xc88e, 0x044f,
        ],
        [
            0x0000, 0x900d, 0x6019, 0xf014, 0xc032, 0x503f, 0xa02b, 0x3026, 0xc067, 0x506a, 0xa07e,
            0x3073, 0x0055, 0x9058, 0x604c, 0xf041, 0xc0cd, 0x50c0, 0xa0d4, 0x30d9, 0x00ff, 0x90f2,
            0x60e6, 0xf0eb, 0x00aa, 0x90a7, 0x60b3, 0xf0be, 0xc098, 0x5095, 0xa081, 0x308c, 0xc199,
            0x5194, 0xa180, 0x318d, 0x01ab, 0x91a6, 0x61b2, 0xf1bf, 0x01fe, 0x91f3, 0x61e7, 0xf1ea,
            0xc1cc, 0x51c1, 0xa1d5, 0x31d8, 0x0154, 0x9159, 0x614d, 0xf140, 0xc166, 0x516b, 0xa17f,
            0x3172, 0xc133, 0x513e, 0xa12a, 0x3127, 0x0101, 0x910c, 0x6118, 0xf115, 0xc331, 0x533c,
            0xa328, 0x3325, 0x0303, 0x930e, 0x631a, 0xf317, 0x0356, 0x935b, 0x634f, 0xf342, 0xc364,
            0x5369, 0xa37d, 0x3370, 0x03fc, 0x93f1, 0x63e5, 0xf3e8, 0xc3ce, 0x53c3, 0xa3d7, 0x33da,
            0xc39b, 0x5396, 0xa382, 0x338f, 0x03a9, 0x93a4, 0x63b0, 0xf3bd, 0x02a8, 0x92a5, 0x62b1,
            0xf2bc, 0xc29a, 0x5297, 0xa283, 0x328e, 0xc2cf, 0x52c2, 0xa2d6, 0x32db, 0x02fd, 0x92f0,
            0x62e4, 0xf2e9, 0xc265, 0x5268, 0xa27c, 0x3271, 0x0257, 0x925a, 0x624e, 0xf243, 0x0202,
            0x920f, 0x621b, 0xf216, 0xc230, 0x523d, 0xa229, 0x3224, 0xc661, 0x566c, 0xa678, 0x3675,
            0x0653, 0x965e, 0x664a, 0xf647, 0x0606, 0x960b, 0x661f, 0xf612, 0xc634, 0x5639, 0xa62d,
            0x3620, 0x06ac, 0x96a1, 0x66b5, 0xf6b8, 0xc69e, 0x5693, 0xa687, 0x368a, 0xc6cb, 0x56c6,
            0xa6d2, 0x36df, 0x06f9, 0x96f4, 0x66e0, 0xf6ed, 0x07f8, 0x97f5, 0x67e1, 0xf7ec, 0xc7ca,
            0x57c7, 0xa7d3, 0x37de, 0xc79f, 0x5792, 0xa786, 0x378b, 0x07ad, 0x97a0, 0x67b4, 0xf7b9,
            0xc735, 0x5738, 0xa72c, 0x3721, 0x0707, 0x970a, 0x671e, 0xf713, 0x0752, 0x975f, 0x674b,
            0xf746, 0xc760, 0x576d, 0xa779, 0x3774, 0x0550, 0x955d, 0x6549, 0xf544, 0xc562, 0x556f,
            0xa57b, 0x3576, 0xc537, 0x553a, 0xa52e, 0x3523, 0x0505, 0x9508, 0x651c, 0xf511, 0xc59d,
            0x5590, 0xa584, 0x3589, 0x05af, 0x95a2, 0x65b6, 0xf5bb, 0x05fa, 0x95f7, 0x65e3, 0xf5ee,
            0xc5c8, 0x55c5, 0xa5d1, 0x35dc, 0xc4c9, 0x54c4, 0xa4d0, 0x34dd, 0x04fb, 0x94f6, 0x64e2,
            0xf4ef, 0x04ae, 0x94a3, 0x64b7, 0xf4ba, 0xc49c, 0x5491, 0xa485, 0x3488, 0x0404, 0x9409,
            0x641d, 0xf410, 0xc436, 0x543b, 0xa42f, 0x3422, 0xc463, 0x546e, 0xa47a, 0x3477, 0x0451,
            0x945c, 0x6448, 0xf445,
        ],
        [
            0x0000, 0xc551, 0xcaa1, 0x0ff0, 0xd541, 0x1010, 0x1fe0, 0xdab1, 0xea81, 0x2fd0, 0x2020,
            0xe571, 0x3fc0, 0xfa91, 0xf561, 0x3030, 0x9501, 0x5050, 0x5fa0, 0x9af1, 0x4040, 0x8511,
            0x8ae1, 0x4fb0, 0x7f80, 0xbad1, 0xb521, 0x7070, 0xaac1, 0x6f90, 0x6060, 0xa531, 0x6a01,
            0xaf50, 0xa0a0, 0x65f1, 0xbf40, 0x7a11, 0x75e1, 0xb0b0, 0x8080, 0x45d1, 0x4a21, 0x8f70,
            0x55c1, 0x9090, 0x9f60, 0x5a31, 0xff00, 0x3a51, 0x35a1, 0xf0f0, 0x2a41, 0xef10, 0xe0e0,
            0x25b1, 0x1581, 0xd0d0, 0xdf20, 0x1a71, 0xc0c0, 0x0591, 0x0a61, 0xcf30, 0xd402, 0x1153,
            0x1ea3, 0xdbf2, 0x0143, 0xc412, 0xcbe2, 0x0eb3, 0x3e83, 0xfbd2, 0xf422, 0x3173, 0xebc2,
            0x2e93, 0x2163, 0xe432, 0x4103, 0x8452, 0x8ba2, 0x4ef3, 0x9442, 0x5113, 0x5ee3, 0x9bb2,
            0xab82, 0x6ed3, 0x6123, 0xa472, 0x7ec3, 0xbb92, 0xb462, 0x7133, 0xbe03, 0x7b52, 0x74a2,
            0xb1f3, 0x6b42, 0xae13, 0xa1e3, 0x64b2, 0x5482, 0x91d3, 0x9e23, 0x5b72, 0x81c3, 0x4492,
            0x4b62, 0x8e33, 0x2b02, 0xee53, 0xe1a3, 0x24f2, 0xfe43, 0x3b12, 0x34e2, 0xf1b3, 0xc183,
            0x04d2, 0x0b22, 0xce73, 0x14c2, 0xd193, 0xde63, 0x1b32, 0xe807, 0x2d56, 0x22a6, 0xe7f7,
            0x3d46, 0xf817, 0xf7e7, 0x32b6, 0x0286, 0xc7d7, 0xc827, 0x0d76, 0xd7c7, 0x1296, 0x1d66,
            0xd837, 0x7d06, 0xb857, 0xb7a7, 0x72f6, 0xa847, 0x6d16, 0x62e6, 0xa7b7, 0x9787, 0x52d6,
            0x5d26, 0x9877, 0x42c6, 0x8797, 0x8867, 0x4d36, 0x8206, 0x4757, 0x48a7, 0x8df6, 0x5747,
            0x9216, 0x9de6, 0x58b7, 0x6887, 0xadd6, 0xa226, 0x6777, 0xbdc6, 0x7897, 0x7767, 0xb236,
            0x1707, 0xd256, 0xdda6, 0x18f7, 0xc246, 0x0717, 0x08e7, 0xcdb6, 0xfd86, 0x38d7, 0x3727,
            0xf276, 0x28c7, 0xed96, 0xe266, 0x2737, 0x3c05, 0xf954, 0xf6a4, 0x33f5, 0xe944, 0x2c15,
            0x23e5, 0xe6b4, 0xd684, 0x13d5, 0x1c25, 0xd974, 0x03c5, 0xc694, 0xc964, 0x0c35, 0xa904,
            0x6c55, 0x63a5, 0xa6f4, 0x7c45, 0xb914, 0xb6e4, 0x73b5, 0x4385, 0x86d4, 0x8924, 0x4c75,
            0x96c4, 0x5395, 0x5c65, 0x9934, 0x5604, 0x9355, 0x9ca5, 0x59f4, 0x8345, 0x4614, 0x49e4,
            0x8cb5, 0xbc85, 0x79d4, 0x7624, 0xb375, 0x69c4, 0xac95, 0xa365, 0x6634, 0xc305, 0x0654,
            0x09a4, 0xccf5, 0x1644, 0xd315, 0xdce5, 0x19b4, 0x2984, 0xecd5, 0xe325, 0x2674, 0xfcc5,
            0x3994, 0x3664, 0xf335,
        ],
        [
            0x0000, 0xfc04, 0xb80b, 0x440f, 0x3015, 0xcc11, 0x881e, 0x741a, 0x602a, 0x9c2e, 0xd821,
            0x2425, 0x503f, 0xac3b, 0xe834, 0x1430, 0xc054, 0x3c50, 0x785f, 0x845b, 0xf041, 0x0c45,
            0x484a, 0xb44e, 0xa07e, 0x5c7a, 0x1875, 0xe471, 0x906b, 0x6c6f, 0x2860, 0xd464, 0xc0ab,
            0x3caf, 0x78a0, 0x84a4, 0xf0be, 0x0cba, 0x48b5, 0xb4b1, 0xa081, 0x5c85, 0x188a, 0xe48e,
            0x9094, 0x6c90, 0x289f, 0xd49b, 0x00ff, 0xfcfb, 0xb8f4, 0x44f0, 0x30ea, 0xccee, 0x88e1,
            0x74e5, 0x60d5, 0x9cd1, 0xd8de, 0x24da, 0x50c0, 0xacc4, 0xe8cb, 0x14cf, 0xc155, 0x3d51,
            0x795e, 0x855a, 0xf140, 0x0d44, 0x494b, 0xb54f, 0xa17f, 0x5d7b, 0x1974, 0xe570, 0x916a,
            0x6d6e, 0x2961, 0xd565, 0x0101, 0xfd05, 0xb90a, 0x450e, 0x3114, 0xcd10, 0x891f, 0x751b,
            0x612b, 0x9d2f, 0xd920, 0x2524, 0x513e, 0xad3a, 0xe935, 0x1531, 0x01fe, 0xfdfa, 0xb9f5,
            0x45f1, 0x31eb, 0xcdef, 0x89e0, 0x75e4, 0x61d4, 0x9dd0, 0xd9df, 0x25db, 0x51c1, 0xadc5,
            0xe9ca, 0x15ce, 0xc1aa, 0x3dae, 0x79a1, 0x85a5, 0xf1bf, 0x0dbb, 0x49b4, 0xb5b0, 0xa180,
            0x5d84, 0x198b, 0xe58f, 0x9195, 0x6d91, 0x299e, 0xd59a, 0xc2a9, 0x3ead, 0x7aa2, 0x86a6,
            0xf2bc, 0x0eb8, 0x4ab7, 0xb6b3, 0xa283, 0x5e87, 0x1a88, 0xe68c, 0x9296, 0x6e92, 0x2a9d,
            0xd699, 0x02fd, 0xfef9, 0xbaf6, 0x46f2, 0x32e8, 0xceec, 0x8ae3, 0x76e7, 0x62d7, 0x9ed3,
            0xdadc, 0x26d8, 0x52c2, 0xaec6, 0xeac9, 0x16cd, 0x0202, 0xfe06, 0xba09, 0x460d, 0x3217,
            0xce13, 0x8a1c, 0x7618, 0x6228, 0x9e2c, 0xda23, 0x2627, 0x523d, 0xae39, 0xea36, 0x1632,
            0xc256, 0x3e52, 0x7a5d, 0x8659, 0xf243, 0x0e47, 0x4a48, 0xb64c, 0xa27c, 0x5e78, 0x1a77,
            0xe673, 0x9269, 0x6e6d, 0x2a62, 0xd666, 0x03fc, 0xfff8, 0xbbf7, 0x47f3, 0x33e9, 0xcfed,
            0x8be2, 0x77e6, 0x63d6, 0x9fd2, 0xdbdd, 0x27d9, 0x53c3, 0xafc7, 0xebc8, 0x17cc, 0xc3a8,
            0x3fac, 0x7ba3, 0x87a7, 0xf3bd, 0x0fb9, 0x4bb6, 0xb7b2, 0xa382, 0x5f86, 0x1b89, 0xe78d,
            0x9397, 0x6f93, 0x2b9c, 0xd798, 0xc357, 0x3f53, 0x7b5c, 0x8758, 0xf342, 0x0f46, 0x4b49,
            0xb74d, 0xa37d, 0x5f79, 0x1b76, 0xe772, 0x9368, 0x6f6c, 0x2b63, 0xd767, 0x0303, 0xff07,
            0xbb08, 0x470c, 0x3316, 0xcf12, 0x8b1d, 0x7719, 0x6329, 0x9f2d, 0xdb22, 0x2726, 0x533c,
            0xaf38, 0xeb37, 0x1733,
        ],
        [
            0x0000, 0xc3fd, 0xc7f9, 0x0404, 0xcff1, 0x0c0c, 0x0808, 0xcbf5, 0xdfe1, 0x1c1c, 0x1818,
            0xdbe5, 0x1010, 0xd3ed, 0xd7e9, 0x1414, 0xffc1, 0x3c3c, 0x3838, 0xfbc5, 0x3030, 0xf3cd,
            0xf7c9, 0x3434, 0x2020, 0xe3dd, 0xe7d9, 0x2424, 0xefd1, 0x2c2c, 0x2828, 0xebd5, 0xbf81,
            0x7c7c, 0x7878, 0xbb85, 0x7070, 0xb38d, 0xb789, 0x7474, 0x6060, 0xa39d, 0xa799, 0x6464,
            0xaf91, 0x6c6c, 0x6868, 0xab95, 0x4040, 0x83bd, 0x87b9, 0x4444, 0x8fb1, 0x4c4c, 0x4848,
            0x8bb5, 0x9fa1, 0x5c5c, 0x5858, 0x9ba5, 0x5050, 0x93ad, 0x97a9, 0x5454, 0x3f01, 0xfcfc,
            0xf8f8, 0x3b05, 0xf0f0, 0x330d, 0x3709, 0xf4f4, 0xe0e0, 0x231d, 0x2719, 0xe4e4, 0x2f11,
            0xecec, 0xe8e8, 0x2b15, 0xc0c0, 0x033d, 0x0739, 0xc4c4, 0x0f31, 0xcccc, 0xc8c8, 0x0b35,
            0x1f21, 0xdcdc, 0xd8d8, 0x1b25, 0xd0d0, 0x132d, 0x1729, 0xd4d4, 0x8080, 0x437d, 0x4779,
            0x8484, 0x4f71, 0x8c8c, 0x8888, 0x4b75, 0x5f61, 0x9c9c, 0x9898, 0x5b65, 0x9090, 0x536d,
            0x5769, 0x9494, 0x7f41, 0xbcbc, 0xb8b8, 0x7b45, 0xb0b0, 0x734d, 0x7749, 0xb4b4, 0xa0a0,
            0x635d, 0x6759, 0xa4a4, 0x6f51, 0xacac, 0xa8a8, 0x6b55, 0x7e02, 0xbdff, 0xb9fb, 0x7a06,
            0xb1f3, 0x720e, 0x760a, 0xb5f7, 0xa1e3, 0x621e, 0x661a, 0xa5e7, 0x6e12, 0xadef, 0xa9eb,
            0x6a16, 0x81c3, 0x423e, 0x463a, 0x85c7, 0x4e32, 0x8dcf, 0x89cb, 0x4a36, 0x5e22, 0x9ddf,
            0x99db, 0x5a26, 0x91d3, 0x522e, 0x562a, 0x95d7, 0xc183, 0x027e, 0x067a, 0xc587, 0x0e72,
            0xcd8f, 0xc98b, 0x0a76, 0x1e62, 0xdd9f, 0xd99b, 0x1a66, 0xd193, 0x126e, 0x166a, 0xd597,
            0x3e42, 0xfdbf, 0xf9bb, 0x3a46, 0xf1b3, 0x324e, 0x364a, 0xf5b7, 0xe1a3, 0x225e, 0x265a,
            0xe5a7, 0x2e52, 0xedaf, 0xe9ab, 0x2a56, 0x4103, 0x82fe, 0x86fa, 0x4507, 0x8ef2, 0x4d0f,
            0x490b, 0x8af6, 0x9ee2, 0x5d1f, 0x591b, 0x9ae6, 0x5113, 0x92ee, 0x96ea, 0x5517, 0xbec2,
            0x7d3f, 0x793b, 0xbac6, 0x7133, 0xb2ce, 0xb6ca, 0x7537, 0x6123, 0xa2de, 0xa6da, 0x6527,
            0xaed2, 0x6d2f, 0x692b, 0xaad6, 0xfe82, 0x3d7f, 0x397b, 0xfa86, 0x3173, 0xf28e, 0xf68a,
            0x3577, 0x2163, 0xe29e, 0xe69a, 0x2567, 0xee92, 0x2d6f, 0x296b, 0xea96, 0x0143, 0xc2be,
            0xc6ba, 0x0547, 0xceb2, 0x0d4f, 0x094b, 0xcab6, 0xdea2, 0x1d5f, 0x195b, 0xdaa6, 0x1153,
            0xd2ae, 0xd6aa, 0x1557,
        ],
        [
            0x0000, 0x8102, 0x4207, 0xc305, 0x840e, 0x050c, 0xc609, 0x470b, 0x481f, 0xc91d, 0x0a18,
            0x8b1a, 0xcc11, 0x4d13, 0x8e16, 0x0f14, 0x903e, 0x113c, 0xd239, 0x533b, 0x1430, 0x9532,
            0x5637, 0xd735, 0xd821, 0x5923, 0x9a26, 0x1b24, 0x5c2f, 0xdd2d, 0x1e28, 0x9f2a, 0x607f,
            0xe17d, 0x2278, 0xa37a, 0xe471, 0x6573, 0xa676, 0x2774, 0x2860, 0xa962, 0x6a67, 0xeb65,
            0xac6e, 0x2d6c, 0xee69, 0x6f6b, 0xf041, 0x7143, 0xb246, 0x3344, 0x744f, 0xf54d, 0x3648,
            0xb74a, 0xb85e, 0x395c, 0xfa59, 0x7b5b, 0x3c50, 0xbd52, 0x7e57, 0xff55, 0xc0fe, 0x41fc,
            0x82f9, 0x03fb, 0x44f0, 0xc5f2, 0x06f7, 0x87f5, 0x88e1, 0x09e3, 0xcae6, 0x4be4, 0x0cef,
            0x8ded, 0x4ee8, 0xcfea, 0x50c0, 0xd1c2, 0x12c7, 0x93c5, 0xd4ce, 0x55cc, 0x96c9, 0x17cb,
            0x18df, 0x99dd, 0x5ad8, 0xdbda, 0x9cd1, 0x1dd3, 0xded6, 0x5fd4, 0xa081, 0x2183, 0xe286,
            0x6384, 0x248f, 0xa58d, 0x6688, 0xe78a, 0xe89e, 0x699c, 0xaa99, 0x2b9b, 0x6c90, 0xed92,
            0x2e97, 0xaf95, 0x30bf, 0xb1bd, 0x72b8, 0xf3ba, 0xb4b1, 0x35b3, 0xf6b6, 0x77b4, 0x78a0,
            0xf9a2, 0x3aa7, 0xbba5, 0xfcae, 0x7dac, 0xbea9, 0x3fab, 0xc1ff, 0x40fd, 0x83f8, 0x02fa,
            0x45f1, 0xc4f3, 0x07f6, 0x86f4, 0x89e0, 0x08e2, 0xcbe7, 0x4ae5, 0x0dee, 0x8cec, 0x4fe9,
            0xceeb, 0x51c1, 0xd0c3, 0x13c6, 0x92c4, 0xd5cf, 0x54cd, 0x97c8, 0x16ca, 0x19de, 0x98dc,
            0x5bd9, 0xdadb, 0x9dd0, 0x1cd2, 0xdfd7, 0x5ed5, 0xa180, 0x2082, 0xe387, 0x6285, 0x258e,
            0xa48c, 0x6789, 0xe68b, 0xe99f, 0x689d, 0xab98, 0x2a9a, 0x6d91, 0xec93, 0x2f96, 0xae94,
            0x31be, 0xb0bc, 0x73b9, 0xf2bb, 0xb5b0, 0x34b2, 0xf7b7, 0x76b5, 0x79a1, 0xf8a3, 0x3ba6,
            0xbaa4, 0xfdaf, 0x7cad, 0xbfa8, 0x3eaa, 0x0101, 0x8003, 0x4306, 0xc204, 0x850f, 0x040d,
            0xc708, 0x460a, 0x491e, 0xc81c, 0x0b19, 0x8a1b, 0xcd10, 0x4c12, 0x8f17, 0x0e15, 0x913f,
            0x103d, 0xd338, 0x523a, 0x1531, 0x9433, 0x5736, 0xd634, 0xd920, 0x5822, 0x9b27, 0x1a25,
            0x5d2e, 0xdc2c, 0x1f29, 0x9e2b, 0x617e, 0xe07c, 0x2379, 0xa27b, 0xe570, 0x6472, 0xa777,
            0x2675, 0x2961, 0xa863, 0x6b66, 0xea64, 0xad6f, 0x2c6d, 0xef68, 0x6e6a, 0xf140, 0x7042,
            0xb347, 0x3245, 0x754e, 0xf44c, 0x3749, 0xb64b, 0xb95f, 0x385d, 0xfb58, 0x7a5a, 0x3d51,
            0xbc53, 0x7f56, 0xfe54,
        ],
        [
            0x0000, 0xc100, 0xc203, 0x0303, 0xc405, 0x0505, 0x0606, 0xc706, 0xc809, 0x0909, 0x0a0a,
            0xcb0a, 0x0c0c, 0xcd0c, 0xce0f, 0x0f0f, 0xd011, 0x1111, 0x1212, 0xd312, 0x1414, 0xd514,
            0xd617, 0x1717, 0x1818, 0xd918, 0xda1b, 0x1b1b, 0xdc1d, 0x1d1d, 0x1e1e, 0xdf1e, 0xe021,
            0x2121, 0x2222, 0xe322, 0x2424, 0xe524, 0xe627, 0x2727, 0x2828, 0xe928, 0xea2b, 0x2b2b,
            0xec2d, 0x2d2d, 0x2e2e, 0xef2e, 0x3030, 0xf130, 0xf233, 0x3333, 0xf435, 0x3535, 0x3636,
            0xf736, 0xf839, 0x3939, 0x3a3a, 0xfb3a, 0x3c3c, 0xfd3c, 0xfe3f, 0x3f3f, 0x8041, 0x4141,
            0x4242, 0x8342, 0x4444, 0x8544, 0x8647, 0x4747, 0x4848, 0x8948, 0x8a4b, 0x4b4b, 0x8c4d,
            0x4d4d, 0x4e4e, 0x8f4e, 0x5050, 0x9150, 0x9253, 0x5353, 0x9455, 0x5555, 0x5656, 0x9756,
            0x9859, 0x5959, 0x5a5a, 0x9b5a, 0x5c5c, 0x9d5c, 0x9e5f, 0x5f5f, 0x6060, 0xa160, 0xa263,
            0x6363, 0xa465, 0x6565, 0x6666, 0xa766, 0xa869, 0x6969, 0x6a6a, 0xab6a, 0x6c6c, 0xad6c,
            0xae6f, 0x6f6f, 0xb071, 0x7171, 0x7272, 0xb372, 0x7474, 0xb574, 0xb677, 0x7777, 0x7878,
            0xb978, 0xba7b, 0x7b7b, 0xbc7d, 0x7d7d, 0x7e7e, 0xbf7e, 0x4081, 0x8181, 0x8282, 0x4382,
            0x8484, 0x4584, 0x4687, 0x8787, 0x8888, 0x4988, 0x4a8b, 0x8b8b, 0x4c8d, 0x8d8d, 0x8e8e,
            0x4f8e, 0x9090, 0x5190, 0x5293, 0x9393, 0x5495, 0x9595, 0x9696, 0x5796, 0x5899, 0x9999,
            0x9a9a, 0x5b9a, 0x9c9c, 0x5d9c, 0x5e9f, 0x9f9f, 0xa0a0, 0x61a0, 0x62a3, 0xa3a3, 0x64a5,
            0xa5a5, 0xa6a6, 0x67a6, 0x68a9, 0xa9a9, 0xaaaa, 0x6baa, 0xacac, 0x6dac, 0x6eaf, 0xafaf,
            0x70b1, 0xb1b1, 0xb2b2, 0x73b2, 0xb4b4, 0x75b4, 0x76b7, 0xb7b7, 0xb8b8, 0x79b8, 0x7abb,
            0xbbbb, 0x7cbd, 0xbdbd, 0xbebe, 0x7fbe, 0xc0c0, 0x01c0, 0x02c3, 0xc3c3, 0x04c5, 0xc5c5,
            0xc6c6, 0x07c6, 0x08c9, 0xc9c9, 0xcaca, 0x0bca, 0xcccc, 0x0dcc, 0x0ecf, 0xcfcf, 0x10d1,
            0xd1d1, 0xd2d2, 0x13d2, 0xd4d4, 0x15d4, 0x16d7, 0xd7d7, 0xd8d8, 0x19d8, 0x1adb, 0xdbdb,
            0x1cdd, 0xdddd, 0xdede, 0x1fde, 0x20e1, 0xe1e1, 0xe2e2, 0x23e2, 0xe4e4, 0x25e4, 0x26e7,
            0xe7e7, 0xe8e8, 0x29e8, 0x2aeb, 0xebeb, 0x2ced, 0xeded, 0xeeee, 0x2fee, 0xf0f0, 0x31f0,
            0x32f3, 0xf3f3, 0x34f5, 0xf5f5, 0xf6f6, 0x37f6, 0x38f9, 0xf9f9, 0xfafa, 0x3bfa, 0xfcfc,
            0x3dfc, 0x3eff, 0xffff,
        ],
        [
            0x0000, 0x00c1, 0x0182, 0x0143, 0x0304, 0x03c5, 0x0286, 0x0247, 0x0608, 0x06c9, 0x078a,
            0x074b, 0x050c, 0x05cd, 0x048e, 0x044f, 0x0c10, 0x0cd1, 0x0d92, 0x0d53, 0x0f14, 0x0fd5,
            0x0e96, 0x0e57, 0x0a18, 0x0ad9, 0x0b9a, 0x0b5b, 0x091c, 0x09dd, 0x089e, 0x085f, 0x1820,
            0x18e1, 0x19a2, 0x1963, 0x1b24, 0x1be5, 0x1aa6, 0x1a67, 0x1e28, 0x1ee9, 0x1faa, 0x1f6b,
            0x1d2c, 0x1ded, 0x1cae, 0x1c6f, 0x1430, 0x14f1, 0x15b2, 0x1573, 0x1734, 0x17f5, 0x16b6,
            0x1677, 0x1238, 0x12f9, 0x13ba, 0x137b, 0x113c, 0x11fd, 0x10be, 0x107f, 0x3040, 0x3081,
            0x31c2, 0x3103, 0x3344, 0x3385, 0x32c6, 0x3207, 0x3648, 0x3689, 0x37ca, 0x370b, 0x354c,
            0x358d, 0x34ce, 0x340f, 0x3c50, 0x3c91, 0x3dd2, 0x3d13, 0x3f54, 0x3f95, 0x3ed6, 0x3e17,
            0x3a58, 0x3a99, 0x3bda, 0x3b1b, 0x395c, 0x399d, 0x38de, 0x381f, 0x2860, 0x28a1, 0x29e2,
            0x2923, 0x2b64, 0x2ba5, 0x2ae6, 0x2a27, 0x2e68, 0x2ea9, 0x2fea, 0x2f2b, 0x2d6c, 0x2dad,
            0x2cee, 0x2c2f, 0x2470, 0x24b1, 0x25f2, 0x2533, 0x2774, 0x27b5, 0x26f6, 0x2637, 0x2278,
            0x22b9, 0x23fa, 0x233b, 0x217c, 0x21bd, 0x20fe, 0x203f, 0x6080, 0x6041, 0x6102, 0x61c3,
            0x6384, 0x6345, 0x6206, 0x62c7, 0x6688, 0x6649, 0x670a, 0x67cb, 0x658c, 0x654d, 0x640e,
            0x64cf, 0x6c90, 0x6c51, 0x6d12, 0x6dd3, 0x6f94, 0x6f55, 0x6e16, 0x6ed7, 0x6a98, 0x6a59,
            0x6b1a, 0x6bdb, 0x699c, 0x695d, 0x681e, 0x68df, 0x78a0, 0x7861, 0x7922, 0x79e3, 0x7ba4,
            0x7b65, 0x7a26, 0x7ae7, 0x7ea8, 0x7e69, 0x7f2a, 0x7feb, 0x7dac, 0x7d6d, 0x7c2e, 0x7cef,
            0x74b0, 0x7471, 0x7532, 0x75f3, 0x77b4, 0x7775, 0x7636, 0x76f7, 0x72b8, 0x7279, 0x733a,
            0x73fb, 0x71bc, 0x717d, 0x703e, 0x70ff, 0x50c0, 0x5001, 0x5142, 0x5183, 0x53c4, 0x5305,
            0x5246, 0x5287, 0x56c8, 0x5609, 0x574a, 0x578b, 0x55cc, 0x550d, 0x544e, 0x548f, 0x5cd0,
            0x5c11, 0x5d52, 0x5d93, 0x5fd4, 0x5f15, 0x5e56, 0x5e97, 0x5ad8, 0x5a19, 0x5b5a, 0x5b9b,
            0x59dc, 0x591d, 0x585e, 0x589f, 0x48e0, 0x4821, 0x4962, 0x49a3, 0x4be4, 0x4b25, 0x4a66,
            0x4aa7, 0x4ee8, 0x4e29, 0x4f6a, 0x4fab, 0x4dec, 0x4d2d, 0x4c6e, 0x4caf, 0x44f0, 0x4431,
            0x4572, 0x45b3, 0x47f4, 0x4735, 0x4676, 0x46b7, 0x42f8, 0x4239, 0x437a, 0x43bb, 0x41fc,
            0x413d, 0x407e, 0x40bf,
        ],
        [
            0x0000, 0x90c1, 0x6181, 0xf140, 0xc302, 0x53c3, 0xa283, 0x3242, 0xc607, 0x56c6, 0xa786,
            0x3747, 0x0505, 0x95c4, 0x6484, 0xf445, 0xcc0d, 0x5ccc, 0xad8c, 0x3d4d, 0x0f0f, 0x9fce,
            0x6e8e, 0xfe4f, 0x0a0a, 0x9acb, 0x6b8b, 0xfb4a, 0xc908, 0x59c9, 0xa889, 0x3848, 0xd819,
            0x48d8, 0xb998, 0x2959, 0x1b1b, 0x8bda, 0x7a9a, 0xea5b, 0x1e1e, 0x8edf, 0x7f9f, 0xef5e,
            0xdd1c, 0x4ddd, 0xbc9d, 0x2c5c, 0x1414, 0x84d5, 0x7595, 0xe554, 0xd716, 0x47d7, 0xb697,
            0x2656, 0xd213, 0x42d2, 0xb392, 0x2353, 0x1111, 0x81d0, 0x7090, 0xe051, 0xf031, 0x60f0,
            0x91b0, 0x0171, 0x3333, 0xa3f2, 0x52b2, 0xc273, 0x3636, 0xa6f7, 0x57b7, 0xc776, 0xf534,
            0x65f5, 0x94b5, 0x0474, 0x3c3c, 0xacfd, 0x5dbd, 0xcd7c, 0xff3e, 0x6fff, 0x9ebf, 0x0e7e,
            0xfa3b, 0x6afa, 0x9bba, 0x0b7b, 0x3939, 0xa9f8, 0x58b8, 0xc879, 0x2828, 0xb8e9, 0x49a9,
            0xd968, 0xeb2a, 0x7beb, 0x8aab, 0x1a6a, 0xee2f, 0x7eee, 0x8fae, 0x1f6f, 0x2d2d, 0xbdec,
            0x4cac, 0xdc6d, 0xe425, 0x74e4, 0x85a4, 0x1565, 0x2727, 0xb7e6, 0x46a6, 0xd667, 0x2222,
            0xb2e3, 0x43a3, 0xd362, 0xe120, 0x71e1, 0x80a1, 0x1060, 0xa061, 0x30a0, 0xc1e0, 0x5121,
            0x6363, 0xf3a2, 0x02e2, 0x9223, 0x6666, 0xf6a7, 0x07e7, 0x9726, 0xa564, 0x35a5, 0xc4e5,
            0x5424, 0x6c6c, 0xfcad, 0x0ded, 0x9d2c, 0xaf6e, 0x3faf, 0xceef, 0x5e2e, 0xaa6b, 0x3aaa,
            0xcbea, 0x5b2b, 0x6969, 0xf9a8, 0x08e8, 0x9829, 0x7878, 0xe8b9, 0x19f9, 0x8938, 0xbb7a,
            0x2bbb, 0xdafb, 0x4a3a, 0xbe7f, 0x2ebe, 0xdffe, 0x4f3f, 0x7d7d, 0xedbc, 0x1cfc, 0x8c3d,
            0xb475, 0x24b4, 0xd5f4, 0x4535, 0x7777, 0xe7b6, 0x16f6, 0x8637, 0x7272, 0xe2b3, 0x13f3,
            0x8332, 0xb170, 0x21b1, 0xd0f1, 0x4030, 0x5050, 0xc091, 0x31d1, 0xa110, 0x9352, 0x0393,
            0xf2d3, 0x6212, 0x9657, 0x0696, 0xf7d6, 0x6717, 0x5555, 0xc594, 0x34d4, 0xa415, 0x9c5d,
            0x0c9c, 0xfddc, 0x6d1d, 0x5f5f, 0xcf9e, 0x3ede, 0xae1f, 0x5a5a, 0xca9b, 0x3bdb, 0xab1a,
            0x9958, 0x0999, 0xf8d9, 0x6818, 0x8849, 0x1888, 0xe9c8, 0x7909, 0x4b4b, 0xdb8a, 0x2aca,
            0xba0b, 0x4e4e, 0xde8f, 0x2fcf, 0xbf0e, 0x8d4c, 0x1d8d, 0xeccd, 0x7c0c, 0x4444, 0xd485,
            0x25c5, 0xb504, 0x8746, 0x1787, 0xe6c7, 0x7606, 0x8243, 0x1282, 0xe3c2, 0x7303, 0x4141,
            0xd180, 0x20c0, 0xb001,
        ],
    ];

    pub static CRC16_MCRF4XX_TABLE: [[u16; 256]; 16] = [
        [
            0x0000, 0x1189, 0x2312, 0x329b, 0x4624, 0x57ad, 0x6536, 0x74bf, 0x8c48, 0x9dc1, 0xaf5a,
            0xbed3, 0xca6c, 0xdbe5, 0xe97e, 0xf8f7, 0x1081, 0x0108, 0x3393, 0x221a, 0x56a5, 0x472c,
            0x75b7, 0x643e, 0x9cc9, 0x8d40, 0xbfdb, 0xae52, 0xdaed, 0xcb64, 0xf9ff, 0xe876, 0x2102,
            0x308b, 0x0210, 0x1399, 0x6726, 0x76af, 0x4434, 0x55bd, 0xad4a, 0xbcc3, 0x8e58, 0x9fd1,
            0xeb6e, 0xfae7, 0xc87c, 0xd9f5, 0x3183, 0x200a, 0x1291, 0x0318, 0x77a7, 0x662e, 0x54b5,
            0x453c, 0xbdcb, 0xac42, 0x9ed9, 0x8f50, 0xfbef, 0xea66, 0xd8fd, 0xc974, 0x4204, 0x538d,
            0x6116, 0x709f, 0x0420, 0x15a9, 0x2732, 0x36bb, 0xce4c, 0xdfc5, 0xed5e, 0xfcd7, 0x8868,
            0x99e1, 0xab7a, 0xbaf3, 0x5285, 0x430c, 0x7197, 0x601e, 0x14a1, 0x0528, 0x37b3, 0x263a,
            0xdecd, 0xcf44, 0xfddf, 0xec56, 0x98e9, 0x8960, 0xbbfb, 0xaa72, 0x6306, 0x728f, 0x4014,
            0x519d, 0x2522, 0x34ab, 0x0630, 0x17b9, 0xef4e, 0xfec7, 0xcc5c, 0xddd5, 0xa96a, 0xb8e3,
            0x8a78, 0x9bf1, 0x7387, 0x620e, 0x5095, 0x411c, 0x35a3, 0x242a, 0x16b1, 0x0738, 0xffcf,
            0xee46, 0xdcdd, 0xcd54, 0xb9eb, 0xa862, 0x9af9, 0x8b70, 0x8408, 0x9581, 0xa71a, 0xb693,
            0xc22c, 0xd3a5, 0xe13e, 0xf0b7, 0x0840, 0x19c9, 0x2b52, 0x3adb, 0x4e64, 0x5fed, 0x6d76,
            0x7cff, 0x9489, 0x8500, 0xb79b, 0xa612, 0xd2ad, 0xc324, 0xf1bf, 0xe036, 0x18c1, 0x0948,
            0x3bd3, 0x2a5a, 0x5ee5, 0x4f6c, 0x7df7, 0x6c7e, 0xa50a, 0xb483, 0x8618, 0x9791, 0xe32e,
            0xf2a7, 0xc03c, 0xd1b5, 0x2942, 0x38cb, 0x0a50, 0x1bd9, 0x6f66, 0x7eef, 0x4c74, 0x5dfd,
            0xb58b, 0xa402, 0x9699, 0x8710, 0xf3af, 0xe226, 0xd0bd, 0xc134, 0x39c3, 0x284a, 0x1ad1,
            0x0b58, 0x7fe7, 0x6e6e, 0x5cf5, 0x4d7c, 0xc60c, 0xd785, 0xe51e, 0xf497, 0x8028, 0x91a1,
            0xa33a, 0xb2b3, 0x4a44, 0x5bcd, 0x6956, 0x78df, 0x0c60, 0x1de9, 0x2f72, 0x3efb, 0xd68d,
            0xc704, 0xf59f, 0xe416, 0x90a9, 0x8120, 0xb3bb, 0xa232, 0x5ac5, 0x4b4c, 0x79d7, 0x685e,
            0x1ce1, 0x0d68, 0x3ff3, 0x2e7a, 0xe70e, 0xf687, 0xc41c, 0xd595, 0xa12a, 0xb0a3, 0x8238,
            0x93b1, 0x6b46, 0x7acf, 0x4854, 0x59dd, 0x2d62, 0x3ceb, 0x0e70, 0x1ff9, 0xf78f, 0xe606,
            0xd49d, 0xc514, 0xb1ab, 0xa022, 0x92b9, 0x8330, 0x7bc7, 0x6a4e, 0x58d5, 0x495c, 0x3de3,
            0x2c6a, 0x1ef1, 0x0f78,
        ],
        [
            0x0000, 0x19d8, 0x33b0, 0x2a68, 0x6760, 0x7eb8, 0x54d0, 0x4d08, 0xcec0, 0xd718, 0xfd70,
            0xe4a8, 0xa9a0, 0xb078, 0x9a10, 0x83c8, 0x9591, 0x8c49, 0xa621, 0xbff9, 0xf2f1, 0xeb29,
            0xc141, 0xd899, 0x5b51, 0x4289, 0x68e1, 0x7139, 0x3c31, 0x25e9, 0x0f81, 0x1659, 0x2333,
            0x3aeb, 0x1083, 0x095b, 0x4453, 0x5d8b, 0x77e3, 0x6e3b, 0xedf3, 0xf42b, 0xde43, 0xc79b,
            0x8a93, 0x934b, 0xb923, 0xa0fb, 0xb6a2, 0xaf7a, 0x8512, 0x9cca, 0xd1c2, 0xc81a, 0xe272,
            0xfbaa, 0x7862, 0x61ba, 0x4bd2, 0x520a, 0x1f02, 0x06da, 0x2cb2, 0x356a, 0x4666, 0x5fbe,
            0x75d6, 0x6c0e, 0x2106, 0x38de, 0x12b6, 0x0b6e, 0x88a6, 0x917e, 0xbb16, 0xa2ce, 0xefc6,
            0xf61e, 0xdc76, 0xc5ae, 0xd3f7, 0xca2f, 0xe047, 0xf99f, 0xb497, 0xad4f, 0x8727, 0x9eff,
            0x1d37, 0x04ef, 0x2e87, 0x375f, 0x7a57, 0x638f, 0x49e7, 0x503f, 0x6555, 0x7c8d, 0x56e5,
            0x4f3d, 0x0235, 0x1bed, 0x3185, 0x285d, 0xab95, 0xb24d, 0x9825, 0x81fd, 0xccf5, 0xd52d,
            0xff45, 0xe69d, 0xf0c4, 0xe91c, 0xc374, 0xdaac, 0x97a4, 0x8e7c, 0xa414, 0xbdcc, 0x3e04,
            0x27dc, 0x0db4, 0x146c, 0x5964, 0x40bc, 0x6ad4, 0x730c, 0x8ccc, 0x9514, 0xbf7c, 0xa6a4,
            0xebac, 0xf274, 0xd81c, 0xc1c4, 0x420c, 0x5bd4, 0x71bc, 0x6864, 0x256c, 0x3cb4, 0x16dc,
            0x0f04, 0x195d, 0x0085, 0x2aed, 0x3335, 0x7e3d, 0x67e5, 0x4d8d, 0x5455, 0xd79d, 0xce45,
            0xe42d, 0xfdf5, 0xb0fd, 0xa925, 0x834d, 0x9a95, 0xafff, 0xb627, 0x9c4f, 0x8597, 0xc89f,
            0xd147, 0xfb2f, 0xe2f7, 0x613f, 0x78e7, 0x528f, 0x4b57, 0x065f, 0x1f87, 0x35ef, 0x2c37,
            0x3a6e, 0x23b6, 0x09de, 0x1006, 0x5d0e, 0x44d6, 0x6ebe, 0x7766, 0xf4ae, 0xed76, 0xc71e,
            0xdec6, 0x93ce, 0x8a16, 0xa07e, 0xb9a6, 0xcaaa, 0xd372, 0xf91a, 0xe0c2, 0xadca, 0xb412,
            0x9e7a, 0x87a2, 0x046a, 0x1db2, 0x37da, 0x2e02, 0x630a, 0x7ad2, 0x50ba, 0x4962, 0x5f3b,
            0x46e3, 0x6c8b, 0x7553, 0x385b, 0x2183, 0x0beb, 0x1233, 0x91fb, 0x8823, 0xa24b, 0xbb93,
            0xf69b, 0xef43, 0xc52b, 0xdcf3, 0xe999, 0xf041, 0xda29, 0xc3f1, 0x8ef9, 0x9721, 0xbd49,
            0xa491, 0x2759, 0x3e81, 0x14e9, 0x0d31, 0x4039, 0x59e1, 0x7389, 0x6a51, 0x7c08, 0x65d0,
            0x4fb8, 0x5660, 0x1b68, 0x02b0, 0x28d8, 0x3100, 0xb2c8, 0xab10, 0x8178, 0x98a0, 0xd5a8,
            0xcc70, 0xe618, 0xffc0,
        ],
        [
            0x0000, 0x5adc, 0xb5b8, 0xef64, 0x6361, 0x39bd, 0xd6d9, 0x8c05, 0xc6c2, 0x9c1e, 0x737a,
            0x29a6, 0xa5a3, 0xff7f, 0x101b, 0x4ac7, 0x8595, 0xdf49, 0x302d, 0x6af1, 0xe6f4, 0xbc28,
            0x534c, 0x0990, 0x4357, 0x198b, 0xf6ef, 0xac33, 0x2036, 0x7aea, 0x958e, 0xcf52, 0x033b,
            0x59e7, 0xb683, 0xec5f, 0x605a, 0x3a86, 0xd5e2, 0x8f3e, 0xc5f9, 0x9f25, 0x7041, 0x2a9d,
            0xa698, 0xfc44, 0x1320, 0x49fc, 0x86ae, 0xdc72, 0x3316, 0x69ca, 0xe5cf, 0xbf13, 0x5077,
            0x0aab, 0x406c, 0x1ab0, 0xf5d4, 0xaf08, 0x230d, 0x79d1, 0x96b5, 0xcc69, 0x0676, 0x5caa,
            0xb3ce, 0xe912, 0x6517, 0x3fcb, 0xd0af, 0x8a73, 0xc0b4, 0x9a68, 0x750c, 0x2fd0, 0xa3d5,
            0xf909, 0x166d, 0x4cb1, 0x83e3, 0xd93f, 0x365b, 0x6c87, 0xe082, 0xba5e, 0x553a, 0x0fe6,
            0x4521, 0x1ffd, 0xf099, 0xaa45, 0x2640, 0x7c9c, 0x93f8, 0xc924, 0x054d, 0x5f91, 0xb0f5,
            0xea29, 0x662c, 0x3cf0, 0xd394, 0x8948, 0xc38f, 0x9953, 0x7637, 0x2ceb, 0xa0ee, 0xfa32,
            0x1556, 0x4f8a, 0x80d8, 0xda04, 0x3560, 0x6fbc, 0xe3b9, 0xb965, 0x5601, 0x0cdd, 0x461a,
            0x1cc6, 0xf3a2, 0xa97e, 0x257b, 0x7fa7, 0x90c3, 0xca1f, 0x0cec, 0x5630, 0xb954, 0xe388,
            0x6f8d, 0x3551, 0xda35, 0x80e9, 0xca2e, 0x90f2, 0x7f96, 0x254a, 0xa94f, 0xf393, 0x1cf7,
            0x462b, 0x8979, 0xd3a5, 0x3cc1, 0x661d, 0xea18, 0xb0c4, 0x5fa0, 0x057c, 0x4fbb, 0x1567,
            0xfa03, 0xa0df, 0x2cda, 0x7606, 0x9962, 0xc3be, 0x0fd7, 0x550b, 0xba6f, 0xe0b3, 0x6cb6,
            0x366a, 0xd90e, 0x83d2, 0xc915, 0x93c9, 0x7cad, 0x2671, 0xaa74, 0xf0a8, 0x1fcc, 0x4510,
            0x8a42, 0xd09e, 0x3ffa, 0x6526, 0xe923, 0xb3ff, 0x5c9b, 0x0647, 0x4c80, 0x165c, 0xf938,
            0xa3e4, 0x2fe1, 0x753d, 0x9a59, 0xc085, 0x0a9a, 0x5046, 0xbf22, 0xe5fe, 0x69fb, 0x3327,
            0xdc43, 0x869f, 0xcc58, 0x9684, 0x79e0, 0x233c, 0xaf39, 0xf5e5, 0x1a81, 0x405d, 0x8f0f,
            0xd5d3, 0x3ab7, 0x606b, 0xec6e, 0xb6b2, 0x59d6, 0x030a, 0x49cd, 0x1311, 0xfc75, 0xa6a9,
            0x2aac, 0x7070, 0x9f14, 0xc5c8, 0x09a1, 0x537d, 0xbc19, 0xe6c5, 0x6ac0, 0x301c, 0xdf78,
            0x85a4, 0xcf63, 0x95bf, 0x7adb, 0x2007, 0xac02, 0xf6de, 0x19ba, 0x4366, 0x8c34, 0xd6e8,
            0x398c, 0x6350, 0xef55, 0xb589, 0x5aed, 0x0031, 0x4af6, 0x102a, 0xff4e, 0xa592, 0x2997,
            0x734b, 0x9c2f, 0xc6f3,
        ],
        [
            0x0000, 0x1cbb, 0x3976, 0x25cd, 0x72ec, 0x6e57, 0x4b9a, 0x5721, 0xe5d8, 0xf963, 0xdcae,
            0xc015, 0x9734, 0x8b8f, 0xae42, 0xb2f9, 0xc3a1, 0xdf1a, 0xfad7, 0xe66c, 0xb14d, 0xadf6,
            0x883b, 0x9480, 0x2679, 0x3ac2, 0x1f0f, 0x03b4, 0x5495, 0x482e, 0x6de3, 0x7158, 0x8f53,
            0x93e8, 0xb625, 0xaa9e, 0xfdbf, 0xe104, 0xc4c9, 0xd872, 0x6a8b, 0x7630, 0x53fd, 0x4f46,
            0x1867, 0x04dc, 0x2111, 0x3daa, 0x4cf2, 0x5049, 0x7584, 0x693f, 0x3e1e, 0x22a5, 0x0768,
            0x1bd3, 0xa92a, 0xb591, 0x905c, 0x8ce7, 0xdbc6, 0xc77d, 0xe2b0, 0xfe0b, 0x16b7, 0x0a0c,
            0x2fc1, 0x337a, 0x645b, 0x78e0, 0x5d2d, 0x4196, 0xf36f, 0xefd4, 0xca19, 0xd6a2, 0x8183,
            0x9d38, 0xb8f5, 0xa44e, 0xd516, 0xc9ad, 0xec60, 0xf0db, 0xa7fa, 0xbb41, 0x9e8c, 0x8237,
            0x30ce, 0x2c75, 0x09b8, 0x1503, 0x4222, 0x5e99, 0x7b54, 0x67ef, 0x99e4, 0x855f, 0xa092,
            0xbc29, 0xeb08, 0xf7b3, 0xd27e, 0xcec5, 0x7c3c, 0x6087, 0x454a, 0x59f1, 0x0ed0, 0x126b,
            0x37a6, 0x2b1d, 0x5a45, 0x46fe, 0x6333, 0x7f88, 0x28a9, 0x3412, 0x11df, 0x0d64, 0xbf9d,
            0xa326, 0x86eb, 0x9a50, 0xcd71, 0xd1ca, 0xf407, 0xe8bc, 0x2d6e, 0x31d5, 0x1418, 0x08a3,
            0x5f82, 0x4339, 0x66f4, 0x7a4f, 0xc8b6, 0xd40d, 0xf1c0, 0xed7b, 0xba5a, 0xa6e1, 0x832c,
            0x9f97, 0xeecf, 0xf274, 0xd7b9, 0xcb02, 0x9c23, 0x8098, 0xa555, 0xb9ee, 0x0b17, 0x17ac,
            0x3261, 0x2eda, 0x79fb, 0x6540, 0x408d, 0x5c36, 0xa23d, 0xbe86, 0x9b4b, 0x87f0, 0xd0d1,
            0xcc6a, 0xe9a7, 0xf51c, 0x47e5, 0x5b5e, 0x7e93, 0x6228, 0x3509, 0x29b2, 0x0c7f, 0x10c4,
            0x619c, 0x7d27, 0x58ea, 0x4451, 0x1370, 0x0fcb, 0x2a06, 0x36bd, 0x8444, 0x98ff, 0xbd32,
            0xa189, 0xf6a8, 0xea13, 0xcfde, 0xd365, 0x3bd9, 0x2762, 0x02af, 0x1e14, 0x4935, 0x558e,
            0x7043, 0x6cf8, 0xde01, 0xc2ba, 0xe777, 0xfbcc, 0xaced, 0xb056, 0x959b, 0x8920, 0xf878,
            0xe4c3, 0xc10e, 0xddb5, 0x8a94, 0x962f, 0xb3e2, 0xaf59, 0x1da0, 0x011b, 0x24d6, 0x386d,
            0x6f4c, 0x73f7, 0x563a, 0x4a81, 0xb48a, 0xa831, 0x8dfc, 0x9147, 0xc666, 0xdadd, 0xff10,
            0xe3ab, 0x5152, 0x4de9, 0x6824, 0x749f, 0x23be, 0x3f05, 0x1ac8, 0x0673, 0x772b, 0x6b90,
            0x4e5d, 0x52e6, 0x05c7, 0x197c, 0x3cb1, 0x200a, 0x92f3, 0x8e48, 0xab85, 0xb73e, 0xe01f,
            0xfca4, 0xd969, 0xc5d2,
        ],
        [
            0x0000, 0x0b44, 0x1688, 0x1dcc, 0x2d10, 0x2654, 0x3b98, 0x30dc, 0x5a20, 0x5164, 0x4ca8,
            0x47ec, 0x7730, 0x7c74, 0x61b8, 0x6afc, 0xb440, 0xbf04, 0xa2c8, 0xa98c, 0x9950, 0x9214,
            0x8fd8, 0x849c, 0xee60, 0xe524, 0xf8e8, 0xf3ac, 0xc370, 0xc834, 0xd5f8, 0xdebc, 0x6091,
            0x6bd5, 0x7619, 0x7d5d, 0x4d81, 0x46c5, 0x5b09, 0x504d, 0x3ab1, 0x31f5, 0x2c39, 0x277d,
            0x17a1, 0x1ce5, 0x0129, 0x0a6d, 0xd4d1, 0xdf95, 0xc259, 0xc91d, 0xf9c1, 0xf285, 0xef49,
            0xe40d, 0x8ef1, 0x85b5, 0x9879, 0x933d, 0xa3e1, 0xa8a5, 0xb569, 0xbe2d, 0xc122, 0xca66,
            0xd7aa, 0xdcee, 0xec32, 0xe776, 0xfaba, 0xf1fe, 0x9b02, 0x9046, 0x8d8a, 0x86ce, 0xb612,
            0xbd56, 0xa09a, 0xabde, 0x7562, 0x7e26, 0x63ea, 0x68ae, 0x5872, 0x5336, 0x4efa, 0x45be,
            0x2f42, 0x2406, 0x39ca, 0x328e, 0x0252, 0x0916, 0x14da, 0x1f9e, 0xa1b3, 0xaaf7, 0xb73b,
            0xbc7f, 0x8ca3, 0x87e7, 0x9a2b, 0x916f, 0xfb93, 0xf0d7, 0xed1b, 0xe65f, 0xd683, 0xddc7,
            0xc00b, 0xcb4f, 0x15f3, 0x1eb7, 0x037b, 0x083f, 0x38e3, 0x33a7, 0x2e6b, 0x252f, 0x4fd3,
            0x4497, 0x595b, 0x521f, 0x62c3, 0x6987, 0x744b, 0x7f0f, 0x8a55, 0x8111, 0x9cdd, 0x9799,
            0xa745, 0xac01, 0xb1cd, 0xba89, 0xd075, 0xdb31, 0xc6fd, 0xcdb9, 0xfd65, 0xf621, 0xebed,
            0xe0a9, 0x3e15, 0x3551, 0x289d, 0x23d9, 0x1305, 0x1841, 0x058d, 0x0ec9, 0x6435, 0x6f71,
            0x72bd, 0x79f9, 0x4925, 0x4261, 0x5fad, 0x54e9, 0xeac4, 0xe180, 0xfc4c, 0xf708, 0xc7d4,
            0xcc90, 0xd15c, 0xda18, 0xb0e4, 0xbba0, 0xa66c, 0xad28, 0x9df4, 0x96b0, 0x8b7c, 0x8038,
            0x5e84, 0x55c0, 0x480c, 0x4348, 0x7394, 0x78d0, 0x651c, 0x6e58, 0x04a4, 0x0fe0, 0x122c,
            0x1968, 0x29b4, 0x22f0, 0x3f3c, 0x3478, 0x4b77, 0x4033, 0x5dff, 0x56bb, 0x6667, 0x6d23,
            0x70ef, 0x7bab, 0x1157, 0x1a13, 0x07df, 0x0c9b, 0x3c47, 0x3703, 0x2acf, 0x218b, 0xff37,
            0xf473, 0xe9bf, 0xe2fb, 0xd227, 0xd963, 0xc4af, 0xcfeb, 0xa517, 0xae53, 0xb39f, 0xb8db,
            0x8807, 0x8343, 0x9e8f, 0x95cb, 0x2be6, 0x20a2, 0x3d6e, 0x362a, 0x06f6, 0x0db2, 0x107e,
            0x1b3a, 0x71c6, 0x7a82, 0x674e, 0x6c0a, 0x5cd6, 0x5792, 0x4a5e, 0x411a, 0x9fa6, 0x94e2,
            0x892e, 0x826a, 0xb2b6, 0xb9f2, 0xa43e, 0xaf7a, 0xc586, 0xcec2, 0xd30e, 0xd84a, 0xe896,
            0xe3d2, 0xfe1e, 0xf55a,
        ],
        [
            0x0000, 0x042b, 0x0856, 0x0c7d, 0x10ac, 0x1487, 0x18fa, 0x1cd1, 0x2158, 0x2573, 0x290e,
            0x2d25, 0x31f4, 0x35df, 0x39a2, 0x3d89, 0x42b0, 0x469b, 0x4ae6, 0x4ecd, 0x521c, 0x5637,
            0x5a4a, 0x5e61, 0x63e8, 0x67c3, 0x6bbe, 0x6f95, 0x7344, 0x776f, 0x7b12, 0x7f39, 0x8560,
            0x814b, 0x8d36, 0x891d, 0x95cc, 0x91e7, 0x9d9a, 0x99b1, 0xa438, 0xa013, 0xac6e, 0xa845,
            0xb494, 0xb0bf, 0xbcc2, 0xb8e9, 0xc7d0, 0xc3fb, 0xcf86, 0xcbad, 0xd77c, 0xd357, 0xdf2a,
            0xdb01, 0xe688, 0xe2a3, 0xeede, 0xeaf5, 0xf624, 0xf20f, 0xfe72, 0xfa59, 0x02d1, 0x06fa,
            0x0a87, 0x0eac, 0x127d, 0x1656, 0x1a2b, 0x1e00, 0x2389, 0x27a2, 0x2bdf, 0x2ff4, 0x3325,
            0x370e, 0x3b73, 0x3f58, 0x4061, 0x444a, 0x4837, 0x4c1c, 0x50cd, 0x54e6, 0x589b, 0x5cb0,
            0x6139, 0x6512, 0x696f, 0x6d44, 0x7195, 0x75be, 0x79c3, 0x7de8, 0x87b1, 0x839a, 0x8fe7,
            0x8bcc, 0x971d, 0x9336, 0x9f4b, 0x9b60, 0xa6e9, 0xa2c2, 0xaebf, 0xaa94, 0xb645, 0xb26e,
            0xbe13, 0xba38, 0xc501, 0xc12a, 0xcd57, 0xc97c, 0xd5ad, 0xd186, 0xddfb, 0xd9d0, 0xe459,
            0xe072, 0xec0f, 0xe824, 0xf4f5, 0xf0de, 0xfca3, 0xf888, 0x05a2, 0x0189, 0x0df4, 0x09df,
            0x150e, 0x1125, 0x1d58, 0x1973, 0x24fa, 0x20d1, 0x2cac, 0x2887, 0x3456, 0x307d, 0x3c00,
            0x382b, 0x4712, 0x4339, 0x4f44, 0x4b6f, 0x57be, 0x5395, 0x5fe8, 0x5bc3, 0x664a, 0x6261,
            0x6e1c, 0x6a37, 0x76e6, 0x72cd, 0x7eb0, 0x7a9b, 0x80c2, 0x84e9, 0x8894, 0x8cbf, 0x906e,
            0x9445, 0x9838, 0x9c13, 0xa19a, 0xa5b1, 0xa9cc, 0xade7, 0xb136, 0xb51d, 0xb960, 0xbd4b,
            0xc272, 0xc659, 0xca24, 0xce0f, 0xd2de, 0xd6f5, 0xda88, 0xdea3, 0xe32a, 0xe701, 0xeb7c,
            0xef57, 0xf386, 0xf7ad, 0xfbd0, 0xfffb, 0x0773, 0x0358, 0x0f25, 0x0b0e, 0x17df, 0x13f4,
            0x1f89, 0x1ba2, 0x262b, 0x2200, 0x2e7d, 0x2a56, 0x3687, 0x32ac, 0x3ed1, 0x3afa, 0x45c3,
            0x41e8, 0x4d95, 0x49be, 0x556f, 0x5144, 0x5d39, 0x5912, 0x649b, 0x60b0, 0x6ccd, 0x68e6,
            0x7437, 0x701c, 0x7c61, 0x784a, 0x8213, 0x8638, 0x8a45, 0x8e6e, 0x92bf, 0x9694, 0x9ae9,
            0x9ec2, 0xa34b, 0xa760, 0xab1d, 0xaf36, 0xb3e7, 0xb7cc, 0xbbb1, 0xbf9a, 0xc0a3, 0xc488,
            0xc8f5, 0xccde, 0xd00f, 0xd424, 0xd859, 0xdc72, 0xe1fb, 0xe5d0, 0xe9ad, 0xed86, 0xf157,
            0xf57c, 0xf901, 0xfd2a,
        ],
        [
            0x0000, 0x9fd5, 0x37bb, 0xa86e, 0x6f76, 0xf0a3, 0x58cd, 0xc718, 0xdeec, 0x4139, 0xe957,
            0x7682, 0xb19a, 0x2e4f, 0x8621, 0x19f4, 0xb5c9, 0x2a1c, 0x8272, 0x1da7, 0xdabf, 0x456a,
            0xed04, 0x72d1, 0x6b25, 0xf4f0, 0x5c9e, 0xc34b, 0x0453, 0x9b86, 0x33e8, 0xac3d, 0x6383,
            0xfc56, 0x5438, 0xcbed, 0x0cf5, 0x9320, 0x3b4e, 0xa49b, 0xbd6f, 0x22ba, 0x8ad4, 0x1501,
            0xd219, 0x4dcc, 0xe5a2, 0x7a77, 0xd64a, 0x499f, 0xe1f1, 0x7e24, 0xb93c, 0x26e9, 0x8e87,
            0x1152, 0x08a6, 0x9773, 0x3f1d, 0xa0c8, 0x67d0, 0xf805, 0x506b, 0xcfbe, 0xc706, 0x58d3,
            0xf0bd, 0x6f68, 0xa870, 0x37a5, 0x9fcb, 0x001e, 0x19ea, 0x863f, 0x2e51, 0xb184, 0x769c,
            0xe949, 0x4127, 0xdef2, 0x72cf, 0xed1a, 0x4574, 0xdaa1, 0x1db9, 0x826c, 0x2a02, 0xb5d7,
            0xac23, 0x33f6, 0x9b98, 0x044d, 0xc355, 0x5c80, 0xf4ee, 0x6b3b, 0xa485, 0x3b50, 0x933e,
            0x0ceb, 0xcbf3, 0x5426, 0xfc48, 0x639d, 0x7a69, 0xe5bc, 0x4dd2, 0xd207, 0x151f, 0x8aca,
            0x22a4, 0xbd71, 0x114c, 0x8e99, 0x26f7, 0xb922, 0x7e3a, 0xe1ef, 0x4981, 0xd654, 0xcfa0,
            0x5075, 0xf81b, 0x67ce, 0xa0d6, 0x3f03, 0x976d, 0x08b8, 0x861d, 0x19c8, 0xb1a6, 0x2e73,
            0xe96b, 0x76be, 0xded0, 0x4105, 0x58f1, 0xc724, 0x6f4a, 0xf09f, 0x3787, 0xa852, 0x003c,
            0x9fe9, 0x33d4, 0xac01, 0x046f, 0x9bba, 0x5ca2, 0xc377, 0x6b19, 0xf4cc, 0xed38, 0x72ed,
            0xda83, 0x4556, 0x824e, 0x1d9b, 0xb5f5, 0x2a20, 0xe59e, 0x7a4b, 0xd225, 0x4df0, 0x8ae8,
            0x153d, 0xbd53, 0x2286, 0x3b72, 0xa4a7, 0x0cc9, 0x931c, 0x5404, 0xcbd1, 0x63bf, 0xfc6a,
            0x5057, 0xcf82, 0x67ec, 0xf839, 0x3f21, 0xa0f4, 0x089a, 0x974f, 0x8ebb, 0x116e, 0xb900,
            0x26d5, 0xe1cd, 0x7e18, 0xd676, 0x49a3, 0x411b, 0xdece, 0x76a0, 0xe975, 0x2e6d, 0xb1b8,
            0x19d6, 0x8603, 0x9ff7, 0x0022, 0xa84c, 0x3799, 0xf081, 0x6f54, 0xc73a, 0x58ef, 0xf4d2,
            0x6b07, 0xc369, 0x5cbc, 0x9ba4, 0x0471, 0xac1f, 0x33ca, 0x2a3e, 0xb5eb, 0x1d85, 0x8250,
            0x4548, 0xda9d, 0x72f3, 0xed26, 0x2298, 0xbd4d, 0x1523, 0x8af6, 0x4dee, 0xd23b, 0x7a55,
            0xe580, 0xfc74, 0x63a1, 0xcbcf, 0x541a, 0x9302, 0x0cd7, 0xa4b9, 0x3b6c, 0x9751, 0x0884,
            0xa0ea, 0x3f3f, 0xf827, 0x67f2, 0xcf9c, 0x5049, 0x49bd, 0xd668, 0x7e06, 0xe1d3, 0x26cb,
            0xb91e, 0x1170, 0x8ea5,
        ],
        [
            0x0000, 0x81bf, 0x0b6f, 0x8ad0, 0x16de, 0x9761, 0x1db1, 0x9c0e, 0x2dbc, 0xac03, 0x26d3,
            0xa76c, 0x3b62, 0xbadd, 0x300d, 0xb1b2, 0x5b78, 0xdac7, 0x5017, 0xd1a8, 0x4da6, 0xcc19,
            0x46c9, 0xc776, 0x76c4, 0xf77b, 0x7dab, 0xfc14, 0x601a, 0xe1a5, 0x6b75, 0xeaca, 0xb6f0,
            0x374f, 0xbd9f, 0x3c20, 0xa02e, 0x2191, 0xab41, 0x2afe, 0x9b4c, 0x1af3, 0x9023, 0x119c,
            0x8d92, 0x0c2d, 0x86fd, 0x0742, 0xed88, 0x6c37, 0xe6e7, 0x6758, 0xfb56, 0x7ae9, 0xf039,
            0x7186, 0xc034, 0x418b, 0xcb5b, 0x4ae4, 0xd6ea, 0x5755, 0xdd85, 0x5c3a, 0x65f1, 0xe44e,
            0x6e9e, 0xef21, 0x732f, 0xf290, 0x7840, 0xf9ff, 0x484d, 0xc9f2, 0x4322, 0xc29d, 0x5e93,
            0xdf2c, 0x55fc, 0xd443, 0x3e89, 0xbf36, 0x35e6, 0xb459, 0x2857, 0xa9e8, 0x2338, 0xa287,
            0x1335, 0x928a, 0x185a, 0x99e5, 0x05eb, 0x8454, 0x0e84, 0x8f3b, 0xd301, 0x52be, 0xd86e,
            0x59d1, 0xc5df, 0x4460, 0xceb0, 0x4f0f, 0xfebd, 0x7f02, 0xf5d2, 0x746d, 0xe863, 0x69dc,
            0xe30c, 0x62b3, 0x8879, 0x09c6, 0x8316, 0x02a9, 0x9ea7, 0x1f18, 0x95c8, 0x1477, 0xa5c5,
            0x247a, 0xaeaa, 0x2f15, 0xb31b, 0x32a4, 0xb874, 0x39cb, 0xcbe2, 0x4a5d, 0xc08d, 0x4132,
            0xdd3c, 0x5c83, 0xd653, 0x57ec, 0xe65e, 0x67e1, 0xed31, 0x6c8e, 0xf080, 0x713f, 0xfbef,
            0x7a50, 0x909a, 0x1125, 0x9bf5, 0x1a4a, 0x8644, 0x07fb, 0x8d2b, 0x0c94, 0xbd26, 0x3c99,
            0xb649, 0x37f6, 0xabf8, 0x2a47, 0xa097, 0x2128, 0x7d12, 0xfcad, 0x767d, 0xf7c2, 0x6bcc,
            0xea73, 0x60a3, 0xe11c, 0x50ae, 0xd111, 0x5bc1, 0xda7e, 0x4670, 0xc7cf, 0x4d1f, 0xcca0,
            0x266a, 0xa7d5, 0x2d05, 0xacba, 0x30b4, 0xb10b, 0x3bdb, 0xba64, 0x0bd6, 0x8a69, 0x00b9,
            0x8106, 0x1d08, 0x9cb7, 0x1667, 0x97d8, 0xae13, 0x2fac, 0xa57c, 0x24c3, 0xb8cd, 0x3972,
            0xb3a2, 0x321d, 0x83af, 0x0210, 0x88c0, 0x097f, 0x9571, 0x14ce, 0x9e1e, 0x1fa1, 0xf56b,
            0x74d4, 0xfe04, 0x7fbb, 0xe3b5, 0x620a, 0xe8da, 0x6965, 0xd8d7, 0x5968, 0xd3b8, 0x5207,
            0xce09, 0x4fb6, 0xc566, 0x44d9, 0x18e3, 0x995c, 0x138c, 0x9233, 0x0e3d, 0x8f82, 0x0552,
            0x84ed, 0x355f, 0xb4e0, 0x3e30, 0xbf8f, 0x2381, 0xa23e, 0x28ee, 0xa951, 0x439b, 0xc224,
            0x48f4, 0xc94b, 0x5545, 0xd4fa, 0x5e2a, 0xdf95, 0x6e27, 0xef98, 0x6548, 0xe4f7, 0x78f9,
            0xf946, 0x7396, 0xf229,
        ],
        [
            0x0000, 0x4dfd, 0x9bfa, 0xd607, 0x3fe5, 0x7218, 0xa41f, 0xe9e2, 0x7fca, 0x3237, 0xe430,
            0xa9cd, 0x402f, 0x0dd2, 0xdbd5, 0x9628, 0xff94, 0xb269, 0x646e, 0x2993, 0xc071, 0x8d8c,
            0x5b8b, 0x1676, 0x805e, 0xcda3, 0x1ba4, 0x5659, 0xbfbb, 0xf246, 0x2441, 0x69bc, 0xf739,
            0xbac4, 0x6cc3, 0x213e, 0xc8dc, 0x8521, 0x5326, 0x1edb, 0x88f3, 0xc50e, 0x1309, 0x5ef4,
            0xb716, 0xfaeb, 0x2cec, 0x6111, 0x08ad, 0x4550, 0x9357, 0xdeaa, 0x3748, 0x7ab5, 0xacb2,
            0xe14f, 0x7767, 0x3a9a, 0xec9d, 0xa160, 0x4882, 0x057f, 0xd378, 0x9e85, 0xe663, 0xab9e,
            0x7d99, 0x3064, 0xd986, 0x947b, 0x427c, 0x0f81, 0x99a9, 0xd454, 0x0253, 0x4fae, 0xa64c,
            0xebb1, 0x3db6, 0x704b, 0x19f7, 0x540a, 0x820d, 0xcff0, 0x2612, 0x6bef, 0xbde8, 0xf015,
            0x663d, 0x2bc0, 0xfdc7, 0xb03a, 0x59d8, 0x1425, 0xc222, 0x8fdf, 0x115a, 0x5ca7, 0x8aa0,
            0xc75d, 0x2ebf, 0x6342, 0xb545, 0xf8b8, 0x6e90, 0x236d, 0xf56a, 0xb897, 0x5175, 0x1c88,
            0xca8f, 0x8772, 0xeece, 0xa333, 0x7534, 0x38c9, 0xd12b, 0x9cd6, 0x4ad1, 0x072c, 0x9104,
            0xdcf9, 0x0afe, 0x4703, 0xaee1, 0xe31c, 0x351b, 0x78e6, 0xc4d7, 0x892a, 0x5f2d, 0x12d0,
            0xfb32, 0xb6cf, 0x60c8, 0x2d35, 0xbb1d, 0xf6e0, 0x20e7, 0x6d1a, 0x84f8, 0xc905, 0x1f02,
            0x52ff, 0x3b43, 0x76be, 0xa0b9, 0xed44, 0x04a6, 0x495b, 0x9f5c, 0xd2a1, 0x4489, 0x0974,
            0xdf73, 0x928e, 0x7b6c, 0x3691, 0xe096, 0xad6b, 0x33ee, 0x7e13, 0xa814, 0xe5e9, 0x0c0b,
            0x41f6, 0x97f1, 0xda0c, 0x4c24, 0x01d9, 0xd7de, 0x9a23, 0x73c1, 0x3e3c, 0xe83b, 0xa5c6,
            0xcc7a, 0x8187, 0x5780, 0x1a7d, 0xf39f, 0xbe62, 0x6865, 0x2598, 0xb3b0, 0xfe4d, 0x284a,
            0x65b7, 0x8c55, 0xc1a8, 0x17af, 0x5a52, 0x22b4, 0x6f49, 0xb94e, 0xf4b3, 0x1d51, 0x50ac,
            0x86ab, 0xcb56, 0x5d7e, 0x1083, 0xc684, 0x8b79, 0x629b, 0x2f66, 0xf961, 0xb49c, 0xdd20,
            0x90dd, 0x46da, 0x0b27, 0xe2c5, 0xaf38, 0x793f, 0x34c2, 0xa2ea, 0xef17, 0x3910, 0x74ed,
            0x9d0f, 0xd0f2, 0x06f5, 0x4b08, 0xd58d, 0x9870, 0x4e77, 0x038a, 0xea68, 0xa795, 0x7192,
            0x3c6f, 0xaa47, 0xe7ba, 0x31bd, 0x7c40, 0x95a2, 0xd85f, 0x0e58, 0x43a5, 0x2a19, 0x67e4,
            0xb1e3, 0xfc1e, 0x15fc, 0x5801, 0x8e06, 0xc3fb, 0x55d3, 0x182e, 0xce29, 0x83d4, 0x6a36,
            0x27cb, 0xf1cc, 0xbc31,
        ],
        [
            0x0000, 0x2c27, 0x584e, 0x7469, 0xb09c, 0x9cbb, 0xe8d2, 0xc4f5, 0x6929, 0x450e, 0x3167,
            0x1d40, 0xd9b5, 0xf592, 0x81fb, 0xaddc, 0xd252, 0xfe75, 0x8a1c, 0xa63b, 0x62ce, 0x4ee9,
            0x3a80, 0x16a7, 0xbb7b, 0x975c, 0xe335, 0xcf12, 0x0be7, 0x27c0, 0x53a9, 0x7f8e, 0xacb5,
            0x8092, 0xf4fb, 0xd8dc, 0x1c29, 0x300e, 0x4467, 0x6840, 0xc59c, 0xe9bb, 0x9dd2, 0xb1f5,
            0x7500, 0x5927, 0x2d4e, 0x0169, 0x7ee7, 0x52c0, 0x26a9, 0x0a8e, 0xce7b, 0xe25c, 0x9635,
            0xba12, 0x17ce, 0x3be9, 0x4f80, 0x63a7, 0xa752, 0x8b75, 0xff1c, 0xd33b, 0x517b, 0x7d5c,
            0x0935, 0x2512, 0xe1e7, 0xcdc0, 0xb9a9, 0x958e, 0x3852, 0x1475, 0x601c, 0x4c3b, 0x88ce,
            0xa4e9, 0xd080, 0xfca7, 0x8329, 0xaf0e, 0xdb67, 0xf740, 0x33b5, 0x1f92, 0x6bfb, 0x47dc,
            0xea00, 0xc627, 0xb24e, 0x9e69, 0x5a9c, 0x76bb, 0x02d2, 0x2ef5, 0xfdce, 0xd1e9, 0xa580,
            0x89a7, 0x4d52, 0x6175, 0x151c, 0x393b, 0x94e7, 0xb8c0, 0xcca9, 0xe08e, 0x247b, 0x085c,
            0x7c35, 0x5012, 0x2f9c, 0x03bb, 0x77d2, 0x5bf5, 0x9f00, 0xb327, 0xc74e, 0xeb69, 0x46b5,
            0x6a92, 0x1efb, 0x32dc, 0xf629, 0xda0e, 0xae67, 0x8240, 0xa2f6, 0x8ed1, 0xfab8, 0xd69f,
            0x126a, 0x3e4d, 0x4a24, 0x6603, 0xcbdf, 0xe7f8, 0x9391, 0xbfb6, 0x7b43, 0x5764, 0x230d,
            0x0f2a, 0x70a4, 0x5c83, 0x28ea, 0x04cd, 0xc038, 0xec1f, 0x9876, 0xb451, 0x198d, 0x35aa,
            0x41c3, 0x6de4, 0xa911, 0x8536, 0xf15f, 0xdd78, 0x0e43, 0x2264, 0x560d, 0x7a2a, 0xbedf,
            0x92f8, 0xe691, 0xcab6, 0x676a, 0x4b4d, 0x3f24, 0x1303, 0xd7f6, 0xfbd1, 0x8fb8, 0xa39f,
            0xdc11, 0xf036, 0x845f, 0xa878, 0x6c8d, 0x40aa, 0x34c3, 0x18e4, 0xb538, 0x991f, 0xed76,
            0xc151, 0x05a4, 0x2983, 0x5dea, 0x71cd, 0xf38d, 0xdfaa, 0xabc3, 0x87e4, 0x4311, 0x6f36,
            0x1b5f, 0x3778, 0x9aa4, 0xb683, 0xc2ea, 0xeecd, 0x2a38, 0x061f, 0x7276, 0x5e51, 0x21df,
            0x0df8, 0x7991, 0x55b6, 0x9143, 0xbd64, 0xc90d, 0xe52a, 0x48f6, 0x64d1, 0x10b8, 0x3c9f,
            0xf86a, 0xd44d, 0xa024, 0x8c03, 0x5f38, 0x731f, 0x0776, 0x2b51, 0xefa4, 0xc383, 0xb7ea,
            0x9bcd, 0x3611, 0x1a36, 0x6e5f, 0x4278, 0x868d, 0xaaaa, 0xdec3, 0xf2e4, 0x8d6a, 0xa14d,
            0xd524, 0xf903, 0x3df6, 0x11d1, 0x65b8, 0x499f, 0xe443, 0xc864, 0xbc0d, 0x902a, 0x54df,
            0x78f8, 0x0c91, 0x20b6,
        ],
        [
            0x0000, 0x5591, 0xab22, 0xfeb3, 0x5e55, 0x0bc4, 0xf577, 0xa0e6, 0xbcaa, 0xe93b, 0x1788,
            0x4219, 0xe2ff, 0xb76e, 0x49dd, 0x1c4c, 0x7145, 0x24d4, 0xda67, 0x8ff6, 0x2f10, 0x7a81,
            0x8432, 0xd1a3, 0xcdef, 0x987e, 0x66cd, 0x335c, 0x93ba, 0xc62b, 0x3898, 0x6d09, 0xe28a,
            0xb71b, 0x49a8, 0x1c39, 0xbcdf, 0xe94e, 0x17fd, 0x426c, 0x5e20, 0x0bb1, 0xf502, 0xa093,
            0x0075, 0x55e4, 0xab57, 0xfec6, 0x93cf, 0xc65e, 0x38ed, 0x6d7c, 0xcd9a, 0x980b, 0x66b8,
            0x3329, 0x2f65, 0x7af4, 0x8447, 0xd1d6, 0x7130, 0x24a1, 0xda12, 0x8f83, 0xcd05, 0x9894,
            0x6627, 0x33b6, 0x9350, 0xc6c1, 0x3872, 0x6de3, 0x71af, 0x243e, 0xda8d, 0x8f1c, 0x2ffa,
            0x7a6b, 0x84d8, 0xd149, 0xbc40, 0xe9d1, 0x1762, 0x42f3, 0xe215, 0xb784, 0x4937, 0x1ca6,
            0x00ea, 0x557b, 0xabc8, 0xfe59, 0x5ebf, 0x0b2e, 0xf59d, 0xa00c, 0x2f8f, 0x7a1e, 0x84ad,
            0xd13c, 0x71da, 0x244b, 0xdaf8, 0x8f69, 0x9325, 0xc6b4, 0x3807, 0x6d96, 0xcd70, 0x98e1,
            0x6652, 0x33c3, 0x5eca, 0x0b5b, 0xf5e8, 0xa079, 0x009f, 0x550e, 0xabbd, 0xfe2c, 0xe260,
            0xb7f1, 0x4942, 0x1cd3, 0xbc35, 0xe9a4, 0x1717, 0x4286, 0x921b, 0xc78a, 0x3939, 0x6ca8,
            0xcc4e, 0x99df, 0x676c, 0x32fd, 0x2eb1, 0x7b20, 0x8593, 0xd002, 0x70e4, 0x2575, 0xdbc6,
            0x8e57, 0xe35e, 0xb6cf, 0x487c, 0x1ded, 0xbd0b, 0xe89a, 0x1629, 0x43b8, 0x5ff4, 0x0a65,
            0xf4d6, 0xa147, 0x01a1, 0x5430, 0xaa83, 0xff12, 0x7091, 0x2500, 0xdbb3, 0x8e22, 0x2ec4,
            0x7b55, 0x85e6, 0xd077, 0xcc3b, 0x99aa, 0x6719, 0x3288, 0x926e, 0xc7ff, 0x394c, 0x6cdd,
            0x01d4, 0x5445, 0xaaf6, 0xff67, 0x5f81, 0x0a10, 0xf4a3, 0xa132, 0xbd7e, 0xe8ef, 0x165c,
            0x43cd, 0xe32b, 0xb6ba, 0x4809, 0x1d98, 0x5f1e, 0x0a8f, 0xf43c, 0xa1ad, 0x014b, 0x54da,
            0xaa69, 0xfff8, 0xe3b4, 0xb625, 0x4896, 0x1d07, 0xbde1, 0xe870, 0x16c3, 0x4352, 0x2e5b,
            0x7bca, 0x8579, 0xd0e8, 0x700e, 0x259f, 0xdb2c, 0x8ebd, 0x92f1, 0xc760, 0x39d3, 0x6c42,
            0xcca4, 0x9935, 0x6786, 0x3217, 0xbd94, 0xe805, 0x16b6, 0x4327, 0xe3c1, 0xb650, 0x48e3,
            0x1d72, 0x013e, 0x54af, 0xaa1c, 0xff8d, 0x5f6b, 0x0afa, 0xf449, 0xa1d8, 0xccd1, 0x9940,
            0x67f3, 0x3262, 0x9284, 0xc715, 0x39a6, 0x6c37, 0x707b, 0x25ea, 0xdb59, 0x8ec8, 0x2e2e,
            0x7bbf, 0x850c, 0xd09d,
        ],
        [
            0x0000, 0x8555, 0x02bb, 0x87ee, 0x0576, 0x8023, 0x07cd, 0x8298, 0x0aec, 0x8fb9, 0x0857,
            0x8d02, 0x0f9a, 0x8acf, 0x0d21, 0x8874, 0x15d8, 0x908d, 0x1763, 0x9236, 0x10ae, 0x95fb,
            0x1215, 0x9740, 0x1f34, 0x9a61, 0x1d8f, 0x98da, 0x1a42, 0x9f17, 0x18f9, 0x9dac, 0x2bb0,
            0xaee5, 0x290b, 0xac5e, 0x2ec6, 0xab93, 0x2c7d, 0xa928, 0x215c, 0xa409, 0x23e7, 0xa6b2,
            0x242a, 0xa17f, 0x2691, 0xa3c4, 0x3e68, 0xbb3d, 0x3cd3, 0xb986, 0x3b1e, 0xbe4b, 0x39a5,
            0xbcf0, 0x3484, 0xb1d1, 0x363f, 0xb36a, 0x31f2, 0xb4a7, 0x3349, 0xb61c, 0x5760, 0xd235,
            0x55db, 0xd08e, 0x5216, 0xd743, 0x50ad, 0xd5f8, 0x5d8c, 0xd8d9, 0x5f37, 0xda62, 0x58fa,
            0xddaf, 0x5a41, 0xdf14, 0x42b8, 0xc7ed, 0x4003, 0xc556, 0x47ce, 0xc29b, 0x4575, 0xc020,
            0x4854, 0xcd01, 0x4aef, 0xcfba, 0x4d22, 0xc877, 0x4f99, 0xcacc, 0x7cd0, 0xf985, 0x7e6b,
            0xfb3e, 0x79a6, 0xfcf3, 0x7b1d, 0xfe48, 0x763c, 0xf369, 0x7487, 0xf1d2, 0x734a, 0xf61f,
            0x71f1, 0xf4a4, 0x6908, 0xec5d, 0x6bb3, 0xeee6, 0x6c7e, 0xe92b, 0x6ec5, 0xeb90, 0x63e4,
            0xe6b1, 0x615f, 0xe40a, 0x6692, 0xe3c7, 0x6429, 0xe17c, 0xaec0, 0x2b95, 0xac7b, 0x292e,
            0xabb6, 0x2ee3, 0xa90d, 0x2c58, 0xa42c, 0x2179, 0xa697, 0x23c2, 0xa15a, 0x240f, 0xa3e1,
            0x26b4, 0xbb18, 0x3e4d, 0xb9a3, 0x3cf6, 0xbe6e, 0x3b3b, 0xbcd5, 0x3980, 0xb1f4, 0x34a1,
            0xb34f, 0x361a, 0xb482, 0x31d7, 0xb639, 0x336c, 0x8570, 0x0025, 0x87cb, 0x029e, 0x8006,
            0x0553, 0x82bd, 0x07e8, 0x8f9c, 0x0ac9, 0x8d27, 0x0872, 0x8aea, 0x0fbf, 0x8851, 0x0d04,
            0x90a8, 0x15fd, 0x9213, 0x1746, 0x95de, 0x108b, 0x9765, 0x1230, 0x9a44, 0x1f11, 0x98ff,
            0x1daa, 0x9f32, 0x1a67, 0x9d89, 0x18dc, 0xf9a0, 0x7cf5, 0xfb1b, 0x7e4e, 0xfcd6, 0x7983,
            0xfe6d, 0x7b38, 0xf34c, 0x7619, 0xf1f7, 0x74a2, 0xf63a, 0x736f, 0xf481, 0x71d4, 0xec78,
            0x692d, 0xeec3, 0x6b96, 0xe90e, 0x6c5b, 0xebb5, 0x6ee0, 0xe694, 0x63c1, 0xe42f, 0x617a,
            0xe3e2, 0x66b7, 0xe159, 0x640c, 0xd210, 0x5745, 0xd0ab, 0x55fe, 0xd766, 0x5233, 0xd5dd,
            0x5088, 0xd8fc, 0x5da9, 0xda47, 0x5f12, 0xdd8a, 0x58df, 0xdf31, 0x5a64, 0xc7c8, 0x429d,
            0xc573, 0x4026, 0xc2be, 0x47eb, 0xc005, 0x4550, 0xcd24, 0x4871, 0xcf9f, 0x4aca, 0xc852,
            0x4d07, 0xcae9, 0x4fbc,
        ],
        [
            0x0000, 0x05ad, 0x0b5a, 0x0ef7, 0x16b4, 0x1319, 0x1dee, 0x1843, 0x2d68, 0x28c5, 0x2632,
            0x239f, 0x3bdc, 0x3e71, 0x3086, 0x352b, 0x5ad0, 0x5f7d, 0x518a, 0x5427, 0x4c64, 0x49c9,
            0x473e, 0x4293, 0x77b8, 0x7215, 0x7ce2, 0x794f, 0x610c, 0x64a1, 0x6a56, 0x6ffb, 0xb5a0,
            0xb00d, 0xbefa, 0xbb57, 0xa314, 0xa6b9, 0xa84e, 0xade3, 0x98c8, 0x9d65, 0x9392, 0x963f,
            0x8e7c, 0x8bd1, 0x8526, 0x808b, 0xef70, 0xeadd, 0xe42a, 0xe187, 0xf9c4, 0xfc69, 0xf29e,
            0xf733, 0xc218, 0xc7b5, 0xc942, 0xccef, 0xd4ac, 0xd101, 0xdff6, 0xda5b, 0x6351, 0x66fc,
            0x680b, 0x6da6, 0x75e5, 0x7048, 0x7ebf, 0x7b12, 0x4e39, 0x4b94, 0x4563, 0x40ce, 0x588d,
            0x5d20, 0x53d7, 0x567a, 0x3981, 0x3c2c, 0x32db, 0x3776, 0x2f35, 0x2a98, 0x246f, 0x21c2,
            0x14e9, 0x1144, 0x1fb3, 0x1a1e, 0x025d, 0x07f0, 0x0907, 0x0caa, 0xd6f1, 0xd35c, 0xddab,
            0xd806, 0xc045, 0xc5e8, 0xcb1f, 0xceb2, 0xfb99, 0xfe34, 0xf0c3, 0xf56e, 0xed2d, 0xe880,
            0xe677, 0xe3da, 0x8c21, 0x898c, 0x877b, 0x82d6, 0x9a95, 0x9f38, 0x91cf, 0x9462, 0xa149,
            0xa4e4, 0xaa13, 0xafbe, 0xb7fd, 0xb250, 0xbca7, 0xb90a, 0xc6a2, 0xc30f, 0xcdf8, 0xc855,
            0xd016, 0xd5bb, 0xdb4c, 0xdee1, 0xebca, 0xee67, 0xe090, 0xe53d, 0xfd7e, 0xf8d3, 0xf624,
            0xf389, 0x9c72, 0x99df, 0x9728, 0x9285, 0x8ac6, 0x8f6b, 0x819c, 0x8431, 0xb11a, 0xb4b7,
            0xba40, 0xbfed, 0xa7ae, 0xa203, 0xacf4, 0xa959, 0x7302, 0x76af, 0x7858, 0x7df5, 0x65b6,
            0x601b, 0x6eec, 0x6b41, 0x5e6a, 0x5bc7, 0x5530, 0x509d, 0x48de, 0x4d73, 0x4384, 0x4629,
            0x29d2, 0x2c7f, 0x2288, 0x2725, 0x3f66, 0x3acb, 0x343c, 0x3191, 0x04ba, 0x0117, 0x0fe0,
            0x0a4d, 0x120e, 0x17a3, 0x1954, 0x1cf9, 0xa5f3, 0xa05e, 0xaea9, 0xab04, 0xb347, 0xb6ea,
            0xb81d, 0xbdb0, 0x889b, 0x8d36, 0x83c1, 0x866c, 0x9e2f, 0x9b82, 0x9575, 0x90d8, 0xff23,
            0xfa8e, 0xf479, 0xf1d4, 0xe997, 0xec3a, 0xe2cd, 0xe760, 0xd24b, 0xd7e6, 0xd911, 0xdcbc,
            0xc4ff, 0xc152, 0xcfa5, 0xca08, 0x1053, 0x15fe, 0x1b09, 0x1ea4, 0x06e7, 0x034a, 0x0dbd,
            0x0810, 0x3d3b, 0x3896, 0x3661, 0x33cc, 0x2b8f, 0x2e22, 0x20d5, 0x2578, 0x4a83, 0x4f2e,
            0x41d9, 0x4474, 0x5c37, 0x599a, 0x576d, 0x52c0, 0x67eb, 0x6246, 0x6cb1, 0x691c, 0x715f,
            0x74f2, 0x7a05, 0x7fa8,
        ],
        [
            0x0000, 0x7eea, 0xfdd4, 0x833e, 0xf3b9, 0x8d53, 0x0e6d, 0x7087, 0xef63, 0x9189, 0x12b7,
            0x6c5d, 0x1cda, 0x6230, 0xe10e, 0x9fe4, 0xd6d7, 0xa83d, 0x2b03, 0x55e9, 0x256e, 0x5b84,
            0xd8ba, 0xa650, 0x39b4, 0x475e, 0xc460, 0xba8a, 0xca0d, 0xb4e7, 0x37d9, 0x4933, 0xa5bf,
            0xdb55, 0x586b, 0x2681, 0x5606, 0x28ec, 0xabd2, 0xd538, 0x4adc, 0x3436, 0xb708, 0xc9e2,
            0xb965, 0xc78f, 0x44b1, 0x3a5b, 0x7368, 0x0d82, 0x8ebc, 0xf056, 0x80d1, 0xfe3b, 0x7d05,
            0x03ef, 0x9c0b, 0xe2e1, 0x61df, 0x1f35, 0x6fb2, 0x1158, 0x9266, 0xec8c, 0x436f, 0x3d85,
            0xbebb, 0xc051, 0xb0d6, 0xce3c, 0x4d02, 0x33e8, 0xac0c, 0xd2e6, 0x51d8, 0x2f32, 0x5fb5,
            0x215f, 0xa261, 0xdc8b, 0x95b8, 0xeb52, 0x686c, 0x1686, 0x6601, 0x18eb, 0x9bd5, 0xe53f,
            0x7adb, 0x0431, 0x870f, 0xf9e5, 0x8962, 0xf788, 0x74b6, 0x0a5c, 0xe6d0, 0x983a, 0x1b04,
            0x65ee, 0x1569, 0x6b83, 0xe8bd, 0x9657, 0x09b3, 0x7759, 0xf467, 0x8a8d, 0xfa0a, 0x84e0,
            0x07de, 0x7934, 0x3007, 0x4eed, 0xcdd3, 0xb339, 0xc3be, 0xbd54, 0x3e6a, 0x4080, 0xdf64,
            0xa18e, 0x22b0, 0x5c5a, 0x2cdd, 0x5237, 0xd109, 0xafe3, 0x86de, 0xf834, 0x7b0a, 0x05e0,
            0x7567, 0x0b8d, 0x88b3, 0xf659, 0x69bd, 0x1757, 0x9469, 0xea83, 0x9a04, 0xe4ee, 0x67d0,
            0x193a, 0x5009, 0x2ee3, 0xaddd, 0xd337, 0xa3b0, 0xdd5a, 0x5e64, 0x208e, 0xbf6a, 0xc180,
            0x42be, 0x3c54, 0x4cd3, 0x3239, 0xb107, 0xcfed, 0x2361, 0x5d8b, 0xdeb5, 0xa05f, 0xd0d8,
            0xae32, 0x2d0c, 0x53e6, 0xcc02, 0xb2e8, 0x31d6, 0x4f3c, 0x3fbb, 0x4151, 0xc26f, 0xbc85,
            0xf5b6, 0x8b5c, 0x0862, 0x7688, 0x060f, 0x78e5, 0xfbdb, 0x8531, 0x1ad5, 0x643f, 0xe701,
            0x99eb, 0xe96c, 0x9786, 0x14b8, 0x6a52, 0xc5b1, 0xbb5b, 0x3865, 0x468f, 0x3608, 0x48e2,
            0xcbdc, 0xb536, 0x2ad2, 0x5438, 0xd706, 0xa9ec, 0xd96b, 0xa781, 0x24bf, 0x5a55, 0x1366,
            0x6d8c, 0xeeb2, 0x9058, 0xe0df, 0x9e35, 0x1d0b, 0x63e1, 0xfc05, 0x82ef, 0x01d1, 0x7f3b,
            0x0fbc, 0x7156, 0xf268, 0x8c82, 0x600e, 0x1ee4, 0x9dda, 0xe330, 0x93b7, 0xed5d, 0x6e63,
            0x1089, 0x8f6d, 0xf187, 0x72b9, 0x0c53, 0x7cd4, 0x023e, 0x8100, 0xffea, 0xb6d9, 0xc833,
            0x4b0d, 0x35e7, 0x4560, 0x3b8a, 0xb8b4, 0xc65e, 0x59ba, 0x2750, 0xa46e, 0xda84, 0xaa03,
            0xd4e9, 0x57d7, 0x293d,
        ],
        [
            0x0000, 0x482a, 0x9054, 0xd87e, 0x28b9, 0x6093, 0xb8ed, 0xf0c7, 0x5172, 0x1958, 0xc126,
            0x890c, 0x79cb, 0x31e1, 0xe99f, 0xa1b5, 0xa2e4, 0xeace, 0x32b0, 0x7a9a, 0x8a5d, 0xc277,
            0x1a09, 0x5223, 0xf396, 0xbbbc, 0x63c2, 0x2be8, 0xdb2f, 0x9305, 0x4b7b, 0x0351, 0x4dd9,
            0x05f3, 0xdd8d, 0x95a7, 0x6560, 0x2d4a, 0xf534, 0xbd1e, 0x1cab, 0x5481, 0x8cff, 0xc4d5,
            0x3412, 0x7c38, 0xa446, 0xec6c, 0xef3d, 0xa717, 0x7f69, 0x3743, 0xc784, 0x8fae, 0x57d0,
            0x1ffa, 0xbe4f, 0xf665, 0x2e1b, 0x6631, 0x96f6, 0xdedc, 0x06a2, 0x4e88, 0x9bb2, 0xd398,
            0x0be6, 0x43cc, 0xb30b, 0xfb21, 0x235f, 0x6b75, 0xcac0, 0x82ea, 0x5a94, 0x12be, 0xe279,
            0xaa53, 0x722d, 0x3a07, 0x3956, 0x717c, 0xa902, 0xe128, 0x11ef, 0x59c5, 0x81bb, 0xc991,
            0x6824, 0x200e, 0xf870, 0xb05a, 0x409d, 0x08b7, 0xd0c9, 0x98e3, 0xd66b, 0x9e41, 0x463f,
            0x0e15, 0xfed2, 0xb6f8, 0x6e86, 0x26ac, 0x8719, 0xcf33, 0x174d, 0x5f67, 0xafa0, 0xe78a,
            0x3ff4, 0x77de, 0x748f, 0x3ca5, 0xe4db, 0xacf1, 0x5c36, 0x141c, 0xcc62, 0x8448, 0x25fd,
            0x6dd7, 0xb5a9, 0xfd83, 0x0d44, 0x456e, 0x9d10, 0xd53a, 0x3f75, 0x775f, 0xaf21, 0xe70b,
            0x17cc, 0x5fe6, 0x8798, 0xcfb2, 0x6e07, 0x262d, 0xfe53, 0xb679, 0x46be, 0x0e94, 0xd6ea,
            0x9ec0, 0x9d91, 0xd5bb, 0x0dc5, 0x45ef, 0xb528, 0xfd02, 0x257c, 0x6d56, 0xcce3, 0x84c9,
            0x5cb7, 0x149d, 0xe45a, 0xac70, 0x740e, 0x3c24, 0x72ac, 0x3a86, 0xe2f8, 0xaad2, 0x5a15,
            0x123f, 0xca41, 0x826b, 0x23de, 0x6bf4, 0xb38a, 0xfba0, 0x0b67, 0x434d, 0x9b33, 0xd319,
            0xd048, 0x9862, 0x401c, 0x0836, 0xf8f1, 0xb0db, 0x68a5, 0x208f, 0x813a, 0xc910, 0x116e,
            0x5944, 0xa983, 0xe1a9, 0x39d7, 0x71fd, 0xa4c7, 0xeced, 0x3493, 0x7cb9, 0x8c7e, 0xc454,
            0x1c2a, 0x5400, 0xf5b5, 0xbd9f, 0x65e1, 0x2dcb, 0xdd0c, 0x9526, 0x4d58, 0x0572, 0x0623,
            0x4e09, 0x9677, 0xde5d, 0x2e9a, 0x66b0, 0xbece, 0xf6e4, 0x5751, 0x1f7b, 0xc705, 0x8f2f,
            0x7fe8, 0x37c2, 0xefbc, 0xa796, 0xe91e, 0xa134, 0x794a, 0x3160, 0xc1a7, 0x898d, 0x51f3,
            0x19d9, 0xb86c, 0xf046, 0x2838, 0x6012, 0x90d5, 0xd8ff, 0x0081, 0x48ab, 0x4bfa, 0x03d0,
            0xdbae, 0x9384, 0x6343, 0x2b69, 0xf317, 0xbb3d, 0x1a88, 0x52a2, 0x8adc, 0xc2f6, 0x3231,
            0x7a1b, 0xa265, 0xea4f,
        ],
        [
            0x0000, 0x8e10, 0x1431, 0x9a21, 0x2862, 0xa672, 0x3c53, 0xb243, 0x50c4, 0xded4, 0x44f5,
            0xcae5, 0x78a6, 0xf6b6, 0x6c97, 0xe287, 0xa188, 0x2f98, 0xb5b9, 0x3ba9, 0x89ea, 0x07fa,
            0x9ddb, 0x13cb, 0xf14c, 0x7f5c, 0xe57d, 0x6b6d, 0xd92e, 0x573e, 0xcd1f, 0x430f, 0x4b01,
            0xc511, 0x5f30, 0xd120, 0x6363, 0xed73, 0x7752, 0xf942, 0x1bc5, 0x95d5, 0x0ff4, 0x81e4,
            0x33a7, 0xbdb7, 0x2796, 0xa986, 0xea89, 0x6499, 0xfeb8, 0x70a8, 0xc2eb, 0x4cfb, 0xd6da,
            0x58ca, 0xba4d, 0x345d, 0xae7c, 0x206c, 0x922f, 0x1c3f, 0x861e, 0x080e, 0x9602, 0x1812,
            0x8233, 0x0c23, 0xbe60, 0x3070, 0xaa51, 0x2441, 0xc6c6, 0x48d6, 0xd2f7, 0x5ce7, 0xeea4,
            0x60b4, 0xfa95, 0x7485, 0x378a, 0xb99a, 0x23bb, 0xadab, 0x1fe8, 0x91f8, 0x0bd9, 0x85c9,
            0x674e, 0xe95e, 0x737f, 0xfd6f, 0x4f2c, 0xc13c, 0x5b1d, 0xd50d, 0xdd03, 0x5313, 0xc932,
            0x4722, 0xf561, 0x7b71, 0xe150, 0x6f40, 0x8dc7, 0x03d7, 0x99f6, 0x17e6, 0xa5a5, 0x2bb5,
            0xb194, 0x3f84, 0x7c8b, 0xf29b, 0x68ba, 0xe6aa, 0x54e9, 0xdaf9, 0x40d8, 0xcec8, 0x2c4f,
            0xa25f, 0x387e, 0xb66e, 0x042d, 0x8a3d, 0x101c, 0x9e0c, 0x2415, 0xaa05, 0x3024, 0xbe34,
            0x0c77, 0x8267, 0x1846, 0x9656, 0x74d1, 0xfac1, 0x60e0, 0xeef0, 0x5cb3, 0xd2a3, 0x4882,
            0xc692, 0x859d, 0x0b8d, 0x91ac, 0x1fbc, 0xadff, 0x23ef, 0xb9ce, 0x37de, 0xd559, 0x5b49,
            0xc168, 0x4f78, 0xfd3b, 0x732b, 0xe90a, 0x671a, 0x6f14, 0xe104, 0x7b25, 0xf535, 0x4776,
            0xc966, 0x5347, 0xdd57, 0x3fd0, 0xb1c0, 0x2be1, 0xa5f1, 0x17b2, 0x99a2, 0x0383, 0x8d93,
            0xce9c, 0x408c, 0xdaad, 0x54bd, 0xe6fe, 0x68ee, 0xf2cf, 0x7cdf, 0x9e58, 0x1048, 0x8a69,
            0x0479, 0xb63a, 0x382a, 0xa20b, 0x2c1b, 0xb217, 0x3c07, 0xa626, 0x2836, 0x9a75, 0x1465,
            0x8e44, 0x0054, 0xe2d3, 0x6cc3, 0xf6e2, 0x78f2, 0xcab1, 0x44a1, 0xde80, 0x5090, 0x139f,
            0x9d8f, 0x07ae, 0x89be, 0x3bfd, 0xb5ed, 0x2fcc, 0xa1dc, 0x435b, 0xcd4b, 0x576a, 0xd97a,
            0x6b39, 0xe529, 0x7f08, 0xf118, 0xf916, 0x7706, 0xed27, 0x6337, 0xd174, 0x5f64, 0xc545,
            0x4b55, 0xa9d2, 0x27c2, 0xbde3, 0x33f3, 0x81b0, 0x0fa0, 0x9581, 0x1b91, 0x589e, 0xd68e,
            0x4caf, 0xc2bf, 0x70fc, 0xfeec, 0x64cd, 0xeadd, 0x085a, 0x864a, 0x1c6b, 0x927b, 0x2038,
            0xae28, 0x3409, 0xba19,
        ],
    ];

    pub static CRC16_MODBUS_TABLE: [[u16; 256]; 16] = [
        [
            0x0000, 0xc0c1, 0xc181, 0x0140, 0xc301, 0x03c0, 0x0280, 0xc241, 0xc601, 0x06c0, 0x0780,
            0xc741, 0x0500, 0xc5c1, 0xc481, 0x0440, 0xcc01, 0x0cc0, 0x0d80, 0xcd41, 0x0f00, 0xcfc1,
            0xce81, 0x0e40, 0x0a00, 0xcac1, 0xcb81, 0x0b40, 0xc901, 0x09c0, 0x0880, 0xc841, 0xd801,
            0x18c0, 0x1980, 0xd941, 0x1b00, 0xdbc1, 0xda81, 0x1a40, 0x1e00, 0xdec1, 0xdf81, 0x1f40,
            0xdd01, 0x1dc0, 0x1c80, 0xdc41, 0x1400, 0xd4c1, 0xd581, 0x1540, 0xd701, 0x17c0, 0x1680,
            0xd641, 0xd201, 0x12c0, 0x1380, 0xd341, 0x1100, 0xd1c1, 0xd081, 0x1040, 0xf001, 0x30c0,
            0x3180, 0xf141, 0x3300, 0xf3c1, 0xf281, 0x3240, 0x3600, 0xf6c1, 0xf781, 0x3740, 0xf501,
            0x35c0, 0x3480, 0xf441, 0x3c00, 0xfcc1, 0xfd81, 0x3d40, 0xff01, 0x3fc0, 0x3e80, 0xfe41,
            0xfa01, 0x3ac0, 0x3b80, 0xfb41, 0x3900, 0xf9c1, 0xf881, 0x3840, 0x2800, 0xe8c1, 0xe981,
            0x2940, 0xeb01, 0x2bc0, 0x2a80, 0xea41, 0xee01, 0x2ec0, 0x2f80, 0xef41, 0x2d00, 0xedc1,
            0xec81, 0x2c40, 0xe401, 0x24c0, 0x2580, 0xe541, 0x2700, 0xe7c1, 0xe681, 0x2640, 0x2200,
            0xe2c1, 0xe381, 0x2340, 0xe101, 0x21c0, 0x2080, 0xe041, 0xa001, 0x60c0, 0x6180, 0xa141,
            0x6300, 0xa3c1, 0xa281, 0x6240, 0x6600, 0xa6c1, 0xa781, 0x6740, 0xa501, 0x65c0, 0x6480,
            0xa441, 0x6c00, 0xacc1, 0xad81, 0x6d40, 0xaf01, 0x6fc0, 0x6e80, 0xae41, 0xaa01, 0x6ac0,
            0x6b80, 0xab41, 0x6900, 0xa9c1, 0xa881, 0x6840, 0x7800, 0xb8c1, 0xb981, 0x7940, 0xbb01,
            0x7bc0, 0x7a80, 0xba41, 0xbe01, 0x7ec0, 0x7f80, 0xbf41, 0x7d00, 0xbdc1, 0xbc81, 0x7c40,
            0xb401, 0x74c0, 0x7580, 0xb541, 0x7700, 0xb7c1, 0xb681, 0x7640, 0x7200, 0xb2c1, 0xb381,
            0x7340, 0xb101, 0x71c0, 0x7080, 0xb041, 0x5000, 0x90c1, 0x9181, 0x5140, 0x9301, 0x53c0,
            0x5280, 0x9241, 0x9601, 0x56c0, 0x5780, 0x9741, 0x5500, 0x95c1, 0x9481, 0x5440, 0x9c01,
            0x5cc0, 0x5d80, 0x9d41, 0x5f00, 0x9fc1, 0x9e81, 0x5e40, 0x5a00, 0x9ac1, 0x9b81, 0x5b40,
            0x9901, 0x59c0, 0x5880, 0x9841, 0x8801, 0x48c0, 0x4980, 0x8941, 0x4b00, 0x8bc1, 0x8a81,
            0x4a40, 0x4e00, 0x8ec1, 0x8f81, 0x4f40, 0x8d01, 0x4dc0, 0x4c80, 0x8c41, 0x4400, 0x84c1,
            0x8581, 0x4540, 0x8701, 0x47c0, 0x4680, 0x8641, 0x8201, 0x42c0, 0x4380, 0x8341, 0x4100,
            0x81c1, 0x8081, 0x4040,
        ],
        [
            0x0000, 0x9001, 0x6001, 0xf000, 0xc002, 0x5003, 0xa003, 0x3002, 0xc007, 0x5006, 0xa006,
            0x3007, 0x0005, 0x9004, 0x6004, 0xf005, 0xc00d, 0x500c, 0xa00c, 0x300d, 0x000f, 0x900e,
            0x600e, 0xf00f, 0x000a, 0x900b, 0x600b, 0xf00a, 0xc008, 0x5009, 0xa009, 0x3008, 0xc019,
            0x5018, 0xa018, 0x3019, 0x001b, 0x901a, 0x601a, 0xf01b, 0x001e, 0x901f, 0x601f, 0xf01e,
            0xc01c, 0x501d, 0xa01d, 0x301c, 0x0014, 0x9015, 0x6015, 0xf014, 0xc016, 0x5017, 0xa017,
            0x3016, 0xc013, 0x5012, 0xa012, 0x3013, 0x0011, 0x9010, 0x6010, 0xf011, 0xc031, 0x5030,
            0xa030, 0x3031, 0x0033, 0x9032, 0x6032, 0xf033, 0x0036, 0x9037, 0x6037, 0xf036, 0xc034,
            0x5035, 0xa035, 0x3034, 0x003c, 0x903d, 0x603d, 0xf03c, 0xc03e, 0x503f, 0xa03f, 0x303e,
            0xc03b, 0x503a, 0xa03a, 0x303b, 0x0039, 0x9038, 0x6038, 0xf039, 0x0028, 0x9029, 0x6029,
            0xf028, 0xc02a, 0x502b, 0xa02b, 0x302a, 0xc02f, 0x502e, 0xa02e, 0x302f, 0x002d, 0x902c,
            0x602c, 0xf02d, 0xc025, 0x5024, 0xa024, 0x3025, 0x0027, 0x9026, 0x6026, 0xf027, 0x0022,
            0x9023, 0x6023, 0xf022, 0xc020, 0x5021, 0xa021, 0x3020, 0xc061, 0x5060, 0xa060, 0x3061,
            0x0063, 0x9062, 0x6062, 0xf063, 0x0066, 0x9067, 0x6067, 0xf066, 0xc064, 0x5065, 0xa065,
            0x3064, 0x006c, 0x906d, 0x606d, 0xf06c, 0xc06e, 0x506f, 0xa06f, 0x306e, 0xc06b, 0x506a,
            0xa06a, 0x306b, 0x0069, 0x9068, 0x6068, 0xf069, 0x0078, 0x9079, 0x6079, 0xf078, 0xc07a,
            0x507b, 0xa07b, 0x307a, 0xc07f, 0x507e, 0xa07e, 0x307f, 0x007d, 0x907c, 0x607c, 0xf07d,
            0xc075, 0x5074, 0xa074, 0x3075, 0x0077, 0x9076, 0x6076, 0xf077, 0x0072, 0x9073, 0x6073,
            0xf072, 0xc070, 0x5071, 0xa071, 0x3070, 0x0050, 0x9051, 0x6051, 0xf050, 0xc052, 0x5053,
            0xa053, 0x3052, 0xc057, 0x5056, 0xa056, 0x3057, 0x0055, 0x9054, 0x6054, 0xf055, 0xc05d,
            0x505c, 0xa05c, 0x305d, 0x005f, 0x905e, 0x605e, 0xf05f, 0x005a, 0x905b, 0x605b, 0xf05a,
            0xc058, 0x5059, 0xa059, 0x3058, 0xc049, 0x5048, 0xa048, 0x3049, 0x004b, 0x904a, 0x604a,
            0xf04b, 0x004e, 0x904f, 0x604f, 0xf04e, 0xc04c, 0x504d, 0xa04d, 0x304c, 0x0044, 0x9045,
            0x6045, 0xf044, 0xc046, 0x5047, 0xa047, 0x3046, 0xc043, 0x5042, 0xa042, 0x3043, 0x0041,
            0x9040, 0x6040, 0xf041,
        ],
        [
            0x0000, 0xc051, 0xc0a1, 0x00f0, 0xc141, 0x0110, 0x01e0, 0xc1b1, 0xc281, 0x02d0, 0x0220,
            0xc271, 0x03c0, 0xc391, 0xc361, 0x0330, 0xc501, 0x0550, 0x05a0, 0xc5f1, 0x0440, 0xc411,
            0xc4e1, 0x04b0, 0x0780, 0xc7d1, 0xc721, 0x0770, 0xc6c1, 0x0690, 0x0660, 0xc631, 0xca01,
            0x0a50, 0x0aa0, 0xcaf1, 0x0b40, 0xcb11, 0xcbe1, 0x0bb0, 0x0880, 0xc8d1, 0xc821, 0x0870,
            0xc9c1, 0x0990, 0x0960, 0xc931, 0x0f00, 0xcf51, 0xcfa1, 0x0ff0, 0xce41, 0x0e10, 0x0ee0,
            0xceb1, 0xcd81, 0x0dd0, 0x0d20, 0xcd71, 0x0cc0, 0xcc91, 0xcc61, 0x0c30, 0xd401, 0x1450,
            0x14a0, 0xd4f1, 0x1540, 0xd511, 0xd5e1, 0x15b0, 0x1680, 0xd6d1, 0xd621, 0x1670, 0xd7c1,
            0x1790, 0x1760, 0xd731, 0x1100, 0xd151, 0xd1a1, 0x11f0, 0xd041, 0x1010, 0x10e0, 0xd0b1,
            0xd381, 0x13d0, 0x1320, 0xd371, 0x12c0, 0xd291, 0xd261, 0x1230, 0x1e00, 0xde51, 0xdea1,
            0x1ef0, 0xdf41, 0x1f10, 0x1fe0, 0xdfb1, 0xdc81, 0x1cd0, 0x1c20, 0xdc71, 0x1dc0, 0xdd91,
            0xdd61, 0x1d30, 0xdb01, 0x1b50, 0x1ba0, 0xdbf1, 0x1a40, 0xda11, 0xdae1, 0x1ab0, 0x1980,
            0xd9d1, 0xd921, 0x1970, 0xd8c1, 0x1890, 0x1860, 0xd831, 0xe801, 0x2850, 0x28a0, 0xe8f1,
            0x2940, 0xe911, 0xe9e1, 0x29b0, 0x2a80, 0xead1, 0xea21, 0x2a70, 0xebc1, 0x2b90, 0x2b60,
            0xeb31, 0x2d00, 0xed51, 0xeda1, 0x2df0, 0xec41, 0x2c10, 0x2ce0, 0xecb1, 0xef81, 0x2fd0,
            0x2f20, 0xef71, 0x2ec0, 0xee91, 0xee61, 0x2e30, 0x2200, 0xe251, 0xe2a1, 0x22f0, 0xe341,
            0x2310, 0x23e0, 0xe3b1, 0xe081, 0x20d0, 0x2020, 0xe071, 0x21c0, 0xe191, 0xe161, 0x2130,
            0xe701, 0x2750, 0x27a0, 0xe7f1, 0x2640, 0xe611, 0xe6e1, 0x26b0, 0x2580, 0xe5d1, 0xe521,
            0x2570, 0xe4c1, 0x2490, 0x2460, 0xe431, 0x3c00, 0xfc51, 0xfca1, 0x3cf0, 0xfd41, 0x3d10,
            0x3de0, 0xfdb1, 0xfe81, 0x3ed0, 0x3e20, 0xfe71, 0x3fc0, 0xff91, 0xff61, 0x3f30, 0xf901,
            0x3950, 0x39a0, 0xf9f1, 0x3840, 0xf811, 0xf8e1, 0x38b0, 0x3b80, 0xfbd1, 0xfb21, 0x3b70,
            0xfac1, 0x3a90, 0x3a60, 0xfa31, 0xf601, 0x3650, 0x36a0, 0xf6f1, 0x3740, 0xf711, 0xf7e1,
            0x37b0, 0x3480, 0xf4d1, 0xf421, 0x3470, 0xf5c1, 0x3590, 0x3560, 0xf531, 0x3300, 0xf351,
            0xf3a1, 0x33f0, 0xf241, 0x3210, 0x32e0, 0xf2b1, 0xf181, 0x31d0, 0x3120, 0xf171, 0x30c0,
            0xf091, 0xf061, 0x3030,
        ],
        [
            0x0000, 0xfc01, 0xb801, 0x4400, 0x3001, 0xcc00, 0x8800, 0x7401, 0x6002, 0x9c03, 0xd803,
            0x2402, 0x5003, 0xac02, 0xe802, 0x1403, 0xc004, 0x3c05, 0x7805, 0x8404, 0xf005, 0x0c04,
            0x4804, 0xb405, 0xa006, 0x5c07, 0x1807, 0xe406, 0x9007, 0x6c06, 0x2806, 0xd407, 0xc00b,
            0x3c0a, 0x780a, 0x840b, 0xf00a, 0x0c0b, 0x480b, 0xb40a, 0xa009, 0x5c08, 0x1808, 0xe409,
            0x9008, 0x6c09, 0x2809, 0xd408, 0x000f, 0xfc0e, 0xb80e, 0x440f, 0x300e, 0xcc0f, 0x880f,
            0x740e, 0x600d, 0x9c0c, 0xd80c, 0x240d, 0x500c, 0xac0d, 0xe80d, 0x140c, 0xc015, 0x3c14,
            0x7814, 0x8415, 0xf014, 0x0c15, 0x4815, 0xb414, 0xa017, 0x5c16, 0x1816, 0xe417, 0x9016,
            0x6c17, 0x2817, 0xd416, 0x0011, 0xfc10, 0xb810, 0x4411, 0x3010, 0xcc11, 0x8811, 0x7410,
            0x6013, 0x9c12, 0xd812, 0x2413, 0x5012, 0xac13, 0xe813, 0x1412, 0x001e, 0xfc1f, 0xb81f,
            0x441e, 0x301f, 0xcc1e, 0x881e, 0x741f, 0x601c, 0x9c1d, 0xd81d, 0x241c, 0x501d, 0xac1c,
            0xe81c, 0x141d, 0xc01a, 0x3c1b, 0x781b, 0x841a, 0xf01b, 0x0c1a, 0x481a, 0xb41b, 0xa018,
            0x5c19, 0x1819, 0xe418, 0x9019, 0x6c18, 0x2818, 0xd419, 0xc029, 0x3c28, 0x7828, 0x8429,
            0xf028, 0x0c29, 0x4829, 0xb428, 0xa02b, 0x5c2a, 0x182a, 0xe42b, 0x902a, 0x6c2b, 0x282b,
            0xd42a, 0x002d, 0xfc2c, 0xb82c, 0x442d, 0x302c, 0xcc2d, 0x882d, 0x742c, 0x602f, 0x9c2e,
            0xd82e, 0x242f, 0x502e, 0xac2f, 0xe82f, 0x142e, 0x0022, 0xfc23, 0xb823, 0x4422, 0x3023,
            0xcc22, 0x8822, 0x7423, 0x6020, 0x9c21, 0xd821, 0x2420, 0x5021, 0xac20, 0xe820, 0x1421,
            0xc026, 0x3c27, 0x7827, 0x8426, 0xf027, 0x0c26, 0x4826, 0xb427, 0xa024, 0x5c25, 0x1825,
            0xe424, 0x9025, 0x6c24, 0x2824, 0xd425, 0x003c, 0xfc3d, 0xb83d, 0x443c, 0x303d, 0xcc3c,
            0x883c, 0x743d, 0x603e, 0x9c3f, 0xd83f, 0x243e, 0x503f, 0xac3e, 0xe83e, 0x143f, 0xc038,
            0x3c39, 0x7839, 0x8438, 0xf039, 0x0c38, 0x4838, 0xb439, 0xa03a, 0x5c3b, 0x183b, 0xe43a,
            0x903b, 0x6c3a, 0x283a, 0xd43b, 0xc037, 0x3c36, 0x7836, 0x8437, 0xf036, 0x0c37, 0x4837,
            0xb436, 0xa035, 0x5c34, 0x1834, 0xe435, 0x9034, 0x6c35, 0x2835, 0xd434, 0x0033, 0xfc32,
            0xb832, 0x4433, 0x3032, 0xcc33, 0x8833, 0x7432, 0x6031, 0x9c30, 0xd830, 0x2431, 0x5030,
            0xac31, 0xe831, 0x1430,
        ],
        [
            0x0000, 0xc03d, 0xc079, 0x0044, 0xc0f1, 0x00cc, 0x0088, 0xc0b5, 0xc1e1, 0x01dc, 0x0198,
            0xc1a5, 0x0110, 0xc12d, 0xc169, 0x0154, 0xc3c1, 0x03fc, 0x03b8, 0xc385, 0x0330, 0xc30d,
            0xc349, 0x0374, 0x0220, 0xc21d, 0xc259, 0x0264, 0xc2d1, 0x02ec, 0x02a8, 0xc295, 0xc781,
            0x07bc, 0x07f8, 0xc7c5, 0x0770, 0xc74d, 0xc709, 0x0734, 0x0660, 0xc65d, 0xc619, 0x0624,
            0xc691, 0x06ac, 0x06e8, 0xc6d5, 0x0440, 0xc47d, 0xc439, 0x0404, 0xc4b1, 0x048c, 0x04c8,
            0xc4f5, 0xc5a1, 0x059c, 0x05d8, 0xc5e5, 0x0550, 0xc56d, 0xc529, 0x0514, 0xcf01, 0x0f3c,
            0x0f78, 0xcf45, 0x0ff0, 0xcfcd, 0xcf89, 0x0fb4, 0x0ee0, 0xcedd, 0xce99, 0x0ea4, 0xce11,
            0x0e2c, 0x0e68, 0xce55, 0x0cc0, 0xccfd, 0xccb9, 0x0c84, 0xcc31, 0x0c0c, 0x0c48, 0xcc75,
            0xcd21, 0x0d1c, 0x0d58, 0xcd65, 0x0dd0, 0xcded, 0xcda9, 0x0d94, 0x0880, 0xc8bd, 0xc8f9,
            0x08c4, 0xc871, 0x084c, 0x0808, 0xc835, 0xc961, 0x095c, 0x0918, 0xc925, 0x0990, 0xc9ad,
            0xc9e9, 0x09d4, 0xcb41, 0x0b7c, 0x0b38, 0xcb05, 0x0bb0, 0xcb8d, 0xcbc9, 0x0bf4, 0x0aa0,
            0xca9d, 0xcad9, 0x0ae4, 0xca51, 0x0a6c, 0x0a28, 0xca15, 0xde01, 0x1e3c, 0x1e78, 0xde45,
            0x1ef0, 0xdecd, 0xde89, 0x1eb4, 0x1fe0, 0xdfdd, 0xdf99, 0x1fa4, 0xdf11, 0x1f2c, 0x1f68,
            0xdf55, 0x1dc0, 0xddfd, 0xddb9, 0x1d84, 0xdd31, 0x1d0c, 0x1d48, 0xdd75, 0xdc21, 0x1c1c,
            0x1c58, 0xdc65, 0x1cd0, 0xdced, 0xdca9, 0x1c94, 0x1980, 0xd9bd, 0xd9f9, 0x19c4, 0xd971,
            0x194c, 0x1908, 0xd935, 0xd861, 0x185c, 0x1818, 0xd825, 0x1890, 0xd8ad, 0xd8e9, 0x18d4,
            0xda41, 0x1a7c, 0x1a38, 0xda05, 0x1ab0, 0xda8d, 0xdac9, 0x1af4, 0x1ba0, 0xdb9d, 0xdbd9,
            0x1be4, 0xdb51, 0x1b6c, 0x1b28, 0xdb15, 0x1100, 0xd13d, 0xd179, 0x1144, 0xd1f1, 0x11cc,
            0x1188, 0xd1b5, 0xd0e1, 0x10dc, 0x1098, 0xd0a5, 0x1010, 0xd02d, 0xd069, 0x1054, 0xd2c1,
            0x12fc, 0x12b8, 0xd285, 0x1230, 0xd20d, 0xd249, 0x1274, 0x1320, 0xd31d, 0xd359, 0x1364,
            0xd3d1, 0x13ec, 0x13a8, 0xd395, 0xd681, 0x16bc, 0x16f8, 0xd6c5, 0x1670, 0xd64d, 0xd609,
            0x1634, 0x1760, 0xd75d, 0xd719, 0x1724, 0xd791, 0x17ac, 0x17e8, 0xd7d5, 0x1540, 0xd57d,
            0xd539, 0x1504, 0xd5b1, 0x158c, 0x15c8, 0xd5f5, 0xd4a1, 0x149c, 0x14d8, 0xd4e5, 0x1450,
            0xd46d, 0xd429, 0x1414,
        ],
        [
            0x0000, 0xd101, 0xe201, 0x3300, 0x8401, 0x5500, 0x6600, 0xb701, 0x4801, 0x9900, 0xaa00,
            0x7b01, 0xcc00, 0x1d01, 0x2e01, 0xff00, 0x9002, 0x4103, 0x7203, 0xa302, 0x1403, 0xc502,
            0xf602, 0x2703, 0xd803, 0x0902, 0x3a02, 0xeb03, 0x5c02, 0x8d03, 0xbe03, 0x6f02, 0x6007,
            0xb106, 0x8206, 0x5307, 0xe406, 0x3507, 0x0607, 0xd706, 0x2806, 0xf907, 0xca07, 0x1b06,
            0xac07, 0x7d06, 0x4e06, 0x9f07, 0xf005, 0x2104, 0x1204, 0xc305, 0x7404, 0xa505, 0x9605,
            0x4704, 0xb804, 0x6905, 0x5a05, 0x8b04, 0x3c05, 0xed04, 0xde04, 0x0f05, 0xc00e, 0x110f,
            0x220f, 0xf30e, 0x440f, 0x950e, 0xa60e, 0x770f, 0x880f, 0x590e, 0x6a0e, 0xbb0f, 0x0c0e,
            0xdd0f, 0xee0f, 0x3f0e, 0x500c, 0x810d, 0xb20d, 0x630c, 0xd40d, 0x050c, 0x360c, 0xe70d,
            0x180d, 0xc90c, 0xfa0c, 0x2b0d, 0x9c0c, 0x4d0d, 0x7e0d, 0xaf0c, 0xa009, 0x7108, 0x4208,
            0x9309, 0x2408, 0xf509, 0xc609, 0x1708, 0xe808, 0x3909, 0x0a09, 0xdb08, 0x6c09, 0xbd08,
            0x8e08, 0x5f09, 0x300b, 0xe10a, 0xd20a, 0x030b, 0xb40a, 0x650b, 0x560b, 0x870a, 0x780a,
            0xa90b, 0x9a0b, 0x4b0a, 0xfc0b, 0x2d0a, 0x1e0a, 0xcf0b, 0xc01f, 0x111e, 0x221e, 0xf31f,
            0x441e, 0x951f, 0xa61f, 0x771e, 0x881e, 0x591f, 0x6a1f, 0xbb1e, 0x0c1f, 0xdd1e, 0xee1e,
            0x3f1f, 0x501d, 0x811c, 0xb21c, 0x631d, 0xd41c, 0x051d, 0x361d, 0xe71c, 0x181c, 0xc91d,
            0xfa1d, 0x2b1c, 0x9c1d, 0x4d1c, 0x7e1c, 0xaf1d, 0xa018, 0x7119, 0x4219, 0x9318, 0x2419,
            0xf518, 0xc618, 0x1719, 0xe819, 0x3918, 0x0a18, 0xdb19, 0x6c18, 0xbd19, 0x8e19, 0x5f18,
            0x301a, 0xe11b, 0xd21b, 0x031a, 0xb41b, 0x651a, 0x561a, 0x871b, 0x781b, 0xa91a, 0x9a1a,
            0x4b1b, 0xfc1a, 0x2d1b, 0x1e1b, 0xcf1a, 0x0011, 0xd110, 0xe210, 0x3311, 0x8410, 0x5511,
            0x6611, 0xb710, 0x4810, 0x9911, 0xaa11, 0x7b10, 0xcc11, 0x1d10, 0x2e10, 0xff11, 0x9013,
            0x4112, 0x7212, 0xa313, 0x1412, 0xc513, 0xf613, 0x2712, 0xd812, 0x0913, 0x3a13, 0xeb12,
            0x5c13, 0x8d12, 0xbe12, 0x6f13, 0x6016, 0xb117, 0x8217, 0x5316, 0xe417, 0x3516, 0x0616,
            0xd717, 0x2817, 0xf916, 0xca16, 0x1b17, 0xac16, 0x7d17, 0x4e17, 0x9f16, 0xf014, 0x2115,
            0x1215, 0xc314, 0x7415, 0xa514, 0x9614, 0x4715, 0xb815, 0x6914, 0x5a14, 0x8b15, 0x3c14,
            0xed15, 0xde15, 0x0f14,
        ],
        [
            0x0000, 0xc010, 0xc023, 0x0033, 0xc045, 0x0055, 0x0066, 0xc076, 0xc089, 0x0099, 0x00aa,
            0xc0ba, 0x00cc, 0xc0dc, 0xc0ef, 0x00ff, 0xc111, 0x0101, 0x0132, 0xc122, 0x0154, 0xc144,
            0xc177, 0x0167, 0x0198, 0xc188, 0xc1bb, 0x01ab, 0xc1dd, 0x01cd, 0x01fe, 0xc1ee, 0xc221,
            0x0231, 0x0202, 0xc212, 0x0264, 0xc274, 0xc247, 0x0257, 0x02a8, 0xc2b8, 0xc28b, 0x029b,
            0xc2ed, 0x02fd, 0x02ce, 0xc2de, 0x0330, 0xc320, 0xc313, 0x0303, 0xc375, 0x0365, 0x0356,
            0xc346, 0xc3b9, 0x03a9, 0x039a, 0xc38a, 0x03fc, 0xc3ec, 0xc3df, 0x03cf, 0xc441, 0x0451,
            0x0462, 0xc472, 0x0404, 0xc414, 0xc427, 0x0437, 0x04c8, 0xc4d8, 0xc4eb, 0x04fb, 0xc48d,
            0x049d, 0x04ae, 0xc4be, 0x0550, 0xc540, 0xc573, 0x0563, 0xc515, 0x0505, 0x0536, 0xc526,
            0xc5d9, 0x05c9, 0x05fa, 0xc5ea, 0x059c, 0xc58c, 0xc5bf, 0x05af, 0x0660, 0xc670, 0xc643,
            0x0653, 0xc625, 0x0635, 0x0606, 0xc616, 0xc6e9, 0x06f9, 0x06ca, 0xc6da, 0x06ac, 0xc6bc,
            0xc68f, 0x069f, 0xc771, 0x0761, 0x0752, 0xc742, 0x0734, 0xc724, 0xc717, 0x0707, 0x07f8,
            0xc7e8, 0xc7db, 0x07cb, 0xc7bd, 0x07ad, 0x079e, 0xc78e, 0xc881, 0x0891, 0x08a2, 0xc8b2,
            0x08c4, 0xc8d4, 0xc8e7, 0x08f7, 0x0808, 0xc818, 0xc82b, 0x083b, 0xc84d, 0x085d, 0x086e,
            0xc87e, 0x0990, 0xc980, 0xc9b3, 0x09a3, 0xc9d5, 0x09c5, 0x09f6, 0xc9e6, 0xc919, 0x0909,
            0x093a, 0xc92a, 0x095c, 0xc94c, 0xc97f, 0x096f, 0x0aa0, 0xcab0, 0xca83, 0x0a93, 0xcae5,
            0x0af5, 0x0ac6, 0xcad6, 0xca29, 0x0a39, 0x0a0a, 0xca1a, 0x0a6c, 0xca7c, 0xca4f, 0x0a5f,
            0xcbb1, 0x0ba1, 0x0b92, 0xcb82, 0x0bf4, 0xcbe4, 0xcbd7, 0x0bc7, 0x0b38, 0xcb28, 0xcb1b,
            0x0b0b, 0xcb7d, 0x0b6d, 0x0b5e, 0xcb4e, 0x0cc0, 0xccd0, 0xcce3, 0x0cf3, 0xcc85, 0x0c95,
            0x0ca6, 0xccb6, 0xcc49, 0x0c59, 0x0c6a, 0xcc7a, 0x0c0c, 0xcc1c, 0xcc2f, 0x0c3f, 0xcdd1,
            0x0dc1, 0x0df2, 0xcde2, 0x0d94, 0xcd84, 0xcdb7, 0x0da7, 0x0d58, 0xcd48, 0xcd7b, 0x0d6b,
            0xcd1d, 0x0d0d, 0x0d3e, 0xcd2e, 0xcee1, 0x0ef1, 0x0ec2, 0xced2, 0x0ea4, 0xceb4, 0xce87,
            0x0e97, 0x0e68, 0xce78, 0xce4b, 0x0e5b, 0xce2d, 0x0e3d, 0x0e0e, 0xce1e, 0x0ff0, 0xcfe0,
            0xcfd3, 0x0fc3, 0xcfb5, 0x0fa5, 0x0f96, 0xcf86, 0xcf79, 0x0f69, 0x0f5a, 0xcf4a, 0x0f3c,
            0xcf2c, 0xcf1f, 0x0f0f,
        ],
        [
            0x0000, 0xccc1, 0xd981, 0x1540, 0xf301, 0x3fc0, 0x2a80, 0xe641, 0xa601, 0x6ac0, 0x7f80,
            0xb341, 0x5500, 0x99c1, 0x8c81, 0x4040, 0x0c01, 0xc0c0, 0xd580, 0x1941, 0xff00, 0x33c1,
            0x2681, 0xea40, 0xaa00, 0x66c1, 0x7381, 0xbf40, 0x5901, 0x95c0, 0x8080, 0x4c41, 0x1802,
            0xd4c3, 0xc183, 0x0d42, 0xeb03, 0x27c2, 0x3282, 0xfe43, 0xbe03, 0x72c2, 0x6782, 0xab43,
            0x4d02, 0x81c3, 0x9483, 0x5842, 0x1403, 0xd8c2, 0xcd82, 0x0143, 0xe702, 0x2bc3, 0x3e83,
            0xf242, 0xb202, 0x7ec3, 0x6b83, 0xa742, 0x4103, 0x8dc2, 0x9882, 0x5443, 0x3004, 0xfcc5,
            0xe985, 0x2544, 0xc305, 0x0fc4, 0x1a84, 0xd645, 0x9605, 0x5ac4, 0x4f84, 0x8345, 0x6504,
            0xa9c5, 0xbc85, 0x7044, 0x3c05, 0xf0c4, 0xe584, 0x2945, 0xcf04, 0x03c5, 0x1685, 0xda44,
            0x9a04, 0x56c5, 0x4385, 0x8f44, 0x6905, 0xa5c4, 0xb084, 0x7c45, 0x2806, 0xe4c7, 0xf187,
            0x3d46, 0xdb07, 0x17c6, 0x0286, 0xce47, 0x8e07, 0x42c6, 0x5786, 0x9b47, 0x7d06, 0xb1c7,
            0xa487, 0x6846, 0x2407, 0xe8c6, 0xfd86, 0x3147, 0xd706, 0x1bc7, 0x0e87, 0xc246, 0x8206,
            0x4ec7, 0x5b87, 0x9746, 0x7107, 0xbdc6, 0xa886, 0x6447, 0x6008, 0xacc9, 0xb989, 0x7548,
            0x9309, 0x5fc8, 0x4a88, 0x8649, 0xc609, 0x0ac8, 0x1f88, 0xd349, 0x3508, 0xf9c9, 0xec89,
            0x2048, 0x6c09, 0xa0c8, 0xb588, 0x7949, 0x9f08, 0x53c9, 0x4689, 0x8a48, 0xca08, 0x06c9,
            0x1389, 0xdf48, 0x3909, 0xf5c8, 0xe088, 0x2c49, 0x780a, 0xb4cb, 0xa18b, 0x6d4a, 0x8b0b,
            0x47ca, 0x528a, 0x9e4b, 0xde0b, 0x12ca, 0x078a, 0xcb4b, 0x2d0a, 0xe1cb, 0xf48b, 0x384a,
            0x740b, 0xb8ca, 0xad8a, 0x614b, 0x870a, 0x4bcb, 0x5e8b, 0x924a, 0xd20a, 0x1ecb, 0x0b8b,
            0xc74a, 0x210b, 0xedca, 0xf88a, 0x344b, 0x500c, 0x9ccd, 0x898d, 0x454c, 0xa30d, 0x6fcc,
            0x7a8c, 0xb64d, 0xf60d, 0x3acc, 0x2f8c, 0xe34d, 0x050c, 0xc9cd, 0xdc8d, 0x104c, 0x5c0d,
            0x90cc, 0x858c, 0x494d, 0xaf0c, 0x63cd, 0x768d, 0xba4c, 0xfa0c, 0x36cd, 0x238d, 0xef4c,
            0x090d, 0xc5cc, 0xd08c, 0x1c4d, 0x480e, 0x84cf, 0x918f, 0x5d4e, 0xbb0f, 0x77ce, 0x628e,
            0xae4f, 0xee0f, 0x22ce, 0x378e, 0xfb4f, 0x1d0e, 0xd1cf, 0xc48f, 0x084e, 0x440f, 0x88ce,
            0x9d8e, 0x514f, 0xb70e, 0x7bcf, 0x6e8f, 0xa24e, 0xe20e, 0x2ecf, 0x3b8f, 0xf74e, 0x110f,
            0xddce, 0xc88e, 0x044f,
        ],
        [
            0x0000, 0x900d, 0x6019, 0xf014, 0xc032, 0x503f, 0xa02b, 0x3026, 0xc067, 0x506a, 0xa07e,
            0x3073, 0x0055, 0x9058, 0x604c, 0xf041, 0xc0cd, 0x50c0, 0xa0d4, 0x30d9, 0x00ff, 0x90f2,
            0x60e6, 0xf0eb, 0x00aa, 0x90a7, 0x60b3, 0xf0be, 0xc098, 0x5095, 0xa081, 0x308c, 0xc199,
            0x5194, 0xa180, 0x318d, 0x01ab, 0x91a6, 0x61b2, 0xf1bf, 0x01fe, 0x91f3, 0x61e7, 0xf1ea,
            0xc1cc, 0x51c1, 0xa1d5, 0x31d8, 0x0154, 0x9159, 0x614d, 0xf140, 0xc166, 0x516b, 0xa17f,
            0x3172, 0xc133, 0x513e, 0xa12a, 0x3127, 0x0101, 0x910c, 0x6118, 0xf115, 0xc331, 0x533c,
            0xa328, 0x3325, 0x0303, 0x930e, 0x631a, 0xf317, 0x0356, 0x935b, 0x634f, 0xf342, 0xc364,
            0x5369, 0xa37d, 0x3370, 0x03fc, 0x93f1, 0x63e5, 0xf3e8, 0xc3ce, 0x53c3, 0xa3d7, 0x33da,
            0xc39b, 0x5396, 0xa382, 0x338f, 0x03a9, 0x93a4, 0x63b0, 0xf3bd, 0x02a8, 0x92a5, 0x62b1,
            0xf2bc, 0xc29a, 0x5297, 0xa283, 0x328e, 0xc2cf, 0x52c2, 0xa2d6, 0x32db, 0x02fd, 0x92f0,
            0x62e4, 0xf2e9, 0xc265, 0x5268, 0xa27c, 0x3271, 0x0257, 0x925a, 0x624e, 0xf243, 0x0202,
            0x920f, 0x621b, 0xf216, 0xc230, 0x523d, 0xa229, 0x3224, 0xc661, 0x566c, 0xa678, 0x3675,
            0x0653, 0x965e, 0x664a, 0xf647, 0x0606, 0x960b, 0x661f, 0xf612, 0xc634, 0x5639, 0xa62d,
            0x3620, 0x06ac, 0x96a1, 0x66b5, 0xf6b8, 0xc69e, 0x5693, 0xa687, 0x368a, 0xc6cb, 0x56c6,
            0xa6d2, 0x36df, 0x06f9, 0x96f4, 0x66e0, 0xf6ed, 0x07f8, 0x97f5, 0x67e1, 0xf7ec, 0xc7ca,
            0x57c7, 0xa7d3, 0x37de, 0xc79f, 0x5792, 0xa786, 0x378b, 0x07ad, 0x97a0, 0x67b4, 0xf7b9,
            0xc735, 0x5738, 0xa72c, 0x3721, 0x0707, 0x970a, 0x671e, 0xf713, 0x0752, 0x975f, 0x674b,
            0xf746, 0xc760, 0x576d, 0xa779, 0x3774, 0x0550, 0x955d, 0x6549, 0xf544, 0xc562, 0x556f,
            0xa57b, 0x3576, 0xc537, 0x553a, 0xa52e, 0x3523, 0x0505, 0x9508, 0x651c, 0xf511, 0xc59d,
            0x5590, 0xa584, 0x3589, 0x05af, 0x95a2, 0x65b6, 0xf5bb, 0x05fa, 0x95f7, 0x65e3, 0xf5ee,
            0xc5c8, 0x55c5, 0xa5d1, 0x35dc, 0xc4c9, 0x54c4, 0xa4d0, 0x34dd, 0x04fb, 0x94f6, 0x64e2,
            0xf4ef, 0x04ae, 0x94a3, 0x64b7, 0xf4ba, 0xc49c, 0x5491, 0xa485, 0x3488, 0x0404, 0x9409,
            0x641d, 0xf410, 0xc436, 0x543b, 0xa42f, 0x3422, 0xc463, 0x546e, 0xa47a, 0x3477, 0x0451,
            0x945c, 0x6448, 0xf445,
        ],
        [
            0x0000, 0xc551, 0xcaa1, 0x0ff0, 0xd541, 0x1010, 0x1fe0, 0xdab1, 0xea81, 0x2fd0, 0x2020,
            0xe571, 0x3fc0, 0xfa91, 0xf561, 0x3030, 0x9501, 0x5050, 0x5fa0, 0x9af1, 0x4040, 0x8511,
            0x8ae1, 0x4fb0, 0x7f80, 0xbad1, 0xb521, 0x7070, 0xaac1, 0x6f90, 0x6060, 0xa531, 0x6a01,
            0xaf50, 0xa0a0, 0x65f1, 0xbf40, 0x7a11, 0x75e1, 0xb0b0, 0x8080, 0x45d1, 0x4a21, 0x8f70,
            0x55c1, 0x9090, 0x9f60, 0x5a31, 0xff00, 0x3a51, 0x35a1, 0xf0f0, 0x2a41, 0xef10, 0xe0e0,
            0x25b1, 0x1581, 0xd0d0, 0xdf20, 0x1a71, 0xc0c0, 0x0591, 0x0a61, 0xcf30, 0xd402, 0x1153,
            0x1ea3, 0xdbf2, 0x0143, 0xc412, 0xcbe2, 0x0eb3, 0x3e83, 0xfbd2, 0xf422, 0x3173, 0xebc2,
            0x2e93, 0x2163, 0xe432, 0x4103, 0x8452, 0x8ba2, 0x4ef3, 0x9442, 0x5113, 0x5ee3, 0x9bb2,
            0xab82, 0x6ed3, 0x6123, 0xa472, 0x7ec3, 0xbb92, 0xb462, 0x7133, 0xbe03, 0x7b52, 0x74a2,
            0xb1f3, 0x6b42, 0xae13, 0xa1e3, 0x64b2, 0x5482, 0x91d3, 0x9e23, 0x5b72, 0x81c3, 0x4492,
            0x4b62, 0x8e33, 0x2b02, 0xee53, 0xe1a3, 0x24f2, 0xfe43, 0x3b12, 0x34e2, 0xf1b3, 0xc183,
            0x04d2, 0x0b22, 0xce73, 0x14c2, 0xd193, 0xde63, 0x1b32, 0xe807, 0x2d56, 0x22a6, 0xe7f7,
            0x3d46, 0xf817, 0xf7e7, 0x32b6, 0x0286, 0xc7d7, 0xc827, 0x0d76, 0xd7c7, 0x1296, 0x1d66,
            0xd837, 0x7d06, 0xb857, 0xb7a7, 0x72f6, 0xa847, 0x6d16, 0x62e6, 0xa7b7, 0x9787, 0x52d6,
            0x5d26, 0x9877, 0x42c6, 0x8797, 0x8867, 0x4d36, 0x8206, 0x4757, 0x48a7, 0x8df6, 0x5747,
            0x9216, 0x9de6, 0x58b7, 0x6887, 0xadd6, 0xa226, 0x6777, 0xbdc6, 0x7897, 0x7767, 0xb236,
            0x1707, 0xd256, 0xdda6, 0x18f7, 0xc246, 0x0717, 0x08e7, 0xcdb6, 0xfd86, 0x38d7, 0x3727,
            0xf276, 0x28c7, 0xed96, 0xe266, 0x2737, 0x3c05, 0xf954, 0xf6a4, 0x33f5, 0xe944, 0x2c15,
            0x23e5, 0xe6b4, 0xd684, 0x13d5, 0x1c25, 0xd974, 0x03c5, 0xc694, 0xc964, 0x0c35, 0xa904,
            0x6c55, 0x63a5, 0xa6f4, 0x7c45, 0xb914, 0xb6e4, 0x73b5, 0x4385, 0x86d4, 0x8924, 0x4c75,
            0x96c4, 0x5395, 0x5c65, 0x9934, 0x5604, 0x9355, 0x9ca5, 0x59f4, 0x8345, 0x4614, 0x49e4,
            0x8cb5, 0xbc85, 0x79d4, 0x7624, 0xb375, 0x69c4, 0xac95, 0xa365, 0x6634, 0xc305, 0x0654,
            0x09a4, 0xccf5, 0x1644, 0xd315, 0xdce5, 0x19b4, 0x2984, 0xecd5, 0xe325, 0x2674, 0xfcc5,
            0x3994, 0x3664, 0xf335,
        ],
        [
            0x0000, 0xfc04, 0xb80b, 0x440f, 0x3015, 0xcc11, 0x881e, 0x741a, 0x602a, 0x9c2e, 0xd821,
            0x2425, 0x503f, 0xac3b, 0xe834, 0x1430, 0xc054, 0x3c50, 0x785f, 0x845b, 0xf041, 0x0c45,
            0x484a, 0xb44e, 0xa07e, 0x5c7a, 0x1875, 0xe471, 0x906b, 0x6c6f, 0x2860, 0xd464, 0xc0ab,
            0x3caf, 0x78a0, 0x84a4, 0xf0be, 0x0cba, 0x48b5, 0xb4b1, 0xa081, 0x5c85, 0x188a, 0xe48e,
            0x9094, 0x6c90, 0x289f, 0xd49b, 0x00ff, 0xfcfb, 0xb8f4, 0x44f0, 0x30ea, 0xccee, 0x88e1,
            0x74e5, 0x60d5, 0x9cd1, 0xd8de, 0x24da, 0x50c0, 0xacc4, 0xe8cb, 0x14cf, 0xc155, 0x3d51,
            0x795e, 0x855a, 0xf140, 0x0d44, 0x494b, 0xb54f, 0xa17f, 0x5d7b, 0x1974, 0xe570, 0x916a,
            0x6d6e, 0x2961, 0xd565, 0x0101, 0xfd05, 0xb90a, 0x450e, 0x3114, 0xcd10, 0x891f, 0x751b,
            0x612b, 0x9d2f, 0xd920, 0x2524, 0x513e, 0xad3a, 0xe935, 0x1531, 0x01fe, 0xfdfa, 0xb9f5,
            0x45f1, 0x31eb, 0xcdef, 0x89e0, 0x75e4, 0x61d4, 0x9dd0, 0xd9df, 0x25db, 0x51c1, 0xadc5,
            0xe9ca, 0x15ce, 0xc1aa, 0x3dae, 0x79a1, 0x85a5, 0xf1bf, 0x0dbb, 0x49b4, 0xb5b0, 0xa180,
            0x5d84, 0x198b, 0xe58f, 0x9195, 0x6d91, 0x299e, 0xd59a, 0xc2a9, 0x3ead, 0x7aa2, 0x86a6,
            0xf2bc, 0x0eb8, 0x4ab7, 0xb6b3, 0xa283, 0x5e87, 0x1a88, 0xe68c, 0x9296, 0x6e92, 0x2a9d,
            0xd699, 0x02fd, 0xfef9, 0xbaf6, 0x46f2, 0x32e8, 0xceec, 0x8ae3, 0x76e7, 0x62d7, 0x9ed3,
            0xdadc, 0x26d8, 0x52c2, 0xaec6, 0xeac9, 0x16cd, 0x0202, 0xfe06, 0xba09, 0x460d, 0x3217,
            0xce13, 0x8a1c, 0x7618, 0x6228, 0x9e2c, 0xda23, 0x2627, 0x523d, 0xae39, 0xea36, 0x1632,
            0xc256, 0x3e52, 0x7a5d, 0x8659, 0xf243, 0x0e47, 0x4a48, 0xb64c, 0xa27c, 0x5e78, 0x1a77,
            0xe673, 0x9269, 0x6e6d, 0x2a62, 0xd666, 0x03fc, 0xfff8, 0xbbf7, 0x47f3, 0x33e9, 0xcfed,
            0x8be2, 0x77e6, 0x63d6, 0x9fd2, 0xdbdd, 0x27d9, 0x53c3, 0xafc7, 0xebc8, 0x17cc, 0xc3a8,
            0x3fac, 0x7ba3, 0x87a7, 0xf3bd, 0x0fb9, 0x4bb6, 0xb7b2, 0xa382, 0x5f86, 0x1b89, 0xe78d,
            0x9397, 0x6f93, 0x2b9c, 0xd798, 0xc357, 0x3f53, 0x7b5c, 0x8758, 0xf342, 0x0f46, 0x4b49,
            0xb74d, 0xa37d, 0x5f79, 0x1b76, 0xe772, 0x9368, 0x6f6c, 0x2b63, 0xd767, 0x0303, 0xff07,
            0xbb08, 0x470c, 0x3316, 0xcf12, 0x8b1d, 0x7719, 0x6329, 0x9f2d, 0xdb22, 0x2726, 0x533c,
            0xaf38, 0xeb37, 0x1733,
        ],
        [
            0x0000, 0xc3fd, 0xc7f9, 0x0404, 0xcff1, 0x0c0c, 0x0808, 0xcbf5, 0xdfe1, 0x1c1c, 0x1818,
            0xdbe5, 0x1010, 0xd3ed, 0xd7e9, 0x1414, 0xffc1, 0x3c3c, 0x3838, 0xfbc5, 0x3030, 0xf3cd,
            0xf7c9, 0x3434, 0x2020, 0xe3dd, 0xe7d9, 0x2424, 0xefd1, 0x2c2c, 0x2828, 0xebd5, 0xbf81,
            0x7c7c, 0x7878, 0xbb85, 0x7070, 0xb38d, 0xb789, 0x7474, 0x6060, 0xa39d, 0xa799, 0x6464,
            0xaf91, 0x6c6c, 0x6868, 0xab95, 0x4040, 0x83bd, 0x87b9, 0x4444, 0x8fb1, 0x4c4c, 0x4848,
            0x8bb5, 0x9fa1, 0x5c5c, 0x5858, 0x9ba5, 0x5050, 0x93ad, 0x97a9, 0x5454, 0x3f01, 0xfcfc,
            0xf8f8, 0x3b05, 0xf0f0, 0x330d, 0x3709, 0xf4f4, 0xe0e0, 0x231d, 0x2719, 0xe4e4, 0x2f11,
            0xecec, 0xe8e8, 0x2b15, 0xc0c0, 0x033d, 0x0739, 0xc4c4, 0x0f31, 0xcccc, 0xc8c8, 0x0b35,
            0x1f21, 0xdcdc, 0xd8d8, 0x1b25, 0xd0d0, 0x132d, 0x1729, 0xd4d4, 0x8080, 0x437d, 0x4779,
            0x8484, 0x4f71, 0x8c8c, 0x8888, 0x4b75, 0x5f61, 0x9c9c, 0x9898, 0x5b65, 0x9090, 0x536d,
            0x5769, 0x9494, 0x7f41, 0xbcbc, 0xb8b8, 0x7b45, 0xb0b0, 0x734d, 0x7749, 0xb4b4, 0xa0a0,
            0x635d, 0x6759, 0xa4a4, 0x6f51, 0xacac, 0xa8a8, 0x6b55, 0x7e02, 0xbdff, 0xb9fb, 0x7a06,
            0xb1f3, 0x720e, 0x760a, 0xb5f7, 0xa1e3, 0x621e, 0x661a, 0xa5e7, 0x6e12, 0xadef, 0xa9eb,
            0x6a16, 0x81c3, 0x423e, 0x463a, 0x85c7, 0x4e32, 0x8dcf, 0x89cb, 0x4a36, 0x5e22, 0x9ddf,
            0x99db, 0x5a26, 0x91d3, 0x522e, 0x562a, 0x95d7, 0xc183, 0x027e, 0x067a, 0xc587, 0x0e72,
            0xcd8f, 0xc98b, 0x0a76, 0x1e62, 0xdd9f, 0xd99b, 0x1a66, 0xd193, 0x126e, 0x166a, 0xd597,
            0x3e42, 0xfdbf, 0xf9bb, 0x3a46, 0xf1b3, 0x324e, 0x364a, 0xf5b7, 0xe1a3, 0x225e, 0x265a,
            0xe5a7, 0x2e52, 0xedaf, 0xe9ab, 0x2a56, 0x4103, 0x82fe, 0x86fa, 0x4507, 0x8ef2, 0x4d0f,
            0x490b, 0x8af6, 0x9ee2, 0x5d1f, 0x591b, 0x9ae6, 0x5113, 0x92ee, 0x96ea, 0x5517, 0xbec2,
            0x7d3f, 0x793b, 0xbac6, 0x7133, 0xb2ce, 0xb6ca, 0x7537, 0x6123, 0xa2de, 0xa6da, 0x6527,
            0xaed2, 0x6d2f, 0x692b, 0xaad6, 0xfe82, 0x3d7f, 0x397b, 0xfa86, 0x3173, 0xf28e, 0xf68a,
            0x3577, 0x2163, 0xe29e, 0xe69a, 0x2567, 0xee92, 0x2d6f, 0x296b, 0xea96, 0x0143, 0xc2be,
            0xc6ba, 0x0547, 0xceb2, 0x0d4f, 0x094b, 0xcab6, 0xdea2, 0x1d5f, 0x195b, 0xdaa6, 0x1153,
            0xd2ae, 0xd6aa, 0x1557,
        ],
        [
            0x0000, 0x8102, 0x4207, 0xc305, 0x840e, 0x050c, 0xc609, 0x470b, 0x481f, 0xc91d, 0x0a18,
            0x8b1a, 0xcc11, 0x4d13, 0x8e16, 0x0f14, 0x903e, 0x113c, 0xd239, 0x533b, 0x1430, 0x9532,
            0x5637, 0xd735, 0xd821, 0x5923, 0x9a26, 0x1b24, 0x5c2f, 0xdd2d, 0x1e28, 0x9f2a, 0x607f,
            0xe17d, 0x2278, 0xa37a, 0xe471, 0x6573, 0xa676, 0x2774, 0x2860, 0xa962, 0x6a67, 0xeb65,
            0xac6e, 0x2d6c, 0xee69, 0x6f6b, 0xf041, 0x7143, 0xb246, 0x3344, 0x744f, 0xf54d, 0x3648,
            0xb74a, 0xb85e, 0x395c, 0xfa59, 0x7b5b, 0x3c50, 0xbd52, 0x7e57, 0xff55, 0xc0fe, 0x41fc,
            0x82f9, 0x03fb, 0x44f0, 0xc5f2, 0x06f7, 0x87f5, 0x88e1, 0x09e3, 0xcae6, 0x4be4, 0x0cef,
            0x8ded, 0x4ee8, 0xcfea, 0x50c0, 0xd1c2, 0x12c7, 0x93c5, 0xd4ce, 0x55cc, 0x96c9, 0x17cb,
            0x18df, 0x99dd, 0x5ad8, 0xdbda, 0x9cd1, 0x1dd3, 0xded6, 0x5fd4, 0xa081, 0x2183, 0xe286,
            0x6384, 0x248f, 0xa58d, 0x6688, 0xe78a, 0xe89e, 0x699c, 0xaa99, 0x2b9b, 0x6c90, 0xed92,
            0x2e97, 0xaf95, 0x30bf, 0xb1bd, 0x72b8, 0xf3ba, 0xb4b1, 0x35b3, 0xf6b6, 0x77b4, 0x78a0,
            0xf9a2, 0x3aa7, 0xbba5, 0xfcae, 0x7dac, 0xbea9, 0x3fab, 0xc1ff, 0x40fd, 0x83f8, 0x02fa,
            0x45f1, 0xc4f3, 0x07f6, 0x86f4, 0x89e0, 0x08e2, 0xcbe7, 0x4ae5, 0x0dee, 0x8cec, 0x4fe9,
            0xceeb, 0x51c1, 0xd0c3, 0x13c6, 0x92c4, 0xd5cf, 0x54cd, 0x97c8, 0x16ca, 0x19de, 0x98dc,
            0x5bd9, 0xdadb, 0x9dd0, 0x1cd2, 0xdfd7, 0x5ed5, 0xa180, 0x2082, 0xe387, 0x6285, 0x258e,
            0xa48c, 0x6789, 0xe68b, 0xe99f, 0x689d, 0xab98, 0x2a9a, 0x6d91, 0xec93, 0x2f96, 0xae94,
            0x31be, 0xb0bc, 0x73b9, 0xf2bb, 0xb5b0, 0x34b2, 0xf7b7, 0x76b5, 0x79a1, 0xf8a3, 0x3ba6,
            0xbaa4, 0xfdaf, 0x7cad, 0xbfa8, 0x3eaa, 0x0101, 0x8003, 0x4306, 0xc204, 0x850f, 0x040d,
            0xc708, 0x460a, 0x491e, 0xc81c, 0x0b19, 0x8a1b, 0xcd10, 0x4c12, 0x8f17, 0x0e15, 0x913f,
            0x103d, 0xd338, 0x523a, 0x1531, 0x9433, 0x5736, 0xd634, 0xd920, 0x5822, 0x9b27, 0x1a25,
            0x5d2e, 0xdc2c, 0x1f29, 0x9e2b, 0x617e, 0xe07c, 0x2379, 0xa27b, 0xe570, 0x6472, 0xa777,
            0x2675, 0x2961, 0xa863, 0x6b66, 0xea64, 0xad6f, 0x2c6d, 0xef68, 0x6e6a, 0xf140, 0x7042,
            0xb347, 0x3245, 0x754e, 0xf44c, 0x3749, 0xb64b, 0xb95f, 0x385d, 0xfb58, 0x7a5a, 0x3d51,
            0xbc53, 0x7f56, 0xfe54,
        ],
        [
            0x0000, 0xc100, 0xc203, 0x0303, 0xc405, 0x0505, 0x0606, 0xc706, 0xc809, 0x0909, 0x0a0a,
            0xcb0a, 0x0c0c, 0xcd0c, 0xce0f, 0x0f0f, 0xd011, 0x1111, 0x1212, 0xd312, 0x1414, 0xd514,
            0xd617, 0x1717, 0x1818, 0xd918, 0xda1b, 0x1b1b, 0xdc1d, 0x1d1d, 0x1e1e, 0xdf1e, 0xe021,
            0x2121, 0x2222, 0xe322, 0x2424, 0xe524, 0xe627, 0x2727, 0x2828, 0xe928, 0xea2b, 0x2b2b,
            0xec2d, 0x2d2d, 0x2e2e, 0xef2e, 0x3030, 0xf130, 0xf233, 0x3333, 0xf435, 0x3535, 0x3636,
            0xf736, 0xf839, 0x3939, 0x3a3a, 0xfb3a, 0x3c3c, 0xfd3c, 0xfe3f, 0x3f3f, 0x8041, 0x4141,
            0x4242, 0x8342, 0x4444, 0x8544, 0x8647, 0x4747, 0x4848, 0x8948, 0x8a4b, 0x4b4b, 0x8c4d,
            0x4d4d, 0x4e4e, 0x8f4e, 0x5050, 0x9150, 0x9253, 0x5353, 0x9455, 0x5555, 0x5656, 0x9756,
            0x9859, 0x5959, 0x5a5a, 0x9b5a, 0x5c5c, 0x9d5c, 0x9e5f, 0x5f5f, 0x6060, 0xa160, 0xa263,
            0x6363, 0xa465, 0x6565, 0x6666, 0xa766, 0xa869, 0x6969, 0x6a6a, 0xab6a, 0x6c6c, 0xad6c,
            0xae6f, 0x6f6f, 0xb071, 0x7171, 0x7272, 0xb372, 0x7474, 0xb574, 0xb677, 0x7777, 0x7878,
            0xb978, 0xba7b, 0x7b7b, 0xbc7d, 0x7d7d, 0x7e7e, 0xbf7e, 0x4081, 0x8181, 0x8282, 0x4382,
            0x8484, 0x4584, 0x4687, 0x8787, 0x8888, 0x4988, 0x4a8b, 0x8b8b, 0x4c8d, 0x8d8d, 0x8e8e,
            0x4f8e, 0x9090, 0x5190, 0x5293, 0x9393, 0x5495, 0x9595, 0x9696, 0x5796, 0x5899, 0x9999,
            0x9a9a, 0x5b9a, 0x9c9c, 0x5d9c, 0x5e9f, 0x9f9f, 0xa0a0, 0x61a0, 0x62a3, 0xa3a3, 0x64a5,
            0xa5a5, 0xa6a6, 0x67a6, 0x68a9, 0xa9a9, 0xaaaa, 0x6baa, 0xacac, 0x6dac, 0x6eaf, 0xafaf,
            0x70b1, 0xb1b1, 0xb2b2, 0x73b2, 0xb4b4, 0x75b4, 0x76b7, 0xb7b7, 0xb8b8, 0x79b8, 0x7abb,
            0xbbbb, 0x7cbd, 0xbdbd, 0xbebe, 0x7fbe, 0xc0c0, 0x01c0, 0x02c3, 0xc3c3, 0x04c5, 0xc5c5,
            0xc6c6, 0x07c6, 0x08c9, 0xc9c9, 0xcaca, 0x0bca, 0xcccc, 0x0dcc, 0x0ecf, 0xcfcf, 0x10d1,
            0xd1d1, 0xd2d2, 0x13d2, 0xd4d4, 0x15d4, 0x16d7, 0xd7d7, 0xd8d8, 0x19d8, 0x1adb, 0xdbdb,
            0x1cdd, 0xdddd, 0xdede, 0x1fde, 0x20e1, 0xe1e1, 0xe2e2, 0x23e2, 0xe4e4, 0x25e4, 0x26e7,
            0xe7e7, 0xe8e8, 0x29e8, 0x2aeb, 0xebeb, 0x2ced, 0xeded, 0xeeee, 0x2fee, 0xf0f0, 0x31f0,
            0x32f3, 0xf3f3, 0x34f5, 0xf5f5, 0xf6f6, 0x37f6, 0x38f9, 0xf9f9, 0xfafa, 0x3bfa, 0xfcfc,
            0x3dfc, 0x3eff, 0xffff,
        ],
        [
            0x0000, 0x00c1, 0x0182, 0x0143, 0x0304, 0x03c5, 0x0286, 0x0247, 0x0608, 0x06c9, 0x078a,
            0x074b, 0x050c, 0x05cd, 0x048e, 0x044f, 0x0c10, 0x0cd1, 0x0d92, 0x0d53, 0x0f14, 0x0fd5,
            0x0e96, 0x0e57, 0x0a18, 0x0ad9, 0x0b9a, 0x0b5b, 0x091c, 0x09dd, 0x089e, 0x085f, 0x1820,
            0x18e1, 0x19a2, 0x1963, 0x1b24, 0x1be5, 0x1aa6, 0x1a67, 0x1e28, 0x1ee9, 0x1faa, 0x1f6b,
            0x1d2c, 0x1ded, 0x1cae, 0x1c6f, 0x1430, 0x14f1, 0x15b2, 0x1573, 0x1734, 0x17f5, 0x16b6,
            0x1677, 0x1238, 0x12f9, 0x13ba, 0x137b, 0x113c, 0x11fd, 0x10be, 0x107f, 0x3040, 0x3081,
            0x31c2, 0x3103, 0x3344, 0x3385, 0x32c6, 0x3207, 0x3648, 0x3689, 0x37ca, 0x370b, 0x354c,
            0x358d, 0x34ce, 0x340f, 0x3c50, 0x3c91, 0x3dd2, 0x3d13, 0x3f54, 0x3f95, 0x3ed6, 0x3e17,
            0x3a58, 0x3a99, 0x3bda, 0x3b1b, 0x395c, 0x399d, 0x38de, 0x381f, 0x2860, 0x28a1, 0x29e2,
            0x2923, 0x2b64, 0x2ba5, 0x2ae6, 0x2a27, 0x2e68, 0x2ea9, 0x2fea, 0x2f2b, 0x2d6c, 0x2dad,
            0x2cee, 0x2c2f, 0x2470, 0x24b1, 0x25f2, 0x2533, 0x2774, 0x27b5, 0x26f6, 0x2637, 0x2278,
            0x22b9, 0x23fa, 0x233b, 0x217c, 0x21bd, 0x20fe, 0x203f, 0x6080, 0x6041, 0x6102, 0x61c3,
            0x6384, 0x6345, 0x6206, 0x62c7, 0x6688, 0x6649, 0x670a, 0x67cb, 0x658c, 0x654d, 0x640e,
            0x64cf, 0x6c90, 0x6c51, 0x6d12, 0x6dd3, 0x6f94, 0x6f55, 0x6e16, 0x6ed7, 0x6a98, 0x6a59,
            0x6b1a, 0x6bdb, 0x699c, 0x695d, 0x681e, 0x68df, 0x78a0, 0x7861, 0x7922, 0x79e3, 0x7ba4,
            0x7b65, 0x7a26, 0x7ae7, 0x7ea8, 0x7e69, 0x7f2a, 0x7feb, 0x7dac, 0x7d6d, 0x7c2e, 0x7cef,
            0x74b0, 0x7471, 0x7532, 0x75f3, 0x77b4, 0x7775, 0x7636, 0x76f7, 0x72b8, 0x7279, 0x733a,
            0x73fb, 0x71bc, 0x717d, 0x703e, 0x70ff, 0x50c0, 0x5001, 0x5142, 0x5183, 0x53c4, 0x5305,
            0x5246, 0x5287, 0x56c8, 0x5609, 0x574a, 0x578b, 0x55cc, 0x550d, 0x544e, 0x548f, 0x5cd0,
            0x5c11, 0x5d52, 0x5d93, 0x5fd4, 0x5f15, 0x5e56, 0x5e97, 0x5ad8, 0x5a19, 0x5b5a, 0x5b9b,
            0x59dc, 0x591d, 0x585e, 0x589f, 0x48e0, 0x4821, 0x4962, 0x49a3, 0x4be4, 0x4b25, 0x4a66,
            0x4aa7, 0x4ee8, 0x4e29, 0x4f6a, 0x4fab, 0x4dec, 0x4d2d, 0x4c6e, 0x4caf, 0x44f0, 0x4431,
            0x4572, 0x45b3, 0x47f4, 0x4735, 0x4676, 0x46b7, 0x42f8, 0x4239, 0x437a, 0x43bb, 0x41fc,
            0x413d, 0x407e, 0x40bf,
        ],
        [
            0x0000, 0x90c1, 0x6181, 0xf140, 0xc302, 0x53c3, 0xa283, 0x3242, 0xc607, 0x56c6, 0xa786,
            0x3747, 0x0505, 0x95c4, 0x6484, 0xf445, 0xcc0d, 0x5ccc, 0xad8c, 0x3d4d, 0x0f0f, 0x9fce,
            0x6e8e, 0xfe4f, 0x0a0a, 0x9acb, 0x6b8b, 0xfb4a, 0xc908, 0x59c9, 0xa889, 0x3848, 0xd819,
            0x48d8, 0xb998, 0x2959, 0x1b1b, 0x8bda, 0x7a9a, 0xea5b, 0x1e1e, 0x8edf, 0x7f9f, 0xef5e,
            0xdd1c, 0x4ddd, 0xbc9d, 0x2c5c, 0x1414, 0x84d5, 0x7595, 0xe554, 0xd716, 0x47d7, 0xb697,
            0x2656, 0xd213, 0x42d2, 0xb392, 0x2353, 0x1111, 0x81d0, 0x7090, 0xe051, 0xf031, 0x60f0,
            0x91b0, 0x0171, 0x3333, 0xa3f2, 0x52b2, 0xc273, 0x3636, 0xa6f7, 0x57b7, 0xc776, 0xf534,
            0x65f5, 0x94b5, 0x0474, 0x3c3c, 0xacfd, 0x5dbd, 0xcd7c, 0xff3e, 0x6fff, 0x9ebf, 0x0e7e,
            0xfa3b, 0x6afa, 0x9bba, 0x0b7b, 0x3939, 0xa9f8, 0x58b8, 0xc879, 0x2828, 0xb8e9, 0x49a9,
            0xd968, 0xeb2a, 0x7beb, 0x8aab, 0x1a6a, 0xee2f, 0x7eee, 0x8fae, 0x1f6f, 0x2d2d, 0xbdec,
            0x4cac, 0xdc6d, 0xe425, 0x74e4, 0x85a4, 0x1565, 0x2727, 0xb7e6, 0x46a6, 0xd667, 0x2222,
            0xb2e3, 0x43a3, 0xd362, 0xe120, 0x71e1, 0x80a1, 0x1060, 0xa061, 0x30a0, 0xc1e0, 0x5121,
            0x6363, 0xf3a2, 0x02e2, 0x9223, 0x6666, 0xf6a7, 0x07e7, 0x9726, 0xa564, 0x35a5, 0xc4e5,
            0x5424, 0x6c6c, 0xfcad, 0x0ded, 0x9d2c, 0xaf6e, 0x3faf, 0xceef, 0x5e2e, 0xaa6b, 0x3aaa,
            0xcbea, 0x5b2b, 0x6969, 0xf9a8, 0x08e8, 0x9829, 0x7878, 0xe8b9, 0x19f9, 0x8938, 0xbb7a,
            0x2bbb, 0xdafb, 0x4a3a, 0xbe7f, 0x2ebe, 0xdffe, 0x4f3f, 0x7d7d, 0xedbc, 0x1cfc, 0x8c3d,
            0xb475, 0x24b4, 0xd5f4, 0x4535, 0x7777, 0xe7b6, 0x16f6, 0x8637, 0x7272, 0xe2b3, 0x13f3,
            0x8332, 0xb170, 0x21b1, 0xd0f1, 0x4030, 0x5050, 0xc091, 0x31d1, 0xa110, 0x9352, 0x0393,
            0xf2d3, 0x6212, 0x9657, 0x0696, 0xf7d6, 0x6717, 0x5555, 0xc594, 0x34d4, 0xa415, 0x9c5d,
            0x0c9c, 0xfddc, 0x6d1d, 0x5f5f, 0xcf9e, 0x3ede, 0xae1f, 0x5a5a, 0xca9b, 0x3bdb, 0xab1a,
            0x9958, 0x0999, 0xf8d9, 0x6818, 0x8849, 0x1888, 0xe9c8, 0x7909, 0x4b4b, 0xdb8a, 0x2aca,
            0xba0b, 0x4e4e, 0xde8f, 0x2fcf, 0xbf0e, 0x8d4c, 0x1d8d, 0xeccd, 0x7c0c, 0x4444, 0xd485,
            0x25c5, 0xb504, 0x8746, 0x1787, 0xe6c7, 0x7606, 0x8243, 0x1282, 0xe3c2, 0x7303, 0x4141,
            0xd180, 0x20c0, 0xb001,
        ],
    ];

    pub static CRC16_NRSC_5_TABLE: [[u16; 256]; 16] = [
        [
            0x0000, 0x35a4, 0x6b48, 0x5eec, 0xd690, 0xe334, 0xbdd8, 0x887c, 0x0d01, 0x38a5, 0x6649,
            0x53ed, 0xdb91, 0xee35, 0xb0d9, 0x857d, 0x1a02, 0x2fa6, 0x714a, 0x44ee, 0xcc92, 0xf936,
            0xa7da, 0x927e, 0x1703, 0x22a7, 0x7c4b, 0x49ef, 0xc193, 0xf437, 0xaadb, 0x9f7f, 0x3404,
            0x01a0, 0x5f4c, 0x6ae8, 0xe294, 0xd730, 0x89dc, 0xbc78, 0x3905, 0x0ca1, 0x524d, 0x67e9,
            0xef95, 0xda31, 0x84dd, 0xb179, 0x2e06, 0x1ba2, 0x454e, 0x70ea, 0xf896, 0xcd32, 0x93de,
            0xa67a, 0x2307, 0x16a3, 0x484f, 0x7deb, 0xf597, 0xc033, 0x9edf, 0xab7b, 0x6808, 0x5dac,
            0x0340, 0x36e4, 0xbe98, 0x8b3c, 0xd5d0, 0xe074, 0x6509, 0x50ad, 0x0e41, 0x3be5, 0xb399,
            0x863d, 0xd8d1, 0xed75, 0x720a, 0x47ae, 0x1942, 0x2ce6, 0xa49a, 0x913e, 0xcfd2, 0xfa76,
            0x7f0b, 0x4aaf, 0x1443, 0x21e7, 0xa99b, 0x9c3f, 0xc2d3, 0xf777, 0x5c0c, 0x69a8, 0x3744,
            0x02e0, 0x8a9c, 0xbf38, 0xe1d4, 0xd470, 0x510d, 0x64a9, 0x3a45, 0x0fe1, 0x879d, 0xb239,
            0xecd5, 0xd971, 0x460e, 0x73aa, 0x2d46, 0x18e2, 0x909e, 0xa53a, 0xfbd6, 0xce72, 0x4b0f,
            0x7eab, 0x2047, 0x15e3, 0x9d9f, 0xa83b, 0xf6d7, 0xc373, 0xd010, 0xe5b4, 0xbb58, 0x8efc,
            0x0680, 0x3324, 0x6dc8, 0x586c, 0xdd11, 0xe8b5, 0xb659, 0x83fd, 0x0b81, 0x3e25, 0x60c9,
            0x556d, 0xca12, 0xffb6, 0xa15a, 0x94fe, 0x1c82, 0x2926, 0x77ca, 0x426e, 0xc713, 0xf2b7,
            0xac5b, 0x99ff, 0x1183, 0x2427, 0x7acb, 0x4f6f, 0xe414, 0xd1b0, 0x8f5c, 0xbaf8, 0x3284,
            0x0720, 0x59cc, 0x6c68, 0xe915, 0xdcb1, 0x825d, 0xb7f9, 0x3f85, 0x0a21, 0x54cd, 0x6169,
            0xfe16, 0xcbb2, 0x955e, 0xa0fa, 0x2886, 0x1d22, 0x43ce, 0x766a, 0xf317, 0xc6b3, 0x985f,
            0xadfb, 0x2587, 0x1023, 0x4ecf, 0x7b6b, 0xb818, 0x8dbc, 0xd350, 0xe6f4, 0x6e88, 0x5b2c,
            0x05c0, 0x3064, 0xb519, 0x80bd, 0xde51, 0xebf5, 0x6389, 0x562d, 0x08c1, 0x3d65, 0xa21a,
            0x97be, 0xc952, 0xfcf6, 0x748a, 0x412e, 0x1fc2, 0x2a66, 0xaf1b, 0x9abf, 0xc453, 0xf1f7,
            0x798b, 0x4c2f, 0x12c3, 0x2767, 0x8c1c, 0xb9b8, 0xe754, 0xd2f0, 0x5a8c, 0x6f28, 0x31c4,
            0x0460, 0x811d, 0xb4b9, 0xea55, 0xdff1, 0x578d, 0x6229, 0x3cc5, 0x0961, 0x961e, 0xa3ba,
            0xfd56, 0xc8f2, 0x408e, 0x752a, 0x2bc6, 0x1e62, 0x9b1f, 0xaebb, 0xf057, 0xc5f3, 0x4d8f,
            0x782b, 0x26c7, 0x1363,
        ],
        [
            0x0000, 0x32b1, 0x6562, 0x57d3, 0xcac4, 0xf875, 0xafa6, 0x9d17, 0x35a9, 0x0718, 0x50cb,
            0x627a, 0xff6d, 0xcddc, 0x9a0f, 0xa8be, 0x6b52, 0x59e3, 0x0e30, 0x3c81, 0xa196, 0x9327,
            0xc4f4, 0xf645, 0x5efb, 0x6c4a, 0x3b99, 0x0928, 0x943f, 0xa68e, 0xf15d, 0xc3ec, 0xd6a4,
            0xe415, 0xb3c6, 0x8177, 0x1c60, 0x2ed1, 0x7902, 0x4bb3, 0xe30d, 0xd1bc, 0x866f, 0xb4de,
            0x29c9, 0x1b78, 0x4cab, 0x7e1a, 0xbdf6, 0x8f47, 0xd894, 0xea25, 0x7732, 0x4583, 0x1250,
            0x20e1, 0x885f, 0xbaee, 0xed3d, 0xdf8c, 0x429b, 0x702a, 0x27f9, 0x1548, 0x0d69, 0x3fd8,
            0x680b, 0x5aba, 0xc7ad, 0xf51c, 0xa2cf, 0x907e, 0x38c0, 0x0a71, 0x5da2, 0x6f13, 0xf204,
            0xc0b5, 0x9766, 0xa5d7, 0x663b, 0x548a, 0x0359, 0x31e8, 0xacff, 0x9e4e, 0xc99d, 0xfb2c,
            0x5392, 0x6123, 0x36f0, 0x0441, 0x9956, 0xabe7, 0xfc34, 0xce85, 0xdbcd, 0xe97c, 0xbeaf,
            0x8c1e, 0x1109, 0x23b8, 0x746b, 0x46da, 0xee64, 0xdcd5, 0x8b06, 0xb9b7, 0x24a0, 0x1611,
            0x41c2, 0x7373, 0xb09f, 0x822e, 0xd5fd, 0xe74c, 0x7a5b, 0x48ea, 0x1f39, 0x2d88, 0x8536,
            0xb787, 0xe054, 0xd2e5, 0x4ff2, 0x7d43, 0x2a90, 0x1821, 0x1ad2, 0x2863, 0x7fb0, 0x4d01,
            0xd016, 0xe2a7, 0xb574, 0x87c5, 0x2f7b, 0x1dca, 0x4a19, 0x78a8, 0xe5bf, 0xd70e, 0x80dd,
            0xb26c, 0x7180, 0x4331, 0x14e2, 0x2653, 0xbb44, 0x89f5, 0xde26, 0xec97, 0x4429, 0x7698,
            0x214b, 0x13fa, 0x8eed, 0xbc5c, 0xeb8f, 0xd93e, 0xcc76, 0xfec7, 0xa914, 0x9ba5, 0x06b2,
            0x3403, 0x63d0, 0x5161, 0xf9df, 0xcb6e, 0x9cbd, 0xae0c, 0x331b, 0x01aa, 0x5679, 0x64c8,
            0xa724, 0x9595, 0xc246, 0xf0f7, 0x6de0, 0x5f51, 0x0882, 0x3a33, 0x928d, 0xa03c, 0xf7ef,
            0xc55e, 0x5849, 0x6af8, 0x3d2b, 0x0f9a, 0x17bb, 0x250a, 0x72d9, 0x4068, 0xdd7f, 0xefce,
            0xb81d, 0x8aac, 0x2212, 0x10a3, 0x4770, 0x75c1, 0xe8d6, 0xda67, 0x8db4, 0xbf05, 0x7ce9,
            0x4e58, 0x198b, 0x2b3a, 0xb62d, 0x849c, 0xd34f, 0xe1fe, 0x4940, 0x7bf1, 0x2c22, 0x1e93,
            0x8384, 0xb135, 0xe6e6, 0xd457, 0xc11f, 0xf3ae, 0xa47d, 0x96cc, 0x0bdb, 0x396a, 0x6eb9,
            0x5c08, 0xf4b6, 0xc607, 0x91d4, 0xa365, 0x3e72, 0x0cc3, 0x5b10, 0x69a1, 0xaa4d, 0x98fc,
            0xcf2f, 0xfd9e, 0x6089, 0x5238, 0x05eb, 0x375a, 0x9fe4, 0xad55, 0xfa86, 0xc837, 0x5520,
            0x6791, 0x3042, 0x02f3,
        ],
        [
            0x0000, 0xcb80, 0x3721, 0xfca1, 0x6e42, 0xa5c2, 0x5963, 0x92e3, 0xdc84, 0x1704, 0xeba5,
            0x2025, 0xb2c6, 0x7946, 0x85e7, 0x4e67, 0x1929, 0xd2a9, 0x2e08, 0xe588, 0x776b, 0xbceb,
            0x404a, 0x8bca, 0xc5ad, 0x0e2d, 0xf28c, 0x390c, 0xabef, 0x606f, 0x9cce, 0x574e, 0x3252,
            0xf9d2, 0x0573, 0xcef3, 0x5c10, 0x9790, 0x6b31, 0xa0b1, 0xeed6, 0x2556, 0xd9f7, 0x1277,
            0x8094, 0x4b14, 0xb7b5, 0x7c35, 0x2b7b, 0xe0fb, 0x1c5a, 0xd7da, 0x4539, 0x8eb9, 0x7218,
            0xb998, 0xf7ff, 0x3c7f, 0xc0de, 0x0b5e, 0x99bd, 0x523d, 0xae9c, 0x651c, 0x64a4, 0xaf24,
            0x5385, 0x9805, 0x0ae6, 0xc166, 0x3dc7, 0xf647, 0xb820, 0x73a0, 0x8f01, 0x4481, 0xd662,
            0x1de2, 0xe143, 0x2ac3, 0x7d8d, 0xb60d, 0x4aac, 0x812c, 0x13cf, 0xd84f, 0x24ee, 0xef6e,
            0xa109, 0x6a89, 0x9628, 0x5da8, 0xcf4b, 0x04cb, 0xf86a, 0x33ea, 0x56f6, 0x9d76, 0x61d7,
            0xaa57, 0x38b4, 0xf334, 0x0f95, 0xc415, 0x8a72, 0x41f2, 0xbd53, 0x76d3, 0xe430, 0x2fb0,
            0xd311, 0x1891, 0x4fdf, 0x845f, 0x78fe, 0xb37e, 0x219d, 0xea1d, 0x16bc, 0xdd3c, 0x935b,
            0x58db, 0xa47a, 0x6ffa, 0xfd19, 0x3699, 0xca38, 0x01b8, 0xc948, 0x02c8, 0xfe69, 0x35e9,
            0xa70a, 0x6c8a, 0x902b, 0x5bab, 0x15cc, 0xde4c, 0x22ed, 0xe96d, 0x7b8e, 0xb00e, 0x4caf,
            0x872f, 0xd061, 0x1be1, 0xe740, 0x2cc0, 0xbe23, 0x75a3, 0x8902, 0x4282, 0x0ce5, 0xc765,
            0x3bc4, 0xf044, 0x62a7, 0xa927, 0x5586, 0x9e06, 0xfb1a, 0x309a, 0xcc3b, 0x07bb, 0x9558,
            0x5ed8, 0xa279, 0x69f9, 0x279e, 0xec1e, 0x10bf, 0xdb3f, 0x49dc, 0x825c, 0x7efd, 0xb57d,
            0xe233, 0x29b3, 0xd512, 0x1e92, 0x8c71, 0x47f1, 0xbb50, 0x70d0, 0x3eb7, 0xf537, 0x0996,
            0xc216, 0x50f5, 0x9b75, 0x67d4, 0xac54, 0xadec, 0x666c, 0x9acd, 0x514d, 0xc3ae, 0x082e,
            0xf48f, 0x3f0f, 0x7168, 0xbae8, 0x4649, 0x8dc9, 0x1f2a, 0xd4aa, 0x280b, 0xe38b, 0xb4c5,
            0x7f45, 0x83e4, 0x4864, 0xda87, 0x1107, 0xeda6, 0x2626, 0x6841, 0xa3c1, 0x5f60, 0x94e0,
            0x0603, 0xcd83, 0x3122, 0xfaa2, 0x9fbe, 0x543e, 0xa89f, 0x631f, 0xf1fc, 0x3a7c, 0xc6dd,
            0x0d5d, 0x433a, 0x88ba, 0x741b, 0xbf9b, 0x2d78, 0xe6f8, 0x1a59, 0xd1d9, 0x8697, 0x4d17,
            0xb1b6, 0x7a36, 0xe8d5, 0x2355, 0xdff4, 0x1474, 0x5a13, 0x9193, 0x6d32, 0xa6b2, 0x3451,
            0xffd1, 0x0370, 0xc8f0,
        ],
        [
            0x0000, 0xd0db, 0x0197, 0xd14c, 0x032e, 0xd3f5, 0x02b9, 0xd262, 0x065c, 0xd687, 0x07cb,
            0xd710, 0x0572, 0xd5a9, 0x04e5, 0xd43e, 0x0cb8, 0xdc63, 0x0d2f, 0xddf4, 0x0f96, 0xdf4d,
            0x0e01, 0xdeda, 0x0ae4, 0xda3f, 0x0b73, 0xdba8, 0x09ca, 0xd911, 0x085d, 0xd886, 0x1970,
            0xc9ab, 0x18e7, 0xc83c, 0x1a5e, 0xca85, 0x1bc9, 0xcb12, 0x1f2c, 0xcff7, 0x1ebb, 0xce60,
            0x1c02, 0xccd9, 0x1d95, 0xcd4e, 0x15c8, 0xc513, 0x145f, 0xc484, 0x16e6, 0xc63d, 0x1771,
            0xc7aa, 0x1394, 0xc34f, 0x1203, 0xc2d8, 0x10ba, 0xc061, 0x112d, 0xc1f6, 0x32e0, 0xe23b,
            0x3377, 0xe3ac, 0x31ce, 0xe115, 0x3059, 0xe082, 0x34bc, 0xe467, 0x352b, 0xe5f0, 0x3792,
            0xe749, 0x3605, 0xe6de, 0x3e58, 0xee83, 0x3fcf, 0xef14, 0x3d76, 0xedad, 0x3ce1, 0xec3a,
            0x3804, 0xe8df, 0x3993, 0xe948, 0x3b2a, 0xebf1, 0x3abd, 0xea66, 0x2b90, 0xfb4b, 0x2a07,
            0xfadc, 0x28be, 0xf865, 0x2929, 0xf9f2, 0x2dcc, 0xfd17, 0x2c5b, 0xfc80, 0x2ee2, 0xfe39,
            0x2f75, 0xffae, 0x2728, 0xf7f3, 0x26bf, 0xf664, 0x2406, 0xf4dd, 0x2591, 0xf54a, 0x2174,
            0xf1af, 0x20e3, 0xf038, 0x225a, 0xf281, 0x23cd, 0xf316, 0x65c0, 0xb51b, 0x6457, 0xb48c,
            0x66ee, 0xb635, 0x6779, 0xb7a2, 0x639c, 0xb347, 0x620b, 0xb2d0, 0x60b2, 0xb069, 0x6125,
            0xb1fe, 0x6978, 0xb9a3, 0x68ef, 0xb834, 0x6a56, 0xba8d, 0x6bc1, 0xbb1a, 0x6f24, 0xbfff,
            0x6eb3, 0xbe68, 0x6c0a, 0xbcd1, 0x6d9d, 0xbd46, 0x7cb0, 0xac6b, 0x7d27, 0xadfc, 0x7f9e,
            0xaf45, 0x7e09, 0xaed2, 0x7aec, 0xaa37, 0x7b7b, 0xaba0, 0x79c2, 0xa919, 0x7855, 0xa88e,
            0x7008, 0xa0d3, 0x719f, 0xa144, 0x7326, 0xa3fd, 0x72b1, 0xa26a, 0x7654, 0xa68f, 0x77c3,
            0xa718, 0x757a, 0xa5a1, 0x74ed, 0xa436, 0x5720, 0x87fb, 0x56b7, 0x866c, 0x540e, 0x84d5,
            0x5599, 0x8542, 0x517c, 0x81a7, 0x50eb, 0x8030, 0x5252, 0x8289, 0x53c5, 0x831e, 0x5b98,
            0x8b43, 0x5a0f, 0x8ad4, 0x58b6, 0x886d, 0x5921, 0x89fa, 0x5dc4, 0x8d1f, 0x5c53, 0x8c88,
            0x5eea, 0x8e31, 0x5f7d, 0x8fa6, 0x4e50, 0x9e8b, 0x4fc7, 0x9f1c, 0x4d7e, 0x9da5, 0x4ce9,
            0x9c32, 0x480c, 0x98d7, 0x499b, 0x9940, 0x4b22, 0x9bf9, 0x4ab5, 0x9a6e, 0x42e8, 0x9233,
            0x437f, 0x93a4, 0x41c6, 0x911d, 0x4051, 0x908a, 0x44b4, 0x946f, 0x4523, 0x95f8, 0x479a,
            0x9741, 0x460d, 0x96d6,
        ],
        [
            0x0000, 0xf127, 0x426f, 0xb348, 0x84de, 0x75f9, 0xc6b1, 0x3796, 0xa99d, 0x58ba, 0xebf2,
            0x1ad5, 0x2d43, 0xdc64, 0x6f2c, 0x9e0b, 0xf31b, 0x023c, 0xb174, 0x4053, 0x77c5, 0x86e2,
            0x35aa, 0xc48d, 0x5a86, 0xaba1, 0x18e9, 0xe9ce, 0xde58, 0x2f7f, 0x9c37, 0x6d10, 0x4617,
            0xb730, 0x0478, 0xf55f, 0xc2c9, 0x33ee, 0x80a6, 0x7181, 0xef8a, 0x1ead, 0xade5, 0x5cc2,
            0x6b54, 0x9a73, 0x293b, 0xd81c, 0xb50c, 0x442b, 0xf763, 0x0644, 0x31d2, 0xc0f5, 0x73bd,
            0x829a, 0x1c91, 0xedb6, 0x5efe, 0xafd9, 0x984f, 0x6968, 0xda20, 0x2b07, 0x8c2e, 0x7d09,
            0xce41, 0x3f66, 0x08f0, 0xf9d7, 0x4a9f, 0xbbb8, 0x25b3, 0xd494, 0x67dc, 0x96fb, 0xa16d,
            0x504a, 0xe302, 0x1225, 0x7f35, 0x8e12, 0x3d5a, 0xcc7d, 0xfbeb, 0x0acc, 0xb984, 0x48a3,
            0xd6a8, 0x278f, 0x94c7, 0x65e0, 0x5276, 0xa351, 0x1019, 0xe13e, 0xca39, 0x3b1e, 0x8856,
            0x7971, 0x4ee7, 0xbfc0, 0x0c88, 0xfdaf, 0x63a4, 0x9283, 0x21cb, 0xd0ec, 0xe77a, 0x165d,
            0xa515, 0x5432, 0x3922, 0xc805, 0x7b4d, 0x8a6a, 0xbdfc, 0x4cdb, 0xff93, 0x0eb4, 0x90bf,
            0x6198, 0xd2d0, 0x23f7, 0x1461, 0xe546, 0x560e, 0xa729, 0xb87d, 0x495a, 0xfa12, 0x0b35,
            0x3ca3, 0xcd84, 0x7ecc, 0x8feb, 0x11e0, 0xe0c7, 0x538f, 0xa2a8, 0x953e, 0x6419, 0xd751,
            0x2676, 0x4b66, 0xba41, 0x0909, 0xf82e, 0xcfb8, 0x3e9f, 0x8dd7, 0x7cf0, 0xe2fb, 0x13dc,
            0xa094, 0x51b3, 0x6625, 0x9702, 0x244a, 0xd56d, 0xfe6a, 0x0f4d, 0xbc05, 0x4d22, 0x7ab4,
            0x8b93, 0x38db, 0xc9fc, 0x57f7, 0xa6d0, 0x1598, 0xe4bf, 0xd329, 0x220e, 0x9146, 0x6061,
            0x0d71, 0xfc56, 0x4f1e, 0xbe39, 0x89af, 0x7888, 0xcbc0, 0x3ae7, 0xa4ec, 0x55cb, 0xe683,
            0x17a4, 0x2032, 0xd115, 0x625d, 0x937a, 0x3453, 0xc574, 0x763c, 0x871b, 0xb08d, 0x41aa,
            0xf2e2, 0x03c5, 0x9dce, 0x6ce9, 0xdfa1, 0x2e86, 0x1910, 0xe837, 0x5b7f, 0xaa58, 0xc748,
            0x366f, 0x8527, 0x7400, 0x4396, 0xb2b1, 0x01f9, 0xf0de, 0x6ed5, 0x9ff2, 0x2cba, 0xdd9d,
            0xea0b, 0x1b2c, 0xa864, 0x5943, 0x7244, 0x8363, 0x302b, 0xc10c, 0xf69a, 0x07bd, 0xb4f5,
            0x45d2, 0xdbd9, 0x2afe, 0x99b6, 0x6891, 0x5f07, 0xae20, 0x1d68, 0xec4f, 0x815f, 0x7078,
            0xc330, 0x3217, 0x0581, 0xf4a6, 0x47ee, 0xb6c9, 0x28c2, 0xd9e5, 0x6aad, 0x9b8a, 0xac1c,
            0x5d3b, 0xee73, 0x1f54,
        ],
        [
            0x0000, 0xbc89, 0xd933, 0x65ba, 0x1247, 0xaece, 0xcb74, 0x77fd, 0x248e, 0x9807, 0xfdbd,
            0x4134, 0x36c9, 0x8a40, 0xeffa, 0x5373, 0x491c, 0xf595, 0x902f, 0x2ca6, 0x5b5b, 0xe7d2,
            0x8268, 0x3ee1, 0x6d92, 0xd11b, 0xb4a1, 0x0828, 0x7fd5, 0xc35c, 0xa6e6, 0x1a6f, 0x9238,
            0x2eb1, 0x4b0b, 0xf782, 0x807f, 0x3cf6, 0x594c, 0xe5c5, 0xb6b6, 0x0a3f, 0x6f85, 0xd30c,
            0xa4f1, 0x1878, 0x7dc2, 0xc14b, 0xdb24, 0x67ad, 0x0217, 0xbe9e, 0xc963, 0x75ea, 0x1050,
            0xacd9, 0xffaa, 0x4323, 0x2699, 0x9a10, 0xeded, 0x5164, 0x34de, 0x8857, 0x8451, 0x38d8,
            0x5d62, 0xe1eb, 0x9616, 0x2a9f, 0x4f25, 0xf3ac, 0xa0df, 0x1c56, 0x79ec, 0xc565, 0xb298,
            0x0e11, 0x6bab, 0xd722, 0xcd4d, 0x71c4, 0x147e, 0xa8f7, 0xdf0a, 0x6383, 0x0639, 0xbab0,
            0xe9c3, 0x554a, 0x30f0, 0x8c79, 0xfb84, 0x470d, 0x22b7, 0x9e3e, 0x1669, 0xaae0, 0xcf5a,
            0x73d3, 0x042e, 0xb8a7, 0xdd1d, 0x6194, 0x32e7, 0x8e6e, 0xebd4, 0x575d, 0x20a0, 0x9c29,
            0xf993, 0x451a, 0x5f75, 0xe3fc, 0x8646, 0x3acf, 0x4d32, 0xf1bb, 0x9401, 0x2888, 0x7bfb,
            0xc772, 0xa2c8, 0x1e41, 0x69bc, 0xd535, 0xb08f, 0x0c06, 0xa883, 0x140a, 0x71b0, 0xcd39,
            0xbac4, 0x064d, 0x63f7, 0xdf7e, 0x8c0d, 0x3084, 0x553e, 0xe9b7, 0x9e4a, 0x22c3, 0x4779,
            0xfbf0, 0xe19f, 0x5d16, 0x38ac, 0x8425, 0xf3d8, 0x4f51, 0x2aeb, 0x9662, 0xc511, 0x7998,
            0x1c22, 0xa0ab, 0xd756, 0x6bdf, 0x0e65, 0xb2ec, 0x3abb, 0x8632, 0xe388, 0x5f01, 0x28fc,
            0x9475, 0xf1cf, 0x4d46, 0x1e35, 0xa2bc, 0xc706, 0x7b8f, 0x0c72, 0xb0fb, 0xd541, 0x69c8,
            0x73a7, 0xcf2e, 0xaa94, 0x161d, 0x61e0, 0xdd69, 0xb8d3, 0x045a, 0x5729, 0xeba0, 0x8e1a,
            0x3293, 0x456e, 0xf9e7, 0x9c5d, 0x20d4, 0x2cd2, 0x905b, 0xf5e1, 0x4968, 0x3e95, 0x821c,
            0xe7a6, 0x5b2f, 0x085c, 0xb4d5, 0xd16f, 0x6de6, 0x1a1b, 0xa692, 0xc328, 0x7fa1, 0x65ce,
            0xd947, 0xbcfd, 0x0074, 0x7789, 0xcb00, 0xaeba, 0x1233, 0x4140, 0xfdc9, 0x9873, 0x24fa,
            0x5307, 0xef8e, 0x8a34, 0x36bd, 0xbeea, 0x0263, 0x67d9, 0xdb50, 0xacad, 0x1024, 0x759e,
            0xc917, 0x9a64, 0x26ed, 0x4357, 0xffde, 0x8823, 0x34aa, 0x5110, 0xed99, 0xf7f6, 0x4b7f,
            0x2ec5, 0x924c, 0xe5b1, 0x5938, 0x3c82, 0x800b, 0xd378, 0x6ff1, 0x0a4b, 0xb6c2, 0xc13f,
            0x7db6, 0x180c, 0xa485,
        ],
        [
            0x0000, 0xe809, 0x7033, 0x983a, 0xe066, 0x086f, 0x9055, 0x785c, 0x60ed, 0x88e4, 0x10de,
            0xf8d7, 0x808b, 0x6882, 0xf0b8, 0x18b1, 0xc1da, 0x29d3, 0xb1e9, 0x59e0, 0x21bc, 0xc9b5,
            0x518f, 0xb986, 0xa137, 0x493e, 0xd104, 0x390d, 0x4151, 0xa958, 0x3162, 0xd96b, 0x2395,
            0xcb9c, 0x53a6, 0xbbaf, 0xc3f3, 0x2bfa, 0xb3c0, 0x5bc9, 0x4378, 0xab71, 0x334b, 0xdb42,
            0xa31e, 0x4b17, 0xd32d, 0x3b24, 0xe24f, 0x0a46, 0x927c, 0x7a75, 0x0229, 0xea20, 0x721a,
            0x9a13, 0x82a2, 0x6aab, 0xf291, 0x1a98, 0x62c4, 0x8acd, 0x12f7, 0xfafe, 0x472a, 0xaf23,
            0x3719, 0xdf10, 0xa74c, 0x4f45, 0xd77f, 0x3f76, 0x27c7, 0xcfce, 0x57f4, 0xbffd, 0xc7a1,
            0x2fa8, 0xb792, 0x5f9b, 0x86f0, 0x6ef9, 0xf6c3, 0x1eca, 0x6696, 0x8e9f, 0x16a5, 0xfeac,
            0xe61d, 0x0e14, 0x962e, 0x7e27, 0x067b, 0xee72, 0x7648, 0x9e41, 0x64bf, 0x8cb6, 0x148c,
            0xfc85, 0x84d9, 0x6cd0, 0xf4ea, 0x1ce3, 0x0452, 0xec5b, 0x7461, 0x9c68, 0xe434, 0x0c3d,
            0x9407, 0x7c0e, 0xa565, 0x4d6c, 0xd556, 0x3d5f, 0x4503, 0xad0a, 0x3530, 0xdd39, 0xc588,
            0x2d81, 0xb5bb, 0x5db2, 0x25ee, 0xcde7, 0x55dd, 0xbdd4, 0x8e54, 0x665d, 0xfe67, 0x166e,
            0x6e32, 0x863b, 0x1e01, 0xf608, 0xeeb9, 0x06b0, 0x9e8a, 0x7683, 0x0edf, 0xe6d6, 0x7eec,
            0x96e5, 0x4f8e, 0xa787, 0x3fbd, 0xd7b4, 0xafe8, 0x47e1, 0xdfdb, 0x37d2, 0x2f63, 0xc76a,
            0x5f50, 0xb759, 0xcf05, 0x270c, 0xbf36, 0x573f, 0xadc1, 0x45c8, 0xddf2, 0x35fb, 0x4da7,
            0xa5ae, 0x3d94, 0xd59d, 0xcd2c, 0x2525, 0xbd1f, 0x5516, 0x2d4a, 0xc543, 0x5d79, 0xb570,
            0x6c1b, 0x8412, 0x1c28, 0xf421, 0x8c7d, 0x6474, 0xfc4e, 0x1447, 0x0cf6, 0xe4ff, 0x7cc5,
            0x94cc, 0xec90, 0x0499, 0x9ca3, 0x74aa, 0xc97e, 0x2177, 0xb94d, 0x5144, 0x2918, 0xc111,
            0x592b, 0xb122, 0xa993, 0x419a, 0xd9a0, 0x31a9, 0x49f5, 0xa1fc, 0x39c6, 0xd1cf, 0x08a4,
            0xe0ad, 0x7897, 0x909e, 0xe8c2, 0x00cb, 0x98f1, 0x70f8, 0x6849, 0x8040, 0x187a, 0xf073,
            0x882f, 0x6026, 0xf81c, 0x1015, 0xeaeb, 0x02e2, 0x9ad8, 0x72d1, 0x0a8d, 0xe284, 0x7abe,
            0x92b7, 0x8a06, 0x620f, 0xfa35, 0x123c, 0x6a60, 0x8269, 0x1a53, 0xf25a, 0x2b31, 0xc338,
            0x5b02, 0xb30b, 0xcb57, 0x235e, 0xbb64, 0x536d, 0x4bdc, 0xa3d5, 0x3bef, 0xd3e6, 0xabba,
            0x43b3, 0xdb89, 0x3380,
        ],
        [
            0x0000, 0x384d, 0x709a, 0x48d7, 0xe134, 0xd979, 0x91ae, 0xa9e3, 0x6249, 0x5a04, 0x12d3,
            0x2a9e, 0x837d, 0xbb30, 0xf3e7, 0xcbaa, 0xc492, 0xfcdf, 0xb408, 0x8c45, 0x25a6, 0x1deb,
            0x553c, 0x6d71, 0xa6db, 0x9e96, 0xd641, 0xee0c, 0x47ef, 0x7fa2, 0x3775, 0x0f38, 0x2905,
            0x1148, 0x599f, 0x61d2, 0xc831, 0xf07c, 0xb8ab, 0x80e6, 0x4b4c, 0x7301, 0x3bd6, 0x039b,
            0xaa78, 0x9235, 0xdae2, 0xe2af, 0xed97, 0xd5da, 0x9d0d, 0xa540, 0x0ca3, 0x34ee, 0x7c39,
            0x4474, 0x8fde, 0xb793, 0xff44, 0xc709, 0x6eea, 0x56a7, 0x1e70, 0x263d, 0x520a, 0x6a47,
            0x2290, 0x1add, 0xb33e, 0x8b73, 0xc3a4, 0xfbe9, 0x3043, 0x080e, 0x40d9, 0x7894, 0xd177,
            0xe93a, 0xa1ed, 0x99a0, 0x9698, 0xaed5, 0xe602, 0xde4f, 0x77ac, 0x4fe1, 0x0736, 0x3f7b,
            0xf4d1, 0xcc9c, 0x844b, 0xbc06, 0x15e5, 0x2da8, 0x657f, 0x5d32, 0x7b0f, 0x4342, 0x0b95,
            0x33d8, 0x9a3b, 0xa276, 0xeaa1, 0xd2ec, 0x1946, 0x210b, 0x69dc, 0x5191, 0xf872, 0xc03f,
            0x88e8, 0xb0a5, 0xbf9d, 0x87d0, 0xcf07, 0xf74a, 0x5ea9, 0x66e4, 0x2e33, 0x167e, 0xddd4,
            0xe599, 0xad4e, 0x9503, 0x3ce0, 0x04ad, 0x4c7a, 0x7437, 0xa414, 0x9c59, 0xd48e, 0xecc3,
            0x4520, 0x7d6d, 0x35ba, 0x0df7, 0xc65d, 0xfe10, 0xb6c7, 0x8e8a, 0x2769, 0x1f24, 0x57f3,
            0x6fbe, 0x6086, 0x58cb, 0x101c, 0x2851, 0x81b2, 0xb9ff, 0xf128, 0xc965, 0x02cf, 0x3a82,
            0x7255, 0x4a18, 0xe3fb, 0xdbb6, 0x9361, 0xab2c, 0x8d11, 0xb55c, 0xfd8b, 0xc5c6, 0x6c25,
            0x5468, 0x1cbf, 0x24f2, 0xef58, 0xd715, 0x9fc2, 0xa78f, 0x0e6c, 0x3621, 0x7ef6, 0x46bb,
            0x4983, 0x71ce, 0x3919, 0x0154, 0xa8b7, 0x90fa, 0xd82d, 0xe060, 0x2bca, 0x1387, 0x5b50,
            0x631d, 0xcafe, 0xf2b3, 0xba64, 0x8229, 0xf61e, 0xce53, 0x8684, 0xbec9, 0x172a, 0x2f67,
            0x67b0, 0x5ffd, 0x9457, 0xac1a, 0xe4cd, 0xdc80, 0x7563, 0x4d2e, 0x05f9, 0x3db4, 0x328c,
            0x0ac1, 0x4216, 0x7a5b, 0xd3b8, 0xebf5, 0xa322, 0x9b6f, 0x50c5, 0x6888, 0x205f, 0x1812,
            0xb1f1, 0x89bc, 0xc16b, 0xf926, 0xdf1b, 0xe756, 0xaf81, 0x97cc, 0x3e2f, 0x0662, 0x4eb5,
            0x76f8, 0xbd52, 0x851f, 0xcdc8, 0xf585, 0x5c66, 0x642b, 0x2cfc, 0x14b1, 0x1b89, 0x23c4,
            0x6b13, 0x535e, 0xfabd, 0xc2f0, 0x8a27, 0xb26a, 0x79c0, 0x418d, 0x095a, 0x3117, 0x98f4,
            0xa0b9, 0xe86e, 0xd023,
        ],
        [
            0x0000, 0x8605, 0xac2b, 0x2a2e, 0xf877, 0x7e72, 0x545c, 0xd259, 0x50cf, 0xd6ca, 0xfce4,
            0x7ae1, 0xa8b8, 0x2ebd, 0x0493, 0x8296, 0xa19e, 0x279b, 0x0db5, 0x8bb0, 0x59e9, 0xdfec,
            0xf5c2, 0x73c7, 0xf151, 0x7754, 0x5d7a, 0xdb7f, 0x0926, 0x8f23, 0xa50d, 0x2308, 0xe31d,
            0x6518, 0x4f36, 0xc933, 0x1b6a, 0x9d6f, 0xb741, 0x3144, 0xb3d2, 0x35d7, 0x1ff9, 0x99fc,
            0x4ba5, 0xcda0, 0xe78e, 0x618b, 0x4283, 0xc486, 0xeea8, 0x68ad, 0xbaf4, 0x3cf1, 0x16df,
            0x90da, 0x124c, 0x9449, 0xbe67, 0x3862, 0xea3b, 0x6c3e, 0x4610, 0xc015, 0x661b, 0xe01e,
            0xca30, 0x4c35, 0x9e6c, 0x1869, 0x3247, 0xb442, 0x36d4, 0xb0d1, 0x9aff, 0x1cfa, 0xcea3,
            0x48a6, 0x6288, 0xe48d, 0xc785, 0x4180, 0x6bae, 0xedab, 0x3ff2, 0xb9f7, 0x93d9, 0x15dc,
            0x974a, 0x114f, 0x3b61, 0xbd64, 0x6f3d, 0xe938, 0xc316, 0x4513, 0x8506, 0x0303, 0x292d,
            0xaf28, 0x7d71, 0xfb74, 0xd15a, 0x575f, 0xd5c9, 0x53cc, 0x79e2, 0xffe7, 0x2dbe, 0xabbb,
            0x8195, 0x0790, 0x2498, 0xa29d, 0x88b3, 0x0eb6, 0xdcef, 0x5aea, 0x70c4, 0xf6c1, 0x7457,
            0xf252, 0xd87c, 0x5e79, 0x8c20, 0x0a25, 0x200b, 0xa60e, 0xcc36, 0x4a33, 0x601d, 0xe618,
            0x3441, 0xb244, 0x986a, 0x1e6f, 0x9cf9, 0x1afc, 0x30d2, 0xb6d7, 0x648e, 0xe28b, 0xc8a5,
            0x4ea0, 0x6da8, 0xebad, 0xc183, 0x4786, 0x95df, 0x13da, 0x39f4, 0xbff1, 0x3d67, 0xbb62,
            0x914c, 0x1749, 0xc510, 0x4315, 0x693b, 0xef3e, 0x2f2b, 0xa92e, 0x8300, 0x0505, 0xd75c,
            0x5159, 0x7b77, 0xfd72, 0x7fe4, 0xf9e1, 0xd3cf, 0x55ca, 0x8793, 0x0196, 0x2bb8, 0xadbd,
            0x8eb5, 0x08b0, 0x229e, 0xa49b, 0x76c2, 0xf0c7, 0xdae9, 0x5cec, 0xde7a, 0x587f, 0x7251,
            0xf454, 0x260d, 0xa008, 0x8a26, 0x0c23, 0xaa2d, 0x2c28, 0x0606, 0x8003, 0x525a, 0xd45f,
            0xfe71, 0x7874, 0xfae2, 0x7ce7, 0x56c9, 0xd0cc, 0x0295, 0x8490, 0xaebe, 0x28bb, 0x0bb3,
            0x8db6, 0xa798, 0x219d, 0xf3c4, 0x75c1, 0x5fef, 0xd9ea, 0x5b7c, 0xdd79, 0xf757, 0x7152,
            0xa30b, 0x250e, 0x0f20, 0x8925, 0x4930, 0xcf35, 0xe51b, 0x631e, 0xb147, 0x3742, 0x1d6c,
            0x9b69, 0x19ff, 0x9ffa, 0xb5d4, 0x33d1, 0xe188, 0x678d, 0x4da3, 0xcba6, 0xe8ae, 0x6eab,
            0x4485, 0xc280, 0x10d9, 0x96dc, 0xbcf2, 0x3af7, 0xb861, 0x3e64, 0x144a, 0x924f, 0x4016,
            0xc613, 0xec3d, 0x6a38,
        ],
        [
            0x0000, 0xe3b2, 0x6745, 0x84f7, 0xce8a, 0x2d38, 0xa9cf, 0x4a7d, 0x3d35, 0xde87, 0x5a70,
            0xb9c2, 0xf3bf, 0x100d, 0x94fa, 0x7748, 0x7a6a, 0x99d8, 0x1d2f, 0xfe9d, 0xb4e0, 0x5752,
            0xd3a5, 0x3017, 0x475f, 0xa4ed, 0x201a, 0xc3a8, 0x89d5, 0x6a67, 0xee90, 0x0d22, 0xf4d4,
            0x1766, 0x9391, 0x7023, 0x3a5e, 0xd9ec, 0x5d1b, 0xbea9, 0xc9e1, 0x2a53, 0xaea4, 0x4d16,
            0x076b, 0xe4d9, 0x602e, 0x839c, 0x8ebe, 0x6d0c, 0xe9fb, 0x0a49, 0x4034, 0xa386, 0x2771,
            0xc4c3, 0xb38b, 0x5039, 0xd4ce, 0x377c, 0x7d01, 0x9eb3, 0x1a44, 0xf9f6, 0x4989, 0xaa3b,
            0x2ecc, 0xcd7e, 0x8703, 0x64b1, 0xe046, 0x03f4, 0x74bc, 0x970e, 0x13f9, 0xf04b, 0xba36,
            0x5984, 0xdd73, 0x3ec1, 0x33e3, 0xd051, 0x54a6, 0xb714, 0xfd69, 0x1edb, 0x9a2c, 0x799e,
            0x0ed6, 0xed64, 0x6993, 0x8a21, 0xc05c, 0x23ee, 0xa719, 0x44ab, 0xbd5d, 0x5eef, 0xda18,
            0x39aa, 0x73d7, 0x9065, 0x1492, 0xf720, 0x8068, 0x63da, 0xe72d, 0x049f, 0x4ee2, 0xad50,
            0x29a7, 0xca15, 0xc737, 0x2485, 0xa072, 0x43c0, 0x09bd, 0xea0f, 0x6ef8, 0x8d4a, 0xfa02,
            0x19b0, 0x9d47, 0x7ef5, 0x3488, 0xd73a, 0x53cd, 0xb07f, 0x9312, 0x70a0, 0xf457, 0x17e5,
            0x5d98, 0xbe2a, 0x3add, 0xd96f, 0xae27, 0x4d95, 0xc962, 0x2ad0, 0x60ad, 0x831f, 0x07e8,
            0xe45a, 0xe978, 0x0aca, 0x8e3d, 0x6d8f, 0x27f2, 0xc440, 0x40b7, 0xa305, 0xd44d, 0x37ff,
            0xb308, 0x50ba, 0x1ac7, 0xf975, 0x7d82, 0x9e30, 0x67c6, 0x8474, 0x0083, 0xe331, 0xa94c,
            0x4afe, 0xce09, 0x2dbb, 0x5af3, 0xb941, 0x3db6, 0xde04, 0x9479, 0x77cb, 0xf33c, 0x108e,
            0x1dac, 0xfe1e, 0x7ae9, 0x995b, 0xd326, 0x3094, 0xb463, 0x57d1, 0x2099, 0xc32b, 0x47dc,
            0xa46e, 0xee13, 0x0da1, 0x8956, 0x6ae4, 0xda9b, 0x3929, 0xbdde, 0x5e6c, 0x1411, 0xf7a3,
            0x7354, 0x90e6, 0xe7ae, 0x041c, 0x80eb, 0x6359, 0x2924, 0xca96, 0x4e61, 0xadd3, 0xa0f1,
            0x4343, 0xc7b4, 0x2406, 0x6e7b, 0x8dc9, 0x093e, 0xea8c, 0x9dc4, 0x7e76, 0xfa81, 0x1933,
            0x534e, 0xb0fc, 0x340b, 0xd7b9, 0x2e4f, 0xcdfd, 0x490a, 0xaab8, 0xe0c5, 0x0377, 0x8780,
            0x6432, 0x137a, 0xf0c8, 0x743f, 0x978d, 0xddf0, 0x3e42, 0xbab5, 0x5907, 0x5425, 0xb797,
            0x3360, 0xd0d2, 0x9aaf, 0x791d, 0xfdea, 0x1e58, 0x6910, 0x8aa2, 0x0e55, 0xede7, 0xa79a,
            0x4428, 0xc0df, 0x236d,
        ],
        [
            0x0000, 0x95bd, 0x8b5b, 0x1ee6, 0xb697, 0x232a, 0x3dcc, 0xa871, 0xcd0f, 0x58b2, 0x4654,
            0xd3e9, 0x7b98, 0xee25, 0xf0c3, 0x657e, 0x3a3f, 0xaf82, 0xb164, 0x24d9, 0x8ca8, 0x1915,
            0x07f3, 0x924e, 0xf730, 0x628d, 0x7c6b, 0xe9d6, 0x41a7, 0xd41a, 0xcafc, 0x5f41, 0x747e,
            0xe1c3, 0xff25, 0x6a98, 0xc2e9, 0x5754, 0x49b2, 0xdc0f, 0xb971, 0x2ccc, 0x322a, 0xa797,
            0x0fe6, 0x9a5b, 0x84bd, 0x1100, 0x4e41, 0xdbfc, 0xc51a, 0x50a7, 0xf8d6, 0x6d6b, 0x738d,
            0xe630, 0x834e, 0x16f3, 0x0815, 0x9da8, 0x35d9, 0xa064, 0xbe82, 0x2b3f, 0xe8fc, 0x7d41,
            0x63a7, 0xf61a, 0x5e6b, 0xcbd6, 0xd530, 0x408d, 0x25f3, 0xb04e, 0xaea8, 0x3b15, 0x9364,
            0x06d9, 0x183f, 0x8d82, 0xd2c3, 0x477e, 0x5998, 0xcc25, 0x6454, 0xf1e9, 0xef0f, 0x7ab2,
            0x1fcc, 0x8a71, 0x9497, 0x012a, 0xa95b, 0x3ce6, 0x2200, 0xb7bd, 0x9c82, 0x093f, 0x17d9,
            0x8264, 0x2a15, 0xbfa8, 0xa14e, 0x34f3, 0x518d, 0xc430, 0xdad6, 0x4f6b, 0xe71a, 0x72a7,
            0x6c41, 0xf9fc, 0xa6bd, 0x3300, 0x2de6, 0xb85b, 0x102a, 0x8597, 0x9b71, 0x0ecc, 0x6bb2,
            0xfe0f, 0xe0e9, 0x7554, 0xdd25, 0x4898, 0x567e, 0xc3c3, 0x71d9, 0xe464, 0xfa82, 0x6f3f,
            0xc74e, 0x52f3, 0x4c15, 0xd9a8, 0xbcd6, 0x296b, 0x378d, 0xa230, 0x0a41, 0x9ffc, 0x811a,
            0x14a7, 0x4be6, 0xde5b, 0xc0bd, 0x5500, 0xfd71, 0x68cc, 0x762a, 0xe397, 0x86e9, 0x1354,
            0x0db2, 0x980f, 0x307e, 0xa5c3, 0xbb25, 0x2e98, 0x05a7, 0x901a, 0x8efc, 0x1b41, 0xb330,
            0x268d, 0x386b, 0xadd6, 0xc8a8, 0x5d15, 0x43f3, 0xd64e, 0x7e3f, 0xeb82, 0xf564, 0x60d9,
            0x3f98, 0xaa25, 0xb4c3, 0x217e, 0x890f, 0x1cb2, 0x0254, 0x97e9, 0xf297, 0x672a, 0x79cc,
            0xec71, 0x4400, 0xd1bd, 0xcf5b, 0x5ae6, 0x9925, 0x0c98, 0x127e, 0x87c3, 0x2fb2, 0xba0f,
            0xa4e9, 0x3154, 0x542a, 0xc197, 0xdf71, 0x4acc, 0xe2bd, 0x7700, 0x69e6, 0xfc5b, 0xa31a,
            0x36a7, 0x2841, 0xbdfc, 0x158d, 0x8030, 0x9ed6, 0x0b6b, 0x6e15, 0xfba8, 0xe54e, 0x70f3,
            0xd882, 0x4d3f, 0x53d9, 0xc664, 0xed5b, 0x78e6, 0x6600, 0xf3bd, 0x5bcc, 0xce71, 0xd097,
            0x452a, 0x2054, 0xb5e9, 0xab0f, 0x3eb2, 0x96c3, 0x037e, 0x1d98, 0x8825, 0xd764, 0x42d9,
            0x5c3f, 0xc982, 0x61f3, 0xf44e, 0xeaa8, 0x7f15, 0x1a6b, 0x8fd6, 0x9130, 0x048d, 0xacfc,
            0x3941, 0x27a7, 0xb21a,
        ],
        [
            0x0000, 0x10b6, 0x216c, 0x31da, 0x42d8, 0x526e, 0x63b4, 0x7302, 0x85b0, 0x9506, 0xa4dc,
            0xb46a, 0xc768, 0xd7de, 0xe604, 0xf6b2, 0xab41, 0xbbf7, 0x8a2d, 0x9a9b, 0xe999, 0xf92f,
            0xc8f5, 0xd843, 0x2ef1, 0x3e47, 0x0f9d, 0x1f2b, 0x6c29, 0x7c9f, 0x4d45, 0x5df3, 0xf6a3,
            0xe615, 0xd7cf, 0xc779, 0xb47b, 0xa4cd, 0x9517, 0x85a1, 0x7313, 0x63a5, 0x527f, 0x42c9,
            0x31cb, 0x217d, 0x10a7, 0x0011, 0x5de2, 0x4d54, 0x7c8e, 0x6c38, 0x1f3a, 0x0f8c, 0x3e56,
            0x2ee0, 0xd852, 0xc8e4, 0xf93e, 0xe988, 0x9a8a, 0x8a3c, 0xbbe6, 0xab50, 0x4d67, 0x5dd1,
            0x6c0b, 0x7cbd, 0x0fbf, 0x1f09, 0x2ed3, 0x3e65, 0xc8d7, 0xd861, 0xe9bb, 0xf90d, 0x8a0f,
            0x9ab9, 0xab63, 0xbbd5, 0xe626, 0xf690, 0xc74a, 0xd7fc, 0xa4fe, 0xb448, 0x8592, 0x9524,
            0x6396, 0x7320, 0x42fa, 0x524c, 0x214e, 0x31f8, 0x0022, 0x1094, 0xbbc4, 0xab72, 0x9aa8,
            0x8a1e, 0xf91c, 0xe9aa, 0xd870, 0xc8c6, 0x3e74, 0x2ec2, 0x1f18, 0x0fae, 0x7cac, 0x6c1a,
            0x5dc0, 0x4d76, 0x1085, 0x0033, 0x31e9, 0x215f, 0x525d, 0x42eb, 0x7331, 0x6387, 0x9535,
            0x8583, 0xb459, 0xa4ef, 0xd7ed, 0xc75b, 0xf681, 0xe637, 0x9ace, 0x8a78, 0xbba2, 0xab14,
            0xd816, 0xc8a0, 0xf97a, 0xe9cc, 0x1f7e, 0x0fc8, 0x3e12, 0x2ea4, 0x5da6, 0x4d10, 0x7cca,
            0x6c7c, 0x318f, 0x2139, 0x10e3, 0x0055, 0x7357, 0x63e1, 0x523b, 0x428d, 0xb43f, 0xa489,
            0x9553, 0x85e5, 0xf6e7, 0xe651, 0xd78b, 0xc73d, 0x6c6d, 0x7cdb, 0x4d01, 0x5db7, 0x2eb5,
            0x3e03, 0x0fd9, 0x1f6f, 0xe9dd, 0xf96b, 0xc8b1, 0xd807, 0xab05, 0xbbb3, 0x8a69, 0x9adf,
            0xc72c, 0xd79a, 0xe640, 0xf6f6, 0x85f4, 0x9542, 0xa498, 0xb42e, 0x429c, 0x522a, 0x63f0,
            0x7346, 0x0044, 0x10f2, 0x2128, 0x319e, 0xd7a9, 0xc71f, 0xf6c5, 0xe673, 0x9571, 0x85c7,
            0xb41d, 0xa4ab, 0x5219, 0x42af, 0x7375, 0x63c3, 0x10c1, 0x0077, 0x31ad, 0x211b, 0x7ce8,
            0x6c5e, 0x5d84, 0x4d32, 0x3e30, 0x2e86, 0x1f5c, 0x0fea, 0xf958, 0xe9ee, 0xd834, 0xc882,
            0xbb80, 0xab36, 0x9aec, 0x8a5a, 0x210a, 0x31bc, 0x0066, 0x10d0, 0x63d2, 0x7364, 0x42be,
            0x5208, 0xa4ba, 0xb40c, 0x85d6, 0x9560, 0xe662, 0xf6d4, 0xc70e, 0xd7b8, 0x8a4b, 0x9afd,
            0xab27, 0xbb91, 0xc893, 0xd825, 0xe9ff, 0xf949, 0x0ffb, 0x1f4d, 0x2e97, 0x3e21, 0x4d23,
            0x5d95, 0x6c4f, 0x7cf9,
        ],
        [
            0x0000, 0x43de, 0x87bc, 0xc462, 0xaf59, 0xec87, 0x28e5, 0x6b3b, 0xfe93, 0xbd4d, 0x792f,
            0x3af1, 0x51ca, 0x1214, 0xd676, 0x95a8, 0x5d07, 0x1ed9, 0xdabb, 0x9965, 0xf25e, 0xb180,
            0x75e2, 0x363c, 0xa394, 0xe04a, 0x2428, 0x67f6, 0x0ccd, 0x4f13, 0x8b71, 0xc8af, 0xba0e,
            0xf9d0, 0x3db2, 0x7e6c, 0x1557, 0x5689, 0x92eb, 0xd135, 0x449d, 0x0743, 0xc321, 0x80ff,
            0xebc4, 0xa81a, 0x6c78, 0x2fa6, 0xe709, 0xa4d7, 0x60b5, 0x236b, 0x4850, 0x0b8e, 0xcfec,
            0x8c32, 0x199a, 0x5a44, 0x9e26, 0xddf8, 0xb6c3, 0xf51d, 0x317f, 0x72a1, 0xd43d, 0x97e3,
            0x5381, 0x105f, 0x7b64, 0x38ba, 0xfcd8, 0xbf06, 0x2aae, 0x6970, 0xad12, 0xeecc, 0x85f7,
            0xc629, 0x024b, 0x4195, 0x893a, 0xcae4, 0x0e86, 0x4d58, 0x2663, 0x65bd, 0xa1df, 0xe201,
            0x77a9, 0x3477, 0xf015, 0xb3cb, 0xd8f0, 0x9b2e, 0x5f4c, 0x1c92, 0x6e33, 0x2ded, 0xe98f,
            0xaa51, 0xc16a, 0x82b4, 0x46d6, 0x0508, 0x90a0, 0xd37e, 0x171c, 0x54c2, 0x3ff9, 0x7c27,
            0xb845, 0xfb9b, 0x3334, 0x70ea, 0xb488, 0xf756, 0x9c6d, 0xdfb3, 0x1bd1, 0x580f, 0xcda7,
            0x8e79, 0x4a1b, 0x09c5, 0x62fe, 0x2120, 0xe542, 0xa69c, 0x085b, 0x4b85, 0x8fe7, 0xcc39,
            0xa702, 0xe4dc, 0x20be, 0x6360, 0xf6c8, 0xb516, 0x7174, 0x32aa, 0x5991, 0x1a4f, 0xde2d,
            0x9df3, 0x555c, 0x1682, 0xd2e0, 0x913e, 0xfa05, 0xb9db, 0x7db9, 0x3e67, 0xabcf, 0xe811,
            0x2c73, 0x6fad, 0x0496, 0x4748, 0x832a, 0xc0f4, 0xb255, 0xf18b, 0x35e9, 0x7637, 0x1d0c,
            0x5ed2, 0x9ab0, 0xd96e, 0x4cc6, 0x0f18, 0xcb7a, 0x88a4, 0xe39f, 0xa041, 0x6423, 0x27fd,
            0xef52, 0xac8c, 0x68ee, 0x2b30, 0x400b, 0x03d5, 0xc7b7, 0x8469, 0x11c1, 0x521f, 0x967d,
            0xd5a3, 0xbe98, 0xfd46, 0x3924, 0x7afa, 0xdc66, 0x9fb8, 0x5bda, 0x1804, 0x733f, 0x30e1,
            0xf483, 0xb75d, 0x22f5, 0x612b, 0xa549, 0xe697, 0x8dac, 0xce72, 0x0a10, 0x49ce, 0x8161,
            0xc2bf, 0x06dd, 0x4503, 0x2e38, 0x6de6, 0xa984, 0xea5a, 0x7ff2, 0x3c2c, 0xf84e, 0xbb90,
            0xd0ab, 0x9375, 0x5717, 0x14c9, 0x6668, 0x25b6, 0xe1d4, 0xa20a, 0xc931, 0x8aef, 0x4e8d,
            0x0d53, 0x98fb, 0xdb25, 0x1f47, 0x5c99, 0x37a2, 0x747c, 0xb01e, 0xf3c0, 0x3b6f, 0x78b1,
            0xbcd3, 0xff0d, 0x9436, 0xd7e8, 0x138a, 0x5054, 0xc5fc, 0x8622, 0x4240, 0x019e, 0x6aa5,
            0x297b, 0xed19, 0xaec7,
        ],
        [
            0x0000, 0x1280, 0x2500, 0x3780, 0x4a00, 0x5880, 0x6f00, 0x7d80, 0x9400, 0x8680, 0xb100,
            0xa380, 0xde00, 0xcc80, 0xfb00, 0xe980, 0x8821, 0x9aa1, 0xad21, 0xbfa1, 0xc221, 0xd0a1,
            0xe721, 0xf5a1, 0x1c21, 0x0ea1, 0x3921, 0x2ba1, 0x5621, 0x44a1, 0x7321, 0x61a1, 0xb063,
            0xa2e3, 0x9563, 0x87e3, 0xfa63, 0xe8e3, 0xdf63, 0xcde3, 0x2463, 0x36e3, 0x0163, 0x13e3,
            0x6e63, 0x7ce3, 0x4b63, 0x59e3, 0x3842, 0x2ac2, 0x1d42, 0x0fc2, 0x7242, 0x60c2, 0x5742,
            0x45c2, 0xac42, 0xbec2, 0x8942, 0x9bc2, 0xe642, 0xf4c2, 0xc342, 0xd1c2, 0xc0e7, 0xd267,
            0xe5e7, 0xf767, 0x8ae7, 0x9867, 0xafe7, 0xbd67, 0x54e7, 0x4667, 0x71e7, 0x6367, 0x1ee7,
            0x0c67, 0x3be7, 0x2967, 0x48c6, 0x5a46, 0x6dc6, 0x7f46, 0x02c6, 0x1046, 0x27c6, 0x3546,
            0xdcc6, 0xce46, 0xf9c6, 0xeb46, 0x96c6, 0x8446, 0xb3c6, 0xa146, 0x7084, 0x6204, 0x5584,
            0x4704, 0x3a84, 0x2804, 0x1f84, 0x0d04, 0xe484, 0xf604, 0xc184, 0xd304, 0xae84, 0xbc04,
            0x8b84, 0x9904, 0xf8a5, 0xea25, 0xdda5, 0xcf25, 0xb2a5, 0xa025, 0x97a5, 0x8525, 0x6ca5,
            0x7e25, 0x49a5, 0x5b25, 0x26a5, 0x3425, 0x03a5, 0x1125, 0x21ef, 0x336f, 0x04ef, 0x166f,
            0x6bef, 0x796f, 0x4eef, 0x5c6f, 0xb5ef, 0xa76f, 0x90ef, 0x826f, 0xffef, 0xed6f, 0xdaef,
            0xc86f, 0xa9ce, 0xbb4e, 0x8cce, 0x9e4e, 0xe3ce, 0xf14e, 0xc6ce, 0xd44e, 0x3dce, 0x2f4e,
            0x18ce, 0x0a4e, 0x77ce, 0x654e, 0x52ce, 0x404e, 0x918c, 0x830c, 0xb48c, 0xa60c, 0xdb8c,
            0xc90c, 0xfe8c, 0xec0c, 0x058c, 0x170c, 0x208c, 0x320c, 0x4f8c, 0x5d0c, 0x6a8c, 0x780c,
            0x19ad, 0x0b2d, 0x3cad, 0x2e2d, 0x53ad, 0x412d, 0x76ad, 0x642d, 0x8dad, 0x9f2d, 0xa8ad,
            0xba2d, 0xc7ad, 0xd52d, 0xe2ad, 0xf02d, 0xe108, 0xf388, 0xc408, 0xd688, 0xab08, 0xb988,
            0x8e08, 0x9c88, 0x7508, 0x6788, 0x5008, 0x4288, 0x3f08, 0x2d88, 0x1a08, 0x0888, 0x6929,
            0x7ba9, 0x4c29, 0x5ea9, 0x2329, 0x31a9, 0x0629, 0x14a9, 0xfd29, 0xefa9, 0xd829, 0xcaa9,
            0xb729, 0xa5a9, 0x9229, 0x80a9, 0x516b, 0x43eb, 0x746b, 0x66eb, 0x1b6b, 0x09eb, 0x3e6b,
            0x2ceb, 0xc56b, 0xd7eb, 0xe06b, 0xf2eb, 0x8f6b, 0x9deb, 0xaa6b, 0xb8eb, 0xd94a, 0xcbca,
            0xfc4a, 0xeeca, 0x934a, 0x81ca, 0xb64a, 0xa4ca, 0x4d4a, 0x5fca, 0x684a, 0x7aca, 0x074a,
            0x15ca, 0x224a, 0x30ca,
        ],
        [
            0x0000, 0xd002, 0x0025, 0xd027, 0x004a, 0xd048, 0x006f, 0xd06d, 0x0094, 0xd096, 0x00b1,
            0xd0b3, 0x00de, 0xd0dc, 0x00fb, 0xd0f9, 0x0128, 0xd12a, 0x010d, 0xd10f, 0x0162, 0xd160,
            0x0147, 0xd145, 0x01bc, 0xd1be, 0x0199, 0xd19b, 0x01f6, 0xd1f4, 0x01d3, 0xd1d1, 0x0250,
            0xd252, 0x0275, 0xd277, 0x021a, 0xd218, 0x023f, 0xd23d, 0x02c4, 0xd2c6, 0x02e1, 0xd2e3,
            0x028e, 0xd28c, 0x02ab, 0xd2a9, 0x0378, 0xd37a, 0x035d, 0xd35f, 0x0332, 0xd330, 0x0317,
            0xd315, 0x03ec, 0xd3ee, 0x03c9, 0xd3cb, 0x03a6, 0xd3a4, 0x0383, 0xd381, 0x04a0, 0xd4a2,
            0x0485, 0xd487, 0x04ea, 0xd4e8, 0x04cf, 0xd4cd, 0x0434, 0xd436, 0x0411, 0xd413, 0x047e,
            0xd47c, 0x045b, 0xd459, 0x0588, 0xd58a, 0x05ad, 0xd5af, 0x05c2, 0xd5c0, 0x05e7, 0xd5e5,
            0x051c, 0xd51e, 0x0539, 0xd53b, 0x0556, 0xd554, 0x0573, 0xd571, 0x06f0, 0xd6f2, 0x06d5,
            0xd6d7, 0x06ba, 0xd6b8, 0x069f, 0xd69d, 0x0664, 0xd666, 0x0641, 0xd643, 0x062e, 0xd62c,
            0x060b, 0xd609, 0x07d8, 0xd7da, 0x07fd, 0xd7ff, 0x0792, 0xd790, 0x07b7, 0xd7b5, 0x074c,
            0xd74e, 0x0769, 0xd76b, 0x0706, 0xd704, 0x0723, 0xd721, 0x0940, 0xd942, 0x0965, 0xd967,
            0x090a, 0xd908, 0x092f, 0xd92d, 0x09d4, 0xd9d6, 0x09f1, 0xd9f3, 0x099e, 0xd99c, 0x09bb,
            0xd9b9, 0x0868, 0xd86a, 0x084d, 0xd84f, 0x0822, 0xd820, 0x0807, 0xd805, 0x08fc, 0xd8fe,
            0x08d9, 0xd8db, 0x08b6, 0xd8b4, 0x0893, 0xd891, 0x0b10, 0xdb12, 0x0b35, 0xdb37, 0x0b5a,
            0xdb58, 0x0b7f, 0xdb7d, 0x0b84, 0xdb86, 0x0ba1, 0xdba3, 0x0bce, 0xdbcc, 0x0beb, 0xdbe9,
            0x0a38, 0xda3a, 0x0a1d, 0xda1f, 0x0a72, 0xda70, 0x0a57, 0xda55, 0x0aac, 0xdaae, 0x0a89,
            0xda8b, 0x0ae6, 0xdae4, 0x0ac3, 0xdac1, 0x0de0, 0xdde2, 0x0dc5, 0xddc7, 0x0daa, 0xdda8,
            0x0d8f, 0xdd8d, 0x0d74, 0xdd76, 0x0d51, 0xdd53, 0x0d3e, 0xdd3c, 0x0d1b, 0xdd19, 0x0cc8,
            0xdcca, 0x0ced, 0xdcef, 0x0c82, 0xdc80, 0x0ca7, 0xdca5, 0x0c5c, 0xdc5e, 0x0c79, 0xdc7b,
            0x0c16, 0xdc14, 0x0c33, 0xdc31, 0x0fb0, 0xdfb2, 0x0f95, 0xdf97, 0x0ffa, 0xdff8, 0x0fdf,
            0xdfdd, 0x0f24, 0xdf26, 0x0f01, 0xdf03, 0x0f6e, 0xdf6c, 0x0f4b, 0xdf49, 0x0e98, 0xde9a,
            0x0ebd, 0xdebf, 0x0ed2, 0xded0, 0x0ef7, 0xdef5, 0x0e0c, 0xde0e, 0x0e29, 0xde2b, 0x0e46,
            0xde44, 0x0e63, 0xde61,
        ],
        [
            0x0000, 0x6b98, 0xd730, 0xbca8, 0x0e41, 0x65d9, 0xd971, 0xb2e9, 0x1c82, 0x771a, 0xcbb2,
            0xa02a, 0x12c3, 0x795b, 0xc5f3, 0xae6b, 0x3904, 0x529c, 0xee34, 0x85ac, 0x3745, 0x5cdd,
            0xe075, 0x8bed, 0x2586, 0x4e1e, 0xf2b6, 0x992e, 0x2bc7, 0x405f, 0xfcf7, 0x976f, 0x7208,
            0x1990, 0xa538, 0xcea0, 0x7c49, 0x17d1, 0xab79, 0xc0e1, 0x6e8a, 0x0512, 0xb9ba, 0xd222,
            0x60cb, 0x0b53, 0xb7fb, 0xdc63, 0x4b0c, 0x2094, 0x9c3c, 0xf7a4, 0x454d, 0x2ed5, 0x927d,
            0xf9e5, 0x578e, 0x3c16, 0x80be, 0xeb26, 0x59cf, 0x3257, 0x8eff, 0xe567, 0xe410, 0x8f88,
            0x3320, 0x58b8, 0xea51, 0x81c9, 0x3d61, 0x56f9, 0xf892, 0x930a, 0x2fa2, 0x443a, 0xf6d3,
            0x9d4b, 0x21e3, 0x4a7b, 0xdd14, 0xb68c, 0x0a24, 0x61bc, 0xd355, 0xb8cd, 0x0465, 0x6ffd,
            0xc196, 0xaa0e, 0x16a6, 0x7d3e, 0xcfd7, 0xa44f, 0x18e7, 0x737f, 0x9618, 0xfd80, 0x4128,
            0x2ab0, 0x9859, 0xf3c1, 0x4f69, 0x24f1, 0x8a9a, 0xe102, 0x5daa, 0x3632, 0x84db, 0xef43,
            0x53eb, 0x3873, 0xaf1c, 0xc484, 0x782c, 0x13b4, 0xa15d, 0xcac5, 0x766d, 0x1df5, 0xb39e,
            0xd806, 0x64ae, 0x0f36, 0xbddf, 0xd647, 0x6aef, 0x0177, 0x6801, 0x0399, 0xbf31, 0xd4a9,
            0x6640, 0x0dd8, 0xb170, 0xdae8, 0x7483, 0x1f1b, 0xa3b3, 0xc82b, 0x7ac2, 0x115a, 0xadf2,
            0xc66a, 0x5105, 0x3a9d, 0x8635, 0xedad, 0x5f44, 0x34dc, 0x8874, 0xe3ec, 0x4d87, 0x261f,
            0x9ab7, 0xf12f, 0x43c6, 0x285e, 0x94f6, 0xff6e, 0x1a09, 0x7191, 0xcd39, 0xa6a1, 0x1448,
            0x7fd0, 0xc378, 0xa8e0, 0x068b, 0x6d13, 0xd1bb, 0xba23, 0x08ca, 0x6352, 0xdffa, 0xb462,
            0x230d, 0x4895, 0xf43d, 0x9fa5, 0x2d4c, 0x46d4, 0xfa7c, 0x91e4, 0x3f8f, 0x5417, 0xe8bf,
            0x8327, 0x31ce, 0x5a56, 0xe6fe, 0x8d66, 0x8c11, 0xe789, 0x5b21, 0x30b9, 0x8250, 0xe9c8,
            0x5560, 0x3ef8, 0x9093, 0xfb0b, 0x47a3, 0x2c3b, 0x9ed2, 0xf54a, 0x49e2, 0x227a, 0xb515,
            0xde8d, 0x6225, 0x09bd, 0xbb54, 0xd0cc, 0x6c64, 0x07fc, 0xa997, 0xc20f, 0x7ea7, 0x153f,
            0xa7d6, 0xcc4e, 0x70e6, 0x1b7e, 0xfe19, 0x9581, 0x2929, 0x42b1, 0xf058, 0x9bc0, 0x2768,
            0x4cf0, 0xe29b, 0x8903, 0x35ab, 0x5e33, 0xecda, 0x8742, 0x3bea, 0x5072, 0xc71d, 0xac85,
            0x102d, 0x7bb5, 0xc95c, 0xa2c4, 0x1e6c, 0x75f4, 0xdb9f, 0xb007, 0x0caf, 0x6737, 0xd5de,
            0xbe46, 0x02ee, 0x6976,
        ],
    ];

    pub static CRC16_OPENSAFETY_A_TABLE: [[u16; 256]; 16] = [
        [
            0x0000, 0x5935, 0xb26a, 0xeb5f, 0x3de1, 0x64d4, 0x8f8b, 0xd6be, 0x7bc2, 0x22f7, 0xc9a8,
            0x909d, 0x4623, 0x1f16, 0xf449, 0xad7c, 0xf784, 0xaeb1, 0x45ee, 0x1cdb, 0xca65, 0x9350,
            0x780f, 0x213a, 0x8c46, 0xd573, 0x3e2c, 0x6719, 0xb1a7, 0xe892, 0x03cd, 0x5af8, 0xb63d,
            0xef08, 0x0457, 0x5d62, 0x8bdc, 0xd2e9, 0x39b6, 0x6083, 0xcdff, 0x94ca, 0x7f95, 0x26a0,
            0xf01e, 0xa92b, 0x4274, 0x1b41, 0x41b9, 0x188c, 0xf3d3, 0xaae6, 0x7c58, 0x256d, 0xce32,
            0x9707, 0x3a7b, 0x634e, 0x8811, 0xd124, 0x079a, 0x5eaf, 0xb5f0, 0xecc5, 0x354f, 0x6c7a,
            0x8725, 0xde10, 0x08ae, 0x519b, 0xbac4, 0xe3f1, 0x4e8d, 0x17b8, 0xfce7, 0xa5d2, 0x736c,
            0x2a59, 0xc106, 0x9833, 0xc2cb, 0x9bfe, 0x70a1, 0x2994, 0xff2a, 0xa61f, 0x4d40, 0x1475,
            0xb909, 0xe03c, 0x0b63, 0x5256, 0x84e8, 0xdddd, 0x3682, 0x6fb7, 0x8372, 0xda47, 0x3118,
            0x682d, 0xbe93, 0xe7a6, 0x0cf9, 0x55cc, 0xf8b0, 0xa185, 0x4ada, 0x13ef, 0xc551, 0x9c64,
            0x773b, 0x2e0e, 0x74f6, 0x2dc3, 0xc69c, 0x9fa9, 0x4917, 0x1022, 0xfb7d, 0xa248, 0x0f34,
            0x5601, 0xbd5e, 0xe46b, 0x32d5, 0x6be0, 0x80bf, 0xd98a, 0x6a9e, 0x33ab, 0xd8f4, 0x81c1,
            0x577f, 0x0e4a, 0xe515, 0xbc20, 0x115c, 0x4869, 0xa336, 0xfa03, 0x2cbd, 0x7588, 0x9ed7,
            0xc7e2, 0x9d1a, 0xc42f, 0x2f70, 0x7645, 0xa0fb, 0xf9ce, 0x1291, 0x4ba4, 0xe6d8, 0xbfed,
            0x54b2, 0x0d87, 0xdb39, 0x820c, 0x6953, 0x3066, 0xdca3, 0x8596, 0x6ec9, 0x37fc, 0xe142,
            0xb877, 0x5328, 0x0a1d, 0xa761, 0xfe54, 0x150b, 0x4c3e, 0x9a80, 0xc3b5, 0x28ea, 0x71df,
            0x2b27, 0x7212, 0x994d, 0xc078, 0x16c6, 0x4ff3, 0xa4ac, 0xfd99, 0x50e5, 0x09d0, 0xe28f,
            0xbbba, 0x6d04, 0x3431, 0xdf6e, 0x865b, 0x5fd1, 0x06e4, 0xedbb, 0xb48e, 0x6230, 0x3b05,
            0xd05a, 0x896f, 0x2413, 0x7d26, 0x9679, 0xcf4c, 0x19f2, 0x40c7, 0xab98, 0xf2ad, 0xa855,
            0xf160, 0x1a3f, 0x430a, 0x95b4, 0xcc81, 0x27de, 0x7eeb, 0xd397, 0x8aa2, 0x61fd, 0x38c8,
            0xee76, 0xb743, 0x5c1c, 0x0529, 0xe9ec, 0xb0d9, 0x5b86, 0x02b3, 0xd40d, 0x8d38, 0x6667,
            0x3f52, 0x922e, 0xcb1b, 0x2044, 0x7971, 0xafcf, 0xf6fa, 0x1da5, 0x4490, 0x1e68, 0x475d,
            0xac02, 0xf537, 0x2389, 0x7abc, 0x91e3, 0xc8d6, 0x65aa, 0x3c9f, 0xd7c0, 0x8ef5, 0x584b,
            0x017e, 0xea21, 0xb314,
        ],
        [
            0x0000, 0xd53c, 0xf34d, 0x2671, 0xbfaf, 0x6a93, 0x4ce2, 0x99de, 0x266b, 0xf357, 0xd526,
            0x001a, 0x99c4, 0x4cf8, 0x6a89, 0xbfb5, 0x4cd6, 0x99ea, 0xbf9b, 0x6aa7, 0xf379, 0x2645,
            0x0034, 0xd508, 0x6abd, 0xbf81, 0x99f0, 0x4ccc, 0xd512, 0x002e, 0x265f, 0xf363, 0x99ac,
            0x4c90, 0x6ae1, 0xbfdd, 0x2603, 0xf33f, 0xd54e, 0x0072, 0xbfc7, 0x6afb, 0x4c8a, 0x99b6,
            0x0068, 0xd554, 0xf325, 0x2619, 0xd57a, 0x0046, 0x2637, 0xf30b, 0x6ad5, 0xbfe9, 0x9998,
            0x4ca4, 0xf311, 0x262d, 0x005c, 0xd560, 0x4cbe, 0x9982, 0xbff3, 0x6acf, 0x6a6d, 0xbf51,
            0x9920, 0x4c1c, 0xd5c2, 0x00fe, 0x268f, 0xf3b3, 0x4c06, 0x993a, 0xbf4b, 0x6a77, 0xf3a9,
            0x2695, 0x00e4, 0xd5d8, 0x26bb, 0xf387, 0xd5f6, 0x00ca, 0x9914, 0x4c28, 0x6a59, 0xbf65,
            0x00d0, 0xd5ec, 0xf39d, 0x26a1, 0xbf7f, 0x6a43, 0x4c32, 0x990e, 0xf3c1, 0x26fd, 0x008c,
            0xd5b0, 0x4c6e, 0x9952, 0xbf23, 0x6a1f, 0xd5aa, 0x0096, 0x26e7, 0xf3db, 0x6a05, 0xbf39,
            0x9948, 0x4c74, 0xbf17, 0x6a2b, 0x4c5a, 0x9966, 0x00b8, 0xd584, 0xf3f5, 0x26c9, 0x997c,
            0x4c40, 0x6a31, 0xbf0d, 0x26d3, 0xf3ef, 0xd59e, 0x00a2, 0xd4da, 0x01e6, 0x2797, 0xf2ab,
            0x6b75, 0xbe49, 0x9838, 0x4d04, 0xf2b1, 0x278d, 0x01fc, 0xd4c0, 0x4d1e, 0x9822, 0xbe53,
            0x6b6f, 0x980c, 0x4d30, 0x6b41, 0xbe7d, 0x27a3, 0xf29f, 0xd4ee, 0x01d2, 0xbe67, 0x6b5b,
            0x4d2a, 0x9816, 0x01c8, 0xd4f4, 0xf285, 0x27b9, 0x4d76, 0x984a, 0xbe3b, 0x6b07, 0xf2d9,
            0x27e5, 0x0194, 0xd4a8, 0x6b1d, 0xbe21, 0x9850, 0x4d6c, 0xd4b2, 0x018e, 0x27ff, 0xf2c3,
            0x01a0, 0xd49c, 0xf2ed, 0x27d1, 0xbe0f, 0x6b33, 0x4d42, 0x987e, 0x27cb, 0xf2f7, 0xd486,
            0x01ba, 0x9864, 0x4d58, 0x6b29, 0xbe15, 0xbeb7, 0x6b8b, 0x4dfa, 0x98c6, 0x0118, 0xd424,
            0xf255, 0x2769, 0x98dc, 0x4de0, 0x6b91, 0xbead, 0x2773, 0xf24f, 0xd43e, 0x0102, 0xf261,
            0x275d, 0x012c, 0xd410, 0x4dce, 0x98f2, 0xbe83, 0x6bbf, 0xd40a, 0x0136, 0x2747, 0xf27b,
            0x6ba5, 0xbe99, 0x98e8, 0x4dd4, 0x271b, 0xf227, 0xd456, 0x016a, 0x98b4, 0x4d88, 0x6bf9,
            0xbec5, 0x0170, 0xd44c, 0xf23d, 0x2701, 0xbedf, 0x6be3, 0x4d92, 0x98ae, 0x6bcd, 0xbef1,
            0x9880, 0x4dbc, 0xd462, 0x015e, 0x272f, 0xf213, 0x4da6, 0x989a, 0xbeeb, 0x6bd7, 0xf209,
            0x2735, 0x0144, 0xd478,
        ],
        [
            0x0000, 0xf081, 0xb837, 0x48b6, 0x295b, 0xd9da, 0x916c, 0x61ed, 0x52b6, 0xa237, 0xea81,
            0x1a00, 0x7bed, 0x8b6c, 0xc3da, 0x335b, 0xa56c, 0x55ed, 0x1d5b, 0xedda, 0x8c37, 0x7cb6,
            0x3400, 0xc481, 0xf7da, 0x075b, 0x4fed, 0xbf6c, 0xde81, 0x2e00, 0x66b6, 0x9637, 0x13ed,
            0xe36c, 0xabda, 0x5b5b, 0x3ab6, 0xca37, 0x8281, 0x7200, 0x415b, 0xb1da, 0xf96c, 0x09ed,
            0x6800, 0x9881, 0xd037, 0x20b6, 0xb681, 0x4600, 0x0eb6, 0xfe37, 0x9fda, 0x6f5b, 0x27ed,
            0xd76c, 0xe437, 0x14b6, 0x5c00, 0xac81, 0xcd6c, 0x3ded, 0x755b, 0x85da, 0x27da, 0xd75b,
            0x9fed, 0x6f6c, 0x0e81, 0xfe00, 0xb6b6, 0x4637, 0x756c, 0x85ed, 0xcd5b, 0x3dda, 0x5c37,
            0xacb6, 0xe400, 0x1481, 0x82b6, 0x7237, 0x3a81, 0xca00, 0xabed, 0x5b6c, 0x13da, 0xe35b,
            0xd000, 0x2081, 0x6837, 0x98b6, 0xf95b, 0x09da, 0x416c, 0xb1ed, 0x3437, 0xc4b6, 0x8c00,
            0x7c81, 0x1d6c, 0xeded, 0xa55b, 0x55da, 0x6681, 0x9600, 0xdeb6, 0x2e37, 0x4fda, 0xbf5b,
            0xf7ed, 0x076c, 0x915b, 0x61da, 0x296c, 0xd9ed, 0xb800, 0x4881, 0x0037, 0xf0b6, 0xc3ed,
            0x336c, 0x7bda, 0x8b5b, 0xeab6, 0x1a37, 0x5281, 0xa200, 0x4fb4, 0xbf35, 0xf783, 0x0702,
            0x66ef, 0x966e, 0xded8, 0x2e59, 0x1d02, 0xed83, 0xa535, 0x55b4, 0x3459, 0xc4d8, 0x8c6e,
            0x7cef, 0xead8, 0x1a59, 0x52ef, 0xa26e, 0xc383, 0x3302, 0x7bb4, 0x8b35, 0xb86e, 0x48ef,
            0x0059, 0xf0d8, 0x9135, 0x61b4, 0x2902, 0xd983, 0x5c59, 0xacd8, 0xe46e, 0x14ef, 0x7502,
            0x8583, 0xcd35, 0x3db4, 0x0eef, 0xfe6e, 0xb6d8, 0x4659, 0x27b4, 0xd735, 0x9f83, 0x6f02,
            0xf935, 0x09b4, 0x4102, 0xb183, 0xd06e, 0x20ef, 0x6859, 0x98d8, 0xab83, 0x5b02, 0x13b4,
            0xe335, 0x82d8, 0x7259, 0x3aef, 0xca6e, 0x686e, 0x98ef, 0xd059, 0x20d8, 0x4135, 0xb1b4,
            0xf902, 0x0983, 0x3ad8, 0xca59, 0x82ef, 0x726e, 0x1383, 0xe302, 0xabb4, 0x5b35, 0xcd02,
            0x3d83, 0x7535, 0x85b4, 0xe459, 0x14d8, 0x5c6e, 0xacef, 0x9fb4, 0x6f35, 0x2783, 0xd702,
            0xb6ef, 0x466e, 0x0ed8, 0xfe59, 0x7b83, 0x8b02, 0xc3b4, 0x3335, 0x52d8, 0xa259, 0xeaef,
            0x1a6e, 0x2935, 0xd9b4, 0x9102, 0x6183, 0x006e, 0xf0ef, 0xb859, 0x48d8, 0xdeef, 0x2e6e,
            0x66d8, 0x9659, 0xf7b4, 0x0735, 0x4f83, 0xbf02, 0x8c59, 0x7cd8, 0x346e, 0xc4ef, 0xa502,
            0x5583, 0x1d35, 0xedb4,
        ],
        [
            0x0000, 0x9f68, 0x67e5, 0xf88d, 0xcfca, 0x50a2, 0xa82f, 0x3747, 0xc6a1, 0x59c9, 0xa144,
            0x3e2c, 0x096b, 0x9603, 0x6e8e, 0xf1e6, 0xd477, 0x4b1f, 0xb392, 0x2cfa, 0x1bbd, 0x84d5,
            0x7c58, 0xe330, 0x12d6, 0x8dbe, 0x7533, 0xea5b, 0xdd1c, 0x4274, 0xbaf9, 0x2591, 0xf1db,
            0x6eb3, 0x963e, 0x0956, 0x3e11, 0xa179, 0x59f4, 0xc69c, 0x377a, 0xa812, 0x509f, 0xcff7,
            0xf8b0, 0x67d8, 0x9f55, 0x003d, 0x25ac, 0xbac4, 0x4249, 0xdd21, 0xea66, 0x750e, 0x8d83,
            0x12eb, 0xe30d, 0x7c65, 0x84e8, 0x1b80, 0x2cc7, 0xb3af, 0x4b22, 0xd44a, 0xba83, 0x25eb,
            0xdd66, 0x420e, 0x7549, 0xea21, 0x12ac, 0x8dc4, 0x7c22, 0xe34a, 0x1bc7, 0x84af, 0xb3e8,
            0x2c80, 0xd40d, 0x4b65, 0x6ef4, 0xf19c, 0x0911, 0x9679, 0xa13e, 0x3e56, 0xc6db, 0x59b3,
            0xa855, 0x373d, 0xcfb0, 0x50d8, 0x679f, 0xf8f7, 0x007a, 0x9f12, 0x4b58, 0xd430, 0x2cbd,
            0xb3d5, 0x8492, 0x1bfa, 0xe377, 0x7c1f, 0x8df9, 0x1291, 0xea1c, 0x7574, 0x4233, 0xdd5b,
            0x25d6, 0xbabe, 0x9f2f, 0x0047, 0xf8ca, 0x67a2, 0x50e5, 0xcf8d, 0x3700, 0xa868, 0x598e,
            0xc6e6, 0x3e6b, 0xa103, 0x9644, 0x092c, 0xf1a1, 0x6ec9, 0x2c33, 0xb35b, 0x4bd6, 0xd4be,
            0xe3f9, 0x7c91, 0x841c, 0x1b74, 0xea92, 0x75fa, 0x8d77, 0x121f, 0x2558, 0xba30, 0x42bd,
            0xddd5, 0xf844, 0x672c, 0x9fa1, 0x00c9, 0x378e, 0xa8e6, 0x506b, 0xcf03, 0x3ee5, 0xa18d,
            0x5900, 0xc668, 0xf12f, 0x6e47, 0x96ca, 0x09a2, 0xdde8, 0x4280, 0xba0d, 0x2565, 0x1222,
            0x8d4a, 0x75c7, 0xeaaf, 0x1b49, 0x8421, 0x7cac, 0xe3c4, 0xd483, 0x4beb, 0xb366, 0x2c0e,
            0x099f, 0x96f7, 0x6e7a, 0xf112, 0xc655, 0x593d, 0xa1b0, 0x3ed8, 0xcf3e, 0x5056, 0xa8db,
            0x37b3, 0x00f4, 0x9f9c, 0x6711, 0xf879, 0x96b0, 0x09d8, 0xf155, 0x6e3d, 0x597a, 0xc612,
            0x3e9f, 0xa1f7, 0x5011, 0xcf79, 0x37f4, 0xa89c, 0x9fdb, 0x00b3, 0xf83e, 0x6756, 0x42c7,
            0xddaf, 0x2522, 0xba4a, 0x8d0d, 0x1265, 0xeae8, 0x7580, 0x8466, 0x1b0e, 0xe383, 0x7ceb,
            0x4bac, 0xd4c4, 0x2c49, 0xb321, 0x676b, 0xf803, 0x008e, 0x9fe6, 0xa8a1, 0x37c9, 0xcf44,
            0x502c, 0xa1ca, 0x3ea2, 0xc62f, 0x5947, 0x6e00, 0xf168, 0x09e5, 0x968d, 0xb31c, 0x2c74,
            0xd4f9, 0x4b91, 0x7cd6, 0xe3be, 0x1b33, 0x845b, 0x75bd, 0xead5, 0x1258, 0x8d30, 0xba77,
            0x251f, 0xdd92, 0x42fa,
        ],
        [
            0x0000, 0x5866, 0xb0cc, 0xe8aa, 0x38ad, 0x60cb, 0x8861, 0xd007, 0x715a, 0x293c, 0xc196,
            0x99f0, 0x49f7, 0x1191, 0xf93b, 0xa15d, 0xe2b4, 0xbad2, 0x5278, 0x0a1e, 0xda19, 0x827f,
            0x6ad5, 0x32b3, 0x93ee, 0xcb88, 0x2322, 0x7b44, 0xab43, 0xf325, 0x1b8f, 0x43e9, 0x9c5d,
            0xc43b, 0x2c91, 0x74f7, 0xa4f0, 0xfc96, 0x143c, 0x4c5a, 0xed07, 0xb561, 0x5dcb, 0x05ad,
            0xd5aa, 0x8dcc, 0x6566, 0x3d00, 0x7ee9, 0x268f, 0xce25, 0x9643, 0x4644, 0x1e22, 0xf688,
            0xaeee, 0x0fb3, 0x57d5, 0xbf7f, 0xe719, 0x371e, 0x6f78, 0x87d2, 0xdfb4, 0x618f, 0x39e9,
            0xd143, 0x8925, 0x5922, 0x0144, 0xe9ee, 0xb188, 0x10d5, 0x48b3, 0xa019, 0xf87f, 0x2878,
            0x701e, 0x98b4, 0xc0d2, 0x833b, 0xdb5d, 0x33f7, 0x6b91, 0xbb96, 0xe3f0, 0x0b5a, 0x533c,
            0xf261, 0xaa07, 0x42ad, 0x1acb, 0xcacc, 0x92aa, 0x7a00, 0x2266, 0xfdd2, 0xa5b4, 0x4d1e,
            0x1578, 0xc57f, 0x9d19, 0x75b3, 0x2dd5, 0x8c88, 0xd4ee, 0x3c44, 0x6422, 0xb425, 0xec43,
            0x04e9, 0x5c8f, 0x1f66, 0x4700, 0xafaa, 0xf7cc, 0x27cb, 0x7fad, 0x9707, 0xcf61, 0x6e3c,
            0x365a, 0xdef0, 0x8696, 0x5691, 0x0ef7, 0xe65d, 0xbe3b, 0xc31e, 0x9b78, 0x73d2, 0x2bb4,
            0xfbb3, 0xa3d5, 0x4b7f, 0x1319, 0xb244, 0xea22, 0x0288, 0x5aee, 0x8ae9, 0xd28f, 0x3a25,
            0x6243, 0x21aa, 0x79cc, 0x9166, 0xc900, 0x1907, 0x4161, 0xa9cb, 0xf1ad, 0x50f0, 0x0896,
            0xe03c, 0xb85a, 0x685d, 0x303b, 0xd891, 0x80f7, 0x5f43, 0x0725, 0xef8f, 0xb7e9, 0x67ee,
            0x3f88, 0xd722, 0x8f44, 0x2e19, 0x767f, 0x9ed5, 0xc6b3, 0x16b4, 0x4ed2, 0xa678, 0xfe1e,
            0xbdf7, 0xe591, 0x0d3b, 0x555d, 0x855a, 0xdd3c, 0x3596, 0x6df0, 0xccad, 0x94cb, 0x7c61,
            0x2407, 0xf400, 0xac66, 0x44cc, 0x1caa, 0xa291, 0xfaf7, 0x125d, 0x4a3b, 0x9a3c, 0xc25a,
            0x2af0, 0x7296, 0xd3cb, 0x8bad, 0x6307, 0x3b61, 0xeb66, 0xb300, 0x5baa, 0x03cc, 0x4025,
            0x1843, 0xf0e9, 0xa88f, 0x7888, 0x20ee, 0xc844, 0x9022, 0x317f, 0x6919, 0x81b3, 0xd9d5,
            0x09d2, 0x51b4, 0xb91e, 0xe178, 0x3ecc, 0x66aa, 0x8e00, 0xd666, 0x0661, 0x5e07, 0xb6ad,
            0xeecb, 0x4f96, 0x17f0, 0xff5a, 0xa73c, 0x773b, 0x2f5d, 0xc7f7, 0x9f91, 0xdc78, 0x841e,
            0x6cb4, 0x34d2, 0xe4d5, 0xbcb3, 0x5419, 0x0c7f, 0xad22, 0xf544, 0x1dee, 0x4588, 0x958f,
            0xcde9, 0x2543, 0x7d25,
        ],
        [
            0x0000, 0xdf09, 0xe727, 0x382e, 0x977b, 0x4872, 0x705c, 0xaf55, 0x77c3, 0xa8ca, 0x90e4,
            0x4fed, 0xe0b8, 0x3fb1, 0x079f, 0xd896, 0xef86, 0x308f, 0x08a1, 0xd7a8, 0x78fd, 0xa7f4,
            0x9fda, 0x40d3, 0x9845, 0x474c, 0x7f62, 0xa06b, 0x0f3e, 0xd037, 0xe819, 0x3710, 0x8639,
            0x5930, 0x611e, 0xbe17, 0x1142, 0xce4b, 0xf665, 0x296c, 0xf1fa, 0x2ef3, 0x16dd, 0xc9d4,
            0x6681, 0xb988, 0x81a6, 0x5eaf, 0x69bf, 0xb6b6, 0x8e98, 0x5191, 0xfec4, 0x21cd, 0x19e3,
            0xc6ea, 0x1e7c, 0xc175, 0xf95b, 0x2652, 0x8907, 0x560e, 0x6e20, 0xb129, 0x5547, 0x8a4e,
            0xb260, 0x6d69, 0xc23c, 0x1d35, 0x251b, 0xfa12, 0x2284, 0xfd8d, 0xc5a3, 0x1aaa, 0xb5ff,
            0x6af6, 0x52d8, 0x8dd1, 0xbac1, 0x65c8, 0x5de6, 0x82ef, 0x2dba, 0xf2b3, 0xca9d, 0x1594,
            0xcd02, 0x120b, 0x2a25, 0xf52c, 0x5a79, 0x8570, 0xbd5e, 0x6257, 0xd37e, 0x0c77, 0x3459,
            0xeb50, 0x4405, 0x9b0c, 0xa322, 0x7c2b, 0xa4bd, 0x7bb4, 0x439a, 0x9c93, 0x33c6, 0xeccf,
            0xd4e1, 0x0be8, 0x3cf8, 0xe3f1, 0xdbdf, 0x04d6, 0xab83, 0x748a, 0x4ca4, 0x93ad, 0x4b3b,
            0x9432, 0xac1c, 0x7315, 0xdc40, 0x0349, 0x3b67, 0xe46e, 0xaa8e, 0x7587, 0x4da9, 0x92a0,
            0x3df5, 0xe2fc, 0xdad2, 0x05db, 0xdd4d, 0x0244, 0x3a6a, 0xe563, 0x4a36, 0x953f, 0xad11,
            0x7218, 0x4508, 0x9a01, 0xa22f, 0x7d26, 0xd273, 0x0d7a, 0x3554, 0xea5d, 0x32cb, 0xedc2,
            0xd5ec, 0x0ae5, 0xa5b0, 0x7ab9, 0x4297, 0x9d9e, 0x2cb7, 0xf3be, 0xcb90, 0x1499, 0xbbcc,
            0x64c5, 0x5ceb, 0x83e2, 0x5b74, 0x847d, 0xbc53, 0x635a, 0xcc0f, 0x1306, 0x2b28, 0xf421,
            0xc331, 0x1c38, 0x2416, 0xfb1f, 0x544a, 0x8b43, 0xb36d, 0x6c64, 0xb4f2, 0x6bfb, 0x53d5,
            0x8cdc, 0x2389, 0xfc80, 0xc4ae, 0x1ba7, 0xffc9, 0x20c0, 0x18ee, 0xc7e7, 0x68b2, 0xb7bb,
            0x8f95, 0x509c, 0x880a, 0x5703, 0x6f2d, 0xb024, 0x1f71, 0xc078, 0xf856, 0x275f, 0x104f,
            0xcf46, 0xf768, 0x2861, 0x8734, 0x583d, 0x6013, 0xbf1a, 0x678c, 0xb885, 0x80ab, 0x5fa2,
            0xf0f7, 0x2ffe, 0x17d0, 0xc8d9, 0x79f0, 0xa6f9, 0x9ed7, 0x41de, 0xee8b, 0x3182, 0x09ac,
            0xd6a5, 0x0e33, 0xd13a, 0xe914, 0x361d, 0x9948, 0x4641, 0x7e6f, 0xa166, 0x9676, 0x497f,
            0x7151, 0xae58, 0x010d, 0xde04, 0xe62a, 0x3923, 0xe1b5, 0x3ebc, 0x0692, 0xd99b, 0x76ce,
            0xa9c7, 0x91e9, 0x4ee0,
        ],
        [
            0x0000, 0x0c29, 0x1852, 0x147b, 0x30a4, 0x3c8d, 0x28f6, 0x24df, 0x6148, 0x6d61, 0x791a,
            0x7533, 0x51ec, 0x5dc5, 0x49be, 0x4597, 0xc290, 0xceb9, 0xdac2, 0xd6eb, 0xf234, 0xfe1d,
            0xea66, 0xe64f, 0xa3d8, 0xaff1, 0xbb8a, 0xb7a3, 0x937c, 0x9f55, 0x8b2e, 0x8707, 0xdc15,
            0xd03c, 0xc447, 0xc86e, 0xecb1, 0xe098, 0xf4e3, 0xf8ca, 0xbd5d, 0xb174, 0xa50f, 0xa926,
            0x8df9, 0x81d0, 0x95ab, 0x9982, 0x1e85, 0x12ac, 0x06d7, 0x0afe, 0x2e21, 0x2208, 0x3673,
            0x3a5a, 0x7fcd, 0x73e4, 0x679f, 0x6bb6, 0x4f69, 0x4340, 0x573b, 0x5b12, 0xe11f, 0xed36,
            0xf94d, 0xf564, 0xd1bb, 0xdd92, 0xc9e9, 0xc5c0, 0x8057, 0x8c7e, 0x9805, 0x942c, 0xb0f3,
            0xbcda, 0xa8a1, 0xa488, 0x238f, 0x2fa6, 0x3bdd, 0x37f4, 0x132b, 0x1f02, 0x0b79, 0x0750,
            0x42c7, 0x4eee, 0x5a95, 0x56bc, 0x7263, 0x7e4a, 0x6a31, 0x6618, 0x3d0a, 0x3123, 0x2558,
            0x2971, 0x0dae, 0x0187, 0x15fc, 0x19d5, 0x5c42, 0x506b, 0x4410, 0x4839, 0x6ce6, 0x60cf,
            0x74b4, 0x789d, 0xff9a, 0xf3b3, 0xe7c8, 0xebe1, 0xcf3e, 0xc317, 0xd76c, 0xdb45, 0x9ed2,
            0x92fb, 0x8680, 0x8aa9, 0xae76, 0xa25f, 0xb624, 0xba0d, 0x9b0b, 0x9722, 0x8359, 0x8f70,
            0xabaf, 0xa786, 0xb3fd, 0xbfd4, 0xfa43, 0xf66a, 0xe211, 0xee38, 0xcae7, 0xc6ce, 0xd2b5,
            0xde9c, 0x599b, 0x55b2, 0x41c9, 0x4de0, 0x693f, 0x6516, 0x716d, 0x7d44, 0x38d3, 0x34fa,
            0x2081, 0x2ca8, 0x0877, 0x045e, 0x1025, 0x1c0c, 0x471e, 0x4b37, 0x5f4c, 0x5365, 0x77ba,
            0x7b93, 0x6fe8, 0x63c1, 0x2656, 0x2a7f, 0x3e04, 0x322d, 0x16f2, 0x1adb, 0x0ea0, 0x0289,
            0x858e, 0x89a7, 0x9ddc, 0x91f5, 0xb52a, 0xb903, 0xad78, 0xa151, 0xe4c6, 0xe8ef, 0xfc94,
            0xf0bd, 0xd462, 0xd84b, 0xcc30, 0xc019, 0x7a14, 0x763d, 0x6246, 0x6e6f, 0x4ab0, 0x4699,
            0x52e2, 0x5ecb, 0x1b5c, 0x1775, 0x030e, 0x0f27, 0x2bf8, 0x27d1, 0x33aa, 0x3f83, 0xb884,
            0xb4ad, 0xa0d6, 0xacff, 0x8820, 0x8409, 0x9072, 0x9c5b, 0xd9cc, 0xd5e5, 0xc19e, 0xcdb7,
            0xe968, 0xe541, 0xf13a, 0xfd13, 0xa601, 0xaa28, 0xbe53, 0xb27a, 0x96a5, 0x9a8c, 0x8ef7,
            0x82de, 0xc749, 0xcb60, 0xdf1b, 0xd332, 0xf7ed, 0xfbc4, 0xefbf, 0xe396, 0x6491, 0x68b8,
            0x7cc3, 0x70ea, 0x5435, 0x581c, 0x4c67, 0x404e, 0x05d9, 0x09f0, 0x1d8b, 0x11a2, 0x357d,
            0x3954, 0x2d2f, 0x2106,
        ],
        [
            0x0000, 0x6f23, 0xde46, 0xb165, 0xe5b9, 0x8a9a, 0x3bff, 0x54dc, 0x9247, 0xfd64, 0x4c01,
            0x2322, 0x77fe, 0x18dd, 0xa9b8, 0xc69b, 0x7dbb, 0x1298, 0xa3fd, 0xccde, 0x9802, 0xf721,
            0x4644, 0x2967, 0xeffc, 0x80df, 0x31ba, 0x5e99, 0x0a45, 0x6566, 0xd403, 0xbb20, 0xfb76,
            0x9455, 0x2530, 0x4a13, 0x1ecf, 0x71ec, 0xc089, 0xafaa, 0x6931, 0x0612, 0xb777, 0xd854,
            0x8c88, 0xe3ab, 0x52ce, 0x3ded, 0x86cd, 0xe9ee, 0x588b, 0x37a8, 0x6374, 0x0c57, 0xbd32,
            0xd211, 0x148a, 0x7ba9, 0xcacc, 0xa5ef, 0xf133, 0x9e10, 0x2f75, 0x4056, 0xafd9, 0xc0fa,
            0x719f, 0x1ebc, 0x4a60, 0x2543, 0x9426, 0xfb05, 0x3d9e, 0x52bd, 0xe3d8, 0x8cfb, 0xd827,
            0xb704, 0x0661, 0x6942, 0xd262, 0xbd41, 0x0c24, 0x6307, 0x37db, 0x58f8, 0xe99d, 0x86be,
            0x4025, 0x2f06, 0x9e63, 0xf140, 0xa59c, 0xcabf, 0x7bda, 0x14f9, 0x54af, 0x3b8c, 0x8ae9,
            0xe5ca, 0xb116, 0xde35, 0x6f50, 0x0073, 0xc6e8, 0xa9cb, 0x18ae, 0x778d, 0x2351, 0x4c72,
            0xfd17, 0x9234, 0x2914, 0x4637, 0xf752, 0x9871, 0xccad, 0xa38e, 0x12eb, 0x7dc8, 0xbb53,
            0xd470, 0x6515, 0x0a36, 0x5eea, 0x31c9, 0x80ac, 0xef8f, 0x0687, 0x69a4, 0xd8c1, 0xb7e2,
            0xe33e, 0x8c1d, 0x3d78, 0x525b, 0x94c0, 0xfbe3, 0x4a86, 0x25a5, 0x7179, 0x1e5a, 0xaf3f,
            0xc01c, 0x7b3c, 0x141f, 0xa57a, 0xca59, 0x9e85, 0xf1a6, 0x40c3, 0x2fe0, 0xe97b, 0x8658,
            0x373d, 0x581e, 0x0cc2, 0x63e1, 0xd284, 0xbda7, 0xfdf1, 0x92d2, 0x23b7, 0x4c94, 0x1848,
            0x776b, 0xc60e, 0xa92d, 0x6fb6, 0x0095, 0xb1f0, 0xded3, 0x8a0f, 0xe52c, 0x5449, 0x3b6a,
            0x804a, 0xef69, 0x5e0c, 0x312f, 0x65f3, 0x0ad0, 0xbbb5, 0xd496, 0x120d, 0x7d2e, 0xcc4b,
            0xa368, 0xf7b4, 0x9897, 0x29f2, 0x46d1, 0xa95e, 0xc67d, 0x7718, 0x183b, 0x4ce7, 0x23c4,
            0x92a1, 0xfd82, 0x3b19, 0x543a, 0xe55f, 0x8a7c, 0xdea0, 0xb183, 0x00e6, 0x6fc5, 0xd4e5,
            0xbbc6, 0x0aa3, 0x6580, 0x315c, 0x5e7f, 0xef1a, 0x8039, 0x46a2, 0x2981, 0x98e4, 0xf7c7,
            0xa31b, 0xcc38, 0x7d5d, 0x127e, 0x5228, 0x3d0b, 0x8c6e, 0xe34d, 0xb791, 0xd8b2, 0x69d7,
            0x06f4, 0xc06f, 0xaf4c, 0x1e29, 0x710a, 0x25d6, 0x4af5, 0xfb90, 0x94b3, 0x2f93, 0x40b0,
            0xf1d5, 0x9ef6, 0xca2a, 0xa509, 0x146c, 0x7b4f, 0xbdd4, 0xd2f7, 0x6392, 0x0cb1, 0x586d,
            0x374e, 0x862b, 0xe908,
        ],
        [
            0x0000, 0x0d0e, 0x1a1c, 0x1712, 0x3438, 0x3936, 0x2e24, 0x232a, 0x6870, 0x657e, 0x726c,
            0x7f62, 0x5c48, 0x5146, 0x4654, 0x4b5a, 0xd0e0, 0xddee, 0xcafc, 0xc7f2, 0xe4d8, 0xe9d6,
            0xfec4, 0xf3ca, 0xb890, 0xb59e, 0xa28c, 0xaf82, 0x8ca8, 0x81a6, 0x96b4, 0x9bba, 0xf8f5,
            0xf5fb, 0xe2e9, 0xefe7, 0xcccd, 0xc1c3, 0xd6d1, 0xdbdf, 0x9085, 0x9d8b, 0x8a99, 0x8797,
            0xa4bd, 0xa9b3, 0xbea1, 0xb3af, 0x2815, 0x251b, 0x3209, 0x3f07, 0x1c2d, 0x1123, 0x0631,
            0x0b3f, 0x4065, 0x4d6b, 0x5a79, 0x5777, 0x745d, 0x7953, 0x6e41, 0x634f, 0xa8df, 0xa5d1,
            0xb2c3, 0xbfcd, 0x9ce7, 0x91e9, 0x86fb, 0x8bf5, 0xc0af, 0xcda1, 0xdab3, 0xd7bd, 0xf497,
            0xf999, 0xee8b, 0xe385, 0x783f, 0x7531, 0x6223, 0x6f2d, 0x4c07, 0x4109, 0x561b, 0x5b15,
            0x104f, 0x1d41, 0x0a53, 0x075d, 0x2477, 0x2979, 0x3e6b, 0x3365, 0x502a, 0x5d24, 0x4a36,
            0x4738, 0x6412, 0x691c, 0x7e0e, 0x7300, 0x385a, 0x3554, 0x2246, 0x2f48, 0x0c62, 0x016c,
            0x167e, 0x1b70, 0x80ca, 0x8dc4, 0x9ad6, 0x97d8, 0xb4f2, 0xb9fc, 0xaeee, 0xa3e0, 0xe8ba,
            0xe5b4, 0xf2a6, 0xffa8, 0xdc82, 0xd18c, 0xc69e, 0xcb90, 0x088b, 0x0585, 0x1297, 0x1f99,
            0x3cb3, 0x31bd, 0x26af, 0x2ba1, 0x60fb, 0x6df5, 0x7ae7, 0x77e9, 0x54c3, 0x59cd, 0x4edf,
            0x43d1, 0xd86b, 0xd565, 0xc277, 0xcf79, 0xec53, 0xe15d, 0xf64f, 0xfb41, 0xb01b, 0xbd15,
            0xaa07, 0xa709, 0x8423, 0x892d, 0x9e3f, 0x9331, 0xf07e, 0xfd70, 0xea62, 0xe76c, 0xc446,
            0xc948, 0xde5a, 0xd354, 0x980e, 0x9500, 0x8212, 0x8f1c, 0xac36, 0xa138, 0xb62a, 0xbb24,
            0x209e, 0x2d90, 0x3a82, 0x378c, 0x14a6, 0x19a8, 0x0eba, 0x03b4, 0x48ee, 0x45e0, 0x52f2,
            0x5ffc, 0x7cd6, 0x71d8, 0x66ca, 0x6bc4, 0xa054, 0xad5a, 0xba48, 0xb746, 0x946c, 0x9962,
            0x8e70, 0x837e, 0xc824, 0xc52a, 0xd238, 0xdf36, 0xfc1c, 0xf112, 0xe600, 0xeb0e, 0x70b4,
            0x7dba, 0x6aa8, 0x67a6, 0x448c, 0x4982, 0x5e90, 0x539e, 0x18c4, 0x15ca, 0x02d8, 0x0fd6,
            0x2cfc, 0x21f2, 0x36e0, 0x3bee, 0x58a1, 0x55af, 0x42bd, 0x4fb3, 0x6c99, 0x6197, 0x7685,
            0x7b8b, 0x30d1, 0x3ddf, 0x2acd, 0x27c3, 0x04e9, 0x09e7, 0x1ef5, 0x13fb, 0x8841, 0x854f,
            0x925d, 0x9f53, 0xbc79, 0xb177, 0xa665, 0xab6b, 0xe031, 0xed3f, 0xfa2d, 0xf723, 0xd409,
            0xd907, 0xce15, 0xc31b,
        ],
        [
            0x0000, 0x1116, 0x222c, 0x333a, 0x4458, 0x554e, 0x6674, 0x7762, 0x88b0, 0x99a6, 0xaa9c,
            0xbb8a, 0xcce8, 0xddfe, 0xeec4, 0xffd2, 0x4855, 0x5943, 0x6a79, 0x7b6f, 0x0c0d, 0x1d1b,
            0x2e21, 0x3f37, 0xc0e5, 0xd1f3, 0xe2c9, 0xf3df, 0x84bd, 0x95ab, 0xa691, 0xb787, 0x90aa,
            0x81bc, 0xb286, 0xa390, 0xd4f2, 0xc5e4, 0xf6de, 0xe7c8, 0x181a, 0x090c, 0x3a36, 0x2b20,
            0x5c42, 0x4d54, 0x7e6e, 0x6f78, 0xd8ff, 0xc9e9, 0xfad3, 0xebc5, 0x9ca7, 0x8db1, 0xbe8b,
            0xaf9d, 0x504f, 0x4159, 0x7263, 0x6375, 0x1417, 0x0501, 0x363b, 0x272d, 0x7861, 0x6977,
            0x5a4d, 0x4b5b, 0x3c39, 0x2d2f, 0x1e15, 0x0f03, 0xf0d1, 0xe1c7, 0xd2fd, 0xc3eb, 0xb489,
            0xa59f, 0x96a5, 0x87b3, 0x3034, 0x2122, 0x1218, 0x030e, 0x746c, 0x657a, 0x5640, 0x4756,
            0xb884, 0xa992, 0x9aa8, 0x8bbe, 0xfcdc, 0xedca, 0xdef0, 0xcfe6, 0xe8cb, 0xf9dd, 0xcae7,
            0xdbf1, 0xac93, 0xbd85, 0x8ebf, 0x9fa9, 0x607b, 0x716d, 0x4257, 0x5341, 0x2423, 0x3535,
            0x060f, 0x1719, 0xa09e, 0xb188, 0x82b2, 0x93a4, 0xe4c6, 0xf5d0, 0xc6ea, 0xd7fc, 0x282e,
            0x3938, 0x0a02, 0x1b14, 0x6c76, 0x7d60, 0x4e5a, 0x5f4c, 0xf0c2, 0xe1d4, 0xd2ee, 0xc3f8,
            0xb49a, 0xa58c, 0x96b6, 0x87a0, 0x7872, 0x6964, 0x5a5e, 0x4b48, 0x3c2a, 0x2d3c, 0x1e06,
            0x0f10, 0xb897, 0xa981, 0x9abb, 0x8bad, 0xfccf, 0xedd9, 0xdee3, 0xcff5, 0x3027, 0x2131,
            0x120b, 0x031d, 0x747f, 0x6569, 0x5653, 0x4745, 0x6068, 0x717e, 0x4244, 0x5352, 0x2430,
            0x3526, 0x061c, 0x170a, 0xe8d8, 0xf9ce, 0xcaf4, 0xdbe2, 0xac80, 0xbd96, 0x8eac, 0x9fba,
            0x283d, 0x392b, 0x0a11, 0x1b07, 0x6c65, 0x7d73, 0x4e49, 0x5f5f, 0xa08d, 0xb19b, 0x82a1,
            0x93b7, 0xe4d5, 0xf5c3, 0xc6f9, 0xd7ef, 0x88a3, 0x99b5, 0xaa8f, 0xbb99, 0xccfb, 0xdded,
            0xeed7, 0xffc1, 0x0013, 0x1105, 0x223f, 0x3329, 0x444b, 0x555d, 0x6667, 0x7771, 0xc0f6,
            0xd1e0, 0xe2da, 0xf3cc, 0x84ae, 0x95b8, 0xa682, 0xb794, 0x4846, 0x5950, 0x6a6a, 0x7b7c,
            0x0c1e, 0x1d08, 0x2e32, 0x3f24, 0x1809, 0x091f, 0x3a25, 0x2b33, 0x5c51, 0x4d47, 0x7e7d,
            0x6f6b, 0x90b9, 0x81af, 0xb295, 0xa383, 0xd4e1, 0xc5f7, 0xf6cd, 0xe7db, 0x505c, 0x414a,
            0x7270, 0x6366, 0x1404, 0x0512, 0x3628, 0x273e, 0xd8ec, 0xc9fa, 0xfac0, 0xebd6, 0x9cb4,
            0x8da2, 0xbe98, 0xaf8e,
        ],
        [
            0x0000, 0xb8b1, 0x2857, 0x90e6, 0x50ae, 0xe81f, 0x78f9, 0xc048, 0xa15c, 0x19ed, 0x890b,
            0x31ba, 0xf1f2, 0x4943, 0xd9a5, 0x6114, 0x1b8d, 0xa33c, 0x33da, 0x8b6b, 0x4b23, 0xf392,
            0x6374, 0xdbc5, 0xbad1, 0x0260, 0x9286, 0x2a37, 0xea7f, 0x52ce, 0xc228, 0x7a99, 0x371a,
            0x8fab, 0x1f4d, 0xa7fc, 0x67b4, 0xdf05, 0x4fe3, 0xf752, 0x9646, 0x2ef7, 0xbe11, 0x06a0,
            0xc6e8, 0x7e59, 0xeebf, 0x560e, 0x2c97, 0x9426, 0x04c0, 0xbc71, 0x7c39, 0xc488, 0x546e,
            0xecdf, 0x8dcb, 0x357a, 0xa59c, 0x1d2d, 0xdd65, 0x65d4, 0xf532, 0x4d83, 0x6e34, 0xd685,
            0x4663, 0xfed2, 0x3e9a, 0x862b, 0x16cd, 0xae7c, 0xcf68, 0x77d9, 0xe73f, 0x5f8e, 0x9fc6,
            0x2777, 0xb791, 0x0f20, 0x75b9, 0xcd08, 0x5dee, 0xe55f, 0x2517, 0x9da6, 0x0d40, 0xb5f1,
            0xd4e5, 0x6c54, 0xfcb2, 0x4403, 0x844b, 0x3cfa, 0xac1c, 0x14ad, 0x592e, 0xe19f, 0x7179,
            0xc9c8, 0x0980, 0xb131, 0x21d7, 0x9966, 0xf872, 0x40c3, 0xd025, 0x6894, 0xa8dc, 0x106d,
            0x808b, 0x383a, 0x42a3, 0xfa12, 0x6af4, 0xd245, 0x120d, 0xaabc, 0x3a5a, 0x82eb, 0xe3ff,
            0x5b4e, 0xcba8, 0x7319, 0xb351, 0x0be0, 0x9b06, 0x23b7, 0xdc68, 0x64d9, 0xf43f, 0x4c8e,
            0x8cc6, 0x3477, 0xa491, 0x1c20, 0x7d34, 0xc585, 0x5563, 0xedd2, 0x2d9a, 0x952b, 0x05cd,
            0xbd7c, 0xc7e5, 0x7f54, 0xefb2, 0x5703, 0x974b, 0x2ffa, 0xbf1c, 0x07ad, 0x66b9, 0xde08,
            0x4eee, 0xf65f, 0x3617, 0x8ea6, 0x1e40, 0xa6f1, 0xeb72, 0x53c3, 0xc325, 0x7b94, 0xbbdc,
            0x036d, 0x938b, 0x2b3a, 0x4a2e, 0xf29f, 0x6279, 0xdac8, 0x1a80, 0xa231, 0x32d7, 0x8a66,
            0xf0ff, 0x484e, 0xd8a8, 0x6019, 0xa051, 0x18e0, 0x8806, 0x30b7, 0x51a3, 0xe912, 0x79f4,
            0xc145, 0x010d, 0xb9bc, 0x295a, 0x91eb, 0xb25c, 0x0aed, 0x9a0b, 0x22ba, 0xe2f2, 0x5a43,
            0xcaa5, 0x7214, 0x1300, 0xabb1, 0x3b57, 0x83e6, 0x43ae, 0xfb1f, 0x6bf9, 0xd348, 0xa9d1,
            0x1160, 0x8186, 0x3937, 0xf97f, 0x41ce, 0xd128, 0x6999, 0x088d, 0xb03c, 0x20da, 0x986b,
            0x5823, 0xe092, 0x7074, 0xc8c5, 0x8546, 0x3df7, 0xad11, 0x15a0, 0xd5e8, 0x6d59, 0xfdbf,
            0x450e, 0x241a, 0x9cab, 0x0c4d, 0xb4fc, 0x74b4, 0xcc05, 0x5ce3, 0xe452, 0x9ecb, 0x267a,
            0xb69c, 0x0e2d, 0xce65, 0x76d4, 0xe632, 0x5e83, 0x3f97, 0x8726, 0x17c0, 0xaf71, 0x6f39,
            0xd788, 0x476e, 0xffdf,
        ],
        [
            0x0000, 0xe1e5, 0x9aff, 0x7b1a, 0x6ccb, 0x8d2e, 0xf634, 0x17d1, 0xd996, 0x3873, 0x4369,
            0xa28c, 0xb55d, 0x54b8, 0x2fa2, 0xce47, 0xea19, 0x0bfc, 0x70e6, 0x9103, 0x86d2, 0x6737,
            0x1c2d, 0xfdc8, 0x338f, 0xd26a, 0xa970, 0x4895, 0x5f44, 0xbea1, 0xc5bb, 0x245e, 0x8d07,
            0x6ce2, 0x17f8, 0xf61d, 0xe1cc, 0x0029, 0x7b33, 0x9ad6, 0x5491, 0xb574, 0xce6e, 0x2f8b,
            0x385a, 0xd9bf, 0xa2a5, 0x4340, 0x671e, 0x86fb, 0xfde1, 0x1c04, 0x0bd5, 0xea30, 0x912a,
            0x70cf, 0xbe88, 0x5f6d, 0x2477, 0xc592, 0xd243, 0x33a6, 0x48bc, 0xa959, 0x433b, 0xa2de,
            0xd9c4, 0x3821, 0x2ff0, 0xce15, 0xb50f, 0x54ea, 0x9aad, 0x7b48, 0x0052, 0xe1b7, 0xf666,
            0x1783, 0x6c99, 0x8d7c, 0xa922, 0x48c7, 0x33dd, 0xd238, 0xc5e9, 0x240c, 0x5f16, 0xbef3,
            0x70b4, 0x9151, 0xea4b, 0x0bae, 0x1c7f, 0xfd9a, 0x8680, 0x6765, 0xce3c, 0x2fd9, 0x54c3,
            0xb526, 0xa2f7, 0x4312, 0x3808, 0xd9ed, 0x17aa, 0xf64f, 0x8d55, 0x6cb0, 0x7b61, 0x9a84,
            0xe19e, 0x007b, 0x2425, 0xc5c0, 0xbeda, 0x5f3f, 0x48ee, 0xa90b, 0xd211, 0x33f4, 0xfdb3,
            0x1c56, 0x674c, 0x86a9, 0x9178, 0x709d, 0x0b87, 0xea62, 0x8676, 0x6793, 0x1c89, 0xfd6c,
            0xeabd, 0x0b58, 0x7042, 0x91a7, 0x5fe0, 0xbe05, 0xc51f, 0x24fa, 0x332b, 0xd2ce, 0xa9d4,
            0x4831, 0x6c6f, 0x8d8a, 0xf690, 0x1775, 0x00a4, 0xe141, 0x9a5b, 0x7bbe, 0xb5f9, 0x541c,
            0x2f06, 0xcee3, 0xd932, 0x38d7, 0x43cd, 0xa228, 0x0b71, 0xea94, 0x918e, 0x706b, 0x67ba,
            0x865f, 0xfd45, 0x1ca0, 0xd2e7, 0x3302, 0x4818, 0xa9fd, 0xbe2c, 0x5fc9, 0x24d3, 0xc536,
            0xe168, 0x008d, 0x7b97, 0x9a72, 0x8da3, 0x6c46, 0x175c, 0xf6b9, 0x38fe, 0xd91b, 0xa201,
            0x43e4, 0x5435, 0xb5d0, 0xceca, 0x2f2f, 0xc54d, 0x24a8, 0x5fb2, 0xbe57, 0xa986, 0x4863,
            0x3379, 0xd29c, 0x1cdb, 0xfd3e, 0x8624, 0x67c1, 0x7010, 0x91f5, 0xeaef, 0x0b0a, 0x2f54,
            0xceb1, 0xb5ab, 0x544e, 0x439f, 0xa27a, 0xd960, 0x3885, 0xf6c2, 0x1727, 0x6c3d, 0x8dd8,
            0x9a09, 0x7bec, 0x00f6, 0xe113, 0x484a, 0xa9af, 0xd2b5, 0x3350, 0x2481, 0xc564, 0xbe7e,
            0x5f9b, 0x91dc, 0x7039, 0x0b23, 0xeac6, 0xfd17, 0x1cf2, 0x67e8, 0x860d, 0xa253, 0x43b6,
            0x38ac, 0xd949, 0xce98, 0x2f7d, 0x5467, 0xb582, 0x7bc5, 0x9a20, 0xe13a, 0x00df, 0x170e,
            0xf6eb, 0x8df1, 0x6c14,
        ],
        [
            0x0000, 0x55d9, 0xabb2, 0xfe6b, 0x0e51, 0x5b88, 0xa5e3, 0xf03a, 0x1ca2, 0x497b, 0xb710,
            0xe2c9, 0x12f3, 0x472a, 0xb941, 0xec98, 0x3944, 0x6c9d, 0x92f6, 0xc72f, 0x3715, 0x62cc,
            0x9ca7, 0xc97e, 0x25e6, 0x703f, 0x8e54, 0xdb8d, 0x2bb7, 0x7e6e, 0x8005, 0xd5dc, 0x7288,
            0x2751, 0xd93a, 0x8ce3, 0x7cd9, 0x2900, 0xd76b, 0x82b2, 0x6e2a, 0x3bf3, 0xc598, 0x9041,
            0x607b, 0x35a2, 0xcbc9, 0x9e10, 0x4bcc, 0x1e15, 0xe07e, 0xb5a7, 0x459d, 0x1044, 0xee2f,
            0xbbf6, 0x576e, 0x02b7, 0xfcdc, 0xa905, 0x593f, 0x0ce6, 0xf28d, 0xa754, 0xe510, 0xb0c9,
            0x4ea2, 0x1b7b, 0xeb41, 0xbe98, 0x40f3, 0x152a, 0xf9b2, 0xac6b, 0x5200, 0x07d9, 0xf7e3,
            0xa23a, 0x5c51, 0x0988, 0xdc54, 0x898d, 0x77e6, 0x223f, 0xd205, 0x87dc, 0x79b7, 0x2c6e,
            0xc0f6, 0x952f, 0x6b44, 0x3e9d, 0xcea7, 0x9b7e, 0x6515, 0x30cc, 0x9798, 0xc241, 0x3c2a,
            0x69f3, 0x99c9, 0xcc10, 0x327b, 0x67a2, 0x8b3a, 0xdee3, 0x2088, 0x7551, 0x856b, 0xd0b2,
            0x2ed9, 0x7b00, 0xaedc, 0xfb05, 0x056e, 0x50b7, 0xa08d, 0xf554, 0x0b3f, 0x5ee6, 0xb27e,
            0xe7a7, 0x19cc, 0x4c15, 0xbc2f, 0xe9f6, 0x179d, 0x4244, 0x9315, 0xc6cc, 0x38a7, 0x6d7e,
            0x9d44, 0xc89d, 0x36f6, 0x632f, 0x8fb7, 0xda6e, 0x2405, 0x71dc, 0x81e6, 0xd43f, 0x2a54,
            0x7f8d, 0xaa51, 0xff88, 0x01e3, 0x543a, 0xa400, 0xf1d9, 0x0fb2, 0x5a6b, 0xb6f3, 0xe32a,
            0x1d41, 0x4898, 0xb8a2, 0xed7b, 0x1310, 0x46c9, 0xe19d, 0xb444, 0x4a2f, 0x1ff6, 0xefcc,
            0xba15, 0x447e, 0x11a7, 0xfd3f, 0xa8e6, 0x568d, 0x0354, 0xf36e, 0xa6b7, 0x58dc, 0x0d05,
            0xd8d9, 0x8d00, 0x736b, 0x26b2, 0xd688, 0x8351, 0x7d3a, 0x28e3, 0xc47b, 0x91a2, 0x6fc9,
            0x3a10, 0xca2a, 0x9ff3, 0x6198, 0x3441, 0x7605, 0x23dc, 0xddb7, 0x886e, 0x7854, 0x2d8d,
            0xd3e6, 0x863f, 0x6aa7, 0x3f7e, 0xc115, 0x94cc, 0x64f6, 0x312f, 0xcf44, 0x9a9d, 0x4f41,
            0x1a98, 0xe4f3, 0xb12a, 0x4110, 0x14c9, 0xeaa2, 0xbf7b, 0x53e3, 0x063a, 0xf851, 0xad88,
            0x5db2, 0x086b, 0xf600, 0xa3d9, 0x048d, 0x5154, 0xaf3f, 0xfae6, 0x0adc, 0x5f05, 0xa16e,
            0xf4b7, 0x182f, 0x4df6, 0xb39d, 0xe644, 0x167e, 0x43a7, 0xbdcc, 0xe815, 0x3dc9, 0x6810,
            0x967b, 0xc3a2, 0x3398, 0x6641, 0x982a, 0xcdf3, 0x216b, 0x74b2, 0x8ad9, 0xdf00, 0x2f3a,
            0x7ae3, 0x8488, 0xd151,
        ],
        [
            0x0000, 0x7f1f, 0xfe3e, 0x8121, 0xa549, 0xda56, 0x5b77, 0x2468, 0x13a7, 0x6cb8, 0xed99,
            0x9286, 0xb6ee, 0xc9f1, 0x48d0, 0x37cf, 0x274e, 0x5851, 0xd970, 0xa66f, 0x8207, 0xfd18,
            0x7c39, 0x0326, 0x34e9, 0x4bf6, 0xcad7, 0xb5c8, 0x91a0, 0xeebf, 0x6f9e, 0x1081, 0x4e9c,
            0x3183, 0xb0a2, 0xcfbd, 0xebd5, 0x94ca, 0x15eb, 0x6af4, 0x5d3b, 0x2224, 0xa305, 0xdc1a,
            0xf872, 0x876d, 0x064c, 0x7953, 0x69d2, 0x16cd, 0x97ec, 0xe8f3, 0xcc9b, 0xb384, 0x32a5,
            0x4dba, 0x7a75, 0x056a, 0x844b, 0xfb54, 0xdf3c, 0xa023, 0x2102, 0x5e1d, 0x9d38, 0xe227,
            0x6306, 0x1c19, 0x3871, 0x476e, 0xc64f, 0xb950, 0x8e9f, 0xf180, 0x70a1, 0x0fbe, 0x2bd6,
            0x54c9, 0xd5e8, 0xaaf7, 0xba76, 0xc569, 0x4448, 0x3b57, 0x1f3f, 0x6020, 0xe101, 0x9e1e,
            0xa9d1, 0xd6ce, 0x57ef, 0x28f0, 0x0c98, 0x7387, 0xf2a6, 0x8db9, 0xd3a4, 0xacbb, 0x2d9a,
            0x5285, 0x76ed, 0x09f2, 0x88d3, 0xf7cc, 0xc003, 0xbf1c, 0x3e3d, 0x4122, 0x654a, 0x1a55,
            0x9b74, 0xe46b, 0xf4ea, 0x8bf5, 0x0ad4, 0x75cb, 0x51a3, 0x2ebc, 0xaf9d, 0xd082, 0xe74d,
            0x9852, 0x1973, 0x666c, 0x4204, 0x3d1b, 0xbc3a, 0xc325, 0x6345, 0x1c5a, 0x9d7b, 0xe264,
            0xc60c, 0xb913, 0x3832, 0x472d, 0x70e2, 0x0ffd, 0x8edc, 0xf1c3, 0xd5ab, 0xaab4, 0x2b95,
            0x548a, 0x440b, 0x3b14, 0xba35, 0xc52a, 0xe142, 0x9e5d, 0x1f7c, 0x6063, 0x57ac, 0x28b3,
            0xa992, 0xd68d, 0xf2e5, 0x8dfa, 0x0cdb, 0x73c4, 0x2dd9, 0x52c6, 0xd3e7, 0xacf8, 0x8890,
            0xf78f, 0x76ae, 0x09b1, 0x3e7e, 0x4161, 0xc040, 0xbf5f, 0x9b37, 0xe428, 0x6509, 0x1a16,
            0x0a97, 0x7588, 0xf4a9, 0x8bb6, 0xafde, 0xd0c1, 0x51e0, 0x2eff, 0x1930, 0x662f, 0xe70e,
            0x9811, 0xbc79, 0xc366, 0x4247, 0x3d58, 0xfe7d, 0x8162, 0x0043, 0x7f5c, 0x5b34, 0x242b,
            0xa50a, 0xda15, 0xedda, 0x92c5, 0x13e4, 0x6cfb, 0x4893, 0x378c, 0xb6ad, 0xc9b2, 0xd933,
            0xa62c, 0x270d, 0x5812, 0x7c7a, 0x0365, 0x8244, 0xfd5b, 0xca94, 0xb58b, 0x34aa, 0x4bb5,
            0x6fdd, 0x10c2, 0x91e3, 0xeefc, 0xb0e1, 0xcffe, 0x4edf, 0x31c0, 0x15a8, 0x6ab7, 0xeb96,
            0x9489, 0xa346, 0xdc59, 0x5d78, 0x2267, 0x060f, 0x7910, 0xf831, 0x872e, 0x97af, 0xe8b0,
            0x6991, 0x168e, 0x32e6, 0x4df9, 0xccd8, 0xb3c7, 0x8408, 0xfb17, 0x7a36, 0x0529, 0x2141,
            0x5e5e, 0xdf7f, 0xa060,
        ],
        [
            0x0000, 0xc68a, 0xd421, 0x12ab, 0xf177, 0x37fd, 0x2556, 0xe3dc, 0xbbdb, 0x7d51, 0x6ffa,
            0xa970, 0x4aac, 0x8c26, 0x9e8d, 0x5807, 0x2e83, 0xe809, 0xfaa2, 0x3c28, 0xdff4, 0x197e,
            0x0bd5, 0xcd5f, 0x9558, 0x53d2, 0x4179, 0x87f3, 0x642f, 0xa2a5, 0xb00e, 0x7684, 0x5d06,
            0x9b8c, 0x8927, 0x4fad, 0xac71, 0x6afb, 0x7850, 0xbeda, 0xe6dd, 0x2057, 0x32fc, 0xf476,
            0x17aa, 0xd120, 0xc38b, 0x0501, 0x7385, 0xb50f, 0xa7a4, 0x612e, 0x82f2, 0x4478, 0x56d3,
            0x9059, 0xc85e, 0x0ed4, 0x1c7f, 0xdaf5, 0x3929, 0xffa3, 0xed08, 0x2b82, 0xba0c, 0x7c86,
            0x6e2d, 0xa8a7, 0x4b7b, 0x8df1, 0x9f5a, 0x59d0, 0x01d7, 0xc75d, 0xd5f6, 0x137c, 0xf0a0,
            0x362a, 0x2481, 0xe20b, 0x948f, 0x5205, 0x40ae, 0x8624, 0x65f8, 0xa372, 0xb1d9, 0x7753,
            0x2f54, 0xe9de, 0xfb75, 0x3dff, 0xde23, 0x18a9, 0x0a02, 0xcc88, 0xe70a, 0x2180, 0x332b,
            0xf5a1, 0x167d, 0xd0f7, 0xc25c, 0x04d6, 0x5cd1, 0x9a5b, 0x88f0, 0x4e7a, 0xada6, 0x6b2c,
            0x7987, 0xbf0d, 0xc989, 0x0f03, 0x1da8, 0xdb22, 0x38fe, 0xfe74, 0xecdf, 0x2a55, 0x7252,
            0xb4d8, 0xa673, 0x60f9, 0x8325, 0x45af, 0x5704, 0x918e, 0x2d2d, 0xeba7, 0xf90c, 0x3f86,
            0xdc5a, 0x1ad0, 0x087b, 0xcef1, 0x96f6, 0x507c, 0x42d7, 0x845d, 0x6781, 0xa10b, 0xb3a0,
            0x752a, 0x03ae, 0xc524, 0xd78f, 0x1105, 0xf2d9, 0x3453, 0x26f8, 0xe072, 0xb875, 0x7eff,
            0x6c54, 0xaade, 0x4902, 0x8f88, 0x9d23, 0x5ba9, 0x702b, 0xb6a1, 0xa40a, 0x6280, 0x815c,
            0x47d6, 0x557d, 0x93f7, 0xcbf0, 0x0d7a, 0x1fd1, 0xd95b, 0x3a87, 0xfc0d, 0xeea6, 0x282c,
            0x5ea8, 0x9822, 0x8a89, 0x4c03, 0xafdf, 0x6955, 0x7bfe, 0xbd74, 0xe573, 0x23f9, 0x3152,
            0xf7d8, 0x1404, 0xd28e, 0xc025, 0x06af, 0x9721, 0x51ab, 0x4300, 0x858a, 0x6656, 0xa0dc,
            0xb277, 0x74fd, 0x2cfa, 0xea70, 0xf8db, 0x3e51, 0xdd8d, 0x1b07, 0x09ac, 0xcf26, 0xb9a2,
            0x7f28, 0x6d83, 0xab09, 0x48d5, 0x8e5f, 0x9cf4, 0x5a7e, 0x0279, 0xc4f3, 0xd658, 0x10d2,
            0xf30e, 0x3584, 0x272f, 0xe1a5, 0xca27, 0x0cad, 0x1e06, 0xd88c, 0x3b50, 0xfdda, 0xef71,
            0x29fb, 0x71fc, 0xb776, 0xa5dd, 0x6357, 0x808b, 0x4601, 0x54aa, 0x9220, 0xe4a4, 0x222e,
            0x3085, 0xf60f, 0x15d3, 0xd359, 0xc1f2, 0x0778, 0x5f7f, 0x99f5, 0x8b5e, 0x4dd4, 0xae08,
            0x6882, 0x7a29, 0xbca3,
        ],
        [
            0x0000, 0x5a5a, 0xb4b4, 0xeeee, 0x305d, 0x6a07, 0x84e9, 0xdeb3, 0x60ba, 0x3ae0, 0xd40e,
            0x8e54, 0x50e7, 0x0abd, 0xe453, 0xbe09, 0xc174, 0x9b2e, 0x75c0, 0x2f9a, 0xf129, 0xab73,
            0x459d, 0x1fc7, 0xa1ce, 0xfb94, 0x157a, 0x4f20, 0x9193, 0xcbc9, 0x2527, 0x7f7d, 0xdbdd,
            0x8187, 0x6f69, 0x3533, 0xeb80, 0xb1da, 0x5f34, 0x056e, 0xbb67, 0xe13d, 0x0fd3, 0x5589,
            0x8b3a, 0xd160, 0x3f8e, 0x65d4, 0x1aa9, 0x40f3, 0xae1d, 0xf447, 0x2af4, 0x70ae, 0x9e40,
            0xc41a, 0x7a13, 0x2049, 0xcea7, 0x94fd, 0x4a4e, 0x1014, 0xfefa, 0xa4a0, 0xee8f, 0xb4d5,
            0x5a3b, 0x0061, 0xded2, 0x8488, 0x6a66, 0x303c, 0x8e35, 0xd46f, 0x3a81, 0x60db, 0xbe68,
            0xe432, 0x0adc, 0x5086, 0x2ffb, 0x75a1, 0x9b4f, 0xc115, 0x1fa6, 0x45fc, 0xab12, 0xf148,
            0x4f41, 0x151b, 0xfbf5, 0xa1af, 0x7f1c, 0x2546, 0xcba8, 0x91f2, 0x3552, 0x6f08, 0x81e6,
            0xdbbc, 0x050f, 0x5f55, 0xb1bb, 0xebe1, 0x55e8, 0x0fb2, 0xe15c, 0xbb06, 0x65b5, 0x3fef,
            0xd101, 0x8b5b, 0xf426, 0xae7c, 0x4092, 0x1ac8, 0xc47b, 0x9e21, 0x70cf, 0x2a95, 0x949c,
            0xcec6, 0x2028, 0x7a72, 0xa4c1, 0xfe9b, 0x1075, 0x4a2f, 0x842b, 0xde71, 0x309f, 0x6ac5,
            0xb476, 0xee2c, 0x00c2, 0x5a98, 0xe491, 0xbecb, 0x5025, 0x0a7f, 0xd4cc, 0x8e96, 0x6078,
            0x3a22, 0x455f, 0x1f05, 0xf1eb, 0xabb1, 0x7502, 0x2f58, 0xc1b6, 0x9bec, 0x25e5, 0x7fbf,
            0x9151, 0xcb0b, 0x15b8, 0x4fe2, 0xa10c, 0xfb56, 0x5ff6, 0x05ac, 0xeb42, 0xb118, 0x6fab,
            0x35f1, 0xdb1f, 0x8145, 0x3f4c, 0x6516, 0x8bf8, 0xd1a2, 0x0f11, 0x554b, 0xbba5, 0xe1ff,
            0x9e82, 0xc4d8, 0x2a36, 0x706c, 0xaedf, 0xf485, 0x1a6b, 0x4031, 0xfe38, 0xa462, 0x4a8c,
            0x10d6, 0xce65, 0x943f, 0x7ad1, 0x208b, 0x6aa4, 0x30fe, 0xde10, 0x844a, 0x5af9, 0x00a3,
            0xee4d, 0xb417, 0x0a1e, 0x5044, 0xbeaa, 0xe4f0, 0x3a43, 0x6019, 0x8ef7, 0xd4ad, 0xabd0,
            0xf18a, 0x1f64, 0x453e, 0x9b8d, 0xc1d7, 0x2f39, 0x7563, 0xcb6a, 0x9130, 0x7fde, 0x2584,
            0xfb37, 0xa16d, 0x4f83, 0x15d9, 0xb179, 0xeb23, 0x05cd, 0x5f97, 0x8124, 0xdb7e, 0x3590,
            0x6fca, 0xd1c3, 0x8b99, 0x6577, 0x3f2d, 0xe19e, 0xbbc4, 0x552a, 0x0f70, 0x700d, 0x2a57,
            0xc4b9, 0x9ee3, 0x4050, 0x1a0a, 0xf4e4, 0xaebe, 0x10b7, 0x4aed, 0xa403, 0xfe59, 0x20ea,
            0x7ab0, 0x945e, 0xce04,
        ],
    ];

    pub static CRC16_OPENSAFETY_B_TABLE: [[u16; 256]; 16] = [
        [
            0x0000, 0x755b, 0xeab6, 0x9fed, 0xa037, 0xd56c, 0x4a81, 0x3fda, 0x3535, 0x406e, 0xdf83,
            0xaad8, 0x9502, 0xe059, 0x7fb4, 0x0aef, 0x6a6a, 0x1f31, 0x80dc, 0xf587, 0xca5d, 0xbf06,
            0x20eb, 0x55b0, 0x5f5f, 0x2a04, 0xb5e9, 0xc0b2, 0xff68, 0x8a33, 0x15de, 0x6085, 0xd4d4,
            0xa18f, 0x3e62, 0x4b39, 0x74e3, 0x01b8, 0x9e55, 0xeb0e, 0xe1e1, 0x94ba, 0x0b57, 0x7e0c,
            0x41d6, 0x348d, 0xab60, 0xde3b, 0xbebe, 0xcbe5, 0x5408, 0x2153, 0x1e89, 0x6bd2, 0xf43f,
            0x8164, 0x8b8b, 0xfed0, 0x613d, 0x1466, 0x2bbc, 0x5ee7, 0xc10a, 0xb451, 0xdcf3, 0xa9a8,
            0x3645, 0x431e, 0x7cc4, 0x099f, 0x9672, 0xe329, 0xe9c6, 0x9c9d, 0x0370, 0x762b, 0x49f1,
            0x3caa, 0xa347, 0xd61c, 0xb699, 0xc3c2, 0x5c2f, 0x2974, 0x16ae, 0x63f5, 0xfc18, 0x8943,
            0x83ac, 0xf6f7, 0x691a, 0x1c41, 0x239b, 0x56c0, 0xc92d, 0xbc76, 0x0827, 0x7d7c, 0xe291,
            0x97ca, 0xa810, 0xdd4b, 0x42a6, 0x37fd, 0x3d12, 0x4849, 0xd7a4, 0xa2ff, 0x9d25, 0xe87e,
            0x7793, 0x02c8, 0x624d, 0x1716, 0x88fb, 0xfda0, 0xc27a, 0xb721, 0x28cc, 0x5d97, 0x5778,
            0x2223, 0xbdce, 0xc895, 0xf74f, 0x8214, 0x1df9, 0x68a2, 0xccbd, 0xb9e6, 0x260b, 0x5350,
            0x6c8a, 0x19d1, 0x863c, 0xf367, 0xf988, 0x8cd3, 0x133e, 0x6665, 0x59bf, 0x2ce4, 0xb309,
            0xc652, 0xa6d7, 0xd38c, 0x4c61, 0x393a, 0x06e0, 0x73bb, 0xec56, 0x990d, 0x93e2, 0xe6b9,
            0x7954, 0x0c0f, 0x33d5, 0x468e, 0xd963, 0xac38, 0x1869, 0x6d32, 0xf2df, 0x8784, 0xb85e,
            0xcd05, 0x52e8, 0x27b3, 0x2d5c, 0x5807, 0xc7ea, 0xb2b1, 0x8d6b, 0xf830, 0x67dd, 0x1286,
            0x7203, 0x0758, 0x98b5, 0xedee, 0xd234, 0xa76f, 0x3882, 0x4dd9, 0x4736, 0x326d, 0xad80,
            0xd8db, 0xe701, 0x925a, 0x0db7, 0x78ec, 0x104e, 0x6515, 0xfaf8, 0x8fa3, 0xb079, 0xc522,
            0x5acf, 0x2f94, 0x257b, 0x5020, 0xcfcd, 0xba96, 0x854c, 0xf017, 0x6ffa, 0x1aa1, 0x7a24,
            0x0f7f, 0x9092, 0xe5c9, 0xda13, 0xaf48, 0x30a5, 0x45fe, 0x4f11, 0x3a4a, 0xa5a7, 0xd0fc,
            0xef26, 0x9a7d, 0x0590, 0x70cb, 0xc49a, 0xb1c1, 0x2e2c, 0x5b77, 0x64ad, 0x11f6, 0x8e1b,
            0xfb40, 0xf1af, 0x84f4, 0x1b19, 0x6e42, 0x5198, 0x24c3, 0xbb2e, 0xce75, 0xaef0, 0xdbab,
            0x4446, 0x311d, 0x0ec7, 0x7b9c, 0xe471, 0x912a, 0x9bc5, 0xee9e, 0x7173, 0x0428, 0x3bf2,
            0x4ea9, 0xd144, 0xa41f,
        ],
        [
            0x0000, 0xec21, 0xad19, 0x4138, 0x2f69, 0xc348, 0x8270, 0x6e51, 0x5ed2, 0xb2f3, 0xf3cb,
            0x1fea, 0x71bb, 0x9d9a, 0xdca2, 0x3083, 0xbda4, 0x5185, 0x10bd, 0xfc9c, 0x92cd, 0x7eec,
            0x3fd4, 0xd3f5, 0xe376, 0x0f57, 0x4e6f, 0xa24e, 0xcc1f, 0x203e, 0x6106, 0x8d27, 0x0e13,
            0xe232, 0xa30a, 0x4f2b, 0x217a, 0xcd5b, 0x8c63, 0x6042, 0x50c1, 0xbce0, 0xfdd8, 0x11f9,
            0x7fa8, 0x9389, 0xd2b1, 0x3e90, 0xb3b7, 0x5f96, 0x1eae, 0xf28f, 0x9cde, 0x70ff, 0x31c7,
            0xdde6, 0xed65, 0x0144, 0x407c, 0xac5d, 0xc20c, 0x2e2d, 0x6f15, 0x8334, 0x1c26, 0xf007,
            0xb13f, 0x5d1e, 0x334f, 0xdf6e, 0x9e56, 0x7277, 0x42f4, 0xaed5, 0xefed, 0x03cc, 0x6d9d,
            0x81bc, 0xc084, 0x2ca5, 0xa182, 0x4da3, 0x0c9b, 0xe0ba, 0x8eeb, 0x62ca, 0x23f2, 0xcfd3,
            0xff50, 0x1371, 0x5249, 0xbe68, 0xd039, 0x3c18, 0x7d20, 0x9101, 0x1235, 0xfe14, 0xbf2c,
            0x530d, 0x3d5c, 0xd17d, 0x9045, 0x7c64, 0x4ce7, 0xa0c6, 0xe1fe, 0x0ddf, 0x638e, 0x8faf,
            0xce97, 0x22b6, 0xaf91, 0x43b0, 0x0288, 0xeea9, 0x80f8, 0x6cd9, 0x2de1, 0xc1c0, 0xf143,
            0x1d62, 0x5c5a, 0xb07b, 0xde2a, 0x320b, 0x7333, 0x9f12, 0x384c, 0xd46d, 0x9555, 0x7974,
            0x1725, 0xfb04, 0xba3c, 0x561d, 0x669e, 0x8abf, 0xcb87, 0x27a6, 0x49f7, 0xa5d6, 0xe4ee,
            0x08cf, 0x85e8, 0x69c9, 0x28f1, 0xc4d0, 0xaa81, 0x46a0, 0x0798, 0xebb9, 0xdb3a, 0x371b,
            0x7623, 0x9a02, 0xf453, 0x1872, 0x594a, 0xb56b, 0x365f, 0xda7e, 0x9b46, 0x7767, 0x1936,
            0xf517, 0xb42f, 0x580e, 0x688d, 0x84ac, 0xc594, 0x29b5, 0x47e4, 0xabc5, 0xeafd, 0x06dc,
            0x8bfb, 0x67da, 0x26e2, 0xcac3, 0xa492, 0x48b3, 0x098b, 0xe5aa, 0xd529, 0x3908, 0x7830,
            0x9411, 0xfa40, 0x1661, 0x5759, 0xbb78, 0x246a, 0xc84b, 0x8973, 0x6552, 0x0b03, 0xe722,
            0xa61a, 0x4a3b, 0x7ab8, 0x9699, 0xd7a1, 0x3b80, 0x55d1, 0xb9f0, 0xf8c8, 0x14e9, 0x99ce,
            0x75ef, 0x34d7, 0xd8f6, 0xb6a7, 0x5a86, 0x1bbe, 0xf79f, 0xc71c, 0x2b3d, 0x6a05, 0x8624,
            0xe875, 0x0454, 0x456c, 0xa94d, 0x2a79, 0xc658, 0x8760, 0x6b41, 0x0510, 0xe931, 0xa809,
            0x4428, 0x74ab, 0x988a, 0xd9b2, 0x3593, 0x5bc2, 0xb7e3, 0xf6db, 0x1afa, 0x97dd, 0x7bfc,
            0x3ac4, 0xd6e5, 0xb8b4, 0x5495, 0x15ad, 0xf98c, 0xc90f, 0x252e, 0x6416, 0x8837, 0xe666,
            0x0a47, 0x4b7f, 0xa75e,
        ],
        [
            0x0000, 0x7098, 0xe130, 0x91a8, 0xb73b, 0xc7a3, 0x560b, 0x2693, 0x1b2d, 0x6bb5, 0xfa1d,
            0x8a85, 0xac16, 0xdc8e, 0x4d26, 0x3dbe, 0x365a, 0x46c2, 0xd76a, 0xa7f2, 0x8161, 0xf1f9,
            0x6051, 0x10c9, 0x2d77, 0x5def, 0xcc47, 0xbcdf, 0x9a4c, 0xead4, 0x7b7c, 0x0be4, 0x6cb4,
            0x1c2c, 0x8d84, 0xfd1c, 0xdb8f, 0xab17, 0x3abf, 0x4a27, 0x7799, 0x0701, 0x96a9, 0xe631,
            0xc0a2, 0xb03a, 0x2192, 0x510a, 0x5aee, 0x2a76, 0xbbde, 0xcb46, 0xedd5, 0x9d4d, 0x0ce5,
            0x7c7d, 0x41c3, 0x315b, 0xa0f3, 0xd06b, 0xf6f8, 0x8660, 0x17c8, 0x6750, 0xd968, 0xa9f0,
            0x3858, 0x48c0, 0x6e53, 0x1ecb, 0x8f63, 0xfffb, 0xc245, 0xb2dd, 0x2375, 0x53ed, 0x757e,
            0x05e6, 0x944e, 0xe4d6, 0xef32, 0x9faa, 0x0e02, 0x7e9a, 0x5809, 0x2891, 0xb939, 0xc9a1,
            0xf41f, 0x8487, 0x152f, 0x65b7, 0x4324, 0x33bc, 0xa214, 0xd28c, 0xb5dc, 0xc544, 0x54ec,
            0x2474, 0x02e7, 0x727f, 0xe3d7, 0x934f, 0xaef1, 0xde69, 0x4fc1, 0x3f59, 0x19ca, 0x6952,
            0xf8fa, 0x8862, 0x8386, 0xf31e, 0x62b6, 0x122e, 0x34bd, 0x4425, 0xd58d, 0xa515, 0x98ab,
            0xe833, 0x799b, 0x0903, 0x2f90, 0x5f08, 0xcea0, 0xbe38, 0xc78b, 0xb713, 0x26bb, 0x5623,
            0x70b0, 0x0028, 0x9180, 0xe118, 0xdca6, 0xac3e, 0x3d96, 0x4d0e, 0x6b9d, 0x1b05, 0x8aad,
            0xfa35, 0xf1d1, 0x8149, 0x10e1, 0x6079, 0x46ea, 0x3672, 0xa7da, 0xd742, 0xeafc, 0x9a64,
            0x0bcc, 0x7b54, 0x5dc7, 0x2d5f, 0xbcf7, 0xcc6f, 0xab3f, 0xdba7, 0x4a0f, 0x3a97, 0x1c04,
            0x6c9c, 0xfd34, 0x8dac, 0xb012, 0xc08a, 0x5122, 0x21ba, 0x0729, 0x77b1, 0xe619, 0x9681,
            0x9d65, 0xedfd, 0x7c55, 0x0ccd, 0x2a5e, 0x5ac6, 0xcb6e, 0xbbf6, 0x8648, 0xf6d0, 0x6778,
            0x17e0, 0x3173, 0x41eb, 0xd043, 0xa0db, 0x1ee3, 0x6e7b, 0xffd3, 0x8f4b, 0xa9d8, 0xd940,
            0x48e8, 0x3870, 0x05ce, 0x7556, 0xe4fe, 0x9466, 0xb2f5, 0xc26d, 0x53c5, 0x235d, 0x28b9,
            0x5821, 0xc989, 0xb911, 0x9f82, 0xef1a, 0x7eb2, 0x0e2a, 0x3394, 0x430c, 0xd2a4, 0xa23c,
            0x84af, 0xf437, 0x659f, 0x1507, 0x7257, 0x02cf, 0x9367, 0xe3ff, 0xc56c, 0xb5f4, 0x245c,
            0x54c4, 0x697a, 0x19e2, 0x884a, 0xf8d2, 0xde41, 0xaed9, 0x3f71, 0x4fe9, 0x440d, 0x3495,
            0xa53d, 0xd5a5, 0xf336, 0x83ae, 0x1206, 0x629e, 0x5f20, 0x2fb8, 0xbe10, 0xce88, 0xe81b,
            0x9883, 0x092b, 0x79b3,
        ],
        [
            0x0000, 0xfa4d, 0x81c1, 0x7b8c, 0x76d9, 0x8c94, 0xf718, 0x0d55, 0xedb2, 0x17ff, 0x6c73,
            0x963e, 0x9b6b, 0x6126, 0x1aaa, 0xe0e7, 0xae3f, 0x5472, 0x2ffe, 0xd5b3, 0xd8e6, 0x22ab,
            0x5927, 0xa36a, 0x438d, 0xb9c0, 0xc24c, 0x3801, 0x3554, 0xcf19, 0xb495, 0x4ed8, 0x2925,
            0xd368, 0xa8e4, 0x52a9, 0x5ffc, 0xa5b1, 0xde3d, 0x2470, 0xc497, 0x3eda, 0x4556, 0xbf1b,
            0xb24e, 0x4803, 0x338f, 0xc9c2, 0x871a, 0x7d57, 0x06db, 0xfc96, 0xf1c3, 0x0b8e, 0x7002,
            0x8a4f, 0x6aa8, 0x90e5, 0xeb69, 0x1124, 0x1c71, 0xe63c, 0x9db0, 0x67fd, 0x524a, 0xa807,
            0xd38b, 0x29c6, 0x2493, 0xdede, 0xa552, 0x5f1f, 0xbff8, 0x45b5, 0x3e39, 0xc474, 0xc921,
            0x336c, 0x48e0, 0xb2ad, 0xfc75, 0x0638, 0x7db4, 0x87f9, 0x8aac, 0x70e1, 0x0b6d, 0xf120,
            0x11c7, 0xeb8a, 0x9006, 0x6a4b, 0x671e, 0x9d53, 0xe6df, 0x1c92, 0x7b6f, 0x8122, 0xfaae,
            0x00e3, 0x0db6, 0xf7fb, 0x8c77, 0x763a, 0x96dd, 0x6c90, 0x171c, 0xed51, 0xe004, 0x1a49,
            0x61c5, 0x9b88, 0xd550, 0x2f1d, 0x5491, 0xaedc, 0xa389, 0x59c4, 0x2248, 0xd805, 0x38e2,
            0xc2af, 0xb923, 0x436e, 0x4e3b, 0xb476, 0xcffa, 0x35b7, 0xa494, 0x5ed9, 0x2555, 0xdf18,
            0xd24d, 0x2800, 0x538c, 0xa9c1, 0x4926, 0xb36b, 0xc8e7, 0x32aa, 0x3fff, 0xc5b2, 0xbe3e,
            0x4473, 0x0aab, 0xf0e6, 0x8b6a, 0x7127, 0x7c72, 0x863f, 0xfdb3, 0x07fe, 0xe719, 0x1d54,
            0x66d8, 0x9c95, 0x91c0, 0x6b8d, 0x1001, 0xea4c, 0x8db1, 0x77fc, 0x0c70, 0xf63d, 0xfb68,
            0x0125, 0x7aa9, 0x80e4, 0x6003, 0x9a4e, 0xe1c2, 0x1b8f, 0x16da, 0xec97, 0x971b, 0x6d56,
            0x238e, 0xd9c3, 0xa24f, 0x5802, 0x5557, 0xaf1a, 0xd496, 0x2edb, 0xce3c, 0x3471, 0x4ffd,
            0xb5b0, 0xb8e5, 0x42a8, 0x3924, 0xc369, 0xf6de, 0x0c93, 0x771f, 0x8d52, 0x8007, 0x7a4a,
            0x01c6, 0xfb8b, 0x1b6c, 0xe121, 0x9aad, 0x60e0, 0x6db5, 0x97f8, 0xec74, 0x1639, 0x58e1,
            0xa2ac, 0xd920, 0x236d, 0x2e38, 0xd475, 0xaff9, 0x55b4, 0xb553, 0x4f1e, 0x3492, 0xcedf,
            0xc38a, 0x39c7, 0x424b, 0xb806, 0xdffb, 0x25b6, 0x5e3a, 0xa477, 0xa922, 0x536f, 0x28e3,
            0xd2ae, 0x3249, 0xc804, 0xb388, 0x49c5, 0x4490, 0xbedd, 0xc551, 0x3f1c, 0x71c4, 0x8b89,
            0xf005, 0x0a48, 0x071d, 0xfd50, 0x86dc, 0x7c91, 0x9c76, 0x663b, 0x1db7, 0xe7fa, 0xeaaf,
            0x10e2, 0x6b6e, 0x9123,
        ],
        [
            0x0000, 0x3c73, 0x78e6, 0x4495, 0xf1cc, 0xcdbf, 0x892a, 0xb559, 0x96c3, 0xaab0, 0xee25,
            0xd256, 0x670f, 0x5b7c, 0x1fe9, 0x239a, 0x58dd, 0x64ae, 0x203b, 0x1c48, 0xa911, 0x9562,
            0xd1f7, 0xed84, 0xce1e, 0xf26d, 0xb6f8, 0x8a8b, 0x3fd2, 0x03a1, 0x4734, 0x7b47, 0xb1ba,
            0x8dc9, 0xc95c, 0xf52f, 0x4076, 0x7c05, 0x3890, 0x04e3, 0x2779, 0x1b0a, 0x5f9f, 0x63ec,
            0xd6b5, 0xeac6, 0xae53, 0x9220, 0xe967, 0xd514, 0x9181, 0xadf2, 0x18ab, 0x24d8, 0x604d,
            0x5c3e, 0x7fa4, 0x43d7, 0x0742, 0x3b31, 0x8e68, 0xb21b, 0xf68e, 0xcafd, 0x162f, 0x2a5c,
            0x6ec9, 0x52ba, 0xe7e3, 0xdb90, 0x9f05, 0xa376, 0x80ec, 0xbc9f, 0xf80a, 0xc479, 0x7120,
            0x4d53, 0x09c6, 0x35b5, 0x4ef2, 0x7281, 0x3614, 0x0a67, 0xbf3e, 0x834d, 0xc7d8, 0xfbab,
            0xd831, 0xe442, 0xa0d7, 0x9ca4, 0x29fd, 0x158e, 0x511b, 0x6d68, 0xa795, 0x9be6, 0xdf73,
            0xe300, 0x5659, 0x6a2a, 0x2ebf, 0x12cc, 0x3156, 0x0d25, 0x49b0, 0x75c3, 0xc09a, 0xfce9,
            0xb87c, 0x840f, 0xff48, 0xc33b, 0x87ae, 0xbbdd, 0x0e84, 0x32f7, 0x7662, 0x4a11, 0x698b,
            0x55f8, 0x116d, 0x2d1e, 0x9847, 0xa434, 0xe0a1, 0xdcd2, 0x2c5e, 0x102d, 0x54b8, 0x68cb,
            0xdd92, 0xe1e1, 0xa574, 0x9907, 0xba9d, 0x86ee, 0xc27b, 0xfe08, 0x4b51, 0x7722, 0x33b7,
            0x0fc4, 0x7483, 0x48f0, 0x0c65, 0x3016, 0x854f, 0xb93c, 0xfda9, 0xc1da, 0xe240, 0xde33,
            0x9aa6, 0xa6d5, 0x138c, 0x2fff, 0x6b6a, 0x5719, 0x9de4, 0xa197, 0xe502, 0xd971, 0x6c28,
            0x505b, 0x14ce, 0x28bd, 0x0b27, 0x3754, 0x73c1, 0x4fb2, 0xfaeb, 0xc698, 0x820d, 0xbe7e,
            0xc539, 0xf94a, 0xbddf, 0x81ac, 0x34f5, 0x0886, 0x4c13, 0x7060, 0x53fa, 0x6f89, 0x2b1c,
            0x176f, 0xa236, 0x9e45, 0xdad0, 0xe6a3, 0x3a71, 0x0602, 0x4297, 0x7ee4, 0xcbbd, 0xf7ce,
            0xb35b, 0x8f28, 0xacb2, 0x90c1, 0xd454, 0xe827, 0x5d7e, 0x610d, 0x2598, 0x19eb, 0x62ac,
            0x5edf, 0x1a4a, 0x2639, 0x9360, 0xaf13, 0xeb86, 0xd7f5, 0xf46f, 0xc81c, 0x8c89, 0xb0fa,
            0x05a3, 0x39d0, 0x7d45, 0x4136, 0x8bcb, 0xb7b8, 0xf32d, 0xcf5e, 0x7a07, 0x4674, 0x02e1,
            0x3e92, 0x1d08, 0x217b, 0x65ee, 0x599d, 0xecc4, 0xd0b7, 0x9422, 0xa851, 0xd316, 0xef65,
            0xabf0, 0x9783, 0x22da, 0x1ea9, 0x5a3c, 0x664f, 0x45d5, 0x79a6, 0x3d33, 0x0140, 0xb419,
            0x886a, 0xccff, 0xf08c,
        ],
        [
            0x0000, 0x58bc, 0xb178, 0xe9c4, 0x17ab, 0x4f17, 0xa6d3, 0xfe6f, 0x2f56, 0x77ea, 0x9e2e,
            0xc692, 0x38fd, 0x6041, 0x8985, 0xd139, 0x5eac, 0x0610, 0xefd4, 0xb768, 0x4907, 0x11bb,
            0xf87f, 0xa0c3, 0x71fa, 0x2946, 0xc082, 0x983e, 0x6651, 0x3eed, 0xd729, 0x8f95, 0xbd58,
            0xe5e4, 0x0c20, 0x549c, 0xaaf3, 0xf24f, 0x1b8b, 0x4337, 0x920e, 0xcab2, 0x2376, 0x7bca,
            0x85a5, 0xdd19, 0x34dd, 0x6c61, 0xe3f4, 0xbb48, 0x528c, 0x0a30, 0xf45f, 0xace3, 0x4527,
            0x1d9b, 0xcca2, 0x941e, 0x7dda, 0x2566, 0xdb09, 0x83b5, 0x6a71, 0x32cd, 0x0feb, 0x5757,
            0xbe93, 0xe62f, 0x1840, 0x40fc, 0xa938, 0xf184, 0x20bd, 0x7801, 0x91c5, 0xc979, 0x3716,
            0x6faa, 0x866e, 0xded2, 0x5147, 0x09fb, 0xe03f, 0xb883, 0x46ec, 0x1e50, 0xf794, 0xaf28,
            0x7e11, 0x26ad, 0xcf69, 0x97d5, 0x69ba, 0x3106, 0xd8c2, 0x807e, 0xb2b3, 0xea0f, 0x03cb,
            0x5b77, 0xa518, 0xfda4, 0x1460, 0x4cdc, 0x9de5, 0xc559, 0x2c9d, 0x7421, 0x8a4e, 0xd2f2,
            0x3b36, 0x638a, 0xec1f, 0xb4a3, 0x5d67, 0x05db, 0xfbb4, 0xa308, 0x4acc, 0x1270, 0xc349,
            0x9bf5, 0x7231, 0x2a8d, 0xd4e2, 0x8c5e, 0x659a, 0x3d26, 0x1fd6, 0x476a, 0xaeae, 0xf612,
            0x087d, 0x50c1, 0xb905, 0xe1b9, 0x3080, 0x683c, 0x81f8, 0xd944, 0x272b, 0x7f97, 0x9653,
            0xceef, 0x417a, 0x19c6, 0xf002, 0xa8be, 0x56d1, 0x0e6d, 0xe7a9, 0xbf15, 0x6e2c, 0x3690,
            0xdf54, 0x87e8, 0x7987, 0x213b, 0xc8ff, 0x9043, 0xa28e, 0xfa32, 0x13f6, 0x4b4a, 0xb525,
            0xed99, 0x045d, 0x5ce1, 0x8dd8, 0xd564, 0x3ca0, 0x641c, 0x9a73, 0xc2cf, 0x2b0b, 0x73b7,
            0xfc22, 0xa49e, 0x4d5a, 0x15e6, 0xeb89, 0xb335, 0x5af1, 0x024d, 0xd374, 0x8bc8, 0x620c,
            0x3ab0, 0xc4df, 0x9c63, 0x75a7, 0x2d1b, 0x103d, 0x4881, 0xa145, 0xf9f9, 0x0796, 0x5f2a,
            0xb6ee, 0xee52, 0x3f6b, 0x67d7, 0x8e13, 0xd6af, 0x28c0, 0x707c, 0x99b8, 0xc104, 0x4e91,
            0x162d, 0xffe9, 0xa755, 0x593a, 0x0186, 0xe842, 0xb0fe, 0x61c7, 0x397b, 0xd0bf, 0x8803,
            0x766c, 0x2ed0, 0xc714, 0x9fa8, 0xad65, 0xf5d9, 0x1c1d, 0x44a1, 0xbace, 0xe272, 0x0bb6,
            0x530a, 0x8233, 0xda8f, 0x334b, 0x6bf7, 0x9598, 0xcd24, 0x24e0, 0x7c5c, 0xf3c9, 0xab75,
            0x42b1, 0x1a0d, 0xe462, 0xbcde, 0x551a, 0x0da6, 0xdc9f, 0x8423, 0x6de7, 0x355b, 0xcb34,
            0x9388, 0x7a4c, 0x22f0,
        ],
        [
            0x0000, 0x3fac, 0x7f58, 0x40f4, 0xfeb0, 0xc11c, 0x81e8, 0xbe44, 0x883b, 0xb797, 0xf763,
            0xc8cf, 0x768b, 0x4927, 0x09d3, 0x367f, 0x652d, 0x5a81, 0x1a75, 0x25d9, 0x9b9d, 0xa431,
            0xe4c5, 0xdb69, 0xed16, 0xd2ba, 0x924e, 0xade2, 0x13a6, 0x2c0a, 0x6cfe, 0x5352, 0xca5a,
            0xf5f6, 0xb502, 0x8aae, 0x34ea, 0x0b46, 0x4bb2, 0x741e, 0x4261, 0x7dcd, 0x3d39, 0x0295,
            0xbcd1, 0x837d, 0xc389, 0xfc25, 0xaf77, 0x90db, 0xd02f, 0xef83, 0x51c7, 0x6e6b, 0x2e9f,
            0x1133, 0x274c, 0x18e0, 0x5814, 0x67b8, 0xd9fc, 0xe650, 0xa6a4, 0x9908, 0xe1ef, 0xde43,
            0x9eb7, 0xa11b, 0x1f5f, 0x20f3, 0x6007, 0x5fab, 0x69d4, 0x5678, 0x168c, 0x2920, 0x9764,
            0xa8c8, 0xe83c, 0xd790, 0x84c2, 0xbb6e, 0xfb9a, 0xc436, 0x7a72, 0x45de, 0x052a, 0x3a86,
            0x0cf9, 0x3355, 0x73a1, 0x4c0d, 0xf249, 0xcde5, 0x8d11, 0xb2bd, 0x2bb5, 0x1419, 0x54ed,
            0x6b41, 0xd505, 0xeaa9, 0xaa5d, 0x95f1, 0xa38e, 0x9c22, 0xdcd6, 0xe37a, 0x5d3e, 0x6292,
            0x2266, 0x1dca, 0x4e98, 0x7134, 0x31c0, 0x0e6c, 0xb028, 0x8f84, 0xcf70, 0xf0dc, 0xc6a3,
            0xf90f, 0xb9fb, 0x8657, 0x3813, 0x07bf, 0x474b, 0x78e7, 0xb685, 0x8929, 0xc9dd, 0xf671,
            0x4835, 0x7799, 0x376d, 0x08c1, 0x3ebe, 0x0112, 0x41e6, 0x7e4a, 0xc00e, 0xffa2, 0xbf56,
            0x80fa, 0xd3a8, 0xec04, 0xacf0, 0x935c, 0x2d18, 0x12b4, 0x5240, 0x6dec, 0x5b93, 0x643f,
            0x24cb, 0x1b67, 0xa523, 0x9a8f, 0xda7b, 0xe5d7, 0x7cdf, 0x4373, 0x0387, 0x3c2b, 0x826f,
            0xbdc3, 0xfd37, 0xc29b, 0xf4e4, 0xcb48, 0x8bbc, 0xb410, 0x0a54, 0x35f8, 0x750c, 0x4aa0,
            0x19f2, 0x265e, 0x66aa, 0x5906, 0xe742, 0xd8ee, 0x981a, 0xa7b6, 0x91c9, 0xae65, 0xee91,
            0xd13d, 0x6f79, 0x50d5, 0x1021, 0x2f8d, 0x576a, 0x68c6, 0x2832, 0x179e, 0xa9da, 0x9676,
            0xd682, 0xe92e, 0xdf51, 0xe0fd, 0xa009, 0x9fa5, 0x21e1, 0x1e4d, 0x5eb9, 0x6115, 0x3247,
            0x0deb, 0x4d1f, 0x72b3, 0xccf7, 0xf35b, 0xb3af, 0x8c03, 0xba7c, 0x85d0, 0xc524, 0xfa88,
            0x44cc, 0x7b60, 0x3b94, 0x0438, 0x9d30, 0xa29c, 0xe268, 0xddc4, 0x6380, 0x5c2c, 0x1cd8,
            0x2374, 0x150b, 0x2aa7, 0x6a53, 0x55ff, 0xebbb, 0xd417, 0x94e3, 0xab4f, 0xf81d, 0xc7b1,
            0x8745, 0xb8e9, 0x06ad, 0x3901, 0x79f5, 0x4659, 0x7026, 0x4f8a, 0x0f7e, 0x30d2, 0x8e96,
            0xb13a, 0xf1ce, 0xce62,
        ],
        [
            0x0000, 0x1851, 0x30a2, 0x28f3, 0x6144, 0x7915, 0x51e6, 0x49b7, 0xc288, 0xdad9, 0xf22a,
            0xea7b, 0xa3cc, 0xbb9d, 0x936e, 0x8b3f, 0xf04b, 0xe81a, 0xc0e9, 0xd8b8, 0x910f, 0x895e,
            0xa1ad, 0xb9fc, 0x32c3, 0x2a92, 0x0261, 0x1a30, 0x5387, 0x4bd6, 0x6325, 0x7b74, 0x95cd,
            0x8d9c, 0xa56f, 0xbd3e, 0xf489, 0xecd8, 0xc42b, 0xdc7a, 0x5745, 0x4f14, 0x67e7, 0x7fb6,
            0x3601, 0x2e50, 0x06a3, 0x1ef2, 0x6586, 0x7dd7, 0x5524, 0x4d75, 0x04c2, 0x1c93, 0x3460,
            0x2c31, 0xa70e, 0xbf5f, 0x97ac, 0x8ffd, 0xc64a, 0xde1b, 0xf6e8, 0xeeb9, 0x5ec1, 0x4690,
            0x6e63, 0x7632, 0x3f85, 0x27d4, 0x0f27, 0x1776, 0x9c49, 0x8418, 0xaceb, 0xb4ba, 0xfd0d,
            0xe55c, 0xcdaf, 0xd5fe, 0xae8a, 0xb6db, 0x9e28, 0x8679, 0xcfce, 0xd79f, 0xff6c, 0xe73d,
            0x6c02, 0x7453, 0x5ca0, 0x44f1, 0x0d46, 0x1517, 0x3de4, 0x25b5, 0xcb0c, 0xd35d, 0xfbae,
            0xe3ff, 0xaa48, 0xb219, 0x9aea, 0x82bb, 0x0984, 0x11d5, 0x3926, 0x2177, 0x68c0, 0x7091,
            0x5862, 0x4033, 0x3b47, 0x2316, 0x0be5, 0x13b4, 0x5a03, 0x4252, 0x6aa1, 0x72f0, 0xf9cf,
            0xe19e, 0xc96d, 0xd13c, 0x988b, 0x80da, 0xa829, 0xb078, 0xbd82, 0xa5d3, 0x8d20, 0x9571,
            0xdcc6, 0xc497, 0xec64, 0xf435, 0x7f0a, 0x675b, 0x4fa8, 0x57f9, 0x1e4e, 0x061f, 0x2eec,
            0x36bd, 0x4dc9, 0x5598, 0x7d6b, 0x653a, 0x2c8d, 0x34dc, 0x1c2f, 0x047e, 0x8f41, 0x9710,
            0xbfe3, 0xa7b2, 0xee05, 0xf654, 0xdea7, 0xc6f6, 0x284f, 0x301e, 0x18ed, 0x00bc, 0x490b,
            0x515a, 0x79a9, 0x61f8, 0xeac7, 0xf296, 0xda65, 0xc234, 0x8b83, 0x93d2, 0xbb21, 0xa370,
            0xd804, 0xc055, 0xe8a6, 0xf0f7, 0xb940, 0xa111, 0x89e2, 0x91b3, 0x1a8c, 0x02dd, 0x2a2e,
            0x327f, 0x7bc8, 0x6399, 0x4b6a, 0x533b, 0xe343, 0xfb12, 0xd3e1, 0xcbb0, 0x8207, 0x9a56,
            0xb2a5, 0xaaf4, 0x21cb, 0x399a, 0x1169, 0x0938, 0x408f, 0x58de, 0x702d, 0x687c, 0x1308,
            0x0b59, 0x23aa, 0x3bfb, 0x724c, 0x6a1d, 0x42ee, 0x5abf, 0xd180, 0xc9d1, 0xe122, 0xf973,
            0xb0c4, 0xa895, 0x8066, 0x9837, 0x768e, 0x6edf, 0x462c, 0x5e7d, 0x17ca, 0x0f9b, 0x2768,
            0x3f39, 0xb406, 0xac57, 0x84a4, 0x9cf5, 0xd542, 0xcd13, 0xe5e0, 0xfdb1, 0x86c5, 0x9e94,
            0xb667, 0xae36, 0xe781, 0xffd0, 0xd723, 0xcf72, 0x444d, 0x5c1c, 0x74ef, 0x6cbe, 0x2509,
            0x3d58, 0x15ab, 0x0dfa,
        ],
        [
            0x0000, 0x0e5f, 0x1cbe, 0x12e1, 0x397c, 0x3723, 0x25c2, 0x2b9d, 0x72f8, 0x7ca7, 0x6e46,
            0x6019, 0x4b84, 0x45db, 0x573a, 0x5965, 0xe5f0, 0xebaf, 0xf94e, 0xf711, 0xdc8c, 0xd2d3,
            0xc032, 0xce6d, 0x9708, 0x9957, 0x8bb6, 0x85e9, 0xae74, 0xa02b, 0xb2ca, 0xbc95, 0xbebb,
            0xb0e4, 0xa205, 0xac5a, 0x87c7, 0x8998, 0x9b79, 0x9526, 0xcc43, 0xc21c, 0xd0fd, 0xdea2,
            0xf53f, 0xfb60, 0xe981, 0xe7de, 0x5b4b, 0x5514, 0x47f5, 0x49aa, 0x6237, 0x6c68, 0x7e89,
            0x70d6, 0x29b3, 0x27ec, 0x350d, 0x3b52, 0x10cf, 0x1e90, 0x0c71, 0x022e, 0x082d, 0x0672,
            0x1493, 0x1acc, 0x3151, 0x3f0e, 0x2def, 0x23b0, 0x7ad5, 0x748a, 0x666b, 0x6834, 0x43a9,
            0x4df6, 0x5f17, 0x5148, 0xeddd, 0xe382, 0xf163, 0xff3c, 0xd4a1, 0xdafe, 0xc81f, 0xc640,
            0x9f25, 0x917a, 0x839b, 0x8dc4, 0xa659, 0xa806, 0xbae7, 0xb4b8, 0xb696, 0xb8c9, 0xaa28,
            0xa477, 0x8fea, 0x81b5, 0x9354, 0x9d0b, 0xc46e, 0xca31, 0xd8d0, 0xd68f, 0xfd12, 0xf34d,
            0xe1ac, 0xeff3, 0x5366, 0x5d39, 0x4fd8, 0x4187, 0x6a1a, 0x6445, 0x76a4, 0x78fb, 0x219e,
            0x2fc1, 0x3d20, 0x337f, 0x18e2, 0x16bd, 0x045c, 0x0a03, 0x105a, 0x1e05, 0x0ce4, 0x02bb,
            0x2926, 0x2779, 0x3598, 0x3bc7, 0x62a2, 0x6cfd, 0x7e1c, 0x7043, 0x5bde, 0x5581, 0x4760,
            0x493f, 0xf5aa, 0xfbf5, 0xe914, 0xe74b, 0xccd6, 0xc289, 0xd068, 0xde37, 0x8752, 0x890d,
            0x9bec, 0x95b3, 0xbe2e, 0xb071, 0xa290, 0xaccf, 0xaee1, 0xa0be, 0xb25f, 0xbc00, 0x979d,
            0x99c2, 0x8b23, 0x857c, 0xdc19, 0xd246, 0xc0a7, 0xcef8, 0xe565, 0xeb3a, 0xf9db, 0xf784,
            0x4b11, 0x454e, 0x57af, 0x59f0, 0x726d, 0x7c32, 0x6ed3, 0x608c, 0x39e9, 0x37b6, 0x2557,
            0x2b08, 0x0095, 0x0eca, 0x1c2b, 0x1274, 0x1877, 0x1628, 0x04c9, 0x0a96, 0x210b, 0x2f54,
            0x3db5, 0x33ea, 0x6a8f, 0x64d0, 0x7631, 0x786e, 0x53f3, 0x5dac, 0x4f4d, 0x4112, 0xfd87,
            0xf3d8, 0xe139, 0xef66, 0xc4fb, 0xcaa4, 0xd845, 0xd61a, 0x8f7f, 0x8120, 0x93c1, 0x9d9e,
            0xb603, 0xb85c, 0xaabd, 0xa4e2, 0xa6cc, 0xa893, 0xba72, 0xb42d, 0x9fb0, 0x91ef, 0x830e,
            0x8d51, 0xd434, 0xda6b, 0xc88a, 0xc6d5, 0xed48, 0xe317, 0xf1f6, 0xffa9, 0x433c, 0x4d63,
            0x5f82, 0x51dd, 0x7a40, 0x741f, 0x66fe, 0x68a1, 0x31c4, 0x3f9b, 0x2d7a, 0x2325, 0x08b8,
            0x06e7, 0x1406, 0x1a59,
        ],
        [
            0x0000, 0x20b4, 0x4168, 0x61dc, 0x82d0, 0xa264, 0xc3b8, 0xe30c, 0x70fb, 0x504f, 0x3193,
            0x1127, 0xf22b, 0xd29f, 0xb343, 0x93f7, 0xe1f6, 0xc142, 0xa09e, 0x802a, 0x6326, 0x4392,
            0x224e, 0x02fa, 0x910d, 0xb1b9, 0xd065, 0xf0d1, 0x13dd, 0x3369, 0x52b5, 0x7201, 0xb6b7,
            0x9603, 0xf7df, 0xd76b, 0x3467, 0x14d3, 0x750f, 0x55bb, 0xc64c, 0xe6f8, 0x8724, 0xa790,
            0x449c, 0x6428, 0x05f4, 0x2540, 0x5741, 0x77f5, 0x1629, 0x369d, 0xd591, 0xf525, 0x94f9,
            0xb44d, 0x27ba, 0x070e, 0x66d2, 0x4666, 0xa56a, 0x85de, 0xe402, 0xc4b6, 0x1835, 0x3881,
            0x595d, 0x79e9, 0x9ae5, 0xba51, 0xdb8d, 0xfb39, 0x68ce, 0x487a, 0x29a6, 0x0912, 0xea1e,
            0xcaaa, 0xab76, 0x8bc2, 0xf9c3, 0xd977, 0xb8ab, 0x981f, 0x7b13, 0x5ba7, 0x3a7b, 0x1acf,
            0x8938, 0xa98c, 0xc850, 0xe8e4, 0x0be8, 0x2b5c, 0x4a80, 0x6a34, 0xae82, 0x8e36, 0xefea,
            0xcf5e, 0x2c52, 0x0ce6, 0x6d3a, 0x4d8e, 0xde79, 0xfecd, 0x9f11, 0xbfa5, 0x5ca9, 0x7c1d,
            0x1dc1, 0x3d75, 0x4f74, 0x6fc0, 0x0e1c, 0x2ea8, 0xcda4, 0xed10, 0x8ccc, 0xac78, 0x3f8f,
            0x1f3b, 0x7ee7, 0x5e53, 0xbd5f, 0x9deb, 0xfc37, 0xdc83, 0x306a, 0x10de, 0x7102, 0x51b6,
            0xb2ba, 0x920e, 0xf3d2, 0xd366, 0x4091, 0x6025, 0x01f9, 0x214d, 0xc241, 0xe2f5, 0x8329,
            0xa39d, 0xd19c, 0xf128, 0x90f4, 0xb040, 0x534c, 0x73f8, 0x1224, 0x3290, 0xa167, 0x81d3,
            0xe00f, 0xc0bb, 0x23b7, 0x0303, 0x62df, 0x426b, 0x86dd, 0xa669, 0xc7b5, 0xe701, 0x040d,
            0x24b9, 0x4565, 0x65d1, 0xf626, 0xd692, 0xb74e, 0x97fa, 0x74f6, 0x5442, 0x359e, 0x152a,
            0x672b, 0x479f, 0x2643, 0x06f7, 0xe5fb, 0xc54f, 0xa493, 0x8427, 0x17d0, 0x3764, 0x56b8,
            0x760c, 0x9500, 0xb5b4, 0xd468, 0xf4dc, 0x285f, 0x08eb, 0x6937, 0x4983, 0xaa8f, 0x8a3b,
            0xebe7, 0xcb53, 0x58a4, 0x7810, 0x19cc, 0x3978, 0xda74, 0xfac0, 0x9b1c, 0xbba8, 0xc9a9,
            0xe91d, 0x88c1, 0xa875, 0x4b79, 0x6bcd, 0x0a11, 0x2aa5, 0xb952, 0x99e6, 0xf83a, 0xd88e,
            0x3b82, 0x1b36, 0x7aea, 0x5a5e, 0x9ee8, 0xbe5c, 0xdf80, 0xff34, 0x1c38, 0x3c8c, 0x5d50,
            0x7de4, 0xee13, 0xcea7, 0xaf7b, 0x8fcf, 0x6cc3, 0x4c77, 0x2dab, 0x0d1f, 0x7f1e, 0x5faa,
            0x3e76, 0x1ec2, 0xfdce, 0xdd7a, 0xbca6, 0x9c12, 0x0fe5, 0x2f51, 0x4e8d, 0x6e39, 0x8d35,
            0xad81, 0xcc5d, 0xece9,
        ],
        [
            0x0000, 0x60d4, 0xc1a8, 0xa17c, 0xf60b, 0x96df, 0x37a3, 0x5777, 0x994d, 0xf999, 0x58e5,
            0x3831, 0x6f46, 0x0f92, 0xaeee, 0xce3a, 0x47c1, 0x2715, 0x8669, 0xe6bd, 0xb1ca, 0xd11e,
            0x7062, 0x10b6, 0xde8c, 0xbe58, 0x1f24, 0x7ff0, 0x2887, 0x4853, 0xe92f, 0x89fb, 0x8f82,
            0xef56, 0x4e2a, 0x2efe, 0x7989, 0x195d, 0xb821, 0xd8f5, 0x16cf, 0x761b, 0xd767, 0xb7b3,
            0xe0c4, 0x8010, 0x216c, 0x41b8, 0xc843, 0xa897, 0x09eb, 0x693f, 0x3e48, 0x5e9c, 0xffe0,
            0x9f34, 0x510e, 0x31da, 0x90a6, 0xf072, 0xa705, 0xc7d1, 0x66ad, 0x0679, 0x6a5f, 0x0a8b,
            0xabf7, 0xcb23, 0x9c54, 0xfc80, 0x5dfc, 0x3d28, 0xf312, 0x93c6, 0x32ba, 0x526e, 0x0519,
            0x65cd, 0xc4b1, 0xa465, 0x2d9e, 0x4d4a, 0xec36, 0x8ce2, 0xdb95, 0xbb41, 0x1a3d, 0x7ae9,
            0xb4d3, 0xd407, 0x757b, 0x15af, 0x42d8, 0x220c, 0x8370, 0xe3a4, 0xe5dd, 0x8509, 0x2475,
            0x44a1, 0x13d6, 0x7302, 0xd27e, 0xb2aa, 0x7c90, 0x1c44, 0xbd38, 0xddec, 0x8a9b, 0xea4f,
            0x4b33, 0x2be7, 0xa21c, 0xc2c8, 0x63b4, 0x0360, 0x5417, 0x34c3, 0x95bf, 0xf56b, 0x3b51,
            0x5b85, 0xfaf9, 0x9a2d, 0xcd5a, 0xad8e, 0x0cf2, 0x6c26, 0xd4be, 0xb46a, 0x1516, 0x75c2,
            0x22b5, 0x4261, 0xe31d, 0x83c9, 0x4df3, 0x2d27, 0x8c5b, 0xec8f, 0xbbf8, 0xdb2c, 0x7a50,
            0x1a84, 0x937f, 0xf3ab, 0x52d7, 0x3203, 0x6574, 0x05a0, 0xa4dc, 0xc408, 0x0a32, 0x6ae6,
            0xcb9a, 0xab4e, 0xfc39, 0x9ced, 0x3d91, 0x5d45, 0x5b3c, 0x3be8, 0x9a94, 0xfa40, 0xad37,
            0xcde3, 0x6c9f, 0x0c4b, 0xc271, 0xa2a5, 0x03d9, 0x630d, 0x347a, 0x54ae, 0xf5d2, 0x9506,
            0x1cfd, 0x7c29, 0xdd55, 0xbd81, 0xeaf6, 0x8a22, 0x2b5e, 0x4b8a, 0x85b0, 0xe564, 0x4418,
            0x24cc, 0x73bb, 0x136f, 0xb213, 0xd2c7, 0xbee1, 0xde35, 0x7f49, 0x1f9d, 0x48ea, 0x283e,
            0x8942, 0xe996, 0x27ac, 0x4778, 0xe604, 0x86d0, 0xd1a7, 0xb173, 0x100f, 0x70db, 0xf920,
            0x99f4, 0x3888, 0x585c, 0x0f2b, 0x6fff, 0xce83, 0xae57, 0x606d, 0x00b9, 0xa1c5, 0xc111,
            0x9666, 0xf6b2, 0x57ce, 0x371a, 0x3163, 0x51b7, 0xf0cb, 0x901f, 0xc768, 0xa7bc, 0x06c0,
            0x6614, 0xa82e, 0xc8fa, 0x6986, 0x0952, 0x5e25, 0x3ef1, 0x9f8d, 0xff59, 0x76a2, 0x1676,
            0xb70a, 0xd7de, 0x80a9, 0xe07d, 0x4101, 0x21d5, 0xefef, 0x8f3b, 0x2e47, 0x4e93, 0x19e4,
            0x7930, 0xd84c, 0xb898,
        ],
        [
            0x0000, 0xdc27, 0xcd15, 0x1132, 0xef71, 0x3356, 0x2264, 0xfe43, 0xabb9, 0x779e, 0x66ac,
            0xba8b, 0x44c8, 0x98ef, 0x89dd, 0x55fa, 0x2229, 0xfe0e, 0xef3c, 0x331b, 0xcd58, 0x117f,
            0x004d, 0xdc6a, 0x8990, 0x55b7, 0x4485, 0x98a2, 0x66e1, 0xbac6, 0xabf4, 0x77d3, 0x4452,
            0x9875, 0x8947, 0x5560, 0xab23, 0x7704, 0x6636, 0xba11, 0xefeb, 0x33cc, 0x22fe, 0xfed9,
            0x009a, 0xdcbd, 0xcd8f, 0x11a8, 0x667b, 0xba5c, 0xab6e, 0x7749, 0x890a, 0x552d, 0x441f,
            0x9838, 0xcdc2, 0x11e5, 0x00d7, 0xdcf0, 0x22b3, 0xfe94, 0xefa6, 0x3381, 0x88a4, 0x5483,
            0x45b1, 0x9996, 0x67d5, 0xbbf2, 0xaac0, 0x76e7, 0x231d, 0xff3a, 0xee08, 0x322f, 0xcc6c,
            0x104b, 0x0179, 0xdd5e, 0xaa8d, 0x76aa, 0x6798, 0xbbbf, 0x45fc, 0x99db, 0x88e9, 0x54ce,
            0x0134, 0xdd13, 0xcc21, 0x1006, 0xee45, 0x3262, 0x2350, 0xff77, 0xccf6, 0x10d1, 0x01e3,
            0xddc4, 0x2387, 0xffa0, 0xee92, 0x32b5, 0x674f, 0xbb68, 0xaa5a, 0x767d, 0x883e, 0x5419,
            0x452b, 0x990c, 0xeedf, 0x32f8, 0x23ca, 0xffed, 0x01ae, 0xdd89, 0xccbb, 0x109c, 0x4566,
            0x9941, 0x8873, 0x5454, 0xaa17, 0x7630, 0x6702, 0xbb25, 0x6413, 0xb834, 0xa906, 0x7521,
            0x8b62, 0x5745, 0x4677, 0x9a50, 0xcfaa, 0x138d, 0x02bf, 0xde98, 0x20db, 0xfcfc, 0xedce,
            0x31e9, 0x463a, 0x9a1d, 0x8b2f, 0x5708, 0xa94b, 0x756c, 0x645e, 0xb879, 0xed83, 0x31a4,
            0x2096, 0xfcb1, 0x02f2, 0xded5, 0xcfe7, 0x13c0, 0x2041, 0xfc66, 0xed54, 0x3173, 0xcf30,
            0x1317, 0x0225, 0xde02, 0x8bf8, 0x57df, 0x46ed, 0x9aca, 0x6489, 0xb8ae, 0xa99c, 0x75bb,
            0x0268, 0xde4f, 0xcf7d, 0x135a, 0xed19, 0x313e, 0x200c, 0xfc2b, 0xa9d1, 0x75f6, 0x64c4,
            0xb8e3, 0x46a0, 0x9a87, 0x8bb5, 0x5792, 0xecb7, 0x3090, 0x21a2, 0xfd85, 0x03c6, 0xdfe1,
            0xced3, 0x12f4, 0x470e, 0x9b29, 0x8a1b, 0x563c, 0xa87f, 0x7458, 0x656a, 0xb94d, 0xce9e,
            0x12b9, 0x038b, 0xdfac, 0x21ef, 0xfdc8, 0xecfa, 0x30dd, 0x6527, 0xb900, 0xa832, 0x7415,
            0x8a56, 0x5671, 0x4743, 0x9b64, 0xa8e5, 0x74c2, 0x65f0, 0xb9d7, 0x4794, 0x9bb3, 0x8a81,
            0x56a6, 0x035c, 0xdf7b, 0xce49, 0x126e, 0xec2d, 0x300a, 0x2138, 0xfd1f, 0x8acc, 0x56eb,
            0x47d9, 0x9bfe, 0x65bd, 0xb99a, 0xa8a8, 0x748f, 0x2175, 0xfd52, 0xec60, 0x3047, 0xce04,
            0x1223, 0x0311, 0xdf36,
        ],
        [
            0x0000, 0xc826, 0xe517, 0x2d31, 0xbf75, 0x7753, 0x5a62, 0x9244, 0x0bb1, 0xc397, 0xeea6,
            0x2680, 0xb4c4, 0x7ce2, 0x51d3, 0x99f5, 0x1762, 0xdf44, 0xf275, 0x3a53, 0xa817, 0x6031,
            0x4d00, 0x8526, 0x1cd3, 0xd4f5, 0xf9c4, 0x31e2, 0xa3a6, 0x6b80, 0x46b1, 0x8e97, 0x2ec4,
            0xe6e2, 0xcbd3, 0x03f5, 0x91b1, 0x5997, 0x74a6, 0xbc80, 0x2575, 0xed53, 0xc062, 0x0844,
            0x9a00, 0x5226, 0x7f17, 0xb731, 0x39a6, 0xf180, 0xdcb1, 0x1497, 0x86d3, 0x4ef5, 0x63c4,
            0xabe2, 0x3217, 0xfa31, 0xd700, 0x1f26, 0x8d62, 0x4544, 0x6875, 0xa053, 0x5d88, 0x95ae,
            0xb89f, 0x70b9, 0xe2fd, 0x2adb, 0x07ea, 0xcfcc, 0x5639, 0x9e1f, 0xb32e, 0x7b08, 0xe94c,
            0x216a, 0x0c5b, 0xc47d, 0x4aea, 0x82cc, 0xaffd, 0x67db, 0xf59f, 0x3db9, 0x1088, 0xd8ae,
            0x415b, 0x897d, 0xa44c, 0x6c6a, 0xfe2e, 0x3608, 0x1b39, 0xd31f, 0x734c, 0xbb6a, 0x965b,
            0x5e7d, 0xcc39, 0x041f, 0x292e, 0xe108, 0x78fd, 0xb0db, 0x9dea, 0x55cc, 0xc788, 0x0fae,
            0x229f, 0xeab9, 0x642e, 0xac08, 0x8139, 0x491f, 0xdb5b, 0x137d, 0x3e4c, 0xf66a, 0x6f9f,
            0xa7b9, 0x8a88, 0x42ae, 0xd0ea, 0x18cc, 0x35fd, 0xfddb, 0xbb10, 0x7336, 0x5e07, 0x9621,
            0x0465, 0xcc43, 0xe172, 0x2954, 0xb0a1, 0x7887, 0x55b6, 0x9d90, 0x0fd4, 0xc7f2, 0xeac3,
            0x22e5, 0xac72, 0x6454, 0x4965, 0x8143, 0x1307, 0xdb21, 0xf610, 0x3e36, 0xa7c3, 0x6fe5,
            0x42d4, 0x8af2, 0x18b6, 0xd090, 0xfda1, 0x3587, 0x95d4, 0x5df2, 0x70c3, 0xb8e5, 0x2aa1,
            0xe287, 0xcfb6, 0x0790, 0x9e65, 0x5643, 0x7b72, 0xb354, 0x2110, 0xe936, 0xc407, 0x0c21,
            0x82b6, 0x4a90, 0x67a1, 0xaf87, 0x3dc3, 0xf5e5, 0xd8d4, 0x10f2, 0x8907, 0x4121, 0x6c10,
            0xa436, 0x3672, 0xfe54, 0xd365, 0x1b43, 0xe698, 0x2ebe, 0x038f, 0xcba9, 0x59ed, 0x91cb,
            0xbcfa, 0x74dc, 0xed29, 0x250f, 0x083e, 0xc018, 0x525c, 0x9a7a, 0xb74b, 0x7f6d, 0xf1fa,
            0x39dc, 0x14ed, 0xdccb, 0x4e8f, 0x86a9, 0xab98, 0x63be, 0xfa4b, 0x326d, 0x1f5c, 0xd77a,
            0x453e, 0x8d18, 0xa029, 0x680f, 0xc85c, 0x007a, 0x2d4b, 0xe56d, 0x7729, 0xbf0f, 0x923e,
            0x5a18, 0xc3ed, 0x0bcb, 0x26fa, 0xeedc, 0x7c98, 0xb4be, 0x998f, 0x51a9, 0xdf3e, 0x1718,
            0x3a29, 0xf20f, 0x604b, 0xa86d, 0x855c, 0x4d7a, 0xd48f, 0x1ca9, 0x3198, 0xf9be, 0x6bfa,
            0xa3dc, 0x8eed, 0x46cb,
        ],
        [
            0x0000, 0x037b, 0x06f6, 0x058d, 0x0dec, 0x0e97, 0x0b1a, 0x0861, 0x1bd8, 0x18a3, 0x1d2e,
            0x1e55, 0x1634, 0x154f, 0x10c2, 0x13b9, 0x37b0, 0x34cb, 0x3146, 0x323d, 0x3a5c, 0x3927,
            0x3caa, 0x3fd1, 0x2c68, 0x2f13, 0x2a9e, 0x29e5, 0x2184, 0x22ff, 0x2772, 0x2409, 0x6f60,
            0x6c1b, 0x6996, 0x6aed, 0x628c, 0x61f7, 0x647a, 0x6701, 0x74b8, 0x77c3, 0x724e, 0x7135,
            0x7954, 0x7a2f, 0x7fa2, 0x7cd9, 0x58d0, 0x5bab, 0x5e26, 0x5d5d, 0x553c, 0x5647, 0x53ca,
            0x50b1, 0x4308, 0x4073, 0x45fe, 0x4685, 0x4ee4, 0x4d9f, 0x4812, 0x4b69, 0xdec0, 0xddbb,
            0xd836, 0xdb4d, 0xd32c, 0xd057, 0xd5da, 0xd6a1, 0xc518, 0xc663, 0xc3ee, 0xc095, 0xc8f4,
            0xcb8f, 0xce02, 0xcd79, 0xe970, 0xea0b, 0xef86, 0xecfd, 0xe49c, 0xe7e7, 0xe26a, 0xe111,
            0xf2a8, 0xf1d3, 0xf45e, 0xf725, 0xff44, 0xfc3f, 0xf9b2, 0xfac9, 0xb1a0, 0xb2db, 0xb756,
            0xb42d, 0xbc4c, 0xbf37, 0xbaba, 0xb9c1, 0xaa78, 0xa903, 0xac8e, 0xaff5, 0xa794, 0xa4ef,
            0xa162, 0xa219, 0x8610, 0x856b, 0x80e6, 0x839d, 0x8bfc, 0x8887, 0x8d0a, 0x8e71, 0x9dc8,
            0x9eb3, 0x9b3e, 0x9845, 0x9024, 0x935f, 0x96d2, 0x95a9, 0xc8db, 0xcba0, 0xce2d, 0xcd56,
            0xc537, 0xc64c, 0xc3c1, 0xc0ba, 0xd303, 0xd078, 0xd5f5, 0xd68e, 0xdeef, 0xdd94, 0xd819,
            0xdb62, 0xff6b, 0xfc10, 0xf99d, 0xfae6, 0xf287, 0xf1fc, 0xf471, 0xf70a, 0xe4b3, 0xe7c8,
            0xe245, 0xe13e, 0xe95f, 0xea24, 0xefa9, 0xecd2, 0xa7bb, 0xa4c0, 0xa14d, 0xa236, 0xaa57,
            0xa92c, 0xaca1, 0xafda, 0xbc63, 0xbf18, 0xba95, 0xb9ee, 0xb18f, 0xb2f4, 0xb779, 0xb402,
            0x900b, 0x9370, 0x96fd, 0x9586, 0x9de7, 0x9e9c, 0x9b11, 0x986a, 0x8bd3, 0x88a8, 0x8d25,
            0x8e5e, 0x863f, 0x8544, 0x80c9, 0x83b2, 0x161b, 0x1560, 0x10ed, 0x1396, 0x1bf7, 0x188c,
            0x1d01, 0x1e7a, 0x0dc3, 0x0eb8, 0x0b35, 0x084e, 0x002f, 0x0354, 0x06d9, 0x05a2, 0x21ab,
            0x22d0, 0x275d, 0x2426, 0x2c47, 0x2f3c, 0x2ab1, 0x29ca, 0x3a73, 0x3908, 0x3c85, 0x3ffe,
            0x379f, 0x34e4, 0x3169, 0x3212, 0x797b, 0x7a00, 0x7f8d, 0x7cf6, 0x7497, 0x77ec, 0x7261,
            0x711a, 0x62a3, 0x61d8, 0x6455, 0x672e, 0x6f4f, 0x6c34, 0x69b9, 0x6ac2, 0x4ecb, 0x4db0,
            0x483d, 0x4b46, 0x4327, 0x405c, 0x45d1, 0x46aa, 0x5513, 0x5668, 0x53e5, 0x509e, 0x58ff,
            0x5b84, 0x5e09, 0x5d72,
        ],
        [
            0x0000, 0xe4ed, 0xbc81, 0x586c, 0x0c59, 0xe8b4, 0xb0d8, 0x5435, 0x18b2, 0xfc5f, 0xa433,
            0x40de, 0x14eb, 0xf006, 0xa86a, 0x4c87, 0x3164, 0xd589, 0x8de5, 0x6908, 0x3d3d, 0xd9d0,
            0x81bc, 0x6551, 0x29d6, 0xcd3b, 0x9557, 0x71ba, 0x258f, 0xc162, 0x990e, 0x7de3, 0x62c8,
            0x8625, 0xde49, 0x3aa4, 0x6e91, 0x8a7c, 0xd210, 0x36fd, 0x7a7a, 0x9e97, 0xc6fb, 0x2216,
            0x7623, 0x92ce, 0xcaa2, 0x2e4f, 0x53ac, 0xb741, 0xef2d, 0x0bc0, 0x5ff5, 0xbb18, 0xe374,
            0x0799, 0x4b1e, 0xaff3, 0xf79f, 0x1372, 0x4747, 0xa3aa, 0xfbc6, 0x1f2b, 0xc590, 0x217d,
            0x7911, 0x9dfc, 0xc9c9, 0x2d24, 0x7548, 0x91a5, 0xdd22, 0x39cf, 0x61a3, 0x854e, 0xd17b,
            0x3596, 0x6dfa, 0x8917, 0xf4f4, 0x1019, 0x4875, 0xac98, 0xf8ad, 0x1c40, 0x442c, 0xa0c1,
            0xec46, 0x08ab, 0x50c7, 0xb42a, 0xe01f, 0x04f2, 0x5c9e, 0xb873, 0xa758, 0x43b5, 0x1bd9,
            0xff34, 0xab01, 0x4fec, 0x1780, 0xf36d, 0xbfea, 0x5b07, 0x036b, 0xe786, 0xb3b3, 0x575e,
            0x0f32, 0xebdf, 0x963c, 0x72d1, 0x2abd, 0xce50, 0x9a65, 0x7e88, 0x26e4, 0xc209, 0x8e8e,
            0x6a63, 0x320f, 0xd6e2, 0x82d7, 0x663a, 0x3e56, 0xdabb, 0xfe7b, 0x1a96, 0x42fa, 0xa617,
            0xf222, 0x16cf, 0x4ea3, 0xaa4e, 0xe6c9, 0x0224, 0x5a48, 0xbea5, 0xea90, 0x0e7d, 0x5611,
            0xb2fc, 0xcf1f, 0x2bf2, 0x739e, 0x9773, 0xc346, 0x27ab, 0x7fc7, 0x9b2a, 0xd7ad, 0x3340,
            0x6b2c, 0x8fc1, 0xdbf4, 0x3f19, 0x6775, 0x8398, 0x9cb3, 0x785e, 0x2032, 0xc4df, 0x90ea,
            0x7407, 0x2c6b, 0xc886, 0x8401, 0x60ec, 0x3880, 0xdc6d, 0x8858, 0x6cb5, 0x34d9, 0xd034,
            0xadd7, 0x493a, 0x1156, 0xf5bb, 0xa18e, 0x4563, 0x1d0f, 0xf9e2, 0xb565, 0x5188, 0x09e4,
            0xed09, 0xb93c, 0x5dd1, 0x05bd, 0xe150, 0x3beb, 0xdf06, 0x876a, 0x6387, 0x37b2, 0xd35f,
            0x8b33, 0x6fde, 0x2359, 0xc7b4, 0x9fd8, 0x7b35, 0x2f00, 0xcbed, 0x9381, 0x776c, 0x0a8f,
            0xee62, 0xb60e, 0x52e3, 0x06d6, 0xe23b, 0xba57, 0x5eba, 0x123d, 0xf6d0, 0xaebc, 0x4a51,
            0x1e64, 0xfa89, 0xa2e5, 0x4608, 0x5923, 0xbdce, 0xe5a2, 0x014f, 0x557a, 0xb197, 0xe9fb,
            0x0d16, 0x4191, 0xa57c, 0xfd10, 0x19fd, 0x4dc8, 0xa925, 0xf149, 0x15a4, 0x6847, 0x8caa,
            0xd4c6, 0x302b, 0x641e, 0x80f3, 0xd89f, 0x3c72, 0x70f5, 0x9418, 0xcc74, 0x2899, 0x7cac,
            0x9841, 0xc02d, 0x24c0,
        ],
        [
            0x0000, 0x89ad, 0x6601, 0xefac, 0xcc02, 0x45af, 0xaa03, 0x23ae, 0xed5f, 0x64f2, 0x8b5e,
            0x02f3, 0x215d, 0xa8f0, 0x475c, 0xcef1, 0xafe5, 0x2648, 0xc9e4, 0x4049, 0x63e7, 0xea4a,
            0x05e6, 0x8c4b, 0x42ba, 0xcb17, 0x24bb, 0xad16, 0x8eb8, 0x0715, 0xe8b9, 0x6114, 0x2a91,
            0xa33c, 0x4c90, 0xc53d, 0xe693, 0x6f3e, 0x8092, 0x093f, 0xc7ce, 0x4e63, 0xa1cf, 0x2862,
            0x0bcc, 0x8261, 0x6dcd, 0xe460, 0x8574, 0x0cd9, 0xe375, 0x6ad8, 0x4976, 0xc0db, 0x2f77,
            0xa6da, 0x682b, 0xe186, 0x0e2a, 0x8787, 0xa429, 0x2d84, 0xc228, 0x4b85, 0x5522, 0xdc8f,
            0x3323, 0xba8e, 0x9920, 0x108d, 0xff21, 0x768c, 0xb87d, 0x31d0, 0xde7c, 0x57d1, 0x747f,
            0xfdd2, 0x127e, 0x9bd3, 0xfac7, 0x736a, 0x9cc6, 0x156b, 0x36c5, 0xbf68, 0x50c4, 0xd969,
            0x1798, 0x9e35, 0x7199, 0xf834, 0xdb9a, 0x5237, 0xbd9b, 0x3436, 0x7fb3, 0xf61e, 0x19b2,
            0x901f, 0xb3b1, 0x3a1c, 0xd5b0, 0x5c1d, 0x92ec, 0x1b41, 0xf4ed, 0x7d40, 0x5eee, 0xd743,
            0x38ef, 0xb142, 0xd056, 0x59fb, 0xb657, 0x3ffa, 0x1c54, 0x95f9, 0x7a55, 0xf3f8, 0x3d09,
            0xb4a4, 0x5b08, 0xd2a5, 0xf10b, 0x78a6, 0x970a, 0x1ea7, 0xaa44, 0x23e9, 0xcc45, 0x45e8,
            0x6646, 0xefeb, 0x0047, 0x89ea, 0x471b, 0xceb6, 0x211a, 0xa8b7, 0x8b19, 0x02b4, 0xed18,
            0x64b5, 0x05a1, 0x8c0c, 0x63a0, 0xea0d, 0xc9a3, 0x400e, 0xafa2, 0x260f, 0xe8fe, 0x6153,
            0x8eff, 0x0752, 0x24fc, 0xad51, 0x42fd, 0xcb50, 0x80d5, 0x0978, 0xe6d4, 0x6f79, 0x4cd7,
            0xc57a, 0x2ad6, 0xa37b, 0x6d8a, 0xe427, 0x0b8b, 0x8226, 0xa188, 0x2825, 0xc789, 0x4e24,
            0x2f30, 0xa69d, 0x4931, 0xc09c, 0xe332, 0x6a9f, 0x8533, 0x0c9e, 0xc26f, 0x4bc2, 0xa46e,
            0x2dc3, 0x0e6d, 0x87c0, 0x686c, 0xe1c1, 0xff66, 0x76cb, 0x9967, 0x10ca, 0x3364, 0xbac9,
            0x5565, 0xdcc8, 0x1239, 0x9b94, 0x7438, 0xfd95, 0xde3b, 0x5796, 0xb83a, 0x3197, 0x5083,
            0xd92e, 0x3682, 0xbf2f, 0x9c81, 0x152c, 0xfa80, 0x732d, 0xbddc, 0x3471, 0xdbdd, 0x5270,
            0x71de, 0xf873, 0x17df, 0x9e72, 0xd5f7, 0x5c5a, 0xb3f6, 0x3a5b, 0x19f5, 0x9058, 0x7ff4,
            0xf659, 0x38a8, 0xb105, 0x5ea9, 0xd704, 0xf4aa, 0x7d07, 0x92ab, 0x1b06, 0x7a12, 0xf3bf,
            0x1c13, 0x95be, 0xb610, 0x3fbd, 0xd011, 0x59bc, 0x974d, 0x1ee0, 0xf14c, 0x78e1, 0x5b4f,
            0xd2e2, 0x3d4e, 0xb4e3,
        ],
    ];

    pub static CRC16_PROFIBUS_TABLE: [[u16; 256]; 16] = [
        [
            0x0000, 0x1dcf, 0x3b9e, 0x2651, 0x773c, 0x6af3, 0x4ca2, 0x516d, 0xee78, 0xf3b7, 0xd5e6,
            0xc829, 0x9944, 0x848b, 0xa2da, 0xbf15, 0xc13f, 0xdcf0, 0xfaa1, 0xe76e, 0xb603, 0xabcc,
            0x8d9d, 0x9052, 0x2f47, 0x3288, 0x14d9, 0x0916, 0x587b, 0x45b4, 0x63e5, 0x7e2a, 0x9fb1,
            0x827e, 0xa42f, 0xb9e0, 0xe88d, 0xf542, 0xd313, 0xcedc, 0x71c9, 0x6c06, 0x4a57, 0x5798,
            0x06f5, 0x1b3a, 0x3d6b, 0x20a4, 0x5e8e, 0x4341, 0x6510, 0x78df, 0x29b2, 0x347d, 0x122c,
            0x0fe3, 0xb0f6, 0xad39, 0x8b68, 0x96a7, 0xc7ca, 0xda05, 0xfc54, 0xe19b, 0x22ad, 0x3f62,
            0x1933, 0x04fc, 0x5591, 0x485e, 0x6e0f, 0x73c0, 0xccd5, 0xd11a, 0xf74b, 0xea84, 0xbbe9,
            0xa626, 0x8077, 0x9db8, 0xe392, 0xfe5d, 0xd80c, 0xc5c3, 0x94ae, 0x8961, 0xaf30, 0xb2ff,
            0x0dea, 0x1025, 0x3674, 0x2bbb, 0x7ad6, 0x6719, 0x4148, 0x5c87, 0xbd1c, 0xa0d3, 0x8682,
            0x9b4d, 0xca20, 0xd7ef, 0xf1be, 0xec71, 0x5364, 0x4eab, 0x68fa, 0x7535, 0x2458, 0x3997,
            0x1fc6, 0x0209, 0x7c23, 0x61ec, 0x47bd, 0x5a72, 0x0b1f, 0x16d0, 0x3081, 0x2d4e, 0x925b,
            0x8f94, 0xa9c5, 0xb40a, 0xe567, 0xf8a8, 0xdef9, 0xc336, 0x455a, 0x5895, 0x7ec4, 0x630b,
            0x3266, 0x2fa9, 0x09f8, 0x1437, 0xab22, 0xb6ed, 0x90bc, 0x8d73, 0xdc1e, 0xc1d1, 0xe780,
            0xfa4f, 0x8465, 0x99aa, 0xbffb, 0xa234, 0xf359, 0xee96, 0xc8c7, 0xd508, 0x6a1d, 0x77d2,
            0x5183, 0x4c4c, 0x1d21, 0x00ee, 0x26bf, 0x3b70, 0xdaeb, 0xc724, 0xe175, 0xfcba, 0xadd7,
            0xb018, 0x9649, 0x8b86, 0x3493, 0x295c, 0x0f0d, 0x12c2, 0x43af, 0x5e60, 0x7831, 0x65fe,
            0x1bd4, 0x061b, 0x204a, 0x3d85, 0x6ce8, 0x7127, 0x5776, 0x4ab9, 0xf5ac, 0xe863, 0xce32,
            0xd3fd, 0x8290, 0x9f5f, 0xb90e, 0xa4c1, 0x67f7, 0x7a38, 0x5c69, 0x41a6, 0x10cb, 0x0d04,
            0x2b55, 0x369a, 0x898f, 0x9440, 0xb211, 0xafde, 0xfeb3, 0xe37c, 0xc52d, 0xd8e2, 0xa6c8,
            0xbb07, 0x9d56, 0x8099, 0xd1f4, 0xcc3b, 0xea6a, 0xf7a5, 0x48b0, 0x557f, 0x732e, 0x6ee1,
            0x3f8c, 0x2243, 0x0412, 0x19dd, 0xf846, 0xe589, 0xc3d8, 0xde17, 0x8f7a, 0x92b5, 0xb4e4,
            0xa92b, 0x163e, 0x0bf1, 0x2da0, 0x306f, 0x6102, 0x7ccd, 0x5a9c, 0x4753, 0x3979, 0x24b6,
            0x02e7, 0x1f28, 0x4e45, 0x538a, 0x75db, 0x6814, 0xd701, 0xcace, 0xec9f, 0xf150, 0xa03d,
            0xbdf2, 0x9ba3, 0x866c,
        ],
        [
            0x0000, 0x8ab4, 0x08a7, 0x8213, 0x114e, 0x9bfa, 0x19e9, 0x935d, 0x229c, 0xa828, 0x2a3b,
            0xa08f, 0x33d2, 0xb966, 0x3b75, 0xb1c1, 0x4538, 0xcf8c, 0x4d9f, 0xc72b, 0x5476, 0xdec2,
            0x5cd1, 0xd665, 0x67a4, 0xed10, 0x6f03, 0xe5b7, 0x76ea, 0xfc5e, 0x7e4d, 0xf4f9, 0x8a70,
            0x00c4, 0x82d7, 0x0863, 0x9b3e, 0x118a, 0x9399, 0x192d, 0xa8ec, 0x2258, 0xa04b, 0x2aff,
            0xb9a2, 0x3316, 0xb105, 0x3bb1, 0xcf48, 0x45fc, 0xc7ef, 0x4d5b, 0xde06, 0x54b2, 0xd6a1,
            0x5c15, 0xedd4, 0x6760, 0xe573, 0x6fc7, 0xfc9a, 0x762e, 0xf43d, 0x7e89, 0x092f, 0x839b,
            0x0188, 0x8b3c, 0x1861, 0x92d5, 0x10c6, 0x9a72, 0x2bb3, 0xa107, 0x2314, 0xa9a0, 0x3afd,
            0xb049, 0x325a, 0xb8ee, 0x4c17, 0xc6a3, 0x44b0, 0xce04, 0x5d59, 0xd7ed, 0x55fe, 0xdf4a,
            0x6e8b, 0xe43f, 0x662c, 0xec98, 0x7fc5, 0xf571, 0x7762, 0xfdd6, 0x835f, 0x09eb, 0x8bf8,
            0x014c, 0x9211, 0x18a5, 0x9ab6, 0x1002, 0xa1c3, 0x2b77, 0xa964, 0x23d0, 0xb08d, 0x3a39,
            0xb82a, 0x329e, 0xc667, 0x4cd3, 0xcec0, 0x4474, 0xd729, 0x5d9d, 0xdf8e, 0x553a, 0xe4fb,
            0x6e4f, 0xec5c, 0x66e8, 0xf5b5, 0x7f01, 0xfd12, 0x77a6, 0x125e, 0x98ea, 0x1af9, 0x904d,
            0x0310, 0x89a4, 0x0bb7, 0x8103, 0x30c2, 0xba76, 0x3865, 0xb2d1, 0x218c, 0xab38, 0x292b,
            0xa39f, 0x5766, 0xddd2, 0x5fc1, 0xd575, 0x4628, 0xcc9c, 0x4e8f, 0xc43b, 0x75fa, 0xff4e,
            0x7d5d, 0xf7e9, 0x64b4, 0xee00, 0x6c13, 0xe6a7, 0x982e, 0x129a, 0x9089, 0x1a3d, 0x8960,
            0x03d4, 0x81c7, 0x0b73, 0xbab2, 0x3006, 0xb215, 0x38a1, 0xabfc, 0x2148, 0xa35b, 0x29ef,
            0xdd16, 0x57a2, 0xd5b1, 0x5f05, 0xcc58, 0x46ec, 0xc4ff, 0x4e4b, 0xff8a, 0x753e, 0xf72d,
            0x7d99, 0xeec4, 0x6470, 0xe663, 0x6cd7, 0x1b71, 0x91c5, 0x13d6, 0x9962, 0x0a3f, 0x808b,
            0x0298, 0x882c, 0x39ed, 0xb359, 0x314a, 0xbbfe, 0x28a3, 0xa217, 0x2004, 0xaab0, 0x5e49,
            0xd4fd, 0x56ee, 0xdc5a, 0x4f07, 0xc5b3, 0x47a0, 0xcd14, 0x7cd5, 0xf661, 0x7472, 0xfec6,
            0x6d9b, 0xe72f, 0x653c, 0xef88, 0x9101, 0x1bb5, 0x99a6, 0x1312, 0x804f, 0x0afb, 0x88e8,
            0x025c, 0xb39d, 0x3929, 0xbb3a, 0x318e, 0xa2d3, 0x2867, 0xaa74, 0x20c0, 0xd439, 0x5e8d,
            0xdc9e, 0x562a, 0xc577, 0x4fc3, 0xcdd0, 0x4764, 0xf6a5, 0x7c11, 0xfe02, 0x74b6, 0xe7eb,
            0x6d5f, 0xef4c, 0x65f8,
        ],
        [
            0x0000, 0x24bc, 0x4978, 0x6dc4, 0x92f0, 0xb64c, 0xdb88, 0xff34, 0x382f, 0x1c93, 0x7157,
            0x55eb, 0xaadf, 0x8e63, 0xe3a7, 0xc71b, 0x705e, 0x54e2, 0x3926, 0x1d9a, 0xe2ae, 0xc612,
            0xabd6, 0x8f6a, 0x4871, 0x6ccd, 0x0109, 0x25b5, 0xda81, 0xfe3d, 0x93f9, 0xb745, 0xe0bc,
            0xc400, 0xa9c4, 0x8d78, 0x724c, 0x56f0, 0x3b34, 0x1f88, 0xd893, 0xfc2f, 0x91eb, 0xb557,
            0x4a63, 0x6edf, 0x031b, 0x27a7, 0x90e2, 0xb45e, 0xd99a, 0xfd26, 0x0212, 0x26ae, 0x4b6a,
            0x6fd6, 0xa8cd, 0x8c71, 0xe1b5, 0xc509, 0x3a3d, 0x1e81, 0x7345, 0x57f9, 0xdcb7, 0xf80b,
            0x95cf, 0xb173, 0x4e47, 0x6afb, 0x073f, 0x2383, 0xe498, 0xc024, 0xade0, 0x895c, 0x7668,
            0x52d4, 0x3f10, 0x1bac, 0xace9, 0x8855, 0xe591, 0xc12d, 0x3e19, 0x1aa5, 0x7761, 0x53dd,
            0x94c6, 0xb07a, 0xddbe, 0xf902, 0x0636, 0x228a, 0x4f4e, 0x6bf2, 0x3c0b, 0x18b7, 0x7573,
            0x51cf, 0xaefb, 0x8a47, 0xe783, 0xc33f, 0x0424, 0x2098, 0x4d5c, 0x69e0, 0x96d4, 0xb268,
            0xdfac, 0xfb10, 0x4c55, 0x68e9, 0x052d, 0x2191, 0xdea5, 0xfa19, 0x97dd, 0xb361, 0x747a,
            0x50c6, 0x3d02, 0x19be, 0xe68a, 0xc236, 0xaff2, 0x8b4e, 0xa4a1, 0x801d, 0xedd9, 0xc965,
            0x3651, 0x12ed, 0x7f29, 0x5b95, 0x9c8e, 0xb832, 0xd5f6, 0xf14a, 0x0e7e, 0x2ac2, 0x4706,
            0x63ba, 0xd4ff, 0xf043, 0x9d87, 0xb93b, 0x460f, 0x62b3, 0x0f77, 0x2bcb, 0xecd0, 0xc86c,
            0xa5a8, 0x8114, 0x7e20, 0x5a9c, 0x3758, 0x13e4, 0x441d, 0x60a1, 0x0d65, 0x29d9, 0xd6ed,
            0xf251, 0x9f95, 0xbb29, 0x7c32, 0x588e, 0x354a, 0x11f6, 0xeec2, 0xca7e, 0xa7ba, 0x8306,
            0x3443, 0x10ff, 0x7d3b, 0x5987, 0xa6b3, 0x820f, 0xefcb, 0xcb77, 0x0c6c, 0x28d0, 0x4514,
            0x61a8, 0x9e9c, 0xba20, 0xd7e4, 0xf358, 0x7816, 0x5caa, 0x316e, 0x15d2, 0xeae6, 0xce5a,
            0xa39e, 0x8722, 0x4039, 0x6485, 0x0941, 0x2dfd, 0xd2c9, 0xf675, 0x9bb1, 0xbf0d, 0x0848,
            0x2cf4, 0x4130, 0x658c, 0x9ab8, 0xbe04, 0xd3c0, 0xf77c, 0x3067, 0x14db, 0x791f, 0x5da3,
            0xa297, 0x862b, 0xebef, 0xcf53, 0x98aa, 0xbc16, 0xd1d2, 0xf56e, 0x0a5a, 0x2ee6, 0x4322,
            0x679e, 0xa085, 0x8439, 0xe9fd, 0xcd41, 0x3275, 0x16c9, 0x7b0d, 0x5fb1, 0xe8f4, 0xcc48,
            0xa18c, 0x8530, 0x7a04, 0x5eb8, 0x337c, 0x17c0, 0xd0db, 0xf467, 0x99a3, 0xbd1f, 0x422b,
            0x6697, 0x0b53, 0x2fef,
        ],
        [
            0x0000, 0x548d, 0xa91a, 0xfd97, 0x4ffb, 0x1b76, 0xe6e1, 0xb26c, 0x9ff6, 0xcb7b, 0x36ec,
            0x6261, 0xd00d, 0x8480, 0x7917, 0x2d9a, 0x2223, 0x76ae, 0x8b39, 0xdfb4, 0x6dd8, 0x3955,
            0xc4c2, 0x904f, 0xbdd5, 0xe958, 0x14cf, 0x4042, 0xf22e, 0xa6a3, 0x5b34, 0x0fb9, 0x4446,
            0x10cb, 0xed5c, 0xb9d1, 0x0bbd, 0x5f30, 0xa2a7, 0xf62a, 0xdbb0, 0x8f3d, 0x72aa, 0x2627,
            0x944b, 0xc0c6, 0x3d51, 0x69dc, 0x6665, 0x32e8, 0xcf7f, 0x9bf2, 0x299e, 0x7d13, 0x8084,
            0xd409, 0xf993, 0xad1e, 0x5089, 0x0404, 0xb668, 0xe2e5, 0x1f72, 0x4bff, 0x888c, 0xdc01,
            0x2196, 0x751b, 0xc777, 0x93fa, 0x6e6d, 0x3ae0, 0x177a, 0x43f7, 0xbe60, 0xeaed, 0x5881,
            0x0c0c, 0xf19b, 0xa516, 0xaaaf, 0xfe22, 0x03b5, 0x5738, 0xe554, 0xb1d9, 0x4c4e, 0x18c3,
            0x3559, 0x61d4, 0x9c43, 0xc8ce, 0x7aa2, 0x2e2f, 0xd3b8, 0x8735, 0xccca, 0x9847, 0x65d0,
            0x315d, 0x8331, 0xd7bc, 0x2a2b, 0x7ea6, 0x533c, 0x07b1, 0xfa26, 0xaeab, 0x1cc7, 0x484a,
            0xb5dd, 0xe150, 0xeee9, 0xba64, 0x47f3, 0x137e, 0xa112, 0xf59f, 0x0808, 0x5c85, 0x711f,
            0x2592, 0xd805, 0x8c88, 0x3ee4, 0x6a69, 0x97fe, 0xc373, 0x0cd7, 0x585a, 0xa5cd, 0xf140,
            0x432c, 0x17a1, 0xea36, 0xbebb, 0x9321, 0xc7ac, 0x3a3b, 0x6eb6, 0xdcda, 0x8857, 0x75c0,
            0x214d, 0x2ef4, 0x7a79, 0x87ee, 0xd363, 0x610f, 0x3582, 0xc815, 0x9c98, 0xb102, 0xe58f,
            0x1818, 0x4c95, 0xfef9, 0xaa74, 0x57e3, 0x036e, 0x4891, 0x1c1c, 0xe18b, 0xb506, 0x076a,
            0x53e7, 0xae70, 0xfafd, 0xd767, 0x83ea, 0x7e7d, 0x2af0, 0x989c, 0xcc11, 0x3186, 0x650b,
            0x6ab2, 0x3e3f, 0xc3a8, 0x9725, 0x2549, 0x71c4, 0x8c53, 0xd8de, 0xf544, 0xa1c9, 0x5c5e,
            0x08d3, 0xbabf, 0xee32, 0x13a5, 0x4728, 0x845b, 0xd0d6, 0x2d41, 0x79cc, 0xcba0, 0x9f2d,
            0x62ba, 0x3637, 0x1bad, 0x4f20, 0xb2b7, 0xe63a, 0x5456, 0x00db, 0xfd4c, 0xa9c1, 0xa678,
            0xf2f5, 0x0f62, 0x5bef, 0xe983, 0xbd0e, 0x4099, 0x1414, 0x398e, 0x6d03, 0x9094, 0xc419,
            0x7675, 0x22f8, 0xdf6f, 0x8be2, 0xc01d, 0x9490, 0x6907, 0x3d8a, 0x8fe6, 0xdb6b, 0x26fc,
            0x7271, 0x5feb, 0x0b66, 0xf6f1, 0xa27c, 0x1010, 0x449d, 0xb90a, 0xed87, 0xe23e, 0xb6b3,
            0x4b24, 0x1fa9, 0xadc5, 0xf948, 0x04df, 0x5052, 0x7dc8, 0x2945, 0xd4d2, 0x805f, 0x3233,
            0x66be, 0x9b29, 0xcfa4,
        ],
        [
            0x0000, 0x19ae, 0x335c, 0x2af2, 0x66b8, 0x7f16, 0x55e4, 0x4c4a, 0xcd70, 0xd4de, 0xfe2c,
            0xe782, 0xabc8, 0xb266, 0x9894, 0x813a, 0x872f, 0x9e81, 0xb473, 0xaddd, 0xe197, 0xf839,
            0xd2cb, 0xcb65, 0x4a5f, 0x53f1, 0x7903, 0x60ad, 0x2ce7, 0x3549, 0x1fbb, 0x0615, 0x1391,
            0x0a3f, 0x20cd, 0x3963, 0x7529, 0x6c87, 0x4675, 0x5fdb, 0xdee1, 0xc74f, 0xedbd, 0xf413,
            0xb859, 0xa1f7, 0x8b05, 0x92ab, 0x94be, 0x8d10, 0xa7e2, 0xbe4c, 0xf206, 0xeba8, 0xc15a,
            0xd8f4, 0x59ce, 0x4060, 0x6a92, 0x733c, 0x3f76, 0x26d8, 0x0c2a, 0x1584, 0x2722, 0x3e8c,
            0x147e, 0x0dd0, 0x419a, 0x5834, 0x72c6, 0x6b68, 0xea52, 0xf3fc, 0xd90e, 0xc0a0, 0x8cea,
            0x9544, 0xbfb6, 0xa618, 0xa00d, 0xb9a3, 0x9351, 0x8aff, 0xc6b5, 0xdf1b, 0xf5e9, 0xec47,
            0x6d7d, 0x74d3, 0x5e21, 0x478f, 0x0bc5, 0x126b, 0x3899, 0x2137, 0x34b3, 0x2d1d, 0x07ef,
            0x1e41, 0x520b, 0x4ba5, 0x6157, 0x78f9, 0xf9c3, 0xe06d, 0xca9f, 0xd331, 0x9f7b, 0x86d5,
            0xac27, 0xb589, 0xb39c, 0xaa32, 0x80c0, 0x996e, 0xd524, 0xcc8a, 0xe678, 0xffd6, 0x7eec,
            0x6742, 0x4db0, 0x541e, 0x1854, 0x01fa, 0x2b08, 0x32a6, 0x4e44, 0x57ea, 0x7d18, 0x64b6,
            0x28fc, 0x3152, 0x1ba0, 0x020e, 0x8334, 0x9a9a, 0xb068, 0xa9c6, 0xe58c, 0xfc22, 0xd6d0,
            0xcf7e, 0xc96b, 0xd0c5, 0xfa37, 0xe399, 0xafd3, 0xb67d, 0x9c8f, 0x8521, 0x041b, 0x1db5,
            0x3747, 0x2ee9, 0x62a3, 0x7b0d, 0x51ff, 0x4851, 0x5dd5, 0x447b, 0x6e89, 0x7727, 0x3b6d,
            0x22c3, 0x0831, 0x119f, 0x90a5, 0x890b, 0xa3f9, 0xba57, 0xf61d, 0xefb3, 0xc541, 0xdcef,
            0xdafa, 0xc354, 0xe9a6, 0xf008, 0xbc42, 0xa5ec, 0x8f1e, 0x96b0, 0x178a, 0x0e24, 0x24d6,
            0x3d78, 0x7132, 0x689c, 0x426e, 0x5bc0, 0x6966, 0x70c8, 0x5a3a, 0x4394, 0x0fde, 0x1670,
            0x3c82, 0x252c, 0xa416, 0xbdb8, 0x974a, 0x8ee4, 0xc2ae, 0xdb00, 0xf1f2, 0xe85c, 0xee49,
            0xf7e7, 0xdd15, 0xc4bb, 0x88f1, 0x915f, 0xbbad, 0xa203, 0x2339, 0x3a97, 0x1065, 0x09cb,
            0x4581, 0x5c2f, 0x76dd, 0x6f73, 0x7af7, 0x6359, 0x49ab, 0x5005, 0x1c4f, 0x05e1, 0x2f13,
            0x36bd, 0xb787, 0xae29, 0x84db, 0x9d75, 0xd13f, 0xc891, 0xe263, 0xfbcd, 0xfdd8, 0xe476,
            0xce84, 0xd72a, 0x9b60, 0x82ce, 0xa83c, 0xb192, 0x30a8, 0x2906, 0x03f4, 0x1a5a, 0x5610,
            0x4fbe, 0x654c, 0x7ce2,
        ],
        [
            0x0000, 0x9c88, 0x24df, 0xb857, 0x49be, 0xd536, 0x6d61, 0xf1e9, 0x937c, 0x0ff4, 0xb7a3,
            0x2b2b, 0xdac2, 0x464a, 0xfe1d, 0x6295, 0x3b37, 0xa7bf, 0x1fe8, 0x8360, 0x7289, 0xee01,
            0x5656, 0xcade, 0xa84b, 0x34c3, 0x8c94, 0x101c, 0xe1f5, 0x7d7d, 0xc52a, 0x59a2, 0x766e,
            0xeae6, 0x52b1, 0xce39, 0x3fd0, 0xa358, 0x1b0f, 0x8787, 0xe512, 0x799a, 0xc1cd, 0x5d45,
            0xacac, 0x3024, 0x8873, 0x14fb, 0x4d59, 0xd1d1, 0x6986, 0xf50e, 0x04e7, 0x986f, 0x2038,
            0xbcb0, 0xde25, 0x42ad, 0xfafa, 0x6672, 0x979b, 0x0b13, 0xb344, 0x2fcc, 0xecdc, 0x7054,
            0xc803, 0x548b, 0xa562, 0x39ea, 0x81bd, 0x1d35, 0x7fa0, 0xe328, 0x5b7f, 0xc7f7, 0x361e,
            0xaa96, 0x12c1, 0x8e49, 0xd7eb, 0x4b63, 0xf334, 0x6fbc, 0x9e55, 0x02dd, 0xba8a, 0x2602,
            0x4497, 0xd81f, 0x6048, 0xfcc0, 0x0d29, 0x91a1, 0x29f6, 0xb57e, 0x9ab2, 0x063a, 0xbe6d,
            0x22e5, 0xd30c, 0x4f84, 0xf7d3, 0x6b5b, 0x09ce, 0x9546, 0x2d11, 0xb199, 0x4070, 0xdcf8,
            0x64af, 0xf827, 0xa185, 0x3d0d, 0x855a, 0x19d2, 0xe83b, 0x74b3, 0xcce4, 0x506c, 0x32f9,
            0xae71, 0x1626, 0x8aae, 0x7b47, 0xe7cf, 0x5f98, 0xc310, 0xc477, 0x58ff, 0xe0a8, 0x7c20,
            0x8dc9, 0x1141, 0xa916, 0x359e, 0x570b, 0xcb83, 0x73d4, 0xef5c, 0x1eb5, 0x823d, 0x3a6a,
            0xa6e2, 0xff40, 0x63c8, 0xdb9f, 0x4717, 0xb6fe, 0x2a76, 0x9221, 0x0ea9, 0x6c3c, 0xf0b4,
            0x48e3, 0xd46b, 0x2582, 0xb90a, 0x015d, 0x9dd5, 0xb219, 0x2e91, 0x96c6, 0x0a4e, 0xfba7,
            0x672f, 0xdf78, 0x43f0, 0x2165, 0xbded, 0x05ba, 0x9932, 0x68db, 0xf453, 0x4c04, 0xd08c,
            0x892e, 0x15a6, 0xadf1, 0x3179, 0xc090, 0x5c18, 0xe44f, 0x78c7, 0x1a52, 0x86da, 0x3e8d,
            0xa205, 0x53ec, 0xcf64, 0x7733, 0xebbb, 0x28ab, 0xb423, 0x0c74, 0x90fc, 0x6115, 0xfd9d,
            0x45ca, 0xd942, 0xbbd7, 0x275f, 0x9f08, 0x0380, 0xf269, 0x6ee1, 0xd6b6, 0x4a3e, 0x139c,
            0x8f14, 0x3743, 0xabcb, 0x5a22, 0xc6aa, 0x7efd, 0xe275, 0x80e0, 0x1c68, 0xa43f, 0x38b7,
            0xc95e, 0x55d6, 0xed81, 0x7109, 0x5ec5, 0xc24d, 0x7a1a, 0xe692, 0x177b, 0x8bf3, 0x33a4,
            0xaf2c, 0xcdb9, 0x5131, 0xe966, 0x75ee, 0x8407, 0x188f, 0xa0d8, 0x3c50, 0x65f2, 0xf97a,
            0x412d, 0xdda5, 0x2c4c, 0xb0c4, 0x0893, 0x941b, 0xf68e, 0x6a06, 0xd251, 0x4ed9, 0xbf30,
            0x23b8, 0x9bef, 0x0767,
        ],
        [
            0x0000, 0x9521, 0x378d, 0xa2ac, 0x6f1a, 0xfa3b, 0x5897, 0xcdb6, 0xde34, 0x4b15, 0xe9b9,
            0x7c98, 0xb12e, 0x240f, 0x86a3, 0x1382, 0xa1a7, 0x3486, 0x962a, 0x030b, 0xcebd, 0x5b9c,
            0xf930, 0x6c11, 0x7f93, 0xeab2, 0x481e, 0xdd3f, 0x1089, 0x85a8, 0x2704, 0xb225, 0x5e81,
            0xcba0, 0x690c, 0xfc2d, 0x319b, 0xa4ba, 0x0616, 0x9337, 0x80b5, 0x1594, 0xb738, 0x2219,
            0xefaf, 0x7a8e, 0xd822, 0x4d03, 0xff26, 0x6a07, 0xc8ab, 0x5d8a, 0x903c, 0x051d, 0xa7b1,
            0x3290, 0x2112, 0xb433, 0x169f, 0x83be, 0x4e08, 0xdb29, 0x7985, 0xeca4, 0xbd02, 0x2823,
            0x8a8f, 0x1fae, 0xd218, 0x4739, 0xe595, 0x70b4, 0x6336, 0xf617, 0x54bb, 0xc19a, 0x0c2c,
            0x990d, 0x3ba1, 0xae80, 0x1ca5, 0x8984, 0x2b28, 0xbe09, 0x73bf, 0xe69e, 0x4432, 0xd113,
            0xc291, 0x57b0, 0xf51c, 0x603d, 0xad8b, 0x38aa, 0x9a06, 0x0f27, 0xe383, 0x76a2, 0xd40e,
            0x412f, 0x8c99, 0x19b8, 0xbb14, 0x2e35, 0x3db7, 0xa896, 0x0a3a, 0x9f1b, 0x52ad, 0xc78c,
            0x6520, 0xf001, 0x4224, 0xd705, 0x75a9, 0xe088, 0x2d3e, 0xb81f, 0x1ab3, 0x8f92, 0x9c10,
            0x0931, 0xab9d, 0x3ebc, 0xf30a, 0x662b, 0xc487, 0x51a6, 0x67cb, 0xf2ea, 0x5046, 0xc567,
            0x08d1, 0x9df0, 0x3f5c, 0xaa7d, 0xb9ff, 0x2cde, 0x8e72, 0x1b53, 0xd6e5, 0x43c4, 0xe168,
            0x7449, 0xc66c, 0x534d, 0xf1e1, 0x64c0, 0xa976, 0x3c57, 0x9efb, 0x0bda, 0x1858, 0x8d79,
            0x2fd5, 0xbaf4, 0x7742, 0xe263, 0x40cf, 0xd5ee, 0x394a, 0xac6b, 0x0ec7, 0x9be6, 0x5650,
            0xc371, 0x61dd, 0xf4fc, 0xe77e, 0x725f, 0xd0f3, 0x45d2, 0x8864, 0x1d45, 0xbfe9, 0x2ac8,
            0x98ed, 0x0dcc, 0xaf60, 0x3a41, 0xf7f7, 0x62d6, 0xc07a, 0x555b, 0x46d9, 0xd3f8, 0x7154,
            0xe475, 0x29c3, 0xbce2, 0x1e4e, 0x8b6f, 0xdac9, 0x4fe8, 0xed44, 0x7865, 0xb5d3, 0x20f2,
            0x825e, 0x177f, 0x04fd, 0x91dc, 0x3370, 0xa651, 0x6be7, 0xfec6, 0x5c6a, 0xc94b, 0x7b6e,
            0xee4f, 0x4ce3, 0xd9c2, 0x1474, 0x8155, 0x23f9, 0xb6d8, 0xa55a, 0x307b, 0x92d7, 0x07f6,
            0xca40, 0x5f61, 0xfdcd, 0x68ec, 0x8448, 0x1169, 0xb3c5, 0x26e4, 0xeb52, 0x7e73, 0xdcdf,
            0x49fe, 0x5a7c, 0xcf5d, 0x6df1, 0xf8d0, 0x3566, 0xa047, 0x02eb, 0x97ca, 0x25ef, 0xb0ce,
            0x1262, 0x8743, 0x4af5, 0xdfd4, 0x7d78, 0xe859, 0xfbdb, 0x6efa, 0xcc56, 0x5977, 0x94c1,
            0x01e0, 0xa34c, 0x366d,
        ],
        [
            0x0000, 0xcf96, 0x82e3, 0x4d75, 0x1809, 0xd79f, 0x9aea, 0x557c, 0x3012, 0xff84, 0xb2f1,
            0x7d67, 0x281b, 0xe78d, 0xaaf8, 0x656e, 0x6024, 0xafb2, 0xe2c7, 0x2d51, 0x782d, 0xb7bb,
            0xface, 0x3558, 0x5036, 0x9fa0, 0xd2d5, 0x1d43, 0x483f, 0x87a9, 0xcadc, 0x054a, 0xc048,
            0x0fde, 0x42ab, 0x8d3d, 0xd841, 0x17d7, 0x5aa2, 0x9534, 0xf05a, 0x3fcc, 0x72b9, 0xbd2f,
            0xe853, 0x27c5, 0x6ab0, 0xa526, 0xa06c, 0x6ffa, 0x228f, 0xed19, 0xb865, 0x77f3, 0x3a86,
            0xf510, 0x907e, 0x5fe8, 0x129d, 0xdd0b, 0x8877, 0x47e1, 0x0a94, 0xc502, 0x9d5f, 0x52c9,
            0x1fbc, 0xd02a, 0x8556, 0x4ac0, 0x07b5, 0xc823, 0xad4d, 0x62db, 0x2fae, 0xe038, 0xb544,
            0x7ad2, 0x37a7, 0xf831, 0xfd7b, 0x32ed, 0x7f98, 0xb00e, 0xe572, 0x2ae4, 0x6791, 0xa807,
            0xcd69, 0x02ff, 0x4f8a, 0x801c, 0xd560, 0x1af6, 0x5783, 0x9815, 0x5d17, 0x9281, 0xdff4,
            0x1062, 0x451e, 0x8a88, 0xc7fd, 0x086b, 0x6d05, 0xa293, 0xefe6, 0x2070, 0x750c, 0xba9a,
            0xf7ef, 0x3879, 0x3d33, 0xf2a5, 0xbfd0, 0x7046, 0x253a, 0xeaac, 0xa7d9, 0x684f, 0x0d21,
            0xc2b7, 0x8fc2, 0x4054, 0x1528, 0xdabe, 0x97cb, 0x585d, 0x2771, 0xe8e7, 0xa592, 0x6a04,
            0x3f78, 0xf0ee, 0xbd9b, 0x720d, 0x1763, 0xd8f5, 0x9580, 0x5a16, 0x0f6a, 0xc0fc, 0x8d89,
            0x421f, 0x4755, 0x88c3, 0xc5b6, 0x0a20, 0x5f5c, 0x90ca, 0xddbf, 0x1229, 0x7747, 0xb8d1,
            0xf5a4, 0x3a32, 0x6f4e, 0xa0d8, 0xedad, 0x223b, 0xe739, 0x28af, 0x65da, 0xaa4c, 0xff30,
            0x30a6, 0x7dd3, 0xb245, 0xd72b, 0x18bd, 0x55c8, 0x9a5e, 0xcf22, 0x00b4, 0x4dc1, 0x8257,
            0x871d, 0x488b, 0x05fe, 0xca68, 0x9f14, 0x5082, 0x1df7, 0xd261, 0xb70f, 0x7899, 0x35ec,
            0xfa7a, 0xaf06, 0x6090, 0x2de5, 0xe273, 0xba2e, 0x75b8, 0x38cd, 0xf75b, 0xa227, 0x6db1,
            0x20c4, 0xef52, 0x8a3c, 0x45aa, 0x08df, 0xc749, 0x9235, 0x5da3, 0x10d6, 0xdf40, 0xda0a,
            0x159c, 0x58e9, 0x977f, 0xc203, 0x0d95, 0x40e0, 0x8f76, 0xea18, 0x258e, 0x68fb, 0xa76d,
            0xf211, 0x3d87, 0x70f2, 0xbf64, 0x7a66, 0xb5f0, 0xf885, 0x3713, 0x626f, 0xadf9, 0xe08c,
            0x2f1a, 0x4a74, 0x85e2, 0xc897, 0x0701, 0x527d, 0x9deb, 0xd09e, 0x1f08, 0x1a42, 0xd5d4,
            0x98a1, 0x5737, 0x024b, 0xcddd, 0x80a8, 0x4f3e, 0x2a50, 0xe5c6, 0xa8b3, 0x6725, 0x3259,
            0xfdcf, 0xb0ba, 0x7f2c,
        ],
        [
            0x0000, 0x4ee2, 0x9dc4, 0xd326, 0x2647, 0x68a5, 0xbb83, 0xf561, 0x4c8e, 0x026c, 0xd14a,
            0x9fa8, 0x6ac9, 0x242b, 0xf70d, 0xb9ef, 0x991c, 0xd7fe, 0x04d8, 0x4a3a, 0xbf5b, 0xf1b9,
            0x229f, 0x6c7d, 0xd592, 0x9b70, 0x4856, 0x06b4, 0xf3d5, 0xbd37, 0x6e11, 0x20f3, 0x2ff7,
            0x6115, 0xb233, 0xfcd1, 0x09b0, 0x4752, 0x9474, 0xda96, 0x6379, 0x2d9b, 0xfebd, 0xb05f,
            0x453e, 0x0bdc, 0xd8fa, 0x9618, 0xb6eb, 0xf809, 0x2b2f, 0x65cd, 0x90ac, 0xde4e, 0x0d68,
            0x438a, 0xfa65, 0xb487, 0x67a1, 0x2943, 0xdc22, 0x92c0, 0x41e6, 0x0f04, 0x5fee, 0x110c,
            0xc22a, 0x8cc8, 0x79a9, 0x374b, 0xe46d, 0xaa8f, 0x1360, 0x5d82, 0x8ea4, 0xc046, 0x3527,
            0x7bc5, 0xa8e3, 0xe601, 0xc6f2, 0x8810, 0x5b36, 0x15d4, 0xe0b5, 0xae57, 0x7d71, 0x3393,
            0x8a7c, 0xc49e, 0x17b8, 0x595a, 0xac3b, 0xe2d9, 0x31ff, 0x7f1d, 0x7019, 0x3efb, 0xeddd,
            0xa33f, 0x565e, 0x18bc, 0xcb9a, 0x8578, 0x3c97, 0x7275, 0xa153, 0xefb1, 0x1ad0, 0x5432,
            0x8714, 0xc9f6, 0xe905, 0xa7e7, 0x74c1, 0x3a23, 0xcf42, 0x81a0, 0x5286, 0x1c64, 0xa58b,
            0xeb69, 0x384f, 0x76ad, 0x83cc, 0xcd2e, 0x1e08, 0x50ea, 0xbfdc, 0xf13e, 0x2218, 0x6cfa,
            0x999b, 0xd779, 0x045f, 0x4abd, 0xf352, 0xbdb0, 0x6e96, 0x2074, 0xd515, 0x9bf7, 0x48d1,
            0x0633, 0x26c0, 0x6822, 0xbb04, 0xf5e6, 0x0087, 0x4e65, 0x9d43, 0xd3a1, 0x6a4e, 0x24ac,
            0xf78a, 0xb968, 0x4c09, 0x02eb, 0xd1cd, 0x9f2f, 0x902b, 0xdec9, 0x0def, 0x430d, 0xb66c,
            0xf88e, 0x2ba8, 0x654a, 0xdca5, 0x9247, 0x4161, 0x0f83, 0xfae2, 0xb400, 0x6726, 0x29c4,
            0x0937, 0x47d5, 0x94f3, 0xda11, 0x2f70, 0x6192, 0xb2b4, 0xfc56, 0x45b9, 0x0b5b, 0xd87d,
            0x969f, 0x63fe, 0x2d1c, 0xfe3a, 0xb0d8, 0xe032, 0xaed0, 0x7df6, 0x3314, 0xc675, 0x8897,
            0x5bb1, 0x1553, 0xacbc, 0xe25e, 0x3178, 0x7f9a, 0x8afb, 0xc419, 0x173f, 0x59dd, 0x792e,
            0x37cc, 0xe4ea, 0xaa08, 0x5f69, 0x118b, 0xc2ad, 0x8c4f, 0x35a0, 0x7b42, 0xa864, 0xe686,
            0x13e7, 0x5d05, 0x8e23, 0xc0c1, 0xcfc5, 0x8127, 0x5201, 0x1ce3, 0xe982, 0xa760, 0x7446,
            0x3aa4, 0x834b, 0xcda9, 0x1e8f, 0x506d, 0xa50c, 0xebee, 0x38c8, 0x762a, 0x56d9, 0x183b,
            0xcb1d, 0x85ff, 0x709e, 0x3e7c, 0xed5a, 0xa3b8, 0x1a57, 0x54b5, 0x8793, 0xc971, 0x3c10,
            0x72f2, 0xa1d4, 0xef36,
        ],
        [
            0x0000, 0x6277, 0xc4ee, 0xa699, 0x9413, 0xf664, 0x50fd, 0x328a, 0x35e9, 0x579e, 0xf107,
            0x9370, 0xa1fa, 0xc38d, 0x6514, 0x0763, 0x6bd2, 0x09a5, 0xaf3c, 0xcd4b, 0xffc1, 0x9db6,
            0x3b2f, 0x5958, 0x5e3b, 0x3c4c, 0x9ad5, 0xf8a2, 0xca28, 0xa85f, 0x0ec6, 0x6cb1, 0xd7a4,
            0xb5d3, 0x134a, 0x713d, 0x43b7, 0x21c0, 0x8759, 0xe52e, 0xe24d, 0x803a, 0x26a3, 0x44d4,
            0x765e, 0x1429, 0xb2b0, 0xd0c7, 0xbc76, 0xde01, 0x7898, 0x1aef, 0x2865, 0x4a12, 0xec8b,
            0x8efc, 0x899f, 0xebe8, 0x4d71, 0x2f06, 0x1d8c, 0x7ffb, 0xd962, 0xbb15, 0xb287, 0xd0f0,
            0x7669, 0x141e, 0x2694, 0x44e3, 0xe27a, 0x800d, 0x876e, 0xe519, 0x4380, 0x21f7, 0x137d,
            0x710a, 0xd793, 0xb5e4, 0xd955, 0xbb22, 0x1dbb, 0x7fcc, 0x4d46, 0x2f31, 0x89a8, 0xebdf,
            0xecbc, 0x8ecb, 0x2852, 0x4a25, 0x78af, 0x1ad8, 0xbc41, 0xde36, 0x6523, 0x0754, 0xa1cd,
            0xc3ba, 0xf130, 0x9347, 0x35de, 0x57a9, 0x50ca, 0x32bd, 0x9424, 0xf653, 0xc4d9, 0xa6ae,
            0x0037, 0x6240, 0x0ef1, 0x6c86, 0xca1f, 0xa868, 0x9ae2, 0xf895, 0x5e0c, 0x3c7b, 0x3b18,
            0x596f, 0xfff6, 0x9d81, 0xaf0b, 0xcd7c, 0x6be5, 0x0992, 0x78c1, 0x1ab6, 0xbc2f, 0xde58,
            0xecd2, 0x8ea5, 0x283c, 0x4a4b, 0x4d28, 0x2f5f, 0x89c6, 0xebb1, 0xd93b, 0xbb4c, 0x1dd5,
            0x7fa2, 0x1313, 0x7164, 0xd7fd, 0xb58a, 0x8700, 0xe577, 0x43ee, 0x2199, 0x26fa, 0x448d,
            0xe214, 0x8063, 0xb2e9, 0xd09e, 0x7607, 0x1470, 0xaf65, 0xcd12, 0x6b8b, 0x09fc, 0x3b76,
            0x5901, 0xff98, 0x9def, 0x9a8c, 0xf8fb, 0x5e62, 0x3c15, 0x0e9f, 0x6ce8, 0xca71, 0xa806,
            0xc4b7, 0xa6c0, 0x0059, 0x622e, 0x50a4, 0x32d3, 0x944a, 0xf63d, 0xf15e, 0x9329, 0x35b0,
            0x57c7, 0x654d, 0x073a, 0xa1a3, 0xc3d4, 0xca46, 0xa831, 0x0ea8, 0x6cdf, 0x5e55, 0x3c22,
            0x9abb, 0xf8cc, 0xffaf, 0x9dd8, 0x3b41, 0x5936, 0x6bbc, 0x09cb, 0xaf52, 0xcd25, 0xa194,
            0xc3e3, 0x657a, 0x070d, 0x3587, 0x57f0, 0xf169, 0x931e, 0x947d, 0xf60a, 0x5093, 0x32e4,
            0x006e, 0x6219, 0xc480, 0xa6f7, 0x1de2, 0x7f95, 0xd90c, 0xbb7b, 0x89f1, 0xeb86, 0x4d1f,
            0x2f68, 0x280b, 0x4a7c, 0xece5, 0x8e92, 0xbc18, 0xde6f, 0x78f6, 0x1a81, 0x7630, 0x1447,
            0xb2de, 0xd0a9, 0xe223, 0x8054, 0x26cd, 0x44ba, 0x43d9, 0x21ae, 0x8737, 0xe540, 0xd7ca,
            0xb5bd, 0x1324, 0x7153,
        ],
        [
            0x0000, 0xf182, 0xfecb, 0x0f49, 0xe059, 0x11db, 0x1e92, 0xef10, 0xdd7d, 0x2cff, 0x23b6,
            0xd234, 0x3d24, 0xcca6, 0xc3ef, 0x326d, 0xa735, 0x56b7, 0x59fe, 0xa87c, 0x476c, 0xb6ee,
            0xb9a7, 0x4825, 0x7a48, 0x8bca, 0x8483, 0x7501, 0x9a11, 0x6b93, 0x64da, 0x9558, 0x53a5,
            0xa227, 0xad6e, 0x5cec, 0xb3fc, 0x427e, 0x4d37, 0xbcb5, 0x8ed8, 0x7f5a, 0x7013, 0x8191,
            0x6e81, 0x9f03, 0x904a, 0x61c8, 0xf490, 0x0512, 0x0a5b, 0xfbd9, 0x14c9, 0xe54b, 0xea02,
            0x1b80, 0x29ed, 0xd86f, 0xd726, 0x26a4, 0xc9b4, 0x3836, 0x377f, 0xc6fd, 0xa74a, 0x56c8,
            0x5981, 0xa803, 0x4713, 0xb691, 0xb9d8, 0x485a, 0x7a37, 0x8bb5, 0x84fc, 0x757e, 0x9a6e,
            0x6bec, 0x64a5, 0x9527, 0x007f, 0xf1fd, 0xfeb4, 0x0f36, 0xe026, 0x11a4, 0x1eed, 0xef6f,
            0xdd02, 0x2c80, 0x23c9, 0xd24b, 0x3d5b, 0xccd9, 0xc390, 0x3212, 0xf4ef, 0x056d, 0x0a24,
            0xfba6, 0x14b6, 0xe534, 0xea7d, 0x1bff, 0x2992, 0xd810, 0xd759, 0x26db, 0xc9cb, 0x3849,
            0x3700, 0xc682, 0x53da, 0xa258, 0xad11, 0x5c93, 0xb383, 0x4201, 0x4d48, 0xbcca, 0x8ea7,
            0x7f25, 0x706c, 0x81ee, 0x6efe, 0x9f7c, 0x9035, 0x61b7, 0x535b, 0xa2d9, 0xad90, 0x5c12,
            0xb302, 0x4280, 0x4dc9, 0xbc4b, 0x8e26, 0x7fa4, 0x70ed, 0x816f, 0x6e7f, 0x9ffd, 0x90b4,
            0x6136, 0xf46e, 0x05ec, 0x0aa5, 0xfb27, 0x1437, 0xe5b5, 0xeafc, 0x1b7e, 0x2913, 0xd891,
            0xd7d8, 0x265a, 0xc94a, 0x38c8, 0x3781, 0xc603, 0x00fe, 0xf17c, 0xfe35, 0x0fb7, 0xe0a7,
            0x1125, 0x1e6c, 0xefee, 0xdd83, 0x2c01, 0x2348, 0xd2ca, 0x3dda, 0xcc58, 0xc311, 0x3293,
            0xa7cb, 0x5649, 0x5900, 0xa882, 0x4792, 0xb610, 0xb959, 0x48db, 0x7ab6, 0x8b34, 0x847d,
            0x75ff, 0x9aef, 0x6b6d, 0x6424, 0x95a6, 0xf411, 0x0593, 0x0ada, 0xfb58, 0x1448, 0xe5ca,
            0xea83, 0x1b01, 0x296c, 0xd8ee, 0xd7a7, 0x2625, 0xc935, 0x38b7, 0x37fe, 0xc67c, 0x5324,
            0xa2a6, 0xadef, 0x5c6d, 0xb37d, 0x42ff, 0x4db6, 0xbc34, 0x8e59, 0x7fdb, 0x7092, 0x8110,
            0x6e00, 0x9f82, 0x90cb, 0x6149, 0xa7b4, 0x5636, 0x597f, 0xa8fd, 0x47ed, 0xb66f, 0xb926,
            0x48a4, 0x7ac9, 0x8b4b, 0x8402, 0x7580, 0x9a90, 0x6b12, 0x645b, 0x95d9, 0x0081, 0xf103,
            0xfe4a, 0x0fc8, 0xe0d8, 0x115a, 0x1e13, 0xef91, 0xddfc, 0x2c7e, 0x2337, 0xd2b5, 0x3da5,
            0xcc27, 0xc36e, 0x32ec,
        ],
        [
            0x0000, 0xa6b6, 0x50a3, 0xf615, 0xa146, 0x07f0, 0xf1e5, 0x5753, 0x5f43, 0xf9f5, 0x0fe0,
            0xa956, 0xfe05, 0x58b3, 0xaea6, 0x0810, 0xbe86, 0x1830, 0xee25, 0x4893, 0x1fc0, 0xb976,
            0x4f63, 0xe9d5, 0xe1c5, 0x4773, 0xb166, 0x17d0, 0x4083, 0xe635, 0x1020, 0xb696, 0x60c3,
            0xc675, 0x3060, 0x96d6, 0xc185, 0x6733, 0x9126, 0x3790, 0x3f80, 0x9936, 0x6f23, 0xc995,
            0x9ec6, 0x3870, 0xce65, 0x68d3, 0xde45, 0x78f3, 0x8ee6, 0x2850, 0x7f03, 0xd9b5, 0x2fa0,
            0x8916, 0x8106, 0x27b0, 0xd1a5, 0x7713, 0x2040, 0x86f6, 0x70e3, 0xd655, 0xc186, 0x6730,
            0x9125, 0x3793, 0x60c0, 0xc676, 0x3063, 0x96d5, 0x9ec5, 0x3873, 0xce66, 0x68d0, 0x3f83,
            0x9935, 0x6f20, 0xc996, 0x7f00, 0xd9b6, 0x2fa3, 0x8915, 0xde46, 0x78f0, 0x8ee5, 0x2853,
            0x2043, 0x86f5, 0x70e0, 0xd656, 0x8105, 0x27b3, 0xd1a6, 0x7710, 0xa145, 0x07f3, 0xf1e6,
            0x5750, 0x0003, 0xa6b5, 0x50a0, 0xf616, 0xfe06, 0x58b0, 0xaea5, 0x0813, 0x5f40, 0xf9f6,
            0x0fe3, 0xa955, 0x1fc3, 0xb975, 0x4f60, 0xe9d6, 0xbe85, 0x1833, 0xee26, 0x4890, 0x4080,
            0xe636, 0x1023, 0xb695, 0xe1c6, 0x4770, 0xb165, 0x17d3, 0x9ec3, 0x3875, 0xce60, 0x68d6,
            0x3f85, 0x9933, 0x6f26, 0xc990, 0xc180, 0x6736, 0x9123, 0x3795, 0x60c6, 0xc670, 0x3065,
            0x96d3, 0x2045, 0x86f3, 0x70e6, 0xd650, 0x8103, 0x27b5, 0xd1a0, 0x7716, 0x7f06, 0xd9b0,
            0x2fa5, 0x8913, 0xde40, 0x78f6, 0x8ee3, 0x2855, 0xfe00, 0x58b6, 0xaea3, 0x0815, 0x5f46,
            0xf9f0, 0x0fe5, 0xa953, 0xa143, 0x07f5, 0xf1e0, 0x5756, 0x0005, 0xa6b3, 0x50a6, 0xf610,
            0x4086, 0xe630, 0x1025, 0xb693, 0xe1c0, 0x4776, 0xb163, 0x17d5, 0x1fc5, 0xb973, 0x4f66,
            0xe9d0, 0xbe83, 0x1835, 0xee20, 0x4896, 0x5f45, 0xf9f3, 0x0fe6, 0xa950, 0xfe03, 0x58b5,
            0xaea0, 0x0816, 0x0006, 0xa6b0, 0x50a5, 0xf613, 0xa140, 0x07f6, 0xf1e3, 0x5755, 0xe1c3,
            0x4775, 0xb160, 0x17d6, 0x4085, 0xe633, 0x1026, 0xb690, 0xbe80, 0x1836, 0xee23, 0x4895,
            0x1fc6, 0xb970, 0x4f65, 0xe9d3, 0x3f86, 0x9930, 0x6f25, 0xc993, 0x9ec0, 0x3876, 0xce63,
            0x68d5, 0x60c5, 0xc673, 0x3066, 0x96d0, 0xc183, 0x6735, 0x9120, 0x3796, 0x8100, 0x27b6,
            0xd1a3, 0x7715, 0x2046, 0x86f0, 0x70e5, 0xd653, 0xde43, 0x78f5, 0x8ee0, 0x2856, 0x7f05,
            0xd9b3, 0x2fa6, 0x8910,
        ],
        [
            0x0000, 0x2049, 0x4092, 0x60db, 0x8124, 0xa16d, 0xc1b6, 0xe1ff, 0x1f87, 0x3fce, 0x5f15,
            0x7f5c, 0x9ea3, 0xbeea, 0xde31, 0xfe78, 0x3f0e, 0x1f47, 0x7f9c, 0x5fd5, 0xbe2a, 0x9e63,
            0xfeb8, 0xdef1, 0x2089, 0x00c0, 0x601b, 0x4052, 0xa1ad, 0x81e4, 0xe13f, 0xc176, 0x7e1c,
            0x5e55, 0x3e8e, 0x1ec7, 0xff38, 0xdf71, 0xbfaa, 0x9fe3, 0x619b, 0x41d2, 0x2109, 0x0140,
            0xe0bf, 0xc0f6, 0xa02d, 0x8064, 0x4112, 0x615b, 0x0180, 0x21c9, 0xc036, 0xe07f, 0x80a4,
            0xa0ed, 0x5e95, 0x7edc, 0x1e07, 0x3e4e, 0xdfb1, 0xfff8, 0x9f23, 0xbf6a, 0xfc38, 0xdc71,
            0xbcaa, 0x9ce3, 0x7d1c, 0x5d55, 0x3d8e, 0x1dc7, 0xe3bf, 0xc3f6, 0xa32d, 0x8364, 0x629b,
            0x42d2, 0x2209, 0x0240, 0xc336, 0xe37f, 0x83a4, 0xa3ed, 0x4212, 0x625b, 0x0280, 0x22c9,
            0xdcb1, 0xfcf8, 0x9c23, 0xbc6a, 0x5d95, 0x7ddc, 0x1d07, 0x3d4e, 0x8224, 0xa26d, 0xc2b6,
            0xe2ff, 0x0300, 0x2349, 0x4392, 0x63db, 0x9da3, 0xbdea, 0xdd31, 0xfd78, 0x1c87, 0x3cce,
            0x5c15, 0x7c5c, 0xbd2a, 0x9d63, 0xfdb8, 0xddf1, 0x3c0e, 0x1c47, 0x7c9c, 0x5cd5, 0xa2ad,
            0x82e4, 0xe23f, 0xc276, 0x2389, 0x03c0, 0x631b, 0x4352, 0xe5bf, 0xc5f6, 0xa52d, 0x8564,
            0x649b, 0x44d2, 0x2409, 0x0440, 0xfa38, 0xda71, 0xbaaa, 0x9ae3, 0x7b1c, 0x5b55, 0x3b8e,
            0x1bc7, 0xdab1, 0xfaf8, 0x9a23, 0xba6a, 0x5b95, 0x7bdc, 0x1b07, 0x3b4e, 0xc536, 0xe57f,
            0x85a4, 0xa5ed, 0x4412, 0x645b, 0x0480, 0x24c9, 0x9ba3, 0xbbea, 0xdb31, 0xfb78, 0x1a87,
            0x3ace, 0x5a15, 0x7a5c, 0x8424, 0xa46d, 0xc4b6, 0xe4ff, 0x0500, 0x2549, 0x4592, 0x65db,
            0xa4ad, 0x84e4, 0xe43f, 0xc476, 0x2589, 0x05c0, 0x651b, 0x4552, 0xbb2a, 0x9b63, 0xfbb8,
            0xdbf1, 0x3a0e, 0x1a47, 0x7a9c, 0x5ad5, 0x1987, 0x39ce, 0x5915, 0x795c, 0x98a3, 0xb8ea,
            0xd831, 0xf878, 0x0600, 0x2649, 0x4692, 0x66db, 0x8724, 0xa76d, 0xc7b6, 0xe7ff, 0x2689,
            0x06c0, 0x661b, 0x4652, 0xa7ad, 0x87e4, 0xe73f, 0xc776, 0x390e, 0x1947, 0x799c, 0x59d5,
            0xb82a, 0x9863, 0xf8b8, 0xd8f1, 0x679b, 0x47d2, 0x2709, 0x0740, 0xe6bf, 0xc6f6, 0xa62d,
            0x8664, 0x781c, 0x5855, 0x388e, 0x18c7, 0xf938, 0xd971, 0xb9aa, 0x99e3, 0x5895, 0x78dc,
            0x1807, 0x384e, 0xd9b1, 0xf9f8, 0x9923, 0xb96a, 0x4712, 0x675b, 0x0780, 0x27c9, 0xc636,
            0xe67f, 0x86a4, 0xa6ed,
        ],
        [
            0x0000, 0xd6b1, 0xb0ad, 0x661c, 0x7c95, 0xaa24, 0xcc38, 0x1a89, 0xf92a, 0x2f9b, 0x4987,
            0x9f36, 0x85bf, 0x530e, 0x3512, 0xe3a3, 0xef9b, 0x392a, 0x5f36, 0x8987, 0x930e, 0x45bf,
            0x23a3, 0xf512, 0x16b1, 0xc000, 0xa61c, 0x70ad, 0x6a24, 0xbc95, 0xda89, 0x0c38, 0xc2f9,
            0x1448, 0x7254, 0xa4e5, 0xbe6c, 0x68dd, 0x0ec1, 0xd870, 0x3bd3, 0xed62, 0x8b7e, 0x5dcf,
            0x4746, 0x91f7, 0xf7eb, 0x215a, 0x2d62, 0xfbd3, 0x9dcf, 0x4b7e, 0x51f7, 0x8746, 0xe15a,
            0x37eb, 0xd448, 0x02f9, 0x64e5, 0xb254, 0xa8dd, 0x7e6c, 0x1870, 0xcec1, 0x983d, 0x4e8c,
            0x2890, 0xfe21, 0xe4a8, 0x3219, 0x5405, 0x82b4, 0x6117, 0xb7a6, 0xd1ba, 0x070b, 0x1d82,
            0xcb33, 0xad2f, 0x7b9e, 0x77a6, 0xa117, 0xc70b, 0x11ba, 0x0b33, 0xdd82, 0xbb9e, 0x6d2f,
            0x8e8c, 0x583d, 0x3e21, 0xe890, 0xf219, 0x24a8, 0x42b4, 0x9405, 0x5ac4, 0x8c75, 0xea69,
            0x3cd8, 0x2651, 0xf0e0, 0x96fc, 0x404d, 0xa3ee, 0x755f, 0x1343, 0xc5f2, 0xdf7b, 0x09ca,
            0x6fd6, 0xb967, 0xb55f, 0x63ee, 0x05f2, 0xd343, 0xc9ca, 0x1f7b, 0x7967, 0xafd6, 0x4c75,
            0x9ac4, 0xfcd8, 0x2a69, 0x30e0, 0xe651, 0x804d, 0x56fc, 0x2db5, 0xfb04, 0x9d18, 0x4ba9,
            0x5120, 0x8791, 0xe18d, 0x373c, 0xd49f, 0x022e, 0x6432, 0xb283, 0xa80a, 0x7ebb, 0x18a7,
            0xce16, 0xc22e, 0x149f, 0x7283, 0xa432, 0xbebb, 0x680a, 0x0e16, 0xd8a7, 0x3b04, 0xedb5,
            0x8ba9, 0x5d18, 0x4791, 0x9120, 0xf73c, 0x218d, 0xef4c, 0x39fd, 0x5fe1, 0x8950, 0x93d9,
            0x4568, 0x2374, 0xf5c5, 0x1666, 0xc0d7, 0xa6cb, 0x707a, 0x6af3, 0xbc42, 0xda5e, 0x0cef,
            0x00d7, 0xd666, 0xb07a, 0x66cb, 0x7c42, 0xaaf3, 0xccef, 0x1a5e, 0xf9fd, 0x2f4c, 0x4950,
            0x9fe1, 0x8568, 0x53d9, 0x35c5, 0xe374, 0xb588, 0x6339, 0x0525, 0xd394, 0xc91d, 0x1fac,
            0x79b0, 0xaf01, 0x4ca2, 0x9a13, 0xfc0f, 0x2abe, 0x3037, 0xe686, 0x809a, 0x562b, 0x5a13,
            0x8ca2, 0xeabe, 0x3c0f, 0x2686, 0xf037, 0x962b, 0x409a, 0xa339, 0x7588, 0x1394, 0xc525,
            0xdfac, 0x091d, 0x6f01, 0xb9b0, 0x7771, 0xa1c0, 0xc7dc, 0x116d, 0x0be4, 0xdd55, 0xbb49,
            0x6df8, 0x8e5b, 0x58ea, 0x3ef6, 0xe847, 0xf2ce, 0x247f, 0x4263, 0x94d2, 0x98ea, 0x4e5b,
            0x2847, 0xfef6, 0xe47f, 0x32ce, 0x54d2, 0x8263, 0x61c0, 0xb771, 0xd16d, 0x07dc, 0x1d55,
            0xcbe4, 0xadf8, 0x7b49,
        ],
        [
            0x0000, 0x5b6a, 0xb6d4, 0xedbe, 0x7067, 0x2b0d, 0xc6b3, 0x9dd9, 0xe0ce, 0xbba4, 0x561a,
            0x0d70, 0x90a9, 0xcbc3, 0x267d, 0x7d17, 0xdc53, 0x8739, 0x6a87, 0x31ed, 0xac34, 0xf75e,
            0x1ae0, 0x418a, 0x3c9d, 0x67f7, 0x8a49, 0xd123, 0x4cfa, 0x1790, 0xfa2e, 0xa144, 0xa569,
            0xfe03, 0x13bd, 0x48d7, 0xd50e, 0x8e64, 0x63da, 0x38b0, 0x45a7, 0x1ecd, 0xf373, 0xa819,
            0x35c0, 0x6eaa, 0x8314, 0xd87e, 0x793a, 0x2250, 0xcfee, 0x9484, 0x095d, 0x5237, 0xbf89,
            0xe4e3, 0x99f4, 0xc29e, 0x2f20, 0x744a, 0xe993, 0xb2f9, 0x5f47, 0x042d, 0x571d, 0x0c77,
            0xe1c9, 0xbaa3, 0x277a, 0x7c10, 0x91ae, 0xcac4, 0xb7d3, 0xecb9, 0x0107, 0x5a6d, 0xc7b4,
            0x9cde, 0x7160, 0x2a0a, 0x8b4e, 0xd024, 0x3d9a, 0x66f0, 0xfb29, 0xa043, 0x4dfd, 0x1697,
            0x6b80, 0x30ea, 0xdd54, 0x863e, 0x1be7, 0x408d, 0xad33, 0xf659, 0xf274, 0xa91e, 0x44a0,
            0x1fca, 0x8213, 0xd979, 0x34c7, 0x6fad, 0x12ba, 0x49d0, 0xa46e, 0xff04, 0x62dd, 0x39b7,
            0xd409, 0x8f63, 0x2e27, 0x754d, 0x98f3, 0xc399, 0x5e40, 0x052a, 0xe894, 0xb3fe, 0xcee9,
            0x9583, 0x783d, 0x2357, 0xbe8e, 0xe5e4, 0x085a, 0x5330, 0xae3a, 0xf550, 0x18ee, 0x4384,
            0xde5d, 0x8537, 0x6889, 0x33e3, 0x4ef4, 0x159e, 0xf820, 0xa34a, 0x3e93, 0x65f9, 0x8847,
            0xd32d, 0x7269, 0x2903, 0xc4bd, 0x9fd7, 0x020e, 0x5964, 0xb4da, 0xefb0, 0x92a7, 0xc9cd,
            0x2473, 0x7f19, 0xe2c0, 0xb9aa, 0x5414, 0x0f7e, 0x0b53, 0x5039, 0xbd87, 0xe6ed, 0x7b34,
            0x205e, 0xcde0, 0x968a, 0xeb9d, 0xb0f7, 0x5d49, 0x0623, 0x9bfa, 0xc090, 0x2d2e, 0x7644,
            0xd700, 0x8c6a, 0x61d4, 0x3abe, 0xa767, 0xfc0d, 0x11b3, 0x4ad9, 0x37ce, 0x6ca4, 0x811a,
            0xda70, 0x47a9, 0x1cc3, 0xf17d, 0xaa17, 0xf927, 0xa24d, 0x4ff3, 0x1499, 0x8940, 0xd22a,
            0x3f94, 0x64fe, 0x19e9, 0x4283, 0xaf3d, 0xf457, 0x698e, 0x32e4, 0xdf5a, 0x8430, 0x2574,
            0x7e1e, 0x93a0, 0xc8ca, 0x5513, 0x0e79, 0xe3c7, 0xb8ad, 0xc5ba, 0x9ed0, 0x736e, 0x2804,
            0xb5dd, 0xeeb7, 0x0309, 0x5863, 0x5c4e, 0x0724, 0xea9a, 0xb1f0, 0x2c29, 0x7743, 0x9afd,
            0xc197, 0xbc80, 0xe7ea, 0x0a54, 0x513e, 0xcce7, 0x978d, 0x7a33, 0x2159, 0x801d, 0xdb77,
            0x36c9, 0x6da3, 0xf07a, 0xab10, 0x46ae, 0x1dc4, 0x60d3, 0x3bb9, 0xd607, 0x8d6d, 0x10b4,
            0x4bde, 0xa660, 0xfd0a,
        ],
        [
            0x0000, 0x41bb, 0x8376, 0xc2cd, 0x1b23, 0x5a98, 0x9855, 0xd9ee, 0x3646, 0x77fd, 0xb530,
            0xf48b, 0x2d65, 0x6cde, 0xae13, 0xefa8, 0x6c8c, 0x2d37, 0xeffa, 0xae41, 0x77af, 0x3614,
            0xf4d9, 0xb562, 0x5aca, 0x1b71, 0xd9bc, 0x9807, 0x41e9, 0x0052, 0xc29f, 0x8324, 0xd918,
            0x98a3, 0x5a6e, 0x1bd5, 0xc23b, 0x8380, 0x414d, 0x00f6, 0xef5e, 0xaee5, 0x6c28, 0x2d93,
            0xf47d, 0xb5c6, 0x770b, 0x36b0, 0xb594, 0xf42f, 0x36e2, 0x7759, 0xaeb7, 0xef0c, 0x2dc1,
            0x6c7a, 0x83d2, 0xc269, 0x00a4, 0x411f, 0x98f1, 0xd94a, 0x1b87, 0x5a3c, 0xafff, 0xee44,
            0x2c89, 0x6d32, 0xb4dc, 0xf567, 0x37aa, 0x7611, 0x99b9, 0xd802, 0x1acf, 0x5b74, 0x829a,
            0xc321, 0x01ec, 0x4057, 0xc373, 0x82c8, 0x4005, 0x01be, 0xd850, 0x99eb, 0x5b26, 0x1a9d,
            0xf535, 0xb48e, 0x7643, 0x37f8, 0xee16, 0xafad, 0x6d60, 0x2cdb, 0x76e7, 0x375c, 0xf591,
            0xb42a, 0x6dc4, 0x2c7f, 0xeeb2, 0xaf09, 0x40a1, 0x011a, 0xc3d7, 0x826c, 0x5b82, 0x1a39,
            0xd8f4, 0x994f, 0x1a6b, 0x5bd0, 0x991d, 0xd8a6, 0x0148, 0x40f3, 0x823e, 0xc385, 0x2c2d,
            0x6d96, 0xaf5b, 0xeee0, 0x370e, 0x76b5, 0xb478, 0xf5c3, 0x4231, 0x038a, 0xc147, 0x80fc,
            0x5912, 0x18a9, 0xda64, 0x9bdf, 0x7477, 0x35cc, 0xf701, 0xb6ba, 0x6f54, 0x2eef, 0xec22,
            0xad99, 0x2ebd, 0x6f06, 0xadcb, 0xec70, 0x359e, 0x7425, 0xb6e8, 0xf753, 0x18fb, 0x5940,
            0x9b8d, 0xda36, 0x03d8, 0x4263, 0x80ae, 0xc115, 0x9b29, 0xda92, 0x185f, 0x59e4, 0x800a,
            0xc1b1, 0x037c, 0x42c7, 0xad6f, 0xecd4, 0x2e19, 0x6fa2, 0xb64c, 0xf7f7, 0x353a, 0x7481,
            0xf7a5, 0xb61e, 0x74d3, 0x3568, 0xec86, 0xad3d, 0x6ff0, 0x2e4b, 0xc1e3, 0x8058, 0x4295,
            0x032e, 0xdac0, 0x9b7b, 0x59b6, 0x180d, 0xedce, 0xac75, 0x6eb8, 0x2f03, 0xf6ed, 0xb756,
            0x759b, 0x3420, 0xdb88, 0x9a33, 0x58fe, 0x1945, 0xc0ab, 0x8110, 0x43dd, 0x0266, 0x8142,
            0xc0f9, 0x0234, 0x438f, 0x9a61, 0xdbda, 0x1917, 0x58ac, 0xb704, 0xf6bf, 0x3472, 0x75c9,
            0xac27, 0xed9c, 0x2f51, 0x6eea, 0x34d6, 0x756d, 0xb7a0, 0xf61b, 0x2ff5, 0x6e4e, 0xac83,
            0xed38, 0x0290, 0x432b, 0x81e6, 0xc05d, 0x19b3, 0x5808, 0x9ac5, 0xdb7e, 0x585a, 0x19e1,
            0xdb2c, 0x9a97, 0x4379, 0x02c2, 0xc00f, 0x81b4, 0x6e1c, 0x2fa7, 0xed6a, 0xacd1, 0x753f,
            0x3484, 0xf649, 0xb7f2,
        ],
    ];

    pub static CRC16_RIELLO_TABLE: [[u16; 256]; 16] = [
        [
            0x0000, 0x1189, 0x2312, 0x329b, 0x4624, 0x57ad, 0x6536, 0x74bf, 0x8c48, 0x9dc1, 0xaf5a,
            0xbed3, 0xca6c, 0xdbe5, 0xe97e, 0xf8f7, 0x1081, 0x0108, 0x3393, 0x221a, 0x56a5, 0x472c,
            0x75b7, 0x643e, 0x9cc9, 0x8d40, 0xbfdb, 0xae52, 0xdaed, 0xcb64, 0xf9ff, 0xe876, 0x2102,
            0x308b, 0x0210, 0x1399, 0x6726, 0x76af, 0x4434, 0x55bd, 0xad4a, 0xbcc3, 0x8e58, 0x9fd1,
            0xeb6e, 0xfae7, 0xc87c, 0xd9f5, 0x3183, 0x200a, 0x1291, 0x0318, 0x77a7, 0x662e, 0x54b5,
            0x453c, 0xbdcb, 0xac42, 0x9ed9, 0x8f50, 0xfbef, 0xea66, 0xd8fd, 0xc974, 0x4204, 0x538d,
            0x6116, 0x709f, 0x0420, 0x15a9, 0x2732, 0x36bb, 0xce4c, 0xdfc5, 0xed5e, 0xfcd7, 0x8868,
            0x99e1, 0xab7a, 0xbaf3, 0x5285, 0x430c, 0x7197, 0x601e, 0x14a1, 0x0528, 0x37b3, 0x263a,
            0xdecd, 0xcf44, 0xfddf, 0xec56, 0x98e9, 0x8960, 0xbbfb, 0xaa72, 0x6306, 0x728f, 0x4014,
            0x519d, 0x2522, 0x34ab, 0x0630, 0x17b9, 0xef4e, 0xfec7, 0xcc5c, 0xddd5, 0xa96a, 0xb8e3,
            0x8a78, 0x9bf1, 0x7387, 0x620e, 0x5095, 0x411c, 0x35a3, 0x242a, 0x16b1, 0x0738, 0xffcf,
            0xee46, 0xdcdd, 0xcd54, 0xb9eb, 0xa862, 0x9af9, 0x8b70, 0x8408, 0x9581, 0xa71a, 0xb693,
            0xc22c, 0xd3a5, 0xe13e, 0xf0b7, 0x0840, 0x19c9, 0x2b52, 0x3adb, 0x4e64, 0x5fed, 0x6d76,
            0x7cff, 0x9489, 0x8500, 0xb79b, 0xa612, 0xd2ad, 0xc324, 0xf1bf, 0xe036, 0x18c1, 0x0948,
            0x3bd3, 0x2a5a, 0x5ee5, 0x4f6c, 0x7df7, 0x6c7e, 0xa50a, 0xb483, 0x8618, 0x9791, 0xe32e,
            0xf2a7, 0xc03c, 0xd1b5, 0x2942, 0x38cb, 0x0a50, 0x1bd9, 0x6f66, 0x7eef, 0x4c74, 0x5dfd,
            0xb58b, 0xa402, 0x9699, 0x8710, 0xf3af, 0xe226, 0xd0bd, 0xc134, 0x39c3, 0x284a, 0x1ad1,
            0x0b58, 0x7fe7, 0x6e6e, 0x5cf5, 0x4d7c, 0xc60c, 0xd785, 0xe51e, 0xf497, 0x8028, 0x91a1,
            0xa33a, 0xb2b3, 0x4a44, 0x5bcd, 0x6956, 0x78df, 0x0c60, 0x1de9, 0x2f72, 0x3efb, 0xd68d,
            0xc704, 0xf59f, 0xe416, 0x90a9, 0x8120, 0xb3bb, 0xa232, 0x5ac5, 0x4b4c, 0x79d7, 0x685e,
            0x1ce1, 0x0d68, 0x3ff3, 0x2e7a, 0xe70e, 0xf687, 0xc41c, 0xd595, 0xa12a, 0xb0a3, 0x8238,
            0x93b1, 0x6b46, 0x7acf, 0x4854, 0x59dd, 0x2d62, 0x3ceb, 0x0e70, 0x1ff9, 0xf78f, 0xe606,
            0xd49d, 0xc514, 0xb1ab, 0xa022, 0x92b9, 0x8330, 0x7bc7, 0x6a4e, 0x58d5, 0x495c, 0x3de3,
            0x2c6a, 0x1ef1, 0x0f78,
        ],
        [
            0x0000, 0x19d8, 0x33b0, 0x2a68, 0x6760, 0x7eb8, 0x54d0, 0x4d08, 0xcec0, 0xd718, 0xfd70,
            0xe4a8, 0xa9a0, 0xb078, 0x9a10, 0x83c8, 0x9591, 0x8c49, 0xa621, 0xbff9, 0xf2f1, 0xeb29,
            0xc141, 0xd899, 0x5b51, 0x4289, 0x68e1, 0x7139, 0x3c31, 0x25e9, 0x0f81, 0x1659, 0x2333,
            0x3aeb, 0x1083, 0x095b, 0x4453, 0x5d8b, 0x77e3, 0x6e3b, 0xedf3, 0xf42b, 0xde43, 0xc79b,
            0x8a93, 0x934b, 0xb923, 0xa0fb, 0xb6a2, 0xaf7a, 0x8512, 0x9cca, 0xd1c2, 0xc81a, 0xe272,
            0xfbaa, 0x7862, 0x61ba, 0x4bd2, 0x520a, 0x1f02, 0x06da, 0x2cb2, 0x356a, 0x4666, 0x5fbe,
            0x75d6, 0x6c0e, 0x2106, 0x38de, 0x12b6, 0x0b6e, 0x88a6, 0x917e, 0xbb16, 0xa2ce, 0xefc6,
            0xf61e, 0xdc76, 0xc5ae, 0xd3f7, 0xca2f, 0xe047, 0xf99f, 0xb497, 0xad4f, 0x8727, 0x9eff,
            0x1d37, 0x04ef, 0x2e87, 0x375f, 0x7a57, 0x638f, 0x49e7, 0x503f, 0x6555, 0x7c8d, 0x56e5,
            0x4f3d, 0x0235, 0x1bed, 0x3185, 0x285d, 0xab95, 0xb24d, 0x9825, 0x81fd, 0xccf5, 0xd52d,
            0xff45, 0xe69d, 0xf0c4, 0xe91c, 0xc374, 0xdaac, 0x97a4, 0x8e7c, 0xa414, 0xbdcc, 0x3e04,
            0x27dc, 0x0db4, 0x146c, 0x5964, 0x40bc, 0x6ad4, 0x730c, 0x8ccc, 0x9514, 0xbf7c, 0xa6a4,
            0xebac, 0xf274, 0xd81c, 0xc1c4, 0x420c, 0x5bd4, 0x71bc, 0x6864, 0x256c, 0x3cb4, 0x16dc,
            0x0f04, 0x195d, 0x0085, 0x2aed, 0x3335, 0x7e3d, 0x67e5, 0x4d8d, 0x5455, 0xd79d, 0xce45,
            0xe42d, 0xfdf5, 0xb0fd, 0xa925, 0x834d, 0x9a95, 0xafff, 0xb627, 0x9c4f, 0x8597, 0xc89f,
            0xd147, 0xfb2f, 0xe2f7, 0x613f, 0x78e7, 0x528f, 0x4b57, 0x065f, 0x1f87, 0x35ef, 0x2c37,
            0x3a6e, 0x23b6, 0x09de, 0x1006, 0x5d0e, 0x44d6, 0x6ebe, 0x7766, 0xf4ae, 0xed76, 0xc71e,
            0xdec6, 0x93ce, 0x8a16, 0xa07e, 0xb9a6, 0xcaaa, 0xd372, 0xf91a, 0xe0c2, 0xadca, 0xb412,
            0x9e7a, 0x87a2, 0x046a, 0x1db2, 0x37da, 0x2e02, 0x630a, 0x7ad2, 0x50ba, 0x4962, 0x5f3b,
            0x46e3, 0x6c8b, 0x7553, 0x385b, 0x2183, 0x0beb, 0x1233, 0x91fb, 0x8823, 0xa24b, 0xbb93,
            0xf69b, 0xef43, 0xc52b, 0xdcf3, 0xe999, 0xf041, 0xda29, 0xc3f1, 0x8ef9, 0x9721, 0xbd49,
            0xa491, 0x2759, 0x3e81, 0x14e9, 0x0d31, 0x4039, 0x59e1, 0x7389, 0x6a51, 0x7c08, 0x65d0,
            0x4fb8, 0x5660, 0x1b68, 0x02b0, 0x28d8, 0x3100, 0xb2c8, 0xab10, 0x8178, 0x98a0, 0xd5a8,
            0xcc70, 0xe618, 0xffc0,
        ],
        [
            0x0000, 0x5adc, 0xb5b8, 0xef64, 0x6361, 0x39bd, 0xd6d9, 0x8c05, 0xc6c2, 0x9c1e, 0x737a,
            0x29a6, 0xa5a3, 0xff7f, 0x101b, 0x4ac7, 0x8595, 0xdf49, 0x302d, 0x6af1, 0xe6f4, 0xbc28,
            0x534c, 0x0990, 0x4357, 0x198b, 0xf6ef, 0xac33, 0x2036, 0x7aea, 0x958e, 0xcf52, 0x033b,
            0x59e7, 0xb683, 0xec5f, 0x605a, 0x3a86, 0xd5e2, 0x8f3e, 0xc5f9, 0x9f25, 0x7041, 0x2a9d,
            0xa698, 0xfc44, 0x1320, 0x49fc, 0x86ae, 0xdc72, 0x3316, 0x69ca, 0xe5cf, 0xbf13, 0x5077,
            0x0aab, 0x406c, 0x1ab0, 0xf5d4, 0xaf08, 0x230d, 0x79d1, 0x96b5, 0xcc69, 0x0676, 0x5caa,
            0xb3ce, 0xe912, 0x6517, 0x3fcb, 0xd0af, 0x8a73, 0xc0b4, 0x9a68, 0x750c, 0x2fd0, 0xa3d5,
            0xf909, 0x166d, 0x4cb1, 0x83e3, 0xd93f, 0x365b, 0x6c87, 0xe082, 0xba5e, 0x553a, 0x0fe6,
            0x4521, 0x1ffd, 0xf099, 0xaa45, 0x2640, 0x7c9c, 0x93f8, 0xc924, 0x054d, 0x5f91, 0xb0f5,
            0xea29, 0x662c, 0x3cf0, 0xd394, 0x8948, 0xc38f, 0x9953, 0x7637, 0x2ceb, 0xa0ee, 0xfa32,
            0x1556, 0x4f8a, 0x80d8, 0xda04, 0x3560, 0x6fbc, 0xe3b9, 0xb965, 0x5601, 0x0cdd, 0x461a,
            0x1cc6, 0xf3a2, 0xa97e, 0x257b, 0x7fa7, 0x90c3, 0xca1f, 0x0cec, 0x5630, 0xb954, 0xe388,
            0x6f8d, 0x3551, 0xda35, 0x80e9, 0xca2e, 0x90f2, 0x7f96, 0x254a, 0xa94f, 0xf393, 0x1cf7,
            0x462b, 0x8979, 0xd3a5, 0x3cc1, 0x661d, 0xea18, 0xb0c4, 0x5fa0, 0x057c, 0x4fbb, 0x1567,
            0xfa03, 0xa0df, 0x2cda, 0x7606, 0x9962, 0xc3be, 0x0fd7, 0x550b, 0xba6f, 0xe0b3, 0x6cb6,
            0x366a, 0xd90e, 0x83d2, 0xc915, 0x93c9, 0x7cad, 0x2671, 0xaa74, 0xf0a8, 0x1fcc, 0x4510,
            0x8a42, 0xd09e, 0x3ffa, 0x6526, 0xe923, 0xb3ff, 0x5c9b, 0x0647, 0x4c80, 0x165c, 0xf938,
            0xa3e4, 0x2fe1, 0x753d, 0x9a59, 0xc085, 0x0a9a, 0x5046, 0xbf22, 0xe5fe, 0x69fb, 0x3327,
            0xdc43, 0x869f, 0xcc58, 0x9684, 0x79e0, 0x233c, 0xaf39, 0xf5e5, 0x1a81, 0x405d, 0x8f0f,
            0xd5d3, 0x3ab7, 0x606b, 0xec6e, 0xb6b2, 0x59d6, 0x030a, 0x49cd, 0x1311, 0xfc75, 0xa6a9,
            0x2aac, 0x7070, 0x9f14, 0xc5c8, 0x09a1, 0x537d, 0xbc19, 0xe6c5, 0x6ac0, 0x301c, 0xdf78,
            0x85a4, 0xcf63, 0x95bf, 0x7adb, 0x2007, 0xac02, 0xf6de, 0x19ba, 0x4366, 0x8c34, 0xd6e8,
            0x398c, 0x6350, 0xef55, 0xb589, 0x5aed, 0x0031, 0x4af6, 0x102a, 0xff4e, 0xa592, 0x2997,
            0x734b, 0x9c2f, 0xc6f3,
        ],
        [
            0x0000, 0x1cbb, 0x3976, 0x25cd, 0x72ec, 0x6e57, 0x4b9a, 0x5721, 0xe5d8, 0xf963, 0xdcae,
            0xc015, 0x9734, 0x8b8f, 0xae42, 0xb2f9, 0xc3a1, 0xdf1a, 0xfad7, 0xe66c, 0xb14d, 0xadf6,
            0x883b, 0x9480, 0x2679, 0x3ac2, 0x1f0f, 0x03b4, 0x5495, 0x482e, 0x6de3, 0x7158, 0x8f53,
            0x93e8, 0xb625, 0xaa9e, 0xfdbf, 0xe104, 0xc4c9, 0xd872, 0x6a8b, 0x7630, 0x53fd, 0x4f46,
            0x1867, 0x04dc, 0x2111, 0x3daa, 0x4cf2, 0x5049, 0x7584, 0x693f, 0x3e1e, 0x22a5, 0x0768,
            0x1bd3, 0xa92a, 0xb591, 0x905c, 0x8ce7, 0xdbc6, 0xc77d, 0xe2b0, 0xfe0b, 0x16b7, 0x0a0c,
            0x2fc1, 0x337a, 0x645b, 0x78e0, 0x5d2d, 0x4196, 0xf36f, 0xefd4, 0xca19, 0xd6a2, 0x8183,
            0x9d38, 0xb8f5, 0xa44e, 0xd516, 0xc9ad, 0xec60, 0xf0db, 0xa7fa, 0xbb41, 0x9e8c, 0x8237,
            0x30ce, 0x2c75, 0x09b8, 0x1503, 0x4222, 0x5e99, 0x7b54, 0x67ef, 0x99e4, 0x855f, 0xa092,
            0xbc29, 0xeb08, 0xf7b3, 0xd27e, 0xcec5, 0x7c3c, 0x6087, 0x454a, 0x59f1, 0x0ed0, 0x126b,
            0x37a6, 0x2b1d, 0x5a45, 0x46fe, 0x6333, 0x7f88, 0x28a9, 0x3412, 0x11df, 0x0d64, 0xbf9d,
            0xa326, 0x86eb, 0x9a50, 0xcd71, 0xd1ca, 0xf407, 0xe8bc, 0x2d6e, 0x31d5, 0x1418, 0x08a3,
            0x5f82, 0x4339, 0x66f4, 0x7a4f, 0xc8b6, 0xd40d, 0xf1c0, 0xed7b, 0xba5a, 0xa6e1, 0x832c,
            0x9f97, 0xeecf, 0xf274, 0xd7b9, 0xcb02, 0x9c23, 0x8098, 0xa555, 0xb9ee, 0x0b17, 0x17ac,
            0x3261, 0x2eda, 0x79fb, 0x6540, 0x408d, 0x5c36, 0xa23d, 0xbe86, 0x9b4b, 0x87f0, 0xd0d1,
            0xcc6a, 0xe9a7, 0xf51c, 0x47e5, 0x5b5e, 0x7e93, 0x6228, 0x3509, 0x29b2, 0x0c7f, 0x10c4,
            0x619c, 0x7d27, 0x58ea, 0x4451, 0x1370, 0x0fcb, 0x2a06, 0x36bd, 0x8444, 0x98ff, 0xbd32,
            0xa189, 0xf6a8, 0xea13, 0xcfde, 0xd365, 0x3bd9, 0x2762, 0x02af, 0x1e14, 0x4935, 0x558e,
            0x7043, 0x6cf8, 0xde01, 0xc2ba, 0xe777, 0xfbcc, 0xaced, 0xb056, 0x959b, 0x8920, 0xf878,
            0xe4c3, 0xc10e, 0xddb5, 0x8a94, 0x962f, 0xb3e2, 0xaf59, 0x1da0, 0x011b, 0x24d6, 0x386d,
            0x6f4c, 0x73f7, 0x563a, 0x4a81, 0xb48a, 0xa831, 0x8dfc, 0x9147, 0xc666, 0xdadd, 0xff10,
            0xe3ab, 0x5152, 0x4de9, 0x6824, 0x749f, 0x23be, 0x3f05, 0x1ac8, 0x0673, 0x772b, 0x6b90,
            0x4e5d, 0x52e6, 0x05c7, 0x197c, 0x3cb1, 0x200a, 0x92f3, 0x8e48, 0xab85, 0xb73e, 0xe01f,
            0xfca4, 0xd969, 0xc5d2,
        ],
        [
            0x0000, 0x0b44, 0x1688, 0x1dcc, 0x2d10, 0x2654, 0x3b98, 0x30dc, 0x5a20, 0x5164, 0x4ca8,
            0x47ec, 0x7730, 0x7c74, 0x61b8, 0x6afc, 0xb440, 0xbf04, 0xa2c8, 0xa98c, 0x9950, 0x9214,
            0x8fd8, 0x849c, 0xee60, 0xe524, 0xf8e8, 0xf3ac, 0xc370, 0xc834, 0xd5f8, 0xdebc, 0x6091,
            0x6bd5, 0x7619, 0x7d5d, 0x4d81, 0x46c5, 0x5b09, 0x504d, 0x3ab1, 0x31f5, 0x2c39, 0x277d,
            0x17a1, 0x1ce5, 0x0129, 0x0a6d, 0xd4d1, 0xdf95, 0xc259, 0xc91d, 0xf9c1, 0xf285, 0xef49,
            0xe40d, 0x8ef1, 0x85b5, 0x9879, 0x933d, 0xa3e1, 0xa8a5, 0xb569, 0xbe2d, 0xc122, 0xca66,
            0xd7aa, 0xdcee, 0xec32, 0xe776, 0xfaba, 0xf1fe, 0x9b02, 0x9046, 0x8d8a, 0x86ce, 0xb612,
            0xbd56, 0xa09a, 0xabde, 0x7562, 0x7e26, 0x63ea, 0x68ae, 0x5872, 0x5336, 0x4efa, 0x45be,
            0x2f42, 0x2406, 0x39ca, 0x328e, 0x0252, 0x0916, 0x14da, 0x1f9e, 0xa1b3, 0xaaf7, 0xb73b,
            0xbc7f, 0x8ca3, 0x87e7, 0x9a2b, 0x916f, 0xfb93, 0xf0d7, 0xed1b, 0xe65f, 0xd683, 0xddc7,
            0xc00b, 0xcb4f, 0x15f3, 0x1eb7, 0x037b, 0x083f, 0x38e3, 0x33a7, 0x2e6b, 0x252f, 0x4fd3,
            0x4497, 0x595b, 0x521f, 0x62c3, 0x6987, 0x744b, 0x7f0f, 0x8a55, 0x8111, 0x9cdd, 0x9799,
            0xa745, 0xac01, 0xb1cd, 0xba89, 0xd075, 0xdb31, 0xc6fd, 0xcdb9, 0xfd65, 0xf621, 0xebed,
            0xe0a9, 0x3e15, 0x3551, 0x289d, 0x23d9, 0x1305, 0x1841, 0x058d, 0x0ec9, 0x6435, 0x6f71,
            0x72bd, 0x79f9, 0x4925, 0x4261, 0x5fad, 0x54e9, 0xeac4, 0xe180, 0xfc4c, 0xf708, 0xc7d4,
            0xcc90, 0xd15c, 0xda18, 0xb0e4, 0xbba0, 0xa66c, 0xad28, 0x9df4, 0x96b0, 0x8b7c, 0x8038,
            0x5e84, 0x55c0, 0x480c, 0x4348, 0x7394, 0x78d0, 0x651c, 0x6e58, 0x04a4, 0x0fe0, 0x122c,
            0x1968, 0x29b4, 0x22f0, 0x3f3c, 0x3478, 0x4b77, 0x4033, 0x5dff, 0x56bb, 0x6667, 0x6d23,
            0x70ef, 0x7bab, 0x1157, 0x1a13, 0x07df, 0x0c9b, 0x3c47, 0x3703, 0x2acf, 0x218b, 0xff37,
            0xf473, 0xe9bf, 0xe2fb, 0xd227, 0xd963, 0xc4af, 0xcfeb, 0xa517, 0xae53, 0xb39f, 0xb8db,
            0x8807, 0x8343, 0x9e8f, 0x95cb, 0x2be6, 0x20a2, 0x3d6e, 0x362a, 0x06f6, 0x0db2, 0x107e,
            0x1b3a, 0x71c6, 0x7a82, 0x674e, 0x6c0a, 0x5cd6, 0x5792, 0x4a5e, 0x411a, 0x9fa6, 0x94e2,
            0x892e, 0x826a, 0xb2b6, 0xb9f2, 0xa43e, 0xaf7a, 0xc586, 0xcec2, 0xd30e, 0xd84a, 0xe896,
            0xe3d2, 0xfe1e, 0xf55a,
        ],
        [
            0x0000, 0x042b, 0x0856, 0x0c7d, 0x10ac, 0x1487, 0x18fa, 0x1cd1, 0x2158, 0x2573, 0x290e,
            0x2d25, 0x31f4, 0x35df, 0x39a2, 0x3d89, 0x42b0, 0x469b, 0x4ae6, 0x4ecd, 0x521c, 0x5637,
            0x5a4a, 0x5e61, 0x63e8, 0x67c3, 0x6bbe, 0x6f95, 0x7344, 0x776f, 0x7b12, 0x7f39, 0x8560,
            0x814b, 0x8d36, 0x891d, 0x95cc, 0x91e7, 0x9d9a, 0x99b1, 0xa438, 0xa013, 0xac6e, 0xa845,
            0xb494, 0xb0bf, 0xbcc2, 0xb8e9, 0xc7d0, 0xc3fb, 0xcf86, 0xcbad, 0xd77c, 0xd357, 0xdf2a,
            0xdb01, 0xe688, 0xe2a3, 0xeede, 0xeaf5, 0xf624, 0xf20f, 0xfe72, 0xfa59, 0x02d1, 0x06fa,
            0x0a87, 0x0eac, 0x127d, 0x1656, 0x1a2b, 0x1e00, 0x2389, 0x27a2, 0x2bdf, 0x2ff4, 0x3325,
            0x370e, 0x3b73, 0x3f58, 0x4061, 0x444a, 0x4837, 0x4c1c, 0x50cd, 0x54e6, 0x589b, 0x5cb0,
            0x6139, 0x6512, 0x696f, 0x6d44, 0x7195, 0x75be, 0x79c3, 0x7de8, 0x87b1, 0x839a, 0x8fe7,
            0x8bcc, 0x971d, 0x9336, 0x9f4b, 0x9b60, 0xa6e9, 0xa2c2, 0xaebf, 0xaa94, 0xb645, 0xb26e,
            0xbe13, 0xba38, 0xc501, 0xc12a, 0xcd57, 0xc97c, 0xd5ad, 0xd186, 0xddfb, 0xd9d0, 0xe459,
            0xe072, 0xec0f, 0xe824, 0xf4f5, 0xf0de, 0xfca3, 0xf888, 0x05a2, 0x0189, 0x0df4, 0x09df,
            0x150e, 0x1125, 0x1d58, 0x1973, 0x24fa, 0x20d1, 0x2cac, 0x2887, 0x3456, 0x307d, 0x3c00,
            0x382b, 0x4712, 0x4339, 0x4f44, 0x4b6f, 0x57be, 0x5395, 0x5fe8, 0x5bc3, 0x664a, 0x6261,
            0x6e1c, 0x6a37, 0x76e6, 0x72cd, 0x7eb0, 0x7a9b, 0x80c2, 0x84e9, 0x8894, 0x8cbf, 0x906e,
            0x9445, 0x9838, 0x9c13, 0xa19a, 0xa5b1, 0xa9cc, 0xade7, 0xb136, 0xb51d, 0xb960, 0xbd4b,
            0xc272, 0xc659, 0xca24, 0xce0f, 0xd2de, 0xd6f5, 0xda88, 0xdea3, 0xe32a, 0xe701, 0xeb7c,
            0xef57, 0xf386, 0xf7ad, 0xfbd0, 0xfffb, 0x0773, 0x0358, 0x0f25, 0x0b0e, 0x17df, 0x13f4,
            0x1f89, 0x1ba2, 0x262b, 0x2200, 0x2e7d, 0x2a56, 0x3687, 0x32ac, 0x3ed1, 0x3afa, 0x45c3,
            0x41e8, 0x4d95, 0x49be, 0x556f, 0x5144, 0x5d39, 0x5912, 0x649b, 0x60b0, 0x6ccd, 0x68e6,
            0x7437, 0x701c, 0x7c61, 0x784a, 0x8213, 0x8638, 0x8a45, 0x8e6e, 0x92bf, 0x9694, 0x9ae9,
            0x9ec2, 0xa34b, 0xa760, 0xab1d, 0xaf36, 0xb3e7, 0xb7cc, 0xbbb1, 0xbf9a, 0xc0a3, 0xc488,
            0xc8f5, 0xccde, 0xd00f, 0xd424, 0xd859, 0xdc72, 0xe1fb, 0xe5d0, 0xe9ad, 0xed86, 0xf157,
            0xf57c, 0xf901, 0xfd2a,
        ],
        [
            0x0000, 0x9fd5, 0x37bb, 0xa86e, 0x6f76, 0xf0a3, 0x58cd, 0xc718, 0xdeec, 0x4139, 0xe957,
            0x7682, 0xb19a, 0x2e4f, 0x8621, 0x19f4, 0xb5c9, 0x2a1c, 0x8272, 0x1da7, 0xdabf, 0x456a,
            0xed04, 0x72d1, 0x6b25, 0xf4f0, 0x5c9e, 0xc34b, 0x0453, 0x9b86, 0x33e8, 0xac3d, 0x6383,
            0xfc56, 0x5438, 0xcbed, 0x0cf5, 0x9320, 0x3b4e, 0xa49b, 0xbd6f, 0x22ba, 0x8ad4, 0x1501,
            0xd219, 0x4dcc, 0xe5a2, 0x7a77, 0xd64a, 0x499f, 0xe1f1, 0x7e24, 0xb93c, 0x26e9, 0x8e87,
            0x1152, 0x08a6, 0x9773, 0x3f1d, 0xa0c8, 0x67d0, 0xf805, 0x506b, 0xcfbe, 0xc706, 0x58d3,
            0xf0bd, 0x6f68, 0xa870, 0x37a5, 0x9fcb, 0x001e, 0x19ea, 0x863f, 0x2e51, 0xb184, 0x769c,
            0xe949, 0x4127, 0xdef2, 0x72cf, 0xed1a, 0x4574, 0xdaa1, 0x1db9, 0x826c, 0x2a02, 0xb5d7,
            0xac23, 0x33f6, 0x9b98, 0x044d, 0xc355, 0x5c80, 0xf4ee, 0x6b3b, 0xa485, 0x3b50, 0x933e,
            0x0ceb, 0xcbf3, 0x5426, 0xfc48, 0x639d, 0x7a69, 0xe5bc, 0x4dd2, 0xd207, 0x151f, 0x8aca,
            0x22a4, 0xbd71, 0x114c, 0x8e99, 0x26f7, 0xb922, 0x7e3a, 0xe1ef, 0x4981, 0xd654, 0xcfa0,
            0x5075, 0xf81b, 0x67ce, 0xa0d6, 0x3f03, 0x976d, 0x08b8, 0x861d, 0x19c8, 0xb1a6, 0x2e73,
            0xe96b, 0x76be, 0xded0, 0x4105, 0x58f1, 0xc724, 0x6f4a, 0xf09f, 0x3787, 0xa852, 0x003c,
            0x9fe9, 0x33d4, 0xac01, 0x046f, 0x9bba, 0x5ca2, 0xc377, 0x6b19, 0xf4cc, 0xed38, 0x72ed,
            0xda83, 0x4556, 0x824e, 0x1d9b, 0xb5f5, 0x2a20, 0xe59e, 0x7a4b, 0xd225, 0x4df0, 0x8ae8,
            0x153d, 0xbd53, 0x2286, 0x3b72, 0xa4a7, 0x0cc9, 0x931c, 0x5404, 0xcbd1, 0x63bf, 0xfc6a,
            0x5057, 0xcf82, 0x67ec, 0xf839, 0x3f21, 0xa0f4, 0x089a, 0x974f, 0x8ebb, 0x116e, 0xb900,
            0x26d5, 0xe1cd, 0x7e18, 0xd676, 0x49a3, 0x411b, 0xdece, 0x76a0, 0xe975, 0x2e6d, 0xb1b8,
            0x19d6, 0x8603, 0x9ff7, 0x0022, 0xa84c, 0x3799, 0xf081, 0x6f54, 0xc73a, 0x58ef, 0xf4d2,
            0x6b07, 0xc369, 0x5cbc, 0x9ba4, 0x0471, 0xac1f, 0x33ca, 0x2a3e, 0xb5eb, 0x1d85, 0x8250,
            0x4548, 0xda9d, 0x72f3, 0xed26, 0x2298, 0xbd4d, 0x1523, 0x8af6, 0x4dee, 0xd23b, 0x7a55,
            0xe580, 0xfc74, 0x63a1, 0xcbcf, 0x541a, 0x9302, 0x0cd7, 0xa4b9, 0x3b6c, 0x9751, 0x0884,
            0xa0ea, 0x3f3f, 0xf827, 0x67f2, 0xcf9c, 0x5049, 0x49bd, 0xd668, 0x7e06, 0xe1d3, 0x26cb,
            0xb91e, 0x1170, 0x8ea5,
        ],
        [
            0x0000, 0x81bf, 0x0b6f, 0x8ad0, 0x16de, 0x9761, 0x1db1, 0x9c0e, 0x2dbc, 0xac03, 0x26d3,
            0xa76c, 0x3b62, 0xbadd, 0x300d, 0xb1b2, 0x5b78, 0xdac7, 0x5017, 0xd1a8, 0x4da6, 0xcc19,
            0x46c9, 0xc776, 0x76c4, 0xf77b, 0x7dab, 0xfc14, 0x601a, 0xe1a5, 0x6b75, 0xeaca, 0xb6f0,
            0x374f, 0xbd9f, 0x3c20, 0xa02e, 0x2191, 0xab41, 0x2afe, 0x9b4c, 0x1af3, 0x9023, 0x119c,
            0x8d92, 0x0c2d, 0x86fd, 0x0742, 0xed88, 0x6c37, 0xe6e7, 0x6758, 0xfb56, 0x7ae9, 0xf039,
            0x7186, 0xc034, 0x418b, 0xcb5b, 0x4ae4, 0xd6ea, 0x5755, 0xdd85, 0x5c3a, 0x65f1, 0xe44e,
            0x6e9e, 0xef21, 0x732f, 0xf290, 0x7840, 0xf9ff, 0x484d, 0xc9f2, 0x4322, 0xc29d, 0x5e93,
            0xdf2c, 0x55fc, 0xd443, 0x3e89, 0xbf36, 0x35e6, 0xb459, 0x2857, 0xa9e8, 0x2338, 0xa287,
            0x1335, 0x928a, 0x185a, 0x99e5, 0x05eb, 0x8454, 0x0e84, 0x8f3b, 0xd301, 0x52be, 0xd86e,
            0x59d1, 0xc5df, 0x4460, 0xceb0, 0x4f0f, 0xfebd, 0x7f02, 0xf5d2, 0x746d, 0xe863, 0x69dc,
            0xe30c, 0x62b3, 0x8879, 0x09c6, 0x8316, 0x02a9, 0x9ea7, 0x1f18, 0x95c8, 0x1477, 0xa5c5,
            0x247a, 0xaeaa, 0x2f15, 0xb31b, 0x32a4, 0xb874, 0x39cb, 0xcbe2, 0x4a5d, 0xc08d, 0x4132,
            0xdd3c, 0x5c83, 0xd653, 0x57ec, 0xe65e, 0x67e1, 0xed31, 0x6c8e, 0xf080, 0x713f, 0xfbef,
            0x7a50, 0x909a, 0x1125, 0x9bf5, 0x1a4a, 0x8644, 0x07fb, 0x8d2b, 0x0c94, 0xbd26, 0x3c99,
            0xb649, 0x37f6, 0xabf8, 0x2a47, 0xa097, 0x2128, 0x7d12, 0xfcad, 0x767d, 0xf7c2, 0x6bcc,
            0xea73, 0x60a3, 0xe11c, 0x50ae, 0xd111, 0x5bc1, 0xda7e, 0x4670, 0xc7cf, 0x4d1f, 0xcca0,
            0x266a, 0xa7d5, 0x2d05, 0xacba, 0x30b4, 0xb10b, 0x3bdb, 0xba64, 0x0bd6, 0x8a69, 0x00b9,
            0x8106, 0x1d08, 0x9cb7, 0x1667, 0x97d8, 0xae13, 0x2fac, 0xa57c, 0x24c3, 0xb8cd, 0x3972,
            0xb3a2, 0x321d, 0x83af, 0x0210, 0x88c0, 0x097f, 0x9571, 0x14ce, 0x9e1e, 0x1fa1, 0xf56b,
            0x74d4, 0xfe04, 0x7fbb, 0xe3b5, 0x620a, 0xe8da, 0x6965, 0xd8d7, 0x5968, 0xd3b8, 0x5207,
            0xce09, 0x4fb6, 0xc566, 0x44d9, 0x18e3, 0x995c, 0x138c, 0x9233, 0x0e3d, 0x8f82, 0x0552,
            0x84ed, 0x355f, 0xb4e0, 0x3e30, 0xbf8f, 0x2381, 0xa23e, 0x28ee, 0xa951, 0x439b, 0xc224,
            0x48f4, 0xc94b, 0x5545, 0xd4fa, 0x5e2a, 0xdf95, 0x6e27, 0xef98, 0x6548, 0xe4f7, 0x78f9,
            0xf946, 0x7396, 0xf229,
        ],
        [
            0x0000, 0x4dfd, 0x9bfa, 0xd607, 0x3fe5, 0x7218, 0xa41f, 0xe9e2, 0x7fca, 0x3237, 0xe430,
            0xa9cd, 0x402f, 0x0dd2, 0xdbd5, 0x9628, 0xff94, 0xb269, 0x646e, 0x2993, 0xc071, 0x8d8c,
            0x5b8b, 0x1676, 0x805e, 0xcda3, 0x1ba4, 0x5659, 0xbfbb, 0xf246, 0x2441, 0x69bc, 0xf739,
            0xbac4, 0x6cc3, 0x213e, 0xc8dc, 0x8521, 0x5326, 0x1edb, 0x88f3, 0xc50e, 0x1309, 0x5ef4,
            0xb716, 0xfaeb, 0x2cec, 0x6111, 0x08ad, 0x4550, 0x9357, 0xdeaa, 0x3748, 0x7ab5, 0xacb2,
            0xe14f, 0x7767, 0x3a9a, 0xec9d, 0xa160, 0x4882, 0x057f, 0xd378, 0x9e85, 0xe663, 0xab9e,
            0x7d99, 0x3064, 0xd986, 0x947b, 0x427c, 0x0f81, 0x99a9, 0xd454, 0x0253, 0x4fae, 0xa64c,
            0xebb1, 0x3db6, 0x704b, 0x19f7, 0x540a, 0x820d, 0xcff0, 0x2612, 0x6bef, 0xbde8, 0xf015,
            0x663d, 0x2bc0, 0xfdc7, 0xb03a, 0x59d8, 0x1425, 0xc222, 0x8fdf, 0x115a, 0x5ca7, 0x8aa0,
            0xc75d, 0x2ebf, 0x6342, 0xb545, 0xf8b8, 0x6e90, 0x236d, 0xf56a, 0xb897, 0x5175, 0x1c88,
            0xca8f, 0x8772, 0xeece, 0xa333, 0x7534, 0x38c9, 0xd12b, 0x9cd6, 0x4ad1, 0x072c, 0x9104,
            0xdcf9, 0x0afe, 0x4703, 0xaee1, 0xe31c, 0x351b, 0x78e6, 0xc4d7, 0x892a, 0x5f2d, 0x12d0,
            0xfb32, 0xb6cf, 0x60c8, 0x2d35, 0xbb1d, 0xf6e0, 0x20e7, 0x6d1a, 0x84f8, 0xc905, 0x1f02,
            0x52ff, 0x3b43, 0x76be, 0xa0b9, 0xed44, 0x04a6, 0x495b, 0x9f5c, 0xd2a1, 0x4489, 0x0974,
            0xdf73, 0x928e, 0x7b6c, 0x3691, 0xe096, 0xad6b, 0x33ee, 0x7e13, 0xa814, 0xe5e9, 0x0c0b,
            0x41f6, 0x97f1, 0xda0c, 0x4c24, 0x01d9, 0xd7de, 0x9a23, 0x73c1, 0x3e3c, 0xe83b, 0xa5c6,
            0xcc7a, 0x8187, 0x5780, 0x1a7d, 0xf39f, 0xbe62, 0x6865, 0x2598, 0xb3b0, 0xfe4d, 0x284a,
            0x65b7, 0x8c55, 0xc1a8, 0x17af, 0x5a52, 0x22b4, 0x6f49, 0xb94e, 0xf4b3, 0x1d51, 0x50ac,
            0x86ab, 0xcb56, 0x5d7e, 0x1083, 0xc684, 0x8b79, 0x629b, 0x2f66, 0xf961, 0xb49c, 0xdd20,
            0x90dd, 0x46da, 0x0b27, 0xe2c5, 0xaf38, 0x793f, 0x34c2, 0xa2ea, 0xef17, 0x3910, 0x74ed,
            0x9d0f, 0xd0f2, 0x06f5, 0x4b08, 0xd58d, 0x9870, 0x4e77, 0x038a, 0xea68, 0xa795, 0x7192,
            0x3c6f, 0xaa47, 0xe7ba, 0x31bd, 0x7c40, 0x95a2, 0xd85f, 0x0e58, 0x43a5, 0x2a19, 0x67e4,
            0xb1e3, 0xfc1e, 0x15fc, 0x5801, 0x8e06, 0xc3fb, 0x55d3, 0x182e, 0xce29, 0x83d4, 0x6a36,
            0x27cb, 0xf1cc, 0xbc31,
        ],
        [
            0x0000, 0x2c27, 0x584e, 0x7469, 0xb09c, 0x9cbb, 0xe8d2, 0xc4f5, 0x6929, 0x450e, 0x3167,
            0x1d40, 0xd9b5, 0xf592, 0x81fb, 0xaddc, 0xd252, 0xfe75, 0x8a1c, 0xa63b, 0x62ce, 0x4ee9,
            0x3a80, 0x16a7, 0xbb7b, 0x975c, 0xe335, 0xcf12, 0x0be7, 0x27c0, 0x53a9, 0x7f8e, 0xacb5,
            0x8092, 0xf4fb, 0xd8dc, 0x1c29, 0x300e, 0x4467, 0x6840, 0xc59c, 0xe9bb, 0x9dd2, 0xb1f5,
            0x7500, 0x5927, 0x2d4e, 0x0169, 0x7ee7, 0x52c0, 0x26a9, 0x0a8e, 0xce7b, 0xe25c, 0x9635,
            0xba12, 0x17ce, 0x3be9, 0x4f80, 0x63a7, 0xa752, 0x8b75, 0xff1c, 0xd33b, 0x517b, 0x7d5c,
            0x0935, 0x2512, 0xe1e7, 0xcdc0, 0xb9a9, 0x958e, 0x3852, 0x1475, 0x601c, 0x4c3b, 0x88ce,
            0xa4e9, 0xd080, 0xfca7, 0x8329, 0xaf0e, 0xdb67, 0xf740, 0x33b5, 0x1f92, 0x6bfb, 0x47dc,
            0xea00, 0xc627, 0xb24e, 0x9e69, 0x5a9c, 0x76bb, 0x02d2, 0x2ef5, 0xfdce, 0xd1e9, 0xa580,
            0x89a7, 0x4d52, 0x6175, 0x151c, 0x393b, 0x94e7, 0xb8c0, 0xcca9, 0xe08e, 0x247b, 0x085c,
            0x7c35, 0x5012, 0x2f9c, 0x03bb, 0x77d2, 0x5bf5, 0x9f00, 0xb327, 0xc74e, 0xeb69, 0x46b5,
            0x6a92, 0x1efb, 0x32dc, 0xf629, 0xda0e, 0xae67, 0x8240, 0xa2f6, 0x8ed1, 0xfab8, 0xd69f,
            0x126a, 0x3e4d, 0x4a24, 0x6603, 0xcbdf, 0xe7f8, 0x9391, 0xbfb6, 0x7b43, 0x5764, 0x230d,
            0x0f2a, 0x70a4, 0x5c83, 0x28ea, 0x04cd, 0xc038, 0xec1f, 0x9876, 0xb451, 0x198d, 0x35aa,
            0x41c3, 0x6de4, 0xa911, 0x8536, 0xf15f, 0xdd78, 0x0e43, 0x2264, 0x560d, 0x7a2a, 0xbedf,
            0x92f8, 0xe691, 0xcab6, 0x676a, 0x4b4d, 0x3f24, 0x1303, 0xd7f6, 0xfbd1, 0x8fb8, 0xa39f,
            0xdc11, 0xf036, 0x845f, 0xa878, 0x6c8d, 0x40aa, 0x34c3, 0x18e4, 0xb538, 0x991f, 0xed76,
            0xc151, 0x05a4, 0x2983, 0x5dea, 0x71cd, 0xf38d, 0xdfaa, 0xabc3, 0x87e4, 0x4311, 0x6f36,
            0x1b5f, 0x3778, 0x9aa4, 0xb683, 0xc2ea, 0xeecd, 0x2a38, 0x061f, 0x7276, 0x5e51, 0x21df,
            0x0df8, 0x7991, 0x55b6, 0x9143, 0xbd64, 0xc90d, 0xe52a, 0x48f6, 0x64d1, 0x10b8, 0x3c9f,
            0xf86a, 0xd44d, 0xa024, 0x8c03, 0x5f38, 0x731f, 0x0776, 0x2b51, 0xefa4, 0xc383, 0xb7ea,
            0x9bcd, 0x3611, 0x1a36, 0x6e5f, 0x4278, 0x868d, 0xaaaa, 0xdec3, 0xf2e4, 0x8d6a, 0xa14d,
            0xd524, 0xf903, 0x3df6, 0x11d1, 0x65b8, 0x499f, 0xe443, 0xc864, 0xbc0d, 0x902a, 0x54df,
            0x78f8, 0x0c91, 0x20b6,
        ],
        [
            0x0000, 0x5591, 0xab22, 0xfeb3, 0x5e55, 0x0bc4, 0xf577, 0xa0e6, 0xbcaa, 0xe93b, 0x1788,
            0x4219, 0xe2ff, 0xb76e, 0x49dd, 0x1c4c, 0x7145, 0x24d4, 0xda67, 0x8ff6, 0x2f10, 0x7a81,
            0x8432, 0xd1a3, 0xcdef, 0x987e, 0x66cd, 0x335c, 0x93ba, 0xc62b, 0x3898, 0x6d09, 0xe28a,
            0xb71b, 0x49a8, 0x1c39, 0xbcdf, 0xe94e, 0x17fd, 0x426c, 0x5e20, 0x0bb1, 0xf502, 0xa093,
            0x0075, 0x55e4, 0xab57, 0xfec6, 0x93cf, 0xc65e, 0x38ed, 0x6d7c, 0xcd9a, 0x980b, 0x66b8,
            0x3329, 0x2f65, 0x7af4, 0x8447, 0xd1d6, 0x7130, 0x24a1, 0xda12, 0x8f83, 0xcd05, 0x9894,
            0x6627, 0x33b6, 0x9350, 0xc6c1, 0x3872, 0x6de3, 0x71af, 0x243e, 0xda8d, 0x8f1c, 0x2ffa,
            0x7a6b, 0x84d8, 0xd149, 0xbc40, 0xe9d1, 0x1762, 0x42f3, 0xe215, 0xb784, 0x4937, 0x1ca6,
            0x00ea, 0x557b, 0xabc8, 0xfe59, 0x5ebf, 0x0b2e, 0xf59d, 0xa00c, 0x2f8f, 0x7a1e, 0x84ad,
            0xd13c, 0x71da, 0x244b, 0xdaf8, 0x8f69, 0x9325, 0xc6b4, 0x3807, 0x6d96, 0xcd70, 0x98e1,
            0x6652, 0x33c3, 0x5eca, 0x0b5b, 0xf5e8, 0xa079, 0x009f, 0x550e, 0xabbd, 0xfe2c, 0xe260,
            0xb7f1, 0x4942, 0x1cd3, 0xbc35, 0xe9a4, 0x1717, 0x4286, 0x921b, 0xc78a, 0x3939, 0x6ca8,
            0xcc4e, 0x99df, 0x676c, 0x32fd, 0x2eb1, 0x7b20, 0x8593, 0xd002, 0x70e4, 0x2575, 0xdbc6,
            0x8e57, 0xe35e, 0xb6cf, 0x487c, 0x1ded, 0xbd0b, 0xe89a, 0x1629, 0x43b8, 0x5ff4, 0x0a65,
            0xf4d6, 0xa147, 0x01a1, 0x5430, 0xaa83, 0xff12, 0x7091, 0x2500, 0xdbb3, 0x8e22, 0x2ec4,
            0x7b55, 0x85e6, 0xd077, 0xcc3b, 0x99aa, 0x6719, 0x3288, 0x926e, 0xc7ff, 0x394c, 0x6cdd,
            0x01d4, 0x5445, 0xaaf6, 0xff67, 0x5f81, 0x0a10, 0xf4a3, 0xa132, 0xbd7e, 0xe8ef, 0x165c,
            0x43cd, 0xe32b, 0xb6ba, 0x4809, 0x1d98, 0x5f1e, 0x0a8f, 0xf43c, 0xa1ad, 0x014b, 0x54da,
            0xaa69, 0xfff8, 0xe3b4, 0xb625, 0x4896, 0x1d07, 0xbde1, 0xe870, 0x16c3, 0x4352, 0x2e5b,
            0x7bca, 0x8579, 0xd0e8, 0x700e, 0x259f, 0xdb2c, 0x8ebd, 0x92f1, 0xc760, 0x39d3, 0x6c42,
            0xcca4, 0x9935, 0x6786, 0x3217, 0xbd94, 0xe805, 0x16b6, 0x4327, 0xe3c1, 0xb650, 0x48e3,
            0x1d72, 0x013e, 0x54af, 0xaa1c, 0xff8d, 0x5f6b, 0x0afa, 0xf449, 0xa1d8, 0xccd1, 0x9940,
            0x67f3, 0x3262, 0x9284, 0xc715, 0x39a6, 0x6c37, 0x707b, 0x25ea, 0xdb59, 0x8ec8, 0x2e2e,
            0x7bbf, 0x850c, 0xd09d,
        ],
        [
            0x0000, 0x8555, 0x02bb, 0x87ee, 0x0576, 0x8023, 0x07cd, 0x8298, 0x0aec, 0x8fb9, 0x0857,
            0x8d02, 0x0f9a, 0x8acf, 0x0d21, 0x8874, 0x15d8, 0x908d, 0x1763, 0x9236, 0x10ae, 0x95fb,
            0x1215, 0x9740, 0x1f34, 0x9a61, 0x1d8f, 0x98da, 0x1a42, 0x9f17, 0x18f9, 0x9dac, 0x2bb0,
            0xaee5, 0x290b, 0xac5e, 0x2ec6, 0xab93, 0x2c7d, 0xa928, 0x215c, 0xa409, 0x23e7, 0xa6b2,
            0x242a, 0xa17f, 0x2691, 0xa3c4, 0x3e68, 0xbb3d, 0x3cd3, 0xb986, 0x3b1e, 0xbe4b, 0x39a5,
            0xbcf0, 0x3484, 0xb1d1, 0x363f, 0xb36a, 0x31f2, 0xb4a7, 0x3349, 0xb61c, 0x5760, 0xd235,
            0x55db, 0xd08e, 0x5216, 0xd743, 0x50ad, 0xd5f8, 0x5d8c, 0xd8d9, 0x5f37, 0xda62, 0x58fa,
            0xddaf, 0x5a41, 0xdf14, 0x42b8, 0xc7ed, 0x4003, 0xc556, 0x47ce, 0xc29b, 0x4575, 0xc020,
            0x4854, 0xcd01, 0x4aef, 0xcfba, 0x4d22, 0xc877, 0x4f99, 0xcacc, 0x7cd0, 0xf985, 0x7e6b,
            0xfb3e, 0x79a6, 0xfcf3, 0x7b1d, 0xfe48, 0x763c, 0xf369, 0x7487, 0xf1d2, 0x734a, 0xf61f,
            0x71f1, 0xf4a4, 0x6908, 0xec5d, 0x6bb3, 0xeee6, 0x6c7e, 0xe92b, 0x6ec5, 0xeb90, 0x63e4,
            0xe6b1, 0x615f, 0xe40a, 0x6692, 0xe3c7, 0x6429, 0xe17c, 0xaec0, 0x2b95, 0xac7b, 0x292e,
            0xabb6, 0x2ee3, 0xa90d, 0x2c58, 0xa42c, 0x2179, 0xa697, 0x23c2, 0xa15a, 0x240f, 0xa3e1,
            0x26b4, 0xbb18, 0x3e4d, 0xb9a3, 0x3cf6, 0xbe6e, 0x3b3b, 0xbcd5, 0x3980, 0xb1f4, 0x34a1,
            0xb34f, 0x361a, 0xb482, 0x31d7, 0xb639, 0x336c, 0x8570, 0x0025, 0x87cb, 0x029e, 0x8006,
            0x0553, 0x82bd, 0x07e8, 0x8f9c, 0x0ac9, 0x8d27, 0x0872, 0x8aea, 0x0fbf, 0x8851, 0x0d04,
            0x90a8, 0x15fd, 0x9213, 0x1746, 0x95de, 0x108b, 0x9765, 0x1230, 0x9a44, 0x1f11, 0x98ff,
            0x1daa, 0x9f32, 0x1a67, 0x9d89, 0x18dc, 0xf9a0, 0x7cf5, 0xfb1b, 0x7e4e, 0xfcd6, 0x7983,
            0xfe6d, 0x7b38, 0xf34c, 0x7619, 0xf1f7, 0x74a2, 0xf63a, 0x736f, 0xf481, 0x71d4, 0xec78,
            0x692d, 0xeec3, 0x6b96, 0xe90e, 0x6c5b, 0xebb5, 0x6ee0, 0xe694, 0x63c1, 0xe42f, 0x617a,
            0xe3e2, 0x66b7, 0xe159, 0x640c, 0xd210, 0x5745, 0xd0ab, 0x55fe, 0xd766, 0x5233, 0xd5dd,
            0x5088, 0xd8fc, 0x5da9, 0xda47, 0x5f12, 0xdd8a, 0x58df, 0xdf31, 0x5a64, 0xc7c8, 0x429d,
            0xc573, 0x4026, 0xc2be, 0x47eb, 0xc005, 0x4550, 0xcd24, 0x4871, 0xcf9f, 0x4aca, 0xc852,
            0x4d07, 0xcae9, 0x4fbc,
        ],
        [
            0x0000, 0x05ad, 0x0b5a, 0x0ef7, 0x16b4, 0x1319, 0x1dee, 0x1843, 0x2d68, 0x28c5, 0x2632,
            0x239f, 0x3bdc, 0x3e71, 0x3086, 0x352b, 0x5ad0, 0x5f7d, 0x518a, 0x5427, 0x4c64, 0x49c9,
            0x473e, 0x4293, 0x77b8, 0x7215, 0x7ce2, 0x794f, 0x610c, 0x64a1, 0x6a56, 0x6ffb, 0xb5a0,
            0xb00d, 0xbefa, 0xbb57, 0xa314, 0xa6b9, 0xa84e, 0xade3, 0x98c8, 0x9d65, 0x9392, 0x963f,
            0x8e7c, 0x8bd1, 0x8526, 0x808b, 0xef70, 0xeadd, 0xe42a, 0xe187, 0xf9c4, 0xfc69, 0xf29e,
            0xf733, 0xc218, 0xc7b5, 0xc942, 0xccef, 0xd4ac, 0xd101, 0xdff6, 0xda5b, 0x6351, 0x66fc,
            0x680b, 0x6da6, 0x75e5, 0x7048, 0x7ebf, 0x7b12, 0x4e39, 0x4b94, 0x4563, 0x40ce, 0x588d,
            0x5d20, 0x53d7, 0x567a, 0x3981, 0x3c2c, 0x32db, 0x3776, 0x2f35, 0x2a98, 0x246f, 0x21c2,
            0x14e9, 0x1144, 0x1fb3, 0x1a1e, 0x025d, 0x07f0, 0x0907, 0x0caa, 0xd6f1, 0xd35c, 0xddab,
            0xd806, 0xc045, 0xc5e8, 0xcb1f, 0xceb2, 0xfb99, 0xfe34, 0xf0c3, 0xf56e, 0xed2d, 0xe880,
            0xe677, 0xe3da, 0x8c21, 0x898c, 0x877b, 0x82d6, 0x9a95, 0x9f38, 0x91cf, 0x9462, 0xa149,
            0xa4e4, 0xaa13, 0xafbe, 0xb7fd, 0xb250, 0xbca7, 0xb90a, 0xc6a2, 0xc30f, 0xcdf8, 0xc855,
            0xd016, 0xd5bb, 0xdb4c, 0xdee1, 0xebca, 0xee67, 0xe090, 0xe53d, 0xfd7e, 0xf8d3, 0xf624,
            0xf389, 0x9c72, 0x99df, 0x9728, 0x9285, 0x8ac6, 0x8f6b, 0x819c, 0x8431, 0xb11a, 0xb4b7,
            0xba40, 0xbfed, 0xa7ae, 0xa203, 0xacf4, 0xa959, 0x7302, 0x76af, 0x7858, 0x7df5, 0x65b6,
            0x601b, 0x6eec, 0x6b41, 0x5e6a, 0x5bc7, 0x5530, 0x509d, 0x48de, 0x4d73, 0x4384, 0x4629,
            0x29d2, 0x2c7f, 0x2288, 0x2725, 0x3f66, 0x3acb, 0x343c, 0x3191, 0x04ba, 0x0117, 0x0fe0,
            0x0a4d, 0x120e, 0x17a3, 0x1954, 0x1cf9, 0xa5f3, 0xa05e, 0xaea9, 0xab04, 0xb347, 0xb6ea,
            0xb81d, 0xbdb0, 0x889b, 0x8d36, 0x83c1, 0x866c, 0x9e2f, 0x9b82, 0x9575, 0x90d8, 0xff23,
            0xfa8e, 0xf479, 0xf1d4, 0xe997, 0xec3a, 0xe2cd, 0xe760, 0xd24b, 0xd7e6, 0xd911, 0xdcbc,
            0xc4ff, 0xc152, 0xcfa5, 0xca08, 0x1053, 0x15fe, 0x1b09, 0x1ea4, 0x06e7, 0x034a, 0x0dbd,
            0x0810, 0x3d3b, 0x3896, 0x3661, 0x33cc, 0x2b8f, 0x2e22, 0x20d5, 0x2578, 0x4a83, 0x4f2e,
            0x41d9, 0x4474, 0x5c37, 0x599a, 0x576d, 0x52c0, 0x67eb, 0x6246, 0x6cb1, 0x691c, 0x715f,
            0x74f2, 0x7a05, 0x7fa8,
        ],
        [
            0x0000, 0x7eea, 0xfdd4, 0x833e, 0xf3b9, 0x8d53, 0x0e6d, 0x7087, 0xef63, 0x9189, 0x12b7,
            0x6c5d, 0x1cda, 0x6230, 0xe10e, 0x9fe4, 0xd6d7, 0xa83d, 0x2b03, 0x55e9, 0x256e, 0x5b84,
            0xd8ba, 0xa650, 0x39b4, 0x475e, 0xc460, 0xba8a, 0xca0d, 0xb4e7, 0x37d9, 0x4933, 0xa5bf,
            0xdb55, 0x586b, 0x2681, 0x5606, 0x28ec, 0xabd2, 0xd538, 0x4adc, 0x3436, 0xb708, 0xc9e2,
            0xb965, 0xc78f, 0x44b1, 0x3a5b, 0x7368, 0x0d82, 0x8ebc, 0xf056, 0x80d1, 0xfe3b, 0x7d05,
            0x03ef, 0x9c0b, 0xe2e1, 0x61df, 0x1f35, 0x6fb2, 0x1158, 0x9266, 0xec8c, 0x436f, 0x3d85,
            0xbebb, 0xc051, 0xb0d6, 0xce3c, 0x4d02, 0x33e8, 0xac0c, 0xd2e6, 0x51d8, 0x2f32, 0x5fb5,
            0x215f, 0xa261, 0xdc8b, 0x95b8, 0xeb52, 0x686c, 0x1686, 0x6601, 0x18eb, 0x9bd5, 0xe53f,
            0x7adb, 0x0431, 0x870f, 0xf9e5, 0x8962, 0xf788, 0x74b6, 0x0a5c, 0xe6d0, 0x983a, 0x1b04,
            0x65ee, 0x1569, 0x6b83, 0xe8bd, 0x9657, 0x09b3, 0x7759, 0xf467, 0x8a8d, 0xfa0a, 0x84e0,
            0x07de, 0x7934, 0x3007, 0x4eed, 0xcdd3, 0xb339, 0xc3be, 0xbd54, 0x3e6a, 0x4080, 0xdf64,
            0xa18e, 0x22b0, 0x5c5a, 0x2cdd, 0x5237, 0xd109, 0xafe3, 0x86de, 0xf834, 0x7b0a, 0x05e0,
            0x7567, 0x0b8d, 0x88b3, 0xf659, 0x69bd, 0x1757, 0x9469, 0xea83, 0x9a04, 0xe4ee, 0x67d0,
            0x193a, 0x5009, 0x2ee3, 0xaddd, 0xd337, 0xa3b0, 0xdd5a, 0x5e64, 0x208e, 0xbf6a, 0xc180,
            0x42be, 0x3c54, 0x4cd3, 0x3239, 0xb107, 0xcfed, 0x2361, 0x5d8b, 0xdeb5, 0xa05f, 0xd0d8,
            0xae32, 0x2d0c, 0x53e6, 0xcc02, 0xb2e8, 0x31d6, 0x4f3c, 0x3fbb, 0x4151, 0xc26f, 0xbc85,
            0xf5b6, 0x8b5c, 0x0862, 0x7688, 0x060f, 0x78e5, 0xfbdb, 0x8531, 0x1ad5, 0x643f, 0xe701,
            0x99eb, 0xe96c, 0x9786, 0x14b8, 0x6a52, 0xc5b1, 0xbb5b, 0x3865, 0x468f, 0x3608, 0x48e2,
            0xcbdc, 0xb536, 0x2ad2, 0x5438, 0xd706, 0xa9ec, 0xd96b, 0xa781, 0x24bf, 0x5a55, 0x1366,
            0x6d8c, 0xeeb2, 0x9058, 0xe0df, 0x9e35, 0x1d0b, 0x63e1, 0xfc05, 0x82ef, 0x01d1, 0x7f3b,
            0x0fbc, 0x7156, 0xf268, 0x8c82, 0x600e, 0x1ee4, 0x9dda, 0xe330, 0x93b7, 0xed5d, 0x6e63,
            0x1089, 0x8f6d, 0xf187, 0x72b9, 0x0c53, 0x7cd4, 0x023e, 0x8100, 0xffea, 0xb6d9, 0xc833,
            0x4b0d, 0x35e7, 0x4560, 0x3b8a, 0xb8b4, 0xc65e, 0x59ba, 0x2750, 0xa46e, 0xda84, 0xaa03,
            0xd4e9, 0x57d7, 0x293d,
        ],
        [
            0x0000, 0x482a, 0x9054, 0xd87e, 0x28b9, 0x6093, 0xb8ed, 0xf0c7, 0x5172, 0x1958, 0xc126,
            0x890c, 0x79cb, 0x31e1, 0xe99f, 0xa1b5, 0xa2e4, 0xeace, 0x32b0, 0x7a9a, 0x8a5d, 0xc277,
            0x1a09, 0x5223, 0xf396, 0xbbbc, 0x63c2, 0x2be8, 0xdb2f, 0x9305, 0x4b7b, 0x0351, 0x4dd9,
            0x05f3, 0xdd8d, 0x95a7, 0x6560, 0x2d4a, 0xf534, 0xbd1e, 0x1cab, 0x5481, 0x8cff, 0xc4d5,
            0x3412, 0x7c38, 0xa446, 0xec6c, 0xef3d, 0xa717, 0x7f69, 0x3743, 0xc784, 0x8fae, 0x57d0,
            0x1ffa, 0xbe4f, 0xf665, 0x2e1b, 0x6631, 0x96f6, 0xdedc, 0x06a2, 0x4e88, 0x9bb2, 0xd398,
            0x0be6, 0x43cc, 0xb30b, 0xfb21, 0x235f, 0x6b75, 0xcac0, 0x82ea, 0x5a94, 0x12be, 0xe279,
            0xaa53, 0x722d, 0x3a07, 0x3956, 0x717c, 0xa902, 0xe128, 0x11ef, 0x59c5, 0x81bb, 0xc991,
            0x6824, 0x200e, 0xf870, 0xb05a, 0x409d, 0x08b7, 0xd0c9, 0x98e3, 0xd66b, 0x9e41, 0x463f,
            0x0e15, 0xfed2, 0xb6f8, 0x6e86, 0x26ac, 0x8719, 0xcf33, 0x174d, 0x5f67, 0xafa0, 0xe78a,
            0x3ff4, 0x77de, 0x748f, 0x3ca5, 0xe4db, 0xacf1, 0x5c36, 0x141c, 0xcc62, 0x8448, 0x25fd,
            0x6dd7, 0xb5a9, 0xfd83, 0x0d44, 0x456e, 0x9d10, 0xd53a, 0x3f75, 0x775f, 0xaf21, 0xe70b,
            0x17cc, 0x5fe6, 0x8798, 0xcfb2, 0x6e07, 0x262d, 0xfe53, 0xb679, 0x46be, 0x0e94, 0xd6ea,
            0x9ec0, 0x9d91, 0xd5bb, 0x0dc5, 0x45ef, 0xb528, 0xfd02, 0x257c, 0x6d56, 0xcce3, 0x84c9,
            0x5cb7, 0x149d, 0xe45a, 0xac70, 0x740e, 0x3c24, 0x72ac, 0x3a86, 0xe2f8, 0xaad2, 0x5a15,
            0x123f, 0xca41, 0x826b, 0x23de, 0x6bf4, 0xb38a, 0xfba0, 0x0b67, 0x434d, 0x9b33, 0xd319,
            0xd048, 0x9862, 0x401c, 0x0836, 0xf8f1, 0xb0db, 0x68a5, 0x208f, 0x813a, 0xc910, 0x116e,
            0x5944, 0xa983, 0xe1a9, 0x39d7, 0x71fd, 0xa4c7, 0xeced, 0x3493, 0x7cb9, 0x8c7e, 0xc454,
            0x1c2a, 0x5400, 0xf5b5, 0xbd9f, 0x65e1, 0x2dcb, 0xdd0c, 0x9526, 0x4d58, 0x0572, 0x0623,
            0x4e09, 0x9677, 0xde5d, 0x2e9a, 0x66b0, 0xbece, 0xf6e4, 0x5751, 0x1f7b, 0xc705, 0x8f2f,
            0x7fe8, 0x37c2, 0xefbc, 0xa796, 0xe91e, 0xa134, 0x794a, 0x3160, 0xc1a7, 0x898d, 0x51f3,
            0x19d9, 0xb86c, 0xf046, 0x2838, 0x6012, 0x90d5, 0xd8ff, 0x0081, 0x48ab, 0x4bfa, 0x03d0,
            0xdbae, 0x9384, 0x6343, 0x2b69, 0xf317, 0xbb3d, 0x1a88, 0x52a2, 0x8adc, 0xc2f6, 0x3231,
            0x7a1b, 0xa265, 0xea4f,
        ],
        [
            0x0000, 0x8e10, 0x1431, 0x9a21, 0x2862, 0xa672, 0x3c53, 0xb243, 0x50c4, 0xded4, 0x44f5,
            0xcae5, 0x78a6, 0xf6b6, 0x6c97, 0xe287, 0xa188, 0x2f98, 0xb5b9, 0x3ba9, 0x89ea, 0x07fa,
            0x9ddb, 0x13cb, 0xf14c, 0x7f5c, 0xe57d, 0x6b6d, 0xd92e, 0x573e, 0xcd1f, 0x430f, 0x4b01,
            0xc511, 0x5f30, 0xd120, 0x6363, 0xed73, 0x7752, 0xf942, 0x1bc5, 0x95d5, 0x0ff4, 0x81e4,
            0x33a7, 0xbdb7, 0x2796, 0xa986, 0xea89, 0x6499, 0xfeb8, 0x70a8, 0xc2eb, 0x4cfb, 0xd6da,
            0x58ca, 0xba4d, 0x345d, 0xae7c, 0x206c, 0x922f, 0x1c3f, 0x861e, 0x080e, 0x9602, 0x1812,
            0x8233, 0x0c23, 0xbe60, 0x3070, 0xaa51, 0x2441, 0xc6c6, 0x48d6, 0xd2f7, 0x5ce7, 0xeea4,
            0x60b4, 0xfa95, 0x7485, 0x378a, 0xb99a, 0x23bb, 0xadab, 0x1fe8, 0x91f8, 0x0bd9, 0x85c9,
            0x674e, 0xe95e, 0x737f, 0xfd6f, 0x4f2c, 0xc13c, 0x5b1d, 0xd50d, 0xdd03, 0x5313, 0xc932,
            0x4722, 0xf561, 0x7b71, 0xe150, 0x6f40, 0x8dc7, 0x03d7, 0x99f6, 0x17e6, 0xa5a5, 0x2bb5,
            0xb194, 0x3f84, 0x7c8b, 0xf29b, 0x68ba, 0xe6aa, 0x54e9, 0xdaf9, 0x40d8, 0xcec8, 0x2c4f,
            0xa25f, 0x387e, 0xb66e, 0x042d, 0x8a3d, 0x101c, 0x9e0c, 0x2415, 0xaa05, 0x3024, 0xbe34,
            0x0c77, 0x8267, 0x1846, 0x9656, 0x74d1, 0xfac1, 0x60e0, 0xeef0, 0x5cb3, 0xd2a3, 0x4882,
            0xc692, 0x859d, 0x0b8d, 0x91ac, 0x1fbc, 0xadff, 0x23ef, 0xb9ce, 0x37de, 0xd559, 0x5b49,
            0xc168, 0x4f78, 0xfd3b, 0x732b, 0xe90a, 0x671a, 0x6f14, 0xe104, 0x7b25, 0xf535, 0x4776,
            0xc966, 0x5347, 0xdd57, 0x3fd0, 0xb1c0, 0x2be1, 0xa5f1, 0x17b2, 0x99a2, 0x0383, 0x8d93,
            0xce9c, 0x408c, 0xdaad, 0x54bd, 0xe6fe, 0x68ee, 0xf2cf, 0x7cdf, 0x9e58, 0x1048, 0x8a69,
            0x0479, 0xb63a, 0x382a, 0xa20b, 0x2c1b, 0xb217, 0x3c07, 0xa626, 0x2836, 0x9a75, 0x1465,
            0x8e44, 0x0054, 0xe2d3, 0x6cc3, 0xf6e2, 0x78f2, 0xcab1, 0x44a1, 0xde80, 0x5090, 0x139f,
            0x9d8f, 0x07ae, 0x89be, 0x3bfd, 0xb5ed, 0x2fcc, 0xa1dc, 0x435b, 0xcd4b, 0x576a, 0xd97a,
            0x6b39, 0xe529, 0x7f08, 0xf118, 0xf916, 0x7706, 0xed27, 0x6337, 0xd174, 0x5f64, 0xc545,
            0x4b55, 0xa9d2, 0x27c2, 0xbde3, 0x33f3, 0x81b0, 0x0fa0, 0x9581, 0x1b91, 0x589e, 0xd68e,
            0x4caf, 0xc2bf, 0x70fc, 0xfeec, 0x64cd, 0xeadd, 0x085a, 0x864a, 0x1c6b, 0x927b, 0x2038,
            0xae28, 0x3409, 0xba19,
        ],
    ];

    pub static CRC16_SPI_FUJITSU_TABLE: [[u16; 256]; 16] = [
        [
            0x0000, 0x1021, 0x2042, 0x3063, 0x4084, 0x50a5, 0x60c6, 0x70e7, 0x8108, 0x9129, 0xa14a,
            0xb16b, 0xc18c, 0xd1ad, 0xe1ce, 0xf1ef, 0x1231, 0x0210, 0x3273, 0x2252, 0x52b5, 0x4294,
            0x72f7, 0x62d6, 0x9339, 0x8318, 0xb37b, 0xa35a, 0xd3bd, 0xc39c, 0xf3ff, 0xe3de, 0x2462,
            0x3443, 0x0420, 0x1401, 0x64e6, 0x74c7, 0x44a4, 0x5485, 0xa56a, 0xb54b, 0x8528, 0x9509,
            0xe5ee, 0xf5cf, 0xc5ac, 0xd58d, 0x3653, 0x2672, 0x1611, 0x0630, 0x76d7, 0x66f6, 0x5695,
            0x46b4, 0xb75b, 0xa77a, 0x9719, 0x8738, 0xf7df, 0xe7fe, 0xd79d, 0xc7bc, 0x48c4, 0x58e5,
            0x6886, 0x78a7, 0x0840, 0x1861, 0x2802, 0x3823, 0xc9cc, 0xd9ed, 0xe98e, 0xf9af, 0x8948,
            0x9969, 0xa90a, 0xb92b, 0x5af5, 0x4ad4, 0x7ab7, 0x6a96, 0x1a71, 0x0a50, 0x3a33, 0x2a12,
            0xdbfd, 0xcbdc, 0xfbbf, 0xeb9e, 0x9b79, 0x8b58, 0xbb3b, 0xab1a, 0x6ca6, 0x7c87, 0x4ce4,
            0x5cc5, 0x2c22, 0x3c03, 0x0c60, 0x1c41, 0xedae, 0xfd8f, 0xcdec, 0xddcd, 0xad2a, 0xbd0b,
            0x8d68, 0x9d49, 0x7e97, 0x6eb6, 0x5ed5, 0x4ef4, 0x3e13, 0x2e32, 0x1e51, 0x0e70, 0xff9f,
            0xefbe, 0xdfdd, 0xcffc, 0xbf1b, 0xaf3a, 0x9f59, 0x8f78, 0x9188, 0x81a9, 0xb1ca, 0xa1eb,
            0xd10c, 0xc12d, 0xf14e, 0xe16f, 0x1080, 0x00a1, 0x30c2, 0x20e3, 0x5004, 0x4025, 0x7046,
            0x6067, 0x83b9, 0x9398, 0xa3fb, 0xb3da, 0xc33d, 0xd31c, 0xe37f, 0xf35e, 0x02b1, 0x1290,
            0x22f3, 0x32d2, 0x4235, 0x5214, 0x6277, 0x7256, 0xb5ea, 0xa5cb, 0x95a8, 0x8589, 0xf56e,
            0xe54f, 0xd52c, 0xc50d, 0x34e2, 0x24c3, 0x14a0, 0x0481, 0x7466, 0x6447, 0x5424, 0x4405,
            0xa7db, 0xb7fa, 0x8799, 0x97b8, 0xe75f, 0xf77e, 0xc71d, 0xd73c, 0x26d3, 0x36f2, 0x0691,
            0x16b0, 0x6657, 0x7676, 0x4615, 0x5634, 0xd94c, 0xc96d, 0xf90e, 0xe92f, 0x99c8, 0x89e9,
            0xb98a, 0xa9ab, 0x5844, 0x4865, 0x7806, 0x6827, 0x18c0, 0x08e1, 0x3882, 0x28a3, 0xcb7d,
            0xdb5c, 0xeb3f, 0xfb1e, 0x8bf9, 0x9bd8, 0xabbb, 0xbb9a, 0x4a75, 0x5a54, 0x6a37, 0x7a16,
            0x0af1, 0x1ad0, 0x2ab3, 0x3a92, 0xfd2e, 0xed0f, 0xdd6c, 0xcd4d, 0xbdaa, 0xad8b, 0x9de8,
            0x8dc9, 0x7c26, 0x6c07, 0x5c64, 0x4c45, 0x3ca2, 0x2c83, 0x1ce0, 0x0cc1, 0xef1f, 0xff3e,
            0xcf5d, 0xdf7c, 0xaf9b, 0xbfba, 0x8fd9, 0x9ff8, 0x6e17, 0x7e36, 0x4e55, 0x5e74, 0x2e93,
            0x3eb2, 0x0ed1, 0x1ef0,
        ],
        [
            0x0000, 0x3331, 0x6662, 0x5553, 0xccc4, 0xfff5, 0xaaa6, 0x9997, 0x89a9, 0xba98, 0xefcb,
            0xdcfa, 0x456d, 0x765c, 0x230f, 0x103e, 0x0373, 0x3042, 0x6511, 0x5620, 0xcfb7, 0xfc86,
            0xa9d5, 0x9ae4, 0x8ada, 0xb9eb, 0xecb8, 0xdf89, 0x461e, 0x752f, 0x207c, 0x134d, 0x06e6,
            0x35d7, 0x6084, 0x53b5, 0xca22, 0xf913, 0xac40, 0x9f71, 0x8f4f, 0xbc7e, 0xe92d, 0xda1c,
            0x438b, 0x70ba, 0x25e9, 0x16d8, 0x0595, 0x36a4, 0x63f7, 0x50c6, 0xc951, 0xfa60, 0xaf33,
            0x9c02, 0x8c3c, 0xbf0d, 0xea5e, 0xd96f, 0x40f8, 0x73c9, 0x269a, 0x15ab, 0x0dcc, 0x3efd,
            0x6bae, 0x589f, 0xc108, 0xf239, 0xa76a, 0x945b, 0x8465, 0xb754, 0xe207, 0xd136, 0x48a1,
            0x7b90, 0x2ec3, 0x1df2, 0x0ebf, 0x3d8e, 0x68dd, 0x5bec, 0xc27b, 0xf14a, 0xa419, 0x9728,
            0x8716, 0xb427, 0xe174, 0xd245, 0x4bd2, 0x78e3, 0x2db0, 0x1e81, 0x0b2a, 0x381b, 0x6d48,
            0x5e79, 0xc7ee, 0xf4df, 0xa18c, 0x92bd, 0x8283, 0xb1b2, 0xe4e1, 0xd7d0, 0x4e47, 0x7d76,
            0x2825, 0x1b14, 0x0859, 0x3b68, 0x6e3b, 0x5d0a, 0xc49d, 0xf7ac, 0xa2ff, 0x91ce, 0x81f0,
            0xb2c1, 0xe792, 0xd4a3, 0x4d34, 0x7e05, 0x2b56, 0x1867, 0x1b98, 0x28a9, 0x7dfa, 0x4ecb,
            0xd75c, 0xe46d, 0xb13e, 0x820f, 0x9231, 0xa100, 0xf453, 0xc762, 0x5ef5, 0x6dc4, 0x3897,
            0x0ba6, 0x18eb, 0x2bda, 0x7e89, 0x4db8, 0xd42f, 0xe71e, 0xb24d, 0x817c, 0x9142, 0xa273,
            0xf720, 0xc411, 0x5d86, 0x6eb7, 0x3be4, 0x08d5, 0x1d7e, 0x2e4f, 0x7b1c, 0x482d, 0xd1ba,
            0xe28b, 0xb7d8, 0x84e9, 0x94d7, 0xa7e6, 0xf2b5, 0xc184, 0x5813, 0x6b22, 0x3e71, 0x0d40,
            0x1e0d, 0x2d3c, 0x786f, 0x4b5e, 0xd2c9, 0xe1f8, 0xb4ab, 0x879a, 0x97a4, 0xa495, 0xf1c6,
            0xc2f7, 0x5b60, 0x6851, 0x3d02, 0x0e33, 0x1654, 0x2565, 0x7036, 0x4307, 0xda90, 0xe9a1,
            0xbcf2, 0x8fc3, 0x9ffd, 0xaccc, 0xf99f, 0xcaae, 0x5339, 0x6008, 0x355b, 0x066a, 0x1527,
            0x2616, 0x7345, 0x4074, 0xd9e3, 0xead2, 0xbf81, 0x8cb0, 0x9c8e, 0xafbf, 0xfaec, 0xc9dd,
            0x504a, 0x637b, 0x3628, 0x0519, 0x10b2, 0x2383, 0x76d0, 0x45e1, 0xdc76, 0xef47, 0xba14,
            0x8925, 0x991b, 0xaa2a, 0xff79, 0xcc48, 0x55df, 0x66ee, 0x33bd, 0x008c, 0x13c1, 0x20f0,
            0x75a3, 0x4692, 0xdf05, 0xec34, 0xb967, 0x8a56, 0x9a68, 0xa959, 0xfc0a, 0xcf3b, 0x56ac,
            0x659d, 0x30ce, 0x03ff,
        ],
        [
            0x0000, 0x3730, 0x6e60, 0x5950, 0xdcc0, 0xebf0, 0xb2a0, 0x8590, 0xa9a1, 0x9e91, 0xc7c1,
            0xf0f1, 0x7561, 0x4251, 0x1b01, 0x2c31, 0x4363, 0x7453, 0x2d03, 0x1a33, 0x9fa3, 0xa893,
            0xf1c3, 0xc6f3, 0xeac2, 0xddf2, 0x84a2, 0xb392, 0x3602, 0x0132, 0x5862, 0x6f52, 0x86c6,
            0xb1f6, 0xe8a6, 0xdf96, 0x5a06, 0x6d36, 0x3466, 0x0356, 0x2f67, 0x1857, 0x4107, 0x7637,
            0xf3a7, 0xc497, 0x9dc7, 0xaaf7, 0xc5a5, 0xf295, 0xabc5, 0x9cf5, 0x1965, 0x2e55, 0x7705,
            0x4035, 0x6c04, 0x5b34, 0x0264, 0x3554, 0xb0c4, 0x87f4, 0xdea4, 0xe994, 0x1dad, 0x2a9d,
            0x73cd, 0x44fd, 0xc16d, 0xf65d, 0xaf0d, 0x983d, 0xb40c, 0x833c, 0xda6c, 0xed5c, 0x68cc,
            0x5ffc, 0x06ac, 0x319c, 0x5ece, 0x69fe, 0x30ae, 0x079e, 0x820e, 0xb53e, 0xec6e, 0xdb5e,
            0xf76f, 0xc05f, 0x990f, 0xae3f, 0x2baf, 0x1c9f, 0x45cf, 0x72ff, 0x9b6b, 0xac5b, 0xf50b,
            0xc23b, 0x47ab, 0x709b, 0x29cb, 0x1efb, 0x32ca, 0x05fa, 0x5caa, 0x6b9a, 0xee0a, 0xd93a,
            0x806a, 0xb75a, 0xd808, 0xef38, 0xb668, 0x8158, 0x04c8, 0x33f8, 0x6aa8, 0x5d98, 0x71a9,
            0x4699, 0x1fc9, 0x28f9, 0xad69, 0x9a59, 0xc309, 0xf439, 0x3b5a, 0x0c6a, 0x553a, 0x620a,
            0xe79a, 0xd0aa, 0x89fa, 0xbeca, 0x92fb, 0xa5cb, 0xfc9b, 0xcbab, 0x4e3b, 0x790b, 0x205b,
            0x176b, 0x7839, 0x4f09, 0x1659, 0x2169, 0xa4f9, 0x93c9, 0xca99, 0xfda9, 0xd198, 0xe6a8,
            0xbff8, 0x88c8, 0x0d58, 0x3a68, 0x6338, 0x5408, 0xbd9c, 0x8aac, 0xd3fc, 0xe4cc, 0x615c,
            0x566c, 0x0f3c, 0x380c, 0x143d, 0x230d, 0x7a5d, 0x4d6d, 0xc8fd, 0xffcd, 0xa69d, 0x91ad,
            0xfeff, 0xc9cf, 0x909f, 0xa7af, 0x223f, 0x150f, 0x4c5f, 0x7b6f, 0x575e, 0x606e, 0x393e,
            0x0e0e, 0x8b9e, 0xbcae, 0xe5fe, 0xd2ce, 0x26f7, 0x11c7, 0x4897, 0x7fa7, 0xfa37, 0xcd07,
            0x9457, 0xa367, 0x8f56, 0xb866, 0xe136, 0xd606, 0x5396, 0x64a6, 0x3df6, 0x0ac6, 0x6594,
            0x52a4, 0x0bf4, 0x3cc4, 0xb954, 0x8e64, 0xd734, 0xe004, 0xcc35, 0xfb05, 0xa255, 0x9565,
            0x10f5, 0x27c5, 0x7e95, 0x49a5, 0xa031, 0x9701, 0xce51, 0xf961, 0x7cf1, 0x4bc1, 0x1291,
            0x25a1, 0x0990, 0x3ea0, 0x67f0, 0x50c0, 0xd550, 0xe260, 0xbb30, 0x8c00, 0xe352, 0xd462,
            0x8d32, 0xba02, 0x3f92, 0x08a2, 0x51f2, 0x66c2, 0x4af3, 0x7dc3, 0x2493, 0x13a3, 0x9633,
            0xa103, 0xf853, 0xcf63,
        ],
        [
            0x0000, 0x76b4, 0xed68, 0x9bdc, 0xcaf1, 0xbc45, 0x2799, 0x512d, 0x85c3, 0xf377, 0x68ab,
            0x1e1f, 0x4f32, 0x3986, 0xa25a, 0xd4ee, 0x1ba7, 0x6d13, 0xf6cf, 0x807b, 0xd156, 0xa7e2,
            0x3c3e, 0x4a8a, 0x9e64, 0xe8d0, 0x730c, 0x05b8, 0x5495, 0x2221, 0xb9fd, 0xcf49, 0x374e,
            0x41fa, 0xda26, 0xac92, 0xfdbf, 0x8b0b, 0x10d7, 0x6663, 0xb28d, 0xc439, 0x5fe5, 0x2951,
            0x787c, 0x0ec8, 0x9514, 0xe3a0, 0x2ce9, 0x5a5d, 0xc181, 0xb735, 0xe618, 0x90ac, 0x0b70,
            0x7dc4, 0xa92a, 0xdf9e, 0x4442, 0x32f6, 0x63db, 0x156f, 0x8eb3, 0xf807, 0x6e9c, 0x1828,
            0x83f4, 0xf540, 0xa46d, 0xd2d9, 0x4905, 0x3fb1, 0xeb5f, 0x9deb, 0x0637, 0x7083, 0x21ae,
            0x571a, 0xccc6, 0xba72, 0x753b, 0x038f, 0x9853, 0xeee7, 0xbfca, 0xc97e, 0x52a2, 0x2416,
            0xf0f8, 0x864c, 0x1d90, 0x6b24, 0x3a09, 0x4cbd, 0xd761, 0xa1d5, 0x59d2, 0x2f66, 0xb4ba,
            0xc20e, 0x9323, 0xe597, 0x7e4b, 0x08ff, 0xdc11, 0xaaa5, 0x3179, 0x47cd, 0x16e0, 0x6054,
            0xfb88, 0x8d3c, 0x4275, 0x34c1, 0xaf1d, 0xd9a9, 0x8884, 0xfe30, 0x65ec, 0x1358, 0xc7b6,
            0xb102, 0x2ade, 0x5c6a, 0x0d47, 0x7bf3, 0xe02f, 0x969b, 0xdd38, 0xab8c, 0x3050, 0x46e4,
            0x17c9, 0x617d, 0xfaa1, 0x8c15, 0x58fb, 0x2e4f, 0xb593, 0xc327, 0x920a, 0xe4be, 0x7f62,
            0x09d6, 0xc69f, 0xb02b, 0x2bf7, 0x5d43, 0x0c6e, 0x7ada, 0xe106, 0x97b2, 0x435c, 0x35e8,
            0xae34, 0xd880, 0x89ad, 0xff19, 0x64c5, 0x1271, 0xea76, 0x9cc2, 0x071e, 0x71aa, 0x2087,
            0x5633, 0xcdef, 0xbb5b, 0x6fb5, 0x1901, 0x82dd, 0xf469, 0xa544, 0xd3f0, 0x482c, 0x3e98,
            0xf1d1, 0x8765, 0x1cb9, 0x6a0d, 0x3b20, 0x4d94, 0xd648, 0xa0fc, 0x7412, 0x02a6, 0x997a,
            0xefce, 0xbee3, 0xc857, 0x538b, 0x253f, 0xb3a4, 0xc510, 0x5ecc, 0x2878, 0x7955, 0x0fe1,
            0x943d, 0xe289, 0x3667, 0x40d3, 0xdb0f, 0xadbb, 0xfc96, 0x8a22, 0x11fe, 0x674a, 0xa803,
            0xdeb7, 0x456b, 0x33df, 0x62f2, 0x1446, 0x8f9a, 0xf92e, 0x2dc0, 0x5b74, 0xc0a8, 0xb61c,
            0xe731, 0x9185, 0x0a59, 0x7ced, 0x84ea, 0xf25e, 0x6982, 0x1f36, 0x4e1b, 0x38af, 0xa373,
            0xd5c7, 0x0129, 0x779d, 0xec41, 0x9af5, 0xcbd8, 0xbd6c, 0x26b0, 0x5004, 0x9f4d, 0xe9f9,
            0x7225, 0x0491, 0x55bc, 0x2308, 0xb8d4, 0xce60, 0x1a8e, 0x6c3a, 0xf7e6, 0x8152, 0xd07f,
            0xa6cb, 0x3d17, 0x4ba3,
        ],
        [
            0x0000, 0xaa51, 0x4483, 0xeed2, 0x8906, 0x2357, 0xcd85, 0x67d4, 0x022d, 0xa87c, 0x46ae,
            0xecff, 0x8b2b, 0x217a, 0xcfa8, 0x65f9, 0x045a, 0xae0b, 0x40d9, 0xea88, 0x8d5c, 0x270d,
            0xc9df, 0x638e, 0x0677, 0xac26, 0x42f4, 0xe8a5, 0x8f71, 0x2520, 0xcbf2, 0x61a3, 0x08b4,
            0xa2e5, 0x4c37, 0xe666, 0x81b2, 0x2be3, 0xc531, 0x6f60, 0x0a99, 0xa0c8, 0x4e1a, 0xe44b,
            0x839f, 0x29ce, 0xc71c, 0x6d4d, 0x0cee, 0xa6bf, 0x486d, 0xe23c, 0x85e8, 0x2fb9, 0xc16b,
            0x6b3a, 0x0ec3, 0xa492, 0x4a40, 0xe011, 0x87c5, 0x2d94, 0xc346, 0x6917, 0x1168, 0xbb39,
            0x55eb, 0xffba, 0x986e, 0x323f, 0xdced, 0x76bc, 0x1345, 0xb914, 0x57c6, 0xfd97, 0x9a43,
            0x3012, 0xdec0, 0x7491, 0x1532, 0xbf63, 0x51b1, 0xfbe0, 0x9c34, 0x3665, 0xd8b7, 0x72e6,
            0x171f, 0xbd4e, 0x539c, 0xf9cd, 0x9e19, 0x3448, 0xda9a, 0x70cb, 0x19dc, 0xb38d, 0x5d5f,
            0xf70e, 0x90da, 0x3a8b, 0xd459, 0x7e08, 0x1bf1, 0xb1a0, 0x5f72, 0xf523, 0x92f7, 0x38a6,
            0xd674, 0x7c25, 0x1d86, 0xb7d7, 0x5905, 0xf354, 0x9480, 0x3ed1, 0xd003, 0x7a52, 0x1fab,
            0xb5fa, 0x5b28, 0xf179, 0x96ad, 0x3cfc, 0xd22e, 0x787f, 0x22d0, 0x8881, 0x6653, 0xcc02,
            0xabd6, 0x0187, 0xef55, 0x4504, 0x20fd, 0x8aac, 0x647e, 0xce2f, 0xa9fb, 0x03aa, 0xed78,
            0x4729, 0x268a, 0x8cdb, 0x6209, 0xc858, 0xaf8c, 0x05dd, 0xeb0f, 0x415e, 0x24a7, 0x8ef6,
            0x6024, 0xca75, 0xada1, 0x07f0, 0xe922, 0x4373, 0x2a64, 0x8035, 0x6ee7, 0xc4b6, 0xa362,
            0x0933, 0xe7e1, 0x4db0, 0x2849, 0x8218, 0x6cca, 0xc69b, 0xa14f, 0x0b1e, 0xe5cc, 0x4f9d,
            0x2e3e, 0x846f, 0x6abd, 0xc0ec, 0xa738, 0x0d69, 0xe3bb, 0x49ea, 0x2c13, 0x8642, 0x6890,
            0xc2c1, 0xa515, 0x0f44, 0xe196, 0x4bc7, 0x33b8, 0x99e9, 0x773b, 0xdd6a, 0xbabe, 0x10ef,
            0xfe3d, 0x546c, 0x3195, 0x9bc4, 0x7516, 0xdf47, 0xb893, 0x12c2, 0xfc10, 0x5641, 0x37e2,
            0x9db3, 0x7361, 0xd930, 0xbee4, 0x14b5, 0xfa67, 0x5036, 0x35cf, 0x9f9e, 0x714c, 0xdb1d,
            0xbcc9, 0x1698, 0xf84a, 0x521b, 0x3b0c, 0x915d, 0x7f8f, 0xd5de, 0xb20a, 0x185b, 0xf689,
            0x5cd8, 0x3921, 0x9370, 0x7da2, 0xd7f3, 0xb027, 0x1a76, 0xf4a4, 0x5ef5, 0x3f56, 0x9507,
            0x7bd5, 0xd184, 0xb650, 0x1c01, 0xf2d3, 0x5882, 0x3d7b, 0x972a, 0x79f8, 0xd3a9, 0xb47d,
            0x1e2c, 0xf0fe, 0x5aaf,
        ],
        [
            0x0000, 0x45a0, 0x8b40, 0xcee0, 0x06a1, 0x4301, 0x8de1, 0xc841, 0x0d42, 0x48e2, 0x8602,
            0xc3a2, 0x0be3, 0x4e43, 0x80a3, 0xc503, 0x1a84, 0x5f24, 0x91c4, 0xd464, 0x1c25, 0x5985,
            0x9765, 0xd2c5, 0x17c6, 0x5266, 0x9c86, 0xd926, 0x1167, 0x54c7, 0x9a27, 0xdf87, 0x3508,
            0x70a8, 0xbe48, 0xfbe8, 0x33a9, 0x7609, 0xb8e9, 0xfd49, 0x384a, 0x7dea, 0xb30a, 0xf6aa,
            0x3eeb, 0x7b4b, 0xb5ab, 0xf00b, 0x2f8c, 0x6a2c, 0xa4cc, 0xe16c, 0x292d, 0x6c8d, 0xa26d,
            0xe7cd, 0x22ce, 0x676e, 0xa98e, 0xec2e, 0x246f, 0x61cf, 0xaf2f, 0xea8f, 0x6a10, 0x2fb0,
            0xe150, 0xa4f0, 0x6cb1, 0x2911, 0xe7f1, 0xa251, 0x6752, 0x22f2, 0xec12, 0xa9b2, 0x61f3,
            0x2453, 0xeab3, 0xaf13, 0x7094, 0x3534, 0xfbd4, 0xbe74, 0x7635, 0x3395, 0xfd75, 0xb8d5,
            0x7dd6, 0x3876, 0xf696, 0xb336, 0x7b77, 0x3ed7, 0xf037, 0xb597, 0x5f18, 0x1ab8, 0xd458,
            0x91f8, 0x59b9, 0x1c19, 0xd2f9, 0x9759, 0x525a, 0x17fa, 0xd91a, 0x9cba, 0x54fb, 0x115b,
            0xdfbb, 0x9a1b, 0x459c, 0x003c, 0xcedc, 0x8b7c, 0x433d, 0x069d, 0xc87d, 0x8ddd, 0x48de,
            0x0d7e, 0xc39e, 0x863e, 0x4e7f, 0x0bdf, 0xc53f, 0x809f, 0xd420, 0x9180, 0x5f60, 0x1ac0,
            0xd281, 0x9721, 0x59c1, 0x1c61, 0xd962, 0x9cc2, 0x5222, 0x1782, 0xdfc3, 0x9a63, 0x5483,
            0x1123, 0xcea4, 0x8b04, 0x45e4, 0x0044, 0xc805, 0x8da5, 0x4345, 0x06e5, 0xc3e6, 0x8646,
            0x48a6, 0x0d06, 0xc547, 0x80e7, 0x4e07, 0x0ba7, 0xe128, 0xa488, 0x6a68, 0x2fc8, 0xe789,
            0xa229, 0x6cc9, 0x2969, 0xec6a, 0xa9ca, 0x672a, 0x228a, 0xeacb, 0xaf6b, 0x618b, 0x242b,
            0xfbac, 0xbe0c, 0x70ec, 0x354c, 0xfd0d, 0xb8ad, 0x764d, 0x33ed, 0xf6ee, 0xb34e, 0x7dae,
            0x380e, 0xf04f, 0xb5ef, 0x7b0f, 0x3eaf, 0xbe30, 0xfb90, 0x3570, 0x70d0, 0xb891, 0xfd31,
            0x33d1, 0x7671, 0xb372, 0xf6d2, 0x3832, 0x7d92, 0xb5d3, 0xf073, 0x3e93, 0x7b33, 0xa4b4,
            0xe114, 0x2ff4, 0x6a54, 0xa215, 0xe7b5, 0x2955, 0x6cf5, 0xa9f6, 0xec56, 0x22b6, 0x6716,
            0xaf57, 0xeaf7, 0x2417, 0x61b7, 0x8b38, 0xce98, 0x0078, 0x45d8, 0x8d99, 0xc839, 0x06d9,
            0x4379, 0x867a, 0xc3da, 0x0d3a, 0x489a, 0x80db, 0xc57b, 0x0b9b, 0x4e3b, 0x91bc, 0xd41c,
            0x1afc, 0x5f5c, 0x971d, 0xd2bd, 0x1c5d, 0x59fd, 0x9cfe, 0xd95e, 0x17be, 0x521e, 0x9a5f,
            0xdfff, 0x111f, 0x54bf,
        ],
        [
            0x0000, 0xb861, 0x60e3, 0xd882, 0xc1c6, 0x79a7, 0xa125, 0x1944, 0x93ad, 0x2bcc, 0xf34e,
            0x4b2f, 0x526b, 0xea0a, 0x3288, 0x8ae9, 0x377b, 0x8f1a, 0x5798, 0xeff9, 0xf6bd, 0x4edc,
            0x965e, 0x2e3f, 0xa4d6, 0x1cb7, 0xc435, 0x7c54, 0x6510, 0xdd71, 0x05f3, 0xbd92, 0x6ef6,
            0xd697, 0x0e15, 0xb674, 0xaf30, 0x1751, 0xcfd3, 0x77b2, 0xfd5b, 0x453a, 0x9db8, 0x25d9,
            0x3c9d, 0x84fc, 0x5c7e, 0xe41f, 0x598d, 0xe1ec, 0x396e, 0x810f, 0x984b, 0x202a, 0xf8a8,
            0x40c9, 0xca20, 0x7241, 0xaac3, 0x12a2, 0x0be6, 0xb387, 0x6b05, 0xd364, 0xddec, 0x658d,
            0xbd0f, 0x056e, 0x1c2a, 0xa44b, 0x7cc9, 0xc4a8, 0x4e41, 0xf620, 0x2ea2, 0x96c3, 0x8f87,
            0x37e6, 0xef64, 0x5705, 0xea97, 0x52f6, 0x8a74, 0x3215, 0x2b51, 0x9330, 0x4bb2, 0xf3d3,
            0x793a, 0xc15b, 0x19d9, 0xa1b8, 0xb8fc, 0x009d, 0xd81f, 0x607e, 0xb31a, 0x0b7b, 0xd3f9,
            0x6b98, 0x72dc, 0xcabd, 0x123f, 0xaa5e, 0x20b7, 0x98d6, 0x4054, 0xf835, 0xe171, 0x5910,
            0x8192, 0x39f3, 0x8461, 0x3c00, 0xe482, 0x5ce3, 0x45a7, 0xfdc6, 0x2544, 0x9d25, 0x17cc,
            0xafad, 0x772f, 0xcf4e, 0xd60a, 0x6e6b, 0xb6e9, 0x0e88, 0xabf9, 0x1398, 0xcb1a, 0x737b,
            0x6a3f, 0xd25e, 0x0adc, 0xb2bd, 0x3854, 0x8035, 0x58b7, 0xe0d6, 0xf992, 0x41f3, 0x9971,
            0x2110, 0x9c82, 0x24e3, 0xfc61, 0x4400, 0x5d44, 0xe525, 0x3da7, 0x85c6, 0x0f2f, 0xb74e,
            0x6fcc, 0xd7ad, 0xcee9, 0x7688, 0xae0a, 0x166b, 0xc50f, 0x7d6e, 0xa5ec, 0x1d8d, 0x04c9,
            0xbca8, 0x642a, 0xdc4b, 0x56a2, 0xeec3, 0x3641, 0x8e20, 0x9764, 0x2f05, 0xf787, 0x4fe6,
            0xf274, 0x4a15, 0x9297, 0x2af6, 0x33b2, 0x8bd3, 0x5351, 0xeb30, 0x61d9, 0xd9b8, 0x013a,
            0xb95b, 0xa01f, 0x187e, 0xc0fc, 0x789d, 0x7615, 0xce74, 0x16f6, 0xae97, 0xb7d3, 0x0fb2,
            0xd730, 0x6f51, 0xe5b8, 0x5dd9, 0x855b, 0x3d3a, 0x247e, 0x9c1f, 0x449d, 0xfcfc, 0x416e,
            0xf90f, 0x218d, 0x99ec, 0x80a8, 0x38c9, 0xe04b, 0x582a, 0xd2c3, 0x6aa2, 0xb220, 0x0a41,
            0x1305, 0xab64, 0x73e6, 0xcb87, 0x18e3, 0xa082, 0x7800, 0xc061, 0xd925, 0x6144, 0xb9c6,
            0x01a7, 0x8b4e, 0x332f, 0xebad, 0x53cc, 0x4a88, 0xf2e9, 0x2a6b, 0x920a, 0x2f98, 0x97f9,
            0x4f7b, 0xf71a, 0xee5e, 0x563f, 0x8ebd, 0x36dc, 0xbc35, 0x0454, 0xdcd6, 0x64b7, 0x7df3,
            0xc592, 0x1d10, 0xa571,
        ],
        [
            0x0000, 0x47d3, 0x8fa6, 0xc875, 0x0f6d, 0x48be, 0x80cb, 0xc718, 0x1eda, 0x5909, 0x917c,
            0xd6af, 0x11b7, 0x5664, 0x9e11, 0xd9c2, 0x3db4, 0x7a67, 0xb212, 0xf5c1, 0x32d9, 0x750a,
            0xbd7f, 0xfaac, 0x236e, 0x64bd, 0xacc8, 0xeb1b, 0x2c03, 0x6bd0, 0xa3a5, 0xe476, 0x7b68,
            0x3cbb, 0xf4ce, 0xb31d, 0x7405, 0x33d6, 0xfba3, 0xbc70, 0x65b2, 0x2261, 0xea14, 0xadc7,
            0x6adf, 0x2d0c, 0xe579, 0xa2aa, 0x46dc, 0x010f, 0xc97a, 0x8ea9, 0x49b1, 0x0e62, 0xc617,
            0x81c4, 0x5806, 0x1fd5, 0xd7a0, 0x9073, 0x576b, 0x10b8, 0xd8cd, 0x9f1e, 0xf6d0, 0xb103,
            0x7976, 0x3ea5, 0xf9bd, 0xbe6e, 0x761b, 0x31c8, 0xe80a, 0xafd9, 0x67ac, 0x207f, 0xe767,
            0xa0b4, 0x68c1, 0x2f12, 0xcb64, 0x8cb7, 0x44c2, 0x0311, 0xc409, 0x83da, 0x4baf, 0x0c7c,
            0xd5be, 0x926d, 0x5a18, 0x1dcb, 0xdad3, 0x9d00, 0x5575, 0x12a6, 0x8db8, 0xca6b, 0x021e,
            0x45cd, 0x82d5, 0xc506, 0x0d73, 0x4aa0, 0x9362, 0xd4b1, 0x1cc4, 0x5b17, 0x9c0f, 0xdbdc,
            0x13a9, 0x547a, 0xb00c, 0xf7df, 0x3faa, 0x7879, 0xbf61, 0xf8b2, 0x30c7, 0x7714, 0xaed6,
            0xe905, 0x2170, 0x66a3, 0xa1bb, 0xe668, 0x2e1d, 0x69ce, 0xfd81, 0xba52, 0x7227, 0x35f4,
            0xf2ec, 0xb53f, 0x7d4a, 0x3a99, 0xe35b, 0xa488, 0x6cfd, 0x2b2e, 0xec36, 0xabe5, 0x6390,
            0x2443, 0xc035, 0x87e6, 0x4f93, 0x0840, 0xcf58, 0x888b, 0x40fe, 0x072d, 0xdeef, 0x993c,
            0x5149, 0x169a, 0xd182, 0x9651, 0x5e24, 0x19f7, 0x86e9, 0xc13a, 0x094f, 0x4e9c, 0x8984,
            0xce57, 0x0622, 0x41f1, 0x9833, 0xdfe0, 0x1795, 0x5046, 0x975e, 0xd08d, 0x18f8, 0x5f2b,
            0xbb5d, 0xfc8e, 0x34fb, 0x7328, 0xb430, 0xf3e3, 0x3b96, 0x7c45, 0xa587, 0xe254, 0x2a21,
            0x6df2, 0xaaea, 0xed39, 0x254c, 0x629f, 0x0b51, 0x4c82, 0x84f7, 0xc324, 0x043c, 0x43ef,
            0x8b9a, 0xcc49, 0x158b, 0x5258, 0x9a2d, 0xddfe, 0x1ae6, 0x5d35, 0x9540, 0xd293, 0x36e5,
            0x7136, 0xb943, 0xfe90, 0x3988, 0x7e5b, 0xb62e, 0xf1fd, 0x283f, 0x6fec, 0xa799, 0xe04a,
            0x2752, 0x6081, 0xa8f4, 0xef27, 0x7039, 0x37ea, 0xff9f, 0xb84c, 0x7f54, 0x3887, 0xf0f2,
            0xb721, 0x6ee3, 0x2930, 0xe145, 0xa696, 0x618e, 0x265d, 0xee28, 0xa9fb, 0x4d8d, 0x0a5e,
            0xc22b, 0x85f8, 0x42e0, 0x0533, 0xcd46, 0x8a95, 0x5357, 0x1484, 0xdcf1, 0x9b22, 0x5c3a,
            0x1be9, 0xd39c, 0x944f,
        ],
        [
            0x0000, 0xeb23, 0xc667, 0x2d44, 0x9cef, 0x77cc, 0x5a88, 0xb1ab, 0x29ff, 0xc2dc, 0xef98,
            0x04bb, 0xb510, 0x5e33, 0x7377, 0x9854, 0x53fe, 0xb8dd, 0x9599, 0x7eba, 0xcf11, 0x2432,
            0x0976, 0xe255, 0x7a01, 0x9122, 0xbc66, 0x5745, 0xe6ee, 0x0dcd, 0x2089, 0xcbaa, 0xa7fc,
            0x4cdf, 0x619b, 0x8ab8, 0x3b13, 0xd030, 0xfd74, 0x1657, 0x8e03, 0x6520, 0x4864, 0xa347,
            0x12ec, 0xf9cf, 0xd48b, 0x3fa8, 0xf402, 0x1f21, 0x3265, 0xd946, 0x68ed, 0x83ce, 0xae8a,
            0x45a9, 0xddfd, 0x36de, 0x1b9a, 0xf0b9, 0x4112, 0xaa31, 0x8775, 0x6c56, 0x5fd9, 0xb4fa,
            0x99be, 0x729d, 0xc336, 0x2815, 0x0551, 0xee72, 0x7626, 0x9d05, 0xb041, 0x5b62, 0xeac9,
            0x01ea, 0x2cae, 0xc78d, 0x0c27, 0xe704, 0xca40, 0x2163, 0x90c8, 0x7beb, 0x56af, 0xbd8c,
            0x25d8, 0xcefb, 0xe3bf, 0x089c, 0xb937, 0x5214, 0x7f50, 0x9473, 0xf825, 0x1306, 0x3e42,
            0xd561, 0x64ca, 0x8fe9, 0xa2ad, 0x498e, 0xd1da, 0x3af9, 0x17bd, 0xfc9e, 0x4d35, 0xa616,
            0x8b52, 0x6071, 0xabdb, 0x40f8, 0x6dbc, 0x869f, 0x3734, 0xdc17, 0xf153, 0x1a70, 0x8224,
            0x6907, 0x4443, 0xaf60, 0x1ecb, 0xf5e8, 0xd8ac, 0x338f, 0xbfb2, 0x5491, 0x79d5, 0x92f6,
            0x235d, 0xc87e, 0xe53a, 0x0e19, 0x964d, 0x7d6e, 0x502a, 0xbb09, 0x0aa2, 0xe181, 0xccc5,
            0x27e6, 0xec4c, 0x076f, 0x2a2b, 0xc108, 0x70a3, 0x9b80, 0xb6c4, 0x5de7, 0xc5b3, 0x2e90,
            0x03d4, 0xe8f7, 0x595c, 0xb27f, 0x9f3b, 0x7418, 0x184e, 0xf36d, 0xde29, 0x350a, 0x84a1,
            0x6f82, 0x42c6, 0xa9e5, 0x31b1, 0xda92, 0xf7d6, 0x1cf5, 0xad5e, 0x467d, 0x6b39, 0x801a,
            0x4bb0, 0xa093, 0x8dd7, 0x66f4, 0xd75f, 0x3c7c, 0x1138, 0xfa1b, 0x624f, 0x896c, 0xa428,
            0x4f0b, 0xfea0, 0x1583, 0x38c7, 0xd3e4, 0xe06b, 0x0b48, 0x260c, 0xcd2f, 0x7c84, 0x97a7,
            0xbae3, 0x51c0, 0xc994, 0x22b7, 0x0ff3, 0xe4d0, 0x557b, 0xbe58, 0x931c, 0x783f, 0xb395,
            0x58b6, 0x75f2, 0x9ed1, 0x2f7a, 0xc459, 0xe91d, 0x023e, 0x9a6a, 0x7149, 0x5c0d, 0xb72e,
            0x0685, 0xeda6, 0xc0e2, 0x2bc1, 0x4797, 0xacb4, 0x81f0, 0x6ad3, 0xdb78, 0x305b, 0x1d1f,
            0xf63c, 0x6e68, 0x854b, 0xa80f, 0x432c, 0xf287, 0x19a4, 0x34e0, 0xdfc3, 0x1469, 0xff4a,
            0xd20e, 0x392d, 0x8886, 0x63a5, 0x4ee1, 0xa5c2, 0x3d96, 0xd6b5, 0xfbf1, 0x10d2, 0xa179,
            0x4a5a, 0x671e, 0x8c3d,
        ],
        [
            0x0000, 0x6f45, 0xde8a, 0xb1cf, 0xad35, 0xc270, 0x73bf, 0x1cfa, 0x4a4b, 0x250e, 0x94c1,
            0xfb84, 0xe77e, 0x883b, 0x39f4, 0x56b1, 0x9496, 0xfbd3, 0x4a1c, 0x2559, 0x39a3, 0x56e6,
            0xe729, 0x886c, 0xdedd, 0xb198, 0x0057, 0x6f12, 0x73e8, 0x1cad, 0xad62, 0xc227, 0x390d,
            0x5648, 0xe787, 0x88c2, 0x9438, 0xfb7d, 0x4ab2, 0x25f7, 0x7346, 0x1c03, 0xadcc, 0xc289,
            0xde73, 0xb136, 0x00f9, 0x6fbc, 0xad9b, 0xc2de, 0x7311, 0x1c54, 0x00ae, 0x6feb, 0xde24,
            0xb161, 0xe7d0, 0x8895, 0x395a, 0x561f, 0x4ae5, 0x25a0, 0x946f, 0xfb2a, 0x721a, 0x1d5f,
            0xac90, 0xc3d5, 0xdf2f, 0xb06a, 0x01a5, 0x6ee0, 0x3851, 0x5714, 0xe6db, 0x899e, 0x9564,
            0xfa21, 0x4bee, 0x24ab, 0xe68c, 0x89c9, 0x3806, 0x5743, 0x4bb9, 0x24fc, 0x9533, 0xfa76,
            0xacc7, 0xc382, 0x724d, 0x1d08, 0x01f2, 0x6eb7, 0xdf78, 0xb03d, 0x4b17, 0x2452, 0x959d,
            0xfad8, 0xe622, 0x8967, 0x38a8, 0x57ed, 0x015c, 0x6e19, 0xdfd6, 0xb093, 0xac69, 0xc32c,
            0x72e3, 0x1da6, 0xdf81, 0xb0c4, 0x010b, 0x6e4e, 0x72b4, 0x1df1, 0xac3e, 0xc37b, 0x95ca,
            0xfa8f, 0x4b40, 0x2405, 0x38ff, 0x57ba, 0xe675, 0x8930, 0xe434, 0x8b71, 0x3abe, 0x55fb,
            0x4901, 0x2644, 0x978b, 0xf8ce, 0xae7f, 0xc13a, 0x70f5, 0x1fb0, 0x034a, 0x6c0f, 0xddc0,
            0xb285, 0x70a2, 0x1fe7, 0xae28, 0xc16d, 0xdd97, 0xb2d2, 0x031d, 0x6c58, 0x3ae9, 0x55ac,
            0xe463, 0x8b26, 0x97dc, 0xf899, 0x4956, 0x2613, 0xdd39, 0xb27c, 0x03b3, 0x6cf6, 0x700c,
            0x1f49, 0xae86, 0xc1c3, 0x9772, 0xf837, 0x49f8, 0x26bd, 0x3a47, 0x5502, 0xe4cd, 0x8b88,
            0x49af, 0x26ea, 0x9725, 0xf860, 0xe49a, 0x8bdf, 0x3a10, 0x5555, 0x03e4, 0x6ca1, 0xdd6e,
            0xb22b, 0xaed1, 0xc194, 0x705b, 0x1f1e, 0x962e, 0xf96b, 0x48a4, 0x27e1, 0x3b1b, 0x545e,
            0xe591, 0x8ad4, 0xdc65, 0xb320, 0x02ef, 0x6daa, 0x7150, 0x1e15, 0xafda, 0xc09f, 0x02b8,
            0x6dfd, 0xdc32, 0xb377, 0xaf8d, 0xc0c8, 0x7107, 0x1e42, 0x48f3, 0x27b6, 0x9679, 0xf93c,
            0xe5c6, 0x8a83, 0x3b4c, 0x5409, 0xaf23, 0xc066, 0x71a9, 0x1eec, 0x0216, 0x6d53, 0xdc9c,
            0xb3d9, 0xe568, 0x8a2d, 0x3be2, 0x54a7, 0x485d, 0x2718, 0x96d7, 0xf992, 0x3bb5, 0x54f0,
            0xe53f, 0x8a7a, 0x9680, 0xf9c5, 0x480a, 0x274f, 0x71fe, 0x1ebb, 0xaf74, 0xc031, 0xdccb,
            0xb38e, 0x0241, 0x6d04,
        ],
        [
            0x0000, 0xd849, 0xa0b3, 0x78fa, 0x5147, 0x890e, 0xf1f4, 0x29bd, 0xa28e, 0x7ac7, 0x023d,
            0xda74, 0xf3c9, 0x2b80, 0x537a, 0x8b33, 0x553d, 0x8d74, 0xf58e, 0x2dc7, 0x047a, 0xdc33,
            0xa4c9, 0x7c80, 0xf7b3, 0x2ffa, 0x5700, 0x8f49, 0xa6f4, 0x7ebd, 0x0647, 0xde0e, 0xaa7a,
            0x7233, 0x0ac9, 0xd280, 0xfb3d, 0x2374, 0x5b8e, 0x83c7, 0x08f4, 0xd0bd, 0xa847, 0x700e,
            0x59b3, 0x81fa, 0xf900, 0x2149, 0xff47, 0x270e, 0x5ff4, 0x87bd, 0xae00, 0x7649, 0x0eb3,
            0xd6fa, 0x5dc9, 0x8580, 0xfd7a, 0x2533, 0x0c8e, 0xd4c7, 0xac3d, 0x7474, 0x44d5, 0x9c9c,
            0xe466, 0x3c2f, 0x1592, 0xcddb, 0xb521, 0x6d68, 0xe65b, 0x3e12, 0x46e8, 0x9ea1, 0xb71c,
            0x6f55, 0x17af, 0xcfe6, 0x11e8, 0xc9a1, 0xb15b, 0x6912, 0x40af, 0x98e6, 0xe01c, 0x3855,
            0xb366, 0x6b2f, 0x13d5, 0xcb9c, 0xe221, 0x3a68, 0x4292, 0x9adb, 0xeeaf, 0x36e6, 0x4e1c,
            0x9655, 0xbfe8, 0x67a1, 0x1f5b, 0xc712, 0x4c21, 0x9468, 0xec92, 0x34db, 0x1d66, 0xc52f,
            0xbdd5, 0x659c, 0xbb92, 0x63db, 0x1b21, 0xc368, 0xead5, 0x329c, 0x4a66, 0x922f, 0x191c,
            0xc155, 0xb9af, 0x61e6, 0x485b, 0x9012, 0xe8e8, 0x30a1, 0x89aa, 0x51e3, 0x2919, 0xf150,
            0xd8ed, 0x00a4, 0x785e, 0xa017, 0x2b24, 0xf36d, 0x8b97, 0x53de, 0x7a63, 0xa22a, 0xdad0,
            0x0299, 0xdc97, 0x04de, 0x7c24, 0xa46d, 0x8dd0, 0x5599, 0x2d63, 0xf52a, 0x7e19, 0xa650,
            0xdeaa, 0x06e3, 0x2f5e, 0xf717, 0x8fed, 0x57a4, 0x23d0, 0xfb99, 0x8363, 0x5b2a, 0x7297,
            0xaade, 0xd224, 0x0a6d, 0x815e, 0x5917, 0x21ed, 0xf9a4, 0xd019, 0x0850, 0x70aa, 0xa8e3,
            0x76ed, 0xaea4, 0xd65e, 0x0e17, 0x27aa, 0xffe3, 0x8719, 0x5f50, 0xd463, 0x0c2a, 0x74d0,
            0xac99, 0x8524, 0x5d6d, 0x2597, 0xfdde, 0xcd7f, 0x1536, 0x6dcc, 0xb585, 0x9c38, 0x4471,
            0x3c8b, 0xe4c2, 0x6ff1, 0xb7b8, 0xcf42, 0x170b, 0x3eb6, 0xe6ff, 0x9e05, 0x464c, 0x9842,
            0x400b, 0x38f1, 0xe0b8, 0xc905, 0x114c, 0x69b6, 0xb1ff, 0x3acc, 0xe285, 0x9a7f, 0x4236,
            0x6b8b, 0xb3c2, 0xcb38, 0x1371, 0x6705, 0xbf4c, 0xc7b6, 0x1fff, 0x3642, 0xee0b, 0x96f1,
            0x4eb8, 0xc58b, 0x1dc2, 0x6538, 0xbd71, 0x94cc, 0x4c85, 0x347f, 0xec36, 0x3238, 0xea71,
            0x928b, 0x4ac2, 0x637f, 0xbb36, 0xc3cc, 0x1b85, 0x90b6, 0x48ff, 0x3005, 0xe84c, 0xc1f1,
            0x19b8, 0x6142, 0xb90b,
        ],
        [
            0x0000, 0x0375, 0x06ea, 0x059f, 0x0dd4, 0x0ea1, 0x0b3e, 0x084b, 0x1ba8, 0x18dd, 0x1d42,
            0x1e37, 0x167c, 0x1509, 0x1096, 0x13e3, 0x3750, 0x3425, 0x31ba, 0x32cf, 0x3a84, 0x39f1,
            0x3c6e, 0x3f1b, 0x2cf8, 0x2f8d, 0x2a12, 0x2967, 0x212c, 0x2259, 0x27c6, 0x24b3, 0x6ea0,
            0x6dd5, 0x684a, 0x6b3f, 0x6374, 0x6001, 0x659e, 0x66eb, 0x7508, 0x767d, 0x73e2, 0x7097,
            0x78dc, 0x7ba9, 0x7e36, 0x7d43, 0x59f0, 0x5a85, 0x5f1a, 0x5c6f, 0x5424, 0x5751, 0x52ce,
            0x51bb, 0x4258, 0x412d, 0x44b2, 0x47c7, 0x4f8c, 0x4cf9, 0x4966, 0x4a13, 0xdd40, 0xde35,
            0xdbaa, 0xd8df, 0xd094, 0xd3e1, 0xd67e, 0xd50b, 0xc6e8, 0xc59d, 0xc002, 0xc377, 0xcb3c,
            0xc849, 0xcdd6, 0xcea3, 0xea10, 0xe965, 0xecfa, 0xef8f, 0xe7c4, 0xe4b1, 0xe12e, 0xe25b,
            0xf1b8, 0xf2cd, 0xf752, 0xf427, 0xfc6c, 0xff19, 0xfa86, 0xf9f3, 0xb3e0, 0xb095, 0xb50a,
            0xb67f, 0xbe34, 0xbd41, 0xb8de, 0xbbab, 0xa848, 0xab3d, 0xaea2, 0xadd7, 0xa59c, 0xa6e9,
            0xa376, 0xa003, 0x84b0, 0x87c5, 0x825a, 0x812f, 0x8964, 0x8a11, 0x8f8e, 0x8cfb, 0x9f18,
            0x9c6d, 0x99f2, 0x9a87, 0x92cc, 0x91b9, 0x9426, 0x9753, 0xaaa1, 0xa9d4, 0xac4b, 0xaf3e,
            0xa775, 0xa400, 0xa19f, 0xa2ea, 0xb109, 0xb27c, 0xb7e3, 0xb496, 0xbcdd, 0xbfa8, 0xba37,
            0xb942, 0x9df1, 0x9e84, 0x9b1b, 0x986e, 0x9025, 0x9350, 0x96cf, 0x95ba, 0x8659, 0x852c,
            0x80b3, 0x83c6, 0x8b8d, 0x88f8, 0x8d67, 0x8e12, 0xc401, 0xc774, 0xc2eb, 0xc19e, 0xc9d5,
            0xcaa0, 0xcf3f, 0xcc4a, 0xdfa9, 0xdcdc, 0xd943, 0xda36, 0xd27d, 0xd108, 0xd497, 0xd7e2,
            0xf351, 0xf024, 0xf5bb, 0xf6ce, 0xfe85, 0xfdf0, 0xf86f, 0xfb1a, 0xe8f9, 0xeb8c, 0xee13,
            0xed66, 0xe52d, 0xe658, 0xe3c7, 0xe0b2, 0x77e1, 0x7494, 0x710b, 0x727e, 0x7a35, 0x7940,
            0x7cdf, 0x7faa, 0x6c49, 0x6f3c, 0x6aa3, 0x69d6, 0x619d, 0x62e8, 0x6777, 0x6402, 0x40b1,
            0x43c4, 0x465b, 0x452e, 0x4d65, 0x4e10, 0x4b8f, 0x48fa, 0x5b19, 0x586c, 0x5df3, 0x5e86,
            0x56cd, 0x55b8, 0x5027, 0x5352, 0x1941, 0x1a34, 0x1fab, 0x1cde, 0x1495, 0x17e0, 0x127f,
            0x110a, 0x02e9, 0x019c, 0x0403, 0x0776, 0x0f3d, 0x0c48, 0x09d7, 0x0aa2, 0x2e11, 0x2d64,
            0x28fb, 0x2b8e, 0x23c5, 0x20b0, 0x252f, 0x265a, 0x35b9, 0x36cc, 0x3353, 0x3026, 0x386d,
            0x3b18, 0x3e87, 0x3df2,
        ],
        [
            0x0000, 0x4563, 0x8ac6, 0xcfa5, 0x05ad, 0x40ce, 0x8f6b, 0xca08, 0x0b5a, 0x4e39, 0x819c,
            0xc4ff, 0x0ef7, 0x4b94, 0x8431, 0xc152, 0x16b4, 0x53d7, 0x9c72, 0xd911, 0x1319, 0x567a,
            0x99df, 0xdcbc, 0x1dee, 0x588d, 0x9728, 0xd24b, 0x1843, 0x5d20, 0x9285, 0xd7e6, 0x2d68,
            0x680b, 0xa7ae, 0xe2cd, 0x28c5, 0x6da6, 0xa203, 0xe760, 0x2632, 0x6351, 0xacf4, 0xe997,
            0x239f, 0x66fc, 0xa959, 0xec3a, 0x3bdc, 0x7ebf, 0xb11a, 0xf479, 0x3e71, 0x7b12, 0xb4b7,
            0xf1d4, 0x3086, 0x75e5, 0xba40, 0xff23, 0x352b, 0x7048, 0xbfed, 0xfa8e, 0x5ad0, 0x1fb3,
            0xd016, 0x9575, 0x5f7d, 0x1a1e, 0xd5bb, 0x90d8, 0x518a, 0x14e9, 0xdb4c, 0x9e2f, 0x5427,
            0x1144, 0xdee1, 0x9b82, 0x4c64, 0x0907, 0xc6a2, 0x83c1, 0x49c9, 0x0caa, 0xc30f, 0x866c,
            0x473e, 0x025d, 0xcdf8, 0x889b, 0x4293, 0x07f0, 0xc855, 0x8d36, 0x77b8, 0x32db, 0xfd7e,
            0xb81d, 0x7215, 0x3776, 0xf8d3, 0xbdb0, 0x7ce2, 0x3981, 0xf624, 0xb347, 0x794f, 0x3c2c,
            0xf389, 0xb6ea, 0x610c, 0x246f, 0xebca, 0xaea9, 0x64a1, 0x21c2, 0xee67, 0xab04, 0x6a56,
            0x2f35, 0xe090, 0xa5f3, 0x6ffb, 0x2a98, 0xe53d, 0xa05e, 0xb5a0, 0xf0c3, 0x3f66, 0x7a05,
            0xb00d, 0xf56e, 0x3acb, 0x7fa8, 0xbefa, 0xfb99, 0x343c, 0x715f, 0xbb57, 0xfe34, 0x3191,
            0x74f2, 0xa314, 0xe677, 0x29d2, 0x6cb1, 0xa6b9, 0xe3da, 0x2c7f, 0x691c, 0xa84e, 0xed2d,
            0x2288, 0x67eb, 0xade3, 0xe880, 0x2725, 0x6246, 0x98c8, 0xddab, 0x120e, 0x576d, 0x9d65,
            0xd806, 0x17a3, 0x52c0, 0x9392, 0xd6f1, 0x1954, 0x5c37, 0x963f, 0xd35c, 0x1cf9, 0x599a,
            0x8e7c, 0xcb1f, 0x04ba, 0x41d9, 0x8bd1, 0xceb2, 0x0117, 0x4474, 0x8526, 0xc045, 0x0fe0,
            0x4a83, 0x808b, 0xc5e8, 0x0a4d, 0x4f2e, 0xef70, 0xaa13, 0x65b6, 0x20d5, 0xeadd, 0xafbe,
            0x601b, 0x2578, 0xe42a, 0xa149, 0x6eec, 0x2b8f, 0xe187, 0xa4e4, 0x6b41, 0x2e22, 0xf9c4,
            0xbca7, 0x7302, 0x3661, 0xfc69, 0xb90a, 0x76af, 0x33cc, 0xf29e, 0xb7fd, 0x7858, 0x3d3b,
            0xf733, 0xb250, 0x7df5, 0x3896, 0xc218, 0x877b, 0x48de, 0x0dbd, 0xc7b5, 0x82d6, 0x4d73,
            0x0810, 0xc942, 0x8c21, 0x4384, 0x06e7, 0xccef, 0x898c, 0x4629, 0x034a, 0xd4ac, 0x91cf,
            0x5e6a, 0x1b09, 0xd101, 0x9462, 0x5bc7, 0x1ea4, 0xdff6, 0x9a95, 0x5530, 0x1053, 0xda5b,
            0x9f38, 0x509d, 0x15fe,
        ],
        [
            0x0000, 0x7b61, 0xf6c2, 0x8da3, 0xfda5, 0x86c4, 0x0b67, 0x7006, 0xeb6b, 0x900a, 0x1da9,
            0x66c8, 0x16ce, 0x6daf, 0xe00c, 0x9b6d, 0xc6f7, 0xbd96, 0x3035, 0x4b54, 0x3b52, 0x4033,
            0xcd90, 0xb6f1, 0x2d9c, 0x56fd, 0xdb5e, 0xa03f, 0xd039, 0xab58, 0x26fb, 0x5d9a, 0x9dcf,
            0xe6ae, 0x6b0d, 0x106c, 0x606a, 0x1b0b, 0x96a8, 0xedc9, 0x76a4, 0x0dc5, 0x8066, 0xfb07,
            0x8b01, 0xf060, 0x7dc3, 0x06a2, 0x5b38, 0x2059, 0xadfa, 0xd69b, 0xa69d, 0xddfc, 0x505f,
            0x2b3e, 0xb053, 0xcb32, 0x4691, 0x3df0, 0x4df6, 0x3697, 0xbb34, 0xc055, 0x2bbf, 0x50de,
            0xdd7d, 0xa61c, 0xd61a, 0xad7b, 0x20d8, 0x5bb9, 0xc0d4, 0xbbb5, 0x3616, 0x4d77, 0x3d71,
            0x4610, 0xcbb3, 0xb0d2, 0xed48, 0x9629, 0x1b8a, 0x60eb, 0x10ed, 0x6b8c, 0xe62f, 0x9d4e,
            0x0623, 0x7d42, 0xf0e1, 0x8b80, 0xfb86, 0x80e7, 0x0d44, 0x7625, 0xb670, 0xcd11, 0x40b2,
            0x3bd3, 0x4bd5, 0x30b4, 0xbd17, 0xc676, 0x5d1b, 0x267a, 0xabd9, 0xd0b8, 0xa0be, 0xdbdf,
            0x567c, 0x2d1d, 0x7087, 0x0be6, 0x8645, 0xfd24, 0x8d22, 0xf643, 0x7be0, 0x0081, 0x9bec,
            0xe08d, 0x6d2e, 0x164f, 0x6649, 0x1d28, 0x908b, 0xebea, 0x577e, 0x2c1f, 0xa1bc, 0xdadd,
            0xaadb, 0xd1ba, 0x5c19, 0x2778, 0xbc15, 0xc774, 0x4ad7, 0x31b6, 0x41b0, 0x3ad1, 0xb772,
            0xcc13, 0x9189, 0xeae8, 0x674b, 0x1c2a, 0x6c2c, 0x174d, 0x9aee, 0xe18f, 0x7ae2, 0x0183,
            0x8c20, 0xf741, 0x8747, 0xfc26, 0x7185, 0x0ae4, 0xcab1, 0xb1d0, 0x3c73, 0x4712, 0x3714,
            0x4c75, 0xc1d6, 0xbab7, 0x21da, 0x5abb, 0xd718, 0xac79, 0xdc7f, 0xa71e, 0x2abd, 0x51dc,
            0x0c46, 0x7727, 0xfa84, 0x81e5, 0xf1e3, 0x8a82, 0x0721, 0x7c40, 0xe72d, 0x9c4c, 0x11ef,
            0x6a8e, 0x1a88, 0x61e9, 0xec4a, 0x972b, 0x7cc1, 0x07a0, 0x8a03, 0xf162, 0x8164, 0xfa05,
            0x77a6, 0x0cc7, 0x97aa, 0xeccb, 0x6168, 0x1a09, 0x6a0f, 0x116e, 0x9ccd, 0xe7ac, 0xba36,
            0xc157, 0x4cf4, 0x3795, 0x4793, 0x3cf2, 0xb151, 0xca30, 0x515d, 0x2a3c, 0xa79f, 0xdcfe,
            0xacf8, 0xd799, 0x5a3a, 0x215b, 0xe10e, 0x9a6f, 0x17cc, 0x6cad, 0x1cab, 0x67ca, 0xea69,
            0x9108, 0x0a65, 0x7104, 0xfca7, 0x87c6, 0xf7c0, 0x8ca1, 0x0102, 0x7a63, 0x27f9, 0x5c98,
            0xd13b, 0xaa5a, 0xda5c, 0xa13d, 0x2c9e, 0x57ff, 0xcc92, 0xb7f3, 0x3a50, 0x4131, 0x3137,
            0x4a56, 0xc7f5, 0xbc94,
        ],
        [
            0x0000, 0xaefc, 0x4dd9, 0xe325, 0x9bb2, 0x354e, 0xd66b, 0x7897, 0x2745, 0x89b9, 0x6a9c,
            0xc460, 0xbcf7, 0x120b, 0xf12e, 0x5fd2, 0x4e8a, 0xe076, 0x0353, 0xadaf, 0xd538, 0x7bc4,
            0x98e1, 0x361d, 0x69cf, 0xc733, 0x2416, 0x8aea, 0xf27d, 0x5c81, 0xbfa4, 0x1158, 0x9d14,
            0x33e8, 0xd0cd, 0x7e31, 0x06a6, 0xa85a, 0x4b7f, 0xe583, 0xba51, 0x14ad, 0xf788, 0x5974,
            0x21e3, 0x8f1f, 0x6c3a, 0xc2c6, 0xd39e, 0x7d62, 0x9e47, 0x30bb, 0x482c, 0xe6d0, 0x05f5,
            0xab09, 0xf4db, 0x5a27, 0xb902, 0x17fe, 0x6f69, 0xc195, 0x22b0, 0x8c4c, 0x2a09, 0x84f5,
            0x67d0, 0xc92c, 0xb1bb, 0x1f47, 0xfc62, 0x529e, 0x0d4c, 0xa3b0, 0x4095, 0xee69, 0x96fe,
            0x3802, 0xdb27, 0x75db, 0x6483, 0xca7f, 0x295a, 0x87a6, 0xff31, 0x51cd, 0xb2e8, 0x1c14,
            0x43c6, 0xed3a, 0x0e1f, 0xa0e3, 0xd874, 0x7688, 0x95ad, 0x3b51, 0xb71d, 0x19e1, 0xfac4,
            0x5438, 0x2caf, 0x8253, 0x6176, 0xcf8a, 0x9058, 0x3ea4, 0xdd81, 0x737d, 0x0bea, 0xa516,
            0x4633, 0xe8cf, 0xf997, 0x576b, 0xb44e, 0x1ab2, 0x6225, 0xccd9, 0x2ffc, 0x8100, 0xded2,
            0x702e, 0x930b, 0x3df7, 0x4560, 0xeb9c, 0x08b9, 0xa645, 0x5412, 0xfaee, 0x19cb, 0xb737,
            0xcfa0, 0x615c, 0x8279, 0x2c85, 0x7357, 0xddab, 0x3e8e, 0x9072, 0xe8e5, 0x4619, 0xa53c,
            0x0bc0, 0x1a98, 0xb464, 0x5741, 0xf9bd, 0x812a, 0x2fd6, 0xccf3, 0x620f, 0x3ddd, 0x9321,
            0x7004, 0xdef8, 0xa66f, 0x0893, 0xebb6, 0x454a, 0xc906, 0x67fa, 0x84df, 0x2a23, 0x52b4,
            0xfc48, 0x1f6d, 0xb191, 0xee43, 0x40bf, 0xa39a, 0x0d66, 0x75f1, 0xdb0d, 0x3828, 0x96d4,
            0x878c, 0x2970, 0xca55, 0x64a9, 0x1c3e, 0xb2c2, 0x51e7, 0xff1b, 0xa0c9, 0x0e35, 0xed10,
            0x43ec, 0x3b7b, 0x9587, 0x76a2, 0xd85e, 0x7e1b, 0xd0e7, 0x33c2, 0x9d3e, 0xe5a9, 0x4b55,
            0xa870, 0x068c, 0x595e, 0xf7a2, 0x1487, 0xba7b, 0xc2ec, 0x6c10, 0x8f35, 0x21c9, 0x3091,
            0x9e6d, 0x7d48, 0xd3b4, 0xab23, 0x05df, 0xe6fa, 0x4806, 0x17d4, 0xb928, 0x5a0d, 0xf4f1,
            0x8c66, 0x229a, 0xc1bf, 0x6f43, 0xe30f, 0x4df3, 0xaed6, 0x002a, 0x78bd, 0xd641, 0x3564,
            0x9b98, 0xc44a, 0x6ab6, 0x8993, 0x276f, 0x5ff8, 0xf104, 0x1221, 0xbcdd, 0xad85, 0x0379,
            0xe05c, 0x4ea0, 0x3637, 0x98cb, 0x7bee, 0xd512, 0x8ac0, 0x243c, 0xc719, 0x69e5, 0x1172,
            0xbf8e, 0x5cab, 0xf257,
        ],
        [
            0x0000, 0xa824, 0x4069, 0xe84d, 0x80d2, 0x28f6, 0xc0bb, 0x689f, 0x1185, 0xb9a1, 0x51ec,
            0xf9c8, 0x9157, 0x3973, 0xd13e, 0x791a, 0x230a, 0x8b2e, 0x6363, 0xcb47, 0xa3d8, 0x0bfc,
            0xe3b1, 0x4b95, 0x328f, 0x9aab, 0x72e6, 0xdac2, 0xb25d, 0x1a79, 0xf234, 0x5a10, 0x4614,
            0xee30, 0x067d, 0xae59, 0xc6c6, 0x6ee2, 0x86af, 0x2e8b, 0x5791, 0xffb5, 0x17f8, 0xbfdc,
            0xd743, 0x7f67, 0x972a, 0x3f0e, 0x651e, 0xcd3a, 0x2577, 0x8d53, 0xe5cc, 0x4de8, 0xa5a5,
            0x0d81, 0x749b, 0xdcbf, 0x34f2, 0x9cd6, 0xf449, 0x5c6d, 0xb420, 0x1c04, 0x8c28, 0x240c,
            0xcc41, 0x6465, 0x0cfa, 0xa4de, 0x4c93, 0xe4b7, 0x9dad, 0x3589, 0xddc4, 0x75e0, 0x1d7f,
            0xb55b, 0x5d16, 0xf532, 0xaf22, 0x0706, 0xef4b, 0x476f, 0x2ff0, 0x87d4, 0x6f99, 0xc7bd,
            0xbea7, 0x1683, 0xfece, 0x56ea, 0x3e75, 0x9651, 0x7e1c, 0xd638, 0xca3c, 0x6218, 0x8a55,
            0x2271, 0x4aee, 0xe2ca, 0x0a87, 0xa2a3, 0xdbb9, 0x739d, 0x9bd0, 0x33f4, 0x5b6b, 0xf34f,
            0x1b02, 0xb326, 0xe936, 0x4112, 0xa95f, 0x017b, 0x69e4, 0xc1c0, 0x298d, 0x81a9, 0xf8b3,
            0x5097, 0xb8da, 0x10fe, 0x7861, 0xd045, 0x3808, 0x902c, 0x0871, 0xa055, 0x4818, 0xe03c,
            0x88a3, 0x2087, 0xc8ca, 0x60ee, 0x19f4, 0xb1d0, 0x599d, 0xf1b9, 0x9926, 0x3102, 0xd94f,
            0x716b, 0x2b7b, 0x835f, 0x6b12, 0xc336, 0xaba9, 0x038d, 0xebc0, 0x43e4, 0x3afe, 0x92da,
            0x7a97, 0xd2b3, 0xba2c, 0x1208, 0xfa45, 0x5261, 0x4e65, 0xe641, 0x0e0c, 0xa628, 0xceb7,
            0x6693, 0x8ede, 0x26fa, 0x5fe0, 0xf7c4, 0x1f89, 0xb7ad, 0xdf32, 0x7716, 0x9f5b, 0x377f,
            0x6d6f, 0xc54b, 0x2d06, 0x8522, 0xedbd, 0x4599, 0xadd4, 0x05f0, 0x7cea, 0xd4ce, 0x3c83,
            0x94a7, 0xfc38, 0x541c, 0xbc51, 0x1475, 0x8459, 0x2c7d, 0xc430, 0x6c14, 0x048b, 0xacaf,
            0x44e2, 0xecc6, 0x95dc, 0x3df8, 0xd5b5, 0x7d91, 0x150e, 0xbd2a, 0x5567, 0xfd43, 0xa753,
            0x0f77, 0xe73a, 0x4f1e, 0x2781, 0x8fa5, 0x67e8, 0xcfcc, 0xb6d6, 0x1ef2, 0xf6bf, 0x5e9b,
            0x3604, 0x9e20, 0x766d, 0xde49, 0xc24d, 0x6a69, 0x8224, 0x2a00, 0x429f, 0xeabb, 0x02f6,
            0xaad2, 0xd3c8, 0x7bec, 0x93a1, 0x3b85, 0x531a, 0xfb3e, 0x1373, 0xbb57, 0xe147, 0x4963,
            0xa12e, 0x090a, 0x6195, 0xc9b1, 0x21fc, 0x89d8, 0xf0c2, 0x58e6, 0xb0ab, 0x188f, 0x7010,
            0xd834, 0x3079, 0x985d,
        ],
    ];

    pub static CRC16_T10_DIF_TABLE: [[u16; 256]; 16] = [
        [
            0x0000, 0x8bb7, 0x9cd9, 0x176e, 0xb205, 0x39b2, 0x2edc, 0xa56b, 0xefbd, 0x640a, 0x7364,
            0xf8d3, 0x5db8, 0xd60f, 0xc161, 0x4ad6, 0x54cd, 0xdf7a, 0xc814, 0x43a3, 0xe6c8, 0x6d7f,
            0x7a11, 0xf1a6, 0xbb70, 0x30c7, 0x27a9, 0xac1e, 0x0975, 0x82c2, 0x95ac, 0x1e1b, 0xa99a,
            0x222d, 0x3543, 0xbef4, 0x1b9f, 0x9028, 0x8746, 0x0cf1, 0x4627, 0xcd90, 0xdafe, 0x5149,
            0xf422, 0x7f95, 0x68fb, 0xe34c, 0xfd57, 0x76e0, 0x618e, 0xea39, 0x4f52, 0xc4e5, 0xd38b,
            0x583c, 0x12ea, 0x995d, 0x8e33, 0x0584, 0xa0ef, 0x2b58, 0x3c36, 0xb781, 0xd883, 0x5334,
            0x445a, 0xcfed, 0x6a86, 0xe131, 0xf65f, 0x7de8, 0x373e, 0xbc89, 0xabe7, 0x2050, 0x853b,
            0x0e8c, 0x19e2, 0x9255, 0x8c4e, 0x07f9, 0x1097, 0x9b20, 0x3e4b, 0xb5fc, 0xa292, 0x2925,
            0x63f3, 0xe844, 0xff2a, 0x749d, 0xd1f6, 0x5a41, 0x4d2f, 0xc698, 0x7119, 0xfaae, 0xedc0,
            0x6677, 0xc31c, 0x48ab, 0x5fc5, 0xd472, 0x9ea4, 0x1513, 0x027d, 0x89ca, 0x2ca1, 0xa716,
            0xb078, 0x3bcf, 0x25d4, 0xae63, 0xb90d, 0x32ba, 0x97d1, 0x1c66, 0x0b08, 0x80bf, 0xca69,
            0x41de, 0x56b0, 0xdd07, 0x786c, 0xf3db, 0xe4b5, 0x6f02, 0x3ab1, 0xb106, 0xa668, 0x2ddf,
            0x88b4, 0x0303, 0x146d, 0x9fda, 0xd50c, 0x5ebb, 0x49d5, 0xc262, 0x6709, 0xecbe, 0xfbd0,
            0x7067, 0x6e7c, 0xe5cb, 0xf2a5, 0x7912, 0xdc79, 0x57ce, 0x40a0, 0xcb17, 0x81c1, 0x0a76,
            0x1d18, 0x96af, 0x33c4, 0xb873, 0xaf1d, 0x24aa, 0x932b, 0x189c, 0x0ff2, 0x8445, 0x212e,
            0xaa99, 0xbdf7, 0x3640, 0x7c96, 0xf721, 0xe04f, 0x6bf8, 0xce93, 0x4524, 0x524a, 0xd9fd,
            0xc7e6, 0x4c51, 0x5b3f, 0xd088, 0x75e3, 0xfe54, 0xe93a, 0x628d, 0x285b, 0xa3ec, 0xb482,
            0x3f35, 0x9a5e, 0x11e9, 0x0687, 0x8d30, 0xe232, 0x6985, 0x7eeb, 0xf55c, 0x5037, 0xdb80,
            0xccee, 0x4759, 0x0d8f, 0x8638, 0x9156, 0x1ae1, 0xbf8a, 0x343d, 0x2353, 0xa8e4, 0xb6ff,
            0x3d48, 0x2a26, 0xa191, 0x04fa, 0x8f4d, 0x9823, 0x1394, 0x5942, 0xd2f5, 0xc59b, 0x4e2c,
            0xeb47, 0x60f0, 0x779e, 0xfc29, 0x4ba8, 0xc01f, 0xd771, 0x5cc6, 0xf9ad, 0x721a, 0x6574,
            0xeec3, 0xa415, 0x2fa2, 0x38cc, 0xb37b, 0x1610, 0x9da7, 0x8ac9, 0x017e, 0x1f65, 0x94d2,
            0x83bc, 0x080b, 0xad60, 0x26d7, 0x31b9, 0xba0e, 0xf0d8, 0x7b6f, 0x6c01, 0xe7b6, 0x42dd,
            0xc96a, 0xde04, 0x55b3,
        ],
        [
            0x0000, 0x7562, 0xeac4, 0x9fa6, 0x5e3f, 0x2b5d, 0xb4fb, 0xc199, 0xbc7e, 0xc91c, 0x56ba,
            0x23d8, 0xe241, 0x9723, 0x0885, 0x7de7, 0xf34b, 0x8629, 0x198f, 0x6ced, 0xad74, 0xd816,
            0x47b0, 0x32d2, 0x4f35, 0x3a57, 0xa5f1, 0xd093, 0x110a, 0x6468, 0xfbce, 0x8eac, 0x6d21,
            0x1843, 0x87e5, 0xf287, 0x331e, 0x467c, 0xd9da, 0xacb8, 0xd15f, 0xa43d, 0x3b9b, 0x4ef9,
            0x8f60, 0xfa02, 0x65a4, 0x10c6, 0x9e6a, 0xeb08, 0x74ae, 0x01cc, 0xc055, 0xb537, 0x2a91,
            0x5ff3, 0x2214, 0x5776, 0xc8d0, 0xbdb2, 0x7c2b, 0x0949, 0x96ef, 0xe38d, 0xda42, 0xaf20,
            0x3086, 0x45e4, 0x847d, 0xf11f, 0x6eb9, 0x1bdb, 0x663c, 0x135e, 0x8cf8, 0xf99a, 0x3803,
            0x4d61, 0xd2c7, 0xa7a5, 0x2909, 0x5c6b, 0xc3cd, 0xb6af, 0x7736, 0x0254, 0x9df2, 0xe890,
            0x9577, 0xe015, 0x7fb3, 0x0ad1, 0xcb48, 0xbe2a, 0x218c, 0x54ee, 0xb763, 0xc201, 0x5da7,
            0x28c5, 0xe95c, 0x9c3e, 0x0398, 0x76fa, 0x0b1d, 0x7e7f, 0xe1d9, 0x94bb, 0x5522, 0x2040,
            0xbfe6, 0xca84, 0x4428, 0x314a, 0xaeec, 0xdb8e, 0x1a17, 0x6f75, 0xf0d3, 0x85b1, 0xf856,
            0x8d34, 0x1292, 0x67f0, 0xa669, 0xd30b, 0x4cad, 0x39cf, 0x3f33, 0x4a51, 0xd5f7, 0xa095,
            0x610c, 0x146e, 0x8bc8, 0xfeaa, 0x834d, 0xf62f, 0x6989, 0x1ceb, 0xdd72, 0xa810, 0x37b6,
            0x42d4, 0xcc78, 0xb91a, 0x26bc, 0x53de, 0x9247, 0xe725, 0x7883, 0x0de1, 0x7006, 0x0564,
            0x9ac2, 0xefa0, 0x2e39, 0x5b5b, 0xc4fd, 0xb19f, 0x5212, 0x2770, 0xb8d6, 0xcdb4, 0x0c2d,
            0x794f, 0xe6e9, 0x938b, 0xee6c, 0x9b0e, 0x04a8, 0x71ca, 0xb053, 0xc531, 0x5a97, 0x2ff5,
            0xa159, 0xd43b, 0x4b9d, 0x3eff, 0xff66, 0x8a04, 0x15a2, 0x60c0, 0x1d27, 0x6845, 0xf7e3,
            0x8281, 0x4318, 0x367a, 0xa9dc, 0xdcbe, 0xe571, 0x9013, 0x0fb5, 0x7ad7, 0xbb4e, 0xce2c,
            0x518a, 0x24e8, 0x590f, 0x2c6d, 0xb3cb, 0xc6a9, 0x0730, 0x7252, 0xedf4, 0x9896, 0x163a,
            0x6358, 0xfcfe, 0x899c, 0x4805, 0x3d67, 0xa2c1, 0xd7a3, 0xaa44, 0xdf26, 0x4080, 0x35e2,
            0xf47b, 0x8119, 0x1ebf, 0x6bdd, 0x8850, 0xfd32, 0x6294, 0x17f6, 0xd66f, 0xa30d, 0x3cab,
            0x49c9, 0x342e, 0x414c, 0xdeea, 0xab88, 0x6a11, 0x1f73, 0x80d5, 0xf5b7, 0x7b1b, 0x0e79,
            0x91df, 0xe4bd, 0x2524, 0x5046, 0xcfe0, 0xba82, 0xc765, 0xb207, 0x2da1, 0x58c3, 0x995a,
            0xec38, 0x739e, 0x06fc,
        ],
        [
            0x0000, 0x7e66, 0xfccc, 0x82aa, 0x722f, 0x0c49, 0x8ee3, 0xf085, 0xe45e, 0x9a38, 0x1892,
            0x66f4, 0x9671, 0xe817, 0x6abd, 0x14db, 0x430b, 0x3d6d, 0xbfc7, 0xc1a1, 0x3124, 0x4f42,
            0xcde8, 0xb38e, 0xa755, 0xd933, 0x5b99, 0x25ff, 0xd57a, 0xab1c, 0x29b6, 0x57d0, 0x8616,
            0xf870, 0x7ada, 0x04bc, 0xf439, 0x8a5f, 0x08f5, 0x7693, 0x6248, 0x1c2e, 0x9e84, 0xe0e2,
            0x1067, 0x6e01, 0xecab, 0x92cd, 0xc51d, 0xbb7b, 0x39d1, 0x47b7, 0xb732, 0xc954, 0x4bfe,
            0x3598, 0x2143, 0x5f25, 0xdd8f, 0xa3e9, 0x536c, 0x2d0a, 0xafa0, 0xd1c6, 0x879b, 0xf9fd,
            0x7b57, 0x0531, 0xf5b4, 0x8bd2, 0x0978, 0x771e, 0x63c5, 0x1da3, 0x9f09, 0xe16f, 0x11ea,
            0x6f8c, 0xed26, 0x9340, 0xc490, 0xbaf6, 0x385c, 0x463a, 0xb6bf, 0xc8d9, 0x4a73, 0x3415,
            0x20ce, 0x5ea8, 0xdc02, 0xa264, 0x52e1, 0x2c87, 0xae2d, 0xd04b, 0x018d, 0x7feb, 0xfd41,
            0x8327, 0x73a2, 0x0dc4, 0x8f6e, 0xf108, 0xe5d3, 0x9bb5, 0x191f, 0x6779, 0x97fc, 0xe99a,
            0x6b30, 0x1556, 0x4286, 0x3ce0, 0xbe4a, 0xc02c, 0x30a9, 0x4ecf, 0xcc65, 0xb203, 0xa6d8,
            0xd8be, 0x5a14, 0x2472, 0xd4f7, 0xaa91, 0x283b, 0x565d, 0x8481, 0xfae7, 0x784d, 0x062b,
            0xf6ae, 0x88c8, 0x0a62, 0x7404, 0x60df, 0x1eb9, 0x9c13, 0xe275, 0x12f0, 0x6c96, 0xee3c,
            0x905a, 0xc78a, 0xb9ec, 0x3b46, 0x4520, 0xb5a5, 0xcbc3, 0x4969, 0x370f, 0x23d4, 0x5db2,
            0xdf18, 0xa17e, 0x51fb, 0x2f9d, 0xad37, 0xd351, 0x0297, 0x7cf1, 0xfe5b, 0x803d, 0x70b8,
            0x0ede, 0x8c74, 0xf212, 0xe6c9, 0x98af, 0x1a05, 0x6463, 0x94e6, 0xea80, 0x682a, 0x164c,
            0x419c, 0x3ffa, 0xbd50, 0xc336, 0x33b3, 0x4dd5, 0xcf7f, 0xb119, 0xa5c2, 0xdba4, 0x590e,
            0x2768, 0xd7ed, 0xa98b, 0x2b21, 0x5547, 0x031a, 0x7d7c, 0xffd6, 0x81b0, 0x7135, 0x0f53,
            0x8df9, 0xf39f, 0xe744, 0x9922, 0x1b88, 0x65ee, 0x956b, 0xeb0d, 0x69a7, 0x17c1, 0x4011,
            0x3e77, 0xbcdd, 0xc2bb, 0x323e, 0x4c58, 0xcef2, 0xb094, 0xa44f, 0xda29, 0x5883, 0x26e5,
            0xd660, 0xa806, 0x2aac, 0x54ca, 0x850c, 0xfb6a, 0x79c0, 0x07a6, 0xf723, 0x8945, 0x0bef,
            0x7589, 0x6152, 0x1f34, 0x9d9e, 0xe3f8, 0x137d, 0x6d1b, 0xefb1, 0x91d7, 0xc607, 0xb861,
            0x3acb, 0x44ad, 0xb428, 0xca4e, 0x48e4, 0x3682, 0x2259, 0x5c3f, 0xde95, 0xa0f3, 0x5076,
            0x2e10, 0xacba, 0xd2dc,
        ],
        [
            0x0000, 0x82b5, 0x8edd, 0x0c68, 0x960d, 0x14b8, 0x18d0, 0x9a65, 0xa7ad, 0x2518, 0x2970,
            0xabc5, 0x31a0, 0xb315, 0xbf7d, 0x3dc8, 0xc4ed, 0x4658, 0x4a30, 0xc885, 0x52e0, 0xd055,
            0xdc3d, 0x5e88, 0x6340, 0xe1f5, 0xed9d, 0x6f28, 0xf54d, 0x77f8, 0x7b90, 0xf925, 0x026d,
            0x80d8, 0x8cb0, 0x0e05, 0x9460, 0x16d5, 0x1abd, 0x9808, 0xa5c0, 0x2775, 0x2b1d, 0xa9a8,
            0x33cd, 0xb178, 0xbd10, 0x3fa5, 0xc680, 0x4435, 0x485d, 0xcae8, 0x508d, 0xd238, 0xde50,
            0x5ce5, 0x612d, 0xe398, 0xeff0, 0x6d45, 0xf720, 0x7595, 0x79fd, 0xfb48, 0x04da, 0x866f,
            0x8a07, 0x08b2, 0x92d7, 0x1062, 0x1c0a, 0x9ebf, 0xa377, 0x21c2, 0x2daa, 0xaf1f, 0x357a,
            0xb7cf, 0xbba7, 0x3912, 0xc037, 0x4282, 0x4eea, 0xcc5f, 0x563a, 0xd48f, 0xd8e7, 0x5a52,
            0x679a, 0xe52f, 0xe947, 0x6bf2, 0xf197, 0x7322, 0x7f4a, 0xfdff, 0x06b7, 0x8402, 0x886a,
            0x0adf, 0x90ba, 0x120f, 0x1e67, 0x9cd2, 0xa11a, 0x23af, 0x2fc7, 0xad72, 0x3717, 0xb5a2,
            0xb9ca, 0x3b7f, 0xc25a, 0x40ef, 0x4c87, 0xce32, 0x5457, 0xd6e2, 0xda8a, 0x583f, 0x65f7,
            0xe742, 0xeb2a, 0x699f, 0xf3fa, 0x714f, 0x7d27, 0xff92, 0x09b4, 0x8b01, 0x8769, 0x05dc,
            0x9fb9, 0x1d0c, 0x1164, 0x93d1, 0xae19, 0x2cac, 0x20c4, 0xa271, 0x3814, 0xbaa1, 0xb6c9,
            0x347c, 0xcd59, 0x4fec, 0x4384, 0xc131, 0x5b54, 0xd9e1, 0xd589, 0x573c, 0x6af4, 0xe841,
            0xe429, 0x669c, 0xfcf9, 0x7e4c, 0x7224, 0xf091, 0x0bd9, 0x896c, 0x8504, 0x07b1, 0x9dd4,
            0x1f61, 0x1309, 0x91bc, 0xac74, 0x2ec1, 0x22a9, 0xa01c, 0x3a79, 0xb8cc, 0xb4a4, 0x3611,
            0xcf34, 0x4d81, 0x41e9, 0xc35c, 0x5939, 0xdb8c, 0xd7e4, 0x5551, 0x6899, 0xea2c, 0xe644,
            0x64f1, 0xfe94, 0x7c21, 0x7049, 0xf2fc, 0x0d6e, 0x8fdb, 0x83b3, 0x0106, 0x9b63, 0x19d6,
            0x15be, 0x970b, 0xaac3, 0x2876, 0x241e, 0xa6ab, 0x3cce, 0xbe7b, 0xb213, 0x30a6, 0xc983,
            0x4b36, 0x475e, 0xc5eb, 0x5f8e, 0xdd3b, 0xd153, 0x53e6, 0x6e2e, 0xec9b, 0xe0f3, 0x6246,
            0xf823, 0x7a96, 0x76fe, 0xf44b, 0x0f03, 0x8db6, 0x81de, 0x036b, 0x990e, 0x1bbb, 0x17d3,
            0x9566, 0xa8ae, 0x2a1b, 0x2673, 0xa4c6, 0x3ea3, 0xbc16, 0xb07e, 0x32cb, 0xcbee, 0x495b,
            0x4533, 0xc786, 0x5de3, 0xdf56, 0xd33e, 0x518b, 0x6c43, 0xeef6, 0xe29e, 0x602b, 0xfa4e,
            0x78fb, 0x7493, 0xf626,
        ],
        [
            0x0000, 0x1368, 0x26d0, 0x35b8, 0x4da0, 0x5ec8, 0x6b70, 0x7818, 0x9b40, 0x8828, 0xbd90,
            0xaef8, 0xd6e0, 0xc588, 0xf030, 0xe358, 0xbd37, 0xae5f, 0x9be7, 0x888f, 0xf097, 0xe3ff,
            0xd647, 0xc52f, 0x2677, 0x351f, 0x00a7, 0x13cf, 0x6bd7, 0x78bf, 0x4d07, 0x5e6f, 0xf1d9,
            0xe2b1, 0xd709, 0xc461, 0xbc79, 0xaf11, 0x9aa9, 0x89c1, 0x6a99, 0x79f1, 0x4c49, 0x5f21,
            0x2739, 0x3451, 0x01e9, 0x1281, 0x4cee, 0x5f86, 0x6a3e, 0x7956, 0x014e, 0x1226, 0x279e,
            0x34f6, 0xd7ae, 0xc4c6, 0xf17e, 0xe216, 0x9a0e, 0x8966, 0xbcde, 0xafb6, 0x6805, 0x7b6d,
            0x4ed5, 0x5dbd, 0x25a5, 0x36cd, 0x0375, 0x101d, 0xf345, 0xe02d, 0xd595, 0xc6fd, 0xbee5,
            0xad8d, 0x9835, 0x8b5d, 0xd532, 0xc65a, 0xf3e2, 0xe08a, 0x9892, 0x8bfa, 0xbe42, 0xad2a,
            0x4e72, 0x5d1a, 0x68a2, 0x7bca, 0x03d2, 0x10ba, 0x2502, 0x366a, 0x99dc, 0x8ab4, 0xbf0c,
            0xac64, 0xd47c, 0xc714, 0xf2ac, 0xe1c4, 0x029c, 0x11f4, 0x244c, 0x3724, 0x4f3c, 0x5c54,
            0x69ec, 0x7a84, 0x24eb, 0x3783, 0x023b, 0x1153, 0x694b, 0x7a23, 0x4f9b, 0x5cf3, 0xbfab,
            0xacc3, 0x997b, 0x8a13, 0xf20b, 0xe163, 0xd4db, 0xc7b3, 0xd00a, 0xc362, 0xf6da, 0xe5b2,
            0x9daa, 0x8ec2, 0xbb7a, 0xa812, 0x4b4a, 0x5822, 0x6d9a, 0x7ef2, 0x06ea, 0x1582, 0x203a,
            0x3352, 0x6d3d, 0x7e55, 0x4bed, 0x5885, 0x209d, 0x33f5, 0x064d, 0x1525, 0xf67d, 0xe515,
            0xd0ad, 0xc3c5, 0xbbdd, 0xa8b5, 0x9d0d, 0x8e65, 0x21d3, 0x32bb, 0x0703, 0x146b, 0x6c73,
            0x7f1b, 0x4aa3, 0x59cb, 0xba93, 0xa9fb, 0x9c43, 0x8f2b, 0xf733, 0xe45b, 0xd1e3, 0xc28b,
            0x9ce4, 0x8f8c, 0xba34, 0xa95c, 0xd144, 0xc22c, 0xf794, 0xe4fc, 0x07a4, 0x14cc, 0x2174,
            0x321c, 0x4a04, 0x596c, 0x6cd4, 0x7fbc, 0xb80f, 0xab67, 0x9edf, 0x8db7, 0xf5af, 0xe6c7,
            0xd37f, 0xc017, 0x234f, 0x3027, 0x059f, 0x16f7, 0x6eef, 0x7d87, 0x483f, 0x5b57, 0x0538,
            0x1650, 0x23e8, 0x3080, 0x4898, 0x5bf0, 0x6e48, 0x7d20, 0x9e78, 0x8d10, 0xb8a8, 0xabc0,
            0xd3d8, 0xc0b0, 0xf508, 0xe660, 0x49d6, 0x5abe, 0x6f06, 0x7c6e, 0x0476, 0x171e, 0x22a6,
            0x31ce, 0xd296, 0xc1fe, 0xf446, 0xe72e, 0x9f36, 0x8c5e, 0xb9e6, 0xaa8e, 0xf4e1, 0xe789,
            0xd231, 0xc159, 0xb941, 0xaa29, 0x9f91, 0x8cf9, 0x6fa1, 0x7cc9, 0x4971, 0x5a19, 0x2201,
            0x3169, 0x04d1, 0x17b9,
        ],
        [
            0x0000, 0x2ba3, 0x5746, 0x7ce5, 0xae8c, 0x852f, 0xf9ca, 0xd269, 0xd6af, 0xfd0c, 0x81e9,
            0xaa4a, 0x7823, 0x5380, 0x2f65, 0x04c6, 0x26e9, 0x0d4a, 0x71af, 0x5a0c, 0x8865, 0xa3c6,
            0xdf23, 0xf480, 0xf046, 0xdbe5, 0xa700, 0x8ca3, 0x5eca, 0x7569, 0x098c, 0x222f, 0x4dd2,
            0x6671, 0x1a94, 0x3137, 0xe35e, 0xc8fd, 0xb418, 0x9fbb, 0x9b7d, 0xb0de, 0xcc3b, 0xe798,
            0x35f1, 0x1e52, 0x62b7, 0x4914, 0x6b3b, 0x4098, 0x3c7d, 0x17de, 0xc5b7, 0xee14, 0x92f1,
            0xb952, 0xbd94, 0x9637, 0xead2, 0xc171, 0x1318, 0x38bb, 0x445e, 0x6ffd, 0x9ba4, 0xb007,
            0xcce2, 0xe741, 0x3528, 0x1e8b, 0x626e, 0x49cd, 0x4d0b, 0x66a8, 0x1a4d, 0x31ee, 0xe387,
            0xc824, 0xb4c1, 0x9f62, 0xbd4d, 0x96ee, 0xea0b, 0xc1a8, 0x13c1, 0x3862, 0x4487, 0x6f24,
            0x6be2, 0x4041, 0x3ca4, 0x1707, 0xc56e, 0xeecd, 0x9228, 0xb98b, 0xd676, 0xfdd5, 0x8130,
            0xaa93, 0x78fa, 0x5359, 0x2fbc, 0x041f, 0x00d9, 0x2b7a, 0x579f, 0x7c3c, 0xae55, 0x85f6,
            0xf913, 0xd2b0, 0xf09f, 0xdb3c, 0xa7d9, 0x8c7a, 0x5e13, 0x75b0, 0x0955, 0x22f6, 0x2630,
            0x0d93, 0x7176, 0x5ad5, 0x88bc, 0xa31f, 0xdffa, 0xf459, 0xbcff, 0x975c, 0xebb9, 0xc01a,
            0x1273, 0x39d0, 0x4535, 0x6e96, 0x6a50, 0x41f3, 0x3d16, 0x16b5, 0xc4dc, 0xef7f, 0x939a,
            0xb839, 0x9a16, 0xb1b5, 0xcd50, 0xe6f3, 0x349a, 0x1f39, 0x63dc, 0x487f, 0x4cb9, 0x671a,
            0x1bff, 0x305c, 0xe235, 0xc996, 0xb573, 0x9ed0, 0xf12d, 0xda8e, 0xa66b, 0x8dc8, 0x5fa1,
            0x7402, 0x08e7, 0x2344, 0x2782, 0x0c21, 0x70c4, 0x5b67, 0x890e, 0xa2ad, 0xde48, 0xf5eb,
            0xd7c4, 0xfc67, 0x8082, 0xab21, 0x7948, 0x52eb, 0x2e0e, 0x05ad, 0x016b, 0x2ac8, 0x562d,
            0x7d8e, 0xafe7, 0x8444, 0xf8a1, 0xd302, 0x275b, 0x0cf8, 0x701d, 0x5bbe, 0x89d7, 0xa274,
            0xde91, 0xf532, 0xf1f4, 0xda57, 0xa6b2, 0x8d11, 0x5f78, 0x74db, 0x083e, 0x239d, 0x01b2,
            0x2a11, 0x56f4, 0x7d57, 0xaf3e, 0x849d, 0xf878, 0xd3db, 0xd71d, 0xfcbe, 0x805b, 0xabf8,
            0x7991, 0x5232, 0x2ed7, 0x0574, 0x6a89, 0x412a, 0x3dcf, 0x166c, 0xc405, 0xefa6, 0x9343,
            0xb8e0, 0xbc26, 0x9785, 0xeb60, 0xc0c3, 0x12aa, 0x3909, 0x45ec, 0x6e4f, 0x4c60, 0x67c3,
            0x1b26, 0x3085, 0xe2ec, 0xc94f, 0xb5aa, 0x9e09, 0x9acf, 0xb16c, 0xcd89, 0xe62a, 0x3443,
            0x1fe0, 0x6305, 0x48a6,
        ],
        [
            0x0000, 0xf249, 0x6f25, 0x9d6c, 0xde4a, 0x2c03, 0xb16f, 0x4326, 0x3723, 0xc56a, 0x5806,
            0xaa4f, 0xe969, 0x1b20, 0x864c, 0x7405, 0x6e46, 0x9c0f, 0x0163, 0xf32a, 0xb00c, 0x4245,
            0xdf29, 0x2d60, 0x5965, 0xab2c, 0x3640, 0xc409, 0x872f, 0x7566, 0xe80a, 0x1a43, 0xdc8c,
            0x2ec5, 0xb3a9, 0x41e0, 0x02c6, 0xf08f, 0x6de3, 0x9faa, 0xebaf, 0x19e6, 0x848a, 0x76c3,
            0x35e5, 0xc7ac, 0x5ac0, 0xa889, 0xb2ca, 0x4083, 0xddef, 0x2fa6, 0x6c80, 0x9ec9, 0x03a5,
            0xf1ec, 0x85e9, 0x77a0, 0xeacc, 0x1885, 0x5ba3, 0xa9ea, 0x3486, 0xc6cf, 0x32af, 0xc0e6,
            0x5d8a, 0xafc3, 0xece5, 0x1eac, 0x83c0, 0x7189, 0x058c, 0xf7c5, 0x6aa9, 0x98e0, 0xdbc6,
            0x298f, 0xb4e3, 0x46aa, 0x5ce9, 0xaea0, 0x33cc, 0xc185, 0x82a3, 0x70ea, 0xed86, 0x1fcf,
            0x6bca, 0x9983, 0x04ef, 0xf6a6, 0xb580, 0x47c9, 0xdaa5, 0x28ec, 0xee23, 0x1c6a, 0x8106,
            0x734f, 0x3069, 0xc220, 0x5f4c, 0xad05, 0xd900, 0x2b49, 0xb625, 0x446c, 0x074a, 0xf503,
            0x686f, 0x9a26, 0x8065, 0x722c, 0xef40, 0x1d09, 0x5e2f, 0xac66, 0x310a, 0xc343, 0xb746,
            0x450f, 0xd863, 0x2a2a, 0x690c, 0x9b45, 0x0629, 0xf460, 0x655e, 0x9717, 0x0a7b, 0xf832,
            0xbb14, 0x495d, 0xd431, 0x2678, 0x527d, 0xa034, 0x3d58, 0xcf11, 0x8c37, 0x7e7e, 0xe312,
            0x115b, 0x0b18, 0xf951, 0x643d, 0x9674, 0xd552, 0x271b, 0xba77, 0x483e, 0x3c3b, 0xce72,
            0x531e, 0xa157, 0xe271, 0x1038, 0x8d54, 0x7f1d, 0xb9d2, 0x4b9b, 0xd6f7, 0x24be, 0x6798,
            0x95d1, 0x08bd, 0xfaf4, 0x8ef1, 0x7cb8, 0xe1d4, 0x139d, 0x50bb, 0xa2f2, 0x3f9e, 0xcdd7,
            0xd794, 0x25dd, 0xb8b1, 0x4af8, 0x09de, 0xfb97, 0x66fb, 0x94b2, 0xe0b7, 0x12fe, 0x8f92,
            0x7ddb, 0x3efd, 0xccb4, 0x51d8, 0xa391, 0x57f1, 0xa5b8, 0x38d4, 0xca9d, 0x89bb, 0x7bf2,
            0xe69e, 0x14d7, 0x60d2, 0x929b, 0x0ff7, 0xfdbe, 0xbe98, 0x4cd1, 0xd1bd, 0x23f4, 0x39b7,
            0xcbfe, 0x5692, 0xa4db, 0xe7fd, 0x15b4, 0x88d8, 0x7a91, 0x0e94, 0xfcdd, 0x61b1, 0x93f8,
            0xd0de, 0x2297, 0xbffb, 0x4db2, 0x8b7d, 0x7934, 0xe458, 0x1611, 0x5537, 0xa77e, 0x3a12,
            0xc85b, 0xbc5e, 0x4e17, 0xd37b, 0x2132, 0x6214, 0x905d, 0x0d31, 0xff78, 0xe53b, 0x1772,
            0x8a1e, 0x7857, 0x3b71, 0xc938, 0x5454, 0xa61d, 0xd218, 0x2051, 0xbd3d, 0x4f74, 0x0c52,
            0xfe1b, 0x6377, 0x913e,
        ],
        [
            0x0000, 0xcabc, 0x1ecf, 0xd473, 0x3d9e, 0xf722, 0x2351, 0xe9ed, 0x7b3c, 0xb180, 0x65f3,
            0xaf4f, 0x46a2, 0x8c1e, 0x586d, 0x92d1, 0xf678, 0x3cc4, 0xe8b7, 0x220b, 0xcbe6, 0x015a,
            0xd529, 0x1f95, 0x8d44, 0x47f8, 0x938b, 0x5937, 0xb0da, 0x7a66, 0xae15, 0x64a9, 0x6747,
            0xadfb, 0x7988, 0xb334, 0x5ad9, 0x9065, 0x4416, 0x8eaa, 0x1c7b, 0xd6c7, 0x02b4, 0xc808,
            0x21e5, 0xeb59, 0x3f2a, 0xf596, 0x913f, 0x5b83, 0x8ff0, 0x454c, 0xaca1, 0x661d, 0xb26e,
            0x78d2, 0xea03, 0x20bf, 0xf4cc, 0x3e70, 0xd79d, 0x1d21, 0xc952, 0x03ee, 0xce8e, 0x0432,
            0xd041, 0x1afd, 0xf310, 0x39ac, 0xeddf, 0x2763, 0xb5b2, 0x7f0e, 0xab7d, 0x61c1, 0x882c,
            0x4290, 0x96e3, 0x5c5f, 0x38f6, 0xf24a, 0x2639, 0xec85, 0x0568, 0xcfd4, 0x1ba7, 0xd11b,
            0x43ca, 0x8976, 0x5d05, 0x97b9, 0x7e54, 0xb4e8, 0x609b, 0xaa27, 0xa9c9, 0x6375, 0xb706,
            0x7dba, 0x9457, 0x5eeb, 0x8a98, 0x4024, 0xd2f5, 0x1849, 0xcc3a, 0x0686, 0xef6b, 0x25d7,
            0xf1a4, 0x3b18, 0x5fb1, 0x950d, 0x417e, 0x8bc2, 0x622f, 0xa893, 0x7ce0, 0xb65c, 0x248d,
            0xee31, 0x3a42, 0xf0fe, 0x1913, 0xd3af, 0x07dc, 0xcd60, 0x16ab, 0xdc17, 0x0864, 0xc2d8,
            0x2b35, 0xe189, 0x35fa, 0xff46, 0x6d97, 0xa72b, 0x7358, 0xb9e4, 0x5009, 0x9ab5, 0x4ec6,
            0x847a, 0xe0d3, 0x2a6f, 0xfe1c, 0x34a0, 0xdd4d, 0x17f1, 0xc382, 0x093e, 0x9bef, 0x5153,
            0x8520, 0x4f9c, 0xa671, 0x6ccd, 0xb8be, 0x7202, 0x71ec, 0xbb50, 0x6f23, 0xa59f, 0x4c72,
            0x86ce, 0x52bd, 0x9801, 0x0ad0, 0xc06c, 0x141f, 0xdea3, 0x374e, 0xfdf2, 0x2981, 0xe33d,
            0x8794, 0x4d28, 0x995b, 0x53e7, 0xba0a, 0x70b6, 0xa4c5, 0x6e79, 0xfca8, 0x3614, 0xe267,
            0x28db, 0xc136, 0x0b8a, 0xdff9, 0x1545, 0xd825, 0x1299, 0xc6ea, 0x0c56, 0xe5bb, 0x2f07,
            0xfb74, 0x31c8, 0xa319, 0x69a5, 0xbdd6, 0x776a, 0x9e87, 0x543b, 0x8048, 0x4af4, 0x2e5d,
            0xe4e1, 0x3092, 0xfa2e, 0x13c3, 0xd97f, 0x0d0c, 0xc7b0, 0x5561, 0x9fdd, 0x4bae, 0x8112,
            0x68ff, 0xa243, 0x7630, 0xbc8c, 0xbf62, 0x75de, 0xa1ad, 0x6b11, 0x82fc, 0x4840, 0x9c33,
            0x568f, 0xc45e, 0x0ee2, 0xda91, 0x102d, 0xf9c0, 0x337c, 0xe70f, 0x2db3, 0x491a, 0x83a6,
            0x57d5, 0x9d69, 0x7484, 0xbe38, 0x6a4b, 0xa0f7, 0x3226, 0xf89a, 0x2ce9, 0xe655, 0x0fb8,
            0xc504, 0x1177, 0xdbcb,
        ],
        [
            0x0000, 0x2d56, 0x5aac, 0x77fa, 0xb558, 0x980e, 0xeff4, 0xc2a2, 0xe107, 0xcc51, 0xbbab,
            0x96fd, 0x545f, 0x7909, 0x0ef3, 0x23a5, 0x49b9, 0x64ef, 0x1315, 0x3e43, 0xfce1, 0xd1b7,
            0xa64d, 0x8b1b, 0xa8be, 0x85e8, 0xf212, 0xdf44, 0x1de6, 0x30b0, 0x474a, 0x6a1c, 0x9372,
            0xbe24, 0xc9de, 0xe488, 0x262a, 0x0b7c, 0x7c86, 0x51d0, 0x7275, 0x5f23, 0x28d9, 0x058f,
            0xc72d, 0xea7b, 0x9d81, 0xb0d7, 0xdacb, 0xf79d, 0x8067, 0xad31, 0x6f93, 0x42c5, 0x353f,
            0x1869, 0x3bcc, 0x169a, 0x6160, 0x4c36, 0x8e94, 0xa3c2, 0xd438, 0xf96e, 0xad53, 0x8005,
            0xf7ff, 0xdaa9, 0x180b, 0x355d, 0x42a7, 0x6ff1, 0x4c54, 0x6102, 0x16f8, 0x3bae, 0xf90c,
            0xd45a, 0xa3a0, 0x8ef6, 0xe4ea, 0xc9bc, 0xbe46, 0x9310, 0x51b2, 0x7ce4, 0x0b1e, 0x2648,
            0x05ed, 0x28bb, 0x5f41, 0x7217, 0xb0b5, 0x9de3, 0xea19, 0xc74f, 0x3e21, 0x1377, 0x648d,
            0x49db, 0x8b79, 0xa62f, 0xd1d5, 0xfc83, 0xdf26, 0xf270, 0x858a, 0xa8dc, 0x6a7e, 0x4728,
            0x30d2, 0x1d84, 0x7798, 0x5ace, 0x2d34, 0x0062, 0xc2c0, 0xef96, 0x986c, 0xb53a, 0x969f,
            0xbbc9, 0xcc33, 0xe165, 0x23c7, 0x0e91, 0x796b, 0x543d, 0xd111, 0xfc47, 0x8bbd, 0xa6eb,
            0x6449, 0x491f, 0x3ee5, 0x13b3, 0x3016, 0x1d40, 0x6aba, 0x47ec, 0x854e, 0xa818, 0xdfe2,
            0xf2b4, 0x98a8, 0xb5fe, 0xc204, 0xef52, 0x2df0, 0x00a6, 0x775c, 0x5a0a, 0x79af, 0x54f9,
            0x2303, 0x0e55, 0xccf7, 0xe1a1, 0x965b, 0xbb0d, 0x4263, 0x6f35, 0x18cf, 0x3599, 0xf73b,
            0xda6d, 0xad97, 0x80c1, 0xa364, 0x8e32, 0xf9c8, 0xd49e, 0x163c, 0x3b6a, 0x4c90, 0x61c6,
            0x0bda, 0x268c, 0x5176, 0x7c20, 0xbe82, 0x93d4, 0xe42e, 0xc978, 0xeadd, 0xc78b, 0xb071,
            0x9d27, 0x5f85, 0x72d3, 0x0529, 0x287f, 0x7c42, 0x5114, 0x26ee, 0x0bb8, 0xc91a, 0xe44c,
            0x93b6, 0xbee0, 0x9d45, 0xb013, 0xc7e9, 0xeabf, 0x281d, 0x054b, 0x72b1, 0x5fe7, 0x35fb,
            0x18ad, 0x6f57, 0x4201, 0x80a3, 0xadf5, 0xda0f, 0xf759, 0xd4fc, 0xf9aa, 0x8e50, 0xa306,
            0x61a4, 0x4cf2, 0x3b08, 0x165e, 0xef30, 0xc266, 0xb59c, 0x98ca, 0x5a68, 0x773e, 0x00c4,
            0x2d92, 0x0e37, 0x2361, 0x549b, 0x79cd, 0xbb6f, 0x9639, 0xe1c3, 0xcc95, 0xa689, 0x8bdf,
            0xfc25, 0xd173, 0x13d1, 0x3e87, 0x497d, 0x642b, 0x478e, 0x6ad8, 0x1d22, 0x3074, 0xf2d6,
            0xdf80, 0xa87a, 0x852c,
        ],
        [
            0x0000, 0x2995, 0x532a, 0x7abf, 0xa654, 0x8fc1, 0xf57e, 0xdceb, 0xc71f, 0xee8a, 0x9435,
            0xbda0, 0x614b, 0x48de, 0x3261, 0x1bf4, 0x0589, 0x2c1c, 0x56a3, 0x7f36, 0xa3dd, 0x8a48,
            0xf0f7, 0xd962, 0xc296, 0xeb03, 0x91bc, 0xb829, 0x64c2, 0x4d57, 0x37e8, 0x1e7d, 0x0b12,
            0x2287, 0x5838, 0x71ad, 0xad46, 0x84d3, 0xfe6c, 0xd7f9, 0xcc0d, 0xe598, 0x9f27, 0xb6b2,
            0x6a59, 0x43cc, 0x3973, 0x10e6, 0x0e9b, 0x270e, 0x5db1, 0x7424, 0xa8cf, 0x815a, 0xfbe5,
            0xd270, 0xc984, 0xe011, 0x9aae, 0xb33b, 0x6fd0, 0x4645, 0x3cfa, 0x156f, 0x1624, 0x3fb1,
            0x450e, 0x6c9b, 0xb070, 0x99e5, 0xe35a, 0xcacf, 0xd13b, 0xf8ae, 0x8211, 0xab84, 0x776f,
            0x5efa, 0x2445, 0x0dd0, 0x13ad, 0x3a38, 0x4087, 0x6912, 0xb5f9, 0x9c6c, 0xe6d3, 0xcf46,
            0xd4b2, 0xfd27, 0x8798, 0xae0d, 0x72e6, 0x5b73, 0x21cc, 0x0859, 0x1d36, 0x34a3, 0x4e1c,
            0x6789, 0xbb62, 0x92f7, 0xe848, 0xc1dd, 0xda29, 0xf3bc, 0x8903, 0xa096, 0x7c7d, 0x55e8,
            0x2f57, 0x06c2, 0x18bf, 0x312a, 0x4b95, 0x6200, 0xbeeb, 0x977e, 0xedc1, 0xc454, 0xdfa0,
            0xf635, 0x8c8a, 0xa51f, 0x79f4, 0x5061, 0x2ade, 0x034b, 0x2c48, 0x05dd, 0x7f62, 0x56f7,
            0x8a1c, 0xa389, 0xd936, 0xf0a3, 0xeb57, 0xc2c2, 0xb87d, 0x91e8, 0x4d03, 0x6496, 0x1e29,
            0x37bc, 0x29c1, 0x0054, 0x7aeb, 0x537e, 0x8f95, 0xa600, 0xdcbf, 0xf52a, 0xeede, 0xc74b,
            0xbdf4, 0x9461, 0x488a, 0x611f, 0x1ba0, 0x3235, 0x275a, 0x0ecf, 0x7470, 0x5de5, 0x810e,
            0xa89b, 0xd224, 0xfbb1, 0xe045, 0xc9d0, 0xb36f, 0x9afa, 0x4611, 0x6f84, 0x153b, 0x3cae,
            0x22d3, 0x0b46, 0x71f9, 0x586c, 0x8487, 0xad12, 0xd7ad, 0xfe38, 0xe5cc, 0xcc59, 0xb6e6,
            0x9f73, 0x4398, 0x6a0d, 0x10b2, 0x3927, 0x3a6c, 0x13f9, 0x6946, 0x40d3, 0x9c38, 0xb5ad,
            0xcf12, 0xe687, 0xfd73, 0xd4e6, 0xae59, 0x87cc, 0x5b27, 0x72b2, 0x080d, 0x2198, 0x3fe5,
            0x1670, 0x6ccf, 0x455a, 0x99b1, 0xb024, 0xca9b, 0xe30e, 0xf8fa, 0xd16f, 0xabd0, 0x8245,
            0x5eae, 0x773b, 0x0d84, 0x2411, 0x317e, 0x18eb, 0x6254, 0x4bc1, 0x972a, 0xbebf, 0xc400,
            0xed95, 0xf661, 0xdff4, 0xa54b, 0x8cde, 0x5035, 0x79a0, 0x031f, 0x2a8a, 0x34f7, 0x1d62,
            0x67dd, 0x4e48, 0x92a3, 0xbb36, 0xc189, 0xe81c, 0xf3e8, 0xda7d, 0xa0c2, 0x8957, 0x55bc,
            0x7c29, 0x0696, 0x2f03,
        ],
        [
            0x0000, 0x5890, 0xb120, 0xe9b0, 0xe9f7, 0xb167, 0x58d7, 0x0047, 0x5859, 0x00c9, 0xe979,
            0xb1e9, 0xb1ae, 0xe93e, 0x008e, 0x581e, 0xb0b2, 0xe822, 0x0192, 0x5902, 0x5945, 0x01d5,
            0xe865, 0xb0f5, 0xe8eb, 0xb07b, 0x59cb, 0x015b, 0x011c, 0x598c, 0xb03c, 0xe8ac, 0xead3,
            0xb243, 0x5bf3, 0x0363, 0x0324, 0x5bb4, 0xb204, 0xea94, 0xb28a, 0xea1a, 0x03aa, 0x5b3a,
            0x5b7d, 0x03ed, 0xea5d, 0xb2cd, 0x5a61, 0x02f1, 0xeb41, 0xb3d1, 0xb396, 0xeb06, 0x02b6,
            0x5a26, 0x0238, 0x5aa8, 0xb318, 0xeb88, 0xebcf, 0xb35f, 0x5aef, 0x027f, 0x5e11, 0x0681,
            0xef31, 0xb7a1, 0xb7e6, 0xef76, 0x06c6, 0x5e56, 0x0648, 0x5ed8, 0xb768, 0xeff8, 0xefbf,
            0xb72f, 0x5e9f, 0x060f, 0xeea3, 0xb633, 0x5f83, 0x0713, 0x0754, 0x5fc4, 0xb674, 0xeee4,
            0xb6fa, 0xee6a, 0x07da, 0x5f4a, 0x5f0d, 0x079d, 0xee2d, 0xb6bd, 0xb4c2, 0xec52, 0x05e2,
            0x5d72, 0x5d35, 0x05a5, 0xec15, 0xb485, 0xec9b, 0xb40b, 0x5dbb, 0x052b, 0x056c, 0x5dfc,
            0xb44c, 0xecdc, 0x0470, 0x5ce0, 0xb550, 0xedc0, 0xed87, 0xb517, 0x5ca7, 0x0437, 0x5c29,
            0x04b9, 0xed09, 0xb599, 0xb5de, 0xed4e, 0x04fe, 0x5c6e, 0xbc22, 0xe4b2, 0x0d02, 0x5592,
            0x55d5, 0x0d45, 0xe4f5, 0xbc65, 0xe47b, 0xbceb, 0x555b, 0x0dcb, 0x0d8c, 0x551c, 0xbcac,
            0xe43c, 0x0c90, 0x5400, 0xbdb0, 0xe520, 0xe567, 0xbdf7, 0x5447, 0x0cd7, 0x54c9, 0x0c59,
            0xe5e9, 0xbd79, 0xbd3e, 0xe5ae, 0x0c1e, 0x548e, 0x56f1, 0x0e61, 0xe7d1, 0xbf41, 0xbf06,
            0xe796, 0x0e26, 0x56b6, 0x0ea8, 0x5638, 0xbf88, 0xe718, 0xe75f, 0xbfcf, 0x567f, 0x0eef,
            0xe643, 0xbed3, 0x5763, 0x0ff3, 0x0fb4, 0x5724, 0xbe94, 0xe604, 0xbe1a, 0xe68a, 0x0f3a,
            0x57aa, 0x57ed, 0x0f7d, 0xe6cd, 0xbe5d, 0xe233, 0xbaa3, 0x5313, 0x0b83, 0x0bc4, 0x5354,
            0xbae4, 0xe274, 0xba6a, 0xe2fa, 0x0b4a, 0x53da, 0x539d, 0x0b0d, 0xe2bd, 0xba2d, 0x5281,
            0x0a11, 0xe3a1, 0xbb31, 0xbb76, 0xe3e6, 0x0a56, 0x52c6, 0x0ad8, 0x5248, 0xbbf8, 0xe368,
            0xe32f, 0xbbbf, 0x520f, 0x0a9f, 0x08e0, 0x5070, 0xb9c0, 0xe150, 0xe117, 0xb987, 0x5037,
            0x08a7, 0x50b9, 0x0829, 0xe199, 0xb909, 0xb94e, 0xe1de, 0x086e, 0x50fe, 0xb852, 0xe0c2,
            0x0972, 0x51e2, 0x51a5, 0x0935, 0xe085, 0xb815, 0xe00b, 0xb89b, 0x512b, 0x09bb, 0x09fc,
            0x516c, 0xb8dc, 0xe04c,
        ],
        [
            0x0000, 0xf3f3, 0x6c51, 0x9fa2, 0xd8a2, 0x2b51, 0xb4f3, 0x4700, 0x3af3, 0xc900, 0x56a2,
            0xa551, 0xe251, 0x11a2, 0x8e00, 0x7df3, 0x75e6, 0x8615, 0x19b7, 0xea44, 0xad44, 0x5eb7,
            0xc115, 0x32e6, 0x4f15, 0xbce6, 0x2344, 0xd0b7, 0x97b7, 0x6444, 0xfbe6, 0x0815, 0xebcc,
            0x183f, 0x879d, 0x746e, 0x336e, 0xc09d, 0x5f3f, 0xaccc, 0xd13f, 0x22cc, 0xbd6e, 0x4e9d,
            0x099d, 0xfa6e, 0x65cc, 0x963f, 0x9e2a, 0x6dd9, 0xf27b, 0x0188, 0x4688, 0xb57b, 0x2ad9,
            0xd92a, 0xa4d9, 0x572a, 0xc888, 0x3b7b, 0x7c7b, 0x8f88, 0x102a, 0xe3d9, 0x5c2f, 0xafdc,
            0x307e, 0xc38d, 0x848d, 0x777e, 0xe8dc, 0x1b2f, 0x66dc, 0x952f, 0x0a8d, 0xf97e, 0xbe7e,
            0x4d8d, 0xd22f, 0x21dc, 0x29c9, 0xda3a, 0x4598, 0xb66b, 0xf16b, 0x0298, 0x9d3a, 0x6ec9,
            0x133a, 0xe0c9, 0x7f6b, 0x8c98, 0xcb98, 0x386b, 0xa7c9, 0x543a, 0xb7e3, 0x4410, 0xdbb2,
            0x2841, 0x6f41, 0x9cb2, 0x0310, 0xf0e3, 0x8d10, 0x7ee3, 0xe141, 0x12b2, 0x55b2, 0xa641,
            0x39e3, 0xca10, 0xc205, 0x31f6, 0xae54, 0x5da7, 0x1aa7, 0xe954, 0x76f6, 0x8505, 0xf8f6,
            0x0b05, 0x94a7, 0x6754, 0x2054, 0xd3a7, 0x4c05, 0xbff6, 0xb85e, 0x4bad, 0xd40f, 0x27fc,
            0x60fc, 0x930f, 0x0cad, 0xff5e, 0x82ad, 0x715e, 0xeefc, 0x1d0f, 0x5a0f, 0xa9fc, 0x365e,
            0xc5ad, 0xcdb8, 0x3e4b, 0xa1e9, 0x521a, 0x151a, 0xe6e9, 0x794b, 0x8ab8, 0xf74b, 0x04b8,
            0x9b1a, 0x68e9, 0x2fe9, 0xdc1a, 0x43b8, 0xb04b, 0x5392, 0xa061, 0x3fc3, 0xcc30, 0x8b30,
            0x78c3, 0xe761, 0x1492, 0x6961, 0x9a92, 0x0530, 0xf6c3, 0xb1c3, 0x4230, 0xdd92, 0x2e61,
            0x2674, 0xd587, 0x4a25, 0xb9d6, 0xfed6, 0x0d25, 0x9287, 0x6174, 0x1c87, 0xef74, 0x70d6,
            0x8325, 0xc425, 0x37d6, 0xa874, 0x5b87, 0xe471, 0x1782, 0x8820, 0x7bd3, 0x3cd3, 0xcf20,
            0x5082, 0xa371, 0xde82, 0x2d71, 0xb2d3, 0x4120, 0x0620, 0xf5d3, 0x6a71, 0x9982, 0x9197,
            0x6264, 0xfdc6, 0x0e35, 0x4935, 0xbac6, 0x2564, 0xd697, 0xab64, 0x5897, 0xc735, 0x34c6,
            0x73c6, 0x8035, 0x1f97, 0xec64, 0x0fbd, 0xfc4e, 0x63ec, 0x901f, 0xd71f, 0x24ec, 0xbb4e,
            0x48bd, 0x354e, 0xc6bd, 0x591f, 0xaaec, 0xedec, 0x1e1f, 0x81bd, 0x724e, 0x7a5b, 0x89a8,
            0x160a, 0xe5f9, 0xa2f9, 0x510a, 0xcea8, 0x3d5b, 0x40a8, 0xb35b, 0x2cf9, 0xdf0a, 0x980a,
            0x6bf9, 0xf45b, 0x07a8,
        ],
        [
            0x0000, 0xfb0b, 0x7da1, 0x86aa, 0xfb42, 0x0049, 0x86e3, 0x7de8, 0x7d33, 0x8638, 0x0092,
            0xfb99, 0x8671, 0x7d7a, 0xfbd0, 0x00db, 0xfa66, 0x016d, 0x87c7, 0x7ccc, 0x0124, 0xfa2f,
            0x7c85, 0x878e, 0x8755, 0x7c5e, 0xfaf4, 0x01ff, 0x7c17, 0x871c, 0x01b6, 0xfabd, 0x7f7b,
            0x8470, 0x02da, 0xf9d1, 0x8439, 0x7f32, 0xf998, 0x0293, 0x0248, 0xf943, 0x7fe9, 0x84e2,
            0xf90a, 0x0201, 0x84ab, 0x7fa0, 0x851d, 0x7e16, 0xf8bc, 0x03b7, 0x7e5f, 0x8554, 0x03fe,
            0xf8f5, 0xf82e, 0x0325, 0x858f, 0x7e84, 0x036c, 0xf867, 0x7ecd, 0x85c6, 0xfef6, 0x05fd,
            0x8357, 0x785c, 0x05b4, 0xfebf, 0x7815, 0x831e, 0x83c5, 0x78ce, 0xfe64, 0x056f, 0x7887,
            0x838c, 0x0526, 0xfe2d, 0x0490, 0xff9b, 0x7931, 0x823a, 0xffd2, 0x04d9, 0x8273, 0x7978,
            0x79a3, 0x82a8, 0x0402, 0xff09, 0x82e1, 0x79ea, 0xff40, 0x044b, 0x818d, 0x7a86, 0xfc2c,
            0x0727, 0x7acf, 0x81c4, 0x076e, 0xfc65, 0xfcbe, 0x07b5, 0x811f, 0x7a14, 0x07fc, 0xfcf7,
            0x7a5d, 0x8156, 0x7beb, 0x80e0, 0x064a, 0xfd41, 0x80a9, 0x7ba2, 0xfd08, 0x0603, 0x06d8,
            0xfdd3, 0x7b79, 0x8072, 0xfd9a, 0x0691, 0x803b, 0x7b30, 0x765b, 0x8d50, 0x0bfa, 0xf0f1,
            0x8d19, 0x7612, 0xf0b8, 0x0bb3, 0x0b68, 0xf063, 0x76c9, 0x8dc2, 0xf02a, 0x0b21, 0x8d8b,
            0x7680, 0x8c3d, 0x7736, 0xf19c, 0x0a97, 0x777f, 0x8c74, 0x0ade, 0xf1d5, 0xf10e, 0x0a05,
            0x8caf, 0x77a4, 0x0a4c, 0xf147, 0x77ed, 0x8ce6, 0x0920, 0xf22b, 0x7481, 0x8f8a, 0xf262,
            0x0969, 0x8fc3, 0x74c8, 0x7413, 0x8f18, 0x09b2, 0xf2b9, 0x8f51, 0x745a, 0xf2f0, 0x09fb,
            0xf346, 0x084d, 0x8ee7, 0x75ec, 0x0804, 0xf30f, 0x75a5, 0x8eae, 0x8e75, 0x757e, 0xf3d4,
            0x08df, 0x7537, 0x8e3c, 0x0896, 0xf39d, 0x88ad, 0x73a6, 0xf50c, 0x0e07, 0x73ef, 0x88e4,
            0x0e4e, 0xf545, 0xf59e, 0x0e95, 0x883f, 0x7334, 0x0edc, 0xf5d7, 0x737d, 0x8876, 0x72cb,
            0x89c0, 0x0f6a, 0xf461, 0x8989, 0x7282, 0xf428, 0x0f23, 0x0ff8, 0xf4f3, 0x7259, 0x8952,
            0xf4ba, 0x0fb1, 0x891b, 0x7210, 0xf7d6, 0x0cdd, 0x8a77, 0x717c, 0x0c94, 0xf79f, 0x7135,
            0x8a3e, 0x8ae5, 0x71ee, 0xf744, 0x0c4f, 0x71a7, 0x8aac, 0x0c06, 0xf70d, 0x0db0, 0xf6bb,
            0x7011, 0x8b1a, 0xf6f2, 0x0df9, 0x8b53, 0x7058, 0x7083, 0x8b88, 0x0d22, 0xf629, 0x8bc1,
            0x70ca, 0xf660, 0x0d6b,
        ],
        [
            0x0000, 0xecb6, 0x52db, 0xbe6d, 0xa5b6, 0x4900, 0xf76d, 0x1bdb, 0xc0db, 0x2c6d, 0x9200,
            0x7eb6, 0x656d, 0x89db, 0x37b6, 0xdb00, 0x0a01, 0xe6b7, 0x58da, 0xb46c, 0xafb7, 0x4301,
            0xfd6c, 0x11da, 0xcada, 0x266c, 0x9801, 0x74b7, 0x6f6c, 0x83da, 0x3db7, 0xd101, 0x1402,
            0xf8b4, 0x46d9, 0xaa6f, 0xb1b4, 0x5d02, 0xe36f, 0x0fd9, 0xd4d9, 0x386f, 0x8602, 0x6ab4,
            0x716f, 0x9dd9, 0x23b4, 0xcf02, 0x1e03, 0xf2b5, 0x4cd8, 0xa06e, 0xbbb5, 0x5703, 0xe96e,
            0x05d8, 0xded8, 0x326e, 0x8c03, 0x60b5, 0x7b6e, 0x97d8, 0x29b5, 0xc503, 0x2804, 0xc4b2,
            0x7adf, 0x9669, 0x8db2, 0x6104, 0xdf69, 0x33df, 0xe8df, 0x0469, 0xba04, 0x56b2, 0x4d69,
            0xa1df, 0x1fb2, 0xf304, 0x2205, 0xceb3, 0x70de, 0x9c68, 0x87b3, 0x6b05, 0xd568, 0x39de,
            0xe2de, 0x0e68, 0xb005, 0x5cb3, 0x4768, 0xabde, 0x15b3, 0xf905, 0x3c06, 0xd0b0, 0x6edd,
            0x826b, 0x99b0, 0x7506, 0xcb6b, 0x27dd, 0xfcdd, 0x106b, 0xae06, 0x42b0, 0x596b, 0xb5dd,
            0x0bb0, 0xe706, 0x3607, 0xdab1, 0x64dc, 0x886a, 0x93b1, 0x7f07, 0xc16a, 0x2ddc, 0xf6dc,
            0x1a6a, 0xa407, 0x48b1, 0x536a, 0xbfdc, 0x01b1, 0xed07, 0x5008, 0xbcbe, 0x02d3, 0xee65,
            0xf5be, 0x1908, 0xa765, 0x4bd3, 0x90d3, 0x7c65, 0xc208, 0x2ebe, 0x3565, 0xd9d3, 0x67be,
            0x8b08, 0x5a09, 0xb6bf, 0x08d2, 0xe464, 0xffbf, 0x1309, 0xad64, 0x41d2, 0x9ad2, 0x7664,
            0xc809, 0x24bf, 0x3f64, 0xd3d2, 0x6dbf, 0x8109, 0x440a, 0xa8bc, 0x16d1, 0xfa67, 0xe1bc,
            0x0d0a, 0xb367, 0x5fd1, 0x84d1, 0x6867, 0xd60a, 0x3abc, 0x2167, 0xcdd1, 0x73bc, 0x9f0a,
            0x4e0b, 0xa2bd, 0x1cd0, 0xf066, 0xebbd, 0x070b, 0xb966, 0x55d0, 0x8ed0, 0x6266, 0xdc0b,
            0x30bd, 0x2b66, 0xc7d0, 0x79bd, 0x950b, 0x780c, 0x94ba, 0x2ad7, 0xc661, 0xddba, 0x310c,
            0x8f61, 0x63d7, 0xb8d7, 0x5461, 0xea0c, 0x06ba, 0x1d61, 0xf1d7, 0x4fba, 0xa30c, 0x720d,
            0x9ebb, 0x20d6, 0xcc60, 0xd7bb, 0x3b0d, 0x8560, 0x69d6, 0xb2d6, 0x5e60, 0xe00d, 0x0cbb,
            0x1760, 0xfbd6, 0x45bb, 0xa90d, 0x6c0e, 0x80b8, 0x3ed5, 0xd263, 0xc9b8, 0x250e, 0x9b63,
            0x77d5, 0xacd5, 0x4063, 0xfe0e, 0x12b8, 0x0963, 0xe5d5, 0x5bb8, 0xb70e, 0x660f, 0x8ab9,
            0x34d4, 0xd862, 0xc3b9, 0x2f0f, 0x9162, 0x7dd4, 0xa6d4, 0x4a62, 0xf40f, 0x18b9, 0x0362,
            0xefd4, 0x51b9, 0xbd0f,
        ],
        [
            0x0000, 0xa010, 0xcb97, 0x6b87, 0x1c99, 0xbc89, 0xd70e, 0x771e, 0x3932, 0x9922, 0xf2a5,
            0x52b5, 0x25ab, 0x85bb, 0xee3c, 0x4e2c, 0x7264, 0xd274, 0xb9f3, 0x19e3, 0x6efd, 0xceed,
            0xa56a, 0x057a, 0x4b56, 0xeb46, 0x80c1, 0x20d1, 0x57cf, 0xf7df, 0x9c58, 0x3c48, 0xe4c8,
            0x44d8, 0x2f5f, 0x8f4f, 0xf851, 0x5841, 0x33c6, 0x93d6, 0xddfa, 0x7dea, 0x166d, 0xb67d,
            0xc163, 0x6173, 0x0af4, 0xaae4, 0x96ac, 0x36bc, 0x5d3b, 0xfd2b, 0x8a35, 0x2a25, 0x41a2,
            0xe1b2, 0xaf9e, 0x0f8e, 0x6409, 0xc419, 0xb307, 0x1317, 0x7890, 0xd880, 0x4227, 0xe237,
            0x89b0, 0x29a0, 0x5ebe, 0xfeae, 0x9529, 0x3539, 0x7b15, 0xdb05, 0xb082, 0x1092, 0x678c,
            0xc79c, 0xac1b, 0x0c0b, 0x3043, 0x9053, 0xfbd4, 0x5bc4, 0x2cda, 0x8cca, 0xe74d, 0x475d,
            0x0971, 0xa961, 0xc2e6, 0x62f6, 0x15e8, 0xb5f8, 0xde7f, 0x7e6f, 0xa6ef, 0x06ff, 0x6d78,
            0xcd68, 0xba76, 0x1a66, 0x71e1, 0xd1f1, 0x9fdd, 0x3fcd, 0x544a, 0xf45a, 0x8344, 0x2354,
            0x48d3, 0xe8c3, 0xd48b, 0x749b, 0x1f1c, 0xbf0c, 0xc812, 0x6802, 0x0385, 0xa395, 0xedb9,
            0x4da9, 0x262e, 0x863e, 0xf120, 0x5130, 0x3ab7, 0x9aa7, 0x844e, 0x245e, 0x4fd9, 0xefc9,
            0x98d7, 0x38c7, 0x5340, 0xf350, 0xbd7c, 0x1d6c, 0x76eb, 0xd6fb, 0xa1e5, 0x01f5, 0x6a72,
            0xca62, 0xf62a, 0x563a, 0x3dbd, 0x9dad, 0xeab3, 0x4aa3, 0x2124, 0x8134, 0xcf18, 0x6f08,
            0x048f, 0xa49f, 0xd381, 0x7391, 0x1816, 0xb806, 0x6086, 0xc096, 0xab11, 0x0b01, 0x7c1f,
            0xdc0f, 0xb788, 0x1798, 0x59b4, 0xf9a4, 0x9223, 0x3233, 0x452d, 0xe53d, 0x8eba, 0x2eaa,
            0x12e2, 0xb2f2, 0xd975, 0x7965, 0x0e7b, 0xae6b, 0xc5ec, 0x65fc, 0x2bd0, 0x8bc0, 0xe047,
            0x4057, 0x3749, 0x9759, 0xfcde, 0x5cce, 0xc669, 0x6679, 0x0dfe, 0xadee, 0xdaf0, 0x7ae0,
            0x1167, 0xb177, 0xff5b, 0x5f4b, 0x34cc, 0x94dc, 0xe3c2, 0x43d2, 0x2855, 0x8845, 0xb40d,
            0x141d, 0x7f9a, 0xdf8a, 0xa894, 0x0884, 0x6303, 0xc313, 0x8d3f, 0x2d2f, 0x46a8, 0xe6b8,
            0x91a6, 0x31b6, 0x5a31, 0xfa21, 0x22a1, 0x82b1, 0xe936, 0x4926, 0x3e38, 0x9e28, 0xf5af,
            0x55bf, 0x1b93, 0xbb83, 0xd004, 0x7014, 0x070a, 0xa71a, 0xcc9d, 0x6c8d, 0x50c5, 0xf0d5,
            0x9b52, 0x3b42, 0x4c5c, 0xec4c, 0x87cb, 0x27db, 0x69f7, 0xc9e7, 0xa260, 0x0270, 0x756e,
            0xd57e, 0xbef9, 0x1ee9,
        ],
        [
            0x0000, 0x832b, 0x8de1, 0x0eca, 0x9075, 0x135e, 0x1d94, 0x9ebf, 0xab5d, 0x2876, 0x26bc,
            0xa597, 0x3b28, 0xb803, 0xb6c9, 0x35e2, 0xdd0d, 0x5e26, 0x50ec, 0xd3c7, 0x4d78, 0xce53,
            0xc099, 0x43b2, 0x7650, 0xf57b, 0xfbb1, 0x789a, 0xe625, 0x650e, 0x6bc4, 0xe8ef, 0x31ad,
            0xb286, 0xbc4c, 0x3f67, 0xa1d8, 0x22f3, 0x2c39, 0xaf12, 0x9af0, 0x19db, 0x1711, 0x943a,
            0x0a85, 0x89ae, 0x8764, 0x044f, 0xeca0, 0x6f8b, 0x6141, 0xe26a, 0x7cd5, 0xfffe, 0xf134,
            0x721f, 0x47fd, 0xc4d6, 0xca1c, 0x4937, 0xd788, 0x54a3, 0x5a69, 0xd942, 0x635a, 0xe071,
            0xeebb, 0x6d90, 0xf32f, 0x7004, 0x7ece, 0xfde5, 0xc807, 0x4b2c, 0x45e6, 0xc6cd, 0x5872,
            0xdb59, 0xd593, 0x56b8, 0xbe57, 0x3d7c, 0x33b6, 0xb09d, 0x2e22, 0xad09, 0xa3c3, 0x20e8,
            0x150a, 0x9621, 0x98eb, 0x1bc0, 0x857f, 0x0654, 0x089e, 0x8bb5, 0x52f7, 0xd1dc, 0xdf16,
            0x5c3d, 0xc282, 0x41a9, 0x4f63, 0xcc48, 0xf9aa, 0x7a81, 0x744b, 0xf760, 0x69df, 0xeaf4,
            0xe43e, 0x6715, 0x8ffa, 0x0cd1, 0x021b, 0x8130, 0x1f8f, 0x9ca4, 0x926e, 0x1145, 0x24a7,
            0xa78c, 0xa946, 0x2a6d, 0xb4d2, 0x37f9, 0x3933, 0xba18, 0xc6b4, 0x459f, 0x4b55, 0xc87e,
            0x56c1, 0xd5ea, 0xdb20, 0x580b, 0x6de9, 0xeec2, 0xe008, 0x6323, 0xfd9c, 0x7eb7, 0x707d,
            0xf356, 0x1bb9, 0x9892, 0x9658, 0x1573, 0x8bcc, 0x08e7, 0x062d, 0x8506, 0xb0e4, 0x33cf,
            0x3d05, 0xbe2e, 0x2091, 0xa3ba, 0xad70, 0x2e5b, 0xf719, 0x7432, 0x7af8, 0xf9d3, 0x676c,
            0xe447, 0xea8d, 0x69a6, 0x5c44, 0xdf6f, 0xd1a5, 0x528e, 0xcc31, 0x4f1a, 0x41d0, 0xc2fb,
            0x2a14, 0xa93f, 0xa7f5, 0x24de, 0xba61, 0x394a, 0x3780, 0xb4ab, 0x8149, 0x0262, 0x0ca8,
            0x8f83, 0x113c, 0x9217, 0x9cdd, 0x1ff6, 0xa5ee, 0x26c5, 0x280f, 0xab24, 0x359b, 0xb6b0,
            0xb87a, 0x3b51, 0x0eb3, 0x8d98, 0x8352, 0x0079, 0x9ec6, 0x1ded, 0x1327, 0x900c, 0x78e3,
            0xfbc8, 0xf502, 0x7629, 0xe896, 0x6bbd, 0x6577, 0xe65c, 0xd3be, 0x5095, 0x5e5f, 0xdd74,
            0x43cb, 0xc0e0, 0xce2a, 0x4d01, 0x9443, 0x1768, 0x19a2, 0x9a89, 0x0436, 0x871d, 0x89d7,
            0x0afc, 0x3f1e, 0xbc35, 0xb2ff, 0x31d4, 0xaf6b, 0x2c40, 0x228a, 0xa1a1, 0x494e, 0xca65,
            0xc4af, 0x4784, 0xd93b, 0x5a10, 0x54da, 0xd7f1, 0xe213, 0x6138, 0x6ff2, 0xecd9, 0x7266,
            0xf14d, 0xff87, 0x7cac,
        ],
    ];

    pub static CRC16_TELEDISK_TABLE: [[u16; 256]; 16] = [
        [
            0x0000, 0xa097, 0xe1b9, 0x412e, 0x63e5, 0xc372, 0x825c, 0x22cb, 0xc7ca, 0x675d, 0x2673,
            0x86e4, 0xa42f, 0x04b8, 0x4596, 0xe501, 0x2f03, 0x8f94, 0xceba, 0x6e2d, 0x4ce6, 0xec71,
            0xad5f, 0x0dc8, 0xe8c9, 0x485e, 0x0970, 0xa9e7, 0x8b2c, 0x2bbb, 0x6a95, 0xca02, 0x5e06,
            0xfe91, 0xbfbf, 0x1f28, 0x3de3, 0x9d74, 0xdc5a, 0x7ccd, 0x99cc, 0x395b, 0x7875, 0xd8e2,
            0xfa29, 0x5abe, 0x1b90, 0xbb07, 0x7105, 0xd192, 0x90bc, 0x302b, 0x12e0, 0xb277, 0xf359,
            0x53ce, 0xb6cf, 0x1658, 0x5776, 0xf7e1, 0xd52a, 0x75bd, 0x3493, 0x9404, 0xbc0c, 0x1c9b,
            0x5db5, 0xfd22, 0xdfe9, 0x7f7e, 0x3e50, 0x9ec7, 0x7bc6, 0xdb51, 0x9a7f, 0x3ae8, 0x1823,
            0xb8b4, 0xf99a, 0x590d, 0x930f, 0x3398, 0x72b6, 0xd221, 0xf0ea, 0x507d, 0x1153, 0xb1c4,
            0x54c5, 0xf452, 0xb57c, 0x15eb, 0x3720, 0x97b7, 0xd699, 0x760e, 0xe20a, 0x429d, 0x03b3,
            0xa324, 0x81ef, 0x2178, 0x6056, 0xc0c1, 0x25c0, 0x8557, 0xc479, 0x64ee, 0x4625, 0xe6b2,
            0xa79c, 0x070b, 0xcd09, 0x6d9e, 0x2cb0, 0x8c27, 0xaeec, 0x0e7b, 0x4f55, 0xefc2, 0x0ac3,
            0xaa54, 0xeb7a, 0x4bed, 0x6926, 0xc9b1, 0x889f, 0x2808, 0xd88f, 0x7818, 0x3936, 0x99a1,
            0xbb6a, 0x1bfd, 0x5ad3, 0xfa44, 0x1f45, 0xbfd2, 0xfefc, 0x5e6b, 0x7ca0, 0xdc37, 0x9d19,
            0x3d8e, 0xf78c, 0x571b, 0x1635, 0xb6a2, 0x9469, 0x34fe, 0x75d0, 0xd547, 0x3046, 0x90d1,
            0xd1ff, 0x7168, 0x53a3, 0xf334, 0xb21a, 0x128d, 0x8689, 0x261e, 0x6730, 0xc7a7, 0xe56c,
            0x45fb, 0x04d5, 0xa442, 0x4143, 0xe1d4, 0xa0fa, 0x006d, 0x22a6, 0x8231, 0xc31f, 0x6388,
            0xa98a, 0x091d, 0x4833, 0xe8a4, 0xca6f, 0x6af8, 0x2bd6, 0x8b41, 0x6e40, 0xced7, 0x8ff9,
            0x2f6e, 0x0da5, 0xad32, 0xec1c, 0x4c8b, 0x6483, 0xc414, 0x853a, 0x25ad, 0x0766, 0xa7f1,
            0xe6df, 0x4648, 0xa349, 0x03de, 0x42f0, 0xe267, 0xc0ac, 0x603b, 0x2115, 0x8182, 0x4b80,
            0xeb17, 0xaa39, 0x0aae, 0x2865, 0x88f2, 0xc9dc, 0x694b, 0x8c4a, 0x2cdd, 0x6df3, 0xcd64,
            0xefaf, 0x4f38, 0x0e16, 0xae81, 0x3a85, 0x9a12, 0xdb3c, 0x7bab, 0x5960, 0xf9f7, 0xb8d9,
            0x184e, 0xfd4f, 0x5dd8, 0x1cf6, 0xbc61, 0x9eaa, 0x3e3d, 0x7f13, 0xdf84, 0x1586, 0xb511,
            0xf43f, 0x54a8, 0x7663, 0xd6f4, 0x97da, 0x374d, 0xd24c, 0x72db, 0x33f5, 0x9362, 0xb1a9,
            0x113e, 0x5010, 0xf087,
        ],
        [
            0x0000, 0x1189, 0x2312, 0x329b, 0x4624, 0x57ad, 0x6536, 0x74bf, 0x8c48, 0x9dc1, 0xaf5a,
            0xbed3, 0xca6c, 0xdbe5, 0xe97e, 0xf8f7, 0xb807, 0xa98e, 0x9b15, 0x8a9c, 0xfe23, 0xefaa,
            0xdd31, 0xccb8, 0x344f, 0x25c6, 0x175d, 0x06d4, 0x726b, 0x63e2, 0x5179, 0x40f0, 0xd099,
            0xc110, 0xf38b, 0xe202, 0x96bd, 0x8734, 0xb5af, 0xa426, 0x5cd1, 0x4d58, 0x7fc3, 0x6e4a,
            0x1af5, 0x0b7c, 0x39e7, 0x286e, 0x689e, 0x7917, 0x4b8c, 0x5a05, 0x2eba, 0x3f33, 0x0da8,
            0x1c21, 0xe4d6, 0xf55f, 0xc7c4, 0xd64d, 0xa2f2, 0xb37b, 0x81e0, 0x9069, 0x01a5, 0x102c,
            0x22b7, 0x333e, 0x4781, 0x5608, 0x6493, 0x751a, 0x8ded, 0x9c64, 0xaeff, 0xbf76, 0xcbc9,
            0xda40, 0xe8db, 0xf952, 0xb9a2, 0xa82b, 0x9ab0, 0x8b39, 0xff86, 0xee0f, 0xdc94, 0xcd1d,
            0x35ea, 0x2463, 0x16f8, 0x0771, 0x73ce, 0x6247, 0x50dc, 0x4155, 0xd13c, 0xc0b5, 0xf22e,
            0xe3a7, 0x9718, 0x8691, 0xb40a, 0xa583, 0x5d74, 0x4cfd, 0x7e66, 0x6fef, 0x1b50, 0x0ad9,
            0x3842, 0x29cb, 0x693b, 0x78b2, 0x4a29, 0x5ba0, 0x2f1f, 0x3e96, 0x0c0d, 0x1d84, 0xe573,
            0xf4fa, 0xc661, 0xd7e8, 0xa357, 0xb2de, 0x8045, 0x91cc, 0x034a, 0x12c3, 0x2058, 0x31d1,
            0x456e, 0x54e7, 0x667c, 0x77f5, 0x8f02, 0x9e8b, 0xac10, 0xbd99, 0xc926, 0xd8af, 0xea34,
            0xfbbd, 0xbb4d, 0xaac4, 0x985f, 0x89d6, 0xfd69, 0xece0, 0xde7b, 0xcff2, 0x3705, 0x268c,
            0x1417, 0x059e, 0x7121, 0x60a8, 0x5233, 0x43ba, 0xd3d3, 0xc25a, 0xf0c1, 0xe148, 0x95f7,
            0x847e, 0xb6e5, 0xa76c, 0x5f9b, 0x4e12, 0x7c89, 0x6d00, 0x19bf, 0x0836, 0x3aad, 0x2b24,
            0x6bd4, 0x7a5d, 0x48c6, 0x594f, 0x2df0, 0x3c79, 0x0ee2, 0x1f6b, 0xe79c, 0xf615, 0xc48e,
            0xd507, 0xa1b8, 0xb031, 0x82aa, 0x9323, 0x02ef, 0x1366, 0x21fd, 0x3074, 0x44cb, 0x5542,
            0x67d9, 0x7650, 0x8ea7, 0x9f2e, 0xadb5, 0xbc3c, 0xc883, 0xd90a, 0xeb91, 0xfa18, 0xbae8,
            0xab61, 0x99fa, 0x8873, 0xfccc, 0xed45, 0xdfde, 0xce57, 0x36a0, 0x2729, 0x15b2, 0x043b,
            0x7084, 0x610d, 0x5396, 0x421f, 0xd276, 0xc3ff, 0xf164, 0xe0ed, 0x9452, 0x85db, 0xb740,
            0xa6c9, 0x5e3e, 0x4fb7, 0x7d2c, 0x6ca5, 0x181a, 0x0993, 0x3b08, 0x2a81, 0x6a71, 0x7bf8,
            0x4963, 0x58ea, 0x2c55, 0x3ddc, 0x0f47, 0x1ece, 0xe639, 0xf7b0, 0xc52b, 0xd4a2, 0xa01d,
            0xb194, 0x830f, 0x9286,
        ],
        [
            0x0000, 0x0694, 0x0d28, 0x0bbc, 0x1a50, 0x1cc4, 0x1778, 0x11ec, 0x34a0, 0x3234, 0x3988,
            0x3f1c, 0x2ef0, 0x2864, 0x23d8, 0x254c, 0x6940, 0x6fd4, 0x6468, 0x62fc, 0x7310, 0x7584,
            0x7e38, 0x78ac, 0x5de0, 0x5b74, 0x50c8, 0x565c, 0x47b0, 0x4124, 0x4a98, 0x4c0c, 0xd280,
            0xd414, 0xdfa8, 0xd93c, 0xc8d0, 0xce44, 0xc5f8, 0xc36c, 0xe620, 0xe0b4, 0xeb08, 0xed9c,
            0xfc70, 0xfae4, 0xf158, 0xf7cc, 0xbbc0, 0xbd54, 0xb6e8, 0xb07c, 0xa190, 0xa704, 0xacb8,
            0xaa2c, 0x8f60, 0x89f4, 0x8248, 0x84dc, 0x9530, 0x93a4, 0x9818, 0x9e8c, 0x0597, 0x0303,
            0x08bf, 0x0e2b, 0x1fc7, 0x1953, 0x12ef, 0x147b, 0x3137, 0x37a3, 0x3c1f, 0x3a8b, 0x2b67,
            0x2df3, 0x264f, 0x20db, 0x6cd7, 0x6a43, 0x61ff, 0x676b, 0x7687, 0x7013, 0x7baf, 0x7d3b,
            0x5877, 0x5ee3, 0x555f, 0x53cb, 0x4227, 0x44b3, 0x4f0f, 0x499b, 0xd717, 0xd183, 0xda3f,
            0xdcab, 0xcd47, 0xcbd3, 0xc06f, 0xc6fb, 0xe3b7, 0xe523, 0xee9f, 0xe80b, 0xf9e7, 0xff73,
            0xf4cf, 0xf25b, 0xbe57, 0xb8c3, 0xb37f, 0xb5eb, 0xa407, 0xa293, 0xa92f, 0xafbb, 0x8af7,
            0x8c63, 0x87df, 0x814b, 0x90a7, 0x9633, 0x9d8f, 0x9b1b, 0x0b2e, 0x0dba, 0x0606, 0x0092,
            0x117e, 0x17ea, 0x1c56, 0x1ac2, 0x3f8e, 0x391a, 0x32a6, 0x3432, 0x25de, 0x234a, 0x28f6,
            0x2e62, 0x626e, 0x64fa, 0x6f46, 0x69d2, 0x783e, 0x7eaa, 0x7516, 0x7382, 0x56ce, 0x505a,
            0x5be6, 0x5d72, 0x4c9e, 0x4a0a, 0x41b6, 0x4722, 0xd9ae, 0xdf3a, 0xd486, 0xd212, 0xc3fe,
            0xc56a, 0xced6, 0xc842, 0xed0e, 0xeb9a, 0xe026, 0xe6b2, 0xf75e, 0xf1ca, 0xfa76, 0xfce2,
            0xb0ee, 0xb67a, 0xbdc6, 0xbb52, 0xaabe, 0xac2a, 0xa796, 0xa102, 0x844e, 0x82da, 0x8966,
            0x8ff2, 0x9e1e, 0x988a, 0x9336, 0x95a2, 0x0eb9, 0x082d, 0x0391, 0x0505, 0x14e9, 0x127d,
            0x19c1, 0x1f55, 0x3a19, 0x3c8d, 0x3731, 0x31a5, 0x2049, 0x26dd, 0x2d61, 0x2bf5, 0x67f9,
            0x616d, 0x6ad1, 0x6c45, 0x7da9, 0x7b3d, 0x7081, 0x7615, 0x5359, 0x55cd, 0x5e71, 0x58e5,
            0x4909, 0x4f9d, 0x4421, 0x42b5, 0xdc39, 0xdaad, 0xd111, 0xd785, 0xc669, 0xc0fd, 0xcb41,
            0xcdd5, 0xe899, 0xee0d, 0xe5b1, 0xe325, 0xf2c9, 0xf45d, 0xffe1, 0xf975, 0xb579, 0xb3ed,
            0xb851, 0xbec5, 0xaf29, 0xa9bd, 0xa201, 0xa495, 0x81d9, 0x874d, 0x8cf1, 0x8a65, 0x9b89,
            0x9d1d, 0x96a1, 0x9035,
        ],
        [
            0x0000, 0x165c, 0x2cb8, 0x3ae4, 0x5970, 0x4f2c, 0x75c8, 0x6394, 0xb2e0, 0xa4bc, 0x9e58,
            0x8804, 0xeb90, 0xfdcc, 0xc728, 0xd174, 0xc557, 0xd30b, 0xe9ef, 0xffb3, 0x9c27, 0x8a7b,
            0xb09f, 0xa6c3, 0x77b7, 0x61eb, 0x5b0f, 0x4d53, 0x2ec7, 0x389b, 0x027f, 0x1423, 0x2a39,
            0x3c65, 0x0681, 0x10dd, 0x7349, 0x6515, 0x5ff1, 0x49ad, 0x98d9, 0x8e85, 0xb461, 0xa23d,
            0xc1a9, 0xd7f5, 0xed11, 0xfb4d, 0xef6e, 0xf932, 0xc3d6, 0xd58a, 0xb61e, 0xa042, 0x9aa6,
            0x8cfa, 0x5d8e, 0x4bd2, 0x7136, 0x676a, 0x04fe, 0x12a2, 0x2846, 0x3e1a, 0x5472, 0x422e,
            0x78ca, 0x6e96, 0x0d02, 0x1b5e, 0x21ba, 0x37e6, 0xe692, 0xf0ce, 0xca2a, 0xdc76, 0xbfe2,
            0xa9be, 0x935a, 0x8506, 0x9125, 0x8779, 0xbd9d, 0xabc1, 0xc855, 0xde09, 0xe4ed, 0xf2b1,
            0x23c5, 0x3599, 0x0f7d, 0x1921, 0x7ab5, 0x6ce9, 0x560d, 0x4051, 0x7e4b, 0x6817, 0x52f3,
            0x44af, 0x273b, 0x3167, 0x0b83, 0x1ddf, 0xccab, 0xdaf7, 0xe013, 0xf64f, 0x95db, 0x8387,
            0xb963, 0xaf3f, 0xbb1c, 0xad40, 0x97a4, 0x81f8, 0xe26c, 0xf430, 0xced4, 0xd888, 0x09fc,
            0x1fa0, 0x2544, 0x3318, 0x508c, 0x46d0, 0x7c34, 0x6a68, 0xa8e4, 0xbeb8, 0x845c, 0x9200,
            0xf194, 0xe7c8, 0xdd2c, 0xcb70, 0x1a04, 0x0c58, 0x36bc, 0x20e0, 0x4374, 0x5528, 0x6fcc,
            0x7990, 0x6db3, 0x7bef, 0x410b, 0x5757, 0x34c3, 0x229f, 0x187b, 0x0e27, 0xdf53, 0xc90f,
            0xf3eb, 0xe5b7, 0x8623, 0x907f, 0xaa9b, 0xbcc7, 0x82dd, 0x9481, 0xae65, 0xb839, 0xdbad,
            0xcdf1, 0xf715, 0xe149, 0x303d, 0x2661, 0x1c85, 0x0ad9, 0x694d, 0x7f11, 0x45f5, 0x53a9,
            0x478a, 0x51d6, 0x6b32, 0x7d6e, 0x1efa, 0x08a6, 0x3242, 0x241e, 0xf56a, 0xe336, 0xd9d2,
            0xcf8e, 0xac1a, 0xba46, 0x80a2, 0x96fe, 0xfc96, 0xeaca, 0xd02e, 0xc672, 0xa5e6, 0xb3ba,
            0x895e, 0x9f02, 0x4e76, 0x582a, 0x62ce, 0x7492, 0x1706, 0x015a, 0x3bbe, 0x2de2, 0x39c1,
            0x2f9d, 0x1579, 0x0325, 0x60b1, 0x76ed, 0x4c09, 0x5a55, 0x8b21, 0x9d7d, 0xa799, 0xb1c5,
            0xd251, 0xc40d, 0xfee9, 0xe8b5, 0xd6af, 0xc0f3, 0xfa17, 0xec4b, 0x8fdf, 0x9983, 0xa367,
            0xb53b, 0x644f, 0x7213, 0x48f7, 0x5eab, 0x3d3f, 0x2b63, 0x1187, 0x07db, 0x13f8, 0x05a4,
            0x3f40, 0x291c, 0x4a88, 0x5cd4, 0x6630, 0x706c, 0xa118, 0xb744, 0x8da0, 0x9bfc, 0xf868,
            0xee34, 0xd4d0, 0xc28c,
        ],
        [
            0x0000, 0xf15f, 0x4229, 0xb376, 0x8452, 0x750d, 0xc67b, 0x3724, 0xa833, 0x596c, 0xea1a,
            0x1b45, 0x2c61, 0xdd3e, 0x6e48, 0x9f17, 0xf0f1, 0x01ae, 0xb2d8, 0x4387, 0x74a3, 0x85fc,
            0x368a, 0xc7d5, 0x58c2, 0xa99d, 0x1aeb, 0xebb4, 0xdc90, 0x2dcf, 0x9eb9, 0x6fe6, 0x4175,
            0xb02a, 0x035c, 0xf203, 0xc527, 0x3478, 0x870e, 0x7651, 0xe946, 0x1819, 0xab6f, 0x5a30,
            0x6d14, 0x9c4b, 0x2f3d, 0xde62, 0xb184, 0x40db, 0xf3ad, 0x02f2, 0x35d6, 0xc489, 0x77ff,
            0x86a0, 0x19b7, 0xe8e8, 0x5b9e, 0xaac1, 0x9de5, 0x6cba, 0xdfcc, 0x2e93, 0x82ea, 0x73b5,
            0xc0c3, 0x319c, 0x06b8, 0xf7e7, 0x4491, 0xb5ce, 0x2ad9, 0xdb86, 0x68f0, 0x99af, 0xae8b,
            0x5fd4, 0xeca2, 0x1dfd, 0x721b, 0x8344, 0x3032, 0xc16d, 0xf649, 0x0716, 0xb460, 0x453f,
            0xda28, 0x2b77, 0x9801, 0x695e, 0x5e7a, 0xaf25, 0x1c53, 0xed0c, 0xc39f, 0x32c0, 0x81b6,
            0x70e9, 0x47cd, 0xb692, 0x05e4, 0xf4bb, 0x6bac, 0x9af3, 0x2985, 0xd8da, 0xeffe, 0x1ea1,
            0xadd7, 0x5c88, 0x336e, 0xc231, 0x7147, 0x8018, 0xb73c, 0x4663, 0xf515, 0x044a, 0x9b5d,
            0x6a02, 0xd974, 0x282b, 0x1f0f, 0xee50, 0x5d26, 0xac79, 0xa543, 0x541c, 0xe76a, 0x1635,
            0x2111, 0xd04e, 0x6338, 0x9267, 0x0d70, 0xfc2f, 0x4f59, 0xbe06, 0x8922, 0x787d, 0xcb0b,
            0x3a54, 0x55b2, 0xa4ed, 0x179b, 0xe6c4, 0xd1e0, 0x20bf, 0x93c9, 0x6296, 0xfd81, 0x0cde,
            0xbfa8, 0x4ef7, 0x79d3, 0x888c, 0x3bfa, 0xcaa5, 0xe436, 0x1569, 0xa61f, 0x5740, 0x6064,
            0x913b, 0x224d, 0xd312, 0x4c05, 0xbd5a, 0x0e2c, 0xff73, 0xc857, 0x3908, 0x8a7e, 0x7b21,
            0x14c7, 0xe598, 0x56ee, 0xa7b1, 0x9095, 0x61ca, 0xd2bc, 0x23e3, 0xbcf4, 0x4dab, 0xfedd,
            0x0f82, 0x38a6, 0xc9f9, 0x7a8f, 0x8bd0, 0x27a9, 0xd6f6, 0x6580, 0x94df, 0xa3fb, 0x52a4,
            0xe1d2, 0x108d, 0x8f9a, 0x7ec5, 0xcdb3, 0x3cec, 0x0bc8, 0xfa97, 0x49e1, 0xb8be, 0xd758,
            0x2607, 0x9571, 0x642e, 0x530a, 0xa255, 0x1123, 0xe07c, 0x7f6b, 0x8e34, 0x3d42, 0xcc1d,
            0xfb39, 0x0a66, 0xb910, 0x484f, 0x66dc, 0x9783, 0x24f5, 0xd5aa, 0xe28e, 0x13d1, 0xa0a7,
            0x51f8, 0xceef, 0x3fb0, 0x8cc6, 0x7d99, 0x4abd, 0xbbe2, 0x0894, 0xf9cb, 0x962d, 0x6772,
            0xd404, 0x255b, 0x127f, 0xe320, 0x5056, 0xa109, 0x3e1e, 0xcf41, 0x7c37, 0x8d68, 0xba4c,
            0x4b13, 0xf865, 0x093a,
        ],
        [
            0x0000, 0xea11, 0x74b5, 0x9ea4, 0xe96a, 0x037b, 0x9ddf, 0x77ce, 0x7243, 0x9852, 0x06f6,
            0xece7, 0x9b29, 0x7138, 0xef9c, 0x058d, 0xe486, 0x0e97, 0x9033, 0x7a22, 0x0dec, 0xe7fd,
            0x7959, 0x9348, 0x96c5, 0x7cd4, 0xe270, 0x0861, 0x7faf, 0x95be, 0x0b1a, 0xe10b, 0x699b,
            0x838a, 0x1d2e, 0xf73f, 0x80f1, 0x6ae0, 0xf444, 0x1e55, 0x1bd8, 0xf1c9, 0x6f6d, 0x857c,
            0xf2b2, 0x18a3, 0x8607, 0x6c16, 0x8d1d, 0x670c, 0xf9a8, 0x13b9, 0x6477, 0x8e66, 0x10c2,
            0xfad3, 0xff5e, 0x154f, 0x8beb, 0x61fa, 0x1634, 0xfc25, 0x6281, 0x8890, 0xd336, 0x3927,
            0xa783, 0x4d92, 0x3a5c, 0xd04d, 0x4ee9, 0xa4f8, 0xa175, 0x4b64, 0xd5c0, 0x3fd1, 0x481f,
            0xa20e, 0x3caa, 0xd6bb, 0x37b0, 0xdda1, 0x4305, 0xa914, 0xdeda, 0x34cb, 0xaa6f, 0x407e,
            0x45f3, 0xafe2, 0x3146, 0xdb57, 0xac99, 0x4688, 0xd82c, 0x323d, 0xbaad, 0x50bc, 0xce18,
            0x2409, 0x53c7, 0xb9d6, 0x2772, 0xcd63, 0xc8ee, 0x22ff, 0xbc5b, 0x564a, 0x2184, 0xcb95,
            0x5531, 0xbf20, 0x5e2b, 0xb43a, 0x2a9e, 0xc08f, 0xb741, 0x5d50, 0xc3f4, 0x29e5, 0x2c68,
            0xc679, 0x58dd, 0xb2cc, 0xc502, 0x2f13, 0xb1b7, 0x5ba6, 0x06fb, 0xecea, 0x724e, 0x985f,
            0xef91, 0x0580, 0x9b24, 0x7135, 0x74b8, 0x9ea9, 0x000d, 0xea1c, 0x9dd2, 0x77c3, 0xe967,
            0x0376, 0xe27d, 0x086c, 0x96c8, 0x7cd9, 0x0b17, 0xe106, 0x7fa2, 0x95b3, 0x903e, 0x7a2f,
            0xe48b, 0x0e9a, 0x7954, 0x9345, 0x0de1, 0xe7f0, 0x6f60, 0x8571, 0x1bd5, 0xf1c4, 0x860a,
            0x6c1b, 0xf2bf, 0x18ae, 0x1d23, 0xf732, 0x6996, 0x8387, 0xf449, 0x1e58, 0x80fc, 0x6aed,
            0x8be6, 0x61f7, 0xff53, 0x1542, 0x628c, 0x889d, 0x1639, 0xfc28, 0xf9a5, 0x13b4, 0x8d10,
            0x6701, 0x10cf, 0xfade, 0x647a, 0x8e6b, 0xd5cd, 0x3fdc, 0xa178, 0x4b69, 0x3ca7, 0xd6b6,
            0x4812, 0xa203, 0xa78e, 0x4d9f, 0xd33b, 0x392a, 0x4ee4, 0xa4f5, 0x3a51, 0xd040, 0x314b,
            0xdb5a, 0x45fe, 0xafef, 0xd821, 0x3230, 0xac94, 0x4685, 0x4308, 0xa919, 0x37bd, 0xddac,
            0xaa62, 0x4073, 0xded7, 0x34c6, 0xbc56, 0x5647, 0xc8e3, 0x22f2, 0x553c, 0xbf2d, 0x2189,
            0xcb98, 0xce15, 0x2404, 0xbaa0, 0x50b1, 0x277f, 0xcd6e, 0x53ca, 0xb9db, 0x58d0, 0xb2c1,
            0x2c65, 0xc674, 0xb1ba, 0x5bab, 0xc50f, 0x2f1e, 0x2a93, 0xc082, 0x5e26, 0xb437, 0xc3f9,
            0x29e8, 0xb74c, 0x5d5d,
        ],
        [
            0x0000, 0x0df6, 0x1bec, 0x161a, 0x37d8, 0x3a2e, 0x2c34, 0x21c2, 0x6fb0, 0x6246, 0x745c,
            0x79aa, 0x5868, 0x559e, 0x4384, 0x4e72, 0xdf60, 0xd296, 0xc48c, 0xc97a, 0xe8b8, 0xe54e,
            0xf354, 0xfea2, 0xb0d0, 0xbd26, 0xab3c, 0xa6ca, 0x8708, 0x8afe, 0x9ce4, 0x9112, 0x1e57,
            0x13a1, 0x05bb, 0x084d, 0x298f, 0x2479, 0x3263, 0x3f95, 0x71e7, 0x7c11, 0x6a0b, 0x67fd,
            0x463f, 0x4bc9, 0x5dd3, 0x5025, 0xc137, 0xccc1, 0xdadb, 0xd72d, 0xf6ef, 0xfb19, 0xed03,
            0xe0f5, 0xae87, 0xa371, 0xb56b, 0xb89d, 0x995f, 0x94a9, 0x82b3, 0x8f45, 0x3cae, 0x3158,
            0x2742, 0x2ab4, 0x0b76, 0x0680, 0x109a, 0x1d6c, 0x531e, 0x5ee8, 0x48f2, 0x4504, 0x64c6,
            0x6930, 0x7f2a, 0x72dc, 0xe3ce, 0xee38, 0xf822, 0xf5d4, 0xd416, 0xd9e0, 0xcffa, 0xc20c,
            0x8c7e, 0x8188, 0x9792, 0x9a64, 0xbba6, 0xb650, 0xa04a, 0xadbc, 0x22f9, 0x2f0f, 0x3915,
            0x34e3, 0x1521, 0x18d7, 0x0ecd, 0x033b, 0x4d49, 0x40bf, 0x56a5, 0x5b53, 0x7a91, 0x7767,
            0x617d, 0x6c8b, 0xfd99, 0xf06f, 0xe675, 0xeb83, 0xca41, 0xc7b7, 0xd1ad, 0xdc5b, 0x9229,
            0x9fdf, 0x89c5, 0x8433, 0xa5f1, 0xa807, 0xbe1d, 0xb3eb, 0x795c, 0x74aa, 0x62b0, 0x6f46,
            0x4e84, 0x4372, 0x5568, 0x589e, 0x16ec, 0x1b1a, 0x0d00, 0x00f6, 0x2134, 0x2cc2, 0x3ad8,
            0x372e, 0xa63c, 0xabca, 0xbdd0, 0xb026, 0x91e4, 0x9c12, 0x8a08, 0x87fe, 0xc98c, 0xc47a,
            0xd260, 0xdf96, 0xfe54, 0xf3a2, 0xe5b8, 0xe84e, 0x670b, 0x6afd, 0x7ce7, 0x7111, 0x50d3,
            0x5d25, 0x4b3f, 0x46c9, 0x08bb, 0x054d, 0x1357, 0x1ea1, 0x3f63, 0x3295, 0x248f, 0x2979,
            0xb86b, 0xb59d, 0xa387, 0xae71, 0x8fb3, 0x8245, 0x945f, 0x99a9, 0xd7db, 0xda2d, 0xcc37,
            0xc1c1, 0xe003, 0xedf5, 0xfbef, 0xf619, 0x45f2, 0x4804, 0x5e1e, 0x53e8, 0x722a, 0x7fdc,
            0x69c6, 0x6430, 0x2a42, 0x27b4, 0x31ae, 0x3c58, 0x1d9a, 0x106c, 0x0676, 0x0b80, 0x9a92,
            0x9764, 0x817e, 0x8c88, 0xad4a, 0xa0bc, 0xb6a6, 0xbb50, 0xf522, 0xf8d4, 0xeece, 0xe338,
            0xc2fa, 0xcf0c, 0xd916, 0xd4e0, 0x5ba5, 0x5653, 0x4049, 0x4dbf, 0x6c7d, 0x618b, 0x7791,
            0x7a67, 0x3415, 0x39e3, 0x2ff9, 0x220f, 0x03cd, 0x0e3b, 0x1821, 0x15d7, 0x84c5, 0x8933,
            0x9f29, 0x92df, 0xb31d, 0xbeeb, 0xa8f1, 0xa507, 0xeb75, 0xe683, 0xf099, 0xfd6f, 0xdcad,
            0xd15b, 0xc741, 0xcab7,
        ],
        [
            0x0000, 0xf2b8, 0x45e7, 0xb75f, 0x8bce, 0x7976, 0xce29, 0x3c91, 0xb70b, 0x45b3, 0xf2ec,
            0x0054, 0x3cc5, 0xce7d, 0x7922, 0x8b9a, 0xce81, 0x3c39, 0x8b66, 0x79de, 0x454f, 0xb7f7,
            0x00a8, 0xf210, 0x798a, 0x8b32, 0x3c6d, 0xced5, 0xf244, 0x00fc, 0xb7a3, 0x451b, 0x3d95,
            0xcf2d, 0x7872, 0x8aca, 0xb65b, 0x44e3, 0xf3bc, 0x0104, 0x8a9e, 0x7826, 0xcf79, 0x3dc1,
            0x0150, 0xf3e8, 0x44b7, 0xb60f, 0xf314, 0x01ac, 0xb6f3, 0x444b, 0x78da, 0x8a62, 0x3d3d,
            0xcf85, 0x441f, 0xb6a7, 0x01f8, 0xf340, 0xcfd1, 0x3d69, 0x8a36, 0x788e, 0x7b2a, 0x8992,
            0x3ecd, 0xcc75, 0xf0e4, 0x025c, 0xb503, 0x47bb, 0xcc21, 0x3e99, 0x89c6, 0x7b7e, 0x47ef,
            0xb557, 0x0208, 0xf0b0, 0xb5ab, 0x4713, 0xf04c, 0x02f4, 0x3e65, 0xccdd, 0x7b82, 0x893a,
            0x02a0, 0xf018, 0x4747, 0xb5ff, 0x896e, 0x7bd6, 0xcc89, 0x3e31, 0x46bf, 0xb407, 0x0358,
            0xf1e0, 0xcd71, 