// Code generated by protoc-gen-go. DO NOT EDIT.
// versions:
// 	protoc-gen-go v1.29.0
// 	protoc        v3.17.3
// source: yandex/cloud/apploadbalancer/v1/load_balancer.proto

package apploadbalancer

import (
	_ "github.com/yandex-cloud/go-genproto/yandex/cloud"
	protoreflect "google.golang.org/protobuf/reflect/protoreflect"
	protoimpl "google.golang.org/protobuf/runtime/protoimpl"
	timestamppb "google.golang.org/protobuf/types/known/timestamppb"
	reflect "reflect"
	sync "sync"
)

const (
	// Verify that this generated code is sufficiently up-to-date.
	_ = protoimpl.EnforceVersion(20 - protoimpl.MinVersion)
	// Verify that runtime/protoimpl is sufficiently up-to-date.
	_ = protoimpl.EnforceVersion(protoimpl.MaxVersion - 20)
)

type LoadBalancer_Status int32

const (
	LoadBalancer_STATUS_UNSPECIFIED LoadBalancer_Status = 0
	// The application load balancer is being created.
	LoadBalancer_CREATING LoadBalancer_Status = 1
	// The application load balancer is being started.
	LoadBalancer_STARTING LoadBalancer_Status = 2
	// The application load balancer is active and sends traffic to the targets.
	LoadBalancer_ACTIVE LoadBalancer_Status = 3
	// The application load balancer is being stopped.
	LoadBalancer_STOPPING LoadBalancer_Status = 4
	// The application load balancer is stopped and doesn't send traffic to the targets.
	LoadBalancer_STOPPED LoadBalancer_Status = 5
	// The application load balancer is being deleted.
	LoadBalancer_DELETING LoadBalancer_Status = 6
)

// Enum value maps for LoadBalancer_Status.
var (
	LoadBalancer_Status_name = map[int32]string{
		0: "STATUS_UNSPECIFIED",
		1: "CREATING",
		2: "STARTING",
		3: "ACTIVE",
		4: "STOPPING",
		5: "STOPPED",
		6: "DELETING",
	}
	LoadBalancer_Status_value = map[string]int32{
		"STATUS_UNSPECIFIED": 0,
		"CREATING":           1,
		"STARTING":           2,
		"ACTIVE":             3,
		"STOPPING":           4,
		"STOPPED":            5,
		"DELETING":           6,
	}
)

func (x LoadBalancer_Status) Enum() *LoadBalancer_Status {
	p := new(LoadBalancer_Status)
	*p = x
	return p
}

func (x LoadBalancer_Status) String() string {
	return protoimpl.X.EnumStringOf(x.Descriptor(), protoreflect.EnumNumber(x))
}

func (LoadBalancer_Status) Descriptor() protoreflect.EnumDescriptor {
	return file_yandex_cloud_apploadbalancer_v1_load_balancer_proto_enumTypes[0].Descriptor()
}

func (LoadBalancer_Status) Type() protoreflect.EnumType {
	return &file_yandex_cloud_apploadbalancer_v1_load_balancer_proto_enumTypes[0]
}

func (x LoadBalancer_Status) Number() protoreflect.EnumNumber {
	return protoreflect.EnumNumber(x)
}

// Deprecated: Use LoadBalancer_Status.Descriptor instead.
func (LoadBalancer_Status) EnumDescriptor() ([]byte, []int) {
	return file_yandex_cloud_apploadbalancer_v1_load_balancer_proto_rawDescGZIP(), []int{0, 0}
}

// Supported target statuses.
type TargetState_Status int32

const (
	TargetState_STATUS_UNSPECIFIED TargetState_Status = 0
	// All of the health checks specified in [HttpBackend.healthchecks] or [GrpcBackend.healthchecks] are passed
	// (the number depends on the [HealthCheck.healthy_threshold] setting) and the target is ready to receive traffic.
	TargetState_HEALTHY TargetState_Status = 1
	// Some of the health checks specified in [HttpBackend.healthchecks] or [GrpcBackend.healthchecks] failed
	// (the number depends on the [HealthCheck.unhealthy_threshold] setting).
	// The target is ready to receive traffic from the load balancer nodes which, based on their health checks,
	// consider the target healthy.
	TargetState_PARTIALLY_HEALTHY TargetState_Status = 2
	// All of the health checks specified in [HttpBackend.healthchecks] or [GrpcBackend.healthchecks] failed
	// (the number depends on the [HealthCheck.unhealthy_threshold] setting) and the target is not receiving traffic.
	TargetState_UNHEALTHY TargetState_Status = 3
	// Target is being deleted and the application load balancer is no longer sending traffic to this target.
	TargetState_DRAINING TargetState_Status = 4
	TargetState_TIMEOUT  TargetState_Status = 5
)

// Enum value maps for TargetState_Status.
var (
	TargetState_Status_name = map[int32]string{
		0: "STATUS_UNSPECIFIED",
		1: "HEALTHY",
		2: "PARTIALLY_HEALTHY",
		3: "UNHEALTHY",
		4: "DRAINING",
		5: "TIMEOUT",
	}
	TargetState_Status_value = map[string]int32{
		"STATUS_UNSPECIFIED": 0,
		"HEALTHY":            1,
		"PARTIALLY_HEALTHY":  2,
		"UNHEALTHY":          3,
		"DRAINING":           4,
		"TIMEOUT":            5,
	}
)

func (x TargetState_Status) Enum() *TargetState_Status {
	p := new(TargetState_Status)
	*p = x
	return p
}

func (x TargetState_Status) String() string {
	return protoimpl.X.EnumStringOf(x.Descriptor(), protoreflect.EnumNumber(x))
}

func (TargetState_Status) Descriptor() protoreflect.EnumDescriptor {
	return file_yandex_cloud_apploadbalancer_v1_load_balancer_proto_enumTypes[1].Descriptor()
}

func (TargetState_Status) Type() protoreflect.EnumType {
	return &file_yandex_cloud_apploadbalancer_v1_load_balancer_proto_enumTypes[1]
}

func (x TargetState_Status) Number() protoreflect.EnumNumber {
	return protoreflect.EnumNumber(x)
}

// Deprecated: Use TargetState_Status.Descriptor instead.
func (TargetState_Status) EnumDescriptor() ([]byte, []int) {
	return file_yandex_cloud_apploadbalancer_v1_load_balancer_proto_rawDescGZIP(), []int{18, 0}
}

// An application load balancer resource.
// For details about the concept, see [documentation](/docs/application-load-balancer/concepts/application-load-balancer).
type LoadBalancer struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// ID of the application load balancer. Generated at creation time.
	Id string `protobuf:"bytes,1,opt,name=id,proto3" json:"id,omitempty"`
	// Name of the application load balancer. The name is unique within the folder.
	Name string `protobuf:"bytes,2,opt,name=name,proto3" json:"name,omitempty"`
	// Description of the application load balancer.
	Description string `protobuf:"bytes,3,opt,name=description,proto3" json:"description,omitempty"`
	// ID of the folder that the application load balancer belongs to.
	FolderId string `protobuf:"bytes,4,opt,name=folder_id,json=folderId,proto3" json:"folder_id,omitempty"`
	// Application load balancer labels as `key:value` pairs.
	// For details about the concept, see [documentation](/docs/overview/concepts/services#labels).
	Labels map[string]string `protobuf:"bytes,5,rep,name=labels,proto3" json:"labels,omitempty" protobuf_key:"bytes,1,opt,name=key,proto3" protobuf_val:"bytes,2,opt,name=value,proto3"`
	// Status of the application load balancer.
	Status LoadBalancer_Status `protobuf:"varint,6,opt,name=status,proto3,enum=yandex.cloud.apploadbalancer.v1.LoadBalancer_Status" json:"status,omitempty"`
	// ID of the region that the application load balancer is located at.
	RegionId string `protobuf:"bytes,7,opt,name=region_id,json=regionId,proto3" json:"region_id,omitempty"`
	// ID of the network that the application load balancer belongs to.
	NetworkId string `protobuf:"bytes,8,opt,name=network_id,json=networkId,proto3" json:"network_id,omitempty"`
	// Listeners that belong to the application load balancer.
	//
	// For details about the concept, see [documentation](/docs/application-load-balancer/concepts/application-load-balancer#listener).
	Listeners []*Listener `protobuf:"bytes,9,rep,name=listeners,proto3" json:"listeners,omitempty"`
	// Locality settings of the application load balancer.
	//
	// For details about the concept, see [documentation](/docs/application-load-balancer/concepts/application-load-balancer#lb-location).
	AllocationPolicy *AllocationPolicy `protobuf:"bytes,10,opt,name=allocation_policy,json=allocationPolicy,proto3" json:"allocation_policy,omitempty"`
	// ID of the log group that stores access logs of the application load balancer.
	//
	// The logs can be accessed using a Cloud Functions [trigger for Cloud Logs](/docs/functions/operations/trigger/cloudlogs-trigger-create).
	LogGroupId string `protobuf:"bytes,11,opt,name=log_group_id,json=logGroupId,proto3" json:"log_group_id,omitempty"`
	// ID's of the security groups attributed to the application load balancer.
	//
	// For details about the concept,
	// see [documentation](/docs/application-load-balancer/concepts/application-load-balancer#security-groups).
	SecurityGroupIds []string `protobuf:"bytes,12,rep,name=security_group_ids,json=securityGroupIds,proto3" json:"security_group_ids,omitempty"`
	// Creation timestamp.
	CreatedAt *timestamppb.Timestamp `protobuf:"bytes,13,opt,name=created_at,json=createdAt,proto3" json:"created_at,omitempty"`
	// Scaling settings of the application load balancer.
	//
	// The scaling settings relate to a special internal instance group which facilitates the balancer's work.
	// Instances in this group are called _resource units_. The group is scaled automatically based on incoming load
	// and within limitations specified in these settings.
	//
	// For details about the concept,
	// see [documentation](/docs/application-load-balancer/concepts/application-load-balancer#lcu-scaling).
	AutoScalePolicy *AutoScalePolicy `protobuf:"bytes,14,opt,name=auto_scale_policy,json=autoScalePolicy,proto3" json:"auto_scale_policy,omitempty"`
	// Cloud logging settings of the application load balancer.
	LogOptions *LogOptions `protobuf:"bytes,15,opt,name=log_options,json=logOptions,proto3" json:"log_options,omitempty"`
}

func (x *LoadBalancer) Reset() {
	*x = LoadBalancer{}
	if protoimpl.UnsafeEnabled {
		mi := &file_yandex_cloud_apploadbalancer_v1_load_balancer_proto_msgTypes[0]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *LoadBalancer) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*LoadBalancer) ProtoMessage() {}

func (x *LoadBalancer) ProtoReflect() protoreflect.Message {
	mi := &file_yandex_cloud_apploadbalancer_v1_load_balancer_proto_msgTypes[0]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use LoadBalancer.ProtoReflect.Descriptor instead.
func (*LoadBalancer) Descriptor() ([]byte, []int) {
	return file_yandex_cloud_apploadbalancer_v1_load_balancer_proto_rawDescGZIP(), []int{0}
}

func (x *LoadBalancer) GetId() string {
	if x != nil {
		return x.Id
	}
	return ""
}

func (x *LoadBalancer) GetName() string {
	if x != nil {
		return x.Name
	}
	return ""
}

func (x *LoadBalancer) GetDescription() string {
	if x != nil {
		return x.Description
	}
	return ""
}

func (x *LoadBalancer) GetFolderId() string {
	if x != nil {
		return x.FolderId
	}
	return ""
}

func (x *LoadBalancer) GetLabels() map[string]string {
	if x != nil {
		return x.Labels
	}
	return nil
}

func (x *LoadBalancer) GetStatus() LoadBalancer_Status {
	if x != nil {
		return x.Status
	}
	return LoadBalancer_STATUS_UNSPECIFIED
}

func (x *LoadBalancer) GetRegionId() string {
	if x != nil {
		return x.RegionId
	}
	return ""
}

func (x *LoadBalancer) GetNetworkId() string {
	if x != nil {
		return x.NetworkId
	}
	return ""
}

func (x *LoadBalancer) GetListeners() []*Listener {
	if x != nil {
		return x.Listeners
	}
	return nil
}

func (x *LoadBalancer) GetAllocationPolicy() *AllocationPolicy {
	if x != nil {
		return x.AllocationPolicy
	}
	return nil
}

func (x *LoadBalancer) GetLogGroupId() string {
	if x != nil {
		return x.LogGroupId
	}
	return ""
}

func (x *LoadBalancer) GetSecurityGroupIds() []string {
	if x != nil {
		return x.SecurityGroupIds
	}
	return nil
}

func (x *LoadBalancer) GetCreatedAt() *timestamppb.Timestamp {
	if x != nil {
		return x.CreatedAt
	}
	return nil
}

func (x *LoadBalancer) GetAutoScalePolicy() *AutoScalePolicy {
	if x != nil {
		return x.AutoScalePolicy
	}
	return nil
}

func (x *LoadBalancer) GetLogOptions() *LogOptions {
	if x != nil {
		return x.LogOptions
	}
	return nil
}

// An endpoint address resource.
type Address struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Endpoint address of one of the types: public (external) IPv4 address, internal IPv4 address, public IPv6 address.
	//
	// Types that are assignable to Address:
	//
	//	*Address_ExternalIpv4Address
	//	*Address_InternalIpv4Address
	//	*Address_ExternalIpv6Address
	Address isAddress_Address `protobuf_oneof:"address"`
}

func (x *Address) Reset() {
	*x = Address{}
	if protoimpl.UnsafeEnabled {
		mi := &file_yandex_cloud_apploadbalancer_v1_load_balancer_proto_msgTypes[1]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *Address) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*Address) ProtoMessage() {}

func (x *Address) ProtoReflect() protoreflect.Message {
	mi := &file_yandex_cloud_apploadbalancer_v1_load_balancer_proto_msgTypes[1]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use Address.ProtoReflect.Descriptor instead.
func (*Address) Descriptor() ([]byte, []int) {
	return file_yandex_cloud_apploadbalancer_v1_load_balancer_proto_rawDescGZIP(), []int{1}
}

func (m *Address) GetAddress() isAddress_Address {
	if m != nil {
		return m.Address
	}
	return nil
}

func (x *Address) GetExternalIpv4Address() *ExternalIpv4Address {
	if x, ok := x.GetAddress().(*Address_ExternalIpv4Address); ok {
		return x.ExternalIpv4Address
	}
	return nil
}

func (x *Address) GetInternalIpv4Address() *InternalIpv4Address {
	if x, ok := x.GetAddress().(*Address_InternalIpv4Address); ok {
		return x.InternalIpv4Address
	}
	return nil
}

func (x *Address) GetExternalIpv6Address() *ExternalIpv6Address {
	if x, ok := x.GetAddress().(*Address_ExternalIpv6Address); ok {
		return x.ExternalIpv6Address
	}
	return nil
}

type isAddress_Address interface {
	isAddress_Address()
}

type Address_ExternalIpv4Address struct {
	// Public IPv4 endpoint address.
	ExternalIpv4Address *ExternalIpv4Address `protobuf:"bytes,1,opt,name=external_ipv4_address,json=externalIpv4Address,proto3,oneof"`
}

type Address_InternalIpv4Address struct {
	// Internal IPv4 endpoint address.
	//
	// To enable the use of listeners with internal addresses, [contact support](https://console.cloud.yandex.ru/support).
	InternalIpv4Address *InternalIpv4Address `protobuf:"bytes,2,opt,name=internal_ipv4_address,json=internalIpv4Address,proto3,oneof"`
}

type Address_ExternalIpv6Address struct {
	// Public IPv6 endpoint address.
	ExternalIpv6Address *ExternalIpv6Address `protobuf:"bytes,3,opt,name=external_ipv6_address,json=externalIpv6Address,proto3,oneof"`
}

func (*Address_ExternalIpv4Address) isAddress_Address() {}

func (*Address_InternalIpv4Address) isAddress_Address() {}

func (*Address_ExternalIpv6Address) isAddress_Address() {}

// A public (external) IPv4 endpoint address resource.
type ExternalIpv4Address struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// IPv4 address.
	Address string `protobuf:"bytes,1,opt,name=address,proto3" json:"address,omitempty"`
}

func (x *ExternalIpv4Address) Reset() {
	*x = ExternalIpv4Address{}
	if protoimpl.UnsafeEnabled {
		mi := &file_yandex_cloud_apploadbalancer_v1_load_balancer_proto_msgTypes[2]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *ExternalIpv4Address) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*ExternalIpv4Address) ProtoMessage() {}

func (x *ExternalIpv4Address) ProtoReflect() protoreflect.Message {
	mi := &file_yandex_cloud_apploadbalancer_v1_load_balancer_proto_msgTypes[2]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use ExternalIpv4Address.ProtoReflect.Descriptor instead.
func (*ExternalIpv4Address) Descriptor() ([]byte, []int) {
	return file_yandex_cloud_apploadbalancer_v1_load_balancer_proto_rawDescGZIP(), []int{2}
}

func (x *ExternalIpv4Address) GetAddress() string {
	if x != nil {
		return x.Address
	}
	return ""
}

// An internal IPv4 endpoint address resource.
type InternalIpv4Address struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// IPv4 address.
	Address string `protobuf:"bytes,1,opt,name=address,proto3" json:"address,omitempty"`
	// ID of the subnet that the address belongs to.
	SubnetId string `protobuf:"bytes,2,opt,name=subnet_id,json=subnetId,proto3" json:"subnet_id,omitempty"`
}

func (x *InternalIpv4Address) Reset() {
	*x = InternalIpv4Address{}
	if protoimpl.UnsafeEnabled {
		mi := &file_yandex_cloud_apploadbalancer_v1_load_balancer_proto_msgTypes[3]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *InternalIpv4Address) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*InternalIpv4Address) ProtoMessage() {}

func (x *InternalIpv4Address) ProtoReflect() protoreflect.Message {
	mi := &file_yandex_cloud_apploadbalancer_v1_load_balancer_proto_msgTypes[3]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use InternalIpv4Address.ProtoReflect.Descriptor instead.
func (*InternalIpv4Address) Descriptor() ([]byte, []int) {
	return file_yandex_cloud_apploadbalancer_v1_load_balancer_proto_rawDescGZIP(), []int{3}
}

func (x *InternalIpv4Address) GetAddress() string {
	if x != nil {
		return x.Address
	}
	return ""
}

func (x *InternalIpv4Address) GetSubnetId() string {
	if x != nil {
		return x.SubnetId
	}
	return ""
}

// A public (external) IPv4 endpoint address resource.
type ExternalIpv6Address struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// IPv6 address.
	Address string `protobuf:"bytes,1,opt,name=address,proto3" json:"address,omitempty"`
}

func (x *ExternalIpv6Address) Reset() {
	*x = ExternalIpv6Address{}
	if protoimpl.UnsafeEnabled {
		mi := &file_yandex_cloud_apploadbalancer_v1_load_balancer_proto_msgTypes[4]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *ExternalIpv6Address) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*ExternalIpv6Address) ProtoMessage() {}

func (x *ExternalIpv6Address) ProtoReflect() protoreflect.Message {
	mi := &file_yandex_cloud_apploadbalancer_v1_load_balancer_proto_msgTypes[4]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use ExternalIpv6Address.ProtoReflect.Descriptor instead.
func (*ExternalIpv6Address) Descriptor() ([]byte, []int) {
	return file_yandex_cloud_apploadbalancer_v1_load_balancer_proto_rawDescGZIP(), []int{4}
}

func (x *ExternalIpv6Address) GetAddress() string {
	if x != nil {
		return x.Address
	}
	return ""
}

// An application load balancer location resource.
//
// For details about the concept, see [documentation](/docs/application-load-balancer/concepts/application-load-balancer#lb-location).
type Location struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// ID of the availability zone where the application load balancer resides.
	//
	// Each availability zone can only be specified once.
	ZoneId string `protobuf:"bytes,1,opt,name=zone_id,json=zoneId,proto3" json:"zone_id,omitempty"`
	// ID of the subnet that the application load balancer belongs to.
	SubnetId string `protobuf:"bytes,2,opt,name=subnet_id,json=subnetId,proto3" json:"subnet_id,omitempty"`
	// Disables the load balancer node in the specified availability zone.
	//
	// Backends in the availability zone are not directly affected by this setting.
	// They still may receive traffic from the load balancer nodes in other availability zones,
	// subject to [LoadBalancingConfig.locality_aware_routing_percent] and [LoadBalancingConfig.strict_locality] settings.
	DisableTraffic bool `protobuf:"varint,3,opt,name=disable_traffic,json=disableTraffic,proto3" json:"disable_traffic,omitempty"`
}

func (x *Location) Reset() {
	*x = Location{}
	if protoimpl.UnsafeEnabled {
		mi := &file_yandex_cloud_apploadbalancer_v1_load_balancer_proto_msgTypes[5]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *Location) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*Location) ProtoMessage() {}

func (x *Location) ProtoReflect() protoreflect.Message {
	mi := &file_yandex_cloud_apploadbalancer_v1_load_balancer_proto_msgTypes[5]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use Location.ProtoReflect.Descriptor instead.
func (*Location) Descriptor() ([]byte, []int) {
	return file_yandex_cloud_apploadbalancer_v1_load_balancer_proto_rawDescGZIP(), []int{5}
}

func (x *Location) GetZoneId() string {
	if x != nil {
		return x.ZoneId
	}
	return ""
}

func (x *Location) GetSubnetId() string {
	if x != nil {
		return x.SubnetId
	}
	return ""
}

func (x *Location) GetDisableTraffic() bool {
	if x != nil {
		return x.DisableTraffic
	}
	return false
}

// A locality settings (allocation policy) resource.
type AllocationPolicy struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Availability zones and subnets that the application load balancer resides.
	Locations []*Location `protobuf:"bytes,1,rep,name=locations,proto3" json:"locations,omitempty"`
}

func (x *AllocationPolicy) Reset() {
	*x = AllocationPolicy{}
	if protoimpl.UnsafeEnabled {
		mi := &file_yandex_cloud_apploadbalancer_v1_load_balancer_proto_msgTypes[6]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *AllocationPolicy) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*AllocationPolicy) ProtoMessage() {}

func (x *AllocationPolicy) ProtoReflect() protoreflect.Message {
	mi := &file_yandex_cloud_apploadbalancer_v1_load_balancer_proto_msgTypes[6]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use AllocationPolicy.ProtoReflect.Descriptor instead.
func (*AllocationPolicy) Descriptor() ([]byte, []int) {
	return file_yandex_cloud_apploadbalancer_v1_load_balancer_proto_rawDescGZIP(), []int{6}
}

func (x *AllocationPolicy) GetLocations() []*Location {
	if x != nil {
		return x.Locations
	}
	return nil
}

// A listener resource.
//
// For details about the concept, see [documentation](/docs/application-load-balancer/concepts/application-load-balancer#listener).
type Listener struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Name of the listener. The name is unique within the application load balancer.
	// The string length in characters is 3-63.
	Name string `protobuf:"bytes,1,opt,name=name,proto3" json:"name,omitempty"`
	// Endpoints of the listener.
	//
	// Endpoints are defined by their IP addresses and ports.
	Endpoints []*Endpoint `protobuf:"bytes,2,rep,name=endpoints,proto3" json:"endpoints,omitempty"`
	// Listener type and settings.
	//
	// Types that are assignable to Listener:
	//
	//	*Listener_Http
	//	*Listener_Tls
	//	*Listener_Stream
	Listener isListener_Listener `protobuf_oneof:"listener"`
}

func (x *Listener) Reset() {
	*x = Listener{}
	if protoimpl.UnsafeEnabled {
		mi := &file_yandex_cloud_apploadbalancer_v1_load_balancer_proto_msgTypes[7]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *Listener) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*Listener) ProtoMessage() {}

func (x *Listener) ProtoReflect() protoreflect.Message {
	mi := &file_yandex_cloud_apploadbalancer_v1_load_balancer_proto_msgTypes[7]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use Listener.ProtoReflect.Descriptor instead.
func (*Listener) Descriptor() ([]byte, []int) {
	return file_yandex_cloud_apploadbalancer_v1_load_balancer_proto_rawDescGZIP(), []int{7}
}

func (x *Listener) GetName() string {
	if x != nil {
		return x.Name
	}
	return ""
}

func (x *Listener) GetEndpoints() []*Endpoint {
	if x != nil {
		return x.Endpoints
	}
	return nil
}

func (m *Listener) GetListener() isListener_Listener {
	if m != nil {
		return m.Listener
	}
	return nil
}

func (x *Listener) GetHttp() *HttpListener {
	if x, ok := x.GetListener().(*Listener_Http); ok {
		return x.Http
	}
	return nil
}

func (x *Listener) GetTls() *TlsListener {
	if x, ok := x.GetListener().(*Listener_Tls); ok {
		return x.Tls
	}
	return nil
}

func (x *Listener) GetStream() *StreamListener {
	if x, ok := x.GetListener().(*Listener_Stream); ok {
		return x.Stream
	}
	return nil
}

type isListener_Listener interface {
	isListener_Listener()
}

type Listener_Http struct {
	// Unencrypted HTTP listener settings.
	Http *HttpListener `protobuf:"bytes,3,opt,name=http,proto3,oneof"`
}

type Listener_Tls struct {
	// TLS-encrypted HTTP or TCP stream listener settings.
	//
	// All handlers within a listener ([TlsListener.default_handler] and [TlsListener.sni_handlers]) must be of one
	// type, [HttpHandler] or [StreamHandler]. Mixing HTTP and TCP stream traffic in a TLS-encrypted listener is not
	// supported.
	Tls *TlsListener `protobuf:"bytes,4,opt,name=tls,proto3,oneof"`
}

type Listener_Stream struct {
	// Unencrypted stream (TCP) listener settings.
	Stream *StreamListener `protobuf:"bytes,5,opt,name=stream,proto3,oneof"`
}

func (*Listener_Http) isListener_Listener() {}

func (*Listener_Tls) isListener_Listener() {}

func (*Listener_Stream) isListener_Listener() {}

// An endpoint resource.
type Endpoint struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Endpoint public (external) and internal addresses.
	Addresses []*Address `protobuf:"bytes,1,rep,name=addresses,proto3" json:"addresses,omitempty"`
	// Endpoint ports.
	Ports []int64 `protobuf:"varint,2,rep,packed,name=ports,proto3" json:"ports,omitempty"`
}

func (x *Endpoint) Reset() {
	*x = Endpoint{}
	if protoimpl.UnsafeEnabled {
		mi := &file_yandex_cloud_apploadbalancer_v1_load_balancer_proto_msgTypes[8]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *Endpoint) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*Endpoint) ProtoMessage() {}

func (x *Endpoint) ProtoReflect() protoreflect.Message {
	mi := &file_yandex_cloud_apploadbalancer_v1_load_balancer_proto_msgTypes[8]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use Endpoint.ProtoReflect.Descriptor instead.
func (*Endpoint) Descriptor() ([]byte, []int) {
	return file_yandex_cloud_apploadbalancer_v1_load_balancer_proto_rawDescGZIP(), []int{8}
}

func (x *Endpoint) GetAddresses() []*Address {
	if x != nil {
		return x.Addresses
	}
	return nil
}

func (x *Endpoint) GetPorts() []int64 {
	if x != nil {
		return x.Ports
	}
	return nil
}

// An HTTP listener resource.
type HttpListener struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Settings for handling HTTP requests.
	//
	// Only one of `handler` and [redirects] can be specified.
	Handler *HttpHandler `protobuf:"bytes,1,opt,name=handler,proto3" json:"handler,omitempty"`
	// Redirects settings.
	//
	// Only one of `redirects` and [handler] can be specified.
	Redirects *Redirects `protobuf:"bytes,2,opt,name=redirects,proto3" json:"redirects,omitempty"`
}

func (x *HttpListener) Reset() {
	*x = HttpListener{}
	if protoimpl.UnsafeEnabled {
		mi := &file_yandex_cloud_apploadbalancer_v1_load_balancer_proto_msgTypes[9]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *HttpListener) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*HttpListener) ProtoMessage() {}

func (x *HttpListener) ProtoReflect() protoreflect.Message {
	mi := &file_yandex_cloud_apploadbalancer_v1_load_balancer_proto_msgTypes[9]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use HttpListener.ProtoReflect.Descriptor instead.
func (*HttpListener) Descriptor() ([]byte, []int) {
	return file_yandex_cloud_apploadbalancer_v1_load_balancer_proto_rawDescGZIP(), []int{9}
}

func (x *HttpListener) GetHandler() *HttpHandler {
	if x != nil {
		return x.Handler
	}
	return nil
}

func (x *HttpListener) GetRedirects() *Redirects {
	if x != nil {
		return x.Redirects
	}
	return nil
}

// TLS-encrypted (HTTP or TCP stream) listener resource.
type TlsListener struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Settings for handling requests by default, with Server Name
	// Indication (SNI) not matching any of the [sni_handlers].
	DefaultHandler *TlsHandler `protobuf:"bytes,1,opt,name=default_handler,json=defaultHandler,proto3" json:"default_handler,omitempty"`
	// Settings for handling requests with Server Name Indication (SNI)
	// matching one of [SniMatch.server_names] values.
	SniHandlers []*SniMatch `protobuf:"bytes,2,rep,name=sni_handlers,json=sniHandlers,proto3" json:"sni_handlers,omitempty"`
}

func (x *TlsListener) Reset() {
	*x = TlsListener{}
	if protoimpl.UnsafeEnabled {
		mi := &file_yandex_cloud_apploadbalancer_v1_load_balancer_proto_msgTypes[10]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *TlsListener) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*TlsListener) ProtoMessage() {}

func (x *TlsListener) ProtoReflect() protoreflect.Message {
	mi := &file_yandex_cloud_apploadbalancer_v1_load_balancer_proto_msgTypes[10]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use TlsListener.ProtoReflect.Descriptor instead.
func (*TlsListener) Descriptor() ([]byte, []int) {
	return file_yandex_cloud_apploadbalancer_v1_load_balancer_proto_rawDescGZIP(), []int{10}
}

func (x *TlsListener) GetDefaultHandler() *TlsHandler {
	if x != nil {
		return x.DefaultHandler
	}
	return nil
}

func (x *TlsListener) GetSniHandlers() []*SniMatch {
	if x != nil {
		return x.SniHandlers
	}
	return nil
}

// A stream (TCP) listener resource.
type StreamListener struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Settings for handling stream (TCP) requests.
	Handler *StreamHandler `protobuf:"bytes,1,opt,name=handler,proto3" json:"handler,omitempty"`
}

func (x *StreamListener) Reset() {
	*x = StreamListener{}
	if protoimpl.UnsafeEnabled {
		mi := &file_yandex_cloud_apploadbalancer_v1_load_balancer_proto_msgTypes[11]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *StreamListener) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*StreamListener) ProtoMessage() {}

func (x *StreamListener) ProtoReflect() protoreflect.Message {
	mi := &file_yandex_cloud_apploadbalancer_v1_load_balancer_proto_msgTypes[11]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use StreamListener.ProtoReflect.Descriptor instead.
func (*StreamListener) Descriptor() ([]byte, []int) {
	return file_yandex_cloud_apploadbalancer_v1_load_balancer_proto_rawDescGZIP(), []int{11}
}

func (x *StreamListener) GetHandler() *StreamHandler {
	if x != nil {
		return x.Handler
	}
	return nil
}

// An HTTP/2 options resource.
type Http2Options struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Maximum number of concurrent HTTP/2 streams in a connection.
	MaxConcurrentStreams int64 `protobuf:"varint,1,opt,name=max_concurrent_streams,json=maxConcurrentStreams,proto3" json:"max_concurrent_streams,omitempty"`
}

func (x *Http2Options) Reset() {
	*x = Http2Options{}
	if protoimpl.UnsafeEnabled {
		mi := &file_yandex_cloud_apploadbalancer_v1_load_balancer_proto_msgTypes[12]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *Http2Options) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*Http2Options) ProtoMessage() {}

func (x *Http2Options) ProtoReflect() protoreflect.Message {
	mi := &file_yandex_cloud_apploadbalancer_v1_load_balancer_proto_msgTypes[12]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use Http2Options.ProtoReflect.Descriptor instead.
func (*Http2Options) Descriptor() ([]byte, []int) {
	return file_yandex_cloud_apploadbalancer_v1_load_balancer_proto_rawDescGZIP(), []int{12}
}

func (x *Http2Options) GetMaxConcurrentStreams() int64 {
	if x != nil {
		return x.MaxConcurrentStreams
	}
	return 0
}

// A stream (TCP) handler resource.
type StreamHandler struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// ID of the backend group processing requests. For details about the concept, see
	// [documentation](/docs/application-load-balancer/concepts/backend-group).
	//
	// The backend group type, specified via [BackendGroup.backend], must be `stream`.
	//
	// To get the list of all available backend groups, make a [BackendGroupService.List] request.
	BackendGroupId string `protobuf:"bytes,1,opt,name=backend_group_id,json=backendGroupId,proto3" json:"backend_group_id,omitempty"`
}

func (x *StreamHandler) Reset() {
	*x = StreamHandler{}
	if protoimpl.UnsafeEnabled {
		mi := &file_yandex_cloud_apploadbalancer_v1_load_balancer_proto_msgTypes[13]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *StreamHandler) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*StreamHandler) ProtoMessage() {}

func (x *StreamHandler) ProtoReflect() protoreflect.Message {
	mi := &file_yandex_cloud_apploadbalancer_v1_load_balancer_proto_msgTypes[13]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use StreamHandler.ProtoReflect.Descriptor instead.
func (*StreamHandler) Descriptor() ([]byte, []int) {
	return file_yandex_cloud_apploadbalancer_v1_load_balancer_proto_rawDescGZIP(), []int{13}
}

func (x *StreamHandler) GetBackendGroupId() string {
	if x != nil {
		return x.BackendGroupId
	}
	return ""
}

// An HTTP handler resource.
type HttpHandler struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// ID of the HTTP router processing requests. For details about the concept, see
	// [documentation](/docs/application-load-balancer/concepts/http-router).
	//
	// To get the list of all available HTTP routers, make a [HttpRouterService.List] request.
	HttpRouterId string `protobuf:"bytes,1,opt,name=http_router_id,json=httpRouterId,proto3" json:"http_router_id,omitempty"`
	// Protocol settings.
	//
	// For HTTPS (HTTP over TLS) connections, settings are applied to the protocol
	// negotiated using TLS [ALPN](https://en.wikipedia.org/wiki/Application-Layer_Protocol_Negotiation) extension.
	//
	// Types that are assignable to ProtocolSettings:
	//
	//	*HttpHandler_Http2Options
	//	*HttpHandler_AllowHttp10
	ProtocolSettings isHttpHandler_ProtocolSettings `protobuf_oneof:"protocol_settings"`
	// When unset, will preserve the incoming x-request-id header, otherwise would rewrite it with a new value.
	RewriteRequestId bool `protobuf:"varint,4,opt,name=rewrite_request_id,json=rewriteRequestId,proto3" json:"rewrite_request_id,omitempty"`
}

func (x *HttpHandler) Reset() {
	*x = HttpHandler{}
	if protoimpl.UnsafeEnabled {
		mi := &file_yandex_cloud_apploadbalancer_v1_load_balancer_proto_msgTypes[14]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *HttpHandler) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*HttpHandler) ProtoMessage() {}

func (x *HttpHandler) ProtoReflect() protoreflect.Message {
	mi := &file_yandex_cloud_apploadbalancer_v1_load_balancer_proto_msgTypes[14]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use HttpHandler.ProtoReflect.Descriptor instead.
func (*HttpHandler) Descriptor() ([]byte, []int) {
	return file_yandex_cloud_apploadbalancer_v1_load_balancer_proto_rawDescGZIP(), []int{14}
}

func (x *HttpHandler) GetHttpRouterId() string {
	if x != nil {
		return x.HttpRouterId
	}
	return ""
}

func (m *HttpHandler) GetProtocolSettings() isHttpHandler_ProtocolSettings {
	if m != nil {
		return m.ProtocolSettings
	}
	return nil
}

func (x *HttpHandler) GetHttp2Options() *Http2Options {
	if x, ok := x.GetProtocolSettings().(*HttpHandler_Http2Options); ok {
		return x.Http2Options
	}
	return nil
}

func (x *HttpHandler) GetAllowHttp10() bool {
	if x, ok := x.GetProtocolSettings().(*HttpHandler_AllowHttp10); ok {
		return x.AllowHttp10
	}
	return false
}

func (x *HttpHandler) GetRewriteRequestId() bool {
	if x != nil {
		return x.RewriteRequestId
	}
	return false
}

type isHttpHandler_ProtocolSettings interface {
	isHttpHandler_ProtocolSettings()
}

type HttpHandler_Http2Options struct {
	// HTTP/2 settings.
	//
	// If specified, incoming HTTP/2 requests are supported by the listener.
	Http2Options *Http2Options `protobuf:"bytes,2,opt,name=http2_options,json=http2Options,proto3,oneof"`
}

type HttpHandler_AllowHttp10 struct {
	// Enables support for incoming HTTP/1.0 and HTTP/1.1 requests and disables it for HTTP/2 requests.
	AllowHttp10 bool `protobuf:"varint,3,opt,name=allow_http10,json=allowHttp10,proto3,oneof"`
}

func (*HttpHandler_Http2Options) isHttpHandler_ProtocolSettings() {}

func (*HttpHandler_AllowHttp10) isHttpHandler_ProtocolSettings() {}

// A listener redirects resource.
type Redirects struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Redirects all unencrypted HTTP requests to the same URI with scheme changed to `https`.
	//
	// The setting has the same effect as a single, catch-all [HttpRoute]
	// with [RedirectAction.replace_scheme] set to `https`.
	HttpToHttps bool `protobuf:"varint,1,opt,name=http_to_https,json=httpToHttps,proto3" json:"http_to_https,omitempty"`
}

func (x *Redirects) Reset() {
	*x = Redirects{}
	if protoimpl.UnsafeEnabled {
		mi := &file_yandex_cloud_apploadbalancer_v1_load_balancer_proto_msgTypes[15]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *Redirects) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*Redirects) ProtoMessage() {}

func (x *Redirects) ProtoReflect() protoreflect.Message {
	mi := &file_yandex_cloud_apploadbalancer_v1_load_balancer_proto_msgTypes[15]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use Redirects.ProtoReflect.Descriptor instead.
func (*Redirects) Descriptor() ([]byte, []int) {
	return file_yandex_cloud_apploadbalancer_v1_load_balancer_proto_rawDescGZIP(), []int{15}
}

func (x *Redirects) GetHttpToHttps() bool {
	if x != nil {
		return x.HttpToHttps
	}
	return false
}

// A SNI handler resource.
type SniMatch struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Name of the SNI handler.
	Name string `protobuf:"bytes,1,opt,name=name,proto3" json:"name,omitempty"`
	// Server names that are matched by the SNI handler.
	ServerNames []string `protobuf:"bytes,2,rep,name=server_names,json=serverNames,proto3" json:"server_names,omitempty"`
	// Settings for handling requests with Server Name Indication (SNI) matching one of [server_names] values.
	Handler *TlsHandler `protobuf:"bytes,3,opt,name=handler,proto3" json:"handler,omitempty"`
}

func (x *SniMatch) Reset() {
	*x = SniMatch{}
	if protoimpl.UnsafeEnabled {
		mi := &file_yandex_cloud_apploadbalancer_v1_load_balancer_proto_msgTypes[16]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *SniMatch) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*SniMatch) ProtoMessage() {}

func (x *SniMatch) ProtoReflect() protoreflect.Message {
	mi := &file_yandex_cloud_apploadbalancer_v1_load_balancer_proto_msgTypes[16]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use SniMatch.ProtoReflect.Descriptor instead.
func (*SniMatch) Descriptor() ([]byte, []int) {
	return file_yandex_cloud_apploadbalancer_v1_load_balancer_proto_rawDescGZIP(), []int{16}
}

func (x *SniMatch) GetName() string {
	if x != nil {
		return x.Name
	}
	return ""
}

func (x *SniMatch) GetServerNames() []string {
	if x != nil {
		return x.ServerNames
	}
	return nil
}

func (x *SniMatch) GetHandler() *TlsHandler {
	if x != nil {
		return x.Handler
	}
	return nil
}

// A TLS-encrypted (HTTP or TCP stream) handler resource.
type TlsHandler struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Settings for handling requests.
	//
	// Types that are assignable to Handler:
	//
	//	*TlsHandler_HttpHandler
	//	*TlsHandler_StreamHandler
	Handler isTlsHandler_Handler `protobuf_oneof:"handler"`
	// ID's of the TLS server certificates from [Certificate Manager](/docs/certificate-manager/).
	//
	// RSA and ECDSA certificates are supported, and only the first certificate of each type is used.
	CertificateIds []string `protobuf:"bytes,3,rep,name=certificate_ids,json=certificateIds,proto3" json:"certificate_ids,omitempty"`
}

func (x *TlsHandler) Reset() {
	*x = TlsHandler{}
	if protoimpl.UnsafeEnabled {
		mi := &file_yandex_cloud_apploadbalancer_v1_load_balancer_proto_msgTypes[17]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *TlsHandler) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*TlsHandler) ProtoMessage() {}

func (x *TlsHandler) ProtoReflect() protoreflect.Message {
	mi := &file_yandex_cloud_apploadbalancer_v1_load_balancer_proto_msgTypes[17]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use TlsHandler.ProtoReflect.Descriptor instead.
func (*TlsHandler) Descriptor() ([]byte, []int) {
	return file_yandex_cloud_apploadbalancer_v1_load_balancer_proto_rawDescGZIP(), []int{17}
}

func (m *TlsHandler) GetHandler() isTlsHandler_Handler {
	if m != nil {
		return m.Handler
	}
	return nil
}

func (x *TlsHandler) GetHttpHandler() *HttpHandler {
	if x, ok := x.GetHandler().(*TlsHandler_HttpHandler); ok {
		return x.HttpHandler
	}
	return nil
}

func (x *TlsHandler) GetStreamHandler() *StreamHandler {
	if x, ok := x.GetHandler().(*TlsHandler_StreamHandler); ok {
		return x.StreamHandler
	}
	return nil
}

func (x *TlsHandler) GetCertificateIds() []string {
	if x != nil {
		return x.CertificateIds
	}
	return nil
}

type isTlsHandler_Handler interface {
	isTlsHandler_Handler()
}

type TlsHandler_HttpHandler struct {
	// HTTP handler.
	HttpHandler *HttpHandler `protobuf:"bytes,2,opt,name=http_handler,json=httpHandler,proto3,oneof"`
}

type TlsHandler_StreamHandler struct {
	// Stream (TCP) handler.
	StreamHandler *StreamHandler `protobuf:"bytes,4,opt,name=stream_handler,json=streamHandler,proto3,oneof"`
}

func (*TlsHandler_HttpHandler) isTlsHandler_Handler() {}

func (*TlsHandler_StreamHandler) isTlsHandler_Handler() {}

// A target state resource.
type TargetState struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Health of the target, i.e. its statuses in all availability zones.
	Status *TargetState_HealthcheckStatus `protobuf:"bytes,1,opt,name=status,proto3" json:"status,omitempty"`
	// Target.
	Target *Target `protobuf:"bytes,2,opt,name=target,proto3" json:"target,omitempty"`
}

func (x *TargetState) Reset() {
	*x = TargetState{}
	if protoimpl.UnsafeEnabled {
		mi := &file_yandex_cloud_apploadbalancer_v1_load_balancer_proto_msgTypes[18]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *TargetState) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*TargetState) ProtoMessage() {}

func (x *TargetState) ProtoReflect() protoreflect.Message {
	mi := &file_yandex_cloud_apploadbalancer_v1_load_balancer_proto_msgTypes[18]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use TargetState.ProtoReflect.Descriptor instead.
func (*TargetState) Descriptor() ([]byte, []int) {
	return file_yandex_cloud_apploadbalancer_v1_load_balancer_proto_rawDescGZIP(), []int{18}
}

func (x *TargetState) GetStatus() *TargetState_HealthcheckStatus {
	if x != nil {
		return x.Status
	}
	return nil
}

func (x *TargetState) GetTarget() *Target {
	if x != nil {
		return x.Target
	}
	return nil
}

// A resource for scaling settings of an application load balancer.
type AutoScalePolicy struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Lower limit for the number of resource units in each availability zone.
	//
	// If not specified previously (using other instruments such as management console), the default value is 2.
	// To revert to it, specify it explicitly.
	//
	// The minimum value is 2.
	MinZoneSize int64 `protobuf:"varint,1,opt,name=min_zone_size,json=minZoneSize,proto3" json:"min_zone_size,omitempty"`
	// Upper limit for the total number of resource units across all availability zones.
	//
	// If a positive value is specified, it must be at least [min_zone_size] multiplied by the size of
	// [AllocationPolicy.locations].
	//
	// If the value is 0, there is no upper limit.
	MaxSize int64 `protobuf:"varint,2,opt,name=max_size,json=maxSize,proto3" json:"max_size,omitempty"`
}

func (x *AutoScalePolicy) Reset() {
	*x = AutoScalePolicy{}
	if protoimpl.UnsafeEnabled {
		mi := &file_yandex_cloud_apploadbalancer_v1_load_balancer_proto_msgTypes[19]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *AutoScalePolicy) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*AutoScalePolicy) ProtoMessage() {}

func (x *AutoScalePolicy) ProtoReflect() protoreflect.Message {
	mi := &file_yandex_cloud_apploadbalancer_v1_load_balancer_proto_msgTypes[19]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use AutoScalePolicy.ProtoReflect.Descriptor instead.
func (*AutoScalePolicy) Descriptor() ([]byte, []int) {
	return file_yandex_cloud_apploadbalancer_v1_load_balancer_proto_rawDescGZIP(), []int{19}
}

func (x *AutoScalePolicy) GetMinZoneSize() int64 {
	if x != nil {
		return x.MinZoneSize
	}
	return 0
}

func (x *AutoScalePolicy) GetMaxSize() int64 {
	if x != nil {
		return x.MaxSize
	}
	return 0
}

// Health of the target.
type TargetState_HealthcheckStatus struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Statuses of the target in its availability zones.
	ZoneStatuses []*TargetState_ZoneHealthcheckStatus `protobuf:"bytes,1,rep,name=zone_statuses,json=zoneStatuses,proto3" json:"zone_statuses,omitempty"`
}

func (x *TargetState_HealthcheckStatus) Reset() {
	*x = TargetState_HealthcheckStatus{}
	if protoimpl.UnsafeEnabled {
		mi := &file_yandex_cloud_apploadbalancer_v1_load_balancer_proto_msgTypes[21]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *TargetState_HealthcheckStatus) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*TargetState_HealthcheckStatus) ProtoMessage() {}

func (x *TargetState_HealthcheckStatus) ProtoReflect() protoreflect.Message {
	mi := &file_yandex_cloud_apploadbalancer_v1_load_balancer_proto_msgTypes[21]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use TargetState_HealthcheckStatus.ProtoReflect.Descriptor instead.
func (*TargetState_HealthcheckStatus) Descriptor() ([]byte, []int) {
	return file_yandex_cloud_apploadbalancer_v1_load_balancer_proto_rawDescGZIP(), []int{18, 0}
}

func (x *TargetState_HealthcheckStatus) GetZoneStatuses() []*TargetState_ZoneHealthcheckStatus {
	if x != nil {
		return x.ZoneStatuses
	}
	return nil
}

// Health of the target in the availability zone.
type TargetState_ZoneHealthcheckStatus struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// ID of the availability zone.
	ZoneId string `protobuf:"bytes,1,opt,name=zone_id,json=zoneId,proto3" json:"zone_id,omitempty"`
	// Status of the target in the availability zone.
	Status TargetState_Status `protobuf:"varint,2,opt,name=status,proto3,enum=yandex.cloud.apploadbalancer.v1.TargetState_Status" json:"status,omitempty"`
	// Indicates whether the target has been marked `UNHEALTHY` due to failing active health checks,
	// which determine target statuses as configured in [HttpBackend.healthchecks] or [GrpcBackend.healthchecks].
	//
	// Currently the only type of health checks is active, as described above.
	// Passive health checks, which determine the health of a target based on its responses to production requests
	// (HTTP 5xx status codes, connection errors etc.), are not implemented yet.
	FailedActiveHc bool `protobuf:"varint,3,opt,name=failed_active_hc,json=failedActiveHc,proto3" json:"failed_active_hc,omitempty"`
}

func (x *TargetState_ZoneHealthcheckStatus) Reset() {
	*x = TargetState_ZoneHealthcheckStatus{}
	if protoimpl.UnsafeEnabled {
		mi := &file_yandex_cloud_apploadbalancer_v1_load_balancer_proto_msgTypes[22]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *TargetState_ZoneHealthcheckStatus) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*TargetState_ZoneHealthcheckStatus) ProtoMessage() {}

func (x *TargetState_ZoneHealthcheckStatus) ProtoReflect() protoreflect.Message {
	mi := &file_yandex_cloud_apploadbalancer_v1_load_balancer_proto_msgTypes[22]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use TargetState_ZoneHealthcheckStatus.ProtoReflect.Descriptor instead.
func (*TargetState_ZoneHealthcheckStatus) Descriptor() ([]byte, []int) {
	return file_yandex_cloud_apploadbalancer_v1_load_balancer_proto_rawDescGZIP(), []int{18, 1}
}

func (x *TargetState_ZoneHealthcheckStatus) GetZoneId() string {
	if x != nil {
		return x.ZoneId
	}
	return ""
}

func (x *TargetState_ZoneHealthcheckStatus) GetStatus() TargetState_Status {
	if x != nil {
		return x.Status
	}
	return TargetState_STATUS_UNSPECIFIED
}

func (x *TargetState_ZoneHealthcheckStatus) GetFailedActiveHc() bool {
	if x != nil {
		return x.FailedActiveHc
	}
	return false
}

var File_yandex_cloud_apploadbalancer_v1_load_balancer_proto protoreflect.FileDescriptor

var file_yandex_cloud_apploadbalancer_v1_load_balancer_proto_rawDesc = []byte{
	0x0a, 0x33, 0x79, 0x61, 0x6e, 0x64, 0x65, 0x78, 0x2f, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2f, 0x61,
	0x70, 0x70, 0x6c, 0x6f, 0x61, 0x64, 0x62, 0x61, 0x6c, 0x61, 0x6e, 0x63, 0x65, 0x72, 0x2f, 0x76,
	0x31, 0x2f, 0x6c, 0x6f, 0x61, 0x64, 0x5f, 0x62, 0x61, 0x6c, 0x61, 0x6e, 0x63, 0x65, 0x72, 0x2e,
	0x70, 0x72, 0x6f, 0x74, 0x6f, 0x12, 0x1f, 0x79, 0x61, 0x6e, 0x64, 0x65, 0x78, 0x2e, 0x63, 0x6c,
	0x6f, 0x75, 0x64, 0x2e, 0x61, 0x70, 0x70, 0x6c, 0x6f, 0x61, 0x64, 0x62, 0x61, 0x6c, 0x61, 0x6e,
	0x63, 0x65, 0x72, 0x2e, 0x76, 0x31, 0x1a, 0x1f, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2f, 0x70,
	0x72, 0x6f, 0x74, 0x6f, 0x62, 0x75, 0x66, 0x2f, 0x74, 0x69, 0x6d, 0x65, 0x73, 0x74, 0x61, 0x6d,
	0x70, 0x2e, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x1a, 0x1d, 0x79, 0x61, 0x6e, 0x64, 0x65, 0x78, 0x2f,
	0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2f, 0x76, 0x61, 0x6c, 0x69, 0x64, 0x61, 0x74, 0x69, 0x6f, 0x6e,
	0x2e, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x1a, 0x2d, 0x79, 0x61, 0x6e, 0x64, 0x65, 0x78, 0x2f, 0x63,
	0x6c, 0x6f, 0x75, 0x64, 0x2f, 0x61, 0x70, 0x70, 0x6c, 0x6f, 0x61, 0x64, 0x62, 0x61, 0x6c, 0x61,
	0x6e, 0x63, 0x65, 0x72, 0x2f, 0x76, 0x31, 0x2f, 0x6c, 0x6f, 0x67, 0x67, 0x69, 0x6e, 0x67, 0x2e,
	0x70, 0x72, 0x6f, 0x74, 0x6f, 0x1a, 0x32, 0x79, 0x61, 0x6e, 0x64, 0x65, 0x78, 0x2f, 0x63, 0x6c,
	0x6f, 0x75, 0x64, 0x2f, 0x61, 0x70, 0x70, 0x6c, 0x6f, 0x61, 0x64, 0x62, 0x61, 0x6c, 0x61, 0x6e,
	0x63, 0x65, 0x72, 0x2f, 0x76, 0x31, 0x2f, 0x74, 0x61, 0x72, 0x67, 0x65, 0x74, 0x5f, 0x67, 0x72,
	0x6f, 0x75, 0x70, 0x2e, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x22, 0xdc, 0x07, 0x0a, 0x0c, 0x4c, 0x6f,
	0x61, 0x64, 0x42, 0x61, 0x6c, 0x61, 0x6e, 0x63, 0x65, 0x72, 0x12, 0x0e, 0x0a, 0x02, 0x69, 0x64,
	0x18, 0x01, 0x20, 0x01, 0x28, 0x09, 0x52, 0x02, 0x69, 0x64, 0x12, 0x12, 0x0a, 0x04, 0x6e, 0x61,
	0x6d, 0x65, 0x18, 0x02, 0x20, 0x01, 0x28, 0x09, 0x52, 0x04, 0x6e, 0x61, 0x6d, 0x65, 0x12, 0x20,
	0x0a, 0x0b, 0x64, 0x65, 0x73, 0x63, 0x72, 0x69, 0x70, 0x74, 0x69, 0x6f, 0x6e, 0x18, 0x03, 0x20,
	0x01, 0x28, 0x09, 0x52, 0x0b, 0x64, 0x65, 0x73, 0x63, 0x72, 0x69, 0x70, 0x74, 0x69, 0x6f, 0x6e,
	0x12, 0x1b, 0x0a, 0x09, 0x66, 0x6f, 0x6c, 0x64, 0x65, 0x72, 0x5f, 0x69, 0x64, 0x18, 0x04, 0x20,
	0x01, 0x28, 0x09, 0x52, 0x08, 0x66, 0x6f, 0x6c, 0x64, 0x65, 0x72, 0x49, 0x64, 0x12, 0x51, 0x0a,
	0x06, 0x6c, 0x61, 0x62, 0x65, 0x6c, 0x73, 0x18, 0x05, 0x20, 0x03, 0x28, 0x0b, 0x32, 0x39, 0x2e,
	0x79, 0x61, 0x6e, 0x64, 0x65, 0x78, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x61, 0x70, 0x70,
	0x6c, 0x6f, 0x61, 0x64, 0x62, 0x61, 0x6c, 0x61, 0x6e, 0x63, 0x65, 0x72, 0x2e, 0x76, 0x31, 0x2e,
	0x4c, 0x6f, 0x61, 0x64, 0x42, 0x61, 0x6c, 0x61, 0x6e, 0x63, 0x65, 0x72, 0x2e, 0x4c, 0x61, 0x62,
	0x65, 0x6c, 0x73, 0x45, 0x6e, 0x74, 0x72, 0x79, 0x52, 0x06, 0x6c, 0x61, 0x62, 0x65, 0x6c, 0x73,
	0x12, 0x4c, 0x0a, 0x06, 0x73, 0x74, 0x61, 0x74, 0x75, 0x73, 0x18, 0x06, 0x20, 0x01, 0x28, 0x0e,
	0x32, 0x34, 0x2e, 0x79, 0x61, 0x6e, 0x64, 0x65, 0x78, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e,
	0x61, 0x70, 0x70, 0x6c, 0x6f, 0x61, 0x64, 0x62, 0x61, 0x6c, 0x61, 0x6e, 0x63, 0x65, 0x72, 0x2e,
	0x76, 0x31, 0x2e, 0x4c, 0x6f, 0x61, 0x64, 0x42, 0x61, 0x6c, 0x61, 0x6e, 0x63, 0x65, 0x72, 0x2e,
	0x53, 0x74, 0x61, 0x74, 0x75, 0x73, 0x52, 0x06, 0x73, 0x74, 0x61, 0x74, 0x75, 0x73, 0x12, 0x1b,
	0x0a, 0x09, 0x72, 0x65, 0x67, 0x69, 0x6f, 0x6e, 0x5f, 0x69, 0x64, 0x18, 0x07, 0x20, 0x01, 0x28,
	0x09, 0x52, 0x08, 0x72, 0x65, 0x67, 0x69, 0x6f, 0x6e, 0x49, 0x64, 0x12, 0x1d, 0x0a, 0x0a, 0x6e,
	0x65, 0x74, 0x77, 0x6f, 0x72, 0x6b, 0x5f, 0x69, 0x64, 0x18, 0x08, 0x20, 0x01, 0x28, 0x09, 0x52,
	0x09, 0x6e, 0x65, 0x74, 0x77, 0x6f, 0x72, 0x6b, 0x49, 0x64, 0x12, 0x47, 0x0a, 0x09, 0x6c, 0x69,
	0x73, 0x74, 0x65, 0x6e, 0x65, 0x72, 0x73, 0x18, 0x09, 0x20, 0x03, 0x28, 0x0b, 0x32, 0x29, 0x2e,
	0x79, 0x61, 0x6e, 0x64, 0x65, 0x78, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x61, 0x70, 0x70,
	0x6c, 0x6f, 0x61, 0x64, 0x62, 0x61, 0x6c, 0x61, 0x6e, 0x63, 0x65, 0x72, 0x2e, 0x76, 0x31, 0x2e,
	0x4c, 0x69, 0x73, 0x74, 0x65, 0x6e, 0x65, 0x72, 0x52, 0x09, 0x6c, 0x69, 0x73, 0x74, 0x65, 0x6e,
	0x65, 0x72, 0x73, 0x12, 0x5e, 0x0a, 0x11, 0x61, 0x6c, 0x6c, 0x6f, 0x63, 0x61, 0x74, 0x69, 0x6f,
	0x6e, 0x5f, 0x70, 0x6f, 0x6c, 0x69, 0x63, 0x79, 0x18, 0x0a, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x31,
	0x2e, 0x79, 0x61, 0x6e, 0x64, 0x65, 0x78, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x61, 0x70,
	0x70, 0x6c, 0x6f, 0x61, 0x64, 0x62, 0x61, 0x6c, 0x61, 0x6e, 0x63, 0x65, 0x72, 0x2e, 0x76, 0x31,
	0x2e, 0x41, 0x6c, 0x6c, 0x6f, 0x63, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x50, 0x6f, 0x6c, 0x69, 0x63,
	0x79, 0x52, 0x10, 0x61, 0x6c, 0x6c, 0x6f, 0x63, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x50, 0x6f, 0x6c,
	0x69, 0x63, 0x79, 0x12, 0x20, 0x0a, 0x0c, 0x6c, 0x6f, 0x67, 0x5f, 0x67, 0x72, 0x6f, 0x75, 0x70,
	0x5f, 0x69, 0x64, 0x18, 0x0b, 0x20, 0x01, 0x28, 0x09, 0x52, 0x0a, 0x6c, 0x6f, 0x67, 0x47, 0x72,
	0x6f, 0x75, 0x70, 0x49, 0x64, 0x12, 0x2c, 0x0a, 0x12, 0x73, 0x65, 0x63, 0x75, 0x72, 0x69, 0x74,
	0x79, 0x5f, 0x67, 0x72, 0x6f, 0x75, 0x70, 0x5f, 0x69, 0x64, 0x73, 0x18, 0x0c, 0x20, 0x03, 0x28,
	0x09, 0x52, 0x10, 0x73, 0x65, 0x63, 0x75, 0x72, 0x69, 0x74, 0x79, 0x47, 0x72, 0x6f, 0x75, 0x70,
	0x49, 0x64, 0x73, 0x12, 0x39, 0x0a, 0x0a, 0x63, 0x72, 0x65, 0x61, 0x74, 0x65, 0x64, 0x5f, 0x61,
	0x74, 0x18, 0x0d, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x1a, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65,
	0x2e, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x62, 0x75, 0x66, 0x2e, 0x54, 0x69, 0x6d, 0x65, 0x73, 0x74,
	0x61, 0x6d, 0x70, 0x52, 0x09, 0x63, 0x72, 0x65, 0x61, 0x74, 0x65, 0x64, 0x41, 0x74, 0x12, 0x5c,
	0x0a, 0x11, 0x61, 0x75, 0x74, 0x6f, 0x5f, 0x73, 0x63, 0x61, 0x6c, 0x65, 0x5f, 0x70, 0x6f, 0x6c,
	0x69, 0x63, 0x79, 0x18, 0x0e, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x30, 0x2e, 0x79, 0x61, 0x6e, 0x64,
	0x65, 0x78, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x61, 0x70, 0x70, 0x6c, 0x6f, 0x61, 0x64,
	0x62, 0x61, 0x6c, 0x61, 0x6e, 0x63, 0x65, 0x72, 0x2e, 0x76, 0x31, 0x2e, 0x41, 0x75, 0x74, 0x6f,
	0x53, 0x63, 0x61, 0x6c, 0x65, 0x50, 0x6f, 0x6c, 0x69, 0x63, 0x79, 0x52, 0x0f, 0x61, 0x75, 0x74,
	0x6f, 0x53, 0x63, 0x61, 0x6c, 0x65, 0x50, 0x6f, 0x6c, 0x69, 0x63, 0x79, 0x12, 0x4c, 0x0a, 0x0b,
	0x6c, 0x6f, 0x67, 0x5f, 0x6f, 0x70, 0x74, 0x69, 0x6f, 0x6e, 0x73, 0x18, 0x0f, 0x20, 0x01, 0x28,
	0x0b, 0x32, 0x2b, 0x2e, 0x79, 0x61, 0x6e, 0x64, 0x65, 0x78, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64,
	0x2e, 0x61, 0x70, 0x70, 0x6c, 0x6f, 0x61, 0x64, 0x62, 0x61, 0x6c, 0x61, 0x6e, 0x63, 0x65, 0x72,
	0x2e, 0x76, 0x31, 0x2e, 0x4c, 0x6f, 0x67, 0x4f, 0x70, 0x74, 0x69, 0x6f, 0x6e, 0x73, 0x52, 0x0a,
	0x6c, 0x6f, 0x67, 0x4f, 0x70, 0x74, 0x69, 0x6f, 0x6e, 0x73, 0x1a, 0x39, 0x0a, 0x0b, 0x4c, 0x61,
	0x62, 0x65, 0x6c, 0x73, 0x45, 0x6e, 0x74, 0x72, 0x79, 0x12, 0x10, 0x0a, 0x03, 0x6b, 0x65, 0x79,
	0x18, 0x01, 0x20, 0x01, 0x28, 0x09, 0x52, 0x03, 0x6b, 0x65, 0x79, 0x12, 0x14, 0x0a, 0x05, 0x76,
	0x61, 0x6c, 0x75, 0x65, 0x18, 0x02, 0x20, 0x01, 0x28, 0x09, 0x52, 0x05, 0x76, 0x61, 0x6c, 0x75,
	0x65, 0x3a, 0x02, 0x38, 0x01, 0x22, 0x71, 0x0a, 0x06, 0x53, 0x74, 0x61, 0x74, 0x75, 0x73, 0x12,
	0x16, 0x0a, 0x12, 0x53, 0x54, 0x41, 0x54, 0x55, 0x53, 0x5f, 0x55, 0x4e, 0x53, 0x50, 0x45, 0x43,
	0x49, 0x46, 0x49, 0x45, 0x44, 0x10, 0x00, 0x12, 0x0c, 0x0a, 0x08, 0x43, 0x52, 0x45, 0x41, 0x54,
	0x49, 0x4e, 0x47, 0x10, 0x01, 0x12, 0x0c, 0x0a, 0x08, 0x53, 0x54, 0x41, 0x52, 0x54, 0x49, 0x4e,
	0x47, 0x10, 0x02, 0x12, 0x0a, 0x0a, 0x06, 0x41, 0x43, 0x54, 0x49, 0x56, 0x45, 0x10, 0x03, 0x12,
	0x0c, 0x0a, 0x08, 0x53, 0x54, 0x4f, 0x50, 0x50, 0x49, 0x4e, 0x47, 0x10, 0x04, 0x12, 0x0b, 0x0a,
	0x07, 0x53, 0x54, 0x4f, 0x50, 0x50, 0x45, 0x44, 0x10, 0x05, 0x12, 0x0c, 0x0a, 0x08, 0x44, 0x45,
	0x4c, 0x45, 0x54, 0x49, 0x4e, 0x47, 0x10, 0x06, 0x22, 0xde, 0x02, 0x0a, 0x07, 0x41, 0x64, 0x64,
	0x72, 0x65, 0x73, 0x73, 0x12, 0x6a, 0x0a, 0x15, 0x65, 0x78, 0x74, 0x65, 0x72, 0x6e, 0x61, 0x6c,
	0x5f, 0x69, 0x70, 0x76, 0x34, 0x5f, 0x61, 0x64, 0x64, 0x72, 0x65, 0x73, 0x73, 0x18, 0x01, 0x20,
	0x01, 0x28, 0x0b, 0x32, 0x34, 0x2e, 0x79, 0x61, 0x6e, 0x64, 0x65, 0x78, 0x2e, 0x63, 0x6c, 0x6f,
	0x75, 0x64, 0x2e, 0x61, 0x70, 0x70, 0x6c, 0x6f, 0x61, 0x64, 0x62, 0x61, 0x6c, 0x61, 0x6e, 0x63,
	0x65, 0x72, 0x2e, 0x76, 0x31, 0x2e, 0x45, 0x78, 0x74, 0x65, 0x72, 0x6e, 0x61, 0x6c, 0x49, 0x70,
	0x76, 0x34, 0x41, 0x64, 0x64, 0x72, 0x65, 0x73, 0x73, 0x48, 0x00, 0x52, 0x13, 0x65, 0x78, 0x74,
	0x65, 0x72, 0x6e, 0x61, 0x6c, 0x49, 0x70, 0x76, 0x34, 0x41, 0x64, 0x64, 0x72, 0x65, 0x73, 0x73,
	0x12, 0x6a, 0x0a, 0x15, 0x69, 0x6e, 0x74, 0x65, 0x72, 0x6e, 0x61, 0x6c, 0x5f, 0x69, 0x70, 0x76,
	0x34, 0x5f, 0x61, 0x64, 0x64, 0x72, 0x65, 0x73, 0x73, 0x18, 0x02, 0x20, 0x01, 0x28, 0x0b, 0x32,
	0x34, 0x2e, 0x79, 0x61, 0x6e, 0x64, 0x65, 0x78, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x61,
	0x70, 0x70, 0x6c, 0x6f, 0x61, 0x64, 0x62, 0x61, 0x6c, 0x61, 0x6e, 0x63, 0x65, 0x72, 0x2e, 0x76,
	0x31, 0x2e, 0x49, 0x6e, 0x74, 0x65, 0x72, 0x6e, 0x61, 0x6c, 0x49, 0x70, 0x76, 0x34, 0x41, 0x64,
	0x64, 0x72, 0x65, 0x73, 0x73, 0x48, 0x00, 0x52, 0x13, 0x69, 0x6e, 0x74, 0x65, 0x72, 0x6e, 0x61,
	0x6c, 0x49, 0x70, 0x76, 0x34, 0x41, 0x64, 0x64, 0x72, 0x65, 0x73, 0x73, 0x12, 0x6a, 0x0a, 0x15,
	0x65, 0x78, 0x74, 0x65, 0x72, 0x6e, 0x61, 0x6c, 0x5f, 0x69, 0x70, 0x76, 0x36, 0x5f, 0x61, 0x64,
	0x64, 0x72, 0x65, 0x73, 0x73, 0x18, 0x03, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x34, 0x2e, 0x79, 0x61,
	0x6e, 0x64, 0x65, 0x78, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x61, 0x70, 0x70, 0x6c, 0x6f,
	0x61, 0x64, 0x62, 0x61, 0x6c, 0x61, 0x6e, 0x63, 0x65, 0x72, 0x2e, 0x76, 0x31, 0x2e, 0x45, 0x78,
	0x74, 0x65, 0x72, 0x6e, 0x61, 0x6c, 0x49, 0x70, 0x76, 0x36, 0x41, 0x64, 0x64, 0x72, 0x65, 0x73,
	0x73, 0x48, 0x00, 0x52, 0x13, 0x65, 0x78, 0x74, 0x65, 0x72, 0x6e, 0x61, 0x6c, 0x49, 0x70, 0x76,
	0x36, 0x41, 0x64, 0x64, 0x72, 0x65, 0x73, 0x73, 0x42, 0x0f, 0x0a, 0x07, 0x61, 0x64, 0x64, 0x72,
	0x65, 0x73, 0x73, 0x12, 0x04, 0xc0, 0xc1, 0x31, 0x01, 0x22, 0x2f, 0x0a, 0x13, 0x45, 0x78, 0x74,
	0x65, 0x72, 0x6e, 0x61, 0x6c, 0x49, 0x70, 0x76, 0x34, 0x41, 0x64, 0x64, 0x72, 0x65, 0x73, 0x73,
	0x12, 0x18, 0x0a, 0x07, 0x61, 0x64, 0x64, 0x72, 0x65, 0x73, 0x73, 0x18, 0x01, 0x20, 0x01, 0x28,
	0x09, 0x52, 0x07, 0x61, 0x64, 0x64, 0x72, 0x65, 0x73, 0x73, 0x22, 0x4c, 0x0a, 0x13, 0x49, 0x6e,
	0x74, 0x65, 0x72, 0x6e, 0x61, 0x6c, 0x49, 0x70, 0x76, 0x34, 0x41, 0x64, 0x64, 0x72, 0x65, 0x73,
	0x73, 0x12, 0x18, 0x0a, 0x07, 0x61, 0x64, 0x64, 0x72, 0x65, 0x73, 0x73, 0x18, 0x01, 0x20, 0x01,
	0x28, 0x09, 0x52, 0x07, 0x61, 0x64, 0x64, 0x72, 0x65, 0x73, 0x73, 0x12, 0x1b, 0x0a, 0x09, 0x73,
	0x75, 0x62, 0x6e, 0x65, 0x74, 0x5f, 0x69, 0x64, 0x18, 0x02, 0x20, 0x01, 0x28, 0x09, 0x52, 0x08,
	0x73, 0x75, 0x62, 0x6e, 0x65, 0x74, 0x49, 0x64, 0x22, 0x2f, 0x0a, 0x13, 0x45, 0x78, 0x74, 0x65,
	0x72, 0x6e, 0x61, 0x6c, 0x49, 0x70, 0x76, 0x36, 0x41, 0x64, 0x64, 0x72, 0x65, 0x73, 0x73, 0x12,
	0x18, 0x0a, 0x07, 0x61, 0x64, 0x64, 0x72, 0x65, 0x73, 0x73, 0x18, 0x01, 0x20, 0x01, 0x28, 0x09,
	0x52, 0x07, 0x61, 0x64, 0x64, 0x72, 0x65, 0x73, 0x73, 0x22, 0x6f, 0x0a, 0x08, 0x4c, 0x6f, 0x63,
	0x61, 0x74, 0x69, 0x6f, 0x6e, 0x12, 0x1d, 0x0a, 0x07, 0x7a, 0x6f, 0x6e, 0x65, 0x5f, 0x69, 0x64,
	0x18, 0x01, 0x20, 0x01, 0x28, 0x09, 0x42, 0x04, 0xe8, 0xc7, 0x31, 0x01, 0x52, 0x06, 0x7a, 0x6f,
	0x6e, 0x65, 0x49, 0x64, 0x12, 0x1b, 0x0a, 0x09, 0x73, 0x75, 0x62, 0x6e, 0x65, 0x74, 0x5f, 0x69,
	0x64, 0x18, 0x02, 0x20, 0x01, 0x28, 0x09, 0x52, 0x08, 0x73, 0x75, 0x62, 0x6e, 0x65, 0x74, 0x49,
	0x64, 0x12, 0x27, 0x0a, 0x0f, 0x64, 0x69, 0x73, 0x61, 0x62, 0x6c, 0x65, 0x5f, 0x74, 0x72, 0x61,
	0x66, 0x66, 0x69, 0x63, 0x18, 0x03, 0x20, 0x01, 0x28, 0x08, 0x52, 0x0e, 0x64, 0x69, 0x73, 0x61,
	0x62, 0x6c, 0x65, 0x54, 0x72, 0x61, 0x66, 0x66, 0x69, 0x63, 0x22, 0x68, 0x0a, 0x10, 0x41, 0x6c,
	0x6c, 0x6f, 0x63, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x50, 0x6f, 0x6c, 0x69, 0x63, 0x79, 0x12, 0x54,
	0x0a, 0x09, 0x6c, 0x6f, 0x63, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x73, 0x18, 0x01, 0x20, 0x03, 0x28,
	0x0b, 0x32, 0x29, 0x2e, 0x79, 0x61, 0x6e, 0x64, 0x65, 0x78, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64,
	0x2e, 0x61, 0x70, 0x70, 0x6c, 0x6f, 0x61, 0x64, 0x62, 0x61, 0x6c, 0x61, 0x6e, 0x63, 0x65, 0x72,
	0x2e, 0x76, 0x31, 0x2e, 0x4c, 0x6f, 0x63, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x42, 0x0b, 0x82, 0xc8,
	0x31, 0x03, 0x3e, 0x3d, 0x31, 0x90, 0xc8, 0x31, 0x01, 0x52, 0x09, 0x6c, 0x6f, 0x63, 0x61, 0x74,
	0x69, 0x6f, 0x6e, 0x73, 0x22, 0xd1, 0x02, 0x0a, 0x08, 0x4c, 0x69, 0x73, 0x74, 0x65, 0x6e, 0x65,
	0x72, 0x12, 0x18, 0x0a, 0x04, 0x6e, 0x61, 0x6d, 0x65, 0x18, 0x01, 0x20, 0x01, 0x28, 0x09, 0x42,
	0x04, 0xe8, 0xc7, 0x31, 0x01, 0x52, 0x04, 0x6e, 0x61, 0x6d, 0x65, 0x12, 0x47, 0x0a, 0x09, 0x65,
	0x6e, 0x64, 0x70, 0x6f, 0x69, 0x6e, 0x74, 0x73, 0x18, 0x02, 0x20, 0x03, 0x28, 0x0b, 0x32, 0x29,
	0x2e, 0x79, 0x61, 0x6e, 0x64, 0x65, 0x78, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x61, 0x70,
	0x70, 0x6c, 0x6f, 0x61, 0x64, 0x62, 0x61, 0x6c, 0x61, 0x6e, 0x63, 0x65, 0x72, 0x2e, 0x76, 0x31,
	0x2e, 0x45, 0x6e, 0x64, 0x70, 0x6f, 0x69, 0x6e, 0x74, 0x52, 0x09, 0x65, 0x6e, 0x64, 0x70, 0x6f,
	0x69, 0x6e, 0x74, 0x73, 0x12, 0x43, 0x0a, 0x04, 0x68, 0x74, 0x74, 0x70, 0x18, 0x03, 0x20, 0x01,
	0x28, 0x0b, 0x32, 0x2d, 0x2e, 0x79, 0x61, 0x6e, 0x64, 0x65, 0x78, 0x2e, 0x63, 0x6c, 0x6f, 0x75,
	0x64, 0x2e, 0x61, 0x70, 0x70, 0x6c, 0x6f, 0x61, 0x64, 0x62, 0x61, 0x6c, 0x61, 0x6e, 0x63, 0x65,
	0x72, 0x2e, 0x76, 0x31, 0x2e, 0x48, 0x74, 0x74, 0x70, 0x4c, 0x69, 0x73, 0x74, 0x65, 0x6e, 0x65,
	0x72, 0x48, 0x00, 0x52, 0x04, 0x68, 0x74, 0x74, 0x70, 0x12, 0x40, 0x0a, 0x03, 0x74, 0x6c, 0x73,
	0x18, 0x04, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x2c, 0x2e, 0x79, 0x61, 0x6e, 0x64, 0x65, 0x78, 0x2e,
	0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x61, 0x70, 0x70, 0x6c, 0x6f, 0x61, 0x64, 0x62, 0x61, 0x6c,
	0x61, 0x6e, 0x63, 0x65, 0x72, 0x2e, 0x76, 0x31, 0x2e, 0x54, 0x6c, 0x73, 0x4c, 0x69, 0x73, 0x74,
	0x65, 0x6e, 0x65, 0x72, 0x48, 0x00, 0x52, 0x03, 0x74, 0x6c, 0x73, 0x12, 0x49, 0x0a, 0x06, 0x73,
	0x74, 0x72, 0x65, 0x61, 0x6d, 0x18, 0x05, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x2f, 0x2e, 0x79, 0x61,
	0x6e, 0x64, 0x65, 0x78, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x61, 0x70, 0x70, 0x6c, 0x6f,
	0x61, 0x64, 0x62, 0x61, 0x6c, 0x61, 0x6e, 0x63, 0x65, 0x72, 0x2e, 0x76, 0x31, 0x2e, 0x53, 0x74,
	0x72, 0x65, 0x61, 0x6d, 0x4c, 0x69, 0x73, 0x74, 0x65, 0x6e, 0x65, 0x72, 0x48, 0x00, 0x52, 0x06,
	0x73, 0x74, 0x72, 0x65, 0x61, 0x6d, 0x42, 0x10, 0x0a, 0x08, 0x6c, 0x69, 0x73, 0x74, 0x65, 0x6e,
	0x65, 0x72, 0x12, 0x04, 0xc0, 0xc1, 0x31, 0x01, 0x22, 0x83, 0x01, 0x0a, 0x08, 0x45, 0x6e, 0x64,
	0x70, 0x6f, 0x69, 0x6e, 0x74, 0x12, 0x4e, 0x0a, 0x09, 0x61, 0x64, 0x64, 0x72, 0x65, 0x73, 0x73,
	0x65, 0x73, 0x18, 0x01, 0x20, 0x03, 0x28, 0x0b, 0x32, 0x28, 0x2e, 0x79, 0x61, 0x6e, 0x64, 0x65,
	0x78, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x61, 0x70, 0x70, 0x6c, 0x6f, 0x61, 0x64, 0x62,
	0x61, 0x6c, 0x61, 0x6e, 0x63, 0x65, 0x72, 0x2e, 0x76, 0x31, 0x2e, 0x41, 0x64, 0x64, 0x72, 0x65,
	0x73, 0x73, 0x42, 0x06, 0x82, 0xc8, 0x31, 0x02, 0x3e, 0x30, 0x52, 0x09, 0x61, 0x64, 0x64, 0x72,
	0x65, 0x73, 0x73, 0x65, 0x73, 0x12, 0x27, 0x0a, 0x05, 0x70, 0x6f, 0x72, 0x74, 0x73, 0x18, 0x02,
	0x20, 0x03, 0x28, 0x03, 0x42, 0x11, 0xfa, 0xc7, 0x31, 0x07, 0x31, 0x2d, 0x36, 0x35, 0x35, 0x33,
	0x35, 0x82, 0xc8, 0x31, 0x02, 0x3e, 0x30, 0x52, 0x05, 0x70, 0x6f, 0x72, 0x74, 0x73, 0x22, 0xa0,
	0x01, 0x0a, 0x0c, 0x48, 0x74, 0x74, 0x70, 0x4c, 0x69, 0x73, 0x74, 0x65, 0x6e, 0x65, 0x72, 0x12,
	0x46, 0x0a, 0x07, 0x68, 0x61, 0x6e, 0x64, 0x6c, 0x65, 0x72, 0x18, 0x01, 0x20, 0x01, 0x28, 0x0b,
	0x32, 0x2c, 0x2e, 0x79, 0x61, 0x6e, 0x64, 0x65, 0x78, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e,
	0x61, 0x70, 0x70, 0x6c, 0x6f, 0x61, 0x64, 0x62, 0x61, 0x6c, 0x61, 0x6e, 0x63, 0x65, 0x72, 0x2e,
	0x76, 0x31, 0x2e, 0x48, 0x74, 0x74, 0x70, 0x48, 0x61, 0x6e, 0x64, 0x6c, 0x65, 0x72, 0x52, 0x07,
	0x68, 0x61, 0x6e, 0x64, 0x6c, 0x65, 0x72, 0x12, 0x48, 0x0a, 0x09, 0x72, 0x65, 0x64, 0x69, 0x72,
	0x65, 0x63, 0x74, 0x73, 0x18, 0x02, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x2a, 0x2e, 0x79, 0x61, 0x6e,
	0x64, 0x65, 0x78, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x61, 0x70, 0x70, 0x6c, 0x6f, 0x61,
	0x64, 0x62, 0x61, 0x6c, 0x61, 0x6e, 0x63, 0x65, 0x72, 0x2e, 0x76, 0x31, 0x2e, 0x52, 0x65, 0x64,
	0x69, 0x72, 0x65, 0x63, 0x74, 0x73, 0x52, 0x09, 0x72, 0x65, 0x64, 0x69, 0x72, 0x65, 0x63, 0x74,
	0x73, 0x22, 0xb7, 0x01, 0x0a, 0x0b, 0x54, 0x6c, 0x73, 0x4c, 0x69, 0x73, 0x74, 0x65, 0x6e, 0x65,
	0x72, 0x12, 0x5a, 0x0a, 0x0f, 0x64, 0x65, 0x66, 0x61, 0x75, 0x6c, 0x74, 0x5f, 0x68, 0x61, 0x6e,
	0x64, 0x6c, 0x65, 0x72, 0x18, 0x01, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x2b, 0x2e, 0x79, 0x61, 0x6e,
	0x64, 0x65, 0x78, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x61, 0x70, 0x70, 0x6c, 0x6f, 0x61,
	0x64, 0x62, 0x61, 0x6c, 0x61, 0x6e, 0x63, 0x65, 0x72, 0x2e, 0x76, 0x31, 0x2e, 0x54, 0x6c, 0x73,
	0x48, 0x61, 0x6e, 0x64, 0x6c, 0x65, 0x72, 0x42, 0x04, 0xe8, 0xc7, 0x31, 0x01, 0x52, 0x0e, 0x64,
	0x65, 0x66, 0x61, 0x75, 0x6c, 0x74, 0x48, 0x61, 0x6e, 0x64, 0x6c, 0x65, 0x72, 0x12, 0x4c, 0x0a,
	0x0c, 0x73, 0x6e, 0x69, 0x5f, 0x68, 0x61, 0x6e, 0x64, 0x6c, 0x65, 0x72, 0x73, 0x18, 0x02, 0x20,
	0x03, 0x28, 0x0b, 0x32, 0x29, 0x2e, 0x79, 0x61, 0x6e, 0x64, 0x65, 0x78, 0x2e, 0x63, 0x6c, 0x6f,
	0x75, 0x64, 0x2e, 0x61, 0x70, 0x70, 0x6c, 0x6f, 0x61, 0x64, 0x62, 0x61, 0x6c, 0x61, 0x6e, 0x63,
	0x65, 0x72, 0x2e, 0x76, 0x31, 0x2e, 0x53, 0x6e, 0x69, 0x4d, 0x61, 0x74, 0x63, 0x68, 0x52, 0x0b,
	0x73, 0x6e, 0x69, 0x48, 0x61, 0x6e, 0x64, 0x6c, 0x65, 0x72, 0x73, 0x22, 0x60, 0x0a, 0x0e, 0x53,
	0x74, 0x72, 0x65, 0x61, 0x6d, 0x4c, 0x69, 0x73, 0x74, 0x65, 0x6e, 0x65, 0x72, 0x12, 0x4e, 0x0a,
	0x07, 0x68, 0x61, 0x6e, 0x64, 0x6c, 0x65, 0x72, 0x18, 0x01, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x2e,
	0x2e, 0x79, 0x61, 0x6e, 0x64, 0x65, 0x78, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x61, 0x70,
	0x70, 0x6c, 0x6f, 0x61, 0x64, 0x62, 0x61, 0x6c, 0x61, 0x6e, 0x63, 0x65, 0x72, 0x2e, 0x76, 0x31,
	0x2e, 0x53, 0x74, 0x72, 0x65, 0x61, 0x6d, 0x48, 0x61, 0x6e, 0x64, 0x6c, 0x65, 0x72, 0x42, 0x04,
	0xe8, 0xc7, 0x31, 0x01, 0x52, 0x07, 0x68, 0x61, 0x6e, 0x64, 0x6c, 0x65, 0x72, 0x22, 0x44, 0x0a,
	0x0c, 0x48, 0x74, 0x74, 0x70, 0x32, 0x4f, 0x70, 0x74, 0x69, 0x6f, 0x6e, 0x73, 0x12, 0x34, 0x0a,
	0x16, 0x6d, 0x61, 0x78, 0x5f, 0x63, 0x6f, 0x6e, 0x63, 0x75, 0x72, 0x72, 0x65, 0x6e, 0x74, 0x5f,
	0x73, 0x74, 0x72, 0x65, 0x61, 0x6d, 0x73, 0x18, 0x01, 0x20, 0x01, 0x28, 0x03, 0x52, 0x14, 0x6d,
	0x61, 0x78, 0x43, 0x6f, 0x6e, 0x63, 0x75, 0x72, 0x72, 0x65, 0x6e, 0x74, 0x53, 0x74, 0x72, 0x65,
	0x61, 0x6d, 0x73, 0x22, 0x3f, 0x0a, 0x0d, 0x53, 0x74, 0x72, 0x65, 0x61, 0x6d, 0x48, 0x61, 0x6e,
	0x64, 0x6c, 0x65, 0x72, 0x12, 0x2e, 0x0a, 0x10, 0x62, 0x61, 0x63, 0x6b, 0x65, 0x6e, 0x64, 0x5f,
	0x67, 0x72, 0x6f, 0x75, 0x70, 0x5f, 0x69, 0x64, 0x18, 0x01, 0x20, 0x01, 0x28, 0x09, 0x42, 0x04,
	0xe8, 0xc7, 0x31, 0x01, 0x52, 0x0e, 0x62, 0x61, 0x63, 0x6b, 0x65, 0x6e, 0x64, 0x47, 0x72, 0x6f,
	0x75, 0x70, 0x49, 0x64, 0x22, 0xf1, 0x01, 0x0a, 0x0b, 0x48, 0x74, 0x74, 0x70, 0x48, 0x61, 0x6e,
	0x64, 0x6c, 0x65, 0x72, 0x12, 0x24, 0x0a, 0x0e, 0x68, 0x74, 0x74, 0x70, 0x5f, 0x72, 0x6f, 0x75,
	0x74, 0x65, 0x72, 0x5f, 0x69, 0x64, 0x18, 0x01, 0x20, 0x01, 0x28, 0x09, 0x52, 0x0c, 0x68, 0x74,
	0x74, 0x70, 0x52, 0x6f, 0x75, 0x74, 0x65, 0x72, 0x49, 0x64, 0x12, 0x54, 0x0a, 0x0d, 0x68, 0x74,
	0x74, 0x70, 0x32, 0x5f, 0x6f, 0x70, 0x74, 0x69, 0x6f, 0x6e, 0x73, 0x18, 0x02, 0x20, 0x01, 0x28,
	0x0b, 0x32, 0x2d, 0x2e, 0x79, 0x61, 0x6e, 0x64, 0x65, 0x78, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64,
	0x2e, 0x61, 0x70, 0x70, 0x6c, 0x6f, 0x61, 0x64, 0x62, 0x61, 0x6c, 0x61, 0x6e, 0x63, 0x65, 0x72,
	0x2e, 0x76, 0x31, 0x2e, 0x48, 0x74, 0x74, 0x70, 0x32, 0x4f, 0x70, 0x74, 0x69, 0x6f, 0x6e, 0x73,
	0x48, 0x00, 0x52, 0x0c, 0x68, 0x74, 0x74, 0x70, 0x32, 0x4f, 0x70, 0x74, 0x69, 0x6f, 0x6e, 0x73,
	0x12, 0x23, 0x0a, 0x0c, 0x61, 0x6c, 0x6c, 0x6f, 0x77, 0x5f, 0x68, 0x74, 0x74, 0x70, 0x31, 0x30,
	0x18, 0x03, 0x20, 0x01, 0x28, 0x08, 0x48, 0x00, 0x52, 0x0b, 0x61, 0x6c, 0x6c, 0x6f, 0x77, 0x48,
	0x74, 0x74, 0x70, 0x31, 0x30, 0x12, 0x2c, 0x0a, 0x12, 0x72, 0x65, 0x77, 0x72, 0x69, 0x74, 0x65,
	0x5f, 0x72, 0x65, 0x71, 0x75, 0x65, 0x73, 0x74, 0x5f, 0x69, 0x64, 0x18, 0x04, 0x20, 0x01, 0x28,
	0x08, 0x52, 0x10, 0x72, 0x65, 0x77, 0x72, 0x69, 0x74, 0x65, 0x52, 0x65, 0x71, 0x75, 0x65, 0x73,
	0x74, 0x49, 0x64, 0x42, 0x13, 0x0a, 0x11, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x63, 0x6f, 0x6c, 0x5f,
	0x73, 0x65, 0x74, 0x74, 0x69, 0x6e, 0x67, 0x73, 0x22, 0x2f, 0x0a, 0x09, 0x52, 0x65, 0x64, 0x69,
	0x72, 0x65, 0x63, 0x74, 0x73, 0x12, 0x22, 0x0a, 0x0d, 0x68, 0x74, 0x74, 0x70, 0x5f, 0x74, 0x6f,
	0x5f, 0x68, 0x74, 0x74, 0x70, 0x73, 0x18, 0x01, 0x20, 0x01, 0x28, 0x08, 0x52, 0x0b, 0x68, 0x74,
	0x74, 0x70, 0x54, 0x6f, 0x48, 0x74, 0x74, 0x70, 0x73, 0x22, 0x9c, 0x01, 0x0a, 0x08, 0x53, 0x6e,
	0x69, 0x4d, 0x61, 0x74, 0x63, 0x68, 0x12, 0x18, 0x0a, 0x04, 0x6e, 0x61, 0x6d, 0x65, 0x18, 0x01,
	0x20, 0x01, 0x28, 0x09, 0x42, 0x04, 0xe8, 0xc7, 0x31, 0x01, 0x52, 0x04, 0x6e, 0x61, 0x6d, 0x65,
	0x12, 0x29, 0x0a, 0x0c, 0x73, 0x65, 0x72, 0x76, 0x65, 0x72, 0x5f, 0x6e, 0x61, 0x6d, 0x65, 0x73,
	0x18, 0x02, 0x20, 0x03, 0x28, 0x09, 0x42, 0x06, 0x82, 0xc8, 0x31, 0x02, 0x3e, 0x30, 0x52, 0x0b,
	0x73, 0x65, 0x72, 0x76, 0x65, 0x72, 0x4e, 0x61, 0x6d, 0x65, 0x73, 0x12, 0x4b, 0x0a, 0x07, 0x68,
	0x61, 0x6e, 0x64, 0x6c, 0x65, 0x72, 0x18, 0x03, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x2b, 0x2e, 0x79,
	0x61, 0x6e, 0x64, 0x65, 0x78, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x61, 0x70, 0x70, 0x6c,
	0x6f, 0x61, 0x64, 0x62, 0x61, 0x6c, 0x61, 0x6e, 0x63, 0x65, 0x72, 0x2e, 0x76, 0x31, 0x2e, 0x54,
	0x6c, 0x73, 0x48, 0x61, 0x6e, 0x64, 0x6c, 0x65, 0x72, 0x42, 0x04, 0xe8, 0xc7, 0x31, 0x01, 0x52,
	0x07, 0x68, 0x61, 0x6e, 0x64, 0x6c, 0x65, 0x72, 0x22, 0xfa, 0x01, 0x0a, 0x0a, 0x54, 0x6c, 0x73,
	0x48, 0x61, 0x6e, 0x64, 0x6c, 0x65, 0x72, 0x12, 0x51, 0x0a, 0x0c, 0x68, 0x74, 0x74, 0x70, 0x5f,
	0x68, 0x61, 0x6e, 0x64, 0x6c, 0x65, 0x72, 0x18, 0x02, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x2c, 0x2e,
	0x79, 0x61, 0x6e, 0x64, 0x65, 0x78, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x61, 0x70, 0x70,
	0x6c, 0x6f, 0x61, 0x64, 0x62, 0x61, 0x6c, 0x61, 0x6e, 0x63, 0x65, 0x72, 0x2e, 0x76, 0x31, 0x2e,
	0x48, 0x74, 0x74, 0x70, 0x48, 0x61, 0x6e, 0x64, 0x6c, 0x65, 0x72, 0x48, 0x00, 0x52, 0x0b, 0x68,
	0x74, 0x74, 0x70, 0x48, 0x61, 0x6e, 0x64, 0x6c, 0x65, 0x72, 0x12, 0x57, 0x0a, 0x0e, 0x73, 0x74,
	0x72, 0x65, 0x61, 0x6d, 0x5f, 0x68, 0x61, 0x6e, 0x64, 0x6c, 0x65, 0x72, 0x18, 0x04, 0x20, 0x01,
	0x28, 0x0b, 0x32, 0x2e, 0x2e, 0x79, 0x61, 0x6e, 0x64, 0x65, 0x78, 0x2e, 0x63, 0x6c, 0x6f, 0x75,
	0x64, 0x2e, 0x61, 0x70, 0x70, 0x6c, 0x6f, 0x61, 0x64, 0x62, 0x61, 0x6c, 0x61, 0x6e, 0x63, 0x65,
	0x72, 0x2e, 0x76, 0x31, 0x2e, 0x53, 0x74, 0x72, 0x65, 0x61, 0x6d, 0x48, 0x61, 0x6e, 0x64, 0x6c,
	0x65, 0x72, 0x48, 0x00, 0x52, 0x0d, 0x73, 0x74, 0x72, 0x65, 0x61, 0x6d, 0x48, 0x61, 0x6e, 0x64,
	0x6c, 0x65, 0x72, 0x12, 0x2f, 0x0a, 0x0f, 0x63, 0x65, 0x72, 0x74, 0x69, 0x66, 0x69, 0x63, 0x61,
	0x74, 0x65, 0x5f, 0x69, 0x64, 0x73, 0x18, 0x03, 0x20, 0x03, 0x28, 0x09, 0x42, 0x06, 0x82, 0xc8,
	0x31, 0x02, 0x3e, 0x30, 0x52, 0x0e, 0x63, 0x65, 0x72, 0x74, 0x69, 0x66, 0x69, 0x63, 0x61, 0x74,
	0x65, 0x49, 0x64, 0x73, 0x42, 0x0f, 0x0a, 0x07, 0x68, 0x61, 0x6e, 0x64, 0x6c, 0x65, 0x72, 0x12,
	0x04, 0xc0, 0xc1, 0x31, 0x01, 0x22, 0xca, 0x04, 0x0a, 0x0b, 0x54, 0x61, 0x72, 0x67, 0x65, 0x74,
	0x53, 0x74, 0x61, 0x74, 0x65, 0x12, 0x56, 0x0a, 0x06, 0x73, 0x74, 0x61, 0x74, 0x75, 0x73, 0x18,
	0x01, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x3e, 0x2e, 0x79, 0x61, 0x6e, 0x64, 0x65, 0x78, 0x2e, 0x63,
	0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x61, 0x70, 0x70, 0x6c, 0x6f, 0x61, 0x64, 0x62, 0x61, 0x6c, 0x61,
	0x6e, 0x63, 0x65, 0x72, 0x2e, 0x76, 0x31, 0x2e, 0x54, 0x61, 0x72, 0x67, 0x65, 0x74, 0x53, 0x74,
	0x61, 0x74, 0x65, 0x2e, 0x48, 0x65, 0x61, 0x6c, 0x74, 0x68, 0x63, 0x68, 0x65, 0x63, 0x6b, 0x53,
	0x74, 0x61, 0x74, 0x75, 0x73, 0x52, 0x06, 0x73, 0x74, 0x61, 0x74, 0x75, 0x73, 0x12, 0x45, 0x0a,
	0x06, 0x74, 0x61, 0x72, 0x67, 0x65, 0x74, 0x18, 0x02, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x27, 0x2e,
	0x79, 0x61, 0x6e, 0x64, 0x65, 0x78, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x61, 0x70, 0x70,
	0x6c, 0x6f, 0x61, 0x64, 0x62, 0x61, 0x6c, 0x61, 0x6e, 0x63, 0x65, 0x72, 0x2e, 0x76, 0x31, 0x2e,
	0x54, 0x61, 0x72, 0x67, 0x65, 0x74, 0x42, 0x04, 0xe8, 0xc7, 0x31, 0x01, 0x52, 0x06, 0x74, 0x61,
	0x72, 0x67, 0x65, 0x74, 0x1a, 0x7c, 0x0a, 0x11, 0x48, 0x65, 0x61, 0x6c, 0x74, 0x68, 0x63, 0x68,
	0x65, 0x63, 0x6b, 0x53, 0x74, 0x61, 0x74, 0x75, 0x73, 0x12, 0x67, 0x0a, 0x0d, 0x7a, 0x6f, 0x6e,
	0x65, 0x5f, 0x73, 0x74, 0x61, 0x74, 0x75, 0x73, 0x65, 0x73, 0x18, 0x01, 0x20, 0x03, 0x28, 0x0b,
	0x32, 0x42, 0x2e, 0x79, 0x61, 0x6e, 0x64, 0x65, 0x78, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e,
	0x61, 0x70, 0x70, 0x6c, 0x6f, 0x61, 0x64, 0x62, 0x61, 0x6c, 0x61, 0x6e, 0x63, 0x65, 0x72, 0x2e,
	0x76, 0x31, 0x2e, 0x54, 0x61, 0x72, 0x67, 0x65, 0x74, 0x53, 0x74, 0x61, 0x74, 0x65, 0x2e, 0x5a,
	0x6f, 0x6e, 0x65, 0x48, 0x65, 0x61, 0x6c, 0x74, 0x68, 0x63, 0x68, 0x65, 0x63, 0x6b, 0x53, 0x74,
	0x61, 0x74, 0x75, 0x73, 0x52, 0x0c, 0x7a, 0x6f, 0x6e, 0x65, 0x53, 0x74, 0x61, 0x74, 0x75, 0x73,
	0x65, 0x73, 0x1a, 0xad, 0x01, 0x0a, 0x15, 0x5a, 0x6f, 0x6e, 0x65, 0x48, 0x65, 0x61, 0x6c, 0x74,
	0x68, 0x63, 0x68, 0x65, 0x63, 0x6b, 0x53, 0x74, 0x61, 0x74, 0x75, 0x73, 0x12, 0x1d, 0x0a, 0x07,
	0x7a, 0x6f, 0x6e, 0x65, 0x5f, 0x69, 0x64, 0x18, 0x01, 0x20, 0x01, 0x28, 0x09, 0x42, 0x04, 0xe8,
	0xc7, 0x31, 0x01, 0x52, 0x06, 0x7a, 0x6f, 0x6e, 0x65, 0x49, 0x64, 0x12, 0x4b, 0x0a, 0x06, 0x73,
	0x74, 0x61, 0x74, 0x75, 0x73, 0x18, 0x02, 0x20, 0x01, 0x28, 0x0e, 0x32, 0x33, 0x2e, 0x79, 0x61,
	0x6e, 0x64, 0x65, 0x78, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x61, 0x70, 0x70, 0x6c, 0x6f,
	0x61, 0x64, 0x62, 0x61, 0x6c, 0x61, 0x6e, 0x63, 0x65, 0x72, 0x2e, 0x76, 0x31, 0x2e, 0x54, 0x61,
	0x72, 0x67, 0x65, 0x74, 0x53, 0x74, 0x61, 0x74, 0x65, 0x2e, 0x53, 0x74, 0x61, 0x74, 0x75, 0x73,
	0x52, 0x06, 0x73, 0x74, 0x61, 0x74, 0x75, 0x73, 0x12, 0x28, 0x0a, 0x10, 0x66, 0x61, 0x69, 0x6c,
	0x65, 0x64, 0x5f, 0x61, 0x63, 0x74, 0x69, 0x76, 0x65, 0x5f, 0x68, 0x63, 0x18, 0x03, 0x20, 0x01,
	0x28, 0x08, 0x52, 0x0e, 0x66, 0x61, 0x69, 0x6c, 0x65, 0x64, 0x41, 0x63, 0x74, 0x69, 0x76, 0x65,
	0x48, 0x63, 0x22, 0x6e, 0x0a, 0x06, 0x53, 0x74, 0x61, 0x74, 0x75, 0x73, 0x12, 0x16, 0x0a, 0x12,
	0x53, 0x54, 0x41, 0x54, 0x55, 0x53, 0x5f, 0x55, 0x4e, 0x53, 0x50, 0x45, 0x43, 0x49, 0x46, 0x49,
	0x45, 0x44, 0x10, 0x00, 0x12, 0x0b, 0x0a, 0x07, 0x48, 0x45, 0x41, 0x4c, 0x54, 0x48, 0x59, 0x10,
	0x01, 0x12, 0x15, 0x0a, 0x11, 0x50, 0x41, 0x52, 0x54, 0x49, 0x41, 0x4c, 0x4c, 0x59, 0x5f, 0x48,
	0x45, 0x41, 0x4c, 0x54, 0x48, 0x59, 0x10, 0x02, 0x12, 0x0d, 0x0a, 0x09, 0x55, 0x4e, 0x48, 0x45,
	0x41, 0x4c, 0x54, 0x48, 0x59, 0x10, 0x03, 0x12, 0x0c, 0x0a, 0x08, 0x44, 0x52, 0x41, 0x49, 0x4e,
	0x49, 0x4e, 0x47, 0x10, 0x04, 0x12, 0x0b, 0x0a, 0x07, 0x54, 0x49, 0x4d, 0x45, 0x4f, 0x55, 0x54,
	0x10, 0x05, 0x22, 0x68, 0x0a, 0x0f, 0x41, 0x75, 0x74, 0x6f, 0x53, 0x63, 0x61, 0x6c, 0x65, 0x50,
	0x6f, 0x6c, 0x69, 0x63, 0x79, 0x12, 0x2e, 0x0a, 0x0d, 0x6d, 0x69, 0x6e, 0x5f, 0x7a, 0x6f, 0x6e,
	0x65, 0x5f, 0x73, 0x69, 0x7a, 0x65, 0x18, 0x01, 0x20, 0x01, 0x28, 0x03, 0x42, 0x0a, 0xfa, 0xc7,
	0x31, 0x06, 0x30, 0x2d, 0x31, 0x30, 0x30, 0x30, 0x52, 0x0b, 0x6d, 0x69, 0x6e, 0x5a, 0x6f, 0x6e,
	0x65, 0x53, 0x69, 0x7a, 0x65, 0x12, 0x25, 0x0a, 0x08, 0x6d, 0x61, 0x78, 0x5f, 0x73, 0x69, 0x7a,
	0x65, 0x18, 0x02, 0x20, 0x01, 0x28, 0x03, 0x42, 0x0a, 0xfa, 0xc7, 0x31, 0x06, 0x30, 0x2d, 0x31,
	0x30, 0x30, 0x30, 0x52, 0x07, 0x6d, 0x61, 0x78, 0x53, 0x69, 0x7a, 0x65, 0x42, 0x7a, 0x0a, 0x23,
	0x79, 0x61, 0x6e, 0x64, 0x65, 0x78, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x61, 0x70, 0x69,
	0x2e, 0x61, 0x70, 0x70, 0x6c, 0x6f, 0x61, 0x64, 0x62, 0x61, 0x6c, 0x61, 0x6e, 0x63, 0x65, 0x72,
	0x2e, 0x76, 0x31, 0x5a, 0x53, 0x67, 0x69, 0x74, 0x68, 0x75, 0x62, 0x2e, 0x63, 0x6f, 0x6d, 0x2f,
	0x79, 0x61, 0x6e, 0x64, 0x65, 0x78, 0x2d, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2f, 0x67, 0x6f, 0x2d,
	0x67, 0x65, 0x6e, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x2f, 0x79, 0x61, 0x6e, 0x64, 0x65, 0x78, 0x2f,
	0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2f, 0x61, 0x70, 0x70, 0x6c, 0x6f, 0x61, 0x64, 0x62, 0x61, 0x6c,
	0x61, 0x6e, 0x63, 0x65, 0x72, 0x2f, 0x76, 0x31, 0x3b, 0x61, 0x70, 0x70, 0x6c, 0x6f, 0x61, 0x64,
	0x62, 0x61, 0x6c, 0x61, 0x6e, 0x63, 0x65, 0x72, 0x62, 0x06, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x33,
}

var (
	file_yandex_cloud_apploadbalancer_v1_load_balancer_proto_rawDescOnce sync.Once
	file_yandex_cloud_apploadbalancer_v1_load_balancer_proto_rawDescData = file_yandex_cloud_apploadbalancer_v1_load_balancer_proto_rawDesc
)

func file_yandex_cloud_apploadbalancer_v1_load_balancer_proto_rawDescGZIP() []byte {
	file_yandex_cloud_apploadbalancer_v1_load_balancer_proto_rawDescOnce.Do(func() {
		file_yandex_cloud_apploadbalancer_v1_load_balancer_proto_rawDescData = protoimpl.X.CompressGZIP(file_yandex_cloud_apploadbalancer_v1_load_balancer_proto_rawDescData)
	})
	return file_yandex_cloud_apploadbalancer_v1_load_balancer_proto_rawDescData
}

var file_yandex_cloud_apploadbalancer_v1_load_balancer_proto_enumTypes = make([]protoimpl.EnumInfo, 2)
var file_yandex_cloud_apploadbalancer_v1_load_balancer_proto_msgTypes = make([]protoimpl.MessageInfo, 23)
var file_yandex_cloud_apploadbalancer_v1_load_balancer_proto_goTypes = []interface{}{
	(LoadBalancer_Status)(0),                  // 0: yandex.cloud.apploadbalancer.v1.LoadBalancer.Status
	(TargetState_Status)(0),                   // 1: yandex.cloud.apploadbalancer.v1.TargetState.Status
	(*LoadBalancer)(nil),                      // 2: yandex.cloud.apploadbalancer.v1.LoadBalancer
	(*Address)(nil),                           // 3: yandex.cloud.apploadbalancer.v1.Address
	(*ExternalIpv4Address)(nil),               // 4: yandex.cloud.apploadbalancer.v1.ExternalIpv4Address
	(*InternalIpv4Address)(nil),               // 5: yandex.cloud.apploadbalancer.v1.InternalIpv4Address
	(*ExternalIpv6Address)(nil),               // 6: yandex.cloud.apploadbalancer.v1.ExternalIpv6Address
	(*Location)(nil),                          // 7: yandex.cloud.apploadbalancer.v1.Location
	(*AllocationPolicy)(nil),                  // 8: yandex.cloud.apploadbalancer.v1.AllocationPolicy
	(*Listener)(nil),                          // 9: yandex.cloud.apploadbalancer.v1.Listener
	(*Endpoint)(nil),                          // 10: yandex.cloud.apploadbalancer.v1.Endpoint
	(*HttpListener)(nil),                      // 11: yandex.cloud.apploadbalancer.v1.HttpListener
	(*TlsListener)(nil),                       // 12: yandex.cloud.apploadbalancer.v1.TlsListener
	(*StreamListener)(nil),                    // 13: yandex.cloud.apploadbalancer.v1.StreamListener
	(*Http2Options)(nil),                      // 14: yandex.cloud.apploadbalancer.v1.Http2Options
	(*StreamHandler)(nil),                     // 15: yandex.cloud.apploadbalancer.v1.StreamHandler
	(*HttpHandler)(nil),                       // 16: yandex.cloud.apploadbalancer.v1.HttpHandler
	(*Redirects)(nil),                         // 17: yandex.cloud.apploadbalancer.v1.Redirects
	(*SniMatch)(nil),                          // 18: yandex.cloud.apploadbalancer.v1.SniMatch
	(*TlsHandler)(nil),                        // 19: yandex.cloud.apploadbalancer.v1.TlsHandler
	(*TargetState)(nil),                       // 20: yandex.cloud.apploadbalancer.v1.TargetState
	(*AutoScalePolicy)(nil),                   // 21: yandex.cloud.apploadbalancer.v1.AutoScalePolicy
	nil,                                       // 22: yandex.cloud.apploadbalancer.v1.LoadBalancer.LabelsEntry
	(*TargetState_HealthcheckStatus)(nil),     // 23: yandex.cloud.apploadbalancer.v1.TargetState.HealthcheckStatus
	(*TargetState_ZoneHealthcheckStatus)(nil), // 24: yandex.cloud.apploadbalancer.v1.TargetState.ZoneHealthcheckStatus
	(*timestamppb.Timestamp)(nil),             // 25: google.protobuf.Timestamp
	(*LogOptions)(nil),                        // 26: yandex.cloud.apploadbalancer.v1.LogOptions
	(*Target)(nil),                            // 27: yandex.cloud.apploadbalancer.v1.Target
}
var file_yandex_cloud_apploadbalancer_v1_load_balancer_proto_depIdxs = []int32{
	22, // 0: yandex.cloud.apploadbalancer.v1.LoadBalancer.labels:type_name -> yandex.cloud.apploadbalancer.v1.LoadBalancer.LabelsEntry
	0,  // 1: yandex.cloud.apploadbalancer.v1.LoadBalancer.status:type_name -> yandex.cloud.apploadbalancer.v1.LoadBalancer.Status
	9,  // 2: yandex.cloud.apploadbalancer.v1.LoadBalancer.listeners:type_name -> yandex.cloud.apploadbalancer.v1.Listener
	8,  // 3: yandex.cloud.apploadbalancer.v1.LoadBalancer.allocation_policy:type_name -> yandex.cloud.apploadbalancer.v1.AllocationPolicy
	25, // 4: yandex.cloud.apploadbalancer.v1.LoadBalancer.created_at:type_name -> google.protobuf.Timestamp
	21, // 5: yandex.cloud.apploadbalancer.v1.LoadBalancer.auto_scale_policy:type_name -> yandex.cloud.apploadbalancer.v1.AutoScalePolicy
	26, // 6: yandex.cloud.apploadbalancer.v1.LoadBalancer.log_options:type_name -> yandex.cloud.apploadbalancer.v1.LogOptions
	4,  // 7: yandex.cloud.apploadbalancer.v1.Address.external_ipv4_address:type_name -> yandex.cloud.apploadbalancer.v1.ExternalIpv4Address
	5,  // 8: yandex.cloud.apploadbalancer.v1.Address.internal_ipv4_address:type_name -> yandex.cloud.apploadbalancer.v1.InternalIpv4Address
	6,  // 9: yandex.cloud.apploadbalancer.v1.Address.external_ipv6_address:type_name -> yandex.cloud.apploadbalancer.v1.ExternalIpv6Address
	7,  // 10: yandex.cloud.apploadbalancer.v1.AllocationPolicy.locations:type_name -> yandex.cloud.apploadbalancer.v1.Location
	10, // 11: yandex.cloud.apploadbalancer.v1.Listener.endpoints:type_name -> yandex.cloud.apploadbalancer.v1.Endpoint
	11, // 12: yandex.cloud.apploadbalancer.v1.Listener.http:type_name -> yandex.cloud.apploadbalancer.v1.HttpListener
	12, // 13: yandex.cloud.apploadbalancer.v1.Listener.tls:type_name -> yandex.cloud.apploadbalancer.v1.TlsListener
	13, // 14: yandex.cloud.apploadbalancer.v1.Listener.stream:type_name -> yandex.cloud.apploadbalancer.v1.StreamListener
	3,  // 15: yandex.cloud.apploadbalancer.v1.Endpoint.addresses:type_name -> yandex.cloud.apploadbalancer.v1.Address
	16, // 16: yandex.cloud.apploadbalancer.v1.HttpListener.handler:type_name -> yandex.cloud.apploadbalancer.v1.HttpHandler
	17, // 17: yandex.cloud.apploadbalancer.v1.HttpListener.redirects:type_name -> yandex.cloud.apploadbalancer.v1.Redirects
	19, // 18: yandex.cloud.apploadbalancer.v1.TlsListener.default_handler:type_name -> yandex.cloud.apploadbalancer.v1.TlsHandler
	18, // 19: yandex.cloud.apploadbalancer.v1.TlsListener.sni_handlers:type_name -> yandex.cloud.apploadbalancer.v1.SniMatch
	15, // 20: yandex.cloud.apploadbalancer.v1.StreamListener.handler:type_name -> yandex.cloud.apploadbalancer.v1.StreamHandler
	14, // 21: yandex.cloud.apploadbalancer.v1.HttpHandler.http2_options:type_name -> yandex.cloud.apploadbalancer.v1.Http2Options
	19, // 22: yandex.cloud.apploadbalancer.v1.SniMatch.handler:type_name -> yandex.cloud.apploadbalancer.v1.TlsHandler
	16, // 23: yandex.cloud.apploadbalancer.v1.TlsHandler.http_handler:type_name -> yandex.cloud.apploadbalancer.v1.HttpHandler
	15, // 24: yandex.cloud.apploadbalancer.v1.TlsHandler.stream_handler:type_name -> yandex.cloud.apploadbalancer.v1.StreamHandler
	23, // 25: yandex.cloud.apploadbalancer.v1.TargetState.status:type_name -> yandex.cloud.apploadbalancer.v1.TargetState.HealthcheckStatus
	27, // 26: yandex.cloud.apploadbalancer.v1.TargetState.target:type_name -> yandex.cloud.apploadbalancer.v1.Target
	24, // 27: yandex.cloud.apploadbalancer.v1.TargetState.HealthcheckStatus.zone_statuses:type_name -> yandex.cloud.apploadbalancer.v1.TargetState.ZoneHealthcheckStatus
	1,  // 28: yandex.cloud.apploadbalancer.v1.TargetState.ZoneHealthcheckStatus.status:type_name -> yandex.cloud.apploadbalancer.v1.TargetState.Status
	29, // [29:29] is the sub-list for method output_type
	29, // [29:29] is the sub-list for method input_type
	29, // [29:29] is the sub-list for extension type_name
	29, // [29:29] is the sub-list for extension extendee
	0,  // [0:29] is the sub-list for field type_name
}

func init() { file_yandex_cloud_apploadbalancer_v1_load_balancer_proto_init() }
func file_yandex_cloud_apploadbalancer_v1_load_balancer_proto_init() {
	if File_yandex_cloud_apploadbalancer_v1_load_balancer_proto != nil {
		return
	}
	file_yandex_cloud_apploadbalancer_v1_logging_proto_init()
	file_yandex_cloud_apploadbalancer_v1_target_group_proto_init()
	if !protoimpl.UnsafeEnabled {
		file_yandex_cloud_apploadbalancer_v1_load_balancer_proto_msgTypes[0].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*LoadBalancer); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_yandex_cloud_apploadbalancer_v1_load_balancer_proto_msgTypes[1].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*Address); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_yandex_cloud_apploadbalancer_v1_load_balancer_proto_msgTypes[2].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*ExternalIpv4Address); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_yandex_cloud_apploadbalancer_v1_load_balancer_proto_msgTypes[3].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*InternalIpv4Address); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_yandex_cloud_apploadbalancer_v1_load_balancer_proto_msgTypes[4].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*ExternalIpv6Address); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_yandex_cloud_apploadbalancer_v1_load_balancer_proto_msgTypes[5].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*Location); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_yandex_cloud_apploadbalancer_v1_load_balancer_proto_msgTypes[6].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*AllocationPolicy); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_yandex_cloud_apploadbalancer_v1_load_balancer_proto_msgTypes[7].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*Listener); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_yandex_cloud_apploadbalancer_v1_load_balancer_proto_msgTypes[8].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*Endpoint); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_yandex_cloud_apploadbalancer_v1_load_balancer_proto_msgTypes[9].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*HttpListener); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_yandex_cloud_apploadbalancer_v1_load_balancer_proto_msgTypes[10].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*TlsListener); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_yandex_cloud_apploadbalancer_v1_load_balancer_proto_msgTypes[11].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*StreamListener); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_yandex_cloud_apploadbalancer_v1_load_balancer_proto_msgTypes[12].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*Http2Options); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_yandex_cloud_apploadbalancer_v1_load_balancer_proto_msgTypes[13].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*StreamHandler); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_yandex_cloud_apploadbalancer_v1_load_balancer_proto_msgTypes[14].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*HttpHandler); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_yandex_cloud_apploadbalancer_v1_load_balancer_proto_msgTypes[15].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*Redirects); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_yandex_cloud_apploadbalancer_v1_load_balancer_proto_msgTypes[16].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*SniMatch); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_yandex_cloud_apploadbalancer_v1_load_balancer_proto_msgTypes[17].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*TlsHandler); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_yandex_cloud_apploadbalancer_v1_load_balancer_proto_msgTypes[18].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*TargetState); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_yandex_cloud_apploadbalancer_v1_load_balancer_proto_msgTypes[19].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*AutoScalePolicy); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_yandex_cloud_apploadbalancer_v1_load_balancer_proto_msgTypes[21].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*TargetState_HealthcheckStatus); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_yandex_cloud_apploadbalancer_v1_load_balancer_proto_msgTypes[22].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*TargetState_ZoneHealthcheckStatus); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
	}
	file_yandex_cloud_apploadbalancer_v1_load_balancer_proto_msgTypes[1].OneofWrappers = []interface{}{
		(*Address_ExternalIpv4Address)(nil),
		(*Address_InternalIpv4Address)(nil),
		(*Address_ExternalIpv6Address)(nil),
	}
	file_yandex_cloud_apploadbalancer_v1_load_balancer_proto_msgTypes[7].OneofWrappers = []interface{}{
		(*Listener_Http)(nil),
		(*Listener_Tls)(nil),
		(*Listener_Stream)(nil),
	}
	file_yandex_cloud_apploadbalancer_v1_load_balancer_proto_msgTypes[14].OneofWrappers = []interface{}{
		(*HttpHandler_Http2Options)(nil),
		(*HttpHandler_AllowHttp10)(nil),
	}
	file_yandex_cloud_apploadbalancer_v1_load_balancer_proto_msgTypes[17].OneofWrappers = []interface{}{
		(*TlsHandler_HttpHandler)(nil),
		(*TlsHandler_StreamHandler)(nil),
	}
	type x struct{}
	out := protoimpl.TypeBuilder{
		File: protoimpl.DescBuilder{
			GoPackagePath: reflect.TypeOf(x{}).PkgPath(),
			RawDescriptor: file_yandex_cloud_apploadbalancer_v1_load_balancer_proto_rawDesc,
			NumEnums:      2,
			NumMessages:   23,
			NumExtensions: 0,
			NumServices:   0,
		},
		GoTypes:           file_yandex_cloud_apploadbalancer_v1_load_balancer_proto_goTypes,
		DependencyIndexes: file_yandex_cloud_apploadbalancer_v1_load_balancer_proto_depIdxs,
		EnumInfos:         file_yandex_cloud_apploadbalancer_v1_load_balancer_proto_enumTypes,
		MessageInfos:      file_yandex_cloud_apploadbalancer_v1_load_balancer_proto_msgTypes,
	}.Build()
	File_yandex_cloud_apploadbalancer_v1_load_balancer_proto = out.File
	file_yandex_cloud_apploadbalancer_v1_load_balancer_proto_rawDesc = nil
	file_yandex_cloud_apploadbalancer_v1_load_balancer_proto_goTypes = nil
	file_yandex_cloud_apploadbalancer_v1_load_balancer_proto_depIdxs = nil
}
