// Code generated by protoc-gen-go. DO NOT EDIT.
// versions:
// 	protoc-gen-go v1.29.0
// 	protoc        v3.17.3
// source: yandex/cloud/mdb/postgresql/v1/perf_diag.proto

package postgresql

import (
	protoreflect "google.golang.org/protobuf/reflect/protoreflect"
	protoimpl "google.golang.org/protobuf/runtime/protoimpl"
	timestamppb "google.golang.org/protobuf/types/known/timestamppb"
	reflect "reflect"
	sync "sync"
)

const (
	// Verify that this generated code is sufficiently up-to-date.
	_ = protoimpl.EnforceVersion(20 - protoimpl.MinVersion)
	// Verify that runtime/protoimpl is sufficiently up-to-date.
	_ = protoimpl.EnforceVersion(protoimpl.MaxVersion - 20)
)

type SessionState struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Time of collecting statistics on sessions (in the [RFC3339](https://www.ietf.org/rfc/rfc3339.txt) text format).
	Time *timestamppb.Timestamp `protobuf:"bytes,1,opt,name=time,proto3" json:"time,omitempty"`
	// Host of the connected client.
	Host string `protobuf:"bytes,2,opt,name=host,proto3" json:"host,omitempty"`
	// Server process ID. For client connections, this is a client connection ID.
	Pid int64 `protobuf:"varint,3,opt,name=pid,proto3" json:"pid,omitempty"`
	// Database ID.
	Database string `protobuf:"bytes,4,opt,name=database,proto3" json:"database,omitempty"`
	// User ID.
	User string `protobuf:"bytes,5,opt,name=user,proto3" json:"user,omitempty"`
	// Application name on the connected client.
	ApplicationName string `protobuf:"bytes,6,opt,name=application_name,json=applicationName,proto3" json:"application_name,omitempty"`
	// Time when a given process was started. For client connections, this is the time when the client connected to the server.
	BackendStart *timestamppb.Timestamp `protobuf:"bytes,7,opt,name=backend_start,json=backendStart,proto3" json:"backend_start,omitempty"`
	// Time when a transaction of a given process was started. Returns [NULL] if no transaction is active.
	//
	// If the currently active query is the first of its transaction, the value of this parameter is equal to the value of the [query_start] parameter.
	XactStart *timestamppb.Timestamp `protobuf:"bytes,8,opt,name=xact_start,json=xactStart,proto3" json:"xact_start,omitempty"`
	// Time when the currently active query was started.
	//
	// If the [state] parameter does not take the value [active], the parameter returns the time when the lastest query was started.
	QueryStart *timestamppb.Timestamp `protobuf:"bytes,9,opt,name=query_start,json=queryStart,proto3" json:"query_start,omitempty"`
	// Time when the [state] parameter was last changed.
	StateChange *timestamppb.Timestamp `protobuf:"bytes,10,opt,name=state_change,json=stateChange,proto3" json:"state_change,omitempty"`
	// Type of event for which the backend is waiting. Such an event is called a wait event. A backend refers to the process that maintains the client connection.
	//
	// For the list of wait events, see the [PostgreSQL documentation](https://www.postgresql.org/docs/current/monitoring-stats.html#WAIT-EVENT-TABLE). If the backend is not waiting for any event, the parameter returns [NULL].
	WaitEventType string `protobuf:"bytes,11,opt,name=wait_event_type,json=waitEventType,proto3" json:"wait_event_type,omitempty"`
	// Wait event name.
	//
	// For the list of such names, see the [PostgreSQL documentation](https://www.postgresql.org/docs/current/monitoring-stats.html#WAIT-EVENT-ACTIVITY-TABLE). If the backend is not waiting for any event, the parameter returns [NULL].
	WaitEvent string `protobuf:"bytes,12,opt,name=wait_event,json=waitEvent,proto3" json:"wait_event,omitempty"`
	// Current backend state. For the list of possible values, see the [PostgreSQL documentation](https://www.postgresql.org/docs/current/monitoring-stats.html#MONITORING-PG-STAT-ACTIVITY-VIEW).
	State string `protobuf:"bytes,13,opt,name=state,proto3" json:"state,omitempty"`
	// Text of the most recent query.
	//
	// If the [state] parameter takes the value [active], the parameter shows the currently executing query. For the rest of the states, the parameter shows the last query that was executed. By default, the query text is truncated to 1024 bytes.
	Query string `protobuf:"bytes,14,opt,name=query,proto3" json:"query,omitempty"`
	// Current backend type. For the list of possible values, see the [PostgreSQL documentation](https://www.postgresql.org/docs/current/monitoring-stats.html#MONITORING-PG-STAT-ACTIVITY-VIEW).
	BackendType string `protobuf:"bytes,15,opt,name=backend_type,json=backendType,proto3" json:"backend_type,omitempty"`
	// IP address of the connected client.
	//
	// The parameter returns [NULL] in the following cases:
	// - The client is connected via a Unix socket on the server.
	// - A given process is internal (for example, autovacuum).
	ClientAddr string `protobuf:"bytes,16,opt,name=client_addr,json=clientAddr,proto3" json:"client_addr,omitempty"`
	// Host name of the connected client (relevant for IP connections).
	ClientHostname string `protobuf:"bytes,17,opt,name=client_hostname,json=clientHostname,proto3" json:"client_hostname,omitempty"`
	// TCP port number that the client is using for communication with the server.
	//
	// Returns [-1] if the client is connected via a Unix socket on the server. Returns [NULL] if a given process is internal (for example, autovacuum).
	ClientPort int64 `protobuf:"varint,18,opt,name=client_port,json=clientPort,proto3" json:"client_port,omitempty"`
	// Top-level transaction ID, if any.
	BackendXid int64 `protobuf:"varint,19,opt,name=backend_xid,json=backendXid,proto3" json:"backend_xid,omitempty"`
	// Current [xmin horizon].
	BackendXmin int64 `protobuf:"varint,20,opt,name=backend_xmin,json=backendXmin,proto3" json:"backend_xmin,omitempty"`
	// Process IDs that are blocking a given server process ID.
	BlockingPids string `protobuf:"bytes,22,opt,name=blocking_pids,json=blockingPids,proto3" json:"blocking_pids,omitempty"`
	// Query ID.
	QueryId string `protobuf:"bytes,23,opt,name=query_id,json=queryId,proto3" json:"query_id,omitempty"`
}

func (x *SessionState) Reset() {
	*x = SessionState{}
	if protoimpl.UnsafeEnabled {
		mi := &file_yandex_cloud_mdb_postgresql_v1_perf_diag_proto_msgTypes[0]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *SessionState) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*SessionState) ProtoMessage() {}

func (x *SessionState) ProtoReflect() protoreflect.Message {
	mi := &file_yandex_cloud_mdb_postgresql_v1_perf_diag_proto_msgTypes[0]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use SessionState.ProtoReflect.Descriptor instead.
func (*SessionState) Descriptor() ([]byte, []int) {
	return file_yandex_cloud_mdb_postgresql_v1_perf_diag_proto_rawDescGZIP(), []int{0}
}

func (x *SessionState) GetTime() *timestamppb.Timestamp {
	if x != nil {
		return x.Time
	}
	return nil
}

func (x *SessionState) GetHost() string {
	if x != nil {
		return x.Host
	}
	return ""
}

func (x *SessionState) GetPid() int64 {
	if x != nil {
		return x.Pid
	}
	return 0
}

func (x *SessionState) GetDatabase() string {
	if x != nil {
		return x.Database
	}
	return ""
}

func (x *SessionState) GetUser() string {
	if x != nil {
		return x.User
	}
	return ""
}

func (x *SessionState) GetApplicationName() string {
	if x != nil {
		return x.ApplicationName
	}
	return ""
}

func (x *SessionState) GetBackendStart() *timestamppb.Timestamp {
	if x != nil {
		return x.BackendStart
	}
	return nil
}

func (x *SessionState) GetXactStart() *timestamppb.Timestamp {
	if x != nil {
		return x.XactStart
	}
	return nil
}

func (x *SessionState) GetQueryStart() *timestamppb.Timestamp {
	if x != nil {
		return x.QueryStart
	}
	return nil
}

func (x *SessionState) GetStateChange() *timestamppb.Timestamp {
	if x != nil {
		return x.StateChange
	}
	return nil
}

func (x *SessionState) GetWaitEventType() string {
	if x != nil {
		return x.WaitEventType
	}
	return ""
}

func (x *SessionState) GetWaitEvent() string {
	if x != nil {
		return x.WaitEvent
	}
	return ""
}

func (x *SessionState) GetState() string {
	if x != nil {
		return x.State
	}
	return ""
}

func (x *SessionState) GetQuery() string {
	if x != nil {
		return x.Query
	}
	return ""
}

func (x *SessionState) GetBackendType() string {
	if x != nil {
		return x.BackendType
	}
	return ""
}

func (x *SessionState) GetClientAddr() string {
	if x != nil {
		return x.ClientAddr
	}
	return ""
}

func (x *SessionState) GetClientHostname() string {
	if x != nil {
		return x.ClientHostname
	}
	return ""
}

func (x *SessionState) GetClientPort() int64 {
	if x != nil {
		return x.ClientPort
	}
	return 0
}

func (x *SessionState) GetBackendXid() int64 {
	if x != nil {
		return x.BackendXid
	}
	return 0
}

func (x *SessionState) GetBackendXmin() int64 {
	if x != nil {
		return x.BackendXmin
	}
	return 0
}

func (x *SessionState) GetBlockingPids() string {
	if x != nil {
		return x.BlockingPids
	}
	return ""
}

func (x *SessionState) GetQueryId() string {
	if x != nil {
		return x.QueryId
	}
	return ""
}

type PrimaryKey struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Host of the connected client.
	Host string `protobuf:"bytes,1,opt,name=host,proto3" json:"host,omitempty"`
	// User ID.
	User string `protobuf:"bytes,2,opt,name=user,proto3" json:"user,omitempty"`
	// Database ID.
	Database string `protobuf:"bytes,4,opt,name=database,proto3" json:"database,omitempty"`
	// Returns [true] if a query is executed as a top-level SQL statement or if the [pg_stat_statements.track](https://www.postgresql.org/docs/current/pgstatstatements.html#id-1.11.7.41.9) parameter is set to the value [top].
	Toplevel bool `protobuf:"varint,5,opt,name=toplevel,proto3" json:"toplevel,omitempty"`
	// Query ID.
	QueryId string `protobuf:"bytes,6,opt,name=query_id,json=queryId,proto3" json:"query_id,omitempty"`
	// Query planning ID.
	PlanId string `protobuf:"bytes,7,opt,name=plan_id,json=planId,proto3" json:"plan_id,omitempty"`
}

func (x *PrimaryKey) Reset() {
	*x = PrimaryKey{}
	if protoimpl.UnsafeEnabled {
		mi := &file_yandex_cloud_mdb_postgresql_v1_perf_diag_proto_msgTypes[1]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *PrimaryKey) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*PrimaryKey) ProtoMessage() {}

func (x *PrimaryKey) ProtoReflect() protoreflect.Message {
	mi := &file_yandex_cloud_mdb_postgresql_v1_perf_diag_proto_msgTypes[1]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use PrimaryKey.ProtoReflect.Descriptor instead.
func (*PrimaryKey) Descriptor() ([]byte, []int) {
	return file_yandex_cloud_mdb_postgresql_v1_perf_diag_proto_rawDescGZIP(), []int{1}
}

func (x *PrimaryKey) GetHost() string {
	if x != nil {
		return x.Host
	}
	return ""
}

func (x *PrimaryKey) GetUser() string {
	if x != nil {
		return x.User
	}
	return ""
}

func (x *PrimaryKey) GetDatabase() string {
	if x != nil {
		return x.Database
	}
	return ""
}

func (x *PrimaryKey) GetToplevel() bool {
	if x != nil {
		return x.Toplevel
	}
	return false
}

func (x *PrimaryKey) GetQueryId() string {
	if x != nil {
		return x.QueryId
	}
	return ""
}

func (x *PrimaryKey) GetPlanId() string {
	if x != nil {
		return x.PlanId
	}
	return ""
}

type QueryStats struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Time of collecting statistics on planning and execution of queries.
	Time *timestamppb.Timestamp `protobuf:"bytes,1,opt,name=time,proto3" json:"time,omitempty"`
	// Statement text.
	Query string `protobuf:"bytes,2,opt,name=query,proto3" json:"query,omitempty"`
	// Normalized query plan.
	NormalizedPlan string `protobuf:"bytes,3,opt,name=normalized_plan,json=normalizedPlan,proto3" json:"normalized_plan,omitempty"`
	// Example of a query execution plan (without normalization).
	ExamplePlan string `protobuf:"bytes,4,opt,name=example_plan,json=examplePlan,proto3" json:"example_plan,omitempty"`
	// Number of times that a query was planned.
	//
	// The parameter returns a non-zero value if the [pg_stat_statements.track_planning](https://www.postgresql.org/docs/current/pgstatstatements.html#id-1.11.7.41.9) parameter is enabled.
	Plans int64 `protobuf:"varint,5,opt,name=plans,proto3" json:"plans,omitempty"`
	// Total time taken to plan a query, in milliseconds.
	//
	// The parameter returns a non-zero value if the [pg_stat_statements.track_planning] parameter is enabled.
	TotalPlanTime float64 `protobuf:"fixed64,6,opt,name=total_plan_time,json=totalPlanTime,proto3" json:"total_plan_time,omitempty"`
	// Minimum time taken to plan a query, in milliseconds.
	//
	// The parameter returns a non-zero value if the [pg_stat_statements.track_planning] parameter is enabled.
	MinPlanTime float64 `protobuf:"fixed64,7,opt,name=min_plan_time,json=minPlanTime,proto3" json:"min_plan_time,omitempty"`
	// Maximum time taken to plan a query, in milliseconds.
	//
	// The parameter returns a non-zero value if the [pg_stat_statements.track_planning] parameter is enabled.
	MaxPlanTime float64 `protobuf:"fixed64,8,opt,name=max_plan_time,json=maxPlanTime,proto3" json:"max_plan_time,omitempty"`
	// Average time taken to plan a query, in milliseconds.
	//
	// The parameter returns a non-zero value if the [pg_stat_statements.track_planning] parameter is enabled.
	MeanPlanTime float64 `protobuf:"fixed64,9,opt,name=mean_plan_time,json=meanPlanTime,proto3" json:"mean_plan_time,omitempty"`
	// Population standard deviation of the time taken to plan a query, in milliseconds.
	//
	// The parameter returns a non-zero value if the [pg_stat_statements.track_planning] parameter is enabled.
	StddevPlanTime float64 `protobuf:"fixed64,10,opt,name=stddev_plan_time,json=stddevPlanTime,proto3" json:"stddev_plan_time,omitempty"`
	// Number of times that a query was executed.
	Calls int64 `protobuf:"varint,11,opt,name=calls,proto3" json:"calls,omitempty"`
	// Total time taken to execute a query, in milliseconds.
	TotalTime float64 `protobuf:"fixed64,12,opt,name=total_time,json=totalTime,proto3" json:"total_time,omitempty"` // total_exec_time
	// Minimum time taken to execute a query, in milliseconds.
	MinTime float64 `protobuf:"fixed64,13,opt,name=min_time,json=minTime,proto3" json:"min_time,omitempty"` // min_exec_time
	// Maximum time taken to execute a query, in milliseconds.
	MaxTime float64 `protobuf:"fixed64,14,opt,name=max_time,json=maxTime,proto3" json:"max_time,omitempty"` // max_exec_time
	// Average time taken to execute a query, in milliseconds.
	MeanTime float64 `protobuf:"fixed64,15,opt,name=mean_time,json=meanTime,proto3" json:"mean_time,omitempty"` // mean_exec_time
	// Population standard deviation of the time taken to execute a query, in milliseconds.
	StddevTime float64 `protobuf:"fixed64,16,opt,name=stddev_time,json=stddevTime,proto3" json:"stddev_time,omitempty"` // stddev_exec_time
	// Number of retrieved or affected rows.
	Rows int64 `protobuf:"varint,17,opt,name=rows,proto3" json:"rows,omitempty"`
	// Number of shared blocks that are hit from cache.
	SharedBlksHit int64 `protobuf:"varint,18,opt,name=shared_blks_hit,json=sharedBlksHit,proto3" json:"shared_blks_hit,omitempty"`
	// Number of read shared blocks.
	SharedBlksRead int64 `protobuf:"varint,19,opt,name=shared_blks_read,json=sharedBlksRead,proto3" json:"shared_blks_read,omitempty"`
	// Number of 'dirtied' shared blocks.
	SharedBlksDirtied int64 `protobuf:"varint,20,opt,name=shared_blks_dirtied,json=sharedBlksDirtied,proto3" json:"shared_blks_dirtied,omitempty"`
	// Number of written shared blocks.
	SharedBlksWritten int64 `protobuf:"varint,21,opt,name=shared_blks_written,json=sharedBlksWritten,proto3" json:"shared_blks_written,omitempty"`
	// Number of local blocks that are hit from cache.
	LocalBlksHit int64 `protobuf:"varint,22,opt,name=local_blks_hit,json=localBlksHit,proto3" json:"local_blks_hit,omitempty"`
	// Number of read local blocks.
	LocalBlksRead int64 `protobuf:"varint,23,opt,name=local_blks_read,json=localBlksRead,proto3" json:"local_blks_read,omitempty"`
	// Number of 'dirtied' local blocks.
	LocalBlksDirtied int64 `protobuf:"varint,24,opt,name=local_blks_dirtied,json=localBlksDirtied,proto3" json:"local_blks_dirtied,omitempty"`
	// Number of written local blocks.
	LocalBlksWritten int64 `protobuf:"varint,25,opt,name=local_blks_written,json=localBlksWritten,proto3" json:"local_blks_written,omitempty"`
	// Number of read temporary blocks.
	TempBlksRead int64 `protobuf:"varint,26,opt,name=temp_blks_read,json=tempBlksRead,proto3" json:"temp_blks_read,omitempty"`
	// Number of written temporary blocks.
	TempBlksWritten int64 `protobuf:"varint,27,opt,name=temp_blks_written,json=tempBlksWritten,proto3" json:"temp_blks_written,omitempty"`
	// Time taken to read data blocks, in milliseconds.
	//
	// The parameter returns a non-zero value if the [track_io_timing](https://www.postgresql.org/docs/current/runtime-config-statistics.html#GUC-TRACK-IO-TIMING) parameter is enabled.
	BlkReadTime float64 `protobuf:"fixed64,28,opt,name=blk_read_time,json=blkReadTime,proto3" json:"blk_read_time,omitempty"`
	// Time taken to record data blocks, in milliseconds.
	//
	// The parameter returns a non-zero value if the [track_io_timing] parameter is enabled.
	BlkWriteTime float64 `protobuf:"fixed64,29,opt,name=blk_write_time,json=blkWriteTime,proto3" json:"blk_write_time,omitempty"`
	// Time taken to read temporary data blocks, in milliseconds.
	//
	// The parameter returns a non-zero value if the [track_io_timing] parameter is enabled.
	TempBlkReadTime float64 `protobuf:"fixed64,30,opt,name=temp_blk_read_time,json=tempBlkReadTime,proto3" json:"temp_blk_read_time,omitempty"`
	// Time taken to record temporary data blocks, in milliseconds.
	//
	// The parameter returns a non-zero value if the [track_io_timing] parameter is enabled.
	TempBlkWriteTime float64 `protobuf:"fixed64,31,opt,name=temp_blk_write_time,json=tempBlkWriteTime,proto3" json:"temp_blk_write_time,omitempty"`
	// Number of WAL records generated during a given period.
	WalRecords int64 `protobuf:"varint,32,opt,name=wal_records,json=walRecords,proto3" json:"wal_records,omitempty"`
	// Number of WAL full page images generated during a given period.
	WalFpi int64 `protobuf:"varint,33,opt,name=wal_fpi,json=walFpi,proto3" json:"wal_fpi,omitempty"`
	// Number of WAL logs generated during a given period, in bytes.
	WalBytes int64 `protobuf:"varint,34,opt,name=wal_bytes,json=walBytes,proto3" json:"wal_bytes,omitempty"`
	// Number of JIT-compiled functions.
	JitFunctions int64 `protobuf:"varint,35,opt,name=jit_functions,json=jitFunctions,proto3" json:"jit_functions,omitempty"`
	// Time taken to generate JIT code, in milliseconds.
	JitGenerationTime float64 `protobuf:"fixed64,36,opt,name=jit_generation_time,json=jitGenerationTime,proto3" json:"jit_generation_time,omitempty"`
	// Number of times that functions have been inlined.
	JitInliningCount int64 `protobuf:"varint,37,opt,name=jit_inlining_count,json=jitInliningCount,proto3" json:"jit_inlining_count,omitempty"`
	// Time taken to inline functions, in milliseconds.
	JitInliningTime float64 `protobuf:"fixed64,38,opt,name=jit_inlining_time,json=jitInliningTime,proto3" json:"jit_inlining_time,omitempty"`
	// Number of times that a query was optimized.
	JitOptimizationCount int64 `protobuf:"varint,39,opt,name=jit_optimization_count,json=jitOptimizationCount,proto3" json:"jit_optimization_count,omitempty"`
	// Time taken to optimize a query, in milliseconds.
	JitOptimizationTime float64 `protobuf:"fixed64,40,opt,name=jit_optimization_time,json=jitOptimizationTime,proto3" json:"jit_optimization_time,omitempty"`
	// Number of times that code was emitted.
	JitEmissionCount int64 `protobuf:"varint,41,opt,name=jit_emission_count,json=jitEmissionCount,proto3" json:"jit_emission_count,omitempty"`
	// Time taken to emit code.
	JitEmissionTime float64 `protobuf:"fixed64,42,opt,name=jit_emission_time,json=jitEmissionTime,proto3" json:"jit_emission_time,omitempty"`
	// Cost of receiving a response to a query before the first row of the response is issued.
	StartupCost int64 `protobuf:"varint,43,opt,name=startup_cost,json=startupCost,proto3" json:"startup_cost,omitempty"`
	// Cost of receiving a response to a query when all the rows of the response are issued.
	TotalCost int64 `protobuf:"varint,44,opt,name=total_cost,json=totalCost,proto3" json:"total_cost,omitempty"`
	// Expected number of rows that a given plan node should issue.
	PlanRows int64 `protobuf:"varint,45,opt,name=plan_rows,json=planRows,proto3" json:"plan_rows,omitempty"`
	// Expected average size of rows that a given plan node should issue.
	PlanWidth int64 `protobuf:"varint,46,opt,name=plan_width,json=planWidth,proto3" json:"plan_width,omitempty"`
	// Number of bytes that the filesystem layer has read.
	Reads int64 `protobuf:"varint,47,opt,name=reads,proto3" json:"reads,omitempty"`
	// Number of bytes that the filesystem layer has written.
	Writes int64 `protobuf:"varint,48,opt,name=writes,proto3" json:"writes,omitempty"`
	// User CPU time used.
	UserTime float64 `protobuf:"fixed64,49,opt,name=user_time,json=userTime,proto3" json:"user_time,omitempty"`
	// System CPU time used.
	SystemTime float64 `protobuf:"fixed64,50,opt,name=system_time,json=systemTime,proto3" json:"system_time,omitempty"`
}

func (x *QueryStats) Reset() {
	*x = QueryStats{}
	if protoimpl.UnsafeEnabled {
		mi := &file_yandex_cloud_mdb_postgresql_v1_perf_diag_proto_msgTypes[2]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *QueryStats) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*QueryStats) ProtoMessage() {}

func (x *QueryStats) ProtoReflect() protoreflect.Message {
	mi := &file_yandex_cloud_mdb_postgresql_v1_perf_diag_proto_msgTypes[2]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use QueryStats.ProtoReflect.Descriptor instead.
func (*QueryStats) Descriptor() ([]byte, []int) {
	return file_yandex_cloud_mdb_postgresql_v1_perf_diag_proto_rawDescGZIP(), []int{2}
}

func (x *QueryStats) GetTime() *timestamppb.Timestamp {
	if x != nil {
		return x.Time
	}
	return nil
}

func (x *QueryStats) GetQuery() string {
	if x != nil {
		return x.Query
	}
	return ""
}

func (x *QueryStats) GetNormalizedPlan() string {
	if x != nil {
		return x.NormalizedPlan
	}
	return ""
}

func (x *QueryStats) GetExamplePlan() string {
	if x != nil {
		return x.ExamplePlan
	}
	return ""
}

func (x *QueryStats) GetPlans() int64 {
	if x != nil {
		return x.Plans
	}
	return 0
}

func (x *QueryStats) GetTotalPlanTime() float64 {
	if x != nil {
		return x.TotalPlanTime
	}
	return 0
}

func (x *QueryStats) GetMinPlanTime() float64 {
	if x != nil {
		return x.MinPlanTime
	}
	return 0
}

func (x *QueryStats) GetMaxPlanTime() float64 {
	if x != nil {
		return x.MaxPlanTime
	}
	return 0
}

func (x *QueryStats) GetMeanPlanTime() float64 {
	if x != nil {
		return x.MeanPlanTime
	}
	return 0
}

func (x *QueryStats) GetStddevPlanTime() float64 {
	if x != nil {
		return x.StddevPlanTime
	}
	return 0
}

func (x *QueryStats) GetCalls() int64 {
	if x != nil {
		return x.Calls
	}
	return 0
}

func (x *QueryStats) GetTotalTime() float64 {
	if x != nil {
		return x.TotalTime
	}
	return 0
}

func (x *QueryStats) GetMinTime() float64 {
	if x != nil {
		return x.MinTime
	}
	return 0
}

func (x *QueryStats) GetMaxTime() float64 {
	if x != nil {
		return x.MaxTime
	}
	return 0
}

func (x *QueryStats) GetMeanTime() float64 {
	if x != nil {
		return x.MeanTime
	}
	return 0
}

func (x *QueryStats) GetStddevTime() float64 {
	if x != nil {
		return x.StddevTime
	}
	return 0
}

func (x *QueryStats) GetRows() int64 {
	if x != nil {
		return x.Rows
	}
	return 0
}

func (x *QueryStats) GetSharedBlksHit() int64 {
	if x != nil {
		return x.SharedBlksHit
	}
	return 0
}

func (x *QueryStats) GetSharedBlksRead() int64 {
	if x != nil {
		return x.SharedBlksRead
	}
	return 0
}

func (x *QueryStats) GetSharedBlksDirtied() int64 {
	if x != nil {
		return x.SharedBlksDirtied
	}
	return 0
}

func (x *QueryStats) GetSharedBlksWritten() int64 {
	if x != nil {
		return x.SharedBlksWritten
	}
	return 0
}

func (x *QueryStats) GetLocalBlksHit() int64 {
	if x != nil {
		return x.LocalBlksHit
	}
	return 0
}

func (x *QueryStats) GetLocalBlksRead() int64 {
	if x != nil {
		return x.LocalBlksRead
	}
	return 0
}

func (x *QueryStats) GetLocalBlksDirtied() int64 {
	if x != nil {
		return x.LocalBlksDirtied
	}
	return 0
}

func (x *QueryStats) GetLocalBlksWritten() int64 {
	if x != nil {
		return x.LocalBlksWritten
	}
	return 0
}

func (x *QueryStats) GetTempBlksRead() int64 {
	if x != nil {
		return x.TempBlksRead
	}
	return 0
}

func (x *QueryStats) GetTempBlksWritten() int64 {
	if x != nil {
		return x.TempBlksWritten
	}
	return 0
}

func (x *QueryStats) GetBlkReadTime() float64 {
	if x != nil {
		return x.BlkReadTime
	}
	return 0
}

func (x *QueryStats) GetBlkWriteTime() float64 {
	if x != nil {
		return x.BlkWriteTime
	}
	return 0
}

func (x *QueryStats) GetTempBlkReadTime() float64 {
	if x != nil {
		return x.TempBlkReadTime
	}
	return 0
}

func (x *QueryStats) GetTempBlkWriteTime() float64 {
	if x != nil {
		return x.TempBlkWriteTime
	}
	return 0
}

func (x *QueryStats) GetWalRecords() int64 {
	if x != nil {
		return x.WalRecords
	}
	return 0
}

func (x *QueryStats) GetWalFpi() int64 {
	if x != nil {
		return x.WalFpi
	}
	return 0
}

func (x *QueryStats) GetWalBytes() int64 {
	if x != nil {
		return x.WalBytes
	}
	return 0
}

func (x *QueryStats) GetJitFunctions() int64 {
	if x != nil {
		return x.JitFunctions
	}
	return 0
}

func (x *QueryStats) GetJitGenerationTime() float64 {
	if x != nil {
		return x.JitGenerationTime
	}
	return 0
}

func (x *QueryStats) GetJitInliningCount() int64 {
	if x != nil {
		return x.JitInliningCount
	}
	return 0
}

func (x *QueryStats) GetJitInliningTime() float64 {
	if x != nil {
		return x.JitInliningTime
	}
	return 0
}

func (x *QueryStats) GetJitOptimizationCount() int64 {
	if x != nil {
		return x.JitOptimizationCount
	}
	return 0
}

func (x *QueryStats) GetJitOptimizationTime() float64 {
	if x != nil {
		return x.JitOptimizationTime
	}
	return 0
}

func (x *QueryStats) GetJitEmissionCount() int64 {
	if x != nil {
		return x.JitEmissionCount
	}
	return 0
}

func (x *QueryStats) GetJitEmissionTime() float64 {
	if x != nil {
		return x.JitEmissionTime
	}
	return 0
}

func (x *QueryStats) GetStartupCost() int64 {
	if x != nil {
		return x.StartupCost
	}
	return 0
}

func (x *QueryStats) GetTotalCost() int64 {
	if x != nil {
		return x.TotalCost
	}
	return 0
}

func (x *QueryStats) GetPlanRows() int64 {
	if x != nil {
		return x.PlanRows
	}
	return 0
}

func (x *QueryStats) GetPlanWidth() int64 {
	if x != nil {
		return x.PlanWidth
	}
	return 0
}

func (x *QueryStats) GetReads() int64 {
	if x != nil {
		return x.Reads
	}
	return 0
}

func (x *QueryStats) GetWrites() int64 {
	if x != nil {
		return x.Writes
	}
	return 0
}

func (x *QueryStats) GetUserTime() float64 {
	if x != nil {
		return x.UserTime
	}
	return 0
}

func (x *QueryStats) GetSystemTime() float64 {
	if x != nil {
		return x.SystemTime
	}
	return 0
}

type QueryStatement struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Primary keys in tables with the statistics on planning and execution of queries.
	Key *PrimaryKey `protobuf:"bytes,1,opt,name=key,proto3" json:"key,omitempty"`
	// Statistics on planning and execution of queries.
	Stats *QueryStats `protobuf:"bytes,2,opt,name=stats,proto3" json:"stats,omitempty"`
}

func (x *QueryStatement) Reset() {
	*x = QueryStatement{}
	if protoimpl.UnsafeEnabled {
		mi := &file_yandex_cloud_mdb_postgresql_v1_perf_diag_proto_msgTypes[3]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *QueryStatement) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*QueryStatement) ProtoMessage() {}

func (x *QueryStatement) ProtoReflect() protoreflect.Message {
	mi := &file_yandex_cloud_mdb_postgresql_v1_perf_diag_proto_msgTypes[3]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use QueryStatement.ProtoReflect.Descriptor instead.
func (*QueryStatement) Descriptor() ([]byte, []int) {
	return file_yandex_cloud_mdb_postgresql_v1_perf_diag_proto_rawDescGZIP(), []int{3}
}

func (x *QueryStatement) GetKey() *PrimaryKey {
	if x != nil {
		return x.Key
	}
	return nil
}

func (x *QueryStatement) GetStats() *QueryStats {
	if x != nil {
		return x.Stats
	}
	return nil
}

var File_yandex_cloud_mdb_postgresql_v1_perf_diag_proto protoreflect.FileDescriptor

var file_yandex_cloud_mdb_postgresql_v1_perf_diag_proto_rawDesc = []byte{
	0x0a, 0x2e, 0x79, 0x61, 0x6e, 0x64, 0x65, 0x78, 0x2f, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2f, 0x6d,
	0x64, 0x62, 0x2f, 0x70, 0x6f, 0x73, 0x74, 0x67, 0x72, 0x65, 0x73, 0x71, 0x6c, 0x2f, 0x76, 0x31,
	0x2f, 0x70, 0x65, 0x72, 0x66, 0x5f, 0x64, 0x69, 0x61, 0x67, 0x2e, 0x70, 0x72, 0x6f, 0x74, 0x6f,
	0x12, 0x1e, 0x79, 0x61, 0x6e, 0x64, 0x65, 0x78, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x6d,
	0x64, 0x62, 0x2e, 0x70, 0x6f, 0x73, 0x74, 0x67, 0x72, 0x65, 0x73, 0x71, 0x6c, 0x2e, 0x76, 0x31,
	0x1a, 0x1f, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2f, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x62, 0x75,
	0x66, 0x2f, 0x74, 0x69, 0x6d, 0x65, 0x73, 0x74, 0x61, 0x6d, 0x70, 0x2e, 0x70, 0x72, 0x6f, 0x74,
	0x6f, 0x22, 0xc2, 0x06, 0x0a, 0x0c, 0x53, 0x65, 0x73, 0x73, 0x69, 0x6f, 0x6e, 0x53, 0x74, 0x61,
	0x74, 0x65, 0x12, 0x2e, 0x0a, 0x04, 0x74, 0x69, 0x6d, 0x65, 0x18, 0x01, 0x20, 0x01, 0x28, 0x0b,
	0x32, 0x1a, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x62,
	0x75, 0x66, 0x2e, 0x54, 0x69, 0x6d, 0x65, 0x73, 0x74, 0x61, 0x6d, 0x70, 0x52, 0x04, 0x74, 0x69,
	0x6d, 0x65, 0x12, 0x12, 0x0a, 0x04, 0x68, 0x6f, 0x73, 0x74, 0x18, 0x02, 0x20, 0x01, 0x28, 0x09,
	0x52, 0x04, 0x68, 0x6f, 0x73, 0x74, 0x12, 0x10, 0x0a, 0x03, 0x70, 0x69, 0x64, 0x18, 0x03, 0x20,
	0x01, 0x28, 0x03, 0x52, 0x03, 0x70, 0x69, 0x64, 0x12, 0x1a, 0x0a, 0x08, 0x64, 0x61, 0x74, 0x61,
	0x62, 0x61, 0x73, 0x65, 0x18, 0x04, 0x20, 0x01, 0x28, 0x09, 0x52, 0x08, 0x64, 0x61, 0x74, 0x61,
	0x62, 0x61, 0x73, 0x65, 0x12, 0x12, 0x0a, 0x04, 0x75, 0x73, 0x65, 0x72, 0x18, 0x05, 0x20, 0x01,
	0x28, 0x09, 0x52, 0x04, 0x75, 0x73, 0x65, 0x72, 0x12, 0x29, 0x0a, 0x10, 0x61, 0x70, 0x70, 0x6c,
	0x69, 0x63, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x5f, 0x6e, 0x61, 0x6d, 0x65, 0x18, 0x06, 0x20, 0x01,
	0x28, 0x09, 0x52, 0x0f, 0x61, 0x70, 0x70, 0x6c, 0x69, 0x63, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x4e,
	0x61, 0x6d, 0x65, 0x12, 0x3f, 0x0a, 0x0d, 0x62, 0x61, 0x63, 0x6b, 0x65, 0x6e, 0x64, 0x5f, 0x73,
	0x74, 0x61, 0x72, 0x74, 0x18, 0x07, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x1a, 0x2e, 0x67, 0x6f, 0x6f,
	0x67, 0x6c, 0x65, 0x2e, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x62, 0x75, 0x66, 0x2e, 0x54, 0x69, 0x6d,
	0x65, 0x73, 0x74, 0x61, 0x6d, 0x70, 0x52, 0x0c, 0x62, 0x61, 0x63, 0x6b, 0x65, 0x6e, 0x64, 0x53,
	0x74, 0x61, 0x72, 0x74, 0x12, 0x39, 0x0a, 0x0a, 0x78, 0x61, 0x63, 0x74, 0x5f, 0x73, 0x74, 0x61,
	0x72, 0x74, 0x18, 0x08, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x1a, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c,
	0x65, 0x2e, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x62, 0x75, 0x66, 0x2e, 0x54, 0x69, 0x6d, 0x65, 0x73,
	0x74, 0x61, 0x6d, 0x70, 0x52, 0x09, 0x78, 0x61, 0x63, 0x74, 0x53, 0x74, 0x61, 0x72, 0x74, 0x12,
	0x3b, 0x0a, 0x0b, 0x71, 0x75, 0x65, 0x72, 0x79, 0x5f, 0x73, 0x74, 0x61, 0x72, 0x74, 0x18, 0x09,
	0x20, 0x01, 0x28, 0x0b, 0x32, 0x1a, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x70, 0x72,
	0x6f, 0x74, 0x6f, 0x62, 0x75, 0x66, 0x2e, 0x54, 0x69, 0x6d, 0x65, 0x73, 0x74, 0x61, 0x6d, 0x70,
	0x52, 0x0a, 0x71, 0x75, 0x65, 0x72, 0x79, 0x53, 0x74, 0x61, 0x72, 0x74, 0x12, 0x3d, 0x0a, 0x0c,
	0x73, 0x74, 0x61, 0x74, 0x65, 0x5f, 0x63, 0x68, 0x61, 0x6e, 0x67, 0x65, 0x18, 0x0a, 0x20, 0x01,
	0x28, 0x0b, 0x32, 0x1a, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x70, 0x72, 0x6f, 0x74,
	0x6f, 0x62, 0x75, 0x66, 0x2e, 0x54, 0x69, 0x6d, 0x65, 0x73, 0x74, 0x61, 0x6d, 0x70, 0x52, 0x0b,
	0x73, 0x74, 0x61, 0x74, 0x65, 0x43, 0x68, 0x61, 0x6e, 0x67, 0x65, 0x12, 0x26, 0x0a, 0x0f, 0x77,
	0x61, 0x69, 0x74, 0x5f, 0x65, 0x76, 0x65, 0x6e, 0x74, 0x5f, 0x74, 0x79, 0x70, 0x65, 0x18, 0x0b,
	0x20, 0x01, 0x28, 0x09, 0x52, 0x0d, 0x77, 0x61, 0x69, 0x74, 0x45, 0x76, 0x65, 0x6e, 0x74, 0x54,
	0x79, 0x70, 0x65, 0x12, 0x1d, 0x0a, 0x0a, 0x77, 0x61, 0x69, 0x74, 0x5f, 0x65, 0x76, 0x65, 0x6e,
	0x74, 0x18, 0x0c, 0x20, 0x01, 0x28, 0x09, 0x52, 0x09, 0x77, 0x61, 0x69, 0x74, 0x45, 0x76, 0x65,
	0x6e, 0x74, 0x12, 0x14, 0x0a, 0x05, 0x73, 0x74, 0x61, 0x74, 0x65, 0x18, 0x0d, 0x20, 0x01, 0x28,
	0x09, 0x52, 0x05, 0x73, 0x74, 0x61, 0x74, 0x65, 0x12, 0x14, 0x0a, 0x05, 0x71, 0x75, 0x65, 0x72,
	0x79, 0x18, 0x0e, 0x20, 0x01, 0x28, 0x09, 0x52, 0x05, 0x71, 0x75, 0x65, 0x72, 0x79, 0x12, 0x21,
	0x0a, 0x0c, 0x62, 0x61, 0x63, 0x6b, 0x65, 0x6e, 0x64, 0x5f, 0x74, 0x79, 0x70, 0x65, 0x18, 0x0f,
	0x20, 0x01, 0x28, 0x09, 0x52, 0x0b, 0x62, 0x61, 0x63, 0x6b, 0x65, 0x6e, 0x64, 0x54, 0x79, 0x70,
	0x65, 0x12, 0x1f, 0x0a, 0x0b, 0x63, 0x6c, 0x69, 0x65, 0x6e, 0x74, 0x5f, 0x61, 0x64, 0x64, 0x72,
	0x18, 0x10, 0x20, 0x01, 0x28, 0x09, 0x52, 0x0a, 0x63, 0x6c, 0x69, 0x65, 0x6e, 0x74, 0x41, 0x64,
	0x64, 0x72, 0x12, 0x27, 0x0a, 0x0f, 0x63, 0x6c, 0x69, 0x65, 0x6e, 0x74, 0x5f, 0x68, 0x6f, 0x73,
	0x74, 0x6e, 0x61, 0x6d, 0x65, 0x18, 0x11, 0x20, 0x01, 0x28, 0x09, 0x52, 0x0e, 0x63, 0x6c, 0x69,
	0x65, 0x6e, 0x74, 0x48, 0x6f, 0x73, 0x74, 0x6e, 0x61, 0x6d, 0x65, 0x12, 0x1f, 0x0a, 0x0b, 0x63,
	0x6c, 0x69, 0x65, 0x6e, 0x74, 0x5f, 0x70, 0x6f, 0x72, 0x74, 0x18, 0x12, 0x20, 0x01, 0x28, 0x03,
	0x52, 0x0a, 0x63, 0x6c, 0x69, 0x65, 0x6e, 0x74, 0x50, 0x6f, 0x72, 0x74, 0x12, 0x1f, 0x0a, 0x0b,
	0x62, 0x61, 0x63, 0x6b, 0x65, 0x6e, 0x64, 0x5f, 0x78, 0x69, 0x64, 0x18, 0x13, 0x20, 0x01, 0x28,
	0x03, 0x52, 0x0a, 0x62, 0x61, 0x63, 0x6b, 0x65, 0x6e, 0x64, 0x58, 0x69, 0x64, 0x12, 0x21, 0x0a,
	0x0c, 0x62, 0x61, 0x63, 0x6b, 0x65, 0x6e, 0x64, 0x5f, 0x78, 0x6d, 0x69, 0x6e, 0x18, 0x14, 0x20,
	0x01, 0x28, 0x03, 0x52, 0x0b, 0x62, 0x61, 0x63, 0x6b, 0x65, 0x6e, 0x64, 0x58, 0x6d, 0x69, 0x6e,
	0x12, 0x23, 0x0a, 0x0d, 0x62, 0x6c, 0x6f, 0x63, 0x6b, 0x69, 0x6e, 0x67, 0x5f, 0x70, 0x69, 0x64,
	0x73, 0x18, 0x16, 0x20, 0x01, 0x28, 0x09, 0x52, 0x0c, 0x62, 0x6c, 0x6f, 0x63, 0x6b, 0x69, 0x6e,
	0x67, 0x50, 0x69, 0x64, 0x73, 0x12, 0x19, 0x0a, 0x08, 0x71, 0x75, 0x65, 0x72, 0x79, 0x5f, 0x69,
	0x64, 0x18, 0x17, 0x20, 0x01, 0x28, 0x09, 0x52, 0x07, 0x71, 0x75, 0x65, 0x72, 0x79, 0x49, 0x64,
	0x4a, 0x04, 0x08, 0x15, 0x10, 0x16, 0x22, 0xa0, 0x01, 0x0a, 0x0a, 0x50, 0x72, 0x69, 0x6d, 0x61,
	0x72, 0x79, 0x4b, 0x65, 0x79, 0x12, 0x12, 0x0a, 0x04, 0x68, 0x6f, 0x73, 0x74, 0x18, 0x01, 0x20,
	0x01, 0x28, 0x09, 0x52, 0x04, 0x68, 0x6f, 0x73, 0x74, 0x12, 0x12, 0x0a, 0x04, 0x75, 0x73, 0x65,
	0x72, 0x18, 0x02, 0x20, 0x01, 0x28, 0x09, 0x52, 0x04, 0x75, 0x73, 0x65, 0x72, 0x12, 0x1a, 0x0a,
	0x08, 0x64, 0x61, 0x74, 0x61, 0x62, 0x61, 0x73, 0x65, 0x18, 0x04, 0x20, 0x01, 0x28, 0x09, 0x52,
	0x08, 0x64, 0x61, 0x74, 0x61, 0x62, 0x61, 0x73, 0x65, 0x12, 0x1a, 0x0a, 0x08, 0x74, 0x6f, 0x70,
	0x6c, 0x65, 0x76, 0x65, 0x6c, 0x18, 0x05, 0x20, 0x01, 0x28, 0x08, 0x52, 0x08, 0x74, 0x6f, 0x70,
	0x6c, 0x65, 0x76, 0x65, 0x6c, 0x12, 0x19, 0x0a, 0x08, 0x71, 0x75, 0x65, 0x72, 0x79, 0x5f, 0x69,
	0x64, 0x18, 0x06, 0x20, 0x01, 0x28, 0x09, 0x52, 0x07, 0x71, 0x75, 0x65, 0x72, 0x79, 0x49, 0x64,
	0x12, 0x17, 0x0a, 0x07, 0x70, 0x6c, 0x61, 0x6e, 0x5f, 0x69, 0x64, 0x18, 0x07, 0x20, 0x01, 0x28,
	0x09, 0x52, 0x06, 0x70, 0x6c, 0x61, 0x6e, 0x49, 0x64, 0x22, 0xb9, 0x0e, 0x0a, 0x0a, 0x51, 0x75,
	0x65, 0x72, 0x79, 0x53, 0x74, 0x61, 0x74, 0x73, 0x12, 0x2e, 0x0a, 0x04, 0x74, 0x69, 0x6d, 0x65,
	0x18, 0x01, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x1a, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e,
	0x70, 0x72, 0x6f, 0x74, 0x6f, 0x62, 0x75, 0x66, 0x2e, 0x54, 0x69, 0x6d, 0x65, 0x73, 0x74, 0x61,
	0x6d, 0x70, 0x52, 0x04, 0x74, 0x69, 0x6d, 0x65, 0x12, 0x14, 0x0a, 0x05, 0x71, 0x75, 0x65, 0x72,
	0x79, 0x18, 0x02, 0x20, 0x01, 0x28, 0x09, 0x52, 0x05, 0x71, 0x75, 0x65, 0x72, 0x79, 0x12, 0x27,
	0x0a, 0x0f, 0x6e, 0x6f, 0x72, 0x6d, 0x61, 0x6c, 0x69, 0x7a, 0x65, 0x64, 0x5f, 0x70, 0x6c, 0x61,
	0x6e, 0x18, 0x03, 0x20, 0x01, 0x28, 0x09, 0x52, 0x0e, 0x6e, 0x6f, 0x72, 0x6d, 0x61, 0x6c, 0x69,
	0x7a, 0x65, 0x64, 0x50, 0x6c, 0x61, 0x6e, 0x12, 0x21, 0x0a, 0x0c, 0x65, 0x78, 0x61, 0x6d, 0x70,
	0x6c, 0x65, 0x5f, 0x70, 0x6c, 0x61, 0x6e, 0x18, 0x04, 0x20, 0x01, 0x28, 0x09, 0x52, 0x0b, 0x65,
	0x78, 0x61, 0x6d, 0x70, 0x6c, 0x65, 0x50, 0x6c, 0x61, 0x6e, 0x12, 0x14, 0x0a, 0x05, 0x70, 0x6c,
	0x61, 0x6e, 0x73, 0x18, 0x05, 0x20, 0x01, 0x28, 0x03, 0x52, 0x05, 0x70, 0x6c, 0x61, 0x6e, 0x73,
	0x12, 0x26, 0x0a, 0x0f, 0x74, 0x6f, 0x74, 0x61, 0x6c, 0x5f, 0x70, 0x6c, 0x61, 0x6e, 0x5f, 0x74,
	0x69, 0x6d, 0x65, 0x18, 0x06, 0x20, 0x01, 0x28, 0x01, 0x52, 0x0d, 0x74, 0x6f, 0x74, 0x61, 0x6c,
	0x50, 0x6c, 0x61, 0x6e, 0x54, 0x69, 0x6d, 0x65, 0x12, 0x22, 0x0a, 0x0d, 0x6d, 0x69, 0x6e, 0x5f,
	0x70, 0x6c, 0x61, 0x6e, 0x5f, 0x74, 0x69, 0x6d, 0x65, 0x18, 0x07, 0x20, 0x01, 0x28, 0x01, 0x52,
	0x0b, 0x6d, 0x69, 0x6e, 0x50, 0x6c, 0x61, 0x6e, 0x54, 0x69, 0x6d, 0x65, 0x12, 0x22, 0x0a, 0x0d,
	0x6d, 0x61, 0x78, 0x5f, 0x70, 0x6c, 0x61, 0x6e, 0x5f, 0x74, 0x69, 0x6d, 0x65, 0x18, 0x08, 0x20,
	0x01, 0x28, 0x01, 0x52, 0x0b, 0x6d, 0x61, 0x78, 0x50, 0x6c, 0x61, 0x6e, 0x54, 0x69, 0x6d, 0x65,
	0x12, 0x24, 0x0a, 0x0e, 0x6d, 0x65, 0x61, 0x6e, 0x5f, 0x70, 0x6c, 0x61, 0x6e, 0x5f, 0x74, 0x69,
	0x6d, 0x65, 0x18, 0x09, 0x20, 0x01, 0x28, 0x01, 0x52, 0x0c, 0x6d, 0x65, 0x61, 0x6e, 0x50, 0x6c,
	0x61, 0x6e, 0x54, 0x69, 0x6d, 0x65, 0x12, 0x28, 0x0a, 0x10, 0x73, 0x74, 0x64, 0x64, 0x65, 0x76,
	0x5f, 0x70, 0x6c, 0x61, 0x6e, 0x5f, 0x74, 0x69, 0x6d, 0x65, 0x18, 0x0a, 0x20, 0x01, 0x28, 0x01,
	0x52, 0x0e, 0x73, 0x74, 0x64, 0x64, 0x65, 0x76, 0x50, 0x6c, 0x61, 0x6e, 0x54, 0x69, 0x6d, 0x65,
	0x12, 0x14, 0x0a, 0x05, 0x63, 0x61, 0x6c, 0x6c, 0x73, 0x18, 0x0b, 0x20, 0x01, 0x28, 0x03, 0x52,
	0x05, 0x63, 0x61, 0x6c, 0x6c, 0x73, 0x12, 0x1d, 0x0a, 0x0a, 0x74, 0x6f, 0x74, 0x61, 0x6c, 0x5f,
	0x74, 0x69, 0x6d, 0x65, 0x18, 0x0c, 0x20, 0x01, 0x28, 0x01, 0x52, 0x09, 0x74, 0x6f, 0x74, 0x61,
	0x6c, 0x54, 0x69, 0x6d, 0x65, 0x12, 0x19, 0x0a, 0x08, 0x6d, 0x69, 0x6e, 0x5f, 0x74, 0x69, 0x6d,
	0x65, 0x18, 0x0d, 0x20, 0x01, 0x28, 0x01, 0x52, 0x07, 0x6d, 0x69, 0x6e, 0x54, 0x69, 0x6d, 0x65,
	0x12, 0x19, 0x0a, 0x08, 0x6d, 0x61, 0x78, 0x5f, 0x74, 0x69, 0x6d, 0x65, 0x18, 0x0e, 0x20, 0x01,
	0x28, 0x01, 0x52, 0x07, 0x6d, 0x61, 0x78, 0x54, 0x69, 0x6d, 0x65, 0x12, 0x1b, 0x0a, 0x09, 0x6d,
	0x65, 0x61, 0x6e, 0x5f, 0x74, 0x69, 0x6d, 0x65, 0x18, 0x0f, 0x20, 0x01, 0x28, 0x01, 0x52, 0x08,
	0x6d, 0x65, 0x61, 0x6e, 0x54, 0x69, 0x6d, 0x65, 0x12, 0x1f, 0x0a, 0x0b, 0x73, 0x74, 0x64, 0x64,
	0x65, 0x76, 0x5f, 0x74, 0x69, 0x6d, 0x65, 0x18, 0x10, 0x20, 0x01, 0x28, 0x01, 0x52, 0x0a, 0x73,
	0x74, 0x64, 0x64, 0x65, 0x76, 0x54, 0x69, 0x6d, 0x65, 0x12, 0x12, 0x0a, 0x04, 0x72, 0x6f, 0x77,
	0x73, 0x18, 0x11, 0x20, 0x01, 0x28, 0x03, 0x52, 0x04, 0x72, 0x6f, 0x77, 0x73, 0x12, 0x26, 0x0a,
	0x0f, 0x73, 0x68, 0x61, 0x72, 0x65, 0x64, 0x5f, 0x62, 0x6c, 0x6b, 0x73, 0x5f, 0x68, 0x69, 0x74,
	0x18, 0x12, 0x20, 0x01, 0x28, 0x03, 0x52, 0x0d, 0x73, 0x68, 0x61, 0x72, 0x65, 0x64, 0x42, 0x6c,
	0x6b, 0x73, 0x48, 0x69, 0x74, 0x12, 0x28, 0x0a, 0x10, 0x73, 0x68, 0x61, 0x72, 0x65, 0x64, 0x5f,
	0x62, 0x6c, 0x6b, 0x73, 0x5f, 0x72, 0x65, 0x61, 0x64, 0x18, 0x13, 0x20, 0x01, 0x28, 0x03, 0x52,
	0x0e, 0x73, 0x68, 0x61, 0x72, 0x65, 0x64, 0x42, 0x6c, 0x6b, 0x73, 0x52, 0x65, 0x61, 0x64, 0x12,
	0x2e, 0x0a, 0x13, 0x73, 0x68, 0x61, 0x72, 0x65, 0x64, 0x5f, 0x62, 0x6c, 0x6b, 0x73, 0x5f, 0x64,
	0x69, 0x72, 0x74, 0x69, 0x65, 0x64, 0x18, 0x14, 0x20, 0x01, 0x28, 0x03, 0x52, 0x11, 0x73, 0x68,
	0x61, 0x72, 0x65, 0x64, 0x42, 0x6c, 0x6b, 0x73, 0x44, 0x69, 0x72, 0x74, 0x69, 0x65, 0x64, 0x12,
	0x2e, 0x0a, 0x13, 0x73, 0x68, 0x61, 0x72, 0x65, 0x64, 0x5f, 0x62, 0x6c, 0x6b, 0x73, 0x5f, 0x77,
	0x72, 0x69, 0x74, 0x74, 0x65, 0x6e, 0x18, 0x15, 0x20, 0x01, 0x28, 0x03, 0x52, 0x11, 0x73, 0x68,
	0x61, 0x72, 0x65, 0x64, 0x42, 0x6c, 0x6b, 0x73, 0x57, 0x72, 0x69, 0x74, 0x74, 0x65, 0x6e, 0x12,
	0x24, 0x0a, 0x0e, 0x6c, 0x6f, 0x63, 0x61, 0x6c, 0x5f, 0x62, 0x6c, 0x6b, 0x73, 0x5f, 0x68, 0x69,
	0x74, 0x18, 0x16, 0x20, 0x01, 0x28, 0x03, 0x52, 0x0c, 0x6c, 0x6f, 0x63, 0x61, 0x6c, 0x42, 0x6c,
	0x6b, 0x73, 0x48, 0x69, 0x74, 0x12, 0x26, 0x0a, 0x0f, 0x6c, 0x6f, 0x63, 0x61, 0x6c, 0x5f, 0x62,
	0x6c, 0x6b, 0x73, 0x5f, 0x72, 0x65, 0x61, 0x64, 0x18, 0x17, 0x20, 0x01, 0x28, 0x03, 0x52, 0x0d,
	0x6c, 0x6f, 0x63, 0x61, 0x6c, 0x42, 0x6c, 0x6b, 0x73, 0x52, 0x65, 0x61, 0x64, 0x12, 0x2c, 0x0a,
	0x12, 0x6c, 0x6f, 0x63, 0x61, 0x6c, 0x5f, 0x62, 0x6c, 0x6b, 0x73, 0x5f, 0x64, 0x69, 0x72, 0x74,
	0x69, 0x65, 0x64, 0x18, 0x18, 0x20, 0x01, 0x28, 0x03, 0x52, 0x10, 0x6c, 0x6f, 0x63, 0x61, 0x6c,
	0x42, 0x6c, 0x6b, 0x73, 0x44, 0x69, 0x72, 0x74, 0x69, 0x65, 0x64, 0x12, 0x2c, 0x0a, 0x12, 0x6c,
	0x6f, 0x63, 0x61, 0x6c, 0x5f, 0x62, 0x6c, 0x6b, 0x73, 0x5f, 0x77, 0x72, 0x69, 0x74, 0x74, 0x65,
	0x6e, 0x18, 0x19, 0x20, 0x01, 0x28, 0x03, 0x52, 0x10, 0x6c, 0x6f, 0x63, 0x61, 0x6c, 0x42, 0x6c,
	0x6b, 0x73, 0x57, 0x72, 0x69, 0x74, 0x74, 0x65, 0x6e, 0x12, 0x24, 0x0a, 0x0e, 0x74, 0x65, 0x6d,
	0x70, 0x5f, 0x62, 0x6c, 0x6b, 0x73, 0x5f, 0x72, 0x65, 0x61, 0x64, 0x18, 0x1a, 0x20, 0x01, 0x28,
	0x03, 0x52, 0x0c, 0x74, 0x65, 0x6d, 0x70, 0x42, 0x6c, 0x6b, 0x73, 0x52, 0x65, 0x61, 0x64, 0x12,
	0x2a, 0x0a, 0x11, 0x74, 0x65, 0x6d, 0x70, 0x5f, 0x62, 0x6c, 0x6b, 0x73, 0x5f, 0x77, 0x72, 0x69,
	0x74, 0x74, 0x65, 0x6e, 0x18, 0x1b, 0x20, 0x01, 0x28, 0x03, 0x52, 0x0f, 0x74, 0x65, 0x6d, 0x70,
	0x42, 0x6c, 0x6b, 0x73, 0x57, 0x72, 0x69, 0x74, 0x74, 0x65, 0x6e, 0x12, 0x22, 0x0a, 0x0d, 0x62,
	0x6c, 0x6b, 0x5f, 0x72, 0x65, 0x61, 0x64, 0x5f, 0x74, 0x69, 0x6d, 0x65, 0x18, 0x1c, 0x20, 0x01,
	0x28, 0x01, 0x52, 0x0b, 0x62, 0x6c, 0x6b, 0x52, 0x65, 0x61, 0x64, 0x54, 0x69, 0x6d, 0x65, 0x12,
	0x24, 0x0a, 0x0e, 0x62, 0x6c, 0x6b, 0x5f, 0x77, 0x72, 0x69, 0x74, 0x65, 0x5f, 0x74, 0x69, 0x6d,
	0x65, 0x18, 0x1d, 0x20, 0x01, 0x28, 0x01, 0x52, 0x0c, 0x62, 0x6c, 0x6b, 0x57, 0x72, 0x69, 0x74,
	0x65, 0x54, 0x69, 0x6d, 0x65, 0x12, 0x2b, 0x0a, 0x12, 0x74, 0x65, 0x6d, 0x70, 0x5f, 0x62, 0x6c,
	0x6b, 0x5f, 0x72, 0x65, 0x61, 0x64, 0x5f, 0x74, 0x69, 0x6d, 0x65, 0x18, 0x1e, 0x20, 0x01, 0x28,
	0x01, 0x52, 0x0f, 0x74, 0x65, 0x6d, 0x70, 0x42, 0x6c, 0x6b, 0x52, 0x65, 0x61, 0x64, 0x54, 0x69,
	0x6d, 0x65, 0x12, 0x2d, 0x0a, 0x13, 0x74, 0x65, 0x6d, 0x70, 0x5f, 0x62, 0x6c, 0x6b, 0x5f, 0x77,
	0x72, 0x69, 0x74, 0x65, 0x5f, 0x74, 0x69, 0x6d, 0x65, 0x18, 0x1f, 0x20, 0x01, 0x28, 0x01, 0x52,
	0x10, 0x74, 0x65, 0x6d, 0x70, 0x42, 0x6c, 0x6b, 0x57, 0x72, 0x69, 0x74, 0x65, 0x54, 0x69, 0x6d,
	0x65, 0x12, 0x1f, 0x0a, 0x0b, 0x77, 0x61, 0x6c, 0x5f, 0x72, 0x65, 0x63, 0x6f, 0x72, 0x64, 0x73,
	0x18, 0x20, 0x20, 0x01, 0x28, 0x03, 0x52, 0x0a, 0x77, 0x61, 0x6c, 0x52, 0x65, 0x63, 0x6f, 0x72,
	0x64, 0x73, 0x12, 0x17, 0x0a, 0x07, 0x77, 0x61, 0x6c, 0x5f, 0x66, 0x70, 0x69, 0x18, 0x21, 0x20,
	0x01, 0x28, 0x03, 0x52, 0x06, 0x77, 0x61, 0x6c, 0x46, 0x70, 0x69, 0x12, 0x1b, 0x0a, 0x09, 0x77,
	0x61, 0x6c, 0x5f, 0x62, 0x79, 0x74, 0x65, 0x73, 0x18, 0x22, 0x20, 0x01, 0x28, 0x03, 0x52, 0x08,
	0x77, 0x61, 0x6c, 0x42, 0x79, 0x74, 0x65, 0x73, 0x12, 0x23, 0x0a, 0x0d, 0x6a, 0x69, 0x74, 0x5f,
	0x66, 0x75, 0x6e, 0x63, 0x74, 0x69, 0x6f, 0x6e, 0x73, 0x18, 0x23, 0x20, 0x01, 0x28, 0x03, 0x52,
	0x0c, 0x6a, 0x69, 0x74, 0x46, 0x75, 0x6e, 0x63, 0x74, 0x69, 0x6f, 0x6e, 0x73, 0x12, 0x2e, 0x0a,
	0x13, 0x6a, 0x69, 0x74, 0x5f, 0x67, 0x65, 0x6e, 0x65, 0x72, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x5f,
	0x74, 0x69, 0x6d, 0x65, 0x18, 0x24, 0x20, 0x01, 0x28, 0x01, 0x52, 0x11, 0x6a, 0x69, 0x74, 0x47,
	0x65, 0x6e, 0x65, 0x72, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x54, 0x69, 0x6d, 0x65, 0x12, 0x2c, 0x0a,
	0x12, 0x6a, 0x69, 0x74, 0x5f, 0x69, 0x6e, 0x6c, 0x69, 0x6e, 0x69, 0x6e, 0x67, 0x5f, 0x63, 0x6f,
	0x75, 0x6e, 0x74, 0x18, 0x25, 0x20, 0x01, 0x28, 0x03, 0x52, 0x10, 0x6a, 0x69, 0x74, 0x49, 0x6e,
	0x6c, 0x69, 0x6e, 0x69, 0x6e, 0x67, 0x43, 0x6f, 0x75, 0x6e, 0x74, 0x12, 0x2a, 0x0a, 0x11, 0x6a,
	0x69, 0x74, 0x5f, 0x69, 0x6e, 0x6c, 0x69, 0x6e, 0x69, 0x6e, 0x67, 0x5f, 0x74, 0x69, 0x6d, 0x65,
	0x18, 0x26, 0x20, 0x01, 0x28, 0x01, 0x52, 0x0f, 0x6a, 0x69, 0x74, 0x49, 0x6e, 0x6c, 0x69, 0x6e,
	0x69, 0x6e, 0x67, 0x54, 0x69, 0x6d, 0x65, 0x12, 0x34, 0x0a, 0x16, 0x6a, 0x69, 0x74, 0x5f, 0x6f,
	0x70, 0x74, 0x69, 0x6d, 0x69, 0x7a, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x5f, 0x63, 0x6f, 0x75, 0x6e,
	0x74, 0x18, 0x27, 0x20, 0x01, 0x28, 0x03, 0x52, 0x14, 0x6a, 0x69, 0x74, 0x4f, 0x70, 0x74, 0x69,
	0x6d, 0x69, 0x7a, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x43, 0x6f, 0x75, 0x6e, 0x74, 0x12, 0x32, 0x0a,
	0x15, 0x6a, 0x69, 0x74, 0x5f, 0x6f, 0x70, 0x74, 0x69, 0x6d, 0x69, 0x7a, 0x61, 0x74, 0x69, 0x6f,
	0x6e, 0x5f, 0x74, 0x69, 0x6d, 0x65, 0x18, 0x28, 0x20, 0x01, 0x28, 0x01, 0x52, 0x13, 0x6a, 0x69,
	0x74, 0x4f, 0x70, 0x74, 0x69, 0x6d, 0x69, 0x7a, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x54, 0x69, 0x6d,
	0x65, 0x12, 0x2c, 0x0a, 0x12, 0x6a, 0x69, 0x74, 0x5f, 0x65, 0x6d, 0x69, 0x73, 0x73, 0x69, 0x6f,
	0x6e, 0x5f, 0x63, 0x6f, 0x75, 0x6e, 0x74, 0x18, 0x29, 0x20, 0x01, 0x28, 0x03, 0x52, 0x10, 0x6a,
	0x69, 0x74, 0x45, 0x6d, 0x69, 0x73, 0x73, 0x69, 0x6f, 0x6e, 0x43, 0x6f, 0x75, 0x6e, 0x74, 0x12,
	0x2a, 0x0a, 0x11, 0x6a, 0x69, 0x74, 0x5f, 0x65, 0x6d, 0x69, 0x73, 0x73, 0x69, 0x6f, 0x6e, 0x5f,
	0x74, 0x69, 0x6d, 0x65, 0x18, 0x2a, 0x20, 0x01, 0x28, 0x01, 0x52, 0x0f, 0x6a, 0x69, 0x74, 0x45,
	0x6d, 0x69, 0x73, 0x73, 0x69, 0x6f, 0x6e, 0x54, 0x69, 0x6d, 0x65, 0x12, 0x21, 0x0a, 0x0c, 0x73,
	0x74, 0x61, 0x72, 0x74, 0x75, 0x70, 0x5f, 0x63, 0x6f, 0x73, 0x74, 0x18, 0x2b, 0x20, 0x01, 0x28,
	0x03, 0x52, 0x0b, 0x73, 0x74, 0x61, 0x72, 0x74, 0x75, 0x70, 0x43, 0x6f, 0x73, 0x74, 0x12, 0x1d,
	0x0a, 0x0a, 0x74, 0x6f, 0x74, 0x61, 0x6c, 0x5f, 0x63, 0x6f, 0x73, 0x74, 0x18, 0x2c, 0x20, 0x01,
	0x28, 0x03, 0x52, 0x09, 0x74, 0x6f, 0x74, 0x61, 0x6c, 0x43, 0x6f, 0x73, 0x74, 0x12, 0x1b, 0x0a,
	0x09, 0x70, 0x6c, 0x61, 0x6e, 0x5f, 0x72, 0x6f, 0x77, 0x73, 0x18, 0x2d, 0x20, 0x01, 0x28, 0x03,
	0x52, 0x08, 0x70, 0x6c, 0x61, 0x6e, 0x52, 0x6f, 0x77, 0x73, 0x12, 0x1d, 0x0a, 0x0a, 0x70, 0x6c,
	0x61, 0x6e, 0x5f, 0x77, 0x69, 0x64, 0x74, 0x68, 0x18, 0x2e, 0x20, 0x01, 0x28, 0x03, 0x52, 0x09,
	0x70, 0x6c, 0x61, 0x6e, 0x57, 0x69, 0x64, 0x74, 0x68, 0x12, 0x14, 0x0a, 0x05, 0x72, 0x65, 0x61,
	0x64, 0x73, 0x18, 0x2f, 0x20, 0x01, 0x28, 0x03, 0x52, 0x05, 0x72, 0x65, 0x61, 0x64, 0x73, 0x12,
	0x16, 0x0a, 0x06, 0x77, 0x72, 0x69, 0x74, 0x65, 0x73, 0x18, 0x30, 0x20, 0x01, 0x28, 0x03, 0x52,
	0x06, 0x77, 0x72, 0x69, 0x74, 0x65, 0x73, 0x12, 0x1b, 0x0a, 0x09, 0x75, 0x73, 0x65, 0x72, 0x5f,
	0x74, 0x69, 0x6d, 0x65, 0x18, 0x31, 0x20, 0x01, 0x28, 0x01, 0x52, 0x08, 0x75, 0x73, 0x65, 0x72,
	0x54, 0x69, 0x6d, 0x65, 0x12, 0x1f, 0x0a, 0x0b, 0x73, 0x79, 0x73, 0x74, 0x65, 0x6d, 0x5f, 0x74,
	0x69, 0x6d, 0x65, 0x18, 0x32, 0x20, 0x01, 0x28, 0x01, 0x52, 0x0a, 0x73, 0x79, 0x73, 0x74, 0x65,
	0x6d, 0x54, 0x69, 0x6d, 0x65, 0x22, 0x90, 0x01, 0x0a, 0x0e, 0x51, 0x75, 0x65, 0x72, 0x79, 0x53,
	0x74, 0x61, 0x74, 0x65, 0x6d, 0x65, 0x6e, 0x74, 0x12, 0x3c, 0x0a, 0x03, 0x6b, 0x65, 0x79, 0x18,
	0x01, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x2a, 0x2e, 0x79, 0x61, 0x6e, 0x64, 0x65, 0x78, 0x2e, 0x63,
	0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x6d, 0x64, 0x62, 0x2e, 0x70, 0x6f, 0x73, 0x74, 0x67, 0x72, 0x65,
	0x73, 0x71, 0x6c, 0x2e, 0x76, 0x31, 0x2e, 0x50, 0x72, 0x69, 0x6d, 0x61, 0x72, 0x79, 0x4b, 0x65,
	0x79, 0x52, 0x03, 0x6b, 0x65, 0x79, 0x12, 0x40, 0x0a, 0x05, 0x73, 0x74, 0x61, 0x74, 0x73, 0x18,
	0x02, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x2a, 0x2e, 0x79, 0x61, 0x6e, 0x64, 0x65, 0x78, 0x2e, 0x63,
	0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x6d, 0x64, 0x62, 0x2e, 0x70, 0x6f, 0x73, 0x74, 0x67, 0x72, 0x65,
	0x73, 0x71, 0x6c, 0x2e, 0x76, 0x31, 0x2e, 0x51, 0x75, 0x65, 0x72, 0x79, 0x53, 0x74, 0x61, 0x74,
	0x73, 0x52, 0x05, 0x73, 0x74, 0x61, 0x74, 0x73, 0x42, 0x73, 0x0a, 0x22, 0x79, 0x61, 0x6e, 0x64,
	0x65, 0x78, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x61, 0x70, 0x69, 0x2e, 0x6d, 0x64, 0x62,
	0x2e, 0x70, 0x6f, 0x73, 0x74, 0x67, 0x72, 0x65, 0x73, 0x71, 0x6c, 0x2e, 0x76, 0x31, 0x5a, 0x4d,
	0x67, 0x69, 0x74, 0x68, 0x75, 0x62, 0x2e, 0x63, 0x6f, 0x6d, 0x2f, 0x79, 0x61, 0x6e, 0x64, 0x65,
	0x78, 0x2d, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2f, 0x67, 0x6f, 0x2d, 0x67, 0x65, 0x6e, 0x70, 0x72,
	0x6f, 0x74, 0x6f, 0x2f, 0x79, 0x61, 0x6e, 0x64, 0x65, 0x78, 0x2f, 0x63, 0x6c, 0x6f, 0x75, 0x64,
	0x2f, 0x6d, 0x64, 0x62, 0x2f, 0x70, 0x6f, 0x73, 0x74, 0x67, 0x72, 0x65, 0x73, 0x71, 0x6c, 0x2f,
	0x76, 0x31, 0x3b, 0x70, 0x6f, 0x73, 0x74, 0x67, 0x72, 0x65, 0x73, 0x71, 0x6c, 0x62, 0x06, 0x70,
	0x72, 0x6f, 0x74, 0x6f, 0x33,
}

var (
	file_yandex_cloud_mdb_postgresql_v1_perf_diag_proto_rawDescOnce sync.Once
	file_yandex_cloud_mdb_postgresql_v1_perf_diag_proto_rawDescData = file_yandex_cloud_mdb_postgresql_v1_perf_diag_proto_rawDesc
)

func file_yandex_cloud_mdb_postgresql_v1_perf_diag_proto_rawDescGZIP() []byte {
	file_yandex_cloud_mdb_postgresql_v1_perf_diag_proto_rawDescOnce.Do(func() {
		file_yandex_cloud_mdb_postgresql_v1_perf_diag_proto_rawDescData = protoimpl.X.CompressGZIP(file_yandex_cloud_mdb_postgresql_v1_perf_diag_proto_rawDescData)
	})
	return file_yandex_cloud_mdb_postgresql_v1_perf_diag_proto_rawDescData
}

var file_yandex_cloud_mdb_postgresql_v1_perf_diag_proto_msgTypes = make([]protoimpl.MessageInfo, 4)
var file_yandex_cloud_mdb_postgresql_v1_perf_diag_proto_goTypes = []interface{}{
	(*SessionState)(nil),          // 0: yandex.cloud.mdb.postgresql.v1.SessionState
	(*PrimaryKey)(nil),            // 1: yandex.cloud.mdb.postgresql.v1.PrimaryKey
	(*QueryStats)(nil),            // 2: yandex.cloud.mdb.postgresql.v1.QueryStats
	(*QueryStatement)(nil),        // 3: yandex.cloud.mdb.postgresql.v1.QueryStatement
	(*timestamppb.Timestamp)(nil), // 4: google.protobuf.Timestamp
}
var file_yandex_cloud_mdb_postgresql_v1_perf_diag_proto_depIdxs = []int32{
	4, // 0: yandex.cloud.mdb.postgresql.v1.SessionState.time:type_name -> google.protobuf.Timestamp
	4, // 1: yandex.cloud.mdb.postgresql.v1.SessionState.backend_start:type_name -> google.protobuf.Timestamp
	4, // 2: yandex.cloud.mdb.postgresql.v1.SessionState.xact_start:type_name -> google.protobuf.Timestamp
	4, // 3: yandex.cloud.mdb.postgresql.v1.SessionState.query_start:type_name -> google.protobuf.Timestamp
	4, // 4: yandex.cloud.mdb.postgresql.v1.SessionState.state_change:type_name -> google.protobuf.Timestamp
	4, // 5: yandex.cloud.mdb.postgresql.v1.QueryStats.time:type_name -> google.protobuf.Timestamp
	1, // 6: yandex.cloud.mdb.postgresql.v1.QueryStatement.key:type_name -> yandex.cloud.mdb.postgresql.v1.PrimaryKey
	2, // 7: yandex.cloud.mdb.postgresql.v1.QueryStatement.stats:type_name -> yandex.cloud.mdb.postgresql.v1.QueryStats
	8, // [8:8] is the sub-list for method output_type
	8, // [8:8] is the sub-list for method input_type
	8, // [8:8] is the sub-list for extension type_name
	8, // [8:8] is the sub-list for extension extendee
	0, // [0:8] is the sub-list for field type_name
}

func init() { file_yandex_cloud_mdb_postgresql_v1_perf_diag_proto_init() }
func file_yandex_cloud_mdb_postgresql_v1_perf_diag_proto_init() {
	if File_yandex_cloud_mdb_postgresql_v1_perf_diag_proto != nil {
		return
	}
	if !protoimpl.UnsafeEnabled {
		file_yandex_cloud_mdb_postgresql_v1_perf_diag_proto_msgTypes[0].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*SessionState); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_yandex_cloud_mdb_postgresql_v1_perf_diag_proto_msgTypes[1].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*PrimaryKey); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_yandex_cloud_mdb_postgresql_v1_perf_diag_proto_msgTypes[2].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*QueryStats); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_yandex_cloud_mdb_postgresql_v1_perf_diag_proto_msgTypes[3].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*QueryStatement); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
	}
	type x struct{}
	out := protoimpl.TypeBuilder{
		File: protoimpl.DescBuilder{
			GoPackagePath: reflect.TypeOf(x{}).PkgPath(),
			RawDescriptor: file_yandex_cloud_mdb_postgresql_v1_perf_diag_proto_rawDesc,
			NumEnums:      0,
			NumMessages:   4,
			NumExtensions: 0,
			NumServices:   0,
		},
		GoTypes:           file_yandex_cloud_mdb_postgresql_v1_perf_diag_proto_goTypes,
		DependencyIndexes: file_yandex_cloud_mdb_postgresql_v1_perf_diag_proto_depIdxs,
		MessageInfos:      file_yandex_cloud_mdb_postgresql_v1_perf_diag_proto_msgTypes,
	}.Build()
	File_yandex_cloud_mdb_postgresql_v1_perf_diag_proto = out.File
	file_yandex_cloud_mdb_postgresql_v1_perf_diag_proto_rawDesc = nil
	file_yandex_cloud_mdb_postgresql_v1_perf_diag_proto_goTypes = nil
	file_yandex_cloud_mdb_postgresql_v1_perf_diag_proto_depIdxs = nil
}
