// Code generated by protoc-gen-go. DO NOT EDIT.
// versions:
// 	protoc-gen-go v1.29.0
// 	protoc        v3.17.3
// source: yandex/cloud/storage/v1/bucket_service.proto

package storage

import (
	_ "github.com/yandex-cloud/go-genproto/yandex/cloud"
	_ "github.com/yandex-cloud/go-genproto/yandex/cloud/api"
	operation "github.com/yandex-cloud/go-genproto/yandex/cloud/operation"
	_ "google.golang.org/genproto/googleapis/api/annotations"
	protoreflect "google.golang.org/protobuf/reflect/protoreflect"
	protoimpl "google.golang.org/protobuf/runtime/protoimpl"
	fieldmaskpb "google.golang.org/protobuf/types/known/fieldmaskpb"
	structpb "google.golang.org/protobuf/types/known/structpb"
	reflect "reflect"
	sync "sync"
)

const (
	// Verify that this generated code is sufficiently up-to-date.
	_ = protoimpl.EnforceVersion(20 - protoimpl.MinVersion)
	// Verify that runtime/protoimpl is sufficiently up-to-date.
	_ = protoimpl.EnforceVersion(protoimpl.MaxVersion - 20)
)

type GetBucketRequest_View int32

const (
	GetBucketRequest_VIEW_UNSPECIFIED GetBucketRequest_View = 0
	// Returns basic information about a bucket.
	//
	// The following fields will _not_ be returned: [Bucket.acl], [Bucket.cors], [Bucket.website_settings],
	// [Bucket.lifecycle_rules], [Bucket.tags].
	GetBucketRequest_VIEW_BASIC GetBucketRequest_View = 1
	// Returns basic information and access control list (ACL) for the bucket.
	//
	// The following fields will _not_ be returned: [Bucket.cors], [Bucket.website_settings], [Bucket.lifecycle_rules],
	// [Bucket.tags].
	GetBucketRequest_VIEW_ACL GetBucketRequest_View = 2
	// Returns full information about a bucket.
	GetBucketRequest_VIEW_FULL GetBucketRequest_View = 3
)

// Enum value maps for GetBucketRequest_View.
var (
	GetBucketRequest_View_name = map[int32]string{
		0: "VIEW_UNSPECIFIED",
		1: "VIEW_BASIC",
		2: "VIEW_ACL",
		3: "VIEW_FULL",
	}
	GetBucketRequest_View_value = map[string]int32{
		"VIEW_UNSPECIFIED": 0,
		"VIEW_BASIC":       1,
		"VIEW_ACL":         2,
		"VIEW_FULL":        3,
	}
)

func (x GetBucketRequest_View) Enum() *GetBucketRequest_View {
	p := new(GetBucketRequest_View)
	*p = x
	return p
}

func (x GetBucketRequest_View) String() string {
	return protoimpl.X.EnumStringOf(x.Descriptor(), protoreflect.EnumNumber(x))
}

func (GetBucketRequest_View) Descriptor() protoreflect.EnumDescriptor {
	return file_yandex_cloud_storage_v1_bucket_service_proto_enumTypes[0].Descriptor()
}

func (GetBucketRequest_View) Type() protoreflect.EnumType {
	return &file_yandex_cloud_storage_v1_bucket_service_proto_enumTypes[0]
}

func (x GetBucketRequest_View) Number() protoreflect.EnumNumber {
	return protoreflect.EnumNumber(x)
}

// Deprecated: Use GetBucketRequest_View.Descriptor instead.
func (GetBucketRequest_View) EnumDescriptor() ([]byte, []int) {
	return file_yandex_cloud_storage_v1_bucket_service_proto_rawDescGZIP(), []int{0, 0}
}

type GetBucketRequest struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Name of the bucket to return.
	//
	// To get the bucket name, make a [BucketService.List] request.
	Name string `protobuf:"bytes,1,opt,name=name,proto3" json:"name,omitempty"`
	// Scope of information about the bucket to return.
	//
	// Access to scopes is managed via [Identity and Access Management roles](/docs/storage/security),
	// bucket [ACL](/docs/storage/concepts/acl) and [policies](/docs/storage/concepts/policy).
	View GetBucketRequest_View `protobuf:"varint,2,opt,name=view,proto3,enum=yandex.cloud.storage.v1.GetBucketRequest_View" json:"view,omitempty"`
}

func (x *GetBucketRequest) Reset() {
	*x = GetBucketRequest{}
	if protoimpl.UnsafeEnabled {
		mi := &file_yandex_cloud_storage_v1_bucket_service_proto_msgTypes[0]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *GetBucketRequest) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*GetBucketRequest) ProtoMessage() {}

func (x *GetBucketRequest) ProtoReflect() protoreflect.Message {
	mi := &file_yandex_cloud_storage_v1_bucket_service_proto_msgTypes[0]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use GetBucketRequest.ProtoReflect.Descriptor instead.
func (*GetBucketRequest) Descriptor() ([]byte, []int) {
	return file_yandex_cloud_storage_v1_bucket_service_proto_rawDescGZIP(), []int{0}
}

func (x *GetBucketRequest) GetName() string {
	if x != nil {
		return x.Name
	}
	return ""
}

func (x *GetBucketRequest) GetView() GetBucketRequest_View {
	if x != nil {
		return x.View
	}
	return GetBucketRequest_VIEW_UNSPECIFIED
}

type ListBucketsRequest struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// ID of the folder to list buckets in.
	//
	// To get the folder ID, make a [yandex.cloud.resourcemanager.v1.FolderService.List] request.
	FolderId string `protobuf:"bytes,1,opt,name=folder_id,json=folderId,proto3" json:"folder_id,omitempty"`
}

func (x *ListBucketsRequest) Reset() {
	*x = ListBucketsRequest{}
	if protoimpl.UnsafeEnabled {
		mi := &file_yandex_cloud_storage_v1_bucket_service_proto_msgTypes[1]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *ListBucketsRequest) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*ListBucketsRequest) ProtoMessage() {}

func (x *ListBucketsRequest) ProtoReflect() protoreflect.Message {
	mi := &file_yandex_cloud_storage_v1_bucket_service_proto_msgTypes[1]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use ListBucketsRequest.ProtoReflect.Descriptor instead.
func (*ListBucketsRequest) Descriptor() ([]byte, []int) {
	return file_yandex_cloud_storage_v1_bucket_service_proto_rawDescGZIP(), []int{1}
}

func (x *ListBucketsRequest) GetFolderId() string {
	if x != nil {
		return x.FolderId
	}
	return ""
}

type ListBucketsResponse struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// List of buckets in the specified folder.
	Buckets []*Bucket `protobuf:"bytes,1,rep,name=buckets,proto3" json:"buckets,omitempty"`
}

func (x *ListBucketsResponse) Reset() {
	*x = ListBucketsResponse{}
	if protoimpl.UnsafeEnabled {
		mi := &file_yandex_cloud_storage_v1_bucket_service_proto_msgTypes[2]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *ListBucketsResponse) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*ListBucketsResponse) ProtoMessage() {}

func (x *ListBucketsResponse) ProtoReflect() protoreflect.Message {
	mi := &file_yandex_cloud_storage_v1_bucket_service_proto_msgTypes[2]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use ListBucketsResponse.ProtoReflect.Descriptor instead.
func (*ListBucketsResponse) Descriptor() ([]byte, []int) {
	return file_yandex_cloud_storage_v1_bucket_service_proto_rawDescGZIP(), []int{2}
}

func (x *ListBucketsResponse) GetBuckets() []*Bucket {
	if x != nil {
		return x.Buckets
	}
	return nil
}

type CreateBucketRequest struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Name of the bucket.
	//
	// The name must be unique within the platform. For naming limitations and rules, see
	// [documentation](/docs/storage/concepts/bucket#naming).
	Name string `protobuf:"bytes,1,opt,name=name,proto3" json:"name,omitempty"`
	// ID of the folder to create a bucket in.
	//
	// To get the folder ID, make a [yandex.cloud.resourcemanager.v1.FolderService.List] request.
	FolderId string `protobuf:"bytes,2,opt,name=folder_id,json=folderId,proto3" json:"folder_id,omitempty"`
	// Default storage class for objects in the bucket. Supported classes are standard storage (`STANDARD`), cold storage
	// (`COLD`, `STANDARD_IA`, `NEARLINE` all synonyms), and ice storage (`ICE` and `GLACIER` are synonyms).
	// For details, see [documentation](/docs/storage/concepts/storage-class).
	DefaultStorageClass string `protobuf:"bytes,4,opt,name=default_storage_class,json=defaultStorageClass,proto3" json:"default_storage_class,omitempty"`
	// Maximum size of the bucket.
	// For details, see [documentation](/docs/storage/operations/buckets/limit-max-volume).
	MaxSize int64 `protobuf:"varint,5,opt,name=max_size,json=maxSize,proto3" json:"max_size,omitempty"`
	// Flags for configuring public (anonymous) access to the bucket's content and settings.
	// For details, see [documentation](/docs/storage/concepts/bucket#bucket-access).
	AnonymousAccessFlags *AnonymousAccessFlags `protobuf:"bytes,6,opt,name=anonymous_access_flags,json=anonymousAccessFlags,proto3" json:"anonymous_access_flags,omitempty"`
	// Access control list (ACL) of the bucket.
	// For details, see [documentation](/docs/storage/concepts/acl).
	Acl *ACL `protobuf:"bytes,7,opt,name=acl,proto3" json:"acl,omitempty"`
	// List of tags for the bucket.
	// For details, see [documentation](/docs/resource-manager/concepts/labels).
	Tags []*Tag `protobuf:"bytes,8,rep,name=tags,proto3" json:"tags,omitempty"`
}

func (x *CreateBucketRequest) Reset() {
	*x = CreateBucketRequest{}
	if protoimpl.UnsafeEnabled {
		mi := &file_yandex_cloud_storage_v1_bucket_service_proto_msgTypes[3]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *CreateBucketRequest) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*CreateBucketRequest) ProtoMessage() {}

func (x *CreateBucketRequest) ProtoReflect() protoreflect.Message {
	mi := &file_yandex_cloud_storage_v1_bucket_service_proto_msgTypes[3]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use CreateBucketRequest.ProtoReflect.Descriptor instead.
func (*CreateBucketRequest) Descriptor() ([]byte, []int) {
	return file_yandex_cloud_storage_v1_bucket_service_proto_rawDescGZIP(), []int{3}
}

func (x *CreateBucketRequest) GetName() string {
	if x != nil {
		return x.Name
	}
	return ""
}

func (x *CreateBucketRequest) GetFolderId() string {
	if x != nil {
		return x.FolderId
	}
	return ""
}

func (x *CreateBucketRequest) GetDefaultStorageClass() string {
	if x != nil {
		return x.DefaultStorageClass
	}
	return ""
}

func (x *CreateBucketRequest) GetMaxSize() int64 {
	if x != nil {
		return x.MaxSize
	}
	return 0
}

func (x *CreateBucketRequest) GetAnonymousAccessFlags() *AnonymousAccessFlags {
	if x != nil {
		return x.AnonymousAccessFlags
	}
	return nil
}

func (x *CreateBucketRequest) GetAcl() *ACL {
	if x != nil {
		return x.Acl
	}
	return nil
}

func (x *CreateBucketRequest) GetTags() []*Tag {
	if x != nil {
		return x.Tags
	}
	return nil
}

type CreateBucketMetadata struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Name of the bucket that is being created.
	Name string `protobuf:"bytes,1,opt,name=name,proto3" json:"name,omitempty"`
}

func (x *CreateBucketMetadata) Reset() {
	*x = CreateBucketMetadata{}
	if protoimpl.UnsafeEnabled {
		mi := &file_yandex_cloud_storage_v1_bucket_service_proto_msgTypes[4]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *CreateBucketMetadata) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*CreateBucketMetadata) ProtoMessage() {}

func (x *CreateBucketMetadata) ProtoReflect() protoreflect.Message {
	mi := &file_yandex_cloud_storage_v1_bucket_service_proto_msgTypes[4]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use CreateBucketMetadata.ProtoReflect.Descriptor instead.
func (*CreateBucketMetadata) Descriptor() ([]byte, []int) {
	return file_yandex_cloud_storage_v1_bucket_service_proto_rawDescGZIP(), []int{4}
}

func (x *CreateBucketMetadata) GetName() string {
	if x != nil {
		return x.Name
	}
	return ""
}

type UpdateBucketRequest struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Name of the bucket to update.
	//
	// The name cannot be updated.
	//
	// To get the bucket name, make a [BucketService.List] request.
	Name string `protobuf:"bytes,1,opt,name=name,proto3" json:"name,omitempty"`
	// Update mask that specifies which attributes of the bucket should be updated.
	// Use * for full update.
	UpdateMask *fieldmaskpb.FieldMask `protobuf:"bytes,2,opt,name=update_mask,json=updateMask,proto3" json:"update_mask,omitempty"`
	// Flags for configuring public (anonymous) access to the bucket's content and settings.
	// For details, see [documentation](/docs/storage/concepts/bucket#bucket-access).
	AnonymousAccessFlags *AnonymousAccessFlags `protobuf:"bytes,3,opt,name=anonymous_access_flags,json=anonymousAccessFlags,proto3" json:"anonymous_access_flags,omitempty"`
	// Default storage class for objects in the bucket. Supported classes are standard storage (`STANDARD`), cold storage
	// (`COLD`, `STANDARD_IA`, `NEARLINE` all synonyms), and ice storage (`ICE` and `GLACIER` are synonyms).
	// For details, see [documentation](/docs/storage/concepts/storage-class).
	DefaultStorageClass string `protobuf:"bytes,4,opt,name=default_storage_class,json=defaultStorageClass,proto3" json:"default_storage_class,omitempty"`
	// Maximum size of the bucket, in bytes.
	// For details, see [documentation](/docs/storage/operations/buckets/limit-max-volume).
	MaxSize int64 `protobuf:"varint,5,opt,name=max_size,json=maxSize,proto3" json:"max_size,omitempty"`
	// List of rules for cross-domain requests to objects in the bucket (cross-origin resource sharing, CORS).
	// For details, see [documentation](/docs/storage/concepts/cors).
	Cors []*CorsRule `protobuf:"bytes,6,rep,name=cors,proto3" json:"cors,omitempty"`
	// Configuration for hosting a static website in the bucket.
	// For details, see [documentation](/docs/storage/concepts/hosting).
	WebsiteSettings *WebsiteSettings `protobuf:"bytes,7,opt,name=website_settings,json=websiteSettings,proto3" json:"website_settings,omitempty"`
	// Bucket versioning status.
	// For details, see [documentation](/docs/storage/concepts/versioning).
	Versioning Versioning `protobuf:"varint,8,opt,name=versioning,proto3,enum=yandex.cloud.storage.v1.Versioning" json:"versioning,omitempty"`
	// List of object lifecycle rules for the bucket.
	// For details, see [documentation](/docs/storage/concepts/lifecycles).
	LifecycleRules []*LifecycleRule `protobuf:"bytes,9,rep,name=lifecycle_rules,json=lifecycleRules,proto3" json:"lifecycle_rules,omitempty"`
	// Bucket policies that set permissions for actions with the bucket, its objects, and groups of objects.
	// For details, see [documentation](/docs/storage/concepts/policy).
	Policy *structpb.Struct `protobuf:"bytes,10,opt,name=policy,proto3" json:"policy,omitempty"`
	// Access control list (ACL) of the bucket.
	// For details, see [documentation](/docs/storage/concepts/acl).
	Acl *ACL `protobuf:"bytes,11,opt,name=acl,proto3" json:"acl,omitempty"`
	// List of tags for the bucket.
	// For details, see [documentation](/docs/resource-manager/concepts/labels).
	Tags []*Tag `protobuf:"bytes,12,rep,name=tags,proto3" json:"tags,omitempty"`
	// Configuration for object lock on the bucket.
	// For details about the concept, see [documentation](/docs/storage/concepts/object-lock).
	ObjectLock *ObjectLock `protobuf:"bytes,13,opt,name=object_lock,json=objectLock,proto3" json:"object_lock,omitempty"`
	// Configuration for bucket's encryption
	// For detauls, see [documentation](/docs/storage/concepts/encryption)
	Encryption *Encryption `protobuf:"bytes,14,opt,name=encryption,proto3" json:"encryption,omitempty"`
}

func (x *UpdateBucketRequest) Reset() {
	*x = UpdateBucketRequest{}
	if protoimpl.UnsafeEnabled {
		mi := &file_yandex_cloud_storage_v1_bucket_service_proto_msgTypes[5]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *UpdateBucketRequest) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*UpdateBucketRequest) ProtoMessage() {}

func (x *UpdateBucketRequest) ProtoReflect() protoreflect.Message {
	mi := &file_yandex_cloud_storage_v1_bucket_service_proto_msgTypes[5]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use UpdateBucketRequest.ProtoReflect.Descriptor instead.
func (*UpdateBucketRequest) Descriptor() ([]byte, []int) {
	return file_yandex_cloud_storage_v1_bucket_service_proto_rawDescGZIP(), []int{5}
}

func (x *UpdateBucketRequest) GetName() string {
	if x != nil {
		return x.Name
	}
	return ""
}

func (x *UpdateBucketRequest) GetUpdateMask() *fieldmaskpb.FieldMask {
	if x != nil {
		return x.UpdateMask
	}
	return nil
}

func (x *UpdateBucketRequest) GetAnonymousAccessFlags() *AnonymousAccessFlags {
	if x != nil {
		return x.AnonymousAccessFlags
	}
	return nil
}

func (x *UpdateBucketRequest) GetDefaultStorageClass() string {
	if x != nil {
		return x.DefaultStorageClass
	}
	return ""
}

func (x *UpdateBucketRequest) GetMaxSize() int64 {
	if x != nil {
		return x.MaxSize
	}
	return 0
}

func (x *UpdateBucketRequest) GetCors() []*CorsRule {
	if x != nil {
		return x.Cors
	}
	return nil
}

func (x *UpdateBucketRequest) GetWebsiteSettings() *WebsiteSettings {
	if x != nil {
		return x.WebsiteSettings
	}
	return nil
}

func (x *UpdateBucketRequest) GetVersioning() Versioning {
	if x != nil {
		return x.Versioning
	}
	return Versioning_VERSIONING_UNSPECIFIED
}

func (x *UpdateBucketRequest) GetLifecycleRules() []*LifecycleRule {
	if x != nil {
		return x.LifecycleRules
	}
	return nil
}

func (x *UpdateBucketRequest) GetPolicy() *structpb.Struct {
	if x != nil {
		return x.Policy
	}
	return nil
}

func (x *UpdateBucketRequest) GetAcl() *ACL {
	if x != nil {
		return x.Acl
	}
	return nil
}

func (x *UpdateBucketRequest) GetTags() []*Tag {
	if x != nil {
		return x.Tags
	}
	return nil
}

func (x *UpdateBucketRequest) GetObjectLock() *ObjectLock {
	if x != nil {
		return x.ObjectLock
	}
	return nil
}

func (x *UpdateBucketRequest) GetEncryption() *Encryption {
	if x != nil {
		return x.Encryption
	}
	return nil
}

type UpdateBucketMetadata struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Name of the bucket that is being updated.
	Name string `protobuf:"bytes,1,opt,name=name,proto3" json:"name,omitempty"`
}

func (x *UpdateBucketMetadata) Reset() {
	*x = UpdateBucketMetadata{}
	if protoimpl.UnsafeEnabled {
		mi := &file_yandex_cloud_storage_v1_bucket_service_proto_msgTypes[6]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *UpdateBucketMetadata) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*UpdateBucketMetadata) ProtoMessage() {}

func (x *UpdateBucketMetadata) ProtoReflect() protoreflect.Message {
	mi := &file_yandex_cloud_storage_v1_bucket_service_proto_msgTypes[6]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use UpdateBucketMetadata.ProtoReflect.Descriptor instead.
func (*UpdateBucketMetadata) Descriptor() ([]byte, []int) {
	return file_yandex_cloud_storage_v1_bucket_service_proto_rawDescGZIP(), []int{6}
}

func (x *UpdateBucketMetadata) GetName() string {
	if x != nil {
		return x.Name
	}
	return ""
}

// DeleteBucketRequest deletes requested bucket from the Cloud.
type DeleteBucketRequest struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Name of the bucket to update.
	//
	// To get the bucket name, make a [BucketService.List] request.
	Name string `protobuf:"bytes,1,opt,name=name,proto3" json:"name,omitempty"`
}

func (x *DeleteBucketRequest) Reset() {
	*x = DeleteBucketRequest{}
	if protoimpl.UnsafeEnabled {
		mi := &file_yandex_cloud_storage_v1_bucket_service_proto_msgTypes[7]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *DeleteBucketRequest) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*DeleteBucketRequest) ProtoMessage() {}

func (x *DeleteBucketRequest) ProtoReflect() protoreflect.Message {
	mi := &file_yandex_cloud_storage_v1_bucket_service_proto_msgTypes[7]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use DeleteBucketRequest.ProtoReflect.Descriptor instead.
func (*DeleteBucketRequest) Descriptor() ([]byte, []int) {
	return file_yandex_cloud_storage_v1_bucket_service_proto_rawDescGZIP(), []int{7}
}

func (x *DeleteBucketRequest) GetName() string {
	if x != nil {
		return x.Name
	}
	return ""
}

type DeleteBucketMetadata struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Name of the bucket that is being deleted.
	Name string `protobuf:"bytes,1,opt,name=name,proto3" json:"name,omitempty"`
}

func (x *DeleteBucketMetadata) Reset() {
	*x = DeleteBucketMetadata{}
	if protoimpl.UnsafeEnabled {
		mi := &file_yandex_cloud_storage_v1_bucket_service_proto_msgTypes[8]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *DeleteBucketMetadata) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*DeleteBucketMetadata) ProtoMessage() {}

func (x *DeleteBucketMetadata) ProtoReflect() protoreflect.Message {
	mi := &file_yandex_cloud_storage_v1_bucket_service_proto_msgTypes[8]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use DeleteBucketMetadata.ProtoReflect.Descriptor instead.
func (*DeleteBucketMetadata) Descriptor() ([]byte, []int) {
	return file_yandex_cloud_storage_v1_bucket_service_proto_rawDescGZIP(), []int{8}
}

func (x *DeleteBucketMetadata) GetName() string {
	if x != nil {
		return x.Name
	}
	return ""
}

type GetBucketStatsRequest struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Name of the bucket to return the statistics for.
	Name string `protobuf:"bytes,1,opt,name=name,proto3" json:"name,omitempty"`
}

func (x *GetBucketStatsRequest) Reset() {
	*x = GetBucketStatsRequest{}
	if protoimpl.UnsafeEnabled {
		mi := &file_yandex_cloud_storage_v1_bucket_service_proto_msgTypes[9]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *GetBucketStatsRequest) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*GetBucketStatsRequest) ProtoMessage() {}

func (x *GetBucketStatsRequest) ProtoReflect() protoreflect.Message {
	mi := &file_yandex_cloud_storage_v1_bucket_service_proto_msgTypes[9]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use GetBucketStatsRequest.ProtoReflect.Descriptor instead.
func (*GetBucketStatsRequest) Descriptor() ([]byte, []int) {
	return file_yandex_cloud_storage_v1_bucket_service_proto_rawDescGZIP(), []int{9}
}

func (x *GetBucketStatsRequest) GetName() string {
	if x != nil {
		return x.Name
	}
	return ""
}

type GetBucketHTTPSConfigRequest struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Name of the bucket to return the HTTPS configuration for.
	Name string `protobuf:"bytes,1,opt,name=name,proto3" json:"name,omitempty"`
}

func (x *GetBucketHTTPSConfigRequest) Reset() {
	*x = GetBucketHTTPSConfigRequest{}
	if protoimpl.UnsafeEnabled {
		mi := &file_yandex_cloud_storage_v1_bucket_service_proto_msgTypes[10]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *GetBucketHTTPSConfigRequest) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*GetBucketHTTPSConfigRequest) ProtoMessage() {}

func (x *GetBucketHTTPSConfigRequest) ProtoReflect() protoreflect.Message {
	mi := &file_yandex_cloud_storage_v1_bucket_service_proto_msgTypes[10]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use GetBucketHTTPSConfigRequest.ProtoReflect.Descriptor instead.
func (*GetBucketHTTPSConfigRequest) Descriptor() ([]byte, []int) {
	return file_yandex_cloud_storage_v1_bucket_service_proto_rawDescGZIP(), []int{10}
}

func (x *GetBucketHTTPSConfigRequest) GetName() string {
	if x != nil {
		return x.Name
	}
	return ""
}

type SelfManagedHTTPSConfigParams struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// [PEM](https://en.wikipedia.org/wiki/Privacy-Enhanced_Mail)-encoded certificate.
	CertificatePem string `protobuf:"bytes,1,opt,name=certificate_pem,json=certificatePem,proto3" json:"certificate_pem,omitempty"`
	// [PEM](https://en.wikipedia.org/wiki/Privacy-Enhanced_Mail)-encoded private key for the certificate.
	PrivateKeyPem string `protobuf:"bytes,2,opt,name=private_key_pem,json=privateKeyPem,proto3" json:"private_key_pem,omitempty"`
}

func (x *SelfManagedHTTPSConfigParams) Reset() {
	*x = SelfManagedHTTPSConfigParams{}
	if protoimpl.UnsafeEnabled {
		mi := &file_yandex_cloud_storage_v1_bucket_service_proto_msgTypes[11]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *SelfManagedHTTPSConfigParams) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*SelfManagedHTTPSConfigParams) ProtoMessage() {}

func (x *SelfManagedHTTPSConfigParams) ProtoReflect() protoreflect.Message {
	mi := &file_yandex_cloud_storage_v1_bucket_service_proto_msgTypes[11]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use SelfManagedHTTPSConfigParams.ProtoReflect.Descriptor instead.
func (*SelfManagedHTTPSConfigParams) Descriptor() ([]byte, []int) {
	return file_yandex_cloud_storage_v1_bucket_service_proto_rawDescGZIP(), []int{11}
}

func (x *SelfManagedHTTPSConfigParams) GetCertificatePem() string {
	if x != nil {
		return x.CertificatePem
	}
	return ""
}

func (x *SelfManagedHTTPSConfigParams) GetPrivateKeyPem() string {
	if x != nil {
		return x.PrivateKeyPem
	}
	return ""
}

// A resource for a TLS certificate from Certificate Manager.
type CertificateManagerHTTPSConfigParams struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// ID of the certificate.
	//
	// To get the list of all available certificates, make a [yandex.cloud.certificatemanager.v1.CertificateService.List]
	// request.
	CertificateId string `protobuf:"bytes,1,opt,name=certificate_id,json=certificateId,proto3" json:"certificate_id,omitempty"`
}

func (x *CertificateManagerHTTPSConfigParams) Reset() {
	*x = CertificateManagerHTTPSConfigParams{}
	if protoimpl.UnsafeEnabled {
		mi := &file_yandex_cloud_storage_v1_bucket_service_proto_msgTypes[12]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *CertificateManagerHTTPSConfigParams) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*CertificateManagerHTTPSConfigParams) ProtoMessage() {}

func (x *CertificateManagerHTTPSConfigParams) ProtoReflect() protoreflect.Message {
	mi := &file_yandex_cloud_storage_v1_bucket_service_proto_msgTypes[12]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use CertificateManagerHTTPSConfigParams.ProtoReflect.Descriptor instead.
func (*CertificateManagerHTTPSConfigParams) Descriptor() ([]byte, []int) {
	return file_yandex_cloud_storage_v1_bucket_service_proto_rawDescGZIP(), []int{12}
}

func (x *CertificateManagerHTTPSConfigParams) GetCertificateId() string {
	if x != nil {
		return x.CertificateId
	}
	return ""
}

type SetBucketHTTPSConfigRequest struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Name of the bucket to update the HTTPS configuration for.
	Name string `protobuf:"bytes,1,opt,name=name,proto3" json:"name,omitempty"`
	// HTTPS configuration parameters.
	//
	// Types that are assignable to Params:
	//
	//	*SetBucketHTTPSConfigRequest_SelfManaged
	//	*SetBucketHTTPSConfigRequest_CertificateManager
	Params isSetBucketHTTPSConfigRequest_Params `protobuf_oneof:"params"`
}

func (x *SetBucketHTTPSConfigRequest) Reset() {
	*x = SetBucketHTTPSConfigRequest{}
	if protoimpl.UnsafeEnabled {
		mi := &file_yandex_cloud_storage_v1_bucket_service_proto_msgTypes[13]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *SetBucketHTTPSConfigRequest) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*SetBucketHTTPSConfigRequest) ProtoMessage() {}

func (x *SetBucketHTTPSConfigRequest) ProtoReflect() protoreflect.Message {
	mi := &file_yandex_cloud_storage_v1_bucket_service_proto_msgTypes[13]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use SetBucketHTTPSConfigRequest.ProtoReflect.Descriptor instead.
func (*SetBucketHTTPSConfigRequest) Descriptor() ([]byte, []int) {
	return file_yandex_cloud_storage_v1_bucket_service_proto_rawDescGZIP(), []int{13}
}

func (x *SetBucketHTTPSConfigRequest) GetName() string {
	if x != nil {
		return x.Name
	}
	return ""
}

func (m *SetBucketHTTPSConfigRequest) GetParams() isSetBucketHTTPSConfigRequest_Params {
	if m != nil {
		return m.Params
	}
	return nil
}

func (x *SetBucketHTTPSConfigRequest) GetSelfManaged() *SelfManagedHTTPSConfigParams {
	if x, ok := x.GetParams().(*SetBucketHTTPSConfigRequest_SelfManaged); ok {
		return x.SelfManaged
	}
	return nil
}

func (x *SetBucketHTTPSConfigRequest) GetCertificateManager() *CertificateManagerHTTPSConfigParams {
	if x, ok := x.GetParams().(*SetBucketHTTPSConfigRequest_CertificateManager); ok {
		return x.CertificateManager
	}
	return nil
}

type isSetBucketHTTPSConfigRequest_Params interface {
	isSetBucketHTTPSConfigRequest_Params()
}

type SetBucketHTTPSConfigRequest_SelfManaged struct {
	// Your TLS certificate, uploaded directly.
	//
	// Object Storage only supports [PEM](https://en.wikipedia.org/wiki/Privacy-Enhanced_Mail)-encoded certificates.
	SelfManaged *SelfManagedHTTPSConfigParams `protobuf:"bytes,2,opt,name=self_managed,json=selfManaged,proto3,oneof"`
}

type SetBucketHTTPSConfigRequest_CertificateManager struct {
	// TLS certificate from Certificate Manager.
	//
	// To create a certificate in Certificate Manager, make a
	// [yandex.cloud.certificatemanager.v1.CertificateService.Create] request.
	CertificateManager *CertificateManagerHTTPSConfigParams `protobuf:"bytes,3,opt,name=certificate_manager,json=certificateManager,proto3,oneof"`
}

func (*SetBucketHTTPSConfigRequest_SelfManaged) isSetBucketHTTPSConfigRequest_Params() {}

func (*SetBucketHTTPSConfigRequest_CertificateManager) isSetBucketHTTPSConfigRequest_Params() {}

type SetBucketHTTPSConfigMetadata struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Name of the bucket the HTTPS configuration is being updated for.
	Name string `protobuf:"bytes,1,opt,name=name,proto3" json:"name,omitempty"`
}

func (x *SetBucketHTTPSConfigMetadata) Reset() {
	*x = SetBucketHTTPSConfigMetadata{}
	if protoimpl.UnsafeEnabled {
		mi := &file_yandex_cloud_storage_v1_bucket_service_proto_msgTypes[14]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *SetBucketHTTPSConfigMetadata) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*SetBucketHTTPSConfigMetadata) ProtoMessage() {}

func (x *SetBucketHTTPSConfigMetadata) ProtoReflect() protoreflect.Message {
	mi := &file_yandex_cloud_storage_v1_bucket_service_proto_msgTypes[14]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use SetBucketHTTPSConfigMetadata.ProtoReflect.Descriptor instead.
func (*SetBucketHTTPSConfigMetadata) Descriptor() ([]byte, []int) {
	return file_yandex_cloud_storage_v1_bucket_service_proto_rawDescGZIP(), []int{14}
}

func (x *SetBucketHTTPSConfigMetadata) GetName() string {
	if x != nil {
		return x.Name
	}
	return ""
}

type DeleteBucketHTTPSConfigRequest struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Name of the bucket to delete the HTTPS configuration for.
	Name string `protobuf:"bytes,1,opt,name=name,proto3" json:"name,omitempty"`
}

func (x *DeleteBucketHTTPSConfigRequest) Reset() {
	*x = DeleteBucketHTTPSConfigRequest{}
	if protoimpl.UnsafeEnabled {
		mi := &file_yandex_cloud_storage_v1_bucket_service_proto_msgTypes[15]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *DeleteBucketHTTPSConfigRequest) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*DeleteBucketHTTPSConfigRequest) ProtoMessage() {}

func (x *DeleteBucketHTTPSConfigRequest) ProtoReflect() protoreflect.Message {
	mi := &file_yandex_cloud_storage_v1_bucket_service_proto_msgTypes[15]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use DeleteBucketHTTPSConfigRequest.ProtoReflect.Descriptor instead.
func (*DeleteBucketHTTPSConfigRequest) Descriptor() ([]byte, []int) {
	return file_yandex_cloud_storage_v1_bucket_service_proto_rawDescGZIP(), []int{15}
}

func (x *DeleteBucketHTTPSConfigRequest) GetName() string {
	if x != nil {
		return x.Name
	}
	return ""
}

type DeleteBucketHTTPSConfigMetadata struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Name of the bucket the HTTPS configuration is being deleted for.
	Name string `protobuf:"bytes,1,opt,name=name,proto3" json:"name,omitempty"`
}

func (x *DeleteBucketHTTPSConfigMetadata) Reset() {
	*x = DeleteBucketHTTPSConfigMetadata{}
	if protoimpl.UnsafeEnabled {
		mi := &file_yandex_cloud_storage_v1_bucket_service_proto_msgTypes[16]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *DeleteBucketHTTPSConfigMetadata) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*DeleteBucketHTTPSConfigMetadata) ProtoMessage() {}

func (x *DeleteBucketHTTPSConfigMetadata) ProtoReflect() protoreflect.Message {
	mi := &file_yandex_cloud_storage_v1_bucket_service_proto_msgTypes[16]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use DeleteBucketHTTPSConfigMetadata.ProtoReflect.Descriptor instead.
func (*DeleteBucketHTTPSConfigMetadata) Descriptor() ([]byte, []int) {
	return file_yandex_cloud_storage_v1_bucket_service_proto_rawDescGZIP(), []int{16}
}

func (x *DeleteBucketHTTPSConfigMetadata) GetName() string {
	if x != nil {
		return x.Name
	}
	return ""
}

var File_yandex_cloud_storage_v1_bucket_service_proto protoreflect.FileDescriptor

var file_yandex_cloud_storage_v1_bucket_service_proto_rawDesc = []byte{
	0x0a, 0x2c, 0x79, 0x61, 0x6e, 0x64, 0x65, 0x78, 0x2f, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2f, 0x73,
	0x74, 0x6f, 0x72, 0x61, 0x67, 0x65, 0x2f, 0x76, 0x31, 0x2f, 0x62, 0x75, 0x63, 0x6b, 0x65, 0x74,
	0x5f, 0x73, 0x65, 0x72, 0x76, 0x69, 0x63, 0x65, 0x2e, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x12, 0x17,
	0x79, 0x61, 0x6e, 0x64, 0x65, 0x78, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x73, 0x74, 0x6f,
	0x72, 0x61, 0x67, 0x65, 0x2e, 0x76, 0x31, 0x1a, 0x1c, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2f,
	0x61, 0x70, 0x69, 0x2f, 0x61, 0x6e, 0x6e, 0x6f, 0x74, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x73, 0x2e,
	0x70, 0x72, 0x6f, 0x74, 0x6f, 0x1a, 0x20, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2f, 0x70, 0x72,
	0x6f, 0x74, 0x6f, 0x62, 0x75, 0x66, 0x2f, 0x66, 0x69, 0x65, 0x6c, 0x64, 0x5f, 0x6d, 0x61, 0x73,
	0x6b, 0x2e, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x1a, 0x1c, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2f,
	0x70, 0x72, 0x6f, 0x74, 0x6f, 0x62, 0x75, 0x66, 0x2f, 0x73, 0x74, 0x72, 0x75, 0x63, 0x74, 0x2e,
	0x70, 0x72, 0x6f, 0x74, 0x6f, 0x1a, 0x20, 0x79, 0x61, 0x6e, 0x64, 0x65, 0x78, 0x2f, 0x63, 0x6c,
	0x6f, 0x75, 0x64, 0x2f, 0x61, 0x70, 0x69, 0x2f, 0x6f, 0x70, 0x65, 0x72, 0x61, 0x74, 0x69, 0x6f,
	0x6e, 0x2e, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x1a, 0x26, 0x79, 0x61, 0x6e, 0x64, 0x65, 0x78, 0x2f,
	0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2f, 0x6f, 0x70, 0x65, 0x72, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x2f,
	0x6f, 0x70, 0x65, 0x72, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x2e, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x1a,
	0x24, 0x79, 0x61, 0x6e, 0x64, 0x65, 0x78, 0x2f, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2f, 0x73, 0x74,
	0x6f, 0x72, 0x61, 0x67, 0x65, 0x2f, 0x76, 0x31, 0x2f, 0x62, 0x75, 0x63, 0x6b, 0x65, 0x74, 0x2e,
	0x70, 0x72, 0x6f, 0x74, 0x6f, 0x1a, 0x1d, 0x79, 0x61, 0x6e, 0x64, 0x65, 0x78, 0x2f, 0x63, 0x6c,
	0x6f, 0x75, 0x64, 0x2f, 0x76, 0x61, 0x6c, 0x69, 0x64, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x2e, 0x70,
	0x72, 0x6f, 0x74, 0x6f, 0x22, 0xbb, 0x01, 0x0a, 0x10, 0x47, 0x65, 0x74, 0x42, 0x75, 0x63, 0x6b,
	0x65, 0x74, 0x52, 0x65, 0x71, 0x75, 0x65, 0x73, 0x74, 0x12, 0x18, 0x0a, 0x04, 0x6e, 0x61, 0x6d,
	0x65, 0x18, 0x01, 0x20, 0x01, 0x28, 0x09, 0x42, 0x04, 0xe8, 0xc7, 0x31, 0x01, 0x52, 0x04, 0x6e,
	0x61, 0x6d, 0x65, 0x12, 0x42, 0x0a, 0x04, 0x76, 0x69, 0x65, 0x77, 0x18, 0x02, 0x20, 0x01, 0x28,
	0x0e, 0x32, 0x2e, 0x2e, 0x79, 0x61, 0x6e, 0x64, 0x65, 0x78, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64,
	0x2e, 0x73, 0x74, 0x6f, 0x72, 0x61, 0x67, 0x65, 0x2e, 0x76, 0x31, 0x2e, 0x47, 0x65, 0x74, 0x42,
	0x75, 0x63, 0x6b, 0x65, 0x74, 0x52, 0x65, 0x71, 0x75, 0x65, 0x73, 0x74, 0x2e, 0x56, 0x69, 0x65,
	0x77, 0x52, 0x04, 0x76, 0x69, 0x65, 0x77, 0x22, 0x49, 0x0a, 0x04, 0x56, 0x69, 0x65, 0x77, 0x12,
	0x14, 0x0a, 0x10, 0x56, 0x49, 0x45, 0x57, 0x5f, 0x55, 0x4e, 0x53, 0x50, 0x45, 0x43, 0x49, 0x46,
	0x49, 0x45, 0x44, 0x10, 0x00, 0x12, 0x0e, 0x0a, 0x0a, 0x56, 0x49, 0x45, 0x57, 0x5f, 0x42, 0x41,
	0x53, 0x49, 0x43, 0x10, 0x01, 0x12, 0x0c, 0x0a, 0x08, 0x56, 0x49, 0x45, 0x57, 0x5f, 0x41, 0x43,
	0x4c, 0x10, 0x02, 0x12, 0x0d, 0x0a, 0x09, 0x56, 0x49, 0x45, 0x57, 0x5f, 0x46, 0x55, 0x4c, 0x4c,
	0x10, 0x03, 0x22, 0x3f, 0x0a, 0x12, 0x4c, 0x69, 0x73, 0x74, 0x42, 0x75, 0x63, 0x6b, 0x65, 0x74,
	0x73, 0x52, 0x65, 0x71, 0x75, 0x65, 0x73, 0x74, 0x12, 0x29, 0x0a, 0x09, 0x66, 0x6f, 0x6c, 0x64,
	0x65, 0x72, 0x5f, 0x69, 0x64, 0x18, 0x01, 0x20, 0x01, 0x28, 0x09, 0x42, 0x0c, 0xe8, 0xc7, 0x31,
	0x01, 0x8a, 0xc8, 0x31, 0x04, 0x3c, 0x3d, 0x35, 0x30, 0x52, 0x08, 0x66, 0x6f, 0x6c, 0x64, 0x65,
	0x72, 0x49, 0x64, 0x22, 0x50, 0x0a, 0x13, 0x4c, 0x69, 0x73, 0x74, 0x42, 0x75, 0x63, 0x6b, 0x65,
	0x74, 0x73, 0x52, 0x65, 0x73, 0x70, 0x6f, 0x6e, 0x73, 0x65, 0x12, 0x39, 0x0a, 0x07, 0x62, 0x75,
	0x63, 0x6b, 0x65, 0x74, 0x73, 0x18, 0x01, 0x20, 0x03, 0x28, 0x0b, 0x32, 0x1f, 0x2e, 0x79, 0x61,
	0x6e, 0x64, 0x65, 0x78, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x73, 0x74, 0x6f, 0x72, 0x61,
	0x67, 0x65, 0x2e, 0x76, 0x31, 0x2e, 0x42, 0x75, 0x63, 0x6b, 0x65, 0x74, 0x52, 0x07, 0x62, 0x75,
	0x63, 0x6b, 0x65, 0x74, 0x73, 0x22, 0xf0, 0x02, 0x0a, 0x13, 0x43, 0x72, 0x65, 0x61, 0x74, 0x65,
	0x42, 0x75, 0x63, 0x6b, 0x65, 0x74, 0x52, 0x65, 0x71, 0x75, 0x65, 0x73, 0x74, 0x12, 0x18, 0x0a,
	0x04, 0x6e, 0x61, 0x6d, 0x65, 0x18, 0x01, 0x20, 0x01, 0x28, 0x09, 0x42, 0x04, 0xe8, 0xc7, 0x31,
	0x01, 0x52, 0x04, 0x6e, 0x61, 0x6d, 0x65, 0x12, 0x29, 0x0a, 0x09, 0x66, 0x6f, 0x6c, 0x64, 0x65,
	0x72, 0x5f, 0x69, 0x64, 0x18, 0x02, 0x20, 0x01, 0x28, 0x09, 0x42, 0x0c, 0xe8, 0xc7, 0x31, 0x01,
	0x8a, 0xc8, 0x31, 0x04, 0x3c, 0x3d, 0x35, 0x30, 0x52, 0x08, 0x66, 0x6f, 0x6c, 0x64, 0x65, 0x72,
	0x49, 0x64, 0x12, 0x32, 0x0a, 0x15, 0x64, 0x65, 0x66, 0x61, 0x75, 0x6c, 0x74, 0x5f, 0x73, 0x74,
	0x6f, 0x72, 0x61, 0x67, 0x65, 0x5f, 0x63, 0x6c, 0x61, 0x73, 0x73, 0x18, 0x04, 0x20, 0x01, 0x28,
	0x09, 0x52, 0x13, 0x64, 0x65, 0x66, 0x61, 0x75, 0x6c, 0x74, 0x53, 0x74, 0x6f, 0x72, 0x61, 0x67,
	0x65, 0x43, 0x6c, 0x61, 0x73, 0x73, 0x12, 0x19, 0x0a, 0x08, 0x6d, 0x61, 0x78, 0x5f, 0x73, 0x69,
	0x7a, 0x65, 0x18, 0x05, 0x20, 0x01, 0x28, 0x03, 0x52, 0x07, 0x6d, 0x61, 0x78, 0x53, 0x69, 0x7a,
	0x65, 0x12, 0x63, 0x0a, 0x16, 0x61, 0x6e, 0x6f, 0x6e, 0x79, 0x6d, 0x6f, 0x75, 0x73, 0x5f, 0x61,
	0x63, 0x63, 0x65, 0x73, 0x73, 0x5f, 0x66, 0x6c, 0x61, 0x67, 0x73, 0x18, 0x06, 0x20, 0x01, 0x28,
	0x0b, 0x32, 0x2d, 0x2e, 0x79, 0x61, 0x6e, 0x64, 0x65, 0x78, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64,
	0x2e, 0x73, 0x74, 0x6f, 0x72, 0x61, 0x67, 0x65, 0x2e, 0x76, 0x31, 0x2e, 0x41, 0x6e, 0x6f, 0x6e,
	0x79, 0x6d, 0x6f, 0x75, 0x73, 0x41, 0x63, 0x63, 0x65, 0x73, 0x73, 0x46, 0x6c, 0x61, 0x67, 0x73,
	0x52, 0x14, 0x61, 0x6e, 0x6f, 0x6e, 0x79, 0x6d, 0x6f, 0x75, 0x73, 0x41, 0x63, 0x63, 0x65, 0x73,
	0x73, 0x46, 0x6c, 0x61, 0x67, 0x73, 0x12, 0x2e, 0x0a, 0x03, 0x61, 0x63, 0x6c, 0x18, 0x07, 0x20,
	0x01, 0x28, 0x0b, 0x32, 0x1c, 0x2e, 0x79, 0x61, 0x6e, 0x64, 0x65, 0x78, 0x2e, 0x63, 0x6c, 0x6f,
	0x75, 0x64, 0x2e, 0x73, 0x74, 0x6f, 0x72, 0x61, 0x67, 0x65, 0x2e, 0x76, 0x31, 0x2e, 0x41, 0x43,
	0x4c, 0x52, 0x03, 0x61, 0x63, 0x6c, 0x12, 0x30, 0x0a, 0x04, 0x74, 0x61, 0x67, 0x73, 0x18, 0x08,
	0x20, 0x03, 0x28, 0x0b, 0x32, 0x1c, 0x2e, 0x79, 0x61, 0x6e, 0x64, 0x65, 0x78, 0x2e, 0x63, 0x6c,
	0x6f, 0x75, 0x64, 0x2e, 0x73, 0x74, 0x6f, 0x72, 0x61, 0x67, 0x65, 0x2e, 0x76, 0x31, 0x2e, 0x54,
	0x61, 0x67, 0x52, 0x04, 0x74, 0x61, 0x67, 0x73, 0x22, 0x2a, 0x0a, 0x14, 0x43, 0x72, 0x65, 0x61,
	0x74, 0x65, 0x42, 0x75, 0x63, 0x6b, 0x65, 0x74, 0x4d, 0x65, 0x74, 0x61, 0x64, 0x61, 0x74, 0x61,
	0x12, 0x12, 0x0a, 0x04, 0x6e, 0x61, 0x6d, 0x65, 0x18, 0x01, 0x20, 0x01, 0x28, 0x09, 0x52, 0x04,
	0x6e, 0x61, 0x6d, 0x65, 0x22, 0xe6, 0x06, 0x0a, 0x13, 0x55, 0x70, 0x64, 0x61, 0x74, 0x65, 0x42,
	0x75, 0x63, 0x6b, 0x65, 0x74, 0x52, 0x65, 0x71, 0x75, 0x65, 0x73, 0x74, 0x12, 0x18, 0x0a, 0x04,
	0x6e, 0x61, 0x6d, 0x65, 0x18, 0x01, 0x20, 0x01, 0x28, 0x09, 0x42, 0x04, 0xe8, 0xc7, 0x31, 0x01,
	0x52, 0x04, 0x6e, 0x61, 0x6d, 0x65, 0x12, 0x41, 0x0a, 0x0b, 0x75, 0x70, 0x64, 0x61, 0x74, 0x65,
	0x5f, 0x6d, 0x61, 0x73, 0x6b, 0x18, 0x02, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x1a, 0x2e, 0x67, 0x6f,
	0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x62, 0x75, 0x66, 0x2e, 0x46, 0x69,
	0x65, 0x6c, 0x64, 0x4d, 0x61, 0x73, 0x6b, 0x42, 0x04, 0xe8, 0xc7, 0x31, 0x01, 0x52, 0x0a, 0x75,
	0x70, 0x64, 0x61, 0x74, 0x65, 0x4d, 0x61, 0x73, 0x6b, 0x12, 0x63, 0x0a, 0x16, 0x61, 0x6e, 0x6f,
	0x6e, 0x79, 0x6d, 0x6f, 0x75, 0x73, 0x5f, 0x61, 0x63, 0x63, 0x65, 0x73, 0x73, 0x5f, 0x66, 0x6c,
	0x61, 0x67, 0x73, 0x18, 0x03, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x2d, 0x2e, 0x79, 0x61, 0x6e, 0x64,
	0x65, 0x78, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x73, 0x74, 0x6f, 0x72, 0x61, 0x67, 0x65,
	0x2e, 0x76, 0x31, 0x2e, 0x41, 0x6e, 0x6f, 0x6e, 0x79, 0x6d, 0x6f, 0x75, 0x73, 0x41, 0x63, 0x63,
	0x65, 0x73, 0x73, 0x46, 0x6c, 0x61, 0x67, 0x73, 0x52, 0x14, 0x61, 0x6e, 0x6f, 0x6e, 0x79, 0x6d,
	0x6f, 0x75, 0x73, 0x41, 0x63, 0x63, 0x65, 0x73, 0x73, 0x46, 0x6c, 0x61, 0x67, 0x73, 0x12, 0x32,
	0x0a, 0x15, 0x64, 0x65, 0x66, 0x61, 0x75, 0x6c, 0x74, 0x5f, 0x73, 0x74, 0x6f, 0x72, 0x61, 0x67,
	0x65, 0x5f, 0x63, 0x6c, 0x61, 0x73, 0x73, 0x18, 0x04, 0x20, 0x01, 0x28, 0x09, 0x52, 0x13, 0x64,
	0x65, 0x66, 0x61, 0x75, 0x6c, 0x74, 0x53, 0x74, 0x6f, 0x72, 0x61, 0x67, 0x65, 0x43, 0x6c, 0x61,
	0x73, 0x73, 0x12, 0x19, 0x0a, 0x08, 0x6d, 0x61, 0x78, 0x5f, 0x73, 0x69, 0x7a, 0x65, 0x18, 0x05,
	0x20, 0x01, 0x28, 0x03, 0x52, 0x07, 0x6d, 0x61, 0x78, 0x53, 0x69, 0x7a, 0x65, 0x12, 0x35, 0x0a,
	0x04, 0x63, 0x6f, 0x72, 0x73, 0x18, 0x06, 0x20, 0x03, 0x28, 0x0b, 0x32, 0x21, 0x2e, 0x79, 0x61,
	0x6e, 0x64, 0x65, 0x78, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x73, 0x74, 0x6f, 0x72, 0x61,
	0x67, 0x65, 0x2e, 0x76, 0x31, 0x2e, 0x43, 0x6f, 0x72, 0x73, 0x52, 0x75, 0x6c, 0x65, 0x52, 0x04,
	0x63, 0x6f, 0x72, 0x73, 0x12, 0x53, 0x0a, 0x10, 0x77, 0x65, 0x62, 0x73, 0x69, 0x74, 0x65, 0x5f,
	0x73, 0x65, 0x74, 0x74, 0x69, 0x6e, 0x67, 0x73, 0x18, 0x07, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x28,
	0x2e, 0x79, 0x61, 0x6e, 0x64, 0x65, 0x78, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x73, 0x74,
	0x6f, 0x72, 0x61, 0x67, 0x65, 0x2e, 0x76, 0x31, 0x2e, 0x57, 0x65, 0x62, 0x73, 0x69, 0x74, 0x65,
	0x53, 0x65, 0x74, 0x74, 0x69, 0x6e, 0x67, 0x73, 0x52, 0x0f, 0x77, 0x65, 0x62, 0x73, 0x69, 0x74,
	0x65, 0x53, 0x65, 0x74, 0x74, 0x69, 0x6e, 0x67, 0x73, 0x12, 0x43, 0x0a, 0x0a, 0x76, 0x65, 0x72,
	0x73, 0x69, 0x6f, 0x6e, 0x69, 0x6e, 0x67, 0x18, 0x08, 0x20, 0x01, 0x28, 0x0e, 0x32, 0x23, 0x2e,
	0x79, 0x61, 0x6e, 0x64, 0x65, 0x78, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x73, 0x74, 0x6f,
	0x72, 0x61, 0x67, 0x65, 0x2e, 0x76, 0x31, 0x2e, 0x56, 0x65, 0x72, 0x73, 0x69, 0x6f, 0x6e, 0x69,
	0x6e, 0x67, 0x52, 0x0a, 0x76, 0x65, 0x72, 0x73, 0x69, 0x6f, 0x6e, 0x69, 0x6e, 0x67, 0x12, 0x4f,
	0x0a, 0x0f, 0x6c, 0x69, 0x66, 0x65, 0x63, 0x79, 0x63, 0x6c, 0x65, 0x5f, 0x72, 0x75, 0x6c, 0x65,
	0x73, 0x18, 0x09, 0x20, 0x03, 0x28, 0x0b, 0x32, 0x26, 0x2e, 0x79, 0x61, 0x6e, 0x64, 0x65, 0x78,
	0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x73, 0x74, 0x6f, 0x72, 0x61, 0x67, 0x65, 0x2e, 0x76,
	0x31, 0x2e, 0x4c, 0x69, 0x66, 0x65, 0x63, 0x79, 0x63, 0x6c, 0x65, 0x52, 0x75, 0x6c, 0x65, 0x52,
	0x0e, 0x6c, 0x69, 0x66, 0x65, 0x63, 0x79, 0x63, 0x6c, 0x65, 0x52, 0x75, 0x6c, 0x65, 0x73, 0x12,
	0x2f, 0x0a, 0x06, 0x70, 0x6f, 0x6c, 0x69, 0x63, 0x79, 0x18, 0x0a, 0x20, 0x01, 0x28, 0x0b, 0x32,
	0x17, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x62, 0x75,
	0x66, 0x2e, 0x53, 0x74, 0x72, 0x75, 0x63, 0x74, 0x52, 0x06, 0x70, 0x6f, 0x6c, 0x69, 0x63, 0x79,
	0x12, 0x2e, 0x0a, 0x03, 0x61, 0x63, 0x6c, 0x18, 0x0b, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x1c, 0x2e,
	0x79, 0x61, 0x6e, 0x64, 0x65, 0x78, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x73, 0x74, 0x6f,
	0x72, 0x61, 0x67, 0x65, 0x2e, 0x76, 0x31, 0x2e, 0x41, 0x43, 0x4c, 0x52, 0x03, 0x61, 0x63, 0x6c,
	0x12, 0x30, 0x0a, 0x04, 0x74, 0x61, 0x67, 0x73, 0x18, 0x0c, 0x20, 0x03, 0x28, 0x0b, 0x32, 0x1c,
	0x2e, 0x79, 0x61, 0x6e, 0x64, 0x65, 0x78, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x73, 0x74,
	0x6f, 0x72, 0x61, 0x67, 0x65, 0x2e, 0x76, 0x31, 0x2e, 0x54, 0x61, 0x67, 0x52, 0x04, 0x74, 0x61,
	0x67, 0x73, 0x12, 0x44, 0x0a, 0x0b, 0x6f, 0x62, 0x6a, 0x65, 0x63, 0x74, 0x5f, 0x6c, 0x6f, 0x63,
	0x6b, 0x18, 0x0d, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x23, 0x2e, 0x79, 0x61, 0x6e, 0x64, 0x65, 0x78,
	0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x73, 0x74, 0x6f, 0x72, 0x61, 0x67, 0x65, 0x2e, 0x76,
	0x31, 0x2e, 0x4f, 0x62, 0x6a, 0x65, 0x63, 0x74, 0x4c, 0x6f, 0x63, 0x6b, 0x52, 0x0a, 0x6f, 0x62,
	0x6a, 0x65, 0x63, 0x74, 0x4c, 0x6f, 0x63, 0x6b, 0x12, 0x43, 0x0a, 0x0a, 0x65, 0x6e, 0x63, 0x72,
	0x79, 0x70, 0x74, 0x69, 0x6f, 0x6e, 0x18, 0x0e, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x23, 0x2e, 0x79,
	0x61, 0x6e, 0x64, 0x65, 0x78, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x73, 0x74, 0x6f, 0x72,
	0x61, 0x67, 0x65, 0x2e, 0x76, 0x31, 0x2e, 0x45, 0x6e, 0x63, 0x72, 0x79, 0x70, 0x74, 0x69, 0x6f,
	0x6e, 0x52, 0x0a, 0x65, 0x6e, 0x63, 0x72, 0x79, 0x70, 0x74, 0x69, 0x6f, 0x6e, 0x22, 0x2a, 0x0a,
	0x14, 0x55, 0x70, 0x64, 0x61, 0x74, 0x65, 0x42, 0x75, 0x63, 0x6b, 0x65, 0x74, 0x4d, 0x65, 0x74,
	0x61, 0x64, 0x61, 0x74, 0x61, 0x12, 0x12, 0x0a, 0x04, 0x6e, 0x61, 0x6d, 0x65, 0x18, 0x01, 0x20,
	0x01, 0x28, 0x09, 0x52, 0x04, 0x6e, 0x61, 0x6d, 0x65, 0x22, 0x2f, 0x0a, 0x13, 0x44, 0x65, 0x6c,
	0x65, 0x74, 0x65, 0x42, 0x75, 0x63, 0x6b, 0x65, 0x74, 0x52, 0x65, 0x71, 0x75, 0x65, 0x73, 0x74,
	0x12, 0x18, 0x0a, 0x04, 0x6e, 0x61, 0x6d, 0x65, 0x18, 0x01, 0x20, 0x01, 0x28, 0x09, 0x42, 0x04,
	0xe8, 0xc7, 0x31, 0x01, 0x52, 0x04, 0x6e, 0x61, 0x6d, 0x65, 0x22, 0x2a, 0x0a, 0x14, 0x44, 0x65,
	0x6c, 0x65, 0x74, 0x65, 0x42, 0x75, 0x63, 0x6b, 0x65, 0x74, 0x4d, 0x65, 0x74, 0x61, 0x64, 0x61,
	0x74, 0x61, 0x12, 0x12, 0x0a, 0x04, 0x6e, 0x61, 0x6d, 0x65, 0x18, 0x01, 0x20, 0x01, 0x28, 0x09,
	0x52, 0x04, 0x6e, 0x61, 0x6d, 0x65, 0x22, 0x31, 0x0a, 0x15, 0x47, 0x65, 0x74, 0x42, 0x75, 0x63,
	0x6b, 0x65, 0x74, 0x53, 0x74, 0x61, 0x74, 0x73, 0x52, 0x65, 0x71, 0x75, 0x65, 0x73, 0x74, 0x12,
	0x18, 0x0a, 0x04, 0x6e, 0x61, 0x6d, 0x65, 0x18, 0x01, 0x20, 0x01, 0x28, 0x09, 0x42, 0x04, 0xe8,
	0xc7, 0x31, 0x01, 0x52, 0x04, 0x6e, 0x61, 0x6d, 0x65, 0x22, 0x37, 0x0a, 0x1b, 0x47, 0x65, 0x74,
	0x42, 0x75, 0x63, 0x6b, 0x65, 0x74, 0x48, 0x54, 0x54, 0x50, 0x53, 0x43, 0x6f, 0x6e, 0x66, 0x69,
	0x67, 0x52, 0x65, 0x71, 0x75, 0x65, 0x73, 0x74, 0x12, 0x18, 0x0a, 0x04, 0x6e, 0x61, 0x6d, 0x65,
	0x18, 0x01, 0x20, 0x01, 0x28, 0x09, 0x42, 0x04, 0xe8, 0xc7, 0x31, 0x01, 0x52, 0x04, 0x6e, 0x61,
	0x6d, 0x65, 0x22, 0x8d, 0x01, 0x0a, 0x1c, 0x53, 0x65, 0x6c, 0x66, 0x4d, 0x61, 0x6e, 0x61, 0x67,
	0x65, 0x64, 0x48, 0x54, 0x54, 0x50, 0x53, 0x43, 0x6f, 0x6e, 0x66, 0x69, 0x67, 0x50, 0x61, 0x72,
	0x61, 0x6d, 0x73, 0x12, 0x36, 0x0a, 0x0f, 0x63, 0x65, 0x72, 0x74, 0x69, 0x66, 0x69, 0x63, 0x61,
	0x74, 0x65, 0x5f, 0x70, 0x65, 0x6d, 0x18, 0x01, 0x20, 0x01, 0x28, 0x09, 0x42, 0x0d, 0x8a, 0xc8,
	0x31, 0x09, 0x3c, 0x3d, 0x33, 0x31, 0x34, 0x35, 0x37, 0x32, 0x38, 0x52, 0x0e, 0x63, 0x65, 0x72,
	0x74, 0x69, 0x66, 0x69, 0x63, 0x61, 0x74, 0x65, 0x50, 0x65, 0x6d, 0x12, 0x35, 0x0a, 0x0f, 0x70,
	0x72, 0x69, 0x76, 0x61, 0x74, 0x65, 0x5f, 0x6b, 0x65, 0x79, 0x5f, 0x70, 0x65, 0x6d, 0x18, 0x02,
	0x20, 0x01, 0x28, 0x09, 0x42, 0x0d, 0x8a, 0xc8, 0x31, 0x09, 0x3c, 0x3d, 0x33, 0x31, 0x34, 0x35,
	0x37, 0x32, 0x38, 0x52, 0x0d, 0x70, 0x72, 0x69, 0x76, 0x61, 0x74, 0x65, 0x4b, 0x65, 0x79, 0x50,
	0x65, 0x6d, 0x22, 0x4c, 0x0a, 0x23, 0x43, 0x65, 0x72, 0x74, 0x69, 0x66, 0x69, 0x63, 0x61, 0x74,
	0x65, 0x4d, 0x61, 0x6e, 0x61, 0x67, 0x65, 0x72, 0x48, 0x54, 0x54, 0x50, 0x53, 0x43, 0x6f, 0x6e,
	0x66, 0x69, 0x67, 0x50, 0x61, 0x72, 0x61, 0x6d, 0x73, 0x12, 0x25, 0x0a, 0x0e, 0x63, 0x65, 0x72,
	0x74, 0x69, 0x66, 0x69, 0x63, 0x61, 0x74, 0x65, 0x5f, 0x69, 0x64, 0x18, 0x01, 0x20, 0x01, 0x28,
	0x09, 0x52, 0x0d, 0x63, 0x65, 0x72, 0x74, 0x69, 0x66, 0x69, 0x63, 0x61, 0x74, 0x65, 0x49, 0x64,
	0x22, 0x94, 0x02, 0x0a, 0x1b, 0x53, 0x65, 0x74, 0x42, 0x75, 0x63, 0x6b, 0x65, 0x74, 0x48, 0x54,
	0x54, 0x50, 0x53, 0x43, 0x6f, 0x6e, 0x66, 0x69, 0x67, 0x52, 0x65, 0x71, 0x75, 0x65, 0x73, 0x74,
	0x12, 0x18, 0x0a, 0x04, 0x6e, 0x61, 0x6d, 0x65, 0x18, 0x01, 0x20, 0x01, 0x28, 0x09, 0x42, 0x04,
	0xe8, 0xc7, 0x31, 0x01, 0x52, 0x04, 0x6e, 0x61, 0x6d, 0x65, 0x12, 0x5a, 0x0a, 0x0c, 0x73, 0x65,
	0x6c, 0x66, 0x5f, 0x6d, 0x61, 0x6e, 0x61, 0x67, 0x65, 0x64, 0x18, 0x02, 0x20, 0x01, 0x28, 0x0b,
	0x32, 0x35, 0x2e, 0x79, 0x61, 0x6e, 0x64, 0x65, 0x78, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e,
	0x73, 0x74, 0x6f, 0x72, 0x61, 0x67, 0x65, 0x2e, 0x76, 0x31, 0x2e, 0x53, 0x65, 0x6c, 0x66, 0x4d,
	0x61, 0x6e, 0x61, 0x67, 0x65, 0x64, 0x48, 0x54, 0x54, 0x50, 0x53, 0x43, 0x6f, 0x6e, 0x66, 0x69,
	0x67, 0x50, 0x61, 0x72, 0x61, 0x6d, 0x73, 0x48, 0x00, 0x52, 0x0b, 0x73, 0x65, 0x6c, 0x66, 0x4d,
	0x61, 0x6e, 0x61, 0x67, 0x65, 0x64, 0x12, 0x6f, 0x0a, 0x13, 0x63, 0x65, 0x72, 0x74, 0x69, 0x66,
	0x69, 0x63, 0x61, 0x74, 0x65, 0x5f, 0x6d, 0x61, 0x6e, 0x61, 0x67, 0x65, 0x72, 0x18, 0x03, 0x20,
	0x01, 0x28, 0x0b, 0x32, 0x3c, 0x2e, 0x79, 0x61, 0x6e, 0x64, 0x65, 0x78, 0x2e, 0x63, 0x6c, 0x6f,
	0x75, 0x64, 0x2e, 0x73, 0x74, 0x6f, 0x72, 0x61, 0x67, 0x65, 0x2e, 0x76, 0x31, 0x2e, 0x43, 0x65,
	0x72, 0x74, 0x69, 0x66, 0x69, 0x63, 0x61, 0x74, 0x65, 0x4d, 0x61, 0x6e, 0x61, 0x67, 0x65, 0x72,
	0x48, 0x54, 0x54, 0x50, 0x53, 0x43, 0x6f, 0x6e, 0x66, 0x69, 0x67, 0x50, 0x61, 0x72, 0x61, 0x6d,
	0x73, 0x48, 0x00, 0x52, 0x12, 0x63, 0x65, 0x72, 0x74, 0x69, 0x66, 0x69, 0x63, 0x61, 0x74, 0x65,
	0x4d, 0x61, 0x6e, 0x61, 0x67, 0x65, 0x72, 0x42, 0x0e, 0x0a, 0x06, 0x70, 0x61, 0x72, 0x61, 0x6d,
	0x73, 0x12, 0x04, 0xc0, 0xc1, 0x31, 0x01, 0x22, 0x32, 0x0a, 0x1c, 0x53, 0x65, 0x74, 0x42, 0x75,
	0x63, 0x6b, 0x65, 0x74, 0x48, 0x54, 0x54, 0x50, 0x53, 0x43, 0x6f, 0x6e, 0x66, 0x69, 0x67, 0x4d,
	0x65, 0x74, 0x61, 0x64, 0x61, 0x74, 0x61, 0x12, 0x12, 0x0a, 0x04, 0x6e, 0x61, 0x6d, 0x65, 0x18,
	0x01, 0x20, 0x01, 0x28, 0x09, 0x52, 0x04, 0x6e, 0x61, 0x6d, 0x65, 0x22, 0x3a, 0x0a, 0x1e, 0x44,
	0x65, 0x6c, 0x65, 0x74, 0x65, 0x42, 0x75, 0x63, 0x6b, 0x65, 0x74, 0x48, 0x54, 0x54, 0x50, 0x53,
	0x43, 0x6f, 0x6e, 0x66, 0x69, 0x67, 0x52, 0x65, 0x71, 0x75, 0x65, 0x73, 0x74, 0x12, 0x18, 0x0a,
	0x04, 0x6e, 0x61, 0x6d, 0x65, 0x18, 0x01, 0x20, 0x01, 0x28, 0x09, 0x42, 0x04, 0xe8, 0xc7, 0x31,
	0x01, 0x52, 0x04, 0x6e, 0x61, 0x6d, 0x65, 0x22, 0x35, 0x0a, 0x1f, 0x44, 0x65, 0x6c, 0x65, 0x74,
	0x65, 0x42, 0x75, 0x63, 0x6b, 0x65, 0x74, 0x48, 0x54, 0x54, 0x50, 0x53, 0x43, 0x6f, 0x6e, 0x66,
	0x69, 0x67, 0x4d, 0x65, 0x74, 0x61, 0x64, 0x61, 0x74, 0x61, 0x12, 0x12, 0x0a, 0x04, 0x6e, 0x61,
	0x6d, 0x65, 0x18, 0x01, 0x20, 0x01, 0x28, 0x09, 0x52, 0x04, 0x6e, 0x61, 0x6d, 0x65, 0x32, 0xe1,
	0x0b, 0x0a, 0x0d, 0x42, 0x75, 0x63, 0x6b, 0x65, 0x74, 0x53, 0x65, 0x72, 0x76, 0x69, 0x63, 0x65,
	0x12, 0x7e, 0x0a, 0x04, 0x4c, 0x69, 0x73, 0x74, 0x12, 0x2b, 0x2e, 0x79, 0x61, 0x6e, 0x64, 0x65,
	0x78, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x73, 0x74, 0x6f, 0x72, 0x61, 0x67, 0x65, 0x2e,
	0x76, 0x31, 0x2e, 0x4c, 0x69, 0x73, 0x74, 0x42, 0x75, 0x63, 0x6b, 0x65, 0x74, 0x73, 0x52, 0x65,
	0x71, 0x75, 0x65, 0x73, 0x74, 0x1a, 0x2c, 0x2e, 0x79, 0x61, 0x6e, 0x64, 0x65, 0x78, 0x2e, 0x63,
	0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x73, 0x74, 0x6f, 0x72, 0x61, 0x67, 0x65, 0x2e, 0x76, 0x31, 0x2e,
	0x4c, 0x69, 0x73, 0x74, 0x42, 0x75, 0x63, 0x6b, 0x65, 0x74, 0x73, 0x52, 0x65, 0x73, 0x70, 0x6f,
	0x6e, 0x73, 0x65, 0x22, 0x1b, 0x82, 0xd3, 0xe4, 0x93, 0x02, 0x15, 0x12, 0x13, 0x2f, 0x73, 0x74,
	0x6f, 0x72, 0x61, 0x67, 0x65, 0x2f, 0x76, 0x31, 0x2f, 0x62, 0x75, 0x63, 0x6b, 0x65, 0x74, 0x73,
	0x12, 0x75, 0x0a, 0x03, 0x47, 0x65, 0x74, 0x12, 0x29, 0x2e, 0x79, 0x61, 0x6e, 0x64, 0x65, 0x78,
	0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x73, 0x74, 0x6f, 0x72, 0x61, 0x67, 0x65, 0x2e, 0x76,
	0x31, 0x2e, 0x47, 0x65, 0x74, 0x42, 0x75, 0x63, 0x6b, 0x65, 0x74, 0x52, 0x65, 0x71, 0x75, 0x65,
	0x73, 0x74, 0x1a, 0x1f, 0x2e, 0x79, 0x61, 0x6e, 0x64, 0x65, 0x78, 0x2e, 0x63, 0x6c, 0x6f, 0x75,
	0x64, 0x2e, 0x73, 0x74, 0x6f, 0x72, 0x61, 0x67, 0x65, 0x2e, 0x76, 0x31, 0x2e, 0x42, 0x75, 0x63,
	0x6b, 0x65, 0x74, 0x22, 0x22, 0x82, 0xd3, 0xe4, 0x93, 0x02, 0x1c, 0x12, 0x1a, 0x2f, 0x73, 0x74,
	0x6f, 0x72, 0x61, 0x67, 0x65, 0x2f, 0x76, 0x31, 0x2f, 0x62, 0x75, 0x63, 0x6b, 0x65, 0x74, 0x73,
	0x2f, 0x7b, 0x6e, 0x61, 0x6d, 0x65, 0x7d, 0x12, 0x9b, 0x01, 0x0a, 0x06, 0x43, 0x72, 0x65, 0x61,
	0x74, 0x65, 0x12, 0x2c, 0x2e, 0x79, 0x61, 0x6e, 0x64, 0x65, 0x78, 0x2e, 0x63, 0x6c, 0x6f, 0x75,
	0x64, 0x2e, 0x73, 0x74, 0x6f, 0x72, 0x61, 0x67, 0x65, 0x2e, 0x76, 0x31, 0x2e, 0x43, 0x72, 0x65,
	0x61, 0x74, 0x65, 0x42, 0x75, 0x63, 0x6b, 0x65, 0x74, 0x52, 0x65, 0x71, 0x75, 0x65, 0x73, 0x74,
	0x1a, 0x21, 0x2e, 0x79, 0x61, 0x6e, 0x64, 0x65, 0x78, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e,
	0x6f, 0x70, 0x65, 0x72, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x2e, 0x4f, 0x70, 0x65, 0x72, 0x61, 0x74,
	0x69, 0x6f, 0x6e, 0x22, 0x40, 0xb2, 0xd2, 0x2a, 0x1e, 0x0a, 0x14, 0x43, 0x72, 0x65, 0x61, 0x74,
	0x65, 0x42, 0x75, 0x63, 0x6b, 0x65, 0x74, 0x4d, 0x65, 0x74, 0x61, 0x64, 0x61, 0x74, 0x61, 0x12,
	0x06, 0x42, 0x75, 0x63, 0x6b, 0x65, 0x74, 0x82, 0xd3, 0xe4, 0x93, 0x02, 0x18, 0x3a, 0x01, 0x2a,
	0x22, 0x13, 0x2f, 0x73, 0x74, 0x6f, 0x72, 0x61, 0x67, 0x65, 0x2f, 0x76, 0x31, 0x2f, 0x62, 0x75,
	0x63, 0x6b, 0x65, 0x74, 0x73, 0x12, 0xa2, 0x01, 0x0a, 0x06, 0x55, 0x70, 0x64, 0x61, 0x74, 0x65,
	0x12, 0x2c, 0x2e, 0x79, 0x61, 0x6e, 0x64, 0x65, 0x78, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e,
	0x73, 0x74, 0x6f, 0x72, 0x61, 0x67, 0x65, 0x2e, 0x76, 0x31, 0x2e, 0x55, 0x70, 0x64, 0x61, 0x74,
	0x65, 0x42, 0x75, 0x63, 0x6b, 0x65, 0x74, 0x52, 0x65, 0x71, 0x75, 0x65, 0x73, 0x74, 0x1a, 0x21,
	0x2e, 0x79, 0x61, 0x6e, 0x64, 0x65, 0x78, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x6f, 0x70,
	0x65, 0x72, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x2e, 0x4f, 0x70, 0x65, 0x72, 0x61, 0x74, 0x69, 0x6f,
	0x6e, 0x22, 0x47, 0xb2, 0xd2, 0x2a, 0x1e, 0x0a, 0x14, 0x55, 0x70, 0x64, 0x61, 0x74, 0x65, 0x42,
	0x75, 0x63, 0x6b, 0x65, 0x74, 0x4d, 0x65, 0x74, 0x61, 0x64, 0x61, 0x74, 0x61, 0x12, 0x06, 0x42,
	0x75, 0x63, 0x6b, 0x65, 0x74, 0x82, 0xd3, 0xe4, 0x93, 0x02, 0x1f, 0x3a, 0x01, 0x2a, 0x32, 0x1a,
	0x2f, 0x73, 0x74, 0x6f, 0x72, 0x61, 0x67, 0x65, 0x2f, 0x76, 0x31, 0x2f, 0x62, 0x75, 0x63, 0x6b,
	0x65, 0x74, 0x73, 0x2f, 0x7b, 0x6e, 0x61, 0x6d, 0x65, 0x7d, 0x12, 0xae, 0x01, 0x0a, 0x06, 0x44,
	0x65, 0x6c, 0x65, 0x74, 0x65, 0x12, 0x2c, 0x2e, 0x79, 0x61, 0x6e, 0x64, 0x65, 0x78, 0x2e, 0x63,
	0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x73, 0x74, 0x6f, 0x72, 0x61, 0x67, 0x65, 0x2e, 0x76, 0x31, 0x2e,
	0x44, 0x65, 0x6c, 0x65, 0x74, 0x65, 0x42, 0x75, 0x63, 0x6b, 0x65, 0x74, 0x52, 0x65, 0x71, 0x75,
	0x65, 0x73, 0x74, 0x1a, 0x21, 0x2e, 0x79, 0x61, 0x6e, 0x64, 0x65, 0x78, 0x2e, 0x63, 0x6c, 0x6f,
	0x75, 0x64, 0x2e, 0x6f, 0x70, 0x65, 0x72, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x2e, 0x4f, 0x70, 0x65,
	0x72, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x22, 0x53, 0xb2, 0xd2, 0x2a, 0x2d, 0x0a, 0x14, 0x44, 0x65,
	0x6c, 0x65, 0x74, 0x65, 0x42, 0x75, 0x63, 0x6b, 0x65, 0x74, 0x4d, 0x65, 0x74, 0x61, 0x64, 0x61,
	0x74, 0x61, 0x12, 0x15, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x70, 0x72, 0x6f, 0x74, 0x6f,
	0x62, 0x75, 0x66, 0x2e, 0x45, 0x6d, 0x70, 0x74, 0x79, 0x82, 0xd3, 0xe4, 0x93, 0x02, 0x1c, 0x2a,
	0x1a, 0x2f, 0x73, 0x74, 0x6f, 0x72, 0x61, 0x67, 0x65, 0x2f, 0x76, 0x31, 0x2f, 0x62, 0x75, 0x63,
	0x6b, 0x65, 0x74, 0x73, 0x2f, 0x7b, 0x6e, 0x61, 0x6d, 0x65, 0x7d, 0x12, 0x8d, 0x01, 0x0a, 0x08,
	0x47, 0x65, 0x74, 0x53, 0x74, 0x61, 0x74, 0x73, 0x12, 0x2e, 0x2e, 0x79, 0x61, 0x6e, 0x64, 0x65,
	0x78, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x73, 0x74, 0x6f, 0x72, 0x61, 0x67, 0x65, 0x2e,
	0x76, 0x31, 0x2e, 0x47, 0x65, 0x74, 0x42, 0x75, 0x63, 0x6b, 0x65, 0x74, 0x53, 0x74, 0x61, 0x74,
	0x73, 0x52, 0x65, 0x71, 0x75, 0x65, 0x73, 0x74, 0x1a, 0x24, 0x2e, 0x79, 0x61, 0x6e, 0x64, 0x65,
	0x78, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x73, 0x74, 0x6f, 0x72, 0x61, 0x67, 0x65, 0x2e,
	0x76, 0x31, 0x2e, 0x42, 0x75, 0x63, 0x6b, 0x65, 0x74, 0x53, 0x74, 0x61, 0x74, 0x73, 0x22, 0x2b,
	0x82, 0xd3, 0xe4, 0x93, 0x02, 0x25, 0x12, 0x23, 0x2f, 0x73, 0x74, 0x6f, 0x72, 0x61, 0x67, 0x65,
	0x2f, 0x76, 0x31, 0x2f, 0x62, 0x75, 0x63, 0x6b, 0x65, 0x74, 0x73, 0x2f, 0x7b, 0x6e, 0x61, 0x6d,
	0x65, 0x7d, 0x3a, 0x67, 0x65, 0x74, 0x53, 0x74, 0x61, 0x74, 0x73, 0x12, 0x9f, 0x01, 0x0a, 0x0e,
	0x47, 0x65, 0x74, 0x48, 0x54, 0x54, 0x50, 0x53, 0x43, 0x6f, 0x6e, 0x66, 0x69, 0x67, 0x12, 0x34,
	0x2e, 0x79, 0x61, 0x6e, 0x64, 0x65, 0x78, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x73, 0x74,
	0x6f, 0x72, 0x61, 0x67, 0x65, 0x2e, 0x76, 0x31, 0x2e, 0x47, 0x65, 0x74, 0x42, 0x75, 0x63, 0x6b,
	0x65, 0x74, 0x48, 0x54, 0x54, 0x50, 0x53, 0x43, 0x6f, 0x6e, 0x66, 0x69, 0x67, 0x52, 0x65, 0x71,
	0x75, 0x65, 0x73, 0x74, 0x1a, 0x24, 0x2e, 0x79, 0x61, 0x6e, 0x64, 0x65, 0x78, 0x2e, 0x63, 0x6c,
	0x6f, 0x75, 0x64, 0x2e, 0x73, 0x74, 0x6f, 0x72, 0x61, 0x67, 0x65, 0x2e, 0x76, 0x31, 0x2e, 0x48,
	0x54, 0x54, 0x50, 0x53, 0x43, 0x6f, 0x6e, 0x66, 0x69, 0x67, 0x22, 0x31, 0x82, 0xd3, 0xe4, 0x93,
	0x02, 0x2b, 0x12, 0x29, 0x2f, 0x73, 0x74, 0x6f, 0x72, 0x61, 0x67, 0x65, 0x2f, 0x76, 0x31, 0x2f,
	0x62, 0x75, 0x63, 0x6b, 0x65, 0x74, 0x73, 0x2f, 0x7b, 0x6e, 0x61, 0x6d, 0x65, 0x7d, 0x3a, 0x67,
	0x65, 0x74, 0x48, 0x74, 0x74, 0x70, 0x73, 0x43, 0x6f, 0x6e, 0x66, 0x69, 0x67, 0x12, 0xce, 0x01,
	0x0a, 0x0e, 0x53, 0x65, 0x74, 0x48, 0x54, 0x54, 0x50, 0x53, 0x43, 0x6f, 0x6e, 0x66, 0x69, 0x67,
	0x12, 0x34, 0x2e, 0x79, 0x61, 0x6e, 0x64, 0x65, 0x78, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e,
	0x73, 0x74, 0x6f, 0x72, 0x61, 0x67, 0x65, 0x2e, 0x76, 0x31, 0x2e, 0x53, 0x65, 0x74, 0x42, 0x75,
	0x63, 0x6b, 0x65, 0x74, 0x48, 0x54, 0x54, 0x50, 0x53, 0x43, 0x6f, 0x6e, 0x66, 0x69, 0x67, 0x52,
	0x65, 0x71, 0x75, 0x65, 0x73, 0x74, 0x1a, 0x21, 0x2e, 0x79, 0x61, 0x6e, 0x64, 0x65, 0x78, 0x2e,
	0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x6f, 0x70, 0x65, 0x72, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x2e,
	0x4f, 0x70, 0x65, 0x72, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x22, 0x63, 0xb2, 0xd2, 0x2a, 0x2b, 0x0a,
	0x1c, 0x53, 0x65, 0x74, 0x42, 0x75, 0x63, 0x6b, 0x65, 0x74, 0x48, 0x54, 0x54, 0x50, 0x53, 0x43,
	0x6f, 0x6e, 0x66, 0x69, 0x67, 0x4d, 0x65, 0x74, 0x61, 0x64, 0x61, 0x74, 0x61, 0x12, 0x0b, 0x48,
	0x54, 0x54, 0x50, 0x53, 0x43, 0x6f, 0x6e, 0x66, 0x69, 0x67, 0x82, 0xd3, 0xe4, 0x93, 0x02, 0x2e,
	0x3a, 0x01, 0x2a, 0x22, 0x29, 0x2f, 0x73, 0x74, 0x6f, 0x72, 0x61, 0x67, 0x65, 0x2f, 0x76, 0x31,
	0x2f, 0x62, 0x75, 0x63, 0x6b, 0x65, 0x74, 0x73, 0x2f, 0x7b, 0x6e, 0x61, 0x6d, 0x65, 0x7d, 0x3a,
	0x73, 0x65, 0x74, 0x48, 0x74, 0x74, 0x70, 0x73, 0x43, 0x6f, 0x6e, 0x66, 0x69, 0x67, 0x12, 0xe1,
	0x01, 0x0a, 0x11, 0x44, 0x65, 0x6c, 0x65, 0x74, 0x65, 0x48, 0x54, 0x54, 0x50, 0x53, 0x43, 0x6f,
	0x6e, 0x66, 0x69, 0x67, 0x12, 0x37, 0x2e, 0x79, 0x61, 0x6e, 0x64, 0x65, 0x78, 0x2e, 0x63, 0x6c,
	0x6f, 0x75, 0x64, 0x2e, 0x73, 0x74, 0x6f, 0x72, 0x61, 0x67, 0x65, 0x2e, 0x76, 0x31, 0x2e, 0x44,
	0x65, 0x6c, 0x65, 0x74, 0x65, 0x42, 0x75, 0x63, 0x6b, 0x65, 0x74, 0x48, 0x54, 0x54, 0x50, 0x53,
	0x43, 0x6f, 0x6e, 0x66, 0x69, 0x67, 0x52, 0x65, 0x71, 0x75, 0x65, 0x73, 0x74, 0x1a, 0x21, 0x2e,
	0x79, 0x61, 0x6e, 0x64, 0x65, 0x78, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x6f, 0x70, 0x65,
	0x72, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x2e, 0x4f, 0x70, 0x65, 0x72, 0x61, 0x74, 0x69, 0x6f, 0x6e,
	0x22, 0x70, 0xb2, 0xd2, 0x2a, 0x38, 0x0a, 0x1f, 0x44, 0x65, 0x6c, 0x65, 0x74, 0x65, 0x42, 0x75,
	0x63, 0x6b, 0x65, 0x74, 0x48, 0x54, 0x54, 0x50, 0x53, 0x43, 0x6f, 0x6e, 0x66, 0x69, 0x67, 0x4d,
	0x65, 0x74, 0x61, 0x64, 0x61, 0x74, 0x61, 0x12, 0x15, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e,
	0x70, 0x72, 0x6f, 0x74, 0x6f, 0x62, 0x75, 0x66, 0x2e, 0x45, 0x6d, 0x70, 0x74, 0x79, 0x82, 0xd3,
	0xe4, 0x93, 0x02, 0x2e, 0x22, 0x2c, 0x2f, 0x73, 0x74, 0x6f, 0x72, 0x61, 0x67, 0x65, 0x2f, 0x76,
	0x31, 0x2f, 0x62, 0x75, 0x63, 0x6b, 0x65, 0x74, 0x73, 0x2f, 0x7b, 0x6e, 0x61, 0x6d, 0x65, 0x7d,
	0x3a, 0x64, 0x65, 0x6c, 0x65, 0x74, 0x65, 0x48, 0x74, 0x74, 0x70, 0x73, 0x43, 0x6f, 0x6e, 0x66,
	0x69, 0x67, 0x42, 0x62, 0x0a, 0x1b, 0x79, 0x61, 0x6e, 0x64, 0x65, 0x78, 0x2e, 0x63, 0x6c, 0x6f,
	0x75, 0x64, 0x2e, 0x61, 0x70, 0x69, 0x2e, 0x73, 0x74, 0x6f, 0x72, 0x61, 0x67, 0x65, 0x2e, 0x76,
	0x31, 0x5a, 0x43, 0x67, 0x69, 0x74, 0x68, 0x75, 0x62, 0x2e, 0x63, 0x6f, 0x6d, 0x2f, 0x79, 0x61,
	0x6e, 0x64, 0x65, 0x78, 0x2d, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2f, 0x67, 0x6f, 0x2d, 0x67, 0x65,
	0x6e, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x2f, 0x79, 0x61, 0x6e, 0x64, 0x65, 0x78, 0x2f, 0x63, 0x6c,
	0x6f, 0x75, 0x64, 0x2f, 0x73, 0x74, 0x6f, 0x72, 0x61, 0x67, 0x65, 0x2f, 0x76, 0x31, 0x3b, 0x73,
	0x74, 0x6f, 0x72, 0x61, 0x67, 0x65, 0x62, 0x06, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x33,
}

var (
	file_yandex_cloud_storage_v1_bucket_service_proto_rawDescOnce sync.Once
	file_yandex_cloud_storage_v1_bucket_service_proto_rawDescData = file_yandex_cloud_storage_v1_bucket_service_proto_rawDesc
)

func file_yandex_cloud_storage_v1_bucket_service_proto_rawDescGZIP() []byte {
	file_yandex_cloud_storage_v1_bucket_service_proto_rawDescOnce.Do(func() {
		file_yandex_cloud_storage_v1_bucket_service_proto_rawDescData = protoimpl.X.CompressGZIP(file_yandex_cloud_storage_v1_bucket_service_proto_rawDescData)
	})
	return file_yandex_cloud_storage_v1_bucket_service_proto_rawDescData
}

var file_yandex_cloud_storage_v1_bucket_service_proto_enumTypes = make([]protoimpl.EnumInfo, 1)
var file_yandex_cloud_storage_v1_bucket_service_proto_msgTypes = make([]protoimpl.MessageInfo, 17)
var file_yandex_cloud_storage_v1_bucket_service_proto_goTypes = []interface{}{
	(GetBucketRequest_View)(0),                  // 0: yandex.cloud.storage.v1.GetBucketRequest.View
	(*GetBucketRequest)(nil),                    // 1: yandex.cloud.storage.v1.GetBucketRequest
	(*ListBucketsRequest)(nil),                  // 2: yandex.cloud.storage.v1.ListBucketsRequest
	(*ListBucketsResponse)(nil),                 // 3: yandex.cloud.storage.v1.ListBucketsResponse
	(*CreateBucketRequest)(nil),                 // 4: yandex.cloud.storage.v1.CreateBucketRequest
	(*CreateBucketMetadata)(nil),                // 5: yandex.cloud.storage.v1.CreateBucketMetadata
	(*UpdateBucketRequest)(nil),                 // 6: yandex.cloud.storage.v1.UpdateBucketRequest
	(*UpdateBucketMetadata)(nil),                // 7: yandex.cloud.storage.v1.UpdateBucketMetadata
	(*DeleteBucketRequest)(nil),                 // 8: yandex.cloud.storage.v1.DeleteBucketRequest
	(*DeleteBucketMetadata)(nil),                // 9: yandex.cloud.storage.v1.DeleteBucketMetadata
	(*GetBucketStatsRequest)(nil),               // 10: yandex.cloud.storage.v1.GetBucketStatsRequest
	(*GetBucketHTTPSConfigRequest)(nil),         // 11: yandex.cloud.storage.v1.GetBucketHTTPSConfigRequest
	(*SelfManagedHTTPSConfigParams)(nil),        // 12: yandex.cloud.storage.v1.SelfManagedHTTPSConfigParams
	(*CertificateManagerHTTPSConfigParams)(nil), // 13: yandex.cloud.storage.v1.CertificateManagerHTTPSConfigParams
	(*SetBucketHTTPSConfigRequest)(nil),         // 14: yandex.cloud.storage.v1.SetBucketHTTPSConfigRequest
	(*SetBucketHTTPSConfigMetadata)(nil),        // 15: yandex.cloud.storage.v1.SetBucketHTTPSConfigMetadata
	(*DeleteBucketHTTPSConfigRequest)(nil),      // 16: yandex.cloud.storage.v1.DeleteBucketHTTPSConfigRequest
	(*DeleteBucketHTTPSConfigMetadata)(nil),     // 17: yandex.cloud.storage.v1.DeleteBucketHTTPSConfigMetadata
	(*Bucket)(nil),                              // 18: yandex.cloud.storage.v1.Bucket
	(*AnonymousAccessFlags)(nil),                // 19: yandex.cloud.storage.v1.AnonymousAccessFlags
	(*ACL)(nil),                                 // 20: yandex.cloud.storage.v1.ACL
	(*Tag)(nil),                                 // 21: yandex.cloud.storage.v1.Tag
	(*fieldmaskpb.FieldMask)(nil),               // 22: google.protobuf.FieldMask
	(*CorsRule)(nil),                            // 23: yandex.cloud.storage.v1.CorsRule
	(*WebsiteSettings)(nil),                     // 24: yandex.cloud.storage.v1.WebsiteSettings
	(Versioning)(0),                             // 25: yandex.cloud.storage.v1.Versioning
	(*LifecycleRule)(nil),                       // 26: yandex.cloud.storage.v1.LifecycleRule
	(*structpb.Struct)(nil),                     // 27: google.protobuf.Struct
	(*ObjectLock)(nil),                          // 28: yandex.cloud.storage.v1.ObjectLock
	(*Encryption)(nil),                          // 29: yandex.cloud.storage.v1.Encryption
	(*operation.Operation)(nil),                 // 30: yandex.cloud.operation.Operation
	(*BucketStats)(nil),                         // 31: yandex.cloud.storage.v1.BucketStats
	(*HTTPSConfig)(nil),                         // 32: yandex.cloud.storage.v1.HTTPSConfig
}
var file_yandex_cloud_storage_v1_bucket_service_proto_depIdxs = []int32{
	0,  // 0: yandex.cloud.storage.v1.GetBucketRequest.view:type_name -> yandex.cloud.storage.v1.GetBucketRequest.View
	18, // 1: yandex.cloud.storage.v1.ListBucketsResponse.buckets:type_name -> yandex.cloud.storage.v1.Bucket
	19, // 2: yandex.cloud.storage.v1.CreateBucketRequest.anonymous_access_flags:type_name -> yandex.cloud.storage.v1.AnonymousAccessFlags
	20, // 3: yandex.cloud.storage.v1.CreateBucketRequest.acl:type_name -> yandex.cloud.storage.v1.ACL
	21, // 4: yandex.cloud.storage.v1.CreateBucketRequest.tags:type_name -> yandex.cloud.storage.v1.Tag
	22, // 5: yandex.cloud.storage.v1.UpdateBucketRequest.update_mask:type_name -> google.protobuf.FieldMask
	19, // 6: yandex.cloud.storage.v1.UpdateBucketRequest.anonymous_access_flags:type_name -> yandex.cloud.storage.v1.AnonymousAccessFlags
	23, // 7: yandex.cloud.storage.v1.UpdateBucketRequest.cors:type_name -> yandex.cloud.storage.v1.CorsRule
	24, // 8: yandex.cloud.storage.v1.UpdateBucketRequest.website_settings:type_name -> yandex.cloud.storage.v1.WebsiteSettings
	25, // 9: yandex.cloud.storage.v1.UpdateBucketRequest.versioning:type_name -> yandex.cloud.storage.v1.Versioning
	26, // 10: yandex.cloud.storage.v1.UpdateBucketRequest.lifecycle_rules:type_name -> yandex.cloud.storage.v1.LifecycleRule
	27, // 11: yandex.cloud.storage.v1.UpdateBucketRequest.policy:type_name -> google.protobuf.Struct
	20, // 12: yandex.cloud.storage.v1.UpdateBucketRequest.acl:type_name -> yandex.cloud.storage.v1.ACL
	21, // 13: yandex.cloud.storage.v1.UpdateBucketRequest.tags:type_name -> yandex.cloud.storage.v1.Tag
	28, // 14: yandex.cloud.storage.v1.UpdateBucketRequest.object_lock:type_name -> yandex.cloud.storage.v1.ObjectLock
	29, // 15: yandex.cloud.storage.v1.UpdateBucketRequest.encryption:type_name -> yandex.cloud.storage.v1.Encryption
	12, // 16: yandex.cloud.storage.v1.SetBucketHTTPSConfigRequest.self_managed:type_name -> yandex.cloud.storage.v1.SelfManagedHTTPSConfigParams
	13, // 17: yandex.cloud.storage.v1.SetBucketHTTPSConfigRequest.certificate_manager:type_name -> yandex.cloud.storage.v1.CertificateManagerHTTPSConfigParams
	2,  // 18: yandex.cloud.storage.v1.BucketService.List:input_type -> yandex.cloud.storage.v1.ListBucketsRequest
	1,  // 19: yandex.cloud.storage.v1.BucketService.Get:input_type -> yandex.cloud.storage.v1.GetBucketRequest
	4,  // 20: yandex.cloud.storage.v1.BucketService.Create:input_type -> yandex.cloud.storage.v1.CreateBucketRequest
	6,  // 21: yandex.cloud.storage.v1.BucketService.Update:input_type -> yandex.cloud.storage.v1.UpdateBucketRequest
	8,  // 22: yandex.cloud.storage.v1.BucketService.Delete:input_type -> yandex.cloud.storage.v1.DeleteBucketRequest
	10, // 23: yandex.cloud.storage.v1.BucketService.GetStats:input_type -> yandex.cloud.storage.v1.GetBucketStatsRequest
	11, // 24: yandex.cloud.storage.v1.BucketService.GetHTTPSConfig:input_type -> yandex.cloud.storage.v1.GetBucketHTTPSConfigRequest
	14, // 25: yandex.cloud.storage.v1.BucketService.SetHTTPSConfig:input_type -> yandex.cloud.storage.v1.SetBucketHTTPSConfigRequest
	16, // 26: yandex.cloud.storage.v1.BucketService.DeleteHTTPSConfig:input_type -> yandex.cloud.storage.v1.DeleteBucketHTTPSConfigRequest
	3,  // 27: yandex.cloud.storage.v1.BucketService.List:output_type -> yandex.cloud.storage.v1.ListBucketsResponse
	18, // 28: yandex.cloud.storage.v1.BucketService.Get:output_type -> yandex.cloud.storage.v1.Bucket
	30, // 29: yandex.cloud.storage.v1.BucketService.Create:output_type -> yandex.cloud.operation.Operation
	30, // 30: yandex.cloud.storage.v1.BucketService.Update:output_type -> yandex.cloud.operation.Operation
	30, // 31: yandex.cloud.storage.v1.BucketService.Delete:output_type -> yandex.cloud.operation.Operation
	31, // 32: yandex.cloud.storage.v1.BucketService.GetStats:output_type -> yandex.cloud.storage.v1.BucketStats
	32, // 33: yandex.cloud.storage.v1.BucketService.GetHTTPSConfig:output_type -> yandex.cloud.storage.v1.HTTPSConfig
	30, // 34: yandex.cloud.storage.v1.BucketService.SetHTTPSConfig:output_type -> yandex.cloud.operation.Operation
	30, // 35: yandex.cloud.storage.v1.BucketService.DeleteHTTPSConfig:output_type -> yandex.cloud.operation.Operation
	27, // [27:36] is the sub-list for method output_type
	18, // [18:27] is the sub-list for method input_type
	18, // [18:18] is the sub-list for extension type_name
	18, // [18:18] is the sub-list for extension extendee
	0,  // [0:18] is the sub-list for field type_name
}

func init() { file_yandex_cloud_storage_v1_bucket_service_proto_init() }
func file_yandex_cloud_storage_v1_bucket_service_proto_init() {
	if File_yandex_cloud_storage_v1_bucket_service_proto != nil {
		return
	}
	file_yandex_cloud_storage_v1_bucket_proto_init()
	if !protoimpl.UnsafeEnabled {
		file_yandex_cloud_storage_v1_bucket_service_proto_msgTypes[0].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*GetBucketRequest); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_yandex_cloud_storage_v1_bucket_service_proto_msgTypes[1].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*ListBucketsRequest); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_yandex_cloud_storage_v1_bucket_service_proto_msgTypes[2].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*ListBucketsResponse); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_yandex_cloud_storage_v1_bucket_service_proto_msgTypes[3].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*CreateBucketRequest); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_yandex_cloud_storage_v1_bucket_service_proto_msgTypes[4].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*CreateBucketMetadata); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_yandex_cloud_storage_v1_bucket_service_proto_msgTypes[5].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*UpdateBucketRequest); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_yandex_cloud_storage_v1_bucket_service_proto_msgTypes[6].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*UpdateBucketMetadata); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_yandex_cloud_storage_v1_bucket_service_proto_msgTypes[7].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*DeleteBucketRequest); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_yandex_cloud_storage_v1_bucket_service_proto_msgTypes[8].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*DeleteBucketMetadata); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_yandex_cloud_storage_v1_bucket_service_proto_msgTypes[9].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*GetBucketStatsRequest); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_yandex_cloud_storage_v1_bucket_service_proto_msgTypes[10].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*GetBucketHTTPSConfigRequest); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_yandex_cloud_storage_v1_bucket_service_proto_msgTypes[11].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*SelfManagedHTTPSConfigParams); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_yandex_cloud_storage_v1_bucket_service_proto_msgTypes[12].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*CertificateManagerHTTPSConfigParams); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_yandex_cloud_storage_v1_bucket_service_proto_msgTypes[13].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*SetBucketHTTPSConfigRequest); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_yandex_cloud_storage_v1_bucket_service_proto_msgTypes[14].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*SetBucketHTTPSConfigMetadata); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_yandex_cloud_storage_v1_bucket_service_proto_msgTypes[15].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*DeleteBucketHTTPSConfigRequest); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_yandex_cloud_storage_v1_bucket_service_proto_msgTypes[16].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*DeleteBucketHTTPSConfigMetadata); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
	}
	file_yandex_cloud_storage_v1_bucket_service_proto_msgTypes[13].OneofWrappers = []interface{}{
		(*SetBucketHTTPSConfigRequest_SelfManaged)(nil),
		(*SetBucketHTTPSConfigRequest_CertificateManager)(nil),
	}
	type x struct{}
	out := protoimpl.TypeBuilder{
		File: protoimpl.DescBuilder{
			GoPackagePath: reflect.TypeOf(x{}).PkgPath(),
			RawDescriptor: file_yandex_cloud_storage_v1_bucket_service_proto_rawDesc,
			NumEnums:      1,
			NumMessages:   17,
			NumExtensions: 0,
			NumServices:   1,
		},
		GoTypes:           file_yandex_cloud_storage_v1_bucket_service_proto_goTypes,
		DependencyIndexes: file_yandex_cloud_storage_v1_bucket_service_proto_depIdxs,
		EnumInfos:         file_yandex_cloud_storage_v1_bucket_service_proto_enumTypes,
		MessageInfos:      file_yandex_cloud_storage_v1_bucket_service_proto_msgTypes,
	}.Build()
	File_yandex_cloud_storage_v1_bucket_service_proto = out.File
	file_yandex_cloud_storage_v1_bucket_service_proto_rawDesc = nil
	file_yandex_cloud_storage_v1_bucket_service_proto_goTypes = nil
	file_yandex_cloud_storage_v1_bucket_service_proto_depIdxs = nil
}
