// Code generated by protoc-gen-go-grpc. DO NOT EDIT.
// versions:
// - protoc-gen-go-grpc v1.3.0
// - protoc             v3.17.3
// source: yandex/cloud/vpc/v1/subnet_service.proto

package vpc

import (
	context "context"
	operation "github.com/yandex-cloud/go-genproto/yandex/cloud/operation"
	grpc "google.golang.org/grpc"
	codes "google.golang.org/grpc/codes"
	status "google.golang.org/grpc/status"
)

// This is a compile-time assertion to ensure that this generated file
// is compatible with the grpc package it is being compiled against.
// Requires gRPC-Go v1.32.0 or later.
const _ = grpc.SupportPackageIsVersion7

const (
	SubnetService_Get_FullMethodName               = "/yandex.cloud.vpc.v1.SubnetService/Get"
	SubnetService_List_FullMethodName              = "/yandex.cloud.vpc.v1.SubnetService/List"
	SubnetService_Create_FullMethodName            = "/yandex.cloud.vpc.v1.SubnetService/Create"
	SubnetService_Update_FullMethodName            = "/yandex.cloud.vpc.v1.SubnetService/Update"
	SubnetService_AddCidrBlocks_FullMethodName     = "/yandex.cloud.vpc.v1.SubnetService/AddCidrBlocks"
	SubnetService_RemoveCidrBlocks_FullMethodName  = "/yandex.cloud.vpc.v1.SubnetService/RemoveCidrBlocks"
	SubnetService_Delete_FullMethodName            = "/yandex.cloud.vpc.v1.SubnetService/Delete"
	SubnetService_ListOperations_FullMethodName    = "/yandex.cloud.vpc.v1.SubnetService/ListOperations"
	SubnetService_Move_FullMethodName              = "/yandex.cloud.vpc.v1.SubnetService/Move"
	SubnetService_ListUsedAddresses_FullMethodName = "/yandex.cloud.vpc.v1.SubnetService/ListUsedAddresses"
)

// SubnetServiceClient is the client API for SubnetService service.
//
// For semantics around ctx use and closing/ending streaming RPCs, please refer to https://pkg.go.dev/google.golang.org/grpc/?tab=doc#ClientConn.NewStream.
type SubnetServiceClient interface {
	// Returns the specified Subnet resource.
	//
	// To get the list of available Subnet resources, make a [List] request.
	Get(ctx context.Context, in *GetSubnetRequest, opts ...grpc.CallOption) (*Subnet, error)
	// Retrieves the list of Subnet resources in the specified folder.
	List(ctx context.Context, in *ListSubnetsRequest, opts ...grpc.CallOption) (*ListSubnetsResponse, error)
	// Creates a subnet in the specified folder and network.
	// Method starts an asynchronous operation that can be cancelled while it is in progress.
	Create(ctx context.Context, in *CreateSubnetRequest, opts ...grpc.CallOption) (*operation.Operation, error)
	// Updates the specified subnet.
	// Method starts an asynchronous operation that can be cancelled while it is in progress.
	Update(ctx context.Context, in *UpdateSubnetRequest, opts ...grpc.CallOption) (*operation.Operation, error)
	// Adds CIDR blocks to the specified subnet.
	// Method starts an asynchronous operation that can be cancelled while it is in progress.
	AddCidrBlocks(ctx context.Context, in *AddSubnetCidrBlocksRequest, opts ...grpc.CallOption) (*operation.Operation, error)
	// Removes CIDR blocks from the specified subnet.
	// Method starts an asynchronous operation that can be cancelled while it is in progress.
	RemoveCidrBlocks(ctx context.Context, in *RemoveSubnetCidrBlocksRequest, opts ...grpc.CallOption) (*operation.Operation, error)
	// Deletes the specified subnet.
	Delete(ctx context.Context, in *DeleteSubnetRequest, opts ...grpc.CallOption) (*operation.Operation, error)
	// List operations for the specified subnet.
	ListOperations(ctx context.Context, in *ListSubnetOperationsRequest, opts ...grpc.CallOption) (*ListSubnetOperationsResponse, error)
	// Move subnet to another folder.
	Move(ctx context.Context, in *MoveSubnetRequest, opts ...grpc.CallOption) (*operation.Operation, error)
	// List used addresses in specified subnet.
	ListUsedAddresses(ctx context.Context, in *ListUsedAddressesRequest, opts ...grpc.CallOption) (*ListUsedAddressesResponse, error)
}

type subnetServiceClient struct {
	cc grpc.ClientConnInterface
}

func NewSubnetServiceClient(cc grpc.ClientConnInterface) SubnetServiceClient {
	return &subnetServiceClient{cc}
}

func (c *subnetServiceClient) Get(ctx context.Context, in *GetSubnetRequest, opts ...grpc.CallOption) (*Subnet, error) {
	out := new(Subnet)
	err := c.cc.Invoke(ctx, SubnetService_Get_FullMethodName, in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *subnetServiceClient) List(ctx context.Context, in *ListSubnetsRequest, opts ...grpc.CallOption) (*ListSubnetsResponse, error) {
	out := new(ListSubnetsResponse)
	err := c.cc.Invoke(ctx, SubnetService_List_FullMethodName, in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *subnetServiceClient) Create(ctx context.Context, in *CreateSubnetRequest, opts ...grpc.CallOption) (*operation.Operation, error) {
	out := new(operation.Operation)
	err := c.cc.Invoke(ctx, SubnetService_Create_FullMethodName, in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *subnetServiceClient) Update(ctx context.Context, in *UpdateSubnetRequest, opts ...grpc.CallOption) (*operation.Operation, error) {
	out := new(operation.Operation)
	err := c.cc.Invoke(ctx, SubnetService_Update_FullMethodName, in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *subnetServiceClient) AddCidrBlocks(ctx context.Context, in *AddSubnetCidrBlocksRequest, opts ...grpc.CallOption) (*operation.Operation, error) {
	out := new(operation.Operation)
	err := c.cc.Invoke(ctx, SubnetService_AddCidrBlocks_FullMethodName, in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *subnetServiceClient) RemoveCidrBlocks(ctx context.Context, in *RemoveSubnetCidrBlocksRequest, opts ...grpc.CallOption) (*operation.Operation, error) {
	out := new(operation.Operation)
	err := c.cc.Invoke(ctx, SubnetService_RemoveCidrBlocks_FullMethodName, in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *subnetServiceClient) Delete(ctx context.Context, in *DeleteSubnetRequest, opts ...grpc.CallOption) (*operation.Operation, error) {
	out := new(operation.Operation)
	err := c.cc.Invoke(ctx, SubnetService_Delete_FullMethodName, in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *subnetServiceClient) ListOperations(ctx context.Context, in *ListSubnetOperationsRequest, opts ...grpc.CallOption) (*ListSubnetOperationsResponse, error) {
	out := new(ListSubnetOperationsResponse)
	err := c.cc.Invoke(ctx, SubnetService_ListOperations_FullMethodName, in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *subnetServiceClient) Move(ctx context.Context, in *MoveSubnetRequest, opts ...grpc.CallOption) (*operation.Operation, error) {
	out := new(operation.Operation)
	err := c.cc.Invoke(ctx, SubnetService_Move_FullMethodName, in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *subnetServiceClient) ListUsedAddresses(ctx context.Context, in *ListUsedAddressesRequest, opts ...grpc.CallOption) (*ListUsedAddressesResponse, error) {
	out := new(ListUsedAddressesResponse)
	err := c.cc.Invoke(ctx, SubnetService_ListUsedAddresses_FullMethodName, in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

// SubnetServiceServer is the server API for SubnetService service.
// All implementations should embed UnimplementedSubnetServiceServer
// for forward compatibility
type SubnetServiceServer interface {
	// Returns the specified Subnet resource.
	//
	// To get the list of available Subnet resources, make a [List] request.
	Get(context.Context, *GetSubnetRequest) (*Subnet, error)
	// Retrieves the list of Subnet resources in the specified folder.
	List(context.Context, *ListSubnetsRequest) (*ListSubnetsResponse, error)
	// Creates a subnet in the specified folder and network.
	// Method starts an asynchronous operation that can be cancelled while it is in progress.
	Create(context.Context, *CreateSubnetRequest) (*operation.Operation, error)
	// Updates the specified subnet.
	// Method starts an asynchronous operation that can be cancelled while it is in progress.
	Update(context.Context, *UpdateSubnetRequest) (*operation.Operation, error)
	// Adds CIDR blocks to the specified subnet.
	// Method starts an asynchronous operation that can be cancelled while it is in progress.
	AddCidrBlocks(context.Context, *AddSubnetCidrBlocksRequest) (*operation.Operation, error)
	// Removes CIDR blocks from the specified subnet.
	// Method starts an asynchronous operation that can be cancelled while it is in progress.
	RemoveCidrBlocks(context.Context, *RemoveSubnetCidrBlocksRequest) (*operation.Operation, error)
	// Deletes the specified subnet.
	Delete(context.Context, *DeleteSubnetRequest) (*operation.Operation, error)
	// List operations for the specified subnet.
	ListOperations(context.Context, *ListSubnetOperationsRequest) (*ListSubnetOperationsResponse, error)
	// Move subnet to another folder.
	Move(context.Context, *MoveSubnetRequest) (*operation.Operation, error)
	// List used addresses in specified subnet.
	ListUsedAddresses(context.Context, *ListUsedAddressesRequest) (*ListUsedAddressesResponse, error)
}

// UnimplementedSubnetServiceServer should be embedded to have forward compatible implementations.
type UnimplementedSubnetServiceServer struct {
}

func (UnimplementedSubnetServiceServer) Get(context.Context, *GetSubnetRequest) (*Subnet, error) {
	return nil, status.Errorf(codes.Unimplemented, "method Get not implemented")
}
func (UnimplementedSubnetServiceServer) List(context.Context, *ListSubnetsRequest) (*ListSubnetsResponse, error) {
	return nil, status.Errorf(codes.Unimplemented, "method List not implemented")
}
func (UnimplementedSubnetServiceServer) Create(context.Context, *CreateSubnetRequest) (*operation.Operation, error) {
	return nil, status.Errorf(codes.Unimplemented, "method Create not implemented")
}
func (UnimplementedSubnetServiceServer) Update(context.Context, *UpdateSubnetRequest) (*operation.Operation, error) {
	return nil, status.Errorf(codes.Unimplemented, "method Update not implemented")
}
func (UnimplementedSubnetServiceServer) AddCidrBlocks(context.Context, *AddSubnetCidrBlocksRequest) (*operation.Operation, error) {
	return nil, status.Errorf(codes.Unimplemented, "method AddCidrBlocks not implemented")
}
func (UnimplementedSubnetServiceServer) RemoveCidrBlocks(context.Context, *RemoveSubnetCidrBlocksRequest) (*operation.Operation, error) {
	return nil, status.Errorf(codes.Unimplemented, "method RemoveCidrBlocks not implemented")
}
func (UnimplementedSubnetServiceServer) Delete(context.Context, *DeleteSubnetRequest) (*operation.Operation, error) {
	return nil, status.Errorf(codes.Unimplemented, "method Delete not implemented")
}
func (UnimplementedSubnetServiceServer) ListOperations(context.Context, *ListSubnetOperationsRequest) (*ListSubnetOperationsResponse, error) {
	return nil, status.Errorf(codes.Unimplemented, "method ListOperations not implemented")
}
func (UnimplementedSubnetServiceServer) Move(context.Context, *MoveSubnetRequest) (*operation.Operation, error) {
	return nil, status.Errorf(codes.Unimplemented, "method Move not implemented")
}
func (UnimplementedSubnetServiceServer) ListUsedAddresses(context.Context, *ListUsedAddressesRequest) (*ListUsedAddressesResponse, error) {
	return nil, status.Errorf(codes.Unimplemented, "method ListUsedAddresses not implemented")
}

// UnsafeSubnetServiceServer may be embedded to opt out of forward compatibility for this service.
// Use of this interface is not recommended, as added methods to SubnetServiceServer will
// result in compilation errors.
type UnsafeSubnetServiceServer interface {
	mustEmbedUnimplementedSubnetServiceServer()
}

func RegisterSubnetServiceServer(s grpc.ServiceRegistrar, srv SubnetServiceServer) {
	s.RegisterService(&SubnetService_ServiceDesc, srv)
}

func _SubnetService_Get_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(GetSubnetRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(SubnetServiceServer).Get(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: SubnetService_Get_FullMethodName,
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(SubnetServiceServer).Get(ctx, req.(*GetSubnetRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _SubnetService_List_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(ListSubnetsRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(SubnetServiceServer).List(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: SubnetService_List_FullMethodName,
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(SubnetServiceServer).List(ctx, req.(*ListSubnetsRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _SubnetService_Create_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(CreateSubnetRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(SubnetServiceServer).Create(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: SubnetService_Create_FullMethodName,
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(SubnetServiceServer).Create(ctx, req.(*CreateSubnetRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _SubnetService_Update_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(UpdateSubnetRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(SubnetServiceServer).Update(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: SubnetService_Update_FullMethodName,
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(SubnetServiceServer).Update(ctx, req.(*UpdateSubnetRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _SubnetService_AddCidrBlocks_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(AddSubnetCidrBlocksRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(SubnetServiceServer).AddCidrBlocks(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: SubnetService_AddCidrBlocks_FullMethodName,
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(SubnetServiceServer).AddCidrBlocks(ctx, req.(*AddSubnetCidrBlocksRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _SubnetService_RemoveCidrBlocks_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(RemoveSubnetCidrBlocksRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(SubnetServiceServer).RemoveCidrBlocks(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: SubnetService_RemoveCidrBlocks_FullMethodName,
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(SubnetServiceServer).RemoveCidrBlocks(ctx, req.(*RemoveSubnetCidrBlocksRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _SubnetService_Delete_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(DeleteSubnetRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(SubnetServiceServer).Delete(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: SubnetService_Delete_FullMethodName,
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(SubnetServiceServer).Delete(ctx, req.(*DeleteSubnetRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _SubnetService_ListOperations_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(ListSubnetOperationsRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(SubnetServiceServer).ListOperations(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: SubnetService_ListOperations_FullMethodName,
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(SubnetServiceServer).ListOperations(ctx, req.(*ListSubnetOperationsRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _SubnetService_Move_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(MoveSubnetRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(SubnetServiceServer).Move(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: SubnetService_Move_FullMethodName,
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(SubnetServiceServer).Move(ctx, req.(*MoveSubnetRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _SubnetService_ListUsedAddresses_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(ListUsedAddressesRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(SubnetServiceServer).ListUsedAddresses(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: SubnetService_ListUsedAddresses_FullMethodName,
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(SubnetServiceServer).ListUsedAddresses(ctx, req.(*ListUsedAddressesRequest))
	}
	return interceptor(ctx, in, info, handler)
}

// SubnetService_ServiceDesc is the grpc.ServiceDesc for SubnetService service.
// It's only intended for direct use with grpc.RegisterService,
// and not to be introspected or modified (even as a copy)
var SubnetService_ServiceDesc = grpc.ServiceDesc{
	ServiceName: "yandex.cloud.vpc.v1.SubnetService",
	HandlerType: (*SubnetServiceServer)(nil),
	Methods: []grpc.MethodDesc{
		{
			MethodName: "Get",
			Handler:    _SubnetService_Get_Handler,
		},
		{
			MethodName: "List",
			Handler:    _SubnetService_List_Handler,
		},
		{
			MethodName: "Create",
			Handler:    _SubnetService_Create_Handler,
		},
		{
			MethodName: "Update",
			Handler:    _SubnetService_Update_Handler,
		},
		{
			MethodName: "AddCidrBlocks",
			Handler:    _SubnetService_AddCidrBlocks_Handler,
		},
		{
			MethodName: "RemoveCidrBlocks",
			Handler:    _SubnetService_RemoveCidrBlocks_Handler,
		},
		{
			MethodName: "Delete",
			Handler:    _SubnetService_Delete_Handler,
		},
		{
			MethodName: "ListOperations",
			Handler:    _SubnetService_ListOperations_Handler,
		},
		{
			MethodName: "Move",
			Handler:    _SubnetService_Move_Handler,
		},
		{
			MethodName: "ListUsedAddresses",
			Handler:    _SubnetService_ListUsedAddresses_Handler,
		},
	},
	Streams:  []grpc.StreamDesc{},
	Metadata: "yandex/cloud/vpc/v1/subnet_service.proto",
}
