// Code generated by sdkgen. DO NOT EDIT.

// nolint
package billing

import (
	"context"

	"google.golang.org/grpc"

	billing "github.com/yandex-cloud/go-genproto/yandex/cloud/billing/v1"
	"github.com/yandex-cloud/go-genproto/yandex/cloud/operation"
)

//revive:disable

// BudgetServiceClient is a billing.BudgetServiceClient with
// lazy GRPC connection initialization.
type BudgetServiceClient struct {
	getConn func(ctx context.Context) (*grpc.ClientConn, error)
}

// Create implements billing.BudgetServiceClient
func (c *BudgetServiceClient) Create(ctx context.Context, in *billing.CreateBudgetRequest, opts ...grpc.CallOption) (*operation.Operation, error) {
	conn, err := c.getConn(ctx)
	if err != nil {
		return nil, err
	}
	return billing.NewBudgetServiceClient(conn).Create(ctx, in, opts...)
}

// Get implements billing.BudgetServiceClient
func (c *BudgetServiceClient) Get(ctx context.Context, in *billing.GetBudgetRequest, opts ...grpc.CallOption) (*billing.Budget, error) {
	conn, err := c.getConn(ctx)
	if err != nil {
		return nil, err
	}
	return billing.NewBudgetServiceClient(conn).Get(ctx, in, opts...)
}

// List implements billing.BudgetServiceClient
func (c *BudgetServiceClient) List(ctx context.Context, in *billing.ListBudgetsRequest, opts ...grpc.CallOption) (*billing.ListBudgetsResponse, error) {
	conn, err := c.getConn(ctx)
	if err != nil {
		return nil, err
	}
	return billing.NewBudgetServiceClient(conn).List(ctx, in, opts...)
}

type BudgetIterator struct {
	ctx  context.Context
	opts []grpc.CallOption

	err           error
	started       bool
	requestedSize int64
	pageSize      int64

	client  *BudgetServiceClient
	request *billing.ListBudgetsRequest

	items []*billing.Budget
}

func (c *BudgetServiceClient) BudgetIterator(ctx context.Context, req *billing.ListBudgetsRequest, opts ...grpc.CallOption) *BudgetIterator {
	var pageSize int64
	const defaultPageSize = 1000
	pageSize = req.PageSize
	if pageSize == 0 {
		pageSize = defaultPageSize
	}
	return &BudgetIterator{
		ctx:      ctx,
		opts:     opts,
		client:   c,
		request:  req,
		pageSize: pageSize,
	}
}

func (it *BudgetIterator) Next() bool {
	if it.err != nil {
		return false
	}
	if len(it.items) > 1 {
		it.items[0] = nil
		it.items = it.items[1:]
		return true
	}
	it.items = nil // consume last item, if any

	if it.started && it.request.PageToken == "" {
		return false
	}
	it.started = true

	if it.requestedSize == 0 || it.requestedSize > it.pageSize {
		it.request.PageSize = it.pageSize
	} else {
		it.request.PageSize = it.requestedSize
	}

	response, err := it.client.List(it.ctx, it.request, it.opts...)
	it.err = err
	if err != nil {
		return false
	}

	it.items = response.Budgets
	it.request.PageToken = response.NextPageToken
	return len(it.items) > 0
}

func (it *BudgetIterator) Take(size int64) ([]*billing.Budget, error) {
	if it.err != nil {
		return nil, it.err
	}

	if size == 0 {
		size = 1 << 32 // something insanely large
	}
	it.requestedSize = size
	defer func() {
		// reset iterator for future calls.
		it.requestedSize = 0
	}()

	var result []*billing.Budget

	for it.requestedSize > 0 && it.Next() {
		it.requestedSize--
		result = append(result, it.Value())
	}

	if it.err != nil {
		return nil, it.err
	}

	return result, nil
}

func (it *BudgetIterator) TakeAll() ([]*billing.Budget, error) {
	return it.Take(0)
}

func (it *BudgetIterator) Value() *billing.Budget {
	if len(it.items) == 0 {
		panic("calling Value on empty iterator")
	}
	return it.items[0]
}

func (it *BudgetIterator) Error() error {
	return it.err
}
