// Code generated by sdkgen. DO NOT EDIT.

// nolint
package compute

import (
	"context"

	"google.golang.org/grpc"

	compute "github.com/yandex-cloud/go-genproto/yandex/cloud/compute/v1"
	"github.com/yandex-cloud/go-genproto/yandex/cloud/operation"
)

//revive:disable

// DiskServiceClient is a compute.DiskServiceClient with
// lazy GRPC connection initialization.
type DiskServiceClient struct {
	getConn func(ctx context.Context) (*grpc.ClientConn, error)
}

// Create implements compute.DiskServiceClient
func (c *DiskServiceClient) Create(ctx context.Context, in *compute.CreateDiskRequest, opts ...grpc.CallOption) (*operation.Operation, error) {
	conn, err := c.getConn(ctx)
	if err != nil {
		return nil, err
	}
	return compute.NewDiskServiceClient(conn).Create(ctx, in, opts...)
}

// Delete implements compute.DiskServiceClient
func (c *DiskServiceClient) Delete(ctx context.Context, in *compute.DeleteDiskRequest, opts ...grpc.CallOption) (*operation.Operation, error) {
	conn, err := c.getConn(ctx)
	if err != nil {
		return nil, err
	}
	return compute.NewDiskServiceClient(conn).Delete(ctx, in, opts...)
}

// Get implements compute.DiskServiceClient
func (c *DiskServiceClient) Get(ctx context.Context, in *compute.GetDiskRequest, opts ...grpc.CallOption) (*compute.Disk, error) {
	conn, err := c.getConn(ctx)
	if err != nil {
		return nil, err
	}
	return compute.NewDiskServiceClient(conn).Get(ctx, in, opts...)
}

// List implements compute.DiskServiceClient
func (c *DiskServiceClient) List(ctx context.Context, in *compute.ListDisksRequest, opts ...grpc.CallOption) (*compute.ListDisksResponse, error) {
	conn, err := c.getConn(ctx)
	if err != nil {
		return nil, err
	}
	return compute.NewDiskServiceClient(conn).List(ctx, in, opts...)
}

type DiskIterator struct {
	ctx  context.Context
	opts []grpc.CallOption

	err           error
	started       bool
	requestedSize int64
	pageSize      int64

	client  *DiskServiceClient
	request *compute.ListDisksRequest

	items []*compute.Disk
}

func (c *DiskServiceClient) DiskIterator(ctx context.Context, req *compute.ListDisksRequest, opts ...grpc.CallOption) *DiskIterator {
	var pageSize int64
	const defaultPageSize = 1000
	pageSize = req.PageSize
	if pageSize == 0 {
		pageSize = defaultPageSize
	}
	return &DiskIterator{
		ctx:      ctx,
		opts:     opts,
		client:   c,
		request:  req,
		pageSize: pageSize,
	}
}

func (it *DiskIterator) Next() bool {
	if it.err != nil {
		return false
	}
	if len(it.items) > 1 {
		it.items[0] = nil
		it.items = it.items[1:]
		return true
	}
	it.items = nil // consume last item, if any

	if it.started && it.request.PageToken == "" {
		return false
	}
	it.started = true

	if it.requestedSize == 0 || it.requestedSize > it.pageSize {
		it.request.PageSize = it.pageSize
	} else {
		it.request.PageSize = it.requestedSize
	}

	response, err := it.client.List(it.ctx, it.request, it.opts...)
	it.err = err
	if err != nil {
		return false
	}

	it.items = response.Disks
	it.request.PageToken = response.NextPageToken
	return len(it.items) > 0
}

func (it *DiskIterator) Take(size int64) ([]*compute.Disk, error) {
	if it.err != nil {
		return nil, it.err
	}

	if size == 0 {
		size = 1 << 32 // something insanely large
	}
	it.requestedSize = size
	defer func() {
		// reset iterator for future calls.
		it.requestedSize = 0
	}()

	var result []*compute.Disk

	for it.requestedSize > 0 && it.Next() {
		it.requestedSize--
		result = append(result, it.Value())
	}

	if it.err != nil {
		return nil, it.err
	}

	return result, nil
}

func (it *DiskIterator) TakeAll() ([]*compute.Disk, error) {
	return it.Take(0)
}

func (it *DiskIterator) Value() *compute.Disk {
	if len(it.items) == 0 {
		panic("calling Value on empty iterator")
	}
	return it.items[0]
}

func (it *DiskIterator) Error() error {
	return it.err
}

// ListOperations implements compute.DiskServiceClient
func (c *DiskServiceClient) ListOperations(ctx context.Context, in *compute.ListDiskOperationsRequest, opts ...grpc.CallOption) (*compute.ListDiskOperationsResponse, error) {
	conn, err := c.getConn(ctx)
	if err != nil {
		return nil, err
	}
	return compute.NewDiskServiceClient(conn).ListOperations(ctx, in, opts...)
}

type DiskOperationsIterator struct {
	ctx  context.Context
	opts []grpc.CallOption

	err           error
	started       bool
	requestedSize int64
	pageSize      int64

	client  *DiskServiceClient
	request *compute.ListDiskOperationsRequest

	items []*operation.Operation
}

func (c *DiskServiceClient) DiskOperationsIterator(ctx context.Context, req *compute.ListDiskOperationsRequest, opts ...grpc.CallOption) *DiskOperationsIterator {
	var pageSize int64
	const defaultPageSize = 1000
	pageSize = req.PageSize
	if pageSize == 0 {
		pageSize = defaultPageSize
	}
	return &DiskOperationsIterator{
		ctx:      ctx,
		opts:     opts,
		client:   c,
		request:  req,
		pageSize: pageSize,
	}
}

func (it *DiskOperationsIterator) Next() bool {
	if it.err != nil {
		return false
	}
	if len(it.items) > 1 {
		it.items[0] = nil
		it.items = it.items[1:]
		return true
	}
	it.items = nil // consume last item, if any

	if it.started && it.request.PageToken == "" {
		return false
	}
	it.started = true

	if it.requestedSize == 0 || it.requestedSize > it.pageSize {
		it.request.PageSize = it.pageSize
	} else {
		it.request.PageSize = it.requestedSize
	}

	response, err := it.client.ListOperations(it.ctx, it.request, it.opts...)
	it.err = err
	if err != nil {
		return false
	}

	it.items = response.Operations
	it.request.PageToken = response.NextPageToken
	return len(it.items) > 0
}

func (it *DiskOperationsIterator) Take(size int64) ([]*operation.Operation, error) {
	if it.err != nil {
		return nil, it.err
	}

	if size == 0 {
		size = 1 << 32 // something insanely large
	}
	it.requestedSize = size
	defer func() {
		// reset iterator for future calls.
		it.requestedSize = 0
	}()

	var result []*operation.Operation

	for it.requestedSize > 0 && it.Next() {
		it.requestedSize--
		result = append(result, it.Value())
	}

	if it.err != nil {
		return nil, it.err
	}

	return result, nil
}

func (it *DiskOperationsIterator) TakeAll() ([]*operation.Operation, error) {
	return it.Take(0)
}

func (it *DiskOperationsIterator) Value() *operation.Operation {
	if len(it.items) == 0 {
		panic("calling Value on empty iterator")
	}
	return it.items[0]
}

func (it *DiskOperationsIterator) Error() error {
	return it.err
}

// ListSnapshotSchedules implements compute.DiskServiceClient
func (c *DiskServiceClient) ListSnapshotSchedules(ctx context.Context, in *compute.ListDiskSnapshotSchedulesRequest, opts ...grpc.CallOption) (*compute.ListDiskSnapshotSchedulesResponse, error) {
	conn, err := c.getConn(ctx)
	if err != nil {
		return nil, err
	}
	return compute.NewDiskServiceClient(conn).ListSnapshotSchedules(ctx, in, opts...)
}

type DiskSnapshotSchedulesIterator struct {
	ctx  context.Context
	opts []grpc.CallOption

	err           error
	started       bool
	requestedSize int64
	pageSize      int64

	client  *DiskServiceClient
	request *compute.ListDiskSnapshotSchedulesRequest

	items []*compute.SnapshotSchedule
}

func (c *DiskServiceClient) DiskSnapshotSchedulesIterator(ctx context.Context, req *compute.ListDiskSnapshotSchedulesRequest, opts ...grpc.CallOption) *DiskSnapshotSchedulesIterator {
	var pageSize int64
	const defaultPageSize = 1000
	pageSize = req.PageSize
	if pageSize == 0 {
		pageSize = defaultPageSize
	}
	return &DiskSnapshotSchedulesIterator{
		ctx:      ctx,
		opts:     opts,
		client:   c,
		request:  req,
		pageSize: pageSize,
	}
}

func (it *DiskSnapshotSchedulesIterator) Next() bool {
	if it.err != nil {
		return false
	}
	if len(it.items) > 1 {
		it.items[0] = nil
		it.items = it.items[1:]
		return true
	}
	it.items = nil // consume last item, if any

	if it.started && it.request.PageToken == "" {
		return false
	}
	it.started = true

	if it.requestedSize == 0 || it.requestedSize > it.pageSize {
		it.request.PageSize = it.pageSize
	} else {
		it.request.PageSize = it.requestedSize
	}

	response, err := it.client.ListSnapshotSchedules(it.ctx, it.request, it.opts...)
	it.err = err
	if err != nil {
		return false
	}

	it.items = response.SnapshotSchedules
	it.request.PageToken = response.NextPageToken
	return len(it.items) > 0
}

func (it *DiskSnapshotSchedulesIterator) Take(size int64) ([]*compute.SnapshotSchedule, error) {
	if it.err != nil {
		return nil, it.err
	}

	if size == 0 {
		size = 1 << 32 // something insanely large
	}
	it.requestedSize = size
	defer func() {
		// reset iterator for future calls.
		it.requestedSize = 0
	}()

	var result []*compute.SnapshotSchedule

	for it.requestedSize > 0 && it.Next() {
		it.requestedSize--
		result = append(result, it.Value())
	}

	if it.err != nil {
		return nil, it.err
	}

	return result, nil
}

func (it *DiskSnapshotSchedulesIterator) TakeAll() ([]*compute.SnapshotSchedule, error) {
	return it.Take(0)
}

func (it *DiskSnapshotSchedulesIterator) Value() *compute.SnapshotSchedule {
	if len(it.items) == 0 {
		panic("calling Value on empty iterator")
	}
	return it.items[0]
}

func (it *DiskSnapshotSchedulesIterator) Error() error {
	return it.err
}

// Move implements compute.DiskServiceClient
func (c *DiskServiceClient) Move(ctx context.Context, in *compute.MoveDiskRequest, opts ...grpc.CallOption) (*operation.Operation, error) {
	conn, err := c.getConn(ctx)
	if err != nil {
		return nil, err
	}
	return compute.NewDiskServiceClient(conn).Move(ctx, in, opts...)
}

// Relocate implements compute.DiskServiceClient
func (c *DiskServiceClient) Relocate(ctx context.Context, in *compute.RelocateDiskRequest, opts ...grpc.CallOption) (*operation.Operation, error) {
	conn, err := c.getConn(ctx)
	if err != nil {
		return nil, err
	}
	return compute.NewDiskServiceClient(conn).Relocate(ctx, in, opts...)
}

// Update implements compute.DiskServiceClient
func (c *DiskServiceClient) Update(ctx context.Context, in *compute.UpdateDiskRequest, opts ...grpc.CallOption) (*operation.Operation, error) {
	conn, err := c.getConn(ctx)
	if err != nil {
		return nil, err
	}
	return compute.NewDiskServiceClient(conn).Update(ctx, in, opts...)
}
