// Code generated by sdkgen. DO NOT EDIT.

// nolint
package containerregistry

import (
	"context"

	"google.golang.org/grpc"

	"github.com/yandex-cloud/go-genproto/yandex/cloud/access"
	containerregistry "github.com/yandex-cloud/go-genproto/yandex/cloud/containerregistry/v1"
	"github.com/yandex-cloud/go-genproto/yandex/cloud/operation"
)

//revive:disable

// RegistryServiceClient is a containerregistry.RegistryServiceClient with
// lazy GRPC connection initialization.
type RegistryServiceClient struct {
	getConn func(ctx context.Context) (*grpc.ClientConn, error)
}

// Create implements containerregistry.RegistryServiceClient
func (c *RegistryServiceClient) Create(ctx context.Context, in *containerregistry.CreateRegistryRequest, opts ...grpc.CallOption) (*operation.Operation, error) {
	conn, err := c.getConn(ctx)
	if err != nil {
		return nil, err
	}
	return containerregistry.NewRegistryServiceClient(conn).Create(ctx, in, opts...)
}

// Delete implements containerregistry.RegistryServiceClient
func (c *RegistryServiceClient) Delete(ctx context.Context, in *containerregistry.DeleteRegistryRequest, opts ...grpc.CallOption) (*operation.Operation, error) {
	conn, err := c.getConn(ctx)
	if err != nil {
		return nil, err
	}
	return containerregistry.NewRegistryServiceClient(conn).Delete(ctx, in, opts...)
}

// Get implements containerregistry.RegistryServiceClient
func (c *RegistryServiceClient) Get(ctx context.Context, in *containerregistry.GetRegistryRequest, opts ...grpc.CallOption) (*containerregistry.Registry, error) {
	conn, err := c.getConn(ctx)
	if err != nil {
		return nil, err
	}
	return containerregistry.NewRegistryServiceClient(conn).Get(ctx, in, opts...)
}

// List implements containerregistry.RegistryServiceClient
func (c *RegistryServiceClient) List(ctx context.Context, in *containerregistry.ListRegistriesRequest, opts ...grpc.CallOption) (*containerregistry.ListRegistriesResponse, error) {
	conn, err := c.getConn(ctx)
	if err != nil {
		return nil, err
	}
	return containerregistry.NewRegistryServiceClient(conn).List(ctx, in, opts...)
}

type RegistryIterator struct {
	ctx  context.Context
	opts []grpc.CallOption

	err           error
	started       bool
	requestedSize int64
	pageSize      int64

	client  *RegistryServiceClient
	request *containerregistry.ListRegistriesRequest

	items []*containerregistry.Registry
}

func (c *RegistryServiceClient) RegistryIterator(ctx context.Context, req *containerregistry.ListRegistriesRequest, opts ...grpc.CallOption) *RegistryIterator {
	var pageSize int64
	const defaultPageSize = 1000
	pageSize = req.PageSize
	if pageSize == 0 {
		pageSize = defaultPageSize
	}
	return &RegistryIterator{
		ctx:      ctx,
		opts:     opts,
		client:   c,
		request:  req,
		pageSize: pageSize,
	}
}

func (it *RegistryIterator) Next() bool {
	if it.err != nil {
		return false
	}
	if len(it.items) > 1 {
		it.items[0] = nil
		it.items = it.items[1:]
		return true
	}
	it.items = nil // consume last item, if any

	if it.started && it.request.PageToken == "" {
		return false
	}
	it.started = true

	if it.requestedSize == 0 || it.requestedSize > it.pageSize {
		it.request.PageSize = it.pageSize
	} else {
		it.request.PageSize = it.requestedSize
	}

	response, err := it.client.List(it.ctx, it.request, it.opts...)
	it.err = err
	if err != nil {
		return false
	}

	it.items = response.Registries
	it.request.PageToken = response.NextPageToken
	return len(it.items) > 0
}

func (it *RegistryIterator) Take(size int64) ([]*containerregistry.Registry, error) {
	if it.err != nil {
		return nil, it.err
	}

	if size == 0 {
		size = 1 << 32 // something insanely large
	}
	it.requestedSize = size
	defer func() {
		// reset iterator for future calls.
		it.requestedSize = 0
	}()

	var result []*containerregistry.Registry

	for it.requestedSize > 0 && it.Next() {
		it.requestedSize--
		result = append(result, it.Value())
	}

	if it.err != nil {
		return nil, it.err
	}

	return result, nil
}

func (it *RegistryIterator) TakeAll() ([]*containerregistry.Registry, error) {
	return it.Take(0)
}

func (it *RegistryIterator) Value() *containerregistry.Registry {
	if len(it.items) == 0 {
		panic("calling Value on empty iterator")
	}
	return it.items[0]
}

func (it *RegistryIterator) Error() error {
	return it.err
}

// ListAccessBindings implements containerregistry.RegistryServiceClient
func (c *RegistryServiceClient) ListAccessBindings(ctx context.Context, in *access.ListAccessBindingsRequest, opts ...grpc.CallOption) (*access.ListAccessBindingsResponse, error) {
	conn, err := c.getConn(ctx)
	if err != nil {
		return nil, err
	}
	return containerregistry.NewRegistryServiceClient(conn).ListAccessBindings(ctx, in, opts...)
}

type RegistryAccessBindingsIterator struct {
	ctx  context.Context
	opts []grpc.CallOption

	err           error
	started       bool
	requestedSize int64
	pageSize      int64

	client  *RegistryServiceClient
	request *access.ListAccessBindingsRequest

	items []*access.AccessBinding
}

func (c *RegistryServiceClient) RegistryAccessBindingsIterator(ctx context.Context, req *access.ListAccessBindingsRequest, opts ...grpc.CallOption) *RegistryAccessBindingsIterator {
	var pageSize int64
	const defaultPageSize = 1000
	pageSize = req.PageSize
	if pageSize == 0 {
		pageSize = defaultPageSize
	}
	return &RegistryAccessBindingsIterator{
		ctx:      ctx,
		opts:     opts,
		client:   c,
		request:  req,
		pageSize: pageSize,
	}
}

func (it *RegistryAccessBindingsIterator) Next() bool {
	if it.err != nil {
		return false
	}
	if len(it.items) > 1 {
		it.items[0] = nil
		it.items = it.items[1:]
		return true
	}
	it.items = nil // consume last item, if any

	if it.started && it.request.PageToken == "" {
		return false
	}
	it.started = true

	if it.requestedSize == 0 || it.requestedSize > it.pageSize {
		it.request.PageSize = it.pageSize
	} else {
		it.request.PageSize = it.requestedSize
	}

	response, err := it.client.ListAccessBindings(it.ctx, it.request, it.opts...)
	it.err = err
	if err != nil {
		return false
	}

	it.items = response.AccessBindings
	it.request.PageToken = response.NextPageToken
	return len(it.items) > 0
}

func (it *RegistryAccessBindingsIterator) Take(size int64) ([]*access.AccessBinding, error) {
	if it.err != nil {
		return nil, it.err
	}

	if size == 0 {
		size = 1 << 32 // something insanely large
	}
	it.requestedSize = size
	defer func() {
		// reset iterator for future calls.
		it.requestedSize = 0
	}()

	var result []*access.AccessBinding

	for it.requestedSize > 0 && it.Next() {
		it.requestedSize--
		result = append(result, it.Value())
	}

	if it.err != nil {
		return nil, it.err
	}

	return result, nil
}

func (it *RegistryAccessBindingsIterator) TakeAll() ([]*access.AccessBinding, error) {
	return it.Take(0)
}

func (it *RegistryAccessBindingsIterator) Value() *access.AccessBinding {
	if len(it.items) == 0 {
		panic("calling Value on empty iterator")
	}
	return it.items[0]
}

func (it *RegistryAccessBindingsIterator) Error() error {
	return it.err
}

// ListIpPermission implements containerregistry.RegistryServiceClient
func (c *RegistryServiceClient) ListIpPermission(ctx context.Context, in *containerregistry.ListIpPermissionRequest, opts ...grpc.CallOption) (*containerregistry.ListIpPermissionsResponse, error) {
	conn, err := c.getConn(ctx)
	if err != nil {
		return nil, err
	}
	return containerregistry.NewRegistryServiceClient(conn).ListIpPermission(ctx, in, opts...)
}

type RegistryIpPermissionIterator struct {
	ctx  context.Context
	opts []grpc.CallOption

	err           error
	started       bool
	requestedSize int64
	pageSize      int64

	client  *RegistryServiceClient
	request *containerregistry.ListIpPermissionRequest

	items []*containerregistry.IpPermission
}

func (c *RegistryServiceClient) RegistryIpPermissionIterator(ctx context.Context, req *containerregistry.ListIpPermissionRequest, opts ...grpc.CallOption) *RegistryIpPermissionIterator {
	var pageSize int64
	const defaultPageSize = 1000

	if pageSize == 0 {
		pageSize = defaultPageSize
	}
	return &RegistryIpPermissionIterator{
		ctx:      ctx,
		opts:     opts,
		client:   c,
		request:  req,
		pageSize: pageSize,
	}
}

func (it *RegistryIpPermissionIterator) Next() bool {
	if it.err != nil {
		return false
	}
	if len(it.items) > 1 {
		it.items[0] = nil
		it.items = it.items[1:]
		return true
	}
	it.items = nil // consume last item, if any

	if it.started {
		return false
	}
	it.started = true

	response, err := it.client.ListIpPermission(it.ctx, it.request, it.opts...)
	it.err = err
	if err != nil {
		return false
	}

	it.items = response.Permissions
	return len(it.items) > 0
}

func (it *RegistryIpPermissionIterator) Take(size int64) ([]*containerregistry.IpPermission, error) {
	if it.err != nil {
		return nil, it.err
	}

	if size == 0 {
		size = 1 << 32 // something insanely large
	}
	it.requestedSize = size
	defer func() {
		// reset iterator for future calls.
		it.requestedSize = 0
	}()

	var result []*containerregistry.IpPermission

	for it.requestedSize > 0 && it.Next() {
		it.requestedSize--
		result = append(result, it.Value())
	}

	if it.err != nil {
		return nil, it.err
	}

	return result, nil
}

func (it *RegistryIpPermissionIterator) TakeAll() ([]*containerregistry.IpPermission, error) {
	return it.Take(0)
}

func (it *RegistryIpPermissionIterator) Value() *containerregistry.IpPermission {
	if len(it.items) == 0 {
		panic("calling Value on empty iterator")
	}
	return it.items[0]
}

func (it *RegistryIpPermissionIterator) Error() error {
	return it.err
}

// SetAccessBindings implements containerregistry.RegistryServiceClient
func (c *RegistryServiceClient) SetAccessBindings(ctx context.Context, in *access.SetAccessBindingsRequest, opts ...grpc.CallOption) (*operation.Operation, error) {
	conn, err := c.getConn(ctx)
	if err != nil {
		return nil, err
	}
	return containerregistry.NewRegistryServiceClient(conn).SetAccessBindings(ctx, in, opts...)
}

// SetIpPermission implements containerregistry.RegistryServiceClient
func (c *RegistryServiceClient) SetIpPermission(ctx context.Context, in *containerregistry.SetIpPermissionRequest, opts ...grpc.CallOption) (*operation.Operation, error) {
	conn, err := c.getConn(ctx)
	if err != nil {
		return nil, err
	}
	return containerregistry.NewRegistryServiceClient(conn).SetIpPermission(ctx, in, opts...)
}

// Update implements containerregistry.RegistryServiceClient
func (c *RegistryServiceClient) Update(ctx context.Context, in *containerregistry.UpdateRegistryRequest, opts ...grpc.CallOption) (*operation.Operation, error) {
	conn, err := c.getConn(ctx)
	if err != nil {
		return nil, err
	}
	return containerregistry.NewRegistryServiceClient(conn).Update(ctx, in, opts...)
}

// UpdateAccessBindings implements containerregistry.RegistryServiceClient
func (c *RegistryServiceClient) UpdateAccessBindings(ctx context.Context, in *access.UpdateAccessBindingsRequest, opts ...grpc.CallOption) (*operation.Operation, error) {
	conn, err := c.getConn(ctx)
	if err != nil {
		return nil, err
	}
	return containerregistry.NewRegistryServiceClient(conn).UpdateAccessBindings(ctx, in, opts...)
}

// UpdateIpPermission implements containerregistry.RegistryServiceClient
func (c *RegistryServiceClient) UpdateIpPermission(ctx context.Context, in *containerregistry.UpdateIpPermissionRequest, opts ...grpc.CallOption) (*operation.Operation, error) {
	conn, err := c.getConn(ctx)
	if err != nil {
		return nil, err
	}
	return containerregistry.NewRegistryServiceClient(conn).UpdateIpPermission(ctx, in, opts...)
}
