// Code generated by sdkgen. DO NOT EDIT.

// nolint
package containers

import (
	"context"

	"google.golang.org/grpc"

	"github.com/yandex-cloud/go-genproto/yandex/cloud/access"
	"github.com/yandex-cloud/go-genproto/yandex/cloud/operation"
	containers "github.com/yandex-cloud/go-genproto/yandex/cloud/serverless/containers/v1"
)

//revive:disable

// ContainerServiceClient is a containers.ContainerServiceClient with
// lazy GRPC connection initialization.
type ContainerServiceClient struct {
	getConn func(ctx context.Context) (*grpc.ClientConn, error)
}

// Create implements containers.ContainerServiceClient
func (c *ContainerServiceClient) Create(ctx context.Context, in *containers.CreateContainerRequest, opts ...grpc.CallOption) (*operation.Operation, error) {
	conn, err := c.getConn(ctx)
	if err != nil {
		return nil, err
	}
	return containers.NewContainerServiceClient(conn).Create(ctx, in, opts...)
}

// Delete implements containers.ContainerServiceClient
func (c *ContainerServiceClient) Delete(ctx context.Context, in *containers.DeleteContainerRequest, opts ...grpc.CallOption) (*operation.Operation, error) {
	conn, err := c.getConn(ctx)
	if err != nil {
		return nil, err
	}
	return containers.NewContainerServiceClient(conn).Delete(ctx, in, opts...)
}

// DeployRevision implements containers.ContainerServiceClient
func (c *ContainerServiceClient) DeployRevision(ctx context.Context, in *containers.DeployContainerRevisionRequest, opts ...grpc.CallOption) (*operation.Operation, error) {
	conn, err := c.getConn(ctx)
	if err != nil {
		return nil, err
	}
	return containers.NewContainerServiceClient(conn).DeployRevision(ctx, in, opts...)
}

// Get implements containers.ContainerServiceClient
func (c *ContainerServiceClient) Get(ctx context.Context, in *containers.GetContainerRequest, opts ...grpc.CallOption) (*containers.Container, error) {
	conn, err := c.getConn(ctx)
	if err != nil {
		return nil, err
	}
	return containers.NewContainerServiceClient(conn).Get(ctx, in, opts...)
}

// GetRevision implements containers.ContainerServiceClient
func (c *ContainerServiceClient) GetRevision(ctx context.Context, in *containers.GetContainerRevisionRequest, opts ...grpc.CallOption) (*containers.Revision, error) {
	conn, err := c.getConn(ctx)
	if err != nil {
		return nil, err
	}
	return containers.NewContainerServiceClient(conn).GetRevision(ctx, in, opts...)
}

// List implements containers.ContainerServiceClient
func (c *ContainerServiceClient) List(ctx context.Context, in *containers.ListContainersRequest, opts ...grpc.CallOption) (*containers.ListContainersResponse, error) {
	conn, err := c.getConn(ctx)
	if err != nil {
		return nil, err
	}
	return containers.NewContainerServiceClient(conn).List(ctx, in, opts...)
}

type ContainerIterator struct {
	ctx  context.Context
	opts []grpc.CallOption

	err           error
	started       bool
	requestedSize int64
	pageSize      int64

	client  *ContainerServiceClient
	request *containers.ListContainersRequest

	items []*containers.Container
}

func (c *ContainerServiceClient) ContainerIterator(ctx context.Context, req *containers.ListContainersRequest, opts ...grpc.CallOption) *ContainerIterator {
	var pageSize int64
	const defaultPageSize = 1000
	pageSize = req.PageSize
	if pageSize == 0 {
		pageSize = defaultPageSize
	}
	return &ContainerIterator{
		ctx:      ctx,
		opts:     opts,
		client:   c,
		request:  req,
		pageSize: pageSize,
	}
}

func (it *ContainerIterator) Next() bool {
	if it.err != nil {
		return false
	}
	if len(it.items) > 1 {
		it.items[0] = nil
		it.items = it.items[1:]
		return true
	}
	it.items = nil // consume last item, if any

	if it.started && it.request.PageToken == "" {
		return false
	}
	it.started = true

	if it.requestedSize == 0 || it.requestedSize > it.pageSize {
		it.request.PageSize = it.pageSize
	} else {
		it.request.PageSize = it.requestedSize
	}

	response, err := it.client.List(it.ctx, it.request, it.opts...)
	it.err = err
	if err != nil {
		return false
	}

	it.items = response.Containers
	it.request.PageToken = response.NextPageToken
	return len(it.items) > 0
}

func (it *ContainerIterator) Take(size int64) ([]*containers.Container, error) {
	if it.err != nil {
		return nil, it.err
	}

	if size == 0 {
		size = 1 << 32 // something insanely large
	}
	it.requestedSize = size
	defer func() {
		// reset iterator for future calls.
		it.requestedSize = 0
	}()

	var result []*containers.Container

	for it.requestedSize > 0 && it.Next() {
		it.requestedSize--
		result = append(result, it.Value())
	}

	if it.err != nil {
		return nil, it.err
	}

	return result, nil
}

func (it *ContainerIterator) TakeAll() ([]*containers.Container, error) {
	return it.Take(0)
}

func (it *ContainerIterator) Value() *containers.Container {
	if len(it.items) == 0 {
		panic("calling Value on empty iterator")
	}
	return it.items[0]
}

func (it *ContainerIterator) Error() error {
	return it.err
}

// ListAccessBindings implements containers.ContainerServiceClient
func (c *ContainerServiceClient) ListAccessBindings(ctx context.Context, in *access.ListAccessBindingsRequest, opts ...grpc.CallOption) (*access.ListAccessBindingsResponse, error) {
	conn, err := c.getConn(ctx)
	if err != nil {
		return nil, err
	}
	return containers.NewContainerServiceClient(conn).ListAccessBindings(ctx, in, opts...)
}

type ContainerAccessBindingsIterator struct {
	ctx  context.Context
	opts []grpc.CallOption

	err           error
	started       bool
	requestedSize int64
	pageSize      int64

	client  *ContainerServiceClient
	request *access.ListAccessBindingsRequest

	items []*access.AccessBinding
}

func (c *ContainerServiceClient) ContainerAccessBindingsIterator(ctx context.Context, req *access.ListAccessBindingsRequest, opts ...grpc.CallOption) *ContainerAccessBindingsIterator {
	var pageSize int64
	const defaultPageSize = 1000
	pageSize = req.PageSize
	if pageSize == 0 {
		pageSize = defaultPageSize
	}
	return &ContainerAccessBindingsIterator{
		ctx:      ctx,
		opts:     opts,
		client:   c,
		request:  req,
		pageSize: pageSize,
	}
}

func (it *ContainerAccessBindingsIterator) Next() bool {
	if it.err != nil {
		return false
	}
	if len(it.items) > 1 {
		it.items[0] = nil
		it.items = it.items[1:]
		return true
	}
	it.items = nil // consume last item, if any

	if it.started && it.request.PageToken == "" {
		return false
	}
	it.started = true

	if it.requestedSize == 0 || it.requestedSize > it.pageSize {
		it.request.PageSize = it.pageSize
	} else {
		it.request.PageSize = it.requestedSize
	}

	response, err := it.client.ListAccessBindings(it.ctx, it.request, it.opts...)
	it.err = err
	if err != nil {
		return false
	}

	it.items = response.AccessBindings
	it.request.PageToken = response.NextPageToken
	return len(it.items) > 0
}

func (it *ContainerAccessBindingsIterator) Take(size int64) ([]*access.AccessBinding, error) {
	if it.err != nil {
		return nil, it.err
	}

	if size == 0 {
		size = 1 << 32 // something insanely large
	}
	it.requestedSize = size
	defer func() {
		// reset iterator for future calls.
		it.requestedSize = 0
	}()

	var result []*access.AccessBinding

	for it.requestedSize > 0 && it.Next() {
		it.requestedSize--
		result = append(result, it.Value())
	}

	if it.err != nil {
		return nil, it.err
	}

	return result, nil
}

func (it *ContainerAccessBindingsIterator) TakeAll() ([]*access.AccessBinding, error) {
	return it.Take(0)
}

func (it *ContainerAccessBindingsIterator) Value() *access.AccessBinding {
	if len(it.items) == 0 {
		panic("calling Value on empty iterator")
	}
	return it.items[0]
}

func (it *ContainerAccessBindingsIterator) Error() error {
	return it.err
}

// ListOperations implements containers.ContainerServiceClient
func (c *ContainerServiceClient) ListOperations(ctx context.Context, in *containers.ListContainerOperationsRequest, opts ...grpc.CallOption) (*containers.ListContainerOperationsResponse, error) {
	conn, err := c.getConn(ctx)
	if err != nil {
		return nil, err
	}
	return containers.NewContainerServiceClient(conn).ListOperations(ctx, in, opts...)
}

type ContainerOperationsIterator struct {
	ctx  context.Context
	opts []grpc.CallOption

	err           error
	started       bool
	requestedSize int64
	pageSize      int64

	client  *ContainerServiceClient
	request *containers.ListContainerOperationsRequest

	items []*operation.Operation
}

func (c *ContainerServiceClient) ContainerOperationsIterator(ctx context.Context, req *containers.ListContainerOperationsRequest, opts ...grpc.CallOption) *ContainerOperationsIterator {
	var pageSize int64
	const defaultPageSize = 1000
	pageSize = req.PageSize
	if pageSize == 0 {
		pageSize = defaultPageSize
	}
	return &ContainerOperationsIterator{
		ctx:      ctx,
		opts:     opts,
		client:   c,
		request:  req,
		pageSize: pageSize,
	}
}

func (it *ContainerOperationsIterator) Next() bool {
	if it.err != nil {
		return false
	}
	if len(it.items) > 1 {
		it.items[0] = nil
		it.items = it.items[1:]
		return true
	}
	it.items = nil // consume last item, if any

	if it.started && it.request.PageToken == "" {
		return false
	}
	it.started = true

	if it.requestedSize == 0 || it.requestedSize > it.pageSize {
		it.request.PageSize = it.pageSize
	} else {
		it.request.PageSize = it.requestedSize
	}

	response, err := it.client.ListOperations(it.ctx, it.request, it.opts...)
	it.err = err
	if err != nil {
		return false
	}

	it.items = response.Operations
	it.request.PageToken = response.NextPageToken
	return len(it.items) > 0
}

func (it *ContainerOperationsIterator) Take(size int64) ([]*operation.Operation, error) {
	if it.err != nil {
		return nil, it.err
	}

	if size == 0 {
		size = 1 << 32 // something insanely large
	}
	it.requestedSize = size
	defer func() {
		// reset iterator for future calls.
		it.requestedSize = 0
	}()

	var result []*operation.Operation

	for it.requestedSize > 0 && it.Next() {
		it.requestedSize--
		result = append(result, it.Value())
	}

	if it.err != nil {
		return nil, it.err
	}

	return result, nil
}

func (it *ContainerOperationsIterator) TakeAll() ([]*operation.Operation, error) {
	return it.Take(0)
}

func (it *ContainerOperationsIterator) Value() *operation.Operation {
	if len(it.items) == 0 {
		panic("calling Value on empty iterator")
	}
	return it.items[0]
}

func (it *ContainerOperationsIterator) Error() error {
	return it.err
}

// ListRevisions implements containers.ContainerServiceClient
func (c *ContainerServiceClient) ListRevisions(ctx context.Context, in *containers.ListContainersRevisionsRequest, opts ...grpc.CallOption) (*containers.ListContainersRevisionsResponse, error) {
	conn, err := c.getConn(ctx)
	if err != nil {
		return nil, err
	}
	return containers.NewContainerServiceClient(conn).ListRevisions(ctx, in, opts...)
}

type ContainerRevisionsIterator struct {
	ctx  context.Context
	opts []grpc.CallOption

	err           error
	started       bool
	requestedSize int64
	pageSize      int64

	client  *ContainerServiceClient
	request *containers.ListContainersRevisionsRequest

	items []*containers.Revision
}

func (c *ContainerServiceClient) ContainerRevisionsIterator(ctx context.Context, req *containers.ListContainersRevisionsRequest, opts ...grpc.CallOption) *ContainerRevisionsIterator {
	var pageSize int64
	const defaultPageSize = 1000
	pageSize = req.PageSize
	if pageSize == 0 {
		pageSize = defaultPageSize
	}
	return &ContainerRevisionsIterator{
		ctx:      ctx,
		opts:     opts,
		client:   c,
		request:  req,
		pageSize: pageSize,
	}
}

func (it *ContainerRevisionsIterator) Next() bool {
	if it.err != nil {
		return false
	}
	if len(it.items) > 1 {
		it.items[0] = nil
		it.items = it.items[1:]
		return true
	}
	it.items = nil // consume last item, if any

	if it.started && it.request.PageToken == "" {
		return false
	}
	it.started = true

	if it.requestedSize == 0 || it.requestedSize > it.pageSize {
		it.request.PageSize = it.pageSize
	} else {
		it.request.PageSize = it.requestedSize
	}

	response, err := it.client.ListRevisions(it.ctx, it.request, it.opts...)
	it.err = err
	if err != nil {
		return false
	}

	it.items = response.Revisions
	it.request.PageToken = response.NextPageToken
	return len(it.items) > 0
}

func (it *ContainerRevisionsIterator) Take(size int64) ([]*containers.Revision, error) {
	if it.err != nil {
		return nil, it.err
	}

	if size == 0 {
		size = 1 << 32 // something insanely large
	}
	it.requestedSize = size
	defer func() {
		// reset iterator for future calls.
		it.requestedSize = 0
	}()

	var result []*containers.Revision

	for it.requestedSize > 0 && it.Next() {
		it.requestedSize--
		result = append(result, it.Value())
	}

	if it.err != nil {
		return nil, it.err
	}

	return result, nil
}

func (it *ContainerRevisionsIterator) TakeAll() ([]*containers.Revision, error) {
	return it.Take(0)
}

func (it *ContainerRevisionsIterator) Value() *containers.Revision {
	if len(it.items) == 0 {
		panic("calling Value on empty iterator")
	}
	return it.items[0]
}

func (it *ContainerRevisionsIterator) Error() error {
	return it.err
}

// Rollback implements containers.ContainerServiceClient
func (c *ContainerServiceClient) Rollback(ctx context.Context, in *containers.RollbackContainerRequest, opts ...grpc.CallOption) (*operation.Operation, error) {
	conn, err := c.getConn(ctx)
	if err != nil {
		return nil, err
	}
	return containers.NewContainerServiceClient(conn).Rollback(ctx, in, opts...)
}

// SetAccessBindings implements containers.ContainerServiceClient
func (c *ContainerServiceClient) SetAccessBindings(ctx context.Context, in *access.SetAccessBindingsRequest, opts ...grpc.CallOption) (*operation.Operation, error) {
	conn, err := c.getConn(ctx)
	if err != nil {
		return nil, err
	}
	return containers.NewContainerServiceClient(conn).SetAccessBindings(ctx, in, opts...)
}

// Update implements containers.ContainerServiceClient
func (c *ContainerServiceClient) Update(ctx context.Context, in *containers.UpdateContainerRequest, opts ...grpc.CallOption) (*operation.Operation, error) {
	conn, err := c.getConn(ctx)
	if err != nil {
		return nil, err
	}
	return containers.NewContainerServiceClient(conn).Update(ctx, in, opts...)
}

// UpdateAccessBindings implements containers.ContainerServiceClient
func (c *ContainerServiceClient) UpdateAccessBindings(ctx context.Context, in *access.UpdateAccessBindingsRequest, opts ...grpc.CallOption) (*operation.Operation, error) {
	conn, err := c.getConn(ctx)
	if err != nil {
		return nil, err
	}
	return containers.NewContainerServiceClient(conn).UpdateAccessBindings(ctx, in, opts...)
}
