// Code generated by sdkgen. DO NOT EDIT.

// nolint
package triggers

import (
	"context"

	"google.golang.org/grpc"

	"github.com/yandex-cloud/go-genproto/yandex/cloud/operation"
	triggers "github.com/yandex-cloud/go-genproto/yandex/cloud/serverless/triggers/v1"
)

//revive:disable

// TriggerServiceClient is a triggers.TriggerServiceClient with
// lazy GRPC connection initialization.
type TriggerServiceClient struct {
	getConn func(ctx context.Context) (*grpc.ClientConn, error)
}

// Create implements triggers.TriggerServiceClient
func (c *TriggerServiceClient) Create(ctx context.Context, in *triggers.CreateTriggerRequest, opts ...grpc.CallOption) (*operation.Operation, error) {
	conn, err := c.getConn(ctx)
	if err != nil {
		return nil, err
	}
	return triggers.NewTriggerServiceClient(conn).Create(ctx, in, opts...)
}

// Delete implements triggers.TriggerServiceClient
func (c *TriggerServiceClient) Delete(ctx context.Context, in *triggers.DeleteTriggerRequest, opts ...grpc.CallOption) (*operation.Operation, error) {
	conn, err := c.getConn(ctx)
	if err != nil {
		return nil, err
	}
	return triggers.NewTriggerServiceClient(conn).Delete(ctx, in, opts...)
}

// Get implements triggers.TriggerServiceClient
func (c *TriggerServiceClient) Get(ctx context.Context, in *triggers.GetTriggerRequest, opts ...grpc.CallOption) (*triggers.Trigger, error) {
	conn, err := c.getConn(ctx)
	if err != nil {
		return nil, err
	}
	return triggers.NewTriggerServiceClient(conn).Get(ctx, in, opts...)
}

// List implements triggers.TriggerServiceClient
func (c *TriggerServiceClient) List(ctx context.Context, in *triggers.ListTriggersRequest, opts ...grpc.CallOption) (*triggers.ListTriggersResponse, error) {
	conn, err := c.getConn(ctx)
	if err != nil {
		return nil, err
	}
	return triggers.NewTriggerServiceClient(conn).List(ctx, in, opts...)
}

type TriggerIterator struct {
	ctx  context.Context
	opts []grpc.CallOption

	err           error
	started       bool
	requestedSize int64
	pageSize      int64

	client  *TriggerServiceClient
	request *triggers.ListTriggersRequest

	items []*triggers.Trigger
}

func (c *TriggerServiceClient) TriggerIterator(ctx context.Context, req *triggers.ListTriggersRequest, opts ...grpc.CallOption) *TriggerIterator {
	var pageSize int64
	const defaultPageSize = 1000
	pageSize = req.PageSize
	if pageSize == 0 {
		pageSize = defaultPageSize
	}
	return &TriggerIterator{
		ctx:      ctx,
		opts:     opts,
		client:   c,
		request:  req,
		pageSize: pageSize,
	}
}

func (it *TriggerIterator) Next() bool {
	if it.err != nil {
		return false
	}
	if len(it.items) > 1 {
		it.items[0] = nil
		it.items = it.items[1:]
		return true
	}
	it.items = nil // consume last item, if any

	if it.started && it.request.PageToken == "" {
		return false
	}
	it.started = true

	if it.requestedSize == 0 || it.requestedSize > it.pageSize {
		it.request.PageSize = it.pageSize
	} else {
		it.request.PageSize = it.requestedSize
	}

	response, err := it.client.List(it.ctx, it.request, it.opts...)
	it.err = err
	if err != nil {
		return false
	}

	it.items = response.Triggers
	it.request.PageToken = response.NextPageToken
	return len(it.items) > 0
}

func (it *TriggerIterator) Take(size int64) ([]*triggers.Trigger, error) {
	if it.err != nil {
		return nil, it.err
	}

	if size == 0 {
		size = 1 << 32 // something insanely large
	}
	it.requestedSize = size
	defer func() {
		// reset iterator for future calls.
		it.requestedSize = 0
	}()

	var result []*triggers.Trigger

	for it.requestedSize > 0 && it.Next() {
		it.requestedSize--
		result = append(result, it.Value())
	}

	if it.err != nil {
		return nil, it.err
	}

	return result, nil
}

func (it *TriggerIterator) TakeAll() ([]*triggers.Trigger, error) {
	return it.Take(0)
}

func (it *TriggerIterator) Value() *triggers.Trigger {
	if len(it.items) == 0 {
		panic("calling Value on empty iterator")
	}
	return it.items[0]
}

func (it *TriggerIterator) Error() error {
	return it.err
}

// ListOperations implements triggers.TriggerServiceClient
func (c *TriggerServiceClient) ListOperations(ctx context.Context, in *triggers.ListTriggerOperationsRequest, opts ...grpc.CallOption) (*triggers.ListTriggerOperationsResponse, error) {
	conn, err := c.getConn(ctx)
	if err != nil {
		return nil, err
	}
	return triggers.NewTriggerServiceClient(conn).ListOperations(ctx, in, opts...)
}

type TriggerOperationsIterator struct {
	ctx  context.Context
	opts []grpc.CallOption

	err           error
	started       bool
	requestedSize int64
	pageSize      int64

	client  *TriggerServiceClient
	request *triggers.ListTriggerOperationsRequest

	items []*operation.Operation
}

func (c *TriggerServiceClient) TriggerOperationsIterator(ctx context.Context, req *triggers.ListTriggerOperationsRequest, opts ...grpc.CallOption) *TriggerOperationsIterator {
	var pageSize int64
	const defaultPageSize = 1000
	pageSize = req.PageSize
	if pageSize == 0 {
		pageSize = defaultPageSize
	}
	return &TriggerOperationsIterator{
		ctx:      ctx,
		opts:     opts,
		client:   c,
		request:  req,
		pageSize: pageSize,
	}
}

func (it *TriggerOperationsIterator) Next() bool {
	if it.err != nil {
		return false
	}
	if len(it.items) > 1 {
		it.items[0] = nil
		it.items = it.items[1:]
		return true
	}
	it.items = nil // consume last item, if any

	if it.started && it.request.PageToken == "" {
		return false
	}
	it.started = true

	if it.requestedSize == 0 || it.requestedSize > it.pageSize {
		it.request.PageSize = it.pageSize
	} else {
		it.request.PageSize = it.requestedSize
	}

	response, err := it.client.ListOperations(it.ctx, it.request, it.opts...)
	it.err = err
	if err != nil {
		return false
	}

	it.items = response.Operations
	it.request.PageToken = response.NextPageToken
	return len(it.items) > 0
}

func (it *TriggerOperationsIterator) Take(size int64) ([]*operation.Operation, error) {
	if it.err != nil {
		return nil, it.err
	}

	if size == 0 {
		size = 1 << 32 // something insanely large
	}
	it.requestedSize = size
	defer func() {
		// reset iterator for future calls.
		it.requestedSize = 0
	}()

	var result []*operation.Operation

	for it.requestedSize > 0 && it.Next() {
		it.requestedSize--
		result = append(result, it.Value())
	}

	if it.err != nil {
		return nil, it.err
	}

	return result, nil
}

func (it *TriggerOperationsIterator) TakeAll() ([]*operation.Operation, error) {
	return it.Take(0)
}

func (it *TriggerOperationsIterator) Value() *operation.Operation {
	if len(it.items) == 0 {
		panic("calling Value on empty iterator")
	}
	return it.items[0]
}

func (it *TriggerOperationsIterator) Error() error {
	return it.err
}

// Pause implements triggers.TriggerServiceClient
func (c *TriggerServiceClient) Pause(ctx context.Context, in *triggers.PauseTriggerRequest, opts ...grpc.CallOption) (*operation.Operation, error) {
	conn, err := c.getConn(ctx)
	if err != nil {
		return nil, err
	}
	return triggers.NewTriggerServiceClient(conn).Pause(ctx, in, opts...)
}

// Resume implements triggers.TriggerServiceClient
func (c *TriggerServiceClient) Resume(ctx context.Context, in *triggers.ResumeTriggerRequest, opts ...grpc.CallOption) (*operation.Operation, error) {
	conn, err := c.getConn(ctx)
	if err != nil {
		return nil, err
	}
	return triggers.NewTriggerServiceClient(conn).Resume(ctx, in, opts...)
}

// Update implements triggers.TriggerServiceClient
func (c *TriggerServiceClient) Update(ctx context.Context, in *triggers.UpdateTriggerRequest, opts ...grpc.CallOption) (*operation.Operation, error) {
	conn, err := c.getConn(ctx)
	if err != nil {
		return nil, err
	}
	return triggers.NewTriggerServiceClient(conn).Update(ctx, in, opts...)
}
