// Code generated by sdkgen. DO NOT EDIT.

// nolint
package vpc

import (
	"context"

	"google.golang.org/grpc"

	"github.com/yandex-cloud/go-genproto/yandex/cloud/operation"
	vpc "github.com/yandex-cloud/go-genproto/yandex/cloud/vpc/v1"
)

//revive:disable

// GatewayServiceClient is a vpc.GatewayServiceClient with
// lazy GRPC connection initialization.
type GatewayServiceClient struct {
	getConn func(ctx context.Context) (*grpc.ClientConn, error)
}

// Create implements vpc.GatewayServiceClient
func (c *GatewayServiceClient) Create(ctx context.Context, in *vpc.CreateGatewayRequest, opts ...grpc.CallOption) (*operation.Operation, error) {
	conn, err := c.getConn(ctx)
	if err != nil {
		return nil, err
	}
	return vpc.NewGatewayServiceClient(conn).Create(ctx, in, opts...)
}

// Delete implements vpc.GatewayServiceClient
func (c *GatewayServiceClient) Delete(ctx context.Context, in *vpc.DeleteGatewayRequest, opts ...grpc.CallOption) (*operation.Operation, error) {
	conn, err := c.getConn(ctx)
	if err != nil {
		return nil, err
	}
	return vpc.NewGatewayServiceClient(conn).Delete(ctx, in, opts...)
}

// Get implements vpc.GatewayServiceClient
func (c *GatewayServiceClient) Get(ctx context.Context, in *vpc.GetGatewayRequest, opts ...grpc.CallOption) (*vpc.Gateway, error) {
	conn, err := c.getConn(ctx)
	if err != nil {
		return nil, err
	}
	return vpc.NewGatewayServiceClient(conn).Get(ctx, in, opts...)
}

// List implements vpc.GatewayServiceClient
func (c *GatewayServiceClient) List(ctx context.Context, in *vpc.ListGatewaysRequest, opts ...grpc.CallOption) (*vpc.ListGatewaysResponse, error) {
	conn, err := c.getConn(ctx)
	if err != nil {
		return nil, err
	}
	return vpc.NewGatewayServiceClient(conn).List(ctx, in, opts...)
}

type GatewayIterator struct {
	ctx  context.Context
	opts []grpc.CallOption

	err           error
	started       bool
	requestedSize int64
	pageSize      int64

	client  *GatewayServiceClient
	request *vpc.ListGatewaysRequest

	items []*vpc.Gateway
}

func (c *GatewayServiceClient) GatewayIterator(ctx context.Context, req *vpc.ListGatewaysRequest, opts ...grpc.CallOption) *GatewayIterator {
	var pageSize int64
	const defaultPageSize = 1000
	pageSize = req.PageSize
	if pageSize == 0 {
		pageSize = defaultPageSize
	}
	return &GatewayIterator{
		ctx:      ctx,
		opts:     opts,
		client:   c,
		request:  req,
		pageSize: pageSize,
	}
}

func (it *GatewayIterator) Next() bool {
	if it.err != nil {
		return false
	}
	if len(it.items) > 1 {
		it.items[0] = nil
		it.items = it.items[1:]
		return true
	}
	it.items = nil // consume last item, if any

	if it.started && it.request.PageToken == "" {
		return false
	}
	it.started = true

	if it.requestedSize == 0 || it.requestedSize > it.pageSize {
		it.request.PageSize = it.pageSize
	} else {
		it.request.PageSize = it.requestedSize
	}

	response, err := it.client.List(it.ctx, it.request, it.opts...)
	it.err = err
	if err != nil {
		return false
	}

	it.items = response.Gateways
	it.request.PageToken = response.NextPageToken
	return len(it.items) > 0
}

func (it *GatewayIterator) Take(size int64) ([]*vpc.Gateway, error) {
	if it.err != nil {
		return nil, it.err
	}

	if size == 0 {
		size = 1 << 32 // something insanely large
	}
	it.requestedSize = size
	defer func() {
		// reset iterator for future calls.
		it.requestedSize = 0
	}()

	var result []*vpc.Gateway

	for it.requestedSize > 0 && it.Next() {
		it.requestedSize--
		result = append(result, it.Value())
	}

	if it.err != nil {
		return nil, it.err
	}

	return result, nil
}

func (it *GatewayIterator) TakeAll() ([]*vpc.Gateway, error) {
	return it.Take(0)
}

func (it *GatewayIterator) Value() *vpc.Gateway {
	if len(it.items) == 0 {
		panic("calling Value on empty iterator")
	}
	return it.items[0]
}

func (it *GatewayIterator) Error() error {
	return it.err
}

// ListOperations implements vpc.GatewayServiceClient
func (c *GatewayServiceClient) ListOperations(ctx context.Context, in *vpc.ListGatewayOperationsRequest, opts ...grpc.CallOption) (*vpc.ListGatewayOperationsResponse, error) {
	conn, err := c.getConn(ctx)
	if err != nil {
		return nil, err
	}
	return vpc.NewGatewayServiceClient(conn).ListOperations(ctx, in, opts...)
}

type GatewayOperationsIterator struct {
	ctx  context.Context
	opts []grpc.CallOption

	err           error
	started       bool
	requestedSize int64
	pageSize      int64

	client  *GatewayServiceClient
	request *vpc.ListGatewayOperationsRequest

	items []*operation.Operation
}

func (c *GatewayServiceClient) GatewayOperationsIterator(ctx context.Context, req *vpc.ListGatewayOperationsRequest, opts ...grpc.CallOption) *GatewayOperationsIterator {
	var pageSize int64
	const defaultPageSize = 1000
	pageSize = req.PageSize
	if pageSize == 0 {
		pageSize = defaultPageSize
	}
	return &GatewayOperationsIterator{
		ctx:      ctx,
		opts:     opts,
		client:   c,
		request:  req,
		pageSize: pageSize,
	}
}

func (it *GatewayOperationsIterator) Next() bool {
	if it.err != nil {
		return false
	}
	if len(it.items) > 1 {
		it.items[0] = nil
		it.items = it.items[1:]
		return true
	}
	it.items = nil // consume last item, if any

	if it.started && it.request.PageToken == "" {
		return false
	}
	it.started = true

	if it.requestedSize == 0 || it.requestedSize > it.pageSize {
		it.request.PageSize = it.pageSize
	} else {
		it.request.PageSize = it.requestedSize
	}

	response, err := it.client.ListOperations(it.ctx, it.request, it.opts...)
	it.err = err
	if err != nil {
		return false
	}

	it.items = response.Operations
	it.request.PageToken = response.NextPageToken
	return len(it.items) > 0
}

func (it *GatewayOperationsIterator) Take(size int64) ([]*operation.Operation, error) {
	if it.err != nil {
		return nil, it.err
	}

	if size == 0 {
		size = 1 << 32 // something insanely large
	}
	it.requestedSize = size
	defer func() {
		// reset iterator for future calls.
		it.requestedSize = 0
	}()

	var result []*operation.Operation

	for it.requestedSize > 0 && it.Next() {
		it.requestedSize--
		result = append(result, it.Value())
	}

	if it.err != nil {
		return nil, it.err
	}

	return result, nil
}

func (it *GatewayOperationsIterator) TakeAll() ([]*operation.Operation, error) {
	return it.Take(0)
}

func (it *GatewayOperationsIterator) Value() *operation.Operation {
	if len(it.items) == 0 {
		panic("calling Value on empty iterator")
	}
	return it.items[0]
}

func (it *GatewayOperationsIterator) Error() error {
	return it.err
}

// Move implements vpc.GatewayServiceClient
func (c *GatewayServiceClient) Move(ctx context.Context, in *vpc.MoveGatewayRequest, opts ...grpc.CallOption) (*operation.Operation, error) {
	conn, err := c.getConn(ctx)
	if err != nil {
		return nil, err
	}
	return vpc.NewGatewayServiceClient(conn).Move(ctx, in, opts...)
}

// Update implements vpc.GatewayServiceClient
func (c *GatewayServiceClient) Update(ctx context.Context, in *vpc.UpdateGatewayRequest, opts ...grpc.CallOption) (*operation.Operation, error) {
	conn, err := c.getConn(ctx)
	if err != nil {
		return nil, err
	}
	return vpc.NewGatewayServiceClient(conn).Update(ctx, in, opts...)
}
